/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.sso;

import java.io.File;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.opensaml.security.x509.X509Support;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.security.saml2.Saml2RelyingPartyProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.io.FileSystemResource;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.saml2.core.Saml2X509Credential;
import org.springframework.security.saml2.provider.service.registration.InMemoryRelyingPartyRegistrationRepository;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrations;
import org.springframework.security.saml2.provider.service.registration.Saml2MessageBinding;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;

@Configuration
@EnableWebSecurity(debug=true)
public class SecurityConfiguration {
    @Autowired
    private AuthenticationSuccessHandler authSuccessHandler;
    @Autowired
    private Environment env;

    @Bean
    SecurityFilterChain securityFilterChain(HttpSecurity http) throws Exception {
        http.authorizeHttpRequests(authorize -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.requestMatchers(new String[]{"/error"})).permitAll().anyRequest()).authenticated()).csrf(csrf -> csrf.disable()).saml2Login(saml2 -> saml2.loginProcessingUrl("/saml/SSO").successHandler(this.authSuccessHandler)).saml2Logout(saml2 -> saml2.logoutRequest(request -> request.logoutUrl("/saml/logout"))).saml2Logout(saml2 -> saml2.logoutResponse(response -> response.logoutUrl("/saml/SingleLogout"))).saml2Metadata(saml2 -> saml2.metadataUrl("/saml/metadata"));
        return (SecurityFilterChain)http.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Bean
    protected InMemoryRelyingPartyRegistrationRepository relyingPartyRegistrations(Saml2RelyingPartyProperties properties) throws Exception {
        String azureCertificate = this.env.getProperty("gescon.saml.certificate");
        InputStream inputStream = new FileSystemResource(azureCertificate).getInputStream();
        File verificationKey = File.createTempFile("azureCert", ".cer");
        try {
            FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)verificationKey);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        Saml2RelyingPartyProperties.Registration registration = (Saml2RelyingPartyProperties.Registration)properties.getRegistration().values().iterator().next();
        X509Certificate certificate = X509Support.decodeCertificate((File)verificationKey);
        Saml2X509Credential credential = Saml2X509Credential.verification((X509Certificate)certificate);
        List registrationRepo = RelyingPartyRegistrations.collectionFromMetadataLocation((String)registration.getAssertingparty().getMetadataUri()).stream().map(builder -> builder.registrationId(UUID.randomUUID().toString()).entityId(registration.getEntityId()).assertionConsumerServiceLocation(registration.getAcs().getLocation()).singleLogoutServiceLocation(registration.getSinglelogout().getUrl()).singleLogoutServiceResponseLocation(registration.getSinglelogout().getResponseUrl()).assertingPartyDetails(party -> party.singleSignOnServiceBinding(Saml2MessageBinding.POST).wantAuthnRequestsSigned(false).verificationX509Credentials(c -> c.add(credential))).build()).collect(Collectors.toList());
        return new InMemoryRelyingPartyRegistrationRepository(registrationRepo);
    }
}

