/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.sso;

import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import jakarta.annotation.PostConstruct;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.security.core.Authentication;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticatedPrincipal;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationSuccessHandler;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.netty.http.client.HttpClient;

@Component
public class Saml2AuthenticationSuccessHandlerImpl
extends SimpleUrlAuthenticationSuccessHandler {
    private static Logger LOG = LoggerFactory.getLogger(Saml2AuthenticationSuccessHandlerImpl.class);
    WebClient webClient;
    @Autowired
    private Environment env;

    @PostConstruct
    public void init() throws SSLException {
        this.logger.debug((Object)"Inicializando Saml2AuthenticationSuccessHandlerImpl...");
        SslContext sslContext = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
        HttpClient httpClient = HttpClient.create().secure(t -> t.sslContext(sslContext));
        this.webClient = WebClient.builder().baseUrl(this.env.getProperty("gescon.server.api-url")).clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient)).build();
    }

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        LOG.debug("SAML2 Auth.Success={}", (Object)authentication);
        Saml2AuthenticatedPrincipal principal = (Saml2AuthenticatedPrincipal)authentication.getPrincipal();
        String userID = principal.getName();
        StringBuilder queryString = new StringBuilder();
        queryString.append("?principalName=").append(userID);
        List groups = principal.getAttribute("http://schemas.microsoft.com/ws/2008/06/identity/claims/groups");
        if (groups != null) {
            for (Object group : groups) {
                queryString.append("&groups=").append(group.toString());
            }
        }
        if (principal.getAttributes() != null) {
            for (String attr : principal.getAttributes().keySet()) {
                LOG.debug("Attr: {} => {}", (Object)attr, principal.getFirstAttribute(attr));
            }
        }
        String gesconUrl = this.env.getProperty("gescon.server.url");
        response.sendRedirect(gesconUrl + "/sso/register" + queryString);
    }
}

