/*
 * Decompiled with CFR 0.152.
 */
package br.com.sigescantt.spring.security.keycloak;

import br.com.sigescantt.core.beans.geral.Empresa;
import br.com.sigescantt.core.beans.seguranca.DTOs.TokenResponseDTO;
import br.com.sigescantt.core.beans.seguranca.GrupoAcessoUsuario;
import br.com.sigescantt.core.beans.seguranca.Usuario;
import br.com.sigescantt.core.beans.seguranca.UsuarioEmpresa;
import br.com.sigescantt.core.beans.seguranca.UsuarioEmpresaPK;
import br.com.sigescantt.core.beans.seguranca.UsuarioGrupo;
import br.com.sigescantt.core.beans.seguranca.UsuarioGrupoPK;
import br.com.sigescantt.core.beans.seguranca.UsuarioPerfil;
import br.com.sigescantt.core.beans.seguranca.VOs.UsuarioChangePasswordRequestVO;
import br.com.sigescantt.geral.TipoRefCode;
import br.com.sigescantt.seguranca.UsuarioSessao;
import br.com.sigescantt.seguranca.UsuarioSessaoPK;
import br.com.sigescantt.services.CoreService;
import br.com.sigescantt.services.Exceptions.ErrorCode;
import br.com.sigescantt.services.Exceptions.ErrorCodeException;
import br.com.sigescantt.services.SegurancaService;
import br.com.sigescantt.services.dao.geral.EmpresaDAO;
import br.com.sigescantt.services.dao.seguranca.GrupoAcessoUsuarioDAO;
import br.com.sigescantt.services.dao.seguranca.UsuarioDAO;
import br.com.sigescantt.services.dao.seguranca.UsuarioEmpresaDAO;
import br.com.sigescantt.services.dao.seguranca.UsuarioGrupoDAO;
import br.com.sigescantt.services.dao.seguranca.UsuarioPerfilDAO;
import br.com.sigescantt.services.dao.seguranca.UsuarioSessaoDAO;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.core.Response;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.KeycloakBuilder;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.admin.client.resource.UsersResource;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class KeycloakCoreService {
    @Value(value="${keycloak.realm}")
    private String realm;
    @Value(value="${keycloak.default-password}")
    private String defaultPassword;
    @Value(value="${keycloak.server-url}")
    private String serverUrl;
    @Value(value="${keycloak.admin-client.id}")
    private String clientId;
    @Value(value="${keycloak.admin-client.secret}")
    private String clientSecret;
    private static final Logger logger = LoggerFactory.getLogger(KeycloakCoreService.class);
    private final UsuarioGrupoDAO usuarioGrupoDAO;
    private final Keycloak keycloakAdmin;
    private final UsuarioDAO usuarioDAO;
    private final SegurancaService segurancaService;
    private final JwtDecoder jwtDecoder;
    private final CoreService coreService;
    private final GrupoAcessoUsuarioDAO grupoAcessoUsuarioDAO;
    private final UsuarioSessaoDAO usuarioSessaoDAO;
    private final UsuarioEmpresaDAO usuarioEmpresaDAO;
    private final EmpresaDAO empresaDAO;
    private final UsuarioPerfilDAO usuarioPerfilDAO;
    private static final String AUTHORIZATION_PROPERTY = "Authorization";
    private static final String AUTHENTICATION_SCHEME = "Bearer";

    public KeycloakCoreService(Keycloak keycloakAdmin, UsuarioDAO usuarioDAO, SegurancaService segurancaService, JwtDecoder jwtDecoder, CoreService coreService, GrupoAcessoUsuarioDAO grupoAcessoUsuarioDAO, UsuarioGrupoDAO usuarioGrupoDAO, UsuarioSessaoDAO usuarioSessaoDAO, UsuarioEmpresaDAO usuarioEmpresaDAO, EmpresaDAO empresaDAO, UsuarioPerfilDAO usuarioPerfilDAO) {
        this.keycloakAdmin = keycloakAdmin;
        this.usuarioDAO = usuarioDAO;
        this.segurancaService = segurancaService;
        this.jwtDecoder = jwtDecoder;
        this.coreService = coreService;
        this.grupoAcessoUsuarioDAO = grupoAcessoUsuarioDAO;
        this.usuarioGrupoDAO = usuarioGrupoDAO;
        this.usuarioSessaoDAO = usuarioSessaoDAO;
        this.usuarioEmpresaDAO = usuarioEmpresaDAO;
        this.empresaDAO = empresaDAO;
        this.usuarioPerfilDAO = usuarioPerfilDAO;
    }

    @Transactional
    public TokenResponseDTO authenticate(String username, String password, HttpServletRequest request) {
        logger.debug("Realizando autentica\u00e7\u00e3o para usu\u00e1rio - {}", (Object)username);
        Keycloak authenticator = KeycloakBuilder.builder().serverUrl(this.serverUrl).realm(this.realm).clientId(this.clientId).clientSecret(this.clientSecret).username(username).password(password).build();
        try {
            AccessTokenResponse keycloakResponse = authenticator.tokenManager().getAccessToken();
            Jwt jwt = this.jwtDecoder.decode(keycloakResponse.getToken());
            Usuario user = this.usuarioDAO.getByLoginFetchGruposAndEmpresas(username);
            this.verifyUserIsInativoOrExpirado(user);
            user = this.processUserCreationOrSync(jwt, user, request);
            this.setGroups(jwt, user);
            return new TokenResponseDTO(keycloakResponse.getToken(), keycloakResponse.getExpiresIn(), keycloakResponse.getRefreshToken(), user.getEmpresas().stream().map(UsuarioEmpresa::getEmpresa).toList());
        }
        catch (NotAuthorizedException notAuthorizedException) {
            throw new ErrorCodeException(ErrorCode.INCORRECT_CREDENTIALS, new String[0]);
        }
    }

    @Transactional
    public void logout(HttpServletRequest request) {
        UsuarioSessao sessao = this.getUsuarioByJWT(request);
        sessao.setDatHorLogout(new Date(System.currentTimeMillis()));
        this.usuarioSessaoDAO.save((Object)sessao);
    }

    @Transactional
    public void setGroups(Jwt jwt, Usuario user) {
        if (jwt.getClaim("groups") != null) {
            this.setJwtKeycloakGroups(jwt, user);
        }
        if (jwt.getClaim("groups") == null) {
            this.setDefaultSystemGroup(user);
        }
    }

    @Transactional
    public void setJwtKeycloakGroups(Jwt jwt, Usuario user) {
        List<String> jwtGroups = jwt.getClaimAsStringList("groups").stream().map(String::toUpperCase).map(group -> group.replaceAll("[^a-zA-Z0-9\u00c7\u00e7\u00c3\u00e3\u00c1\u00e1\u00c0\u00e0\u00c9\u00e9\u00c8\u00e8\u00cd\u00ed\u00cc\u00ec\u00d3\u00f3\u00d2\u00f2\u00d5\u00f5\u00da\u00fa\u00d9\u00f9\u00dc\u00fc\\s]", "")).toList();
        List dbGroupsByJwt = this.grupoAcessoUsuarioDAO.getByDescricoes(jwtGroups);
        if (dbGroupsByJwt.isEmpty()) {
            logger.debug("Nenhum grupo equivalente aos informados no JWT foi encontrado no sistema para o usu\u00e1rio: {}", (Object)user.getLogin());
        }
        Set dbGroupsByJwtDescriptions = dbGroupsByJwt.stream().map(GrupoAcessoUsuario::getDescricao).map(String::toUpperCase).collect(Collectors.toSet());
        logger.debug("Grupos enviados no JWT: {}", jwtGroups);
        logger.debug("Grupos equivalentes do JWT que foram encontrados no sistema: {}", dbGroupsByJwtDescriptions);
        Set userCurrentGroups = user.getGrupos().stream().map(group -> group.getGrupoAcesso().getDescricao()).map(String::toUpperCase).collect(Collectors.toSet());
        Set groupsToBeAdded = dbGroupsByJwtDescriptions.stream().filter(group -> !userCurrentGroups.contains(group)).collect(Collectors.toSet());
        List<UsuarioGrupo> groupsToBeAddedEntities = dbGroupsByJwt.stream().map(group -> {
            UsuarioGrupo userGroup = new UsuarioGrupo();
            userGroup.setId(new UsuarioGrupoPK(user.getId(), group.getId()));
            userGroup.setUsuario(user);
            userGroup.setGrupoAcesso(group);
            return userGroup;
        }).toList();
        user.setGrupos(new HashSet<UsuarioGrupo>(groupsToBeAddedEntities));
        this.usuarioDAO.save((Object)user);
        if (groupsToBeAdded.isEmpty()) {
            logger.debug("Nenhuma altera\u00e7\u00e3o de grupos necess\u00e1ria para o usu\u00e1rio: {}", (Object)user.getLogin());
        } else {
            logger.debug("A adi\u00e7\u00e3o de novos grupos ocorreu com sucesso! Grupos adicionados ao usu\u00e1rio {} - {}", (Object)user.getLogin(), groupsToBeAdded);
        }
    }

    @Transactional
    public void setDefaultSystemGroup(Usuario user) {
        Integer groupId = (Integer)Optional.ofNullable(this.coreService.getRefValueByName(null, TipoRefCode.KEYCLOAK_ID_GRUPO_PADRAO)).orElseThrow(() -> new ErrorCodeException(ErrorCode.DEFAULT_KEYCLOAK_GROUP_NOT_DEFINED, new String[0]));
        GrupoAcessoUsuario group = (GrupoAcessoUsuario)this.grupoAcessoUsuarioDAO.findById((Object)groupId).orElseThrow(() -> new ErrorCodeException(ErrorCode.GROUP_NOT_FOUND, new String[0]));
        boolean precisaDoGrupoPadrao = user.getGrupos().stream().noneMatch(grupo -> grupo.getGrupoAcesso().getId().equals(groupId));
        if (precisaDoGrupoPadrao) {
            UsuarioGrupo userGroup = new UsuarioGrupo();
            userGroup.setId(new UsuarioGrupoPK(user.getId(), group.getId()));
            userGroup.setUsuario(user);
            userGroup.setGrupoAcesso(group);
            userGroup.setDatHorCadastro(LocalDateTime.now());
            userGroup.setIdUsuarioIns(Integer.valueOf(1));
            logger.debug("Nenhum grupo encontrado no JWT para usu\u00e1rio: {}, adicionando grupo {} (padr\u00e3o configurado no sistema)", (Object)user.getLogin(), (Object)group.getDescricao());
            this.usuarioGrupoDAO.save((Object)userGroup);
        }
    }

    @Transactional
    public Usuario processUserCreationOrSync(Jwt jwt, Usuario user, HttpServletRequest request) {
        Map claims = jwt.getClaims();
        String username = claims.get("preferred_username").toString();
        String email = claims.get("email").toString();
        String name = claims.get("name").toString();
        String keycloakId = claims.get("sub").toString();
        logger.debug("Verificando usu\u00e1rio de login: [{}]...", (Object)username);
        if (user == null) {
            Integer userId = this.usuarioDAO.getNextId();
            Usuario newUser = new Usuario();
            newUser.setId(userId);
            newUser.setLogin(username);
            newUser.setEmail(email);
            newUser.setNome(name);
            newUser.setDatHorCadastro(LocalDateTime.now());
            newUser.setKeycloakId(UUID.fromString(keycloakId));
            newUser.setTipo("N");
            user = (Usuario)this.usuarioDAO.save((Object)newUser);
            this.createUserProfile(user);
            logger.debug("Usu\u00e1rio n\u00e3o identificado no sistema, portanto foi criado o usu\u00e1rio com as informa\u00e7\u00f5es: {}, {}, {}", new Object[]{username, name, email});
        } else {
            boolean userFoiAlterado = false;
            if (user.getKeycloakId() == null) {
                user.setKeycloakId(UUID.fromString(keycloakId));
                userFoiAlterado = true;
            }
            if (!(user.getNome().equals(name) && user.getEmail().equals(email) && user.getLogin().equals(username))) {
                user.setNome(name);
                user.setEmail(email);
                user.setLogin(username);
                user.setDatHorAlteracao(LocalDateTime.now());
                logger.debug("Dados do usu\u00e1rio {} foram alterados no Keycloak, sincroniza\u00e7\u00e3o dos dados realizada com sucesso!", (Object)user.getLogin());
                userFoiAlterado = true;
            }
            if (userFoiAlterado) {
                this.usuarioDAO.save((Object)user);
            }
        }
        Empresa agencia = (Empresa)this.empresaDAO.getAgencia().orElseThrow(() -> new ErrorCodeException(ErrorCode.AGENCIA_NOT_DEFINED, new String[0]));
        Optional usuarioTemAgencia = this.usuarioEmpresaDAO.findUserHasAgencia(user.getId(), agencia.getId());
        if (usuarioTemAgencia.isEmpty()) {
            UsuarioEmpresa usuarioEmpresa = new UsuarioEmpresa();
            usuarioEmpresa.setId(new UsuarioEmpresaPK(user.getId(), agencia.getId()));
            usuarioEmpresa.setDatHorCadastro(LocalDateTime.now());
            usuarioEmpresa.setIdUsuarioIns(Integer.valueOf(1));
            this.usuarioEmpresaDAO.save((Object)usuarioEmpresa);
        }
        this.createUserSession(request, user, jwt.getTokenValue());
        return user;
    }

    @Transactional
    public void createUserSession(HttpServletRequest request, Usuario user, String token) {
        UsuarioSessao sessao = new UsuarioSessao();
        String agente = request.getHeader("User-Agent");
        sessao.setId(new UsuarioSessaoPK(user.getId(), this.usuarioSessaoDAO.getNextId(user.getId())));
        sessao.setUserAgent(agente);
        sessao.setUsuario(user);
        sessao.setIpAcesso(request.getRemoteAddr());
        sessao.setSessionApi(token);
        sessao.getId().setIdUsuario(user.getId());
        sessao.setDatHorLogin(new Date(System.currentTimeMillis()));
        this.usuarioSessaoDAO.save((Object)sessao);
    }

    @Transactional
    public void createUserProfile(Usuario user) {
        UsuarioPerfil perfil = new UsuarioPerfil();
        perfil.setIdUsuario(user.getId());
        perfil.setSenha("sigescantt");
        perfil.setBloqueado(Integer.valueOf(0));
        perfil.setAdministrador(Integer.valueOf(0));
        perfil.setInativo(Integer.valueOf(0));
        perfil.setDatHorExpiracao(LocalDateTime.now().plusMonths(6L));
        this.usuarioPerfilDAO.save((Object)perfil);
    }

    public void alterarSenhaUsuario(String token, String novaSenha) {
        this.segurancaService.validateUserByRequest(token);
        Usuario usuarioToken = this.segurancaService.validateUserByBearerToken(token);
        UserResource userResource = this.keycloakAdmin.realm(this.realm).users().get(String.valueOf(usuarioToken.getKeycloakId()));
        UserRepresentation keycloakUser = userResource.toRepresentation();
        CredentialRepresentation credential = new CredentialRepresentation();
        credential.setType("password");
        credential.setValue(novaSenha);
        keycloakUser.setCredentials(Collections.singletonList(credential));
        userResource.update(keycloakUser);
    }

    @Transactional
    public void alterarSenhaAdmin(String token, UsuarioChangePasswordRequestVO vo) {
        this.segurancaService.validateUserIsAdmin(token);
        Usuario usuarioNovaSenha = (Usuario)this.usuarioDAO.findById((Object)vo.idUsuario()).orElseThrow(() -> new ErrorCodeException(ErrorCode.USER_NOT_FOUND, new String[0]));
        if (usuarioNovaSenha.getKeycloakId() == null || usuarioNovaSenha.getKeycloakId().toString().isBlank()) {
            throw new ErrorCodeException(ErrorCode.KEYCLOAK_USER_UUID_NOT_FOUND, new String[0]);
        }
        UserResource userResource = this.keycloakAdmin.realm(this.realm).users().get(String.valueOf(usuarioNovaSenha.getKeycloakId()));
        UserRepresentation keycloakUser = userResource.toRepresentation();
        CredentialRepresentation credential = new CredentialRepresentation();
        credential.setType("password");
        credential.setValue(vo.novaSenha());
        keycloakUser.setCredentials(Collections.singletonList(credential));
        userResource.update(keycloakUser);
    }

    public void migrateUsers() {
        List usersDB = this.usuarioDAO.findAll();
        UsersResource usersResource = this.keycloakAdmin.realm(this.realm).users();
        for (Usuario userDB : usersDB) {
            String lastNameUserDB;
            String firstNameUserDB;
            String nomeCompletoUserDB = userDB.getNome();
            String nomeLimpo = nomeCompletoUserDB.trim();
            int primeiroEspaco = nomeLimpo.indexOf(32);
            if (primeiroEspaco == -1) {
                firstNameUserDB = nomeLimpo;
                lastNameUserDB = "";
            } else {
                firstNameUserDB = nomeLimpo.substring(0, primeiroEspaco);
                lastNameUserDB = nomeLimpo.substring(primeiroEspaco + 1).trim();
            }
            UserRepresentation keycloakUser = new UserRepresentation();
            keycloakUser.setUsername(userDB.getLogin());
            keycloakUser.setEmail(userDB.getEmail());
            keycloakUser.setFirstName(firstNameUserDB);
            keycloakUser.setLastName(lastNameUserDB);
            keycloakUser.setEnabled(Boolean.valueOf(true));
            keycloakUser.setEmailVerified(Boolean.valueOf(true));
            CredentialRepresentation credential = new CredentialRepresentation();
            credential.setType("password");
            credential.setValue(this.defaultPassword);
            keycloakUser.setCredentials(Collections.singletonList(credential));
            try {
                Response response = usersResource.create(keycloakUser);
                try {
                    if (response.getStatus() == 201) {
                        logger.debug("Usu\u00e1rio criado com sucesso: {}", (Object)userDB.getLogin());
                        continue;
                    }
                    if (response.getStatus() == 409) {
                        logger.debug("Usu\u00e1rio j\u00e1 existe: {}", (Object)userDB.getLogin());
                        continue;
                    }
                    logger.debug("Erro ao criar usu\u00e1rio {}", (Object)(userDB.getLogin() + " - " + response.getStatusInfo().getReasonPhrase()));
                }
                finally {
                    if (response == null) continue;
                    response.close();
                }
            }
            catch (Exception e) {
                logger.debug("Exception ao criar usu\u00e1rio {}", (Object)(userDB.getLogin() + " - " + e.getMessage()));
            }
        }
    }

    @Transactional
    public void syncUsersFromKeycloak() {
        logger.debug("Inicializando processo de sincroniza\u00e7\u00e3o de usu\u00e1rios com Keycloak...");
        List usersDB = this.usuarioDAO.findAll();
        RealmResource realmResource = this.keycloakAdmin.realm(this.realm);
        UsersResource usersResource = realmResource.users();
        for (Usuario user : usersDB) {
            try {
                List keycloakUsers = usersResource.searchByUsername(user.getLogin(), Boolean.valueOf(true));
                if (!keycloakUsers.isEmpty()) {
                    UserRepresentation keycloakUser = (UserRepresentation)keycloakUsers.getFirst();
                    this.updateLocalUser(keycloakUser, user);
                    continue;
                }
                logger.debug("Usu\u00e1rio {} existe localmente mas n\u00e3o foi encontrado no Keycloak", (Object)user.getLogin());
            }
            catch (Exception e) {
                logger.debug("Um erro ocorreu na sincroniza\u00e7\u00e3o do usu\u00e1rio: {}", (Object)user.getLogin(), (Object)e);
            }
        }
        logger.debug("Processo de sincroniza\u00e7\u00e3o dos usu\u00e1rios finalizado com sucesso");
    }

    @Transactional
    protected void updateLocalUser(UserRepresentation keycloakUser, Usuario user) {
        boolean updatable = this.needsUpdate(keycloakUser, user);
        if (updatable) {
            user.setLogin(keycloakUser.getUsername());
            user.setEmail(keycloakUser.getEmail());
            user.setDatHorAlteracao(LocalDateTime.now());
            user.setNome(keycloakUser.getFirstName() + " " + keycloakUser.getLastName());
            user.setKeycloakId(UUID.fromString(keycloakUser.getId()));
            this.usuarioDAO.save((Object)user);
            logger.debug("Cadastro ATUALIZADO: O usu\u00e1rio [{}] teve suas informa\u00e7\u00f5es sincronizadas com o Keycloak.", (Object)user.getLogin());
        } else {
            logger.debug("As informa\u00e7\u00f5es do usu\u00e1rio [{}] continuam as mesmas, nada para alterar...", (Object)user.getLogin());
        }
    }

    protected boolean needsUpdate(UserRepresentation keycloakUser, Usuario user) {
        return !user.getLogin().equals(keycloakUser.getUsername()) || !user.getEmail().equals(keycloakUser.getEmail()) || !user.getNome().equals(keycloakUser.getFirstName() + " " + keycloakUser.getLastName());
    }

    protected UsuarioSessao getUsuarioByJWT(HttpServletRequest request) {
        String bearerToken = this.getToken(request);
        UsuarioSessao sessao = this.segurancaService.getSessaoUsuarioByToken(bearerToken);
        if (sessao != null) {
            return sessao;
        }
        logger.info(String.format("BearerToken '%s' n\u00e3o encontrado ou inv\u00e1lido. ", bearerToken));
        return null;
    }

    protected String getToken(HttpServletRequest request) {
        Enumeration headers = request.getHeaders(AUTHORIZATION_PROPERTY);
        if (headers == null || !headers.hasMoreElements()) {
            logger.error("No Header AuthProperty ");
            return null;
        }
        return ((String)headers.nextElement()).replaceFirst("Bearer ", "");
    }

    protected void verifyUserIsInativoOrExpirado(Usuario user) {
        if (user != null && user.getPerfil() != null) {
            if (user.getPerfil().getDatHorExpiracao() != null && user.getPerfil().getDatHorExpiracao().isBefore(LocalDateTime.now())) {
                throw new ErrorCodeException(ErrorCode.EXPIRED_USER, new String[0]);
            }
            if (user.getPerfil().getInativoBoolean().booleanValue()) {
                throw new ErrorCodeException(ErrorCode.INACTIVE_USER, new String[0]);
            }
        }
    }
}

