/*
 * Decompiled with CFR 0.152.
 */
package br.com.sigescantt.spring.security.authentication;

import br.com.sigescantt.core.beans.seguranca.DTOs.TokenResponseDTO;
import br.com.sigescantt.core.beans.seguranca.DTOs.UsuarioLoginDTO;
import br.com.sigescantt.spring.security.keycloak.KeycloakCoreService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/auth"})
@RestController
@Validated
public class AuthenticationRestServices {
    private final KeycloakCoreService keycloakCoreService;

    public AuthenticationRestServices(KeycloakCoreService keycloakCoreService) {
        this.keycloakCoreService = keycloakCoreService;
    }

    @PostMapping
    public TokenResponseDTO login(@RequestBody @Valid UsuarioLoginDTO dto, HttpServletRequest request) {
        return this.keycloakCoreService.authenticate(dto.username(), dto.password(), request);
    }

    @PostMapping(value={"/logout"})
    public void logout(HttpServletRequest request) {
        this.keycloakCoreService.logout(request);
    }
}

