/*
 * Decompiled with CFR 0.152.
 */
package br.com.sigescantt.spring.security;

import br.com.sigescantt.core.beans.seguranca.Usuario;
import br.com.sigescantt.geral.TipoRefCode;
import br.com.sigescantt.services.CoreService;
import br.com.sigescantt.services.SegurancaService;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class SchedulerApiKeyAuthenticationFilter
extends OncePerRequestFilter {
    private static final Logger logger = LoggerFactory.getLogger(SchedulerApiKeyAuthenticationFilter.class);
    private static final String API_KEY_HEADER = "X-API-KEY";
    private static final String SCHEDULER_PATH = "/api/schedulers";
    private final String schedulerApiKey;
    private final SegurancaService segurancaService;
    private final CoreService coreService;

    public SchedulerApiKeyAuthenticationFilter(SegurancaService segurancaService, CoreService coreService, @Value(value="${sigescantt.api-key.scheduler}") String schedulerApiKey) {
        this.segurancaService = segurancaService;
        this.schedulerApiKey = schedulerApiKey;
        this.coreService = coreService;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String requestPath = request.getRequestURI();
        if (!requestPath.startsWith(SCHEDULER_PATH)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String apiKey = request.getHeader(API_KEY_HEADER);
        if (apiKey == null || apiKey.trim().isEmpty()) {
            logger.debug("Chave API n\u00e3o enviada: {}", (Object)requestPath);
            response.sendError(401, "Chave API inv\u00e1lida");
            return;
        }
        if (!this.schedulerApiKey.equals(apiKey)) {
            logger.warn("Tentativa de acesso com chave API inv\u00e1lida para endpoint do scheduler: {}", (Object)requestPath);
            response.sendError(401, "Chave API inv\u00e1lida");
            return;
        }
        Optional schedulerUsernameOpt = this.coreService.getRefValueByName(null, TipoRefCode.SCHEDULER_USUARIO_API, String.class);
        if (schedulerUsernameOpt.isEmpty()) {
            logger.error("Usu\u00e1rio do scheduler n\u00e3o configurado na base de dados");
            response.sendError(500, "Usu\u00e1rio do scheduler n\u00e3o configurado");
            return;
        }
        String schedulerUsername = (String)schedulerUsernameOpt.get();
        try {
            Usuario schedulerUser = this.segurancaService.getUsuarioByLoginOrMail(schedulerUsername);
            if (schedulerUser == null) {
                logger.error("Usu\u00e1rio do scheduler '{}' n\u00e3o encontrado na base de dados", (Object)schedulerUsername);
                response.sendError(500, "Usu\u00e1rio do scheduler n\u00e3o configurado");
                return;
            }
            UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)schedulerUser, null, Collections.emptyList());
            SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
            logger.debug("Usu\u00e1rio do scheduler '{}' autenticado com sucesso para endpoint: {}", (Object)schedulerUsername, (Object)requestPath);
        }
        catch (Exception e) {
            logger.error("Erro ao autenticar usu\u00e1rio do scheduler: {}", (Object)e.getMessage(), (Object)e);
            response.sendError(500, "Erro de autentica\u00e7\u00e3o");
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

