/*
 * Decompiled with CFR 0.152.
 */
package br.com.sigescantt.reports;

import br.com.sigescantt.sigaco.MonitoracaoSigaco;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.DefaultIndexedColorMap;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportMonitoracaoExcel {
    private Logger logger = LoggerFactory.getLogger(ExportMonitoracaoExcel.class);

    public byte[] executeXLS(List<MonitoracaoSigaco> monitoracoes) {
        this.logger.debug("Iniciando exporta\u00e7\u00e3o das monitora\u00e7\u00f5es");
        SXSSFWorkbook wb = new SXSSFWorkbook(100);
        Sheet sheet = wb.createSheet("Monitora\u00e7\u00f5es");
        DefaultIndexedColorMap idxColor = new DefaultIndexedColorMap();
        sheet.setDisplayGridlines(false);
        sheet.setPrintGridlines(false);
        sheet.setAutobreaks(false);
        Font fontBase = wb.createFont();
        fontBase.setFontHeightInPoints((short)11);
        fontBase.setFontName("Calibri");
        Font fontRevisao = wb.createFont();
        fontRevisao.setFontHeightInPoints((short)13);
        fontRevisao.setFontName("Calibri");
        Font fontRelatorio = wb.createFont();
        fontRelatorio.setFontHeightInPoints((short)16);
        fontRelatorio.setFontName("Calibri");
        fontRelatorio.setBold(true);
        Font fontHeader = wb.createFont();
        fontHeader.setFontHeightInPoints((short)8);
        fontHeader.setFontName("Calibri");
        fontHeader.setBold(true);
        Font fontTitle = wb.createFont();
        fontTitle.setFontHeightInPoints((short)18);
        fontTitle.setFontName("Calibri");
        Font fontBigHeader = wb.createFont();
        fontBigHeader.setFontHeightInPoints((short)18);
        fontBigHeader.setColor(IndexedColors.GREY_50_PERCENT.getIndex());
        fontBigHeader.setFontName("Calibri");
        Font fontBig = wb.createFont();
        fontBig.setFontHeightInPoints((short)18);
        fontBig.setFontName("Calibri");
        Font fontSub = wb.createFont();
        fontSub.setFontHeightInPoints((short)11);
        fontSub.setFontName("Calibri");
        fontSub.setBold(true);
        Font fontQtde = wb.createFont();
        fontQtde.setFontHeightInPoints((short)11);
        fontQtde.setFontName("Calibri");
        CellStyle styleBorder = wb.createCellStyle();
        styleBorder.setBorderBottom(BorderStyle.THIN);
        styleBorder.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        styleBorder.setBorderLeft(BorderStyle.THIN);
        styleBorder.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        styleBorder.setBorderRight(BorderStyle.THIN);
        styleBorder.setRightBorderColor(IndexedColors.BLACK.getIndex());
        styleBorder.setBorderTop(BorderStyle.THIN);
        styleBorder.setTopBorderColor(IndexedColors.BLACK.getIndex());
        CellStyle styleBorderCinza = wb.createCellStyle();
        styleBorderCinza.setBorderBottom(BorderStyle.THIN);
        styleBorderCinza.setBottomBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleBorderCinza.setBorderLeft(BorderStyle.THIN);
        styleBorderCinza.setLeftBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleBorderCinza.setBorderRight(BorderStyle.THIN);
        styleBorderCinza.setRightBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleBorderCinza.setBorderTop(BorderStyle.THIN);
        styleBorderCinza.setTopBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        CellStyle styleBase = wb.createCellStyle();
        styleBase.setFont(fontBase);
        styleBase.setAlignment(HorizontalAlignment.CENTER);
        styleBase.setWrapText(true);
        styleBase.setVerticalAlignment(VerticalAlignment.CENTER);
        styleBase.setBorderBottom(BorderStyle.THIN);
        styleBase.setBottomBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleBase.setBorderLeft(BorderStyle.THIN);
        styleBase.setLeftBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleBase.setBorderRight(BorderStyle.THIN);
        styleBase.setRightBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleBase.setBorderTop(BorderStyle.THIN);
        styleBase.setTopBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        DataFormat formatter = wb.createDataFormat();
        CellStyle styleNumerico = wb.createCellStyle();
        styleNumerico.setFont(fontBase);
        styleNumerico.setBorderBottom(BorderStyle.THIN);
        styleNumerico.setBottomBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleNumerico.setBorderLeft(BorderStyle.THIN);
        styleNumerico.setLeftBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleNumerico.setBorderRight(BorderStyle.THIN);
        styleNumerico.setRightBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleNumerico.setBorderTop(BorderStyle.THIN);
        styleNumerico.setTopBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleNumerico.setAlignment(HorizontalAlignment.RIGHT);
        styleNumerico.setDataFormat(formatter.getFormat("##,##0.00"));
        CellStyle styleHead = wb.createCellStyle();
        styleHead.cloneStyleFrom(styleBorderCinza);
        styleHead.setFont(fontHeader);
        styleHead.setAlignment(HorizontalAlignment.CENTER);
        styleHead.setVerticalAlignment(VerticalAlignment.CENTER);
        styleHead.setWrapText(true);
        ((XSSFCellStyle)styleHead).setFillForegroundColor(new XSSFColor(new Color(198, 198, 198), (IndexedColorMap)idxColor));
        styleHead.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        CellStyle styleCabecalho = wb.createCellStyle();
        styleCabecalho.setFont(fontBigHeader);
        styleCabecalho.setBorderBottom(BorderStyle.THIN);
        styleCabecalho.setBottomBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleCabecalho.setBorderLeft(BorderStyle.THIN);
        styleCabecalho.setLeftBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleCabecalho.setBorderRight(BorderStyle.THIN);
        styleCabecalho.setRightBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleCabecalho.setBorderTop(BorderStyle.THIN);
        styleCabecalho.setTopBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleCabecalho.setAlignment(HorizontalAlignment.CENTER);
        styleCabecalho.setVerticalAlignment(VerticalAlignment.CENTER);
        styleCabecalho.setWrapText(true);
        CellStyle styleControle = wb.createCellStyle();
        styleControle.setFont(fontBig);
        styleControle.setAlignment(HorizontalAlignment.CENTER);
        styleControle.setVerticalAlignment(VerticalAlignment.CENTER);
        styleControle.setWrapText(true);
        styleControle.setBorderLeft(BorderStyle.THIN);
        styleControle.setLeftBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleControle.setBorderRight(BorderStyle.THIN);
        styleControle.setRightBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleControle.setBorderTop(BorderStyle.THIN);
        styleControle.setTopBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        CellStyle styleSubCabecalho = wb.createCellStyle();
        styleSubCabecalho.setFont(fontSub);
        styleSubCabecalho.setAlignment(HorizontalAlignment.CENTER);
        styleSubCabecalho.setVerticalAlignment(VerticalAlignment.CENTER);
        styleSubCabecalho.setWrapText(true);
        CellStyle styleRevisao = wb.createCellStyle();
        styleRevisao.setFont(fontRevisao);
        styleRevisao.setAlignment(HorizontalAlignment.CENTER);
        styleRevisao.setVerticalAlignment(VerticalAlignment.CENTER);
        styleRevisao.setWrapText(true);
        styleRevisao.setBorderLeft(BorderStyle.THIN);
        styleRevisao.setLeftBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleRevisao.setBorderRight(BorderStyle.THIN);
        styleRevisao.setRightBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        CellStyle styleRelatorio = wb.createCellStyle();
        styleRelatorio.setFont(fontRevisao);
        styleRelatorio.setAlignment(HorizontalAlignment.CENTER);
        styleRelatorio.setVerticalAlignment(VerticalAlignment.CENTER);
        styleRelatorio.setWrapText(true);
        styleRelatorio.setBorderLeft(BorderStyle.THIN);
        styleRelatorio.setLeftBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleRelatorio.setBorderRight(BorderStyle.THIN);
        styleRelatorio.setRightBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleRelatorio.setBorderBottom(BorderStyle.THIN);
        styleRelatorio.setBottomBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        CellStyle styleFooterCentral = wb.createCellStyle();
        styleFooterCentral.setFont(fontBase);
        styleFooterCentral.setAlignment(HorizontalAlignment.CENTER);
        ((XSSFCellStyle)styleFooterCentral).setFillForegroundColor(new XSSFColor(new Color(198, 198, 198), (IndexedColorMap)idxColor));
        styleFooterCentral.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        styleFooterCentral.setBorderBottom(BorderStyle.THIN);
        styleFooterCentral.setBottomBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleFooterCentral.setBorderLeft(BorderStyle.THIN);
        styleFooterCentral.setLeftBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleFooterCentral.setBorderRight(BorderStyle.THIN);
        styleFooterCentral.setRightBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleFooterCentral.setBorderTop(BorderStyle.THIN);
        styleFooterCentral.setTopBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        CellStyle styleFooterDireita = wb.createCellStyle();
        styleFooterDireita.setFont(fontBase);
        styleFooterDireita.setAlignment(HorizontalAlignment.RIGHT);
        styleFooterDireita.setDataFormat(formatter.getFormat("##,##0.00"));
        ((XSSFCellStyle)styleFooterDireita).setFillForegroundColor(new XSSFColor(new Color(198, 198, 198), (IndexedColorMap)idxColor));
        styleFooterDireita.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        styleFooterDireita.setBorderBottom(BorderStyle.THIN);
        styleFooterDireita.setBottomBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleFooterDireita.setBorderLeft(BorderStyle.THIN);
        styleFooterDireita.setLeftBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleFooterDireita.setBorderRight(BorderStyle.THIN);
        styleFooterDireita.setRightBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleFooterDireita.setBorderTop(BorderStyle.THIN);
        styleFooterDireita.setTopBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        Font smallFont = wb.createFont();
        smallFont.setFontHeightInPoints((short)8);
        smallFont.setItalic(true);
        Font small2Font = wb.createFont();
        small2Font.setFontHeightInPoints((short)9);
        CellStyle styleFooterLeft = wb.createCellStyle();
        styleFooterLeft.setFont(smallFont);
        styleFooterLeft.setAlignment(HorizontalAlignment.LEFT);
        ((XSSFCellStyle)styleFooterLeft).setFillForegroundColor(new XSSFColor(new Color(190, 190, 190), (IndexedColorMap)idxColor));
        styleFooterLeft.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        styleFooterLeft.setBorderBottom(BorderStyle.THIN);
        styleFooterLeft.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        styleFooterLeft.setBorderLeft(BorderStyle.THIN);
        styleFooterLeft.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        styleFooterLeft.setBorderTop(BorderStyle.THIN);
        styleFooterLeft.setTopBorderColor(IndexedColors.BLACK.getIndex());
        CellStyle styleFooterRight = wb.createCellStyle();
        styleFooterRight.setFont(small2Font);
        styleFooterRight.setAlignment(HorizontalAlignment.LEFT);
        ((XSSFCellStyle)styleFooterRight).setFillForegroundColor(new XSSFColor(new Color(190, 190, 190), (IndexedColorMap)idxColor));
        styleFooterRight.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        styleFooterRight.setBorderBottom(BorderStyle.THIN);
        styleFooterRight.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        styleFooterRight.setBorderRight(BorderStyle.THIN);
        styleFooterRight.setRightBorderColor(IndexedColors.BLACK.getIndex());
        styleFooterRight.setBorderTop(BorderStyle.THIN);
        styleFooterRight.setTopBorderColor(IndexedColors.BLACK.getIndex());
        CellStyle styleQtd = wb.createCellStyle();
        styleQtd.setFont(fontQtde);
        styleQtd.setBorderBottom(BorderStyle.THIN);
        styleQtd.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        styleQtd.setBorderLeft(BorderStyle.THIN);
        styleQtd.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        styleQtd.setBorderRight(BorderStyle.THIN);
        styleQtd.setRightBorderColor(IndexedColors.BLACK.getIndex());
        styleQtd.setBorderTop(BorderStyle.THIN);
        styleQtd.setTopBorderColor(IndexedColors.BLACK.getIndex());
        styleQtd.setDataFormat(formatter.getFormat("##,##0.00"));
        CellStyle styleData = wb.createCellStyle();
        styleData.cloneStyleFrom(styleBase);
        styleData.setDataFormat(formatter.getFormat("dd/MM/yyyy"));
        styleData.setAlignment(HorizontalAlignment.CENTER);
        CellStyle styleDataHora = wb.createCellStyle();
        styleDataHora.cloneStyleFrom(styleBase);
        styleDataHora.setDataFormat(formatter.getFormat("dd/MM/yyyy HH:mm"));
        styleDataHora.setAlignment(HorizontalAlignment.CENTER);
        Integer idx = 0;
        Integer idxCell = 0;
        Row row = sheet.createRow(0);
        Cell cell = row.createCell(idxCell.intValue());
        cell.setCellStyle(styleHead);
        cell.setCellValue("Tipo Ativo");
        idxCell = idxCell + 1;
        cell = row.createCell(idxCell.intValue());
        cell.setCellStyle(styleHead);
        cell.setCellValue("Elemento");
        idxCell = idxCell + 1;
        cell = row.createCell(idxCell.intValue());
        cell.setCellStyle(styleHead);
        cell.setCellValue("Data Monitora\u00e7\u00e3o");
        idxCell = idxCell + 1;
        cell = row.createCell(idxCell.intValue());
        cell.setCellStyle(styleHead);
        cell.setCellValue("Rodovia");
        idxCell = idxCell + 1;
        cell = row.createCell(idxCell.intValue());
        cell.setCellStyle(styleHead);
        cell.setCellValue("Km Inicial.");
        idxCell = idxCell + 1;
        cell = row.createCell(idxCell.intValue());
        cell.setCellStyle(styleHead);
        cell.setCellValue("Km Final");
        idxCell = idxCell + 1;
        cell = row.createCell(idxCell.intValue());
        cell.setCellStyle(styleHead);
        cell.setCellValue("Segmento");
        idxCell = idxCell + 1;
        cell = row.createCell(idxCell.intValue());
        cell.setCellStyle(styleHead);
        cell.setCellValue("Extens\u00e3o");
        idxCell = idxCell + 1;
        cell = row.createCell(idxCell.intValue());
        cell.setCellStyle(styleHead);
        cell.setCellValue("Pista");
        idxCell = idxCell + 1;
        cell = row.createCell(idxCell.intValue());
        cell.setCellStyle(styleHead);
        cell.setCellValue("Sentido");
        idxCell = idxCell + 1;
        cell = row.createCell(idxCell.intValue());
        cell.setCellStyle(styleHead);
        cell.setCellValue("Faixa");
        idxCell = idxCell + 1;
        cell = row.createCell(idxCell.intValue());
        cell.setCellStyle(styleHead);
        cell.setCellValue("Via");
        idxCell = idxCell + 1;
        cell = row.createCell(idxCell.intValue());
        cell.setCellStyle(styleHead);
        cell.setCellValue("Lado");
        idxCell = idxCell + 1;
        cell = row.createCell(idxCell.intValue());
        cell.setCellStyle(styleHead);
        cell.setCellValue("Latitude");
        idxCell = idxCell + 1;
        cell = row.createCell(idxCell.intValue());
        cell.setCellStyle(styleHead);
        cell.setCellValue("Longitude");
        idxCell = idxCell + 1;
        cell = row.createCell(idxCell.intValue());
        cell.setCellStyle(styleHead);
        cell.setCellValue("Fase Monitora\u00e7\u00e3o");
        idxCell = idxCell + 1;
        cell = row.createCell(idxCell.intValue());
        cell.setCellStyle(styleHead);
        cell.setCellValue("Respons\u00e1vel");
        idxCell = idxCell + 1;
        cell = row.createCell(idxCell.intValue());
        cell.setCellStyle(styleHead);
        cell.setCellValue("Estado Conserva\u00e7\u00e3o");
        idxCell = idxCell + 1;
        cell = row.createCell(idxCell.intValue());
        cell.setCellStyle(styleHead);
        cell.setCellValue("Material");
        idxCell = idxCell + 1;
        cell = row.createCell(idxCell.intValue());
        cell.setCellStyle(styleHead);
        cell.setCellValue("Ambiente");
        idxCell = idxCell + 1;
        cell = row.createCell(idxCell.intValue());
        cell.setCellStyle(styleHead);
        cell.setCellValue("M\u00e9dia");
        idxCell = idxCell + 1;
        cell = row.createCell(idxCell.intValue());
        cell.setCellStyle(styleHead);
        cell.setCellValue("M\u00ednimo");
        idxCell = idxCell + 1;
        cell = row.createCell(idxCell.intValue());
        cell.setCellStyle(styleHead);
        cell.setCellValue("Lote");
        idxCell = idxCell + 1;
        cell = row.createCell(idxCell.intValue());
        cell.setCellStyle(styleHead);
        cell.setCellValue("Funcion\u00e1rio");
        idxCell = idxCell + 1;
        cell = row.createCell(idxCell.intValue());
        cell.setCellStyle(styleHead);
        cell.setCellValue("Observa\u00e7\u00f5es");
        if (monitoracoes != null) {
            for (MonitoracaoSigaco sig : monitoracoes) {
                idx = idx + 1;
                row = sheet.createRow(idx.intValue());
                idxCell = 0;
                cell = row.createCell(idxCell.intValue());
                cell.setCellStyle(styleBase);
                cell.setCellValue(sig.getTipoAtivo());
                idxCell = idxCell + 1;
                cell = row.createCell(idxCell.intValue());
                cell.setCellStyle(styleBase);
                if (sig.getElemento() != null && sig.getElemento() != null) {
                    cell.setCellValue(sig.getElemento().getDesNome());
                }
                idxCell = idxCell + 1;
                cell = row.createCell(idxCell.intValue());
                cell.setCellStyle(styleData);
                cell.setCellValue(sig.getDatMonitoracao());
                idxCell = idxCell + 1;
                cell = row.createCell(idxCell.intValue());
                cell.setCellStyle(styleBase);
                if (sig.getRodovia() != null && sig.getRodovia() != null) {
                    cell.setCellValue(sig.getRodovia().getDescricao());
                }
                idxCell = idxCell + 1;
                cell = row.createCell(idxCell.intValue());
                cell.setCellStyle(styleNumerico);
                if (sig.getKmInicial() != null) {
                    cell.setCellValue(sig.getKmInicial().doubleValue());
                }
                idxCell = idxCell + 1;
                cell = row.createCell(idxCell.intValue());
                cell.setCellStyle(styleNumerico);
                if (sig.getKmFinal() != null) {
                    cell.setCellValue(sig.getKmFinal().doubleValue());
                }
                idxCell = idxCell + 1;
                cell = row.createCell(idxCell.intValue());
                cell.setCellStyle(styleBase);
                cell.setCellValue(sig.getSegmento());
                idxCell = idxCell + 1;
                cell = row.createCell(idxCell.intValue());
                cell.setCellStyle(styleNumerico);
                if (sig.getExtensao() != null) {
                    cell.setCellValue(sig.getExtensao().doubleValue());
                }
                idxCell = idxCell + 1;
                cell = row.createCell(idxCell.intValue());
                cell.setCellStyle(styleBase);
                cell.setCellValue(sig.getPista());
                idxCell = idxCell + 1;
                cell = row.createCell(idxCell.intValue());
                cell.setCellStyle(styleBase);
                cell.setCellValue(sig.getSentido());
                idxCell = idxCell + 1;
                cell = row.createCell(idxCell.intValue());
                cell.setCellStyle(styleBase);
                cell.setCellValue(sig.getFaixa());
                idxCell = idxCell + 1;
                cell = row.createCell(idxCell.intValue());
                cell.setCellStyle(styleBase);
                if (sig.getVia() != null) {
                    cell.setCellValue((double)sig.getVia().charValue());
                }
                idxCell = idxCell + 1;
                cell = row.createCell(idxCell.intValue());
                cell.setCellStyle(styleBase);
                cell.setCellValue(sig.getLado());
                idxCell = idxCell + 1;
                cell = row.createCell(idxCell.intValue());
                cell.setCellStyle(styleNumerico);
                if (sig.getLatitude() != null) {
                    cell.setCellValue(sig.getLatitude().doubleValue());
                }
                idxCell = idxCell + 1;
                cell = row.createCell(idxCell.intValue());
                cell.setCellStyle(styleNumerico);
                if (sig.getLongitude() != null) {
                    cell.setCellValue(sig.getLongitude().doubleValue());
                }
                idxCell = idxCell + 1;
                cell = row.createCell(idxCell.intValue());
                cell.setCellStyle(styleBase);
                if (sig.getFase() != null) {
                    cell.setCellValue(sig.getFase().getDescricao());
                }
                idxCell = idxCell + 1;
                cell = row.createCell(idxCell.intValue());
                cell.setCellStyle(styleBase);
                cell.setCellValue((double)sig.getIdResponsavel().intValue());
                idxCell = idxCell + 1;
                cell = row.createCell(idxCell.intValue());
                cell.setCellStyle(styleBase);
                cell.setCellValue((double)sig.getEstadoConservacao().charValue());
                idxCell = idxCell + 1;
                cell = row.createCell(idxCell.intValue());
                cell.setCellStyle(styleBase);
                cell.setCellValue(sig.getMaterial());
                idxCell = idxCell + 1;
                cell = row.createCell(idxCell.intValue());
                cell.setCellStyle(styleBase);
                cell.setCellValue(sig.getAmbiente());
                idxCell = idxCell + 1;
                cell = row.createCell(idxCell.intValue());
                cell.setCellStyle(styleNumerico);
                if (sig.getMedia() != null) {
                    cell.setCellValue(sig.getMedia().doubleValue());
                }
                idxCell = idxCell + 1;
                cell = row.createCell(idxCell.intValue());
                cell.setCellStyle(styleNumerico);
                if (sig.getMinimo() != null) {
                    cell.setCellValue(sig.getMinimo().doubleValue());
                }
                idxCell = idxCell + 1;
                cell = row.createCell(idxCell.intValue());
                cell.setCellStyle(styleBase);
                cell.setCellValue(sig.getLote());
                idxCell = idxCell + 1;
                cell = row.createCell(idxCell.intValue());
                cell.setCellStyle(styleBase);
                cell.setCellValue(sig.getFuncionario());
                idxCell = idxCell + 1;
                cell = row.createCell(idxCell.intValue());
                cell.setCellStyle(styleBase);
                cell.setCellValue(sig.getObservacao());
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            wb.write((OutputStream)baos);
            baos.flush();
            wb.close();
        }
        catch (IOException ioExc) {
            this.logger.error("IOExc", (Throwable)ioExc);
        }
        return baos.toByteArray();
    }
}

