/*
 * Decompiled with CFR 0.152.
 */
package br.com.sigescantt.core.spring;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.AbstractBeanFactory;
import org.springframework.stereotype.Component;

@Component
public class PropertiesAccessor {
    private static Logger logger = LoggerFactory.getLogger(PropertiesAccessor.class);
    private final AbstractBeanFactory beanFactory;
    private final Map<String, String> cache = new ConcurrentHashMap();

    protected PropertiesAccessor(AbstractBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public String getProperty(String key) {
        if (this.cache.containsKey(key)) {
            return (String)this.cache.get(key);
        }
        String foundProp = null;
        try {
            foundProp = this.beanFactory.resolveEmbeddedValue("${" + key.trim() + "}");
            this.cache.put(key, foundProp);
        }
        catch (IllegalArgumentException illExc) {
            logger.error("IllegalExc", (Throwable)illExc);
        }
        return foundProp;
    }
}

