/*
 * Decompiled with CFR 0.152.
 */
package br.com.sigescantt.apis.geral;

import br.com.sigescantt.core.beans.geral.TrechoCidade;
import br.com.sigescantt.demandas.Trecho;
import br.com.sigescantt.services.trecho.TrechoService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="Trechos v1", description="Trechos v1")
@RequestMapping(value={"/api/v1/trechos"})
@Validated
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J3\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0001\u0010\t\u001a\u00020\n2\n\b\u0001\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\b\u0001\u0010\f\u001a\u00020\rH\u0017\u00a2\u0006\u0002\u0010\u000eJ3\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00072\b\b\u0001\u0010\u0011\u001a\u00020\n2\n\b\u0001\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\b\u0001\u0010\f\u001a\u00020\rH\u0017\u00a2\u0006\u0002\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lbr/com/sigescantt/apis/geral/TrechoRestServices;", "", "trechoService", "Lbr/com/sigescantt/services/trecho/TrechoService;", "<init>", "(Lbr/com/sigescantt/services/trecho/TrechoService;)V", "findTrechos", "Lorg/springframework/data/domain/Page;", "Lbr/com/sigescantt/demandas/Trecho;", "idEmpresa", "", "idCidade", "pageable", "Lorg/springframework/data/domain/Pageable;", "(ILjava/lang/Integer;Lorg/springframework/data/domain/Pageable;)Lorg/springframework/data/domain/Page;", "findCidades", "Lbr/com/sigescantt/core/beans/geral/TrechoCidade;", "trechoId", "server"})
public class TrechoRestServices {
    @NotNull
    private final TrechoService trechoService;

    public TrechoRestServices(@NotNull TrechoService trechoService) {
        Intrinsics.checkNotNullParameter((Object)trechoService, (String)"trechoService");
        this.trechoService = trechoService;
    }

    @Operation(summary="Busca trechos", description="Retorna uma lista de trechos.")
    @ApiResponses(value={@ApiResponse(description="Lista de trechos encontrados.", responseCode="200")})
    @GetMapping
    @NotNull
    public Page<Trecho> findTrechos(@Parameter(description="ID da empresa") @RequestParam(value="idEmpresa") int idEmpresa, @Parameter(description="ID da cidade (opcional)") @RequestParam(value="idCidade", required=false) @Nullable Integer idCidade, @Parameter(description="Par\u00e2metros de pagina\u00e7\u00e3o") @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Page page = this.trechoService.findTrechos(idEmpresa, idCidade, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findTrechos(...)");
        return page;
    }

    @Operation(summary="Busca cidades de um trecho", description="Retorna uma lista de cidades.")
    @ApiResponses(value={@ApiResponse(description="Lista de cidades encontradas.", responseCode="200")})
    @GetMapping(value={"/{trechoId}/cidades"})
    @NotNull
    public Page<TrechoCidade> findCidades(@Parameter(description="ID do trecho") @PathVariable(value="trechoId") int trechoId, @Parameter(description="ID da cidade (opcional)") @RequestParam(value="idCidade", required=false) @Nullable Integer idCidade, @Parameter(description="Par\u00e2metros de pagina\u00e7\u00e3o") @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Page page = this.trechoService.findCidadesByTrecho(trechoId, idCidade, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findCidadesByTrecho(...)");
        return page;
    }
}

