/*
 * Decompiled with CFR 0.152.
 */
package br.com.sigescantt.apis.geral;

import br.com.sigescantt.core.beans.geral.Cidade;
import br.com.sigescantt.services.CadastroService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="Cidades v1", description="Cidades v1")
@RequestMapping(value={"/api/v1/cidades"})
@Validated
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J0\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\n\b\u0001\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0001\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\b\u0001\u0010\f\u001a\u00020\rH\u0017J\u0012\u0010\u000e\u001a\u00020\b2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lbr/com/sigescantt/apis/geral/CidadeRestServices;", "", "cadastroService", "Lbr/com/sigescantt/services/CadastroService;", "<init>", "(Lbr/com/sigescantt/services/CadastroService;)V", "findCidades", "Lorg/springframework/data/domain/Page;", "Lbr/com/sigescantt/core/beans/geral/Cidade;", "nome", "", "uf", "pageable", "Lorg/springframework/data/domain/Pageable;", "findCidadeById", "idCidade", "", "server"})
public class CidadeRestServices {
    @NotNull
    private final CadastroService cadastroService;

    public CidadeRestServices(@NotNull CadastroService cadastroService) {
        Intrinsics.checkNotNullParameter((Object)cadastroService, (String)"cadastroService");
        this.cadastroService = cadastroService;
    }

    @Operation(summary="Busca cidades pelo nome", description="Retorna uma lista de cidades filtradas pelo nome.")
    @ApiResponses(value={@ApiResponse(description="Lista de cidades encontradas.", responseCode="200")})
    @GetMapping
    @NotNull
    public Page<Cidade> findCidades(@Parameter(description="Nome da cidade") @RequestParam(required=false) @Nullable String nome, @Parameter(description="UF da cidade") @RequestParam(required=false) @Nullable String uf, @Parameter(description="Par\u00e2metros de pagina\u00e7\u00e3o") @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Page page = this.cadastroService.findCidades(nome, uf, null, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findCidades(...)");
        return page;
    }

    @Operation(summary="Busca cidades pelo ID", description="Busca uma cidade pelo ID.")
    @ApiResponses(value={@ApiResponse(description="Cidade encontrada.", responseCode="200"), @ApiResponse(description="Cidade n\u00e3o encontrada.", responseCode="404")})
    @GetMapping(value={"/{idCidade}"})
    @NotNull
    public Cidade findCidadeById(@PathVariable(value="idCidade") int idCidade) {
        Cidade cidade = this.cadastroService.getCidadeById(idCidade);
        Intrinsics.checkNotNullExpressionValue((Object)cidade, (String)"getCidadeById(...)");
        return cidade;
    }
}

