/*
 * Decompiled with CFR 0.152.
 */
package br.com.sigescantt.apis.ativos;

import br.com.sigescantt.apis.BaseRestService;
import br.com.sigescantt.core.beans.seguranca.PublicUser;
import br.com.sigescantt.core.beans.seguranca.Usuario;
import br.com.sigescantt.core.dto.ativos.FindDashboardItemsDTO;
import br.com.sigescantt.core.dto.ativos.FindMonitoracoesDTO;
import br.com.sigescantt.core.dto.ativos.FindMonitoracoesFxdDTO;
import br.com.sigescantt.core.dto.ativos.FindMonitoracoesOaeDTO;
import br.com.sigescantt.core.dto.ativos.FindMonitoracoesPavDTO;
import br.com.sigescantt.core.dto.ativos.FindMonitoracoesSinDTO;
import br.com.sigescantt.core.dto.ativos.FindMonitoracoesTecDTO;
import br.com.sigescantt.core.dto.ativos.SaveTipoElementoDTO;
import br.com.sigescantt.core.dto.ativos.importacao.ImportMonitoracoesDTO;
import br.com.sigescantt.core.dto.ativos.importacao.ImportMonitoracoesResponseDTO;
import br.com.sigescantt.exceptions.BusinessException;
import br.com.sigescantt.services.CadastroService;
import br.com.sigescantt.services.CoreService;
import br.com.sigescantt.services.Exceptions.ErrorCode;
import br.com.sigescantt.services.Exceptions.ErrorCodeException;
import br.com.sigescantt.services.SegurancaService;
import br.com.sigescantt.services.ativos.SigacoService;
import br.com.sigescantt.services.ativos.importacao.ImportacaoSigacoHelper;
import br.com.sigescantt.sigaco.DashboardSigacoVO;
import br.com.sigescantt.sigaco.ElementoSigaco;
import br.com.sigescantt.sigaco.FaseMonitoracao;
import br.com.sigescantt.sigaco.FaseMonitoracaoAnexo;
import br.com.sigescantt.sigaco.ImportacaoMonitoracao;
import br.com.sigescantt.sigaco.MonitoracaoAnexo;
import br.com.sigescantt.sigaco.MonitoracaoHistorico;
import br.com.sigescantt.sigaco.MonitoracaoImagem;
import br.com.sigescantt.sigaco.MonitoracaoSigaco;
import br.com.sigescantt.sigaco.PlanoAcaoElemento;
import br.com.sigescantt.sigaco.TipoElemento;
import br.com.sigescantt.sigaco.dto.StructuredMonitoracaoDesempenhoDTO;
import br.com.sigescantt.sigaco.enums.TipoAtivo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import java.io.InputStream;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.annotations.ParameterObject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@RestController
@Tag(name="Ativos v1", description="Opera\u00e7\u00f5es relacionadas a monitora\u00e7\u00e3o de ativos v1")
@RequestMapping(value={"/api/v1/ativos"})
@Validated
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0090\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ4\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0017J4\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0017J6\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u001aH\u0017J4\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0017J6\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\b\u0001\u0010\u0015\u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u001aH\u0017J4\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\b\u0001\u0010\u0015\u001a\u00020#2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0017J4\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\b\u0001\u0010\u0015\u001a\u00020%2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0017J4\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0017J4\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0017J4\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0017J=\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0001\u0010+\u001a\u0004\u0018\u00010,2\b\b\u0001\u0010\u0017\u001a\u00020\u0018H\u0017\u00a2\u0006\u0002\u0010-J=\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0001\u0010+\u001a\u0004\u0018\u00010,2\b\b\u0001\u0010\u0017\u001a\u00020\u0018H\u0017\u00a2\u0006\u0002\u0010-JU\u00100\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0001\u00101\u001a\u0004\u0018\u0001022\n\b\u0001\u00103\u001a\u0004\u0018\u00010,2\n\b\u0001\u00104\u001a\u0004\u0018\u00010,2\b\b\u0001\u0010\u0017\u001a\u00020\u0018H\u0017\u00a2\u0006\u0002\u00105J=\u00106\u001a\b\u0012\u0004\u0012\u0002070\u00112\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0001\u0010+\u001a\u0004\u0018\u00010,2\b\b\u0001\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0017\u00a2\u0006\u0002\u00108Ja\u00109\u001a\b\u0012\u0004\u0012\u00020:0\u00112\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0001\u0010;\u001a\u0004\u0018\u00010,2\n\b\u0001\u00101\u001a\u0004\u0018\u00010\u00142\n\b\u0001\u0010<\u001a\u0004\u0018\u00010,2\n\b\u0001\u0010=\u001a\u0004\u0018\u00010\u00142\b\b\u0001\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0017\u00a2\u0006\u0002\u0010>J@\u0010?\u001a\b\u0012\u0004\u0012\u00020@0\u00112\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\b\u0001\u00101\u001a\u0002022\b\b\u0001\u0010\u0015\u001a\u00020A2\b\b\u0001\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0017JS\u0010B\u001a\b\u0012\u0004\u0012\u00020@0\u00112\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\b\u0001\u00101\u001a\u0002022\n\b\u0001\u0010C\u001a\u0004\u0018\u00010,2\n\b\u0001\u0010D\u001a\u0004\u0018\u00010\u00142\b\b\u0001\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0017\u00a2\u0006\u0002\u0010EJ\u001c\u0010F\u001a\u00020G2\b\b\u0001\u0010H\u001a\u00020,2\b\b\u0001\u0010\u0019\u001a\u00020\u001aH\u0017Jg\u0010I\u001a\b\u0012\u0004\u0012\u00020G0\u00112\b\b\u0001\u0010\u0017\u001a\u00020\u00182\n\b\u0001\u0010J\u001a\u0004\u0018\u00010\u00142\n\b\u0001\u0010K\u001a\u0004\u0018\u0001022\n\b\u0001\u0010L\u001a\u0004\u0018\u00010M2\n\b\u0001\u0010N\u001a\u0004\u0018\u00010M2\u0010\b\u0001\u0010O\u001a\n\u0012\u0004\u0012\u00020,\u0018\u00010P2\u0006\u0010\u0019\u001a\u00020\u001aH\u0017\u00a2\u0006\u0002\u0010QJ\u001a\u0010R\u001a\u00020G2\b\b\u0001\u0010\u0015\u001a\u00020S2\u0006\u0010\u0019\u001a\u00020\u001aH\u0017J$\u0010T\u001a\u00020G2\b\b\u0001\u0010H\u001a\u00020,2\b\b\u0001\u0010\u0015\u001a\u00020S2\u0006\u0010\u0019\u001a\u00020\u001aH\u0017J\u001a\u0010U\u001a\u00020V2\b\b\u0001\u0010H\u001a\u00020,2\u0006\u0010\u0019\u001a\u00020\u001aH\u0017J\u00a2\u0001\u0010W\u001a\b\u0012\u0004\u0012\u00020X0\u00112\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\b\u0001\u00101\u001a\u0002022\n\b\u0001\u0010J\u001a\u0004\u0018\u00010\u00142\u0010\b\u0001\u0010Y\u001a\n\u0012\u0004\u0012\u00020,\u0018\u00010P2\u0010\b\u0001\u0010O\u001a\n\u0012\u0004\u0012\u00020,\u0018\u00010P2\u0010\b\u0001\u0010Z\u001a\n\u0012\u0004\u0012\u00020,\u0018\u00010P2\n\b\u0001\u0010[\u001a\u0004\u0018\u00010\u00142\n\b\u0001\u0010\\\u001a\u0004\u0018\u00010\u00142\u0010\b\u0001\u0010]\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010P2\b\b\u0001\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0017J8\u0010^\u001a\b\u0012\u0004\u0012\u00020\u00140P2\b\b\u0001\u0010\u0013\u001a\u00020\u00142\n\b\u0001\u0010J\u001a\u0004\u0018\u00010\u00142\n\b\u0001\u0010_\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0017J8\u0010`\u001a\b\u0012\u0004\u0012\u00020a0\u00112\b\b\u0001\u0010\u0013\u001a\u00020\u00142\n\b\u0001\u0010J\u001a\u0004\u0018\u00010\u00142\b\b\u0001\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u001aH\u0017J=\u0010b\u001a\b\u0012\u0004\u0012\u00020c0\u00112\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0001\u0010;\u001a\u0004\u0018\u00010,2\b\b\u0001\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0017\u00a2\u0006\u0002\u00108J*\u0010d\u001a\b\u0012\u0004\u0012\u00020e0P2\b\b\u0001\u0010f\u001a\u00020\u00142\b\b\u0001\u00101\u001a\u0002022\u0006\u0010\u0019\u001a\u00020\u001aH\u0017JG\u0010g\u001a\b\u0012\u0004\u0012\u00020h0P2\b\b\u0001\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u00101\u001a\u0002022\n\b\u0001\u0010;\u001a\u0004\u0018\u00010,2\n\b\u0001\u0010i\u001a\u0004\u0018\u00010,2\u0006\u0010\u0019\u001a\u00020\u001aH\u0017\u00a2\u0006\u0002\u0010jJ8\u0010k\u001a\u00020h2\b\b\u0001\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u00101\u001a\u0002022\b\b\u0001\u0010;\u001a\u00020,2\b\b\u0001\u0010l\u001a\u00020,2\u0006\u0010\u0019\u001a\u00020\u001aH\u0017J:\u0010m\u001a\u00020n2\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\b\u0001\u00101\u001a\u0002022\b\b\u0001\u0010\u0015\u001a\u00020o2\b\b\u0001\u0010p\u001a\u00020q2\u0006\u0010\u0019\u001a\u00020\u001aH\u0017J\u0012\u0010r\u001a\u00020s2\b\b\u0001\u0010t\u001a\u00020\u0014H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006u"}, d2={"Lbr/com/sigescantt/apis/ativos/AtivosV1RestServices;", "Lbr/com/sigescantt/apis/BaseRestService;", "segurancaService", "Lbr/com/sigescantt/services/SegurancaService;", "coreService", "Lbr/com/sigescantt/services/CoreService;", "cadastroService", "Lbr/com/sigescantt/services/CadastroService;", "sigacoService", "Lbr/com/sigescantt/services/ativos/SigacoService;", "importacaoSigacoHelper", "Lbr/com/sigescantt/services/ativos/importacao/ImportacaoSigacoHelper;", "<init>", "(Lbr/com/sigescantt/services/SegurancaService;Lbr/com/sigescantt/services/CoreService;Lbr/com/sigescantt/services/CadastroService;Lbr/com/sigescantt/services/ativos/SigacoService;Lbr/com/sigescantt/services/ativos/importacao/ImportacaoSigacoHelper;)V", "logger", "Lorg/slf4j/Logger;", "findMonitoracoesEdf", "Lorg/springframework/data/domain/Page;", "Lbr/com/sigescantt/sigaco/MonitoracaoSigaco;", "empresa", "", "dto", "Lbr/com/sigescantt/core/dto/ativos/FindMonitoracoesDTO;", "pageable", "Lorg/springframework/data/domain/Pageable;", "request", "Ljakarta/servlet/http/HttpServletRequest;", "findMonitoracoesTec", "Lbr/com/sigescantt/core/dto/ativos/FindMonitoracoesTecDTO;", "findMonitoracoesSin", "Lbr/com/sigescantt/core/dto/ativos/FindMonitoracoesSinDTO;", "findMonitoracoesOac", "findMonitoracoesOae", "Lbr/com/sigescantt/core/dto/ativos/FindMonitoracoesOaeDTO;", "findMonitoracoesPav", "Lbr/com/sigescantt/core/dto/ativos/FindMonitoracoesPavDTO;", "findMonitoracoesFxd", "Lbr/com/sigescantt/core/dto/ativos/FindMonitoracoesFxdDTO;", "findMonitoracoesEle", "findMonitoracoesIts", "findMonitoracoesTun", "findAnexos", "Lbr/com/sigescantt/sigaco/MonitoracaoAnexo;", "idMonitoracao", "", "(Ljakarta/servlet/http/HttpServletRequest;Ljava/lang/String;Ljava/lang/Integer;Lorg/springframework/data/domain/Pageable;)Lorg/springframework/data/domain/Page;", "findImagens", "Lbr/com/sigescantt/sigaco/MonitoracaoImagem;", "findCiclosAnteriores", "tipoAtivo", "Lbr/com/sigescantt/sigaco/enums/TipoAtivo;", "idElemento", "faseMonitoracao", "(Ljakarta/servlet/http/HttpServletRequest;Ljava/lang/String;Lbr/com/sigescantt/sigaco/enums/TipoAtivo;Ljava/lang/Integer;Ljava/lang/Integer;Lorg/springframework/data/domain/Pageable;)Lorg/springframework/data/domain/Page;", "findHistoricos", "Lbr/com/sigescantt/sigaco/MonitoracaoHistorico;", "(Ljava/lang/String;Ljava/lang/Integer;Lorg/springframework/data/domain/Pageable;Ljakarta/servlet/http/HttpServletRequest;)Lorg/springframework/data/domain/Page;", "findImportacoes", "Lbr/com/sigescantt/sigaco/ImportacaoMonitoracao;", "idFase", "status", "responsavel", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Lorg/springframework/data/domain/Pageable;Ljakarta/servlet/http/HttpServletRequest;)Lorg/springframework/data/domain/Page;", "findDashboardsItems", "Lbr/com/sigescantt/sigaco/DashboardSigacoVO;", "Lbr/com/sigescantt/core/dto/ativos/FindDashboardItemsDTO;", "findDashboardsCiclos", "idItem", "subTipo", "(Ljava/lang/String;Lbr/com/sigescantt/sigaco/enums/TipoAtivo;Ljava/lang/Integer;Ljava/lang/String;Lorg/springframework/data/domain/Pageable;Ljakarta/servlet/http/HttpServletRequest;)Lorg/springframework/data/domain/Page;", "findTipoElementoById", "Lbr/com/sigescantt/sigaco/TipoElemento;", "idCategoria", "findTiposElementos", "search", "subsistema", "isParent", "", "isChild", "idsTipoElementosPai", "", "(Lorg/springframework/data/domain/Pageable;Ljava/lang/String;Lbr/com/sigescantt/sigaco/enums/TipoAtivo;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/util/List;Ljakarta/servlet/http/HttpServletRequest;)Lorg/springframework/data/domain/Page;", "saveCategoria", "Lbr/com/sigescantt/core/dto/ativos/SaveTipoElementoDTO;", "updateCategoria", "deleteCategoria", "", "findElementos", "Lbr/com/sigescantt/sigaco/ElementoSigaco;", "idsTipoElementos", "idRodovias", "kmInicial", "kmFinal", "statusValue", "getTiposSinalizacao", "classeSinalizacao", "findFases", "Lbr/com/sigescantt/sigaco/FaseMonitoracao;", "findAnexosFase", "Lbr/com/sigescantt/sigaco/FaseMonitoracaoAnexo;", "getMonitoracoesDesempenho", "Lbr/com/sigescantt/sigaco/dto/StructuredMonitoracaoDesempenhoDTO;", "siglaEmpresa", "findPlanosAcao", "Lbr/com/sigescantt/sigaco/PlanoAcaoElemento;", "elemento", "(Ljava/lang/String;Lbr/com/sigescantt/sigaco/enums/TipoAtivo;Ljava/lang/Integer;Ljava/lang/Integer;Ljakarta/servlet/http/HttpServletRequest;)Ljava/util/List;", "getPlanoAcaoById", "sequencia", "importMonitoracoes", "Lbr/com/sigescantt/core/dto/ativos/importacao/ImportMonitoracoesResponseDTO;", "Lbr/com/sigescantt/core/dto/ativos/importacao/ImportMonitoracoesDTO;", "file", "Lorg/springframework/web/multipart/MultipartFile;", "getImportacaoProgress", "Lorg/springframework/web/servlet/mvc/method/annotation/SseEmitter;", "jobId", "server"})
public class AtivosV1RestServices
extends BaseRestService {
    @NotNull
    private final SegurancaService segurancaService;
    @NotNull
    private final CoreService coreService;
    @NotNull
    private final CadastroService cadastroService;
    @NotNull
    private final SigacoService sigacoService;
    @NotNull
    private final ImportacaoSigacoHelper importacaoSigacoHelper;
    @NotNull
    private final Logger logger;

    public AtivosV1RestServices(@NotNull SegurancaService segurancaService, @NotNull CoreService coreService, @NotNull CadastroService cadastroService, @NotNull SigacoService sigacoService, @NotNull ImportacaoSigacoHelper importacaoSigacoHelper) {
        Intrinsics.checkNotNullParameter((Object)segurancaService, (String)"segurancaService");
        Intrinsics.checkNotNullParameter((Object)coreService, (String)"coreService");
        Intrinsics.checkNotNullParameter((Object)cadastroService, (String)"cadastroService");
        Intrinsics.checkNotNullParameter((Object)sigacoService, (String)"sigacoService");
        Intrinsics.checkNotNullParameter((Object)importacaoSigacoHelper, (String)"importacaoSigacoHelper");
        super(segurancaService);
        this.segurancaService = segurancaService;
        this.coreService = coreService;
        this.cadastroService = cadastroService;
        this.sigacoService = sigacoService;
        this.importacaoSigacoHelper = importacaoSigacoHelper;
        Logger logger = LoggerFactory.getLogger(AtivosV1RestServices.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    @Operation(summary="Buscar monitora\u00e7\u00f5es de Edifica\u00e7\u00f5es", description="Retorna uma lista de monitora\u00e7\u00f5es de Edifica\u00e7\u00f5es filtradas pelos par\u00e2metros informados")
    @ApiResponses(value={@ApiResponse(description="Lista de monitora\u00e7\u00f5es de Edifica\u00e7\u00f5es encontradas", responseCode="200")})
    @GetMapping(value={"/monitoracoes/{empresa}/EDF"})
    @NotNull
    public Page<MonitoracaoSigaco> findMonitoracoesEdf(@Parameter(description="Sigla da empresa", required=true) @PathVariable @Nullable String empresa, @ParameterObject @Valid @NotNull FindMonitoracoesDTO dto, @NotNull Pageable pageable, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        Page page = this.sigacoService.findMonitoracoes(empresa, TipoAtivo.EDIFICACOES, dto, usuario2, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findMonitoracoes(...)");
        return page;
    }

    @Operation(summary="Buscar monitora\u00e7\u00f5es de Terraplenos", description="Retorna uma lista de monitora\u00e7\u00f5es de Terraplenos filtradas pelos par\u00e2metros informados")
    @ApiResponses(value={@ApiResponse(description="Lista de monitora\u00e7\u00f5es de Terraplenos encontradas", responseCode="200")})
    @GetMapping(value={"/monitoracoes/{empresa}/TEC"})
    @NotNull
    public Page<MonitoracaoSigaco> findMonitoracoesTec(@Parameter(description="Sigla da empresa", required=true) @PathVariable @Nullable String empresa, @ParameterObject @Valid @NotNull FindMonitoracoesTecDTO dto, @NotNull Pageable pageable, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        Page page = this.sigacoService.findMonitoracoes(empresa, TipoAtivo.TERRAPLENOS, (FindMonitoracoesDTO)dto, usuario2, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findMonitoracoes(...)");
        return page;
    }

    @Operation(summary="Buscar monitora\u00e7\u00f5es de Sinaliza\u00e7\u00e3o", description="Retorna uma lista de monitora\u00e7\u00f5es de Sinaliza\u00e7\u00e3o filtradas pelos par\u00e2metros informados")
    @ApiResponses(value={@ApiResponse(description="Lista de monitora\u00e7\u00f5es de Sinaliza\u00e7\u00e3o encontradas", responseCode="200")})
    @GetMapping(value={"/monitoracoes/{empresa}/SIN"})
    @NotNull
    public Page<MonitoracaoSigaco> findMonitoracoesSin(@Parameter(description="Sigla da empresa", required=true) @PathVariable @Nullable String empresa, @ParameterObject @Valid @NotNull FindMonitoracoesSinDTO dto, @NotNull Pageable pageable, @Parameter(description="Par\u00e2metros de busca espec\u00edficos para Sinaliza\u00e7\u00e3o") @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        Page page = this.sigacoService.findMonitoracoes(empresa, TipoAtivo.SINALIZACAO, (FindMonitoracoesDTO)dto, usuario2, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findMonitoracoes(...)");
        return page;
    }

    @Operation(summary="Buscar monitora\u00e7\u00f5es de Obras de Arte Corrente", description="Retorna uma lista de monitora\u00e7\u00f5es de Obras de Arte Corrente filtradas pelos par\u00e2metros informados")
    @ApiResponses(value={@ApiResponse(description="Lista de monitora\u00e7\u00f5es de Obras de Arte Corrente encontradas", responseCode="200")})
    @GetMapping(value={"/monitoracoes/{empresa}/OAC"})
    @NotNull
    public Page<MonitoracaoSigaco> findMonitoracoesOac(@Parameter(description="Sigla da empresa", required=true) @PathVariable @Nullable String empresa, @ParameterObject @Valid @NotNull FindMonitoracoesDTO dto, @NotNull Pageable pageable, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        Page page = this.sigacoService.findMonitoracoes(empresa, TipoAtivo.OBRA_ARTE_CORRENTE, dto, usuario2, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findMonitoracoes(...)");
        return page;
    }

    @Operation(summary="Buscar monitora\u00e7\u00f5es de Obras de Arte Especial", description="Retorna uma lista de monitora\u00e7\u00f5es de Obras de Arte Especial filtradas pelos par\u00e2metros informados")
    @ApiResponses(value={@ApiResponse(description="Lista de monitora\u00e7\u00f5es de Obras de Arte Especial encontradas", responseCode="200")})
    @GetMapping(value={"/monitoracoes/{empresa}/OAE"})
    @NotNull
    public Page<MonitoracaoSigaco> findMonitoracoesOae(@Parameter(description="Sigla da empresa", required=true) @PathVariable @Nullable String empresa, @ParameterObject @Valid @NotNull FindMonitoracoesOaeDTO dto, @NotNull Pageable pageable, @Parameter(description="Par\u00e2metros de busca espec\u00edficos para Obras de Arte Especial") @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        Page page = this.sigacoService.findMonitoracoes(empresa, TipoAtivo.OBRA_ARTE_ESPECIAL, (FindMonitoracoesDTO)dto, usuario2, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findMonitoracoes(...)");
        return page;
    }

    @Operation(summary="Buscar monitora\u00e7\u00f5es de Pavimento", description="Retorna uma lista de monitora\u00e7\u00f5es de Pavimento filtradas pelos par\u00e2metros informados")
    @ApiResponses(value={@ApiResponse(description="Lista de monitora\u00e7\u00f5es de Pavimento encontradas", responseCode="200")})
    @GetMapping(value={"/monitoracoes/{empresa}/PAV"})
    @NotNull
    public Page<MonitoracaoSigaco> findMonitoracoesPav(@Parameter(description="Sigla da empresa", required=true) @PathVariable @Nullable String empresa, @ParameterObject @Valid @NotNull FindMonitoracoesPavDTO dto, @NotNull Pageable pageable, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        Page page = this.sigacoService.findMonitoracoes(empresa, TipoAtivo.PAVIMENTO, (FindMonitoracoesDTO)dto, usuario2, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findMonitoracoes(...)");
        return page;
    }

    @Operation(summary="Buscar monitora\u00e7\u00f5es de Faixa de Dom\u00ednio", description="Retorna uma lista de monitora\u00e7\u00f5es de Faixa de Dom\u00ednio filtradas pelos par\u00e2metros informados")
    @ApiResponses(value={@ApiResponse(description="Lista de monitora\u00e7\u00f5es de Faixa de Dom\u00ednio encontradas", responseCode="200")})
    @GetMapping(value={"/monitoracoes/{empresa}/FXD"})
    @NotNull
    public Page<MonitoracaoSigaco> findMonitoracoesFxd(@Parameter(description="Sigla da empresa", required=true) @PathVariable @Nullable String empresa, @ParameterObject @Valid @NotNull FindMonitoracoesFxdDTO dto, @NotNull Pageable pageable, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        Page page = this.sigacoService.findMonitoracoes(empresa, TipoAtivo.FAIXA_DOMINIO, (FindMonitoracoesDTO)dto, usuario2, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findMonitoracoes(...)");
        return page;
    }

    @Operation(summary="Buscar monitora\u00e7\u00f5es de Sistemas El\u00e9tricos", description="Retorna uma lista de monitora\u00e7\u00f5es de Sistemas El\u00e9tricos filtradas pelos par\u00e2metros informados")
    @ApiResponses(value={@ApiResponse(description="Lista de monitora\u00e7\u00f5es de Sistemas El\u00e9tricos encontradas", responseCode="200")})
    @GetMapping(value={"/monitoracoes/{empresa}/ELE"})
    @NotNull
    public Page<MonitoracaoSigaco> findMonitoracoesEle(@Parameter(description="Sigla da empresa", required=true) @PathVariable @Nullable String empresa, @ParameterObject @Valid @NotNull FindMonitoracoesDTO dto, @NotNull Pageable pageable, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        Page page = this.sigacoService.findMonitoracoes(empresa, TipoAtivo.SISTEMAS_ELETRICOS, dto, usuario2, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findMonitoracoes(...)");
        return page;
    }

    @Operation(summary="Buscar monitora\u00e7\u00f5es de Equipamentos ITS", description="Retorna uma lista de monitora\u00e7\u00f5es de Equipamentos ITS filtradas pelos par\u00e2metros informados")
    @ApiResponses(value={@ApiResponse(description="Lista de monitora\u00e7\u00f5es de Equipamentos ITS encontradas", responseCode="200")})
    @GetMapping(value={"/monitoracoes/{empresa}/ITS"})
    @NotNull
    public Page<MonitoracaoSigaco> findMonitoracoesIts(@Parameter(description="Sigla da empresa", required=true) @PathVariable @Nullable String empresa, @ParameterObject @Valid @NotNull FindMonitoracoesDTO dto, @NotNull Pageable pageable, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        Page page = this.sigacoService.findMonitoracoes(empresa, TipoAtivo.ITS, dto, usuario2, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findMonitoracoes(...)");
        return page;
    }

    @Operation(summary="Buscar monitora\u00e7\u00f5es de T\u00faneis", description="Retorna uma lista de monitora\u00e7\u00f5es de T\u00faneis filtradas pelos par\u00e2metros informados")
    @ApiResponses(value={@ApiResponse(description="Lista de monitora\u00e7\u00f5es de T\u00faneis encontradas", responseCode="200")})
    @GetMapping(value={"/monitoracoes/{empresa}/TUN"})
    @NotNull
    public Page<MonitoracaoSigaco> findMonitoracoesTun(@Parameter(description="Sigla da empresa", required=true) @PathVariable @Nullable String empresa, @ParameterObject @Valid @NotNull FindMonitoracoesDTO dto, @NotNull Pageable pageable, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        Page page = this.sigacoService.findMonitoracoes(empresa, TipoAtivo.TUNEIS, dto, usuario2, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findMonitoracoes(...)");
        return page;
    }

    @Operation(summary="Buscar anexos da monitora\u00e7\u00e3o", description="Retorna lista de anexos associados a uma monitora\u00e7\u00e3o")
    @ApiResponses(value={@ApiResponse(description="Opera\u00e7\u00e3o realizada com sucesso", responseCode="200")})
    @GetMapping(value={"/monitoracoes/{empresa}/{idMonitoracao}/anexos"})
    @NotNull
    public Page<MonitoracaoAnexo> findAnexos(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="ID da monitora\u00e7\u00e3o") @PathVariable(name="idMonitoracao") @Nullable Integer idMonitoracao, @Parameter(description="Par\u00e2metros de pagina\u00e7\u00e3o") @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        Usuario usuario2 = usuario;
        Page page = this.sigacoService.findAnexosMonitoracao(empresa, idMonitoracao, usuario2, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findAnexosMonitoracao(...)");
        return page;
    }

    @Operation(summary="Buscar imagens da monitora\u00e7\u00e3o", description="Retorna lista de imagens associadas a uma monitora\u00e7\u00e3o")
    @ApiResponses(value={@ApiResponse(description="Opera\u00e7\u00e3o realizada com sucesso", responseCode="200"), @ApiResponse(description="Monitora\u00e7\u00e3o n\u00e3o encontrada", responseCode="404")})
    @GetMapping(value={"/monitoracoes/{empresa}/{idMonitoracao}/imagens"})
    @NotNull
    public Page<MonitoracaoImagem> findImagens(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="ID da monitora\u00e7\u00e3o") @PathVariable(name="idMonitoracao") @Nullable Integer idMonitoracao, @Parameter(description="Par\u00e2metros de pagina\u00e7\u00e3o") @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        Usuario usuario2 = usuario;
        Page page = this.sigacoService.findImagensMonitoracao(empresa, idMonitoracao, null, null, null, null, null, usuario2, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findImagensMonitoracao(...)");
        return page;
    }

    @Operation(summary="Buscar hist\u00f3rico de monitora\u00e7\u00f5es", description="Retorna os hist\u00f3ricos (ciclos anteriores) de uma monitora\u00e7\u00e3o")
    @ApiResponses(value={@ApiResponse(description="Hist\u00f3rico encontrado com sucesso", responseCode="200")})
    @GetMapping(value={"/monitoracoes/{empresa}/{tipoAtivo}/ciclos/{idElemento}"})
    @NotNull
    public Page<MonitoracaoSigaco> findCiclosAnteriores(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="C\u00f3digo do tipo de ativo") @PathVariable(name="tipoAtivo") @Nullable TipoAtivo tipoAtivo, @Parameter(description="ID do elemento") @PathVariable(name="idElemento") @Nullable Integer idElemento, @Parameter(description="Fase da monitora\u00e7\u00e3o") @RequestParam(name="fase") @Nullable Integer faseMonitoracao, @Parameter(description="Par\u00e2metros de pagina\u00e7\u00e3o") @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        Usuario usuario2 = usuario;
        Page page = this.sigacoService.findCiclosAnteriores(empresa, tipoAtivo, idElemento, faseMonitoracao, usuario2, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findCiclosAnteriores(...)");
        return page;
    }

    @Operation(summary="Buscar hist\u00f3ricos da monitora\u00e7\u00e3o", description="Retorna os hist\u00f3ricos de altera\u00e7\u00f5es ou eventos de uma monitora\u00e7\u00e3o")
    @ApiResponses(value={@ApiResponse(description="Hist\u00f3ricos encontrados com sucesso", responseCode="200")})
    @GetMapping(value={"/monitoracoes/{empresa}/{idMonitoracao}/historicos"})
    @NotNull
    public Page<MonitoracaoHistorico> findHistoricos(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="ID da monitora\u00e7\u00e3o") @PathVariable(name="idMonitoracao") @Nullable Integer idMonitoracao, @Parameter(description="Par\u00e2metros de pagina\u00e7\u00e3o") @NotNull Pageable pageable, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        Usuario usuario2 = usuario;
        Page page = this.sigacoService.findHistoricos(empresa, idMonitoracao, usuario2, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findHistoricos(...)");
        return page;
    }

    @Operation(summary="Buscar importa\u00e7\u00f5es de monitora\u00e7\u00f5es", description="Retorna a lista de importa\u00e7\u00f5es de monitora\u00e7\u00f5es baseado em filtros opcionais")
    @ApiResponses(value={@ApiResponse(description="Opera\u00e7\u00e3o realizada com sucesso", responseCode="200")})
    @GetMapping(value={"/monitoracoes/importacoes/{empresa}"})
    @NotNull
    public Page<ImportacaoMonitoracao> findImportacoes(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="ID da fase", required=false) @RequestParam(name="idFase", required=false) @Nullable Integer idFase, @Parameter(description="Subsistema", required=false) @RequestParam(name="subsistema", required=false) @Nullable String tipoAtivo, @Parameter(description="Status", required=false) @RequestParam(name="status", required=false) @Nullable Integer status, @Parameter(description="Respons\u00e1vel", required=false) @RequestParam(name="responsavel", required=false) @Nullable String responsavel, @Parameter(description="Par\u00e2metros de pagina\u00e7\u00e3o") @NotNull Pageable pageable, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        Usuario usuario2 = usuario;
        Page page = this.sigacoService.findImportacoes(empresa, idFase, tipoAtivo, status, responsavel, usuario2, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findImportacoes(...)");
        return page;
    }

    @Operation(summary="Buscar itens de dashboards", description="Retorna os itens dos dashboards de monitora\u00e7\u00e3o com base em filtros")
    @ApiResponses(value={@ApiResponse(description="Itens encontrados com sucesso", responseCode="200")})
    @GetMapping(value={"/monitoracoes/{empresa}/dashboards/{tipoAtivo}/itens"})
    @NotNull
    public Page<DashboardSigacoVO> findDashboardsItems(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="C\u00f3digo do tipo de ativo") @PathVariable(name="tipoAtivo") @NotNull TipoAtivo tipoAtivo, @ParameterObject @Valid @NotNull FindDashboardItemsDTO dto, @Parameter(description="Par\u00e2metros de pagina\u00e7\u00e3o") @NotNull Pageable pageable, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)tipoAtivo, (String)"tipoAtivo");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        Usuario usuario2 = usuario;
        Page page = this.sigacoService.findDashboardItens(empresa, tipoAtivo, dto, usuario2, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findDashboardItens(...)");
        return page;
    }

    @Operation(summary="Buscar ciclos de dashboards", description="Retorna os ciclos dos itens de dashboards de monitora\u00e7\u00e3o")
    @ApiResponses(value={@ApiResponse(description="Ciclos encontrados com sucesso", responseCode="200")})
    @GetMapping(value={"/monitoracoes/{empresa}/dashboards/{tipoAtivo}/ciclos/{idItem}"})
    @NotNull
    public Page<DashboardSigacoVO> findDashboardsCiclos(@Parameter(description="Sigla da empresa") @PathVariable @Nullable String empresa, @Parameter(description="C\u00f3digo do tipo de ativo") @PathVariable @NotNull TipoAtivo tipoAtivo, @Parameter(description="ID do item do dashboard") @PathVariable @Nullable Integer idItem, @Parameter(description="Subtipo") @RequestParam(required=false) @Nullable String subTipo, @Parameter(description="Par\u00e2metros de pagina\u00e7\u00e3o") @NotNull Pageable pageable, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)tipoAtivo, (String)"tipoAtivo");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        Page page = this.sigacoService.findDashboardCiclos(empresa, tipoAtivo, subTipo, idItem, usuario2, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findDashboardCiclos(...)");
        return page;
    }

    @GetMapping(value={"/cadastros/tiposElementos/{idCategoria}"})
    @Operation(summary="Retorna a categoria com base no seu identificador")
    @ApiResponses(value={@ApiResponse(description="Categoria encontrada com sucesso", responseCode="200"), @ApiResponse(description="Categoria n\u00e3o encontrada", responseCode="404")})
    @NotNull
    public TipoElemento findTipoElementoById(@Parameter(description="Identificador da categoria.") @PathVariable(name="idCategoria") int idCategoria, @Parameter(hidden=true) @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.getUsuarioByJWT(request) == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        this.logger.debug("getCategoriaById({})", (Object)idCategoria);
        TipoElemento tipoElemento = this.sigacoService.getTipoElementoById(idCategoria);
        Intrinsics.checkNotNullExpressionValue((Object)tipoElemento, (String)"getTipoElementoById(...)");
        return tipoElemento;
    }

    @GetMapping(value={"/cadastros/tiposElementos"})
    @Operation(summary="Recupera uma lista de tipos de elementos baseada em filtros (search e subsistema).")
    @ApiResponses(value={@ApiResponse(description="Sucesso", responseCode="200")})
    @NotNull
    public Page<TipoElemento> findTiposElementos(@Parameter(description="Par\u00e2metros de pagina\u00e7\u00e3o") @NotNull Pageable pageable, @Parameter(description="Par\u00e2metro de busca") @RequestParam(value="search", required=false) @Nullable String search, @Parameter(description="Tipo do ativo") @RequestParam(value="subsistema", required=false) @Nullable TipoAtivo subsistema, @Parameter(description="Boolean indicando se o elemento \u00e9 pai") @RequestParam(value="isParent", required=false) @Nullable Boolean isParent, @Parameter(description="Boolean indicando se o elemento \u00e9 filho") @RequestParam(value="isChild", required=false) @Nullable Boolean isChild, @Parameter(description="ID do tipo elememento pai") @RequestParam(value="idTipoElementoPai", required=false) @Nullable List<Integer> idsTipoElementosPai, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        Usuario usuario2 = usuario;
        Page page = this.sigacoService.findTiposElementos(search, subsistema, idsTipoElementosPai, isParent, isChild, usuario2, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findTiposElementos(...)");
        return page;
    }

    @PostMapping(value={"/cadastros/tiposElementos"})
    @Operation(summary="Salva a categoria de ativo.")
    @ApiResponses(value={@ApiResponse(description="Tipo elemento criado com sucesso", responseCode="201")})
    @NotNull
    public TipoElemento saveCategoria(@RequestBody(description="Dados da categoria de ativo a ser salva.") @org.springframework.web.bind.annotation.RequestBody @Valid @NotNull SaveTipoElementoDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        PublicUser usuario = publicUser;
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        TipoElemento tipoElemento = this.sigacoService.createTipoElemento(dto, ((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)tipoElemento, (String)"createTipoElemento(...)");
        return tipoElemento;
    }

    @PutMapping(value={"/cadastros/tiposElementos/{idCategoria}"})
    @Operation(summary="Atualiza a categoria de ativo conforme seu identificador")
    @ApiResponses(value={@ApiResponse(description="Categoria atualizada com sucesso", responseCode="200")})
    @NotNull
    public TipoElemento updateCategoria(@Parameter(description="Identificador da categoria a ser atualizada.") @PathVariable(name="idCategoria") int idCategoria, @RequestBody(description="Dados da categoria de ativo a ser atualizada.") @org.springframework.web.bind.annotation.RequestBody @Valid @NotNull SaveTipoElementoDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        PublicUser usuario = publicUser;
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        TipoElemento tipoElemento = this.sigacoService.updateTipoElemento(idCategoria, dto, ((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)tipoElemento, (String)"updateTipoElemento(...)");
        return tipoElemento;
    }

    @DeleteMapping(value={"/cadastros/tiposElementos/{idCategoria}"})
    @Operation(summary="Deleta a categoria de ativo conforme seu identificador")
    @ApiResponses(value={@ApiResponse(description="Categoria deletada com sucesso", responseCode="204")})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteCategoria(@Parameter(description="Identificador da categoria a ser removida.") @PathVariable(name="idCategoria") int idCategoria, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.getPrivateUsuarioByJWT(request) == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        this.logger.debug("deleteCategoria({})", (Object)idCategoria);
        this.sigacoService.deleteTipoElemento(idCategoria);
    }

    @GetMapping(value={"/cadastros/{empresa}/elementos/{tipoAtivo}/all"})
    @Operation(summary="Busca os itens de ativo.")
    @ApiResponses(value={@ApiResponse(description="Sucesso", responseCode="200", content={@Content(schema=@Schema(implementation=ElementoSigaco.class))})})
    @NotNull
    public Page<ElementoSigaco> findElementos(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="Tipo de ativo") @PathVariable(name="tipoAtivo") @NotNull TipoAtivo tipoAtivo, @Parameter(description="Par\u00e2metro de busca") @RequestParam(value="search", required=false) @Nullable String search, @Parameter(description="ID do Tipo do Elemento") @RequestParam(value="idTipoElemento", required=false) @Nullable List<Integer> idsTipoElementos, @Parameter(description="ID do Tipo elememento pai") @RequestParam(value="idTipoElementoPai", required=false) @Nullable List<Integer> idsTipoElementosPai, @Parameter(description="ID da rodovia") @RequestParam(value="rodovia", required=false) @Nullable List<Integer> idRodovias, @Parameter(description="Kil\u00f4metro inicial") @RequestParam(value="kmInicial", required=false) @Nullable String kmInicial, @Parameter(description="Kil\u00f4metro final") @RequestParam(value="kmFinal", required=false) @Nullable String kmFinal, @Parameter(description="Status do elemento") @RequestParam(value="status", required=false) @Nullable List<String> statusValue, @Parameter(description="Par\u00e2metros de pagina\u00e7\u00e3o") @NotNull Pageable pageable, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)tipoAtivo, (String)"tipoAtivo");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        Usuario usuario2 = usuario;
        Page page = this.sigacoService.findElementos(empresa, search, tipoAtivo, idsTipoElementos, idsTipoElementosPai, idRodovias, kmInicial, kmFinal, statusValue, usuario2, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findElementos(...)");
        return page;
    }

    @GetMapping(value={"/monitoracoes/{empresa}/SIN/tipoSinalizacao"})
    @Operation(summary="Recupera os tipos de sinaliza\u00e7\u00e3o para o tipo de ativo Sinaliza\u00e7\u00e3o.")
    @ApiResponses(value={@ApiResponse(description="Sucesso", responseCode="200")})
    @NotNull
    public List<String> getTiposSinalizacao(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa, @Parameter(description="Par\u00e2metro de busca") @RequestParam(name="search", required=false) @Nullable String search, @Parameter(description="Classe sinaliza\u00e7\u00e3o") @RequestParam(name="classeSinalizacao", required=false) @Nullable String classeSinalizacao, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.getPrivateUsuarioByJWT(request) == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        List list = this.sigacoService.getTiposSinalizacao(empresa, search, classeSinalizacao);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTiposSinalizacao(...)");
        return list;
    }

    @GetMapping(value={"/cadastros/{empresa}/fasesMonitoracao"})
    @Operation(summary="Recupera as fases de monitora\u00e7\u00e3o dos ativos, podendo aplicar um filtro via par\u00e2metro 'search'.")
    @ApiResponses(value={@ApiResponse(description="Sucesso", responseCode="200")})
    @NotNull
    public Page<FaseMonitoracao> findFases(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa, @Parameter(description="Par\u00e2metro de busca") @RequestParam(name="search", required=false) @Nullable String search, @Parameter(description="Par\u00e2metros de pagina\u00e7\u00e3o") @PageableDefault(sort={"id"}, direction=Sort.Direction.ASC) @NotNull Pageable pageable, @Parameter(hidden=true) @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        Usuario usuario2 = usuario;
        Page page = this.sigacoService.findFasesMonitoracoes(empresa, search, usuario2, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findFasesMonitoracoes(...)");
        return page;
    }

    @GetMapping(value={"/cadastros/{empresa}/fasesMonitoracao/{idFase}/anexos"})
    @Operation(summary="Recupera a lista de anexos para a fase especificada.")
    @ApiResponses(value={@ApiResponse(description="Sucesso", responseCode="200")})
    @NotNull
    public Page<FaseMonitoracaoAnexo> findAnexosFase(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="Identificador da fase") @PathVariable(name="idFase") @Nullable Integer idFase, @Parameter(description="Par\u00e2metros de pagina\u00e7\u00e3o") @NotNull Pageable pageable, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        Usuario usuario2 = usuario;
        Page page = this.sigacoService.findAnexosFase(empresa, idFase, usuario2, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findAnexosFase(...)");
        return page;
    }

    @GetMapping(value={"/monitoracoes/{siglaEmpresa}/desempenho/{tipoAtivo}"})
    @Operation(summary="Recupera as m\u00e9tricas de desempenho das monitora\u00e7\u00f5es ")
    @ApiResponses(value={@ApiResponse(description="Sucesso", responseCode="200")})
    @NotNull
    public List<StructuredMonitoracaoDesempenhoDTO> getMonitoracoesDesempenho(@PathVariable(value="siglaEmpresa") @NotNull String siglaEmpresa, @PathVariable(value="tipoAtivo") @NotNull TipoAtivo tipoAtivo, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)siglaEmpresa, (String)"siglaEmpresa");
        Intrinsics.checkNotNullParameter((Object)tipoAtivo, (String)"tipoAtivo");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        Usuario usuario2 = usuario;
        List list = this.sigacoService.getMonitoracoesDesempenho(siglaEmpresa, tipoAtivo);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getMonitoracoesDesempenho(...)");
        return list;
    }

    @Operation(summary="Buscar planos de a\u00e7\u00e3o", description="Retorna uma lista de planos de a\u00e7\u00e3o para o elemento e fase especificados")
    @ApiResponses(value={@ApiResponse(description="Lista de planos de a\u00e7\u00e3o encontrados", responseCode="200")})
    @GetMapping(value={"/planosAcoes/{empresa}/{tipoAtivo}/{idFase}"})
    @NotNull
    public List<PlanoAcaoElemento> findPlanosAcao(@Parameter(description="Sigla da empresa", required=true) @PathVariable(name="empresa") @NotNull String empresa, @Parameter(description="Tipo de ativo", required=true) @PathVariable(name="tipoAtivo") @NotNull TipoAtivo tipoAtivo, @Parameter(description="ID da fase", required=true) @PathVariable(name="idFase") @Nullable Integer idFase, @Parameter(description="ID do elemento", required=false) @RequestParam(name="elemento", required=false) @Nullable Integer elemento, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)tipoAtivo, (String)"tipoAtivo");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        Object[] objectArray = new Object[]{empresa, tipoAtivo, idFase, elemento};
        this.logger.debug("findPlanosAcao({}, {}, {}, {})", objectArray);
        List list = this.sigacoService.findPlanosAcao(empresa, tipoAtivo, idFase, elemento, usuario2);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findPlanosAcao(...)");
        return list;
    }

    @Operation(summary="Buscar plano de a\u00e7\u00e3o por identificador", description="Retorna o plano de a\u00e7\u00e3o correspondente \u00e0 empresa, tipo de ativo, fase e sequ\u00eancia informados")
    @ApiResponses(value={@ApiResponse(description="Plano de a\u00e7\u00e3o encontrado", responseCode="200"), @ApiResponse(description="Plano de a\u00e7\u00e3o n\u00e3o encontrado", responseCode="404")})
    @GetMapping(value={"/planosAcoes/{empresa}/{tipoAtivo}/{idFase}/{sequencia}"})
    @NotNull
    public PlanoAcaoElemento getPlanoAcaoById(@Parameter(description="Sigla da empresa", required=true) @PathVariable(name="empresa") @NotNull String empresa, @Parameter(description="Tipo de ativo", required=true) @PathVariable(name="tipoAtivo") @NotNull TipoAtivo tipoAtivo, @Parameter(description="ID da fase", required=true) @PathVariable(name="idFase") int idFase, @Parameter(description="Sequ\u00eancia do plano de a\u00e7\u00e3o", required=true) @PathVariable(name="sequencia") int sequencia, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)tipoAtivo, (String)"tipoAtivo");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        Object[] objectArray = new Object[]{empresa, tipoAtivo, idFase, sequencia};
        this.logger.debug("getPlanoAcaoById({}, {}, {}, {})", objectArray);
        PlanoAcaoElemento planoAcaoElemento = this.sigacoService.getPlanoAcaoById(empresa, idFase, sequencia, usuario2);
        Intrinsics.checkNotNullExpressionValue((Object)planoAcaoElemento, (String)"getPlanoAcaoById(...)");
        return planoAcaoElemento;
    }

    @PostMapping(value={"/monitoracoes/{empresa}/import/{tipoAtivo}"}, consumes={"multipart/form-data"})
    @Operation(summary="Importar monitora\u00e7\u00f5es", description="Importa uma lista de monitora\u00e7\u00f5es a partir de um arquivo XLSX")
    @ApiResponses(value={@ApiResponse(description="Importa\u00e7\u00e3o realizada com sucesso", responseCode="200")})
    @NotNull
    public ImportMonitoracoesResponseDTO importMonitoracoes(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @PathVariable(value="tipoAtivo") @NotNull TipoAtivo tipoAtivo, @RequestPart(value="body") @Valid @NotNull ImportMonitoracoesDTO dto, @RequestPart(value="file") @NotNull MultipartFile file, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)tipoAtivo, (String)"tipoAtivo");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String jobId = string;
        try {
            InputStream inputStream = file.getInputStream();
            Integer n = usuario2.getId();
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
            this.importacaoSigacoHelper.importarMonitoracoes(empresa, tipoAtivo, dto, inputStream, jobId, ((Number)n).intValue());
            return new ImportMonitoracoesResponseDTO(jobId);
        }
        catch (BusinessException e) {
            this.logger.error("Erro ao importar monitora\u00e7\u00f5es: " + e.getMessage(), (Throwable)e);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, e.getMessage());
        }
    }

    @GetMapping(value={"/monitoracoes/import/progress/{jobId}"}, produces={"text/event-stream"})
    @Operation(summary="Verificar progresso da importa\u00e7\u00e3o de monitora\u00e7\u00f5es", description="Retorna o progresso da importa\u00e7\u00e3o de monitora\u00e7\u00f5es em tempo real")
    @ApiResponses(value={@ApiResponse(description="Progresso da importa\u00e7\u00e3o retornado com sucesso", responseCode="200"), @ApiResponse(description="Job de importa\u00e7\u00e3o n\u00e3o encontrado", responseCode="404")})
    @NotNull
    public SseEmitter getImportacaoProgress(@PathVariable(value="jobId") @NotNull String jobId) {
        Intrinsics.checkNotNullParameter((Object)jobId, (String)"jobId");
        SseEmitter sseEmitter = this.importacaoSigacoHelper.registerProgressListener(jobId);
        Intrinsics.checkNotNullExpressionValue((Object)sseEmitter, (String)"registerProgressListener(...)");
        return sseEmitter;
    }
}

