/*
 * Decompiled with CFR 0.152.
 */
package br.com.sigescantt.apis.ativos;

import br.com.sigescantt.apis.BaseRestService;
import br.com.sigescantt.core.beans.geral.Empresa;
import br.com.sigescantt.core.beans.seguranca.PublicUser;
import br.com.sigescantt.core.beans.seguranca.Usuario;
import br.com.sigescantt.core.dto.ativos.FindDashboardItemsDTO;
import br.com.sigescantt.exceptions.BusinessException;
import br.com.sigescantt.ged.utils.UploadedFileInfo;
import br.com.sigescantt.reports.ExportMonitoracaoExcel;
import br.com.sigescantt.services.CadastroService;
import br.com.sigescantt.services.CoreService;
import br.com.sigescantt.services.Exceptions.ErrorCode;
import br.com.sigescantt.services.Exceptions.ErrorCodeException;
import br.com.sigescantt.services.SegurancaService;
import br.com.sigescantt.services.ativos.SigacoService;
import br.com.sigescantt.sigaco.DashboardSigacoVO;
import br.com.sigescantt.sigaco.ImportacaoMonitoracao;
import br.com.sigescantt.sigaco.MonitoracaoAnexo;
import br.com.sigescantt.sigaco.MonitoracaoDrenagem;
import br.com.sigescantt.sigaco.MonitoracaoEdificacao;
import br.com.sigescantt.sigaco.MonitoracaoFaixaDominio;
import br.com.sigescantt.sigaco.MonitoracaoHistorico;
import br.com.sigescantt.sigaco.MonitoracaoImagem;
import br.com.sigescantt.sigaco.MonitoracaoOae;
import br.com.sigescantt.sigaco.MonitoracaoPavimento;
import br.com.sigescantt.sigaco.MonitoracaoSigaco;
import br.com.sigescantt.sigaco.MonitoracaoSinalizacao;
import br.com.sigescantt.sigaco.MonitoracaoTerrapleno;
import br.com.sigescantt.sigaco.enums.TipoAtivo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(name="Ativos", description="Opera\u00e7\u00f5es relacionadas a monitora\u00e7\u00e3o de ativos")
@RequestMapping(value={"/api/monitoracoes/sigaco"})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00d2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJD\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u00192\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\b\u0001\u0010\u001e\u001a\u00020\u001f2\u0010\b\u0001\u0010 \u001a\n\u0012\u0004\u0012\u00020!\u0018\u00010\u001a2\u0006\u0010\"\u001a\u00020#H\u0017J=\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00192\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\b\u0001\u0010\u001e\u001a\u00020\u001f2\n\b\u0001\u0010%\u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#H\u0017\u00a2\u0006\u0002\u0010&J.\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00192\u0006\u0010\"\u001a\u00020#2\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\n\b\u0001\u0010(\u001a\u0004\u0018\u00010)H\u0017J.\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00192\u0006\u0010\"\u001a\u00020#2\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\n\b\u0001\u0010(\u001a\u0004\u0018\u00010*H\u0017J.\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00192\u0006\u0010\"\u001a\u00020#2\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\n\b\u0001\u0010(\u001a\u0004\u0018\u00010+H\u0017J.\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00192\u0006\u0010\"\u001a\u00020#2\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\n\b\u0001\u0010(\u001a\u0004\u0018\u00010,H\u0017J.\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00192\u0006\u0010\"\u001a\u00020#2\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\n\b\u0001\u0010(\u001a\u0004\u0018\u00010-H\u0017J.\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00192\u0006\u0010\"\u001a\u00020#2\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\n\b\u0001\u0010(\u001a\u0004\u0018\u00010.H\u0017J.\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00192\u0006\u0010\"\u001a\u00020#2\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\n\b\u0001\u0010(\u001a\u0004\u0018\u00010/H\u0017J.\u00100\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00192\u0006\u0010\"\u001a\u00020#2\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\n\b\u0001\u0010(\u001a\u0004\u0018\u00010\u001bH\u0017J=\u00101\u001a\b\u0012\u0004\u0012\u0002020\u00192\u0006\u0010\"\u001a\u00020#2\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\b\u0001\u0010\u001e\u001a\u00020\u001f2\n\b\u0001\u0010%\u001a\u0004\u0018\u00010!H\u0017\u00a2\u0006\u0002\u00103J3\u00104\u001a\b\u0012\u0004\u0012\u0002050\u001a2\u0006\u0010\"\u001a\u00020#2\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\n\b\u0001\u0010%\u001a\u0004\u0018\u00010!H\u0017\u00a2\u0006\u0002\u00106J?\u00107\u001a\b\u0012\u0004\u0012\u0002050\u00192\u0006\u0010\"\u001a\u00020#2\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\n\b\u0001\u0010%\u001a\u0004\u0018\u00010!2\n\b\u0001\u00108\u001a\u0004\u0018\u00010!H\u0017\u00a2\u0006\u0002\u00109J=\u0010:\u001a\b\u0012\u0004\u0012\u0002050\u00192\u0006\u0010\"\u001a\u00020#2\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\n\b\u0001\u0010%\u001a\u0004\u0018\u00010!2\b\b\u0001\u0010;\u001a\u00020<H\u0017\u00a2\u0006\u0002\u0010=J?\u0010>\u001a\b\u0012\u0004\u0012\u0002020\u00192\u0006\u0010\"\u001a\u00020#2\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\n\b\u0001\u0010%\u001a\u0004\u0018\u00010!2\n\b\u0001\u0010?\u001a\u0004\u0018\u00010!H\u0017\u00a2\u0006\u0002\u00109J3\u0010@\u001a\b\u0012\u0004\u0012\u00020A0\u001a2\u0006\u0010\"\u001a\u00020#2\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\n\b\u0001\u0010%\u001a\u0004\u0018\u00010!H\u0017\u00a2\u0006\u0002\u00106J?\u0010B\u001a\b\u0012\u0004\u0012\u00020A0\u00192\u0006\u0010\"\u001a\u00020#2\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\n\b\u0001\u0010%\u001a\u0004\u0018\u00010!2\n\b\u0001\u00108\u001a\u0004\u0018\u00010!H\u0017\u00a2\u0006\u0002\u00109J=\u0010C\u001a\b\u0012\u0004\u0012\u00020A0\u00192\u0006\u0010\"\u001a\u00020#2\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\n\b\u0001\u0010%\u001a\u0004\u0018\u00010!2\b\b\u0001\u0010;\u001a\u00020<H\u0017\u00a2\u0006\u0002\u0010=J?\u0010D\u001a\b\u0012\u0004\u0012\u0002020\u00192\u0006\u0010\"\u001a\u00020#2\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\n\b\u0001\u0010%\u001a\u0004\u0018\u00010!2\n\b\u0001\u0010?\u001a\u0004\u0018\u00010!H\u0017\u00a2\u0006\u0002\u00109JK\u0010E\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\"\u001a\u00020#2\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\n\b\u0001\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\n\b\u0001\u0010F\u001a\u0004\u0018\u00010!2\n\b\u0001\u0010G\u001a\u0004\u0018\u00010!H\u0017\u00a2\u0006\u0002\u0010HJ9\u0010I\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020J0\u001a0\u00192\u0006\u0010\"\u001a\u00020#2\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\n\b\u0001\u0010%\u001a\u0004\u0018\u00010!H\u0017\u00a2\u0006\u0002\u0010KJ>\u0010L\u001a\b\u0012\u0004\u0012\u00020M0\u00192\u0006\u0010\"\u001a\u00020#2\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\b\u0001\u0010\u001e\u001a\u00020\u001f2\u0010\b\u0001\u0010 \u001a\n\u0012\u0004\u0012\u00020!\u0018\u00010\u001aH\u0017J\u001f\u0010N\u001a\n\u0012\u0004\u0012\u00020P\u0018\u00010O2\b\u0010Q\u001a\u0004\u0018\u00010\u001dH\u0016\u00a2\u0006\u0002\u0010RJ]\u0010S\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020T0\u001a0\u00192\u0006\u0010\"\u001a\u00020#2\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\n\b\u0001\u0010 \u001a\u0004\u0018\u00010!2\n\b\u0001\u0010U\u001a\u0004\u0018\u00010\u001d2\n\b\u0001\u0010V\u001a\u0004\u0018\u00010!2\n\b\u0001\u0010W\u001a\u0004\u0018\u00010\u001dH\u0017\u00a2\u0006\u0002\u0010XJ?\u0010Y\u001a\b\u0012\u0004\u0012\u00020T0\u00192\u0006\u0010\"\u001a\u00020#2\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\n\b\u0001\u0010 \u001a\u0004\u0018\u00010!2\n\b\u0001\u0010Z\u001a\u0004\u0018\u00010!H\u0017\u00a2\u0006\u0002\u00109J?\u0010[\u001a\b\u0012\u0004\u0012\u0002020\u00192\u0006\u0010\"\u001a\u00020#2\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\n\b\u0001\u0010\\\u001a\u0004\u0018\u00010!2\n\b\u0001\u0010]\u001a\u0004\u0018\u00010!H\u0017\u00a2\u0006\u0002\u00109J?\u0010^\u001a\b\u0012\u0004\u0012\u0002020\u00192\u0006\u0010\"\u001a\u00020#2\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\n\b\u0001\u0010\\\u001a\u0004\u0018\u00010!2\n\b\u0001\u0010]\u001a\u0004\u0018\u00010!H\u0017\u00a2\u0006\u0002\u00109J?\u0010_\u001a\b\u0012\u0004\u0012\u0002020\u00192\u0006\u0010\"\u001a\u00020#2\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\n\b\u0001\u0010\\\u001a\u0004\u0018\u00010!2\n\b\u0001\u0010]\u001a\u0004\u0018\u00010!H\u0017\u00a2\u0006\u0002\u00109J?\u0010`\u001a\b\u0012\u0004\u0012\u0002020\u00192\u0006\u0010\"\u001a\u00020#2\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\n\b\u0001\u0010\\\u001a\u0004\u0018\u00010!2\n\b\u0001\u0010]\u001a\u0004\u0018\u00010!H\u0017\u00a2\u0006\u0002\u00109J?\u0010a\u001a\b\u0012\u0004\u0012\u0002020\u00192\u0006\u0010\"\u001a\u00020#2\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\n\b\u0001\u0010\\\u001a\u0004\u0018\u00010!2\n\b\u0001\u0010]\u001a\u0004\u0018\u00010!H\u0017\u00a2\u0006\u0002\u00109J>\u0010b\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020d0\u001a0c0\u00192\u0006\u0010\"\u001a\u00020#2\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\b\u0001\u0010\u001e\u001a\u00020\u001fH\u0017J,\u0010e\u001a\b\u0012\u0004\u0012\u00020d0\u001a2\u0006\u0010\"\u001a\u00020#2\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\b\u0001\u0010\u001e\u001a\u00020\u001fH\u0017J=\u0010f\u001a\b\u0012\u0004\u0012\u00020d0\u001a2\u0006\u0010\"\u001a\u00020#2\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\b\u0001\u0010\u001e\u001a\u00020\u001f2\n\b\u0001\u0010g\u001a\u0004\u0018\u00010!H\u0017\u00a2\u0006\u0002\u0010hR\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006i"}, d2={"Lbr/com/sigescantt/apis/ativos/AtivosRestServices;", "Lbr/com/sigescantt/apis/BaseRestService;", "segurancaService", "Lbr/com/sigescantt/services/SegurancaService;", "coreService", "Lbr/com/sigescantt/services/CoreService;", "cadastroService", "Lbr/com/sigescantt/services/CadastroService;", "sigacoService", "Lbr/com/sigescantt/services/ativos/SigacoService;", "<init>", "(Lbr/com/sigescantt/services/SegurancaService;Lbr/com/sigescantt/services/CoreService;Lbr/com/sigescantt/services/CadastroService;Lbr/com/sigescantt/services/ativos/SigacoService;)V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "ptBR", "Ljava/util/Locale;", "getPtBR", "()Ljava/util/Locale;", "fmtPtBr", "Ljava/text/NumberFormat;", "getFmtPtBr", "()Ljava/text/NumberFormat;", "findMonitoracoes", "Lorg/springframework/http/ResponseEntity;", "", "Lbr/com/sigescantt/sigaco/MonitoracaoSigaco;", "empresa", "", "tipoAtivo", "Lbr/com/sigescantt/sigaco/enums/TipoAtivo;", "idFase", "", "request", "Ljakarta/servlet/http/HttpServletRequest;", "getMonitoracaoById", "idMonitoracao", "(Ljava/lang/String;Lbr/com/sigescantt/sigaco/enums/TipoAtivo;Ljava/lang/Integer;Ljakarta/servlet/http/HttpServletRequest;)Lorg/springframework/http/ResponseEntity;", "saveMonitoracao", "monitoracao", "Lbr/com/sigescantt/sigaco/MonitoracaoDrenagem;", "Lbr/com/sigescantt/sigaco/MonitoracaoSinalizacao;", "Lbr/com/sigescantt/sigaco/MonitoracaoPavimento;", "Lbr/com/sigescantt/sigaco/MonitoracaoTerrapleno;", "Lbr/com/sigescantt/sigaco/MonitoracaoFaixaDominio;", "Lbr/com/sigescantt/sigaco/MonitoracaoOae;", "Lbr/com/sigescantt/sigaco/MonitoracaoEdificacao;", "updateMonitoracao", "deleteMonitoracao", "", "(Ljakarta/servlet/http/HttpServletRequest;Ljava/lang/String;Lbr/com/sigescantt/sigaco/enums/TipoAtivo;Ljava/lang/Integer;)Lorg/springframework/http/ResponseEntity;", "findImagens", "Lbr/com/sigescantt/sigaco/MonitoracaoImagem;", "(Ljakarta/servlet/http/HttpServletRequest;Ljava/lang/String;Ljava/lang/Integer;)Ljava/util/List;", "getImagemById", "sequencia", "(Ljakarta/servlet/http/HttpServletRequest;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;)Lorg/springframework/http/ResponseEntity;", "saveImagem", "file", "Lorg/springframework/web/multipart/MultipartFile;", "(Ljakarta/servlet/http/HttpServletRequest;Ljava/lang/String;Ljava/lang/Integer;Lorg/springframework/web/multipart/MultipartFile;)Lorg/springframework/http/ResponseEntity;", "deleteImagemMonitoracao", "seqAnexo", "findAnexos", "Lbr/com/sigescantt/sigaco/MonitoracaoAnexo;", "getAnexoById", "saveAnexo", "deleteAnexoMonitoracao", "findCiclosAnteriores", "idElemento", "faseMonitoracao", "(Ljakarta/servlet/http/HttpServletRequest;Ljava/lang/String;Lbr/com/sigescantt/sigaco/enums/TipoAtivo;Ljava/lang/Integer;Ljava/lang/Integer;)Ljava/util/List;", "findHistoricos", "Lbr/com/sigescantt/sigaco/MonitoracaoHistorico;", "(Ljakarta/servlet/http/HttpServletRequest;Ljava/lang/String;Ljava/lang/Integer;)Lorg/springframework/http/ResponseEntity;", "exportExcel", "", "stringToKm", "", "", "cellValue", "(Ljava/lang/String;)[Ljava/lang/Double;", "findImportacoes", "Lbr/com/sigescantt/sigaco/ImportacaoMonitoracao;", "subsistema", "status", "responsavel", "(Ljakarta/servlet/http/HttpServletRequest;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;)Lorg/springframework/http/ResponseEntity;", "getImportacaoById", "seqImportacao", "aprovarImportacoes", "fase", "importacao", "reprovarImportacoes", "publicarImportacoes", "reprovarPublicacoes", "deleteImportacoes", "findDashboards", "", "Lbr/com/sigescantt/sigaco/DashboardSigacoVO;", "findDashboardsItems", "findDashboardsCiclos", "idItem", "(Ljakarta/servlet/http/HttpServletRequest;Ljava/lang/String;Lbr/com/sigescantt/sigaco/enums/TipoAtivo;Ljava/lang/Integer;)Ljava/util/List;", "server"})
@SourceDebugExtension(value={"SMAP\nAtivosRestServices.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AtivosRestServices.kt\nbr/com/sigescantt/apis/ativos/AtivosRestServices\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,1652:1\n108#2:1653\n80#2,22:1654\n108#2:1676\n80#2,22:1677\n108#2:1699\n80#2,22:1700\n108#2:1761\n80#2,22:1762\n108#2:1784\n80#2,22:1785\n739#3,9:1722\n739#3,9:1735\n739#3,9:1748\n37#4:1731\n36#4,3:1732\n37#4:1744\n36#4,3:1745\n37#4:1757\n36#4,3:1758\n*S KotlinDebug\n*F\n+ 1 AtivosRestServices.kt\nbr/com/sigescantt/apis/ativos/AtivosRestServices\n*L\n127#1:1653\n127#1:1654,22\n172#1:1676\n172#1:1677,22\n1084#1:1699\n1084#1:1700,22\n1551#1:1761\n1551#1:1762,22\n1553#1:1784\n1553#1:1785,22\n1160#1:1722,9\n1168#1:1735,9\n1175#1:1748,9\n1160#1:1731\n1160#1:1732,3\n1168#1:1744\n1168#1:1745,3\n1175#1:1757\n1175#1:1758,3\n*E\n"})
public class AtivosRestServices
extends BaseRestService {
    @NotNull
    private final SegurancaService segurancaService;
    @NotNull
    private final CoreService coreService;
    @NotNull
    private final CadastroService cadastroService;
    @NotNull
    private final SigacoService sigacoService;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Locale ptBR;
    @NotNull
    private final NumberFormat fmtPtBr;

    public AtivosRestServices(@NotNull SegurancaService segurancaService, @NotNull CoreService coreService, @NotNull CadastroService cadastroService, @NotNull SigacoService sigacoService) {
        Intrinsics.checkNotNullParameter((Object)segurancaService, (String)"segurancaService");
        Intrinsics.checkNotNullParameter((Object)coreService, (String)"coreService");
        Intrinsics.checkNotNullParameter((Object)cadastroService, (String)"cadastroService");
        Intrinsics.checkNotNullParameter((Object)sigacoService, (String)"sigacoService");
        super(segurancaService);
        this.segurancaService = segurancaService;
        this.coreService = coreService;
        this.cadastroService = cadastroService;
        this.sigacoService = sigacoService;
        Logger logger = LoggerFactory.getLogger(AtivosRestServices.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
        Locale locale = new Locale.Builder().setLanguage("pt").setRegion("BR").build();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"build(...)");
        this.ptBR = locale;
        NumberFormat numberFormat = DecimalFormat.getNumberInstance(this.getPtBR());
        Intrinsics.checkNotNullExpressionValue((Object)numberFormat, (String)"getNumberInstance(...)");
        this.fmtPtBr = numberFormat;
    }

    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public Locale getPtBR() {
        return this.ptBR;
    }

    @NotNull
    public NumberFormat getFmtPtBr() {
        return this.fmtPtBr;
    }

    /*
     * WARNING - void declaration
     */
    @Operation(summary="Buscar monitora\u00e7\u00f5es", description="Retorna lista de monitora\u00e7\u00f5es filtradas por empresa e tipo de ativo")
    @ApiResponses(value={@ApiResponse(description="Opera\u00e7\u00e3o realizada com sucesso", responseCode="200")})
    @GetMapping(value={"/{empresa}/{tipoAtivo}/all"})
    @NotNull
    public ResponseEntity<List<MonitoracaoSigaco>> findMonitoracoes(@Parameter(description="Sigla da empresa", required=true) @PathVariable @Nullable String empresa, @Parameter(description="C\u00f3digo do tipo de ativo", required=true) @PathVariable @NotNull TipoAtivo tipoAtivo, @Parameter(description="ID da fase de monitora\u00e7\u00e3o", required=false) @RequestParam(value="faseMonitoracao", required=false) @Nullable List<Integer> idFase, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)tipoAtivo, (String)"tipoAtivo");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        SegurancaService segurancaService = this.segurancaService;
        Intrinsics.checkNotNull((Object)segurancaService);
        Usuario usuario2 = segurancaService.getUsuarioByLoginOrMail(usuario.getLogin());
        if (usuario2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        Usuario usr = usuario2;
        try {
            Double[] kmMetros;
            ArrayList<Object> arrayList;
            Object iteParm;
            this.getLogger().debug("findMonitoracoes({}, {})", (Object)empresa, (Object)tipoAtivo);
            Empresa empresa2 = this.coreService.getEmpresaBySigla(empresa);
            if (empresa2 == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            Empresa empresaDB = empresa2;
            Integer idCategoria = null;
            String situacao = null;
            String param = null;
            List rodovias = null;
            Double kmInicial = null;
            Double kmFinal = null;
            Integer faixa = null;
            String sentido = null;
            Object[] params = request.getParameterValues("rodovias");
            if (params != null && params.length > 0) {
                rodovias = new ArrayList();
                Iterator iterator = ArrayIteratorKt.iterator((Object[])params);
                while (iterator.hasNext()) {
                    iteParm = (String)iterator.next();
                    ArrayList arrayList2 = (ArrayList)rodovias;
                    String string = iteParm;
                    Intrinsics.checkNotNull((Object)string);
                    arrayList2.add(Integer.parseInt(string));
                }
            }
            if ((param = request.getParameter("categoria")) != null) {
                idCategoria = Integer.parseInt(param);
            }
            ArrayList<Object> categoriasId = new ArrayList<Object>();
            params = request.getParameterValues("categorias");
            if (params != null && params.length > 0) {
                iteParm = ArrayIteratorKt.iterator((Object[])params);
                while (iteParm.hasNext()) {
                    void $this$trim$iv;
                    String iteParm2;
                    String string = iteParm2 = (String)iteParm.next();
                    Intrinsics.checkNotNull((Object)string);
                    CharSequence charSequence = string;
                    if (!new Regex("^[+-]?\\d+$").matches(charSequence)) continue;
                    charSequence = iteParm2;
                    arrayList = categoriasId;
                    boolean $i$f$trim = false;
                    CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                    boolean $i$f$trim2 = false;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it = $this$trim$iv$iv.charAt(index$iv$iv);
                        boolean bl = false;
                        boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    arrayList.add(Integer.parseInt(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()));
                }
            }
            if ((kmMetros = this.stringToKm(request.getParameter("kmInicial"))) != null && kmMetros.length > 0) {
                kmInicial = kmMetros[0] + kmMetros[1];
            }
            if ((kmMetros = this.stringToKm(request.getParameter("kmFinal"))) != null && kmMetros.length > 0) {
                kmFinal = kmMetros[0] + kmMetros[1];
            }
            if ((param = request.getParameter("faixa")) != null) {
                faixa = Integer.parseInt(param);
            }
            sentido = request.getParameter("sentido");
            situacao = request.getParameter("situacao");
            String classeSinalizacao = request.getParameter("classeSinalizacao");
            String variavel = null;
            String varIni = null;
            String varFim = null;
            String tipoAcesso = null;
            Integer seqImportacao = null;
            param = request.getParameter("importacao");
            if (param != null) {
                seqImportacao = Integer.parseInt(param);
            }
            Integer statusImportacao = null;
            param = request.getParameter("statusImportacao");
            if (param != null) {
                statusImportacao = Integer.parseInt(param);
            }
            if (usr.getIdPoderConcedente() != null && empresaDB.getIdPoderConcedente() != null && usr.isExterno().booleanValue() && Intrinsics.areEqual((Object)usr.getIdPoderConcedente(), (Object)empresaDB.getIdPoderConcedente())) {
                statusImportacao = 2;
            }
            tipoAcesso = request.getParameter("tipoAcesso");
            HashMap extParams = new HashMap();
            if (request.getParameter("calcularSnv") != null) {
                ((Map)extParams).put("calcularSnv", request.getParameter("calcularSnv"));
            }
            ArrayList tiposSinalizacao = new ArrayList();
            params = request.getParameterValues("tipoSinalizacao");
            if (params != null && params.length > 0) {
                Iterator match$iv$iv = ArrayIteratorKt.iterator((Object[])params);
                while (match$iv$iv.hasNext()) {
                    void $this$trim$iv;
                    String iteParm3 = (String)match$iv$iv.next();
                    Intrinsics.checkNotNull((Object)iteParm3);
                    arrayList = tiposSinalizacao;
                    boolean $i$f$trim = false;
                    CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                    boolean $i$f$trim3 = false;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv2;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it = $this$trim$iv$iv.charAt(index$iv$iv);
                        boolean bl = false;
                        boolean bl3 = match$iv$iv2 = Intrinsics.compare((int)it, (int)32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv2) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv2) break;
                        --endIndex$iv$iv;
                    }
                    arrayList.add(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
                }
                ((Map)extParams).put("tiposSinalizacao", tiposSinalizacao);
            }
            if (request.getParameter("notaTecnicaGeral") != null) {
                ((Map)extParams).put("notaTecnicaGeral", request.getParameter("notaTecnicaGeral"));
            }
            if (request.getParameter("tipoPelicula") != null) {
                ((Map)extParams).put("tipoPelicula", request.getParameter("tipoPelicula"));
            }
            if (request.getParameter("situacao") != null) {
                ((Map)extParams).put("situacao", request.getParameter("situacao"));
            }
            List rows = this.sigacoService.findMonitoracoes(empresa, tipoAtivo, idCategoria, (List)categoriasId, idFase, rodovias, kmInicial, kmFinal, faixa, sentido, situacao, classeSinalizacao, variavel, varIni, varFim, tipoAcesso, seqImportacao, statusImportacao, null, null, (Map)extParams);
            for (MonitoracaoSigaco row : rows) {
                if (row.getElemento() == null) continue;
                row.getElemento().setTipoElemento(null);
                row.getElemento().setRodovia(null);
                row.setAnexos(null);
                row.setImportacao(null);
                if (row.getRodovia() == null) continue;
                row.getRodovia().setEmpresa(null);
            }
            ResponseEntity responseEntity = ResponseEntity.ok().body((Object)rows);
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            this.getLogger().error("BizExc.findMonitoracoes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @Operation(summary="Buscar monitora\u00e7\u00e3o por ID", description="Retorna uma monitora\u00e7\u00e3o espec\u00edfica pelo seu identificador")
    @ApiResponses(value={@ApiResponse(description="Monitora\u00e7\u00e3o encontrada", responseCode="200"), @ApiResponse(description="Monitora\u00e7\u00e3o n\u00e3o encontrada", responseCode="404")})
    @GetMapping(value={"/{empresa}/{tipoAtivo}/{idMonitoracao}"})
    @NotNull
    public ResponseEntity<MonitoracaoSigaco> getMonitoracaoById(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="C\u00f3digo do tipo de ativo") @PathVariable(name="tipoAtivo") @NotNull TipoAtivo tipoAtivo, @Parameter(description="ID da monitora\u00e7\u00e3o") @PathVariable(name="idMonitoracao") @Nullable Integer idMonitoracao, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)tipoAtivo, (String)"tipoAtivo");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.getLogger().debug("getMonitoracaoById({}, {})", (Object)empresa, (Object)idMonitoracao);
            HashMap extParams = new HashMap();
            if (request.getParameter("calcularSnv") != null) {
                ((Map)extParams).put("calcularSnv", request.getParameter("calcularSnv"));
            }
            ResponseEntity.BodyBuilder bodyBuilder = ResponseEntity.ok();
            SigacoService sigacoService = this.sigacoService;
            Intrinsics.checkNotNull((Object)sigacoService);
            ResponseEntity responseEntity = bodyBuilder.body((Object)sigacoService.getMonitoracaoById(empresa, idMonitoracao, tipoAtivo, (Map)extParams));
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            this.getLogger().error("BizExc.getMonitoracaoById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @Operation(summary="Salvar monitora\u00e7\u00e3o de drenagem", description="Cria ou atualiza uma monitora\u00e7\u00e3o do tipo drenagem")
    @ApiResponses(value={@ApiResponse(description="Monitora\u00e7\u00e3o criada com sucesso", responseCode="201")})
    @PostMapping(value={"/{empresa}/drenagens"})
    @NotNull
    public ResponseEntity<MonitoracaoSigaco> saveMonitoracao(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="Dados da monitora\u00e7\u00e3o de drenagem") @RequestBody @Nullable MonitoracaoDrenagem monitoracao) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            SigacoService sigacoService = this.sigacoService;
            Intrinsics.checkNotNull((Object)sigacoService);
            MonitoracaoSigaco monitoracaoDB = sigacoService.saveMonitoracao(empresa, (MonitoracaoSigaco)monitoracao, usuario.getLogin());
            ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.CREATED)).body((Object)monitoracaoDB);
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            this.getLogger().error("BizExc.saveMonitoracao[DRE]", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @Operation(summary="Salvar monitora\u00e7\u00e3o de sinaliza\u00e7\u00e3o", description="Cria ou atualiza uma monitora\u00e7\u00e3o do tipo sinaliza\u00e7\u00e3o")
    @ApiResponses(value={@ApiResponse(description="Monitora\u00e7\u00e3o criada com sucesso", responseCode="201")})
    @PostMapping(value={"/{empresa}/sinalizacoes"})
    @NotNull
    public ResponseEntity<MonitoracaoSigaco> saveMonitoracao(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="Dados da monitora\u00e7\u00e3o de sinaliza\u00e7\u00e3o") @RequestBody @Nullable MonitoracaoSinalizacao monitoracao) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            SigacoService sigacoService = this.sigacoService;
            Intrinsics.checkNotNull((Object)sigacoService);
            MonitoracaoSigaco monitoracaoDB = sigacoService.saveMonitoracao(empresa, (MonitoracaoSigaco)monitoracao, usuario.getLogin());
            ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.CREATED)).body((Object)monitoracaoDB);
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            this.getLogger().error("BizExc.saveMonitoracao[SNH]", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @Operation(summary="Salvar monitora\u00e7\u00e3o de pavimentos", description="Cria ou atualiza uma monitora\u00e7\u00e3o do tipo pavimentos")
    @ApiResponses(value={@ApiResponse(description="Monitora\u00e7\u00e3o criada com sucesso", responseCode="201")})
    @PostMapping(value={"/{empresa}/pavimentos"})
    @NotNull
    public ResponseEntity<MonitoracaoSigaco> saveMonitoracao(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="Dados da monitora\u00e7\u00e3o de pavimentos") @RequestBody @Nullable MonitoracaoPavimento monitoracao) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            SigacoService sigacoService = this.sigacoService;
            Intrinsics.checkNotNull((Object)sigacoService);
            MonitoracaoSigaco monitoracaoDB = sigacoService.saveMonitoracao(empresa, (MonitoracaoSigaco)monitoracao, usuario.getLogin());
            ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.CREATED)).body((Object)monitoracaoDB);
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            this.getLogger().error("BizExc.saveMonitoracao[SNV]", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @Operation(summary="Salvar monitora\u00e7\u00e3o de terraplenos", description="Cria ou atualiza uma monitora\u00e7\u00e3o do tipo terraplenos")
    @ApiResponses(value={@ApiResponse(description="Monitora\u00e7\u00e3o criada com sucesso", responseCode="201")})
    @PostMapping(value={"/{empresa}/terraplenos"})
    @NotNull
    public ResponseEntity<MonitoracaoSigaco> saveMonitoracao(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="Dados da monitora\u00e7\u00e3o de terraplenos") @RequestBody @Nullable MonitoracaoTerrapleno monitoracao) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            SigacoService sigacoService = this.sigacoService;
            Intrinsics.checkNotNull((Object)sigacoService);
            MonitoracaoSigaco monitoracaoDB = sigacoService.saveMonitoracao(empresa, (MonitoracaoSigaco)monitoracao, usuario.getLogin());
            ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.CREATED)).body((Object)monitoracaoDB);
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            this.getLogger().error("BizExc.saveMonitoracao[SNV]", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @Operation(summary="Salvar monitora\u00e7\u00e3o de faixa de dom\u00ednio", description="Cria ou atualiza uma monitora\u00e7\u00e3o do tipo faixa de dom\u00ednio")
    @ApiResponses(value={@ApiResponse(description="Monitora\u00e7\u00e3o criada com sucesso", responseCode="201")})
    @PostMapping(value={"/{empresa}/faixasDominio"})
    @NotNull
    public ResponseEntity<MonitoracaoSigaco> saveMonitoracao(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="Dados da monitora\u00e7\u00e3o de faixa de dom\u00ednio") @RequestBody @Nullable MonitoracaoFaixaDominio monitoracao) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            SigacoService sigacoService = this.sigacoService;
            Intrinsics.checkNotNull((Object)sigacoService);
            MonitoracaoSigaco monitoracaoDB = sigacoService.saveMonitoracao(empresa, (MonitoracaoSigaco)monitoracao, usuario.getLogin());
            ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.CREATED)).body((Object)monitoracaoDB);
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            this.getLogger().error("BizExc.saveMonitoracao[Faixa de dom\u00ednio]", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @Operation(summary="Salvar monitora\u00e7\u00e3o de obra de arte especial", description="Cria ou atualiza uma monitora\u00e7\u00e3o do tipo obra de arte especial")
    @ApiResponses(value={@ApiResponse(description="Monitora\u00e7\u00e3o criada com sucesso", responseCode="201")})
    @PostMapping(value={"/{empresa}/obrasArteEspeciais"})
    @NotNull
    public ResponseEntity<MonitoracaoSigaco> saveMonitoracao(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="Dados da monitora\u00e7\u00e3o de obra de arte especial") @RequestBody @Nullable MonitoracaoOae monitoracao) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            SigacoService sigacoService = this.sigacoService;
            Intrinsics.checkNotNull((Object)sigacoService);
            MonitoracaoSigaco monitoracaoDB = sigacoService.saveMonitoracao(empresa, (MonitoracaoSigaco)monitoracao, usuario.getLogin());
            ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.CREATED)).body((Object)monitoracaoDB);
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            this.getLogger().error("BizExc.saveMonitoracao[Obra de Arte Especial]", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @Operation(summary="Salvar monitora\u00e7\u00e3o de edifica\u00e7\u00f5es", description="Cria ou atualiza uma monitora\u00e7\u00e3o do tipo edifica\u00e7\u00f5es")
    @ApiResponses(value={@ApiResponse(description="Monitora\u00e7\u00e3o criada com sucesso", responseCode="201")})
    @PostMapping(value={"/{empresa}/edificacoes"})
    @NotNull
    public ResponseEntity<MonitoracaoSigaco> saveMonitoracao(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="Dados da monitora\u00e7\u00e3o de edifica\u00e7\u00f5es") @RequestBody @Nullable MonitoracaoEdificacao monitoracao) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            SigacoService sigacoService = this.sigacoService;
            Intrinsics.checkNotNull((Object)sigacoService);
            MonitoracaoSigaco monitoracaoDB = sigacoService.saveMonitoracao(empresa, (MonitoracaoSigaco)monitoracao, usuario.getLogin());
            ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.CREATED)).body((Object)monitoracaoDB);
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            this.getLogger().error("BizExc.saveMonitoracao[Edifica\u00e7\u00f5es]", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @Operation(summary="Atualizar monitora\u00e7\u00e3o", description="Atualiza uma monitora\u00e7\u00e3o existente")
    @ApiResponses(value={@ApiResponse(description="Monitora\u00e7\u00e3o atualizada com sucesso", responseCode="201")})
    @PutMapping(value={"/{empresa}"})
    @NotNull
    public ResponseEntity<MonitoracaoSigaco> updateMonitoracao(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="Dados da monitora\u00e7\u00e3o a ser atualizada") @RequestBody @Nullable MonitoracaoSigaco monitoracao) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            SigacoService sigacoService = this.sigacoService;
            Intrinsics.checkNotNull((Object)sigacoService);
            MonitoracaoSigaco monitoracaoDB = sigacoService.saveMonitoracao(empresa, monitoracao, usuario.getLogin());
            ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.CREATED)).body((Object)monitoracaoDB);
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            this.getLogger().error("BizExc.updateMonitoracao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @Operation(summary="Excluir monitora\u00e7\u00e3o", description="Remove uma monitora\u00e7\u00e3o espec\u00edfica")
    @ApiResponses(value={@ApiResponse(description="Monitora\u00e7\u00e3o exclu\u00edda com sucesso", responseCode="200"), @ApiResponse(description="Monitora\u00e7\u00e3o n\u00e3o encontrada", responseCode="404")})
    @DeleteMapping(value={"/{empresa}/{tipoAtivo}/{idMonitoracao}"})
    @NotNull
    public ResponseEntity<Boolean> deleteMonitoracao(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="C\u00f3digo do tipo de ativo") @PathVariable(name="tipoAtivo") @NotNull TipoAtivo tipoAtivo, @Parameter(description="ID da monitora\u00e7\u00e3o") @PathVariable(name="idMonitoracao") @Nullable Integer idMonitoracao) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)tipoAtivo, (String)"tipoAtivo");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            return new ResponseEntity((Object)this.sigacoService.deleteMonitoracao(empresa, idMonitoracao, tipoAtivo), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.getLogger().error("BizExc.deleteMonitoracao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @Operation(summary="Buscar imagens da monitora\u00e7\u00e3o", description="Retorna lista de imagens associadas a uma monitora\u00e7\u00e3o")
    @ApiResponses(value={@ApiResponse(description="Opera\u00e7\u00e3o realizada com sucesso", responseCode="200"), @ApiResponse(description="Monitora\u00e7\u00e3o n\u00e3o encontrada", responseCode="404")})
    @GetMapping(value={"/{empresa}/{idMonitoracao}/imagens"})
    @NotNull
    public List<MonitoracaoImagem> findImagens(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="ID da monitora\u00e7\u00e3o") @PathVariable(name="idMonitoracao") @Nullable Integer idMonitoracao) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        List list = this.sigacoService.findImagensMonitoracao(empresa, idMonitoracao, null, null, null, null, null, usuario2, Pageable.unpaged()).getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContent(...)");
        return list;
    }

    @Operation(summary="Buscar imagem por ID", description="Retorna a imagem da monitora\u00e7\u00e3o a partir do seu identificador")
    @ApiResponses(value={@ApiResponse(description="Imagem encontrada", responseCode="200"), @ApiResponse(description="Imagem n\u00e3o encontrada", responseCode="404")})
    @GetMapping(value={"/{empresa}/{idMonitoracao}/imagens/{sequencia}"})
    @NotNull
    public ResponseEntity<MonitoracaoImagem> getImagemById(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="ID da monitora\u00e7\u00e3o") @PathVariable(name="idMonitoracao") @Nullable Integer idMonitoracao, @Parameter(description="Sequ\u00eancia da imagem") @PathVariable(name="sequencia") @Nullable Integer sequencia) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.getLogger().debug("getImagemById({}, {})", (Object)empresa, (Object)idMonitoracao);
            return new ResponseEntity((Object)this.sigacoService.getImagemMonitoracaoById(empresa, idMonitoracao, sequencia), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.getLogger().error("BizExc.getImagemById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @Operation(summary="Salvar imagem da monitora\u00e7\u00e3o", description="Realiza o upload de uma imagem para uma monitora\u00e7\u00e3o, recebendo multipart/form-data com os par\u00e2metros de arquivo")
    @ApiResponses(value={@ApiResponse(description="Imagem salva com sucesso", responseCode="201")})
    @PostMapping(value={"/{empresa}/{idMonitoracao}/imagens"}, consumes={"multipart/form-data"})
    @ResponseBody
    @NotNull
    public ResponseEntity<MonitoracaoImagem> saveImagem(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="ID da monitora\u00e7\u00e3o") @PathVariable(name="idMonitoracao") @Nullable Integer idMonitoracao, @Parameter(description="Arquivo de imagem enviado") @RequestParam(name="file", required=false) @NotNull MultipartFile file) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.getLogger().debug("Executando saveImagem(emp={},idMonitoracao={})...", (Object)empresa, (Object)idMonitoracao);
        try {
            Map formData = request.getParameterMap();
            String tipoAtivo = null;
            String tipoMovto = null;
            String tipoImagem = null;
            if (formData.containsKey("tipoAtivo")) {
                Object v = formData.get("tipoAtivo");
                Intrinsics.checkNotNull(v);
                tipoAtivo = ((String[])v)[0];
            }
            if (formData.containsKey("tipoMovimento")) {
                Object v = formData.get("tipoMovimento");
                Intrinsics.checkNotNull(v);
                tipoMovto = ((String[])v)[0];
            }
            if (formData.containsKey("tipoImagem")) {
                Object v = formData.get("tipoImagem");
                Intrinsics.checkNotNull(v);
                tipoImagem = ((String[])v)[0];
            }
            UploadedFileInfo fileInfo = new UploadedFileInfo(file.getOriginalFilename(), file.getContentType(), Long.valueOf(file.getSize()), file.getInputStream());
            MonitoracaoImagem imagemDB = this.sigacoService.saveImagemMonitoracao(empresa, idMonitoracao, tipoAtivo, tipoImagem, tipoMovto, fileInfo, usuario.getLogin());
            ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.CREATED)).body((Object)imagemDB);
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            this.getLogger().error("BizExc.saveImagem", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (IOException ioExc) {
            this.getLogger().error("BizExc.saveImagem", (Throwable)ioExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ioExc.getMessage());
        }
    }

    @Operation(summary="Excluir imagem da monitora\u00e7\u00e3o", description="Exclui a imagem da monitora\u00e7\u00e3o a partir de seu identificador")
    @ApiResponses(value={@ApiResponse(description="Imagem exclu\u00edda com sucesso", responseCode="200"), @ApiResponse(description="Imagem n\u00e3o encontrada", responseCode="404")})
    @DeleteMapping(value={"/{empresa}/{idMonitoracao}/imagens/{seqAnexo}"})
    @NotNull
    public ResponseEntity<Boolean> deleteImagemMonitoracao(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="ID da monitora\u00e7\u00e3o") @PathVariable(name="idMonitoracao") @Nullable Integer idMonitoracao, @Parameter(description="Sequ\u00eancia do anexo") @PathVariable(name="seqAnexo") @Nullable Integer seqAnexo) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Object[] objectArray = new Object[]{empresa, idMonitoracao, seqAnexo};
        this.getLogger().debug("deleteImagemMonitoracaoSigaco({},{},{})", objectArray);
        try {
            return new ResponseEntity((Object)this.sigacoService.deleteImagemMonitoracao(empresa, idMonitoracao, seqAnexo), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.getLogger().error("BizExc.deleteImagemMonitoracaoSigaco", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @Operation(summary="Buscar anexos da monitora\u00e7\u00e3o", description="Retorna lista de anexos associados a uma monitora\u00e7\u00e3o")
    @ApiResponses(value={@ApiResponse(description="Opera\u00e7\u00e3o realizada com sucesso", responseCode="200")})
    @GetMapping(value={"/{empresa}/{idMonitoracao}/anexos"})
    @NotNull
    public List<MonitoracaoAnexo> findAnexos(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="ID da monitora\u00e7\u00e3o") @PathVariable(name="idMonitoracao") @Nullable Integer idMonitoracao) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        List list = this.sigacoService.findAnexosMonitoracao(empresa, idMonitoracao, usuario2, Pageable.unpaged()).getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContent(...)");
        return list;
    }

    @Operation(summary="Buscar anexo por ID", description="Retorna o anexo da monitora\u00e7\u00e3o a partir do seu identificador")
    @ApiResponses(value={@ApiResponse(description="Anexo encontrado", responseCode="200"), @ApiResponse(description="Anexo n\u00e3o encontrado", responseCode="404")})
    @GetMapping(value={"/{empresa}/{idMonitoracao}/anexos/{sequencia}"})
    @NotNull
    public ResponseEntity<MonitoracaoAnexo> getAnexoById(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="ID da monitora\u00e7\u00e3o") @PathVariable(name="idMonitoracao") @Nullable Integer idMonitoracao, @Parameter(description="Sequ\u00eancia do anexo") @PathVariable(name="sequencia") @Nullable Integer sequencia) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.getLogger().debug("getAnexoById({}, {})", (Object)empresa, (Object)idMonitoracao);
            return new ResponseEntity((Object)this.sigacoService.getAnexoMonitoracaoById(empresa, idMonitoracao, sequencia), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.getLogger().error("BizExc.getAnexoById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @Operation(summary="Salvar anexo da monitora\u00e7\u00e3o", description="Realiza o upload de um anexo para uma monitora\u00e7\u00e3o, recebendo multipart/form-data com os par\u00e2metros de arquivo")
    @ApiResponses(value={@ApiResponse(description="Anexo salvo com sucesso", responseCode="201")})
    @PostMapping(value={"/{empresa}/{idMonitoracao}/anexos"}, consumes={"multipart/form-data"})
    @ResponseBody
    @NotNull
    public ResponseEntity<MonitoracaoAnexo> saveAnexo(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="ID da monitora\u00e7\u00e3o") @PathVariable(name="idMonitoracao") @Nullable Integer idMonitoracao, @Parameter(description="Arquivo a ser enviado") @RequestParam(name="file", required=false) @NotNull MultipartFile file) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.getLogger().debug("Executando saveAnexo(emp={},idMonitoracao={})...", (Object)empresa, (Object)idMonitoracao);
        try {
            Map formData = request.getParameterMap();
            String tipoAtivo = null;
            String tipoAnexo = null;
            if (formData.containsKey("tipoAtivo")) {
                Object v = formData.get("tipoAtivo");
                Intrinsics.checkNotNull(v);
                tipoAtivo = ((String[])v)[0];
            }
            if (formData.containsKey("tipoAnexo")) {
                Object v = formData.get("tipoAnexo");
                Intrinsics.checkNotNull(v);
                tipoAnexo = ((String[])v)[0];
            }
            UploadedFileInfo fileInfo = new UploadedFileInfo(file.getOriginalFilename(), file.getContentType(), Long.valueOf(file.getSize()), file.getInputStream());
            MonitoracaoAnexo imagemDB = this.sigacoService.saveAnexoMonitoracao(empresa, idMonitoracao, tipoAtivo, tipoAnexo, fileInfo, usuario.getLogin());
            ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.CREATED)).body((Object)imagemDB);
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            this.getLogger().error("BizExc.saveAnexo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (IOException ioExc) {
            this.getLogger().error("BizExc.saveAnexo", (Throwable)ioExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ioExc.getMessage());
        }
    }

    @Operation(summary="Excluir anexo da monitora\u00e7\u00e3o", description="Exclui o anexo da monitora\u00e7\u00e3o a partir de seu identificador")
    @ApiResponses(value={@ApiResponse(description="Anexo exclu\u00eddo com sucesso", responseCode="200")})
    @DeleteMapping(value={"/{empresa}/{idMonitoracao}/anexos/{seqAnexo}"})
    @NotNull
    public ResponseEntity<Boolean> deleteAnexoMonitoracao(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="ID da monitora\u00e7\u00e3o") @PathVariable(name="idMonitoracao") @Nullable Integer idMonitoracao, @Parameter(description="Sequ\u00eancia do anexo") @PathVariable(name="seqAnexo") @Nullable Integer seqAnexo) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Object[] objectArray = new Object[]{empresa, idMonitoracao, seqAnexo};
        this.getLogger().debug("deleteAnexoMonitoracao({},{},{})", objectArray);
        try {
            return new ResponseEntity((Object)this.sigacoService.deleteAnexoMonitoracao(empresa, idMonitoracao, seqAnexo), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.getLogger().error("BizExc.deleteAnexoInspecao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @Operation(summary="Buscar hist\u00f3rico de monitora\u00e7\u00f5es", description="Retorna os hist\u00f3ricos (ciclos anteriores) de uma monitora\u00e7\u00e3o")
    @ApiResponses(value={@ApiResponse(description="Hist\u00f3rico encontrado com sucesso", responseCode="200")})
    @GetMapping(value={"/{empresa}/{tipoAtivo}/ciclos/{idElemento}"})
    @NotNull
    public List<MonitoracaoSigaco> findCiclosAnteriores(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="C\u00f3digo do tipo de ativo") @PathVariable(name="tipoAtivo") @Nullable TipoAtivo tipoAtivo, @Parameter(description="ID do elemento") @PathVariable(name="idElemento") @Nullable Integer idElemento, @Parameter(description="Fase da monitora\u00e7\u00e3o") @RequestParam(name="fase") @Nullable Integer faseMonitoracao) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        List list = this.sigacoService.findCiclosAnteriores(empresa, tipoAtivo, idElemento, faseMonitoracao, usuario2, Pageable.unpaged()).getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContent(...)");
        return list;
    }

    @Operation(summary="Buscar hist\u00f3ricos da monitora\u00e7\u00e3o", description="Retorna os hist\u00f3ricos de altera\u00e7\u00f5es ou eventos de uma monitora\u00e7\u00e3o")
    @ApiResponses(value={@ApiResponse(description="Hist\u00f3ricos encontrados com sucesso", responseCode="200")})
    @GetMapping(value={"/{empresa}/{idMonitoracao}/historicos"})
    @NotNull
    public ResponseEntity<List<MonitoracaoHistorico>> findHistoricos(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="ID da monitora\u00e7\u00e3o") @PathVariable(name="idMonitoracao") @Nullable Integer idMonitoracao) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        Usuario usuario2 = usuario;
        ResponseEntity responseEntity = ResponseEntity.ok((Object)this.sigacoService.findHistoricos(empresa, idMonitoracao, usuario2, Pageable.unpaged()).getContent());
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(...)");
        return responseEntity;
    }

    /*
     * WARNING - void declaration
     */
    @Operation(summary="Exportar monitora\u00e7\u00f5es para Excel", description="Gera arquivo Excel com dados das monitora\u00e7\u00f5es filtradas")
    @ApiResponses(value={@ApiResponse(description="Arquivo gerado com sucesso", responseCode="200")})
    @PostMapping(value={"/{empresa}/{tipoAtivo}/exportacao"})
    @NotNull
    public ResponseEntity<byte[]> exportExcel(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="C\u00f3digo do tipo de ativo") @PathVariable(name="tipoAtivo") @NotNull TipoAtivo tipoAtivo, @Parameter(description="ID da fase de monitora\u00e7\u00e3o", required=false) @RequestParam(value="faseMonitoracao", required=false) @Nullable List<Integer> idFase) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)tipoAtivo, (String)"tipoAtivo");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.getLogger().debug("Exportando excel, monitora\u00e7\u00f5es (emp={}, {})...", (Object)empresa, (Object)tipoAtivo);
        if (empresa == null || ((CharSequence)empresa).length() == 0) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o informada.");
        }
        try {
            Double[] kmMetros;
            Object iteParm;
            SegurancaService segurancaService = this.segurancaService;
            Intrinsics.checkNotNull((Object)segurancaService);
            Usuario usuario2 = segurancaService.getUsuarioByLoginOrMail(usuario.getLogin());
            if (usuario2 == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
            }
            Usuario usr = usuario2;
            Empresa empresa2 = this.coreService.getEmpresaBySigla(empresa);
            if (empresa2 == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            Empresa empresaDB = empresa2;
            Integer idCategoria = null;
            String situacao = null;
            String param = null;
            List rodovias = null;
            Double kmInicial = null;
            Double kmFinal = null;
            Integer faixa = null;
            String sentido = null;
            Object[] params = request.getParameterValues("rodovias");
            if (params != null && params.length > 0) {
                rodovias = new ArrayList();
                Iterator iterator = ArrayIteratorKt.iterator((Object[])params);
                while (iterator.hasNext()) {
                    iteParm = (String)iterator.next();
                    ArrayList arrayList = (ArrayList)rodovias;
                    String string = iteParm;
                    Intrinsics.checkNotNull((Object)string);
                    arrayList.add(Integer.parseInt(string));
                }
            }
            if ((param = request.getParameter("categoria")) != null) {
                idCategoria = Integer.parseInt(param);
            }
            ArrayList<Integer> categoriasId = new ArrayList<Integer>();
            params = request.getParameterValues("categorias");
            if (params != null && params.length > 0) {
                iteParm = ArrayIteratorKt.iterator((Object[])params);
                while (iteParm.hasNext()) {
                    void $this$trim$iv;
                    String iteParm2;
                    String string = iteParm2 = (String)iteParm.next();
                    Intrinsics.checkNotNull((Object)string);
                    CharSequence charSequence = string;
                    if (!new Regex("^[+-]?\\d+$").matches(charSequence)) continue;
                    charSequence = iteParm2;
                    ArrayList<Integer> arrayList = categoriasId;
                    boolean $i$f$trim = false;
                    CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                    boolean $i$f$trim2 = false;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it = $this$trim$iv$iv.charAt(index$iv$iv);
                        boolean bl = false;
                        boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    arrayList.add(Integer.parseInt(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()));
                }
            }
            if ((kmMetros = this.stringToKm(request.getParameter("kmInicial"))) != null && kmMetros.length > 0) {
                kmInicial = kmMetros[0] + kmMetros[1];
            }
            if ((kmMetros = this.stringToKm(request.getParameter("kmFinal"))) != null && kmMetros.length > 0) {
                kmFinal = kmMetros[0] + kmMetros[1];
            }
            if ((param = request.getParameter("faixa")) != null) {
                faixa = Integer.parseInt(param);
            }
            sentido = request.getParameter("sentido");
            situacao = request.getParameter("situacao");
            String classeSinalizacao = request.getParameter("classeSinalizacao");
            String variavel = null;
            String varIni = null;
            String varFim = null;
            String tipoAcesso = request.getParameter("tipoAcesso");
            Integer seqImportacao = null;
            param = request.getParameter("importacao");
            if (param != null) {
                seqImportacao = Integer.parseInt(param);
            }
            Integer statusImportacao = null;
            param = request.getParameter("statusImportacao");
            if (param != null) {
                statusImportacao = Integer.parseInt(param);
            }
            HashMap extParams = new HashMap();
            if (request.getParameter("situacao") != null) {
                ((Map)extParams).put("situacao", request.getParameter("situacao"));
            }
            if (usr.getIdPoderConcedente() != null && empresaDB.getIdPoderConcedente() != null && usr.isExterno().booleanValue() && Intrinsics.areEqual((Object)usr.getIdPoderConcedente(), (Object)empresaDB.getIdPoderConcedente())) {
                statusImportacao = 2;
            }
            List monitoracoes = this.sigacoService.findMonitoracoes(empresa, tipoAtivo, idCategoria, (List)categoriasId, idFase, rodovias, kmInicial, kmFinal, faixa, sentido, situacao, classeSinalizacao, variavel, varIni, varFim, tipoAcesso, seqImportacao, statusImportacao, null, null, (Map)extParams);
            byte[] byArray = new ExportMonitoracaoExcel().executeXLS(monitoracoes);
            if (byArray == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Relat\u00f3rio n\u00e3o foi gerado corretamente.");
            }
            byte[] bytes = byArray;
            this.getLogger().debug("Bytes.length gerados==> {}", (Object)(bytes.length > 0 ? bytes.length / 1024 : 0));
            HttpHeaders headers = new HttpHeaders();
            headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
            headers.add("Pragma", "no-cache");
            headers.add("Expires", "0");
            headers.add("Content-Disposition", "attachment; filename=\"monitoracoes.xlsx\"");
            headers.add("Content-Type", "application/octet-stream");
            return new ResponseEntity((Object)bytes, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.getLogger().error("bizExc", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @Nullable
    public Double[] stringToKm(@Nullable String cellValue) {
        String cellValue2 = cellValue;
        if (cellValue2 == null || ((CharSequence)cellValue2).length() == 0) {
            return null;
        }
        try {
            String[] kmMetros;
            String[] kmMetros2;
            Double[] $this$toTypedArray$iv;
            Collection $this$dropLastWhile$iv;
            String string;
            Object object;
            Double[] doubleArray;
            if (StringsKt.indexOf$default((CharSequence)cellValue2, (String)" ", (int)0, (boolean)false, (int)6, null) != -1) {
                doubleArray = (Double[])cellValue2;
                object = new Regex(" ");
                string = "+";
                cellValue2 = object.replace((CharSequence)doubleArray, string);
            }
            if (StringsKt.indexOf$default((CharSequence)cellValue2, (String)".", (int)0, (boolean)false, (int)6, null) != -1) {
                List list;
                object = cellValue2;
                string = new Regex("\\.");
                int n = 0;
                object = string.split((CharSequence)object, n);
                boolean $i$f$dropLastWhile = false;
                if (!$this$dropLastWhile$iv.isEmpty()) {
                    ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        String it = (String)iterator$iv.previous();
                        boolean bl = false;
                        if (((CharSequence)it).length() == 0) continue;
                        list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    list = CollectionsKt.emptyList();
                }
                $this$dropLastWhile$iv = list;
                boolean $i$f$toTypedArray = false;
                CharSequence thisCollection$iv = $this$toTypedArray$iv;
                kmMetros2 = thisCollection$iv.toArray(new String[0]);
                if (kmMetros2 != null && kmMetros2.length > 0) {
                    $this$toTypedArray$iv = new Double[]{Double.parseDouble(kmMetros2[0]), Double.parseDouble(kmMetros2[1])};
                    return $this$toTypedArray$iv;
                }
                return null;
            }
            if (StringsKt.indexOf$default((CharSequence)cellValue2, (String)",", (int)0, (boolean)false, (int)6, null) != -1) {
                Double[] $this$toTypedArray$iv2;
                List list;
                Collection $this$dropLastWhile$iv2;
                double kilometro = this.getFmtPtBr().parse(cellValue2).doubleValue();
                Object thisCollection$iv = String.valueOf(kilometro);
                Regex it = new Regex("\\.");
                int bl = 0;
                thisCollection$iv = it.split((CharSequence)thisCollection$iv, bl);
                boolean $i$f$dropLastWhile = false;
                if (!$this$dropLastWhile$iv2.isEmpty()) {
                    ListIterator iterator$iv = $this$dropLastWhile$iv2.listIterator($this$dropLastWhile$iv2.size());
                    while (iterator$iv.hasPrevious()) {
                        String it2 = (String)iterator$iv.previous();
                        boolean bl2 = false;
                        if (((CharSequence)it2).length() == 0) continue;
                        list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv2, (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    list = CollectionsKt.emptyList();
                }
                $this$dropLastWhile$iv2 = list;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv2 = $this$toTypedArray$iv2;
                kmMetros = thisCollection$iv2.toArray(new String[0]);
                if (kmMetros != null && kmMetros.length > 0) {
                    $this$toTypedArray$iv2 = new Double[]{Double.parseDouble(kmMetros[0]), Double.parseDouble(kmMetros[1])};
                    return $this$toTypedArray$iv2;
                }
                return null;
            }
            if (StringsKt.indexOf$default((CharSequence)cellValue2, (String)"+", (int)0, (boolean)false, (int)6, null) != -1) {
                List list;
                $this$toTypedArray$iv = cellValue2;
                kmMetros = new Regex("\\+");
                int $this$toTypedArray$iv2 = 0;
                $this$toTypedArray$iv = kmMetros.split((CharSequence)$this$toTypedArray$iv, $this$toTypedArray$iv2);
                boolean $i$f$dropLastWhile = false;
                if (!$this$dropLastWhile$iv.isEmpty()) {
                    ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        String it = (String)iterator$iv.previous();
                        boolean bl = false;
                        if (((CharSequence)it).length() == 0) continue;
                        list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    list = CollectionsKt.emptyList();
                }
                $this$dropLastWhile$iv = list;
                boolean $i$f$toTypedArray = false;
                Double[] thisCollection$iv = $this$toTypedArray$iv;
                kmMetros2 = thisCollection$iv.toArray(new String[0]);
                if (kmMetros2 != null && kmMetros2.length > 0) {
                    $this$toTypedArray$iv = new Double[]{Double.parseDouble(kmMetros2[0]), Double.parseDouble(kmMetros2[1]) / (double)1000};
                    return $this$toTypedArray$iv;
                }
                return null;
            }
            doubleArray = new Double[]{Double.parseDouble(cellValue2), 0.0};
            return doubleArray;
        }
        catch (NumberFormatException nmfExc) {
            return null;
        }
        catch (ParseException psExc) {
            return null;
        }
    }

    @Operation(summary="Buscar importa\u00e7\u00f5es de monitora\u00e7\u00f5es", description="Retorna a lista de importa\u00e7\u00f5es de monitora\u00e7\u00f5es baseado em filtros opcionais")
    @ApiResponses(value={@ApiResponse(description="Opera\u00e7\u00e3o realizada com sucesso", responseCode="200")})
    @GetMapping(value={"/importacoes/{empresa}"})
    @NotNull
    public ResponseEntity<List<ImportacaoMonitoracao>> findImportacoes(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="ID da fase", required=false) @RequestParam(name="idFase", required=false) @Nullable Integer idFase, @Parameter(description="Subsistema", required=false) @RequestParam(name="subsistema", required=false) @Nullable String subsistema, @Parameter(description="Status", required=false) @RequestParam(name="status", required=false) @Nullable Integer status, @Parameter(description="Respons\u00e1vel", required=false) @RequestParam(name="responsavel", required=false) @Nullable String responsavel) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        Usuario usuario2 = usuario;
        ResponseEntity responseEntity = ResponseEntity.ok((Object)this.sigacoService.findImportacoes(empresa, idFase, subsistema, status, responsavel, usuario2, Pageable.unpaged()).getContent());
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(...)");
        return responseEntity;
    }

    @Operation(summary="Buscar importa\u00e7\u00e3o por ID", description="Retorna a importa\u00e7\u00e3o de monitora\u00e7\u00e3o a partir de seu identificador")
    @ApiResponses(value={@ApiResponse(description="Importa\u00e7\u00e3o encontrada", responseCode="200")})
    @GetMapping(value={"/importacoes/{empresa}/{idFase}/{seqImportacao}"})
    @NotNull
    public ResponseEntity<ImportacaoMonitoracao> getImportacaoById(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="ID da fase") @PathVariable(name="idFase") @Nullable Integer idFase, @Parameter(description="Sequ\u00eancia da importa\u00e7\u00e3o") @PathVariable(name="seqImportacao") @Nullable Integer seqImportacao) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            Object[] objectArray = new Object[]{empresa, idFase, seqImportacao};
            this.getLogger().debug("getImportacaoById({}, {}, {})", objectArray);
            ResponseEntity responseEntity = ResponseEntity.ok().body((Object)this.sigacoService.getImportacaoById(idFase, seqImportacao));
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            this.getLogger().error("BizExc.getImportacaoById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @Operation(summary="Aprovar importa\u00e7\u00e3o", description="Aprova uma importa\u00e7\u00e3o de monitora\u00e7\u00e3o")
    @ApiResponses(value={@ApiResponse(description="Importa\u00e7\u00e3o aprovada com sucesso", responseCode="200")})
    @PostMapping(value={"/importacoes/{empresa}/{fase}/{importacao}/aprovar"})
    @NotNull
    public ResponseEntity<Boolean> aprovarImportacoes(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="Fase da importa\u00e7\u00e3o") @PathVariable(name="fase") @Nullable Integer fase, @Parameter(description="ID da importa\u00e7\u00e3o") @PathVariable(name="importacao") @Nullable Integer importacao) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            Object[] objectArray = new Object[]{usuario.getLogin(), empresa, importacao};
            this.getLogger().debug("{} - aprovarImportacoes({}, {})", objectArray);
            return new ResponseEntity((Object)this.sigacoService.aprovarImportacoes(empresa, fase, importacao, usuario.getLogin()), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.getLogger().error("BizExc.aprovarImportacoes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @Operation(summary="Reprovar importa\u00e7\u00e3o", description="Reprova uma importa\u00e7\u00e3o de monitora\u00e7\u00e3o")
    @ApiResponses(value={@ApiResponse(description="Importa\u00e7\u00e3o reprovada com sucesso", responseCode="200")})
    @PostMapping(value={"/importacoes/{empresa}/{fase}/{importacao}/reprovarImportacao"})
    @NotNull
    public ResponseEntity<Boolean> reprovarImportacoes(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="Fase da importa\u00e7\u00e3o") @PathVariable(name="fase") @Nullable Integer fase, @Parameter(description="ID da importa\u00e7\u00e3o") @PathVariable(name="importacao") @Nullable Integer importacao) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            Object[] objectArray = new Object[]{usuario.getLogin(), empresa, fase, importacao};
            this.getLogger().debug("{} - reprovarImportacoes({}, {}, {})", objectArray);
            return new ResponseEntity((Object)this.sigacoService.reprovarImportacoes(empresa, fase, importacao, usuario.getLogin()), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.getLogger().error("BizExc.reprovarImportacoes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @Operation(summary="Publicar importa\u00e7\u00e3o", description="Publica uma importa\u00e7\u00e3o de monitora\u00e7\u00e3o")
    @ApiResponses(value={@ApiResponse(description="Importa\u00e7\u00e3o publicada com sucesso", responseCode="200")})
    @PostMapping(value={"/importacoes/{empresa}/{fase}/{importacao}/publicar"})
    @NotNull
    public ResponseEntity<Boolean> publicarImportacoes(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="Fase da importa\u00e7\u00e3o") @PathVariable(name="fase") @Nullable Integer fase, @Parameter(description="ID da importa\u00e7\u00e3o") @PathVariable(name="importacao") @Nullable Integer importacao) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            Object[] objectArray = new Object[]{empresa, fase, importacao};
            this.getLogger().debug("publicarImportacoes({}, {}, {})", objectArray);
            return new ResponseEntity((Object)this.sigacoService.aprovarPublicacoes(empresa, fase, importacao, usuario.getLogin()), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.getLogger().error("BizExc.publicarImportacoes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @Operation(summary="Reprovar publica\u00e7\u00e3o", description="Reprova uma publica\u00e7\u00e3o de monitora\u00e7\u00e3o")
    @ApiResponses(value={@ApiResponse(description="Publica\u00e7\u00e3o reprovada com sucesso", responseCode="200")})
    @PostMapping(value={"/importacoes/{empresa}/{fase}/{importacao}/reprovarPublicacao"})
    @NotNull
    public ResponseEntity<Boolean> reprovarPublicacoes(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="Fase da importa\u00e7\u00e3o") @PathVariable(name="fase") @Nullable Integer fase, @Parameter(description="ID da importa\u00e7\u00e3o") @PathVariable(name="importacao") @Nullable Integer importacao) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            Object[] objectArray = new Object[]{usuario.getLogin(), empresa, fase, importacao};
            this.getLogger().debug("{} - reprovarPublicacoes({}, {}, {})", objectArray);
            return new ResponseEntity((Object)this.sigacoService.reprovarPublicacoes(empresa, fase, importacao, usuario.getLogin()), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.getLogger().error("BizExc.reprovarPublicacoes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @Operation(summary="Excluir importa\u00e7\u00f5es", description="Exclui uma importa\u00e7\u00e3o de monitora\u00e7\u00e3o")
    @ApiResponses(value={@ApiResponse(description="Importa\u00e7\u00e3o exclu\u00edda com sucesso", responseCode="200")})
    @DeleteMapping(value={"/importacoes/{empresa}/{fase}/{importacao}/excluir"})
    @NotNull
    public ResponseEntity<Boolean> deleteImportacoes(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="Fase da importa\u00e7\u00e3o") @PathVariable(name="fase") @Nullable Integer fase, @Parameter(description="ID da importa\u00e7\u00e3o") @PathVariable(name="importacao") @Nullable Integer importacao) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            Object[] objectArray = new Object[]{empresa, fase, importacao};
            this.getLogger().debug("excluirImportacoes({}, {}, {})", objectArray);
            return new ResponseEntity((Object)this.sigacoService.deleteImportacoes(empresa, fase, importacao, usuario.getLogin()), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.getLogger().error("BizExc.excluirImportacoes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @Operation(summary="Buscar dashboards", description="Retorna dashboards de monitora\u00e7\u00e3o com base em filtros")
    @ApiResponses(value={@ApiResponse(description="Dashboards encontrados com sucesso", responseCode="200")})
    @GetMapping(value={"/{empresa}/dashboards/{tipoAtivo}"})
    @NotNull
    public ResponseEntity<Map<String, List<DashboardSigacoVO>>> findDashboards(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="C\u00f3digo do tipo de ativo") @PathVariable(name="tipoAtivo") @NotNull TipoAtivo tipoAtivo) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)tipoAtivo, (String)"tipoAtivo");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        SegurancaService segurancaService = this.segurancaService;
        Intrinsics.checkNotNull((Object)segurancaService);
        Usuario usuario2 = segurancaService.getUsuarioByLoginOrMail(usuario.getLogin());
        if (usuario2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        Usuario usr = usuario2;
        try {
            Double[] kmMetros;
            Object[] objectArray = new Object[]{usuario.getLogin(), empresa, tipoAtivo};
            this.getLogger().debug("{} - findDashboards({}, {})", objectArray);
            Empresa empresa2 = this.coreService.getEmpresaBySigla(empresa);
            if (empresa2 == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            Empresa empresaDB = empresa2;
            Integer idFase = null;
            List rodovias = null;
            Double kmInicial = null;
            Double kmFinal = null;
            Integer faixa = null;
            String sentido = null;
            Integer statusImportacao = null;
            String param = null;
            String estadoConservacao = request.getParameter("estadoConservacao");
            Object[] params = request.getParameterValues("faseMonitoracao");
            if (params != null && params.length > 0 && params[0] != null) {
                String string = params[0];
                Intrinsics.checkNotNull((Object)string);
                if (!(((CharSequence)string).length() == 0)) {
                    Object object = params[0];
                    Intrinsics.checkNotNull((Object)object);
                    idFase = Integer.parseInt((String)object);
                }
            }
            if ((params = request.getParameterValues("rodovias")) != null && params.length > 0) {
                rodovias = new ArrayList();
                Iterator iterator = ArrayIteratorKt.iterator((Object[])params);
                while (iterator.hasNext()) {
                    String iteParm = (String)iterator.next();
                    ArrayList arrayList = (ArrayList)rodovias;
                    String string = iteParm;
                    Intrinsics.checkNotNull((Object)string);
                    arrayList.add(Integer.parseInt(string));
                }
            }
            if ((kmMetros = this.stringToKm(request.getParameter("kmInicial"))) != null && kmMetros.length > 0) {
                kmInicial = kmMetros[0] + kmMetros[1];
            }
            if ((kmMetros = this.stringToKm(request.getParameter("kmFinal"))) != null && kmMetros.length > 0) {
                kmFinal = kmMetros[0] + kmMetros[1];
            }
            Integer idCategoria = null;
            param = request.getParameter("categoria");
            if (param != null) {
                idCategoria = Integer.parseInt(param);
            }
            ArrayList categoriasDesc = new ArrayList();
            ArrayList<Object> categoriasId = new ArrayList<Object>();
            params = request.getParameterValues("categorias");
            if (params != null && params.length > 0) {
                Iterator iterator = ArrayIteratorKt.iterator((Object[])params);
                while (iterator.hasNext()) {
                    boolean bl;
                    boolean match$iv$iv;
                    char it;
                    int index$iv$iv;
                    boolean startFound$iv$iv;
                    int endIndex$iv$iv;
                    int startIndex$iv$iv;
                    boolean $i$f$trim;
                    CharSequence $this$trim$iv$iv;
                    String $this$trim$iv;
                    boolean $i$f$trim2;
                    ArrayList<Object> arrayList;
                    String iteParm;
                    String string = iteParm = (String)iterator.next();
                    Intrinsics.checkNotNull((Object)string);
                    CharSequence charSequence = string;
                    if (new Regex("^[+-]?\\d+$").matches(charSequence)) {
                        charSequence = iteParm;
                        arrayList = categoriasId;
                        $i$f$trim2 = false;
                        $this$trim$iv$iv = $this$trim$iv;
                        $i$f$trim = false;
                        startIndex$iv$iv = 0;
                        endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                        startFound$iv$iv = false;
                        while (startIndex$iv$iv <= endIndex$iv$iv) {
                            index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                            it = $this$trim$iv$iv.charAt(index$iv$iv);
                            boolean bl2 = false;
                            boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                            if (!startFound$iv$iv) {
                                if (!match$iv$iv) {
                                    startFound$iv$iv = true;
                                    continue;
                                }
                                ++startIndex$iv$iv;
                                continue;
                            }
                            if (!match$iv$iv) break;
                            --endIndex$iv$iv;
                        }
                        bl = arrayList.add(Integer.parseInt(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()));
                        continue;
                    }
                    $this$trim$iv = iteParm;
                    arrayList = categoriasDesc;
                    $i$f$trim2 = false;
                    $this$trim$iv$iv = $this$trim$iv;
                    $i$f$trim = false;
                    startIndex$iv$iv = 0;
                    endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        it = $this$trim$iv$iv.charAt(index$iv$iv);
                        boolean bl4 = false;
                        boolean bl5 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    bl = arrayList.add(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
                }
            }
            if ((param = request.getParameter("faixa")) != null) {
                faixa = Integer.parseInt(param);
            }
            sentido = request.getParameter("sentido");
            String subTipo = request.getParameter("subTipo");
            String tipoAcesso = request.getParameter("tipoAcesso");
            HashMap extParams = new HashMap();
            if (request.getParameter("tipoPelicula") != null) {
                ((Map)extParams).put("tipoPelicula", request.getParameter("tipoPelicula"));
            }
            HashMap dashboards = this.sigacoService.findDashboards(empresa, tipoAtivo, subTipo, idFase, idCategoria, (List)categoriasDesc, (List)categoriasId, rodovias, kmInicial, kmFinal, faixa, sentido, tipoAcesso, estadoConservacao, statusImportacao, (Map)extParams, usuario.getLogin());
            ResponseEntity responseEntity = ResponseEntity.ok().body((Object)dashboards);
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            this.getLogger().error("BizExc.findDashboards", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @Operation(summary="Buscar itens de dashboards", description="Retorna os itens dos dashboards de monitora\u00e7\u00e3o com base em filtros")
    @ApiResponses(value={@ApiResponse(description="Itens encontrados com sucesso", responseCode="200")})
    @GetMapping(value={"/{empresa}/dashboards/{tipoAtivo}/itens"})
    @NotNull
    public List<DashboardSigacoVO> findDashboardsItems(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="C\u00f3digo do tipo de ativo") @PathVariable(name="tipoAtivo") @NotNull TipoAtivo tipoAtivo) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)tipoAtivo, (String)"tipoAtivo");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        Integer idFase = null;
        String[] params = request.getParameterValues("faseMonitoracao");
        if (params != null && params.length > 0 && params[0] != null) {
            String string = params[0];
            Intrinsics.checkNotNull((Object)string);
            if (!(((CharSequence)string).length() == 0)) {
                String string2 = params[0];
                Intrinsics.checkNotNull((Object)string2);
                idFase = Integer.parseInt(string2);
            }
        }
        String string = request.getParameter("rodovia");
        String string3 = request.getParameter("kilometro");
        String string4 = request.getParameter("ano");
        String string5 = request.getParameter("faixa");
        List list = this.sigacoService.findDashboardItens(empresa, tipoAtivo, new FindDashboardItemsDTO(idFase, string != null ? StringsKt.toIntOrNull((String)string) : null, string3 != null ? StringsKt.toDoubleOrNull((String)string3) : null, string4 != null ? StringsKt.toIntOrNull((String)string4) : null, request.getParameter("tipoGrafico"), request.getParameter("subTipo"), string5 != null ? StringsKt.toIntOrNull((String)string5) : null, request.getParameter("sentido"), request.getParameter("serieName"), request.getParameter("itemName")), usuario2, Pageable.unpaged()).getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContent(...)");
        return list;
    }

    @Operation(summary="Buscar ciclos de dashboards", description="Retorna os ciclos dos itens de dashboards de monitora\u00e7\u00e3o")
    @ApiResponses(value={@ApiResponse(description="Ciclos encontrados com sucesso", responseCode="200")})
    @GetMapping(value={"/{empresa}/dashboards/{tipoAtivo}/ciclos/{idItem}"})
    @NotNull
    public List<DashboardSigacoVO> findDashboardsCiclos(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable @Nullable String empresa, @Parameter(description="C\u00f3digo do tipo de ativo") @PathVariable @NotNull TipoAtivo tipoAtivo, @Parameter(description="ID do item do dashboard") @PathVariable @Nullable Integer idItem) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)tipoAtivo, (String)"tipoAtivo");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        String subTipo = request.getParameter("subTipo");
        List list = this.sigacoService.findDashboardCiclos(empresa, tipoAtivo, subTipo, idItem, usuario2, Pageable.unpaged()).getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContent(...)");
        return list;
    }
}

