/*
 * Decompiled with CFR 0.152.
 */
package br.com.sigescantt.apis;

import br.com.sigescantt.apis.BaseRestService;
import br.com.sigescantt.core.beans.seguranca.PublicUser;
import br.com.sigescantt.core.dto.geral.tipoDocumento.TipoDocumentoDTO;
import br.com.sigescantt.exceptions.BusinessException;
import br.com.sigescantt.geral.TipoDocumento;
import br.com.sigescantt.services.CadastroService;
import br.com.sigescantt.services.CoreService;
import br.com.sigescantt.services.Exceptions.ErrorCode;
import br.com.sigescantt.services.Exceptions.ErrorCodeException;
import br.com.sigescantt.services.SegurancaService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(name="tiposDocumento", description="Servi\u00e7os REST para consulta e gerenciamento de tipos de documento")
@RequestMapping(value={"/api/v1/tiposDocumento", "/api/tiposDocumento"})
@Validated
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ6\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0001\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J\"\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00172\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\b\u0001\u0010\u0018\u001a\u00020\u0019H\u0017J\u001a\u0010\u001a\u001a\u00020\u000e2\b\b\u0001\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J*\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00172\b\b\u0001\u0010\u001b\u001a\u00020\u001c2\b\b\u0001\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J \u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00172\b\b\u0001\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u0010H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lbr/com/sigescantt/apis/TiposDocumentosRestServices;", "Lbr/com/sigescantt/apis/BaseRestService;", "segurancaService", "Lbr/com/sigescantt/services/SegurancaService;", "coreService", "Lbr/com/sigescantt/services/CoreService;", "cadastroService", "Lbr/com/sigescantt/services/CadastroService;", "<init>", "(Lbr/com/sigescantt/services/SegurancaService;Lbr/com/sigescantt/services/CoreService;Lbr/com/sigescantt/services/CadastroService;)V", "logger", "Lorg/slf4j/Logger;", "findTiposDocumento", "Lorg/springframework/data/domain/Page;", "Lbr/com/sigescantt/geral/TipoDocumento;", "request", "Ljakarta/servlet/http/HttpServletRequest;", "search", "", "classe", "pageable", "Lorg/springframework/data/domain/Pageable;", "findTiposDocumentoEmpresa", "Lorg/springframework/http/ResponseEntity;", "idTipoDocumento", "", "saveTipoDocumento", "dto", "Lbr/com/sigescantt/core/dto/geral/tipoDocumento/TipoDocumentoDTO;", "deleteTipoDocumento", "", "server"})
public class TiposDocumentosRestServices
extends BaseRestService {
    @NotNull
    private final SegurancaService segurancaService;
    @NotNull
    private final CoreService coreService;
    @NotNull
    private final CadastroService cadastroService;
    @NotNull
    private final Logger logger;

    public TiposDocumentosRestServices(@NotNull SegurancaService segurancaService, @NotNull CoreService coreService, @NotNull CadastroService cadastroService) {
        Intrinsics.checkNotNullParameter((Object)segurancaService, (String)"segurancaService");
        Intrinsics.checkNotNullParameter((Object)coreService, (String)"coreService");
        Intrinsics.checkNotNullParameter((Object)cadastroService, (String)"cadastroService");
        super(segurancaService);
        this.segurancaService = segurancaService;
        this.coreService = coreService;
        this.cadastroService = cadastroService;
        Logger logger = LoggerFactory.getLogger(TiposDocumentosRestServices.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    @GetMapping
    @ResponseBody
    @Operation(summary="Busca tipos de documento por classe", description="Retorna os tipos de documento por classe de documento (COR, COE, OBR, NTF, TRO, LIC) da empresa informada")
    @ApiResponses(value={@ApiResponse(description="Lista de tipos de documento encontrada com sucesso", responseCode="200")})
    @NotNull
    public Page<TipoDocumento> findTiposDocumento(@NotNull HttpServletRequest request, @Parameter(description="Classe do documento (COR, COE, OBR, NTF, TRO, LIC)") @RequestParam(value="search", required=false) @Nullable String search, @RequestParam(value="classe", required=false) @Nullable String classe, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        if (this.getUsuarioByJWT(request) == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        this.logger.debug("Iniciando find de tipos documento...");
        Page page = this.cadastroService.findTipoDocumentosPaginated(search, classe, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findTipoDocumentosPaginated(...)");
        return page;
    }

    @GetMapping(value={"/{idTipoDocumento}"})
    @ResponseBody
    @Operation(summary="Busca o Tipo do Documento de acordo com identificador informado", description="Busca o Tipo do Documento de acordo com identificador informado")
    @ApiResponses(value={@ApiResponse(description="Tipo de Documento retornado com sucesso", responseCode="200")})
    @NotNull
    public ResponseEntity<TipoDocumento> findTiposDocumentoEmpresa(@Nullable HttpServletRequest request, @PathVariable(value="idTipoDocumento") int idTipoDocumento) {
        try {
            this.logger.debug("Iniciando find de tipos documento...");
            return new ResponseEntity((Object)this.cadastroService.findTipoDocumentoById(Integer.valueOf(idTipoDocumento)), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.findTiposDocumento", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping
    @Operation(summary="Cadastra ou atualiza um tipo de documento", description="Salva um novo tipo de documento ou atualiza um existente")
    @ApiResponses(value={@ApiResponse(description="Tipo de documento criado ou atualizado com sucesso", responseCode="201")})
    @ResponseStatus(value=HttpStatus.CREATED)
    @NotNull
    public TipoDocumento saveTipoDocumento(@Parameter(description="Objeto TipoDocumento a ser salvo", required=true) @Valid @RequestBody @NotNull TipoDocumentoDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        PublicUser usuario = publicUser;
        this.logger.debug("saveTipoDocumento ({}))", (Object)dto);
        TipoDocumento tipoDocumento = this.cadastroService.saveTipoDocumento(dto, usuario.getLogin());
        Intrinsics.checkNotNullExpressionValue((Object)tipoDocumento, (String)"saveTipoDocumento(...)");
        return tipoDocumento;
    }

    @PutMapping(value={"/{idTipoDocumento}"})
    @Operation(summary="Atualiza um tipo de documento existente", description="Atualiza um tipo de documento existente")
    @ApiResponses(value={@ApiResponse(description="Tipo de documento atualizado com sucesso", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<TipoDocumento> saveTipoDocumento(@Parameter(description="Objeto TipoDocumento a ser editado", required=true, content={@Content(schema=@Schema(implementation=TipoDocumento.class))}) @RequestBody @NotNull TipoDocumentoDTO dto, @PathVariable(value="idTipoDocumento") int idTipoDocumento, @NotNull HttpServletRequest request) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.logger.debug("editTipoDocumento ({}))", (Object)dto);
        return new ResponseEntity((Object)this.cadastroService.editTipoDocumento(dto, Integer.valueOf(idTipoDocumento), usuario.getLogin()), (HttpStatusCode)HttpStatus.OK);
    }

    @DeleteMapping(value={"/{idTipoDocumento}"})
    @Operation(summary="Remove um tipo de documento", description="Exclui um tipo de documento com base no ID, retornando erro se houver liga\u00e7\u00e3o com outras entidades do sistema")
    @ApiResponses(value={@ApiResponse(description="Tipo de documento exclu\u00eddo com sucesso", responseCode="200")})
    @NotNull
    public ResponseEntity<Boolean> deleteTipoDocumento(@Parameter(description="ID do tipo de documento a ser exclu\u00eddo") @PathVariable(name="idTipoDocumento") int idTipoDocumento, @NotNull HttpServletRequest request) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.getUsuarioByJWT(request) == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        this.logger.debug("deleteTipoDocumento({})", (Object)idTipoDocumento);
        try {
            return new ResponseEntity((Object)this.cadastroService.deleteTipoDocumento(Integer.valueOf(idTipoDocumento)), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.deleteTipoDocumento", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

