/*
 * Decompiled with CFR 0.152.
 */
package br.com.sigescantt.apis;

import br.com.sigescantt.core.dto.configuracoes.SystemConfigDTO;
import br.com.sigescantt.services.sysconfig.SystemConfigService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="systemConfig", description="REST Services para configura\u00e7\u00f5es dos sistemas")
@RequestMapping(value={"/api/v1/configuracoes"})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\u0007H\u0017J\b\u0010\t\u001a\u00020\u0007H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lbr/com/sigescantt/apis/SystemConfigRestServices;", "", "systemConfigService", "Lbr/com/sigescantt/services/sysconfig/SystemConfigService;", "<init>", "(Lbr/com/sigescantt/services/sysconfig/SystemConfigService;)V", "setSystemConfig", "Lbr/com/sigescantt/core/dto/configuracoes/SystemConfigDTO;", "request", "getSystemConfig", "server"})
public class SystemConfigRestServices {
    @NotNull
    private final SystemConfigService systemConfigService;

    public SystemConfigRestServices(@NotNull SystemConfigService systemConfigService) {
        Intrinsics.checkNotNullParameter((Object)systemConfigService, (String)"systemConfigService");
        this.systemConfigService = systemConfigService;
    }

    @Operation(summary="Definir configura\u00e7\u00f5es padr\u00e3o do sistema.", description="Endpoint para definir configura\u00e7\u00f5es padr\u00e3o do sistema.")
    @ApiResponses(value={@ApiResponse(description="Configura\u00e7\u00f5es do sistema alteradas com sucesso.", responseCode="200")})
    @PostMapping
    @NotNull
    public SystemConfigDTO setSystemConfig(@Parameter(description="Payload de configura\u00e7\u00f5es do sistema.", required=true) @RequestBody @Valid @NotNull SystemConfigDTO request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        SystemConfigDTO systemConfigDTO = this.systemConfigService.saveConfiguracoesSistema(request);
        Intrinsics.checkNotNullExpressionValue((Object)systemConfigDTO, (String)"saveConfiguracoesSistema(...)");
        return systemConfigDTO;
    }

    @Operation(summary="Visualizar configura\u00e7\u00f5es padr\u00e3o do sistema.", description="Visuaizar configura\u00e7\u00f5es padr\u00e3o do sistema.")
    @GetMapping
    @NotNull
    public SystemConfigDTO getSystemConfig() {
        SystemConfigDTO systemConfigDTO = this.systemConfigService.getConfiguracoesSistema();
        Intrinsics.checkNotNullExpressionValue((Object)systemConfigDTO, (String)"getConfiguracoesSistema(...)");
        return systemConfigDTO;
    }
}

