/*
 * Decompiled with CFR 0.152.
 */
package br.com.sigescantt.apis;

import br.com.sigescantt.apis.BaseRestService;
import br.com.sigescantt.core.beans.geral.Empresa;
import br.com.sigescantt.core.beans.geral.Rodovia;
import br.com.sigescantt.core.beans.seguranca.PublicUser;
import br.com.sigescantt.core.dto.geral.rodovia.SaveRodoviaDTO;
import br.com.sigescantt.exceptions.BusinessException;
import br.com.sigescantt.services.CadastroService;
import br.com.sigescantt.services.CoreService;
import br.com.sigescantt.services.SegurancaService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(name="rodovias", description="Servi\u00e7os REST para consulta e gerenciamento de rodovias")
@RequestMapping(value={"/api/v1/empresas"})
@Validated
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ,\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0001\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u001aH\u0017J$\u0010\u001b\u001a\u00020\u00142\b\b\u0001\u0010\u001c\u001a\u00020\u00182\b\b\u0001\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0017J$\u0010\u001f\u001a\u00020\u00142\b\b\u0001\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010 \u001a\u00020!2\u0006\u0010\u0015\u001a\u00020\u0016H\u0017J.\u0010\"\u001a\u00020\u00142\b\b\u0001\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010 \u001a\u00020!2\b\b\u0001\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0017J \u0010#\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0017J$\u0010$\u001a\u00020%2\b\b\u0001\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010 \u001a\u00020!2\u0006\u0010\u0015\u001a\u00020\u0016H\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lbr/com/sigescantt/apis/RodoviasRestServices;", "Lbr/com/sigescantt/apis/BaseRestService;", "segurancaService", "Lbr/com/sigescantt/services/SegurancaService;", "coreService", "Lbr/com/sigescantt/services/CoreService;", "cadastroService", "Lbr/com/sigescantt/services/CadastroService;", "<init>", "(Lbr/com/sigescantt/services/SegurancaService;Lbr/com/sigescantt/services/CoreService;Lbr/com/sigescantt/services/CadastroService;)V", "getSegurancaService", "()Lbr/com/sigescantt/services/SegurancaService;", "getCoreService", "()Lbr/com/sigescantt/services/CoreService;", "getCadastroService", "()Lbr/com/sigescantt/services/CadastroService;", "LOG", "Lorg/slf4j/Logger;", "findRodovias", "Lorg/springframework/data/domain/Page;", "Lbr/com/sigescantt/core/beans/geral/Rodovia;", "request", "Ljakarta/servlet/http/HttpServletRequest;", "empresa", "", "pageable", "Lorg/springframework/data/domain/Pageable;", "createRodovia", "empresaSigla", "dto", "Lbr/com/sigescantt/core/dto/geral/rodovia/SaveRodoviaDTO;", "findRodoviaById", "idRodovia", "", "updateRodovia", "findRodoviasGeral", "deleteRodovia", "", "server"})
public class RodoviasRestServices
extends BaseRestService {
    @NotNull
    private final SegurancaService segurancaService;
    @NotNull
    private final CoreService coreService;
    @NotNull
    private final CadastroService cadastroService;
    @NotNull
    private final Logger LOG;

    public RodoviasRestServices(@NotNull SegurancaService segurancaService, @NotNull CoreService coreService, @NotNull CadastroService cadastroService) {
        Intrinsics.checkNotNullParameter((Object)segurancaService, (String)"segurancaService");
        Intrinsics.checkNotNullParameter((Object)coreService, (String)"coreService");
        Intrinsics.checkNotNullParameter((Object)cadastroService, (String)"cadastroService");
        super(segurancaService);
        this.segurancaService = segurancaService;
        this.coreService = coreService;
        this.cadastroService = cadastroService;
        Logger logger = LoggerFactory.getLogger(RodoviasRestServices.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.LOG = logger;
    }

    @NotNull
    public SegurancaService getSegurancaService() {
        return this.segurancaService;
    }

    @NotNull
    public CoreService getCoreService() {
        return this.coreService;
    }

    @NotNull
    public CadastroService getCadastroService() {
        return this.cadastroService;
    }

    @Operation(summary="Busca rodovias por empresa", description="Retorna uma lista de rodovias filtradas por empresa. Requer permiss\u00e3o 'RODOVIAS' ou 'RODOVIAS_LISTAGEM'.")
    @ApiResponses(value={@ApiResponse(description="Lista de rodovias encontrada com sucesso", responseCode="200")})
    @GetMapping(value={"/{empresa}/rodovias"})
    @NotNull
    public Page<Rodovia> findRodovias(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa para filtrar as rodovias") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="Par\u00e2metros de pagina\u00e7\u00e3o") @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        try {
            PublicUser publicUser = this.getUsuarioByJWT(request);
            if (publicUser == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            PublicUser usuario = publicUser;
            this.LOG.debug("{} - Iniciando findRodovias(emp={})...", (Object)usuario.getLogin(), (Object)empresa);
            String searchTxt = null;
            if (request.getParameter("search") != null) {
                searchTxt = request.getParameter("search");
            }
            Empresa empresa2 = this.getCoreService().getEmpresaBySigla(empresa);
            if (empresa2 == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            Empresa empresaDB = empresa2;
            LocalDateTime lastUpdate = null;
            if (request.getParameter("lastUpdate") != null) {
                DateTimeFormatter dateFmt;
                LocalDateTime localDateTime;
                try {
                    localDateTime = LocalDateTime.parse(request.getParameter("lastUpdate"));
                }
                catch (DateTimeParseException dteExc) {
                    localDateTime = null;
                }
                lastUpdate = localDateTime;
                if (lastUpdate == null) {
                    try {
                        dateFmt = DateTimeFormatter.ofPattern("dd/MM/yyyy-HH:mm:ss");
                        lastUpdate = LocalDateTime.parse(request.getParameter("lastUpdate"), dateFmt);
                    }
                    catch (DateTimeParseException dteExc) {
                        lastUpdate = null;
                    }
                }
                if (lastUpdate == null) {
                    try {
                        dateFmt = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss");
                        lastUpdate = LocalDateTime.parse(request.getParameter("lastUpdate"), dateFmt);
                    }
                    catch (DateTimeParseException dteExc) {
                        lastUpdate = null;
                    }
                }
                this.LOG.debug("Usando lastUpdate==> {}", (Object)lastUpdate);
            }
            Page rodovias = this.getCadastroService().findRodovias(searchTxt, empresaDB.getId(), lastUpdate, pageable);
            for (Rodovia rdv : rodovias) {
                rdv.setEmpresa(null);
            }
            Intrinsics.checkNotNull((Object)rodovias);
            return rodovias;
        }
        catch (BusinessException bizExc) {
            this.LOG.error("BizExc.findRodovias", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/rodovias"})
    @Operation(summary="Cria uma nova rodovia", description="Cria uma nova rodovia associada a uma empresa espec\u00edfica. Requer permiss\u00e3o 'RODOVIAS' ou 'RODOVIAS_CADASTRO'.")
    @ApiResponses(value={@ApiResponse(description="Rodovia criada com sucesso", responseCode="201")})
    @NotNull
    public Rodovia createRodovia(@Parameter(description="Sigla da empresa para associar a nova rodovia") @PathVariable(value="empresa") @NotNull String empresaSigla, @Parameter(description="Dados da nova rodovia a ser criada") @Valid @RequestBody @NotNull SaveRodoviaDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresaSigla, (String)"empresaSigla");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.LOG.debug("{} - Iniciando createRodovia(emp={})...", (Object)usuario.getLogin(), (Object)empresaSigla);
        CadastroService cadastroService = this.getCadastroService();
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        Rodovia rodovia = cadastroService.createRodovia(empresaSigla, dto, ((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)rodovia, (String)"createRodovia(...)");
        return rodovia;
    }

    @GetMapping(value={"/{empresa}/rodovias/{id}"})
    @Operation(summary="Busca uma rodovia por ID", description="Retorna os detalhes de uma rodovia espec\u00edfica pelo seu ID. Requer permiss\u00e3o 'RODOVIAS' ou 'RODOVIAS_LISTAGEM'.")
    @ApiResponses(value={@ApiResponse(description="Rodovia encontrada com sucesso", responseCode="200"), @ApiResponse(description="Rodovia n\u00e3o encontrada", responseCode="404")})
    @NotNull
    public Rodovia findRodoviaById(@Parameter(description="Sigla da empresa associada \u00e0 rodovia") @PathVariable(name="empresa") @NotNull String empresa, @Parameter(description="ID da rodovia a ser buscada") @PathVariable(name="id") int idRodovia, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Object[] objectArray = new Object[]{usuario.getLogin(), empresa, idRodovia};
        this.LOG.debug("{} - Iniciando findRodoviaById(emp={}, id={})...", objectArray);
        Rodovia rodovia = this.getCadastroService().getRodoviaById(idRodovia);
        Intrinsics.checkNotNullExpressionValue((Object)rodovia, (String)"getRodoviaById(...)");
        return rodovia;
    }

    @PutMapping(value={"/{empresa}/rodovias/{id}"})
    @Operation(summary="Atualiza uma rodovia existente", description="Atualiza os dados de uma rodovia existente. Requer permiss\u00e3o 'RODOVIAS' ou 'RODOVIAS_EDICAO'.")
    @ApiResponses(value={@ApiResponse(description="Rodovia atualizada com sucesso", responseCode="200"), @ApiResponse(description="Rodovia n\u00e3o encontrada", responseCode="404")})
    @NotNull
    public Rodovia updateRodovia(@Parameter(description="Sigla da empresa associada \u00e0 rodovia") @PathVariable(value="empresa") @NotNull String empresa, @Parameter(description="ID da rodovia a ser atualizada") @PathVariable(value="id") int idRodovia, @Parameter(description="Dados da rodovia a ser atualizada") @Valid @RequestBody @NotNull SaveRodoviaDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.LOG.debug("{} - Iniciando updateRodovia(id={})...", (Object)usuario.getLogin(), (Object)empresa);
        CadastroService cadastroService = this.getCadastroService();
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        Rodovia rodovia = cadastroService.updateRodovia(empresa, idRodovia, dto, ((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)rodovia, (String)"updateRodovia(...)");
        return rodovia;
    }

    @Operation(summary="Busca todas as rodovias do sistema", description="Retorna uma lista completa de rodovias do sistema sem filtrar por empresa")
    @ApiResponses(value={@ApiResponse(description="Lista de rodovias encontrada com sucesso", responseCode="200")})
    @GetMapping(value={"/rodovias"})
    @NotNull
    public Page<Rodovia> findRodoviasGeral(@Parameters(value={@Parameter(description="Requisi\u00e7\u00e3o HTTP contendo poss\u00edveis par\u00e2metros de busca e filtro"), @Parameter(description="Par\u00e2metros de pagina\u00e7\u00e3o")}) @NotNull Pageable pageable, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            PublicUser publicUser = this.getUsuarioByJWT(request);
            if (publicUser == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            PublicUser usuario = publicUser;
            this.LOG.debug("{} - Iniciando findRodoviasGeral()...", (Object)usuario.getLogin());
            String searchTxt = null;
            if (request.getParameter("search") != null) {
                searchTxt = request.getParameter("search");
            }
            LocalDateTime lastUpdate = null;
            if (request.getParameter("lastUpdate") != null) {
                DateTimeFormatter dateFmt;
                LocalDateTime localDateTime;
                try {
                    localDateTime = LocalDateTime.parse(request.getParameter("lastUpdate"));
                }
                catch (DateTimeParseException dteExc) {
                    localDateTime = null;
                }
                lastUpdate = localDateTime;
                if (lastUpdate == null) {
                    try {
                        dateFmt = DateTimeFormatter.ofPattern("dd/MM/yyyy-HH:mm:ss");
                        lastUpdate = LocalDateTime.parse(request.getParameter("lastUpdate"), dateFmt);
                    }
                    catch (DateTimeParseException dteExc) {
                        lastUpdate = null;
                    }
                }
                if (lastUpdate == null) {
                    try {
                        dateFmt = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss");
                        lastUpdate = LocalDateTime.parse(request.getParameter("lastUpdate"), dateFmt);
                    }
                    catch (DateTimeParseException dteExc) {
                        lastUpdate = null;
                    }
                }
                this.LOG.debug("Usando lastUpdate==> {}", (Object)lastUpdate);
            }
            Integer idEmpresa = null;
            Page rodovias = this.getCadastroService().findRodovias(searchTxt, idEmpresa, lastUpdate, pageable);
            for (Rodovia rdv : rodovias) {
                rdv.setEmpresa(null);
            }
            Intrinsics.checkNotNull((Object)rodovias);
            return rodovias;
        }
        catch (BusinessException bizExc) {
            this.LOG.error("BizExc.findRodoviasGeral", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/rodovias/{id}"})
    @Operation(summary="Remove uma rodovia", description="Remove uma rodovia existente pelo seu ID. Requer permiss\u00e3o 'RODOVIAS' ou 'RODOVIAS_EXCLUSAO'.")
    @ApiResponses(value={@ApiResponse(description="Rodovia removida com sucesso", responseCode="200"), @ApiResponse(description="Rodovia n\u00e3o encontrada", responseCode="404")})
    public void deleteRodovia(@Parameter(description="Sigla da empresa associada \u00e0 rodovia") @PathVariable(value="empresa") @NotNull String empresa, @Parameter(description="ID da rodovia a ser removida") @PathVariable(value="id") int idRodovia, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.LOG.debug("{} - Iniciando deleteRodovia(id={})...", (Object)usuario.getLogin(), (Object)idRodovia);
        this.getCadastroService().deleteRodovia(empresa, idRodovia);
    }
}

