/*
 * Decompiled with CFR 0.152.
 */
package br.com.sigescantt.apis;

import br.com.sigescantt.apis.BaseRestService;
import br.com.sigescantt.core.beans.seguranca.PublicUser;
import br.com.sigescantt.core.dto.relacoes.CreateRegistroInformacaoDTO;
import br.com.sigescantt.core.dto.relacoes.CreateRegistroReuniaoDTO;
import br.com.sigescantt.core.dto.relacoes.FindRegistrosInformacoesDTO;
import br.com.sigescantt.core.dto.relacoes.FindRegistrosReunioesDTO;
import br.com.sigescantt.core.dto.relacoes.SaveRegistroInformacaoParticipanteDTO;
import br.com.sigescantt.core.dto.relacoes.SaveRegistroReuniaoParticipanteDTO;
import br.com.sigescantt.core.dto.relacoes.UpdateRegistroInformacaoDTO;
import br.com.sigescantt.core.dto.relacoes.UpdateRegistroReuniaoDTO;
import br.com.sigescantt.relacoes.RegistroInformacao;
import br.com.sigescantt.relacoes.RegistroInformacaoAnexo;
import br.com.sigescantt.relacoes.RegistroInformacaoParticipante;
import br.com.sigescantt.relacoes.RegistroReuniao;
import br.com.sigescantt.relacoes.RegistroReuniaoAnexo;
import br.com.sigescantt.relacoes.RegistroReuniaoParticipante;
import br.com.sigescantt.services.SegurancaService;
import br.com.sigescantt.services.relacoes.RelacaoInstitucionalService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.annotations.ParameterObject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(name="Rela\u00e7\u00f5es Institucionais v1", description="REST Services para Rela\u00e7\u00f5es Institucionais v1")
@RequestMapping(value={"/api/v1/relacoes"})
@Validated
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\b\u0001\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u001c\u0010\u0011\u001a\u00020\f2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u0013H\u0017J\u001a\u0010\u0015\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J.\u0010\u0019\u001a\u00020\f2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u00132\b\b\u0001\u0010\r\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J\u001c\u0010\u001b\u001a\u00020\u001c2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u0013H\u0017J*\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u000b2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J&\u0010\u001f\u001a\u00020\u001e2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u00132\b\b\u0001\u0010 \u001a\u00020\u0013H\u0017J.\u0010!\u001a\u00020\u001e2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u00132\b\b\u0001\u0010\r\u001a\u00020\"2\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J0\u0010#\u001a\u00020\u001e2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u00132\b\b\u0001\u0010$\u001a\u00020\u00132\b\b\u0001\u0010\r\u001a\u00020\"H\u0017J&\u0010%\u001a\u00020\u001c2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u00132\b\b\u0001\u0010 \u001a\u00020\u0013H\u0017J*\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u000b2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J&\u0010(\u001a\u00020'2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u00132\b\b\u0001\u0010 \u001a\u00020\u0013H\u0017J.\u0010)\u001a\u00020'2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u00132\b\b\u0001\u0010*\u001a\u00020+2\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J&\u0010,\u001a\u00020\u001c2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u00132\b\b\u0001\u0010 \u001a\u00020\u0013H\u0017J \u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u000b2\b\b\u0001\u0010\r\u001a\u00020/2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u0012\u00100\u001a\u00020.2\b\b\u0001\u0010\u0014\u001a\u00020\u0013H\u0017J\u001a\u00101\u001a\u00020.2\b\b\u0001\u0010\r\u001a\u0002022\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J$\u00103\u001a\u00020.2\b\b\u0001\u0010\u0014\u001a\u00020\u00132\b\b\u0001\u0010\r\u001a\u0002042\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J\u0012\u00105\u001a\u00020\u001c2\b\b\u0001\u0010\u0014\u001a\u00020\u0013H\u0017J \u00106\u001a\b\u0012\u0004\u0012\u0002070\u000b2\b\b\u0001\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u001c\u00108\u001a\u0002072\b\b\u0001\u0010\u0014\u001a\u00020\u00132\b\b\u0001\u0010 \u001a\u00020\u0013H\u0017J$\u00109\u001a\u0002072\b\b\u0001\u0010\u0014\u001a\u00020\u00132\b\b\u0001\u0010\r\u001a\u00020:2\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J&\u0010;\u001a\u0002072\b\b\u0001\u0010\u0014\u001a\u00020\u00132\b\b\u0001\u0010 \u001a\u00020\u00132\b\b\u0001\u0010\r\u001a\u00020:H\u0017J\u001c\u0010<\u001a\u00020\u001c2\b\b\u0001\u0010\u0014\u001a\u00020\u00132\b\b\u0001\u0010 \u001a\u00020\u0013H\u0017J \u0010=\u001a\b\u0012\u0004\u0012\u00020>0\u000b2\b\b\u0001\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u001c\u0010?\u001a\u00020>2\b\b\u0001\u0010\u0014\u001a\u00020\u00132\b\b\u0001\u0010 \u001a\u00020\u0013H\u0017J$\u0010@\u001a\u00020>2\b\b\u0001\u0010\u0014\u001a\u00020\u00132\b\b\u0001\u0010*\u001a\u00020+2\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J\u001c\u0010A\u001a\u00020\u001c2\b\b\u0001\u0010\u0014\u001a\u00020\u00132\b\b\u0001\u0010 \u001a\u00020\u0013H\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lbr/com/sigescantt/apis/RelacaoInstitucionalRestServices;", "Lbr/com/sigescantt/apis/BaseRestService;", "segurancaService", "Lbr/com/sigescantt/services/SegurancaService;", "relacaoInstitucionalService", "Lbr/com/sigescantt/services/relacoes/RelacaoInstitucionalService;", "<init>", "(Lbr/com/sigescantt/services/SegurancaService;Lbr/com/sigescantt/services/relacoes/RelacaoInstitucionalService;)V", "LOGGER", "Lorg/slf4j/Logger;", "findRegistrosReunioes", "Lorg/springframework/data/domain/Page;", "Lbr/com/sigescantt/relacoes/RegistroReuniao;", "dto", "Lbr/com/sigescantt/core/dto/relacoes/FindRegistrosReunioesDTO;", "pageable", "Lorg/springframework/data/domain/Pageable;", "findRegistroReuniaoById", "empresaId", "", "registroId", "createRegistroReuniao", "Lbr/com/sigescantt/core/dto/relacoes/CreateRegistroReuniaoDTO;", "request", "Ljakarta/servlet/http/HttpServletRequest;", "updateRegistroReuniao", "Lbr/com/sigescantt/core/dto/relacoes/UpdateRegistroReuniaoDTO;", "deleteRegistroReuniao", "", "findParticipantesReuniao", "Lbr/com/sigescantt/relacoes/RegistroReuniaoParticipante;", "getParticipanteReuniaoById", "sequencia", "createParticipanteReuniao", "Lbr/com/sigescantt/core/dto/relacoes/SaveRegistroReuniaoParticipanteDTO;", "updateParticipanteReuniao", "participanteId", "deleteParticipanteReuniao", "findAnexosReuniao", "Lbr/com/sigescantt/relacoes/RegistroReuniaoAnexo;", "findAnexoReuniaoById", "createAnexoReuniao", "file", "Lorg/springframework/web/multipart/MultipartFile;", "deleteAnexoReuniao", "findRegistrosInformacoes", "Lbr/com/sigescantt/relacoes/RegistroInformacao;", "Lbr/com/sigescantt/core/dto/relacoes/FindRegistrosInformacoesDTO;", "findRegistroInformacaoById", "createRegistroInformacao", "Lbr/com/sigescantt/core/dto/relacoes/CreateRegistroInformacaoDTO;", "updateRegistroInformacao", "Lbr/com/sigescantt/core/dto/relacoes/UpdateRegistroInformacaoDTO;", "deleteRegistroInformacao", "findParticipantesInformacao", "Lbr/com/sigescantt/relacoes/RegistroInformacaoParticipante;", "findParticipanteInformacaoById", "createParticipanteInformacao", "Lbr/com/sigescantt/core/dto/relacoes/SaveRegistroInformacaoParticipanteDTO;", "updateParticipanteInformacao", "deleteParticipanteInformacao", "findAnexosInformacao", "Lbr/com/sigescantt/relacoes/RegistroInformacaoAnexo;", "findAnexoInformacaoById", "saveAnexoInformacao", "deleteAnexoInformacao", "server"})
public class RelacaoInstitucionalRestServices
extends BaseRestService {
    @NotNull
    private final RelacaoInstitucionalService relacaoInstitucionalService;
    @NotNull
    private final Logger LOGGER;

    public RelacaoInstitucionalRestServices(@NotNull SegurancaService segurancaService, @NotNull RelacaoInstitucionalService relacaoInstitucionalService) {
        Intrinsics.checkNotNullParameter((Object)segurancaService, (String)"segurancaService");
        Intrinsics.checkNotNullParameter((Object)relacaoInstitucionalService, (String)"relacaoInstitucionalService");
        super(segurancaService);
        this.relacaoInstitucionalService = relacaoInstitucionalService;
        Logger logger = LoggerFactory.getLogger(RelacaoInstitucionalRestServices.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.LOGGER = logger;
    }

    @Operation(summary="Lista registros de reuni\u00f5es com filtros")
    @ApiResponses(value={@ApiResponse(description="Registros encontrados", responseCode="200")})
    @GetMapping(value={"/reunioes"})
    @NotNull
    public Page<RegistroReuniao> findRegistrosReunioes(@ParameterObject @Valid @NotNull FindRegistrosReunioesDTO dto, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Page page = this.relacaoInstitucionalService.findRegistrosReunioes(dto, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findRegistrosReunioes(...)");
        return page;
    }

    @Operation(summary="Busca registro de reuni\u00e3o por ID")
    @ApiResponses(value={@ApiResponse(description="Registro encontrado", responseCode="200")})
    @GetMapping(value={"/reunioes/{empresaId}/{registroId}"})
    @NotNull
    public RegistroReuniao findRegistroReuniaoById(@Parameter(description="ID da empresa") @PathVariable int empresaId, @Parameter(description="ID do registro") @PathVariable int registroId) {
        RegistroReuniao registroReuniao = this.relacaoInstitucionalService.findRegistroReuniaoById(empresaId, registroId);
        Intrinsics.checkNotNullExpressionValue((Object)registroReuniao, (String)"findRegistroReuniaoById(...)");
        return registroReuniao;
    }

    @Operation(summary="Cria novo registro de reuni\u00e3o")
    @ApiResponses(value={@ApiResponse(description="Registro criado", responseCode="201")})
    @PostMapping(value={"/reunioes"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @NotNull
    public RegistroReuniao createRegistroReuniao(@Valid @RequestBody @NotNull CreateRegistroReuniaoDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        RegistroReuniao registroReuniao = this.relacaoInstitucionalService.createRegistroReuniao(dto, ((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)registroReuniao, (String)"createRegistroReuniao(...)");
        return registroReuniao;
    }

    @Operation(summary="Atualiza registro de reuni\u00e3o")
    @ApiResponses(value={@ApiResponse(description="Registro atualizado", responseCode="200")})
    @PutMapping(value={"/reunioes/{empresaId}/{registroId}"})
    @NotNull
    public RegistroReuniao updateRegistroReuniao(@Parameter(description="ID da empresa") @PathVariable int empresaId, @Parameter(description="ID do registro") @PathVariable int registroId, @Valid @RequestBody @NotNull UpdateRegistroReuniaoDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        RegistroReuniao registroReuniao = this.relacaoInstitucionalService.updateRegistroReuniao(empresaId, registroId, dto, ((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)registroReuniao, (String)"updateRegistroReuniao(...)");
        return registroReuniao;
    }

    @Operation(summary="Remove registro de reuni\u00e3o")
    @ApiResponses(value={@ApiResponse(description="Registro removido", responseCode="200")})
    @DeleteMapping(value={"/reunioes/{empresaId}/{registroId}"})
    public void deleteRegistroReuniao(@Parameter(description="ID da empresa") @PathVariable int empresaId, @Parameter(description="ID do registro") @PathVariable int registroId) {
        this.relacaoInstitucionalService.deleteRegistroReuniao(empresaId, registroId);
    }

    @Operation(summary="Lista participantes da reuni\u00e3o")
    @ApiResponses(value={@ApiResponse(description="Participantes encontrados", responseCode="200")})
    @GetMapping(value={"/reunioes/{empresaId}/{registroId}/participantes"})
    @NotNull
    public Page<RegistroReuniaoParticipante> findParticipantesReuniao(@Parameter(description="ID da empresa") @PathVariable int empresaId, @Parameter(description="ID do registro") @PathVariable int registroId, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Page page = this.relacaoInstitucionalService.findParticipantesReuniao(empresaId, registroId, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findParticipantesReuniao(...)");
        return page;
    }

    @Operation(summary="Busca participante da reuni\u00e3o por ID")
    @ApiResponses(value={@ApiResponse(description="Participante encontrado", responseCode="200")})
    @GetMapping(value={"/reunioes/{empresaId}/{registroId}/participantes/{sequencia}"})
    @NotNull
    public RegistroReuniaoParticipante getParticipanteReuniaoById(@Parameter(description="ID da empresa") @PathVariable int empresaId, @Parameter(description="ID do registro") @PathVariable int registroId, @Parameter(description="Sequ\u00eancia do participante") @PathVariable int sequencia) {
        RegistroReuniaoParticipante registroReuniaoParticipante = this.relacaoInstitucionalService.getParticipanteReuniaoById(empresaId, registroId, sequencia);
        Intrinsics.checkNotNullExpressionValue((Object)registroReuniaoParticipante, (String)"getParticipanteReuniaoById(...)");
        return registroReuniaoParticipante;
    }

    @Operation(summary="Adiciona participante \u00e0 reuni\u00e3o")
    @ApiResponses(value={@ApiResponse(description="Participante adicionado", responseCode="201")})
    @PostMapping(value={"/reunioes/{empresaId}/{registroId}/participantes"})
    @NotNull
    public RegistroReuniaoParticipante createParticipanteReuniao(@Parameter(description="ID da empresa") @PathVariable int empresaId, @Parameter(description="ID do registro") @PathVariable int registroId, @Valid @RequestBody @NotNull SaveRegistroReuniaoParticipanteDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        RegistroReuniaoParticipante registroReuniaoParticipante = this.relacaoInstitucionalService.createParticipanteReuniao(empresaId, registroId, dto, ((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)registroReuniaoParticipante, (String)"createParticipanteReuniao(...)");
        return registroReuniaoParticipante;
    }

    @Operation(summary="Atualiza participante da reuni\u00e3o")
    @ApiResponses(value={@ApiResponse(description="Participante atualizado", responseCode="200")})
    @PutMapping(value={"/reunioes/{empresaId}/{registroId}/participantes/{participanteId}"})
    @NotNull
    public RegistroReuniaoParticipante updateParticipanteReuniao(@Parameter(description="ID da empresa") @PathVariable int empresaId, @Parameter(description="ID do registro") @PathVariable int registroId, @Parameter(description="ID do participante") @PathVariable int participanteId, @Valid @RequestBody @NotNull SaveRegistroReuniaoParticipanteDTO dto) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        RegistroReuniaoParticipante registroReuniaoParticipante = this.relacaoInstitucionalService.updateParticipanteReuniao(empresaId, registroId, participanteId, dto);
        Intrinsics.checkNotNullExpressionValue((Object)registroReuniaoParticipante, (String)"updateParticipanteReuniao(...)");
        return registroReuniaoParticipante;
    }

    @Operation(summary="Remove participante da reuni\u00e3o")
    @ApiResponses(value={@ApiResponse(description="Participante removido", responseCode="200")})
    @DeleteMapping(value={"/reunioes/{empresaId}/{registroId}/participantes/{sequencia}"})
    public void deleteParticipanteReuniao(@Parameter(description="ID da empresa") @PathVariable int empresaId, @Parameter(description="ID do registro") @PathVariable int registroId, @Parameter(description="Sequ\u00eancia do participante") @PathVariable int sequencia) {
        this.relacaoInstitucionalService.deleteParticipanteReuniao(empresaId, registroId, sequencia);
    }

    @Operation(summary="Lista anexos da reuni\u00e3o")
    @ApiResponses(value={@ApiResponse(description="Anexos encontrados", responseCode="200")})
    @GetMapping(value={"/reunioes/{empresaId}/{registroId}/anexos"})
    @NotNull
    public Page<RegistroReuniaoAnexo> findAnexosReuniao(@Parameter(description="ID da empresa") @PathVariable int empresaId, @Parameter(description="ID do registro") @PathVariable int registroId, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Page page = this.relacaoInstitucionalService.findAnexosReuniao(empresaId, registroId, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findAnexosReuniao(...)");
        return page;
    }

    @Operation(summary="Busca anexo da reuni\u00e3o por ID")
    @ApiResponses(value={@ApiResponse(description="Anexo encontrado", responseCode="200")})
    @GetMapping(value={"/reunioes/{empresaId}/{registroId}/anexos/{sequencia}"})
    @NotNull
    public RegistroReuniaoAnexo findAnexoReuniaoById(@Parameter(description="ID da empresa") @PathVariable int empresaId, @Parameter(description="ID do registro") @PathVariable int registroId, @Parameter(description="Sequ\u00eancia do anexo") @PathVariable int sequencia) {
        RegistroReuniaoAnexo registroReuniaoAnexo = this.relacaoInstitucionalService.findAnexoReuniaoById(empresaId, registroId, sequencia);
        Intrinsics.checkNotNullExpressionValue((Object)registroReuniaoAnexo, (String)"findAnexoReuniaoById(...)");
        return registroReuniaoAnexo;
    }

    @Operation(summary="Adiciona anexo \u00e0 reuni\u00e3o")
    @ApiResponses(value={@ApiResponse(description="Anexo adicionado", responseCode="201")})
    @PostMapping(value={"/reunioes/{empresaId}/{registroId}/anexos"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @NotNull
    public RegistroReuniaoAnexo createAnexoReuniao(@Parameter(description="ID da empresa") @PathVariable int empresaId, @Parameter(description="ID do registro") @PathVariable int registroId, @Parameter(description="Arquivo") @RequestPart(required=true) @NotNull MultipartFile file, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        RegistroReuniaoAnexo registroReuniaoAnexo = this.relacaoInstitucionalService.createAnexoReuniao(empresaId, registroId, file, ((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)registroReuniaoAnexo, (String)"createAnexoReuniao(...)");
        return registroReuniaoAnexo;
    }

    @Operation(summary="Remove anexo da reuni\u00e3o")
    @ApiResponses(value={@ApiResponse(description="Anexo removido", responseCode="200")})
    @DeleteMapping(value={"/reunioes/{empresaId}/{registroId}/anexos/{sequencia}"})
    public void deleteAnexoReuniao(@Parameter(description="ID da empresa") @PathVariable int empresaId, @Parameter(description="ID do registro") @PathVariable int registroId, @Parameter(description="Sequ\u00eancia do anexo") @PathVariable int sequencia) {
        this.relacaoInstitucionalService.deleteAnexoReuniao(empresaId, registroId, sequencia);
    }

    @Operation(summary="Lista registros de informa\u00e7\u00f5es com filtros")
    @ApiResponses(value={@ApiResponse(description="Registros encontrados", responseCode="200")})
    @GetMapping(value={"/informacoes"})
    @NotNull
    public Page<RegistroInformacao> findRegistrosInformacoes(@ParameterObject @Valid @NotNull FindRegistrosInformacoesDTO dto, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Page page = this.relacaoInstitucionalService.findRegistrosInformacoes(dto, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findRegistrosInformacoes(...)");
        return page;
    }

    @Operation(summary="Busca registro de informa\u00e7\u00e3o por ID")
    @ApiResponses(value={@ApiResponse(description="Registro encontrado", responseCode="200")})
    @GetMapping(value={"/informacoes/{registroId}"})
    @NotNull
    public RegistroInformacao findRegistroInformacaoById(@Parameter(description="ID do registro") @PathVariable int registroId) {
        RegistroInformacao registroInformacao = this.relacaoInstitucionalService.findRegistroInformacaoById(registroId);
        Intrinsics.checkNotNullExpressionValue((Object)registroInformacao, (String)"findRegistroInformacaoById(...)");
        return registroInformacao;
    }

    @Operation(summary="Cria novo registro de informa\u00e7\u00e3o")
    @ApiResponses(value={@ApiResponse(description="Registro criado", responseCode="201")})
    @PostMapping(value={"/informacoes"})
    @NotNull
    public RegistroInformacao createRegistroInformacao(@Valid @RequestBody @NotNull CreateRegistroInformacaoDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        RegistroInformacao registroInformacao = this.relacaoInstitucionalService.createRegistroInformacao(dto, ((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)registroInformacao, (String)"createRegistroInformacao(...)");
        return registroInformacao;
    }

    @Operation(summary="Atualiza registro de informa\u00e7\u00e3o")
    @ApiResponses(value={@ApiResponse(description="Registro atualizado", responseCode="200")})
    @PutMapping(value={"/informacoes/{registroId}"})
    @NotNull
    public RegistroInformacao updateRegistroInformacao(@Parameter(description="ID do registro") @PathVariable int registroId, @Valid @RequestBody @NotNull UpdateRegistroInformacaoDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        RegistroInformacao registroInformacao = this.relacaoInstitucionalService.updateRegistroInformacao(registroId, dto, ((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)registroInformacao, (String)"updateRegistroInformacao(...)");
        return registroInformacao;
    }

    @Operation(summary="Remove registro de informa\u00e7\u00e3o")
    @ApiResponses(value={@ApiResponse(description="Registro removido", responseCode="200")})
    @DeleteMapping(value={"/informacoes/{registroId}"})
    public void deleteRegistroInformacao(@Parameter(description="ID do registro") @PathVariable int registroId) {
        this.relacaoInstitucionalService.deleteRegistroInformacao(registroId);
    }

    @Operation(summary="Lista participantes da informa\u00e7\u00e3o")
    @ApiResponses(value={@ApiResponse(description="Participantes encontrados", responseCode="200")})
    @GetMapping(value={"/informacoes/{registroId}/participantes"})
    @NotNull
    public Page<RegistroInformacaoParticipante> findParticipantesInformacao(@Parameter(description="ID do registro") @PathVariable int registroId, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Page page = this.relacaoInstitucionalService.findParticipantesInformacao(registroId, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findParticipantesInformacao(...)");
        return page;
    }

    @Operation(summary="Busca participante da informa\u00e7\u00e3o por ID")
    @ApiResponses(value={@ApiResponse(description="Participante encontrado", responseCode="200")})
    @GetMapping(value={"/informacoes/{registroId}/participantes/{sequencia}"})
    @NotNull
    public RegistroInformacaoParticipante findParticipanteInformacaoById(@Parameter(description="ID do registro") @PathVariable int registroId, @Parameter(description="Sequ\u00eancia do participante") @PathVariable int sequencia) {
        RegistroInformacaoParticipante registroInformacaoParticipante = this.relacaoInstitucionalService.findParticipanteInformacaoById(registroId, sequencia);
        Intrinsics.checkNotNullExpressionValue((Object)registroInformacaoParticipante, (String)"findParticipanteInformacaoById(...)");
        return registroInformacaoParticipante;
    }

    @Operation(summary="Adiciona participante \u00e0 informa\u00e7\u00e3o")
    @ApiResponses(value={@ApiResponse(description="Participante adicionado", responseCode="201")})
    @PostMapping(value={"/informacoes/{registroId}/participantes"})
    @NotNull
    public RegistroInformacaoParticipante createParticipanteInformacao(@Parameter(description="ID do registro") @PathVariable int registroId, @Valid @RequestBody @NotNull SaveRegistroInformacaoParticipanteDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        RegistroInformacaoParticipante registroInformacaoParticipante = this.relacaoInstitucionalService.createParticipanteInformacao(registroId, dto, ((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)registroInformacaoParticipante, (String)"createParticipanteInformacao(...)");
        return registroInformacaoParticipante;
    }

    @Operation(summary="Atualiza participante da informa\u00e7\u00e3o")
    @ApiResponses(value={@ApiResponse(description="Participante atualizado", responseCode="200")})
    @PutMapping(value={"/informacoes/{registroId}/participantes/{sequencia}"})
    @NotNull
    public RegistroInformacaoParticipante updateParticipanteInformacao(@Parameter(description="ID do registro") @PathVariable int registroId, @Parameter(description="Sequ\u00eancia do participante") @PathVariable int sequencia, @Valid @RequestBody @NotNull SaveRegistroInformacaoParticipanteDTO dto) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        RegistroInformacaoParticipante registroInformacaoParticipante = this.relacaoInstitucionalService.updateParticipanteInformacao(registroId, sequencia, dto);
        Intrinsics.checkNotNullExpressionValue((Object)registroInformacaoParticipante, (String)"updateParticipanteInformacao(...)");
        return registroInformacaoParticipante;
    }

    @Operation(summary="Remove participante da informa\u00e7\u00e3o")
    @ApiResponses(value={@ApiResponse(description="Participante removido", responseCode="200")})
    @DeleteMapping(value={"/informacoes/{registroId}/participantes/{sequencia}"})
    public void deleteParticipanteInformacao(@Parameter(description="ID do registro") @PathVariable int registroId, @Parameter(description="Sequ\u00eancia do participante") @PathVariable int sequencia) {
        this.relacaoInstitucionalService.deleteParticipanteInformacao(registroId, sequencia);
    }

    @Operation(summary="Lista anexos da informa\u00e7\u00e3o")
    @ApiResponses(value={@ApiResponse(description="Anexos encontrados", responseCode="200")})
    @GetMapping(value={"/informacoes/{registroId}/anexos"})
    @NotNull
    public Page<RegistroInformacaoAnexo> findAnexosInformacao(@Parameter(description="ID do registro") @PathVariable int registroId, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Page page = this.relacaoInstitucionalService.findAnexosInformacao(registroId, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findAnexosInformacao(...)");
        return page;
    }

    @Operation(summary="Busca anexo da informa\u00e7\u00e3o por ID")
    @ApiResponses(value={@ApiResponse(description="Anexo encontrado", responseCode="200")})
    @GetMapping(value={"/informacoes/{registroId}/anexos/{sequencia}"})
    @NotNull
    public RegistroInformacaoAnexo findAnexoInformacaoById(@Parameter(description="ID do registro") @PathVariable int registroId, @Parameter(description="Sequ\u00eancia do anexo") @PathVariable int sequencia) {
        RegistroInformacaoAnexo registroInformacaoAnexo = this.relacaoInstitucionalService.findAnexoInformacaoById(registroId, sequencia);
        Intrinsics.checkNotNullExpressionValue((Object)registroInformacaoAnexo, (String)"findAnexoInformacaoById(...)");
        return registroInformacaoAnexo;
    }

    @Operation(summary="Adiciona anexo \u00e0 informa\u00e7\u00e3o")
    @ApiResponses(value={@ApiResponse(description="Anexo adicionado", responseCode="201")})
    @PostMapping(value={"/informacoes/{registroId}/anexos"})
    @NotNull
    public RegistroInformacaoAnexo saveAnexoInformacao(@Parameter(description="ID do registro") @PathVariable int registroId, @Parameter(description="Arquivo") @RequestPart(required=true) @NotNull MultipartFile file, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        RegistroInformacaoAnexo registroInformacaoAnexo = this.relacaoInstitucionalService.saveAnexoInformacao(registroId, file, ((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)registroInformacaoAnexo, (String)"saveAnexoInformacao(...)");
        return registroInformacaoAnexo;
    }

    @Operation(summary="Remove anexo da informa\u00e7\u00e3o")
    @ApiResponses(value={@ApiResponse(description="Anexo removido", responseCode="200")})
    @DeleteMapping(value={"/informacoes/{registroId}/anexos/{sequencia}"})
    public void deleteAnexoInformacao(@Parameter(description="ID do registro") @PathVariable int registroId, @Parameter(description="Sequ\u00eancia do anexo") @PathVariable int sequencia) {
        this.relacaoInstitucionalService.deleteAnexoInformacao(registroId, sequencia);
    }
}

