/*
 * Decompiled with CFR 0.152.
 */
package br.com.sigescantt.apis;

import br.com.sigescantt.apis.BaseRestService;
import br.com.sigescantt.core.beans.seguranca.PublicUser;
import br.com.sigescantt.core.dto.pleitos.FindPleitosDTO;
import br.com.sigescantt.core.dto.pleitos.PleitoPrimeiraFaseDTO;
import br.com.sigescantt.core.dto.pleitos.PleitoSegundaFaseDTO;
import br.com.sigescantt.core.dto.pleitos.UpdatePleitoDTO;
import br.com.sigescantt.core.dto.pleitos.anexo.FindPleitoAnexosDTO;
import br.com.sigescantt.core.dto.pleitos.demandante.SaveDemandanteDTO;
import br.com.sigescantt.core.dto.pleitos.historico.CreateHistoricoDTO;
import br.com.sigescantt.core.dto.pleitos.historico.UpdateHistoricoDTO;
import br.com.sigescantt.core.dto.pleitos.itemContratual.CreatePleitoItemContratualDTO;
import br.com.sigescantt.core.dto.pleitos.logs.CreatePleitoLogDTO;
import br.com.sigescantt.core.dto.pleitos.rodovia.CreatePleitoRodoviaDTO;
import br.com.sigescantt.core.dto.pleitos.rodovia.UpdatePleitoRodoviaDTO;
import br.com.sigescantt.exceptions.BusinessException;
import br.com.sigescantt.geral.importacao.ProcessoImportacao;
import br.com.sigescantt.pleitos.HistoricoPleito;
import br.com.sigescantt.pleitos.Pleito;
import br.com.sigescantt.pleitos.PleitoAnexo;
import br.com.sigescantt.pleitos.PleitoDemandante;
import br.com.sigescantt.pleitos.PleitoEstruturaContrato;
import br.com.sigescantt.pleitos.PleitoLog;
import br.com.sigescantt.pleitos.PleitoRodovia;
import br.com.sigescantt.services.Exceptions.ErrorCode;
import br.com.sigescantt.services.Exceptions.ErrorCodeException;
import br.com.sigescantt.services.PleitoService;
import br.com.sigescantt.services.SegurancaService;
import br.com.sigescantt.services.helpers.ImportacaoPleitoHelper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.annotations.ParameterObject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(name="pleitos", description="REST Services para Pleitos")
@RequestMapping(value={"/api/v1/pleitos"})
@Validated
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00e0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J4\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010\u000e\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J$\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J.\u0010\u001d\u001a\u00020\r2\b\b\u0001\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010\u000e\u001a\u00020\u001e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J$\u0010\u001f\u001a\u00020 2\b\b\u0001\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J*\u0010!\u001a\b\u0012\u0004\u0012\u00020\r0\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J(\u0010\"\u001a\b\u0012\u0004\u0012\u00020\r0#2\b\b\u0001\u0010\u000e\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J.\u0010'\u001a\u00020(2\b\b\u0001\u0010)\u001a\u00020\u00172\b\b\u0001\u0010*\u001a\u00020\u00172\b\b\u0001\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J*\u0010+\u001a\b\u0012\u0004\u0012\u00020(0#2\b\b\u0001\u0010)\u001a\u00020\u00172\b\b\u0001\u0010*\u001a\u00020\u00172\u0006\u0010%\u001a\u00020&H\u0017J \u0010+\u001a\b\u0012\u0004\u0012\u00020(0#2\b\b\u0001\u0010\u000e\u001a\u00020,2\u0006\u0010%\u001a\u00020&H\u0017J.\u0010-\u001a\u00020 2\b\b\u0001\u0010)\u001a\u00020\u00172\b\b\u0001\u0010*\u001a\u00020\u00172\b\b\u0001\u0010.\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J:\u0010/\u001a\u0002002\b\b\u0001\u00101\u001a\u00020\u00152\b\b\u0001\u0010*\u001a\u00020\u00172\b\b\u0001\u0010\u000e\u001a\u0002022\n\b\u0001\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J2\u00103\u001a\b\u0012\u0004\u0012\u0002000#2\b\b\u0001\u00101\u001a\u00020\u00152\b\b\u0001\u0010*\u001a\u00020\u00172\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017JD\u00104\u001a\u0002002\b\b\u0001\u00101\u001a\u00020\u00152\b\b\u0001\u0010*\u001a\u00020\u00172\b\b\u0001\u00105\u001a\u00020\u00172\b\b\u0001\u0010\u000e\u001a\u0002062\n\b\u0001\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J.\u00107\u001a\u00020 2\b\b\u0001\u00101\u001a\u00020\u00152\b\b\u0001\u0010*\u001a\u00020\u00172\b\b\u0001\u00105\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J.\u00108\u001a\u00020 2\b\b\u0001\u00101\u001a\u00020\u00152\b\b\u0001\u0010*\u001a\u00020\u00172\b\b\u0001\u00105\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J*\u00109\u001a\b\u0012\u0004\u0012\u00020:0#2\b\b\u0001\u00101\u001a\u00020\u00152\b\b\u0001\u0010*\u001a\u00020\u00172\u0006\u0010%\u001a\u00020&H\u0017J4\u0010;\u001a\b\u0012\u0004\u0012\u00020:0<2\b\b\u0001\u00101\u001a\u00020\u00152\b\b\u0001\u0010*\u001a\u00020\u00172\b\b\u0001\u0010\u000e\u001a\u00020=2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J.\u0010>\u001a\u00020 2\b\b\u0001\u00101\u001a\u00020\u00152\b\b\u0001\u0010*\u001a\u00020\u00172\b\b\u0001\u0010?\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J*\u0010@\u001a\b\u0012\u0004\u0012\u00020A0#2\b\b\u0001\u00101\u001a\u00020\u00152\b\b\u0001\u0010*\u001a\u00020\u00172\u0006\u0010%\u001a\u00020&H\u0017J.\u0010B\u001a\u00020A2\b\b\u0001\u00101\u001a\u00020\u00152\b\b\u0001\u0010*\u001a\u00020\u00172\b\b\u0001\u0010\u000e\u001a\u00020C2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J8\u0010D\u001a\u00020A2\b\b\u0001\u00101\u001a\u00020\u00152\b\b\u0001\u0010*\u001a\u00020\u00172\b\b\u0001\u0010E\u001a\u00020\u00172\b\b\u0001\u0010\u000e\u001a\u00020F2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J.\u0010G\u001a\u00020 2\b\b\u0001\u00101\u001a\u00020\u00152\b\b\u0001\u0010*\u001a\u00020\u00172\b\b\u0001\u0010E\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J$\u0010H\u001a\u00020 2\b\b\u0001\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010*\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J*\u0010I\u001a\b\u0012\u0004\u0012\u00020J0#2\b\b\u0001\u00101\u001a\u00020\u00152\b\b\u0001\u0010*\u001a\u00020\u00172\u0006\u0010%\u001a\u00020&H\u0017J.\u0010K\u001a\u00020J2\b\b\u0001\u00101\u001a\u00020\u00152\b\b\u0001\u0010*\u001a\u00020\u00172\b\b\u0001\u0010\u000e\u001a\u00020L2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\u0012\u0010M\u001a\u00020N2\b\b\u0001\u0010O\u001a\u00020\u0017H\u0017J\"\u0010P\u001a\b\u0012\u0004\u0012\u00020N0#2\n\b\u0001\u0010Q\u001a\u0004\u0018\u00010\u00152\u0006\u0010%\u001a\u00020&H\u0017J\u001a\u0010R\u001a\b\u0012\u0004\u0012\u00020\u00150<2\n\b\u0001\u0010Q\u001a\u0004\u0018\u00010\u0015H\u0017J\u001a\u0010S\u001a\u00020N2\b\b\u0001\u0010\u000e\u001a\u00020T2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J$\u0010U\u001a\u00020N2\b\b\u0001\u0010O\u001a\u00020\u00172\b\b\u0001\u0010\u000e\u001a\u00020T2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\u0012\u0010V\u001a\u00020 2\b\b\u0001\u0010O\u001a\u00020\u0017H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006W"}, d2={"Lbr/com/sigescantt/apis/PleitosRestServices;", "Lbr/com/sigescantt/apis/BaseRestService;", "segurancaService", "Lbr/com/sigescantt/services/SegurancaService;", "pleitoService", "Lbr/com/sigescantt/services/PleitoService;", "importacaoPleitoHelper", "Lbr/com/sigescantt/services/helpers/ImportacaoPleitoHelper;", "<init>", "(Lbr/com/sigescantt/services/SegurancaService;Lbr/com/sigescantt/services/PleitoService;Lbr/com/sigescantt/services/helpers/ImportacaoPleitoHelper;)V", "LOGGER", "Lorg/slf4j/Logger;", "savePleitoPrimeiraFase", "Lbr/com/sigescantt/pleitos/Pleito;", "dto", "Lbr/com/sigescantt/core/dto/pleitos/PleitoPrimeiraFaseDTO;", "request", "Ljakarta/servlet/http/HttpServletRequest;", "savePleitoSegundaFase", "Lorg/springframework/http/ResponseEntity;", "empresa", "", "idPleito", "", "Lbr/com/sigescantt/core/dto/pleitos/PleitoSegundaFaseDTO;", "importPleitos", "Lbr/com/sigescantt/geral/importacao/ProcessoImportacao;", "file", "Lorg/springframework/web/multipart/MultipartFile;", "updatePleito", "Lbr/com/sigescantt/core/dto/pleitos/UpdatePleitoDTO;", "deletePleito", "", "getPleito", "findPleitos", "Lorg/springframework/data/domain/Page;", "Lbr/com/sigescantt/core/dto/pleitos/FindPleitosDTO;", "pageable", "Lorg/springframework/data/domain/Pageable;", "createAnexo", "Lbr/com/sigescantt/pleitos/PleitoAnexo;", "empresaId", "pleitoId", "findAnexos", "Lbr/com/sigescantt/core/dto/pleitos/anexo/FindPleitoAnexosDTO;", "deleteAnexo", "anexoId", "createHistorico", "Lbr/com/sigescantt/pleitos/HistoricoPleito;", "empresaSigla", "Lbr/com/sigescantt/core/dto/pleitos/historico/CreateHistoricoDTO;", "findHistoricosByPleitoId", "updateHistorico", "historicoId", "Lbr/com/sigescantt/core/dto/pleitos/historico/UpdateHistoricoDTO;", "deleteHistorico", "deleteHistoricoAnexo", "findPleitoItensContratuais", "Lbr/com/sigescantt/pleitos/PleitoEstruturaContrato;", "createItemContratual", "", "Lbr/com/sigescantt/core/dto/pleitos/itemContratual/CreatePleitoItemContratualDTO;", "deleteItemContratual", "idItemContratual", "findPleitoRodovias", "Lbr/com/sigescantt/pleitos/PleitoRodovia;", "createPleitoRodovia", "Lbr/com/sigescantt/core/dto/pleitos/rodovia/CreatePleitoRodoviaDTO;", "updatePleitoRodovia", "idPleitoRodovia", "Lbr/com/sigescantt/core/dto/pleitos/rodovia/UpdatePleitoRodoviaDTO;", "deletePleitoRodovia", "iniciarAprovacao", "findPleitoLogs", "Lbr/com/sigescantt/pleitos/PleitoLog;", "createLog", "Lbr/com/sigescantt/core/dto/pleitos/logs/CreatePleitoLogDTO;", "findDemandanteById", "Lbr/com/sigescantt/pleitos/PleitoDemandante;", "id", "findDemandantes", "nome", "demandanteAutocomplete", "createDemandante", "Lbr/com/sigescantt/core/dto/pleitos/demandante/SaveDemandanteDTO;", "updateDemandante", "deleteDemandante", "server"})
public class PleitosRestServices
extends BaseRestService {
    @NotNull
    private final SegurancaService segurancaService;
    @NotNull
    private final PleitoService pleitoService;
    @NotNull
    private final ImportacaoPleitoHelper importacaoPleitoHelper;
    @NotNull
    private final Logger LOGGER;

    public PleitosRestServices(@NotNull SegurancaService segurancaService, @NotNull PleitoService pleitoService, @NotNull ImportacaoPleitoHelper importacaoPleitoHelper) {
        Intrinsics.checkNotNullParameter((Object)segurancaService, (String)"segurancaService");
        Intrinsics.checkNotNullParameter((Object)pleitoService, (String)"pleitoService");
        Intrinsics.checkNotNullParameter((Object)importacaoPleitoHelper, (String)"importacaoPleitoHelper");
        super(segurancaService);
        this.segurancaService = segurancaService;
        this.pleitoService = pleitoService;
        this.importacaoPleitoHelper = importacaoPleitoHelper;
        Logger logger = LoggerFactory.getLogger(PleitosRestServices.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.LOGGER = logger;
    }

    @Operation(summary="Salva um novo pleito", description="Cria ou atualiza um pleito com suas informa\u00e7\u00f5es relacionadas")
    @ApiResponses(value={@ApiResponse(description="Pleito criado com sucesso", responseCode="201")})
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    @NotNull
    public Pleito savePleitoPrimeiraFase(@Parameter(description="Dados do pleito a ser salvo", required=true) @RequestBody @Valid @NotNull PleitoPrimeiraFaseDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.LOGGER.debug("{} - savePleitoPrimeiraFase({})", (Object)usuario.getLogin(), (Object)dto);
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        Pleito pleito = this.pleitoService.savePleitoPrimeiraFase(dto, ((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)pleito, (String)"savePleitoPrimeiraFase(...)");
        return pleito;
    }

    @Operation(summary="Salva um novo pleito em sua segunda fase.", description="Salva um novo pleito em sua segunda fase.")
    @ApiResponses(value={@ApiResponse(description="Pleito criado com sucesso", responseCode="201", content={@Content(mediaType="application/json", schema=@Schema(implementation=Pleito.class))})})
    @PutMapping(value={"/{empresa}/{idPleito}"})
    @NotNull
    public ResponseEntity<Pleito> savePleitoSegundaFase(@Parameter(description="Sigla da empresa", required=true) @PathVariable @NotNull String empresa, @Parameter(description="Identificador do pleito", required=true) @PathVariable int idPleito, @Parameter(description="Dados do pleito a ser salvo", required=true) @RequestBody @Valid @NotNull PleitoSegundaFaseDTO dto, @NotNull HttpServletRequest request) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            PublicUser publicUser = this.getUsuarioByJWT(request);
            if (publicUser == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            PublicUser usuario = publicUser;
            this.LOGGER.debug("{} - savePleito({})", (Object)usuario.getLogin(), (Object)dto);
            Integer n = usuario.getId();
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
            return new ResponseEntity((Object)this.pleitoService.savePleitoSegundaFase(dto, ((Number)n).intValue(), idPleito, empresa), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.savePleito", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/import"}, consumes={"multipart/form-data"})
    @Operation(summary="Importa pleitos a partir de um arquivo XLSX", description="Processa o XLSX e persiste os pleitos na base")
    @NotNull
    public ProcessoImportacao importPleitos(@PathVariable(value="empresa") @NotNull String empresa, @RequestPart(value="file") @NotNull MultipartFile file, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            PublicUser publicUser = this.getUsuarioByJWT(request);
            if (publicUser == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            PublicUser usuario = publicUser;
            ProcessoImportacao processoImportacao = this.importacaoPleitoHelper.importarPleitos(empresa, file.getInputStream(), usuario.getId());
            Intrinsics.checkNotNullExpressionValue((Object)processoImportacao, (String)"importarPleitos(...)");
            return processoImportacao;
        }
        catch (BusinessException ex) {
            String[] stringArray = new String[]{"%error%", ex.getMessage()};
            throw new ErrorCodeException(ErrorCode.VALIDATION_ERROR, stringArray);
        }
    }

    @Operation(summary="Edita pleito por meio de seu identificador", description="Atualiza um pleito por meio de seu identificador e campos informados.")
    @ApiResponses(value={@ApiResponse(description="Pleito atualizado com sucesso", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=Pleito.class))})})
    @PutMapping(value={"/{empresa}/{idPleito}/deprecated"})
    @NotNull
    public Pleito updatePleito(@Parameter(description="ID da empresa") @PathVariable(value="empresa") @NotNull String empresa, @Parameter(description="ID do pleito") @PathVariable(value="idPleito") @NotNull int idPleito, @Parameter(description="Dados atualizados do pleito") @Valid @RequestBody @NotNull UpdatePleitoDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        String ipExterno = this.getIpExterno(request);
        Pleito pleito = this.pleitoService.updatePleito(Integer.valueOf(idPleito), empresa, dto, usuario.getId(), ipExterno);
        Intrinsics.checkNotNullExpressionValue((Object)pleito, (String)"updatePleito(...)");
        return pleito;
    }

    @Operation(summary="Delete pleito por meio de seu identificador", description="ADelete um pleito por meio de seu identificador.")
    @ApiResponses(value={@ApiResponse(description="Pleito deletado com sucesso", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=Pleito.class))})})
    @DeleteMapping(value={"/{empresa}/{idPleito}"})
    public void deletePleito(@Parameter(description="ID da empresa") @PathVariable(value="empresa") @NotNull String empresa, @Parameter(description="ID do pleito") @PathVariable(value="idPleito") int idPleito, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.pleitoService.removePleito(Integer.valueOf(idPleito), empresa, usuario.getId());
    }

    @Operation(summary="Recupera um pleito espec\u00edfico", description="Busca e retorna um pleito com base no c\u00f3digo da empresa e ID do pleito")
    @ApiResponses(value={@ApiResponse(description="Pleito encontrado com sucesso", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=Pleito.class))})})
    @GetMapping(value={"/{empresa}/{idPleito}"})
    @NotNull
    public ResponseEntity<Pleito> getPleito(@PathVariable @NotNull String empresa, @PathVariable int idPleito, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Integer n = idPleito;
        Integer n2 = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"getId(...)");
        return new ResponseEntity((Object)this.pleitoService.getPleitoById(empresa, n, ((Number)n2).intValue()), (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping
    @Operation(summary="Listagem paginada de pleitos", description="Retorna os Pleitos filtrados conforme os par\u00e2metros informados no payload")
    @ApiResponses(value={@ApiResponse(description="Retorna a lista paginada de pleitos", responseCode="200")})
    @NotNull
    public Page<Pleito> findPleitos(@ParameterObject @NotNull FindPleitosDTO dto, @NotNull Pageable pageable, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        Page page = this.pleitoService.findPleitos(dto, ((Number)n).intValue(), pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findPleitos(...)");
        return page;
    }

    @PostMapping(value={"/{empresaId}/{pleitoId}/anexo"}, consumes={"multipart/form-data"})
    @Operation(summary="Cria\u00e7\u00e3o de anexo de pleito", description="Cria um anexo para o pleito e o arquivo informado")
    @ApiResponses(value={@ApiResponse(description="Retorna o anexo criado", responseCode="201")})
    @NotNull
    public PleitoAnexo createAnexo(@PathVariable(value="empresaId") int empresaId, @PathVariable(value="pleitoId") int pleitoId, @RequestPart @NotNull MultipartFile file, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        PleitoAnexo pleitoAnexo = this.pleitoService.createAnexo(empresaId, pleitoId, ((Number)n).intValue(), file);
        Intrinsics.checkNotNullExpressionValue((Object)pleitoAnexo, (String)"createAnexo(...)");
        return pleitoAnexo;
    }

    @GetMapping(value={"/{empresaId}/{pleitoId}/anexo"})
    @Operation(summary="Listagem paginada de anexos de pleito", description="Retorna os Anexos de Pleito do pleito especificado")
    @ApiResponses(value={@ApiResponse(description="Retorna a lista paginada dos anexos de pleito", responseCode="200")})
    @NotNull
    public Page<PleitoAnexo> findAnexos(@PathVariable(value="empresaId") int empresaId, @PathVariable(value="pleitoId") int pleitoId, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Page page = this.pleitoService.findAnexos(Integer.valueOf(empresaId), Integer.valueOf(pleitoId), pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findAnexos(...)");
        return page;
    }

    @GetMapping(value={"/anexo"})
    @Operation(summary="Listagem paginada de anexos de pleito baseado no filtro do payload", description="Retorna os Anexos de Pleito filtrados conforme os par\u00e2metros informados no payload")
    @ApiResponses(value={@ApiResponse(description="Retorna a lista paginada dos anexos de pleito", responseCode="200")})
    @NotNull
    public Page<PleitoAnexo> findAnexos(@Valid @ModelAttribute @NotNull FindPleitoAnexosDTO dto, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Page page = this.pleitoService.findAnexos(dto, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findAnexos(...)");
        return page;
    }

    @DeleteMapping(value={"/{empresaId}/{pleitoId}/anexo/{anexoId}"})
    @Operation(summary="Deleta um anexo de pleito", description="Deleta um anexo de pleito existente com base no ID do pleito e ID do anexo")
    @ApiResponses(value={@ApiResponse(description="Anexo deletado com sucesso", responseCode="200")})
    public void deleteAnexo(@PathVariable(value="empresaId") int empresaId, @PathVariable(value="pleitoId") int pleitoId, @PathVariable(value="anexoId") int anexoId, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Integer n = empresaId;
        Integer n2 = pleitoId;
        Integer n3 = anexoId;
        Integer n4 = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n4, (String)"getId(...)");
        this.pleitoService.deleteAnexo(n, n2, n3, ((Number)n4).intValue());
    }

    @PostMapping(value={"/{empresa}/{pleitoId}/historico"}, consumes={"multipart/form-data"})
    @Operation(summary="Cria\u00e7\u00e3o de hist\u00f3rico de pleito", description="Cria um novo hist\u00f3rico para o pleito informado")
    @ApiResponses(value={@ApiResponse(description="Retorna o hist\u00f3rico criado", responseCode="201")})
    @NotNull
    public HistoricoPleito createHistorico(@PathVariable(value="empresa") @NotNull String empresaSigla, @PathVariable(value="pleitoId") int pleitoId, @Valid @RequestPart(value="historico") @NotNull CreateHistoricoDTO dto, @RequestPart(required=false) @Nullable MultipartFile file, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresaSigla, (String)"empresaSigla");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        HistoricoPleito historicoPleito = this.pleitoService.createHistorico(empresaSigla, pleitoId, dto, ((Number)n).intValue(), file);
        Intrinsics.checkNotNullExpressionValue((Object)historicoPleito, (String)"createHistorico(...)");
        return historicoPleito;
    }

    @GetMapping(value={"/{empresa}/{pleitoId}/historico"})
    @Operation(summary="Listagem paginada de hist\u00f3ricos de pleito", description="Retorna os hist\u00f3ricos atrav\u00e9s do id do pleito.")
    @ApiResponses(value={@ApiResponse(description="Retorna a lista paginada de historicos", responseCode="200")})
    @NotNull
    public Page<HistoricoPleito> findHistoricosByPleitoId(@PathVariable(value="empresa") @NotNull String empresaSigla, @PathVariable(value="pleitoId") int pleitoId, @NotNull Pageable pageable, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresaSigla, (String)"empresaSigla");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        Page page = this.pleitoService.findHistoricosByPleitoId(empresaSigla, pleitoId, ((Number)n).intValue(), pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findHistoricosByPleitoId(...)");
        return page;
    }

    @PutMapping(value={"/{empresa}/{pleitoId}/historico/{historicoId}"}, consumes={"multipart/form-data"})
    @Operation(summary="Atualiza um hist\u00f3rico de pleito", description="Atualiza um hist\u00f3rico de pleito existente com base no ID do pleito e ID do hist\u00f3rico")
    @ApiResponses(value={@ApiResponse(description="Retorna o hist\u00f3rico atualizado", responseCode="200")})
    @NotNull
    public HistoricoPleito updateHistorico(@PathVariable(value="empresa") @NotNull String empresaSigla, @PathVariable(value="pleitoId") int pleitoId, @PathVariable(value="historicoId") int historicoId, @Valid @RequestPart(value="historico") @NotNull UpdateHistoricoDTO dto, @RequestPart(required=false) @Nullable MultipartFile file, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresaSigla, (String)"empresaSigla");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        HistoricoPleito historicoPleito = this.pleitoService.updateHistorico(empresaSigla, pleitoId, historicoId, dto, ((Number)n).intValue(), file);
        Intrinsics.checkNotNullExpressionValue((Object)historicoPleito, (String)"updateHistorico(...)");
        return historicoPleito;
    }

    @DeleteMapping(value={"/{empresa}/{pleitoId}/historico/{historicoId}"})
    @Operation(summary="Deleta um hist\u00f3rico de pleito", description="Deleta um hist\u00f3rico de pleito existente com base no ID do pleito e ID do hist\u00f3rico")
    @ApiResponses(value={@ApiResponse(description="Hist\u00f3rico deletado com sucesso", responseCode="200")})
    public void deleteHistorico(@PathVariable(value="empresa") @NotNull String empresaSigla, @PathVariable(value="pleitoId") int pleitoId, @PathVariable(value="historicoId") int historicoId, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresaSigla, (String)"empresaSigla");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        this.pleitoService.deleteHistorico(empresaSigla, pleitoId, historicoId, ((Number)n).intValue());
    }

    @DeleteMapping(value={"/{empresa}/{pleitoId}/historico/{historicoId}/anexo"})
    @Operation(summary="Deleta o anexo de um hist\u00f3rico de pleito", description="Deleta o anexo de um hist\u00f3rico de pleito existente com base no ID do pleito e ID do hist\u00f3rico")
    @ApiResponses(value={@ApiResponse(description="Anexo deletado com sucesso", responseCode="200")})
    public void deleteHistoricoAnexo(@PathVariable(value="empresa") @NotNull String empresaSigla, @PathVariable(value="pleitoId") int pleitoId, @PathVariable(value="historicoId") int historicoId, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresaSigla, (String)"empresaSigla");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        this.pleitoService.deleteHistoricoAnexo(empresaSigla, pleitoId, historicoId, ((Number)n).intValue());
    }

    @GetMapping(value={"/{empresa}/{pleitoId}/itens-contratuais"})
    @Operation(summary="Listagem paginada de itens contratuais associados a um pleito", description="Retorna os itens contratuais associados a um pleito espec\u00edfico")
    @ApiResponses(value={@ApiResponse(description="Retorna a lista paginada de itens contratuais associados ao pleito", responseCode="200")})
    @NotNull
    public Page<PleitoEstruturaContrato> findPleitoItensContratuais(@PathVariable(value="empresa") @NotNull String empresaSigla, @PathVariable(value="pleitoId") int pleitoId, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)empresaSigla, (String)"empresaSigla");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Page page = this.pleitoService.findPleitoItemContratos(empresaSigla, pleitoId, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findPleitoItemContratos(...)");
        return page;
    }

    @PostMapping(value={"/{empresa}/{pleitoId}/itens-contratuais"})
    @Operation(summary="Cria\u00e7\u00e3o de itens contratuais de pleito", description="Cria um novo item contratual para o pleito informado")
    @ApiResponses(value={@ApiResponse(description="Retorna o item contratual criado", responseCode="201")})
    @NotNull
    public List<PleitoEstruturaContrato> createItemContratual(@PathVariable(value="empresa") @NotNull String empresaSigla, @PathVariable(value="pleitoId") int pleitoId, @Valid @RequestBody @NotNull CreatePleitoItemContratualDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresaSigla, (String)"empresaSigla");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        List list = this.pleitoService.createPleitoItemContratos(empresaSigla, pleitoId, dto, ((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"createPleitoItemContratos(...)");
        return list;
    }

    @DeleteMapping(value={"/{empresa}/{pleitoId}/itens-contratuais/{itemContratualId}"})
    @Operation(summary="Deleta um item contratual de pleito", description="Deleta um item contratual de pleito existente com base no ID do pleito e ID do item contratual")
    @ApiResponses(value={@ApiResponse(description="Item contratual deletado com sucesso", responseCode="200")})
    public void deleteItemContratual(@PathVariable(value="empresa") @NotNull String empresaSigla, @PathVariable(value="pleitoId") int pleitoId, @PathVariable(value="itemContratualId") int idItemContratual, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresaSigla, (String)"empresaSigla");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        this.pleitoService.deletePleitoItemContrato(empresaSigla, pleitoId, idItemContratual, ((Number)n).intValue());
    }

    @GetMapping(value={"/{empresa}/{pleitoId}/rodovias"})
    @Operation(summary="Listagem paginada de rodovias associadas a um pleito", description="Retorna as rodovias associadas a um pleito espec\u00edfico")
    @ApiResponses(value={@ApiResponse(description="Retorna a lista paginada de rodovias associadas ao pleito", responseCode="200")})
    @NotNull
    public Page<PleitoRodovia> findPleitoRodovias(@PathVariable(value="empresa") @NotNull String empresaSigla, @PathVariable(value="pleitoId") int pleitoId, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)empresaSigla, (String)"empresaSigla");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Page page = this.pleitoService.findPleitoRodovias(empresaSigla, pleitoId, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findPleitoRodovias(...)");
        return page;
    }

    @PostMapping(value={"/{empresa}/{pleitoId}/rodovias"})
    @Operation(summary="Associa uma rodovia a um pleito", description="Associa uma rodovia a um pleito")
    @ApiResponses(value={@ApiResponse(description="Retorna a associa\u00e7\u00e3o criada", responseCode="201")})
    @NotNull
    public PleitoRodovia createPleitoRodovia(@PathVariable(value="empresa") @NotNull String empresaSigla, @PathVariable(value="pleitoId") int pleitoId, @Valid @RequestBody @NotNull CreatePleitoRodoviaDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresaSigla, (String)"empresaSigla");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        PleitoRodovia pleitoRodovia = this.pleitoService.createPleitoRodovia(empresaSigla, pleitoId, dto, ((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)pleitoRodovia, (String)"createPleitoRodovia(...)");
        return pleitoRodovia;
    }

    @PutMapping(value={"/{empresa}/{pleitoId}/rodovias/{idPleitoRodovia}"})
    @Operation(summary="Atualiza uma associa\u00e7\u00e3o de rodovia a um pleito", description="Atualiza uma associa\u00e7\u00e3o de rodovia a um pleito")
    @ApiResponses(value={@ApiResponse(description="Associa\u00e7\u00e3o de rodovia atualizada com sucesso", responseCode="200")})
    @NotNull
    public PleitoRodovia updatePleitoRodovia(@PathVariable(value="empresa") @NotNull String empresaSigla, @PathVariable(value="pleitoId") int pleitoId, @PathVariable(value="idPleitoRodovia") int idPleitoRodovia, @Valid @RequestBody @NotNull UpdatePleitoRodoviaDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresaSigla, (String)"empresaSigla");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        PleitoRodovia pleitoRodovia = this.pleitoService.updatePleitoRodovia(empresaSigla, pleitoId, idPleitoRodovia, dto, ((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)pleitoRodovia, (String)"updatePleitoRodovia(...)");
        return pleitoRodovia;
    }

    @DeleteMapping(value={"/{empresa}/{pleitoId}/rodovias/{idPleitoRodovia}"})
    @Operation(summary="Desassocia uma rodovia de um pleito", description="Desassocia uma rodovia de um pleito")
    @ApiResponses(value={@ApiResponse(description="Rodovia desassociada com sucesso", responseCode="200")})
    public void deletePleitoRodovia(@PathVariable(value="empresa") @NotNull String empresaSigla, @PathVariable(value="pleitoId") int pleitoId, @PathVariable(value="idPleitoRodovia") int idPleitoRodovia, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresaSigla, (String)"empresaSigla");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        this.pleitoService.deletePleitoRodovia(empresaSigla, pleitoId, idPleitoRodovia, ((Number)n).intValue());
    }

    @PostMapping(value={"/{empresa}/{pleitoId}/iniciar"})
    @Operation(summary="Iniciar fluxo de aprova\u00e7\u00e3o de Pleitos", description="Iniciar fluxo de aprova\u00e7\u00e3o de Pleitos")
    @ApiResponses(value={@ApiResponse(description="Fluxo iniciado com sucesso", responseCode="200")})
    public void iniciarAprovacao(@PathVariable(value="empresa") @NotNull String empresa, @PathVariable(value="pleitoId") int pleitoId, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        this.pleitoService.iniciarAprovacao(empresa, pleitoId, ((Number)n).intValue());
    }

    @GetMapping(value={"/{empresa}/{pleitoId}/logs"})
    @Operation(summary="Listagem paginada de logs de pleito", description="Retorna os logs associados a um pleito espec\u00edfico")
    @ApiResponses(value={@ApiResponse(description="Retorna a lista paginada de logs associados ao pleito", responseCode="200")})
    @NotNull
    public Page<PleitoLog> findPleitoLogs(@PathVariable(value="empresa") @NotNull String empresaSigla, @PathVariable(value="pleitoId") int pleitoId, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)empresaSigla, (String)"empresaSigla");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Page page = this.pleitoService.findLogsByPleito(empresaSigla, pleitoId, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findLogsByPleito(...)");
        return page;
    }

    @PostMapping(value={"/{empresa}/{pleitoId}/logs"})
    @Operation(summary="Cria\u00e7\u00e3o de logs de pleito", description="Cria um novo log para o pleito informado")
    @ApiResponses(value={@ApiResponse(description="Retorna o log criado", responseCode="201")})
    @NotNull
    public PleitoLog createLog(@PathVariable(value="empresa") @NotNull String empresaSigla, @PathVariable(value="pleitoId") int pleitoId, @Valid @RequestBody @NotNull CreatePleitoLogDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresaSigla, (String)"empresaSigla");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        PleitoLog pleitoLog = this.pleitoService.createLog(empresaSigla, pleitoId, dto, ((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)pleitoLog, (String)"createLog(...)");
        return pleitoLog;
    }

    @GetMapping(value={"/demandantes/{id}"})
    @Operation(summary="Busca um demandante por ID", description="Retorna um demandante espec\u00edfico com base no ID informado")
    @ApiResponses(value={@ApiResponse(description="Retorna o demandante encontrado", responseCode="200"), @ApiResponse(description="Demandante n\u00e3o encontrado", responseCode="404")})
    @NotNull
    public PleitoDemandante findDemandanteById(@PathVariable(value="id") int id) {
        PleitoDemandante pleitoDemandante = this.pleitoService.findDemandanteById(id);
        Intrinsics.checkNotNullExpressionValue((Object)pleitoDemandante, (String)"findDemandanteById(...)");
        return pleitoDemandante;
    }

    @GetMapping(value={"/demandantes"})
    @Operation(summary="Listagem de todos os demandantes", description="Retorna todos os demandantes cadastrados no sistema")
    @ApiResponses(value={@ApiResponse(description="Retorna a lista de demandantes", responseCode="200")})
    @NotNull
    public Page<PleitoDemandante> findDemandantes(@RequestParam(value="search", required=false) @Nullable String nome, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Page page = this.pleitoService.findDemandantes(nome, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findDemandantes(...)");
        return page;
    }

    @GetMapping(value={"/demandantes/autocomplete"})
    @Operation(summary="Autocomplete de demandantes", description="Retorna uma lista de demandantes filtrados pelo nome informado")
    @ApiResponses(value={@ApiResponse(description="Retorna a lista de demandantes filtrados", responseCode="200")})
    @NotNull
    public List<String> demandanteAutocomplete(@RequestParam(value="nome", required=false) @Nullable String nome) {
        List list = this.pleitoService.demandanteAutocomplete(nome);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"demandanteAutocomplete(...)");
        return list;
    }

    @PostMapping(value={"/demandantes"})
    @Operation(summary="Cria\u00e7\u00e3o de um novo demandante", description="Cria um novo demandante no sistema")
    @ApiResponses(value={@ApiResponse(description="Demandante criado com sucesso", responseCode="201")})
    @NotNull
    public PleitoDemandante createDemandante(@Valid @RequestBody @NotNull SaveDemandanteDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        PublicUser usuario = publicUser;
        PleitoDemandante pleitoDemandante = this.pleitoService.createDemandante(dto, usuario.getId());
        Intrinsics.checkNotNullExpressionValue((Object)pleitoDemandante, (String)"createDemandante(...)");
        return pleitoDemandante;
    }

    @PutMapping(value={"/demandantes/{id}"})
    @Operation(summary="Atualiza\u00e7\u00e3o de um demandante", description="Atualiza um demandante existente no sistema")
    @ApiResponses(value={@ApiResponse(description="Demandante atualizado com sucesso", responseCode="200"), @ApiResponse(description="Demandante n\u00e3o encontrado", responseCode="404")})
    @NotNull
    public PleitoDemandante updateDemandante(@PathVariable(value="id") int id, @Valid @RequestBody @NotNull SaveDemandanteDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        PublicUser usuario = publicUser;
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        PleitoDemandante pleitoDemandante = this.pleitoService.updateDemandante(id, dto, ((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)pleitoDemandante, (String)"updateDemandante(...)");
        return pleitoDemandante;
    }

    @DeleteMapping(value={"/demandantes/{id}"})
    @Operation(summary="Dele\u00e7\u00e3o de um demandante", description="Deleta um demandante existente no sistema")
    @ApiResponses(value={@ApiResponse(description="Demandante deletado com sucesso", responseCode="200"), @ApiResponse(description="Demandante n\u00e3o encontrado", responseCode="404")})
    public void deleteDemandante(@PathVariable(value="id") int id) {
        this.pleitoService.deleteDemandante(id);
    }
}

