/*
 * Decompiled with CFR 0.152.
 */
package br.com.sigescantt.apis;

import br.com.sigescantt.apis.BaseRestService;
import br.com.sigescantt.apis.ObrigacoesRestServices$findResumoObrigacoes$;
import br.com.sigescantt.core.beans.geral.Empresa;
import br.com.sigescantt.core.beans.geral.UsuarioPreferencia;
import br.com.sigescantt.core.beans.seguranca.PublicUser;
import br.com.sigescantt.exceptions.BusinessException;
import br.com.sigescantt.geral.ColumnInfo;
import br.com.sigescantt.geral.EmpresaArea;
import br.com.sigescantt.geral.EstruturaContrato;
import br.com.sigescantt.geral.TipoDocumento;
import br.com.sigescantt.obrigacoes.ObrigacaoAnexo;
import br.com.sigescantt.obrigacoes.ObrigacaoContratual;
import br.com.sigescantt.obrigacoes.ObrigacaoHistorico;
import br.com.sigescantt.obrigacoes.ObrigacaoLancamento;
import br.com.sigescantt.obrigacoes.ObrigacaoLancamentoResponsavel;
import br.com.sigescantt.obrigacoes.ObrigacaoResponsavel;
import br.com.sigescantt.obrigacoes.ResumoObrigacaoVO;
import br.com.sigescantt.obrigacoes.TipoStatusLancamentoObrigacao;
import br.com.sigescantt.reports.RelatorioObrigacoesXls;
import br.com.sigescantt.services.CoreService;
import br.com.sigescantt.services.ObrigacaoService;
import br.com.sigescantt.services.SegurancaService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@RestController
@Tag(name="obrigacoes", description="REST Services para obriga\u00e7\u00f5es")
@RequestMapping(value={"/api/obrigacoes"})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ6\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000f2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\n\b\u0001\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\b\u0001\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0017J5\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u000f2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\n\b\u0001\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\b\u0001\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0017\u00a2\u0006\u0002\u0010\u001bJ2\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000f2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u0019\u001a\u00020\u001aH\u0017JA\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00110\u000f2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\n\b\u0001\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\b\u0001\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\n\b\u0001\u0010\u001e\u001a\u0004\u0018\u00010\u001aH\u0017\u00a2\u0006\u0002\u0010\u001fJ.\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00180\u000f2\n\b\u0001\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\b\u0001\u0010!\u001a\u00020\u00182\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0017J?\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00180\u000f2\n\b\u0001\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\b\u0001\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\b\u0001\u0010!\u001a\u00020\u00182\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0017\u00a2\u0006\u0002\u0010#JA\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00110\u000f2\n\b\u0001\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\b\u0001\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\n\b\u0001\u0010%\u001a\u0004\u0018\u00010\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0017\u00a2\u0006\u0002\u0010&J+\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00150\u000f2\n\b\u0001\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\b\u0001\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0017\u00a2\u0006\u0002\u0010(J7\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00150\u000f2\n\b\u0001\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\b\u0001\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\n\b\u0001\u0010\u001e\u001a\u0004\u0018\u00010\u001aH\u0017\u00a2\u0006\u0002\u0010*J<\u0010+\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020,0\u00100\u000f2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010\u001e\u001a\u00020\u001aH\u0017J2\u0010-\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020.0\u00100\u000f2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u0019\u001a\u00020\u001aH\u0017J6\u0010/\u001a\b\u0012\u0004\u0012\u00020.0\u000f2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u00100\u001a\u00020.H\u0017J6\u00101\u001a\b\u0012\u0004\u0012\u0002020\u000f2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u00103\u001a\u00020\u001aH\u0017J<\u00104\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002050\u00100\u000f2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010\u001e\u001a\u00020\u001aH\u0017J@\u00106\u001a\b\u0012\u0004\u0012\u0002050\u000f2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010\u001e\u001a\u00020\u001a2\b\b\u0001\u00100\u001a\u000205H\u0017J@\u00107\u001a\b\u0012\u0004\u0012\u0002020\u000f2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010\u001e\u001a\u00020\u001a2\b\b\u0001\u00103\u001a\u00020\u001aH\u0017J0\u00108\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020:090\u000f2\n\b\u0001\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0017J;\u0010;\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020<0\u00100\u000f2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\n\b\u0001\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\b\u0001\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0017\u00a2\u0006\u0002\u0010\u001bJ:\u0010=\u001a\b\u0012\u0004\u0012\u00020>0\u000f2\n\b\u0001\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\b\u0001\u0010\u0016\u001a\u0004\u0018\u00010\u00152\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010?\u001a\u00020@H\u0017J\u000e\u0010A\u001a\b\u0012\u0004\u0012\u00020B0\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lbr/com/sigescantt/apis/ObrigacoesRestServices;", "Lbr/com/sigescantt/apis/BaseRestService;", "segurancaService", "Lbr/com/sigescantt/services/SegurancaService;", "coreService", "Lbr/com/sigescantt/services/CoreService;", "obrigacaoService", "Lbr/com/sigescantt/services/ObrigacaoService;", "<init>", "(Lbr/com/sigescantt/services/SegurancaService;Lbr/com/sigescantt/services/CoreService;Lbr/com/sigescantt/services/ObrigacaoService;)V", "logger", "Lorg/slf4j/Logger;", "dataFmt", "Ljava/time/format/DateTimeFormatter;", "findObrigacoes", "Lorg/springframework/http/ResponseEntity;", "", "Lbr/com/sigescantt/obrigacoes/ObrigacaoLancamento;", "request", "Ljakarta/servlet/http/HttpServletRequest;", "empresa", "", "search", "getObrigacao", "Lbr/com/sigescantt/obrigacoes/ObrigacaoContratual;", "idObrigacao", "", "(Ljakarta/servlet/http/HttpServletRequest;Ljava/lang/String;Ljava/lang/Integer;)Lorg/springframework/http/ResponseEntity;", "getLancamentosByObrigacao", "getLancamentoObrigacao", "seqLancamento", "(Ljakarta/servlet/http/HttpServletRequest;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;)Lorg/springframework/http/ResponseEntity;", "createObrigacao", "obrigacao", "updateObrigacao", "(Ljava/lang/String;Ljava/lang/Integer;Lbr/com/sigescantt/obrigacoes/ObrigacaoContratual;Ljakarta/servlet/http/HttpServletRequest;)Lorg/springframework/http/ResponseEntity;", "saveLancamento", "lancamento", "(Ljava/lang/String;Ljava/lang/Integer;Lbr/com/sigescantt/obrigacoes/ObrigacaoLancamento;Ljakarta/servlet/http/HttpServletRequest;)Lorg/springframework/http/ResponseEntity;", "deleteObrigacao", "(Ljava/lang/String;Ljava/lang/Integer;)Lorg/springframework/http/ResponseEntity;", "deleteLancamentoObrigacao", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;)Lorg/springframework/http/ResponseEntity;", "findAnexosObrigacao", "Lbr/com/sigescantt/obrigacoes/ObrigacaoAnexo;", "findResponsaveisObrigacao", "Lbr/com/sigescantt/obrigacoes/ObrigacaoResponsavel;", "saveResponsavelObrigacao", "responsavel", "deleteResponsavelObrigacao", "", "seqResponsavel", "findResponsaveisLancamentoObrigacao", "Lbr/com/sigescantt/obrigacoes/ObrigacaoLancamentoResponsavel;", "saveResponsavelLancamentoObrigacao", "deleteResponsavelLancamentoObrigacao", "findResumoObrigacoes", "", "", "getHistoricosByObrigacao", "Lbr/com/sigescantt/obrigacoes/ObrigacaoHistorico;", "exportXls", "Lorg/springframework/web/servlet/mvc/method/annotation/StreamingResponseBody;", "response", "Ljakarta/servlet/http/HttpServletResponse;", "createColumnsInfo", "Lbr/com/sigescantt/geral/ColumnInfo;", "server"})
@SourceDebugExtension(value={"SMAP\nObrigacoesRestServices.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObrigacoesRestServices.kt\nbr/com/sigescantt/apis/ObrigacoesRestServices\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1107:1\n1053#2:1108\n*S KotlinDebug\n*F\n+ 1 ObrigacoesRestServices.kt\nbr/com/sigescantt/apis/ObrigacoesRestServices\n*L\n760#1:1108\n*E\n"})
public class ObrigacoesRestServices
extends BaseRestService {
    @NotNull
    private final SegurancaService segurancaService;
    @NotNull
    private final CoreService coreService;
    @NotNull
    private final ObrigacaoService obrigacaoService;
    @NotNull
    private final Logger logger;
    @NotNull
    private final DateTimeFormatter dataFmt;

    public ObrigacoesRestServices(@NotNull SegurancaService segurancaService, @NotNull CoreService coreService, @NotNull ObrigacaoService obrigacaoService) {
        Intrinsics.checkNotNullParameter((Object)segurancaService, (String)"segurancaService");
        Intrinsics.checkNotNullParameter((Object)coreService, (String)"coreService");
        Intrinsics.checkNotNullParameter((Object)obrigacaoService, (String)"obrigacaoService");
        super(segurancaService);
        this.segurancaService = segurancaService;
        this.coreService = coreService;
        this.obrigacaoService = obrigacaoService;
        Logger logger = LoggerFactory.getLogger(ObrigacoesRestServices.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"ofPattern(...)");
        this.dataFmt = dateTimeFormatter;
    }

    @GetMapping(value={"/{empresa}"})
    @Operation(summary="Lista obriga\u00e7\u00f5es", description="Endpoint para listar as obriga\u00e7\u00f5es de acordo com os filtros informados (empresa, search, datas, status, etc).")
    @ApiResponses(value={@ApiResponse(description="Lista de obriga\u00e7\u00f5es retornada com sucesso.", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<List<ObrigacaoLancamento>> findObrigacoes(@Parameter(description="Requisi\u00e7\u00e3o HTTP", hidden=true) @NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa", example="empresa1") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="Termo de busca", required=false) @RequestParam(name="search", required=false) @Nullable String search) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.logger.debug("API search (empresa={}, search={})...", (Object)empresa, (Object)search);
        try {
            CoreService coreService = this.coreService;
            Intrinsics.checkNotNull((Object)coreService);
            Empresa emp = coreService.getEmpresaBySigla(empresa);
            List empresasInt = new ArrayList();
            Integer n = emp.getId();
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
            empresasInt.add(n);
            Integer idClassificacao = null;
            String parmTxt = request.getParameter("idClassificacao");
            if (parmTxt != null && !(((CharSequence)parmTxt).length() == 0)) {
                String string = request.getParameter("idClassificacao");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getParameter(...)");
                idClassificacao = Integer.parseInt(string);
            }
            LocalDate dataInicial = null;
            LocalDate dataFinal = null;
            parmTxt = request.getParameter("datInicial");
            if (parmTxt != null && !(((CharSequence)parmTxt).length() == 0)) {
                dataInicial = LocalDate.parse(parmTxt, this.dataFmt);
            }
            if ((parmTxt = request.getParameter("datFinal")) != null && !(((CharSequence)parmTxt).length() == 0)) {
                dataFinal = LocalDate.parse(parmTxt, this.dataFmt);
            }
            Integer status = null;
            parmTxt = request.getParameter("status");
            if (parmTxt != null && !(((CharSequence)parmTxt).length() == 0)) {
                String string = request.getParameter("status");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getParameter(...)");
                status = Integer.parseInt(string);
            }
            String nroCarta = null;
            parmTxt = request.getParameter("nroCarta");
            if (parmTxt != null && !(((CharSequence)parmTxt).length() == 0)) {
                nroCarta = request.getParameter("nroCarta");
            }
            String respEntrega = null;
            parmTxt = request.getParameter("responsavelEntrega");
            if (parmTxt != null && !(((CharSequence)parmTxt).length() == 0)) {
                respEntrega = request.getParameter("responsavelEntrega");
            }
            List obrigacoesDB = this.obrigacaoService.findLancamentosByFiltro(empresasInt, search, null, idClassificacao, status, null, null, dataInicial, dataFinal, null, nroCarta, respEntrega, Boolean.valueOf(true));
            for (ObrigacaoLancamento lcto : obrigacoesDB) {
                ObrigacaoContratual obriga = lcto.getObrigacao();
                lcto.setEmpresa(null);
                lcto.setResponsavelEntrega(null);
                ObrigacaoContratual obrigaBase = new ObrigacaoContratual();
                obrigaBase.setNome(obriga.getNome());
                obrigaBase.setDescricao(obriga.getDescricao());
                obrigaBase.setFrequencia(obriga.getFrequencia());
                obrigaBase.setPeriodicidade(obriga.getPeriodicidade());
                obrigaBase.setDiaFixo(obriga.getDiaFixo());
                obrigaBase.setDiaUtil(obriga.getDiaUtil());
                obrigaBase.setDiasAviso(obriga.getDiasAviso());
                obrigaBase.setDatInicioObrigacao(obriga.getDatInicioObrigacao());
                obrigaBase.setDatFinalObrigacao(obriga.getDatFinalObrigacao());
                obrigaBase.setItemContrato(obriga.getItemContrato());
                obrigaBase.setFormato(obriga.getFormato());
                obrigaBase.setStatus(obriga.getStatus());
                obrigaBase.setDatHorEncerrar(obriga.getDatHorEncerrar());
                obrigaBase.setArea(obriga.getArea());
                EmpresaArea area = obriga.getArea();
                TipoDocumento classif = obriga.getClassificacao();
                if (classif != null) {
                    classif.setEntidade(null);
                }
                obrigaBase.setClassificacao(classif);
                lcto.setObrigacao(obrigaBase);
            }
            return new ResponseEntity((Object)obrigacoesDB, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.findObrigacoesContratuais", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.logger.error("Exception.findObrigacoesContratuais", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idObrigacao}"})
    @Operation(summary="Detalha obriga\u00e7\u00e3o", description="Endpoint para exibir os detalhes completos da obriga\u00e7\u00e3o com base na empresa e no ID da obriga\u00e7\u00e3o.")
    @ApiResponses(value={@ApiResponse(description="Detalhes da obriga\u00e7\u00e3o retornados com sucesso.", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<ObrigacaoContratual> getObrigacao(@Parameter(description="Requisi\u00e7\u00e3o HTTP", hidden=true) @NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa", example="empresa1") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="ID da obriga\u00e7\u00e3o", example="123") @PathVariable(name="idObrigacao") @Nullable Integer idObrigacao) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Object[] objectArray = new Object[]{usuario.getLogin(), empresa, idObrigacao};
        this.logger.debug("{} - Executando getObrigacao(emp={},idObrigacao={})...", objectArray);
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            ObrigacaoContratual obrigacao = this.obrigacaoService.getById(emp.getId(), idObrigacao);
            obrigacao.setArea(null);
            obrigacao.setResponsaveis(null);
            if (obrigacao.getItemContrato() != null) {
                obrigacao.getItemContrato().setItemPrincipal(null);
            }
            return new ResponseEntity((Object)obrigacao, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.getObrigacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idObrigacao}/lancamentos"})
    @Operation(summary="Filtra lan\u00e7amentos", description="Endpoint para filtrar os lan\u00e7amentos da obriga\u00e7\u00e3o, informando empresa e ID da obriga\u00e7\u00e3o.")
    @ApiResponses(value={@ApiResponse(description="Lan\u00e7amentos da obriga\u00e7\u00e3o retornados com sucesso.", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<List<ObrigacaoLancamento>> getLancamentosByObrigacao(@Parameter(description="Requisi\u00e7\u00e3o HTTP", hidden=true) @NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa", example="empresa1") @PathVariable(name="empresa") @NotNull String empresa, @Parameter(description="ID da obriga\u00e7\u00e3o", example="123") @PathVariable(name="idObrigacao") int idObrigacao) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Object[] objectArray = new Object[]{usuario.getLogin(), empresa, idObrigacao};
        this.logger.debug("{} - Executando getLancamentosByObrigacao(emp={},idObrigacao={})...", objectArray);
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            List lctos = this.obrigacaoService.findLancamentosByObrigacao(emp.getId(), Integer.valueOf(idObrigacao), null);
            for (ObrigacaoLancamento lct : lctos) {
                EstruturaContrato itemCtr = lct.getObrigacao().getItemContrato();
                if (itemCtr != null) {
                    itemCtr.setItemPrincipal(null);
                }
                lct.getObrigacao().setArea(null);
                lct.setEmpresa(null);
                lct.getObrigacao().setResponsaveis(null);
            }
            return new ResponseEntity((Object)lctos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.getLancamentosByObrigacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idObrigacao}/lancamentos/{seqLancamento}"})
    @Operation(summary="Detalha lan\u00e7amento", description="Endpoint para exibir os detalhes do lan\u00e7amento da obriga\u00e7\u00e3o baseado na empresa, ID da obriga\u00e7\u00e3o e sequ\u00eancia do lan\u00e7amento.")
    @ApiResponses(value={@ApiResponse(description="Detalhes do lan\u00e7amento retornados com sucesso.", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<ObrigacaoLancamento> getLancamentoObrigacao(@Parameter(description="Requisi\u00e7\u00e3o HTTP", hidden=true) @NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa", example="empresa1") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="ID da obriga\u00e7\u00e3o", example="123") @PathVariable(name="idObrigacao") @Nullable Integer idObrigacao, @Parameter(description="Sequ\u00eancia do lan\u00e7amento", example="1") @PathVariable(name="seqLancamento") @Nullable Integer seqLancamento) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Object[] objectArray = new Object[]{usuario.getLogin(), empresa, idObrigacao, seqLancamento};
        this.logger.debug("{} - Executando getLancamentoObrigacao(emp={},idObrigacao={},seqLancamento={})...", objectArray);
        try {
            CoreService coreService = this.coreService;
            Intrinsics.checkNotNull((Object)coreService);
            Empresa emp = coreService.getEmpresaBySigla(empresa);
            ObrigacaoLancamento obrigacaoLcto = this.obrigacaoService.getLancamentoById(emp.getId(), idObrigacao, seqLancamento);
            List responsaveis = this.obrigacaoService.findResponsaveisLancamento(emp.getId(), idObrigacao, seqLancamento);
            List anexos = this.obrigacaoService.findAnexos(emp.getId(), idObrigacao, seqLancamento);
            ObrigacaoLancamento lcto = obrigacaoLcto;
            ObrigacaoContratual obr = lcto.getObrigacao();
            obr.setResponsaveis(null);
            EmpresaArea area = obr.getArea();
            obr.setArea(new EmpresaArea());
            obr.getArea().setId(area.getId());
            obr.getArea().setSigla(area.getSigla());
            obr.getArea().setDescricao(area.getDescricao());
            obrigacaoLcto.setResponsaveis(responsaveis);
            obrigacaoLcto.setAnexos(anexos);
            return new ResponseEntity((Object)lcto, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.getLancamentoObrigacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}"})
    @Operation(summary="Cria obriga\u00e7\u00e3o", description="Endpoint para cria\u00e7\u00e3o de uma nova obriga\u00e7\u00e3o com par\u00e2metros e anexos enviados.")
    @ApiResponses(value={@ApiResponse(description="Obriga\u00e7\u00e3o criada com sucesso.", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<ObrigacaoContratual> createObrigacao(@Parameter(description="Sigla da empresa", example="empresa1") @PathVariable(name="empresa") @Nullable String empresa, @RequestBody(description="Objeto ObrigacaoContratual a ser criado", required=true) @org.springframework.web.bind.annotation.RequestBody @NotNull ObrigacaoContratual obrigacao, @Parameter(description="Requisi\u00e7\u00e3o HTTP", hidden=true) @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)obrigacao, (String)"obrigacao");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        SegurancaService segurancaService = this.segurancaService;
        Intrinsics.checkNotNull((Object)segurancaService);
        PublicUser publicUser2 = segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            obrigacao.getId().setIdEmpresa(emp.getId());
            ObrigacaoContratual obrigacaoContratual = this.obrigacaoService.save(obrigacao, null, usr.getId());
            Intrinsics.checkNotNullExpressionValue((Object)obrigacaoContratual, (String)"save(...)");
            ObrigacaoContratual saved = obrigacaoContratual;
            return new ResponseEntity((Object)saved, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.createObrigacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PutMapping(value={"/{empresa}/{idObrigacao}"})
    @Operation(summary="Atualiza obriga\u00e7\u00e3o", description="Endpoint para atualiza\u00e7\u00e3o de uma obriga\u00e7\u00e3o a partir do seu ID, com par\u00e2metros e anexos enviados.")
    @ApiResponses(value={@ApiResponse(description="Obriga\u00e7\u00e3o atualizada com sucesso.", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<ObrigacaoContratual> updateObrigacao(@Parameter(description="Sigla da empresa", example="empresa1") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="ID da obriga\u00e7\u00e3o", example="123") @PathVariable(name="idObrigacao") @Nullable Integer idObrigacao, @RequestBody(description="Objeto ObrigacaoContratual com dados atualizados", required=true) @org.springframework.web.bind.annotation.RequestBody @NotNull ObrigacaoContratual obrigacao, @Parameter(description="Requisi\u00e7\u00e3o HTTP", hidden=true) @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)obrigacao, (String)"obrigacao");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        SegurancaService segurancaService = this.segurancaService;
        Intrinsics.checkNotNull((Object)segurancaService);
        PublicUser publicUser2 = segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            obrigacao.getId().setIdEmpresa(emp.getId());
            ObrigacaoContratual obrigacaoContratual = this.obrigacaoService.save(obrigacao, null, usr.getId());
            Intrinsics.checkNotNullExpressionValue((Object)obrigacaoContratual, (String)"save(...)");
            ObrigacaoContratual saved = obrigacaoContratual;
            return new ResponseEntity((Object)saved, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.createObrigacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idObrigacao}/lancamentos"})
    @Operation(summary="Cria lan\u00e7amento", description="Endpoint para salvar um novo lan\u00e7amento da obriga\u00e7\u00e3o com o payload enviado.")
    @ApiResponses(value={@ApiResponse(description="Lan\u00e7amento salvo com sucesso.", responseCode="200")})
    @NotNull
    public ResponseEntity<ObrigacaoLancamento> saveLancamento(@Parameter(description="Sigla da empresa", example="empresa1") @PathVariable @Nullable String empresa, @Parameter(description="ID da obriga\u00e7\u00e3o", example="123") @PathVariable @Nullable Integer idObrigacao, @RequestBody(description="Objeto ObrigacaoLancamento a ser salvo", required=true) @org.springframework.web.bind.annotation.RequestBody @Nullable ObrigacaoLancamento lancamento, @Parameter(description="Requisi\u00e7\u00e3o HTTP", hidden=true) @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            CoreService coreService = this.coreService;
            Intrinsics.checkNotNull((Object)coreService);
            Empresa emp = coreService.getEmpresaBySigla(empresa);
            PublicUser publicUser = this.getUsuarioByJWT(request);
            if (publicUser == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            PublicUser usuario = publicUser;
            this.logger.debug("{} - saveLancamento({})", (Object)usuario.getLogin(), (Object)empresa);
            ObrigacaoLancamento lcto = this.obrigacaoService.saveLancamento(lancamento, usuario.getId());
            return new ResponseEntity((Object)lcto, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.createObrigacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idObrigacao}"})
    @Operation(summary="Exclui obriga\u00e7\u00e3o", description="Endpoint para exclus\u00e3o de uma obriga\u00e7\u00e3o com base no identificador fornecido.")
    @ApiResponses(value={@ApiResponse(description="Obriga\u00e7\u00e3o exclu\u00edda com sucesso.", responseCode="200")})
    @NotNull
    public ResponseEntity<String> deleteObrigacao(@Parameter(description="Sigla da empresa", example="empresa1") @PathVariable @Nullable String empresa, @Parameter(description="ID da obriga\u00e7\u00e3o", example="123") @PathVariable @Nullable Integer idObrigacao) {
        try {
            CoreService coreService = this.coreService;
            Intrinsics.checkNotNull((Object)coreService);
            Empresa emp = coreService.getEmpresaBySigla(empresa);
            this.obrigacaoService.delete(emp.getId(), idObrigacao);
            return new ResponseEntity((Object)"Exclus\u00e3o realizada com sucesso.", (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.deleteObrigacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idObrigacao}/lancamentos/{seqLancamento}"})
    @Operation(summary="Exclui lan\u00e7amento", description="Endpoint para exclus\u00e3o de um lan\u00e7amento da obriga\u00e7\u00e3o com base no ID e sequ\u00eancia.")
    @ApiResponses(value={@ApiResponse(description="Lan\u00e7amento exclu\u00eddo com sucesso.", responseCode="200")})
    @NotNull
    public ResponseEntity<String> deleteLancamentoObrigacao(@Parameter(description="Sigla da empresa", example="empresa1") @PathVariable @Nullable String empresa, @Parameter(description="ID da obriga\u00e7\u00e3o", example="123") @PathVariable @Nullable Integer idObrigacao, @Parameter(description="Sequ\u00eancia do lan\u00e7amento", example="1") @PathVariable @Nullable Integer seqLancamento) {
        try {
            CoreService coreService = this.coreService;
            Intrinsics.checkNotNull((Object)coreService);
            Empresa emp = coreService.getEmpresaBySigla(empresa);
            this.obrigacaoService.deleteLancamento(emp.getId(), idObrigacao, seqLancamento);
            return new ResponseEntity((Object)"Exclus\u00e3o do lan\u00e7amento realizada com sucesso.", (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.deleteLancamentoObrigacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idObrigacao}/anexos"})
    @Operation(summary="Lista anexos", description="Endpoint para listar os anexos da obriga\u00e7\u00e3o ou do lan\u00e7amento, conforme informado.")
    @ApiResponses(value={@ApiResponse(description="Lista de anexos retornada com sucesso.", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<List<ObrigacaoAnexo>> findAnexosObrigacao(@Parameter(description="Requisi\u00e7\u00e3o HTTP", hidden=true) @NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa", example="empresa1") @PathVariable(name="empresa") @NotNull String empresa, @Parameter(description="ID da obriga\u00e7\u00e3o", example="123") @PathVariable(name="idObrigacao") int idObrigacao, @Parameter(description="Sequ\u00eancia do lan\u00e7amento (opcional)", required=false, example="1") @RequestParam(name="seqLancamento", required=false) int seqLancamento) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Object[] objectArray = new Object[]{empresa, idObrigacao, seqLancamento};
        this.logger.debug("API findAnexosObrigacao (empresa={}, idObrigacao={}, seqLancamento={})...", objectArray);
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            List anexos = this.obrigacaoService.findAnexos(emp.getId(), Integer.valueOf(idObrigacao), Integer.valueOf(seqLancamento));
            return new ResponseEntity((Object)anexos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.findAnexosObrigacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idObrigacao}/responsaveis"})
    @Operation(summary="Lista respons\u00e1veis", description="Endpoint para listar os respons\u00e1veis associados a uma obriga\u00e7\u00e3o.")
    @ApiResponses(value={@ApiResponse(description="Lista de respons\u00e1veis retornada com sucesso.", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<List<ObrigacaoResponsavel>> findResponsaveisObrigacao(@Parameter(description="Requisi\u00e7\u00e3o HTTP", hidden=true) @NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa", example="empresa1") @PathVariable(name="empresa") @NotNull String empresa, @Parameter(description="ID da obriga\u00e7\u00e3o", example="123") @PathVariable(name="idObrigacao") int idObrigacao) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.logger.debug("API findResponsaveisObrigacao (empresa={}, idObrigacao={})...", (Object)empresa, (Object)idObrigacao);
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            List responsaveis = this.obrigacaoService.findResponsaveis(emp.getId(), Integer.valueOf(idObrigacao), null);
            return new ResponseEntity((Object)responsaveis, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.findResponsaveisObrigacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idObrigacao}/responsaveis"})
    @Operation(summary="Salva respons\u00e1vel", description="Endpoint para salvar um respons\u00e1vel para a obriga\u00e7\u00e3o.")
    @ApiResponses(value={@ApiResponse(description="Respons\u00e1vel salvo com sucesso.", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<ObrigacaoResponsavel> saveResponsavelObrigacao(@Parameter(description="Requisi\u00e7\u00e3o HTTP", hidden=true) @NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa", example="empresa1") @PathVariable(name="empresa") @NotNull String empresa, @Parameter(description="ID da obriga\u00e7\u00e3o", example="123") @PathVariable(name="idObrigacao") int idObrigacao, @RequestBody(description="Objeto ObrigacaoResponsavel a ser salvo", required=true) @org.springframework.web.bind.annotation.RequestBody @NotNull ObrigacaoResponsavel responsavel) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)responsavel, (String)"responsavel");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.logger.debug("API saveResponsavelObrigacao (empresa={}, idObrigacao={})...", (Object)empresa, (Object)idObrigacao);
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            ObrigacaoContratual obrigacao = this.obrigacaoService.getById(emp.getId(), Integer.valueOf(idObrigacao));
            ObrigacaoResponsavel responsavel2 = this.obrigacaoService.saveResponsavel(obrigacao, responsavel, usuario.getId());
            return new ResponseEntity((Object)responsavel2, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveResponsavelObrigacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idObrigacao}/responsaveis/{seqResponsavel}"})
    @Operation(summary="Exclui respons\u00e1vel", description="Endpoint para excluir um respons\u00e1vel da obriga\u00e7\u00e3o com base no ID e na sequ\u00eancia.")
    @ApiResponses(value={@ApiResponse(description="Respons\u00e1vel exclu\u00eddo com sucesso.", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<Boolean> deleteResponsavelObrigacao(@Parameter(description="Requisi\u00e7\u00e3o HTTP", hidden=true) @NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa", example="empresa1") @PathVariable(name="empresa") @NotNull String empresa, @Parameter(description="ID da obriga\u00e7\u00e3o", example="123") @PathVariable(name="idObrigacao") int idObrigacao, @Parameter(description="Sequ\u00eancia do respons\u00e1vel", example="1") @PathVariable(name="seqResponsavel") int seqResponsavel) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Object[] objectArray = new Object[]{empresa, idObrigacao, seqResponsavel};
        this.logger.debug("API deleteResponsavelObrigacao (empresa={}, idObrigacao={}, seqResponsavel={})...", objectArray);
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            ObrigacaoContratual obrigacao = this.obrigacaoService.getById(emp.getId(), Integer.valueOf(idObrigacao));
            this.obrigacaoService.deleteResponsavel(emp.getId(), Integer.valueOf(idObrigacao), Integer.valueOf(seqResponsavel), usuario.getId());
            Unit responsavel = Unit.INSTANCE;
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.deleteResponsavelObrigacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idObrigacao}/lancamentos/{seqLancamento}/responsaveis"})
    @Operation(summary="Lista respons\u00e1veis do lan\u00e7amento", description="Endpoint para listar os respons\u00e1veis de um lan\u00e7amento da obriga\u00e7\u00e3o.")
    @ApiResponses(value={@ApiResponse(description="Lista de respons\u00e1veis do lan\u00e7amento retornada com sucesso.", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<List<ObrigacaoLancamentoResponsavel>> findResponsaveisLancamentoObrigacao(@Parameter(description="Requisi\u00e7\u00e3o HTTP", hidden=true) @NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa", example="empresa1") @PathVariable(name="empresa") @NotNull String empresa, @Parameter(description="ID da obriga\u00e7\u00e3o", example="123") @PathVariable(name="idObrigacao") int idObrigacao, @Parameter(description="Sequ\u00eancia do lan\u00e7amento", example="1") @PathVariable(name="seqLancamento") int seqLancamento) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Object[] objectArray = new Object[]{empresa, idObrigacao, seqLancamento};
        this.logger.debug("API findResponsaveisLancamentoObrigacao (empresa={}, idObrigacao={}, seqLancamento={})...", objectArray);
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            List responsaveis = this.obrigacaoService.findResponsaveisLancamento(emp.getId(), Integer.valueOf(idObrigacao), Integer.valueOf(seqLancamento));
            return new ResponseEntity((Object)responsaveis, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.findResponsaveisLancamentoObrigacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idObrigacao}/lancamentos/{seqLancamento}/responsaveis"})
    @Operation(summary="Salva respons\u00e1vel do lan\u00e7amento", description="Endpoint para salvar um respons\u00e1vel para o lan\u00e7amento da obriga\u00e7\u00e3o.")
    @ApiResponses(value={@ApiResponse(description="Respons\u00e1vel do lan\u00e7amento salvo com sucesso.", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<ObrigacaoLancamentoResponsavel> saveResponsavelLancamentoObrigacao(@Parameter(description="Requisi\u00e7\u00e3o HTTP", hidden=true) @NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa", example="empresa1") @PathVariable(name="empresa") @NotNull String empresa, @Parameter(description="ID da obriga\u00e7\u00e3o", example="123") @PathVariable(name="idObrigacao") int idObrigacao, @Parameter(description="Sequ\u00eancia do lan\u00e7amento", example="1") @PathVariable(name="seqLancamento") int seqLancamento, @RequestBody(description="Objeto ObrigacaoLancamentoResponsavel a ser salvo", required=true) @org.springframework.web.bind.annotation.RequestBody @NotNull ObrigacaoLancamentoResponsavel responsavel) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)responsavel, (String)"responsavel");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Object[] objectArray = new Object[]{empresa, idObrigacao, seqLancamento};
        this.logger.debug("API saveResponsavelLancamentoObrigacao (empresa={}, idObrigacao={}, seqLancamento={})...", objectArray);
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            ObrigacaoLancamento obrigacao = this.obrigacaoService.getLancamentoById(emp.getId(), Integer.valueOf(idObrigacao), Integer.valueOf(seqLancamento));
            ObrigacaoLancamentoResponsavel responsavel2 = this.obrigacaoService.saveResponsavelLancamento(obrigacao, responsavel, usuario.getId());
            return new ResponseEntity((Object)responsavel2, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveResponsavelLancamentoObrigacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idObrigacao}/lancamentos/{seqLancamento}/responsaveis/{seqResponsavel}"})
    @Operation(summary="Exclui respons\u00e1vel do lan\u00e7amento", description="Endpoint para excluir um respons\u00e1vel do lan\u00e7amento da obriga\u00e7\u00e3o com base no ID, sequ\u00eancia do lan\u00e7amento e sequ\u00eancia do respons\u00e1vel.")
    @ApiResponses(value={@ApiResponse(description="Respons\u00e1vel do lan\u00e7amento exclu\u00eddo com sucesso.", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<Boolean> deleteResponsavelLancamentoObrigacao(@Parameter(description="Requisi\u00e7\u00e3o HTTP", hidden=true) @NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa", example="empresa1") @PathVariable(name="empresa") @NotNull String empresa, @Parameter(description="ID da obriga\u00e7\u00e3o", example="123") @PathVariable(name="idObrigacao") int idObrigacao, @Parameter(description="Sequ\u00eancia do lan\u00e7amento", example="1") @PathVariable(name="seqLancamento") int seqLancamento, @Parameter(description="Sequ\u00eancia do respons\u00e1vel", example="1") @PathVariable(name="seqResponsavel") int seqResponsavel) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Object[] objectArray = new Object[]{empresa, idObrigacao, seqResponsavel};
        this.logger.debug("API deleteResponsavelLancamentoObrigacao (empresa={}, idObrigacao={}, seqResponsavel={})...", objectArray);
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            this.obrigacaoService.deleteResponsavelLancamento(emp.getId(), Integer.valueOf(idObrigacao), Integer.valueOf(seqLancamento), Integer.valueOf(seqResponsavel), usuario.getId());
            Unit responsavel = Unit.INSTANCE;
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.deleteResponsavelLancamentoObrigacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"{empresa}/resumos"})
    @Operation(summary="Resumo obriga\u00e7\u00f5es", description="Endpoint para retornar o resumo das obriga\u00e7\u00f5es, agrupando por totais e tipos de status.")
    @ApiResponses(value={@ApiResponse(description="Resumo das obriga\u00e7\u00f5es retornado com sucesso.", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<Map<String, Object>> findResumoObrigacoes(@Parameter(description="Sigla da empresa", example="empresa1") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="Requisi\u00e7\u00e3o HTTP", hidden=true) @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            Integer area;
            LocalDate localDate;
            String dataTxt;
            Map params = request.getParameterMap();
            ArrayList<Integer> listEmp = new ArrayList<Integer>();
            Empresa empDB = this.coreService.getEmpresaBySigla(empresa);
            listEmp.add(empDB.getId());
            ArrayList areasId = new ArrayList();
            Integer tipoObrigacao = null;
            Integer statusObriga = null;
            HashMap itens = new HashMap();
            LocalDate dataInicial = null;
            LocalDate dataFinal = null;
            DateTimeFormatter dateFmt = DateTimeFormatter.ISO_LOCAL_DATE;
            if (params.containsKey("dataInicial")) {
                Object v = params.get("dataInicial");
                Intrinsics.checkNotNull(v);
                dataTxt = ((String[])v)[0];
                if (dataTxt != null && !(((CharSequence)dataTxt).length() == 0)) {
                    try {
                        localDate = LocalDate.parse(dataTxt, dateFmt);
                    }
                    catch (DateTimeParseException dteExc) {
                        localDate = null;
                    }
                    dataInicial = localDate;
                }
            }
            if (params.containsKey("dataFinal")) {
                Object v = params.get("dataFinal");
                Intrinsics.checkNotNull(v);
                dataTxt = ((String[])v)[0];
                if (dataTxt != null && !(((CharSequence)dataTxt).length() == 0)) {
                    try {
                        localDate = LocalDate.parse(dataTxt, dateFmt);
                    }
                    catch (DateTimeParseException dteExc) {
                        localDate = null;
                    }
                    dataFinal = localDate;
                }
            }
            List obrigacoes = this.obrigacaoService.findLancamentosByFiltro((List)listEmp, null, (List)areasId, tipoObrigacao, statusObriga, null, null, dataInicial, dataFinal, null, null, null, Boolean.valueOf(false));
            int countPendentes = 0;
            int countAndamento = 0;
            int countEncerrados = 0;
            HashMap mapAreas = new HashMap();
            for (Object lcto : obrigacoes) {
                Integer countArea;
                ResumoObrigacaoVO resumo;
                area = lcto.getObrigacao().getArea();
                if (Intrinsics.areEqual((Object)lcto.getStatus(), (Object)TipoStatusLancamentoObrigacao.PENDENTE.getCode())) {
                    ++countPendentes;
                    if (area == null) continue;
                    resumo = (ResumoObrigacaoVO)mapAreas.get(area.getSigla());
                    if (resumo == null) {
                        resumo = new ResumoObrigacaoVO();
                        resumo.setArea(area.getSigla());
                        ((Map)mapAreas).put(area.getSigla(), resumo);
                    }
                    if ((countArea = resumo.getCountPendente()) == null) {
                        countArea = 0;
                    }
                    countArea = countArea + 1;
                    resumo.setCountPendente(countArea);
                    continue;
                }
                if (Intrinsics.areEqual((Object)lcto.getStatus(), (Object)TipoStatusLancamentoObrigacao.INTEGRADO.getCode())) {
                    ++countAndamento;
                    if (area == null) continue;
                    resumo = (ResumoObrigacaoVO)mapAreas.get(area.getSigla());
                    if (resumo == null) {
                        resumo = new ResumoObrigacaoVO();
                        resumo.setArea(area.getSigla());
                        ((Map)mapAreas).put(area.getSigla(), resumo);
                    }
                    if ((countArea = resumo.getCountAndamento()) == null) {
                        countArea = 0;
                    }
                    countArea = countArea + 1;
                    resumo.setCountAndamento(countArea);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)lcto.getStatus(), (Object)TipoStatusLancamentoObrigacao.PROTOCOLADO.getCode()) && !Intrinsics.areEqual((Object)lcto.getStatus(), (Object)TipoStatusLancamentoObrigacao.ENCERRADO.getCode())) continue;
                ++countEncerrados;
                if (area == null) continue;
                resumo = (ResumoObrigacaoVO)mapAreas.get(area.getSigla());
                if (resumo == null) {
                    resumo = new ResumoObrigacaoVO();
                    resumo.setArea(area.getSigla());
                    ((Map)mapAreas).put(area.getSigla(), resumo);
                }
                if ((countArea = resumo.getCountEncerrado()) == null) {
                    countArea = 0;
                }
                countArea = countArea + 1;
                resumo.setCountEncerrado(countArea);
            }
            area = countPendentes;
            ((Map)itens).put("resumoPendentes", area);
            area = countAndamento;
            ((Map)itens).put("resumoAndamento", area);
            area = countEncerrados;
            ((Map)itens).put("resumoEncerradas", area);
            ArrayList<ResumoObrigacaoVO> list = new ArrayList<ResumoObrigacaoVO>();
            for (Object e : mapAreas.keySet()) {
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                String key = (String)e;
                ResumoObrigacaoVO item = (ResumoObrigacaoVO)mapAreas.get(key);
                if (item == null) continue;
                list.add(item);
            }
            Iterable $this$sortedBy$iv = list;
            boolean $i$f$sortedBy = false;
            CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)((Comparator)new findResumoObrigacoes$$inlined$sortedBy$1()));
            ((Map)itens).put("areas", list);
            return new ResponseEntity(itens, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.findResumoDemandas", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.logger.error("Exception.findResumoDemandas", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idObrigacao}/historicos"})
    @Operation(summary="Hist\u00f3ricos da obriga\u00e7\u00e3o", description="Endpoint para exibir os hist\u00f3ricos dos dados da obriga\u00e7\u00e3o com base na empresa e ID da obriga\u00e7\u00e3o.")
    @ApiResponses(value={@ApiResponse(description="Hist\u00f3ricos retornados com sucesso.", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<List<ObrigacaoHistorico>> getHistoricosByObrigacao(@Parameter(description="Requisi\u00e7\u00e3o HTTP", hidden=true) @NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa", example="empresa1") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="ID da obriga\u00e7\u00e3o", example="123") @PathVariable(name="idObrigacao") @Nullable Integer idObrigacao) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Object[] objectArray = new Object[]{usuario.getLogin(), empresa, idObrigacao};
        this.logger.debug("{} - Executando getHistoricosByObrigacao(emp={},idObrigacao={})...", objectArray);
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            List historicos = this.obrigacaoService.findHistoricosByObrigacao(emp.getId(), idObrigacao);
            for (ObrigacaoHistorico hist : historicos) {
                if (hist.getUsuario() == null) continue;
                hist.getUsuario().setGrupos(null);
            }
            return new ResponseEntity((Object)historicos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.getHistoricosByObrigacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     */
    @PostMapping(value={"/{empresa}/exportacoes"})
    @Operation(summary="Exporta XLSX", description="Endpoint para efetuar o download do relat\u00f3rio de obriga\u00e7\u00f5es em formato XLSX.")
    @ApiResponses(value={@ApiResponse(description="Relat\u00f3rio XLSX gerado e enviado com sucesso.", responseCode="200")})
    @NotNull
    public ResponseEntity<StreamingResponseBody> exportXls(@Parameter(description="Sigla da empresa", example="empresa1") @PathVariable @Nullable String empresa, @Parameter(description="Termo de busca", example="busca") @PathVariable @Nullable String search, @Parameter(description="Requisi\u00e7\u00e3o HTTP", hidden=true) @NotNull HttpServletRequest request, @Parameter(description="Resposta HTTP", hidden=true) @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        v0 = this.getUsuarioByJWT(request);
        if (v0 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        usuario = v0;
        this.logger.debug("Iniciando exportXls...");
        emp = this.coreService.getEmpresaBySigla(empresa);
        empresasInt = new ArrayList<E>();
        v1 = emp.getId();
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getId(...)");
        empresasInt.add(v1);
        idClassificacao = null;
        parmTxt = request.getParameter("idClassificacao");
        if (parmTxt != null && !(((CharSequence)parmTxt).length() == 0)) {
            v2 = request.getParameter("idClassificacao");
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getParameter(...)");
            idClassificacao = Integer.parseInt(v2);
        }
        dataInicial = null;
        dataFinal = null;
        parmTxt = request.getParameter("datInicial");
        if (parmTxt != null && !(((CharSequence)parmTxt).length() == 0)) {
            dataInicial = LocalDate.parse(parmTxt, this.dataFmt);
        }
        if ((parmTxt = request.getParameter("datFinal")) != null && !(((CharSequence)parmTxt).length() == 0)) {
            dataFinal = LocalDate.parse(parmTxt, this.dataFmt);
        }
        status = null;
        parmTxt = request.getParameter("status");
        if (parmTxt != null && !(((CharSequence)parmTxt).length() == 0)) {
            v3 = request.getParameter("status");
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getParameter(...)");
            status = Integer.parseInt(v3);
        }
        nroCarta = null;
        parmTxt = request.getParameter("nroCarta");
        if (parmTxt != null && !(((CharSequence)parmTxt).length() == 0)) {
            nroCarta = request.getParameter("nroCarta");
        }
        respEntrega = null;
        parmTxt = request.getParameter("responsavelEntrega");
        if (parmTxt != null && !(((CharSequence)parmTxt).length() == 0)) {
            respEntrega = request.getParameter("responsavelEntrega");
        }
        obrigacoes = this.obrigacaoService.findLancamentosByFiltro(empresasInt, search, null, idClassificacao, status, null, null, dataInicial, dataFinal, null, nroCarta, respEntrega, Boolean.valueOf(true));
        columnsInfo = this.createColumnsInfo();
        noPrefsCols = new StringBuilder();
        for (ColumnInfo colInfo : columnsInfo) {
            if (noPrefsCols.length() > 0) {
                noPrefsCols.append(";");
            }
            noPrefsCols.append(colInfo.getFieldName());
        }
        prefData = null;
        usrPref = this.coreService.findPreferenciasByTipo(usuario.getId(), "CONSULTA_OBRIGACAO_PREFERENCIAS", null);
        if (usrPref == null || usrPref.isEmpty() || ((UsuarioPreferencia)usrPref.get(0)).getPreferencia() == null) ** GOTO lbl-1000
        v4 = ((UsuarioPreferencia)usrPref.get(0)).getPreferencia();
        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getPreferencia(...)");
        if (((CharSequence)v4).length() == 0) lbl-1000:
        // 2 sources

        {
            v5 = noPrefsCols.toString();
            v6 = v5;
            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"toString(...)");
        } else {
            v7 = ((UsuarioPreferencia)usrPref.get(0)).getPreferencia();
            v6 = v7;
            Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"getPreferencia(...)");
        }
        prefData = v6;
        preferencias = new ArrayList<String>();
        var22_21 = new String[]{";"};
        pref = StringsKt.split$default((CharSequence)StringsKt.trim((CharSequence)prefData).toString(), (String[])var22_21, (boolean)false, (int)0, (int)6, null);
        for (String config : pref) {
            preferencias.add(config);
        }
        stream = (StreamingResponseBody)LambdaMetafactory.metafactory(null, null, null, (Ljava/io/OutputStream;)V, exportXls$lambda$1(java.util.List java.util.ArrayList br.com.sigescantt.apis.ObrigacoesRestServices jakarta.servlet.http.HttpServletResponse java.io.OutputStream ), (Ljava/io/OutputStream;)V)((List)obrigacoes, preferencias, (ObrigacoesRestServices)this, (HttpServletResponse)response);
        fileName = "obrigacoes.xlsx";
        var24_24 = new String[]{"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"};
        v8 = (ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Type", var24_24);
        var24_24 = new String[]{"attachment filename=\"" + fileName + "\""};
        v9 = ((ResponseEntity.BodyBuilder)v8.header("Content-Disposition", var24_24)).body((Object)stream);
        Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"body(...)");
        return v9;
    }

    @NotNull
    public List<ColumnInfo> createColumnsInfo() {
        ArrayList<ColumnInfo> colsInf = new ArrayList<ColumnInfo>();
        colsInf.add(new ColumnInfo("Nome", "nome", "Obriga\u00e7\u00e3o Contratual", null));
        colsInf.add(new ColumnInfo("Descri\u00e7\u00e3o", "descricao", "Obriga\u00e7\u00e3o Contratual", null));
        colsInf.add(new ColumnInfo("Classifica\u00e7\u00e3o", "classificacao", "Obriga\u00e7\u00e3o Contratual", null));
        colsInf.add(new ColumnInfo("\u00c1rea", "area", "Obriga\u00e7\u00e3o Contratual", null));
        colsInf.add(new ColumnInfo("Respons\u00e1vel", "responsavel", "Obriga\u00e7\u00e3o Contratual", null));
        colsInf.add(new ColumnInfo("Entidade", "entidade", "Obriga\u00e7\u00e3o Contratual", null));
        colsInf.add(new ColumnInfo("Item contrato", "itemContrato", "Item Contratual", null));
        colsInf.add(new ColumnInfo("Formato", "formato", "Obriga\u00e7\u00e3o Contratual", null));
        colsInf.add(new ColumnInfo("Status Obriga\u00e7\u00e3o", "statusObrigacao", "Obriga\u00e7\u00e3o Contratual", null));
        colsInf.add(new ColumnInfo("Periodicidade", "periodicidade", "Obriga\u00e7\u00e3o Contratual", null));
        colsInf.add(new ColumnInfo("Tipo Periodicidade", "tipoPeriodicidade", "Obriga\u00e7\u00e3o Contratual", null));
        colsInf.add(new ColumnInfo("Dia \u00datil", "diaUtil", "Obriga\u00e7\u00e3o Contratual", null));
        colsInf.add(new ColumnInfo("Dia Fixo", "diaFixo", "Obriga\u00e7\u00e3o Contratual", null));
        colsInf.add(new ColumnInfo("Aviso (Dias)", "aviso", "Obriga\u00e7\u00e3o Contratual", null));
        colsInf.add(new ColumnInfo("Inicio Obriga\u00e7\u00e3o", "inicioObrigacao", "Obriga\u00e7\u00e3o Contratual", null));
        colsInf.add(new ColumnInfo("Final Obriga\u00e7\u00e3o", "finalObrigacao", "Obriga\u00e7\u00e3o Contratual", null));
        colsInf.add(new ColumnInfo("M\u00eas", "mes", "Obriga\u00e7\u00e3o Lan\u00e7amento", null));
        colsInf.add(new ColumnInfo("Ano", "ano", "Obriga\u00e7\u00e3o Lan\u00e7amento", null));
        colsInf.add(new ColumnInfo("Prazo", "prazo", "Obriga\u00e7\u00e3o Lan\u00e7amento", null));
        colsInf.add(new ColumnInfo("Entrega", "entrega", "Obriga\u00e7\u00e3o Lan\u00e7amento", null));
        colsInf.add(new ColumnInfo("Correspond\u00eancia", "correspondencia", "Obriga\u00e7\u00e3o Lan\u00e7amento", null));
        colsInf.add(new ColumnInfo("Status - Lancam.", "statusLancamento", "Obriga\u00e7\u00e3o Lan\u00e7amento", null));
        colsInf.add(new ColumnInfo("Status - Prazo", "statusPrazoDesc", "Obriga\u00e7\u00e3o Lan\u00e7amento", null));
        colsInf.add(new ColumnInfo("Data encerr.", "datEncerramento", "Obriga\u00e7\u00e3o Lan\u00e7amento", null));
        colsInf.add(new ColumnInfo("Observa\u00e7\u00e3o encerr.", "observacaoEncerramento", "Obriga\u00e7\u00e3o Lan\u00e7amento", null));
        return colsInf;
    }

    private static final void exportXls$lambda$1(List $obrigacoes, ArrayList $preferencias, ObrigacoesRestServices this$0, HttpServletResponse $response, OutputStream out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        byte[] bytes = new RelatorioObrigacoesXls().execute($obrigacoes, (List)$preferencias);
        if (bytes != null && bytes.length > 0) {
            this$0.logger.debug("Escrevendo response stream");
            out.write(bytes);
            $response.setHeader("Content-Length", String.valueOf(bytes.length));
        }
    }
}

