/*
 * Decompiled with CFR 0.152.
 */
package br.com.sigescantt.apis;

import br.com.sigescantt.apis.BaseRestService;
import br.com.sigescantt.core.beans.geral.Empresa;
import br.com.sigescantt.core.beans.seguranca.PublicUser;
import br.com.sigescantt.core.dto.licencas.CondicionanteDocumentoPaginationDTO;
import br.com.sigescantt.core.dto.licencas.CondicionanteNotaDTO;
import br.com.sigescantt.core.dto.licencas.CondicionantePaginationDTO;
import br.com.sigescantt.core.dto.licencas.CreateCondicionanteDTO;
import br.com.sigescantt.core.dto.licencas.CreatePlanoAcaoCondicionanteDTO;
import br.com.sigescantt.core.dto.licencas.EditLicencaDTO;
import br.com.sigescantt.core.dto.licencas.EditPlanoAcaoCondicionanteDTO;
import br.com.sigescantt.core.dto.licencas.FindLicencasDTO;
import br.com.sigescantt.exceptions.BusinessException;
import br.com.sigescantt.licencas.Condicionante;
import br.com.sigescantt.licencas.CondicionanteDocumento;
import br.com.sigescantt.licencas.CondicionanteNota;
import br.com.sigescantt.licencas.Licenca;
import br.com.sigescantt.licencas.LicencaDocumento;
import br.com.sigescantt.licencas.LicencaNota;
import br.com.sigescantt.licencas.LicencaObra;
import br.com.sigescantt.licencas.LicencaObraVO;
import br.com.sigescantt.licencas.PlanoAcaoCondicionante;
import br.com.sigescantt.licencas.PlanoAcaoCondicionanteDocumento;
import br.com.sigescantt.services.CoreService;
import br.com.sigescantt.services.Exceptions.ErrorCode;
import br.com.sigescantt.services.Exceptions.ErrorCodeException;
import br.com.sigescantt.services.LicencaService;
import br.com.sigescantt.services.SegurancaService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.annotations.ParameterObject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;

@Tag(name="licencas v1", description="REST Services para Licen\u00e7as Ambientais v1")
@Validated
@RestController
@RequestMapping(value={"/api/v1/licencas"})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00e0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ(\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\b\u0001\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J \u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00162\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0017\u001a\u00020\u0018H\u0017J \u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00162\b\b\u0001\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J*\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00162\b\b\u0001\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u000f\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J'\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00162\n\b\u0001\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0011\u001a\u00020\u0012H\u0017\u00a2\u0006\u0002\u0010\u001fJ*\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u00162\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\"\u001a\u00020!H\u0017J4\u0010#\u001a\b\u0012\u0004\u0012\u00020!0\u00162\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010$\u001a\u00020\u00182\b\b\u0001\u0010\"\u001a\u00020!H\u0017J:\u0010%\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0\r0\u00162\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0017\u001a\u00020\u00182\n\b\u0001\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J*\u0010(\u001a\b\u0012\u0004\u0012\u00020!0\u00162\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010$\u001a\u00020\u0018H\u0017J*\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00162\b\b\u0001\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010$\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J.\u0010*\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020+0\r0\u00162\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J*\u0010,\u001a\b\u0012\u0004\u0012\u00020+0\u00162\b\b\u0001\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010-\u001a\u00020.2\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J-\u0010/\u001a\u0002002\n\b\u0001\u0010\u0017\u001a\u0004\u0018\u00010\u00182\n\b\u0001\u00101\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0011\u001a\u00020\u0012H\u0017\u00a2\u0006\u0002\u00102J:\u00103\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002040\r0\u00162\b\b\u0001\u0010\u0017\u001a\u00020\u00182\n\b\u0001\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J$\u00105\u001a\u0002042\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u00106\u001a\u00020\u0018H\u0017J*\u00107\u001a\b\u0012\u0004\u0012\u0002080\u00162\b\b\u0001\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u000f\u001a\u0002092\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J4\u0010:\u001a\b\u0012\u0004\u0012\u0002080\u00162\b\b\u0001\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u00106\u001a\u00020\u00182\b\b\u0001\u0010\u000f\u001a\u0002092\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J*\u0010;\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00162\b\b\u0001\u00106\u001a\u00020\u00182\b\b\u0001\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0012H\u0017JD\u0010<\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020=0\r0\u00162\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u00106\u001a\u00020\u00182\n\b\u0001\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J4\u0010>\u001a\b\u0012\u0004\u0012\u00020=0\u00162\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u00106\u001a\u00020\u00182\b\b\u0001\u0010$\u001a\u00020\u0018H\u0017J6\u0010?\u001a\b\u0012\u0004\u0012\u00020=0\u00162\b\b\u0001\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u00106\u001a\u00020\u00182\n\b\u0001\u0010@\u001a\u0004\u0018\u00010=2\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J4\u0010A\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00162\b\b\u0001\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u00106\u001a\u00020\u00182\b\b\u0001\u0010$\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J>\u0010B\u001a\b\u0012\u0004\u0012\u00020=0\u00162\b\b\u0001\u0010\u000f\u001a\u00020C2\b\b\u0001\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u00106\u001a\u00020\u00182\b\b\u0001\u0010$\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0012H\u0017JD\u0010D\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020E0\r0\u00162\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u00106\u001a\u00020\u00182\n\b\u0001\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J4\u0010F\u001a\b\u0012\u0004\u0012\u00020E0\u00162\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u00106\u001a\u00020\u00182\b\b\u0001\u0010G\u001a\u00020\u0018H\u0017J*\u0010H\u001a\b\u0012\u0004\u0012\u00020E0\u00162\b\b\u0001\u00106\u001a\u00020\u00182\b\b\u0001\u0010\u000f\u001a\u00020I2\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J4\u0010J\u001a\b\u0012\u0004\u0012\u00020E0\u00162\b\b\u0001\u00106\u001a\u00020\u00182\b\b\u0001\u0010G\u001a\u00020\u00182\b\b\u0001\u0010\u000f\u001a\u00020K2\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J4\u0010L\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00162\b\b\u0001\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u00106\u001a\u00020\u00182\b\b\u0001\u0010G\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J>\u0010M\u001a\b\u0012\u0004\u0012\u00020N0\u00162\b\b\u0001\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u00106\u001a\u00020\u00182\b\b\u0001\u0010G\u001a\u00020\u00182\b\b\u0001\u0010-\u001a\u00020.2\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J<\u0010O\u001a\b\u0012\u0004\u0012\u00020N0\r2\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u00106\u001a\u00020\u00182\b\b\u0001\u0010G\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J>\u0010P\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00162\b\b\u0001\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u00106\u001a\u00020\u00182\b\b\u0001\u0010G\u001a\u00020\u00182\b\b\u0001\u0010Q\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J8\u0010R\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020S0\r0\u00162\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u00106\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J4\u0010T\u001a\b\u0012\u0004\u0012\u00020U0\u00162\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u00106\u001a\u00020\u00182\b\b\u0001\u00101\u001a\u00020\u0018H\u0017J4\u0010V\u001a\b\u0012\u0004\u0012\u00020U0\u00162\b\b\u0001\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u00106\u001a\u00020\u00182\b\b\u0001\u0010-\u001a\u00020.2\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J4\u0010W\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00162\b\b\u0001\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u00106\u001a\u00020\u00182\b\b\u0001\u00101\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J.\u0010X\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020Y0\r0\u00162\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J*\u0010Z\u001a\b\u0012\u0004\u0012\u00020Y0\u00162\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010[\u001a\u00020\u0018H\u0017J\"\u0010\\\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u00162\b\b\u0001\u0010]\u001a\u00020^2\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J3\u0010_\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00162\n\b\u0001\u0010\u0017\u001a\u0004\u0018\u00010\u00182\n\b\u0001\u0010`\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0011\u001a\u00020\u0012H\u0017\u00a2\u0006\u0002\u0010aR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006b"}, d2={"Lbr/com/sigescantt/apis/LicencasRestServices;", "Lbr/com/sigescantt/apis/BaseRestService;", "coreService", "Lbr/com/sigescantt/services/CoreService;", "licencaService", "Lbr/com/sigescantt/services/LicencaService;", "segurancaService", "Lbr/com/sigescantt/services/SegurancaService;", "<init>", "(Lbr/com/sigescantt/services/CoreService;Lbr/com/sigescantt/services/LicencaService;Lbr/com/sigescantt/services/SegurancaService;)V", "LOGGER", "Lorg/slf4j/Logger;", "findLicencas", "Lorg/springframework/data/domain/Page;", "Lbr/com/sigescantt/licencas/Licenca;", "dto", "Lbr/com/sigescantt/core/dto/licencas/FindLicencasDTO;", "request", "Ljakarta/servlet/http/HttpServletRequest;", "pageable", "Lorg/springframework/data/domain/Pageable;", "getLicenca", "Lorg/springframework/http/ResponseEntity;", "idLicenca", "", "saveLicenca", "licenca", "editLicenca", "Lbr/com/sigescantt/core/dto/licencas/EditLicencaDTO;", "deleteLicenca", "", "(Ljava/lang/Integer;Ljakarta/servlet/http/HttpServletRequest;)Lorg/springframework/http/ResponseEntity;", "createNotasLicenca", "Lbr/com/sigescantt/licencas/LicencaNota;", "nota", "editNotasLicenca", "idNota", "getNotasLicenca", "search", "", "getLicencaNota", "deleteLicencaNota", "findDocumentosByLicenca", "Lbr/com/sigescantt/licencas/LicencaDocumento;", "saveDocumentoByLicenca", "file", "Lorg/springframework/web/multipart/MultipartFile;", "removeDocumentoLicenca", "", "seqArquivo", "(Ljava/lang/Integer;Ljava/lang/Integer;Ljakarta/servlet/http/HttpServletRequest;)V", "findCondicionantesByLicenca", "Lbr/com/sigescantt/core/dto/licencas/CondicionantePaginationDTO;", "getCondicionanteById", "idCondicionante", "saveCondicionanteByLicenca", "Lbr/com/sigescantt/licencas/Condicionante;", "Lbr/com/sigescantt/core/dto/licencas/CreateCondicionanteDTO;", "editCondicionanteByLicenca", "deleteCondicionanteByLicenca", "findCondicionanteNota", "Lbr/com/sigescantt/licencas/CondicionanteNota;", "getCondicionanteNota", "saveCondicionanteNota", "condicionanteNota", "deleteCondicionanteNota", "editCondicionanteNota", "Lbr/com/sigescantt/core/dto/licencas/CondicionanteNotaDTO;", "findPlanosAcao", "Lbr/com/sigescantt/licencas/PlanoAcaoCondicionante;", "getPlanoAcaoById", "idPlanoAcao", "savePlanoAcao", "Lbr/com/sigescantt/core/dto/licencas/CreatePlanoAcaoCondicionanteDTO;", "editPlanoAcao", "Lbr/com/sigescantt/core/dto/licencas/EditPlanoAcaoCondicionanteDTO;", "deletePlanoAcao", "savePlanoAcaoCondicionanteDocumento", "Lbr/com/sigescantt/licencas/PlanoAcaoCondicionanteDocumento;", "findDocumentosByPlanoAcao", "removeDocumentoPlanoAcao", "seqAnexo", "findDocumentosByCondicionante", "Lbr/com/sigescantt/core/dto/licencas/CondicionanteDocumentoPaginationDTO;", "getDocumentoBySeq", "Lbr/com/sigescantt/licencas/CondicionanteDocumento;", "saveCondicionanteDocumento", "removeDocumento", "findObrasByLicenca", "Lbr/com/sigescantt/licencas/LicencaObra;", "getLicencaObraById", "idObra", "saveLicencaObra", "licencaObra", "Lbr/com/sigescantt/licencas/LicencaObraVO;", "deleteLicencaObra", "sequencia", "(Ljava/lang/Integer;Ljava/lang/Integer;Ljakarta/servlet/http/HttpServletRequest;)Lorg/springframework/http/ResponseEntity;", "server"})
public class LicencasRestServices
extends BaseRestService {
    @Nullable
    private final CoreService coreService;
    @NotNull
    private final LicencaService licencaService;
    @NotNull
    private final SegurancaService segurancaService;
    @NotNull
    private final Logger LOGGER;

    public LicencasRestServices(@Nullable CoreService coreService, @NotNull LicencaService licencaService, @NotNull SegurancaService segurancaService) {
        Intrinsics.checkNotNullParameter((Object)licencaService, (String)"licencaService");
        Intrinsics.checkNotNullParameter((Object)segurancaService, (String)"segurancaService");
        super(segurancaService);
        this.coreService = coreService;
        this.licencaService = licencaService;
        this.segurancaService = segurancaService;
        Logger logger = LoggerFactory.getLogger(LicencasRestServices.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.LOGGER = logger;
    }

    @GetMapping
    @Operation(summary="Consulta paginada de Licencas")
    @NotNull
    public Page<Licenca> findLicencas(@ParameterObject @Valid @NotNull FindLicencasDTO dto, @NotNull HttpServletRequest request, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        this.LOGGER.debug("API getLicencasPaginated...");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        PublicUser usuario = publicUser;
        this.LOGGER.debug("{} - getLicenca()", (Object)usuario);
        Page page = this.licencaService.findLicencas(dto, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findLicencas(...)");
        return page;
    }

    @GetMapping(value={"/{idLicenca}"})
    @Operation(summary="Carrega dados da licen\u00e7a de acordo com o ID da licen\u00e7a")
    @NotNull
    public ResponseEntity<Licenca> getLicenca(@NotNull HttpServletRequest request, @PathVariable int idLicenca) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.LOGGER.debug("API getLicenca...");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.LOGGER.debug("{} - getLicenca()", (Object)usuario);
        Licenca licenca = this.licencaService.getLicencaById(Integer.valueOf(idLicenca));
        if (licenca == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Licen\u00e7a n\u00e3o encontrada.");
        }
        Licenca lic = licenca;
        lic.setEmpresa(null);
        return new ResponseEntity((Object)lic, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping
    @Operation(summary="Salva a Licen\u00e7a")
    @NotNull
    public ResponseEntity<Licenca> saveLicenca(@RequestBody @NotNull Licenca licenca, @NotNull HttpServletRequest request) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)licenca, (String)"licenca");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        CoreService coreService = this.coreService;
        Intrinsics.checkNotNull((Object)coreService);
        Empresa empresa = coreService.getEmpresaById(licenca.getIdEmpresa());
        if (empresa == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
        }
        Empresa emp = empresa;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        return new ResponseEntity((Object)this.licencaService.saveLicenca(licenca, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/{idLicenca}"})
    @Operation(summary="Edita a Licen\u00e7a")
    @NotNull
    public ResponseEntity<Licenca> editLicenca(@PathVariable(value="idLicenca") int idLicenca, @Valid @RequestBody @NotNull EditLicencaDTO dto, @NotNull HttpServletRequest request) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        CoreService coreService = this.coreService;
        Intrinsics.checkNotNull((Object)coreService);
        Empresa empresa = coreService.getEmpresaById(dto.idEmpresa());
        if (empresa == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
        }
        Empresa emp = empresa;
        SegurancaService segurancaService = this.segurancaService;
        Intrinsics.checkNotNull((Object)segurancaService);
        PublicUser publicUser2 = segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            Object[] objectArray = new Object[]{usuario, emp.getSigla(), dto};
            this.LOGGER.debug("{} - saveLicenca ({}, {}))", objectArray);
            return new ResponseEntity((Object)this.licencaService.editLicenca(dto, usr.getId(), Integer.valueOf(idLicenca)), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.saveLicenca", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{idLicenca}"})
    @Operation(summary="Exclui a Licen\u00e7a atrav\u00e9s de seu identificador")
    @NotNull
    public ResponseEntity<Boolean> deleteLicenca(@PathVariable(name="idLicenca") @Nullable Integer idLicenca, @NotNull HttpServletRequest request) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.LOGGER.debug("{} - deleteLicenca({})", (Object)usuario, (Object)idLicenca);
        try {
            return new ResponseEntity((Object)this.licencaService.deleteLicenca(idLicenca, this.getIpExterno(request)), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.deleteLicenca", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{idLicenca}/notas"})
    @Operation(summary="Cria uma nota de acordo com o identificador da Licen\u00e7a")
    @NotNull
    public ResponseEntity<LicencaNota> createNotasLicenca(@NotNull HttpServletRequest request, @PathVariable int idLicenca, @RequestBody @NotNull LicencaNota nota) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)nota, (String)"nota");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.LOGGER.debug("{} - createNotasLicenca({})", (Object)usuario, (Object)idLicenca);
        try {
            return new ResponseEntity((Object)this.licencaService.saveNotaLicenca(Integer.valueOf(idLicenca), usuario.getId(), nota), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.findLicencaNota", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.LOGGER.error("Exception.findfindLicencaNota", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PutMapping(value={"/{idLicenca}/notas/{idNota}"})
    @Operation(summary="Cria uma nota de acordo com o identificador da Licen\u00e7a")
    @NotNull
    public ResponseEntity<LicencaNota> editNotasLicenca(@NotNull HttpServletRequest request, @PathVariable(value="idLicenca") int idLicenca, @PathVariable(value="idNota") int idNota, @RequestBody @NotNull LicencaNota nota) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)nota, (String)"nota");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.LOGGER.debug("{} - createNotasLicenca({})", (Object)usuario, (Object)idLicenca);
        try {
            return new ResponseEntity((Object)this.licencaService.editNotaLicenca(Integer.valueOf(idLicenca), Integer.valueOf(idNota), usuario.getId(), nota), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.findLicencaNota", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.LOGGER.error("Exception.findfindLicencaNota", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{idLicenca}/notas"})
    @Operation(summary="Consulta as notas de acordo com o identificador da Licen\u00e7a")
    @NotNull
    public ResponseEntity<Page<LicencaNota>> getNotasLicenca(@NotNull HttpServletRequest request, @PathVariable int idLicenca, @RequestParam(value="search", required=false) @Nullable String search, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.LOGGER.debug("{} - findLicencaNota({})", (Object)usuario, (Object)idLicenca);
        try {
            Page page = this.licencaService.getNotasLicenca(Integer.valueOf(idLicenca), search, pageable);
            if (page == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Notas n\u00e3o encontrado.");
            }
            Page notas = page;
            return new ResponseEntity((Object)notas, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.findLicencaNota", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.LOGGER.error("Exception.findfindLicencaNota", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{idLicenca}/notas/{idNota}"})
    @Operation(summary="Carrega os dados da nota de acordo com o ID da Licen\u00e7a e da Nota.")
    @NotNull
    public ResponseEntity<LicencaNota> getLicencaNota(@NotNull HttpServletRequest request, @PathVariable(value="idLicenca") int idLicenca, @PathVariable(value="idNota") int idNota) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.LOGGER.debug("API getLicencaNota...");
        try {
            PublicUser publicUser = this.getUsuarioByJWT(request);
            if (publicUser == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            PublicUser usuario = publicUser;
            LicencaNota licencaNota = this.licencaService.getLicencaNota(Integer.valueOf(idLicenca), Integer.valueOf(idNota));
            if (licencaNota == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Nota da Condicionante n\u00e3o encontrada.");
            }
            LicencaNota not = licencaNota;
            this.LOGGER.debug("{} - getLicencaNota()", (Object)usuario);
            return new ResponseEntity((Object)not, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.getLicencaNota", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.LOGGER.error("Exception.getLicencaNota", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @DeleteMapping(value={"/{idLicenca}/notas/{idNota}"})
    @Operation(summary="Exclui a Nota de uma Licen\u00e7a por meio de seu identificador.")
    @NotNull
    public ResponseEntity<Boolean> deleteLicencaNota(@PathVariable(value="idLicenca") int idLicenca, @PathVariable(value="idNota") int idNota, @NotNull HttpServletRequest request) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.LOGGER.debug("{} - deleteLicencaNota({})", (Object)usuario, (Object)idNota);
            this.licencaService.deleteLicencaNota(Integer.valueOf(idLicenca), Integer.valueOf(idNota));
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.deleteLicencaNota", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{idLicenca}/documentos"})
    @Operation(summary="Consulta paginada de anexos pertencentes \u00e0 Licen\u00e7a.", description="Consulta os anexos pertencentes \u00e0 Licen\u00e7a de acordo com o identificador informado.")
    @ApiResponses(value={@ApiResponse(description="Retorna os anexos da Licen\u00e7a cujo identificador foi enviado.", responseCode="200")})
    @NotNull
    public ResponseEntity<Page<LicencaDocumento>> findDocumentosByLicenca(@NotNull HttpServletRequest request, @PathVariable(value="idLicenca") int idLicenca, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.LOGGER.debug("{} - findDocumentosByLicenca()", (Object)usuario);
        return new ResponseEntity((Object)this.licencaService.findDocumentosByLicenca(Integer.valueOf(idLicenca), pageable), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(path={"/{idLicenca}/documentos"}, consumes={"multipart/form-data"})
    @Operation(summary="Cria\u00e7\u00e3o de anexo em Licen\u00e7a.", description="Cria um anexo para a Licen\u00e7a, utilizando o arquivo enviado.")
    @ApiResponses(value={@ApiResponse(description="Retorna o anexo criado.", responseCode="201")})
    @NotNull
    public ResponseEntity<LicencaDocumento> saveDocumentoByLicenca(@PathVariable(value="idLicenca") int idLicenca, @RequestPart(value="file") @NotNull MultipartFile file, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        PublicUser usuario = publicUser;
        try {
            this.LOGGER.debug("{} - saveDocumentoByLicenca())", (Object)usuario);
            return new ResponseEntity((Object)this.licencaService.registraUploadAnexoLicenca(file, Integer.valueOf(idLicenca), usuario.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.saveDocumento", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{idLicenca}/documentos/{seqArquivo}"})
    @Operation(summary="Exclui o Documento atrav\u00e9s de seu identificador")
    public void removeDocumentoLicenca(@PathVariable @Nullable Integer idLicenca, @PathVariable @Nullable Integer seqArquivo, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.LOGGER.debug("{} - deleteDocumento({})", (Object)usuario, (Object)seqArquivo);
        this.licencaService.removeDocumentoLicenca(idLicenca, seqArquivo, usuario.getId(), null);
    }

    @GetMapping(value={"/{idLicenca}/condicionantes"})
    @Operation(summary="Consulta paginada de Condicionantes de acordo com a Licen\u00e7a.", description="Realiza consulta paginada de Condicionantes, de acordo com o identificador de Licen\u00e7a enviado.")
    @ApiResponses(value={@ApiResponse(description="Retorna as condicionantes da Licen\u00e7a.", responseCode="200"), @ApiResponse(description="Licen\u00e7a n\u00e3o encontrada de acordo com identificador informado.", responseCode="404")})
    @NotNull
    public ResponseEntity<Page<CondicionantePaginationDTO>> findCondicionantesByLicenca(@PathVariable(value="idLicenca") int idLicenca, @RequestParam(value="search", required=false) @Nullable String search, @NotNull HttpServletRequest request, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.LOGGER.debug("{} - findCondicionantesByLicenca()", (Object)usuario);
        try {
            return new ResponseEntity((Object)this.licencaService.findCondicionantesByLicenca(Integer.valueOf(idLicenca), search, pageable), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.findCondicionantesByLicenca", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.LOGGER.error("Exception.findCondicionantesByLicenca", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{idLicenca}/condicionantes/{idCondicionante}"})
    @Operation(summary="Consulta Condicionante de acordo com o identificador de Licen\u00e7a e seu pr\u00f3prio identificador.", description="Realiza consulta de Condicionante por meio do identificador de Licen\u00e7a e seu pr\u00f3prio identificador.")
    @ApiResponses(value={@ApiResponse(description="Retorna a condicionante.", responseCode="200"), @ApiResponse(description="Condicionante n\u00e3o encontrada de acordo com identificador informado.", responseCode="404")})
    @NotNull
    public CondicionantePaginationDTO getCondicionanteById(@NotNull HttpServletRequest request, @PathVariable(value="idLicenca") int idLicenca, @PathVariable(value="idCondicionante") int idCondicionante) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.LOGGER.debug("{} - getCondicionanteById()", (Object)usuario);
        CondicionantePaginationDTO condicionantePaginationDTO = this.licencaService.getCondicionanteById(Integer.valueOf(idCondicionante), Integer.valueOf(idLicenca));
        Intrinsics.checkNotNullExpressionValue((Object)condicionantePaginationDTO, (String)"getCondicionanteById(...)");
        return condicionantePaginationDTO;
    }

    @PostMapping(value={"/{idLicenca}/condicionantes"})
    @Operation(summary="Cria uma Condicionante de acordo com os atributos enviados.", description="Realiza a cria\u00e7\u00e3o de uma Condicionante por meio dos atributos enviados em payload.")
    @ApiResponses(value={@ApiResponse(description="Retorna a condicionante.", responseCode="201"), @ApiResponse(description="Houve um erro ao criar uma Condicionante.", responseCode="400")})
    @NotNull
    public ResponseEntity<Condicionante> saveCondicionanteByLicenca(@PathVariable(value="idLicenca") int idLicenca, @Valid @RequestBody @NotNull CreateCondicionanteDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        PublicUser usuario = publicUser;
        try {
            this.LOGGER.debug("{} - saveCondicionanteByLicenca ({}))", (Object)usuario, (Object)dto);
            return new ResponseEntity((Object)this.licencaService.saveCondicionante(dto, Integer.valueOf(idLicenca), usuario.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.saveCondicionante", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PutMapping(value={"/{idLicenca}/condicionantes/{idCondicionante}"})
    @Operation(summary="Edita uma Condicionante de acordo com os atributos enviados.", description="Realiza a edi\u00e7\u00e3o de uma Condicionante por meio dos atributos enviados em payload.")
    @ApiResponses(value={@ApiResponse(description="Retorna a condicionante editada.", responseCode="201"), @ApiResponse(description="Houve um erro ao editar uma Condicionante.", responseCode="400")})
    @NotNull
    public ResponseEntity<Condicionante> editCondicionanteByLicenca(@PathVariable(value="idLicenca") int idLicenca, @PathVariable(value="idCondicionante") int idCondicionante, @Valid @RequestBody @NotNull CreateCondicionanteDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        PublicUser usuario = publicUser;
        try {
            this.LOGGER.debug("{} - saveCondicionanteByLicenca ({}))", (Object)usuario, (Object)dto);
            return new ResponseEntity((Object)this.licencaService.editCondicionante(dto, Integer.valueOf(idLicenca), Integer.valueOf(idCondicionante), usuario.getId()), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.saveCondicionante", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{idLicenca}/condicionantes/{idCondicionante}"})
    @Operation(summary="Deleta uma condicionante de acordo com seu identificador.", description="Deleta uma condicionante de acordo com o identificador informado na URL.")
    @ApiResponses(value={@ApiResponse(description="Deleta a condicionante.", responseCode="200"), @ApiResponse(description="Houve um erro ao deletar uma Condicionante.", responseCode="400")})
    @NotNull
    public ResponseEntity<Boolean> deleteCondicionanteByLicenca(@PathVariable(name="idCondicionante") int idCondicionante, @PathVariable(name="idLicenca") int idLicenca, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.LOGGER.debug("{} - deleteCondicionanteByLicenca({}, {})", (Object)usuario, (Object)idCondicionante);
        try {
            return new ResponseEntity((Object)this.licencaService.deleteCondicionante(Integer.valueOf(idCondicionante), Integer.valueOf(idLicenca)), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.deleteCondicionante", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{idLicenca}/condicionantes/{idCondicionante}/notas"})
    @Operation(summary="Consulta paginada de notas de uma Condicionante.", description="Realiza consulta paginada de notas de uma Condicionante de acordo com seu identificador.")
    @ApiResponses(value={@ApiResponse(description="Retorna pagina\u00e7\u00e3o de notas de Condicionante", responseCode="200"), @ApiResponse(description="Houve um erro ao buscar as notas da Condicionante informada.", responseCode="400")})
    @NotNull
    public ResponseEntity<Page<CondicionanteNota>> findCondicionanteNota(@NotNull HttpServletRequest request, @PathVariable(value="idLicenca") int idLicenca, @PathVariable(value="idCondicionante") int idCondicionante, @RequestParam(value="search", required=false) @Nullable String search, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.LOGGER.debug("{} - findCondicionanteNota()", (Object)usuario);
        try {
            return new ResponseEntity((Object)this.licencaService.findCondicionanteNota(Integer.valueOf(idLicenca), Integer.valueOf(idCondicionante), search, pageable), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.findCondicionanteNota", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.LOGGER.error("Exception.findCondicionanteNota", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{idLicenca}/condicionantes/{idCondicionante}/notas/{idNota}"})
    @Operation(summary="Consulta de nota de uma Condicionante de acordo com seu identificador.", description="Realiza consulta de nota de uma Condicionante de acordo com seu identificador.")
    @ApiResponses(value={@ApiResponse(description="Retorna uma nota espec\u00edfica de Condicionante", responseCode="200"), @ApiResponse(description="Houve um erro ao buscar a notas de Condicionante com o identificador informado.", responseCode="400")})
    @NotNull
    public ResponseEntity<CondicionanteNota> getCondicionanteNota(@NotNull HttpServletRequest request, @PathVariable(value="idLicenca") int idLicenca, @PathVariable(value="idCondicionante") int idCondicionante, @PathVariable(value="idNota") int idNota) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.LOGGER.debug("API getCondicionanteNota...");
        try {
            PublicUser publicUser = this.getUsuarioByJWT(request);
            if (publicUser == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            PublicUser usuario = publicUser;
            this.LOGGER.debug("{} - getCondicionanteNota()", (Object)usuario);
            return new ResponseEntity((Object)this.licencaService.getCondicionanteNota(Integer.valueOf(idCondicionante), Integer.valueOf(idNota), Integer.valueOf(idLicenca)), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.getCondicionanteNota", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.LOGGER.error("Exception.getCondicionanteNota", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/{idLicenca}/condicionantes/{idCondicionante}/notas"})
    @Operation(summary="Cria nota de uma Condicionante.", description="Realiza o cadastro de nota de uma Condicionante.")
    @ApiResponses(value={@ApiResponse(description="Retorna uma nota de Condicionante", responseCode="200"), @ApiResponse(description="Houve um erro ao criar nota de Condicionante.", responseCode="400")})
    @NotNull
    public ResponseEntity<CondicionanteNota> saveCondicionanteNota(@PathVariable(name="idLicenca") int idLicenca, @PathVariable(name="idCondicionante") int idCondicionante, @RequestBody @Nullable CondicionanteNota condicionanteNota, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.LOGGER.debug("{} - saveCondicionanteNota ({}, {}))", (Object)usuario, (Object)condicionanteNota);
            return new ResponseEntity((Object)this.licencaService.saveCondicionanteNota(condicionanteNota, Integer.valueOf(idLicenca), Integer.valueOf(idCondicionante), usuario.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.saveCondicionante", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{idLicenca}/condicionantes/{idCondicionante}/notas/{idNota}"})
    @Operation(summary="Exclui nota de Condicionante.", description="Deleta nota de uma Condicionante de acordo com seu identificador informado.")
    @ApiResponses(value={@ApiResponse(description="Nota de Condicionante deletada com sucesso.", responseCode="200"), @ApiResponse(description="Houve um erro ao deletar Nota de Condicionante.", responseCode="400")})
    @NotNull
    public ResponseEntity<Boolean> deleteCondicionanteNota(@PathVariable(value="idLicenca") int idLicenca, @PathVariable(value="idCondicionante") int idCondicionante, @PathVariable(value="idNota") int idNota, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.LOGGER.debug("{} - deleteCondicionanteNota({}, {})", (Object)usuario, (Object)idNota);
            this.licencaService.deleteCondicionanteNota(Integer.valueOf(idCondicionante), Integer.valueOf(idNota), Integer.valueOf(idLicenca));
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.deleteCondicionanteNota", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PutMapping(value={"/{idLicenca}/condicionantes/{idCondicionante}/notas/{idNota}"})
    @Operation(summary="Edi\u00e7\u00e3o de nota de Condicionante.", description="Edi\u00e7\u00e3o de nota de Condicionante.")
    @ApiResponses(value={@ApiResponse(description="Nota de Condicionante editada com sucesso.", responseCode="200"), @ApiResponse(description="Houve um erro ao editar Nota de Condicionante.", responseCode="400")})
    @NotNull
    public ResponseEntity<CondicionanteNota> editCondicionanteNota(@RequestBody @NotNull CondicionanteNotaDTO dto, @PathVariable(value="idLicenca") int idLicenca, @PathVariable(value="idCondicionante") int idCondicionante, @PathVariable(value="idNota") int idNota, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.LOGGER.debug("{} - deleteCondicionanteNota({}, {})", (Object)usuario, (Object)idNota);
            return new ResponseEntity((Object)this.licencaService.editCondicionanteNota(dto, Integer.valueOf(idCondicionante), Integer.valueOf(idNota), Integer.valueOf(idLicenca), usuario.getId()), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.deleteCondicionanteNota", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{idLicenca}/condicionantes/{idCondicionante}/planosAcao"})
    @Operation(summary="Consulta paginada de Planos de A\u00e7\u00e3o de uma Condicionante.", description="Realiza consulta paginada de Planos de A\u00e7\u00e3o de uma Condicionante de acordo com seu identificador informado.")
    @ApiResponses(value={@ApiResponse(description="Consulta de Planos de A\u00e7\u00e3o realizada com sucesso.", responseCode="200"), @ApiResponse(description="Houve um erro ao consultar os Planos de A\u00e7\u00e3o de uma Condicionante.", responseCode="400")})
    @NotNull
    public ResponseEntity<Page<PlanoAcaoCondicionante>> findPlanosAcao(@NotNull HttpServletRequest request, @PathVariable(value="idLicenca") int idLicenca, @PathVariable(value="idCondicionante") int idCondicionante, @RequestParam(value="search", required=false) @Nullable String search, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        if (this.getUsuarioByJWT(request) == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        this.LOGGER.debug("findPlanosAcao ({})", (Object)idCondicionante);
        try {
            return new ResponseEntity((Object)this.licencaService.findPlanosAcao(Integer.valueOf(idLicenca), Integer.valueOf(idCondicionante), search, pageable), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.findPlanoAcaoCondicionante", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.LOGGER.error("Exception.findPlanoAcaoCondicionante", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{idLicenca}/condicionantes/{idCondicionante}/planosAcao/{idPlanoAcao}"})
    @Operation(summary="Consulta de Plano de A\u00e7\u00e3o de uma Condicionante.", description="Realiza consulta de Plano de A\u00e7\u00e3o de uma Condicionante de acordo com seu identificador informado.")
    @ApiResponses(value={@ApiResponse(description="Plano de A\u00e7\u00e3o encontrado com sucesso.", responseCode="200"), @ApiResponse(description="Houve um erro ao consultar o Plano de A\u00e7\u00e3o com o identificador informado.", responseCode="400")})
    @NotNull
    public ResponseEntity<PlanoAcaoCondicionante> getPlanoAcaoById(@NotNull HttpServletRequest request, @PathVariable(value="idLicenca") int idLicenca, @PathVariable(value="idCondicionante") int idCondicionante, @PathVariable(value="idPlanoAcao") int idPlanoAcao) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            if (this.getUsuarioByJWT(request) == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            PlanoAcaoCondicionante planoAcaoCondicionante = this.licencaService.getPlanoAcaoById(Integer.valueOf(idPlanoAcao), Integer.valueOf(idCondicionante), Integer.valueOf(idLicenca));
            if (planoAcaoCondicionante == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Plano de A\u00e7\u00e3o n\u00e3o encontrada.");
            }
            PlanoAcaoCondicionante plano = planoAcaoCondicionante;
            return new ResponseEntity((Object)plano, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.getPlanoAcaoCondicionante", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.LOGGER.error("Exception.getPlanoAcaoCondicionante", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/{idLicenca}/condicionantes/{idCondicionante}/planosAcao"})
    @Operation(summary="Salva Plano de A\u00e7\u00e3o de uma Condicionante.", description="Realiza cadastro de Plano de A\u00e7\u00e3o de uma Condicionante de acordo com payload informado.")
    @ApiResponses(value={@ApiResponse(description="Plano de A\u00e7\u00e3o criado com sucesso.", responseCode="200"), @ApiResponse(description="Houve um erro ao criar o Plano de A\u00e7\u00e3o com o payload informado.", responseCode="400")})
    @NotNull
    public ResponseEntity<PlanoAcaoCondicionante> savePlanoAcao(@PathVariable(value="idCondicionante") int idCondicionante, @RequestBody @NotNull CreatePlanoAcaoCondicionanteDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        SegurancaService segurancaService = this.segurancaService;
        Intrinsics.checkNotNull((Object)segurancaService);
        PublicUser publicUser2 = segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            this.LOGGER.debug("{} - savePlanoAcaoCondicionante ({}))", (Object)usuario, (Object)dto);
            return new ResponseEntity((Object)this.licencaService.savePlanoAcao(dto, Integer.valueOf(idCondicionante), usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.savePlanoAcaoCondicionante", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PutMapping(value={"/{idLicenca}/condicionantes/{idCondicionante}/planosAcao/{idPlanoAcao}"})
    @Operation(summary="Edita Plano de A\u00e7\u00e3o de uma Condicionante.", description="Realiza edi\u00e7\u00e3o de Plano de A\u00e7\u00e3o de uma Condicionante de acordo com payload informado.")
    @ApiResponses(value={@ApiResponse(description="Plano de A\u00e7\u00e3o editado com sucesso.", responseCode="200"), @ApiResponse(description="Houve um erro ao editar o Plano de A\u00e7\u00e3o com o payload informado.", responseCode="400")})
    @NotNull
    public ResponseEntity<PlanoAcaoCondicionante> editPlanoAcao(@PathVariable(value="idCondicionante") int idCondicionante, @PathVariable(value="idPlanoAcao") int idPlanoAcao, @RequestBody @NotNull EditPlanoAcaoCondicionanteDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        SegurancaService segurancaService = this.segurancaService;
        Intrinsics.checkNotNull((Object)segurancaService);
        PublicUser publicUser2 = segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            this.LOGGER.debug("{} - editPlanoAcaoCondicionante ({}))", (Object)usuario, (Object)dto);
            return new ResponseEntity((Object)this.licencaService.editPlanoAcao(dto, Integer.valueOf(idPlanoAcao), Integer.valueOf(idCondicionante), usr.getId()), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.savePlanoAcaoCondicionante", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{idLicenca}/condicionantes/{idCondicionante}/planosAcao/{idPlanoAcao}"})
    @Operation(summary="Exclui Plano de A\u00e7\u00e3o de uma Condicionante.", description="Exclui Plano de A\u00e7\u00e3o de uma Condicionante de acordo com identificador informado.")
    @ApiResponses(value={@ApiResponse(description="Plano de A\u00e7\u00e3o deletado com sucesso.", responseCode="200"), @ApiResponse(description="Houve um erro ao deletar o Plano de A\u00e7\u00e3o com o identificador informado.", responseCode="400")})
    @NotNull
    public ResponseEntity<Boolean> deletePlanoAcao(@PathVariable(value="idLicenca") int idLicenca, @PathVariable(value="idCondicionante") int idCondicionante, @PathVariable(value="idPlanoAcao") int idPlanoAcao, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.LOGGER.debug("{} - deletePlanoAcao({})", (Object)usuario, (Object)idPlanoAcao);
            this.licencaService.deletePlanoAcao(Integer.valueOf(idPlanoAcao), Integer.valueOf(idCondicionante), Integer.valueOf(idLicenca));
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.deletePlanoAcaoCondicionante", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{idLicenca}/condicionantes/{idCondicionante}/planosAcao/{idPlanoAcao}/documentos"}, consumes={"multipart/form-data"})
    @Operation(summary="Salva o documento de um Plano de A\u00e7\u00e3o de uma Condicionante.", description="Realiza cadastro de documento pertencente \u00e0 um Plano de A\u00e7\u00e3o de uma Condicionante de acordo com identificador informado.")
    @ApiResponses(value={@ApiResponse(description="Documento do Plano de A\u00e7\u00e3o criado com sucesso.", responseCode="200"), @ApiResponse(description="Houve um erro ao criar o Documento do Plano de A\u00e7\u00e3o com o identificador informado.", responseCode="400")})
    @NotNull
    public ResponseEntity<PlanoAcaoCondicionanteDocumento> savePlanoAcaoCondicionanteDocumento(@PathVariable(value="idLicenca") int idLicenca, @PathVariable(value="idCondicionante") int idCondicionante, @PathVariable(value="idPlanoAcao") int idPlanoAcao, @RequestPart(value="file") @NotNull MultipartFile file, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        SegurancaService segurancaService = this.segurancaService;
        Intrinsics.checkNotNull((Object)segurancaService);
        PublicUser publicUser = segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser;
        try {
            this.LOGGER.debug("{} - savePlanoAcaoCondicionanteDocumento ())", (Object)usuario);
            return new ResponseEntity((Object)this.licencaService.registraUploadAnexoPlanoAcao(file, Integer.valueOf(idPlanoAcao), Integer.valueOf(idCondicionante), Integer.valueOf(idLicenca), usuario.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.saveCondicionanteDocumento", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{idLicenca}/condicionantes/{idCondicionante}/planosAcao/{idPlanoAcao}/documentos"})
    @Operation(summary="Consulta os documentos de um Plano de A\u00e7\u00e3o de uma Condicionante.", description="Realiza consulta de documentos pertencentes a um Plano de A\u00e7\u00e3o de uma Condicionante de acordo com identificador informado.")
    @ApiResponses(value={@ApiResponse(description="Consulta de Documentos do Plano de A\u00e7\u00e3o criado com sucesso.", responseCode="200"), @ApiResponse(description="Houve um erro ao consultar os Documentos do Plano de A\u00e7\u00e3o com o identificador informado.", responseCode="400")})
    @NotNull
    public Page<PlanoAcaoCondicionanteDocumento> findDocumentosByPlanoAcao(@NotNull HttpServletRequest request, @PathVariable(value="idLicenca") int idLicenca, @PathVariable(value="idCondicionante") int idCondicionante, @PathVariable(value="idPlanoAcao") int idPlanoAcao, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.LOGGER.debug("{} - findDocumentosByPlanoAcao()", (Object)usuario);
        try {
            Page page = this.licencaService.findDocumentosByPlanoAcao(Integer.valueOf(idPlanoAcao), Integer.valueOf(idCondicionante), Integer.valueOf(idLicenca), pageable);
            Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findDocumentosByPlanoAcao(...)");
            return page;
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.findDocumentosByPlanoAcao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.LOGGER.error("Exception.findDocumentosByPlanoAcao", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @DeleteMapping(value={"/{idLicenca}/condicionantes/{idCondicionante}/planosAcao/{idPlanoAcao}/documentos/{seqAnexo}"})
    @Operation(summary="Deleta o documento de um Plano de A\u00e7\u00e3o de uma Condicionante.", description="Realiza dele\u00e7\u00e3o de documento pertencente a um Plano de A\u00e7\u00e3o de uma Condicionante de acordo com identificador informado.")
    @ApiResponses(value={@ApiResponse(description="Dele\u00e7\u00e3o de Documento do Plano de A\u00e7\u00e3o realizado com sucesso.", responseCode="200"), @ApiResponse(description="Houve um erro ao deletar o Documento do Plano de A\u00e7\u00e3o com o identificador informado.", responseCode="400")})
    @NotNull
    public ResponseEntity<Boolean> removeDocumentoPlanoAcao(@PathVariable(value="idLicenca") int idLicenca, @PathVariable(value="idCondicionante") int idCondicionante, @PathVariable(value="idPlanoAcao") int idPlanoAcao, @PathVariable(value="seqAnexo") int seqAnexo, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.licencaService.removeDocumentoPlanoAcao(Integer.valueOf(idPlanoAcao), Integer.valueOf(idCondicionante), Integer.valueOf(idLicenca), Integer.valueOf(seqAnexo), usuario.getId(), this.getIpExterno(request));
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.removeDocumentoPlanoAcao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{idLicenca}/condicionantes/{idCondicionante}/documentos"})
    @Operation(summary="Consulta os documentos de uma Condicionante.", description="Consulta os documentos de uma Condicionante de acordo com seu identificador.")
    @ApiResponses(value={@ApiResponse(description="Consulta de documentos de Condicionante realizada com sucesso.", responseCode="200"), @ApiResponse(description="Houve um erro ao realizar consulta de documentos de Condicionante com identificador informado.", responseCode="400")})
    @NotNull
    public ResponseEntity<Page<CondicionanteDocumentoPaginationDTO>> findDocumentosByCondicionante(@NotNull HttpServletRequest request, @PathVariable(value="idLicenca") int idLicenca, @PathVariable(value="idCondicionante") int idCondicionante, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.LOGGER.debug("{} - findDocumentosByCondicionante()", (Object)usuario);
        try {
            Page page = this.licencaService.findDocumentosByCondicionante(Integer.valueOf(idLicenca), Integer.valueOf(idCondicionante), pageable);
            if (page == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Condicionante n\u00e3o encontrado.");
            }
            Page documentos = page;
            return new ResponseEntity((Object)documentos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.findCondicionanteDocumento", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.LOGGER.error("Exception.findCondicionanteDocumento", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{idLicenca}/condicionantes/{idCondicionante}/documentos/{seqArquivo}"})
    @Operation(summary="Consulta o documento de uma Condicionante de acordo com seu identificador.", description="Consulta o documento de uma Condicionante de acordo com seu identificador espec\u00edficado na URL.")
    @ApiResponses(value={@ApiResponse(description="Consulta de documento de Condicionante realizado com sucesso.", responseCode="200"), @ApiResponse(description="Houve um erro ao realizar consulta de documento de Condicionante com identificador informado.", responseCode="400")})
    @NotNull
    public ResponseEntity<CondicionanteDocumento> getDocumentoBySeq(@NotNull HttpServletRequest request, @PathVariable(value="idLicenca") int idLicenca, @PathVariable(value="idCondicionante") int idCondicionante, @PathVariable(value="seqArquivo") int seqArquivo) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            PublicUser publicUser = this.getUsuarioByJWT(request);
            if (publicUser == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            PublicUser usuario = publicUser;
            CondicionanteDocumento doc = this.licencaService.getCondicionanteDocumentoBySeq(Integer.valueOf(idLicenca), Integer.valueOf(idCondicionante), Integer.valueOf(seqArquivo));
            this.LOGGER.debug("{} - getDocumentoBySeq()", (Object)usuario);
            return new ResponseEntity((Object)doc, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.getCondicionanteDocumento", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.LOGGER.error("Exception.getCondicionanteDocumento", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/{idLicenca}/condicionantes/{idCondicionante}/documentos"}, consumes={"multipart/form-data"})
    @Operation(summary="Salva o documento de uma Condicionante de acordo com seu identificador.", description="Salva o documento de uma Condicionante de acordo com seu identificador espec\u00edficado na URL.")
    @ApiResponses(value={@ApiResponse(description="Documento de Condicionante criado com sucesso.", responseCode="200"), @ApiResponse(description="Houve um erro ao criar documento de Condicionante com identificador informado.", responseCode="400")})
    @NotNull
    public ResponseEntity<CondicionanteDocumento> saveCondicionanteDocumento(@PathVariable(value="idLicenca") int idLicenca, @PathVariable(value="idCondicionante") int idCondicionante, @RequestPart(value="file") @NotNull MultipartFile file, @NotNull HttpServletRequest request) {
        PublicUser usuario;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = usuario = this.getUsuarioByJWT(request);
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(publicUser != null ? publicUser.getLogin() : null);
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            return new ResponseEntity((Object)this.licencaService.registraUploadAnexoCondicionante(Integer.valueOf(idLicenca), Integer.valueOf(idCondicionante), file, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.saveCondicionanteDocumento", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{idLicenca}/condicionantes/{idCondicionante}/documentos/{seqArquivo}"})
    @Operation(summary="Exclui o documento de uma Condicionante de acordo com seu identificador.", description="Exclui o documento de uma Condicionante de acordo com seu identificador espec\u00edficado na URL.")
    @ApiResponses(value={@ApiResponse(description="Documento de Condicionante deletado com sucesso.", responseCode="200"), @ApiResponse(description="Houve um erro ao deletar documento de Condicionante com identificador informado.", responseCode="400")})
    @NotNull
    public ResponseEntity<Boolean> removeDocumento(@PathVariable(value="idLicenca") int idLicenca, @PathVariable(value="idCondicionante") int idCondicionante, @PathVariable(value="seqArquivo") int seqArquivo, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.LOGGER.debug("{} - deleteDocumento({})", (Object)usuario, (Object)seqArquivo);
            this.licencaService.removeDocumento(Integer.valueOf(idLicenca), Integer.valueOf(idCondicionante), Integer.valueOf(seqArquivo), usuario.getId(), this.getIpExterno(request));
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.deleteCondicionanteDocumento", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{idLicenca}/obras"})
    @Operation(summary="Consulta obras de uma Licen\u00e7a de acordo com seu identificador.", description="Consulta obras de uma Licen\u00e7a de acordo com seu identificador espec\u00edficado na URL.")
    @ApiResponses(value={@ApiResponse(description="Obras da Licen\u00e7a consultadas com sucesso.", responseCode="200"), @ApiResponse(description="Houve um erro ao consultar Obras de Licen\u00e7a com identificador informado.", responseCode="400")})
    @NotNull
    public ResponseEntity<Page<LicencaObra>> findObrasByLicenca(@NotNull HttpServletRequest request, @PathVariable(value="idLicenca") int idLicenca, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.LOGGER.debug("{} - findObrasByLicenca()", (Object)usuario);
        try {
            Page obras = this.licencaService.findObrasByLicenca(Integer.valueOf(idLicenca), pageable);
            return new ResponseEntity((Object)obras, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.findObrasByLicenca", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.LOGGER.error("Exception.findObrasByLicenca", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{idLicenca}/obras/{idObra}"})
    @Operation(summary="Consulta obra de uma Licen\u00e7a de acordo com seu identificador.", description="Consulta obra de uma Licen\u00e7a de acordo com seu identificador espec\u00edficado na URL.")
    @ApiResponses(value={@ApiResponse(description="Obra da Licen\u00e7a consultada com sucesso.", responseCode="200"), @ApiResponse(description="Houve um erro ao consultar Obra de Licen\u00e7a com identificador informado.", responseCode="400")})
    @NotNull
    public ResponseEntity<LicencaObra> getLicencaObraById(@NotNull HttpServletRequest request, @PathVariable(value="idLicenca") int idLicenca, @PathVariable(value="idObra") int idObra) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            PublicUser publicUser = this.getUsuarioByJWT(request);
            if (publicUser == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            PublicUser usuario = publicUser;
            LicencaObra licencaObra = this.licencaService.getLicencaObraById(Integer.valueOf(idLicenca), Integer.valueOf(idObra));
            if (licencaObra == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Obra n\u00e3o encontrada.");
            }
            LicencaObra doc = licencaObra;
            this.LOGGER.debug("{} - getLicencaObraById()", (Object)usuario);
            return new ResponseEntity((Object)doc, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.getObra", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.LOGGER.error("Exception.getObra", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/{idLicenca}/obras"})
    @Operation(summary="Cria Obra de uma Licen\u00e7a de acordo com seu identificador.", description="Cria Obra de uma Licen\u00e7a de acordo com seu identificador espec\u00edficado na URL.")
    @ApiResponses(value={@ApiResponse(description="Obra de Licen\u00e7a criada com sucesso.", responseCode="200"), @ApiResponse(description="Houve um erro ao criar Obra de Licen\u00e7a com identificador informado.", responseCode="400")})
    @NotNull
    public ResponseEntity<Boolean> saveLicencaObra(@RequestBody @NotNull LicencaObraVO licencaObra, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)licencaObra, (String)"licencaObra");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            this.LOGGER.debug("{} - saveLicencaObra ({}))", (Object)usuario, (Object)licencaObra);
            return new ResponseEntity((Object)this.licencaService.saveLicencaObra(licencaObra, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.saveObra", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{idLicenca}/obras/{seqObra}"})
    @Operation(summary="Exclui a obra atrav\u00e9s de seu identificador")
    @NotNull
    public ResponseEntity<Boolean> deleteLicencaObra(@PathVariable(name="idLicenca") @Nullable Integer idLicenca, @PathVariable(name="seqObra") @Nullable Integer sequencia, @NotNull HttpServletRequest request) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.LOGGER.debug("{} - deleteLicencaObra({})", (Object)usuario, (Object)idLicenca);
        try {
            return new ResponseEntity((Object)this.licencaService.deleteLicencaObra(idLicenca, sequencia), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.deleteLicencaObra", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

