/*
 * Decompiled with CFR 0.152.
 */
package br.com.sigescantt.apis;

import br.com.sigescantt.apis.BaseRestService;
import br.com.sigescantt.core.beans.geral.Empresa;
import br.com.sigescantt.core.beans.seguranca.PublicUser;
import br.com.sigescantt.core.dto.itensObrigacao.ItemObrigacaoDTO;
import br.com.sigescantt.exceptions.BusinessException;
import br.com.sigescantt.geral.EstruturaContrato;
import br.com.sigescantt.geral.EstruturaContratoEscopo;
import br.com.sigescantt.geral.ParametroDesempenho;
import br.com.sigescantt.geral.ParametroDesempenhoItem;
import br.com.sigescantt.services.CadastroService;
import br.com.sigescantt.services.CoreService;
import br.com.sigescantt.services.EstruturaContratoService;
import br.com.sigescantt.services.SegurancaService;
import br.com.sigescantt.services.contratos.ImportacaoContratosHelper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@RestController
@Tag(name="itensContratos", description="REST Services para Estruturas do contrato/PER")
@RequestMapping(value={"/api/itensContratos"})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u001c\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0017J\u0012\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010\u0018\u001a\u00020\u0011H\u0017JB\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001b0\u001a2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\n\b\u0001\u0010\u001d\u001a\u0004\u0018\u00010\u00112\n\b\u0001\u0010\u001e\u001a\u0004\u0018\u00010\u00112\n\b\u0001\u0010\u001f\u001a\u0004\u0018\u00010\u0011H\u0017J,\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001c0\u001a2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u001d\u001a\u00020\u00112\b\b\u0001\u0010!\u001a\u00020\"H\u0017J6\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001a2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u001d\u001a\u00020\u00112\b\b\u0001\u0010$\u001a\u00020%2\b\b\u0001\u0010!\u001a\u00020\"H\u0017J&\u0010&\u001a\u00020'2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u001d\u001a\u00020\u00112\b\b\u0001\u0010$\u001a\u00020%H\u0017J&\u0010(\u001a\u00020\u001c2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u001d\u001a\u00020\u00112\b\b\u0001\u0010$\u001a\u00020%H\u0017J(\u0010)\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020*0\u001b0\u001a2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u001d\u001a\u00020\u0011H\u0017J(\u0010+\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020,0\u001b0\u001a2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u001d\u001a\u00020\u0011H\u0017J(\u0010-\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020.0\u001b0\u001a2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u001d\u001a\u00020\u0011H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lbr/com/sigescantt/apis/ItensContratoRestServices;", "Lbr/com/sigescantt/apis/BaseRestService;", "segurancaService", "Lbr/com/sigescantt/services/SegurancaService;", "coreService", "Lbr/com/sigescantt/services/CoreService;", "cadastroService", "Lbr/com/sigescantt/services/CadastroService;", "estruturaContratoService", "Lbr/com/sigescantt/services/EstruturaContratoService;", "importacaoContratosHelper", "Lbr/com/sigescantt/services/contratos/ImportacaoContratosHelper;", "<init>", "(Lbr/com/sigescantt/services/SegurancaService;Lbr/com/sigescantt/services/CoreService;Lbr/com/sigescantt/services/CadastroService;Lbr/com/sigescantt/services/EstruturaContratoService;Lbr/com/sigescantt/services/contratos/ImportacaoContratosHelper;)V", "LOG", "Lorg/slf4j/Logger;", "importItensPER", "", "request", "Ljakarta/servlet/http/HttpServletRequest;", "file", "Lorg/springframework/web/multipart/MultipartFile;", "getImportacaoProgress", "Lorg/springframework/web/servlet/mvc/method/annotation/SseEmitter;", "jobId", "findItensContrato", "Lorg/springframework/http/ResponseEntity;", "", "Lbr/com/sigescantt/geral/EstruturaContrato;", "empresa", "itemPer", "itemPep", "createItensContrato", "dto", "Lbr/com/sigescantt/core/dto/itensObrigacao/ItemObrigacaoDTO;", "editItensContrato", "idEstruturaContrato", "", "deleteItensContrato", "", "getItensContrato", "findEscopoContrato", "Lbr/com/sigescantt/geral/EstruturaContratoEscopo;", "findParametrosDesempenho", "Lbr/com/sigescantt/geral/ParametroDesempenho;", "findParametroDesempenhoItens", "Lbr/com/sigescantt/geral/ParametroDesempenhoItem;", "server"})
public class ItensContratoRestServices
extends BaseRestService {
    @NotNull
    private final SegurancaService segurancaService;
    @NotNull
    private final CoreService coreService;
    @NotNull
    private final CadastroService cadastroService;
    @NotNull
    private final EstruturaContratoService estruturaContratoService;
    @NotNull
    private final ImportacaoContratosHelper importacaoContratosHelper;
    @NotNull
    private final Logger LOG;

    public ItensContratoRestServices(@NotNull SegurancaService segurancaService, @NotNull CoreService coreService, @NotNull CadastroService cadastroService, @NotNull EstruturaContratoService estruturaContratoService, @NotNull ImportacaoContratosHelper importacaoContratosHelper) {
        Intrinsics.checkNotNullParameter((Object)segurancaService, (String)"segurancaService");
        Intrinsics.checkNotNullParameter((Object)coreService, (String)"coreService");
        Intrinsics.checkNotNullParameter((Object)cadastroService, (String)"cadastroService");
        Intrinsics.checkNotNullParameter((Object)estruturaContratoService, (String)"estruturaContratoService");
        Intrinsics.checkNotNullParameter((Object)importacaoContratosHelper, (String)"importacaoContratosHelper");
        super(segurancaService);
        this.segurancaService = segurancaService;
        this.coreService = coreService;
        this.cadastroService = cadastroService;
        this.estruturaContratoService = estruturaContratoService;
        this.importacaoContratosHelper = importacaoContratosHelper;
        Logger logger = LoggerFactory.getLogger(ItensContratoRestServices.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.LOG = logger;
    }

    @PostMapping(value={"/importacao"}, consumes={"multipart/form-data"})
    @Operation(summary="Realizar importa\u00e7\u00e3o de planilha com Itens do PER.", description="Realizar importa\u00e7\u00e3o de planilha com Itens do PER.")
    @ApiResponses(value={@ApiResponse(description="Opera\u00e7\u00e3o realizada com sucesso", responseCode="200")})
    @NotNull
    public String importItensPER(@Parameter(hidden=true) @NotNull HttpServletRequest request, @RequestPart(value="file") @NotNull MultipartFile file) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String jobId = string;
        this.importacaoContratosHelper.importarItensPER(file.getInputStream(), jobId, usuario.getId());
        return jobId;
    }

    @GetMapping(value={"/import/progress/{jobId}"}, produces={"text/event-stream"})
    @Operation(summary="Verificar progresso da importa\u00e7\u00e3o de monitora\u00e7\u00f5es", description="Retorna o progresso da importa\u00e7\u00e3o de monitora\u00e7\u00f5es em tempo real")
    @ApiResponses(value={@ApiResponse(description="Progresso da importa\u00e7\u00e3o retornado com sucesso", responseCode="200"), @ApiResponse(description="Job de importa\u00e7\u00e3o n\u00e3o encontrado", responseCode="404")})
    @NotNull
    public SseEmitter getImportacaoProgress(@PathVariable(value="jobId") @NotNull String jobId) {
        Intrinsics.checkNotNullParameter((Object)jobId, (String)"jobId");
        SseEmitter sseEmitter = this.importacaoContratosHelper.registerProgressListener(jobId);
        Intrinsics.checkNotNullExpressionValue((Object)sseEmitter, (String)"registerProgressListener(...)");
        return sseEmitter;
    }

    @GetMapping(value={"/{empresa}"})
    @Operation(summary="Consulta os itens de contrato, de acordo com os filtros informados", description="Retorna uma lista de estruturas de contrato filtradas por empresa, com op\u00e7\u00e3o de filtros adicionais por itemPer e itemPep. As refer\u00eancias circulares s\u00e3o removidas (itemPrincipal \u00e9 definido como null).")
    @ApiResponses(value={@ApiResponse(description="Opera\u00e7\u00e3o realizada com sucesso", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<List<EstruturaContrato>> findItensContrato(@Parameter(hidden=true) @NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="Filtro opcional por item PER") @RequestParam(name="itemPer", required=false) @Nullable String itemPer, @Parameter(description="Filtro opcional por item PEP") @RequestParam(name="itemPep", required=false) @Nullable String itemPep) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.LOG.debug("{} - findItensContrato(empresa={})...", (Object)usuario.getLogin(), (Object)empresa);
        return new ResponseEntity((Object)this.estruturaContratoService.getAllEstruturaContrato(empresa), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/{empresa}"})
    @Operation(summary="Cadastra o item de contrato de acordo com o payload informado.", description="Cadastra o item de contrato de acordo com o payload informado.")
    @ApiResponses(value={@ApiResponse(description="Item de Contrato cadastrado com sucesso", responseCode="201")})
    @ResponseBody
    @NotNull
    public ResponseEntity<EstruturaContrato> createItensContrato(@Parameter(hidden=true) @NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa, @Parameter(description="Payload com informa\u00e7\u00f5es do Item de Contrato") @Valid @RequestBody @NotNull ItemObrigacaoDTO dto) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.LOG.debug("{} - createItensContrato(empresa={})...", (Object)usuario.getLogin(), (Object)empresa);
        Empresa emp = this.coreService.getEmpresaBySigla(empresa);
        Integer idEmpresa = emp.getId();
        return new ResponseEntity((Object)this.estruturaContratoService.createEstruturaContrato(dto, idEmpresa, usuario.getId()), (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/{empresa}/{idEstruturaContrato}"})
    @Operation(summary="Edita o item de contrato de acordo com o payload informado.", description="Edita o item de contrato de acordo com o payload informado.")
    @ApiResponses(value={@ApiResponse(description="Item de Contrato editado com sucesso", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<EstruturaContrato> editItensContrato(@Parameter(hidden=true) @NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa, @Parameter(description="Identificador do Item de Contrato") @PathVariable(name="idEstruturaContrato") int idEstruturaContrato, @Parameter(description="Payload com informa\u00e7\u00f5es do Item de Contrato") @RequestBody @Valid @NotNull ItemObrigacaoDTO dto) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.LOG.debug("{} - editItensContrato(empresa={})...", (Object)usuario.getLogin(), (Object)empresa);
        Empresa emp = this.coreService.getEmpresaBySigla(empresa);
        Integer idEmpresa = emp.getId();
        return new ResponseEntity((Object)this.estruturaContratoService.editEstruturaContrato(dto, idEmpresa, Integer.valueOf(idEstruturaContrato), usuario.getId()), (HttpStatusCode)HttpStatus.OK);
    }

    @DeleteMapping(value={"/{empresa}/{idEstruturaContrato}"})
    @Operation(summary="Deleta o item de contrato de acordo com o identificador informado.", description="Deleta o item de contrato de acordo com o identificador informado.")
    @ApiResponses(value={@ApiResponse(description="Item de Contrato deletado com sucesso", responseCode="200")})
    @ResponseBody
    public void deleteItensContrato(@Parameter(hidden=true) @NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa, @Parameter(description="Identificador do Item de Contrato") @PathVariable(name="idEstruturaContrato") int idEstruturaContrato) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.LOG.debug("{} - editItensContrato(empresa={})...", (Object)usuario.getLogin(), (Object)empresa);
        Empresa emp = this.coreService.getEmpresaBySigla(empresa);
        Integer idEmpresa = emp.getId();
        this.estruturaContratoService.deleteEstruturaContrato(idEmpresa, Integer.valueOf(idEstruturaContrato));
    }

    @GetMapping(value={"/{empresa}/{idEstruturaContrato}"})
    @Operation(summary="Consulta o item de contrato de acordo com o identificador informado.", description="Consulta o item de contrato de acordo com o identificador informado.")
    @ApiResponses(value={@ApiResponse(description="Item de Contrato consultado com sucesso", responseCode="200")})
    @ResponseBody
    @NotNull
    public EstruturaContrato getItensContrato(@Parameter(hidden=true) @NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa, @Parameter(description="Identificador do Item de Contrato") @PathVariable(name="idEstruturaContrato") int idEstruturaContrato) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.LOG.debug("{} - editItensContrato(empresa={})...", (Object)usuario.getLogin(), (Object)empresa);
        Empresa emp = this.coreService.getEmpresaBySigla(empresa);
        Integer idEmpresa = emp.getId();
        EstruturaContrato estruturaContrato = this.estruturaContratoService.getEstruturaContratoById(idEmpresa, Integer.valueOf(idEstruturaContrato));
        Intrinsics.checkNotNullExpressionValue((Object)estruturaContrato, (String)"getEstruturaContratoById(...)");
        return estruturaContrato;
    }

    @GetMapping(value={"/{empresa}/escopos"})
    @Operation(summary="Retorna os dados de escopos do contrato, de acordo com o(s) item(ns) contratual(is)", description="Consulta os escopos de contrato para a empresa especificada. As refer\u00eancias circulares s\u00e3o removidas (item.itemPrincipal \u00e9 definido como null).")
    @ApiResponses(value={@ApiResponse(description="Opera\u00e7\u00e3o realizada com sucesso", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<List<EstruturaContratoEscopo>> findEscopoContrato(@Parameter(hidden=true) @NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.LOG.debug("{} - findEscopoContrato(empresa = {})...", (Object)usuario.getLogin(), (Object)empresa);
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            List empresasInt = new ArrayList();
            Integer n = emp.getId();
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
            empresasInt.add(n);
            List itensPer = new ArrayList();
            List escopos = this.cadastroService.findEscoposByItensContrato(emp.getId(), itensPer);
            for (EstruturaContratoEscopo esco : escopos) {
                if (esco.getItem() == null) continue;
                esco.getItem().setItemPrincipal(null);
            }
            return new ResponseEntity((Object)escopos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOG.error("BizExc.findEscopoContrato", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.LOG.error("Exception.findEscopoContrato", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/parametros"})
    @Operation(summary="Retorna os par\u00e2metros de desempenho do contrato, de acordo com o(s) item(ns) contratual(is)", description="Consulta os par\u00e2metros de desempenho para a empresa especificada. As refer\u00eancias circulares s\u00e3o removidas (item.itemPrincipal \u00e9 definido como null).")
    @ApiResponses(value={@ApiResponse(description="Opera\u00e7\u00e3o realizada com sucesso", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<List<ParametroDesempenho>> findParametrosDesempenho(@Parameter(hidden=true) @NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.LOG.debug("{} - findParametrosDesempenho(empresa = {})...", (Object)usuario.getLogin(), (Object)empresa);
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            List empresasInt = new ArrayList();
            Integer n = emp.getId();
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
            empresasInt.add(n);
            List itensContrato = new ArrayList();
            List parametros = this.cadastroService.findParametrosDesempenhoByItensContrato(emp.getId(), itensContrato);
            for (ParametroDesempenho parm : parametros) {
                if (parm.getItem() == null) continue;
                parm.getItem().setItemPrincipal(null);
            }
            return new ResponseEntity((Object)parametros, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOG.error("BizExc.findParametrosDesempenho", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.LOG.error("Exception.findParametrosDesempenho", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/parametrosItens"})
    @Operation(summary="Retorna os itens dos par\u00e2metros de desempenho do contrato, de acordo com o(s) item(ns) contratual(is)", description="Consulta os itens de par\u00e2metros de desempenho para a empresa especificada. As refer\u00eancias circulares s\u00e3o removidas (item.parametro \u00e9 definido como null).")
    @ApiResponses(value={@ApiResponse(description="Opera\u00e7\u00e3o realizada com sucesso", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<List<ParametroDesempenhoItem>> findParametroDesempenhoItens(@Parameter(hidden=true) @NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.LOG.debug("{} - findParametrosDesempenho(empresa = {})...", (Object)usuario.getLogin(), (Object)empresa);
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            List itensContrato = new ArrayList();
            List parametrosItems = this.cadastroService.findParametroDesempenhoItemsbyItensContrato(emp.getId(), itensContrato);
            for (ParametroDesempenhoItem item : parametrosItems) {
                item.setParametro(null);
            }
            return new ResponseEntity((Object)parametrosItems, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOG.error("BizExc.findParametrosDesempenhoItem", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.LOG.error("Exception.findParametrosDesempenhoItem", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }
}

