/*
 * Decompiled with CFR 0.152.
 */
package br.com.sigescantt.apis;

import br.com.sigescantt.apis.BaseRestService;
import br.com.sigescantt.core.beans.seguranca.GrupoAcessoUsuario;
import br.com.sigescantt.core.beans.seguranca.PublicUser;
import br.com.sigescantt.exceptions.BusinessException;
import br.com.sigescantt.services.SegurancaService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(name="gruposAcesso", description="REST Services para Grupos de Acesso dos Usu\u00e1rios")
@RequestMapping(value={"/api/gruposAcesso"})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t2\b\b\u0001\u0010\f\u001a\u00020\rH\u0017J)\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\t2\n\b\u0001\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\b\u0001\u0010\f\u001a\u00020\rH\u0017\u00a2\u0006\u0002\u0010\u0011J$\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\t2\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\u000b2\b\b\u0001\u0010\f\u001a\u00020\rH\u0017J)\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\t2\n\b\u0001\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\b\u0001\u0010\f\u001a\u00020\rH\u0017\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lbr/com/sigescantt/apis/GruposUsuariosRestServices;", "Lbr/com/sigescantt/apis/BaseRestService;", "segurancaService", "Lbr/com/sigescantt/services/SegurancaService;", "<init>", "(Lbr/com/sigescantt/services/SegurancaService;)V", "logger", "Lorg/slf4j/Logger;", "findGruposAcesso", "Lorg/springframework/http/ResponseEntity;", "", "Lbr/com/sigescantt/core/beans/seguranca/GrupoAcessoUsuario;", "request", "Ljakarta/servlet/http/HttpServletRequest;", "getGrupoAcessoById", "idGrupo", "", "(Ljava/lang/Integer;Ljakarta/servlet/http/HttpServletRequest;)Lorg/springframework/http/ResponseEntity;", "saveGrupoAcesso", "grupo", "deleteGrupoAcesso", "", "server"})
public class GruposUsuariosRestServices
extends BaseRestService {
    @NotNull
    private final SegurancaService segurancaService;
    @NotNull
    private final Logger logger;

    public GruposUsuariosRestServices(@NotNull SegurancaService segurancaService) {
        Intrinsics.checkNotNullParameter((Object)segurancaService, (String)"segurancaService");
        super(segurancaService);
        this.segurancaService = segurancaService;
        Logger logger = LoggerFactory.getLogger(GruposUsuariosRestServices.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    @GetMapping
    @Operation(summary="Lista os grupos de acesso", description="Recupera a lista de grupos de acesso para o usu\u00e1rio autenticado. Permite filtrar por termo de busca e m\u00f3dulo.")
    @ApiResponses(value={@ApiResponse(description="Opera\u00e7\u00e3o realizada com sucesso", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<List<GrupoAcessoUsuario>> findGruposAcesso(@Parameter(hidden=true) @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        this.logger.debug("Executando SegurancasRestServices GET gruposUsuario...");
        try {
            String search = null;
            String modulo = null;
            if (request.getParameter("search") != null) {
                search = request.getParameter("search");
            }
            if (request.getParameter("modulo") != null) {
                search = request.getParameter("modulo");
            }
            List list = this.segurancaService.findGruposAcessoUsuarios(search, modulo);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findGruposAcessoUsuarios(...)");
            List result = list;
            for (GrupoAcessoUsuario grp : result) {
                grp.setDatHorCadastro(null);
                grp.setIdUsuarioIns(null);
            }
            return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.getGruposUsuario", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.logger.error("Exc.getGruposUsuario", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{idGrupo}"})
    @Operation(summary="Obt\u00e9m um grupo de acesso espec\u00edfico", description="Recupera o grupo de acesso com base no identificador fornecido.")
    @ApiResponses(value={@ApiResponse(description="Opera\u00e7\u00e3o realizada com sucesso", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<GrupoAcessoUsuario> getGrupoAcessoById(@Parameter(description="Identificador do grupo de acesso") @PathVariable(name="idGrupo") @Nullable Integer idGrupo, @Parameter(hidden=true) @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        this.logger.debug("Executando SegurancasRestServices GET grupoUsuario...");
        try {
            GrupoAcessoUsuario grupoAcessoUsuario = this.segurancaService.getGrupoAcessoUsuarioById(idGrupo);
            Intrinsics.checkNotNullExpressionValue((Object)grupoAcessoUsuario, (String)"getGrupoAcessoUsuarioById(...)");
            GrupoAcessoUsuario result = grupoAcessoUsuario;
            result.setDatHorCadastro(null);
            result.setIdUsuarioIns(null);
            return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.getGrupoAcessoById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.logger.error("Exc.getGrupoAcessoById", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping
    @Operation(summary="Salva os grupos de acesso a partir de seu payload", description="Salva ou atualiza um grupo de acesso com os dados fornecidos no payload.")
    @ApiResponses(value={@ApiResponse(description="Grupo de acesso criado com sucesso", responseCode="201")})
    @NotNull
    public ResponseEntity<GrupoAcessoUsuario> saveGrupoAcesso(@io.swagger.v3.oas.annotations.parameters.RequestBody(description="Payload contendo os dados do grupo de acesso a ser salvo", required=true) @RequestBody @Nullable GrupoAcessoUsuario grupo, @Parameter(hidden=true) @NotNull HttpServletRequest request) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            this.logger.debug("saveGrupoAcesso({})", (Object)grupo);
            return new ResponseEntity((Object)this.segurancaService.saveGrupoAcessoUsuario(grupo, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveGrupoAcesso", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{idGrupo}"})
    @Operation(summary="Deleta o grupo de acesso de acordo com seu ID", description="Exclui um grupo de acesso com base no identificador.")
    @ApiResponses(value={@ApiResponse(description="Grupo de acesso exclu\u00eddo com sucesso", responseCode="200")})
    @NotNull
    public ResponseEntity<Boolean> deleteGrupoAcesso(@Parameter(description="Identificador do grupo de acesso a ser exclu\u00eddo") @PathVariable(name="idGrupo") @Nullable Integer idGrupo, @Parameter(hidden=true) @NotNull HttpServletRequest request) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            this.logger.debug("deleteGrupoAcesso({})", (Object)idGrupo);
            this.segurancaService.deleteGrupoAcessoUsuario(idGrupo);
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.deleteGrupoAcesso", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

