/*
 * Decompiled with CFR 0.152.
 */
package br.com.sigescantt.apis;

import br.com.sigescantt.apis.BaseRestService;
import br.com.sigescantt.core.beans.seguranca.PublicUser;
import br.com.sigescantt.core.dto.licencas.EntidadeRequestDTO;
import br.com.sigescantt.core.dto.licencas.EntidadeResponsaveisDTO;
import br.com.sigescantt.core.dto.licencas.SetorEntidadeRequestDTO;
import br.com.sigescantt.core.dto.licencas.SetorEntidadeResponsavelRequestDTO;
import br.com.sigescantt.exceptions.BusinessException;
import br.com.sigescantt.geral.Entidade;
import br.com.sigescantt.geral.EntidadeEmpresa;
import br.com.sigescantt.geral.SetorEntidade;
import br.com.sigescantt.geral.SetorEntidadeResponsavel;
import br.com.sigescantt.services.CadastroService;
import br.com.sigescantt.services.CoreService;
import br.com.sigescantt.services.SegurancaService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(name="entidades", description="REST Services para entidades")
@Validated
@RequestMapping(value={"/api/v1/entidades", "/api/entidades"})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001e\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\r2\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0017J2\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00130\r2\n\b\u0001\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\b\u0001\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J)\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\r2\n\b\u0001\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0017\u00a2\u0006\u0002\u0010\u001bJ<\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u00130\r2\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\n\b\u0001\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\b\u0001\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J\"\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000f0\r2\b\b\u0001\u0010\u001f\u001a\u00020\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0017J,\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000f0\r2\b\b\u0001\u0010!\u001a\u00020\"2\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0017J5\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\r2\n\b\u0001\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\n\b\u0001\u0010%\u001a\u0004\u0018\u00010\u001a2\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0017\u00a2\u0006\u0002\u0010&JF\u0010'\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0\u00130\r2\b\b\u0001\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010)\u001a\u00020\u001a2\n\b\u0001\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J6\u0010*\u001a\b\u0012\u0004\u0012\u00020(0\r2\b\b\u0001\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010)\u001a\u00020\u001a2\b\b\u0001\u0010+\u001a\u00020\u001aH\u0017J6\u0010,\u001a\b\u0012\u0004\u0012\u00020(0\r2\b\b\u0001\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010)\u001a\u00020\u001a2\b\b\u0001\u0010!\u001a\u00020-H\u0017J@\u0010.\u001a\b\u0012\u0004\u0012\u00020(0\r2\b\b\u0001\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010)\u001a\u00020\u001a2\b\b\u0001\u0010+\u001a\u00020\u001a2\b\b\u0001\u0010!\u001a\u00020-H\u0017J0\u0010/\u001a\u0002002\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010)\u001a\u00020\u001a2\b\b\u0001\u0010+\u001a\u00020\u001a2\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0017J<\u00101\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002020\u00130\r2\b\b\u0001\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\n\b\u0001\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J,\u00103\u001a\b\u0012\u0004\u0012\u0002020\r2\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010!\u001a\u0002042\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0017J6\u00105\u001a\b\u0012\u0004\u0012\u0002020\r2\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010)\u001a\u00020\u001a2\b\b\u0001\u0010!\u001a\u0002042\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0017J,\u00106\u001a\b\u0012\u0004\u0012\u0002020\r2\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010)\u001a\u00020\u001a2\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0017J,\u00107\u001a\b\u0012\u0004\u0012\u00020$0\r2\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010)\u001a\u00020\u001a2\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0017J/\u00108\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002090\u000e0\r2\n\b\u0001\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0017\u00a2\u0006\u0002\u0010\u001bJ5\u0010:\u001a\b\u0012\u0004\u0012\u0002090\r2\n\b\u0001\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\n\b\u0001\u0010;\u001a\u0004\u0018\u00010\u001a2\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0017\u00a2\u0006\u0002\u0010&J0\u0010<\u001a\b\u0012\u0004\u0012\u0002090\r2\n\b\u0001\u0010=\u001a\u0004\u0018\u00010\u00152\n\b\u0001\u0010>\u001a\u0004\u0018\u0001092\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0017J5\u0010?\u001a\b\u0012\u0004\u0012\u00020@0\r2\n\b\u0001\u0010=\u001a\u0004\u0018\u00010\u00152\n\b\u0001\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0017\u00a2\u0006\u0002\u0010AR\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lbr/com/sigescantt/apis/EntidadesRestServices;", "Lbr/com/sigescantt/apis/BaseRestService;", "segurancaService", "Lbr/com/sigescantt/services/SegurancaService;", "coreService", "Lbr/com/sigescantt/services/CoreService;", "cadastroService", "Lbr/com/sigescantt/services/CadastroService;", "<init>", "(Lbr/com/sigescantt/services/SegurancaService;Lbr/com/sigescantt/services/CoreService;Lbr/com/sigescantt/services/CadastroService;)V", "logger", "Lorg/slf4j/Logger;", "findAllEntidades", "Lorg/springframework/http/ResponseEntity;", "", "Lbr/com/sigescantt/geral/Entidade;", "request", "Ljakarta/servlet/http/HttpServletRequest;", "findAllEntidadesPaginated", "Lorg/springframework/data/domain/Page;", "search", "", "pageable", "Lorg/springframework/data/domain/Pageable;", "getEntidadeById", "idEntidade", "", "(Ljava/lang/Integer;Ljakarta/servlet/http/HttpServletRequest;)Lorg/springframework/http/ResponseEntity;", "getEntidadeAndResponsaveisById", "Lbr/com/sigescantt/core/dto/licencas/EntidadeResponsaveisDTO;", "saveEntidade", "entidade", "editEntidade", "dto", "Lbr/com/sigescantt/core/dto/licencas/EntidadeRequestDTO;", "deleteEntidade", "", "idSubstituta", "(Ljava/lang/Integer;Ljava/lang/Integer;Ljakarta/servlet/http/HttpServletRequest;)Lorg/springframework/http/ResponseEntity;", "findSetoresResponsaveisEntidade", "Lbr/com/sigescantt/geral/SetorEntidadeResponsavel;", "idSetor", "getResponsavelEntidade", "sequencia", "saveResponsavelEntidade", "Lbr/com/sigescantt/core/dto/licencas/SetorEntidadeResponsavelRequestDTO;", "editResponsavelEntidade", "deleteResponsavelEntidade", "", "findSetoresEntidades", "Lbr/com/sigescantt/geral/SetorEntidade;", "saveSetorEntidade", "Lbr/com/sigescantt/core/dto/licencas/SetorEntidadeRequestDTO;", "editSetorEntidade", "getSetorEntidade", "deleteSetorEntidade", "findEntidadesEmpresa", "Lbr/com/sigescantt/geral/EntidadeEmpresa;", "getEmpresaEntidadeById", "idEmpresa", "saveEntidadeEmpresa", "empresa", "entidadeEmpresa", "deleteEntidadeEmpresa", "Ljava/lang/Void;", "(Ljava/lang/String;Ljava/lang/Integer;Ljakarta/servlet/http/HttpServletRequest;)Lorg/springframework/http/ResponseEntity;", "server"})
public class EntidadesRestServices
extends BaseRestService {
    @NotNull
    private final SegurancaService segurancaService;
    @NotNull
    private final CoreService coreService;
    @NotNull
    private final CadastroService cadastroService;
    @NotNull
    private final Logger logger;

    public EntidadesRestServices(@NotNull SegurancaService segurancaService, @NotNull CoreService coreService, @NotNull CadastroService cadastroService) {
        Intrinsics.checkNotNullParameter((Object)segurancaService, (String)"segurancaService");
        Intrinsics.checkNotNullParameter((Object)coreService, (String)"coreService");
        Intrinsics.checkNotNullParameter((Object)cadastroService, (String)"cadastroService");
        super(segurancaService);
        this.segurancaService = segurancaService;
        this.coreService = coreService;
        this.cadastroService = cadastroService;
        Logger logger = LoggerFactory.getLogger(EntidadesRestServices.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    @GetMapping(value={"/all"})
    @Operation(summary="Retorna todas as entidades", description="Retorna todas as entidades cadastradas no sistema.")
    @ApiResponses(value={@ApiResponse(description="Entidades recuperadas com sucesso", responseCode="200")})
    @NotNull
    public ResponseEntity<List<Entidade>> findAllEntidades(@Parameter(hidden=true) @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.logger.debug("{} - Iniciando findEntidades...", (Object)usuario.getLogin());
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ENTIDADES");
            if (!permissao.booleanValue()) {
                this.logger.error("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ENTIDADES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            List entidades = this.cadastroService.findAllEntidades();
            return new ResponseEntity((Object)entidades, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.findEntidades", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping
    @Operation(summary="Retorna as entidades paginadas", description="Retorna as entidades cadastradas no sistema de maneira paginada.")
    @ApiResponses(value={@ApiResponse(description="Entidades recuperadas com sucesso", responseCode="200")})
    @NotNull
    public ResponseEntity<Page<Entidade>> findAllEntidadesPaginated(@RequestParam(value="search", required=false) @Nullable String search, @Parameter(hidden=true) @NotNull HttpServletRequest request, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.logger.debug("{} - Iniciando findEntidades...", (Object)usuario.getLogin());
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ENTIDADES");
            if (!permissao.booleanValue()) {
                this.logger.error("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ENTIDADES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            Page entidades = this.cadastroService.findAllEntidadesPaginated(search, pageable);
            return new ResponseEntity((Object)entidades, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.findEntidades", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{idEntidade}"})
    @Operation(summary="Carrega a entidade pelo seu identificador", description="Carrega a entidade baseada no identificador fornecido.")
    @ApiResponses(value={@ApiResponse(description="Entidade recuperada com sucesso", responseCode="200")})
    @NotNull
    public ResponseEntity<Entidade> getEntidadeById(@Parameter(description="Identificador da entidade") @PathVariable(name="idEntidade") @Nullable Integer idEntidade, @Parameter(hidden=true) @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.logger.debug("{} - getEntidadeById({})", (Object)usuario.getLogin(), (Object)idEntidade);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ENTIDADES");
            if (!permissao.booleanValue()) {
                this.logger.error("Erro permiss\u00e3o, getEntidade ({}, {})", (Object)usuario.getLogin(), (Object)"ENTIDADES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.cadastroService.getEntidadeById(idEntidade), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.getEntidadeById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{idEntidade}/responsaveis"})
    @Operation(summary="Carrega a entidade pelo seu identificador juntamente com os respons\u00e1veis.", description="Carrega a entidade pelo seu identificador juntamente com os respons\u00e1veis.")
    @ApiResponses(value={@ApiResponse(description="Entidade recuperada com sucesso", responseCode="200")})
    @NotNull
    public ResponseEntity<Page<EntidadeResponsaveisDTO>> getEntidadeAndResponsaveisById(@Parameter(description="Identificador da entidade") @PathVariable(name="idEntidade") int idEntidade, @RequestParam(value="search", required=false) @Nullable String search, @Parameter(hidden=true) @NotNull HttpServletRequest request, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.logger.debug("{} - getEntidadeAndResponsaveisById({})", (Object)usuario.getLogin(), (Object)idEntidade);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ENTIDADES");
            if (!permissao.booleanValue()) {
                this.logger.error("Erro permiss\u00e3o, getEntidade ({}, {})", (Object)usuario.getLogin(), (Object)"ENTIDADES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.cadastroService.getEntidadeResponsaveisById(Integer.valueOf(idEntidade), search, pageable), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.getEntidadeById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping
    @Operation(summary="Salva a entidade a partir dos dados informados", description="Salva a entidade a partir dos dados informados.")
    @ApiResponses(value={@ApiResponse(description="Entidade criada com sucesso", responseCode="201")})
    @NotNull
    public ResponseEntity<Entidade> saveEntidade(@org.springframework.web.bind.annotation.RequestBody @NotNull Entidade entidade, @Parameter(hidden=true) @NotNull HttpServletRequest request) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)entidade, (String)"entidade");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.logger.debug("{} - saveEntidade({})", (Object)usuario.getLogin(), (Object)entidade);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ENTIDADES");
            if (!permissao.booleanValue()) {
                this.logger.error("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ENTIDADES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.cadastroService.saveEntidade(entidade, usuario.getLogin()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveEntidade", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PutMapping(value={"/{idEntidade}"})
    @Operation(summary="Salva a entidade a partir dos dados informados", description="Salva a entidade a partir dos dados informados.")
    @ApiResponses(value={@ApiResponse(description="Entidade criada com sucesso", responseCode="201")})
    @NotNull
    public ResponseEntity<Entidade> editEntidade(@RequestBody(description="Payload contendo os dados da entidade a ser editada") @org.springframework.web.bind.annotation.RequestBody @NotNull EntidadeRequestDTO dto, @PathVariable(value="idEntidade") int idEntidade, @Parameter(hidden=true) @NotNull HttpServletRequest request) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.logger.debug("{} - saveEntidade({})", (Object)usuario.getLogin(), (Object)dto);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ENTIDADES");
            if (!permissao.booleanValue()) {
                this.logger.error("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ENTIDADES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.cadastroService.editEntidade(dto, Integer.valueOf(idEntidade), usuario.getId()), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveEntidade", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{idEntidade}"})
    @Operation(summary="Exclui a entidade a partir do identificador fornecido", description="Exclui a entidade com base no identificador fornecido.")
    @ApiResponses(value={@ApiResponse(description="Entidade exclu\u00edda com sucesso", responseCode="200")})
    @NotNull
    public ResponseEntity<Boolean> deleteEntidade(@Parameter(description="Identificador da entidade") @PathVariable(name="idEntidade") @Nullable Integer idEntidade, @RequestParam(name="idSubstituta", required=false) @Nullable Integer idSubstituta, @Parameter(hidden=true) @NotNull HttpServletRequest request) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.logger.debug("{} - deleteEntidade({})", (Object)usuario.getLogin(), (Object)idEntidade);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ENTIDADES");
            if (!permissao.booleanValue()) {
                this.logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"ENTIDADES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.cadastroService.deleteEntidade(idEntidade, idSubstituta), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.deleteEntidade", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{idEntidade}/setores/{idSetor}/responsaveis"})
    @ResponseBody
    @Operation(summary="Retorna os respons\u00e1veis dos setores da entidade", description="Retorna os respons\u00e1veis dos setores da entidade informada")
    @ApiResponses(value={@ApiResponse(description="Respons\u00e1veis recuperados com sucesso", responseCode="200")})
    @NotNull
    public ResponseEntity<Page<SetorEntidadeResponsavel>> findSetoresResponsaveisEntidade(@Parameter(hidden=true) @NotNull HttpServletRequest request, @Parameter(description="Identificador da entidade") @PathVariable(value="idEntidade") int idEntidade, @Parameter(description="Identificador do setor") @PathVariable(value="idSetor") int idSetor, @RequestParam(value="search", required=false) @Nullable String search, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.logger.debug("{} - Iniciando findSetoresResponsaveis...", (Object)usuario.getLogin());
            return new ResponseEntity((Object)this.cadastroService.findResponsaveisSetor(Integer.valueOf(idEntidade), Integer.valueOf(idSetor), search, pageable), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.findSetoresResponsaveis", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{idEntidade}/setores/{idSetor}/responsaveis/{sequencia}"})
    @Operation(summary="Consulta o respons\u00e1vel para o setor da entidade", description="Consulta um respons\u00e1vel para um setor da entidade.")
    @ApiResponses(value={@ApiResponse(description="Respons\u00e1vel consultado com sucesso", responseCode="200")})
    @NotNull
    public ResponseEntity<SetorEntidadeResponsavel> getResponsavelEntidade(@Parameter(hidden=true) @NotNull HttpServletRequest request, @PathVariable(value="idEntidade") int idEntidade, @PathVariable(value="idSetor") int idSetor, @PathVariable(value="sequencia") int sequencia) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            this.logger.debug("{} - getResponsavelEntidade({})", (Object)usuario.getLogin());
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ENTIDADES");
            if (!permissao.booleanValue()) {
                this.logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"ENTIDADES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.cadastroService.getResponsavel(Integer.valueOf(idEntidade), Integer.valueOf(idSetor), Integer.valueOf(sequencia)), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveResponsavelEntidade", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{idEntidade}/setores/{idSetor}/responsaveis"})
    @Operation(summary="Salva o respons\u00e1vel para o setor da entidade", description="Salva um respons\u00e1vel para um setor da entidade.")
    @ApiResponses(value={@ApiResponse(description="Respons\u00e1vel criado com sucesso", responseCode="201")})
    @NotNull
    public ResponseEntity<SetorEntidadeResponsavel> saveResponsavelEntidade(@Parameter(hidden=true) @NotNull HttpServletRequest request, @PathVariable(value="idEntidade") int idEntidade, @PathVariable(value="idSetor") int idSetor, @Parameter(description="Payload contendo os dados do respons\u00e1vel para o setor da entidade") @Valid @org.springframework.web.bind.annotation.RequestBody @NotNull SetorEntidadeResponsavelRequestDTO dto) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            this.logger.debug("{} - saveEntidade({})", (Object)usuario.getLogin(), (Object)dto);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ENTIDADES");
            if (!permissao.booleanValue()) {
                this.logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"ENTIDADES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.cadastroService.saveResponsavel(dto, Integer.valueOf(idEntidade), Integer.valueOf(idSetor), usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveResponsavelEntidade", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PutMapping(value={"/{idEntidade}/setores/{idSetor}/responsaveis/{sequencia}"})
    @Operation(summary="Edita o respons\u00e1vel para o setor da entidade", description="Edita um respons\u00e1vel para um setor da entidade.")
    @ApiResponses(value={@ApiResponse(description="Respons\u00e1vel editado com sucesso", responseCode="200")})
    @NotNull
    public ResponseEntity<SetorEntidadeResponsavel> editResponsavelEntidade(@Parameter(hidden=true) @NotNull HttpServletRequest request, @PathVariable(value="idEntidade") int idEntidade, @PathVariable(value="idSetor") int idSetor, @PathVariable(value="sequencia") int sequencia, @Parameter(description="Payload contendo os dados do respons\u00e1vel para o setor da entidade") @Valid @org.springframework.web.bind.annotation.RequestBody @NotNull SetorEntidadeResponsavelRequestDTO dto) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            this.logger.debug("{} - saveEntidade({})", (Object)usuario.getLogin(), (Object)dto);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ENTIDADES");
            if (!permissao.booleanValue()) {
                this.logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"ENTIDADES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.cadastroService.editResponsavel(dto, Integer.valueOf(idEntidade), Integer.valueOf(idSetor), Integer.valueOf(sequencia), usr.getId()), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveResponsavelEntidade", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{idEntidade}/setores/{idSetor}/responsaveis/{sequencia}"})
    @Operation(summary="Exclui o respons\u00e1vel do setor da entidade", description="Exclui o respons\u00e1vel do setor da entidade com base nos identificadores informados.")
    @ApiResponses(value={@ApiResponse(description="Respons\u00e1vel exclu\u00eddo com sucesso", responseCode="200")})
    public void deleteResponsavelEntidade(@PathVariable(value="idEntidade") int idEntidade, @PathVariable(value="idSetor") int idSetor, @PathVariable(value="sequencia") int sequencia, @Parameter(hidden=true) @NotNull HttpServletRequest request) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.logger.debug("{} - deleteResponsavelEntidade({})", (Object)usuario.getLogin(), (Object)idSetor);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ENTIDADES");
            if (!permissao.booleanValue()) {
                this.logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"ENTIDADES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            this.cadastroService.deleteResponsavel(Integer.valueOf(idEntidade), Integer.valueOf(idSetor), Integer.valueOf(sequencia));
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.deleteResponsavelEntidade", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{idEntidade}/setores"})
    @ResponseBody
    @Operation(summary="Retorna todos os setores", description="Retorna todos os setores, independentemente da entidade associada.")
    @ApiResponses(value={@ApiResponse(description="Setores recuperados com sucesso", responseCode="200")})
    @NotNull
    public ResponseEntity<Page<SetorEntidade>> findSetoresEntidades(@Parameter(hidden=true) @NotNull HttpServletRequest request, @PathVariable(value="idEntidade") int idEntidade, @RequestParam(value="search", required=false) @Nullable String search, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.logger.debug("{} - findSetoresEntidades...", (Object)usuario.getLogin());
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ENTIDADES");
            if (!permissao.booleanValue()) {
                this.logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"ENTIDADES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.cadastroService.findSetoresEntidades(Integer.valueOf(idEntidade), search, pageable), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.findSetoresEntidade", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{idEntidade}/setores"})
    @Operation(summary="Salva um novo setor para a entidade", description="Salva um novo setor para a entidade.")
    @ApiResponses(value={@ApiResponse(description="Setor criado com sucesso", responseCode="201")})
    @NotNull
    public ResponseEntity<SetorEntidade> saveSetorEntidade(@PathVariable(value="idEntidade") int idEntidade, @Parameter(description="Payload contendo os dados do setor a ser salvo") @Valid @org.springframework.web.bind.annotation.RequestBody @NotNull SetorEntidadeRequestDTO dto, @Parameter(hidden=true) @NotNull HttpServletRequest request) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            this.logger.debug("{} - saveSetorEntidade({})", (Object)usuario.getLogin(), (Object)dto);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ENTIDADES");
            if (!permissao.booleanValue()) {
                this.logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"ENTIDADES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.cadastroService.saveSetor(dto, Integer.valueOf(idEntidade), usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveSetorEntidade", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PutMapping(value={"/{idEntidade}/setores/{idSetor}"})
    @Operation(summary="Edita um novo setor para a entidade", description="Edita um novo setor para a entidade.")
    @ApiResponses(value={@ApiResponse(description="Setor editado com sucesso", responseCode="200")})
    @NotNull
    public ResponseEntity<SetorEntidade> editSetorEntidade(@PathVariable(value="idEntidade") int idEntidade, @PathVariable(value="idSetor") int idSetor, @Parameter(description="Payload contendo os dados do setor a ser editado") @Valid @org.springframework.web.bind.annotation.RequestBody @NotNull SetorEntidadeRequestDTO dto, @Parameter(hidden=true) @NotNull HttpServletRequest request) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            this.logger.debug("{} - editSetorEntidade({})", (Object)usuario.getLogin(), (Object)dto);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ENTIDADES");
            if (!permissao.booleanValue()) {
                this.logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"ENTIDADES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.cadastroService.editSetor(dto, Integer.valueOf(idEntidade), Integer.valueOf(idSetor), usr.getId()), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.editSetorEntidade", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{idEntidade}/setores/{idSetor}"})
    @Operation(summary="Consulta um setor para a entidade de acordo com seu identificador", description="Consulta um setor para a entidade de acordo com seu identificador")
    @ApiResponses(value={@ApiResponse(description="Setor consultado com sucesso", responseCode="200")})
    @NotNull
    public ResponseEntity<SetorEntidade> getSetorEntidade(@PathVariable(value="idEntidade") int idEntidade, @PathVariable(value="idSetor") int idSetor, @Parameter(hidden=true) @NotNull HttpServletRequest request) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            this.logger.debug("{} - getSetorEntidade({})", (Object)usuario.getLogin());
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ENTIDADES");
            if (!permissao.booleanValue()) {
                this.logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"ENTIDADES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.cadastroService.getSetor(Integer.valueOf(idEntidade), Integer.valueOf(idSetor)), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.editSetorEntidade", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{idEntidade}/setores/{idSetor}"})
    @Operation(summary="Exclui o setor da entidade", description="Exclui o setor da entidade com base nos identificadores fornecidos.")
    @ApiResponses(value={@ApiResponse(description="Setor exclu\u00eddo com sucesso", responseCode="200")})
    @NotNull
    public ResponseEntity<Boolean> deleteSetorEntidade(@Parameter(description="Identificador da entidade") @PathVariable int idEntidade, @Parameter(description="Identificador do setor") @PathVariable int idSetor, @Parameter(hidden=true) @NotNull HttpServletRequest request) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            Object[] objectArray = new Object[]{usuario.getLogin(), idEntidade, idSetor};
            this.logger.debug("{} - deleteSetorEntidade({}, {})", objectArray);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ENTIDADES");
            if (!permissao.booleanValue()) {
                this.logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"ENTIDADES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.cadastroService.deleteSetor(Integer.valueOf(idSetor)), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.deleteSetorEntidade", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{idEntidade}/entidadesEmpresa"})
    @Operation(summary="Lista as empresas associadas \u00e0 entidade", description="Lista as empresas associadas \u00e0 entidade informada.")
    @ApiResponses(value={@ApiResponse(description="Empresas associadas recuperadas com sucesso", responseCode="200")})
    @NotNull
    public ResponseEntity<List<EntidadeEmpresa>> findEntidadesEmpresa(@Parameter(description="Identificador da entidade para consulta das empresas associadas") @PathVariable(name="idEntidade") @Nullable Integer idEntidade, @Parameter(hidden=true) @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.logger.debug("({}) - Iniciando findEntidadesEmpresa({})", (Object)usuario.getLogin());
        try {
            List rows = this.cadastroService.findEntidadesEmpresa(idEntidade);
            ResponseEntity responseEntity = ResponseEntity.ok().body((Object)rows);
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.findTiposDocumentos", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{idEntidade}/entidadesEmpresa/{idEmpresa}"})
    @Operation(summary="Carrega a rela\u00e7\u00e3o entre entidade e empresa", description="Carrega a rela\u00e7\u00e3o entre entidade e empresa com base nos identificadores fornecidos.")
    @ApiResponses(value={@ApiResponse(description="Rela\u00e7\u00e3o recuperada com sucesso", responseCode="200")})
    @NotNull
    public ResponseEntity<EntidadeEmpresa> getEmpresaEntidadeById(@Parameter(description="Identificador da entidade") @PathVariable(name="idEntidade") @Nullable Integer idEntidade, @Parameter(description="Identificador da empresa") @PathVariable(name="idEmpresa") @Nullable Integer idEmpresa, @Parameter(hidden=true) @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            Object[] objectArray = new Object[]{usuario.getLogin(), idEntidade, idEmpresa};
            this.logger.debug("{} - getEntidadeById({}, {})", objectArray);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ENTIDADES");
            if (!permissao.booleanValue()) {
                this.logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"ENTIDADES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.cadastroService.getEntidadeEmpresaById(idEntidade, idEmpresa), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.getEntidadeById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/entidadesEmpresa"})
    @Operation(summary="Salva o relacionamento entre entidade e empresa", description="Salva o relacionamento entre entidade e empresa.")
    @ApiResponses(value={@ApiResponse(description="Relacionamento criado com sucesso", responseCode="201")})
    @NotNull
    public ResponseEntity<EntidadeEmpresa> saveEntidadeEmpresa(@Parameter(description="Sigla da empresa") @PathVariable @Nullable String empresa, @RequestBody(description="Payload contendo os dados para o relacionamento entre entidade e empresa") @org.springframework.web.bind.annotation.RequestBody @Nullable EntidadeEmpresa entidadeEmpresa, @Parameter(hidden=true) @NotNull HttpServletRequest request) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.logger.debug("{} - saveEntidadeEmpresa", (Object)usuario.getLogin());
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ENTIDADES");
            if (!permissao.booleanValue()) {
                this.logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"ENTIDADES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.cadastroService.saveEntidadeEmpresa(entidadeEmpresa, usuario.getLogin()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveLocalEmpresa", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idEntidade}/entidadesEmpresa"})
    @Operation(summary="Exclui o relacionamento entre entidade e empresa", description="Exclui o relacionamento entre entidade e empresa.")
    @ApiResponses(value={@ApiResponse(description="Relacionamento exclu\u00eddo com sucesso", responseCode="204")})
    @NotNull
    public ResponseEntity<Void> deleteEntidadeEmpresa(@Parameter(description="Sigla da empresa") @PathVariable(value="empresa") @Nullable String empresa, @Parameter(description="Identificador da entidade") @PathVariable(name="idEntidade") @Nullable Integer idEntidade, @Parameter(hidden=true) @NotNull HttpServletRequest request) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            Object[] objectArray = new Object[]{usuario.getLogin(), empresa, idEntidade};
            this.logger.debug("{} - deleteEntidadeEmpresa({}, {})", objectArray);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ENTIDADES");
            if (!permissao.booleanValue()) {
                this.logger.error("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ENTIDADES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            this.cadastroService.deleteEntidadeEmpresa(idEntidade, empresa);
            return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.deleteEntidadeEmpresa", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

