/*
 * Decompiled with CFR 0.152.
 */
package br.com.sigescantt.apis;

import br.com.sigescantt.apis.BaseRestService;
import br.com.sigescantt.core.beans.geral.Empresa;
import br.com.sigescantt.core.beans.seguranca.PublicUser;
import br.com.sigescantt.core.beans.seguranca.UsuarioEmpresa;
import br.com.sigescantt.core.dto.geral.empresa.SaveEmpresaDTO;
import br.com.sigescantt.core.dto.geral.empresa.anoConcessao.SaveEmpresaAnoConcessaoDTO;
import br.com.sigescantt.exceptions.BusinessException;
import br.com.sigescantt.geral.EmpresaAnoConcessao;
import br.com.sigescantt.geral.EmpresaArea;
import br.com.sigescantt.geral.EmpresaAreaResponsavel;
import br.com.sigescantt.geral.EmpresaLocal;
import br.com.sigescantt.services.CadastroService;
import br.com.sigescantt.services.CoreService;
import br.com.sigescantt.services.Exceptions.ErrorCode;
import br.com.sigescantt.services.Exceptions.ErrorCodeException;
import br.com.sigescantt.services.SegurancaService;
import br.com.sigescantt.services.empresa.EmpresaService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(name="empresas", description="REST Services para empresas")
@RequestMapping(value={"/api/v1/empresas"})
@Validated
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001e\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000f2\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0017J\u001e\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000f2\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0017J\"\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u000f2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0016\u001a\u00020\u0017H\u0017J\"\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u000f2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0019\u001a\u00020\u001aH\u0017J(\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u00100\u000f2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0016\u001a\u00020\u0017H\u0017J(\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u00100\u000f2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0016\u001a\u00020\u0017H\u0017J,\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u000f2\b\b\u0001\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010!\u001a\u00020 2\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0017J,\u0010\"\u001a\b\u0012\u0004\u0012\u00020 0\u000f2\b\b\u0001\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010#\u001a\u00020\u001a2\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0017J(\u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u00100\u000f2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0016\u001a\u00020\u0017H\u0017J,\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u000f2\b\b\u0001\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010#\u001a\u00020\u001a2\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0017J&\u0010'\u001a\u00020\u00112\b\b\u0001\u0010(\u001a\u00020)2\n\b\u0001\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J0\u0010,\u001a\u00020\u00112\b\b\u0001\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010(\u001a\u00020)2\n\b\u0001\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J,\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001c0\u000f2\b\b\u0001\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010.\u001a\u00020\u001c2\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0017J\"\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001e0\u000f2\b\b\u0001\u00100\u001a\u00020\u001e2\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0017J8\u00101\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u00100\u000f2\b\b\u0001\u0010\u0016\u001a\u00020\u00172\u000e\b\u0001\u00100\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00102\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0017J\"\u00102\u001a\b\u0012\u0004\u0012\u00020&0\u000f2\b\b\u0001\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0017J,\u00103\u001a\b\u0012\u0004\u0012\u00020&0\u000f2\b\b\u0001\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u00104\u001a\u00020\u001a2\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0017J,\u00105\u001a\b\u0012\u0004\u0012\u00020&0\u000f2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u00106\u001a\u00020\u001aH\u0017JB\u00107\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u000209080\u000f2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0016\u001a\u00020\u00172\u000e\b\u0001\u00104\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00102\b\b\u0001\u0010:\u001a\u00020;H\u0017J2\u0010<\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000f2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010=\u001a\u00020\u001aH\u0017J,\u0010>\u001a\b\u0012\u0004\u0012\u00020\u001c0\u000f2\b\b\u0001\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u00104\u001a\u00020\u001a2\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0017J,\u0010?\u001a\b\u0012\u0004\u0012\u00020\u001e0\u000f2\b\b\u0001\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u00106\u001a\u00020\u001a2\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0017J\"\u0010@\u001a\b\u0012\u0004\u0012\u00020A082\b\b\u0001\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010:\u001a\u00020;H\u0017J$\u0010B\u001a\u00020A2\b\b\u0001\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010(\u001a\u00020C2\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J.\u0010D\u001a\u00020A2\b\b\u0001\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010E\u001a\u00020\u001a2\b\b\u0001\u0010(\u001a\u00020C2\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J$\u0010F\u001a\u00020G2\b\b\u0001\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010E\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u0013H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lbr/com/sigescantt/apis/EmpresasRestServices;", "Lbr/com/sigescantt/apis/BaseRestService;", "segurancaService", "Lbr/com/sigescantt/services/SegurancaService;", "coreService", "Lbr/com/sigescantt/services/CoreService;", "cadastroService", "Lbr/com/sigescantt/services/CadastroService;", "empresaService", "Lbr/com/sigescantt/services/empresa/EmpresaService;", "<init>", "(Lbr/com/sigescantt/services/SegurancaService;Lbr/com/sigescantt/services/CoreService;Lbr/com/sigescantt/services/CadastroService;Lbr/com/sigescantt/services/empresa/EmpresaService;)V", "logger", "Lorg/slf4j/Logger;", "findEmpresasUsuario", "Lorg/springframework/http/ResponseEntity;", "", "Lbr/com/sigescantt/core/beans/geral/Empresa;", "request", "Ljakarta/servlet/http/HttpServletRequest;", "findTodasEmpresas", "getEmpresa", "empresa", "", "findEmpresaById", "idEmpresa", "", "findAreasEmpresa", "Lbr/com/sigescantt/geral/EmpresaArea;", "findUsuariosEmpresa", "Lbr/com/sigescantt/core/beans/seguranca/UsuarioEmpresa;", "saveLocalEmpresa", "Lbr/com/sigescantt/geral/EmpresaLocal;", "empresaLocal", "getEmpresaLocalById", "idLocal", "findLocaisEmpresa", "deleteEmpresaLocal", "", "createEmpresa", "dto", "Lbr/com/sigescantt/core/dto/geral/empresa/SaveEmpresaDTO;", "logoImage", "Lorg/springframework/web/multipart/MultipartFile;", "updateEmpresa", "saveAreaEmpresa", "empresaArea", "saveUsuarioEmpresa", "usuarioEmpresa", "saveUsuariosEmpresa", "deleteEmpresa", "deleteAreaEmpresa", "idArea", "deleteUsuarioEmpresa", "idUsuario", "findResponsaveisArea", "Lorg/springframework/data/domain/Page;", "Lbr/com/sigescantt/geral/EmpresaAreaResponsavel;", "pageable", "Lorg/springframework/data/domain/Pageable;", "findFiliais", "idHolding", "getEmpresaAreaById", "getUsuarioEmpresaById", "getAnosConcessaoByEmpresa", "Lbr/com/sigescantt/geral/EmpresaAnoConcessao;", "saveAnoConcessaoEmpresa", "Lbr/com/sigescantt/core/dto/geral/empresa/anoConcessao/SaveEmpresaAnoConcessaoDTO;", "updateAnoConcessaoEmpresa", "seqAnoConcessao", "deleteAnoConcessaoEmpresa", "", "server"})
public class EmpresasRestServices
extends BaseRestService {
    @NotNull
    private final SegurancaService segurancaService;
    @NotNull
    private final CoreService coreService;
    @NotNull
    private final CadastroService cadastroService;
    @NotNull
    private final EmpresaService empresaService;
    @NotNull
    private final Logger logger;

    public EmpresasRestServices(@NotNull SegurancaService segurancaService, @NotNull CoreService coreService, @NotNull CadastroService cadastroService, @NotNull EmpresaService empresaService) {
        Intrinsics.checkNotNullParameter((Object)segurancaService, (String)"segurancaService");
        Intrinsics.checkNotNullParameter((Object)coreService, (String)"coreService");
        Intrinsics.checkNotNullParameter((Object)cadastroService, (String)"cadastroService");
        Intrinsics.checkNotNullParameter((Object)empresaService, (String)"empresaService");
        super(segurancaService);
        this.segurancaService = segurancaService;
        this.coreService = coreService;
        this.cadastroService = cadastroService;
        this.empresaService = empresaService;
        Logger logger = LoggerFactory.getLogger(EmpresasRestServices.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    @GetMapping
    @Operation(summary="Lista as empresas associadas ao usu\u00e1rio token. Retorna a lista de empresas vinculadas ao usu\u00e1rio autenticado.")
    @ApiResponses(value={@ApiResponse(description="Empresas listadas com sucesso.", responseCode="200")})
    @NotNull
    public ResponseEntity<List<Empresa>> findEmpresasUsuario(@Parameter(hidden=true) @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        this.logger.debug("[{}] - findEmpresasUsuario()...", (Object)usuario.getLogin());
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            List empresasUsr = this.segurancaService.findEmpresasByUsuario(usr.getId());
            ArrayList<Empresa> empresas = new ArrayList<Empresa>();
            if (empresasUsr != null) {
                for (UsuarioEmpresa usrEmp : empresasUsr) {
                    Empresa emp = new Empresa();
                    emp.setId(usrEmp.getId().getIdEmpresa());
                    emp.setTipoEmpresa(usrEmp.getEmpresa().getTipoEmpresa());
                    emp.setSigla(usrEmp.getEmpresa().getSigla());
                    emp.setIdHolding(usrEmp.getEmpresa().getIdHolding());
                    emp.setIdPoderConcedente(usrEmp.getEmpresa().getIdPoderConcedente());
                    emp.setNomeFantasia(usrEmp.getEmpresa().getNomeFantasia());
                    emp.setRazaoSocial(usrEmp.getEmpresa().getRazaoSocial());
                    emp.setEndereco(usrEmp.getEmpresa().getEndereco());
                    emp.setNumeroEndereco(usrEmp.getEmpresa().getNumeroEndereco());
                    emp.setLogoImageAnexoId(usrEmp.getEmpresa().getLogoImageAnexoId());
                    emp.setLogoImageAnexo(usrEmp.getEmpresa().getLogoImageAnexo());
                    empresas.add(emp);
                }
            }
            return new ResponseEntity(empresas, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.findEmpresasUsuario", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/all"})
    @Operation(tags={"security.open"}, summary="Lista todas as empresas do ambiente. Permite filtro opcional por par\u00e2metro search.")
    @ApiResponses(value={@ApiResponse(description="Empresas do ambiente listadas com sucesso.", responseCode="200")})
    @NotNull
    public ResponseEntity<List<Empresa>> findTodasEmpresas(@Parameter(hidden=true) @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.logger.debug("Executando findTodasEmpresas...");
        String search = null;
        if (request.getParameter("search") != null) {
            search = request.getParameter("search");
        }
        try {
            List empresasLst = this.coreService.findEmpresas(search, null);
            ArrayList<Empresa> empresas = new ArrayList<Empresa>();
            for (Empresa emp : empresasLst) {
                Empresa empObj = new Empresa();
                empObj.setId(emp.getId());
                empObj.setTipoEmpresa(emp.getTipoEmpresa());
                empObj.setSigla(emp.getSigla());
                empObj.setIdHolding(emp.getIdHolding());
                empObj.setNomeFantasia(emp.getNomeFantasia());
                empObj.setRazaoSocial(emp.getRazaoSocial());
                empObj.setEndereco(emp.getEndereco());
                empObj.setNumeroEndereco(emp.getNumeroEndereco());
                empObj.setDatInicioContrato(emp.getDatInicioContrato());
                empObj.setDatTerminoContrato(emp.getDatTerminoContrato());
                emp.setLogoImageAnexoId(emp.getLogoImageAnexoId());
                emp.setLogoImageAnexo(emp.getLogoImageAnexo());
                empresas.add(empObj);
            }
            return new ResponseEntity(empresas, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.findTodasEmpresas", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.logger.error("Exception.findTodasEmpresas", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}"})
    @Operation(summary="Consulta informa\u00e7\u00f5es detalhadas da empresa. Retorna os dados da empresa com base na sigla informada.")
    @ApiResponses(value={@ApiResponse(description="Empresa encontrada com sucesso.", responseCode="200")})
    @NotNull
    public ResponseEntity<Empresa> getEmpresa(@Parameter(hidden=true) @NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa a ser consultada") @PathVariable(name="empresa") @NotNull String empresa) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        this.logger.debug("API getEmpresa, emp={}...", (Object)empresa);
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            return new ResponseEntity((Object)emp, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.getEmpresa", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.logger.error("Exception.getEmpresa", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/infos/{idEmpresa}"})
    @Operation(summary="Consulta informa\u00e7\u00f5es detalhadas da empresa pelo ID. Retorna os dados da empresa com base no identificador num\u00e9rico.")
    @ApiResponses(value={@ApiResponse(description="Empresa encontrada com sucesso.", responseCode="200")})
    @NotNull
    public ResponseEntity<Empresa> findEmpresaById(@Parameter(hidden=true) @NotNull HttpServletRequest request, @Parameter(description="Identificador da empresa") @PathVariable(name="idEmpresa") int idEmpresa) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.logger.debug("API findEmpresaById, emp={}...", (Object)idEmpresa);
        try {
            Empresa emp = this.coreService.getEmpresaById(Integer.valueOf(idEmpresa));
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            return new ResponseEntity((Object)emp, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.findEmpresaById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.logger.error("Exception.findEmpresaById", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/areas"})
    @Operation(summary="Lista as \u00e1reas da empresa informada. Retorna a lista das \u00e1reas que pertencem \u00e0 empresa pela sigla.")
    @ApiResponses(value={@ApiResponse(description="\u00c1reas listadas com sucesso.", responseCode="200")})
    @NotNull
    public ResponseEntity<List<EmpresaArea>> findAreasEmpresa(@Parameter(hidden=true) @NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa para a qual se deseja listar as \u00e1reas") @PathVariable(name="empresa") @NotNull String empresa) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            this.logger.debug("{} - findAreasEmpresa ({})", (Object)usuario.getLogin(), (Object)empresa);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "EMPRESAS");
            if (!permissao.booleanValue()) {
                this.logger.error("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"EMPRESAS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            List areas = this.empresaService.findAreasByEmpresa(emp.getId(), Boolean.valueOf(false), null);
            return new ResponseEntity((Object)areas, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.findAreasEmpresa", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.logger.error("Exception.findAreasEmpresa", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/usuarios"})
    @Operation(summary="Lista os usu\u00e1rios da empresa informada. Retorna todos os usu\u00e1rios vinculados \u00e0 empresa.")
    @ApiResponses(value={@ApiResponse(description="Usu\u00e1rios listados com sucesso.", responseCode="200")})
    @NotNull
    public ResponseEntity<List<UsuarioEmpresa>> findUsuariosEmpresa(@Parameter(hidden=true) @NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa para consulta dos usu\u00e1rios") @PathVariable(name="empresa") @NotNull String empresa) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        try {
            this.logger.debug("findUsuariosEmpresa ({})", (Object)empresa);
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            List list = this.segurancaService.findUsuariosByEmpresa(emp.getId(), null, null, null, Boolean.valueOf(false), Pageable.unpaged()).getContent();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContent(...)");
            List usuarios = list;
            for (UsuarioEmpresa usuario : usuarios) {
                usuario.setEmpresa(null);
                usuario.setUsuario(usuario.getUsuario().toPublico());
                usuario.setIdUsuarioIns(null);
                usuario.setDatHorCadastro(null);
            }
            return new ResponseEntity((Object)usuarios, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.findUsuariosEmpresa", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.logger.error("Exception.findUsuariosEmpresa", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"{empresa}/locais"})
    @Operation(summary="Salva o local da empresa. Armazena os dados do local a partir do payload fornecido.")
    @ApiResponses(value={@ApiResponse(description="Local salvo com sucesso.", responseCode="201")})
    @NotNull
    public ResponseEntity<EmpresaLocal> saveLocalEmpresa(@Parameter(description="Sigla da empresa para salvar o local") @PathVariable(name="empresa") @NotNull String empresa, @RequestBody(description="Payload contendo os dados do local da empresa") @org.springframework.web.bind.annotation.RequestBody @NotNull EmpresaLocal empresaLocal, @Parameter(hidden=true) @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)empresaLocal, (String)"empresaLocal");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Empresa empresaGet = this.coreService.getEmpresaBySigla(empresa);
        if (empresaGet == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
        }
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            this.logger.debug("{} - saveLocalEmpresa({})", (Object)usuario.getLogin(), (Object)empresaLocal.getSigla());
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "EMPRESAS");
            if (!permissao.booleanValue()) {
                this.logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"EMPRESAS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.empresaService.saveEmpresaLocal(empresaLocal, usuario.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveLocalEmpresa", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"{empresa}/locais/{idLocal}"})
    @Operation(summary="Busca o local da empresa. Retorna o local com base no ID informado.")
    @ApiResponses(value={@ApiResponse(description="Local encontrado com sucesso.", responseCode="200")})
    @NotNull
    public ResponseEntity<EmpresaLocal> getEmpresaLocalById(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa, @Parameter(description="Identificador do local") @PathVariable(name="idLocal") int idLocal, @Parameter(hidden=true) @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Empresa empresaGet = this.coreService.getEmpresaBySigla(empresa);
        if (empresaGet == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
        }
        EmpresaLocal empresaLocal = this.empresaService.getEmpresaLocalById(Integer.valueOf(idLocal));
        Intrinsics.checkNotNullExpressionValue((Object)empresaLocal, (String)"getEmpresaLocalById(...)");
        EmpresaLocal localGet = empresaLocal;
        try {
            Object[] objectArray = new Object[]{usuario.getLogin(), empresa, idLocal};
            this.logger.debug("{} getEmpresaLocalById({},{})", objectArray);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "EMPRESAS");
            if (!permissao.booleanValue()) {
                this.logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"EMPRESAS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            ResponseEntity responseEntity = ResponseEntity.ok().body((Object)this.empresaService.getEmpresaLocalById(Integer.valueOf(idLocal)));
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.getEmpresaLocalById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/locais"})
    @Operation(summary="Lista os locais da empresa informada. Retorna os locais vinculados \u00e0 empresa.")
    @ApiResponses(value={@ApiResponse(description="Locais listados com sucesso.", responseCode="200")})
    @NotNull
    public ResponseEntity<List<EmpresaLocal>> findLocaisEmpresa(@Parameter(hidden=true) @NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa para listagem dos locais") @PathVariable(name="empresa") @NotNull String empresa) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Empresa emp = this.coreService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
        }
        try {
            this.logger.debug("{} - findLocaisEmpresa({})", (Object)usuario.getLogin(), (Object)empresa);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "EMPRESAS");
            if (!permissao.booleanValue()) {
                this.logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"EMPRESAS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            List locais = this.empresaService.findLocaisByEmpresa(emp.getId());
            if (locais != null) {
                for (EmpresaLocal local : locais) {
                    local.setIdUsuarioIns(null);
                    local.setIdUsuarioUpd(null);
                    local.setDatHorCadastro(null);
                    local.setDatHorAlteracao(null);
                }
            }
            return new ResponseEntity((Object)locais, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.findLocaisEmpresa", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.logger.error("Exception.findLocaisEmpresa", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/locais/{idLocal}"})
    @Operation(summary="Exclui o local da empresa. Deleta o local com base no identificador informado.")
    @ApiResponses(value={@ApiResponse(description="Local exclu\u00eddo com sucesso.", responseCode="200")})
    @NotNull
    public ResponseEntity<Boolean> deleteEmpresaLocal(@Parameter(description="Sigla da empresa") @PathVariable @NotNull String empresa, @Parameter(description="Identificador do local a ser deletado") @PathVariable int idLocal, @Parameter(hidden=true) @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Empresa empresaGet = this.coreService.getEmpresaBySigla(empresa);
        if (empresaGet == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
        }
        EmpresaLocal empresaLocal = this.empresaService.getEmpresaLocalById(Integer.valueOf(idLocal));
        Intrinsics.checkNotNullExpressionValue((Object)empresaLocal, (String)"getEmpresaLocalById(...)");
        EmpresaLocal localGet = empresaLocal;
        try {
            Object[] objectArray = new Object[]{usuario.getLogin(), idLocal, empresa};
            this.logger.debug("{} - deleteEmpresaLocal({},{})", objectArray);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "EMPRESAS");
            if (!permissao.booleanValue()) {
                this.logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"EMPRESAS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.empresaService.deleteEmpresaLocal(Integer.valueOf(idLocal)), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.deleteEmpresaLocal", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping
    @Operation(summary="Salva a empresa. Registra uma nova empresa a partir do payload fornecido.")
    @ApiResponses(value={@ApiResponse(description="Empresa salva com sucesso.", responseCode="201")})
    @ResponseStatus(value=HttpStatus.CREATED)
    @NotNull
    public Empresa createEmpresa(@RequestBody(description="Payload contendo os dados da empresa") @Valid @RequestPart(value="body") @NotNull SaveEmpresaDTO dto, @RequestPart(name="logo", required=false) @Nullable MultipartFile logoImage, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.logger.debug("createEmpresa({})", (Object)dto);
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        Empresa empresa = this.empresaService.createEmpresa(dto, logoImage, ((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)empresa, (String)"createEmpresa(...)");
        return empresa;
    }

    @PutMapping(value={"/{empresa}"})
    @Operation(summary="Atualiza a empresa. Modifica os dados da empresa com base no payload fornecido.")
    @ApiResponses(value={@ApiResponse(description="Empresa atualizada com sucesso.", responseCode="200")})
    @NotNull
    public Empresa updateEmpresa(@Parameter(description="Sigla da empresa a ser atualizada") @PathVariable(name="empresa") @NotNull String empresa, @RequestBody(description="Payload contendo os dados atualizados da empresa") @Valid @RequestPart(value="body") @NotNull SaveEmpresaDTO dto, @RequestPart(name="logo", required=false) @Nullable MultipartFile logoImage, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.logger.debug("updateEmpresa({})", (Object)empresa);
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        Empresa empresa2 = this.empresaService.updateEmpresa(empresa, dto, logoImage, ((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)empresa2, (String)"updateEmpresa(...)");
        return empresa2;
    }

    @PostMapping(value={"{empresa}/areas"})
    @Operation(summary="Salva a \u00e1rea da empresa. Registra uma nova \u00e1rea com os dados fornecidos no payload.")
    @ApiResponses(value={@ApiResponse(description="\u00c1rea salva com sucesso.", responseCode="201")})
    @NotNull
    public ResponseEntity<EmpresaArea> saveAreaEmpresa(@Parameter(description="Sigla da empresa onde a \u00e1rea ser\u00e1 salva") @PathVariable(name="empresa") @NotNull String empresa, @RequestBody(description="Payload contendo os dados da \u00e1rea da empresa") @org.springframework.web.bind.annotation.RequestBody @NotNull EmpresaArea empresaArea, @Parameter(hidden=true) @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)empresaArea, (String)"empresaArea");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Empresa emp = this.coreService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrado.");
        }
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            this.logger.debug("{} - saveAreaEmpresa({})", (Object)usuario.getLogin(), (Object)empresaArea);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "EMPRESAS");
            if (!permissao.booleanValue()) {
                this.logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"EMPRESAS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
            return new ResponseEntity((Object)this.empresaService.saveArea(empresaArea, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveAreaEmpresa", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/usuarios"})
    @Operation(summary="Salva o usu\u00e1rio da empresa. Registra um novo usu\u00e1rio com base no payload fornecido.")
    @ApiResponses(value={@ApiResponse(description="Usu\u00e1rio salvo com sucesso.", responseCode="201")})
    @NotNull
    public ResponseEntity<UsuarioEmpresa> saveUsuarioEmpresa(@RequestBody(description="Payload contendo os dados do usu\u00e1rio da empresa") @org.springframework.web.bind.annotation.RequestBody @NotNull UsuarioEmpresa usuarioEmpresa, @Parameter(hidden=true) @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)usuarioEmpresa, (String)"usuarioEmpresa");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            this.logger.debug("saveAreaEmpresa({})", (Object)usuarioEmpresa);
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
            }
            return new ResponseEntity((Object)this.segurancaService.saveUsuarioEmpresa(usuarioEmpresa), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveUsuarioEmpresa", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/usuarios"})
    @Operation(summary="Salva lista de usu\u00e1rios da empresa. Registra m\u00faltiplos usu\u00e1rios a partir do payload fornecido.")
    @ApiResponses(value={@ApiResponse(description="Usu\u00e1rios salvos com sucesso.", responseCode="201")})
    @NotNull
    public ResponseEntity<List<UsuarioEmpresa>> saveUsuariosEmpresa(@Parameter(description="Sigla da empresa para a qual os usu\u00e1rios ser\u00e3o salvos") @PathVariable(name="empresa") @NotNull String empresa, @RequestBody(description="Payload contendo a lista de usu\u00e1rios da empresa") @org.springframework.web.bind.annotation.RequestBody @NotNull List<? extends UsuarioEmpresa> usuarioEmpresa, @Parameter(hidden=true) @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter(usuarioEmpresa, (String)"usuarioEmpresa");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser usuario = this.getUsuarioByJWT(request);
        Empresa emp = this.coreService.getEmpresaBySigla(empresa);
        try {
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrado.");
            }
            this.logger.debug("usu\u00e1rio={}, saveUsuariosEmpresa({})", (Object)usuario.getLogin(), (Object)empresa);
            return new ResponseEntity((Object)this.segurancaService.saveUsuariosEmpresa(usuarioEmpresa, usuario.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveUsuariosEmpresa", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}"})
    @Operation(summary="Exclui a empresa. Deleta a empresa com base na sigla informada.")
    @ApiResponses(value={@ApiResponse(description="Empresa exclu\u00edda com sucesso.", responseCode="200")})
    @NotNull
    public ResponseEntity<Boolean> deleteEmpresa(@Parameter(description="Sigla da empresa a ser exclu\u00edda") @PathVariable(name="empresa") @NotNull String empresa, @Parameter(hidden=true) @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            this.logger.debug("deleteEmpresa({})", (Object)empresa);
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            return new ResponseEntity((Object)this.coreService.deleteEmpresa(emp.getId()), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.deleteEmpresa", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"{empresa}/areas/{idArea}"})
    @Operation(summary="Exclui a \u00e1rea da empresa. Deleta a \u00e1rea com base no identificador informado.")
    @ApiResponses(value={@ApiResponse(description="\u00c1rea exclu\u00edda com sucesso.", responseCode="200")})
    @NotNull
    public ResponseEntity<Boolean> deleteAreaEmpresa(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa, @Parameter(description="Identificador da \u00e1rea a ser exclu\u00edda") @PathVariable(name="idArea") int idArea, @Parameter(hidden=true) @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Empresa emp = this.coreService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrado.");
        }
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            this.logger.debug("{} - deleteAreaEmpresa({})", (Object)usuario.getLogin(), (Object)idArea);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "EMPRESAS");
            if (!permissao.booleanValue()) {
                this.logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"EMPRESAS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.empresaService.deleteArea(Integer.valueOf(idArea)), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.deleteAreaEmpresa", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"{empresa}/usuarios/{idUsuario}"})
    @Operation(summary="Exclui o usu\u00e1rio da empresa. Remove o usu\u00e1rio a partir do identificador informado.")
    @ApiResponses(value={@ApiResponse(description="Usu\u00e1rio exclu\u00eddo com sucesso.", responseCode="200")})
    @NotNull
    public ResponseEntity<Boolean> deleteUsuarioEmpresa(@Parameter(hidden=true) @NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable @NotNull String empresa, @Parameter(description="Identificador do usu\u00e1rio a ser exclu\u00eddo") @PathVariable int idUsuario) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Empresa emp = this.coreService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrado.");
        }
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Object[] objectArray = new Object[]{usuario.getLogin(), empresa, idUsuario};
            this.logger.debug("{} - deleteUsuarioEmpresa({}, {})", objectArray);
            return new ResponseEntity((Object)this.segurancaService.deleteEmpresasUsuario(Integer.valueOf(idUsuario), emp.getId()), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.deleteUsuarioEmpresa", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/responsaveisArea"})
    @Operation(summary="Consulta respons\u00e1veis da \u00e1rea. Retorna os respons\u00e1veis para as \u00e1reas especificadas.")
    @ApiResponses(value={@ApiResponse(description="Respons\u00e1veis listados com sucesso.", responseCode="200")})
    @NotNull
    public ResponseEntity<Page<EmpresaAreaResponsavel>> findResponsaveisArea(@Parameter(hidden=true) @NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa, @Parameter(description="Identificador da \u00e1rea") @RequestParam(name="idArea") @NotNull List<Integer> idArea, @Parameter(description="Par\u00e2metro de pagina\u00e7\u00e3o") @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter(idArea, (String)"idArea");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Object[] objectArray = new Object[]{usuario.getLogin(), empresa, idArea};
            this.logger.debug("{} - findResponsaveisArea ({},{})", objectArray);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "EMPRESAS");
            if (!permissao.booleanValue()) {
                this.logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"EMPRESAS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                HttpStatusCode httpStatusCode = (HttpStatusCode)HttpStatus.BAD_REQUEST;
                String string = "Empresa %s n\u00e3o encontrada.";
                Object[] objectArray2 = new Object[]{empresa};
                String string2 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                throw new ResponseStatusException(httpStatusCode, string2);
            }
            Page responsaveis = this.empresaService.findResponsaveisByArea(pageable, emp.getId(), idArea);
            return new ResponseEntity((Object)responsaveis, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("findResponsaveisArea.findResponsaveisArea", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.logger.error("exc.findResponsaveisArea", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"{empresa}/filiais/{idHolding}"})
    @Operation(summary="Lista as empresas filiais da Holding. Retorna empresas filiais baseadas no ID da holding.")
    @ApiResponses(value={@ApiResponse(description="Filiais listadas com sucesso.", responseCode="200")})
    @NotNull
    public ResponseEntity<List<Empresa>> findFiliais(@Parameter(hidden=true) @NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa, @Parameter(description="Identificador da Holding") @PathVariable(name="idHolding") int idHolding) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Empresa emp = this.coreService.getEmpresaBySigla(empresa);
        if (emp == null) {
            HttpStatusCode httpStatusCode = (HttpStatusCode)HttpStatus.BAD_REQUEST;
            String string = "Empresa %s n\u00e3o encontrada.";
            Object[] objectArray = new Object[]{empresa};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            throw new ResponseStatusException(httpStatusCode, string2);
        }
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            this.logger.debug("{} - findFiliais...", (Object)usuario.getLogin());
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "EMPRESAS");
            if (!permissao.booleanValue()) {
                this.logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"EMPRESAS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            List filiais = this.coreService.findEmpresasByHolding(Integer.valueOf(idHolding));
            boolean incluirHolding = Boolean.parseBoolean(request.getParameter("incluirHolding"));
            if (incluirHolding) {
                Empresa holding = this.coreService.getEmpresaById(Integer.valueOf(idHolding));
                if (filiais == null) {
                    filiais = new ArrayList();
                }
                filiais.add(holding);
            }
            ArrayList<Empresa> empresas = new ArrayList<Empresa>();
            if (filiais != null) {
                for (Empresa usrEmp : filiais) {
                    Empresa newEmp = new Empresa();
                    newEmp.setId(usrEmp.getId());
                    newEmp.setTipoEmpresa(usrEmp.getTipoEmpresa());
                    newEmp.setSigla(usrEmp.getSigla());
                    newEmp.setNomeFantasia(usrEmp.getNomeFantasia());
                    newEmp.setRazaoSocial(usrEmp.getRazaoSocial());
                    empresas.add(newEmp);
                }
            }
            return new ResponseEntity(empresas, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.findFiliais", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"{empresa}/areas/{idArea}"})
    @Operation(summary="Busca a \u00e1rea da empresa. Retorna a \u00e1rea com base no ID informado.")
    @ApiResponses(value={@ApiResponse(description="\u00c1rea encontrada com sucesso.", responseCode="200")})
    @NotNull
    public ResponseEntity<EmpresaArea> getEmpresaAreaById(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa, @Parameter(description="Identificador da \u00e1rea") @PathVariable(name="idArea") int idArea, @Parameter(hidden=true) @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Empresa emp = this.coreService.getEmpresaBySigla(empresa);
        if (emp == null) {
            HttpStatusCode httpStatusCode = (HttpStatusCode)HttpStatus.BAD_REQUEST;
            String string = "Empresa %s n\u00e3o encontrada.";
            Object[] objectArray = new Object[]{empresa};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            throw new ResponseStatusException(httpStatusCode, string2);
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "EMPRESAS");
            if (!permissao.booleanValue()) {
                this.logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"EMPRESAS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            EmpresaArea empresaArea = this.empresaService.getAreaById(Integer.valueOf(idArea));
            ResponseEntity responseEntity = ResponseEntity.ok().body((Object)empresaArea);
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            this.logger.error("bizExc.getEmpresaAreaById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"{empresa}/usuarios/{idUsuario}"})
    @Operation(summary="Busca o usu\u00e1rio da empresa. Retorna os dados do usu\u00e1rio com base no ID informado.")
    @ApiResponses(value={@ApiResponse(description="Usu\u00e1rio encontrado com sucesso.", responseCode="200")})
    @NotNull
    public ResponseEntity<UsuarioEmpresa> getUsuarioEmpresaById(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa, @Parameter(description="Identificador do usu\u00e1rio") @PathVariable(name="idUsuario") int idUsuario, @Parameter(hidden=true) @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Object[] objectArray = new Object[]{usuario.getLogin(), empresa, idUsuario};
        this.logger.debug("{} - Executando getUnidadeById({}, {})", objectArray);
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                HttpStatusCode httpStatusCode = (HttpStatusCode)HttpStatus.BAD_REQUEST;
                String string = "Empresa %s n\u00e3o encontrada.";
                Object[] objectArray2 = new Object[]{empresa};
                String string2 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                throw new ResponseStatusException(httpStatusCode, string2);
            }
            UsuarioEmpresa usuarioEmpresa = this.segurancaService.getUsuarioByIdAndEmpresa(Integer.valueOf(idUsuario), emp.getId());
            ResponseEntity responseEntity = ResponseEntity.ok().body((Object)usuarioEmpresa);
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            this.logger.error("bizExc.getUsuarioEmpresaById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/anosConcessao"})
    @Operation(summary="Lista os anos de concess\u00e3o da empresa. Retorna os anos de concess\u00e3o vinculados \u00e0 empresa.")
    @ApiResponses(value={@ApiResponse(description="Anos de concess\u00e3o listados com sucesso.", responseCode="200"), @ApiResponse(description="Empresa n\u00e3o encontrada.", responseCode="404")})
    @NotNull
    public Page<EmpresaAnoConcessao> getAnosConcessaoByEmpresa(@Parameter(description="Sigla da empresa para listagem dos anos de concess\u00e3o") @PathVariable(name="empresa") @NotNull String empresa, @Parameter(description="Par\u00e2metros de pagina\u00e7\u00e3o") @PageableDefault(sort={"id.anoConcessao"}, direction=Sort.Direction.ASC) @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Page page = this.empresaService.getAnosConcessaoByEmpresa(empresa, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"getAnosConcessaoByEmpresa(...)");
        return page;
    }

    @PostMapping(value={"{empresa}/anosConcessao"})
    @Operation(summary="Salva o ano de concess\u00e3o da empresa. Registra um novo ano de concess\u00e3o com os dados fornecidos no payload.")
    @ApiResponses(value={@ApiResponse(description="Ano de concess\u00e3o salvo com sucesso.", responseCode="201"), @ApiResponse(description="Empresa n\u00e3o encontrada.", responseCode="404")})
    @NotNull
    public EmpresaAnoConcessao saveAnoConcessaoEmpresa(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa, @RequestBody(description="Payload contendo os dados do ano de concess\u00e3o da empresa") @org.springframework.web.bind.annotation.RequestBody @Valid @NotNull SaveEmpresaAnoConcessaoDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        PublicUser usuario = publicUser;
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        EmpresaAnoConcessao empresaAnoConcessao = this.empresaService.createAnoConcessao(empresa, dto, ((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)empresaAnoConcessao, (String)"createAnoConcessao(...)");
        return empresaAnoConcessao;
    }

    @PutMapping(value={"{empresa}/anosConcessao/{seqAnoConcessao}"})
    @Operation(summary="Atualiza o ano de concess\u00e3o da empresa. Modifica os dados do ano de concess\u00e3o com base no payload fornecido.")
    @ApiResponses(value={@ApiResponse(description="Ano de concess\u00e3o atualizado com sucesso.", responseCode="200"), @ApiResponse(description="Empresa ou ano de concess\u00e3o n\u00e3o encontrado.", responseCode="404")})
    @NotNull
    public EmpresaAnoConcessao updateAnoConcessaoEmpresa(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa, @Parameter(description="Identificador do ano de concess\u00e3o a ser atualizado") @PathVariable(name="seqAnoConcessao") int seqAnoConcessao, @RequestBody(description="Payload contendo os dados atualizados do ano de concess\u00e3o da empresa") @org.springframework.web.bind.annotation.RequestBody @Valid @NotNull SaveEmpresaAnoConcessaoDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        PublicUser usuario = publicUser;
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        EmpresaAnoConcessao empresaAnoConcessao = this.empresaService.updateAnoConcessao(empresa, seqAnoConcessao, dto, ((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)empresaAnoConcessao, (String)"updateAnoConcessao(...)");
        return empresaAnoConcessao;
    }

    @DeleteMapping(value={"{empresa}/anosConcessao/{seqAnoConcessao}"})
    @Operation(summary="Exclui o ano de concess\u00e3o da empresa. Deleta o ano de concess\u00e3o com base no identificador informado.")
    @ApiResponses(value={@ApiResponse(description="Ano de concess\u00e3o exclu\u00eddo com sucesso.", responseCode="200"), @ApiResponse(description="Empresa ou ano de concess\u00e3o n\u00e3o encontrado.", responseCode="404")})
    public void deleteAnoConcessaoEmpresa(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa, @Parameter(description="Identificador do ano de concess\u00e3o a ser exclu\u00eddo") @PathVariable(name="seqAnoConcessao") int seqAnoConcessao, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.getUsuarioByJWT(request) == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        this.empresaService.deleteAnoConcessao(empresa, seqAnoConcessao);
    }
}

