/*
 * Decompiled with CFR 0.152.
 */
package br.com.sigescantt.apis;

import br.com.sigescantt.apis.BaseRestService;
import br.com.sigescantt.core.beans.geral.Empresa;
import br.com.sigescantt.core.beans.geral.RefCode;
import br.com.sigescantt.core.beans.geral.TipoCanal;
import br.com.sigescantt.core.beans.geral.TipoModulo;
import br.com.sigescantt.core.beans.seguranca.PublicUser;
import br.com.sigescantt.exceptions.BusinessException;
import br.com.sigescantt.ged.utils.UploadedFileInfo;
import br.com.sigescantt.geral.TipoRefCode;
import br.com.sigescantt.seguranca.UsuarioSessao;
import br.com.sigescantt.services.CadastroService;
import br.com.sigescantt.services.CoreService;
import br.com.sigescantt.services.GedService;
import br.com.sigescantt.services.SegurancaService;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@RestController
@Tags(value={@Tag(name="downloads", description="REST Services para downloads"), @Tag(name="security.open")})
@RequestMapping(value={"/api/downloads"})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ6\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\b\b\u0001\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u00162\b\b\u0001\u0010\u0017\u001a\u00020\u00162\b\b\u0001\u0010\u0018\u001a\u00020\u0016H\u0017J6\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00112\b\b\u0001\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u00162\b\b\u0001\u0010\u0017\u001a\u00020\u00162\b\b\u0001\u0010\u0018\u001a\u00020\u0016H\u0017J\u0018\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00112\b\b\u0001\u0010\u0013\u001a\u00020\u0014H\u0017J\"\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00112\b\b\u0001\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u001f\u001a\u00020 H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006!"}, d2={"Lbr/com/sigescantt/apis/DownloadsRestServices;", "Lbr/com/sigescantt/apis/BaseRestService;", "segurancaService", "Lbr/com/sigescantt/services/SegurancaService;", "coreService", "Lbr/com/sigescantt/services/CoreService;", "cadastroService", "Lbr/com/sigescantt/services/CadastroService;", "gedService", "Lbr/com/sigescantt/services/GedService;", "<init>", "(Lbr/com/sigescantt/services/SegurancaService;Lbr/com/sigescantt/services/CoreService;Lbr/com/sigescantt/services/CadastroService;Lbr/com/sigescantt/services/GedService;)V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "downloadAnexo", "Lorg/springframework/http/ResponseEntity;", "", "request", "Ljakarta/servlet/http/HttpServletRequest;", "empresa", "", "modulo", "uuid", "downloadThumb", "Lorg/springframework/core/io/ByteArrayResource;", "downloadLogomarcas", "Lcom/fasterxml/jackson/databind/node/ArrayNode;", "downloadBackgroundPadrao", "Lorg/springframework/web/servlet/mvc/method/annotation/StreamingResponseBody;", "response", "Ljakarta/servlet/http/HttpServletResponse;", "server"})
public class DownloadsRestServices
extends BaseRestService {
    @NotNull
    private final SegurancaService segurancaService;
    @NotNull
    private final CoreService coreService;
    @NotNull
    private final CadastroService cadastroService;
    @NotNull
    private final GedService gedService;
    @NotNull
    private final Logger logger;

    public DownloadsRestServices(@NotNull SegurancaService segurancaService, @NotNull CoreService coreService, @NotNull CadastroService cadastroService, @NotNull GedService gedService) {
        Intrinsics.checkNotNullParameter((Object)segurancaService, (String)"segurancaService");
        Intrinsics.checkNotNullParameter((Object)coreService, (String)"coreService");
        Intrinsics.checkNotNullParameter((Object)cadastroService, (String)"cadastroService");
        Intrinsics.checkNotNullParameter((Object)gedService, (String)"gedService");
        super(segurancaService);
        this.segurancaService = segurancaService;
        this.coreService = coreService;
        this.cadastroService = cadastroService;
        this.gedService = gedService;
        Logger logger = LoggerFactory.getLogger(DownloadsRestServices.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @GetMapping(value={"/{empresa}/anexos/{modulo}/{uuid}"})
    @Operation(summary="Efetua o download do anexo no GED, conforme UUID e M\u00f3dulo", description="Realiza o download de um anexo armazenado no GED, identificado pelo UUID e m\u00f3dulo. Para dispositivos m\u00f3veis, imagens s\u00e3o redimensionadas automaticamente para otimizar o tr\u00e1fego. Alguns m\u00f3dulos requerem autentica\u00e7\u00e3o para acesso aos anexos.")
    @ApiResponses(value={@ApiResponse(description="Download realizado com sucesso", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<byte[]> downloadAnexo(@Parameter(hidden=true) @NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa, @Parameter(description="M\u00f3dulo do sistema") @PathVariable(name="modulo") @NotNull String modulo, @Parameter(description="UUID do anexo no GED") @PathVariable(name="uuid") @NotNull String uuid) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)modulo, (String)"modulo");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Object[] objectArray = new Object[]{empresa, modulo, uuid};
        this.logger.debug("Downloading anexos (emp={},modulo={},uuid={})...", objectArray);
        if (((CharSequence)empresa).length() == 0) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o informada.");
        }
        Empresa emp = this.coreService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
        }
        if (((CharSequence)modulo).length() == 0) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "M\u00f3dulo do anexo n\u00e3o informado.");
        }
        if (((CharSequence)uuid).length() == 0) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Identificador do Anexo n\u00e3o informado.");
        }
        UsuarioSessao sessao = null;
        if (request.getParameter("token") != null) {
            sessao = this.getSessaoUsuarioByToken(request.getParameter("token"));
        }
        if (!(sessao != null && sessao.getUsuario() != null || modulo.equals(TipoModulo.CORRESPONDENCIAS.getSigla()) || modulo.equals(TipoModulo.AMBIENTAL.getSigla()) || modulo.equals(TipoModulo.SIGACO.getSigla()) || modulo.equals(TipoModulo.GERAL.getSigla()))) {
            PublicUser publicUser = this.getUsuarioByJWT(request);
            if (publicUser == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Token de acesso n\u00e3o dispon\u00edvel.");
            }
            PublicUser publicUser2 = publicUser;
        }
        try {
            UploadedFileInfo uploadedFileInfo = this.gedService.getFileInfoByUuid(emp.getId(), uuid, Boolean.valueOf(false));
            Intrinsics.checkNotNullExpressionValue((Object)uploadedFileInfo, (String)"getFileInfoByUuid(...)");
            UploadedFileInfo gedFileInfo = uploadedFileInfo;
            if (modulo.equals(TipoModulo.CORRESPONDENCIAS.getSigla()) && !StringsKt.equals((String)gedFileInfo.getItemModulo(), (String)"Assinatura digital", (boolean)true) && sessao == null) {
                PublicUser publicUser = this.getUsuarioByJWT(request);
                if (publicUser == null) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Token de acesso n\u00e3o dispon\u00edvel.");
                }
                uploadedFileInfo = publicUser;
            }
            byte[] gedBytes = null;
            int imgWidth = 768;
            String string = gedFileInfo.getFileName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            CharSequence charSequence = string2;
            boolean gedImage = new Regex("(jpg|jpeg|gif|png)").matches(charSequence);
            if (sessao != null && sessao.getCanal().equals(TipoCanal.MOBILE.getCode()) && gedImage && gedFileInfo.getSize() > 524288L) {
                String repoAdicional = this.coreService.getRepoPathLeitura(emp.getId());
                gedBytes = this.gedService.getFileBytesByUUID(emp.getId(), uuid, repoAdicional);
                if (gedBytes == null) {
                    this.gedService.createScaledImage(gedFileInfo.getFullPath(), gedFileInfo.getRepoPath(), Integer.valueOf(imgWidth), repoAdicional);
                    gedBytes = this.gedService.getFileBytesByUUID(emp.getId(), uuid, repoAdicional);
                    if (gedBytes == null) {
                        gedBytes = this.gedService.getFileBytesByUUID(emp.getId(), uuid, null);
                    }
                }
            } else {
                gedBytes = this.gedService.getFileBytesByUUID(emp.getId(), uuid, null);
            }
            if (gedBytes == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Arquivo f\u00edsico n\u00e3o foi encontrado, imposs\u00edvel prosseguir.");
            }
            HttpHeaders headers = new HttpHeaders();
            headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
            headers.add("Content-Type", gedFileInfo.getContentType());
            headers.add("Content-Disposition", "attachment filename=\"" + gedFileInfo.getFileName() + "\"");
            headers.add("Pragma", "no-cache");
            headers.add("Expires", "0");
            ResponseEntity.BodyBuilder bodyBuilder = (ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers);
            Long l = gedFileInfo.getSize();
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getSize(...)");
            ResponseEntity responseEntity = bodyBuilder.contentLength(((Number)l).longValue()).body((Object)gedBytes);
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            this.logger.error("bizExc", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/{empresa}/thumbs/{modulo}/{uuid}"})
    @Operation(summary="Efetua o download do Thumbnail no GED, conforme UUID e M\u00f3dulo. O anexo precisa ser do tipo imagem.", description="Realiza o download da miniatura (thumbnail) de uma imagem armazenada no GED. O anexo deve ser obrigatoriamente do tipo imagem (jpg, jpeg, gif, png). Alguns m\u00f3dulos requerem autentica\u00e7\u00e3o para acesso \u00e0s miniaturas.")
    @ApiResponses(value={@ApiResponse(description="Download da miniatura realizado com sucesso", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<ByteArrayResource> downloadThumb(@Parameter(hidden=true) @NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa, @Parameter(description="M\u00f3dulo do sistema") @PathVariable(name="modulo") @NotNull String modulo, @Parameter(description="UUID da imagem") @PathVariable(name="uuid") @NotNull String uuid) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)modulo, (String)"modulo");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Object[] objectArray = new Object[]{empresa, modulo, uuid};
        this.logger.debug("Downloading Thumb (emp={},modulo={},uuid={})...", objectArray);
        if (((CharSequence)empresa).length() == 0) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o informada.");
        }
        Empresa emp = this.coreService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
        }
        if (((CharSequence)modulo).length() == 0) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Tipo do M\u00f3dulo n\u00e3o foi informado.");
        }
        if (((CharSequence)uuid).length() == 0) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "UUID do Anexo n\u00e3o foi informado.");
        }
        PublicUser usuario = null;
        if (request.getParameter("token") != null) {
            usuario = this.getUsuarioByToken(request.getParameter("token"));
        }
        if (!(usuario != null || modulo.equals(TipoModulo.CORRESPONDENCIAS.getSigla()) || modulo.equals(TipoModulo.AMBIENTAL.getSigla()) || modulo.equals(TipoModulo.SIGACO.getSigla()) || (usuario = this.getUsuarioByJWT(request)) != null)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Token de acesso n\u00e3o dispon\u00edvel.");
        }
        try {
            UploadedFileInfo fileInfo = null;
            fileInfo = this.gedService.getFileInfoByUuid(emp.getId(), uuid, Boolean.valueOf(false));
            String string = fileInfo.getFileName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            CharSequence charSequence = string2;
            if (new Regex("(jpg|jpeg|gif|png)").matches(charSequence)) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Anexo n\u00e3o \u00e9 uma imagem.");
            }
            HttpHeaders headers = null;
            headers = new HttpHeaders();
            headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
            headers.add("Content-Type", fileInfo.getContentType());
            headers.add("Pragma", "no-cache");
            headers.add("Expires", "0");
            Closeable closeable = this.gedService.getThumbnailByUUID(emp.getId(), uuid, null);
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                if (it == null) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Miniatura n\u00e3o foi encontrada no reposit\u00f3rio.");
                }
                byte[] bytes = it.readAllBytes();
                ByteArrayResource resThumb = new ByteArrayResource(bytes);
                ResponseEntity.BodyBuilder bodyBuilder = (ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers);
                Long l = fileInfo.getSize();
                Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getSize(...)");
                ResponseEntity responseEntity = bodyBuilder.contentLength(((Number)l).longValue()).body((Object)resThumb);
                Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
                ResponseEntity responseEntity2 = responseEntity;
                return responseEntity2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException ioExc) {
            this.logger.error("ioExc", (Throwable)ioExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ioExc.getMessage());
        }
        catch (BusinessException bizExc) {
            this.logger.error("bizExc", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/logomarcas"})
    @Operation(summary="Efetua o download das logomarcas das empresas", description="Retorna as logomarcas de todas as empresas cadastradas no sistema, codificadas em Base64. Caso a logomarca n\u00e3o seja encontrada, retorna uma imagem padr\u00e3o.")
    @ApiResponses(value={@ApiResponse(description="Logomarcas retornadas com sucesso", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<ArrayNode> downloadLogomarcas(@Parameter(hidden=true) @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.logger.debug("Downloading logomarcas()...");
        List empresas = this.coreService.findEmpresas(null, null);
        String pathGeral = null;
        String logomarca = null;
        ArrayNode arrayNode = JsonNodeFactory.instance.arrayNode();
        Intrinsics.checkNotNullExpressionValue((Object)arrayNode, (String)"arrayNode(...)");
        ArrayNode logomarcas = arrayNode;
        for (Empresa empresa : empresas) {
            ObjectNode node;
            this.logger.debug("looping empresa={}", (Object)empresa.getSigla());
            pathGeral = this.coreService.getRepoPath(empresa.getId());
            logomarca = null;
            List refCodes = this.coreService.findRefCodes(empresa.getId(), "INFRA.");
            for (RefCode refEmp : refCodes) {
                if (refEmp.getIdEmpresa() == null || !((Object)refEmp.getIdEmpresa()).equals(empresa.getId()) || !refEmp.getRefName().equals(TipoRefCode.INFRA_LOGOMARCA.getRefName())) continue;
                logomarca = refEmp.getRefValue();
            }
            File logoFile = null;
            String extensao = null;
            byte[] bytes = new byte[]{};
            if (pathGeral != null && logomarca != null) {
                StringBuilder filePath = new StringBuilder();
                filePath.append(pathGeral);
                filePath.append(File.separator);
                filePath.append("img");
                filePath.append(File.separator);
                filePath.append(logomarca);
                this.logger.debug("reading logomarca={}", (Object)filePath.toString());
                extensao = FilenameUtils.getExtension((String)filePath.toString());
                logoFile = new File(filePath.toString());
            }
            if (pathGeral == null || logomarca == null || logoFile == null || !logoFile.exists()) {
                try {
                    ClassLoader cl;
                    Intrinsics.checkNotNullExpressionValue((Object)request.getServletContext().getClassLoader(), (String)"getClassLoader(...)");
                    URL stream = cl.getResource("META-INF/resources/img/logo_gesconsys.png");
                    if (stream == null) {
                        throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Logo padr\u00e3o n\u00e3o foi encontrada, verifique.");
                    }
                    bytes = IOUtils.toByteArray((URL)stream);
                    extensao = "png";
                }
                catch (FileNotFoundException fnfExc) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, fnfExc.getMessage());
                }
                catch (IOException ioExc) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ioExc.getMessage());
                }
            }
            if (logoFile != null && logoFile.exists()) {
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(logoFile);
                    bytes = new byte[(int)logoFile.length()];
                    fis.read(bytes);
                    fis.close();
                }
                catch (FileNotFoundException fnfExc) {
                    this.logger.error("fnfExc", (Throwable)fnfExc);
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, fnfExc.getMessage());
                }
                catch (IOException ioExc) {
                    this.logger.error("ioExc", (Throwable)ioExc);
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ioExc.getMessage());
                }
            }
            if (bytes == null || bytes.length == 0) continue;
            Intrinsics.checkNotNullExpressionValue((Object)JsonNodeFactory.instance.objectNode(), (String)"objectNode(...)");
            node.put("empresa", empresa.getSigla());
            node.put("imagem", Base64.encodeBase64String((byte[])bytes));
            node.put("extensao", extensao);
            logomarcas.add((JsonNode)node);
        }
        return new ResponseEntity((Object)logomarcas, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/backgrounds"})
    @Operation(summary="Efetua o download do background padr\u00e3o", description="Realiza o download da imagem de fundo (background) padr\u00e3o do sistema ou da empresa configurada. Utiliza StreamingResponseBody para otimizar a transfer\u00eancia de dados.")
    @ApiResponses(value={@ApiResponse(description="Background retornado com sucesso", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<StreamingResponseBody> downloadBackgroundPadrao(@Parameter(hidden=true) @NotNull HttpServletRequest request, @Parameter(hidden=true) @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        this.logger.debug("API downloadBackgroundPadrao...");
        Object empresaGlobal = this.coreService.getGlobalRefValueByName(TipoRefCode.INFRA_EMPRESA_PADRAO);
        StreamingResponseBody stream = arg_0 -> DownloadsRestServices.downloadBackgroundPadrao$lambda$1(empresaGlobal, this, response, request, arg_0);
        this.logger.info("streaming response({})", empresaGlobal);
        return new ResponseEntity((Object)stream, (HttpStatusCode)HttpStatus.OK);
    }

    private static final void downloadBackgroundPadrao$lambda$1(Object $empresaGlobal, DownloadsRestServices this$0, HttpServletResponse $response, HttpServletRequest $request, OutputStream out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        File backgroundFile = null;
        byte[] bytes = new byte[]{};
        if ($empresaGlobal != null) {
            if (!($empresaGlobal instanceof Integer)) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Erro formato EmpresaGlobal.");
            }
            Object backgroundPath = this$0.coreService.getRefValueByName((Integer)$empresaGlobal, TipoRefCode.INFRA_BACKGROUND_EMPRESA);
            if (backgroundPath != null && !(((CharSequence)backgroundPath.toString()).length() == 0)) {
                Object pathGeral = this$0.coreService.getRefValueByName((Integer)$empresaGlobal, TipoRefCode.INFRA_PATH_GERAL);
                StringBuilder filePath = new StringBuilder();
                filePath.append(pathGeral);
                filePath.append(File.separator);
                filePath.append("img");
                filePath.append(File.separator);
                filePath.append(backgroundPath);
                this$0.logger.debug("reading background={}", (Object)filePath.toString());
                String fileName = FilenameUtils.getName((String)filePath.toString());
                backgroundFile = new File(filePath.toString());
                $response.setHeader("Content-Disposition", "attachment filename=\"" + fileName + "\"");
            }
        }
        if (backgroundFile != null && backgroundFile.exists()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(backgroundFile);
                bytes = new byte[(int)backgroundFile.length()];
                fis.read(bytes);
                fis.close();
            }
            catch (FileNotFoundException fnfExc) {
                this$0.logger.error("fnfExc", (Throwable)fnfExc);
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, fnfExc.getMessage());
            }
            catch (IOException ioExc) {
                this$0.logger.error("ioExc", (Throwable)ioExc);
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ioExc.getMessage());
            }
        }
        String fileName = "full-background.jpg";
        try {
            ClassLoader cl = $request.getServletContext().getClassLoader();
            URL stream = cl.getResource("static/" + fileName);
            if (stream == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Logo padr\u00e3o n\u00e3o foi encontrada, verifique.");
            }
            bytes = IOUtils.toByteArray((URL)stream);
            $response.setHeader("Content-Disposition", "attachment filename=\"" + fileName + "\"");
        }
        catch (FileNotFoundException fnfExc) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, fnfExc.getMessage());
        }
        out.write(bytes);
    }
}

