/*
 * Decompiled with CFR 0.152.
 */
package br.com.sigescantt.apis;

import br.com.sigescantt.apis.BaseRestService;
import br.com.sigescantt.core.beans.geral.ConfiguracaoInterfaceVO;
import br.com.sigescantt.core.beans.geral.DicionarioPropertyVO;
import br.com.sigescantt.core.beans.geral.DicionarioVO;
import br.com.sigescantt.core.beans.geral.TipoModulo;
import br.com.sigescantt.core.beans.seguranca.PublicUser;
import br.com.sigescantt.exceptions.BusinessException;
import br.com.sigescantt.services.CoreService;
import br.com.sigescantt.services.Exceptions.ErrorCode;
import br.com.sigescantt.services.Exceptions.ErrorCodeException;
import br.com.sigescantt.services.SegurancaService;
import br.com.sigescantt.services.helpers.BaseImportHelper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(name="core", description="REST Services para Servi\u00e7os principais")
@RequestMapping(value={"/api/v1/core"})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J*\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000b2\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0017J4\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u000b2\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\b\u0001\u0010\u0015\u001a\u00020\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0017J\u001a\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J:\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000b2\b\b\u0001\u0010\u000e\u001a\u00020\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\u00112\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u000f2\n\b\u0001\u0010\u001d\u001a\u0004\u0018\u00010\u000fH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lbr/com/sigescantt/apis/CoreRestServices;", "Lbr/com/sigescantt/apis/BaseRestService;", "segurancaService", "Lbr/com/sigescantt/services/SegurancaService;", "coreService", "Lbr/com/sigescantt/services/CoreService;", "<init>", "(Lbr/com/sigescantt/services/SegurancaService;Lbr/com/sigescantt/services/CoreService;)V", "logger", "Lorg/slf4j/Logger;", "findDicionarios", "Lorg/springframework/http/ResponseEntity;", "", "Lbr/com/sigescantt/core/beans/geral/DicionarioVO;", "modulo", "", "request", "Ljakarta/servlet/http/HttpServletRequest;", "findEntidadeDicionario", "", "Lbr/com/sigescantt/core/beans/geral/DicionarioPropertyVO;", "entidade", "preProcessarPlanilhas", "Lbr/com/sigescantt/services/helpers/BaseImportHelper$PreProcessResult;", "file", "Lorg/springframework/web/multipart/MultipartFile;", "findConfiguracoesInterfaces", "Lbr/com/sigescantt/core/beans/geral/ConfiguracaoInterfaceVO;", "nomeInterface", "fluxoInterface", "server"})
public class CoreRestServices
extends BaseRestService {
    @NotNull
    private final SegurancaService segurancaService;
    @NotNull
    private final CoreService coreService;
    @NotNull
    private final Logger logger;

    public CoreRestServices(@NotNull SegurancaService segurancaService, @NotNull CoreService coreService) {
        Intrinsics.checkNotNullParameter((Object)segurancaService, (String)"segurancaService");
        Intrinsics.checkNotNullParameter((Object)coreService, (String)"coreService");
        super(segurancaService);
        this.segurancaService = segurancaService;
        this.coreService = coreService;
        Logger logger = LoggerFactory.getLogger(CoreRestServices.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    @GetMapping(value={"/dicionarios/{modulo}"})
    @Operation(summary="Retorna o dicion\u00e1rio do m\u00f3dulo informado")
    @NotNull
    public ResponseEntity<List<DicionarioVO>> findDicionarios(@PathVariable(name="modulo") @Nullable String modulo, @Parameter(hidden=true) @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.logger.debug("findDicionarios({},{})", (Object)usuario.getLogin(), (Object)modulo);
            TipoModulo tipoModulo = TipoModulo.fromSigla((String)modulo);
            List dicionario = this.coreService.loadDicionario(tipoModulo);
            ResponseEntity responseEntity = ResponseEntity.ok().body((Object)dicionario);
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.findDicionarios", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/dicionarios/{modulo}/{entidade}"})
    @Operation(summary="Retorna o dicion\u00e1rio do m\u00f3dulo informado")
    @NotNull
    public ResponseEntity<Collection<DicionarioPropertyVO>> findEntidadeDicionario(@PathVariable(name="modulo") @Nullable String modulo, @PathVariable(name="entidade") @NotNull String entidade, @Parameter(hidden=true) @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)entidade, (String)"entidade");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            Object[] objectArray = new Object[]{usuario.getLogin(), modulo, entidade};
            this.logger.debug("findEntidadeDicionario({},{}, {})", objectArray);
            TipoModulo tipoModulo = TipoModulo.fromSigla((String)modulo);
            Map dicionario = this.coreService.loadEntidadeDicionario(tipoModulo, entidade);
            if (dicionario == null || dicionario.isEmpty()) {
                HttpStatusCode httpStatusCode = (HttpStatusCode)HttpStatus.BAD_REQUEST;
                String string = "N\u00e3o h\u00e1 dicion\u00e1rio para o m\u00f3dulo '%s' e entidade '%s'";
                Object[] objectArray2 = new Object[]{modulo, entidade};
                String string2 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                throw new ResponseStatusException(httpStatusCode, string2);
            }
            ResponseEntity responseEntity = ResponseEntity.ok().body(dicionario.values());
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.findEntidadeDicionario", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/planilhas/preprocessar"})
    @NotNull
    public BaseImportHelper.PreProcessResult preProcessarPlanilhas(@RequestPart(value="file") @NotNull MultipartFile file, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.getUsuarioByJWT(request) == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        BaseImportHelper.PreProcessResult preProcessResult = new BaseImportHelper().preProcess(file.getInputStream());
        Intrinsics.checkNotNullExpressionValue((Object)preProcessResult, (String)"preProcess(...)");
        return preProcessResult;
    }

    @GetMapping(value={"/configuracoes/{modulo}"})
    @Operation(summary="Retorna a configura\u00e7\u00e3o de interface definida")
    @NotNull
    public ResponseEntity<ConfiguracaoInterfaceVO> findConfiguracoesInterfaces(@PathVariable(name="modulo") @NotNull String modulo, @Parameter(hidden=true) @NotNull HttpServletRequest request, @Parameter(required=false) @Nullable String nomeInterface, @Parameter(required=false) @Nullable String fluxoInterface) {
        Intrinsics.checkNotNullParameter((Object)modulo, (String)"modulo");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            Object[] objectArray = new Object[]{usuario.getLogin(), modulo, nomeInterface, fluxoInterface};
            this.logger.debug("findConfiguracoesInterfaces({},{},{},{})", objectArray);
            ResponseEntity responseEntity = ResponseEntity.ok().body((Object)this.coreService.findConfiguracoesInterfaces(modulo, nomeInterface, fluxoInterface));
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.findConfiguracoesInterfaces", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

