/*
 * Decompiled with CFR 0.152.
 */
package br.com.sigescantt.apis;

import br.com.sigescantt.apis.BaseRestService;
import br.com.sigescantt.core.beans.geral.Empresa;
import br.com.sigescantt.core.beans.geral.TipoModulo;
import br.com.sigescantt.core.beans.seguranca.PublicUser;
import br.com.sigescantt.core.dto.relacoes.FindRegistrosInformacoesDTO;
import br.com.sigescantt.core.dto.relacoes.FindRegistrosReunioesDTO;
import br.com.sigescantt.exceptions.BusinessException;
import br.com.sigescantt.geral.CalendarioEvento;
import br.com.sigescantt.geral.EmpresaArea;
import br.com.sigescantt.obrigacoes.ObrigacaoContratual;
import br.com.sigescantt.obrigacoes.ObrigacaoLancamento;
import br.com.sigescantt.obrigacoes.TipoPeriodicidade;
import br.com.sigescantt.obrigacoes.TipoStatusLancamentoObrigacao;
import br.com.sigescantt.relacoes.RegistroInformacao;
import br.com.sigescantt.relacoes.RegistroReuniao;
import br.com.sigescantt.services.CoreService;
import br.com.sigescantt.services.ObrigacaoService;
import br.com.sigescantt.services.SegurancaService;
import br.com.sigescantt.services.empresa.EmpresaService;
import br.com.sigescantt.services.relacoes.RelacaoInstitucionalService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(name="calend\u00e1rios", description="REST Services para calend\u00e1rios")
@RequestMapping(value={"/api/calendarios"})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\b\u0017\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0099\u0001\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u00112\b\b\u0001\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u0016\u001a\u00020\u00152\n\b\u0001\u0010\u0017\u001a\u0004\u0018\u00010\u00152\n\b\u0001\u0010\u0018\u001a\u0004\u0018\u00010\u00192\n\b\u0001\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\n\b\u0001\u0010\u001d\u001a\u0004\u0018\u00010\u00152\n\b\u0001\u0010\u001e\u001a\u0004\u0018\u00010\u00192\n\b\u0001\u0010\u001f\u001a\u0004\u0018\u00010\u00152\n\b\u0001\u0010 \u001a\u0004\u0018\u00010\u00152\n\b\u0001\u0010!\u001a\u0004\u0018\u00010\"H\u0017\u00a2\u0006\u0002\u0010#Je\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010%\u001a\u00020\u00192\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00190\u00122\b\u0010'\u001a\u0004\u0018\u00010\u00192\b\u0010(\u001a\u0004\u0018\u00010\u00152\b\u0010\u001f\u001a\u0004\u0018\u00010\u0015H\u0012\u00a2\u0006\u0002\u0010)J4\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010%\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0015H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lbr/com/sigescantt/apis/CalendariosRestServices;", "Lbr/com/sigescantt/apis/BaseRestService;", "segurancaService", "Lbr/com/sigescantt/services/SegurancaService;", "coreService", "Lbr/com/sigescantt/services/CoreService;", "obrigacaoService", "Lbr/com/sigescantt/services/ObrigacaoService;", "relacaoInstitucionalService", "Lbr/com/sigescantt/services/relacoes/RelacaoInstitucionalService;", "empresaService", "Lbr/com/sigescantt/services/empresa/EmpresaService;", "<init>", "(Lbr/com/sigescantt/services/SegurancaService;Lbr/com/sigescantt/services/CoreService;Lbr/com/sigescantt/services/ObrigacaoService;Lbr/com/sigescantt/services/relacoes/RelacaoInstitucionalService;Lbr/com/sigescantt/services/empresa/EmpresaService;)V", "logger", "Lorg/slf4j/Logger;", "findEventosCalendario", "Lorg/springframework/http/ResponseEntity;", "", "Lbr/com/sigescantt/geral/CalendarioEvento;", "empresa", "", "modulo", "areas", "idTipoDocumento", "", "dataInicial", "Ljava/time/LocalDate;", "dataFinal", "entidades", "statusObrigacoes", "periodicidade", "statusLancamentos", "request", "Ljakarta/servlet/http/HttpServletRequest;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/time/LocalDate;Ljava/time/LocalDate;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;Ljakarta/servlet/http/HttpServletRequest;)Lorg/springframework/http/ResponseEntity;", "loadEventosObrigacoes", "idEmpresa", "areasId", "statusObrigacao", "statusLancamento", "(ILjava/lang/Integer;Ljava/time/LocalDate;Ljava/time/LocalDate;Ljava/util/List;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;)Ljava/util/List;", "loadEventosRelacoes", "server"})
@SourceDebugExtension(value={"SMAP\nCalendariosRestServices.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CalendariosRestServices.kt\nbr/com/sigescantt/apis/CalendariosRestServices\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,392:1\n739#2,9:393\n739#2,9:429\n37#3:402\n36#3,3:403\n37#3:438\n36#3,3:439\n108#4:406\n80#4,22:407\n108#4:442\n80#4,22:443\n*S KotlinDebug\n*F\n+ 1 CalendariosRestServices.kt\nbr/com/sigescantt/apis/CalendariosRestServices\n*L\n121#1:393,9\n310#1:429,9\n121#1:402\n121#1:403,3\n311#1:438\n311#1:439,3\n125#1:406\n125#1:407,22\n311#1:442\n311#1:443,22\n*E\n"})
public class CalendariosRestServices
extends BaseRestService {
    @NotNull
    private final SegurancaService segurancaService;
    @NotNull
    private final CoreService coreService;
    @NotNull
    private final ObrigacaoService obrigacaoService;
    @NotNull
    private final RelacaoInstitucionalService relacaoInstitucionalService;
    @NotNull
    private final EmpresaService empresaService;
    @NotNull
    private final Logger logger;

    public CalendariosRestServices(@NotNull SegurancaService segurancaService, @NotNull CoreService coreService, @NotNull ObrigacaoService obrigacaoService, @NotNull RelacaoInstitucionalService relacaoInstitucionalService, @NotNull EmpresaService empresaService) {
        Intrinsics.checkNotNullParameter((Object)segurancaService, (String)"segurancaService");
        Intrinsics.checkNotNullParameter((Object)coreService, (String)"coreService");
        Intrinsics.checkNotNullParameter((Object)obrigacaoService, (String)"obrigacaoService");
        Intrinsics.checkNotNullParameter((Object)relacaoInstitucionalService, (String)"relacaoInstitucionalService");
        Intrinsics.checkNotNullParameter((Object)empresaService, (String)"empresaService");
        super(segurancaService);
        this.segurancaService = segurancaService;
        this.coreService = coreService;
        this.obrigacaoService = obrigacaoService;
        this.relacaoInstitucionalService = relacaoInstitucionalService;
        this.empresaService = empresaService;
        Logger logger = LoggerFactory.getLogger(CalendariosRestServices.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"/{empresa}/eventos/{modulo}"})
    @Operation(summary="Retorna os eventos do(s) m\u00f3dulo(s) selecionado(s).", description="Recupera eventos de calend\u00e1rio filtrados por empresa, m\u00f3dulo e outros crit\u00e9rios opcionais. Permite filtrar por datas, \u00e1reas, tipos de documento, status e outros par\u00e2metros espec\u00edficos de cada m\u00f3dulo. Os eventos s\u00e3o retornados em ordem cronol\u00f3gica e incluem informa\u00e7\u00f5es detalhadas como t\u00edtulo, descri\u00e7\u00e3o, data, status e outras informa\u00e7\u00f5es relevantes para cada tipo de evento.")
    @ApiResponses(value={@ApiResponse(description="Eventos recuperados com sucesso", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<List<CalendarioEvento>> findEventosCalendario(@Parameter(description="Sigla da empresa para filtrar eventos") @PathVariable(value="empresa") @NotNull String empresa, @Parameter(description="M\u00f3dulo para filtrar eventos (OBRIGACOES, RELACOES_INSTITUCIONAIS, etc)") @PathVariable(value="modulo") @NotNull String modulo, @Parameter(description="Lista de IDs de \u00e1reas separados por v\u00edrgula para filtrar eventos") @RequestParam(name="areas", required=false) @Nullable String areas, @Parameter(description="ID do tipo de documento para filtrar eventos") @RequestParam(name="idTipoDocumento", required=false) @Nullable Integer idTipoDocumento, @Parameter(description="Data inicial para filtro de eventos (formato ISO: yyyy-MM-dd)") @RequestParam(name="dataInicial", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) @Nullable LocalDate dataInicial, @Parameter(description="Data final para filtro de eventos (formato ISO: yyyy-MM-dd)") @RequestParam(name="dataFinal", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) @Nullable LocalDate dataFinal, @Parameter(description="Lista de IDs de entidades separados por v\u00edrgula para filtrar eventos de rela\u00e7\u00f5es institucionais") @RequestParam(name="entidades", required=false) @Nullable String entidades, @Parameter(description="Status das obriga\u00e7\u00f5es para filtrar eventos") @RequestParam(name="statusObrigacoes", required=false) @Nullable Integer statusObrigacoes, @Parameter(description="Periodicidade das obriga\u00e7\u00f5es (c\u00f3digos conforme TipoPeriodicidade)") @RequestParam(name="periodicidade", required=false) @Nullable String periodicidade, @Parameter(description="Status dos lan\u00e7amentos (P=Pendente, A=Integrado, E=Encerrado)") @RequestParam(name="statusLancamentos", required=false) @Nullable String statusLancamentos, @Parameter(hidden=true) @Nullable HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)modulo, (String)"modulo");
        HttpServletRequest httpServletRequest = request;
        Intrinsics.checkNotNull((Object)httpServletRequest);
        PublicUser publicUser = this.getUsuarioByJWT(httpServletRequest);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            ArrayList eventos = new ArrayList();
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            ArrayList<Integer> areasId = new ArrayList<Integer>();
            if (areas != null && !(((CharSequence)areas).length() == 0)) {
                void $this$toTypedArray$iv;
                List list;
                Collection $this$dropLastWhile$iv;
                Object object = areas;
                Regex regex = new Regex(",");
                int n = 0;
                object = regex.split((CharSequence)object, n);
                boolean $i$f$dropLastWhile = false;
                if (!$this$dropLastWhile$iv.isEmpty()) {
                    ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        String it = (String)iterator$iv.previous();
                        boolean bl = false;
                        if (((CharSequence)it).length() == 0) continue;
                        list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    list = CollectionsKt.emptyList();
                }
                $this$dropLastWhile$iv = list;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                String[] areasTxt = thisCollection$iv.toArray(new String[0]);
                List areasLst = this.empresaService.findAreasByEmpresa(emp.getId(), Boolean.valueOf(false), null);
                block3: for (String areaId : areasTxt) {
                    for (EmpresaArea area : areasLst) {
                        String $this$trim$iv = areaId;
                        boolean $i$f$trim = false;
                        CharSequence $this$trim$iv$iv = $this$trim$iv;
                        boolean $i$f$trim2 = false;
                        int startIndex$iv$iv = 0;
                        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                        boolean startFound$iv$iv = false;
                        while (startIndex$iv$iv <= endIndex$iv$iv) {
                            boolean match$iv$iv;
                            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                            char it = $this$trim$iv$iv.charAt(index$iv$iv);
                            boolean bl = false;
                            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                            if (!startFound$iv$iv) {
                                if (!match$iv$iv) {
                                    startFound$iv$iv = true;
                                    continue;
                                }
                                ++startIndex$iv$iv;
                                continue;
                            }
                            if (!match$iv$iv) break;
                            --endIndex$iv$iv;
                        }
                        if (!Intrinsics.areEqual((Object)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString(), (Object)String.valueOf(area.getId()))) continue;
                        Integer n2 = area.getId();
                        Intrinsics.checkNotNull((Object)n2);
                        areasId.add(n2);
                        continue block3;
                    }
                }
            }
            if (Intrinsics.areEqual((Object)modulo, (Object)TipoModulo.OBRIGACOES.getSigla())) {
                Integer n = emp.getId();
                Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
                eventos.addAll(this.loadEventosObrigacoes(((Number)n).intValue(), idTipoDocumento, dataInicial, dataFinal, (List)areasId, statusObrigacoes, statusLancamentos, periodicidade));
            }
            if (Intrinsics.areEqual((Object)modulo, (Object)TipoModulo.RELACOES_INSTITUCIONAIS.getSigla())) {
                Integer n = emp.getId();
                Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
                eventos.addAll(this.loadEventosRelacoes(((Number)n).intValue(), dataInicial, dataFinal, entidades));
            }
            return new ResponseEntity(eventos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("findEventos", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private List<CalendarioEvento> loadEventosObrigacoes(int idEmpresa, Integer idTipoDocumento, LocalDate dataInicial, LocalDate dataFinal, List<Integer> areasId, Integer statusObrigacao, String statusLancamento, String periodicidade) {
        ArrayList<CalendarioEvento> eventos;
        block24: {
            Integer statusObrigacao2 = statusObrigacao;
            List empresasInt = new ArrayList();
            empresasInt.add(idEmpresa);
            LocalDate hoje = LocalDate.now();
            if (statusLancamento != null) {
                int n = -1;
                switch (statusLancamento.hashCode()) {
                    case 80: {
                        if (!statusLancamento.equals("P")) break;
                        n = 1;
                        break;
                    }
                    case 65: {
                        if (!statusLancamento.equals("A")) break;
                        n = 2;
                        break;
                    }
                    case 69: {
                        if (!statusLancamento.equals("E")) break;
                        n = 3;
                        break;
                    }
                }
                switch (n) {
                    case 1: {
                        statusObrigacao2 = TipoStatusLancamentoObrigacao.PENDENTE.getCode();
                        break;
                    }
                    case 2: {
                        statusObrigacao2 = TipoStatusLancamentoObrigacao.INTEGRADO.getCode();
                        break;
                    }
                    case 3: {
                        statusObrigacao2 = TipoStatusLancamentoObrigacao.ENCERRADO.getCode();
                        break;
                    }
                }
            }
            List obrigacoesDB = this.obrigacaoService.findLancamentosByFiltro(empresasInt, null, areasId, idTipoDocumento, statusObrigacao2, null, null, dataInicial, dataFinal, periodicidade, null, null, Boolean.valueOf(false));
            eventos = new ArrayList<CalendarioEvento>();
            if (obrigacoesDB == null) break block24;
            for (ObrigacaoLancamento lcto : obrigacoesDB) {
                CalendarioEvento evento;
                block23: {
                    block26: {
                        block25: {
                            ObrigacaoContratual obrigacao = lcto.getObrigacao();
                            if (((Object)obrigacao.getPeriodicidade()).equals(TipoPeriodicidade.EVENTUAL.getCode())) continue;
                            evento = new CalendarioEvento();
                            evento.setId(lcto.getId().getIdObrigacao().toString());
                            evento.setIdEmpresa(lcto.getId().getIdEmpresa());
                            evento.setSequencia(lcto.getId().getSequencia());
                            evento.setTitulo(obrigacao.getNome());
                            evento.setDescricao(obrigacao.getDescricao());
                            if (obrigacao.getClassificacao() != null) {
                                evento.setTipoDocumento(obrigacao.getClassificacao().getDescricao());
                            }
                            evento.setData(lcto.getDatObrigacao());
                            if (lcto.getDatEncerramento() != null) {
                                evento.setDatConclusao(lcto.getDatEncerramento().toLocalDate());
                            }
                            evento.setStatus(lcto.getStatus());
                            evento.setStatusDesc(lcto.getStatusDesc());
                            if (lcto.getDatExecucao() == null) {
                                evento.setPrazo(Integer.valueOf(lcto.getDatObrigacao().compareTo(hoje)));
                            } else {
                                evento.setPrazo(Integer.valueOf(lcto.getDatObrigacao().compareTo(lcto.getDatExecucao())));
                            }
                            if (!((Object)lcto.getStatus()).equals(TipoStatusLancamentoObrigacao.PENDENTE.getCode())) break block25;
                            Integer n = evento.getPrazo();
                            if (n == null || n != 0) break block25;
                            evento.setStatusPrazoDesc("Obriga\u00e7\u00e3o na data atual");
                            break block23;
                        }
                        if (((Object)lcto.getStatus()).equals(TipoStatusLancamentoObrigacao.ENCERRADO.getCode()) || ((Object)lcto.getStatus()).equals(TipoStatusLancamentoObrigacao.PROTOCOLADO.getCode())) break block26;
                        if (evento.getPrazo() >= 0) {
                            if (((Object)lcto.getStatus()).equals(TipoStatusLancamentoObrigacao.INTEGRADO.getCode())) {
                                evento.setStatusPrazoDesc("Obriga\u00e7\u00e3o inclu\u00edda em correspond\u00eancia");
                                break block23;
                            } else {
                                evento.setStatusPrazoDesc("Obriga\u00e7\u00e3o em aberto, pendente");
                            }
                            break block23;
                        } else {
                            evento.setStatusPrazoDesc("Obriga\u00e7\u00e3o em atraso");
                        }
                        break block23;
                    }
                    if (evento.getPrazo() >= 0) {
                        evento.setStatusPrazoDesc("Obriga\u00e7\u00e3o encerrada no prazo");
                    } else {
                        evento.setStatusPrazoDesc("Obriga\u00e7\u00e3o encerrada com atraso");
                    }
                }
                if (lcto.getIdCorrespondencia() != null) {
                    evento.setReferencia(lcto.getIdCorrespondencia().toString());
                    evento.setReferenciaDesc(lcto.getCorrespondencia().getAssunto());
                }
                eventos.add(evento);
            }
        }
        return eventos;
    }

    /*
     * WARNING - void declaration
     */
    private List<CalendarioEvento> loadEventosRelacoes(int idEmpresa, LocalDate dataInicial, LocalDate dataFinal, String entidades) {
        Page informacoesDB;
        List empresasInt = new ArrayList();
        empresasInt.add(idEmpresa);
        Integer idArea = null;
        Integer idResponsavel = null;
        List entidadesLst = null;
        if (entidades != null && !(((CharSequence)entidades).length() == 0)) {
            void $this$toTypedArray$iv2;
            List list;
            String it;
            Collection $this$dropLastWhile$iv;
            entidadesLst = new ArrayList();
            Object object = entidades;
            Regex regex = new Regex(",");
            int n = 0;
            object = regex.split((CharSequence)object, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    it = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            $this$dropLastWhile$iv = list;
            int $i$f$toTypedArray = 0;
            void thisCollection$iv = $this$toTypedArray$iv2;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            $i$f$toTypedArray = stringArray.length;
            for (int $this$toTypedArray$iv2 = 0; $this$toTypedArray$iv2 < $i$f$toTypedArray; ++$this$toTypedArray$iv2) {
                void $this$trim$iv;
                String entidade;
                it = entidade = stringArray[$this$toTypedArray$iv2];
                ArrayList arrayList = (ArrayList)entidadesLst;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it2 = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it2, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                arrayList.add(Integer.parseInt(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()));
            }
        }
        ArrayList<CalendarioEvento> eventos = new ArrayList<CalendarioEvento>();
        Page reunioesDB = this.relacaoInstitucionalService.findRegistrosReunioes(new FindRegistrosReunioesDTO(empresasInt, null, idArea, entidadesLst, null, dataInicial, dataFinal, idResponsavel), Pageable.unpaged());
        if (reunioesDB != null) {
            for (RegistroReuniao reuniao : reunioesDB) {
                CalendarioEvento evento = new CalendarioEvento();
                evento.setId(reuniao.getId().getIdRegistro().toString());
                evento.setIdEmpresa(reuniao.getId().getIdEmpresa());
                evento.setTitulo(reuniao.getAssunto());
                evento.setDescricao(reuniao.getObservacao());
                evento.setData(reuniao.getDataInteracao());
                evento.setHoraInicial(reuniao.getInicio());
                evento.setHoraFinal(reuniao.getTermino());
                if (reuniao.getUsuario() != null) {
                    evento.setNome(reuniao.getUsuario().getNome());
                }
                evento.setLocal(reuniao.getLocal());
                evento.setStatus(reuniao.getStatus());
                evento.setModulo(TipoModulo.RELACOES_INSTITUCIONAIS.getSigla());
                evento.setModuloItem("Reuni\u00e3o");
                eventos.add(evento);
            }
        }
        if ((informacoesDB = this.relacaoInstitucionalService.findRegistrosInformacoes(new FindRegistrosInformacoesDTO(empresasInt, null, idArea, entidadesLst, dataInicial, dataFinal, idResponsavel), Pageable.unpaged())) != null) {
            for (RegistroInformacao informacao : informacoesDB) {
                CalendarioEvento evento = new CalendarioEvento();
                evento.setId(informacao.getId().toString());
                evento.setIdEmpresa(informacao.getIdEmpresa());
                evento.setNome(informacao.getNomeStakeholder());
                evento.setTitulo(informacao.getAssunto());
                evento.setDescricao(informacao.getObservacao());
                evento.setData(informacao.getDataInformacao());
                evento.setModulo(TipoModulo.RELACOES_INSTITUCIONAIS.getSigla());
                evento.setModuloItem("Informa\u00e7\u00e3o");
                eventos.add(evento);
            }
        }
        return eventos;
    }
}

