/*
 * Decompiled with CFR 0.152.
 */
package br.com.sigescantt.apis;

import br.com.sigescantt.apis.BaseRestService;
import br.com.sigescantt.core.beans.geral.Empresa;
import br.com.sigescantt.core.beans.seguranca.PublicUser;
import br.com.sigescantt.core.beans.seguranca.Usuario;
import br.com.sigescantt.core.dto.ativos.SaveTipoElementoDTO;
import br.com.sigescantt.exceptions.BusinessException;
import br.com.sigescantt.ged.utils.UploadedFileInfo;
import br.com.sigescantt.services.CadastroService;
import br.com.sigescantt.services.CoreService;
import br.com.sigescantt.services.Exceptions.ErrorCode;
import br.com.sigescantt.services.Exceptions.ErrorCodeException;
import br.com.sigescantt.services.GedService;
import br.com.sigescantt.services.SegurancaService;
import br.com.sigescantt.services.ativos.SigacoService;
import br.com.sigescantt.sigaco.ElementoDrenagem;
import br.com.sigescantt.sigaco.ElementoSigaco;
import br.com.sigescantt.sigaco.ElementoSinalizacao;
import br.com.sigescantt.sigaco.FaseMonitoracao;
import br.com.sigescantt.sigaco.FaseMonitoracaoAnexo;
import br.com.sigescantt.sigaco.TipoElemento;
import br.com.sigescantt.sigaco.enums.TipoAtivo;
import br.com.sigescantt.sigaco.enums.TipoStatusElemento;
import br.com.sigescantt.utils.KilometerUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Validated
@Tag(name="sigaco", description="REST Services para Cadastros do Sigaco")
@RequestMapping(value={"/api/cadastros/sigaco"})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0018\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\b\b\u0001\u0010 \u001a\u00020!H\u0017J$\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001f0#2\b\b\u0001\u0010$\u001a\u00020%2\n\b\u0001\u0010 \u001a\u0004\u0018\u00010!H\u0017J&\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001f0#2\n\b\u0001\u0010'\u001a\u0004\u0018\u00010\u001f2\n\b\u0001\u0010 \u001a\u0004\u0018\u00010!H\u0017J$\u0010(\u001a\b\u0012\u0004\u0012\u00020)0#2\b\b\u0001\u0010$\u001a\u00020%2\n\b\u0001\u0010 \u001a\u0004\u0018\u00010!H\u0017J4\u0010*\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020+0\u001e0#2\n\b\u0001\u0010,\u001a\u0004\u0018\u00010-2\b\b\u0001\u0010.\u001a\u00020/2\b\b\u0001\u0010 \u001a\u00020!H\u0017JA\u00100\u001a\b\u0012\u0004\u0012\u00020+0#2\n\b\u0001\u0010,\u001a\u0004\u0018\u00010-2\b\b\u0001\u0010.\u001a\u00020/2\n\b\u0001\u00101\u001a\u0004\u0018\u00010%2\n\b\u0001\u0010 \u001a\u0004\u0018\u00010!H\u0017\u00a2\u0006\u0002\u00102J2\u00103\u001a\b\u0012\u0004\u0012\u00020+0#2\n\b\u0001\u0010,\u001a\u0004\u0018\u00010-2\n\b\u0001\u00104\u001a\u0004\u0018\u0001052\n\b\u0001\u0010 \u001a\u0004\u0018\u00010!H\u0017J2\u00103\u001a\b\u0012\u0004\u0012\u00020+0#2\n\b\u0001\u0010,\u001a\u0004\u0018\u00010-2\n\b\u0001\u00104\u001a\u0004\u0018\u0001062\n\b\u0001\u0010 \u001a\u0004\u0018\u00010!H\u0017JA\u00107\u001a\b\u0012\u0004\u0012\u0002080#2\n\b\u0001\u0010,\u001a\u0004\u0018\u00010-2\n\b\u0001\u00101\u001a\u0004\u0018\u00010%2\b\b\u0001\u0010.\u001a\u00020/2\n\b\u0001\u0010 \u001a\u0004\u0018\u00010!H\u0017\u00a2\u0006\u0002\u00109J.\u0010:\u001a\b\u0012\u0004\u0012\u00020;0\u001e2\b\b\u0001\u0010,\u001a\u00020-2\n\b\u0001\u0010<\u001a\u0004\u0018\u00010-2\b\b\u0001\u0010 \u001a\u00020!H\u0017J7\u0010=\u001a\b\u0012\u0004\u0012\u00020;0#2\n\b\u0001\u0010,\u001a\u0004\u0018\u00010-2\n\b\u0001\u0010>\u001a\u0004\u0018\u00010%2\n\b\u0001\u0010 \u001a\u0004\u0018\u00010!H\u0017\u00a2\u0006\u0002\u0010?J0\u0010@\u001a\b\u0012\u0004\u0012\u00020;0#2\n\b\u0001\u0010,\u001a\u0004\u0018\u00010-2\b\b\u0001\u0010A\u001a\u00020;2\n\b\u0001\u0010 \u001a\u0004\u0018\u00010!H\u0017J+\u0010B\u001a\b\u0012\u0004\u0012\u0002080#2\n\b\u0001\u0010>\u001a\u0004\u0018\u00010%2\n\b\u0001\u0010 \u001a\u0004\u0018\u00010!H\u0017\u00a2\u0006\u0002\u0010CJ3\u0010D\u001a\b\u0012\u0004\u0012\u00020E0\u001e2\n\b\u0001\u0010,\u001a\u0004\u0018\u00010-2\n\b\u0001\u0010>\u001a\u0004\u0018\u00010%2\u0006\u0010 \u001a\u00020!H\u0017\u00a2\u0006\u0002\u0010FJC\u0010G\u001a\b\u0012\u0004\u0012\u00020E0#2\n\b\u0001\u0010,\u001a\u0004\u0018\u00010-2\n\b\u0001\u0010>\u001a\u0004\u0018\u00010%2\n\b\u0001\u0010H\u001a\u0004\u0018\u00010%2\n\b\u0001\u0010 \u001a\u0004\u0018\u00010!H\u0017\u00a2\u0006\u0002\u0010IJ?\u0010J\u001a\b\u0012\u0004\u0012\u00020E0#2\b\b\u0001\u0010 \u001a\u00020!2\n\b\u0001\u0010,\u001a\u0004\u0018\u00010-2\n\b\u0001\u0010>\u001a\u0004\u0018\u00010%2\b\b\u0001\u0010K\u001a\u00020LH\u0017\u00a2\u0006\u0002\u0010MJC\u0010N\u001a\b\u0012\u0004\u0012\u0002080#2\n\b\u0001\u0010,\u001a\u0004\u0018\u00010-2\n\b\u0001\u0010>\u001a\u0004\u0018\u00010%2\n\b\u0001\u0010H\u001a\u0004\u0018\u00010%2\n\b\u0001\u0010 \u001a\u0004\u0018\u00010!H\u0017\u00a2\u0006\u0002\u0010IJ6\u0010O\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020P0\u001e0#2\b\b\u0001\u0010 \u001a\u00020!2\n\b\u0001\u0010,\u001a\u0004\u0018\u00010-2\n\b\u0001\u0010.\u001a\u0004\u0018\u00010/H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013\u00a2\u0006\n\n\u0002\u0010\u0017\u001a\u0004\b\u0015\u0010\u0016R\u001b\u0010\u0018\u001a\n \u0014*\u0004\u0018\u00010\u00190\u0019\u00a2\u0006\n\n\u0002\u0010\u001c\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006Q"}, d2={"Lbr/com/sigescantt/apis/CadastrosSigacoRestServices;", "Lbr/com/sigescantt/apis/BaseRestService;", "segurancaService", "Lbr/com/sigescantt/services/SegurancaService;", "coreService", "Lbr/com/sigescantt/services/CoreService;", "cadastroService", "Lbr/com/sigescantt/services/CadastroService;", "sigacoService", "Lbr/com/sigescantt/services/ativos/SigacoService;", "gedService", "Lbr/com/sigescantt/services/GedService;", "<init>", "(Lbr/com/sigescantt/services/SegurancaService;Lbr/com/sigescantt/services/CoreService;Lbr/com/sigescantt/services/CadastroService;Lbr/com/sigescantt/services/ativos/SigacoService;Lbr/com/sigescantt/services/GedService;)V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "ptBR", "Ljava/util/Locale;", "kotlin.jvm.PlatformType", "getPtBR", "()Ljava/util/Locale;", "Ljava/util/Locale;", "fmtPtBr", "Ljava/text/NumberFormat;", "getFmtPtBr", "()Ljava/text/NumberFormat;", "Ljava/text/NumberFormat;", "findTiposElementos", "", "Lbr/com/sigescantt/sigaco/TipoElemento;", "request", "Ljakarta/servlet/http/HttpServletRequest;", "getCategoriaById", "Lorg/springframework/http/ResponseEntity;", "idCategoria", "", "saveCategoria", "categoria", "deleteCategoria", "Ljava/lang/Void;", "findElementos", "Lbr/com/sigescantt/sigaco/ElementoSigaco;", "empresa", "", "tipoAtivo", "Lbr/com/sigescantt/sigaco/enums/TipoAtivo;", "getElementoById", "idElemento", "(Ljava/lang/String;Lbr/com/sigescantt/sigaco/enums/TipoAtivo;Ljava/lang/Integer;Ljakarta/servlet/http/HttpServletRequest;)Lorg/springframework/http/ResponseEntity;", "saveElemento", "elemento", "Lbr/com/sigescantt/sigaco/ElementoDrenagem;", "Lbr/com/sigescantt/sigaco/ElementoSinalizacao;", "deleteElemento", "", "(Ljava/lang/String;Ljava/lang/Integer;Lbr/com/sigescantt/sigaco/enums/TipoAtivo;Ljakarta/servlet/http/HttpServletRequest;)Lorg/springframework/http/ResponseEntity;", "findFases", "Lbr/com/sigescantt/sigaco/FaseMonitoracao;", "search", "getFaseById", "idFase", "(Ljava/lang/String;Ljava/lang/Integer;Ljakarta/servlet/http/HttpServletRequest;)Lorg/springframework/http/ResponseEntity;", "saveFase", "fase", "deleteFase", "(Ljava/lang/Integer;Ljakarta/servlet/http/HttpServletRequest;)Lorg/springframework/http/ResponseEntity;", "findAnexosFase", "Lbr/com/sigescantt/sigaco/FaseMonitoracaoAnexo;", "(Ljava/lang/String;Ljava/lang/Integer;Ljakarta/servlet/http/HttpServletRequest;)Ljava/util/List;", "getAnexoFaseById", "idAnexoFase", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;Ljakarta/servlet/http/HttpServletRequest;)Lorg/springframework/http/ResponseEntity;", "saveAnexoFase", "file", "Lorg/springframework/web/multipart/MultipartFile;", "(Ljakarta/servlet/http/HttpServletRequest;Ljava/lang/String;Ljava/lang/Integer;Lorg/springframework/web/multipart/MultipartFile;)Lorg/springframework/http/ResponseEntity;", "deleteAnexoFase", "downloadRelatorioFases", "Lbr/com/sigescantt/ged/utils/UploadedFileInfo;", "server"})
public class CadastrosSigacoRestServices
extends BaseRestService {
    @NotNull
    private final SegurancaService segurancaService;
    @NotNull
    private final CoreService coreService;
    @NotNull
    private final CadastroService cadastroService;
    @NotNull
    private final SigacoService sigacoService;
    @NotNull
    private final GedService gedService;
    @NotNull
    private final Logger logger;
    private final Locale ptBR;
    private final NumberFormat fmtPtBr;

    public CadastrosSigacoRestServices(@NotNull SegurancaService segurancaService, @NotNull CoreService coreService, @NotNull CadastroService cadastroService, @NotNull SigacoService sigacoService, @NotNull GedService gedService) {
        Intrinsics.checkNotNullParameter((Object)segurancaService, (String)"segurancaService");
        Intrinsics.checkNotNullParameter((Object)coreService, (String)"coreService");
        Intrinsics.checkNotNullParameter((Object)cadastroService, (String)"cadastroService");
        Intrinsics.checkNotNullParameter((Object)sigacoService, (String)"sigacoService");
        Intrinsics.checkNotNullParameter((Object)gedService, (String)"gedService");
        super(segurancaService);
        this.segurancaService = segurancaService;
        this.coreService = coreService;
        this.cadastroService = cadastroService;
        this.sigacoService = sigacoService;
        this.gedService = gedService;
        Logger logger = LoggerFactory.getLogger(CadastrosSigacoRestServices.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
        this.ptBR = new Locale.Builder().setLanguage("pt").setRegion("BR").build();
        this.fmtPtBr = DecimalFormat.getNumberInstance(this.ptBR);
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    public final Locale getPtBR() {
        return this.ptBR;
    }

    public final NumberFormat getFmtPtBr() {
        return this.fmtPtBr;
    }

    @GetMapping(value={"/tiposElementos"})
    @Operation(summary="Recupera uma lista de tipos de elementos baseada em filtros (search e subsistema).")
    @ApiResponses(value={@ApiResponse(description="Sucesso", responseCode="200", content={@Content(schema=@Schema(implementation=TipoElemento.class))})})
    @NotNull
    public List<TipoElemento> findTiposElementos(@Parameter(hidden=true) @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        String search = null;
        TipoAtivo subsistema = null;
        if (request.getParameter("search") != null) {
            search = request.getParameter("search");
        }
        if (request.getParameter("subsistema") != null) {
            subsistema = TipoAtivo.fromCode((String)request.getParameter("subsistema"));
        }
        List list = this.sigacoService.findTiposElementos(search, subsistema, null, null, null, usuario2, Pageable.unpaged()).getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContent(...)");
        return list;
    }

    @GetMapping(value={"/tiposElementos/{idCategoria}"})
    @Operation(summary="Retorna a categoria com base no seu identificador")
    @ApiResponses(value={@ApiResponse(description="Sucesso", responseCode="200", content={@Content(schema=@Schema(implementation=TipoElemento.class))})})
    @NotNull
    public ResponseEntity<TipoElemento> getCategoriaById(@Parameter(description="Identificador da categoria.") @PathVariable(name="idCategoria") int idCategoria, @Parameter(hidden=true) @Nullable HttpServletRequest request) {
        HttpServletRequest httpServletRequest = request;
        Intrinsics.checkNotNull((Object)httpServletRequest);
        PublicUser publicUser = this.getUsuarioByJWT(httpServletRequest);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.logger.debug("getCategoriaById({})", (Object)idCategoria);
            return new ResponseEntity((Object)this.sigacoService.getTipoElementoById(idCategoria), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.getCategoriaById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/tiposElementos"})
    @Operation(summary="Salva a categoria de ativo.")
    @ApiResponses(value={@ApiResponse(description="Criado", responseCode="201")})
    @NotNull
    public ResponseEntity<TipoElemento> saveCategoria(@RequestBody(description="Dados da categoria de ativo a ser salva.") @org.springframework.web.bind.annotation.RequestBody @Nullable TipoElemento categoria, @Parameter(hidden=true) @Nullable HttpServletRequest request) throws BusinessException {
        HttpServletRequest httpServletRequest = request;
        Intrinsics.checkNotNull((Object)httpServletRequest);
        PublicUser publicUser = this.getUsuarioByJWT(httpServletRequest);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            TipoElemento tipoElemento = categoria;
            if ((tipoElemento != null ? tipoElemento.getId() : null) != null) {
                Integer n = categoria.getId();
                Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
                int n2 = ((Number)n).intValue();
                SaveTipoElementoDTO saveTipoElementoDTO = new SaveTipoElementoDTO(categoria.getSigla(), categoria.getDescricao(), TipoAtivo.fromCode((String)categoria.getTipoAtivo()), categoria.getIdTipoElementoPai(), categoria.getCodigoTipo());
                Integer n3 = usuario.getId();
                Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"getId(...)");
                TipoElemento categoriaDB = this.sigacoService.updateTipoElemento(n2, saveTipoElementoDTO, ((Number)n3).intValue());
                ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.OK)).body((Object)categoriaDB);
                Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
                return responseEntity;
            }
            TipoElemento tipoElemento2 = categoria;
            TipoElemento tipoElemento3 = categoria;
            TipoElemento tipoElemento4 = categoria;
            TipoElemento tipoElemento5 = categoria;
            TipoElemento tipoElemento6 = categoria;
            SaveTipoElementoDTO saveTipoElementoDTO = new SaveTipoElementoDTO(tipoElemento2 != null ? tipoElemento2.getSigla() : null, tipoElemento3 != null ? tipoElemento3.getDescricao() : null, TipoAtivo.fromCode((String)(tipoElemento4 != null ? tipoElemento4.getTipoAtivo() : null)), tipoElemento5 != null ? tipoElemento5.getIdTipoElementoPai() : null, tipoElemento6 != null ? tipoElemento6.getCodigoTipo() : null);
            Integer n = usuario.getId();
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
            TipoElemento categoriaDB = this.sigacoService.createTipoElemento(saveTipoElementoDTO, ((Number)n).intValue());
            ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.CREATED)).body((Object)categoriaDB);
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveCategoria", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/tiposElementos/{idCategoria}"})
    @Operation(summary="Deleta a categoria de ativo conforme seu identificador")
    @ApiResponses(value={@ApiResponse(description="Sucesso - Sem conte\u00fado", responseCode="204")})
    @NotNull
    public ResponseEntity<Void> deleteCategoria(@Parameter(description="Identificador da categoria a ser removida.") @PathVariable(name="idCategoria") int idCategoria, @Parameter(hidden=true) @Nullable HttpServletRequest request) throws BusinessException {
        HttpServletRequest httpServletRequest = request;
        Intrinsics.checkNotNull((Object)httpServletRequest);
        PublicUser publicUser = this.getUsuarioByJWT(httpServletRequest);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.logger.debug("deleteCategoria({})", (Object)idCategoria);
            this.sigacoService.deleteTipoElemento(idCategoria);
            ResponseEntity responseEntity = ResponseEntity.noContent().build();
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"build(...)");
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.deleteCategoria", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/elementos/{tipoAtivo}/all"})
    @Operation(summary="Busca os itens de ativo.")
    @ApiResponses(value={@ApiResponse(description="Sucesso", responseCode="200", content={@Content(schema=@Schema(implementation=ElementoSigaco.class))})})
    @NotNull
    public ResponseEntity<List<ElementoSigaco>> findElementos(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="Tipo de ativo") @PathVariable(name="tipoAtivo") @NotNull TipoAtivo tipoAtivo, @Parameter(hidden=true) @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)tipoAtivo, (String)"tipoAtivo");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Integer idTipoElemento = null;
        Integer idRodovia = null;
        Double kmInicial = null;
        Double kmFinal = null;
        try {
            Double[] kmMetros;
            this.logger.debug("findItens({}, {})", (Object)empresa, (Object)tipoAtivo);
            String search = null;
            if (request.getParameter("search") != null) {
                search = request.getParameter("search");
            }
            if (request.getParameter("tipoElemento") != null) {
                String string = request.getParameter("tipoElemento");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getParameter(...)");
                idTipoElemento = Integer.parseInt(string);
            }
            if (request.getParameter("rodovia") != null) {
                String string = request.getParameter("rodovia");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getParameter(...)");
                idRodovia = Integer.parseInt(string);
            }
            if ((kmMetros = KilometerUtils.stringToKm((String)request.getParameter("kmInicial"))) != null && kmMetros.length > 0) {
                double d = kmMetros[0];
                Double d2 = kmMetros[1];
                Intrinsics.checkNotNullExpressionValue((Object)d2, (String)"get(...)");
                kmInicial = d + ((Number)d2).doubleValue();
            }
            if ((kmMetros = KilometerUtils.stringToKm((String)request.getParameter("kmFinal"))) != null && kmMetros.length > 0) {
                double d = kmMetros[0];
                Double d3 = kmMetros[1];
                Intrinsics.checkNotNullExpressionValue((Object)d3, (String)"get(...)");
                kmFinal = d + ((Number)d3).doubleValue();
            }
            TipoStatusElemento status = TipoStatusElemento.ATIVO;
            if (request.getParameter("status") != null) {
                status = TipoStatusElemento.fromCode((String)request.getParameter("status"));
            }
            TipoStatusElemento tipoStatusElemento = status;
            ResponseEntity responseEntity = ResponseEntity.ok().body((Object)this.sigacoService.findElementos(empresa, search, tipoAtivo, idTipoElemento, CollectionsKt.listOf((Object)idRodovia), kmInicial, kmFinal, tipoStatusElemento != null ? tipoStatusElemento.getSituacao() : null));
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.findItens", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/elementos/{tipoAtivo}/{idElemento}"})
    @Operation(summary="Busca o elemento por seu identificador e empresa.")
    @ApiResponses(value={@ApiResponse(description="Sucesso", responseCode="200", content={@Content(schema=@Schema(implementation=ElementoSigaco.class))})})
    @NotNull
    public ResponseEntity<ElementoSigaco> getElementoById(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="Tipo de ativo") @PathVariable(name="tipoAtivo") @NotNull TipoAtivo tipoAtivo, @Parameter(description="Identificador do elemento") @PathVariable(name="idElemento") @Nullable Integer idElemento, @Parameter(hidden=true) @Nullable HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)tipoAtivo, (String)"tipoAtivo");
        HttpServletRequest httpServletRequest = request;
        Intrinsics.checkNotNull((Object)httpServletRequest);
        PublicUser publicUser = this.getUsuarioByJWT(httpServletRequest);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.logger.debug("getElementoById({})", (Object)idElemento);
            return new ResponseEntity((Object)this.sigacoService.getElementoById(empresa, idElemento, tipoAtivo), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.getElementoById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/elementosDrenagem"})
    @Operation(summary="Salva o Elemento de ativo drenagem.")
    @ApiResponses(value={@ApiResponse(description="Criado", responseCode="201", content={@Content(schema=@Schema(implementation=ElementoSigaco.class))})})
    @NotNull
    public ResponseEntity<ElementoSigaco> saveElemento(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @RequestBody(description="Dados do elemento de drenagem a ser salvo.") @org.springframework.web.bind.annotation.RequestBody @Nullable ElementoDrenagem elemento, @Parameter(hidden=true) @Nullable HttpServletRequest request) throws BusinessException {
        HttpServletRequest httpServletRequest = request;
        Intrinsics.checkNotNull((Object)httpServletRequest);
        PublicUser publicUser = this.getUsuarioByJWT(httpServletRequest);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            ElementoSigaco elementoDB = this.sigacoService.saveElemento(empresa, (ElementoSigaco)elemento, usuario.getLogin());
            ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.CREATED)).body((Object)elementoDB);
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveElemento", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/elementosSinalizacao"})
    @Operation(summary="Salva o Elemento de sinaliza\u00e7\u00e3o [Vert./Horiz./EPS]")
    @ApiResponses(value={@ApiResponse(description="Criado", responseCode="201")})
    @NotNull
    public ResponseEntity<ElementoSigaco> saveElemento(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @RequestBody(description="Dados do elemento de sinaliza\u00e7\u00e3o a ser salvo.") @org.springframework.web.bind.annotation.RequestBody @Nullable ElementoSinalizacao elemento, @Parameter(hidden=true) @Nullable HttpServletRequest request) throws BusinessException {
        HttpServletRequest httpServletRequest = request;
        Intrinsics.checkNotNull((Object)httpServletRequest);
        PublicUser publicUser = this.getUsuarioByJWT(httpServletRequest);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            ElementoSigaco elementoDB = this.sigacoService.saveElemento(empresa, (ElementoSigaco)elemento, usuario.getLogin());
            ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.CREATED)).body((Object)elementoDB);
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveElemento", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/elementos/{tipoAtivo}/{idElemento}"})
    @Operation(summary="Deleta o elemento de ativo de acordo com seu identificador e empresa.")
    @ApiResponses(value={@ApiResponse(description="Sucesso", responseCode="200")})
    @NotNull
    public ResponseEntity<Boolean> deleteElemento(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="Identificador do elemento") @PathVariable(name="idElemento") @Nullable Integer idElemento, @Parameter(description="Tipo de ativo") @PathVariable(name="tipoAtivo") @NotNull TipoAtivo tipoAtivo, @Parameter(hidden=true) @Nullable HttpServletRequest request) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)tipoAtivo, (String)"tipoAtivo");
        HttpServletRequest httpServletRequest = request;
        Intrinsics.checkNotNull((Object)httpServletRequest);
        PublicUser publicUser = this.getUsuarioByJWT(httpServletRequest);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.logger.debug("deleteElemento({})", (Object)idElemento);
            return new ResponseEntity((Object)this.sigacoService.deleteElemento(empresa, idElemento, tipoAtivo), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.deleteElemento", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/fasesMonitoracao"})
    @Operation(summary="Recupera as fases de monitora\u00e7\u00e3o dos ativos, podendo aplicar um filtro via par\u00e2metro 'search'.")
    @ApiResponses(value={@ApiResponse(description="Sucesso", responseCode="200", content={@Content(schema=@Schema(implementation=FaseMonitoracao.class))})})
    @NotNull
    public List<FaseMonitoracao> findFases(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa, @Parameter(description="Par\u00e2metro de busca") @RequestParam(name="search", required=false) @Nullable String search, @Parameter(hidden=true) @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        Usuario usuario2 = usuario;
        List list = this.sigacoService.findFasesMonitoracoes(empresa, search, usuario2, Pageable.unpaged()).getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContent(...)");
        return list;
    }

    @GetMapping(value={"/{empresa}/fasesMonitoracao/{idFase}"})
    @Operation(summary="Busca a fase de monitora\u00e7\u00e3o conforme seu identificador")
    @ApiResponses(value={@ApiResponse(description="Sucesso", responseCode="200", content={@Content(schema=@Schema(implementation=FaseMonitoracao.class))})})
    @NotNull
    public ResponseEntity<FaseMonitoracao> getFaseById(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="Identificador da fase") @PathVariable(name="idFase") @Nullable Integer idFase, @Parameter(hidden=true) @Nullable HttpServletRequest request) {
        HttpServletRequest httpServletRequest = request;
        Intrinsics.checkNotNull((Object)httpServletRequest);
        PublicUser publicUser = this.getUsuarioByJWT(httpServletRequest);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.logger.debug("getFaseById({}, {})", (Object)empresa, (Object)idFase);
            FaseMonitoracao fase = this.sigacoService.getFaseMonitoracaoById(idFase);
            if (fase != null) {
                fase.setResponsaveis(this.sigacoService.findResponsaveisFase(idFase));
            }
            ResponseEntity responseEntity = ResponseEntity.ok().body((Object)fase);
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.getFaseById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/fasesMonitoracao"})
    @Operation(summary="Salva a fase de monitora\u00e7\u00e3o.")
    @ApiResponses(value={@ApiResponse(description="Criado", responseCode="201", content={@Content(schema=@Schema(implementation=FaseMonitoracao.class))})})
    @NotNull
    public ResponseEntity<FaseMonitoracao> saveFase(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @RequestBody(description="Dados da fase a ser salva.") @org.springframework.web.bind.annotation.RequestBody @NotNull FaseMonitoracao fase, @Parameter(hidden=true) @Nullable HttpServletRequest request) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)fase, (String)"fase");
        HttpServletRequest httpServletRequest = request;
        Intrinsics.checkNotNull((Object)httpServletRequest);
        PublicUser publicUser = this.getUsuarioByJWT(httpServletRequest);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            fase.setIdEmpresa(emp.getId());
            FaseMonitoracao faseDB = this.sigacoService.saveFaseMonitoracao(fase, usuario.getLogin());
            return new ResponseEntity((Object)faseDB, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveFase", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/fasesMonitoracao/{idFase}"})
    @Operation(summary="Deleta a fase de monitora\u00e7\u00e3o de acordo com seu identificador")
    @ApiResponses(value={@ApiResponse(description="Sucesso", responseCode="200")})
    @NotNull
    public ResponseEntity<Boolean> deleteFase(@Parameter(description="Identificador da fase a ser removida.") @PathVariable(name="idFase") @Nullable Integer idFase, @Parameter(hidden=true) @Nullable HttpServletRequest request) throws BusinessException {
        HttpServletRequest httpServletRequest = request;
        Intrinsics.checkNotNull((Object)httpServletRequest);
        PublicUser publicUser = this.getUsuarioByJWT(httpServletRequest);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.logger.debug("deleteFase({})", (Object)idFase);
            return new ResponseEntity((Object)this.sigacoService.deleteFaseMonitoracao(idFase), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.deleteFase", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/fasesMonitoracao/{idFase}/anexos"})
    @Operation(summary="Recupera a lista de anexos para a fase especificada.")
    @ApiResponses(value={@ApiResponse(description="Sucesso", responseCode="200", content={@Content(schema=@Schema(implementation=FaseMonitoracaoAnexo.class))})})
    @NotNull
    public List<FaseMonitoracaoAnexo> findAnexosFase(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="Identificador da fase") @PathVariable(name="idFase") @Nullable Integer idFase, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        List list = this.sigacoService.findAnexosFase(empresa, idFase, usuario2, Pageable.unpaged()).getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContent(...)");
        return list;
    }

    @GetMapping(value={"/{empresa}/fasesMonitoracao/{idFase}/anexos/{idAnexoFase}"})
    @Operation(summary="Recupera o anexo da fase conforme seu identificador.")
    @ApiResponses(value={@ApiResponse(description="Sucesso", responseCode="200", content={@Content(schema=@Schema(implementation=FaseMonitoracaoAnexo.class))})})
    @NotNull
    public ResponseEntity<FaseMonitoracaoAnexo> getAnexoFaseById(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="Identificador da fase") @PathVariable(name="idFase") @Nullable Integer idFase, @Parameter(description="Identificador do anexo") @PathVariable(name="idAnexoFase") @Nullable Integer idAnexoFase, @Parameter(hidden=true) @Nullable HttpServletRequest request) {
        HttpServletRequest httpServletRequest = request;
        Intrinsics.checkNotNull((Object)httpServletRequest);
        PublicUser publicUser = this.getUsuarioByJWT(httpServletRequest);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            Object[] objectArray = new Object[]{empresa, idFase, idAnexoFase};
            this.logger.debug("getAnexoFaseById({}, {}, {})", objectArray);
            return new ResponseEntity((Object)this.sigacoService.getAnexoFaseById(empresa, idAnexoFase), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.getAnexoFaseById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/fasesMonitoracao/{idFase}/anexos"}, consumes={"multipart/form-data"})
    @ResponseBody
    @Operation(summary="Salva o anexo para a fase informada.")
    @ApiResponses(value={@ApiResponse(description="Criado", responseCode="201", content={@Content(schema=@Schema(implementation=FaseMonitoracaoAnexo.class))})})
    @NotNull
    public ResponseEntity<FaseMonitoracaoAnexo> saveAnexoFase(@Parameter(hidden=true) @NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="Identificador da fase") @PathVariable(name="idFase") @Nullable Integer idFase, @RequestParam(name="file", required=false) @Parameter(description="Arquivo a ser anexado.") @NotNull MultipartFile file) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.logger.debug("Executando saveAnexoFase(emp={},idFase={})...", (Object)empresa, (Object)idFase);
        try {
            Map formData = request.getParameterMap();
            String tipoAtivo = null;
            if (formData.containsKey("tipoAtivo")) {
                Object v = formData.get("tipoAtivo");
                Intrinsics.checkNotNull(v);
                tipoAtivo = ((String[])v)[0];
            }
            UploadedFileInfo fileInfo = new UploadedFileInfo(file.getOriginalFilename(), file.getContentType(), Long.valueOf(file.getSize()), file.getInputStream());
            FaseMonitoracaoAnexo imagemDB = this.sigacoService.saveAnexoFase(empresa, idFase, tipoAtivo, fileInfo, usuario.getLogin());
            ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.CREATED)).body((Object)imagemDB);
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveAnexoFase", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (IOException ioExc) {
            this.logger.error("BizExc.saveAnexoFase", (Throwable)ioExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ioExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/fasesMonitoracao/{idFase}/anexos/{idAnexoFase}"})
    @Operation(summary="Exclui o anexo da Monitora\u00e7\u00e3o a partir de seu identificador")
    @ApiResponses(value={@ApiResponse(description="Sucesso", responseCode="200")})
    @NotNull
    public ResponseEntity<Boolean> deleteAnexoFase(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="Identificador da fase") @PathVariable(name="idFase") @Nullable Integer idFase, @Parameter(description="Identificador do anexo") @PathVariable(name="idAnexoFase") @Nullable Integer idAnexoFase, @Parameter(hidden=true) @Nullable HttpServletRequest request) throws BusinessException {
        HttpServletRequest httpServletRequest = request;
        Intrinsics.checkNotNull((Object)httpServletRequest);
        PublicUser publicUser = this.getUsuarioByJWT(httpServletRequest);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Object[] objectArray = new Object[]{empresa, idFase, idAnexoFase};
        this.logger.debug("deleteAnexoFase({},{},{})", objectArray);
        try {
            return new ResponseEntity((Object)this.sigacoService.deleteAnexoFase(empresa, idAnexoFase), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.deleteAnexoFase", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/fasesMonitoracao/relatorios/{tipoAtivo}"})
    @Operation(summary="Realiza o download do relat\u00f3rio das fases de monitora\u00e7\u00e3o no formato de arquivo.")
    @ApiResponses(value={@ApiResponse(description="Sucesso", responseCode="200", content={@Content(schema=@Schema(implementation=UploadedFileInfo.class))})})
    @NotNull
    public ResponseEntity<List<UploadedFileInfo>> downloadRelatorioFases(@Parameter(hidden=true) @NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="Tipo de ativo para o relat\u00f3rio") @PathVariable(name="tipoAtivo") @Nullable TipoAtivo tipoAtivo) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.logger.debug("Exportando excel, monitora\u00e7\u00f5es (emp={}, {})...", (Object)empresa, (Object)tipoAtivo);
        if (empresa == null || ((CharSequence)empresa).length() == 0) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o informada.");
        }
        try {
            Object[] objectArray = new Object[]{empresa, empresa, tipoAtivo};
            this.logger.debug("downloadRelatorioFase({},{},{})", objectArray);
            ArrayList<Integer> idFases = new ArrayList<Integer>();
            String[] params = request.getParameterValues("fasesMonitoracao");
            if (params != null && params.length > 0 && params[0] != null) {
                String string = params[0];
                Intrinsics.checkNotNull((Object)string);
                if (!(((CharSequence)string).length() == 0)) {
                    String string2 = params[0];
                    Intrinsics.checkNotNull((Object)string2);
                    idFases.add(Integer.parseInt(string2));
                }
            }
            ArrayList<FaseMonitoracaoAnexo> anexos = new ArrayList<FaseMonitoracaoAnexo>();
            ArrayList<UploadedFileInfo> files = new ArrayList<UploadedFileInfo>();
            Iterator iterator = idFases.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                int idFase = ((Number)e).intValue();
                anexos.add(this.sigacoService.getAnexoByTipo(empresa, Integer.valueOf(idFase), tipoAtivo));
            }
            byte[] buffer = new byte[4096];
            Iterator iterator3 = anexos.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator3, (String)"iterator(...)");
            Iterator iterator4 = iterator3;
            while (iterator4.hasNext()) {
                Object e = iterator4.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                FaseMonitoracaoAnexo anx = (FaseMonitoracaoAnexo)e;
                if (anx.getIdEmpresa() == null || anx.getAnexo() == null) continue;
                UploadedFileInfo fileInfo = this.gedService.getFileInfoByUuid(anx.getIdEmpresa(), anx.getAnexo().getUuid(), null);
                fileInfo.setInputStream(null);
                fileInfo.setFileBytes(this.gedService.getFileBytesByUUID(anx.getIdEmpresa(), anx.getAnexo().getUuid(), null));
                if (fileInfo.getFileBytes() == null) {
                    this.logger.error("Arquivo {} nao encontrado.", (Object)anx.getAnexo().getNome());
                    continue;
                }
                files.add(fileInfo);
            }
            ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.OK)).body(files);
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.downloadRelatorioFases", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

