/*
 * Decompiled with CFR 0.152.
 */
package br.com.sigescantt.apis;

import br.com.sigescantt.apis.BaseRestService;
import br.com.sigescantt.core.beans.geral.Empresa;
import br.com.sigescantt.core.beans.geral.RevisaoTarifaria;
import br.com.sigescantt.core.beans.seguranca.PublicUser;
import br.com.sigescantt.core.dto.pleitos.assunto.CreateAssuntoPleitoDTO;
import br.com.sigescantt.core.dto.pleitos.enquadramento.CreateEnquadramentoPleitoDTO;
import br.com.sigescantt.core.dto.pleitos.status.SavePleitoStatusDTO;
import br.com.sigescantt.core.dto.pleitos.tipoObra.CreateTipoObraPleitoDTO;
import br.com.sigescantt.exceptions.BusinessException;
import br.com.sigescantt.pleitos.AssuntoPleito;
import br.com.sigescantt.pleitos.EnquadramentoPleito;
import br.com.sigescantt.pleitos.FaixaValor;
import br.com.sigescantt.pleitos.GrupoTrabalho;
import br.com.sigescantt.pleitos.NivelAgencia;
import br.com.sigescantt.pleitos.PleitoStatus;
import br.com.sigescantt.pleitos.PleitoTipoDesequilibrio;
import br.com.sigescantt.pleitos.PossibilidadeExito;
import br.com.sigescantt.pleitos.PrioridadePleito;
import br.com.sigescantt.pleitos.StatusAgencia;
import br.com.sigescantt.pleitos.TipoCaracteristica;
import br.com.sigescantt.pleitos.TipoObraPleito;
import br.com.sigescantt.pleitos.TipoPleito;
import br.com.sigescantt.services.CadastrosPleitoService;
import br.com.sigescantt.services.CoreService;
import br.com.sigescantt.services.Exceptions.ErrorCode;
import br.com.sigescantt.services.Exceptions.ErrorCodeException;
import br.com.sigescantt.services.SegurancaService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(name="pleitos", description="REST Services para cadastro de informa\u00e7\u00f5es de pleitos")
@Validated
@RequestMapping(value={"/api/cadastros/pleitos"})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00de\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ&\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\r2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0017J*\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\r2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J*\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\r2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J*\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\r2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J&\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u000e0\r2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0017J*\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\r2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u001e\u001a\u00020\u0016H\u0017J*\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001c0\r2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010 \u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J*\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001a0\r2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\"\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J&\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0\u000e0\r2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0017J*\u0010%\u001a\b\u0012\u0004\u0012\u00020$0\r2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010&\u001a\u00020\u0016H\u0017J*\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001a0\r2\b\b\u0001\u0010(\u001a\u00020\u00162\b\b\u0001\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J*\u0010)\u001a\b\u0012\u0004\u0012\u00020$0\r2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010*\u001a\u00020$2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J&\u0010+\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020,0\u000e0\r2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0017J*\u0010-\u001a\b\u0012\u0004\u0012\u00020,0\r2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010.\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J*\u0010/\u001a\b\u0012\u0004\u0012\u00020,0\r2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u00100\u001a\u0002012\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J*\u00102\u001a\b\u0012\u0004\u0012\u00020\u001a0\r2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u00103\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J&\u00104\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002050\u000e0\r2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0017J*\u00106\u001a\b\u0012\u0004\u0012\u0002050\r2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u00107\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J*\u00108\u001a\b\u0012\u0004\u0012\u0002050\r2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u00109\u001a\u0002052\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J*\u0010:\u001a\b\u0012\u0004\u0012\u00020\u001a0\r2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\"\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J&\u0010;\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020<0\u000e0\r2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J*\u0010=\u001a\b\u0012\u0004\u0012\u00020<0\r2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010>\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J*\u0010?\u001a\b\u0012\u0004\u0012\u00020<0\r2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010@\u001a\u00020<2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J*\u0010A\u001a\b\u0012\u0004\u0012\u00020\u001a0\r2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u00103\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J&\u0010B\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020C0\u000e0\r2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0017J*\u0010D\u001a\b\u0012\u0004\u0012\u00020C0\r2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010E\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J*\u0010F\u001a\b\u0012\u0004\u0012\u00020C0\r2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010G\u001a\u00020C2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J*\u0010H\u001a\b\u0012\u0004\u0012\u00020\u001a0\r2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010E\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J&\u0010I\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020J0\u000e0\r2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0017J*\u0010K\u001a\b\u0012\u0004\u0012\u00020J0\r2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010L\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J*\u0010M\u001a\b\u0012\u0004\u0012\u00020J0\r2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010N\u001a\u00020J2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J*\u0010O\u001a\b\u0012\u0004\u0012\u00020\u001a0\r2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010P\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J*\u0010Q\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020R\u0018\u00010\u000e0\r2\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0001\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0017J5\u0010S\u001a\b\u0012\u0004\u0012\u00020R0\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\n\b\u0001\u0010\u0012\u001a\u0004\u0018\u00010\u00132\n\b\u0001\u0010T\u001a\u0004\u0018\u00010\u0016H\u0017\u00a2\u0006\u0002\u0010UJ0\u0010V\u001a\b\u0012\u0004\u0012\u00020R0\r2\n\b\u0001\u0010\u0012\u001a\u0004\u0018\u00010\u00132\n\b\u0001\u0010W\u001a\u0004\u0018\u00010R2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0017J5\u0010X\u001a\b\u0012\u0004\u0012\u00020\u001a0\r2\n\b\u0001\u0010\u0012\u001a\u0004\u0018\u00010\u00132\n\b\u0001\u0010Y\u001a\u0004\u0018\u00010\u00162\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0017\u00a2\u0006\u0002\u0010ZJ&\u0010[\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\\0\u000e0\r2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J*\u0010]\u001a\b\u0012\u0004\u0012\u00020\\0\r2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010^\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J*\u0010_\u001a\b\u0012\u0004\u0012\u00020\\0\r2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010`\u001a\u00020\\2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J*\u0010a\u001a\b\u0012\u0004\u0012\u00020\u001a0\r2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010b\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J&\u0010c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020d0\u000e0\r2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J*\u0010e\u001a\b\u0012\u0004\u0012\u00020d0\r2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010f\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J*\u0010g\u001a\b\u0012\u0004\u0012\u00020d0\r2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010h\u001a\u00020d2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J*\u0010i\u001a\b\u0012\u0004\u0012\u00020\u001a0\r2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010j\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J \u0010k\u001a\b\u0012\u0004\u0012\u00020l0\r2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u00100\u001a\u00020mH\u0017J(\u0010n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020l0\u000e0\r2\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0001\u0010o\u001a\u0004\u0018\u00010\u0013H\u0017J\u001a\u0010n\u001a\u00020l2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010p\u001a\u00020\u0016H\u0017J*\u0010q\u001a\b\u0012\u0004\u0012\u00020l0\r2\b\b\u0001\u0010p\u001a\u00020\u00162\b\b\u0001\u00100\u001a\u00020m2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\u001a\u0010r\u001a\u00020s2\b\b\u0001\u0010p\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J \u0010t\u001a\b\u0012\u0004\u0012\u00020u0\r2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u00100\u001a\u00020vH\u0017JB\u0010w\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020u0x0\r2\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0001\u0010o\u001a\u0004\u0018\u00010\u00132\u0010\b\u0001\u0010y\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u000e2\u0006\u0010z\u001a\u00020{H\u0017J \u0010|\u001a\b\u0012\u0004\u0012\u00020u0\r2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010}\u001a\u00020\u0016H\u0017J*\u0010~\u001a\b\u0012\u0004\u0012\u00020u0\r2\b\b\u0001\u0010}\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u00100\u001a\u00020vH\u0017J\u001a\u0010\u007f\u001a\u00020s2\b\b\u0001\u0010}\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J#\u0010\u0080\u0001\u001a\t\u0012\u0005\u0012\u00030\u0081\u00010\r2\u0006\u0010\u0010\u001a\u00020\u00112\t\b\u0001\u00100\u001a\u00030\u0082\u0001H\u0017J*\u0010\u0083\u0001\u001a\u000f\u0012\u000b\u0012\t\u0012\u0005\u0012\u00030\u0081\u00010\u000e0\r2\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0001\u0010o\u001a\u0004\u0018\u00010\u0013H\u0017J#\u0010\u0084\u0001\u001a\t\u0012\u0005\u0012\u00030\u0081\u00010\r2\u0006\u0010\u0010\u001a\u00020\u00112\t\b\u0001\u0010\u0085\u0001\u001a\u00020\u0016H\u0017J.\u0010\u0086\u0001\u001a\t\u0012\u0005\u0012\u00030\u0081\u00010\r2\t\b\u0001\u0010\u0085\u0001\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00112\t\b\u0001\u00100\u001a\u00030\u0082\u0001H\u0017J\u001c\u0010\u0087\u0001\u001a\u00020s2\t\b\u0001\u0010\u0085\u0001\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0088\u0001"}, d2={"Lbr/com/sigescantt/apis/CadastrosPleitosRestServices;", "Lbr/com/sigescantt/apis/BaseRestService;", "coreService", "Lbr/com/sigescantt/services/CoreService;", "segurancaService", "Lbr/com/sigescantt/services/SegurancaService;", "cadastrosPleitoService", "Lbr/com/sigescantt/services/CadastrosPleitoService;", "<init>", "(Lbr/com/sigescantt/services/CoreService;Lbr/com/sigescantt/services/SegurancaService;Lbr/com/sigescantt/services/CadastrosPleitoService;)V", "logger", "Lorg/slf4j/Logger;", "findTiposPleito", "Lorg/springframework/http/ResponseEntity;", "", "Lbr/com/sigescantt/pleitos/TipoPleito;", "request", "Ljakarta/servlet/http/HttpServletRequest;", "empresa", "", "getTipoPleitoById", "idTipoPleito", "", "saveTiposPleito", "pleito", "deleteTipoPleito", "", "findTiposCaracteristica", "Lbr/com/sigescantt/pleitos/TipoCaracteristica;", "getTipoCaracteristica", "idTipoCaracteristica", "saveTiposCaracteristicas", "tipo", "deleteTipoCaracteristica", "idTipo", "findNiveisAgencia", "Lbr/com/sigescantt/pleitos/NivelAgencia;", "getNivelAgencia", "idNivelAgencia", "deleteNivelAgencia", "idNivel", "saveNivelAgencia", "nivelAgencia", "findStatusPleito", "Lbr/com/sigescantt/pleitos/PleitoStatus;", "getStatusPleitoById", "idStatusPleito", "saveStatusPleito", "dto", "Lbr/com/sigescantt/core/dto/pleitos/status/SavePleitoStatusDTO;", "deleteStatusPleito", "idStatus", "findTiposDesequilibrio", "Lbr/com/sigescantt/pleitos/PleitoTipoDesequilibrio;", "getTipoDesequilibrioById", "idTipoDesequilibrio", "saveTiposDesequilibrio", "tipos", "deleteTipoDesequilibrio", "findStatusAgencia", "Lbr/com/sigescantt/pleitos/StatusAgencia;", "getStatusAgenciaById", "idStatusAgencia", "saveStatusAgencia", "status", "deleteStatusAgencia", "findPrioridadesPleito", "Lbr/com/sigescantt/pleitos/PrioridadePleito;", "getPrioridadePleitoById", "idPrioridade", "savePrioridadePleito", "prioridade", "deletePrioridadePleito", "findGruposTrabalho", "Lbr/com/sigescantt/pleitos/GrupoTrabalho;", "getGrupoTrabalhoById", "idGrupoTrabalho", "saveGruposTrabalho", "grupos", "deleteGrupoTrabalho", "idGrupo", "findRevisoesTarifarias", "Lbr/com/sigescantt/core/beans/geral/RevisaoTarifaria;", "getRevisaoTarifaria", "idRevisaoTarifaria", "(Ljakarta/servlet/http/HttpServletRequest;Ljava/lang/String;Ljava/lang/Integer;)Lorg/springframework/http/ResponseEntity;", "saveRevisaoTarifaria", "revisao", "deleteRevisaoTarifaria", "idRevisao", "(Ljava/lang/String;Ljava/lang/Integer;Ljakarta/servlet/http/HttpServletRequest;)Lorg/springframework/http/ResponseEntity;", "findPossibilidadesExito", "Lbr/com/sigescantt/pleitos/PossibilidadeExito;", "getPossibilidadeExitoById", "idPossibilidadeExito", "savePossibilidadeExito", "possibilidade", "deletePossibilidadeExito", "idPossibilidade", "findFaixasValores", "Lbr/com/sigescantt/pleitos/FaixaValor;", "getFaixaValorById", "idFaixaValor", "saveFaixaValor", "faixa", "deleteFaixaValor", "idFaixa", "saveAssuntoPleito", "Lbr/com/sigescantt/pleitos/AssuntoPleito;", "Lbr/com/sigescantt/core/dto/pleitos/assunto/CreateAssuntoPleitoDTO;", "findAssuntoPleito", "search", "idAssunto", "editAssuntoPleito", "deleteAssuntoPleito", "", "saveEnquadramentoPleito", "Lbr/com/sigescantt/pleitos/EnquadramentoPleito;", "Lbr/com/sigescantt/core/dto/pleitos/enquadramento/CreateEnquadramentoPleitoDTO;", "findEnquadramentosPleito", "Lorg/springframework/data/domain/Page;", "idCoordenacao", "pageable", "Lorg/springframework/data/domain/Pageable;", "findEnquadramentoPleitoById", "idEnquadramento", "editEnquadramentoPleito", "deleteEnquadramentoPleito", "saveTipoObraPleito", "Lbr/com/sigescantt/pleitos/TipoObraPleito;", "Lbr/com/sigescantt/core/dto/pleitos/tipoObra/CreateTipoObraPleitoDTO;", "findTiposObraPleito", "findTipoObraPleitoById", "idTipoObra", "editTipoObraPleito", "deleteTipoObraPleito", "server"})
@SourceDebugExtension(value={"SMAP\nCadastrosPleitosRestServices.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CadastrosPleitosRestServices.kt\nbr/com/sigescantt/apis/CadastrosPleitosRestServices\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1977:1\n2642#2:1978\n2642#2:1980\n2642#2:1983\n2642#2:1985\n2642#2:1987\n774#2:1989\n865#2,2:1990\n1863#2,2:1992\n1863#2,2:1994\n1863#2,2:1996\n1863#2,2:1998\n1863#2,2:2000\n1#3:1979\n1#3:1981\n1#3:1982\n1#3:1984\n1#3:1986\n1#3:1988\n*S KotlinDebug\n*F\n+ 1 CadastrosPleitosRestServices.kt\nbr/com/sigescantt/apis/CadastrosPleitosRestServices\n*L\n66#1:1978\n191#1:1980\n335#1:1983\n476#1:1985\n603#1:1987\n728#1:1989\n728#1:1990,2\n728#1:1992,2\n862#1:1994,2\n995#1:1996,2\n1285#1:1998,2\n1414#1:2000,2\n66#1:1979\n191#1:1981\n335#1:1984\n476#1:1986\n603#1:1988\n*E\n"})
public class CadastrosPleitosRestServices
extends BaseRestService {
    @NotNull
    private final CoreService coreService;
    @NotNull
    private final SegurancaService segurancaService;
    @NotNull
    private final CadastrosPleitoService cadastrosPleitoService;
    @NotNull
    private final Logger logger;

    public CadastrosPleitosRestServices(@NotNull CoreService coreService, @NotNull SegurancaService segurancaService, @NotNull CadastrosPleitoService cadastrosPleitoService) {
        Intrinsics.checkNotNullParameter((Object)coreService, (String)"coreService");
        Intrinsics.checkNotNullParameter((Object)segurancaService, (String)"segurancaService");
        Intrinsics.checkNotNullParameter((Object)cadastrosPleitoService, (String)"cadastrosPleitoService");
        super(segurancaService);
        this.coreService = coreService;
        this.segurancaService = segurancaService;
        this.cadastrosPleitoService = cadastrosPleitoService;
        Logger logger = LoggerFactory.getLogger(CadastrosPleitosRestServices.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    @GetMapping(value={"/{empresa}/tipos"})
    @Operation(summary="Retorna os tipos de pleitos", description="Busca todos os tipos de pleitos dispon\u00edveis, com op\u00e7\u00e3o de filtro por texto.")
    @ApiResponses(value={@ApiResponse(description="Tipos de pleitos encontrados com sucesso.", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<List<TipoPleito>> findTiposPleito(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.logger.debug("API findTiposPleito(emp={})...", (Object)empresa);
        try {
            Iterable iterable;
            String search = request.getParameter("search");
            Iterable $this$onEach$iv = this.cadastrosPleitoService.findTiposPleitos(search, Boolean.valueOf(true));
            boolean $i$f$onEach = false;
            Iterable $this$onEach_u24lambda_u2418$iv = iterable = $this$onEach$iv;
            boolean bl = false;
            for (Object element$iv : $this$onEach_u24lambda_u2418$iv) {
                TipoPleito it = (TipoPleito)element$iv;
                boolean bl2 = false;
                it.setDatHorCadastro(null);
                it.setIdUsuarioIns(null);
                it.setDatHorAlteracao(null);
                it.setIdUsuarioUpd(null);
            }
            List tipos = (List)iterable;
            responseEntity = new ResponseEntity((Object)tipos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.findTiposPleito", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.logger.error("Exception.findTiposPleito", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
        return responseEntity;
    }

    @GetMapping(value={"/{empresa}/{idTipoPleito}/tipoPleito"})
    @Operation(summary="Busca o tipo do pleito conforme seu identificador.", description="Retorna os detalhes de um tipo de pleito espec\u00edfico com base no seu ID.")
    @ApiResponses(value={@ApiResponse(description="Tipo de pleito encontrado com sucesso.", responseCode="200")})
    @NotNull
    public ResponseEntity<TipoPleito> getTipoPleitoById(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa, @Parameter(description="Identificador do tipo de pleito") @PathVariable(name="idTipoPleito") int idTipoPleito, @NotNull HttpServletRequest request) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.logger.debug("getTipoPleitoById({}, {})", (Object)empresa, (Object)idTipoPleito);
            responseEntity = ResponseEntity.ok((Object)this.cadastrosPleitoService.getTipoPleitoById(Integer.valueOf(idTipoPleito)));
            Intrinsics.checkNotNull((Object)responseEntity);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.getStatusAgenciaById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        return responseEntity;
    }

    @PostMapping(value={"/{empresa}/tipos"})
    @Operation(summary="Salva os tipos de pleito a partir de seu payload", description="Cria ou atualiza um tipo de pleito com os dados fornecidos.")
    @ApiResponses(value={@ApiResponse(description="Tipo de pleito criado com sucesso.", responseCode="201")})
    @NotNull
    public ResponseEntity<TipoPleito> saveTiposPleito(@Parameter(description="Sigla da empresa") @PathVariable @NotNull String empresa, @RequestBody(description="Dados do tipo de pleito a ser salvo", required=true) @org.springframework.web.bind.annotation.RequestBody @NotNull TipoPleito pleito, @NotNull HttpServletRequest request) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)pleito, (String)"pleito");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            this.logger.debug("saveTiposPleito({}, {})", (Object)empresa, (Object)pleito);
            responseEntity = new ResponseEntity((Object)this.cadastrosPleitoService.saveTipoPleito(pleito, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveTiposPleito", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        return responseEntity;
    }

    @DeleteMapping(value={"/{empresa}/{idTipoPleito}/tipos"})
    @Operation(summary="Exclui o tipo de pleito de acordo com seu ID.", description="Remove permanentemente um tipo de pleito do sistema utilizando seu identificador.")
    @ApiResponses(value={@ApiResponse(description="Tipo de pleito exclu\u00eddo com sucesso.", responseCode="200")})
    @NotNull
    public ResponseEntity<Boolean> deleteTipoPleito(@Parameter(description="Sigla da empresa") @PathVariable @NotNull String empresa, @Parameter(description="Identificador do tipo de pleito a ser exclu\u00eddo") @PathVariable int idTipoPleito, @NotNull HttpServletRequest request) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.logger.debug("deleteTipoPleito({}, {})", (Object)empresa, (Object)idTipoPleito);
            this.cadastrosPleitoService.deleteTipoPleito(Integer.valueOf(idTipoPleito));
            responseEntity = new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.deleteTipoPleito", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        return responseEntity;
    }

    @GetMapping(value={"/{empresa}/tiposCaracteristica"})
    @Operation(summary="Retorna os tipos de caracter\u00edsticas de pleitos", description="Busca todos os tipos de caracter\u00edsticas de pleitos dispon\u00edveis, com op\u00e7\u00e3o de filtro por texto.")
    @ApiResponses(value={@ApiResponse(description="Tipos de caracter\u00edsticas encontrados com sucesso.", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<List<TipoCaracteristica>> findTiposCaracteristica(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable @NotNull String empresa) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.logger.debug("API findTiposCaracteristica(emp={})...", (Object)empresa);
        try {
            Iterable iterable;
            Empresa empresa2 = this.coreService.getEmpresaBySigla(empresa);
            if (empresa2 == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            Empresa empresaDB = empresa2;
            String search = request.getParameter("search");
            Iterable $this$onEach$iv = this.cadastrosPleitoService.findTiposCaracteristica(search, empresaDB.getId());
            boolean $i$f$onEach = false;
            Iterable $this$onEach_u24lambda_u2418$iv = iterable = $this$onEach$iv;
            boolean bl = false;
            for (Object element$iv : $this$onEach_u24lambda_u2418$iv) {
                TipoCaracteristica it = (TipoCaracteristica)element$iv;
                boolean bl2 = false;
                it.setDatHorCadastro(null);
                it.setIdUsuarioIns(null);
                it.setDatHorAlteracao(null);
                it.setIdUsuarioUpd(null);
            }
            List tipos = (List)iterable;
            responseEntity = new ResponseEntity((Object)tipos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.findTiposCaracteristicas", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.logger.error("Exception.findTiposCaracteristicas", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
        return responseEntity;
    }

    @GetMapping(value={"/{empresa}/{idTipoCaracteristica}/tipoCaracteristica"})
    @Operation(summary="Exibe o tipo de caracter\u00edstica conforme seu identificador.", description="Retorna os detalhes de um tipo de caracter\u00edstica espec\u00edfico com base no seu ID.")
    @ApiResponses(value={@ApiResponse(description="Tipo de caracter\u00edstica encontrado com sucesso.", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<TipoCaracteristica> getTipoCaracteristica(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable @NotNull String empresa, @Parameter(description="Identificador do tipo de caracter\u00edstica") @PathVariable int idTipoCaracteristica) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.logger.debug("Executando getTipoCaracteristica");
        try {
            Empresa empresa2 = this.coreService.getEmpresaBySigla(empresa);
            if (empresa2 == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            Empresa empresaDB = empresa2;
            TipoCaracteristica tipoCaracteristica = this.cadastrosPleitoService.getTipoCaracteristicaById(Integer.valueOf(idTipoCaracteristica), empresaDB.getId());
            responseEntity = new ResponseEntity((Object)tipoCaracteristica, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.getTipoCaracteristica", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.logger.error("Exception.getTipoCaracteristica", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
        return responseEntity;
    }

    @PostMapping(value={"/{empresa}/tiposCaracteristica"})
    @Operation(summary="Salva os tipos de caracter\u00edsticas de pleito a partir de seu payload", description="Cria ou atualiza um tipo de caracter\u00edstica de pleito com os dados fornecidos.")
    @ApiResponses(value={@ApiResponse(description="Tipo de caracter\u00edstica criado com sucesso.", responseCode="201")})
    @NotNull
    public ResponseEntity<TipoCaracteristica> saveTiposCaracteristicas(@Parameter(description="Sigla da empresa") @PathVariable @NotNull String empresa, @RequestBody(description="Dados do tipo de caracter\u00edstica a ser salvo", required=true) @org.springframework.web.bind.annotation.RequestBody @NotNull TipoCaracteristica tipo, @NotNull HttpServletRequest request) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)tipo, (String)"tipo");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            this.logger.debug("saveTiposPleito({})", (Object)tipo);
            responseEntity = new ResponseEntity((Object)this.cadastrosPleitoService.saveTipoCaracteristica(tipo, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveTiposCaracteristicas", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        return responseEntity;
    }

    @DeleteMapping(value={"/{empresa}/{idTipo}/tiposCaracteristica"})
    @Operation(summary="Exclui o tipo de caracter\u00edstica de pleito de acordo com seu ID.", description="Remove permanentemente um tipo de caracter\u00edstica de pleito do sistema utilizando seu identificador.")
    @ApiResponses(value={@ApiResponse(description="Tipo de caracter\u00edstica exclu\u00eddo com sucesso.", responseCode="200")})
    @NotNull
    public ResponseEntity<Boolean> deleteTipoCaracteristica(@Parameter(description="Sigla da empresa") @PathVariable @NotNull String empresa, @Parameter(description="Identificador do tipo de caracter\u00edstica a ser exclu\u00eddo") @PathVariable int idTipo, @NotNull HttpServletRequest request) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.logger.debug("deleteTipoCaracteristica({})", (Object)idTipo);
            Empresa empresa2 = this.coreService.getEmpresaBySigla(empresa);
            if (empresa2 == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            Empresa empresaDB = empresa2;
            this.cadastrosPleitoService.deleteTipoCaracteristica(Integer.valueOf(idTipo), empresaDB.getId());
            responseEntity = new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.deleteTipoCaracteristica", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        return responseEntity;
    }

    @GetMapping(value={"/{empresa}/nivelAgencia"})
    @Operation(summary="Localiza n\u00edveis de ag\u00eancia de acordo com a empresa", description="Busca todos os n\u00edveis de ag\u00eancia dispon\u00edveis para uma empresa espec\u00edfica, com op\u00e7\u00e3o de filtro por texto.")
    @ApiResponses(value={@ApiResponse(description="N\u00edveis de ag\u00eancia encontrados com sucesso.", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<List<NivelAgencia>> findNiveisAgencia(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.logger.debug("API findNiveisAgencia(emp={})...", (Object)empresa);
        String search = request.getParameter("search");
        try {
            Empresa empresa2 = this.coreService.getEmpresaBySigla(empresa);
            if (empresa2 == null) {
                throw new BusinessException("Empresa n\u00e3o foi encontrada.");
            }
            Empresa emp = empresa2;
            List niveis = this.cadastrosPleitoService.findNiveisAgencia(emp.getId(), search);
            List list = niveis;
            if (list != null) {
                List list2;
                List it = list2 = list;
                boolean bl = false;
                list = !((Collection)it).isEmpty() ? list2 : null;
                if (list != null) {
                    Iterable iterable;
                    Iterable $this$onEach$iv = list;
                    boolean $i$f$onEach = false;
                    Iterable $this$onEach_u24lambda_u2418$iv = iterable = $this$onEach$iv;
                    boolean bl2 = false;
                    for (Object element$iv : $this$onEach_u24lambda_u2418$iv) {
                        NivelAgencia it2 = (NivelAgencia)element$iv;
                        boolean bl3 = false;
                        it2.setDatHorCadastro(null);
                        it2.setIdUsuarioIns(null);
                        it2.setDatHorAlteracao(null);
                        it2.setIdUsuarioUpd(null);
                    }
                    List cfr_ignored_0 = (List)iterable;
                }
            }
            responseEntity = new ResponseEntity((Object)niveis, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.findNiveisAgencia", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.logger.error("Exception.findNiveisAgencia", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
        return responseEntity;
    }

    @GetMapping(value={"/{empresa}/{idNivelAgencia}/nivelAgencia"})
    @Operation(summary="Exibe o n\u00edvel da ag\u00eancia conforme seu identificador.", description="Retorna os detalhes de um n\u00edvel de ag\u00eancia espec\u00edfico com base no seu ID.")
    @ApiResponses(value={@ApiResponse(description="N\u00edvel de ag\u00eancia encontrado com sucesso.", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<NivelAgencia> getNivelAgencia(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa, @Parameter(description="Identificador do n\u00edvel de ag\u00eancia") @PathVariable(name="idNivelAgencia") int idNivelAgencia) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.logger.debug("Executando getNivelAgencia");
        try {
            Empresa empresa2 = this.coreService.getEmpresaBySigla(empresa);
            if (empresa2 == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            Empresa empresaDB = empresa2;
            NivelAgencia nivelAgencia = this.cadastrosPleitoService.getNivelAgenciaById(Integer.valueOf(idNivelAgencia), empresaDB.getId());
            responseEntity = new ResponseEntity((Object)nivelAgencia, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.getNivelAgencia", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.logger.error("Exception.getNivelAgencia", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
        return responseEntity;
    }

    @DeleteMapping(value={"/{empresa}/{idNivel}/nivelAgencia"})
    @Operation(summary="Exclui o n\u00edvel de ag\u00eancia de acordo com seu ID.", description="Remove permanentemente um n\u00edvel de ag\u00eancia do sistema utilizando seu identificador.")
    @ApiResponses(value={@ApiResponse(description="N\u00edvel de ag\u00eancia exclu\u00eddo com sucesso.", responseCode="200")})
    @NotNull
    public ResponseEntity<Boolean> deleteNivelAgencia(@Parameter(description="Identificador do n\u00edvel de ag\u00eancia a ser exclu\u00eddo") @PathVariable(name="idNivel") int idNivel, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa, @NotNull HttpServletRequest request) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.logger.debug("deleteNivelAgencia({})", (Object)idNivel);
            Empresa empresa2 = this.coreService.getEmpresaBySigla(empresa);
            if (empresa2 == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            Empresa empresaDB = empresa2;
            this.cadastrosPleitoService.deleteNivelAgencia(Integer.valueOf(idNivel), empresaDB.getId());
            responseEntity = new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.deleteNivelAgencia", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        return responseEntity;
    }

    @PostMapping(value={"/{empresa}/nivelAgencia"})
    @Operation(summary="Salva os n\u00edveis de ag\u00eancia de pleito a partir de seu payload", description="Cria ou atualiza um n\u00edvel de ag\u00eancia com os dados fornecidos.")
    @ApiResponses(value={@ApiResponse(description="N\u00edvel de ag\u00eancia criado com sucesso.", responseCode="201")})
    @NotNull
    public ResponseEntity<NivelAgencia> saveNivelAgencia(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa, @RequestBody(description="Dados do n\u00edvel de ag\u00eancia a ser salvo", required=true) @org.springframework.web.bind.annotation.RequestBody @NotNull NivelAgencia nivelAgencia, @NotNull HttpServletRequest request) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)nivelAgencia, (String)"nivelAgencia");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            this.logger.debug("saveNivelAgencia({})", (Object)nivelAgencia);
            responseEntity = new ResponseEntity((Object)this.cadastrosPleitoService.saveNivelAgencia(nivelAgencia, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveNivelAgencia", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        return responseEntity;
    }

    @GetMapping(value={"/{empresa}/status"})
    @Operation(summary="Retorna os status de pleitos", description="Busca todos os status de pleitos dispon\u00edveis, com op\u00e7\u00e3o de filtro por texto.")
    @ApiResponses(value={@ApiResponse(description="Status de pleitos encontrados com sucesso.", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<List<PleitoStatus>> findStatusPleito(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable @NotNull String empresa) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.logger.debug("API findStatusPleito(emp={})...", (Object)empresa);
        try {
            Iterable iterable;
            Empresa empresa2 = this.coreService.getEmpresaBySigla(empresa);
            if (empresa2 == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            Empresa empresaDB = empresa2;
            String search = request.getParameter("search");
            Iterable $this$onEach$iv = this.cadastrosPleitoService.findStatusPleito(empresaDB.getId(), search);
            boolean $i$f$onEach = false;
            Iterable $this$onEach_u24lambda_u2418$iv = iterable = $this$onEach$iv;
            boolean bl = false;
            for (Object element$iv : $this$onEach_u24lambda_u2418$iv) {
                PleitoStatus it = (PleitoStatus)element$iv;
                boolean bl2 = false;
                it.setDatHorCadastro(null);
                it.setIdUsuarioIns(null);
                it.setDatHorAlteracao(null);
                it.setIdUsuarioUpd(null);
            }
            List status = (List)iterable;
            responseEntity = new ResponseEntity((Object)status, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.findStatusPleito", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.logger.error("Exception.findStatusPleito", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
        return responseEntity;
    }

    @GetMapping(value={"/{empresa}/{idStatusPleito}/status"})
    @Operation(summary="Busca o status de pleito conforme seu identificador.", description="Retorna os detalhes do status de pleito com base no ID fornecido.")
    @ApiResponses(value={@ApiResponse(description="Status de pleito encontrado com sucesso.", responseCode="200")})
    @NotNull
    public ResponseEntity<PleitoStatus> getStatusPleitoById(@Parameter(description="Sigla da empresa") @PathVariable @NotNull String empresa, @Parameter(description="Identificador do status de pleito") @PathVariable int idStatusPleito, @NotNull HttpServletRequest request) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.getUsuarioByJWT(request) == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            this.logger.debug("getStatusPleitoById({})", (Object)idStatusPleito);
            responseEntity = ResponseEntity.ok((Object)this.cadastrosPleitoService.getStatusPleitoById(Integer.valueOf(idStatusPleito)));
            Intrinsics.checkNotNull((Object)responseEntity);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.getStatusPleitoById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        return responseEntity;
    }

    @PostMapping(value={"/{empresa}/status"})
    @Operation(summary="Salva os status de pleito a partir de seu payload", description="Cria ou atualiza um status de pleito com os dados fornecidos.")
    @ApiResponses(value={@ApiResponse(description="Status de pleito criado com sucesso.", responseCode="201")})
    @NotNull
    public ResponseEntity<PleitoStatus> saveStatusPleito(@Parameter(description="Sigla da empresa") @PathVariable @NotNull String empresa, @RequestBody(description="Dados do status de pleito a ser salvo", required=true) @Valid @org.springframework.web.bind.annotation.RequestBody @NotNull SavePleitoStatusDTO dto, @NotNull HttpServletRequest request) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            this.logger.debug("saveStatusPleito({})", (Object)dto);
            Integer n = usr.getId();
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
            responseEntity = new ResponseEntity((Object)this.cadastrosPleitoService.saveStatusPleito(empresa, dto, ((Number)n).intValue()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveStatusPleito", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        return responseEntity;
    }

    @DeleteMapping(value={"/{empresa}/{idStatus}/status"})
    @Operation(summary="Exclui o status de pleito de acordo com seu ID.", description="Remove permanentemente um status de pleito do sistema utilizando seu identificador.")
    @ApiResponses(value={@ApiResponse(description="Status de pleito exclu\u00eddo com sucesso.", responseCode="200")})
    @NotNull
    public ResponseEntity<Boolean> deleteStatusPleito(@Parameter(description="Sigla da empresa") @PathVariable @NotNull String empresa, @Parameter(description="Identificador do status de pleito a ser exclu\u00eddo") @PathVariable int idStatus, @NotNull HttpServletRequest request) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.getUsuarioByJWT(request) == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            this.logger.debug("deleteStatusPleito({}, {})", (Object)empresa, (Object)idStatus);
            this.cadastrosPleitoService.deleteStatusPleito(Integer.valueOf(idStatus));
            responseEntity = new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.deleteStatusPleito", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        return responseEntity;
    }

    @GetMapping(value={"/{empresa}/tiposDesequilibrio"})
    @Operation(summary="Retorna os tipos de desequil\u00edbrio de pleitos", description="Busca todos os tipos de desequil\u00edbrio de pleitos dispon\u00edveis, com op\u00e7\u00e3o de filtro por texto.")
    @ApiResponses(value={@ApiResponse(description="Tipos de desequil\u00edbrio encontrados com sucesso.", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<List<PleitoTipoDesequilibrio>> findTiposDesequilibrio(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable @NotNull String empresa) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.logger.debug("API findTiposDesequilibrio(emp={})...", (Object)empresa);
        try {
            Iterable iterable;
            Empresa empresa2 = this.coreService.getEmpresaBySigla(empresa);
            if (empresa2 == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            Empresa empresaDB = empresa2;
            String search = request.getParameter("search");
            Iterable $this$onEach$iv = this.cadastrosPleitoService.findTiposDesequilibrio(empresaDB.getId(), search);
            boolean $i$f$onEach = false;
            Iterable $this$onEach_u24lambda_u2418$iv = iterable = $this$onEach$iv;
            boolean bl = false;
            for (Object element$iv : $this$onEach_u24lambda_u2418$iv) {
                PleitoTipoDesequilibrio it = (PleitoTipoDesequilibrio)element$iv;
                boolean bl2 = false;
                it.setDatHorCadastro(null);
                it.setIdUsuarioIns(null);
                it.setDatHorAlteracao(null);
                it.setIdUsuarioUpd(null);
            }
            List tipos = (List)iterable;
            responseEntity = new ResponseEntity((Object)tipos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.findTiposDesequilibrio", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.logger.error("Exception.findTiposDesequilibrio", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
        return responseEntity;
    }

    @GetMapping(value={"/{empresa}/{idTipoDesequilibrio}/tipoDesequilibrio"})
    @Operation(summary="Busca o tipo de desequil\u00edbrio conforme seu identificador.", description="Retorna os detalhes do tipo de desequil\u00edbrio com base no ID fornecido.")
    @ApiResponses(value={@ApiResponse(description="Tipo de desequil\u00edbrio encontrado com sucesso.", responseCode="200")})
    @NotNull
    public ResponseEntity<PleitoTipoDesequilibrio> getTipoDesequilibrioById(@Parameter(description="Sigla da empresa") @PathVariable @NotNull String empresa, @Parameter(description="Identificador do tipo de desequil\u00edbrio") @PathVariable int idTipoDesequilibrio, @NotNull HttpServletRequest request) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.logger.debug("getPleitoTipoDesequilibrioById({}, {})", (Object)empresa, (Object)idTipoDesequilibrio);
            responseEntity = ResponseEntity.ok((Object)this.cadastrosPleitoService.getTipoDesequilibrioById(Integer.valueOf(idTipoDesequilibrio)));
            Intrinsics.checkNotNull((Object)responseEntity);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.getTipoDesequilibrioById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        return responseEntity;
    }

    @PostMapping(value={"/{empresa}/tiposDesequilibrio"})
    @Operation(summary="Salva os tipos de desequil\u00edbrio de pleito a partir de seu payload", description="Cria ou atualiza um tipo de desequil\u00edbrio de pleito com os dados fornecidos.")
    @ApiResponses(value={@ApiResponse(description="Tipo de desequil\u00edbrio criado com sucesso.", responseCode="201")})
    @NotNull
    public ResponseEntity<PleitoTipoDesequilibrio> saveTiposDesequilibrio(@Parameter(description="Sigla da empresa") @PathVariable @NotNull String empresa, @RequestBody(description="Dados do tipo de desequil\u00edbrio a ser salvo", required=true) @org.springframework.web.bind.annotation.RequestBody @NotNull PleitoTipoDesequilibrio tipos, @NotNull HttpServletRequest request) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)tipos, (String)"tipos");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            this.logger.debug("saveTiposDesequilibrio({}, {})", (Object)empresa, (Object)tipos);
            responseEntity = new ResponseEntity((Object)this.cadastrosPleitoService.saveTipoDesequilibrio(tipos, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveTiposDesequilibrio", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        return responseEntity;
    }

    @DeleteMapping(value={"/{empresa}/{idTipo}/tiposDesequilibrio"})
    @Operation(summary="Exclui o tipo de desequil\u00edbrio de pleito de acordo com seu ID.", description="Remove permanentemente um tipo de desequil\u00edbrio de pleito do sistema utilizando seu identificador.")
    @ApiResponses(value={@ApiResponse(description="Tipo de desequil\u00edbrio exclu\u00eddo com sucesso.", responseCode="200")})
    @NotNull
    public ResponseEntity<Boolean> deleteTipoDesequilibrio(@Parameter(description="Sigla da empresa") @PathVariable @NotNull String empresa, @Parameter(description="Identificador do tipo de desequil\u00edbrio a ser exclu\u00eddo") @PathVariable int idTipo, @NotNull HttpServletRequest request) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.logger.debug("deleteTipoDesequilibrio({}, {})", (Object)empresa, (Object)idTipo);
            this.cadastrosPleitoService.deleteTipoDesequilibrio(Integer.valueOf(idTipo));
            responseEntity = new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.deleteTipoDesequilibrio", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        return responseEntity;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"/{empresa}/statusAgencia"})
    @Operation(summary="Retorna os status de ag\u00eancia", description="Busca todos os status de ag\u00eancia dispon\u00edveis, com op\u00e7\u00e3o de filtro por texto.")
    @ApiResponses(value={@ApiResponse(description="Status de ag\u00eancia encontrados com sucesso.", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<List<StatusAgencia>> findStatusAgencia(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.logger.debug("API findStatusAgencia(){}...", (Object)empresa);
        try {
            List status;
            String search = request.getParameter("search");
            List list = status = this.cadastrosPleitoService.findStatusAgencia(search);
            if (list != null) {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = list;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    StatusAgencia it = (StatusAgencia)element$iv$iv;
                    boolean bl = false;
                    if (!(it != null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$forEach$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    StatusAgencia tipo = (StatusAgencia)element$iv;
                    boolean bl = false;
                    tipo.setDatHorCadastro(null);
                    tipo.setIdUsuarioIns(null);
                    tipo.setDatHorAlteracao(null);
                    tipo.setIdUsuarioUpd(null);
                }
            }
            return new ResponseEntity((Object)status, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.findStatusAgencia", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.logger.error("Exception.findStatusAgencia", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idStatusAgencia}/statusAgencia"})
    @Operation(summary="Busca o status da ag\u00eancia conforme seu identificador.", description="Retorna os detalhes do status da ag\u00eancia com base no ID fornecido.")
    @ApiResponses(value={@ApiResponse(description="Status da ag\u00eancia encontrado com sucesso.", responseCode="200")})
    @NotNull
    public ResponseEntity<StatusAgencia> getStatusAgenciaById(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa, @Parameter(description="Identificador do status da ag\u00eancia") @PathVariable(name="idStatusAgencia") int idStatusAgencia, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.logger.debug("getStatusAgenciaById({}, {})", (Object)empresa, (Object)idStatusAgencia);
            ResponseEntity responseEntity = ResponseEntity.ok().body((Object)this.cadastrosPleitoService.getStatusAgenciaById(Integer.valueOf(idStatusAgencia)));
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.getStatusAgenciaById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/statusAgencia"})
    @Operation(summary="Salva os status de ag\u00eancia a partir de seu payload", description="Cria ou atualiza um status de ag\u00eancia com os dados fornecidos.")
    @ApiResponses(value={@ApiResponse(description="Status de ag\u00eancia criado com sucesso.", responseCode="201")})
    @NotNull
    public ResponseEntity<StatusAgencia> saveStatusAgencia(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa, @RequestBody(description="Dados do status de ag\u00eancia a ser salvo", required=true) @org.springframework.web.bind.annotation.RequestBody @NotNull StatusAgencia status, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            this.logger.debug("saveStatusAgencia({}, {})", (Object)empresa, (Object)status);
            return new ResponseEntity((Object)this.cadastrosPleitoService.saveStatusAgencia(status, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveStatusAgencia", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idStatus}/statusAgencia"})
    @Operation(summary="Exclui o status de ag\u00eancia de acordo com seu ID.", description="Remove permanentemente um status de ag\u00eancia do sistema utilizando seu identificador.")
    @ApiResponses(value={@ApiResponse(description="Status de ag\u00eancia exclu\u00eddo com sucesso.", responseCode="200")})
    @NotNull
    public ResponseEntity<Boolean> deleteStatusAgencia(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa, @Parameter(description="Identificador do status de ag\u00eancia a ser exclu\u00eddo") @PathVariable(name="idStatus") int idStatus, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            this.logger.debug("deleteStatusAgencia({}, {})", (Object)empresa, (Object)idStatus);
            this.cadastrosPleitoService.deleteStatusAgencia(Integer.valueOf(idStatus));
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.deleteStatusAgencia", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/prioridades"})
    @Operation(summary="Localiza as prioridades de pleito de acordo com a empresa", description="Busca todas as prioridades de pleito dispon\u00edveis para uma empresa, com op\u00e7\u00e3o de filtro por texto.")
    @ApiResponses(value={@ApiResponse(description="Prioridades de pleito encontradas com sucesso.", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<List<PrioridadePleito>> findPrioridadesPleito(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.logger.debug("API findPrioridades(emp={})...", (Object)empresa);
        String search = request.getParameter("search");
        try {
            List prioridades;
            Empresa empresa2 = this.coreService.getEmpresaBySigla(empresa);
            if (empresa2 == null) {
                throw new ErrorCodeException(ErrorCode.EMPRESA_NOT_FOUND, new String[0]);
            }
            Empresa emp = empresa2;
            List list = prioridades = this.cadastrosPleitoService.findPrioridadesPleitos(emp.getId(), search);
            if (list != null) {
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PrioridadePleito prioridade = (PrioridadePleito)element$iv;
                    boolean bl = false;
                    prioridade.setDatHorCadastro(null);
                    prioridade.setIdUsuarioIns(null);
                    prioridade.setDatHorAlteracao(null);
                    prioridade.setIdUsuarioUpd(null);
                }
            }
            return new ResponseEntity((Object)prioridades, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.findTiposPleito", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.logger.error("Exception.findTiposPleito", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idPrioridade}/prioridadePleito"})
    @Operation(summary="Busca a prioridade do pleito conforme seu identificador.", description="Retorna os detalhes da prioridade de pleito com base no ID fornecido.")
    @ApiResponses(value={@ApiResponse(description="Prioridade de pleito encontrada com sucesso.", responseCode="200")})
    @NotNull
    public ResponseEntity<PrioridadePleito> getPrioridadePleitoById(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa, @Parameter(description="Identificador da prioridade de pleito") @PathVariable(name="idPrioridade") int idPrioridade, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.logger.debug("getPrioridadeById({}, {})", (Object)empresa, (Object)idPrioridade);
            ResponseEntity responseEntity = ResponseEntity.ok().body((Object)this.cadastrosPleitoService.getPrioridadePleitoById(Integer.valueOf(idPrioridade)));
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.getPrioridadeById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/prioridades"})
    @Operation(summary="Salva as prioridades de pleito a partir de seu payload", description="Cria ou atualiza uma prioridade de pleito com os dados fornecidos.")
    @ApiResponses(value={@ApiResponse(description="Prioridade de pleito criada com sucesso.", responseCode="201")})
    @NotNull
    public ResponseEntity<PrioridadePleito> savePrioridadePleito(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa, @RequestBody(description="Dados da prioridade de pleito a ser salva", required=true) @org.springframework.web.bind.annotation.RequestBody @NotNull PrioridadePleito prioridade, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)prioridade, (String)"prioridade");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            this.logger.debug("savePrioridadePleito({}, {})", (Object)empresa, (Object)prioridade);
            return new ResponseEntity((Object)this.cadastrosPleitoService.savePrioridadePleito(prioridade, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.savePrioridadePleito", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idPrioridade}/prioridades"})
    @Operation(summary="Exclui a prioridade do pleito de acordo com seu ID.", description="Remove permanentemente uma prioridade de pleito do sistema utilizando seu identificador.")
    @ApiResponses(value={@ApiResponse(description="Prioridade de pleito exclu\u00edda com sucesso.", responseCode="200")})
    @NotNull
    public ResponseEntity<Boolean> deletePrioridadePleito(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa, @Parameter(description="Identificador da prioridade de pleito a ser exclu\u00edda") @PathVariable(name="idPrioridade") int idPrioridade, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.logger.debug("deleteNivelAgencia({}, {})", (Object)empresa, (Object)idPrioridade);
            this.cadastrosPleitoService.deletePrioridadePleito(Integer.valueOf(idPrioridade));
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.deletePrioridadePleito", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/gruposTrabalho"})
    @Operation(summary="Retorna os grupos de trabalho de pleitos", description="Busca todos os grupos de trabalho de pleito dispon\u00edveis, com op\u00e7\u00e3o de filtro por texto.")
    @ApiResponses(value={@ApiResponse(description="Grupos de trabalho encontrados com sucesso.", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<List<GrupoTrabalho>> findGruposTrabalho(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.logger.debug("API findGruposTrabalho(emp={})...", (Object)empresa);
        try {
            List grupo;
            Empresa empresa2 = this.coreService.getEmpresaBySigla(empresa);
            if (empresa2 == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            Empresa empresaDB = empresa2;
            String search = request.getParameter("search");
            List list = grupo = this.cadastrosPleitoService.findGruposTrabalho(empresaDB.getId(), search);
            if (list != null) {
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    GrupoTrabalho grupos = (GrupoTrabalho)element$iv;
                    boolean bl = false;
                    grupos.setDatHorCadastro(null);
                    grupos.setIdUsuarioIns(null);
                    grupos.setDatHorAlteracao(null);
                    grupos.setIdUsuarioUpd(null);
                }
            }
            return new ResponseEntity((Object)grupo, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.findGruposTrabalho", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.logger.error("Exception.findGruposTrabalho", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idGrupoTrabalho}/gruposPleito"})
    @Operation(summary="Busca o grupo de trabalho conforme seu identificador.", description="Retorna os detalhes do grupo de trabalho de pleito com base no ID fornecido.")
    @ApiResponses(value={@ApiResponse(description="Grupo de trabalho encontrado com sucesso.", responseCode="200")})
    @NotNull
    public ResponseEntity<GrupoTrabalho> getGrupoTrabalhoById(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa, @Parameter(description="Identificador do grupo de trabalho") @PathVariable(name="idGrupoTrabalho") int idGrupoTrabalho, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.logger.debug("getGrupoTrabalhoById({}, {})", (Object)empresa, (Object)idGrupoTrabalho);
            ResponseEntity responseEntity = ResponseEntity.ok().body((Object)this.cadastrosPleitoService.getGrupoTrabalhoById(Integer.valueOf(idGrupoTrabalho)));
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.getGrupoTrabalhoById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/gruposTrabalho"})
    @Operation(summary="Salva os grupos de trabalho de pleito a partir de seu payload", description="Cria ou atualiza grupos de trabalho de pleito com os dados fornecidos.")
    @ApiResponses(value={@ApiResponse(description="Grupo de trabalho criado com sucesso.", responseCode="201")})
    @NotNull
    public ResponseEntity<GrupoTrabalho> saveGruposTrabalho(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa, @RequestBody(description="Dados do grupo de trabalho a ser salvo", required=true) @org.springframework.web.bind.annotation.RequestBody @NotNull GrupoTrabalho grupos, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)grupos, (String)"grupos");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            this.logger.debug("saveGruposTrabalho({}, {})", (Object)empresa, (Object)grupos);
            return new ResponseEntity((Object)this.cadastrosPleitoService.saveGrupoTrabalho(grupos, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveGruposTrabalho", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idGrupo}/gruposTrabalho"})
    @Operation(summary="Exclui o grupo de trabalho de pleito de acordo com seu ID.", description="Remove permanentemente um grupo de trabalho do pleito utilizando seu identificador.")
    @ApiResponses(value={@ApiResponse(description="Grupo de trabalho exclu\u00eddo com sucesso.", responseCode="200")})
    @NotNull
    public ResponseEntity<Boolean> deleteGrupoTrabalho(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa, @Parameter(description="Identificador do grupo de trabalho a ser exclu\u00eddo") @PathVariable(name="idGrupo") int idGrupo, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.logger.debug("deleteGrupoTrabalho({}, {})", (Object)empresa, (Object)idGrupo);
            this.cadastrosPleitoService.deleteGrupoTrabalho(Integer.valueOf(idGrupo));
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.deleteGrupoTrabalho", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/revisoesTarifarias"})
    @Operation(summary="Retorna as revis\u00f5es tarif\u00e1rias de pleitos", description="Busca todas as revis\u00f5es tarif\u00e1rias de pleitos dispon\u00edveis, com op\u00e7\u00e3o de filtro por texto.")
    @ApiResponses(value={@ApiResponse(description="Revis\u00f5es tarif\u00e1rias encontradas com sucesso.", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<List<RevisaoTarifaria>> findRevisoesTarifarias(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.logger.debug("API findRevisoesTarifarias(emp={})...", (Object)empresa);
        try {
            Empresa empresa2 = this.coreService.getEmpresaBySigla(empresa);
            if (empresa2 == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            Empresa empresaDB = empresa2;
            String search = null;
            if (request.getParameter("search") != null) {
                search = request.getParameter("search");
            }
            List list = this.cadastrosPleitoService.findRevisoesTarifarias(empresaDB.getId(), search, Boolean.valueOf(true));
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findRevisoesTarifarias(...)");
            List revisoes = list;
            if (!revisoes.isEmpty()) {
                for (RevisaoTarifaria revisao : revisoes) {
                    revisao.setDatHorCadastro(null);
                    revisao.setIdUsuarioIns(null);
                    revisao.setDatHorAlteracao(null);
                    revisao.setIdUsuarioUpd(null);
                }
            }
            return new ResponseEntity((Object)revisoes, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.findRevisoesTarifarias", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.logger.error("Exception.findRevisoesTarifarias", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idRevisaoTarifaria}/revisaoTarifaria"})
    @Operation(summary="Exibe a revis\u00e3o tarif\u00e1ria conforme seu identificador.", description="Retorna os detalhes da revis\u00e3o tarif\u00e1ria com base no ID fornecido.")
    @ApiResponses(value={@ApiResponse(description="Revis\u00e3o tarif\u00e1ria encontrada com sucesso.", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<RevisaoTarifaria> getRevisaoTarifaria(@Nullable HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="Identificador da revis\u00e3o tarif\u00e1ria") @PathVariable(name="idRevisaoTarifaria") @Nullable Integer idRevisaoTarifaria) {
        HttpServletRequest httpServletRequest = request;
        Intrinsics.checkNotNull((Object)httpServletRequest);
        PublicUser publicUser = this.getUsuarioByJWT(httpServletRequest);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.logger.debug("Executando getRevisaoTarifaria, {}, {}", (Object)empresa, (Object)idRevisaoTarifaria);
        try {
            Empresa empresa2 = this.coreService.getEmpresaBySigla(empresa);
            if (empresa2 == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            Empresa empresaDB = empresa2;
            RevisaoTarifaria revisaoTarifaria = this.cadastrosPleitoService.getRevisaoTarifariaById(empresaDB.getId(), idRevisaoTarifaria);
            if (revisaoTarifaria == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Revis\u00e3o n\u00e3o encontrada");
            }
            RevisaoTarifaria revisaoTarifaria2 = revisaoTarifaria;
            return new ResponseEntity((Object)revisaoTarifaria2, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.getRevisaoTarifaria", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.logger.error("Exception.getRevisaoTarifaria", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/revisoesTarifarias"})
    @Operation(summary="Salva as revis\u00f5es tarif\u00e1rias de pleito a partir de seu payload", description="Cria ou atualiza uma revis\u00e3o tarif\u00e1ria com os dados fornecidos.")
    @ApiResponses(value={@ApiResponse(description="Revis\u00e3o tarif\u00e1ria criada com sucesso.", responseCode="201")})
    @NotNull
    public ResponseEntity<RevisaoTarifaria> saveRevisaoTarifaria(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @RequestBody(description="Dados da revis\u00e3o tarif\u00e1ria a ser salva", required=true) @org.springframework.web.bind.annotation.RequestBody @Nullable RevisaoTarifaria revisao, @Nullable HttpServletRequest request) throws BusinessException {
        HttpServletRequest httpServletRequest = request;
        Intrinsics.checkNotNull((Object)httpServletRequest);
        PublicUser publicUser = this.getUsuarioByJWT(httpServletRequest);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            this.logger.debug("saveRevisaoTarifaria({}, {})", (Object)empresa, (Object)revisao);
            return new ResponseEntity((Object)this.cadastrosPleitoService.saveRevisaoTarifaria(revisao, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveRevisaoTarifaria", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"{empresa}/{idRevisao}/revisoesTarifarias"})
    @Operation(summary="Exclui a revis\u00e3o tarif\u00e1ria de acordo com seu ID.", description="Remove permanentemente uma revis\u00e3o tarif\u00e1ria do sistema utilizando seu identificador.")
    @ApiResponses(value={@ApiResponse(description="Revis\u00e3o tarif\u00e1ria exclu\u00edda com sucesso.", responseCode="200")})
    @NotNull
    public ResponseEntity<Boolean> deleteRevisaoTarifaria(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="Identificador da revis\u00e3o tarif\u00e1ria a ser exclu\u00edda") @PathVariable(name="idRevisao") @Nullable Integer idRevisao, @Nullable HttpServletRequest request) throws BusinessException {
        HttpServletRequest httpServletRequest = request;
        Intrinsics.checkNotNull((Object)httpServletRequest);
        PublicUser publicUser = this.getUsuarioByJWT(httpServletRequest);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.logger.debug("deleteRevisaoTarifaria({})", (Object)idRevisao);
            Empresa empresa2 = this.coreService.getEmpresaBySigla(empresa);
            if (empresa2 == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            Empresa empresaDB = empresa2;
            this.cadastrosPleitoService.deleteRevisaoTarifaria(empresaDB.getId(), idRevisao);
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.deleteRevisaoTarifaria", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/possibilidadesExito"})
    @Operation(summary="Retorna as possibilidades \u00eaxito de pleitos", description="Busca todas as possibilidades de \u00eaxito dispon\u00edveis, com op\u00e7\u00e3o de filtro por texto.")
    @ApiResponses(value={@ApiResponse(description="Possibilidades de \u00eaxito encontradas com sucesso.", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<List<PossibilidadeExito>> findPossibilidadesExito(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.logger.debug("API findPossibilidadesExito(), {}", (Object)empresa);
        try {
            List possibilidades;
            String search = request.getParameter("search");
            List list = possibilidades = this.cadastrosPleitoService.findPossibilidades(search, null);
            if (list != null) {
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PossibilidadeExito possibilidade = (PossibilidadeExito)element$iv;
                    boolean bl = false;
                    possibilidade.setDatHorCadastro(null);
                    possibilidade.setIdUsuarioIns(null);
                    possibilidade.setDatHorAlteracao(null);
                    possibilidade.setIdUsuarioUpd(null);
                }
            }
            return new ResponseEntity((Object)possibilidades, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.findPossibilidadesExito", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.logger.error("Exception.findPossibilidadesExito", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idPossibilidadeExito}/possibilidadesExito"})
    @Operation(summary="Busca a possibilidade de \u00eaxito conforme seu identificador.", description="Retorna os detalhes da possibilidade de \u00eaxito com base no ID fornecido.")
    @ApiResponses(value={@ApiResponse(description="Possibilidade de \u00eaxito encontrada com sucesso.", responseCode="200")})
    @NotNull
    public ResponseEntity<PossibilidadeExito> getPossibilidadeExitoById(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa, @Parameter(description="Identificador da possibilidade de \u00eaxito") @PathVariable(name="idPossibilidadeExito") int idPossibilidadeExito, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.logger.debug("getPossibilidadeExitoById({}, {})", (Object)empresa, (Object)idPossibilidadeExito);
            ResponseEntity responseEntity = ResponseEntity.ok().body((Object)this.cadastrosPleitoService.getPossibilidadeById(Integer.valueOf(idPossibilidadeExito)));
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.getPossibilidadeExitoById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/possibilidadesExito"})
    @Operation(summary="Salva as possibilidades de \u00eaxito a partir de seu payload", description="Cria ou atualiza uma possibilidade de \u00eaxito com os dados fornecidos.")
    @ApiResponses(value={@ApiResponse(description="Possibilidade de \u00eaxito criada com sucesso.", responseCode="201")})
    @NotNull
    public ResponseEntity<PossibilidadeExito> savePossibilidadeExito(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa, @RequestBody(description="Dados da possibilidade de \u00eaxito a ser salva", required=true) @org.springframework.web.bind.annotation.RequestBody @NotNull PossibilidadeExito possibilidade, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)possibilidade, (String)"possibilidade");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            this.logger.debug("savePossibilidadeExito({}, {})", (Object)empresa, (Object)possibilidade);
            return new ResponseEntity((Object)this.cadastrosPleitoService.savePossibilidade(possibilidade, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.savePossibilidadeExito", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idPossibilidade}/possibilidadesExito"})
    @Operation(summary="Exclui a possibilidade de \u00eaxito de acordo com seu ID.", description="Remove permanentemente uma possibilidade de \u00eaxito do sistema utilizando seu identificador.")
    @ApiResponses(value={@ApiResponse(description="Possibilidade de \u00eaxito exclu\u00edda com sucesso.", responseCode="200")})
    @NotNull
    public ResponseEntity<Boolean> deletePossibilidadeExito(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa, @Parameter(description="Identificador da possibilidade de \u00eaxito a ser exclu\u00edda") @PathVariable(name="idPossibilidade") int idPossibilidade, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.logger.debug("deletePossibilidadeExito({}, {})", (Object)empresa, (Object)idPossibilidade);
            this.cadastrosPleitoService.deletePossibilidade(Integer.valueOf(idPossibilidade));
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.deletePossibilidadeExito", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/faixasValores"})
    @Operation(summary="Retorna as faixas de valores de pleitos", description="Busca todas as faixas de valores dispon\u00edveis, com op\u00e7\u00e3o de filtro por texto.")
    @ApiResponses(value={@ApiResponse(description="Faixas de valores encontradas com sucesso.", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<List<FaixaValor>> findFaixasValores(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.logger.debug("API findFaixasValores(), {}", (Object)empresa);
        try {
            List faixas;
            String search = request.getParameter("search");
            List list = faixas = this.cadastrosPleitoService.findFaixasValores(search);
            if (list != null) {
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    FaixaValor faixa = (FaixaValor)element$iv;
                    boolean bl = false;
                    faixa.setDatHorCadastro(null);
                    faixa.setIdUsuarioIns(null);
                    faixa.setDatHorAlteracao(null);
                    faixa.setIdUsuarioUpd(null);
                }
            }
            return new ResponseEntity((Object)faixas, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.FaixaValor", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.logger.error("Exception.FaixaValor", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idFaixaValor}/faixaValor"})
    @Operation(summary="Busca a faixa de valor conforme seu identificador.", description="Retorna os detalhes da faixa de valor com base no ID fornecido.")
    @ApiResponses(value={@ApiResponse(description="Faixa de valor encontrada com sucesso.", responseCode="200")})
    @NotNull
    public ResponseEntity<FaixaValor> getFaixaValorById(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa, @Parameter(description="Identificador da faixa de valor") @PathVariable(name="idFaixaValor") int idFaixaValor, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.logger.debug("getFaixaValorById({}, {})", (Object)empresa, (Object)idFaixaValor);
            ResponseEntity responseEntity = ResponseEntity.ok().body((Object)this.cadastrosPleitoService.getFaixaValorById(Integer.valueOf(idFaixaValor)));
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.getFaixaValorById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/faixasValores"})
    @Operation(summary="Salva as faixas de valores a partir de seu payload", description="Cria ou atualiza uma faixa de valor com os dados fornecidos.")
    @ApiResponses(value={@ApiResponse(description="Faixa de valor criada com sucesso.", responseCode="201")})
    @NotNull
    public ResponseEntity<FaixaValor> saveFaixaValor(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa, @RequestBody(description="Dados da faixa de valor a ser salva", required=true) @org.springframework.web.bind.annotation.RequestBody @NotNull FaixaValor faixa, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)faixa, (String)"faixa");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            this.logger.debug("saveFaixaValor({}, {})", (Object)empresa, (Object)faixa);
            return new ResponseEntity((Object)this.cadastrosPleitoService.saveFaixaValor(faixa, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveFaixaValor", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idFaixa}/faixasValores"})
    @Operation(summary="Exclui a faixa de valor de acordo com seu ID.", description="Remove permanentemente uma faixa de valor do sistema utilizando seu identificador.")
    @ApiResponses(value={@ApiResponse(description="Faixa de valor exclu\u00edda com sucesso.", responseCode="200")})
    @NotNull
    public ResponseEntity<Boolean> deleteFaixaValor(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa, @Parameter(description="Identificador da faixa de valor a ser exclu\u00edda") @PathVariable(name="idFaixa") int idFaixa, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.logger.debug("deleteFaixaValor({}, {})", (Object)empresa, (Object)idFaixa);
            this.cadastrosPleitoService.deleteFaixaValor(Integer.valueOf(idFaixa));
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.deleteFaixaValor", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/assunto"})
    @Operation(summary="Salva um assunto pleito a partir de seu payload", description="Cria ou atualiza um assunto pleito com os dados fornecidos.")
    @ApiResponses(value={@ApiResponse(description="Assunto pleito criado com sucesso.", responseCode="201")})
    @NotNull
    public ResponseEntity<AssuntoPleito> saveAssuntoPleito(@NotNull HttpServletRequest request, @org.springframework.web.bind.annotation.RequestBody @Valid @NotNull CreateAssuntoPleitoDTO dto) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            return new ResponseEntity((Object)this.cadastrosPleitoService.saveAssuntoPleito(dto, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveFaixaValor", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/assunto"})
    @Operation(summary="Lista todos Assunto Pleito", description="Lista todos Assunto Pleito.")
    @ApiResponses(value={@ApiResponse(responseCode="200")})
    @NotNull
    public ResponseEntity<List<AssuntoPleito>> findAssuntoPleito(@NotNull HttpServletRequest request, @RequestParam(required=false) @Nullable String search) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            return new ResponseEntity((Object)this.cadastrosPleitoService.findAssuntosPleito(search), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveFaixaValor", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/assunto/{idAssunto}"})
    @Operation(summary="Lista Assunto Pleito de acordo com identificador informado.", description="Lista Assunto Pleito de acordo com identificador informado.")
    @ApiResponses(value={@ApiResponse(responseCode="200")})
    @NotNull
    public AssuntoPleito findAssuntoPleito(@NotNull HttpServletRequest request, @PathVariable int idAssunto) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            AssuntoPleito assuntoPleito = this.cadastrosPleitoService.findAssuntoPleitoById(Integer.valueOf(idAssunto));
            Intrinsics.checkNotNullExpressionValue((Object)assuntoPleito, (String)"findAssuntoPleitoById(...)");
            return assuntoPleito;
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveFaixaValor", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PutMapping(value={"/assunto/{idAssunto}"})
    @Operation(summary="Edi\u00e7\u00e3o de assunto pleito via identificador.", description="Edi\u00e7\u00e3o de assunto pleito via identificador.")
    @ApiResponses(value={@ApiResponse(responseCode="200")})
    @NotNull
    public ResponseEntity<AssuntoPleito> editAssuntoPleito(@RequestBody(description="ID do Assunto Pleito \u00e0 ser editado.", required=true) @PathVariable int idAssunto, @RequestBody(description="ID do Assunto Pleito \u00e0 ser editado.", required=true) @org.springframework.web.bind.annotation.RequestBody @NotNull CreateAssuntoPleitoDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            return new ResponseEntity((Object)this.cadastrosPleitoService.editAssuntoPleito(Integer.valueOf(idAssunto), dto, usr.getId()), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveFaixaValor", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/assunto/{idAssunto}"})
    @Operation(summary="Dele\u00e7\u00e3o de assunto pleito via identificador.", description="Dele\u00e7\u00e3o de assunto pleito via identificador.")
    @ApiResponses(value={@ApiResponse(responseCode="200")})
    public void deleteAssuntoPleito(@RequestBody(description="ID do Assunto Pleito \u00e0 ser deletado.", required=true) @PathVariable int idAssunto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            this.cadastrosPleitoService.deleteAssuntoPleito(Integer.valueOf(idAssunto));
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveFaixaValor", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/enquadramento"})
    @Operation(summary="Salva um enquadramento pleito a partir de seu payload", description="Cria ou atualiza um enquadramento pleito com os dados fornecidos.")
    @ApiResponses(value={@ApiResponse(description="Enquadramento pleito criado com sucesso.", responseCode="201")})
    @NotNull
    public ResponseEntity<EnquadramentoPleito> saveEnquadramentoPleito(@NotNull HttpServletRequest request, @org.springframework.web.bind.annotation.RequestBody @Valid @NotNull CreateEnquadramentoPleitoDTO dto) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            return new ResponseEntity((Object)this.cadastrosPleitoService.saveEnquadramentoPleito(dto, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveFaixaValor", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/enquadramento"})
    @Operation(summary="Lista todos Enquadramento Pleito", description="Lista todos Enquadramento Pleito.")
    @ApiResponses(value={@ApiResponse(responseCode="200")})
    @NotNull
    public ResponseEntity<Page<EnquadramentoPleito>> findEnquadramentosPleito(@NotNull HttpServletRequest request, @RequestParam(name="search", required=false) @Nullable String search, @RequestParam(name="idCoordenacao", required=false) @Nullable List<Integer> idCoordenacao, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            return new ResponseEntity((Object)this.cadastrosPleitoService.findEnquadramentosPleito(search, idCoordenacao, pageable), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveFaixaValor", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/enquadramento/{idEnquadramento}"})
    @Operation(summary="Lista todos Enquadramento Pleito", description="Lista todos Enquadramento Pleito.")
    @ApiResponses(value={@ApiResponse(responseCode="200")})
    @NotNull
    public ResponseEntity<EnquadramentoPleito> findEnquadramentoPleitoById(@NotNull HttpServletRequest request, @PathVariable int idEnquadramento) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            return new ResponseEntity((Object)this.cadastrosPleitoService.findEnquadramentoPleitoById(Integer.valueOf(idEnquadramento)), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveFaixaValor", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PutMapping(value={"/enquadramento/{idEnquadramento}"})
    @Operation(summary="Edi\u00e7\u00e3o de enquadramento pleito via identificador.", description="Edi\u00e7\u00e3o de enquadramento pleito via identificador.")
    @ApiResponses(value={@ApiResponse(responseCode="200")})
    @NotNull
    public ResponseEntity<EnquadramentoPleito> editEnquadramentoPleito(@RequestBody(description="ID do Enquadramento Pleito \u00e0 ser editado.", required=true) @PathVariable int idEnquadramento, @NotNull HttpServletRequest request, @org.springframework.web.bind.annotation.RequestBody @Valid @NotNull CreateEnquadramentoPleitoDTO dto) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            return new ResponseEntity((Object)this.cadastrosPleitoService.editEnquadramentoPleito(dto, Integer.valueOf(idEnquadramento), usr.getId()), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveFaixaValor", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/enquadramento/{idEnquadramento}"})
    @Operation(summary="Dele\u00e7\u00e3o de enquadramento pleito via identificador.", description="Dele\u00e7\u00e3o de enquadramento pleito via identificador.")
    @ApiResponses(value={@ApiResponse(responseCode="200")})
    public void deleteEnquadramentoPleito(@RequestBody(description="ID do Enquadramento Pleito \u00e0 ser deletado.", required=true) @PathVariable int idEnquadramento, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            this.cadastrosPleitoService.deleteEnquadramentoPleito(Integer.valueOf(idEnquadramento));
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveFaixaValor", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/tipoObra"})
    @Operation(summary="Salva um tipo de obra do pleito a partir de seu payload", description="Cria ou atualiza um tipo de obra do pleito com os dados fornecidos.")
    @ApiResponses(value={@ApiResponse(description="Tipo de obra criado com sucesso.", responseCode="201")})
    @NotNull
    public ResponseEntity<TipoObraPleito> saveTipoObraPleito(@NotNull HttpServletRequest request, @org.springframework.web.bind.annotation.RequestBody @Valid @NotNull CreateTipoObraPleitoDTO dto) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            return new ResponseEntity((Object)this.cadastrosPleitoService.saveTipoObraPleito(dto, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveFaixaValor", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/tipoObra"})
    @Operation(summary="Lista todos Tipos de Obra", description="Lista todos Tipos de Obra.")
    @ApiResponses(value={@ApiResponse(responseCode="200")})
    @NotNull
    public ResponseEntity<List<TipoObraPleito>> findTiposObraPleito(@NotNull HttpServletRequest request, @RequestParam(required=false) @Nullable String search) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            return new ResponseEntity((Object)this.cadastrosPleitoService.findTiposObraPleito(search), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveFaixaValor", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/tipoObra/{idTipoObra}"})
    @Operation(summary="Retorna um Tipos de Obra de acordo com seu identificador", description="Retorna um Tipos de Obra de acordo com seu identificador.")
    @ApiResponses(value={@ApiResponse(responseCode="200")})
    @NotNull
    public ResponseEntity<TipoObraPleito> findTipoObraPleitoById(@NotNull HttpServletRequest request, @PathVariable int idTipoObra) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            return new ResponseEntity((Object)this.cadastrosPleitoService.findTipoObraPleitoById(Integer.valueOf(idTipoObra)), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveFaixaValor", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PutMapping(value={"/tipoObra/{idTipoObra}"})
    @Operation(summary="Edi\u00e7\u00e3o de Tipos de Obra via identificador.", description="Edi\u00e7\u00e3o de Tipos de Obra via identificador.")
    @ApiResponses(value={@ApiResponse(responseCode="200")})
    @NotNull
    public ResponseEntity<TipoObraPleito> editTipoObraPleito(@RequestBody(description="ID do Tipo Obra Pleito \u00e0 ser editado.", required=true) @PathVariable int idTipoObra, @NotNull HttpServletRequest request, @org.springframework.web.bind.annotation.RequestBody @Valid @NotNull CreateTipoObraPleitoDTO dto) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            return new ResponseEntity((Object)this.cadastrosPleitoService.editTipoObraPleito(dto, Integer.valueOf(idTipoObra), usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveFaixaValor", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/tipoObra/{idTipoObra}"})
    @Operation(summary="Dele\u00e7\u00e3o de Tipos de Obra via identificador.", description="Dele\u00e7\u00e3o de Tipos de Obra via identificador.")
    @ApiResponses(value={@ApiResponse(responseCode="200")})
    public void deleteTipoObraPleito(@RequestBody(description="ID do Tipo de Obra \u00e0 ser deletado.", required=true) @PathVariable int idTipoObra, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            this.cadastrosPleitoService.deleteTipoObraPleito(Integer.valueOf(idTipoObra));
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveFaixaValor", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

