/*
 * Decompiled with CFR 0.152.
 */
package br.com.sigescantt.apis;

import br.com.sigescantt.apis.BaseRestService;
import br.com.sigescantt.core.beans.seguranca.PublicUser;
import br.com.sigescantt.core.dto.licencas.CreateCaraterCondicionanteDTO;
import br.com.sigescantt.core.dto.licencas.CreatePrioridadePlanoAcaoDTO;
import br.com.sigescantt.core.dto.licencas.CreateStatusCondicionanteDTO;
import br.com.sigescantt.core.dto.licencas.CreateStatusLicencaDTO;
import br.com.sigescantt.core.dto.licencas.CreateStatusPlanoAcaoDTO;
import br.com.sigescantt.core.dto.licencas.CreateTipoPlanoAcaoDTO;
import br.com.sigescantt.licencas.CaraterCondicionante;
import br.com.sigescantt.licencas.PrioridadePlanoAcao;
import br.com.sigescantt.licencas.StatusCondicionante;
import br.com.sigescantt.licencas.StatusLicenca;
import br.com.sigescantt.licencas.StatusPlanoAcao;
import br.com.sigescantt.licencas.TipoPlanoAcao;
import br.com.sigescantt.services.CadastrosLicencaService;
import br.com.sigescantt.services.Exceptions.ErrorCode;
import br.com.sigescantt.services.Exceptions.ErrorCodeException;
import br.com.sigescantt.services.SegurancaService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Cadastros Licen\u00e7as v1", description="REST Services para Cadastros de Licen\u00e7as Ambientais v1")
@Validated
@RestController
@RequestMapping(value={"/api/v1/cadastros/licencas"})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0017J$\u0010\u000e\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0017J\u001a\u0010\u0011\u001a\u00020\t2\b\b\u0001\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0017J*\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u00132\n\b\u0001\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\rH\u0017J\u001a\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0017J\u001a\u0010\u001a\u001a\u00020\u001b2\b\b\u0001\u0010\n\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\rH\u0017J$\u0010\u001d\u001a\u00020\u001b2\b\b\u0001\u0010\n\u001a\u00020\u001c2\b\b\u0001\u0010\u001e\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0017J\u001a\u0010\u001f\u001a\u00020\u001b2\b\b\u0001\u0010\u001e\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0017J*\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001b0\u00132\n\b\u0001\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\rH\u0017J\u001a\u0010!\u001a\u00020\u00192\b\b\u0001\u0010\u001e\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0017J\u001a\u0010\"\u001a\u00020#2\b\b\u0001\u0010\n\u001a\u00020$2\u0006\u0010\f\u001a\u00020\rH\u0017J$\u0010%\u001a\u00020#2\b\b\u0001\u0010\n\u001a\u00020$2\b\b\u0001\u0010&\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0017J\u001a\u0010'\u001a\u00020#2\b\b\u0001\u0010&\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0017J*\u0010(\u001a\b\u0012\u0004\u0012\u00020#0\u00132\n\b\u0001\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\rH\u0017J\u001a\u0010)\u001a\u00020\u00192\b\b\u0001\u0010&\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0017J\u001a\u0010*\u001a\u00020+2\b\b\u0001\u0010\n\u001a\u00020,2\u0006\u0010\f\u001a\u00020\rH\u0017J$\u0010-\u001a\u00020+2\b\b\u0001\u0010\n\u001a\u00020,2\b\b\u0001\u0010.\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0017J\u001a\u0010/\u001a\u00020+2\b\b\u0001\u0010.\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0017J*\u00100\u001a\b\u0012\u0004\u0012\u00020+0\u00132\n\b\u0001\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\rH\u0017J\u001a\u00101\u001a\u00020\u00192\b\b\u0001\u0010.\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0017J\u001a\u00102\u001a\u0002032\b\b\u0001\u0010\n\u001a\u0002042\u0006\u0010\f\u001a\u00020\rH\u0017J$\u00105\u001a\u0002032\b\b\u0001\u0010\n\u001a\u0002042\b\b\u0001\u00106\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0017J\u001a\u00107\u001a\u0002032\b\b\u0001\u00106\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0017J*\u00108\u001a\b\u0012\u0004\u0012\u0002030\u00132\n\b\u0001\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\rH\u0017J\u001a\u00109\u001a\u00020\u00192\b\b\u0001\u00106\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0017J\u001a\u0010:\u001a\u00020;2\b\b\u0001\u0010\n\u001a\u00020<2\u0006\u0010\f\u001a\u00020\rH\u0017J$\u0010=\u001a\u00020;2\b\b\u0001\u0010\n\u001a\u00020<2\b\b\u0001\u0010>\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0017J\u001a\u0010?\u001a\u00020;2\b\b\u0001\u0010>\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0017J*\u0010@\u001a\b\u0012\u0004\u0012\u00020;0\u00132\n\b\u0001\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\rH\u0017J\u001a\u0010A\u001a\u00020\u00192\b\b\u0001\u0010>\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lbr/com/sigescantt/apis/CadastrosLicencasRestServices;", "Lbr/com/sigescantt/apis/BaseRestService;", "segurancaService", "Lbr/com/sigescantt/services/SegurancaService;", "cadastrosLicencaService", "Lbr/com/sigescantt/services/CadastrosLicencaService;", "<init>", "(Lbr/com/sigescantt/services/SegurancaService;Lbr/com/sigescantt/services/CadastrosLicencaService;)V", "createStatusLicenca", "Lbr/com/sigescantt/licencas/StatusLicenca;", "dto", "Lbr/com/sigescantt/core/dto/licencas/CreateStatusLicencaDTO;", "request", "Ljakarta/servlet/http/HttpServletRequest;", "editStatusLicenca", "idStatusLicenca", "", "getStatusLicencaById", "getStatusLicenca", "Lorg/springframework/data/domain/Page;", "search", "", "pageable", "Lorg/springframework/data/domain/Pageable;", "deleteStatusLicenca", "", "createCaraterCondicionante", "Lbr/com/sigescantt/licencas/CaraterCondicionante;", "Lbr/com/sigescantt/core/dto/licencas/CreateCaraterCondicionanteDTO;", "editCaraterCondicionante", "idCaraterCondicionante", "getCaraterCondicionanteById", "getCaraterCondicionante", "deleteCaraterCondicionante", "createStatusCondicionante", "Lbr/com/sigescantt/licencas/StatusCondicionante;", "Lbr/com/sigescantt/core/dto/licencas/CreateStatusCondicionanteDTO;", "editStatusCondicionante", "idStatusCondicionante", "getStatusCondicionanteById", "getStatusCondicionante", "deleteStatusCondicionante", "createPrioridadePlanoAcao", "Lbr/com/sigescantt/licencas/PrioridadePlanoAcao;", "Lbr/com/sigescantt/core/dto/licencas/CreatePrioridadePlanoAcaoDTO;", "editPrioridadePlanoAcao", "idPrioridadePlanoAcao", "getPrioridadePlanoAcaoById", "getPrioridadePlanoAcao", "deletePrioridadePlanoAcao", "createTipoPlanoAcao", "Lbr/com/sigescantt/licencas/TipoPlanoAcao;", "Lbr/com/sigescantt/core/dto/licencas/CreateTipoPlanoAcaoDTO;", "editTipoPlanoAcao", "idTipoPlanoAcao", "getTipoPlanoAcaoById", "getTipoPlanoAcao", "deleteTipoPlanoAcao", "createStatusPlanoAcao", "Lbr/com/sigescantt/licencas/StatusPlanoAcao;", "Lbr/com/sigescantt/core/dto/licencas/CreateStatusPlanoAcaoDTO;", "editStatusPlanoAcao", "idStatusPlanoAcao", "getStatusPlanoAcaoById", "getStatusPlanoAcao", "deleteStatusPlanoAcao", "server"})
public class CadastrosLicencasRestServices
extends BaseRestService {
    @NotNull
    private final SegurancaService segurancaService;
    @NotNull
    private final CadastrosLicencaService cadastrosLicencaService;

    public CadastrosLicencasRestServices(@NotNull SegurancaService segurancaService, @NotNull CadastrosLicencaService cadastrosLicencaService) {
        Intrinsics.checkNotNullParameter((Object)segurancaService, (String)"segurancaService");
        Intrinsics.checkNotNullParameter((Object)cadastrosLicencaService, (String)"cadastrosLicencaService");
        super(segurancaService);
        this.segurancaService = segurancaService;
        this.cadastrosLicencaService = cadastrosLicencaService;
    }

    @PostMapping(value={"/status"})
    @Operation(summary="Cria um Status de Licen\u00e7as.", description="REST contendo cria\u00e7\u00e3o de Status para utiliza\u00e7\u00e3o em Licen\u00e7as.")
    @ApiResponses(value={@ApiResponse(description="Retorna o Status Licen\u00e7a criado.", responseCode="201")})
    @NotNull
    public StatusLicenca createStatusLicenca(@Valid @RequestBody @NotNull CreateStatusLicencaDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        PublicUser usuario = publicUser;
        StatusLicenca statusLicenca = this.cadastrosLicencaService.createStatusLicenca(dto, usuario.getId());
        Intrinsics.checkNotNullExpressionValue((Object)statusLicenca, (String)"createStatusLicenca(...)");
        return statusLicenca;
    }

    @PutMapping(value={"/status/{idStatusLicenca}"})
    @Operation(summary="Edita um Status de Licen\u00e7as.", description="REST contendo edi\u00e7\u00e3o de Status para utiliza\u00e7\u00e3o em Licen\u00e7as.")
    @ApiResponses(value={@ApiResponse(description="Retorna o Status Licen\u00e7a editado.", responseCode="200")})
    @NotNull
    public StatusLicenca editStatusLicenca(@Valid @RequestBody @NotNull CreateStatusLicencaDTO dto, @PathVariable(value="idStatusLicenca") int idStatusLicenca, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        PublicUser usuario = publicUser;
        StatusLicenca statusLicenca = this.cadastrosLicencaService.editStatusLicenca(dto, Integer.valueOf(idStatusLicenca), usuario.getId());
        Intrinsics.checkNotNullExpressionValue((Object)statusLicenca, (String)"editStatusLicenca(...)");
        return statusLicenca;
    }

    @GetMapping(value={"/status/{idStatusLicenca}"})
    @Operation(summary="Retorna um Status de Licen\u00e7as.", description="REST contendo retorno de Status para utiliza\u00e7\u00e3o em Licen\u00e7as de acordo com seu identificador.")
    @ApiResponses(value={@ApiResponse(description="Retorna o Status Licen\u00e7a de acordo com seu identificador.", responseCode="200")})
    @NotNull
    public StatusLicenca getStatusLicencaById(@PathVariable(value="idStatusLicenca") int idStatusLicenca, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.getUsuarioByJWT(request) == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        StatusLicenca statusLicenca = this.cadastrosLicencaService.getStatusLicencaById(Integer.valueOf(idStatusLicenca));
        Intrinsics.checkNotNullExpressionValue((Object)statusLicenca, (String)"getStatusLicencaById(...)");
        return statusLicenca;
    }

    @GetMapping(value={"/status"})
    @Operation(summary="Retorna os Status de Licen\u00e7as paginados.", description="REST paginado contendo retorno de Status para utiliza\u00e7\u00e3o em Licen\u00e7as.")
    @ApiResponses(value={@ApiResponse(description="Retorna os Status Licen\u00e7a.", responseCode="200")})
    @NotNull
    public Page<StatusLicenca> getStatusLicenca(@RequestParam(value="search", required=false) @Nullable String search, @NotNull Pageable pageable, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.getUsuarioByJWT(request) == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        Page page = this.cadastrosLicencaService.getStatusLicenca(search, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"getStatusLicenca(...)");
        return page;
    }

    @DeleteMapping(value={"/status/{idStatusLicenca}"})
    @Operation(summary="Deleta Status de Licen\u00e7as de acordo com seu identificador.", description="REST para dele\u00e7\u00e3o de um Status de Licen\u00e7as de acordo com seu identificador.")
    @ApiResponses(value={@ApiResponse(responseCode="200")})
    public void deleteStatusLicenca(@PathVariable(value="idStatusLicenca") int idStatusLicenca, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.getUsuarioByJWT(request) == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        this.cadastrosLicencaService.deleteStatusLicenca(Integer.valueOf(idStatusLicenca));
    }

    @PostMapping(value={"/caraterCondicionante"})
    @Operation(summary="Cria um Carater de Condicionante.", description="REST contendo cria\u00e7\u00e3o de Carater de Condicionante.")
    @ApiResponses(value={@ApiResponse(description="Retorna o Carater de Condicionante criado.", responseCode="201")})
    @NotNull
    public CaraterCondicionante createCaraterCondicionante(@Valid @RequestBody @NotNull CreateCaraterCondicionanteDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        PublicUser usuario = publicUser;
        CaraterCondicionante caraterCondicionante = this.cadastrosLicencaService.createCaraterCondicionante(dto, usuario.getId());
        Intrinsics.checkNotNullExpressionValue((Object)caraterCondicionante, (String)"createCaraterCondicionante(...)");
        return caraterCondicionante;
    }

    @PutMapping(value={"/caraterCondicionante/{idCaraterCondicionante}"})
    @Operation(summary="Edita um Carater de Condicionante.", description="REST contendo edi\u00e7\u00e3o de Carater de Condicionante.")
    @ApiResponses(value={@ApiResponse(description="Retorna o Carater de Condicionante editado.", responseCode="200")})
    @NotNull
    public CaraterCondicionante editCaraterCondicionante(@Valid @RequestBody @NotNull CreateCaraterCondicionanteDTO dto, @PathVariable(value="idCaraterCondicionante") int idCaraterCondicionante, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        PublicUser usuario = publicUser;
        CaraterCondicionante caraterCondicionante = this.cadastrosLicencaService.editCaraterCondicionante(dto, Integer.valueOf(idCaraterCondicionante), usuario.getId());
        Intrinsics.checkNotNullExpressionValue((Object)caraterCondicionante, (String)"editCaraterCondicionante(...)");
        return caraterCondicionante;
    }

    @GetMapping(value={"/caraterCondicionante/{idCaraterCondicionante}"})
    @Operation(summary="Retorna um Carater de Condicionante.", description="REST contendo retorno de Carater de Condicionante de acordo com seu identificador.")
    @ApiResponses(value={@ApiResponse(description="Retorna o Car\u00e1ter Condicionante de acordo com seu identificador.", responseCode="200")})
    @NotNull
    public CaraterCondicionante getCaraterCondicionanteById(@PathVariable(value="idCaraterCondicionante") int idCaraterCondicionante, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.getUsuarioByJWT(request) == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        CaraterCondicionante caraterCondicionante = this.cadastrosLicencaService.getCaraterCondicionanteById(Integer.valueOf(idCaraterCondicionante));
        Intrinsics.checkNotNullExpressionValue((Object)caraterCondicionante, (String)"getCaraterCondicionanteById(...)");
        return caraterCondicionante;
    }

    @GetMapping(value={"/caraterCondicionante"})
    @Operation(summary="Retorna os Car\u00e1teres de Condicionante paginados.", description="REST paginado contendo retorno de Car\u00e1teres de Condicionante.")
    @ApiResponses(value={@ApiResponse(description="Retorna os Car\u00e1teres de Condicionante.", responseCode="200")})
    @NotNull
    public Page<CaraterCondicionante> getCaraterCondicionante(@RequestParam(value="search", required=false) @Nullable String search, @NotNull Pageable pageable, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.getUsuarioByJWT(request) == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        Page page = this.cadastrosLicencaService.getCaraterCondicionante(search, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"getCaraterCondicionante(...)");
        return page;
    }

    @DeleteMapping(value={"/caraterCondicionante/{idCaraterCondicionante}"})
    @Operation(summary="Deleta Car\u00e1ter de Condicionante de acordo com seu identificador.", description="REST para dele\u00e7\u00e3o de um Status de Licen\u00e7as de acordo com seu identificador.")
    @ApiResponses(value={@ApiResponse(responseCode="200")})
    public void deleteCaraterCondicionante(@PathVariable(value="idCaraterCondicionante") int idCaraterCondicionante, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.getUsuarioByJWT(request) == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        this.cadastrosLicencaService.deleteCaraterCondicionante(Integer.valueOf(idCaraterCondicionante));
    }

    @PostMapping(value={"/statusCondicionante"})
    @Operation(summary="Cria um Status de Condicionante.", description="REST contendo cria\u00e7\u00e3o de Status de Condicionante.")
    @ApiResponses(value={@ApiResponse(description="Retorna o Status de Condicionante criado.", responseCode="201")})
    @NotNull
    public StatusCondicionante createStatusCondicionante(@Valid @RequestBody @NotNull CreateStatusCondicionanteDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        PublicUser usuario = publicUser;
        StatusCondicionante statusCondicionante = this.cadastrosLicencaService.createStatusCondicionante(dto, usuario.getId());
        Intrinsics.checkNotNullExpressionValue((Object)statusCondicionante, (String)"createStatusCondicionante(...)");
        return statusCondicionante;
    }

    @PutMapping(value={"/statusCondicionante/{idStatusCondicionante}"})
    @Operation(summary="Edita um Status de Condicionante.", description="REST contendo edi\u00e7\u00e3o de Status de Condicionante.")
    @ApiResponses(value={@ApiResponse(description="Retorna o Status de Condicionante editado.", responseCode="200")})
    @NotNull
    public StatusCondicionante editStatusCondicionante(@Valid @RequestBody @NotNull CreateStatusCondicionanteDTO dto, @PathVariable(value="idStatusCondicionante") int idStatusCondicionante, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        PublicUser usuario = publicUser;
        StatusCondicionante statusCondicionante = this.cadastrosLicencaService.editStatusCondicionante(dto, Integer.valueOf(idStatusCondicionante), usuario.getId());
        Intrinsics.checkNotNullExpressionValue((Object)statusCondicionante, (String)"editStatusCondicionante(...)");
        return statusCondicionante;
    }

    @GetMapping(value={"/statusCondicionante/{idStatusCondicionante}"})
    @Operation(summary="Retorna um Status de Condicionante.", description="REST contendo retorno de Status de Condicionante de acordo com seu identificador.")
    @ApiResponses(value={@ApiResponse(description="Retorna o Status de Condicionante de acordo com seu identificador.", responseCode="200")})
    @NotNull
    public StatusCondicionante getStatusCondicionanteById(@PathVariable(value="idStatusCondicionante") int idStatusCondicionante, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.getUsuarioByJWT(request) == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        StatusCondicionante statusCondicionante = this.cadastrosLicencaService.getStatusCondicionanteById(Integer.valueOf(idStatusCondicionante));
        Intrinsics.checkNotNullExpressionValue((Object)statusCondicionante, (String)"getStatusCondicionanteById(...)");
        return statusCondicionante;
    }

    @GetMapping(value={"/statusCondicionante"})
    @Operation(summary="Retorna os Status de Condicionante paginados.", description="REST paginado contendo retorno de Status de Condicionante.")
    @ApiResponses(value={@ApiResponse(description="Retorna os Status de Condicionante.", responseCode="200")})
    @NotNull
    public Page<StatusCondicionante> getStatusCondicionante(@RequestParam(value="search", required=false) @Nullable String search, @NotNull Pageable pageable, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.getUsuarioByJWT(request) == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        Page page = this.cadastrosLicencaService.getStatusCondicionante(search, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"getStatusCondicionante(...)");
        return page;
    }

    @DeleteMapping(value={"/statusCondicionante/{idStatusCondicionante}"})
    @Operation(summary="Deleta um Status de Condicionante de acordo com seu identificador.", description="REST para dele\u00e7\u00e3o de um Status de Condicionante de acordo com seu identificador.")
    @ApiResponses(value={@ApiResponse(responseCode="200")})
    public void deleteStatusCondicionante(@PathVariable(value="idStatusCondicionante") int idStatusCondicionante, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.getUsuarioByJWT(request) == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        this.cadastrosLicencaService.deleteStatusCondicionante(Integer.valueOf(idStatusCondicionante));
    }

    @PostMapping(value={"/prioridadePlanoAcao"})
    @Operation(summary="Cria uma Prioridade de Plano de A\u00e7\u00e3o.", description="REST contendo cria\u00e7\u00e3o de Prioridade de Plano de A\u00e7\u00e3o.")
    @ApiResponses(value={@ApiResponse(description="Retorna a Prioridade de Plano de A\u00e7\u00e3o criada.", responseCode="201")})
    @NotNull
    public PrioridadePlanoAcao createPrioridadePlanoAcao(@Valid @RequestBody @NotNull CreatePrioridadePlanoAcaoDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        PublicUser usuario = publicUser;
        PrioridadePlanoAcao prioridadePlanoAcao = this.cadastrosLicencaService.createPrioridadePlanoAcao(dto, usuario.getId());
        Intrinsics.checkNotNullExpressionValue((Object)prioridadePlanoAcao, (String)"createPrioridadePlanoAcao(...)");
        return prioridadePlanoAcao;
    }

    @PutMapping(value={"/prioridadePlanoAcao/{idPrioridadePlanoAcao}"})
    @Operation(summary="Edita uma Prioridade de Plano de A\u00e7\u00e3o.", description="REST contendo edi\u00e7\u00e3o de uma Prioridade de Plano de A\u00e7\u00e3o.")
    @ApiResponses(value={@ApiResponse(description="Retorna uma Prioridade de Plano de A\u00e7\u00e3o editada.", responseCode="200")})
    @NotNull
    public PrioridadePlanoAcao editPrioridadePlanoAcao(@Valid @RequestBody @NotNull CreatePrioridadePlanoAcaoDTO dto, @PathVariable(value="idPrioridadePlanoAcao") int idPrioridadePlanoAcao, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        PublicUser usuario = publicUser;
        PrioridadePlanoAcao prioridadePlanoAcao = this.cadastrosLicencaService.editPrioridadePlanoAcao(dto, Integer.valueOf(idPrioridadePlanoAcao), usuario.getId());
        Intrinsics.checkNotNullExpressionValue((Object)prioridadePlanoAcao, (String)"editPrioridadePlanoAcao(...)");
        return prioridadePlanoAcao;
    }

    @GetMapping(value={"/prioridadePlanoAcao/{idPrioridadePlanoAcao}"})
    @Operation(summary="Retorna uma Prioridade de Plano de A\u00e7\u00e3o.", description="REST contendo retorno de uma Prioridade de Plano de A\u00e7\u00e3o de acordo com seu identificador.")
    @ApiResponses(value={@ApiResponse(description="Retorna uma Prioridade de Plano de A\u00e7\u00e3o de acordo com seu identificador.", responseCode="200")})
    @NotNull
    public PrioridadePlanoAcao getPrioridadePlanoAcaoById(@PathVariable(value="idPrioridadePlanoAcao") int idPrioridadePlanoAcao, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.getUsuarioByJWT(request) == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        PrioridadePlanoAcao prioridadePlanoAcao = this.cadastrosLicencaService.getPrioridadePlanoAcaoById(Integer.valueOf(idPrioridadePlanoAcao));
        Intrinsics.checkNotNullExpressionValue((Object)prioridadePlanoAcao, (String)"getPrioridadePlanoAcaoById(...)");
        return prioridadePlanoAcao;
    }

    @GetMapping(value={"/prioridadePlanoAcao"})
    @Operation(summary="Retorna as Prioridades de Planos de A\u00e7\u00e3o paginados.", description="REST paginado contendo retorno de Prioridades de Planos de A\u00e7\u00e3o.")
    @ApiResponses(value={@ApiResponse(description="Retorna as Prioridades de Planos de A\u00e7\u00e3o.", responseCode="200")})
    @NotNull
    public Page<PrioridadePlanoAcao> getPrioridadePlanoAcao(@RequestParam(value="search", required=false) @Nullable String search, @NotNull Pageable pageable, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.getUsuarioByJWT(request) == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        Page page = this.cadastrosLicencaService.getPrioridadePlanoAcao(search, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"getPrioridadePlanoAcao(...)");
        return page;
    }

    @DeleteMapping(value={"/prioridadePlanoAcao/{idPrioridadePlanoAcao}"})
    @Operation(summary="Deleta uma Prioridade de Plano de A\u00e7\u00e3o de acordo com seu identificador.", description="REST para dele\u00e7\u00e3o de Prioridade de Plano de A\u00e7\u00e3o de acordo com seu identificador.")
    @ApiResponses(value={@ApiResponse(responseCode="200")})
    public void deletePrioridadePlanoAcao(@PathVariable(value="idPrioridadePlanoAcao") int idPrioridadePlanoAcao, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.getUsuarioByJWT(request) == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        this.cadastrosLicencaService.deletePrioridadePlanoAcao(Integer.valueOf(idPrioridadePlanoAcao));
    }

    @PostMapping(value={"/tipoPlanoAcao"})
    @Operation(summary="Cria um Tipo de Plano de A\u00e7\u00e3o.", description="REST contendo cria\u00e7\u00e3o de Tipo de Plano de A\u00e7\u00e3o.")
    @ApiResponses(value={@ApiResponse(description="Retorna o Tipo de Plano de A\u00e7\u00e3o criado.", responseCode="201")})
    @NotNull
    public TipoPlanoAcao createTipoPlanoAcao(@Valid @RequestBody @NotNull CreateTipoPlanoAcaoDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        PublicUser usuario = publicUser;
        TipoPlanoAcao tipoPlanoAcao = this.cadastrosLicencaService.createTipoPlanoAcao(dto, usuario.getId());
        Intrinsics.checkNotNullExpressionValue((Object)tipoPlanoAcao, (String)"createTipoPlanoAcao(...)");
        return tipoPlanoAcao;
    }

    @PutMapping(value={"/tipoPlanoAcao/{idTipoPlanoAcao}"})
    @Operation(summary="Edita um Tipo de Plano de A\u00e7\u00e3o.", description="REST contendo edi\u00e7\u00e3o de um Tipo de Plano de A\u00e7\u00e3o.")
    @ApiResponses(value={@ApiResponse(description="Retorna um Tipo de Plano de A\u00e7\u00e3o editado.", responseCode="200")})
    @NotNull
    public TipoPlanoAcao editTipoPlanoAcao(@Valid @RequestBody @NotNull CreateTipoPlanoAcaoDTO dto, @PathVariable(value="idTipoPlanoAcao") int idTipoPlanoAcao, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        PublicUser usuario = publicUser;
        TipoPlanoAcao tipoPlanoAcao = this.cadastrosLicencaService.editTipoPlanoAcao(dto, Integer.valueOf(idTipoPlanoAcao), usuario.getId());
        Intrinsics.checkNotNullExpressionValue((Object)tipoPlanoAcao, (String)"editTipoPlanoAcao(...)");
        return tipoPlanoAcao;
    }

    @GetMapping(value={"/tipoPlanoAcao/{idTipoPlanoAcao}"})
    @Operation(summary="Retorna um Tipo de Plano de A\u00e7\u00e3o.", description="REST contendo retorno de um Tipo de Plano de A\u00e7\u00e3o de acordo com seu identificador.")
    @ApiResponses(value={@ApiResponse(description="Retorna um Tipo de Plano de A\u00e7\u00e3o de acordo com seu identificador.", responseCode="200")})
    @NotNull
    public TipoPlanoAcao getTipoPlanoAcaoById(@PathVariable(value="idTipoPlanoAcao") int idTipoPlanoAcao, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.getUsuarioByJWT(request) == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        TipoPlanoAcao tipoPlanoAcao = this.cadastrosLicencaService.getTipoPlanoAcaoById(Integer.valueOf(idTipoPlanoAcao));
        Intrinsics.checkNotNullExpressionValue((Object)tipoPlanoAcao, (String)"getTipoPlanoAcaoById(...)");
        return tipoPlanoAcao;
    }

    @GetMapping(value={"/tipoPlanoAcao"})
    @Operation(summary="Retorna os Tipos de Planos de A\u00e7\u00e3o paginados.", description="REST paginado contendo retorno de Tipos de Planos de A\u00e7\u00e3o.")
    @ApiResponses(value={@ApiResponse(description="Retorna os Tipos de Planos de A\u00e7\u00e3o.", responseCode="200")})
    @NotNull
    public Page<TipoPlanoAcao> getTipoPlanoAcao(@RequestParam(value="search", required=false) @Nullable String search, @NotNull Pageable pageable, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.getUsuarioByJWT(request) == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        Page page = this.cadastrosLicencaService.getTipoPlanoAcao(search, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"getTipoPlanoAcao(...)");
        return page;
    }

    @DeleteMapping(value={"/tipoPlanoAcao/{idTipoPlanoAcao}"})
    @Operation(summary="Deleta um Tipo de Plano de A\u00e7\u00e3o de acordo com seu identificador.", description="REST para dele\u00e7\u00e3o de um Tipo de Plano de A\u00e7\u00e3o de acordo com seu identificador.")
    @ApiResponses(value={@ApiResponse(responseCode="200")})
    public void deleteTipoPlanoAcao(@PathVariable(value="idTipoPlanoAcao") int idTipoPlanoAcao, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.getUsuarioByJWT(request) == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        this.cadastrosLicencaService.deleteTipoPlanoAcao(Integer.valueOf(idTipoPlanoAcao));
    }

    @PostMapping(value={"/statusPlanoAcao"})
    @Operation(summary="Cria um Status de Plano de A\u00e7\u00e3o.", description="REST contendo cria\u00e7\u00e3o de Status de Plano de A\u00e7\u00e3o.")
    @ApiResponses(value={@ApiResponse(description="Retorna o Status de Plano de A\u00e7\u00e3o criado.", responseCode="201")})
    @NotNull
    public StatusPlanoAcao createStatusPlanoAcao(@Valid @RequestBody @NotNull CreateStatusPlanoAcaoDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        PublicUser usuario = publicUser;
        StatusPlanoAcao statusPlanoAcao = this.cadastrosLicencaService.createStatusPlanoAcao(dto, usuario.getId());
        Intrinsics.checkNotNullExpressionValue((Object)statusPlanoAcao, (String)"createStatusPlanoAcao(...)");
        return statusPlanoAcao;
    }

    @PutMapping(value={"/statusPlanoAcao/{idStatusPlanoAcao}"})
    @Operation(summary="Edita um Status de Plano de A\u00e7\u00e3o.", description="REST contendo edi\u00e7\u00e3o de um Status de Plano de A\u00e7\u00e3o.")
    @ApiResponses(value={@ApiResponse(description="Retorna um Status de Plano de A\u00e7\u00e3o editado.", responseCode="200")})
    @NotNull
    public StatusPlanoAcao editStatusPlanoAcao(@Valid @RequestBody @NotNull CreateStatusPlanoAcaoDTO dto, @PathVariable(value="idStatusPlanoAcao") int idStatusPlanoAcao, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        PublicUser usuario = publicUser;
        StatusPlanoAcao statusPlanoAcao = this.cadastrosLicencaService.editStatusPlanoAcao(dto, Integer.valueOf(idStatusPlanoAcao), usuario.getId());
        Intrinsics.checkNotNullExpressionValue((Object)statusPlanoAcao, (String)"editStatusPlanoAcao(...)");
        return statusPlanoAcao;
    }

    @GetMapping(value={"/statusPlanoAcao/{idStatusPlanoAcao}"})
    @Operation(summary="Retorna um Status de Plano de A\u00e7\u00e3o.", description="REST contendo retorno de um Status de Plano de A\u00e7\u00e3o de acordo com seu identificador.")
    @ApiResponses(value={@ApiResponse(description="Retorna um Status de Plano de A\u00e7\u00e3o de acordo com seu identificador.", responseCode="200")})
    @NotNull
    public StatusPlanoAcao getStatusPlanoAcaoById(@PathVariable(value="idStatusPlanoAcao") int idStatusPlanoAcao, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.getUsuarioByJWT(request) == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        StatusPlanoAcao statusPlanoAcao = this.cadastrosLicencaService.getStatusPlanoAcaoById(Integer.valueOf(idStatusPlanoAcao));
        Intrinsics.checkNotNullExpressionValue((Object)statusPlanoAcao, (String)"getStatusPlanoAcaoById(...)");
        return statusPlanoAcao;
    }

    @GetMapping(value={"/statusPlanoAcao"})
    @Operation(summary="Retorna os Status de Planos de A\u00e7\u00e3o paginados.", description="REST paginado contendo retorno de Status de Planos de A\u00e7\u00e3o.")
    @ApiResponses(value={@ApiResponse(description="Retorna os Status de Planos de A\u00e7\u00e3o.", responseCode="200")})
    @NotNull
    public Page<StatusPlanoAcao> getStatusPlanoAcao(@RequestParam(value="search", required=false) @Nullable String search, @NotNull Pageable pageable, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.getUsuarioByJWT(request) == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        Page page = this.cadastrosLicencaService.getStatusPlanoAcao(search, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"getStatusPlanoAcao(...)");
        return page;
    }

    @DeleteMapping(value={"/statusPlanoAcao/{idStatusPlanoAcao}"})
    @Operation(summary="Deleta um Status de Plano de A\u00e7\u00e3o de acordo com seu identificador.", description="REST para dele\u00e7\u00e3o de um Status de Plano de A\u00e7\u00e3o de acordo com seu identificador.")
    @ApiResponses(value={@ApiResponse(responseCode="200")})
    public void deleteStatusPlanoAcao(@PathVariable(value="idStatusPlanoAcao") int idStatusPlanoAcao, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.getUsuarioByJWT(request) == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        this.cadastrosLicencaService.deleteStatusPlanoAcao(Integer.valueOf(idStatusPlanoAcao));
    }
}

