/*
 * Decompiled with CFR 0.152.
 */
package br.com.sigescantt.apis;

import br.com.sigescantt.apis.BaseRestService;
import br.com.sigescantt.core.beans.geral.Empresa;
import br.com.sigescantt.core.beans.seguranca.Usuario;
import br.com.sigescantt.core.dto.geral.empresa.area.EmpresaAreaDTO;
import br.com.sigescantt.core.dto.geral.empresa.area.EmpresaAreaResponsavelDTO;
import br.com.sigescantt.core.dto.geral.empresa.area.EmpresaAreaStructuredDTO;
import br.com.sigescantt.geral.EmpresaArea;
import br.com.sigescantt.geral.EmpresaAreaResponsavel;
import br.com.sigescantt.services.CadastroService;
import br.com.sigescantt.services.SegurancaService;
import br.com.sigescantt.services.empresa.EmpresaService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@Tag(name="empresas", description="REST Services para ag\u00eancia")
@RequestMapping(value={"/api/v1/agencia"})
@Validated
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0017J3\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\n\b\u0001\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0017\u00a2\u0006\u0002\u0010\u0016J3\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u000f2\n\b\u0001\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0017\u00a2\u0006\u0002\u0010\u0016J\u001a\u0010\u0019\u001a\u00020\u00102\b\b\u0001\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J\u001a\u0010\u001c\u001a\u00020\u00102\b\b\u0001\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J$\u0010\u001f\u001a\u00020\u00102\b\b\u0001\u0010\u001d\u001a\u00020\u001e2\b\b\u0001\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J\u001a\u0010 \u001a\u00020!2\b\b\u0001\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J>\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0010\b\u0001\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u000f2\n\b\u0001\u0010%\u001a\u0004\u0018\u00010&2\b\b\u0001\u0010'\u001a\u00020(2\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J\u001a\u0010)\u001a\u00020*2\b\b\u0001\u0010+\u001a\u00020*2\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J\u001a\u0010,\u001a\u00020*2\b\b\u0001\u0010+\u001a\u00020*2\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J$\u0010-\u001a\u00020!2\b\b\u0001\u0010\u001a\u001a\u00020\u001b2\b\b\u0001\u0010.\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lbr/com/sigescantt/apis/AgenciasRestServices;", "Lbr/com/sigescantt/apis/BaseRestService;", "segurancaService", "Lbr/com/sigescantt/services/SegurancaService;", "empresaService", "Lbr/com/sigescantt/services/empresa/EmpresaService;", "cadastroService", "Lbr/com/sigescantt/services/CadastroService;", "<init>", "(Lbr/com/sigescantt/services/SegurancaService;Lbr/com/sigescantt/services/empresa/EmpresaService;Lbr/com/sigescantt/services/CadastroService;)V", "logger", "Lorg/slf4j/Logger;", "findAgenciaEmpresa", "Lbr/com/sigescantt/core/beans/geral/Empresa;", "findAreas", "", "Lbr/com/sigescantt/core/dto/geral/empresa/area/EmpresaAreaDTO;", "inativo", "", "visivelEmPleito", "request", "Ljakarta/servlet/http/HttpServletRequest;", "(Ljava/lang/Boolean;Ljava/lang/Boolean;Ljakarta/servlet/http/HttpServletRequest;)Ljava/util/List;", "findAreasStructured", "Lbr/com/sigescantt/core/dto/geral/empresa/area/EmpresaAreaStructuredDTO;", "getAreaById", "idArea", "", "saveArea", "empresaArea", "Lbr/com/sigescantt/geral/EmpresaArea;", "editArea", "deleteArea", "", "getResponsaveisArea", "Lorg/springframework/data/domain/Page;", "Lbr/com/sigescantt/core/dto/geral/empresa/area/EmpresaAreaResponsavelDTO;", "search", "", "pageable", "Lorg/springframework/data/domain/Pageable;", "saveResponsavelArea", "Lbr/com/sigescantt/geral/EmpresaAreaResponsavel;", "responsavel", "editResponsavelArea", "deleteResponsavelArea", "idUsuario", "server"})
@SourceDebugExtension(value={"SMAP\nAgenciasRestServices.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AgenciasRestServices.kt\nbr/com/sigescantt/apis/AgenciasRestServices\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,258:1\n1557#2:259\n1628#2,3:260\n774#2:263\n865#2,2:264\n1557#2:266\n1628#2,3:267\n774#2:271\n865#2,2:272\n1557#2:274\n1628#2,3:275\n1#3:270\n*S KotlinDebug\n*F\n+ 1 AgenciasRestServices.kt\nbr/com/sigescantt/apis/AgenciasRestServices\n*L\n71#1:259\n71#1:260,3\n92#1:263\n92#1:264,2\n99#1:266\n99#1:267,3\n95#1:271\n95#1:272,2\n96#1:274\n96#1:275,3\n*E\n"})
public class AgenciasRestServices
extends BaseRestService {
    @NotNull
    private final SegurancaService segurancaService;
    @NotNull
    private final EmpresaService empresaService;
    @NotNull
    private final CadastroService cadastroService;
    @NotNull
    private final Logger logger;

    public AgenciasRestServices(@NotNull SegurancaService segurancaService, @NotNull EmpresaService empresaService, @NotNull CadastroService cadastroService) {
        Intrinsics.checkNotNullParameter((Object)segurancaService, (String)"segurancaService");
        Intrinsics.checkNotNullParameter((Object)empresaService, (String)"empresaService");
        Intrinsics.checkNotNullParameter((Object)cadastroService, (String)"cadastroService");
        super(segurancaService);
        this.segurancaService = segurancaService;
        this.empresaService = empresaService;
        this.cadastroService = cadastroService;
        Logger logger = LoggerFactory.getLogger(AgenciasRestServices.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    @GetMapping
    @Operation(summary="Busca a \u00fanica empresa ag\u00eancia.")
    @ApiResponses(value={@ApiResponse(description="Empresa ag\u00eancia encontrada com sucesso.", responseCode="200"), @ApiResponse(description="Empresa ag\u00eancia n\u00e3o encontrada.", responseCode="404")})
    @NotNull
    public Empresa findAgenciaEmpresa() {
        this.logger.debug("API findAgenciaEmpresa...");
        Empresa empresa = this.empresaService.findAgenciaEmpresa();
        Intrinsics.checkNotNullExpressionValue((Object)empresa, (String)"findAgenciaEmpresa(...)");
        return empresa;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"/areas"})
    @Operation(summary="Lista as \u00e1reas da ag\u00eancia. Retorna a lista das \u00e1reas que pertencem \u00e0 ag\u00eancia.")
    @ApiResponses(value={@ApiResponse(description="\u00c1reas listadas com sucesso.", responseCode="200")})
    @NotNull
    public List<EmpresaAreaDTO> findAreas(@RequestParam(value="inativo", required=false) @Nullable Boolean inativo, @RequestParam(value="visivelEmPleito", required=false) @Nullable Boolean visivelEmPleito, @NotNull HttpServletRequest request) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        List list = this.empresaService.findAgenciaAreas(inativo, visivelEmPleito, usuario2);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findAgenciaAreas(...)");
        Iterable iterable = list;
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void area;
            EmpresaArea empresaArea = (EmpresaArea)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(EmpresaAreaDTO.fromEntity((EmpresaArea)area));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"/areas/structured"})
    @Operation(summary="Lista as \u00e1reas da ag\u00eancia de forma estruturada. Retorna a lista das \u00e1reas que pertencem \u00e0 ag\u00eancia.")
    @ApiResponses(value={@ApiResponse(description="\u00c1reas listadas com sucesso.", responseCode="200")})
    @NotNull
    public List<EmpresaAreaStructuredDTO> findAreasStructured(@RequestParam(value="inativo", required=false) @Nullable Boolean inativo, @RequestParam(value="visivelEmPleito", required=false) @Nullable Boolean visivelEmPleito, @NotNull HttpServletRequest request) {
        void $this$mapTo$iv$iv;
        EmpresaArea it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        List allAreas = this.empresaService.findAgenciaAreas(inativo, visivelEmPleito, usuario2);
        Intrinsics.checkNotNull((Object)allAreas);
        Iterable $this$filter$iv = allAreas;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (EmpresaArea)element$iv$iv;
            boolean bl = false;
            if (!(it.getIdAreaPai() == null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List rootAreas = (List)destination$iv$iv;
        Iterable $this$map$iv = rootAreas;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (EmpresaArea)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(AgenciasRestServices.findAreasStructured$buildStructuredDTO((List)allAreas, (EmpresaArea)it));
        }
        return (List)destination$iv$iv;
    }

    @GetMapping(value={"/areas/{idArea}"})
    @Operation(summary="Busca a \u00e1rea da ag\u00eancia com base no ID informado.")
    @ApiResponses(value={@ApiResponse(description="\u00c1rea encontrada com sucesso.", responseCode="200"), @ApiResponse(description="ID da \u00e1rea inv\u00e1lido ou n\u00e3o encontrado.", responseCode="400")})
    @NotNull
    public EmpresaAreaDTO getAreaById(@Parameter(description="Identificador da \u00e1rea") @PathVariable(name="idArea") int idArea, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        EmpresaArea area = this.empresaService.getAgenciaAreaById(idArea, usuario2);
        boolean bl = false;
        EmpresaAreaDTO empresaAreaDTO = EmpresaAreaDTO.fromEntity((EmpresaArea)area);
        Intrinsics.checkNotNullExpressionValue((Object)empresaAreaDTO, (String)"let(...)");
        return empresaAreaDTO;
    }

    @PostMapping(value={"/areas"})
    @Operation(summary="Salva a \u00e1rea da empresa. Registra uma nova \u00e1rea com os dados fornecidos no payload.")
    @ApiResponses(value={@ApiResponse(description="\u00c1rea salva com sucesso.", responseCode="201")})
    @NotNull
    public EmpresaAreaDTO saveArea(@RequestBody(description="Payload contendo os dados da \u00e1rea da empresa") @org.springframework.web.bind.annotation.RequestBody @NotNull EmpresaArea empresaArea, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresaArea, (String)"empresaArea");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        this.logger.debug("{} - saveArea({})", (Object)usuario2.getLogin(), (Object)empresaArea);
        EmpresaArea area = this.empresaService.saveAgenciaArea(empresaArea, usuario2);
        boolean bl = false;
        EmpresaAreaDTO empresaAreaDTO = EmpresaAreaDTO.fromEntity((EmpresaArea)area);
        Intrinsics.checkNotNullExpressionValue((Object)empresaAreaDTO, (String)"let(...)");
        return empresaAreaDTO;
    }

    @PutMapping(value={"/areas/{idArea}"})
    @Operation(summary="Edita a \u00e1rea da empresa. Edita uma \u00e1rea existente com os dados fornecidos no payload.")
    @ApiResponses(value={@ApiResponse(description="\u00c1rea editada com sucesso.", responseCode="201")})
    @NotNull
    public EmpresaAreaDTO editArea(@RequestBody(description="Payload contendo os dados da \u00e1rea da empresa") @org.springframework.web.bind.annotation.RequestBody @NotNull EmpresaArea empresaArea, @PathVariable int idArea, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresaArea, (String)"empresaArea");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        this.logger.debug("{} - saveArea({})", (Object)usuario2.getLogin(), (Object)empresaArea);
        EmpresaArea area = this.empresaService.editAgenciaArea(empresaArea, usuario2, Integer.valueOf(idArea));
        boolean bl = false;
        EmpresaAreaDTO empresaAreaDTO = EmpresaAreaDTO.fromEntity((EmpresaArea)area);
        Intrinsics.checkNotNullExpressionValue((Object)empresaAreaDTO, (String)"let(...)");
        return empresaAreaDTO;
    }

    @DeleteMapping(value={"/areas/{idArea}"})
    @Operation(summary="Exclui a \u00e1rea da ag\u00eancia com base no identificador informado.")
    @ApiResponses(value={@ApiResponse(description="\u00c1rea exclu\u00edda com sucesso.", responseCode="200"), @ApiResponse(description="ID da \u00e1rea inv\u00e1lido ou n\u00e3o encontrado.", responseCode="400")})
    public void deleteArea(@Parameter(description="Identificador da \u00e1rea a ser exclu\u00edda") @PathVariable(name="idArea") int idArea, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        this.logger.debug("{} - deleteArea({})", (Object)usuario2.getLogin(), (Object)idArea);
        this.empresaService.deleteAgenciaArea(idArea, usuario2);
    }

    @GetMapping(value={"/areas/usuarios"})
    @Operation(summary="Retorna os usu\u00e1rios paginados pertencentes \u00e0 \u00e1rea de uma ag\u00eancia com base no identificador informado.")
    @ApiResponses(value={@ApiResponse(description="\u00c1rea exclu\u00edda com sucesso.", responseCode="200"), @ApiResponse(description="ID da \u00e1rea inv\u00e1lido ou n\u00e3o encontrado.", responseCode="400")})
    @NotNull
    public Page<EmpresaAreaResponsavelDTO> getResponsaveisArea(@Parameter(description="Identificador da(s) \u00e1rea(s)") @RequestParam(name="idArea", required=false) @Nullable List<Integer> idArea, @Parameter(description="Par\u00e2metro de pesquisa por meio de nome/email do respons\u00e1vel pela \u00e1rea") @RequestParam(name="search", required=false) @Nullable String search, @Parameter(description="Par\u00e2metro de pagina\u00e7\u00e3o") @NotNull Pageable pageable, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        this.logger.debug("{} - getUsuariosArea({})", (Object)usuario2.getLogin(), idArea);
        Page page = this.empresaService.findResponsaveisByAgenciaArea(idArea, search, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findResponsaveisByAgenciaArea(...)");
        return page;
    }

    @PostMapping(value={"/areas/usuarios"})
    @Operation(summary="Salva um usu\u00e1rio associando-o \u00e0 \u00e1rea de acordo com os identificadores informados.")
    @ApiResponses(value={@ApiResponse(description="Usu\u00e1rio associado \u00e0 \u00e1rea com sucesso.", responseCode="200"), @ApiResponse(description="ID da \u00e1rea/usu\u00e1rio inv\u00e1lido ou n\u00e3o encontrado.", responseCode="400")})
    @NotNull
    public EmpresaAreaResponsavel saveResponsavelArea(@Parameter(description="Payload para cria\u00e7\u00e3o") @RequestBody @org.springframework.web.bind.annotation.RequestBody @NotNull EmpresaAreaResponsavel responsavel, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)responsavel, (String)"responsavel");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        this.logger.debug("{} - saveResponsavelArea()", (Object)usuario2.getLogin());
        EmpresaAreaResponsavel empresaAreaResponsavel = this.empresaService.saveResponsavelAgenciaArea(responsavel, usuario2);
        Intrinsics.checkNotNullExpressionValue((Object)empresaAreaResponsavel, (String)"saveResponsavelAgenciaArea(...)");
        return empresaAreaResponsavel;
    }

    @PutMapping(value={"/areas/usuarios"})
    @Operation(summary="Edita um usu\u00e1rio de uma \u00e1rea de acordo com os identificadores informados.")
    @ApiResponses(value={@ApiResponse(description="Usu\u00e1rio editado com sucesso.", responseCode="200"), @ApiResponse(description="ID da \u00e1rea/usu\u00e1rio inv\u00e1lido ou n\u00e3o encontrado.", responseCode="400")})
    @NotNull
    public EmpresaAreaResponsavel editResponsavelArea(@Parameter(description="Payload para edi\u00e7\u00e3o") @RequestBody @org.springframework.web.bind.annotation.RequestBody @NotNull EmpresaAreaResponsavel responsavel, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)responsavel, (String)"responsavel");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        this.logger.debug("{} - saveResponsavelArea()", (Object)usuario2.getLogin());
        EmpresaAreaResponsavel empresaAreaResponsavel = this.empresaService.editResponsavelAgenciaArea(responsavel, usuario2);
        Intrinsics.checkNotNullExpressionValue((Object)empresaAreaResponsavel, (String)"editResponsavelAgenciaArea(...)");
        return empresaAreaResponsavel;
    }

    @DeleteMapping(value={"/areas/usuarios"})
    @Operation(summary="Edita um usu\u00e1rio de uma \u00e1rea de acordo com os identificadores informados.")
    @ApiResponses(value={@ApiResponse(description="Usu\u00e1rio editado com sucesso.", responseCode="200"), @ApiResponse(description="ID da \u00e1rea/usu\u00e1rio inv\u00e1lido ou n\u00e3o encontrado.", responseCode="400")})
    public void deleteResponsavelArea(@Parameter(description="Identificador da \u00e1rea") @RequestParam(name="idArea") int idArea, @Parameter(description="Identificador do usu\u00e1rio respons\u00e1vel") @RequestParam(name="idUsuario") int idUsuario, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        this.logger.debug("{} - deleteResponsavelArea()", (Object)usuario2.getLogin());
        this.empresaService.deleteResponsavelAgenciaArea(Integer.valueOf(idArea), Integer.valueOf(idUsuario));
    }

    /*
     * WARNING - void declaration
     */
    private static final EmpresaAreaStructuredDTO findAreasStructured$buildStructuredDTO(List<EmpresaArea> allAreas, EmpresaArea area) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNull(allAreas);
        Iterable $this$filter$iv = allAreas;
        boolean $i$f$filter22 = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            EmpresaArea it = (EmpresaArea)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getIdAreaPai(), (Object)area.getId())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List children = (List)destination$iv$iv;
        Iterable $i$f$filter22 = children;
        EmpresaArea empresaArea = area;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            EmpresaArea bl = (EmpresaArea)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(AgenciasRestServices.findAreasStructured$buildStructuredDTO(allAreas, (EmpresaArea)it));
        }
        EmpresaAreaStructuredDTO empresaAreaStructuredDTO = EmpresaAreaStructuredDTO.fromEntityWithChildren((EmpresaArea)empresaArea, (List)((List)destination$iv$iv2));
        Intrinsics.checkNotNullExpressionValue((Object)empresaAreaStructuredDTO, (String)"fromEntityWithChildren(...)");
        return empresaAreaStructuredDTO;
    }
}

