/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.shared;

import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.geral.Entidade;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.beans.shared.TipoDocumento;
import br.com.oti.gesconsys.business.CoreService;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para tipos de documento. Ir\u00e1 abranger Correspond\u00eancias, Obriga\u00e7\u00f5es, Licen\u00e7as e Notifica\u00e7\u00f5es", name="tiposDocumento")
@RequestMapping(value={"/api/tiposDocumento"})
public class TiposDocumentoRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(TiposDocumentoRestServices.class);
    @Autowired
    private CoreService coreService;
    @Autowired
    private CadastroService cadastroService;

    @GetMapping(value={"/{empresa}/{classe}"})
    @ResponseBody
    @Operation(summary="Retorna os tipos de documento por classe de documento(COR, COE, OBR, NTF, TRO, LIC), da empresa informada")
    public ResponseEntity<List<TipoDocumento>> findTiposDocumento(HttpServletRequest request, @PathVariable(value="empresa") String empresa, @PathVariable(value="classe") String classe) {
        try {
            logger.debug("Iniciando find de tipos documento...");
            Empresa emp = new Empresa();
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            ArrayList<TipoDocumento> tipos = new ArrayList<TipoDocumento>();
            List tiposDocumentoEmp = this.cadastroService.findTiposDocumentosByClasse(emp.getId(), classe);
            if (tiposDocumentoEmp != null) {
                for (TipoDocumento tipoDocumento : tiposDocumentoEmp) {
                    TipoDocumento tipo = tipoDocumento;
                    Entidade ett = tipo.getEntidade();
                    if (ett != null) {
                        ett.setDatHorAlteracao(null);
                        ett.setDatHorCadastro(null);
                        ett.setIdUsuarioIns(null);
                        ett.setIdUsuarioUpd(null);
                        ett.setSetores(null);
                    }
                    tipo.setEntidade(ett);
                    tipo.setIdUsuarioUpd(null);
                    tipo.setDatHorCadastro(null);
                    tipo.setIdUsuarioIns(null);
                    tipo.setDatHorAlteracao(null);
                    tipo.setIdUsuarioUpd(null);
                    tipo.setNumeroCartaFormato(null);
                    tipo.setResposta(null);
                    tipos.add(tipo);
                }
            }
            return new ResponseEntity(tipos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findTiposDocumento", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}"})
    @ResponseBody
    @Operation(summary="Retorna os tipos de documento da empresa informada")
    public ResponseEntity<List<TipoDocumento>> findTiposDocumentoEmpresa(HttpServletRequest request, @PathVariable(value="empresa") String empresa) {
        try {
            logger.debug("Iniciando find de tipos documento...");
            Empresa emp = new Empresa();
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            ArrayList<TipoDocumento> tiposDocumento = new ArrayList<TipoDocumento>();
            List tiposDocumentoEmp = this.cadastroService.findTiposDocumentos(emp.getId(), null);
            if (tiposDocumentoEmp != null) {
                for (TipoDocumento tipoDocto : tiposDocumentoEmp) {
                    Entidade ett = tipoDocto.getEntidade();
                    if (ett != null) {
                        ett.setDatHorAlteracao(null);
                        ett.setDatHorCadastro(null);
                        ett.setIdUsuarioIns(null);
                        ett.setIdUsuarioUpd(null);
                        ett.setSetores(null);
                    }
                    tipoDocto.setEntidade(ett);
                    tipoDocto.setIdUsuarioUpd(null);
                    tipoDocto.setIdUsuarioIns(null);
                    tipoDocto.setNumeroCartaFormato(null);
                    TipoDocumento tipo = tipoDocto.getTipoDocumento();
                    if (tipo != null) {
                        tipo.setEntidade(null);
                        tipo.setIdUsuarioUpd(null);
                        tipo.setIdUsuarioIns(null);
                        tipo.setNumeroCartaFormato(null);
                    }
                    tiposDocumento.add(tipoDocto);
                }
            }
            return new ResponseEntity(tiposDocumento, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findTiposDocumento", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping
    @Operation(summary="Atualiza os dados do Tipos de Documento")
    @ResponseBody
    public ResponseEntity<TipoDocumento> saveTipoDocumento(@RequestBody TipoDocumento tipoDocto, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("saveTipoDocumento ({}))", (Object)tipoDocto);
            return new ResponseEntity((Object)this.cadastroService.saveTipoDocumento(tipoDocto, usuario.getLogin()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveTipoDocumento", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idTipoDocumento}"})
    @Operation(summary="Exclui a equipe, retornando erro se houver liga\u00e7\u00e3o com outras entidades do sistema")
    public ResponseEntity<Boolean> deleteTipoDocumento(@PathVariable(name="empresa") String empresa, @PathVariable(name="idTipoDocumento") Integer idTipoDocumento, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("deleteTipoDocumento({}, {})", (Object)empresa, (Object)idTipoDocumento);
        try {
            Empresa emp = new Empresa();
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            return new ResponseEntity((Object)this.cadastroService.deleteTipoDocumento(emp.getId(), idTipoDocumento), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteTipoDocumento", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

