/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.core;

import br.com.oti.gesconsys.beans.core.TipoModulo;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.beans.shared.ProcessoImportacao;
import br.com.oti.gesconsys.business.CoreService;
import br.com.oti.gesconsys.business.helper.BaseImportHelper;
import br.com.oti.gesconsys.business.helper.ImportacaoDemandaHelper;
import br.com.oti.gesconsys.business.helper.ImportacaoFaixaDominioHelper;
import br.com.oti.gesconsys.business.helper.ImportacaoObrigacaoHelper;
import br.com.oti.gesconsys.business.helper.ImportacaoPleitoHelper;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para Importa\u00e7\u00f5es em Planilhas", name="core")
@RequestMapping(value={"/api/importacoes"})
public class ImportacoesRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(ImportacoesRestServices.class);
    @Autowired
    private CoreService coreService;
    @Autowired
    private SegurancaService segurancaService;
    @Autowired
    private ImportacaoDemandaHelper importaDemandaHelper;
    @Autowired
    private ImportacaoObrigacaoHelper importaObrigacaoHelper;
    @Autowired
    private ImportacaoFaixaDominioHelper importaFaixaDominioHelper;
    @Autowired
    private ImportacaoPleitoHelper importaPleitoHelper;

    @PostMapping(consumes={"multipart/form-data"}, path={"/{empresa}/{modulo}"})
    @Operation(summary="Efetua a importa\u00e7\u00e3o ou atualiza\u00e7\u00e3o dos dados de item, para a empresa e m\u00f3dulo definidos.", description="M\u00f3dulo, deve ser informado conforme padr\u00f5es [OBR, CRP, PLT, ...]")
    @ResponseBody
    public ResponseEntity<Map<String, Object>> executeImportacao(@PathVariable(name="empresa") String empresa, @PathVariable(name="modulo") String modulo, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
        }
        logger.debug("Iniciando importa\u00e7\u00e3o, usu\u00e1rio={}, empresa={}, modulo={}", new Object[]{empresa, usuario.getLogin(), modulo});
        Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
        if (empresaDB == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
        }
        PublicUser userDB = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (userDB == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o foi encontrado.");
        }
        if (modulo == null || modulo.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "M\u00f3dulo relacionado n\u00e3o foi informado.");
        }
        try {
            MultiValueMap allFiles;
            StandardMultipartHttpServletRequest multipartReq = (StandardMultipartHttpServletRequest)request;
            String preProcessar = multipartReq.getParameter("preProcessar");
            String planilha = multipartReq.getParameter("planilha");
            String colunasTxt = multipartReq.getParameter("colunasImportar");
            List colunasImportacao = null;
            if (colunasTxt != null && !colunasTxt.isEmpty()) {
                ObjectMapper mapper = new ObjectMapper();
                colunasImportacao = (List)mapper.readValue(colunasTxt, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            if ((allFiles = multipartReq.getMultiFileMap()) != null && !allFiles.isEmpty()) {
                HashMap<String, ProcessoImportacao> payload = new HashMap<String, ProcessoImportacao>();
                for (String filesKeyName : allFiles.keySet()) {
                    List files = (List)allFiles.get((Object)filesKeyName);
                    for (MultipartFile file : files) {
                        ProcessoImportacao itens;
                        logger.debug("Upload original.fileName={}", (Object)file.getOriginalFilename());
                        if (preProcessar != null && !preProcessar.isEmpty()) {
                            BaseImportHelper baseHelper = new BaseImportHelper();
                            payload.putAll(baseHelper.preProcess(file.getInputStream()));
                            continue;
                        }
                        if (modulo.toUpperCase().equals(TipoModulo.OBRIGACOES.getSigla())) {
                            itens = this.importaObrigacaoHelper.importarObrigacoes(empresaDB.getId(), file.getInputStream(), userDB.getId());
                            payload.put("processo", itens);
                            continue;
                        }
                        if (modulo.toUpperCase().equals(TipoModulo.PLEITOS.getSigla())) {
                            itens = this.importaPleitoHelper.importarPleitos(empresaDB.getId(), file.getInputStream(), userDB.getId());
                            payload.put("processo", itens);
                            continue;
                        }
                        if (modulo.toUpperCase().equals(TipoModulo.FAIXA_DOMINIO.getSigla())) {
                            itens = this.importaFaixaDominioHelper.importarDemandas(empresaDB.getId(), userDB.getLogin(), file.getInputStream());
                            payload.put("processo", itens);
                            continue;
                        }
                        if (!modulo.toUpperCase().equals(TipoModulo.DEMANDAS.getSigla())) continue;
                        itens = this.importaDemandaHelper.importarDemandas(empresaDB.getId(), userDB.getLogin(), planilha, file.getInputStream());
                        payload.put("processo", itens);
                    }
                }
                return new ResponseEntity(payload, (HttpStatusCode)HttpStatus.CREATED);
            }
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "N\u00e3o h\u00e1 arquivos de carga para processamento.");
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.executeImportacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (IOException ioExc) {
            logger.error("IOExc.executeImportacao", (Throwable)ioExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ioExc.getMessage());
        }
    }
}

