/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest;

import br.com.oti.gesconsys.actions.geral.ResumoCorrespondenciasExport;
import br.com.oti.gesconsys.beans.ResumoObrigacaoVO;
import br.com.oti.gesconsys.beans.core.KeyValue;
import br.com.oti.gesconsys.beans.correspondencia.CorrespondenciaMobileVO;
import br.com.oti.gesconsys.beans.correspondencia.ResumoGeralCorrespondenciaVO;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.geral.EmpresaArea;
import br.com.oti.gesconsys.beans.geral.ResumoGeralMainVO;
import br.com.oti.gesconsys.beans.obrigacao.ObrigacaoLancamento;
import br.com.oti.gesconsys.beans.obrigacao.TipoStatusLancamentoObrigacao;
import br.com.oti.gesconsys.beans.pleito.ResumoGeralPleitoVO;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.business.CoreService;
import br.com.oti.gesconsys.business.services.CorrespondenciaService;
import br.com.oti.gesconsys.business.services.DemandaService;
import br.com.oti.gesconsys.business.services.ObrigacaoService;
import br.com.oti.gesconsys.business.services.PleitoService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para resumos", name="resumos")
@RequestMapping(value={"/api/resumos"})
public class ResumosRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(ResumosRestServices.class);
    @Autowired
    private CoreService coreService;
    @Autowired
    private ObrigacaoService obrigacaoService;
    @Autowired
    private PleitoService pleitoService;
    @Autowired
    private CorrespondenciaService correspondenciaService;
    @Autowired
    private DemandaService demandaService;
    @Autowired
    private SegurancaService segurancaService;

    @GetMapping
    @Operation(summary="Retorna o resumo dos Pleitos & Correspond\u00eancias")
    @ResponseBody
    public ResponseEntity<ResumoGeralMainVO> getResumo(HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        logger.debug("API getResumo...");
        ResumoGeralMainVO resumoGeral = new ResumoGeralMainVO();
        try {
            Integer n;
            Integer anoCorresp = null;
            String param = request.getParameter("anoCorresp");
            if (param != null && !param.isEmpty()) {
                anoCorresp = Integer.valueOf(param);
            }
            Integer mesCorresp = null;
            param = request.getParameter("mesCorresp");
            if (param != null && !param.isEmpty()) {
                mesCorresp = Integer.valueOf(param);
            }
            String empresaCorresp = null;
            param = request.getParameter("empresaCorresp");
            if (param != null && !param.isEmpty()) {
                empresaCorresp = param;
            }
            ResumoGeralCorrespondenciaVO resumoCorresp = this.correspondenciaService.findResumoCorrespondencias(usr.getId(), anoCorresp, mesCorresp, empresaCorresp, null, null, null, Boolean.FALSE, Boolean.FALSE, null, Boolean.valueOf(true), null);
            Integer count = 0;
            for (CorrespondenciaMobileVO users : resumoCorresp.getUsuarios()) {
                if (count > 50) break;
                resumoGeral.getResumoCorrespondencia().getUsuarios().add(users);
                n = count;
                count = count + 1;
            }
            count = 0;
            for (CorrespondenciaMobileVO ars : resumoCorresp.getAreas()) {
                if (count > 50) break;
                resumoGeral.getResumoCorrespondencia().getAreas().add(ars);
                n = count;
                count = count + 1;
            }
            count = 0;
            for (CorrespondenciaMobileVO str : resumoCorresp.getSetores()) {
                if (count > 50) break;
                resumoGeral.getResumoCorrespondencia().getSetores().add(str);
                n = count;
                count = count + 1;
            }
            Empresa empDB = this.coreService.getEmpresaBySigla(empresaCorresp);
            ResumoGeralPleitoVO resumoPleito = this.pleitoService.findResumoGeralPleito(empDB.getId(), Boolean.valueOf(true));
            resumoGeral.setResumoPleito(resumoPleito);
            return new ResponseEntity((Object)resumoGeral, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getResumo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.getResumo", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/correspondencias"})
    @Operation(summary="Retorna o resumo das Correspond\u00eancias, contendo os totais de acordo com os filtros informados")
    @ResponseBody
    public ResponseEntity<KeyValue[]> findResumoCorrespondencias(HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("{} - findResumoCorrespondencias()", (Object)usuario.getLogin());
        try {
            KeyValue[] resumoCorresp = this.internalFilterStatusCorrespondencia(request, usuario.getLogin());
            return new ResponseEntity((Object)resumoCorresp, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findResumoCorrespondencias", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findResumoCorrespondencias", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    private KeyValue[] internalFilterStatusCorrespondencia(HttpServletRequest request, String usuario) throws BusinessException {
        Integer anoCorresp = null;
        Integer mesCorresp = null;
        String empCorresp = null;
        ArrayList<Integer> areasEmpInt = null;
        String classeDocto = null;
        ArrayList<Integer> tiposDocto = null;
        ArrayList<Integer> statusAprov = null;
        Map params = request.getParameterMap();
        if (params.containsKey("empCorresp")) {
            empCorresp = request.getParameter("empCorresp");
        }
        if (params.containsKey("anoCorresp")) {
            anoCorresp = Integer.valueOf(request.getParameter("anoCorresp"));
        }
        if (params.containsKey("mesCorresp")) {
            mesCorresp = Integer.valueOf(request.getParameter("mesCorresp"));
        }
        if (params.containsKey("classeCorresp")) {
            classeDocto = request.getParameter("classeCorresp");
        }
        if (params.containsKey("tipoCorresp")) {
            String[] tiposTxt = request.getParameterValues("tipoCorresp");
            tiposDocto = new ArrayList<Integer>();
            for (String itemTipo : tiposTxt) {
                tiposDocto.add(Integer.valueOf(itemTipo));
            }
        }
        if (params.containsKey("areaCorresp")) {
            Integer areaCorresp = Integer.valueOf(request.getParameter("areaCorresp"));
            areasEmpInt = new ArrayList<Integer>();
            areasEmpInt.add(areaCorresp);
        }
        if (params.containsKey("statusCorresp")) {
            String[] statusTxt = request.getParameterValues("statusCorresp");
            statusAprov = new ArrayList<Integer>();
            for (String itemStat : statusTxt) {
                statusAprov.add(Integer.valueOf(itemStat));
            }
        }
        KeyValue[] resumoCorresp = this.correspondenciaService.findResumoStatusCorrespondencias(usuario, anoCorresp, mesCorresp, empCorresp, areasEmpInt, classeDocto, tiposDocto, statusAprov);
        return resumoCorresp;
    }

    private ResumoGeralCorrespondenciaVO internalFilterCorrespondencia(HttpServletRequest request, String usuario) throws BusinessException {
        PublicUser usr;
        Integer anoCorresp = null;
        Integer mesCorresp = null;
        String empCorresp = null;
        ArrayList<Integer> areasEmpInt = null;
        String classeDocto = null;
        ArrayList<Integer> tiposDocto = null;
        Boolean todasAreas = false;
        Boolean todosSetores = false;
        ArrayList<Integer> statusAprov = null;
        Boolean pendenciasUsuario = false;
        Map params = request.getParameterMap();
        if (params.containsKey("empCorresp")) {
            empCorresp = request.getParameter("empCorresp");
        }
        if (params.containsKey("anoCorresp")) {
            anoCorresp = Integer.valueOf(request.getParameter("anoCorresp"));
        }
        if (params.containsKey("mesCorresp")) {
            mesCorresp = Integer.valueOf(request.getParameter("mesCorresp"));
        }
        if (params.containsKey("classeCorresp")) {
            classeDocto = request.getParameter("classeCorresp");
        }
        if (params.containsKey("tipoCorresp")) {
            String[] tiposTxt = request.getParameterValues("tipoCorresp");
            tiposDocto = new ArrayList<Integer>();
            for (String itemTipo : tiposTxt) {
                tiposDocto.add(Integer.valueOf(itemTipo));
            }
        }
        if (params.containsKey("statusCorresp")) {
            String[] statusTxt = request.getParameterValues("statusCorresp");
            statusAprov = new ArrayList<Integer>();
            for (String itemStat : statusTxt) {
                statusAprov.add(Integer.valueOf(itemStat));
            }
        }
        if (params.containsKey("areaCorresp")) {
            Integer areaCorresp = Integer.valueOf(request.getParameter("areaCorresp"));
            areasEmpInt = new ArrayList<Integer>();
            areasEmpInt.add(areaCorresp);
        }
        if ((usr = this.segurancaService.getUsuarioByLogin(usuario)) == null) {
            throw new BusinessException("Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        ResumoGeralCorrespondenciaVO resumoCorresp = this.correspondenciaService.findResumoCorrespondencias(usr.getId(), anoCorresp, mesCorresp, empCorresp, areasEmpInt, classeDocto, tiposDocto, todasAreas, todosSetores, statusAprov, pendenciasUsuario, null);
        return resumoCorresp;
    }

    @GetMapping(value={"{empresa}/correspondencias/exportResumo"})
    @Operation(summary="Retorna o resumo das Correspond\u00eancias, contendo os totais de acordo com os filtros informados")
    @ResponseBody
    public ResponseEntity<Object> exportResumoCorrespondencias(@PathVariable(name="empresa") String empresa, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("Gerando relat\u00f3rio XLS resumo");
            byte[] bytes = new ResumoCorrespondenciasExport().executeXLS(this.internalFilterCorrespondencia(request, usuario.getLogin()));
            logger.debug("Escrevendo response stream, bytes.length={}", (Object)bytes.length);
            HttpHeaders headers = new HttpHeaders();
            headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
            headers.add("Content-Type", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            headers.add("Pragma", "no-cache");
            headers.add("Expires", "0");
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).contentLength((long)bytes.length).body((Object)new ByteArrayResource(bytes));
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"{empresa}/correspondencias/exportResumoItens/{categoria}"})
    @Operation(summary="Retorna o resumo das Correspond\u00eancias, contendo os totais de acordo com os filtros informados")
    @ResponseBody
    public ResponseEntity<Object> exportResumoItensCorrespondencias(@PathVariable(name="empresa") String empresa, @PathVariable(name="categoria") String categoria, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("Gerando relat\u00f3rio XLS resumo itens");
            ResumoGeralCorrespondenciaVO resumoCorresp = this.internalFilterCorrespondencia(request, usuario.getLogin());
            List rawData = resumoCorresp.getDados();
            ArrayList<CorrespondenciaMobileVO> items = new ArrayList<CorrespondenciaMobileVO>();
            for (CorrespondenciaMobileVO dataVO : rawData) {
                String itemStatus = dataVO.getStatusPrazo();
                if (itemStatus == null || !itemStatus.equals(categoria) && !itemStatus.startsWith(categoria)) continue;
                items.add(dataVO);
            }
            byte[] bytes = new ResumoCorrespondenciasExport().executeItemXLS(categoria, items);
            logger.debug("Escrevendo response stream, bytes.length={}", (Object)bytes.length);
            HttpHeaders headers = new HttpHeaders();
            headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
            headers.add("Content-Type", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            headers.add("Pragma", "no-cache");
            headers.add("Expires", "0");
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).contentLength((long)bytes.length).body((Object)new ByteArrayResource(bytes));
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/demandas"})
    @Operation(summary="Retorna o resumo das Demandas, agrupando por totais e tipos")
    @ResponseBody
    public ResponseEntity<List<KeyValue>> findResumoDemandas(HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Integer idEmpresa = null;
            Map params = request.getParameterMap();
            if (params.containsKey("empresa")) {
                String empresa = request.getParameter("empresa");
                idEmpresa = Integer.valueOf(empresa);
            }
            ArrayList<KeyValue> itens = new ArrayList<KeyValue>();
            Map demandas = this.demandaService.findResumoDemandasByStatus(idEmpresa);
            for (String demanda : demandas.keySet()) {
                itens.add(new KeyValue((Object)demanda, (Integer)demandas.get(demanda)));
            }
            return new ResponseEntity(itens, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findResumoDemandas", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findResumoDemandas", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"{empresa}/obrigacoes"})
    @Operation(summary="Retorna o resumo das obriga\u00e7\u00f5es, agrupando por totais e tipos")
    @ResponseBody
    public ResponseEntity<Map<String, Object>> findResumoObrigacoes(@PathVariable(name="empresa") String empresa, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            String dataTxt;
            Map params = request.getParameterMap();
            ArrayList<Integer> listEmp = new ArrayList<Integer>();
            Empresa empDB = this.coreService.getEmpresaBySigla(empresa);
            listEmp.add(empDB.getId());
            ArrayList areasId = new ArrayList();
            Integer tipoObrigacao = null;
            Integer statusObriga = null;
            HashMap<String, Serializable> itens = new HashMap<String, Serializable>();
            LocalDate dataInicial = null;
            LocalDate dataFinal = null;
            DateTimeFormatter dateFmt = DateTimeFormatter.ISO_LOCAL_DATE;
            if (params.containsKey("dataInicial") && (dataTxt = ((String[])params.get("dataInicial"))[0]) != null && !dataTxt.isEmpty()) {
                try {
                    dataInicial = LocalDate.parse(dataTxt, dateFmt);
                }
                catch (DateTimeParseException dteExc) {
                    dataInicial = null;
                }
            }
            if (params.containsKey("dataFinal") && (dataTxt = ((String[])params.get("dataFinal"))[0]) != null && !dataTxt.isEmpty()) {
                try {
                    dataFinal = LocalDate.parse(dataTxt, dateFmt);
                }
                catch (DateTimeParseException dteExc) {
                    dataFinal = null;
                }
            }
            List obrigacoes = this.obrigacaoService.findLancamentosByFiltro(listEmp, null, areasId, tipoObrigacao, statusObriga, null, null, dataInicial, dataFinal, null, null, null, Boolean.valueOf(false));
            int countPendentes = 0;
            int countAndamento = 0;
            int countEncerrados = 0;
            HashMap<String, ResumoObrigacaoVO> mapAreas = new HashMap<String, ResumoObrigacaoVO>();
            for (ObrigacaoLancamento lcto : obrigacoes) {
                Integer countArea;
                ResumoObrigacaoVO resumo;
                EmpresaArea area = lcto.getObrigacao().getArea();
                if (lcto.getStatus().equals(TipoStatusLancamentoObrigacao.PENDENTE.getCode())) {
                    ++countPendentes;
                    if (area == null) continue;
                    resumo = (ResumoObrigacaoVO)mapAreas.get(area.getSigla());
                    if (resumo == null) {
                        resumo = new ResumoObrigacaoVO();
                        resumo.setArea(area.getSigla());
                        mapAreas.put(area.getSigla(), resumo);
                    }
                    if ((countArea = resumo.getCountPendente()) == null) {
                        countArea = 0;
                    }
                    countArea = countArea + 1;
                    resumo.setCountPendente(countArea);
                    continue;
                }
                if (lcto.getStatus().equals(TipoStatusLancamentoObrigacao.INTEGRADO.getCode())) {
                    ++countAndamento;
                    if (area == null) continue;
                    resumo = (ResumoObrigacaoVO)mapAreas.get(area.getSigla());
                    if (resumo == null) {
                        resumo = new ResumoObrigacaoVO();
                        resumo.setArea(area.getSigla());
                        mapAreas.put(area.getSigla(), resumo);
                    }
                    if ((countArea = resumo.getCountAndamento()) == null) {
                        countArea = 0;
                    }
                    countArea = countArea + 1;
                    resumo.setCountAndamento(countArea);
                    continue;
                }
                if (!lcto.getStatus().equals(TipoStatusLancamentoObrigacao.PROTOCOLADO.getCode()) && !lcto.getStatus().equals(TipoStatusLancamentoObrigacao.ENCERRADO.getCode())) continue;
                ++countEncerrados;
                if (area == null) continue;
                resumo = (ResumoObrigacaoVO)mapAreas.get(area.getSigla());
                if (resumo == null) {
                    resumo = new ResumoObrigacaoVO();
                    resumo.setArea(area.getSigla());
                    mapAreas.put(area.getSigla(), resumo);
                }
                if ((countArea = resumo.getCountEncerrado()) == null) {
                    countArea = 0;
                }
                countArea = countArea + 1;
                resumo.setCountEncerrado(countArea);
            }
            itens.put("resumoPendentes", Integer.valueOf(countPendentes));
            itens.put("resumoAndamento", Integer.valueOf(countAndamento));
            itens.put("resumoEncerradas", Integer.valueOf(countEncerrados));
            ArrayList<ResumoObrigacaoVO> list = new ArrayList<ResumoObrigacaoVO>();
            for (String key : mapAreas.keySet()) {
                list.add((ResumoObrigacaoVO)mapAreas.get(key));
            }
            list.sort((r1, r2) -> r1.getCountTotal().compareTo(r2.getCountTotal()));
            itens.put("areas", list);
            return new ResponseEntity(itens, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findResumoDemandas", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findResumoDemandas", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }
}

