/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest;

import br.com.oti.gesconsys.beans.core.KeyValue;
import br.com.oti.gesconsys.beans.core.TipoModulo;
import br.com.oti.gesconsys.beans.core.TipoRefCode;
import br.com.oti.gesconsys.beans.ged.Anexo;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.geral.RevisaoTarifaria;
import br.com.oti.gesconsys.beans.geral.TipoFluxoCaixa;
import br.com.oti.gesconsys.beans.pleito.CaracteristicaPleito;
import br.com.oti.gesconsys.beans.pleito.FaixaValor;
import br.com.oti.gesconsys.beans.pleito.FichaPleito;
import br.com.oti.gesconsys.beans.pleito.GrupoTrabalho;
import br.com.oti.gesconsys.beans.pleito.HistoricoPleito;
import br.com.oti.gesconsys.beans.pleito.NivelAgencia;
import br.com.oti.gesconsys.beans.pleito.Pleito;
import br.com.oti.gesconsys.beans.pleito.PleitoArquivo;
import br.com.oti.gesconsys.beans.pleito.PleitoBridge;
import br.com.oti.gesconsys.beans.pleito.PleitoMobileVO;
import br.com.oti.gesconsys.beans.pleito.PleitoResumoVO;
import br.com.oti.gesconsys.beans.pleito.PleitoRodovia;
import br.com.oti.gesconsys.beans.pleito.PleitoStatus;
import br.com.oti.gesconsys.beans.pleito.PleitoTipoDesequilibrio;
import br.com.oti.gesconsys.beans.pleito.PleitoValorAprovado;
import br.com.oti.gesconsys.beans.pleito.PossibilidadeExito;
import br.com.oti.gesconsys.beans.pleito.PrioridadePleito;
import br.com.oti.gesconsys.beans.pleito.RevisaoPleito;
import br.com.oti.gesconsys.beans.pleito.StatusAgencia;
import br.com.oti.gesconsys.beans.pleito.TipoCaracteristica;
import br.com.oti.gesconsys.beans.pleito.TipoPleito;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.business.CoreService;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.PleitoService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.ged.business.GedService;
import br.com.oti.gesconsys.rest.BaseRestService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para pleitos", name="pleitos")
@RequestMapping(value={"/api/pleitos"})
public class PleitosRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(PleitosRestServices.class);
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private CoreService coreService;
    @Autowired
    private GedService gedService;
    @Autowired
    private PleitoService pleitoService;
    @Autowired
    private SegurancaService segurancaService;

    @GetMapping(value={"/{empresa}"})
    @Operation(summary="Localiza pleitos de acordo com os filtros")
    @ResponseBody
    public ResponseEntity<List<PleitoMobileVO>> findPleitos(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @RequestParam(name="search", required=false) String search, @RequestParam(name="dataInicial", required=false) Date dataInicial, @RequestParam(name="dataFinal", required=false) Date dataFinal, @RequestParam(name="tipoPleito", required=false) Integer tipoPleito, @RequestParam(name="tipoCaracteristica", required=false) String tipoCaracteristica, @RequestParam(name="prioridade", required=false) Integer prioridade, @RequestParam(name="nivelAgencia", required=false) Integer nivelAgencia, @RequestParam(name="nroPleito", required=false) Integer nroPleito, @RequestParam(name="status", required=false) String status) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API search (empresa={},search={})...", (Object)empresa, (Object)search);
        SimpleDateFormat sdfData = new SimpleDateFormat("dd/MM/yy", new Locale("pt", "BR"));
        try {
            String visaoTxt;
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            ArrayList<Integer> empresasInt = new ArrayList<Integer>();
            empresasInt.add(emp.getId());
            ArrayList<PleitoMobileVO> pleitos = new ArrayList<PleitoMobileVO>();
            ArrayList<Integer> tiposPleito = null;
            if (tipoPleito != null) {
                tiposPleito = new ArrayList<Integer>();
                tiposPleito.add(tipoPleito);
            }
            ArrayList<Character> tiposCaracteristica = null;
            if (tipoCaracteristica != null) {
                tiposCaracteristica = new ArrayList<Character>();
                tiposCaracteristica.add(Character.valueOf(tipoCaracteristica.charAt(0)));
            }
            ArrayList<Integer> prioridades = null;
            if (prioridade != null) {
                prioridades = new ArrayList<Integer>();
                prioridades.add(prioridade);
            }
            ArrayList<Integer> niveisAgencia = null;
            if (nivelAgencia != null) {
                niveisAgencia = new ArrayList<Integer>();
                niveisAgencia.add(nivelAgencia);
            }
            boolean visaoBasica = (visaoTxt = (String)this.coreService.getRefValueByName(emp.getId(), TipoRefCode.PLEITO_TIPO_VISAO)) != null && visaoTxt.equals("B");
            List pleitosDB = this.pleitoService.findResumoPleitos(empresasInt, search, dataInicial, dataFinal, status, tiposPleito, niveisAgencia, prioridades, tiposCaracteristica, null, null, null, nroPleito, null, Boolean.valueOf(visaoBasica), null);
            for (PleitoResumoVO pleito : pleitosDB) {
                PleitoMobileVO pleitoVO = new PleitoMobileVO();
                pleitoVO.setIdEmpresa(pleito.getIdEmpresa());
                pleitoVO.setIdPleito(pleito.getIdPleito());
                pleitoVO.setDescricao(pleito.getDescricao());
                pleitoVO.setSigla(pleito.getSigla());
                pleitoVO.setStatusPleito(pleito.getStatusPleito());
                pleitoVO.setTipoPleito(pleito.getTipoPleito());
                pleitoVO.setTipoFinalidade(pleito.getTipoFinalidade());
                pleitoVO.setPrioridade(pleito.getPrioridade());
                pleitoVO.setStatusExecucao(pleito.getStatusExecucaoDesc());
                pleitoVO.setPerImpactoTarifa(pleito.getPerImpactoTarifa());
                Date dataUltHist = pleito.getDataUltimoHistorico();
                String ultimoHist = pleito.getUltimoHistorico();
                if (dataUltHist != null && ultimoHist != null) {
                    pleitoVO.setHistorico(String.format("%s - %s", sdfData.format(dataUltHist), ultimoHist));
                }
                pleitoVO.setValorPleitoAtual(pleito.getValPleitoBaseAtual() == null ? BigDecimal.ZERO : pleito.getValPleitoBaseAtual().setScale(2, RoundingMode.HALF_EVEN));
                BigDecimal pleitoAprovado = pleito.getValAprovadoBaseAtual();
                if (pleitoAprovado == null) {
                    pleitoAprovado = BigDecimal.ZERO;
                }
                pleitoVO.setValorAprovadoAtual(pleitoAprovado.setScale(2, RoundingMode.HALF_EVEN));
                BigDecimal pleitoPendente = pleito.getValPleitoBaseAtual();
                if (pleitoPendente == null) {
                    pleitoPendente = BigDecimal.ZERO;
                }
                if (pleito.getValPleitoBaseAtual() != null && pleito.getValAprovadoBaseAtual() != null) {
                    pleitoPendente = pleito.getValPleitoBaseAtual().subtract(pleito.getValAprovadoBaseAtual());
                }
                pleitoVO.setValorPleitoPendente(pleitoPendente.setScale(2, RoundingMode.HALF_EVEN));
                pleitos.add(pleitoVO);
            }
            return new ResponseEntity(pleitos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findEmpresasUsuario", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findEmpresasUsuario", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idPleito}"})
    @Operation(summary="Carrega o pleito de acordo com o crit\u00e9rio (Empresa e ID Pleito)")
    @ResponseBody
    public ResponseEntity<PleitoMobileVO> getPleito(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idPleito") Integer idPleito) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API getPleito...");
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            ArrayList<Integer> emps = new ArrayList<Integer>();
            emps.add(emp.getId());
            Pleito pleito = this.pleitoService.getPleitoById(idPleito, emp.getId());
            if (pleito != null) {
                NivelAgencia nivelAgencia;
                String visaoTxt = (String)this.coreService.getRefValueByName(emp.getId(), TipoRefCode.PLEITO_TIPO_VISAO);
                boolean visaoBasica = visaoTxt != null && visaoTxt.equals("B");
                List resumos = this.pleitoService.findResumoPleitos(emps, pleito.getDescricao(), null, null, null, null, null, null, null, null, null, Boolean.valueOf(true), null, null, Boolean.valueOf(visaoBasica), null);
                PleitoResumoVO pleitoResumo = new PleitoResumoVO();
                for (PleitoResumoVO rsm : resumos) {
                    if (!rsm.getIdPleito().equals(pleito.getId().getIdPleito())) continue;
                    pleitoResumo = rsm;
                    break;
                }
                List valoresAprovadosCache = this.pleitoService.findValoresAprovados(idPleito, emp.getId());
                ArrayList<PleitoValorAprovado> valoresAprovados = new ArrayList<PleitoValorAprovado>();
                for (PleitoValorAprovado val : valoresAprovadosCache) {
                    val.setPleito(null);
                    valoresAprovados.add(val);
                }
                PleitoMobileVO pleitoMobile = PleitoMobileVO.fromPleito((Pleito)pleito, (PleitoResumoVO)pleitoResumo, (Empresa)emp, valoresAprovados);
                List rodovias = this.pleitoService.findRodovias(pleito.getId().getIdEmpresa(), pleito.getId().getIdPleito());
                StringBuilder rodoviaTxt = new StringBuilder();
                if (rodovias != null) {
                    for (PleitoRodovia rdv : rodovias) {
                        if (rodoviaTxt.length() > 0) {
                            rodoviaTxt.append(" / ");
                        }
                        rodoviaTxt.append(rdv.getRodovia().getDescricao());
                    }
                    pleitoMobile.setRodovia(rodoviaTxt.toString());
                }
                if (pleito.getIdNivelAgencia() != null && (nivelAgencia = this.pleitoService.getNivelAgenciaById(pleito.getIdNivelAgencia(), pleito.getId().getIdEmpresa())) != null) {
                    pleitoMobile.setNivelAgencia(nivelAgencia.getDescricao());
                }
                List caracteristicas = this.pleitoService.findCaracteristicasPleito(idPleito, emp.getId(), null, null);
                List historicos = this.pleitoService.findHistoricosPleito(idPleito, emp.getId(), null);
                List anexos = this.pleitoService.findArquivosByPleito(idPleito, emp.getId(), null);
                List revisoesOrcadas = this.pleitoService.findRevisoesPleito(idPleito, emp.getId(), null, null);
                if (historicos != null) {
                    for (HistoricoPleito hist : historicos) {
                        if (hist.getResponsavel() != null) {
                            hist.setResponsavel(hist.getResponsavel().toPublico());
                        }
                        hist.setEmpresa(null);
                        hist.setPleito(null);
                    }
                    pleitoMobile.setHistoricos(historicos);
                }
                if (caracteristicas != null) {
                    for (CaracteristicaPleito carc : caracteristicas) {
                        carc.setPleito(null);
                    }
                    pleitoMobile.setCaracteristicas(caracteristicas);
                }
                if (anexos != null) {
                    if (pleitoMobile.getAnexos() == null) {
                        pleitoMobile.setAnexos(new ArrayList());
                    }
                    for (PleitoArquivo arq : anexos) {
                        arq.setUsuario(null);
                        arq.setEmpresa(null);
                        arq.setPleito(null);
                        if (arq.getAnexo() == null || arq.getAnexo().getUuid() == null) continue;
                        pleitoMobile.getAnexos().add(new KeyValue((Object)arq.getAnexo().getUuid(), arq.getAnexo().getNome()));
                    }
                }
                if (revisoesOrcadas != null) {
                    if (pleitoMobile.getRevisoes() == null) {
                        pleitoMobile.setRevisoes(new ArrayList());
                    }
                    for (RevisaoPleito rev : revisoesOrcadas) {
                        rev.setRevisaoTarifaria(null);
                        pleitoMobile.getRevisoes().add(rev);
                    }
                }
                return new ResponseEntity((Object)pleitoMobile, (HttpStatusCode)HttpStatus.OK);
            }
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Pleito n\u00e3o foi encontrado.");
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getPleito", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.getPleito", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}"})
    @Operation(summary="Cria um novo pleito de acordo com os dados base e upload dos anexos")
    @ResponseBody
    public ResponseEntity<Pleito> createPleito(@PathVariable(name="empresa") String empresa, @RequestBody Pleito pleito, @RequestParam(name="tipoCaracteristica", required=false) String tipoCaracteristica, @RequestParam(name="historicos", required=false) List<HistoricoPleito> historicos, @RequestParam(name="caracteristicas", required=false) List<CaracteristicaPleito> caracteristicas, @RequestParam(name="valoresAprovados", required=false) List<PleitoValorAprovado> valoresAprovados, @RequestParam(name="pleitoBridge", required=false) PleitoBridge pleitoBridge, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            pleito.getId().setIdEmpresa(empresaDB.getId());
            FichaPleito ficha = new FichaPleito(pleito);
            ficha.setPleito(pleito);
            FichaPleito saved = this.pleitoService.savePleito(pleito, historicos, caracteristicas, valoresAprovados, pleitoBridge, null, usr.getId(), request.getLocalAddr());
            return new ResponseEntity((Object)saved.getPleito(), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.createPleito", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/anexosPleito"}, consumes={"multipart/form-data"})
    @Operation(summary="Salva os anexos do pleito")
    public ResponseEntity<List<PleitoArquivo>> saveAnexosPleito(@PathVariable(name="empresa") String empresa, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Map formData = request.getParameterMap();
            ObjectMapper mapper = new ObjectMapper();
            mapper.registerModule((Module)new JavaTimeModule());
            mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            List anexos = (List)mapper.readValue(((String[])formData.get("anexos"))[0], (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            logger.debug("saveAnexosPleito.count ({}))", (Object)anexos);
            if (anexos != null) {
                for (PleitoArquivo anexo : anexos) {
                    this.internalSaveAnexo(empresaDB.getId(), anexo.getId().getIdPleito(), anexo, usuario.getLogin(), request);
                }
            }
            return new ResponseEntity((Object)anexos, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.saveAnexosPleito", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (JsonProcessingException jspExc) {
            logger.error("JsmExc.saveAnexosPleito", (Throwable)jspExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, jspExc.getMessage());
        }
    }

    private PleitoArquivo internalSaveAnexo(Integer idEmpresa, Integer idPleito, PleitoArquivo anexo, String usuario, HttpServletRequest request) {
        StandardMultipartHttpServletRequest multipartReq = (StandardMultipartHttpServletRequest)request;
        Map filesMap = multipartReq.getFileMap();
        PleitoArquivo anexoDB = anexo;
        if (filesMap != null && !filesMap.isEmpty()) {
            PublicUser user = this.segurancaService.getUsuarioByLogin(usuario);
            for (String uploadFile : filesMap.keySet()) {
                List filesReq = multipartReq.getFiles(uploadFile);
                for (MultipartFile fileReq : filesReq) {
                    String fileName = fileReq.getOriginalFilename();
                    logger.debug("Upload original.fileName={}", (Object)fileName);
                    if (anexo.getAnexo() != null && !fileName.equals(anexo.getAnexo().getNome())) continue;
                    Anexo anexoGed = this.gedService.createAnexo(idEmpresa, TipoModulo.PLEITOS.getSigla(), "Pleitos", fileName, "Anexos", null, fileReq, user.getId(), LocalDateTime.now());
                    anexo.getId().setIdEmpresa(idEmpresa);
                    anexo.setIdAnexo(anexoGed.getId().getIdAnexo());
                    anexo.setAnexo(anexoGed);
                    anexoDB = this.pleitoService.saveArquivo(anexo, user.getId(), request.getLocalAddr());
                }
            }
        }
        return anexoDB;
    }

    @GetMapping(value={"/{empresa}/tipos"})
    @Operation(summary="Retorna os tipos de pleitos")
    @ResponseBody
    public ResponseEntity<List<TipoPleito>> findTiposPleito(HttpServletRequest request, @PathVariable(name="empresa") String empresa) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API findTiposPleito(emp={})...", (Object)empresa);
        try {
            List tipos;
            String search = null;
            if (request.getParameter("search") != null) {
                search = request.getParameter("search");
            }
            if ((tipos = this.pleitoService.findTiposPleitos(search, Boolean.valueOf(true))) != null && !tipos.isEmpty()) {
                for (TipoPleito tipo : tipos) {
                    tipo.setDatHorCadastro(null);
                    tipo.setIdUsuarioIns(null);
                    tipo.setDatHorAlteracao(null);
                    tipo.setIdUsuarioUpd(null);
                }
            }
            return new ResponseEntity((Object)tipos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findTiposPleito", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findTiposPleito", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idTipoPleito}/tipoPleito"})
    @Operation(summary="Busca o tipo do pleito conforme seu identificador.")
    public ResponseEntity<TipoPleito> getTipoPleitoById(@PathVariable(name="empresa") String empresa, @PathVariable(name="idTipoPleito") Integer idTipoPleito, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("getTipoPleitoById({}, {})", (Object)empresa, (Object)idTipoPleito);
            return ResponseEntity.ok().body((Object)this.pleitoService.getTipoPleitoById(idTipoPleito));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getStatusAgenciaById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/tipos"})
    @Operation(summary="Salva os tipos de pleito a partir de seu payload")
    public ResponseEntity<TipoPleito> saveTiposPleito(@PathVariable(name="empresa") String empresa, @RequestBody TipoPleito pleito, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("saveTiposPleito({}, {})", (Object)empresa, (Object)pleito);
            return new ResponseEntity((Object)this.pleitoService.saveTipoPleito(pleito, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveTiposPleito", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idTipoPleito}/tipos"})
    @Operation(summary="Exclui o tipo de pleito de acordo com seu ID.")
    public ResponseEntity<Boolean> deleteTipoPleito(@PathVariable(name="empresa") String empresa, @PathVariable(name="idTipoPleito") Integer idTipoPleito, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("deleteTipoPleito({}, {})", (Object)empresa, (Object)idTipoPleito);
            this.pleitoService.deleteTipoPleito(idTipoPleito);
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteTipoPleito", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/nivelAgencia"})
    @Operation(summary="Localiza n\u00edveis de ag\u00eancia de acordo com a empresa")
    @ResponseBody
    public ResponseEntity<List<NivelAgencia>> findNiveisAgencia(HttpServletRequest request, @PathVariable(name="empresa") String empresa) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API findNiveisAgencia(emp={})...", (Object)empresa);
        String search = null;
        if (request.getParameter("search") != null) {
            search = request.getParameter("search");
        }
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new BusinessException("Empresa n\u00e3o foi encontrada.");
            }
            List niveis = this.pleitoService.findNiveisAgencia(emp.getId(), search);
            if (niveis != null && !niveis.isEmpty()) {
                for (NivelAgencia nivel : niveis) {
                    nivel.setDatHorCadastro(null);
                    nivel.setIdUsuarioIns(null);
                    nivel.setDatHorAlteracao(null);
                    nivel.setIdUsuarioUpd(null);
                }
            }
            return new ResponseEntity((Object)niveis, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findNiveisAgencia", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findNiveisAgencia", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idNivelAgencia}/nivelAgencia"})
    @Operation(summary="Exibe o n\u00edvel da ag\u00eancia conforme seu identificador.")
    @ResponseBody
    public ResponseEntity<NivelAgencia> getNivelAgencia(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idNivelAgencia") Integer idNivelAgencia) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("Executando getNivelAgencia");
        try {
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            NivelAgencia nivelAgencia = this.pleitoService.getNivelAgenciaById(idNivelAgencia, empresaDB.getId());
            return new ResponseEntity((Object)nivelAgencia, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getNivelAgencia", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.getNivelAgencia", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idNivel}/nivelAgencia"})
    @Operation(summary="Exclui o n\u00edvel de ag\u00eancia de acordo com seu ID.")
    public ResponseEntity<Boolean> deleteNivelAgencia(@PathVariable(name="idNivel") Integer idNivel, @PathVariable(name="empresa") String empresa, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("deleteNivelAgencia({})", (Object)idNivel);
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            this.pleitoService.deleteNivelAgencia(idNivel, empresaDB.getId());
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteNivelAgencia", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/nivelAgencia"})
    @Operation(summary="Salva os n\u00edveis de ag\u00eancia de pleito a partir de seu payload")
    public ResponseEntity<NivelAgencia> saveNivelAgencia(@PathVariable(name="empresa") String empresa, @RequestBody NivelAgencia nivelAgencia, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("saveNivelAgencia({})", (Object)nivelAgencia);
            return new ResponseEntity((Object)this.pleitoService.saveNivelAgencia(nivelAgencia, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveNivelAgencia", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/prioridades"})
    @Operation(summary="Localiza as prioridades de pleito de acordo com a empresa")
    @ResponseBody
    public ResponseEntity<List<PrioridadePleito>> findPrioridadesPleito(HttpServletRequest request, @PathVariable(name="empresa") String empresa) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API findPrioridades(emp={})...", (Object)empresa);
        String search = null;
        if (request.getParameter("search") != null) {
            search = request.getParameter("search");
        }
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            List prioridades = this.pleitoService.findPrioridadesPleitos(search);
            if (prioridades != null && !prioridades.isEmpty()) {
                for (PrioridadePleito prioridade : prioridades) {
                    prioridade.setDatHorCadastro(null);
                    prioridade.setIdUsuarioIns(null);
                    prioridade.setDatHorAlteracao(null);
                    prioridade.setIdUsuarioUpd(null);
                }
            }
            return new ResponseEntity((Object)prioridades, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findTiposPleito", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findTiposPleito", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idPrioridade}/prioridadePleito"})
    @Operation(summary="Busca a prioridade do pleito conforme seu identificador.")
    public ResponseEntity<PrioridadePleito> getPrioridadePleitoById(@PathVariable(name="empresa") String empresa, @PathVariable(name="idPrioridade") Integer idPrioridade, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("getPrioridadeById({}, {})", (Object)empresa, (Object)idPrioridade);
            return ResponseEntity.ok().body((Object)this.pleitoService.getPrioridadePleitoById(idPrioridade));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getPrioridadeById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/prioridades"})
    @Operation(summary="Salva as prioridades de pleito a partir de seu payload")
    public ResponseEntity<PrioridadePleito> savePrioridadePleito(@PathVariable(name="empresa") String empresa, @RequestBody PrioridadePleito prioridade, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("savePrioridadePleito({}, {})", (Object)empresa, (Object)prioridade);
            return new ResponseEntity((Object)this.pleitoService.savePrioridadePleito(prioridade, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.savePrioridadePleito", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idPrioridade}/prioridades"})
    @Operation(summary="Exclui a prioridade do pleito de acordo com seu ID.")
    public ResponseEntity<Boolean> deletePrioridadePleito(@PathVariable(name="empresa") String empresa, @PathVariable(name="idPrioridade") Integer idPrioridade, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("deleteNivelAgencia({}, {})", (Object)empresa, (Object)idPrioridade);
            this.pleitoService.deletePrioridadePleito(idPrioridade);
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deletePrioridadePleito", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/caracteristicas"})
    @Operation(summary="Localiza as caracteristicas de pleito de acordo com a empresa")
    @ResponseBody
    public ResponseEntity<List<CaracteristicaPleito>> findCaracteristicaPleito(HttpServletRequest request, @PathVariable(name="empresa") String empresa) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API findPrioridades(emp={})...", (Object)empresa);
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            List caracteristicas = this.pleitoService.findCaracteristicasPleitoByEmpresa(emp.getId());
            if (caracteristicas != null && !caracteristicas.isEmpty()) {
                for (CaracteristicaPleito caracteristica : caracteristicas) {
                    caracteristica.setDatHorCadastro(null);
                    caracteristica.setIdUsuarioIns(null);
                    caracteristica.setDatHorAlteracao(null);
                    caracteristica.setIdUsuarioUpd(null);
                }
            }
            return new ResponseEntity((Object)caracteristicas, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findTiposPleito", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findTiposPleito", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idPleito}/{revisao}/caracteristicasPleito/{seqCaracteristica}"})
    @Operation(summary="Exibe as caracter\u00edsticas do pleito conforme seu identificador.")
    @ResponseBody
    public ResponseEntity<CaracteristicaPleito> getCaracteristicaPleito(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idPleito") Integer idPleito, @PathVariable(name="revisao") Integer revisao, @PathVariable(name="seqCaracteristica") Integer seqCaracteristica) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("Executando getCaracteristicaPleito");
        try {
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            CaracteristicaPleito caracteristicasPleito = this.pleitoService.getCaracteristicaById(empresaDB.getId(), idPleito, seqCaracteristica, revisao);
            return new ResponseEntity((Object)caracteristicasPleito, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getCaracteristicasPleito", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.getCaracteristicasPleito", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/caracteristicas"})
    @Operation(summary="Salva as caracter\u00edsticas de pleito a partir de seu payload")
    public ResponseEntity<CaracteristicaPleito> saveCaracteristicaPleito(@PathVariable(name="empresa") String empresa, @RequestBody CaracteristicaPleito caracteristica, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("saveCaracteristicaPleito({}, {})", (Object)empresa, (Object)caracteristica);
            Pleito pleito = this.pleitoService.getPleitoById(caracteristica.getId().getIdPleito(), caracteristica.getId().getIdEmpresa());
            if (pleito == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Pleito n\u00e3o informado para caracter\u00edstica.");
            }
            return new ResponseEntity((Object)this.pleitoService.saveCaracteristica(pleito, caracteristica, usr.getId(), null, null, request.getLocalAddr()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveCaracteristicaPleito", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idPleito}/{revisao}/caracteristicas/{sequencia}"})
    @Operation(summary="Exclui a caracter\u00edstica do pleito de acordo com seu ID.")
    public ResponseEntity<Boolean> deleteCaracteristicaPleito(@PathVariable(name="empresa") String empresa, @PathVariable(name="idPleito") Integer idPleito, @PathVariable(name="revisao") Integer revisao, @PathVariable(name="sequencia") Integer sequencia, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("deleteCaracteristicaPleito({})", (Object)idPleito);
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            this.pleitoService.deleteCaracteristicaPleito(idPleito, empresaDB.getId(), sequencia, revisao);
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteCaracteristicaPleito", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/tiposCaracteristica"})
    @Operation(summary="Retorna os tipos de carater\u00edsticas de pleitos")
    @ResponseBody
    public ResponseEntity<List<TipoCaracteristica>> findTiposCaracteristica(HttpServletRequest request, @PathVariable(name="empresa") String empresa) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API findTiposCaracteristica(emp={})...", (Object)empresa);
        try {
            List tipos;
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            String search = null;
            if (request.getParameter("search") != null) {
                search = request.getParameter("search");
            }
            if ((tipos = this.pleitoService.findTiposCaracteristica(search, empresaDB.getId())) != null && !tipos.isEmpty()) {
                for (TipoCaracteristica tipo : tipos) {
                    tipo.setDatHorCadastro(null);
                    tipo.setIdUsuarioIns(null);
                    tipo.setDatHorAlteracao(null);
                    tipo.setIdUsuarioUpd(null);
                }
            }
            return new ResponseEntity((Object)tipos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findTiposCaracteristicas", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findTiposCaracteristicas", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idTipoCaracteristica}/tipoCaracteristica"})
    @Operation(summary="Exibe o tipo de caracter\u00edstica conforme seu identificador.")
    @ResponseBody
    public ResponseEntity<TipoCaracteristica> getTipoCaracteristica(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idTipoCaracteristica") Integer idTipoCaracteristica) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("Executando getTipoCaracteristica");
        try {
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            TipoCaracteristica tipoCaracteristica = this.pleitoService.getTipoCaracteristicaById(idTipoCaracteristica, empresaDB.getId());
            return new ResponseEntity((Object)tipoCaracteristica, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getTipoCaracteristica", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.getTipoCaracteristica", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/tiposCaracteristica"})
    @Operation(summary="Salva os tipos de caracteristicas de pleito a partir de seu payload")
    public ResponseEntity<TipoCaracteristica> saveTiposCaracteristicas(@PathVariable(name="empresa") String empresa, @RequestBody TipoCaracteristica tipo, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("saveTiposPleito({})", (Object)tipo);
            return new ResponseEntity((Object)this.pleitoService.saveTipoCaracteristica(tipo, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveTiposCaracteristicas", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idTipo}/tiposCaracteristica"})
    @Operation(summary="Exclui o tipo de caracteristica de pleito de acordo com seu ID.")
    public ResponseEntity<Boolean> deleteTipoCaracteristica(@PathVariable(name="empresa") String empresa, @PathVariable(name="idTipo") Integer idTipo, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("deleteTipoCaracteristica({})", (Object)idTipo);
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            this.pleitoService.deleteTipoCaracteristica(idTipo, empresaDB.getId());
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteTipoCaracteristica", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/status"})
    @Operation(summary="Retorna os status de pleitos")
    @ResponseBody
    public ResponseEntity<List<PleitoStatus>> findStatusPleito(HttpServletRequest request, @PathVariable(name="empresa") String empresa) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API findStatusPleito(emp={})...", (Object)empresa);
        try {
            List status;
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            String search = null;
            if (request.getParameter("search") != null) {
                search = request.getParameter("search");
            }
            if ((status = this.pleitoService.findStatusPleito(search)) != null && !status.isEmpty()) {
                for (PleitoStatus tipo : status) {
                    tipo.setDatHorCadastro(null);
                    tipo.setIdUsuarioIns(null);
                    tipo.setDatHorAlteracao(null);
                    tipo.setIdUsuarioUpd(null);
                }
            }
            return new ResponseEntity((Object)status, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findStatusPleito", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findStatusPleito", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idStatusPleito}/status"})
    @Operation(summary="Busca o status conforme seu identificador.")
    public ResponseEntity<PleitoStatus> getStatusPleitoById(@PathVariable(name="empresa") String empresa, @PathVariable(name="idStatusPleito") Integer idStatusPleito, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("getStatusPleitoById({})", (Object)idStatusPleito);
            return ResponseEntity.ok().body((Object)this.pleitoService.getStatusPleitoById(idStatusPleito));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getStatusPleitoById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/status"})
    @Operation(summary="Salva os status de pleito a partir de seu payload")
    public ResponseEntity<PleitoStatus> saveStatusPleito(@PathVariable(name="empresa") String empresa, @RequestBody PleitoStatus status, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("saveStatusPleito({})", (Object)status);
            return new ResponseEntity((Object)this.pleitoService.saveStatusPleito(status, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveStatusPleito", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idStatus}/status"})
    @Operation(summary="Exclui o status de pleito de acordo com seu ID.")
    public ResponseEntity<Boolean> deleteStatusPleito(@PathVariable(name="empresa") String empresa, @PathVariable(name="idStatus") Integer idStatus, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("deleteStatusPleito({}, {})", (Object)empresa, (Object)idStatus);
            this.pleitoService.deleteStatusPleito(idStatus);
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteStatusPleito", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/statusAgencia"})
    @Operation(summary="Retorna os status de ag\u00eancia")
    @ResponseBody
    public ResponseEntity<List<StatusAgencia>> findStatusAgencia(@PathVariable(name="empresa") String empresa, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API findStatusAgencia(){}...", (Object)empresa);
        try {
            List status;
            String search = null;
            if (request.getParameter("search") != null) {
                search = request.getParameter("search");
            }
            if ((status = this.pleitoService.findStatusAgencia(search)) != null && !status.isEmpty()) {
                for (StatusAgencia tipo : status) {
                    tipo.setDatHorCadastro(null);
                    tipo.setIdUsuarioIns(null);
                    tipo.setDatHorAlteracao(null);
                    tipo.setIdUsuarioUpd(null);
                }
            }
            return new ResponseEntity((Object)status, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findStatusAgencia", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findStatusAgencia", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idStatusAgencia}/statusAgencia"})
    @Operation(summary="Busca o status da ag\u00eancia conforme seu identificador.")
    public ResponseEntity<StatusAgencia> getStatusAgenciaById(@PathVariable(name="empresa") String empresa, @PathVariable(name="idStatusAgencia") Integer idStatusAgencia, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("getStatusAgenciaById({}, {})", (Object)empresa, (Object)idStatusAgencia);
            return ResponseEntity.ok().body((Object)this.pleitoService.getStatusAgenciaById(idStatusAgencia));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getStatusAgenciaById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/statusAgencia"})
    @Operation(summary="Salva os status de ag\u00eancia a partir de seu payload")
    public ResponseEntity<StatusAgencia> saveStatusAgencia(@PathVariable(name="empresa") String empresa, @RequestBody StatusAgencia status, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("saveStatusAgencia({}, {})", (Object)empresa, (Object)status);
            return new ResponseEntity((Object)this.pleitoService.saveStatusAgencia(status, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveStatusAgencia", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idStatus}/statusAgencia"})
    @Operation(summary="Exclui o status de ag\u00eancia de acordo com seu ID.")
    public ResponseEntity<Boolean> deleteStatusAgencia(@PathVariable(name="empresa") String empresa, @PathVariable(name="idStatus") Integer idStatus, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("deleteStatusAgencia({}, {})", (Object)empresa, (Object)idStatus);
            this.pleitoService.deleteStatusAgencia(idStatus);
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteStatusAgencia", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/gruposTrabalho"})
    @Operation(summary="Retorna os grupos de trabalho de pleitos")
    @ResponseBody
    public ResponseEntity<List<GrupoTrabalho>> findGruposTrabalho(HttpServletRequest request, @PathVariable(name="empresa") String empresa) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API findGruposTrabalho(emp={})...", (Object)empresa);
        try {
            List grupo;
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            String search = null;
            if (request.getParameter("search") != null) {
                search = request.getParameter("search");
            }
            if ((grupo = this.pleitoService.findGruposTrabalho(empresaDB.getId(), search)) != null && !grupo.isEmpty()) {
                for (GrupoTrabalho grupos : grupo) {
                    grupos.setDatHorCadastro(null);
                    grupos.setIdUsuarioIns(null);
                    grupos.setDatHorAlteracao(null);
                    grupos.setIdUsuarioUpd(null);
                }
            }
            return new ResponseEntity((Object)grupo, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findGruposTrabalho", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findGruposTrabalho", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idGrupoTrabalho}/gruposPleito"})
    @Operation(summary="Busca o grupo de trabalho conforme seu identificador.")
    public ResponseEntity<GrupoTrabalho> getGrupoTrabalhoById(@PathVariable(name="empresa") String empresa, @PathVariable(name="idGrupoTrabalho") Integer idGrupoTrabalho, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("getGrupoTrabalhoById({}, {})", (Object)empresa, (Object)idGrupoTrabalho);
            return ResponseEntity.ok().body((Object)this.pleitoService.getGrupoTrabalhoById(idGrupoTrabalho));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getGrupoTrabalhoById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/gruposTrabalho"})
    @Operation(summary="Salva os grupos de trabalho de pleito a partir de seu payload")
    public ResponseEntity<GrupoTrabalho> saveGruposTrabalho(@PathVariable(name="empresa") String empresa, @RequestBody GrupoTrabalho grupos, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("saveGruposTrabalho({}, {})", (Object)empresa, (Object)grupos);
            return new ResponseEntity((Object)this.pleitoService.saveGrupoTrabalho(grupos, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveGruposTrabalho", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idGrupo}/gruposTrabalho"})
    @Operation(summary="Exclui o grupo de trabalho de pleito de acordo com seu ID.")
    public ResponseEntity<Boolean> deleteGrupoTrabalho(@PathVariable(name="empresa") String empresa, @PathVariable(name="idGrupo") Integer idGrupo, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("deleteGrupoTrabalho({}, {})", (Object)empresa, (Object)idGrupo);
            this.pleitoService.deleteGrupoTrabalho(idGrupo);
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteGrupoTrabalho", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/tiposDesequilibrio"})
    @Operation(summary="Retorna os tipos de desequilibrio de pleitos")
    @ResponseBody
    public ResponseEntity<List<PleitoTipoDesequilibrio>> findTiposDesequilibrio(HttpServletRequest request, @PathVariable(name="empresa") String empresa) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API findTiposDesequilibrio(emp={})...", (Object)empresa);
        try {
            List tipos;
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            String search = null;
            if (request.getParameter("search") != null) {
                search = request.getParameter("search");
            }
            if ((tipos = this.pleitoService.findTiposDesequilibrio(empresaDB.getId(), search)) != null && !tipos.isEmpty()) {
                for (PleitoTipoDesequilibrio tipo : tipos) {
                    tipo.setDatHorCadastro(null);
                    tipo.setIdUsuarioIns(null);
                    tipo.setDatHorAlteracao(null);
                    tipo.setIdUsuarioUpd(null);
                }
            }
            return new ResponseEntity((Object)tipos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findTiposDesequilibrio", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findTiposDesequilibrio", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idTipoDesequilibrio}/tipoDesequilibrio"})
    @Operation(summary="Busca o tipo de desequilibrio conforme seu identificador.")
    public ResponseEntity<PleitoTipoDesequilibrio> getTipoDesequilibrioById(@PathVariable(name="empresa") String empresa, @PathVariable(name="idTipoDesequilibrio") Integer idTipoDesequilibrio, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("getPleitoTipoDesequilibrioById({}, {})", (Object)empresa, (Object)idTipoDesequilibrio);
            return ResponseEntity.ok().body((Object)this.pleitoService.getTipoDesequilibrioById(idTipoDesequilibrio));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getTipoDesequilibrioById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/tiposDesequilibrio"})
    @Operation(summary="Salva os tipos de desequilibrio de pleito a partir de seu payload")
    public ResponseEntity<PleitoTipoDesequilibrio> saveTiposDesequilibrio(@PathVariable(name="empresa") String empresa, @RequestBody PleitoTipoDesequilibrio tipos, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("saveTiposDesequilibrio({}, {})", (Object)empresa, (Object)tipos);
            return new ResponseEntity((Object)this.pleitoService.saveTipoDesequilibrio(tipos, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveTiposDesequilibrio", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idTipo}/tiposDesequilibrio"})
    @Operation(summary="Exclui o tipo de desequilibrio de pleito de acordo com seu ID.")
    public ResponseEntity<Boolean> deleteTipoDesequilibrio(@PathVariable(name="empresa") String empresa, @PathVariable(name="idTipo") Integer idTipo, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("deleteTipoDesequilibrio({}, {})", (Object)empresa, (Object)idTipo);
            this.pleitoService.deleteTipoDesequilibrio(idTipo);
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteTipoDesequilibrio", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/revisoesTarifarias"})
    @Operation(summary="Retorna as revis\u00f5es tarif\u00e1rias de pleitos")
    @ResponseBody
    public ResponseEntity<List<RevisaoTarifaria>> findRevisoesTarifarias(HttpServletRequest request, @PathVariable(name="empresa") String empresa) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API findRevisoesTarifarias(emp={})...", (Object)empresa);
        try {
            List revisoes;
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            String search = null;
            if (request.getParameter("search") != null) {
                search = request.getParameter("search");
            }
            if ((revisoes = this.cadastroService.findRevisoesTarifarias(empresaDB.getId(), search, Boolean.valueOf(true))) != null && !revisoes.isEmpty()) {
                for (RevisaoTarifaria revisao : revisoes) {
                    revisao.setDatHorCadastro(null);
                    revisao.setIdUsuarioIns(null);
                    revisao.setDatHorAlteracao(null);
                    revisao.setIdUsuarioUpd(null);
                }
            }
            return new ResponseEntity((Object)revisoes, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findRevisoesTarifarias", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findRevisoesTarifarias", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idRevisaoTarifaria}/revisaoTarifaria"})
    @Operation(summary="Exibe a revis\u00e3o tarif\u00e1ria conforme seu identificador.")
    @ResponseBody
    public ResponseEntity<RevisaoTarifaria> getRevisaoTarifaria(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idRevisaoTarifaria") Integer idRevisaoTarifaria) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("Executando getRevisaoTarifaria, {}, {}", (Object)empresa, (Object)idRevisaoTarifaria);
        try {
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            RevisaoTarifaria revisaoTarifaria = this.cadastroService.getRevisaoTarifariaById(empresaDB.getId(), idRevisaoTarifaria);
            return new ResponseEntity((Object)revisaoTarifaria, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getRevisaoTarifaria", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.getRevisaoTarifaria", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/revisoesTarifarias"})
    @Operation(summary="Salva as revis\u00f5es tarif\u00e1rias de pleito a partir de seu payload")
    public ResponseEntity<RevisaoTarifaria> saveRevisaoTarifaria(@PathVariable(name="empresa") String empresa, @RequestBody RevisaoTarifaria revisao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("saveRevisaoTarifaria({}, {})", (Object)empresa, (Object)revisao);
            return new ResponseEntity((Object)this.cadastroService.saveRevisaoTarifaria(revisao, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveRevisaoTarifaria", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"{empresa}/{idRevisao}/revisoesTarifarias"})
    @Operation(summary="Exclui a revis\u00e3o tarif\u00e1ria de acordo com seu ID.")
    public ResponseEntity<Boolean> deleteRevisaoTarifaria(@PathVariable(name="empresa") String empresa, @PathVariable(name="idRevisao") Integer idRevisao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("deleteRevisaoTarifaria({})", (Object)idRevisao);
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            this.cadastroService.deleteRevisaoTarifaria(empresaDB.getId(), idRevisao);
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteRevisaoTarifaria", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/faixasValores"})
    @Operation(summary="Retorna as faixas de valores de pleitos")
    @ResponseBody
    public ResponseEntity<List<FaixaValor>> findFaixasValores(@PathVariable(name="empresa") String empresa, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API findFaixasValores(), {}", (Object)empresa);
        try {
            List faixas;
            String search = null;
            if (request.getParameter("search") != null) {
                search = request.getParameter("search");
            }
            if ((faixas = this.pleitoService.findFaixasValores(search)) != null && !faixas.isEmpty()) {
                for (FaixaValor faixa : faixas) {
                    faixa.setDatHorCadastro(null);
                    faixa.setIdUsuarioIns(null);
                    faixa.setDatHorAlteracao(null);
                    faixa.setIdUsuarioUpd(null);
                }
            }
            return new ResponseEntity((Object)faixas, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.FaixaValor", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.FaixaValor", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idFaixaValor}/faixaValor"})
    @Operation(summary="Busca a faixa de valor conforme seu identificador.")
    public ResponseEntity<FaixaValor> getFaixaValorById(@PathVariable(name="empresa") String empresa, @PathVariable(name="idFaixaValor") Integer idFaixaValor, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("getFaixaValorById({}, {})", (Object)empresa, (Object)idFaixaValor);
            return ResponseEntity.ok().body((Object)this.pleitoService.getFaixaValorById(idFaixaValor));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getFaixaValorById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/faixasValores"})
    @Operation(summary="Salva as faixas de valores a partir de seu payload")
    public ResponseEntity<FaixaValor> saveFaixaValor(@PathVariable(name="empresa") String empresa, @RequestBody FaixaValor faixa, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("saveFaixaValor({}, {})", (Object)empresa, (Object)faixa);
            return new ResponseEntity((Object)this.pleitoService.saveFaixaValor(faixa, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveFaixaValor", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idFaixa}/faixasValores"})
    @Operation(summary="Exclui a faixa de valor de acordo com seu ID.")
    public ResponseEntity<Boolean> deleteFaixaValor(@PathVariable(name="empresa") String empresa, @PathVariable(name="idFaixa") Integer idFaixa, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("deleteFaixaValor({}, {})", (Object)empresa, (Object)idFaixa);
            this.pleitoService.deleteFaixaValor(idFaixa);
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteFaixaValor", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/possibilidadesExito"})
    @Operation(summary="Retorna as possibilidades \u00eaxito de pleitos")
    @ResponseBody
    public ResponseEntity<List<PossibilidadeExito>> findPossibilidadesExito(@PathVariable(name="empresa") String empresa, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API findPossibilidadesExito(), {}", (Object)empresa);
        try {
            List possibilidades;
            String search = null;
            if (request.getParameter("search") != null) {
                search = request.getParameter("search");
            }
            if ((possibilidades = this.pleitoService.findPossibilidades(search, null)) != null && !possibilidades.isEmpty()) {
                for (PossibilidadeExito possibilidade : possibilidades) {
                    possibilidade.setDatHorCadastro(null);
                    possibilidade.setIdUsuarioIns(null);
                    possibilidade.setDatHorAlteracao(null);
                    possibilidade.setIdUsuarioUpd(null);
                }
            }
            return new ResponseEntity((Object)possibilidades, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findPossibilidadesExito", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findPossibilidadesExito", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idPossibilidadeExito}/possibilidadesExito"})
    @Operation(summary="Busca a possibilidade de \u00eaxito conforme seu identificador.")
    public ResponseEntity<PossibilidadeExito> getPossibilidadeExitoById(@PathVariable(name="empresa") String empresa, @PathVariable(name="idPossibilidadeExito") Integer idPossibilidadeExito, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("getPossibilidadeExitoById({}, {})", (Object)empresa, (Object)idPossibilidadeExito);
            return ResponseEntity.ok().body((Object)this.pleitoService.getPossibilidadeById(idPossibilidadeExito));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getPossibilidadeExitoById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/possibilidadesExito"})
    @Operation(summary="Salva as possibilidades de \u00eaxito a partir de seu payload")
    public ResponseEntity<PossibilidadeExito> savePossibilidadeExito(@PathVariable(name="empresa") String empresa, @RequestBody PossibilidadeExito possibilidade, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("savePossibilidadeExito({}, {})", (Object)empresa, (Object)possibilidade);
            return new ResponseEntity((Object)this.pleitoService.savePossibilidade(possibilidade, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.savePossibilidadeExito", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idPossibilidade}/possibilidadesExito"})
    @Operation(summary="Exclui a possibilidade de \u00eaxito de acordo com seu ID.")
    public ResponseEntity<Boolean> deletePossibilidadeExito(@PathVariable(name="empresa") String empresa, @PathVariable(name="idPossibilidade") Integer idPossibilidade, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("deletePossibilidadeExito({}, {})", (Object)empresa, (Object)idPossibilidade);
            this.pleitoService.deletePossibilidade(idPossibilidade);
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deletePossibilidadeExito", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idPleito}/{idUsuario}/{resourcePath}/pleito"})
    @Operation(summary="Exclui o pleito de acordo com seu ID.")
    public ResponseEntity<Boolean> deletePleito(@PathVariable(name="empresa") String empresa, @PathVariable(name="idPleito") Integer idPleito, @PathVariable(name="idUsuario") Integer idUsuario, @PathVariable(name="resourcePath") String resourcePath, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("deletePleito({}, {})", (Object)empresa, (Object)idPleito);
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada para a sigla informada.");
            }
            this.pleitoService.removePleito(idPleito, emp.getId(), resourcePath, empresa, idUsuario, request.getLocalAddr());
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deletePleito", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/fluxosCaixa"})
    @Operation(summary="Lista os tipos de fluxo de caixa cadastrados .")
    public ResponseEntity<List<TipoFluxoCaixa>> findFluxosCaixa(HttpServletRequest request, @PathVariable(name="empresa") String empresa) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "TIPOS_FLUXO_CAIXA");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"TIPOS_FLUXO_CAIXA");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            String search = null;
            Object tipoAtivo = null;
            if (request.getParameter("search") != null) {
                search = request.getParameter("search");
            }
            logger.debug("{} - findFluxosCaixa({}, {}, {})", new Object[]{usuario.getLogin(), search, tipoAtivo, empresa});
            List rows = this.pleitoService.findTiposFluxosCaixa(search);
            return ResponseEntity.ok().body((Object)rows);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findFluxosCaixa", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/fluxosCaixa/{idTipoFluxoCaixa}"})
    @Operation(summary="Busca o fluxo caixa conforme seu ID.")
    public ResponseEntity<TipoFluxoCaixa> getFluxoCaixaById(@PathVariable(name="empresa") String empresa, @PathVariable(name="idTipoFluxoCaixa") Integer idTipofluxoCaixa, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
        }
        logger.debug("{} - Executando getFluxoById({}, {})", new Object[]{usuario.getLogin(), empresa, idTipofluxoCaixa});
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "TIPOS_FLUXO_CAIXA");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"TIPOS_FLUXO_CAIXA");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            return ResponseEntity.ok().body((Object)this.pleitoService.getTipoFluxoCaixaById(idTipofluxoCaixa));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getFluxoCaixaById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/fluxosCaixa"})
    @Operation(summary="Salva as informa\u00e7\u00f5es do tipo fluxo de caixa.")
    public ResponseEntity<TipoFluxoCaixa> saveFluxoCaixa(@PathVariable(name="empresa") String empresa, @RequestBody TipoFluxoCaixa fluxoCaixa, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
        }
        try {
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            logger.debug("({}) - saveFluxo({})", (Object)usuario.getLogin(), (Object)empresa);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "TIPOS_FLUXO_CAIXA");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"TIPOS_FLUXO_CAIXA");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            TipoFluxoCaixa poderDB = this.pleitoService.saveTipoFluxoCaixa(fluxoCaixa, Integer.valueOf(1));
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)poderDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveFluxoCaixa", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/fluxosCaixa/{idTipoFluxoCaixa}"})
    @Operation(summary="Deleta o fluxo de caixa de acordo com seu ID.")
    public ResponseEntity<Boolean> deleteFluxoCaixa(@PathVariable(name="empresa") String empresa, @PathVariable(name="idTipoFluxoCaixa") Integer idTipoFluxoCaixa, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
        }
        try {
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            logger.debug("{} - deleteFluxoCaixa({})", (Object)usuario.getLogin(), (Object)idTipoFluxoCaixa);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "TIPOS_FLUXO_CAIXA");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"TIPOS_FLUXO_CAIXA");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            this.pleitoService.deleteTipoFluxoCaixa(idTipoFluxoCaixa);
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteFluxoCaixa", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

