unit Unit16;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, Db, Grids, DBGrids;

type
  TForm16 = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    GroupBox2: TGroupBox;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Edit6: TEdit;
    Edit7: TEdit;
    Edit8: TEdit;
    GroupBox11: TGroupBox;
    Label22: TLabel;
    Label23: TLabel;
    Label24: TLabel;
    Label25: TLabel;
    Edit22: TEdit;
    Edit23: TEdit;
    Edit24: TEdit;
    Edit25: TEdit;
    BitBtn3: TBitBtn;
    Label26: TLabel;
    Edit26: TEdit;
    Label27: TLabel;
    BitBtn5: TBitBtn;
    BitBtn2: TBitBtn;
    BitBtn1: TBitBtn;
    BitBtn4: TBitBtn;
    GroupBox1: TGroupBox;
    DBGrid1: TDBGrid;
    DataSource1: TDataSource;
    Label1: TLabel;
    Edit1: TEdit;
    Label2: TLabel;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    Label3: TLabel;
    Label4: TLabel;
    ComboBox1: TComboBox;
    Button1: TButton;
    procedure Trfego1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure BitBtn4Click(Sender: TObject);
    procedure BitBtn5Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form16: TForm16;

implementation

uses Childwin, ComObj, ActiveX, Unit72, Unit10, Unit24;

{$R *.DFM}

procedure TForm16.Trfego1Click(Sender: TObject);
begin
  MDIChild.Trfego1Click(Sender);
end;


procedure TForm16.BitBtn2Click(Sender: TObject);
begin
  Close;
end;

procedure TForm16.BitBtn1Click(Sender: TObject);
const
  Nmax = 30;
  NFieldsMax = 20;
var
  Excel: OleVariant;
  ArqDados: TextFile;
  TaxaAutos, TaxaCam, TaxaOnibus, FV2, FV3, FV4, FV5, FV6: Single;
  Ano, NPeriodos, Code, FileCodeExcel, icont, i, j, NFields, Ntraf: integer;
  Programa, Dados, Calc, Arquivo, ArqCsv, ArqDbf, Linha, Param, Simula,
    TrafData, DadosAnoBase: string;
  Year: string[4];
  Nome: array [1..Nmax] of string[15];
  Pedagio: array [1..Nmax] of string[15];
  isent: array [1..Nmax] of integer;
  Campo: array [1..NFieldsMax] of string[15];
  Sentido: string[15];
  NumSec, Flag: SmallInt;
  StartTime: TDateTime;
begin
 if ComboBox1.Text <> '' then
 begin
  Screen.Cursor := crHourglass;
  DataModule10.Table8.Active := False;
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Year := IntToStr(Ano);
  if CheckBox1.Checked = True then Simula := 'Sim' else Simula := 'Nao';
  Arquivo := Calc + 'Excesso.dat';
  AssignFile(ArqDados, Arquivo);
  Rewrite(ArqDados);
  Writeln(ArqDados, Simula);
  CloseFile(ArqDados);
  Arquivo := Calc + 'Trafego.dat';
  AssignFile(Arqdados, Arquivo);
  Rewrite(ArqDados);
  Val(Edit6.Text, TaxaAutos, Code);
  Val(Edit7.Text, TaxaCam, Code);
  Val(Edit8.Text, TaxaOnibus, Code);
  Writeln(ArqDados, TaxaAutos);
  Writeln(ArqDados, TaxaCam);
  Writeln(ArqDados, TaxaOnibus);
  Val(Edit22.Text, FV2, Code);
  Val(Edit23.Text, FV3, Code);
  Val(Edit24.Text, FV4, Code);
  Val(Edit25.Text, FV5, Code);
  Val(Edit26.Text, FV6, Code);
  Writeln(ArqDados, FV2:9:5);
  Writeln(ArqDados, FV3:9:5);
  Writeln(ArqDados, FV4:9:5);
  Writeln(ArqDados, FV5:9:5);
  Writeln(ArqDados, FV6:9:5);
  CloseFile(ArqDados);
  ArqDbf := Dados + 'Pedagios.dbf';
  ArqCsv := Dados + 'Pedagios.csv';
  if FileExists(ArqCsv) then
    begin
      AssignFile(ArqDados, ArqCsv);
      Erase(ArqDados)
    end;
  Excel := CreateOleObject('Excel.Application');
  Excel.Visible := False;
  FileCodeExcel := 8;
  Excel.Workbooks.Open(ArqDbf, True, FileCodeExcel);
  Excel.Workbooks.Add;
  Excel.Workbooks[1].Sheets[1].UsedRange.Copy;
  Excel.Workbooks[2].Sheets[1].PasteSpecial;
  FileCodeExcel := 6;
  Excel.Workbooks[2].Sheets[1].SaveAs(ArqCsv, FileCodeExcel);
  Excel.Workbooks[2].Saved := True;
  Excel.Workbooks.Close;
  Excel.Quit;
  for i := 1 to Nmax do
    begin
      Nome[i] := '';
      Pedagio[i] := '';
    end;
  AssignFile(ArqDados, ArqCsv);
  Reset(ArqDados);
  Readln(ArqDados, Linha);
  icont := 0;
  NFields := 3;
  while not Eof(ArqDados) do
    begin
      Readln(ArqDados, Linha);
      icont := icont + 1;
      j := 1;
      for i := 1 to NFields do
        Campo[i] := '';
      for i := 1 to Length(Linha) do
        begin
          if Linha[i] = ',' then
            j := j + 1
          else
            Campo[j] := Campo[j] + Linha[i];
        end;
      Nome[icont] := Campo[1];
      Sentido := Campo[2];
      Pedagio[icont] := Campo[3];
      if Sentido[1] = 'U' then isent[icont] := 1 else isent[icont] := 2;
    end;
  CloseFile(ArqDados);
  Arquivo := DadosAnoBase + 'Pedagios.dat';
  AssignFile(ArqDados, Arquivo);
  Rewrite(ArqDados);
  Writeln(ArqDados, icont);
  Writeln(ArqDados, Edit1.Text);
  for i := 1 to icont do
    begin
      Writeln(ArqDados, Nome[i]);
      Writeln(ArqDados, isent[i]);
    end;
  CloseFile(ArqDados);
  AssignFile(ArqDados, 'Pedg.dat');
  Rewrite(ArqDados);
  Writeln(ArqDados, 'Contagem');
  for i := 1 to icont do
    Writeln(ArqDados, Pedagio[i]);
  CloseFile(ArqDados);
  Ntraf := StrToInt(ComboBox1.Text);
  AssignFile(ArqDados, 'TrafData.dat');
  Rewrite(ArqDados);
  Writeln(ArqDados, Ntraf);
  for i := 1 to Ntraf do
    begin
      j := i - 1;
      TrafData := Dados + IntToStr(Ano-j) + '\';
      Writeln(ArqDados, TrafData);
    end;
  CloseFile(ArqDados);
  Arquivo := 'DOS.DAT';
  if FileExists(Arquivo) then
    begin
      AssignFile(ArqDados, Arquivo);
      Erase(ArqDados)
    end;
  WinExec('command.com /c Pedagios.bat', SW_HIDE);
  Flag := 0;
  StartTime := now;
  NumSec := 5;
  repeat
    Application.ProcessMessages;
    if FileExists(Arquivo) then Flag := 1;
  until (Now > StartTime + NumSec * (1/24/60/60)) and (Flag = 1);
  Screen.Cursor := crDefault;
  Close;
 end;
end;

procedure TForm16.BitBtn3Click(Sender: TObject);
const
  NCat = 18;
  NEixosVeic = 6;
var
  Excel: OleVariant;
  Ano, NPeriodos, i, icont, eixo, Neixos, j, NTotalEixos, FileCodeExcel,
    Pmax, NeixosPesagem: integer;
  Arquivo, Programa, Dados, Calc, Linha, Carga, ArqCsv, ArqDbf,
    DadosAnoBase: string;
  Year: string[4];
  ArqDados: TextFile;
  Load, L2, Nveic: array[1..NEixosVeic] of integer;
  Achou: boolean;
  Fv, Fc, PSI0, PSIt, Rho18, Rho, Bheta18, Bheta, SN, L1, PBruto: Single;
  Fveic: array[1..NEixosVeic] of Single;
  EixosSimples, EixosTandem, NEixosSimples, NEixosTandem: array [1..NCat] of Single;
begin
  Screen.Cursor := crHourglass;
  { Ano-base e subdiretrios }
    AssignFile(ArqDados, 'Diretor.dat');
    Reset(ArqDados);
    Readln(ArqDados, Ano);
    Readln(ArqDados, NPeriodos);
    Readln(ArqDados, Programa);
    Readln(ArqDados, Dados);
    Readln(ArqDados, Calc);
    Readln(ArqDados, DadosAnoBase);
    CloseFile(ArqDados);
    Year := IntToStr(Ano);
  DataModule24.Table28.Active := False;
  for i := 1 to NEixosVeic do
    begin
      Fveic[i] := 0.0;
      Nveic[i] := 0;
    end;
  EixosSimples[1] := 0.0;
  EixosTandem[1] := 0.0;
  NEixosSimples[1] := 0;
  NEixosTandem[1] := 0;
  for i := 2 to NCat do
    begin
      NEixosSimples[i] := 0;
      NEixosTandem[i] := 0;
      EixosSimples[i] := EixosSimples[i-1] + 1000.0;
      EixosTandem[i] := EixosTandem[i-1] + 2000.0;
    end;
  NTotalEixos := 0;
  { L o arquivo das pesagens e calcula Fv(AASHTO) para cada tipo de veculo }
    Arquivo := Dados + 'Cargas\' + 'BALANCA.TXT';
    AssignFile(ArqDados, Arquivo);
    Reset(ArqDados);
    Achou := False;
    while not Eof(ArqDados) do
      begin
        Readln(ArqDados, Linha);
        icont := 1;
        Neixos := 0;
        for i := 1 to Length(Linha) do
          begin
            if Linha[i] = '@' then
              begin
                if Achou then
                  begin
                    Load[eixo] := StrToInt(Carga);
                    if Load[eixo] > 0 then Neixos := Neixos + 1;
                  end;
                inc(icont);
                Achou := (icont in [12..17]);
                Carga := '';
                if Achou then
                  begin
                    case icont of
                      12: eixo := 1;
                      13: eixo := 2;
                      14: eixo := 3;
                      15: eixo := 4;
                      16: eixo := 5;
                      17: eixo := 6;
                      else
                    end;
                  end;
              end
            else
              begin
                if Achou then
                  if Linha[i] <> '' then Carga := Carga + Linha[i];
              end;
          end;
        { Obtidas as cargas de eixo do veculo, calcula-se Fv }
        NeixosPesagem := Neixos;
        PBruto := 0.0;
        for i := 1 to Neixos do
          PBruto := PBruto + (Load[i]/1000);
        if PBruto > 3.0 then
         begin
          L2[1] := 1;
            if Neixos = 2 then
              L2[Neixos] := 1
            else
              if Neixos = 3 then
                begin
                  if PBruto <= 20.0 then
                    begin
                      Neixos := 2;
                      L2[Neixos] := 2;
                      Load[Neixos] := Load[2] + Load[3];
                    end
                  else
                    begin
                      L2[2] := 1;
                      L2[3] := 1;
                    end;
                end
              else
                if Neixos = 4 then
                  { Considerado como 2S2 }
                  begin
                    Neixos := 3;
                    L2[2] := 1;
                    L2[3] := 2;
                    Load[3] := Load[3] + Load[4];
                  end
                else
                  if Neixos = 5 then
                    { Considerado como 2S3 }
                    begin
                      Neixos := 3;
                      L2[2] := 1;
                      L2[3] := 2;
                      Load[3] := Load[3] + Load[4] + Load[5];
                    end
                  else
                    begin
                      { 6 eixos ==> considerado como 3S3 }
                      Neixos := 3;
                      L2[2] := 2;
                      L2[3] := 2;
                      Load[2] := Load[2] + Load[3];
                      Load[3] := Load[4] + Load[5] + Load[6];
                    end;
            Fv := 0.0;
            for i := 1 to Neixos do
              begin
                if L2[i] = 1 then
                  begin
                    if Load[i] > EixosSimples[NCat] then
                      NEixosSimples[NCat] := NEixosSimples[NCat] + 1
                    else
                      for j := 1 to NCat-1 do
                        begin
                          if Load[i] > EixosSimples[j] then
                            if Load[i] <= EixosSimples[j+1] then
                              NEixosSimples[j] := NEixosSimples[j] + 1;
                        end;
                  end
                else
                  begin
                    if Load[i] > EixosTandem[NCat] then
                      NEixosTandem[NCat] := NEixosTandem[NCat] + 1
                    else
                      for j := 1 to NCat-1 do
                        begin
                          if Load[i] > EixosTandem[j] then
                            if Load[i] <= EixosTandem[j+1] then
                              NEixosTandem[j] := NEixosTandem[j] + 1;
                        end;
                  end;
                NTotalEixos := NTotalEixos + 1;
                PSI0 := 4.2;
                PSIt := 2.5;
                SN := 3.0;
                if CheckBox1.Checked = True then
                  begin
                    if L2[i] = 1 then Pmax := 10500 else Pmax := 17850;
                    if Load[i] > Pmax then Load[i] := Pmax;
                  end;
                L1 := Load[i]/(0.4536*1000);
                Bheta := 0.40+0.081*exp(3.23*ln(L1+L2[i]))/(exp(5.19*ln(SN+1))*exp(3.23*ln(L2[i])));
                Bheta18 := 0.40+0.081*exp(3.23*ln(18+1))/(exp(5.19*ln(SN+1))*exp(3.23*ln(1)));
                Rho := 5.93+9.36*(ln(SN+1)/ln(10.0))-4.79*(ln(L1+L2[i])/ln(10.0))+4.33*(ln(L2[i])/ln(10.0));
                Rho := exp(Rho*ln(10.0));
                Rho18 := 5.93+9.36*(ln(SN+1)/ln(10.0))-4.79*(ln(18+1)/ln(10.0))+4.33*(ln(1)/ln(10.0));
                Rho18 := exp(Rho18*ln(10.0));
                Fc := (Rho18/Rho)*exp(((1/Bheta18)-(1/Bheta))*ln((PSI0-PSIt)/(PSI0-1.5)));
                Fv := Fv + Fc;
              end;
            Fveic[NeixosPesagem] := Fveic[NeixosPesagem] + Fv;
            Nveic[NeixosPesagem] := Nveic[NeixosPesagem] + 1;
         end;
      end;
      for i := 2 to NEixosVeic do
        begin
          Fveic[i] := Fveic[i] / Nveic[i];
          case i of
               2: Edit22.Text := FloatToStr(Fveic[i]);
               3: Edit23.Text := FloatToStr(Fveic[i]);
               4: Edit24.Text := FloatToStr(Fveic[i]);
               5: Edit25.Text := FloatToStr(Fveic[i]);
               6: Edit26.Text := FloatToStr(Fveic[i]);
               else
          end;
        end;
  for i := 1 to NCat do
    begin
      NEixosSimples[i] := 100 * NEixosSimples[i] / NTotalEixos;
      NEixosTandem[i] := 100 * NEixosTandem[i] / NTotalEixos;
    end;
  Arquivo := Calc + 'Simples.csv';
  AssignFile(ArqDados, Arquivo);
  Rewrite(ArqDados);
  Writeln(ArqDados, 'Qmin (tf)', ',', 'Qmax (tf)', ',', 'Freq. (%)');
  for i := 1 to NCat-1 do
    Writeln(ArqDados, EixosSimples[i]/1000, ',', EixosSimples[i+1]/1000, ',', NEixosSimples[i]);
  Writeln(ArqDados, EixosSimples[NCat]/1000, ',', 2*EixosSimples[NCat]/1000, ',', NEixosSimples[NCat]);
  CloseFile(ArqDados);
  Arquivo := Calc + 'Tandem.csv';
  AssignFile(ArqDados, Arquivo);
  Rewrite(ArqDados);
  Writeln(ArqDados, 'Qmin (tf)', ',', 'Qmax (tf)', ',', 'Freq. (%)');
  for i := 1 to NCat-1 do
    Writeln(ArqDados, EixosTandem[i]/1000, ',', EixosTandem[i+1]/1000, ',', NEixosTandem[i]);
  Writeln(ArqDados, EixosTandem[NCat]/1000, ',', 2*EixosTandem[NCat]/1000, ',', NEixosTandem[NCat]);
  CloseFile(ArqDados);
  { Converte de CSV para DBF }
    Excel := CreateOleObject('Excel.Application');
    Excel.Visible := False;
    ArqDbf := Calc + 'Simples.dbf';
    if FileExists(ArqDbf) then
      begin
        AssignFile(ArqDados, ArqDbf);
        Erase(ArqDados)
      end;
    ArqCsv := Calc + 'Simples.csv';
    FileCodeExcel := 6;
    Excel.Workbooks.Open(ArqCsv, True, FileCodeExcel);
    Excel.Workbooks.Add;
    Excel.Workbooks[1].Sheets[1].UsedRange.Copy;
    Excel.Workbooks[2].Sheets[1].PasteSpecial;
    FileCodeExcel := 8;
    Excel.Workbooks[2].Sheets[1].Columns[3].NumberFormat := '###.####';
    Excel.Workbooks[2].Sheets[1].SaveAs(ArqDbf, FileCodeExcel);
    Excel.Workbooks[2].Saved := True;
    Excel.Workbooks.Close;
    ArqDbf := Calc + 'Tandem.dbf';
    if FileExists(ArqDbf) then
      begin
        AssignFile(ArqDados, ArqDbf);
        Erase(ArqDados)
      end;
    ArqCsv := Calc + 'Tandem.csv';
    FileCodeExcel := 6;
    Excel.Workbooks.Open(ArqCsv, True, FileCodeExcel);
    Excel.Workbooks.Add;
    Excel.Workbooks[1].Sheets[1].UsedRange.Copy;
    Excel.Workbooks[2].Sheets[1].PasteSpecial;
    FileCodeExcel := 8;
    Excel.Workbooks[2].Sheets[1].Columns[3].NumberFormat := '###.####';
    Excel.Workbooks[2].Sheets[1].SaveAs(ArqDbf, FileCodeExcel);
    Excel.Workbooks[2].Saved := True;
    Excel.Workbooks.Close;
    Excel.Quit;
  BitBtn5.Visible := True;
  Screen.Cursor := crDefault;
end;

procedure TForm16.FormShow(Sender: TObject);
var
  ArqDados: TextFile;
  Ano, NPeriodos, Nper, i: integer;
  Programa, Dados, Calc, Arquivo: string;
begin
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  CloseFile(ArqDados);
  BitBtn1.Visible := False;
  BitBtn3.Visible := False;
  BitBtn5.Visible := False;
  Label1.Caption := '';
  Edit1.Visible := False;
  DataModule10.Table8.Active := False;
  Nper := Ano - 2003;
  Arquivo := Calc + 'Traf.dat';
  AssignFile(ArqDados, Arquivo);
  Rewrite(ArqDados);
  for i := 1 to Nper do
    Writeln(ArqDados, i);
  CloseFile(ArqDados);
  ComboBox1.Items.LoadFromFile(Arquivo);
end;

procedure TForm16.BitBtn4Click(Sender: TObject);
const
  Nmax = 30;
var
  ArqDados: TextFile;
  TaxaAutos, TaxaCam, TaxaOnibus, FV2, FV3, FV4, FV5, FV6: Single;
  Ano, NPeriodos, Code, NCat, icont, i, Ntraf: integer;
  Programa, Dados, Calc, Arquivo, TrafData, DadosAnoBase: string;
  Year: string[4];
  Nome: array [1..Nmax] of string[8];
  Pedagio: array [1..Nmax] of string;
  isent: array [1..Nmax] of integer;
begin
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Arquivo := Programa + 'Pedag.dat';
  DBGrid1.Columns[0].PickList.LoadFromFile(Arquivo);
  DataModule10.Table8.Active := True;
  Label1.Caption := 'Nmero de categorias de veculos = ';
  Edit1.Visible := True;
  Year := IntToStr(Ano);
  Arquivo := Calc + 'Trafego.dat';
  AssignFile(Arqdados, Arquivo);
  Reset(ArqDados);
  Readln(ArqDados, TaxaAutos);
  Readln(ArqDados, TaxaCam);
  Readln(ArqDados, TaxaOnibus);
  Readln(ArqDados, FV2);
  Readln(ArqDados, FV3);
  Readln(ArqDados, FV4);
  Readln(ArqDados, FV5);
  Readln(ArqDados, FV6);
  CloseFile(ArqDados);
  Edit6.Text := FloatToStr(TaxaAutos);
  Edit7.Text := FloatToStr(TaxaCam);
  Edit8.Text := FloatToStr(TaxaOnibus);
  Edit22.Text := FloatToStr(FV2);
  Edit23.Text := FloatToStr(FV3);
  Edit24.Text := FloatToStr(FV4);
  Edit25.Text := FloatToStr(FV5);
  Edit26.Text := FloatToStr(FV6);
  BitBtn1.Visible := True;
  BitBtn3.Visible := True;
  Arquivo := DadosAnoBase + 'Pedagios.dat';
  AssignFile(ArqDados, Arquivo);
  Reset(ArqDados);
  Readln(ArqDados, icont);
  Readln(ArqDados, NCat);
  for i := 1 to icont do
    begin
      Readln(ArqDados, Nome[i]);
      Readln(ArqDados, isent[i]);
    end;
  CloseFile(ArqDados);
  Edit1.Text := IntToStr(NCat);
  AssignFile(ArqDados, 'TrafData.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ntraf);
  for i := 1 to Ntraf do
    Readln(ArqDados, TrafData);
  CloseFile(ArqDados);
  ComboBox1.Text := IntToStr(Ntraf);
end;

procedure TForm16.BitBtn5Click(Sender: TObject);
begin
  TOKBottomDlg1.Create(Self);
end;

procedure TForm16.CheckBox2Click(Sender: TObject);
begin
  if CheckBox2.Checked = True then CheckBox1.Checked := False;
  if CheckBox2.Checked = False then CheckBox1.Checked := True;
end;

procedure TForm16.CheckBox1Click(Sender: TObject);
begin
  if CheckBox1.Checked = True then CheckBox2.Checked := False;
  if CheckBox1.Checked = False then CheckBox2.Checked := True;
end;

procedure TForm16.Button1Click(Sender: TObject);
var
  Excel: OleVariant;
  ArqDados: TextFile;
  Ano, NPeriodos, Code, FileCodeExcel: integer;
  Programa, Dados, Calc, Arquivo, DadosAnoBase: string;
  Year: string[4];
begin
  Screen.Cursor := crHourglass;
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Year := IntToStr(Ano);
  Excel := CreateOleObject('Excel.Application');
  Excel.Visible := True;
  FileCodeExcel := 1;
  Arquivo := DadosAnoBase + 'Trafego.xls';
  Excel.Workbooks.Open(Arquivo, True, FileCodeExcel);
  Screen.Cursor := crDefault;
end;

initialization
  CoInitialize (nil);

end.
