CLS

' Vetores e Matrizes associados `as faixas de trafego:
NFaixasMax = 4
DIM CustoFaixa(NFaixasMax), MedidaAcost$(NFaixasMax), HRAC(NFaixasMax)
DIM H2AC(NFaixasMax), MedidaF$(NFaixasMax), Hfres(NFaixasMax), Hrec(NFaixasMax)
DIM ConserP(NPolos), UltCamada$(NFaixasMax), VDMUni(NFaixasMax)
DIM REVEST$(NFaixasMax), Nacum(NFaixasMax), VidaRes(NFaixasMax), CotaFaixa(NFaixasMax)
DIM ALFAIGG(NFaixasMax), Restaurado$(NFaixasMax), PSInovo(NFaixasMax), SN(NFaixasMax)
DIM HREFORCO(NFaixasMax), HRef(NFaixasMax), Heff(NFaixasMax), IRec(NFaixasMax)
DIM ICalib(NFaixasMax), D0(NFaixasMax), MRfound(NFaixasMax)
DIM PSIacost(NFaixasMax), DegrauAcost(NFaixasMax)
DIM CustoAcost(NFaixasMax), ATRat(NFaixasMax, 40)

OPEN "DIRETOR.DAT" FOR INPUT AS #1
INPUT #1, ANOBASE
INPUT #1, NPeriodos
INPUT #1, PROGRAMA$
INPUT #1, DADOS$
INPUT #1, CALC$
INPUT #1, DadosAnoBase$
CLOSE #1

' Codigos de identificacao das rodovias que compoem a rede:
ARQUIVO$ = DadosAnoBase$ + "RODOVIAS.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NRODOV
DIM Rodov$(NRODOV), NSTHRODOV(NRODOV)
FOR I = 1 TO NRODOV
    INPUT #1, Rodov$(I)
NEXT I
CLOSE #1

' Numero de Subtrechos Homogeneos por rodovia:
ARQUIVO$ = CALC$ + "NSTHROD.OUT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NSTHMAX
FOR I = 1 TO NRODOV
    INPUT #1, NSTHRODOV(I)
NEXT I
CLOSE #1

' Numero total de Subtrechos Homogeneos da rede
NSTH = 0
FOR I = 1 TO NRODOV
    NSTH = NSTH + NSTHRODOV(I)
NEXT I
DIM AnoRest(NSTH, NFaixasMax)

' - - - - - - - - - - - -
' - Vetores e Matrizes  -
' - - - - - - - - - - - -
DIM QImed(NFaixasMax), H1REV(NFaixasMax), HrecExist(NFaixasMax), VRmed(NPeriodos)
DIM Idade(NFaixasMax), PSIat(NSTH, NFaixasMax), NANO(NFaixasMax), PPrest(NPeriodos)
DIM RestrAnual(NPeriodos), RestrPolo(NPolos, NPeriodos), IPRIOR(NSTH, NFaixasMax)
DIM PSImed(NPeriodos), Aream2(NSTH, NFaixasMax), AreaAcost(NSTH, NFaixasMax)
DIM PSImedSTH(NSTH), NPSI(NPeriodos), PSIt(1), NFaixas(NSTH)
DIM IRI0(NFaixasMax), ALPHA(NFaixasMax)
DIM EXECF(NSTH, NFaixasMax), NewRestP(NPolos), CustoCLP(NPolos), Deficit(NPeriodos)
DIM IPMAXPolo(NPolos), STHPRIPolo(NPolos), CostPr(NPolos), CUSTOT(NPeriodos)
DIM STH(NSTHMAX)

' Arquivo de configuracao do problema a ser analisado:
ARQUIVO$ = CALC$ + "Modo.dat"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, MODO
CLOSE #1

SELECT CASE MODO
    CASE 1
        MODOANALISE$ = "EstratBase"
        ARQ$ = "EB"
        ARQUIVO$ = CALC$ + ARQ$ + ".CSV"
        OPEN ARQUIVO$ FOR INPUT AS #9
        LINE INPUT #9, LINHA$
    CASE 2
        MODOANALISE$ = "EstratRO"
        ARQ$ = "RO"
        ARQUIVO$ = CALC$ + ARQ$ + ".CSV"
        OPEN ARQUIVO$ FOR INPUT AS #9
        LINE INPUT #9, LINHA$
    CASE 0
        MODOANALISE$ = "EVOLUI"
        ARQ$ = "EVO"
        ARQUIVO$ = CALC$ + ARQ$ + ".CSV"
        OPEN ARQUIVO$ FOR INPUT AS #9
        LINE INPUT #9, LINHA$
    CASE 5
        MODOANALISE$ = "NECESSIDADES"
        ARQ$ = "NAT"
    CASE 6
        MODOANALISE$ = "ATUAL"
        ARQ$ = "NAT"
    CASE ELSE
        PRINT "ERRO"
END SELECT

ARQUIVO$ = CALC$ + "ESTSTHS0.DAT"
OPEN ARQUIVO$ FOR INPUT AS #12

ARQUIVO$ = CALC$ + "IDS.OUT"
OPEN ARQUIVO$ FOR INPUT AS #10

ISTH = 0
FOR IRodov = 1 TO NRODOV

    ARQUIVO$ = CALC$ + "MOD" + Rodov$(IRodov) + "2.CSV"
    OPEN ARQUIVO$ FOR INPUT AS #14
    LINE INPUT #14, LINHA$

    ARQUIVO$ = CALC$ + "ATR" + Rodov$(IRodov) + ".CSV"
    OPEN ARQUIVO$ FOR INPUT AS #11
    LINE INPUT #11, LINHA$

    ARQUIVO$ = CALC$ + "OC" + ARQ$ + Rodov$(IRodov) + ".CSV"
    OPEN ARQUIVO$ FOR OUTPUT AS #15
    WRITE #15, "STH", "km", "H1cm", "D0 Fx1", "D0 Fx2", "E1", "E2", "E3", "QI Fx1", "QI Fx2", "ATR Fx1", "ATR Fx2", "PSI Fx1", "PSI Fx2", "IDS Fx1", "IDS Fx2", "VR Fx1", "VR Fx2"

    FOR ISUB = 1 TO NSTHRODOV(IRodov)

        ISTH = ISTH + 1
        INPUT #10, J, IGG(1), IGG(2), IGG(3), IGG(4), TR23(1), TR23(2), TR23(3), TR23(4), TR3(1), TR3(2), TR3(3), TR3(4)

        INPUT #12, STH, NFaixas(ISTH), KMI, KMF, FatorVDM, FatorTraf
        N = NFaixas(ISTH)
        km = (KMI + KMF) / 2

        INPUT #14, STH, H(1), Emed(1), Temp, H(2), Emed(2), H(3), Emed(3), H(4), Emed(4), H(5), Emed(5), E1refMed, DRmed, SNmed, DataNova$, Equipamento$
        E3 = Emed(3)
        IF Emed(4) > 0 THEN E3 = Emed(4)
        IF Emed(5) > 0 THEN E3 = Emed(5)

        INPUT #11, STH, ATRe(1), ATRd(1), ATRe(2), ATRd(2), ATRe(3), ATRd(3), ATRe(4), ATRd(4), DAT$, Equipamento$, DSVe(1), DSVd(1), DSVe(2), DSVd(2), DSVe(3), DSVd(3), DSVe(4), DSVd(4)
        FOR I = 1 TO NFaixas(ISTH)
            ATR(I) = ATRe(I) + ATRd(I)
        NEXT I
        FOR I = 1 TO NFaixas(ISTH)
            ATR(I) = ATR(I) / 2
        NEXT I

        H1 = 0
        FOR IFaixa = 1 TO NFaixas(ISTH)
            INPUT #12, IFX, H1REV(IFX), HrecExist(IFX), Idade(IFX), SN(IFX), QImed(IFX), NANO(IFX), IRI0(IFX), Nacum(IFX), REVEST$(IFX), ALFAIGG(IFX)
            INPUT #12, PSIat(ISTH, IFX), Aream2(ISTH, IFX), VidaRes(IFX), VDMUni(IFX), PSInovo(IFX), Heff(IFX), IRec(IFX), ICalib(IFX), D0(IFX), MRfound(IFX)
            INPUT #12, ALPHA0(IFX), ALPHA(IFX), ALPHA2(IFX), AreaAcost(ISTH, IFX), PSIacost(IFX), DegrauAcost(IFX), T0(IFX), TR23(IFX), CBRSL(IFX), CamBase$(IFX), VDMc(IFX), ATRmed(IFX)
            H1 = H1 + H1REV(IFX)
        NEXT IFaixa
        H1 = H1 / NFaixas(ISTH)

        WRITE #15, STH, km, H1, D0(1), D0(2), Emed(1), Emed(2), E3, QImed(1), QImed(2), ATR(1), ATR(2), PSIat(ISTH, 1), PSIat(ISTH, 2), IGG(1), IGG(2), VidaRes(1), VidaRes(2)

    NEXT ISUB
    CLOSE #11, #14, #15

NEXT IRodov
INPUT #12, PSImed(0), NPSI(0), VRmed(0)
INPUT #12, AreaTotal, NUnidAnalise
CLOSE #12, #10

IF MODO < 5 THEN

    FOR ISTH = 1 TO NSTH
        FOR IFX = 1 TO NFaixasMax
            AnoRest(ISTH, IFX) = 0
        NEXT IFX
    NEXT ISTH

    FOR ANO = 1 TO NPeriodos
        ISTH = 0
        FOR IRodov = 1 TO NRODOV
            FOR ISUB = 1 TO NSTHRODOV(IRodov)

                ISTH = ISTH + 1

                INPUT #9, AnoAt, STH, Iniciokm, Finalkm, AcostLE$, HRLE, H2LE, Medida$(1), Hfrescm(1), HReccm(1), Medida$(2), Hfrescm(2), HReccm(2), Medida$(3), Hfrescm(3), HReccm(3), Medida$(4), Hfrescm(4), HReccm(4), AcostLD$, HRLD, H2LD

                FOR IFX = 1 TO NFaixas(ISTH)
                    IF AnoRest(ISTH, IFX) = 0 THEN
                        SELECT CASE Medida$(IFX)
                            CASE "RS", "FR+RC", "MF+RC", "RRV", "RRP", "RRT"
                                AnoRest(ISTH, IFX) = ANO
                            CASE "CP"
                                IF HReccm(IFX) > 1! THEN AnoRest(ISTH, IFX) = ANO
                            CASE ELSE
                        END SELECT
                    END IF
                NEXT IFX

            NEXT ISUB
        NEXT IRodov
    NEXT ANO
    CLOSE #9

    FOR ANO = 1 TO NPeriodos

        ARQUIVO$ = CALC$ + ARQ$ + STR$(ANO) + ".DAT"
        OPEN ARQUIVO$ FOR INPUT AS #7

        ISTH = 0
        FOR IRodov = 1 TO NRODOV

            ARQUIVO$ = CALC$ + "OC" + ARQ$ + Rodov$(IRodov) + ".CSV"
            OPEN ARQUIVO$ FOR INPUT AS #14
            LINE INPUT #14, LINHA$

            SELECT CASE ANO
                CASE 1: YEAR$ = "1"
                CASE 2: YEAR$ = "2"
                CASE 3: YEAR$ = "3"
                CASE 4: YEAR$ = "4"
                CASE 5: YEAR$ = "5"
                CASE 6: YEAR$ = "6"
                CASE 7: YEAR$ = "7"
                CASE 8: YEAR$ = "8"
                CASE 9: YEAR$ = "9"
                CASE 10: YEAR$ = "10"
                CASE 11: YEAR$ = "11"
                CASE 12: YEAR$ = "12"
                CASE 13: YEAR$ = "13"
                CASE 14: YEAR$ = "14"
                CASE 15: YEAR$ = "15"
                CASE 16: YEAR$ = "16"
                CASE 17: YEAR$ = "17"
                CASE 18: YEAR$ = "18"
                CASE 19: YEAR$ = "19"
                CASE 20: YEAR$ = "20"
                CASE 21: YEAR$ = "21"
                CASE 22: YEAR$ = "22"
                CASE 23: YEAR$ = "23"
                CASE 24: YEAR$ = "24"
                CASE 25: YEAR$ = "25"
                CASE 26: YEAR$ = "26"
                CASE 27: YEAR$ = "27"
                CASE 28: YEAR$ = "28"
                CASE 29: YEAR$ = "29"
                CASE 30: YEAR$ = "30"
                CASE 31: YEAR$ = "31"
                CASE 32: YEAR$ = "32"
                CASE 33: YEAR$ = "33"
                CASE 34: YEAR$ = "34"
                CASE 35: YEAR$ = "35"
                CASE 36: YEAR$ = "36"
                CASE 37: YEAR$ = "37"
                CASE 38: YEAR$ = "38"
                CASE 39: YEAR$ = "39"
                CASE 40: YEAR$ = "40"
                CASE ELSE: PRINT "ERRO"
            END SELECT
            ARQUIVO$ = CALC$ + "X" + ARQ$ + Rodov$(IRodov) + YEAR$ + ".CSV"
            OPEN ARQUIVO$ FOR OUTPUT AS #15
            WRITE #15, "STH", "km", "H1cm", "D0 Fx1", "D0 Fx2", "E1", "E2", "E3", "QI Fx1", "QI Fx2", "ATR Fx1", "ATR Fx2", "PSI Fx1", "PSI Fx2", "IDS Fx1", "IDS Fx2", "VR Fx1", "VR Fx2"

            FOR ISUB = 1 TO NSTHRODOV(IRodov)

                ISTH = ISTH + 1

                INPUT #14, STH, km, H1, D0(1), D0(2), Emed(1), Emed(2), E3, QImed(1), QImed(2), ATR(1), ATR(2), PSIat(ISTH, 1), PSIat(ISTH, 2), IGG(1), IGG(2), VidaRes(1), VidaRes(2)
                ATRat(1, 0) = ATR(1)
                ATRat(2, 0) = ATR(2)

                H1 = 0
                INPUT #7, STH, KMI, KMF
                FOR IFX = 1 TO NFaixas(ISTH)
                    INPUT #7, STH, IFX, PSIat(ISTH, IFX), Aream2(ISTH, IFX), VidaRes(IFX), Restaurado$(IFX), UltCamada$(IFX), VDMUni(IFX), PSInovo(IFX), HRef(IFX), Heff(IFX), IRec(IFX), ICalib(IFX), D0(IFX), MRfound(IFX)
                    INPUT #7, H1REV(IFX), HrecExist(IFX), Idade(IFX), SN(IFX), QImed(IFX), NANO(IFX), IRI0(IFX), Nacum(IFX), ALFAIGG(IFX), ATRmed(IFX)
                    INPUT #7, ALPHA0(IFX), ALPHA(IFX), ALPHA2(IFX), AreaAcost(ISTH, IFX), PSIacost(IFX), DegrauAcost(IFX), T0(IFX), TR23(IFX), CBRSL(IFX), CamBase$(IFX), VDMc(IFX)
                    H1 = H1 + H1REV(IFX)
                    PSIQI = 5! * EXP(-QImed(IFX) / 71.5)
                    PSR = 2 * PSIat(ISTH, IFX) - PSIQI
                    IF PSR < 0 THEN PSR = 0
                    IF PSR > 5 THEN PSR = 5
                    IGG(IFX) = (309.22 - 61.844 * PSR) / (PSR + .616)
                    IF IGG(IFX) < 0 THEN IGG(IFX) = 0
                NEXT IFX
                H1 = H1 / NFaixas(ISTH)

                MMP = .125
                FOR IFX = 1 TO NFaixas(ISTH)
                    IF Restaurado$(IFX) = "Sim" THEN RH = 1 ELSE RH = 0
                    IF IGG(IFX) < 30 THEN
                        CRX = 0
                    ELSE
                        CRX = .1621 - .2161 * IGG(IFX) + .0081 * (IGG(IFX) ^ 2) - .00003 * (IGG(IFX) ^ 3)
                        IF CRX > 100 THEN CRX = 100
                    END IF
                    ERM = .0902 + .0384 * (D0(IFX) / 100) - .009 * RH + .00158 * MMP * CRX
                    FOR Tempo = 1 TO ANO
                        IF Tempo >= AnoRest(ISTH, IFX) THEN
                            IF AnoRest(ISTH, IFX) > 0 THEN
                                Age = Tempo - AnoRest(ISTH, IFX)
                            ELSE
                                Age = Idade(IFX)
                            END IF
                        ELSE
                            Age = Idade(IFX)
                        END IF
                        IF Age > 0 THEN
                            DELTAatr = (ERM + .166) * ATRat(IFX, Tempo - 1) / Age
                            ATRat(IFX, Tempo) = ATRat(IFX, Tempo - 1) + DELTAatr
                        ELSE
                            ATRat(IFX, Tempo) = .15 * ATRat(IFX, Tempo - 1)
                        END IF
                    NEXT Tempo
                NEXT IFX

                WRITE #15, STH, km, H1, D0(1), D0(2), Emed(1), Emed(2), E3, QImed(1), QImed(2), ATRat(1, ANO), ATRat(2, ANO), PSIat(ISTH, 1), PSIat(ISTH, 2), IGG(1), IGG(2), VidaRes(1), VidaRes(2)

            NEXT ISUB
            CLOSE #14, #15

        NEXT IRodov
        INPUT #7, PSImed(0), NPSI(0), VRmed(0)
        INPUT #7, AreaTotal, NUnidAnalise
        CLOSE #7

    NEXT ANO

END IF

SYSTEM
