_TITLE "QB64"

'$DYNAMIC
DEFLNG A-Z

dim shared os as string
os$="WIN" 'use "LNX" under Linux

dim shared pathsep AS string * 1
pathsep$ = "\"
IF os$ = "LNX" THEN pathsep$ = "/"
'note: QB64 handles OS specific path separators automatically except under SHELL calls

ON ERROR GOTO qberror_test

dim shared tempfolderindex
dim shared tmpdir as string
e=0
i=1
if os$="WIN" then tmpdir$ = ".\internal\temp\"
if os$="LNX" then tmpdir$ = "./internal/temp/"
open tmpdir$+"temp.bin" for output lock read write as #26
do while e
i=i+1
if i=1000 then print "Unable to locate the 'internal' folder":end
mkdir ".\internal\temp"+str2$(i)
if os$="WIN" then tmpdir$ = ".\internal\temp"+str2$(i)+"\"
if os$="LNX" then tmpdir$ = "./internal/temp"+str2$(i)+"/"
e=0
open tmpdir$+"temp.bin" for output lock read write as #26
loop
'temp folder established
tempfolderindex=i
if i>1 then
'create modified version of qbx.cpp
open ".\internal\c\qbx"+str2$(i)+".cpp" for output as #2
open ".\internal\c\qbx.cpp" for input as #1
do until eof(1)
line input #1,a$
x=instr(a$,"..\\temp\\"): if x then a$=left$(a$,x-1)+"..\\temp"+str2$(i)+"\\"+right$(a$,len(a$)-(x+9))
x=instr(a$,"../temp/"): if x then a$=left$(a$,x-1)+"../temp"+str2$(i)+"/"+right$(a$,len(a$)-(x+7))
print #2,a$
loop
close #1,#2
end if
ON ERROR GOTO qberror

dim shared tempfolderindexstr as string 'appended to "Untitled"
if tempfolderindex<>1 then tempfolderindexstr$="("+str2$(tempfolderindex)+")"

dim shared crlf as string
crlf=chr$(13)+chr$(10)

'work in progress here to improve handling of DATA
'dim datablock(1 to 16384+64) as long '16K, every 256th index is a crlf
'dim databyte(255) as long 'followed by ","
'dim databyte2(255) as long 'followed by " "(nothing)
'for i=0 to 255
'i$=str2$(i$)
'l=len(i$)
'if l=1 then i$="  "+i$
'if l=2 then i$=" "+i$
'i2$=i$+" "
'i$=i$+","
'databyte2(i)=i2$
'databyte2(i)=i$
'next


dim shared autoarray


DIM SHARED sp2 AS STRING * 1
sp2=chr$(249)

dim shared ontimerid


dim shared revertmaymusthave(1 to 10000)
dim shared revertmaymusthaven




dim shared linecontinuation

dim shared dim2typepassback as string 'passes back correct case sensitive version of type


dim shared inclevel
dim shared incname(100) as string 'must be full path as given
dim shared inclinenumber(100) as long
dim shared incerror as string


dim shared fix046 as string
fix046$="__"+"ASCII"+"_"+"CHR"+"_"+"046"+"__" 'broken up to avoid detection for layout reversion

dim shared layout as string 'passed to IDE
dim shared layoutok as long 'tracks status of entire line

dim shared layoutcomment as string

dim shared tlayout as string 'temporary layout string set by supporting functions
dim shared layoutdone as long 'tracks status of single command


dim shared fooindwel

dim shared alphanumeric(255)
for i=48 to 57
alphanumeric(i)=-1
next
for i=65 to 90
alphanumeric(i)=-1
next
for i=97 to 122
alphanumeric(i)=-1
next
'_ is treated as an alphabet letter
alphanumeric(95)=-1

dim shared lfsinglechar(255)
lfsinglechar(40)=1 '(
lfsinglechar(41)=1 ')
lfsinglechar(42)=1 '*
lfsinglechar(43)=1 '+
lfsinglechar(45)=1 '-
lfsinglechar(47)=1 '/
lfsinglechar(60)=1 '<
lfsinglechar(61)=1 '=
lfsinglechar(62)=1 '>
lfsinglechar(92)=1 '\
lfsinglechar(94)=1 '^

lfsinglechar(44)=1 ',
lfsinglechar(46)=1 '.
lfsinglechar(58)=1 ':
lfsinglechar(59)=1 ';

lfsinglechar(35)=1 '# (file no only)
lfsinglechar(36)=1 '$ (metacommand only)
lfsinglechar(63)=1 '? (print macro)
lfsinglechar(95)=1 '_










dim shared nextrunlineindex as long

dim shared lineinput3buffer as string
dim shared lineinput3index as long

dim shared debug as long 'debug is off by default
'debug=1

dim shared dimstatic as long

dim shared staticarraylist as string
dim shared staticarraylistn as long
dim shared commonarraylist as string
dim shared commonarraylistn as long

'CONST support
dim shared constmax as long
constmax=10000
dim shared constlast as long
constlast=-1
dim shared constname(constmax) as STRING
dim shared constnamesymbol (constmax) as STRING 'optional name symbol
' `1 and `no-number must be handled correctly
dim shared constlastshared as LONG 'so any defined inside a sub/function after this index can be "forgotten" when sub/function exits
constlastshared=-1
dim shared consttype(constmax) as LONG 'variable type number
'consttype determines storage
dim shared constinteger(constmax) as _INTEGER64
dim shared constuinteger(constmax) as _UNSIGNED _INTEGER64
dim shared constfloat(constmax) as _FLOAT
dim shared conststring(constmax) as STRING

'UDT
'names
dim shared lasttype as long
dim shared udtxname(1000) as string*256
dim shared udtxcname(1000) as string*256
dim shared udtxsize(1000) as long
dim shared udtxbytealign(1000) as integer 'first element MUST be on a byte alignment & size is a multiple of 8
dim shared udtxnext(1000) as long
'elements
dim shared lasttypeelement as long
dim shared udtename(1000) as string*256
dim shared udtecname(1000) as string*256
dim shared udtebytealign(1000) as integer
dim shared udtesize(1000) as long
dim shared udtetype(1000) as long
dim shared udtetypesize(1000) as long
dim shared udtearrayelements(1000) as long
dim shared udtearraybaseelement(1000) as string*1024
dim shared udtearraytopelement(1000) as string*1024
dim shared udtenext(1000) as long

type idstruct

n AS STRING * 256 'name
cn AS STRING * 256 'case sensitive version of n

arraytype AS LONG 'similar to t
arrayelements AS INTEGER
staticarray AS INTEGER 'set for arrays declared in the main module with static elements

mayhave AS STRING * 8 'mayhave and musthave are exclusive of each other
musthave AS STRING * 8
t AS LONG 'type

tsize AS LONG


subfunc AS INTEGER 'if function=1, sub=2 (max 60 arguements!)
callname AS STRING * 256
args AS INTEGER
arg AS STRING * 400 'similar to t
argsize AS STRING * 400 'similar to tsize (used for fixed length strings)
specialformat AS STRING * 256
secondargmustbe AS STRING * 256
secondargcantbe AS STRING * 256
ret AS LONG 'the value it returns if it is a function (again like t)

insubfunc AS STRING * 256
share AS INTEGER
nele AS STRING * 100
nelereq AS STRING * 100
linkid AS LONG
linkarg AS INTEGER
staticscope as integer
	'For variables which are arguments passed to a sub/function
	sfid as long 'id number of variable's parent sub/function
	sfarg as integer 'argument/parameter # within call (1=first)

end type

dim shared id as idstruct

DIM SHARED idn AS LONG
dim shared ids_max as long
ids_max=1024
redim shared ids(1 to ids_max) as idstruct
reDIM SHARED cmemlist(1 to ids_max+1) AS INTEGER 'variables that must be in cmem
redim shared sfcmemargs(1 to ids_max+1) as string * 100 's/f arg that must be in cmem
reDIM SHARED arrayelementslist(1 to ids_max+1) AS INTEGER 'arrayelementslist (like cmemlist) helps to resolve the number of elements in arrays with an unknown number of elements. Note: arrays with an unknown number of elements have .arrayelements=-1


'create blank id template for idclear to copy (stops strings being set to chr$(0))
dim shared cleariddata as idstruct
cleariddata.cn = ""
cleariddata.n = ""
cleariddata.mayhave = ""
cleariddata.musthave = ""
cleariddata.callname = ""
cleariddata.arg = ""
cleariddata.argsize = ""
cleariddata.specialformat = ""
cleariddata.secondargmustbe = ""
cleariddata.secondargcantbe = ""
cleariddata.insubfunc = ""
cleariddata.nele = ""
cleariddata.nelereq = ""

DIM SHARED ISSTRING AS LONG
DIM SHARED ISFLOAT  AS LONG
DIM SHARED ISUNSIGNED  AS LONG
DIM SHARED ISPOINTER  AS LONG
DIM SHARED ISFIXEDLENGTH  AS LONG
DIM SHARED ISINCONVENTIONALMEMORY AS LONG
DIM SHARED ISOFFSETINBITS  AS LONG
DIM SHARED ISARRAY AS LONG
DIM SHARED ISREFERENCE AS LONG
DIM SHARED ISUDT AS LONG

DIM SHARED STRINGTYPE AS LONG
DIM SHARED BITTYPE AS LONG
DIM SHARED UBITTYPE AS LONG
DIM SHARED BYTETYPE AS LONG
DIM SHARED UBYTETYPE AS LONG
DIM SHARED INTEGERTYPE AS LONG
DIM SHARED UINTEGERTYPE AS LONG
DIM SHARED LONGTYPE AS LONG
DIM SHARED ULONGTYPE AS LONG
DIM SHARED INTEGER64TYPE AS LONG
DIM SHARED UINTEGER64TYPE AS LONG
DIM SHARED SINGLETYPE AS LONG
DIM SHARED DOUBLETYPE AS LONG
DIM SHARED FLOATTYPE AS LONG

DIM SHARED gosubid AS LONG
DIM SHARED redimoption AS INTEGER
DIM SHARED arraydesc AS INTEGER
DIM SHARED qberrorhappened AS INTEGER
DIM SHARED qberrorcode AS INTEGER
DIM SHARED qberrorline AS INTEGER
'COMMON SHARED defineaz() AS STRING
'COMMON SHARED defineextaz() AS STRING

DIM SHARED sourcefile AS STRING 'the full path and filename
DIM SHARED file AS STRING 'name of the file (without .bas or path)

'COMMON SHARED separgs() AS STRING
DIM SHARED sp AS STRING * 1
DIM SHARED constequation AS INTEGER
DIM SHARED dynamic AS INTEGER
DIM SHARED findidsecondarg AS STRING
DIM SHARED findanotherid AS INTEGER
DIM SHARED findidinternal AS LONG
DIM SHARED currentid AS LONG 'is the index of the last ID accessed
DIM SHARED linenumber AS LONG
DIM SHARED wholeline AS STRING
DIM SHARED linefragment AS STRING
'COMMON SHARED bitmask() AS _INTEGER64
'COMMON SHARED bitmaskinv() AS _INTEGER64

DIM SHARED arrayprocessinghappened AS INTEGER
DIM SHARED stringprocessinghappened AS INTEGER
DIM SHARED cleanupstringprocessingcall AS STRING
DIM SHARED recompile AS INTEGER 'forces recompilation
'COMMON SHARED cmemlist() AS INTEGER
DIM SHARED dataoffset AS LONG
DIM SHARED optionbase AS INTEGER

DIM SHARED addmetastatic AS INTEGER
DIM SHARED addmetadynamic AS INTEGER
dim shared addmetainclude as string

DIM SHARED closedmain AS INTEGER
DIM SHARED module AS STRING
DIM SHARED subfunc AS STRING
DIM SHARED subfuncn AS LONG
DIM SHARED defdatahandle AS INTEGER
DIM SHARED dimsfarray AS INTEGER
DIM SHARED dimshared AS INTEGER

'Allows passing of known elements to recompilation
DIM SHARED sflistn AS INTEGER
'COMMON SHARED sfidlist() AS LONG
'COMMON SHARED sfarglist() AS INTEGER
'COMMON SHARED sfelelist() AS INTEGER
DIM SHARED glinkid AS LONG
DIM SHARED glinkarg AS INTEGER
DIM SHARED typname2typsize AS LONG
DIM SHARED uniquenumbern AS LONG

'CLEAR , , 16384


DIM SHARED bitmask(1 TO 56) AS _INTEGER64
DIM SHARED bitmaskinv(1 TO 56) AS _INTEGER64
DIM SHARED separgs(100) AS STRING
DIM SHARED separgslayout(100) AS STRING


DIM SHARED defineextaz(1 TO 27) AS STRING
DIM SHARED defineaz(1 TO 27) AS STRING '27 is an underscore

ISSTRING = 1073741824
ISFLOAT = 536870912
ISUNSIGNED = 268435456
ISPOINTER = 134217728
ISFIXEDLENGTH = 67108864 'only set for strings with pointer flag
ISINCONVENTIONALMEMORY = 33554432
ISOFFSETINBITS = 16777216
ISARRAY = 8388608
ISREFERENCE = 4194304
ISUDT = 2097152

STRINGTYPE = ISSTRING + ISPOINTER
BITTYPE = 1& + ISPOINTER + ISOFFSETINBITS
UBITTYPE = 1& + ISPOINTER + ISUNSIGNED + ISOFFSETINBITS 'QB64 will also support BIT*n, eg. DIM bitarray[10] AS _UNSIGNED _BIT*10
BYTETYPE = 8& + ISPOINTER
UBYTETYPE = 8& + ISPOINTER + ISUNSIGNED
INTEGERTYPE = 16& + ISPOINTER
UINTEGERTYPE = 16& + ISPOINTER + ISUNSIGNED
LONGTYPE = 32& + ISPOINTER
ULONGTYPE = 32& + ISPOINTER + ISUNSIGNED
INTEGER64TYPE = 64& + ISPOINTER
UINTEGER64TYPE = 64& + ISPOINTER + ISUNSIGNED
SINGLETYPE = 32& + ISFLOAT + ISPOINTER
DOUBLETYPE = 64& + ISFLOAT + ISPOINTER
FLOATTYPE = 256& + ISFLOAT + ISPOINTER '8-32 bytes






dim shared statementn as long





DIM controllevel AS INTEGER '0=not in a controled block
DIM controltype(1000) AS INTEGER
'1=IF (awaiting END IF)
'2=FOR (awaiting NEXT)
'3=DO (awaiting LOOP [UNTIL|WHILE param])
'4=DO WHILE/UNTIL (awaiting LOOP)
'5=WHILE (awaiting WEND)
'10=SELECT CASE qbs (awaiting END SELECT/CASE)
'11=SELECT CASE int64 (awaiting END SELECT/CASE)
'12=SELECT CASE uint64 (awaiting END SELECT/CASE)
'13=SELECT CASE long double (awaiting END SELECT/CASE/CASE ELSE)
'18=CASE (awaiting END SELECT/CASE/CASE ELSE)
'19=CASE ELSE (awaiting END SELECT)
DIM controlid(1000) AS LONG
DIM controlvalue(1000) AS LONG
DIM controlstate(1000) AS INTEGER

DIM separgs2(100) AS STRING
DIM separgslayout2(100) AS STRING

sp = CHR$(250)



ON ERROR GOTO qberror

i2&& = 1
FOR i&& = 1 TO 56
bitmask(i&&) = i2&&
bitmaskinv(i&&) = NOT i2&&
i2&& = i2&& + 2 ^ i&&
NEXT

DIM id2 AS idstruct

cleanupstringprocessingcall$ = "qbs_cleanup(qbs_tmp_base,"

DIM SHARED sfidlist(1000) AS LONG
DIM SHARED sfarglist(1000) AS INTEGER
DIM SHARED sfelelist(1000) AS INTEGER

dim shared command2$

command2$=command$
a$=ltrim$(rtrim$(command2$))
a2$=lcase$(left$(a$,2))
if a2$="-c" then command2$=ltrim$(right$(a$,len(a$)-2)): goto noide
'assume command2$ contains the name of a file to load/compile

'compiler-side IDE data & definitions
dim shared idecurrentlinelayout as string
dim shared idecurrentlinelayouti as long
dim shared idelayoutallow as long


dim shared idecommand as string
dim shared idereturn as string
dim shared ideerror as long
dim shared idecompiled as long
dim shared idemode
dim shared ideerrorline as long 'set by qb64error(...) to the line number it would have reported, this number
'is later passed to the ide in message #8
dim shared idemessage as string 'set by qb64error(...) to the error message to be reported, this
'is later passed to the ide in message #8

'the function ?=ide(?) should always be passed 0, it returns a message code number, any further information
'is passed back in idereturn

'message code numbers:
'0	no ide present  (auto defined array ide() return 0)

'1	launch ide & with passed filename (compiler->ide)

'2	begin new compilation with returned line of code (compiler<-ide)
'	[2][line of code]

'3	request next line (compiler->ide)
'	[3]

'4	next line of code returned (compiler<-ide)
'	[4][line of code]

'5	no more lines of code exist (compiler<-ide)
'	[5]

'6	code is OK/ready (compiler->ide)
'	[6]

'7	repass the code from the beginning (compiler->ide)
'	[7]

'8	an error has occurred with 'this' message on 'this' line(compiler->ide)
'	[8][error message][line as long]

'9	C++ compile (if necessary) and run with 'this' name (compiler<-ide)
'	[9][name(no path, no .bas)]

'10	The line requires more time to process
'       Pass-back 'line of code' using method [4] when ready
'	[10][line of code]

'11	".EXE file created" message

'12     The name of the exe I'll create is '...' (compiler->ide)
'	[12][exe name without .exe]

'255    A qb error happened in the IDE (compiler->ide)
'	note: detected by the fact that ideerror was not set to 0
'	[255]

'IDE MODULE: shared data & definitions
DIM SHARED mousex AS INTEGER
DIM SHARED mousey AS INTEGER
DIM SHARED mousewheel AS INTEGER
DIM SHARED mousebutton1 AS INTEGER
DIM SHARED mousebutton2 AS INTEGER
DIM SHARED mousevisible AS INTEGER
DIM SHARED mousepassed AS INTEGER
'---------------------------------------------------
DIM SHARED idet AS STRING, idel, ideli, iden
DIM SHARED idelaunched, idecompiling
dim shared idecompiledline 'stores the number of the last line sent to the compiler, used only to know which line to send next
dim shared idecompiledline$ 'stores the last line sent to the compiler
DIM SHARED idesx, idesy, idecx, idecy
DIM SHARED ideselect, ideselectx1, ideselecty1, idemouseselect
DIM SHARED ideunsaved
DIM SHARED ideroot AS STRING
DIM SHARED idetxt(1000) AS STRING
DIM SHARED idetxtlast AS INTEGER
DIM SHARED idehl
DIM SHARED idealtcode(255) AS INTEGER
DIM SHARED ideprogname AS STRING
DIM SHARED idepath AS STRING
DIM SHARED idefindtext AS STRING
DIM SHARED idefindcasesens AS INTEGER
DIM SHARED idefindwholeword AS INTEGER
DIM SHARED idechangeto AS STRING
DIM SHARED idechangemade AS INTEGER
DIM SHARED ideautosave AS INTEGER
DIM SHARED ideinsert AS INTEGER
DIM SHARED idepathsep AS STRING * 1
'--------------------------------------------------------------------------------
TYPE idedbptype
x AS LONG
y AS LONG
w AS LONG
h AS LONG
nam AS LONG
END TYPE
'--------------------------------------------------------------------------------
TYPE idedbotype
par AS idedbptype
x AS LONG
y AS LONG
w AS LONG
h AS LONG
typ AS LONG
nam AS LONG
txt AS LONG
def AS LONG
cx AS LONG
cy AS LONG
foc AS LONG
sel AS LONG 'selected item no.
stx AS LONG 'selected item in string form
v1 AS LONG
num AS LONG
END TYPE
'--------------------------------------------------------------------------------
dim shared idefocusline 'simply stores the location of the line to highlight in red
dim shared ideautorun
DIM shared menu$(1 TO 10, 0 TO 20)
DIM shared menusize(1 TO 10)
DIM shared menus as integer
DIM shared menubar$
dim shared idealthighlight,ideentermenu
dim shared ideautolayout,ideautoindent,ideautoindentsize
dim shared idewx,idewy,idecustomfont,idecustomfontfile$,idecustomfontheight,idecustomfonthandle
dim shared iderunmode
'IDE MODULE SECTION END: shared data & definitions

idemode=1
sendc$ = "" 'no initial message
if command2$<>"" then sendc$=chr$(1)+command2$
sendcommand:
idecommand$=sendc$
c=ide(0)
ideerror=0
if c=0 then idemode=0: goto noide
c$=idereturn$

IF c = 2 THEN 'begin
ideerrorline=0 'addresses invalid prepass error line numbers being reported
idepass=1
goto fullrecompile
ideret1:
wholeline$=c$
goto ideprepass
ideret2:
sendc$ = CHR$(3) 'request next line
goto sendcommand
END IF

IF c = 4 THEN 'next line
if idepass=1 then
wholeline$=c$
goto ideprepass
'(returns to ideret2: above)
end if
'assume idepass>1
a3$=c$
continuelinefrom = 0
goto ide4
ideret4:
sendc$ = CHR$(3) 'request next line
goto sendcommand
END IF

IF c = 5 THEN 'end of program reached
if idepass=1 then
'prepass complete
idepass=2
goto ide3
ideret3:
sendc$ = CHR$(7) 'repass request
goto sendcommand
end if
'assume idepass=2
'finalize program
goto ide5
ideret5: 'note: won't return here if a recompile was required!
sendc$ = CHR$(6) 'ready
idecompiled=0
goto sendcommand
END IF

if c=9 then 'run

if idecompiled=0 then 'exe needs to be compiled
file$=c$

f$=file$
i=1
nextexeindex:
e=0
ON ERROR GOTO qberror_test
OPEN file$ + ".exe" FOR OUTPUT AS #1 'locate accessible file and truncate
ON ERROR GOTO qberror
if e=1 then 
i=i+1
file$=f$+"("+str2$(i)+")"
goto nextexeindex
else
CLOSE #1
end if

'inform IDE of name change if necessary (IDE will respond with message 9 and corrected name)
if i<>1 then
sendc$ = CHR$(12)+file$
goto sendcommand
end if


ideerrorline=0 'addresses C++ comp. error's line number
goto ide6
ideret6:
idecompiled=1
end if

if iderunmode=2 then
sendc$ = CHR$(11) '.EXE file created
goto sendcommand
end if

'hack! (a new message should be sent to the IDE stating C++ compilation was successful)
COLOR 7, 1: LOCATE idewy-3, 2: PRINT SPACE$(idewx-2);: LOCATE idewy-2, 2: PRINT SPACE$(idewx-2);: LOCATE idewy-1, 2: PRINT SPACE$(idewx-2); 'clear status window

LOCATE idewy-3, 2:PRINT "Starting program...";
PCOPY 3, 0

'execute program

if iderunmode=1 then
if os$="WIN" then shell _DONTWAIT idezfilename$(chr$(34)+file$+".exe"+chr$(34))
if os$="LNX" then shell _DONTWAIT idezfilename$("./"+file$+".exe")
else
if os$="WIN" then shell idezfilename$(chr$(34)+file$+".exe"+chr$(34))
if os$="LNX" then shell idezfilename$("./"+file$+".exe")
end if

sendc$ = CHR$(6) 'ready
goto sendcommand
end if

PRINT "Invalid IDE message": end

ideerror:
sendc$ = CHR$(8) + idemessage$+mkl$(ideerrorline)
goto sendcommand


noide:
PRINT "QB64 COMPILER V0.872"

IF COMMAND2$ = "" THEN
LINE INPUT ; "COMPILE (.bas)>", f$
ELSE
f$ = COMMAND2$
END IF

f$=ltrim$(rtrim$(f$))
IF LEN(f$) > 4 THEN
IF UCASE$(RIGHT$(f$, 4)) <> ".BAS" THEN f$ = f$+".bas"
else
f$ = f$+".bas"
END IF
sourcefile$=f$
'derive name from sourcefile
f$=left$(f$,len(f$)-4) 'remove .bas
for x=len(f$) to 1 step -1
a$=mid$(f$,x,1)
if a$="/" or a$="\" then
f$=right$(f$,len(f$)-x)
exit for
end if
next
file$=f$

'if cmemlist(currentid+1)<>0 before calling regid the variable
'MUST be defined in cmem!

fullrecompile:
close
open tmpdir$+"temp.bin" for output lock read write as #26 'relock

if debug then OPEN tmpdir$ + "debug.txt" FOR OUTPUT AS #9


for i=1 to ids_max+1
arrayelementslist(i)=0
cmemlist(i)=0
sfcmemargs(i)=""
next


'erase cmemlist
'erase sfcmemargs

lastunresolved=-1 'first pass
sflistn=-1 'no entries

recompile:

'clear/init variables
dynscope=0
elsefollowup=0
ontimerid=0
commonarraylist="": commonarraylistn=0
staticarraylist="": staticarraylistn=0
fooindwel=0
layout=""
layoutok=0
nochecks=0
inclevel=0
addmetainclude$=""
nextrunlineindex=1
lasttype=0
lasttypeelement=0
definingtype=0
constlast=-1
constlastshared=-1
defdatahandle = 18
closedmain = 0
addmetastatic = 0
addmetadynamic = 0
dynamic=0
optionbase = 0
dataoffset = 0
statementn = 0
qberrorhappened = 0: qberrorcode = 0: qberrorline = 0
FOR i = 1 TO 27: defineaz(i) = "SINGLE": defineextaz(i) = "!": NEXT
controllevel = 0
findidsecondarg$ = "": findanotherid = 0: findidinternal = 0: currentid = 0
linenumber = 0
wholeline$ = ""
linefragment$ = ""
idn = 0
arrayprocessinghappened = 0
stringprocessinghappened = 0
subfuncn=0
subfunc=""


'begin compilation
CLOSE 'close any open files
open tmpdir$+"temp.bin" for output lock read write as #26 'relock

if debug then OPEN tmpdir$ + "debug.txt" FOR APPEND AS #9

if idemode=0 then
qberrorhappened = -1
OPEN sourcefile$ FOR INPUT AS #1
qberrorhappened1:
IF qberrorhappened = 1 THEN
PRINT
PRINT "CANNOT LOCATE SOURCE FILE:" + sourcefile$
END
ELSE
CLOSE #1
END IF
qberrorhappened = 0
end if

reginternal

OPEN tmpdir$ + "userdata.txt" FOR OUTPUT AS #16
OPEN tmpdir$ + "global.txt" FOR OUTPUT AS #18

if iderecompile then
iderecompile=0
idepass=1 'prepass must be done again
sendc$ = CHR$(7) 'repass request
goto sendcommand
end if

if idemode then goto ideret1

lineinput3load sourcefile$

DO
wholeline$=lineinput3$
if wholeline$=chr$(13) then exit do
ideprepass:

layout=""
layoutok=0

linenumber = linenumber + 1
if len(wholeline$) then

wholeline$ = lineformat(wholeline$)

cwholeline$=wholeline$
wholeline$ = eleucase$(wholeline$) '********REMOVE THIS LINE LATER********


addmetadynamic = 0: addmetastatic = 0
wholelinen = numelements(wholeline$)

if wholelinen then

wholelinei = 1

'skip line number?
e$ = getelement$(wholeline$, 1)
if (asc(e$)>=48 and asc(e$)<=59) or asc(e$)=46 then wholelinei=2: goto ppskpl

'skip 'POSSIBLE' line label?
IF wholelinen >= 2 THEN
x2=instr(wholeline$,sp+":"+sp):x3=x2+2
if x2=0 then
if right$(wholeline$,2)=sp+":" then x2=len(wholeline$)-1:x3=x2+1
end if

if x2 then
e$=left$(wholeline$,x2-1)
if validlabel(e$) then
	wholeline$ = right$(wholeline$, len(wholeline$)-x3)
	cwholeline$ = right$(cwholeline$, len(wholeline$)-x3)
	wholelinen = numelements(wholeline$)
	goto ppskpl
end if 'valid
end if 'includes ":"
end if 'wholelinen>=2

ppskpl:
if wholelinei<=wholelinen then
'----------------------------------------
a$=""
ca$=""
ppblda:
e$=getelement$(wholeline$, wholelinei)
ce$=getelement$(cwholeline$, wholelinei)
if e$=":" or e$="ELSE" or e$="THEN" or e$="" then
if len(a$) then
if debug then print #9, "PP["+a$+"]"
n=numelements(a$)
firstelement$ = getelement(a$, 1)
secondelement$ = getelement(a$, 2)
thirdelement$ = getelement(a$, 3)
'========================================



'UDT TYPE definition
if n>=1 then
if firstelement$="TYPE" then
if n<>2 then a$="Expected TYPE typename":goto errmes
lasttype=lasttype+1
definingtype=lasttype
i=definingtype
udtxname(i)=secondelement$
udtxcname(i)=getelement(ca$,2)
udtxnext(i)=0
udtxsize(i)=0
'print "TYPE "+rtrim$(udtxname(i))
GOTO finishedlinepp
end if
end if

if definingtype then
i=definingtype

if n>=1 then
if firstelement$="END" then
if n<>2 or secondelement$<>"TYPE" then a$="Expected END TYPE":goto errmes
if udtxnext(i)=0 then a$="No elements defined in TYPE":goto errmes
definingtype=0

'create global buffer for SWAP space
siz$=str2$(udtxsize(i)\8)
print #18,"char *g_tmp_udt_"+rtrim$(udtxname(i))+"=(char*)malloc("+siz$+");"

'print "END TYPE";udtxsize(i);udtxbytealign(i)
GOTO finishedlinepp
end if
end if

lasttypeelement=lasttypeelement+1
i2=lasttypeelement
udtenext(i2)=0

if n<3 then a$="Expected variablename AS type or END TYPE":goto errmes
n$=firstelement$
ii=2

udtearrayelements(i2)=0
if secondelement$="(" then
'...
end if

if ii>=n or getelement$(a$,ii)<>"AS" then a$="Expected variablename AS type or END TYPE":goto errmes
t$=getelements$(a$,ii+1,n)

typ=typname2typ(t$)
if typ=0 then a$="Undefined type":goto errmes
typsize=typname2typsize

udtename(i2)=n$
udtecname(i2)=getelement$(ca$,1)
udtetype(i2)=typ
udtetypesize(i2)=typsize

'Calculate element's size
if typ and ISUDT then
 u=typ and 511
 udtesize(i2)=udtxsize(u)
 if udtxbytealign(u) then udtxbytealign(i)=1:udtebytealign(i2)=1
else
 if (typ AND ISSTRING) then
  if (typ AND ISFIXEDLENGTH)=0 then a$="Expected STRING *":goto errmes
  udtesize(i2)=typsize*8
  udtxbytealign(i)=1:udtebytealign(i2)=1
 else
  udtesize(i2)=typ and 511
  if (typ AND ISOFFSETINBITS)=0 then udtxbytealign(i)=1:udtebytealign(i2)=1
 end if
end if

'Increase block size
if udtebytealign(i2) then
if udtxsize(i) mod 8 then
udtxsize(i) =udtxsize(i) + (8-(udtxsize(i) mod 8))
end if
end if
udtxsize(i)=udtxsize(i)+udtesize(i2)

'Link element to previous element
if udtxnext(i)=0 then
udtxnext(i)=i2
else
udtenext(i2-1)=i2
end if

'print "+"+rtrim$(udtename(i2));udtesize(i2);udtebytealign(i2);udtxsize(i)

GOTO finishedlinepp

end if 'definingtype


'DEFINE
d=0
IF firstelement$ = "DEFINT" THEN d = 1
IF firstelement$ = "DEFLNG" THEN d = 1
IF firstelement$ = "DEFSNG" THEN d = 1
IF firstelement$ = "DEFDBL" THEN d = 1
IF firstelement$ = "DEFSTR" THEN d = 1
IF firstelement$ = "_DEFINE" THEN d = 1
IF d THEN
predefining = 1: GOTO predefine
predefined: predefining = 0
GOTO finishedlinepp
END IF


'SUB/FUNCTION
firstelement$ = getelement$(a$, 1)
sf = 0
IF firstelement$ = "FUNCTION" THEN sf = 1
IF firstelement$ = "SUB" THEN sf = 2
IF sf THEN
IF n = 1 THEN a$="Expected name after SUB/FUNCTION":goto errmes

'convert periods to _046_
i2=instr(a$,sp+"."+sp)
if i2 then
do
a$=left$(a$,i2-1)+fix046$+right$(a$,len(a$)-i2-2)
ca$=left$(ca$,i2-1)+fix046$+right$(ca$,len(ca$)-i2-2)
i2=instr(a$,sp+"."+sp)
loop until i2=0
n=numelements(a$)
firstelement$ = getelement(a$, 1): secondelement$ = getelement(a$, 2): thirdelement$ = getelement(a$, 3)
end if

n$ = getelement$(ca$, 2)
symbol$ = removesymbol$(n$)
IF sf = 2 AND symbol$ <> "" THEN a$="Type symbols after a SUB name are invalid":goto errmes

'remove STATIC (which is ignored)
e$ = getelement$(a$, n): if e$="STATIC" then a$=left$(a$,len(a$)-7): ca$=left$(ca$,len(ca$)-7): n=n-1

params = 0
params$ = ""
paramsize$ = ""
nele$ = ""
nelereq$ = ""
IF n > 2 THEN
e$ = getelement$(a$, 3)
IF e$ <> "(" THEN a$="Expected (":goto errmes
e$ = getelement$(a$, n)
IF e$ <> ")" THEN a$="Expected )":goto errmes
IF n < 4 THEN a$="Expected ( ... )":goto errmes
if n=4 then goto nosfparams
b = 0
a2$ = ""
FOR i = 4 TO n - 1
e$ = getelement$(a$, i)
IF e$ = "(" THEN b = b + 1
IF e$ = ")" THEN b = b - 1
IF e$ = "," AND b = 0 THEN
IF i = n - 1 THEN a$="Expected , ... )":goto errmes
getlastparam:
IF a2$ = "" THEN a$="Expected ... ,":goto errmes
a2$ = LEFT$(a2$, LEN(a2$) - 1)
'possible format: [BYVAL]a[%][(1)][AS][type]
n2 = numelements(a2$)
array = 0
t2$ = ""
e$ = getelement$(a2$, 1)
n2$ = e$
symbol2$ = removesymbol$(n2$)
m = 0
FOR i2 = 2 TO n2
e$ = getelement$(a2$, i2)
IF e$ = "(" THEN
IF m <> 0 THEN a$="Syntax error":goto errmes
m = 1
array = 1
GOTO gotaa
END IF
IF e$ = ")" THEN
IF m <> 1 THEN a$="Syntax error":goto errmes
m = 2
GOTO gotaa
END IF
IF e$ = "AS" THEN
IF m <> 0 AND m <> 2 THEN a$="Syntax error":goto errmes
m = 3
GOTO gotaa
END IF
IF m = 1 THEN GOTO gotaa 'ignore contents of bracket
IF m <> 3 THEN a$="Syntax error":goto errmes
IF t2$ = "" THEN t2$ = e$ ELSE t2$ = t2$ + " " + e$
gotaa:
NEXT i2

params = params + 1
argnelereq = 0

IF symbol2$ <> "" AND t2$ <> "" THEN a$="Syntax error":goto errmes
IF t2$ = "" THEN t2$ = symbol2$
IF t2$ = "" THEN
IF LEFT$(n2$, 1) = "_" THEN v = 27 ELSE v = ASC(ucase$(n2$)) - 64
t2$ = defineaz(v)
END IF

paramsize = 0
IF array = 1 THEN
t = typname2typ(t2$)
IF t = 0 THEN a$="Illegal SUB/FUNCTION parameter":goto errmes
IF (t AND ISFIXEDLENGTH) THEN paramsize = typname2typsize
t = t + ISARRAY
 'check for recompilation override
 FOR i10 = 0 TO sflistn
 IF sfidlist(i10) = idn + 1 THEN
 IF sfarglist(i10) = params THEN
 argnelereq = sfelelist(i10)
 END IF
 END IF
 NEXT
ELSE
t = typname2typ(t2$)
IF t = 0 THEN a$="Illegal SUB/FUNCTION parameter":goto errmes
IF (t AND ISFIXEDLENGTH) THEN paramsize = typname2typsize
END IF
nelereq$ = nelereq$ + CHR$(argnelereq)

'consider changing 0 in following line too!
nele$ = nele$ + CHR$(0)

paramsize$ = paramsize$ + MKL$(paramsize)
params$ = params$ + MKL$(t)
a2$ = ""
ELSE
a2$ = a2$ + e$ + sp
IF i = n - 1 THEN GOTO getlastparam
END IF
NEXT i
END IF 'n>2
nosfparams:

IF sf = 1 THEN
'function
clearid
id.n = n$
id.subfunc = 1
id.callname = "FUNC_" + ucase$(n$)
id.args = params
id.arg = params$
id.argsize = paramsize$
id.nele = nele$
id.nelereq = nelereq$
IF symbol$ <> "" THEN
id.ret = typname2typ(symbol$)
ELSE
IF LEFT$(n$, 1) = "_" THEN v = 27 ELSE v = ASC(ucase$(n$)) - 64
symbol$ = defineaz(v)
id.ret = typname2typ(symbol$)
END IF
IF id.ret = 0 THEN a$="Invalid FUNCTION return type":goto errmes
s$ = LEFT$(symbol$, 1)
IF s$ <> "~" AND s$ <> "`" AND s$ <> "%" AND s$ <> "&" AND s$ <> "!" AND s$ <> "#" AND s$ <> "$" THEN
symbol$ = type2symbol$(symbol$)
END IF
id.mayhave = symbol$
IF id.ret AND ISPOINTER THEN
IF (id.ret AND ISSTRING) = 0 THEN id.ret = id.ret - ISPOINTER
END IF
regid
ELSE
'sub
clearid
id.n = n$
id.subfunc = 2
id.callname = "SUB_" + ucase$(n$)
id.args = params
id.arg = params$
id.argsize = paramsize$
id.nele = nele$
id.nelereq = nelereq$
regid
END IF
END IF

'========================================
finishedlinepp:
end if
a$=""
ca$=""
else
if a$="" then a$=e$:ca$=ce$ else a$=a$+sp+e$:ca$=ca$+sp+ce$
end if
if wholelinei<=wholelinen then wholelinei=wholelinei+1: goto ppblda
'----------------------------------------
end if 'wholelinei<=wholelinen
end if 'wholelinen
end if 'len(wholeline$)



'Include Manager #1
if len(addmetainclude$) then
a$=addmetainclude$: addmetainclude$="" 'read/clear message
if inclevel=100 then qb64error "Too many indwelling INCLUDE files"
'1. Verify file exists (location is either (a)relative to source file or (b)absolute)
fh=99+inclevel+1
for try=1 to 2
if try=1 then
if inclevel=0 then
if idemode then p$=idepath$ + pathsep$ else p$=getfilepath$(sourcefile$)
else
p$=getfilepath$(incname(inclevel))
end if
f$=p$+a$
end if
if try=2 then f$=a$
qberrorhappened = -3
open f$ for input as #fh
qberrorhappened3:
IF qberrorhappened=-3 THEN exit for
qberrorhappened=0
next
if qberrorhappened<>-3 then qberrorhappened=0: qb64error "File "+a$+" not found"
inclevel=inclevel+1: incname$(inclevel)=f$: inclinenumber(inclevel)=0
end if 'fall through to next section...
'--------------------
if inclevel then
fh=99+inclevel
'2. Feed next line
if eof(fh)=0 then
line input #fh,x$
wholeline$=x$
inclinenumber(inclevel)=inclinenumber(inclevel)+1
	'create extended error string 'incerror$'
	e$=" in line "+str2(inclinenumber(inclevel))+" of "+incname$(inclevel)+" included"
        if inclevel>1 then
	e$=e$+" (through "
	for x=1 to inclevel-1 step 1
	e$=e$+incname$(x)
	if x<inclevel-1 then 'a sep is req
	if x=inclevel-2 then
	e$=e$+" then "
	else
	e$=e$+", "
	end if
	end if
	next
	e$=e$+")"
	end if
	incerror$=e$
linenumber = linenumber - 1 'lower official linenumber to counter later increment
if idemode then sendc$ = CHR$(10)+ wholeline$: goto sendcommand 'passback
goto ideprepass
end if
'3. Close & return control
close #fh
inclevel=inclevel-1
'fall through to next section...
end if 
'(end manager)



if idemode then goto ideret2
loop
'prepass finished

lineinput3index=1 'reset input line

'ide specific
ide3:

addmetainclude$="" 'reset stray meta-includes

close #16

'reset altered variables
dataoffset = 0
inclevel=0

FOR i = 1 TO 27: defineaz(i) = "SINGLE": defineextaz(i) = "!": NEXT

OPEN tmpdir$ + "main.txt" FOR OUTPUT AS #12
OPEN tmpdir$ + "maindata.txt" FOR OUTPUT AS #13
OPEN tmpdir$ + "userdata.txt" FOR OUTPUT AS #16
OPEN tmpdir$ + "regsf.txt" FOR OUTPUT AS #17
OPEN tmpdir$ + "mainfree.txt" FOR OUTPUT AS #19
OPEN tmpdir$ + "runline.txt" FOR OUTPUT AS #21

OPEN tmpdir$ + "mainerr.txt" FOR OUTPUT AS #14 'main error handler
'i. check the value of error_line
'ii. jump to the appropriate label
errorlabels = 0
PRINT #14, "if (error_occurred){ error_occurred=0;"

OPEN tmpdir$ + "chain.txt" FOR OUTPUT AS #22: CLOSE #22 'will be appended to as necessary
OPEN tmpdir$ + "inpchain.txt" FOR OUTPUT AS #23: CLOSE #23 'will be appended to as necessary
'*** #22 & #23 are reserved for usage by chain & inpchain ***

OPEN tmpdir$ + "ontimer.txt" FOR OUTPUT AS #24
OPEN tmpdir$ + "ontimerj.txt" FOR OUTPUT AS #25
'*****#26 used for locking qb64

gosubid = 1
'to be included whenever return without a label is called

'return [label] in QBASIC was not possible in a sub/function, but QB64 will support this
'special codes will represent special return conditions:
'0=return from main to calling sub/function/proc by return NULL;
'1... a global number representing a return point after a gosub
'note: RETURN [label] should fail if a "return NULL;" type return is required
OPEN tmpdir$ + "ret0.txt" FOR OUTPUT AS #15
PRINT #15, "if (next_return_point){"
PRINT #15, "next_return_point--;"
PRINT #15, "switch(return_point[next_return_point]){"
PRINT #15, "case 0:"
PRINT #15, "return NULL;"
PRINT #15, "break;"

continueline = 0
endifs = 0
lineelseused = 0
continuelinefrom = 0
linenumber = 0

PRINT #12, "S_0:;" 'note: REQUIRED by run statement

'ide specific
if idemode then goto ideret3

DO
ide4:
includeline:

stringprocessinghappened = 0

IF continuelinefrom THEN
start = continuelinefrom
continuelinefrom = 0
GOTO contline
end if

'begin a new line

impliedendif=0
THENGOTO = 0
continueline = 0
endifs = 0
lineelseused = 0
newif = 0

'apply metacommands from previous line
IF addmetadynamic = 1 THEN addmetadynamic = 0: dynamic = 1
IF addmetastatic = 1 THEN addmetastatic = 0: dynamic = 0

'a3$ is passed in idemode and when using $include
if idemode=0 and inclevel=0 then a3$=lineinput3$
if a3$=chr$(13) then exit do
linenumber = linenumber + 1

layout=""
layoutok=1

if idemode=0 then
IF len(a3$) THEN
dotlinecount = dotlinecount + 1: IF dotlinecount >= 100 THEN dotlinecount=0: print ".";
END IF
END IF

a3$ = LTRIM$(RTRIM$(a3$))
wholeline = a3$

layoutoriginal$=a3$
layoutcomment$="" 'clear any previous layout comment
lhscontrollevel=controllevel

linefragment = "[INFORMATION UNAVAILABLE]"
IF LEN(a3$) = 0 THEN GOTO finishednonexec
if debug then print #9, "########" + a3$ + "########"

layoutdone=1 'validates layout of any following goto finishednonexec/finishedline

'QB64 Metacommands
if asc(a3$)=36 then  '$

a3u$=ucase$(a3$)

if a3u$="$CHECKING:OFF" then
layout$="$CHECKING:OFF"
nochecks=1
goto finishednonexec
end if

if a3u$="$CHECKING:ON" then
layout$="$CHECKING:ON"
nochecks=0
goto finishednonexec
end if

end if 'QB64 Metacommands

linedataoffset=dataoffset

entireline$ = lineformat(a3$): if len(entireline$)=0 then GOTO finishednonexec
u$=ucase$(entireline$)

newif = 0

'Convert "CASE ELSE" to "CASE C-EL" to avoid confusing compiler
'note: CASE does not have to begin on a new line
s=1
i = INSTR(s,u$,"CASE" + sp + "ELSE")
do while i
skip=0
if i<>1 then
if mid$(u$,i-1,1)<>sp then skip=1
end if
if i<>len(u$)-8 then
if mid$(u$,i+9,1)<>sp then skip=1
end if
if skip=0 then
MID$(entireline$, i) = "CASE" + sp + "C-EL"
u$=ucase$(entireline$)
end if
s=i+9
i = INSTR(s,u$,"CASE" + sp + "ELSE")
loop

n = numelements(entireline$)

'line number?
a=asc(entireline$)
if (a>=48 and a<=57) or a=46 then 'numeric
label$ = getelement(entireline$, 1)
if validlabel(label$) then
layout$=tlayout$
PRINT #12, "LABEL_" + LABEL$ + ":;"
PRINT #18, "unsigned long data_at_LABEL_" + LABEL$ + "=" + str2(linedataoffset) + ";"
if instr(label$,"p") then mid$(label$,instr(label$,"p"),1)="."
PRINT #12, "last_line=" + label$ + ";"
IF n = 1 THEN GOTO finishednonexec
entireline$ = getelements(entireline$, 2, n): u$=ucase$(entireline$): n = n - 1
'note: fall through, numeric labels can be followed by alphanumeric label
END IF 'validlabel
end if 'numeric
'it wasn't a line number

'label?
'note: ignores possibility that this could be a single command SUB/FUNCTION (as in QBASIC?)
IF n >= 2 THEN
x2=instr(entireline$,sp+":")
if x2 then
if x2=len(entireline$)-1 then x3=x2+1 else x3=x2+2
a$=left$(entireline$,x2-1)
if validlabel(a$) then
	if len(layout$) then layout$=layout$+sp+tlayout$+":" else layout$=tlayout$+":"
	PRINT #12, "LABEL_" + a$ + ":;"
	PRINT #18, "unsigned long data_at_LABEL_" + a$ + "=" + str2(linedataoffset) + ";"
	entireline$ = right$(entireline$, len(entireline$)-x3): u$=ucase$(entireline$)
	n=numelements(entireline$): IF n = 0 THEN GOTO finishednonexec
end if 'valid
end if 'includes sp+":"
end if 'n>=2

'remove leading ":"
do while asc(u$)=58 '":"
if len(layout$) then layout$=layout$+sp2+":" else layout$=":"
if len(u$)=1 then GOTO finishednonexec
entireline$ = getelements(entireline$, 2, n): u$=ucase$(entireline$): n=n-1
loop

'ELSE at the beginning of a line
if asc(u$)=69 then '"E"

e1$=getelement(u$, 1)

IF e1$ = "ELSE" THEN
a$ = "ELSE"
if n>1 then continuelinefrom = 2
GOTO gotcommand
END IF

IF e1$ = "ELSEIF" THEN
if n<3 then a$="Expected ... THEN": goto errmes
IF getelement(u$, n) = "THEN" THEN a$=entireline$:goto gotcommand
FOR i = 3 TO n-1
IF getelement(u$, i) = "THEN" THEN
a$=getelements(entireline$,1,i)
continuelinefrom = i+1
goto gotcommand
END IF
NEXT
a$="Expected THEN":goto errmes
END IF

END IF '"E"

start = 1

goto skipcontinit

contline:

n = numelements(entireline$)
u$=ucase$(entireline$)

skipcontinit:

'jargon:
'lineelseused - counts how many line ELSEs can POSSIBLY follow
'endifs - how many C++ endifs "}" need to be added at the end of the line
'lineelseused - counts the number of indwelling ELSE statements on a line
'impliedendif - stops autoformat from adding "END IF"

a$ = ""

FOR i = start TO n
e$ = getelement(u$, i)


IF e$ = ":" THEN
if i=start then 
layoutdone=1: if len(layout$) then layout$=layout$+sp2+":" else layout$=":"
IF i <> n THEN continuelinefrom = i+1
goto finishednonexec
end if
IF i <> n THEN continuelinefrom = i
GOTO gotcommand
END IF


'begin scanning an 'IF' statement
IF e$ = "IF" AND a$ = "" THEN newif = 1


IF e$ = "THEN" OR (e$ = "GOTO" AND newif = 1) THEN
newif = 0
IF lineelseused > 0 THEN lineelseused = lineelseused - 1
IF e$ = "GOTO" THEN
IF i = n THEN a$="Expected IF expression GOTO label":goto errmes
i = i - 1
END IF
a$ = a$ + sp + e$ '+"THEN"/"GOTO"
IF i <> n THEN continuelinefrom = i + 1: endifs = endifs + 1
GOTO gotcommand
END IF


IF e$ = "ELSE" THEN

IF start=i THEN
 IF lineelseused >= 1 THEN
 'note: more than one else used (in a row) on this line, so close first if with an 'END IF' first
 'note: parses 'END IF' then (after continuelinefrom) parses 'ELSE'
 'consider the following: (square brackets make reading easier)
 'eg. if a=1 then [if b=2 then c=2 else d=2] else e=3
 impliedendif=1: a$ = "END" + sp + "IF"
 endifs = endifs - 1
 continuelinefrom = i
 lineelseused = lineelseused - 1
 GOTO gotcommand
 END IF
'follow up previously encountered 'ELSE' by applying 'ELSE'
a$ = "ELSE": continuelinefrom = i + 1
lineelseused = lineelseused + 1
GOTO gotcommand
end if 'start=i

'apply everything up to (but not including) 'ELSE'
continuelinefrom = i
GOTO gotcommand
END IF '"ELSE"


e$=getelement(entireline$, i): IF a$ = "" THEN a$ = e$ ELSE a$ = a$ + sp + e$
NEXT


'we're reached the end of the line
IF endifs > 0 THEN
endifs = endifs - 1
impliedendif=1: entireline$ = entireline$ + sp + ":" + sp + "END" + sp + "IF": n=n+3
i=i+1 'skip the ":" (i is now equal to n+2)
continuelinefrom = i
GOTO gotcommand
END IF


gotcommand:

dynscope=0

ca$=a$
a$=eleucase$(ca$) '***REVISE THIS SECTION LATER***


layoutdone=0

linefragment = a$
if debug then print #9, a$
n = numelements(a$)
IF n = 0 THEN GOTO finishednonexec

'convert non-UDT dimensioned periods to _046_
if instr(ca$,sp+"."+sp) then
a3$=getelement(ca$, 1)
except=0
aa$=a3$+sp 'rebuilt a$ (always has a trailing spacer)
for x=2 to n
a2$=getelement(ca$, x)
if except=1 then except=2: goto udtperiod 'skip element name
if a2$="." and x<>n then
if except=2 then except=1: goto udtperiod 'sub-element of UDT

if a3$=")" then
'assume it was something like typevar(???).x and treat as a UDT
except=1
goto udtperiod
end if

'find an ID of that type
try = findid(ucase$(a3$))
DO WHILE try
if ((id.t and ISUDT)<>0) or ((id.arraytype and ISUDT)<>0) then
except=1
goto udtperiod
end if
IF try = 2 THEN findanotherid = 1: try = findid(ucase$(a3$)) ELSE try = 0
LOOP
'not a udt; fuse lhs & rhs with _046_
aa$=left$(aa$,len(aa$)-1)+fix046$
goto periodfused
end if '"."
except=0
udtperiod:
aa$=aa$+a2$+sp
periodfused:
a3$=a2$
next
a$=left$(aa$,len(aa$)-1)
ca$=a$
a$=eleucase$(ca$)
n = numelements(a$)
end if

arrayprocessinghappened = 0

firstelement$ = getelement(a$, 1)
secondelement$ = getelement(a$, 2)
thirdelement$ = getelement(a$, 3)

'non-executable section

'check TYPE declarations (created on prepass)
if firstelement$="TYPE" then
if n<>2 then qb64error "Expected TYPE type-name"
l$="TYPE"+sp+getelement(ca$, 2)
layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$
definingtype=1
GOTO finishednonexec
end if

if definingtype then

if firstelement$="END" then
if n<>2 or secondelement$<>"TYPE" then qb64error "Expected END TYPE"
definingtype=0
l$="END"+sp+"TYPE"
layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$
GOTO finishednonexec
end if

if n<3 or secondelement$<>"AS" then qb64error "Expected element-name AS type-name"
l$=getelement(ca$, 1)+sp+"AS"
t$=getelements$(a$,3,n)
typ=typname2typ(t$)
if typ=0 then a$="Undefined type":goto errmes
if typ AND ISUDT then
t$=rtrim$(udtxcname(typ AND 511))
end if
l$=l$+sp+t$
layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$
GOTO finishednonexec

end if 'defining type

'skip DECLARE SUB/FUNCTION
IF n >= 1 THEN
IF firstelement$ = "DECLARE" THEN GOTO finishednonexec 'note: no layout required
END IF

'begin SUB/FUNCTION
IF n >= 1 THEN
sf = 0
IF firstelement$ = "FUNCTION" THEN sf = 1
IF firstelement$ = "SUB" THEN sf = 2
IF sf THEN
IF n = 1 THEN a$="Expected name after SUB/FUNCTION":goto errmes
e$ = getelement$(ca$, 2)
symbol$ = removesymbol$(e$) '$,%,etc.
IF sf = 2 AND symbol$ <> "" THEN a$="Type symbols after a SUB name are invalid":goto errmes
try = findid(e$)
DO WHILE try
IF id.subfunc = sf THEN GOTO createsf
IF try = 2 THEN findanotherid = 1: try = findid(e$) ELSE try = 0
LOOP
a$="Unregistered SUB/FUNCTION encountered":goto errmes
createsf:
l$=firstelement$+sp+e$+symbol$

id2 = id

targetid = currentid
IF closedmain = 0 THEN closemain
subfuncn = subfuncn + 1
CLOSE #13: OPEN tmpdir$ + "data" + str2$(subfuncn) + ".txt" FOR OUTPUT AS #13
CLOSE #19: OPEN tmpdir$ + "free" + str2$(subfuncn) + ".txt" FOR OUTPUT AS #19
CLOSE #15: OPEN tmpdir$ + "ret" + str2$(subfuncn) + ".txt" FOR OUTPUT AS #15
PRINT #15, "if (next_return_point){"
PRINT #15, "next_return_point--;"
PRINT #15, "switch(return_point[next_return_point]){"
PRINT #15, "case 0:"
PRINT #15, "error(3);"'return without gosub!
PRINT #15, "break;"
defdatahandle = 13
subfunc = RTRIM$(id.callname) 'SUB_..."
subfuncret$ = ""
IF sf = 1 THEN
rettyp = id.ret
t$ = typ2ctyp$(id.ret, "")
IF t$ = "qbs" THEN t$ = "qbs*"
PRINT #17, t$ + " " + RTRIM$(id.callname) + "(";
PRINT #12, t$ + " " + RTRIM$(id.callname) + "(";
'create variable to return result
'if type wasn't specified, define it
IF symbol$ = "" THEN
a = ASC(ucase$(e$)): IF a = 95 THEN a = 91
a = a - 64 'so A=1, Z=27 and _=28
symbol$ = defineextaz(a)
END IF
ignore = dim2(e$, symbol$, 0, "")
'the following line stops the return variable from being free'd before being returned
CLOSE #19: OPEN tmpdir$ + "free" + str2$(subfuncn) + ".txt" FOR OUTPUT AS #19
'create return
IF (rettyp AND ISSTRING) THEN
r$ = refer$(str2$(currentid), id.t, 1)
subfuncret$ = subfuncret$ + "qbs_maketmp("+r$+");"
subfuncret$ = subfuncret$ + "return " + r$ + ";"
ELSE
r$ = refer$(str2$(currentid), id.t, 0)
subfuncret$ = "return " + r$ + ";"
END IF
ELSE
PRINT #17, "void " + RTRIM$(id.callname) + "(";
PRINT #12, "void " + RTRIM$(id.callname) + "(";
END IF

addstatic2layout=0
staticsf=0
e$ = getelement$(a$, n)
if e$="STATIC" then
addstatic2layout=1
staticsf=2
a$=left$(a$,len(a$)-7): n=n-1 'remove STATIC
end if

'check items to pass
params = 0
IF n > 2 THEN
e$ = getelement$(a$, 3)
IF e$ <> "(" THEN a$="Expected (":goto errmes
e$ = getelement$(a$, n)
IF e$ <> ")" THEN a$="Expected )":goto errmes
l$=l$+sp+"("
if n=4 then goto nosfparams2
IF n < 4 THEN a$="Expected ( ... )":goto errmes
b = 0
a2$ = ""
FOR i = 4 TO n - 1
e$ = getelement$(ca$, i)
IF e$ = "(" THEN b = b + 1
IF e$ = ")" THEN b = b - 1
IF e$ = "," AND b = 0 THEN
IF i = n - 1 THEN a$="Expected , ... )":goto errmes
getlastparam2:
IF a2$ = "" THEN a$="Expected ... ,":goto errmes
a2$ = LEFT$(a2$, LEN(a2$) - 1)
'possible format: [BYVAL]a[%][(1)][AS][type]
params = params + 1
glinkid = targetid
glinkarg = params



IF params > 1 THEN
PRINT #17, ",";
PRINT #12, ",";
END IF
n2 = numelements(a2$)
array = 0
t2$ = ""
e$ = getelement$(a2$, 1)
if right$(l$,1)="(" then l$=l$+sp2+e$ else l$=l$+sp+e$

n2$ = e$
dimmethod = 0


symbol2$ = removesymbol$(n2$)
IF symbol2$ <> "" THEN dimmethod = 1
m = 0
FOR i2 = 2 TO n2
e$ = getelement$(a2$, i2)
IF e$ = "(" THEN
IF m <> 0 THEN a$="Syntax error":goto errmes
m = 1
array = 1
l$=l$+sp2+"("
GOTO gotaa2
END IF
IF e$ = ")" THEN
IF m <> 1 THEN a$="Syntax error":goto errmes
m = 2
l$=l$+sp2+")"
GOTO gotaa2
END IF
IF ucase$(e$) = "AS" THEN
IF m <> 0 AND m <> 2 THEN a$="Syntax error":goto errmes
m = 3
l$=l$+sp+"AS"
GOTO gotaa2
END IF
IF m = 1 THEN l$=l$+sp+e$: GOTO gotaa2 'ignore contents of option bracket telling how many dimensions (add to layout as is)
IF m <> 3 THEN a$="Syntax error":goto errmes
IF t2$ = "" THEN t2$ = e$ ELSE t2$ = t2$ + " " + e$
gotaa2:
NEXT i2
IF symbol2$ <> "" AND t2$ <> "" THEN a$="Syntax error":goto errmes


if len(t2$) then 'add type-name after AS
t2$=ucase$(t2$)
t3$=t2$
typ=typname2typ(t3$)
if typ=0 then a$="Undefined type":goto errmes
if typ AND ISUDT then
t3$=rtrim$(udtxcname(typ AND 511))
else
for t3i=1 to len(t3i)
if asc(t3$,t3i)=32 then asc(t3$,t3i)=asc(sp)
next
end if
l$=l$+sp+t3$
end if

IF t2$ = "" THEN t2$ = symbol2$
IF t2$ = "" THEN
IF LEFT$(n2$, 1) = "_" THEN v = 27 ELSE v = ASC(ucase$(n2$)) - 64
t2$ = defineaz(v)
dimmethod = 1
END IF




IF array = 1 THEN
dimsfarray = 1
'note: id2.nele is currently 0
nelereq = ASC(MID$(id2.nelereq, params, 1))
IF nelereq THEN
nele = nelereq
MID$(id2.nele, params, 1) = CHR$(nele)

ids(targetid)=id2

ignore = dim2(n2$, t2$, dimmethod, str2$(nele))
ELSE
nele = 1
MID$(id2.nele, params, 1) = CHR$(nele)

ids(targetid)=id2

ignore = dim2(n2$, t2$, dimmethod, "?")
END IF
dimsfarray = 0
r$ = refer$(str2$(currentid), id.t, 1)
PRINT #17, "long*" + r$;
PRINT #12, "long*" + r$;
ELSE
dimsfarray = 1
ignore = dim2(n2$, t2$, dimmethod, "")
dimsfarray = 0
t$ = ""
typ = id.t 'the typ of the ID created by dim2
t$ = typ2ctyp$(typ, "")
IF t$ = "" THEN x=101:goto errnum
'searchpoint
'get the name of the variable
r$ = refer$(str2$(currentid), id.t, 1)
PRINT #17, t$ + "*" + r$;
PRINT #12, t$ + "*" + r$;
 IF t$ = "qbs" THEN
 u$ = str2$(uniquenumber)
 PRINT #13, "qbs*oldstr" + u$ + "=NULL;"
 PRINT #13, "if(" + r$ + "->tmp||" + r$ + "->fixed||" + r$ + "->readonly){"
 PRINT #13, "oldstr" + u$ + "=" + r$ + ";"
 PRINT #13, r$ + "=qbs_new(oldstr" + u$ + "->len,0);"
 PRINT #13, "memcpy(" + r$ + "->chr,oldstr" + u$ + "->chr,oldstr" + u$ + "->len);"
 PRINT #13, "}"
 PRINT #19, "if(oldstr" + u$ + "){"
 PRINT #19, "if(oldstr" + u$ + "->fixed)qbs_set(oldstr" + u$ + "," + r$ + ");"
 PRINT #19, "qbs_free(" + r$ + ");"
 PRINT #19, "}"
 END IF
END IF

if i<>n-1 then l$=l$+sp2+","

a2$ = ""
ELSE
a2$ = a2$ + e$ + sp
IF i = n - 1 THEN GOTO getlastparam2
END IF
NEXT i
nosfparams2:
l$=l$+sp2+")"
END IF 'n>2

if addstatic2layout then l$=l$+sp+"STATIC"
layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$

PRINT #17, ");"
PRINT #12, "){"
PRINT #12, "qbs *tqbs;"
PRINT #12, "long tmp_long;"
PRINT #12, "long tmp_fileno;"
PRINT #12, "unsigned long qbs_tmp_base=qbs_tmp_list_nexti;"
PRINT #12, "unsigned char *tmp_mem_static_pointer=mem_static_pointer;"
PRINT #12, "unsigned long tmp_cmem_sp=cmem_sp;"
PRINT #12, "#include " + CHR$(34) + "data" + str2$(subfuncn) + ".txt" + CHR$(34)
PRINT #12, "if (new_error) goto exit_subfunc;"

'statementn = statementn + 1
'if nochecks=0 then PRINT #12, "S_" + str2$(statementn) + ":;"

dimstatic=staticsf
GOTO finishednonexec
END IF
END IF

'END SUB/FUNCTION
IF n = 2 THEN
IF firstelement$ = "END" THEN
sf = 0
IF secondelement$ = "FUNCTION" THEN sf = 1
IF secondelement$ = "SUB" THEN sf = 2
IF sf THEN

l$=firstelement$+sp+secondelement$
layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$

staticarraylist="": staticarraylistn=0 'remove previously listed arrays
dimstatic=0
PRINT #12, "exit_subfunc:;"
PRINT #12, "#include " + CHR$(34) + "free" + str2$(subfuncn) + ".txt" + CHR$(34)
PRINT #12, "if ((tmp_mem_static_pointer>=mem_static)&&(tmp_mem_static_pointer<=mem_static_limit)) mem_static_pointer=tmp_mem_static_pointer; else mem_static_pointer=mem_static;"
PRINT #12, "cmem_sp=tmp_cmem_sp;"
IF subfuncret$ <> "" THEN PRINT #12, subfuncret$
PRINT #12, "}" 'skeleton sub
'ret???.txt
PRINT #15, "}"'end case
PRINT #15, "}"
PRINT #15, "error(3);"'no valid return possible
subfunc = ""
'unshare temp. shared variables
for i=1 to idn
if ids(i).share and 2 then ids(i).share=ids(i).share-2
next

for i=1 to revertmaymusthaven
x=revertmaymusthave(i)
swap ids(x).musthave,ids(x).mayhave
next
revertmaymusthaven=0

'undeclare constants in sub/function's scope
constlast=constlastshared
GOTO finishednonexec
END IF
END IF
END IF



if n>=1 and firstelement$="CONST" then
'DEF... do not change type, the expression is stored in a suitable type
'based on its value if type isn't forced/specified
if n<3 then a$="Expected CONST name = value/expression":goto errmes
i=2

constdefpending:
pending=0

n$=getelement$(a$,i): i=i+1

typeoverride=0
s$=removesymbol$(n$)
if s$<>"" then
typeoverride=typname2typ(s$)
if typeoverride and ISFIXEDLENGTH then a$="Invalid constant type":goto errmes
if typeoverride=0 then a$="Invalid constant type":goto errmes
end if

if getelement$(a$,i)<>"=" then a$="Expected =":goto errmes
i=i+1

'get expression
e$=""
b=0
for i2=i to n
e2$=getelement$(a$,i2)
if e2$="(" then b=b+1
if e2$=")" then b=b-1
if e2$="," and b=0 then
pending=1
i=i2+1
if i>n-2 then a$="Expected CONST ... , name = value/expression":goto errmes
exit for
end if
if len(e$)=0 then e$=e2$ else e$=e$+sp+e2$
next

e$ = fixoperationorder(e$)
e$ = evaluateconst(e$, t)

if t and ISSTRING then 'string type

if typeoverride then
if (typeoverride and ISSTRING)=0 then a$="Type mismatch":goto errmes
end if

else 'not a string type

if typeoverride then
if typeoverride and ISSTRING then a$="Type mismatch":goto errmes
end if

if t and ISFLOAT then
 constval##=_cv(_float,e$)
 constval&&=constval##
 constval~&&=constval&&
else
 if (t and ISUNSIGNED) and (t AND 511)=64 then
  constval~&&=_cv(_unsigned _integer64,e$)
  constval&&=constval~&&
  constval##=constval&&
 else
  constval&&=_cv(_integer64,e$)
  constval##=constval&&
  constval~&&=constval&&
 end if
end if

'override type?
if typeoverride then
'range check required here (noted in todo)
t=typeoverride
end if

end if 'not a string type

constlast=constlast+1
i2=constlast
if subfunc = "" then constlastshared=i2
constname(i2)=n$
constnamesymbol(i2)=typevalue2symbol$(t)
consttype(i2)=t
if t and ISSTRING then
 conststring(i2)=e$
else
 if t and ISFLOAT then
  constfloat(i2)=constval##
 else
  if t and ISUNSIGNED then
   constuinteger(i2)=constval~&&
  else
   constinteger(i2)=constval&&
  end if
 end if
end if

if pending then goto constdefpending

GOTO finishednonexec
end if

predefine:
IF n >= 2 THEN
asreq=0
IF firstelement$ = "DEFINT" THEN a$ = a$ + sp + "AS" + sp + "INTEGER": n = n + 2: GOTO definetype
IF firstelement$ = "DEFLNG" THEN a$ = a$ + sp + "AS" + sp + "LONG": n = n + 2: GOTO definetype
IF firstelement$ = "DEFSNG" THEN a$ = a$ + sp + "AS" + sp + "SINGLE": n = n + 2: GOTO definetype
IF firstelement$ = "DEFDBL" THEN a$ = a$ + sp + "AS" + sp + "DOUBLE": n = n + 2: GOTO definetype
IF firstelement$ = "DEFSTR" THEN a$ = a$ + sp + "AS" + sp + "STRING": n = n + 2: GOTO definetype
IF firstelement$ = "_DEFINE" THEN
asreq=1
definetype:
l$=firstelement$
'get type from rhs
typ$ = ""
typ2$ = ""
t$ = ""
FOR i = n TO 2 STEP -1
t$ = getelement$(a$, i)
IF t$ = "AS" THEN EXIT FOR
typ$ = t$ + " " + typ$
typ2$ = t$+sp+typ2$
NEXT
typ$ = RTRIM$(typ$)
IF t$ <> "AS" THEN x=23:goto errnum
IF i = n OR i = 2 THEN x=24:goto errnum


n = i - 1
'the data is from element 2 to element n
i = 2 - 1
definenext:
'expects an alphabet letter or underscore
i = i + 1: e$ = getelement$(a$, i): e = ASC(ucase$(e$))
IF LEN(e$) > 1 THEN x=25:goto errnum
IF e <> 95 AND (e > 90 OR e < 65) THEN x=26:goto errnum
IF e = 95 THEN e = 27 ELSE e = e - 64
defineaz(e) = typ$
defineextaz(e) = type2symbol(typ$)
firste = e
l$=l$+sp+e$

IF i = n THEN
IF predefining = 1 THEN GOTO predefined
if asreq then l$=l$+sp+"AS"+sp+typ2$
layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$
GOTO finishednonexec
END IF

'expects "-" or ","
i = i + 1: e$ = getelement$(a$, i)
IF e$ <> "-" AND e$ <> "," THEN x=27:goto errnum
IF e$ = "-" THEN
l$=l$+sp2+"-"
IF i = n THEN x=28:goto errnum
'expects an alphabet letter or underscore
i = i + 1: e$ = getelement$(a$, i): e = ASC(ucase$(e$))
IF LEN(e$) > 1 THEN x=29:goto errnum
IF e <> 95 AND (e > 90 OR e < 65) THEN x=30:goto errnum
  IF e = 95 THEN e = 27 ELSE e = e - 64
  IF firste > e THEN SWAP e, firste
  FOR e2 = firste TO e
  defineaz(e2) = typ$
  defineextaz(e2) = type2symbol(typ$)
  NEXT
  l$=l$+sp2+e$
IF i = n THEN
IF predefining = 1 THEN GOTO predefined
if asreq then l$=l$+sp+"AS"+sp+typ2$
layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$
GOTO finishednonexec
END IF
'expects ","
i = i + 1: e$ = getelement$(a$, i)
IF e$ <> "," THEN x=31:goto errnum
END IF
l$=l$+sp2+","
GOTO definenext
END IF '_DEFINE
END IF '2
IF predefining = 1 THEN GOTO predefined

if closedmain <> 0 and subfunc = "" then a$="Statement cannot be placed between SUB/FUNCTIONs":goto errmes

'executable section:

statementn = statementn + 1

'dynamic scope commands:


IF n >= 1 THEN
IF firstelement$ = "NEXT" THEN

l$="NEXT"
if n=1 then goto simplenext
v$=""
FOR i = 2 TO n
a2$ = getelement(ca$, i)

if a2$="," then

lastnextele:
e$=fixoperationorder(v$)
if len(l$)=4 then l$=l$+sp+tlayout$ else l$=l$+sp2+","+sp+tlayout$
e$ = evaluate(e$, typ)
IF (typ AND ISREFERENCE) THEN
getid val(e$)
IF (id.t AND ISPOINTER) THEN
IF (id.t AND ISSTRING) = 0 THEN
IF (id.t AND ISOFFSETINBITS) = 0 THEN
IF (id.t AND ISARRAY) = 0 THEN
GOTO fornextfoundvar2
END IF
END IF
END IF
END IF
END IF
a$="Unsupported variable after NEXT":goto errmes
fornextfoundvar2:
simplenext:
IF controltype(controllevel) <> 2 THEN a$="NEXT without FOR":goto errmes
if n<>1 and controlvalue(controllevel)<>currentid then a$="Incorrect variable after NEXT":goto errmes
PRINT #12, "}"
PRINT #12, "fornext_exit_" + str2$(controlid(controllevel)) + ":;"
controllevel = controllevel - 1
if n=1 then exit for
v$=""

else

if len(v$) then v$=v$+sp+a2$ else v$=a2$
if i=n then goto lastnextele

end if

next

layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$
GOTO finishednonexec '***no error causing code, event checking done by FOR***
END IF
END IF



IF n >= 1 THEN
IF firstelement$ = "WHILE" THEN
if nochecks=0 then PRINT #12, "S_" + str2$(statementn) + ":;":dynscope=1

controllevel = controllevel + 1
controltype(controllevel) = 5
controlid(controllevel) = uniquenumber
IF n >= 2 THEN
e$ = fixoperationorder(getelements$(ca$, 2, n))
l$="WHILE"+sp+tlayout$
layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$
e$ = evaluate(e$, typ)
IF (typ AND ISREFERENCE) THEN e$ = refer$(e$, typ, 0)
IF stringprocessinghappened THEN e$ = cleanupstringprocessingcall$ + e$ + ")"
IF (typ AND ISSTRING) THEN x=12:goto errnum
PRINT #12, "while((" + e$ + ")||new_error){"
ELSE
x=13:goto errnum
END IF

GOTO finishedline
END IF
END IF

IF n = 1 THEN
IF firstelement$ = "WEND" THEN


IF controltype(controllevel) <> 5 THEN a$="WEND without WHILE":goto errmes
PRINT #12, "}"
PRINT #12, "ww_exit_" + str2$(controlid(controllevel)) + ":;"
controllevel = controllevel - 1
l$="WEND"
layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$
GOTO finishednonexec '***no error causing code, event checking done by WHILE***
END IF
END IF





IF n >= 1 THEN
IF firstelement$ = "DO" THEN
if nochecks=0 then PRINT #12, "S_" + str2$(statementn) + ":;":dynscope=1
controllevel = controllevel + 1
l$="DO"
IF n >= 2 THEN
whileuntil = 0
IF secondelement$ = "WHILE" THEN whileuntil = 1:l$=l$+sp+"WHILE"
IF secondelement$ = "UNTIL" THEN whileuntil = 2:l$=l$+sp+"UNTIL"
IF whileuntil = 0 THEN x=15:goto errnum
e$ = fixoperationorder(getelements$(ca$, 3, n))
l$=l$+sp+tlayout$
e$ = evaluate(e$, typ)
IF (typ AND ISREFERENCE) THEN e$ = refer$(e$, typ, 0)
IF stringprocessinghappened THEN e$ = cleanupstringprocessingcall$ + e$ + ")"
IF (typ AND ISSTRING) THEN x=16:goto errnum
IF whileuntil = 1 THEN PRINT #12, "while((" + e$ + ")||new_error){" ELSE PRINT #12, "while((!(" + e$ + "))||new_error){"
controltype(controllevel) = 4
ELSE
controltype(controllevel) = 3
PRINT #12, "do{"
END IF
controlid(controllevel) = uniquenumber
layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$
GOTO finishedline
END IF
END IF

IF n >= 1 THEN
IF firstelement$ = "LOOP" THEN
l$="LOOP"
IF controltype(controllevel) <> 3 AND controltype(controllevel) <> 4 THEN x=17:goto errnum
IF n >= 2 THEN
if nochecks=0 then PRINT #12, "S_" + str2$(statementn) + ":;":dynscope=1
IF controltype(controllevel) = 4 THEN x=18:goto errnum
whileuntil = 0
IF secondelement$ = "WHILE" THEN whileuntil = 1:l$=l$+sp+"WHILE"
IF secondelement$ = "UNTIL" THEN whileuntil = 2:l$=l$+sp+"UNTIL"
IF whileuntil = 0 THEN x=19:goto errnum
e$ = fixoperationorder(getelements$(ca$, 3, n))
l$=l$+sp+tlayout$
e$ = evaluate(e$, typ)
IF (typ AND ISREFERENCE) THEN e$ = refer$(e$, typ, 0)
IF stringprocessinghappened THEN e$ = cleanupstringprocessingcall$ + e$ + ")"
IF (typ AND ISSTRING) THEN x=20:goto errnum
IF whileuntil = 1 THEN PRINT #12, "}while((" + e$ + ")&&(!new_error));" ELSE PRINT #12, "}while((!(" + e$ + "))&&(!new_error));"
ELSE
IF controltype(controllevel) = 4 THEN
PRINT #12, "}"
ELSE
PRINT #12, "}while(1);" 'infinite loop!
END IF
END IF
PRINT #12, "dl_exit_" + str2$(controlid(controllevel)) + ":;"
controllevel = controllevel - 1
layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$
if n=1 then GOTO finishednonexec '***no error causing code, event checking done by DO***
GOTO finishedline
END IF
END IF









IF n >= 6 THEN
IF firstelement$ = "FOR" THEN
if nochecks=0 then PRINT #12, "S_" + str2$(statementn) + ":;":dynscope=1

l$="FOR"
controllevel = controllevel + 1
controltype(controllevel) = 2
controlid(controllevel) = uniquenumber
v$ = ""
startvalue$ = ""
p3$ = "1": stepused=0
p2$ = ""
FOR i = 2 TO n
IF getelement$(a$, i) = "=" THEN
v$ = getelements$(ca$, 2, i - 1)
equpos = i
END IF
IF getelement$(a$, i) = "TO" THEN
startvalue$ = getelements$(ca$, equpos + 1, i - 1)
topos = i
END IF
IF getelement$(a$, i) = "STEP" THEN
stepused=1
p2$ = getelements$(ca$, topos + 1, i - 1)
p3$ = getelements$(ca$, i + 1, n)
END IF
NEXT
IF p2$ = "" THEN p2$ = getelements$(ca$, topos + 1, n)

e$=fixoperationorder(v$)
l$=l$+sp+tlayout$
e$ = evaluate(e$, typ)
IF (typ AND ISREFERENCE) THEN
getid val(e$)
IF (id.t AND ISPOINTER) THEN
IF (id.t AND ISSTRING) = 0 THEN
IF (id.t AND ISOFFSETINBITS) = 0 THEN
IF (id.t AND ISARRAY) = 0 THEN
GOTO fornextfoundvar
END IF
END IF
END IF
END IF
END IF
x=21:goto errnum
fornextfoundvar:
controlvalue(controllevel)=currentid
v$=e$

setrefer v$, typ, startvalue$, 0
l$=l$+sp+"="+sp+tlayout$

'find C++ datatype to match variable
'markup to cater for greater range/accuracy
ctype$ = ""
ctyp = typ - ISPOINTER
bits = typ AND 511
IF (typ AND ISFLOAT) THEN
IF bits = 32 THEN ctype$ = "double": ctyp = 64& + ISFLOAT
IF bits = 64 THEN ctype$ = "long double": ctyp = 256& + ISFLOAT
IF bits = 256 THEN ctype$ = "long double": ctyp = 256& + ISFLOAT
ELSE
IF bits = 8 THEN ctype$ = "int16": ctyp = 16&
IF bits = 16 THEN ctype$ = "int32": ctyp = 32&
IF bits = 32 THEN ctype$ = "int64": ctyp = 64&
IF bits = 64 THEN ctype$ = "int64": ctyp = 64&
END IF
IF ctype$ = "" THEN x=22:goto errnum
u$ = str2(uniquenumber)

IF subfunc = "" THEN
PRINT #13, "static " + ctype$ + " fornext_value" + u$ + ";"
PRINT #13, "static " + ctype$ + " fornext_finalvalue" + u$ + ";"
PRINT #13, "static " + ctype$ + " fornext_step" + u$ + ";"
PRINT #13, "static unsigned char fornext_step_negative" + u$ + ";"
ELSE
PRINT #13, ctype$ + " fornext_value" + u$ + ";"
PRINT #13, ctype$ + " fornext_finalvalue" + u$ + ";"
PRINT #13, ctype$ + " fornext_step" + u$ + ";"
PRINT #13, "unsigned char fornext_step_negative" + u$ + ";"
END IF

typbak = typ
PRINT #12, "fornext_value" + u$ + "=" + refer$(v$, typ, 0) + ";"
typ = typbak

e$=fixoperationorder$(p2$)
l$=l$+sp+"TO"+sp+tlayout$
e$ = evaluatetotyp(e$, ctyp)
PRINT #12, "fornext_finalvalue" + u$ + "=" + e$ + ";"

e$=fixoperationorder$(p3$)
if stepused=1 then l$=l$+sp+"STEP"+sp+tlayout$
e$ = evaluatetotyp(e$, ctyp)
PRINT #12, "fornext_step" + u$ + "=" + e$ + ";"

PRINT #12, "if (fornext_step" + u$ + "<0) fornext_step_negative" + u$ + "=1; else fornext_step_negative" + u$ + "=0;"
PRINT #12, "if (new_error) goto fornext_error" + u$ + ";"
PRINT #12, "goto fornext_entrylabel" + u$ + ";"
PRINT #12, "while(1){"
typbak = typ
PRINT #12, "fornext_value" + u$ + "=fornext_step" + u$ + "+(" + refer$(v$, typ, 0) + ");"
typ = typbak
setrefer v$, typ, "fornext_value" + u$, 1
'old-> e$ = "fornext_value" + u$ + "+=fornext_step" + u$
'old-> setrefer v$, typ, e$, 1
PRINT #12, "fornext_entrylabel" + u$ + ":"
PRINT #12, "if (fornext_step_negative" + u$ + "){"
PRINT #12, "if (fornext_value" + u$ + "<fornext_finalvalue" + u$ + ") break;"
PRINT #12, "}else{"
PRINT #12, "if (fornext_value" + u$ + ">fornext_finalvalue" + u$ + ") break;"
PRINT #12, "}"
PRINT #12, "fornext_error" + u$ + ":"

layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$

GOTO finishedline
END IF
END IF


IF n = 1 THEN
IF firstelement$ = "ELSE" THEN
FOR i = controllevel TO 1 STEP -1
t = controltype(i)
IF t = 1 THEN
IF controlstate(controllevel) = 2 THEN a$="IF-THEN already contains an ELSE statement":goto errmes
PRINT #12, "}else{"
controlstate(controllevel) = 2
if lineelseused = 0 then lhscontrollevel=lhscontrollevel-1
l$="ELSE"
layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$
GOTO finishednonexec '***no error causing code, event checking done by IF***
END IF
NEXT
a$="ELSE without IF":goto errmes
END IF
END IF

IF n >= 3 THEN
IF firstelement$ = "ELSEIF" THEN
if nochecks=0 then PRINT #12, "S_" + str2$(statementn) + ":;":dynscope=1

FOR i = controllevel TO 1 STEP -1
t = controltype(i)
IF t = 1 THEN
IF controlstate(controllevel) = 2 THEN a$="ELSEIF invalid after ELSE":goto errmes
controlstate(controllevel) = 1
controlvalue(controllevel) = controlvalue(controllevel) + 1
e$ = getelement$(a$, n)
IF e$ <> "THEN" THEN a$="Expected ELSEIF expression THEN":goto errmes
PRINT #12, "}else{"
e$ = fixoperationorder$(getelements$(ca$, 2, n - 1))
l$="ELSEIF"+sp+tlayout$+sp+"THEN"
layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$
e$ = evaluate(e$, typ)
IF (typ AND ISREFERENCE) THEN e$ = refer$(e$, typ, 0)
IF stringprocessinghappened THEN
PRINT #12, "if (" + cleanupstringprocessingcall$ + e$ + ")){"
ELSE
PRINT #12, "if (" + e$ + "){"
END IF
lhscontrollevel=lhscontrollevel-1
GOTO finishedline
END IF
NEXT
a$="ELSEIF without IF":goto errmes
END IF
END IF

IF n >= 3 THEN
IF firstelement$ = "IF" THEN
if nochecks=0 then PRINT #12, "S_" + str2$(statementn) + ":;":dynscope=1

e$ = getelement(a$, n)
iftype = 0
IF e$ = "THEN" THEN iftype = 1
IF e$ = "GOTO" THEN iftype = 2
IF iftype = 0 THEN a$="Expected IF expression THEN/GOTO":goto errmes

controllevel = controllevel + 1
controltype(controllevel) = 1
controlvalue(controllevel) = 0 'number of extra closing } required at END IF
controlstate(controllevel) = 0

e$ = fixoperationorder$(getelements(ca$, 2, n - 1))
l$="IF"+sp+tlayout$
e$ = evaluate(e$, typ)
IF (typ AND ISREFERENCE) THEN e$ = refer$(e$, typ, 0)

IF stringprocessinghappened THEN
PRINT #12, "if ((" + cleanupstringprocessingcall$ + e$ + "))||new_error){"
ELSE
PRINT #12, "if ((" + e$ + ")||new_error){"
END IF

if iftype=1 then l$=l$+sp+"THEN" 'note: 'GOTO' will be added when iftype=2
layoutdone=1: if len(layout$)=0 then layout$=l$ else layout$=layout$+sp+l$

IF iftype = 2 THEN 'IF ... GOTO
GOTO finishedline
END IF

THENGOTO = 1 'possible: IF a=1 THEN 10 
GOTO finishedline2
END IF
END IF


'END IF
IF n = 2 THEN
IF getelement(a$, 1) = "END" AND getelement(a$, 2) = "IF" THEN


IF controltype(controllevel) <> 1 THEN a$="END IF without IF":goto errmes
layoutdone=1
if impliedendif=0 then
l$="END"+sp+"IF"
if len(layout$)=0 then layout$=l$ else layout$=layout$+sp+l$
end if
PRINT #12, "}"
FOR i = 1 TO controlvalue(controllevel)
PRINT #12, "}"
NEXT
controllevel = controllevel - 1
GOTO finishednonexec '***no error causing code, event checking done by IF***
END IF
END IF



'SELECT CASE
IF n >= 1 THEN
IF firstelement$ = "SELECT" THEN
if nochecks=0 then PRINT #12, "S_" + str2$(statementn) + ":;":dynscope=1

IF n = 1 OR secondelement$ <> "CASE" THEN a$="Expected CASE":goto errmes
IF n = 2 THEN a$="Expected SELECT CASE expression":goto errmes
e$ = fixoperationorder(getelements$(ca$, 3, n))
l$="SELECT"+sp+"CASE"+sp+tlayout$
layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$
e$ = evaluate(e$, typ)
IF (typ AND ISREFERENCE) THEN e$ = refer(e$, typ, 0)
u = uniquenumber
t$ = ""
IF (typ AND ISSTRING) THEN
t = 0
PRINT #13, "static qbs *sc_" + str2$(u) + "=qbs_new(0,0);"
PRINT #12, "qbs_set(sc_" + str2$(u) + "," + e$ + ");"
ELSE
IF (typ AND ISFLOAT) THEN
t = 3: t$ = "long double": PRINT #13, "static " + t$ + " sc_" + str2$(u) + ";"
ELSE
t = 1: t$ = "int64"
IF (typ AND 511) = 64 AND (typ AND ISUNSIGNED) <> 0 THEN t = 2: t$ = "uint64"
PRINT #13, "static " + t$ + " sc_" + str2$(u) + ";"
END IF
PRINT #12, "sc_" + str2$(u) + "=" + e$ + ";"
END IF
controllevel = controllevel + 1
controltype(controllevel) = 10 + t
controlid(controllevel) = u


GOTO finishedline
END IF
END IF


'END SELECT
IF n = 2 THEN
IF firstelement$ = "END" AND secondelement$ = "SELECT" THEN


'complete current case if necessary
'18=CASE (awaiting END SELECT/CASE/CASE ELSE)
'19=CASE ELSE (awaiting END SELECT)
IF controltype(controllevel) = 18 THEN
controllevel = controllevel - 1
PRINT #12, "goto sc_" + str2$(controlid(controllevel)) + "_end;"
PRINT #12, "}"
END IF
IF controltype(controllevel) = 19 THEN
controllevel = controllevel - 1
END IF
PRINT #12, "sc_" + str2$(controlid(controllevel)) + "_end:;"
IF controltype(controllevel) < 10 OR controltype(controllevel) > 13 THEN a$="END SELECT without SELECT CASE":goto errmes
controllevel = controllevel - 1
l$="END"+sp+"SELECT"
layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$
GOTO finishednonexec '***no error causing code, event checking done by SELECT CASE***
END IF
END IF

'CASE
IF n >= 1 THEN
IF firstelement$ = "CASE" THEN

l$="CASE"
'complete current case if necessary
'18=CASE (awaiting END SELECT/CASE/CASE ELSE)
'19=CASE ELSE (awaiting END SELECT)
IF controltype(controllevel) = 19 THEN a$="Expected END SELECT":goto errmes
IF controltype(controllevel) = 18 THEN
lhscontrollevel=lhscontrollevel-1
controllevel = controllevel - 1
PRINT #12, "goto sc_" + str2$(controlid(controllevel)) + "_end;"
PRINT #12, "}"
'following line fixes problem related to RESUME after error
'statementn = statementn + 1
'if nochecks=0 then PRINT #12, "S_" + str2$(statementn) + ":;"
END IF

IF controltype(controllevel) < 10 OR controltype(controllevel) > 13 THEN a$="CASE without SELECT CASE":goto errmes
IF n = 1 THEN a$="Expected CASE expression":goto errmes
n$ = "sc_" + str2$(controlid(controllevel))

'CASE ELSE
IF n = 2 THEN
IF getelement$(a$, 2) = "C-EL" THEN
controllevel = controllevel + 1: controltype(controllevel) = 19
l$=l$+sp+"ELSE"
layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$
GOTO finishednonexec '***no error causing code, event checking done by SELECT CASE***
END IF
END IF

if nochecks=0 then PRINT #12, "S_" + str2$(statementn) + ":;":dynscope=1


PRINT #12, "if ((";
nexp = 0
b = 0
e$ = ""
FOR i = 2 TO n
e2$ = getelement$(ca$, i)
IF e2$ = "(" THEN b = b + 1
IF e2$ = ")" THEN b = b - 1
IF i = n THEN e$ = e$ + sp + e2$
IF i = n OR (e2$ = "," AND b = 0) THEN
IF nexp <> 0 THEN l$=l$+sp2+",":PRINT #12, "||";
IF e$ = "" THEN a$="Expected expression":goto errmes
e$ = RIGHT$(e$, LEN(e$) - 1)



'TYPE 1? ... TO ...
n2 = numelements(e$)
b2 = 0
el$ = "": er$ = ""
usedto = 0
FOR i2 = 1 TO n2
e3$ = getelement$(e$, i2)
IF e3$ = "(" THEN b2 = b2 + 1
IF e3$ = ")" THEN b2 = b2 - 1
IF b2 = 0 AND ucase$(e3$) = "TO" THEN
usedto = 1
ELSE
IF usedto = 0 THEN el$ = el$ + sp + e3$ ELSE er$ = er$ + sp + e3$
END IF
NEXT
IF usedto = 1 THEN
IF el$ = "" OR er$ = "" THEN a$="Expected expression TO expression":goto errmes
el$ = RIGHT$(el$, LEN(el$) - 1): er$ = RIGHT$(er$, LEN(er$) - 1)
'evaluate each side
FOR i2 = 1 TO 2
IF i2 = 1 THEN e$ = el$ ELSE e$ = er$
e$ = fixoperationorder(e$)
if i2=1 then l$=l$+sp+tlayout$ else l$=l$+sp+"TO"+sp+tlayout$
e$ = evaluate(e$, typ)
IF (typ AND ISREFERENCE) THEN e$ = refer(e$, typ, 0)
IF controltype(controllevel) = 10 THEN
IF (typ AND ISSTRING) = 0 THEN a$="Expected string expression":goto errmes
IF i2 = 1 THEN PRINT #12, "(qbs_greaterorequal(" + n$ + "," + e$ + ")&&qbs_lessorequal(" + n$ + ",";
IF i2 = 2 THEN PRINT #12, e$ + "))";
ELSE
IF (typ AND ISSTRING) THEN a$="Expected numeric expression":goto errmes
'round to integer?
IF (typ AND ISFLOAT) THEN
IF controltype(controllevel) = 11 THEN e$ = "qbr(" + e$ + ")"
IF controltype(controllevel) = 12 THEN e$ = "qbr_longdouble_to_uint64(" + e$ + ")"
END IF
IF i2 = 1 THEN PRINT #12, "((" + n$ + ">=(" + e$ + "))&&(" + n$ + "<=(";
IF i2 = 2 THEN PRINT #12, e$ + ")))";
END IF

NEXT
GOTO addedexp
END IF

o$ = "==" 'used by type 3

'TYPE 2?
x$=getelement$(e$, 1)
if isoperator(x$) then 'non-standard usage correction
if x$="=" or x$="<>" or x$=">" or x$="<" or x$=">=" or x$="<=" then
e$="IS"+sp+e$
x$="IS"
end if
end if
IF ucase$(x$) = "IS" THEN
n2 = numelements(e$)
IF n2 < 3 THEN a$="Expected IS =,<>,>,<,>=,<= expression":goto errmes
o$ = getelement$(e$, 2)
o = 0
IF o$ = "=" THEN o$ = "==": o = 1
IF o$ = "<>" THEN o$ = "!=": o = 1
IF o$ = ">" THEN o = 1
IF o$ = "<" THEN o = 1
IF o$ = ">=" THEN o = 1
IF o$ = "<=" THEN o = 1
IF o <> 1 THEN a$="Expected IS =,<>,>,<,>=,<= expression":goto errmes
l$=l$+sp+"IS"+sp+o$
e$ = getelements$(e$, 3, n2)
'fall through to type 3 using modified e$ & o$
END IF

'TYPE 3? simple expression
e$ = fixoperationorder(e$)
l$=l$+sp+tlayout$
e$ = evaluate(e$, typ)
IF (typ AND ISREFERENCE) THEN e$ = refer(e$, typ, 0)
IF controltype(controllevel) = 10 THEN
'string comparison
IF (typ AND ISSTRING) = 0 THEN a$="Expected string expression":goto errmes
IF o$ = "==" THEN o$ = "qbs_equal"
IF o$ = "!=" THEN o$ = "qbs_notequal"
IF o$ = ">" THEN o$ = "qbs_greaterthan"
IF o$ = "<" THEN o$ = "qbs_lessthan"
IF o$ = ">=" THEN o$ = "qbs_greaterorequal"
IF o$ = "<=" THEN o$ = "qbs_lessorequal"
PRINT #12, o$ + "(" + n$ + "," + e$ + ")";
ELSE
'numeric
IF (typ AND ISSTRING) THEN a$="Expected numeric expression":goto errmes
'round to integer?
IF (typ AND ISFLOAT) THEN
IF controltype(controllevel) = 11 THEN e$ = "qbr(" + e$ + ")"
IF controltype(controllevel) = 12 THEN e$ = "qbr_longdouble_to_uint64(" + e$ + ")"
END IF
PRINT #12, "(" + n$ + o$ + "(" + e$ + "))";
END IF

addedexp:
e$ = ""
nexp = nexp + 1
ELSE
e$ = e$ + sp + e2$
END IF
NEXT
PRINT #12, ")||new_error){"

layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$
controllevel = controllevel + 1: controltype(controllevel) = 18
GOTO finishedline
END IF
END IF











'static scope commands:

if nochecks=0 then
print #12,"do{"
'PRINT #12, "S_" + str2$(statementn) + ":;"
end if


'1=IF (awaiting END IF)
'2=FOR (awaiting NEXT)
'3=DO (awaiting LOOP [UNTIL|WHILE param])
'4=DO WHILE/UNTIL (awaiting LOOP)
'5=WHILE (awaiting WEND)

IF n = 2 THEN
IF firstelement$ = "EXIT" THEN

l$=firstelement$+sp+secondelement$

IF secondelement$ = "DO" THEN
'scan backwards until previous control level reached
FOR i = controllevel TO 1 STEP -1
t = controltype(i)
IF t = 3 OR t = 4 THEN
PRINT #12, "goto dl_exit_" + str2$(controlid(i)) + ";"
layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$
GOTO finishedline
END IF
NEXT
a$="EXIT DO without DO":goto errmes
END IF

IF secondelement$ = "FOR" THEN
'scan backwards until previous control level reached
FOR i = controllevel TO 1 STEP -1
t = controltype(i)
IF t = 2 THEN
PRINT #12, "goto fornext_exit_" + str2$(controlid(i)) + ";"
layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$
GOTO finishedline
END IF
NEXT
a$="EXIT FOR without FOR":goto errmes
END IF

IF secondelement$ = "WHILE" THEN
'scan backwards until previous control level reached
FOR i = controllevel TO 1 STEP -1
t = controltype(i)
IF t = 5 THEN
PRINT #12, "goto ww_exit_" + str2$(controlid(i)) + ";"
layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$
GOTO finishedline
END IF
NEXT
a$="EXIT WHILE without WHILE":goto errmes
END IF

END IF
END IF


if n>=2 then
if firstelement$="ON" and secondelement$="TIMER" then
i=3
if i>n then a$="Expected (":goto errmes
a2$=getelement$(ca$,i): i=i+1
if a2$<>"(" then a$="Expected (":goto errmes
l$="ON"+sp+"TIMER"+sp2+"("
if i>n then a$="Expected ...":goto errmes
b=0
x=0
e2$=""
e3$=""
for i=i to n
e$=getelement$(ca$,i)
a=asc(e$)
if a=40 then b=b+1
if a=41 then b=b-1
if b=-1 then goto ontimgotarg
if a=44 and b=0 then
x=x+1
if x>1 then a$="Expected )":goto errmes
if e2$="" then a$="Expected ... ,":goto errmes
e3$=e2$
e2$=""
else
if len(e2$) then e2$=e2$+sp+e$ else e2$=e$
end if
next 
a$="Expected )":goto errmes
ontimgotarg:
if e2$="" then a$="Expected ... )":goto errmes
print #12,"ontimer_setup(";
'i
if len(e3$) then
e$=fixoperationorder$(e3$)
l$=l$+sp2+tlayout$+","+sp
e$=evaluatetotyp(e$,32&)
print #12,e$+",";
else
print #12,"0,";
l$=l$+sp2
end if
'sec
e$=fixoperationorder$(e2$)
l$=l$+tlayout$+sp2+")"+sp
e$=evaluatetotyp(e$,DOUBLETYPE-ISPOINTER)
print #12,e$+",";
i=i+1
if i>n then a$="Expected GOSUB/CALL":goto errmes
a2$=getelement$(a$,i): i=i+1
ontimerid=ontimerid+1
print #12,str2$(ontimerid)+",";

if a2$="GOSUB" then
if i>n then a$="Expected linenumber/label":goto errmes
a2$=getelement$(a$,i): i=i+1
l$=l$+"GOSUB"+sp+a2$
print #12,"0);"

IF validlabel(a2$) = 0 THEN nerror (65)
print #25,"if(timer_event_id=="+str2$(ontimerid)+")goto LABEL_" + a2$ + ";"

print #24,"case "+str2$(ontimerid)+":"
print #24,"timer_event_occurred++;"
print #24,"timer_event_id="+str2$(ontimerid)+";"
print #24,"timer_event_occurred++;"
print #24,"QBMAIN(NULL);"
print #24,"event_return--;"
print #24,"break;"



'call validlabel (to validate the label) [see goto]
'increment ontimerid
'use ontimerid to generate the jumper routine
'etc.


if len(layout$)=0 then layout$=l$ else layout$=layout$+sp+l$
layoutdone=1
GOTO finishedline
else

'establish whether sub a2$ exists using try
x=0
try = findid(a2$)
DO WHILE try
if id.subfunc=2 then x=1: exit do
IF try = 2 THEN findanotherid = 1: try = findid(a2$) ELSE try = 0
LOOP
if x=0 then a$="Expected GOSUB/sub":goto errmes

l$=l$+a2$ '*

print #24,"case "+str2$(ontimerid)+":"
print #24,rtrim$(id.callname)+"(";

if id.args>1 then a$="SUB requires more than one argument":goto errmes

if i>n then

if id.args=1 then a$="Expected argument after SUB":goto errmes
print #12,"0);"
print #24,");"

else

if id.args=0 then a$="SUB has no arguments":goto errmes

t=cvl(id.arg)
b=t and 511
if b=0 or (t and isarray)<>0 or (t and isfloat)<>0 or (t and isstring)<>0 or (t and isoffsetinbits)<>0 then a$="Only SUB arguments of integer-type allowed":goto errmes
if b=8 then ct$="int8"
if b=16 then ct$="int16"
if b=32 then ct$="int32"
if b=64 then ct$="int64"
if t and isunsigned then ct$="u"+ct$
print #24,"("+ct$+"*)&i64);"

e$=getelements$(ca$,i,n)
e$=fixoperationorder$(e$)
l$=l$+sp+tlayout$
e$=evaluatetotyp(e$,INTEGER64TYPE-ISPOINTER)
print #12,e$+");"

end if

print #24,"break;"
if len(layout$)=0 then layout$=l$ else layout$=layout$+sp+l$
layoutdone=1
GOTO finishedline
end if

end if
end if


'SHARED (SUB)
if n>=1 then
if firstelement$="SHARED" then
if n=1 then a$="Expected SHARED ...":goto errmes
i=2
if subfuncn=0 then a$="SHARED must be used within a SUB/FUNCTION":goto errmes



l$="SHARED"
subfuncshr:

'get variable name
n$=getelement$(ca$,i): i=i+1

if n$="" then a$="Expected SHARED variable-name":goto errmes

s$ = removesymbol(n$)
l2$=s$ 'either symbol or nothing

'array?
a=0
if getelement$(a$,i)="(" then
if getelement$(a$,i+1)<>")" then a$="Expected ()":goto errmes
i=i+2
a=1
l2$=l2$+sp2+"("+sp2+")"
end if

method=1

'specific type?
t$=""
ts$=""
t3$=""
if getelement$(a$,i)="AS" then
l2$=l2$+sp+"AS"
getshrtyp:
i=i+1
t2$=getelement$(a$,i)
if t2$<>"," and t2$<>"" then
if t$="" then t$=t2$ else t$=t$+" "+t2$
if t3$="" then t3$=t2$ else t3$=t3$+sp+t2$
goto getshrtyp
end if
if t$="" then a$="Expected AS type":goto errmes

t=typname2typ(t$)
if t and ISINCONVENTIONALMEMORY then t=t-ISINCONVENTIONALMEMORY
if t and ISPOINTER then t=t-ISPOINTER
if t and ISREFERENCE then t=t-ISREFERENCE
tsize=typname2typsize
method=0
if (t and ISUDT)=0 then ts$=type2symbol$(t$) else t3$=rtrim$(udtxcname(t AND 511))
l2$=l2$+sp+t3$

end if 'as

if len(s$)<>0 and len(t$)<>0 then a$="Expected symbol or AS type after variable name":goto errmes

'no symbol of type specified, apply default
if s$="" and t$="" then
IF LEFT$(n$, 1) = "_" THEN v = 27 ELSE v = ASC(ucase$(n$)) - 64
s$ = defineextaz(v)
end if

'switch to main module
oldsubfunc$=subfunc$
subfunc$ = ""
defdatahandle=18
close #13:open tmpdir$+"maindata.txt" for append as #13
close #19:open tmpdir$+"mainfree.txt" for append as #19

'use 'try' to locate the variable (if it already exists)
n2$=n$+s$+ts$ 'note: either ts$ or s$ will exist unless it is a UDT
try = findid(n2$)
DO WHILE try
if a then
'an array

if id.arraytype THEN
if len(t$)=0 then goto shrfound
t2=id.arraytype: t2size=id.tsize
if t2 and ISINCONVENTIONALMEMORY then t2=t2-ISINCONVENTIONALMEMORY
if t2 and ISPOINTER then t2=t2-ISPOINTER
if t2 and ISREFERENCE then t2=t2-ISREFERENCE
if t=t2 and tsize=t2size then goto shrfound
end if

else
'not an array

if id.t then
if len(t$)=0 then goto shrfound
t2=id.t: t2size=id.tsize
if t2 and ISINCONVENTIONALMEMORY then t2=t2-ISINCONVENTIONALMEMORY
if t2 and ISPOINTER then t2=t2-ISPOINTER
if t2 and ISREFERENCE then t2=t2-ISREFERENCE

if debug then print #9, "SHARED:comparing:";t;t2,tsize;t2size

if t=t2 and tsize=t2size then goto shrfound
end if

end if

IF try = 2 THEN findanotherid = 1: try = findid(n2$) ELSE try = 0
LOOP
'unknown variable
if a then a$="Array not defined":goto errmes
'create variable
if len(s$) then typ$=s$ else typ$=t$
retval=dim2(n$, typ$, method, "")
'note: variable created!

shrfound:
l$=l$+sp+rtrim$(id.cn)+l2$

ids(currentid).share=ids(currentid).share OR 2 'set as temporarily shared

'method must apply to the current sub/function regardless of how the variable was defined in 'main'
lmay=len(rtrim$(id.mayhave)): lmust=len(rtrim$(id.musthave))
if lmay<>0 or lmust<>0 then
if (method=1 and lmust=0) or (method=0 and lmay=0) then
revertmaymusthaven=revertmaymusthaven+1
revertmaymusthave(revertmaymusthaven)=currentid
swap ids(currentid).musthave,ids(currentid).mayhave
end if
end if

'switch back to sub/func
subfunc$=oldsubfunc$
defdatahandle=13
close #13:open tmpdir$+"data"+str2$(subfuncn)+".txt" for append as #13
close #19:open tmpdir$+"free"+str2$(subfuncn)+".txt" for append as #19

if getelement$(a$,i)="," then i=i+1: l$=l$+sp2+",": goto subfuncshr
if getelement$(a$,i)<>"" then a$="Expected ,":goto errmes

layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$
GOTO finishedline
end if
end if

'EXIT SUB/FUNCTION
IF n = 2 THEN
IF firstelement$ = "EXIT" THEN
sf = 0
IF secondelement$ = "FUNCTION" THEN sf = 1
IF secondelement$ = "SUB" THEN sf = 2
IF sf THEN
PRINT #12, "goto exit_subfunc;"
l$=firstelement$+sp+secondelement$
layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$
GOTO finishedline
END IF
END IF
END IF




'SWAP
IF firstelement$ = "SWAP" THEN
IF n < 4 THEN a$="Expected SWAP ... , ...":goto errmes
b = 0
ele = 1
e1$ = ""
e2$ = ""
FOR i = 2 TO n
e$ = getelement$(a$, i)
IF e$ = "(" THEN b = b + 1
IF e$ = ")" THEN b = b - 1
IF e$ = "," AND b = 0 THEN
IF ele = 2 THEN a$="Expected SWAP ... , ...":goto errmes
ele = 2
ELSE
IF ele = 1 THEN e1$ = e1$ + sp + e$ ELSE e2$ = e2$ + sp + e$
END IF
NEXT
IF e2$ = "" THEN a$="Expected SWAP ... , ...":goto errmes
e1$ = RIGHT$(e1$, LEN(e1$) - 1): e2$ = RIGHT$(e2$, LEN(e2$) - 1)

e1$ = fixoperationorder(e1$)
e1l$=tlayout$
e2$ = fixoperationorder(e2$)
e2l$=tlayout$
e1$ = evaluate(e1$, e1typ): e2$ = evaluate(e2$, e2typ)
IF (e1typ AND ISREFERENCE) = 0 OR (e2typ AND ISREFERENCE) = 0 THEN a$="Expected variable":goto errmes

layoutdone=1
l$="SWAP"+sp+e1l$+sp2+","+sp+e2l$
if len(layout$)=0 then layout$=l$ else layout$=layout$+sp+l$

'swap strings?
IF (e1typ AND ISSTRING) THEN
IF (e2typ AND ISSTRING) = 0 THEN a$="Type mismatch":goto errmes
e1$ = refer(e1$, e1typ, 0): e2$ = refer(e2$, e2typ, 0)
PRINT #12, "swap_string("+e1$+","+e2$+");"
GOTO finishedline
END IF

'swap UDT?
'note: entire UDTs, unlike thier elements cannot be swapped like standard variables
'      as UDT sizes may vary, and to avoid a malloc operation, QB64 should allocate a buffer
'      in global.txt for the purpose of swapping each UDT type

IF e1typ and ISUDT then
a$=e1$
'retrieve ID
i = INSTR(a$, "")
IF i THEN
idnumber = VAL(LEFT$(a$, i - 1)): a$ = RIGHT$(a$, LEN(a$) - i)
getid idnumber
u=VAL(a$)
i = INSTR(a$, ""): a$=right$(a$,len(a$)-i): e=VAL(a$)
i = INSTR(a$, ""): o$=right$(a$,len(a$)-i)
n$="UDT_"+rtrim$(id.n):if id.t=0 then n$="ARRAY_"+n$+"[0]"
if e=0 then 'not an element of UDT u
lhsscope$=scope$
e$ = e2$:t2=e2typ
if (t2 and ISUDT)=0 then a$="Expected SWAP with similar user defined type":goto errmes
idnumber2=VAL(e$)
getid idnumber2
n2$="UDT_"+rtrim$(id.n):if id.t=0 then n2$="ARRAY_"+n2$+"[0]"
i = INSTR(e$, ""): e$=right$(e$,len(e$)-i): u2=VAL(e$)
i = INSTR(e$, ""): e$=right$(e$,len(e$)-i): e2=VAL(e$)
i = INSTR(e$, ""): o2$=right$(e$,len(e$)-i)
'WARNING: u2 may need minor modifications based on e to see if they are the same
if u<>u2 or e2<>0 then a$="Expected SWAP with similar user defined type":goto errmes
dst$="(((char*)"+lhsscope$+n$+")+("+o$+"))"
src$="(((char*)"+scope$+n2$+")+("+o2$+"))"
b=udtxsize(u)\8
siz$=str2$(b)
if b=1 then print #12, "swap_8("+src$+","+dst$+");"
if b=2 then print #12, "swap_16("+src$+","+dst$+");"
if b=4 then print #12, "swap_32("+src$+","+dst$+");"
if b=8 then print #12, "swap_64("+src$+","+dst$+");"
if b<>1 and b<>2 and b<>4 and b<>8 then print #12, "swap_block("+src$+","+dst$+","+siz$+");"
GOTO finishedline
end if 'e=0
end if 'i
end if 'isudt

'cull irrelavent flags to make comparison possible
e1typc = e1typ
IF e1typc AND ISPOINTER THEN e1typc = e1typc - ISPOINTER
IF e1typc AND ISINCONVENTIONALMEMORY THEN e1typc = e1typc - ISINCONVENTIONALMEMORY
IF e1typc AND ISARRAY THEN e1typc = e1typc - ISARRAY
IF e1typc AND ISUNSIGNED THEN e1typc = e1typc - ISUNSIGNED
IF e1typc AND ISUDT THEN e1typc = e1typc - ISUDT
e2typc = e2typ
IF e2typc AND ISPOINTER THEN e2typc = e2typc - ISPOINTER
IF e2typc AND ISINCONVENTIONALMEMORY THEN e2typc = e2typc - ISINCONVENTIONALMEMORY
IF e2typc AND ISARRAY THEN e2typc = e2typc - ISARRAY
IF e2typc AND ISUNSIGNED THEN e2typc = e2typc - ISUNSIGNED
IF e2typc AND ISUDT THEN e2typc = e2typc - ISUDT
IF e1typc <> e2typc THEN a$="Type mismatch":goto errmes
t = e1typ
IF t AND ISOFFSETINBITS THEN a$="Cannot SWAP bit-length variables":goto errmes
b = t AND 511
t$=str2$(b): if b>64 then t$="longdouble"
PRINT #12, "swap_"+t$+"(&"+refer(e1$, e1typ, 0) + ",&"+refer(e2$, e2typ, 0)+");"
GOTO finishedline
END IF



'LSET/RSET
IF n >= 1 THEN
IF firstelement$ = "LSET" OR firstelement$ = "RSET" THEN
l$=firstelement$
dest$ = ""
source$ = ""
part = 1
i = 2
a3$ = ""
b = 0
DO
IF i > n THEN
IF part <> 2 OR a3$ = "" THEN x=1:goto errnum
source$ = a3$
EXIT DO
END IF
a2$ = getelement$(a$, i)
IF a2$ = "(" THEN b = b + 1
IF a2$ = ")" THEN b = b - 1
IF a2$ = "=" AND b = 0 THEN
IF part = 1 THEN dest$ = a3$: part = 2: a3$ = "": GOTO lrsetgotpart
END IF
IF LEN(a3$) THEN a3$ = a3$ + sp + a2$ ELSE a3$ = a2$
lrsetgotpart:
i = i + 1
LOOP
IF dest$ = "" THEN x=2:goto errnum
'check if it is a valid source string
f$ = fixoperationorder$(dest$)
l$=l$+sp+tlayout$+sp+"="
e$ = evaluate(f$, sourcetyp)
IF (sourcetyp AND ISREFERENCE) = 0 OR (sourcetyp AND ISSTRING) = 0 THEN x=3:goto errnum
dest$ = evaluatetotyp(f$, ISSTRING)
source$=fixoperationorder$(source$)
l$=l$+sp+tlayout$
layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$
source$=evaluatetotyp(source$,ISSTRING)
IF firstelement$ = "LSET" THEN
PRINT #12, "sub_lset(" + dest$ + "," + source$ + ");"
ELSE
PRINT #12, "sub_rset(" + dest$ + "," + source$ + ");"
END IF
GOTO finishedline
END IF
END IF

'ASC statement (fully inline)
IF n >= 1 THEN
IF firstelement$ = "ASC" THEN
IF getelement$(a$, 2) <> "(" THEN a$="Expected ( after ASC":goto errmes

'calculate 3 parts
useposition=0
part = 1
i = 3
a3$ = ""
stringvariable$ = ""
position$ = ""
b = 0
DO

IF i > n THEN 'got part 3
IF part <> 3 OR len(a3$) = 0 THEN a$="Expected ASC ( ... , ... ) = ...":goto errmes
expression$ = a3$
EXIT DO
END IF

a2$ = getelement$(ca$, i)
IF a2$ = "(" THEN b = b + 1
IF a2$ = ")" THEN b = b - 1

IF b = -1 THEN

IF part = 1 THEN 'eg. ASC(a$)=65
IF getelement$(a$, i + 1) <> "=" THEN a$="Expected =":goto errmes
stringvariable$ = a3$
position$ = "1"
part = 3: a3$ = "": i = i + 1: GOTO ascgotpart
END IF

IF part = 2 THEN 'eg. ASC(a$,i)=65
IF getelement$(a$, i + 1) <> "=" THEN a$="Expected =":goto errmes
useposition=1
position$ = a3$
part = 3: a3$ = "": i = i + 1: GOTO ascgotpart
END IF

'fall through, already in part 3

end if

IF a2$ = "," AND b = 0 THEN
IF part = 1 THEN stringvariable$ = a3$: part = 2: a3$ = "": GOTO ascgotpart
END IF

IF LEN(a3$) THEN a3$ = a3$ + sp + a2$ ELSE a3$ = a2$
ascgotpart:
i = i + 1
LOOP
IF len(stringvariable$) = 0 or len(position$)=0 THEN a$="Expected ASC ( ... , ... ) = ...":goto errmes

'validate stringvariable$
stringvariable$ = fixoperationorder$(stringvariable$)
l$="ASC"+sp2+"("+sp2+tlayout$

e$ = evaluate(stringvariable$, sourcetyp)
IF (sourcetyp AND ISREFERENCE) = 0 OR (sourcetyp AND ISSTRING) = 0 THEN a$="Expected ASC ( string-variable , ...":goto errmes
stringvariable$ = evaluatetotyp(stringvariable$, ISSTRING)



if position$="1" then
if useposition then l$=l$+sp2+","+sp+"1"+sp2+")"+sp+"=" else l$=l$+sp2+")"+sp+"="

PRINT #12, "tqbs="+stringvariable$+"; if (!new_error){"
e$=fixoperationorder$(expression$)
l$=l$+sp+tlayout$
e$=evaluatetotyp(e$,32&)
PRINT #12, "tmp_long="+e$+"; if (!new_error){"
print #12, "if (tqbs->len){tqbs->chr[0]=tmp_long;}else{error(5);}"
PRINT #12, "}}"

else

PRINT #12, "tqbs="+stringvariable$+"; if (!new_error){"
e$=fixoperationorder$(position$)
l$=l$+sp2+","+sp+tlayout$+sp2+")"+sp+"="
e$=evaluatetotyp(e$,32&)
PRINT #12, "tmp_fileno="+e$+"; if (!new_error){"
e$=fixoperationorder$(expression$)
l$=l$+sp+tlayout$
e$=evaluatetotyp(e$,32&)
PRINT #12, "tmp_long="+e$+"; if (!new_error){"
print #12, "if ((tmp_fileno>0)&&(tmp_fileno<=tqbs->len)){tqbs->chr[tmp_fileno-1]=tmp_long;}else{error(5);}"
PRINT #12, "}}}"

end if
layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$
GOTO finishedline
END IF
END IF




'MID$ statement
IF n >= 1 THEN
IF firstelement$ = "MID$" THEN
IF getelement$(a$, 2) <> "(" THEN x=4:goto errnum
'calculate 4 parts
length$ = ""
part = 1
i = 3
a3$ = ""
STRINGVARIABLE$ = ""
start$ = ""
b = 0
DO
IF i > n THEN
IF part <> 4 OR a3$ = "" THEN x=5:goto errnum
stringexpression$ = a3$
EXIT DO
END IF
a2$ = getelement$(ca$, i)
IF a2$ = "(" THEN b = b + 1
IF a2$ = ")" THEN b = b - 1
IF b = -1 THEN
IF part = 2 THEN
IF getelement$(a$, i + 1) <> "=" THEN x=6:goto errnum
start$ = a3$: part = 4: a3$ = "": i = i + 1: GOTO midgotpart
END IF
IF part = 3 THEN
IF getelement$(a$, i + 1) <> "=" THEN x=7:goto errnum
IF a3$ = "" THEN x=8:goto errnum
length$ = a3$: part = 4: a3$ = "": i = i + 1: GOTO midgotpart
END IF
END IF
IF a2$ = "," AND b = 0 THEN
IF part = 1 THEN STRINGVARIABLE$ = a3$: part = 2: a3$ = "": GOTO midgotpart
IF part = 2 THEN start$ = a3$: part = 3: a3$ = "": GOTO midgotpart
END IF
IF LEN(a3$) THEN a3$ = a3$ + sp + a2$ ELSE a3$ = a2$
midgotpart:
i = i + 1
LOOP
IF STRINGVARIABLE$ = "" THEN x=9:goto errnum
IF start$ = "" THEN x=10:goto errnum
'check if it is a valid source string
STRINGVARIABLE$ = fixoperationorder$(STRINGVARIABLE$)
l$="MID$"+sp2+"("+sp2+tlayout$
e$ = evaluate(STRINGVARIABLE$, sourcetyp)
IF (sourcetyp AND ISREFERENCE) = 0 OR (sourcetyp AND ISSTRING) = 0 THEN x=11:goto errnum
STRINGVARIABLE$ = evaluatetotyp(STRINGVARIABLE$, ISSTRING)

start$ = evaluatetotyp(fixoperationorder$(start$), 32&)
l$=l$+sp2+","+sp+tlayout$

stringexpression$=fixoperationorder$(stringexpression$)
l2$=tlayout$
stringexpression$ = evaluatetotyp(stringexpression$, ISSTRING)

IF LEN(length$) THEN
length$=fixoperationorder$(length$)
l$=l$+sp2+","+sp+tlayout$
length$ = evaluatetotyp(length$, 32&)
PRINT #12, "sub_mid(" + STRINGVARIABLE$ + "," + start$ + "," + length$ + "," + stringexpression$ + ",1);"
ELSE
PRINT #12, "sub_mid(" + STRINGVARIABLE$ + "," + start$ + ",0," + stringexpression$ + ",0);"
END IF

l$=l$+sp2+")"+sp+"="+sp+l2$
layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$
GOTO finishedline
END IF
END IF


IF n >= 2 THEN
IF firstelement$ = "ERASE" THEN
i = 2
l$="ERASE"
erasenextarray:
var$ = getelement$(ca$, i)
x$=var$: ls$=removesymbol(x$)
reattempterase:
try = findid(var$)
DO WHILE try
IF id.arraytype THEN
l$=l$+sp+rtrim$(id.cn)+ls$
'erase the array
clearerase:
n$ = RTRIM$(id.callname)
bytesperelement$ = str2((id.arraytype AND 511) \ 8)
IF id.arraytype AND ISSTRING THEN bytesperelement$ = str2(id.tsize)
IF id.arraytype AND ISOFFSETINBITS THEN bytesperelement$ = str2((id.arraytype AND 511)) + "/8+1"
if id.arraytype and ISUDT then
bytesperelement$=str2(udtxsize(id.arraytype AND 511)\8)
end if
PRINT #12, "if (" + n$ + "[2]&1){"'array is defined
PRINT #12, "if (" + n$ + "[2]&2){"'array is static
IF (id.arraytype AND ISSTRING) <> 0 AND (id.arraytype AND ISFIXEDLENGTH) = 0 THEN
 PRINT #12, "tmp_long=";
 FOR i2 = 1 TO abs(id.arrayelements)
 IF i2 <> 1 THEN PRINT #12, "*";
 PRINT #12, n$ + "[" + str2(i2 * 4 - 4 + 5) + "]";
 NEXT
 PRINT #12, ";"
 PRINT #12, "while(tmp_long--){"
 PRINT #12, "((qbs*)(((uint64*)(" + n$ + "[0]))[tmp_long]))->len=0;"
 PRINT #12, "}"
ELSE
 'numeric
 'clear array
 PRINT #12, "memset((void*)(" + n$ + "[0]),0,";
 FOR i2 = 1 TO abs(id.arrayelements)
 IF i2 <> 1 THEN PRINT #12, "*";
 PRINT #12, n$ + "[" + str2(i2 * 4 - 4 + 5) + "]";
 NEXT
 PRINT #12, "*" + bytesperelement$ + ");"
END IF
PRINT #12, "}else{"'array is dynamic
'1. free memory & any allocated strings
IF (id.arraytype AND ISSTRING) <> 0 AND (id.arraytype AND ISFIXEDLENGTH) = 0 THEN
 'free strings
 PRINT #12, "tmp_long=";
 FOR i2 = 1 TO abs(id.arrayelements)
 IF i2 <> 1 THEN PRINT #12, "*";
 PRINT #12, n$ + "[" + str2(i2 * 4 - 4 + 5) + "]";
 NEXT
 PRINT #12, ";"
 PRINT #12, "while(tmp_long--){"
 PRINT #12, "qbs_free((qbs*)(((uint64*)(" + n$ + "[0]))[tmp_long]));"
 PRINT #12, "}"
 'free memory
 PRINT #12, "free((void*)(" + n$ + "[0]));"
ELSE
 'free memory
 PRINT #12, "if (" + n$ + "[2]&4){"'cmem array
 PRINT #12, "cmem_dynamic_free((unsigned char*)(" + n$ + "[0]));"
 PRINT #12, "}else{"'non-cmem array
 PRINT #12, "free((void*)(" + n$ + "[0]));"
 PRINT #12, "}"
END IF
'2. set array (and its elements) as undefined
PRINT #12, n$ + "[2]^=1;" 'remove defined flag, keeping other flags (such as cmem)
'set dimensions as undefined
FOR i2 = 1 TO abs(id.arrayelements)
b = i2 * 4
PRINT #12, n$ + "[" + str2(b) + "]=2147483647;"'base
PRINT #12, n$ + "[" + str2(b + 1) + "]=0;"'num. index
PRINT #12, n$ + "[" + str2(b + 2) + "]=0;"'multiplier
NEXT
IF (id.arraytype AND ISSTRING) <> 0 AND (id.arraytype AND ISFIXEDLENGTH) = 0 THEN
PRINT #12, n$ + "[0]=(long)&nothingstring;"
ELSE
PRINT #12, n$ + "[0]=(unsigned long)nothingvalue;"
END IF
PRINT #12, "}"'static/dynamic
PRINT #12, "}"'array is defined
if clearerasereturn=1 then clearerasereturn=0: goto clearerasereturned
GOTO erasedarray
END IF
IF try = 2 THEN findanotherid = 1: try = findid(var$) ELSE try = 0
LOOP

'add extension (if possible) as retry
IF isvalidvariable(var$) THEN
dtyp$ = removesymbol(var$)
IF dtyp$ = "" THEN
IF LEFT$(var$, 1) = "_" THEN v = 27 ELSE v = ASC(ucase$(var$)) - 64
're-attempt array erase
var$ = var$ + defineextaz(v)
GOTO reattempterase
END IF
END IF

x=32:goto errnum

erasedarray:
IF i < n THEN
i = i + 1: n$ = getelement$(a$, i): IF n$ <> "," THEN x=33:goto errnum
l$=l$+sp2+","
i = i + 1: IF i > n THEN x=34:goto errnum
GOTO erasenextarray
END IF

layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$
GOTO finishedline
END IF
END IF


'DIM/REDIM/STATIC
if n>=2 then
dimoption=0: redimoption=0: commonoption=0
if firstelement$="DIM" then dimoption=1
if firstelement$="REDIM" then
dimoption=2: redimoption = 1
if secondelement$="_PRESERVE" then
redimoption = 2
if n=2 then a$="Expected REDIM _PRESERVE ...":goto errmes
end if
end if
if firstelement$="STATIC" then dimoption=3
if firstelement$="COMMON" then dimoption=1: commonoption=1
if dimoption then
l$=firstelement$

if dimoption=3 and subfuncn=0 then a$="STATIC must be used within a SUB/FUNCTION":goto errmes
if commonoption=1 and subfuncn<>0 then a$="COMMON cannot be used within a SUB/FUNCTION":goto errmes

i = 2
if redimoption = 2 then i=3: l$=l$+sp+"_PRESERVE"

if dimoption<>3 then 'shared cannot be static
a2$ = getelement(a$, i)
IF a2$ = "SHARED" THEN
if subfuncn<>0 then a$="DIM/REDIM SHARED invalid within a SUB/FUNCTION":goto errmes
dimshared = 1
i = i + 1
l$=l$+sp+a2$
END IF
end if

if dimoption=3 then dimstatic=1

dimnext:

listarray=0


'old chain code
'chaincommonarray=0

varname$ = getelement(ca$, i): i = i + 1
if varname$="" then a$="Expected variable-name":goto errmes

'get the next element
IF i >= n + 1 THEN e$ = "" ELSE e$ = getelement(a$, i): i = i + 1

'check if next element is a ( to create an array
elements$ = ""

IF e$ = "(" THEN
b = 1
for i=i to n
e$=getelement(ca$, i)
IF e$ = "(" THEN b = b + 1
IF e$ = ")" THEN b = b - 1
if b=0 then exit for
if len(elements$) then elements$ = elements$ + sp + e$ else elements$=e$
next
if b<>0 then a$="Expected )":goto errmes
i=i+1 'set i to point to the next element

if commonoption then elements$="?"


if debug then print #9,"DIM2:array:elements$:["+elements$+"]"

'arrayname() means list array to it will automatically be static when it is formally dimensioned later
'note: listed arrays are always created in dynamic memory, but their contents are not erased
'      this differs from static arrays from SUB...STATIC and the unique QB64 method -> STATIC arrayname(100)
if dimoption=3 then 'STATIC
if len(elements$)=0 then
listarray=1
end if
end if

'last element was ")"
'get next element
IF i >= n + 1 THEN e$ = "" ELSE e$ = getelement(a$, i): i = i + 1
END IF 'e$="("
d$ = e$

dimmethod = 0

appendname$="" 'the symbol to append to name returned by dim2
appendtype$="" 'eg. sp+AS+spINTEGER
dim2typepassback$=""

'does varname have an appended symbol?
s$ = removesymbol$(varname$)
IF s$ <> "" THEN
typ$ = s$
dimmethod = 1
appendname$=typ$
GOTO dimgottyp
END IF

IF d$ = "AS" THEN

appendtype$=sp+"AS"
typ$ = ""
FOR i = i TO n
d$ = getelement(a$, i)
IF d$ = "," THEN i = i + 1: EXIT FOR
typ$ = typ$ + d$ + " "
appendtype$=appendtype$+sp+d$
d$ = ""
NEXT
appendtype$=ucase$(appendtype$) 'capitalise default types (udt override this later if necessary)
typ$ = RTRIM$(typ$)
GOTO dimgottyp
END IF

'auto-define type based on name
IF LEFT$(varname$, 1) = "_" THEN v = 27 ELSE v = ASC(ucase$(varname$)) - 64
typ$ = defineaz(v)
dimmethod = 1
GOTO dimgottyp
dimgottyp:
IF d$ <> "" AND d$ <> "," THEN x=35:goto errnum



if listarray then 'eg. STATIC a()
'note: static list arrays cannot be created until they are formally (RE)DIM'd later
if len(staticarraylist) then staticarraylist=staticarraylist+sp
staticarraylist=staticarraylist+varname$+sp+symbol2fulltypename$(typ$)+sp+str2(dimmethod)
staticarraylistn=staticarraylistn+1
l$=l$+sp+varname$+appendname$+sp2+"("+sp2+")"+appendtype$
'note: none of the following code is run, dim2 call is also skipped

else

olddimstatic=dimstatic

'check if varname is on the static list
if len(elements$) then 'it's an array
if subfuncn then 'it's in a sub/function
xi=1
for x=1 to staticarraylistn
varname2$=getelement$(staticarraylist,xi):xi=xi+1
typ2$=getelement$(staticarraylist,xi):xi=xi+1
dimmethod2=val(getelement$(staticarraylist,xi)):xi=xi+1
'check if they are similar
if ucase$(varname$)=ucase$(varname2$) then
if symbol2fulltypename$(typ$)=typ2$ then
if dimmethod=dimmethod2 then
'match found!
varname$=varname2$
dimstatic=3
if dimoption=3 then a$="Array already listed as STATIC":goto errmes
end if
end if 'typ
end if 'varname
next
end if
end if

'COMMON exception
'note: COMMON alone does not imply SHARED
'      if either(or both) COMMON & later DIM have SHARED, variable becomes shared
if commonoption then
if len(elements$) then
	'add array to list
	if len(commonarraylist) then commonarraylist=commonarraylist+sp
	'note: dimmethod distinguishes between a%(...) vs a(...) AS INTEGER
	commonarraylist=commonarraylist+varname$+sp+symbol2fulltypename$(typ$)+sp+str2(dimmethod)+sp+str2(dimshared)
	commonarraylistn=commonarraylistn+1
        if debug then print #9, "common listed:"+varname$+sp+symbol2fulltypename$(typ$)+sp+str2(dimmethod)+sp+str2(dimshared)
'	tlayout$=varname$+sp+"("+sp2+")"

'note: elements$="?"

'note: the following code only adds include directives, everything else is defered

x=idn+1 'the id number of the array

OPEN tmpdir$ + "chain.txt" FOR APPEND AS #22
'include directive
print #22, "#include " + CHR$(34) + "chain" + str2$(x) + ".txt" + CHR$(34)
close #22
'create/clear include file
open tmpdir$ + "chain" + str2$(x) + ".txt" for output as #22:close #22

OPEN tmpdir$ + "inpchain.txt" FOR APPEND AS #22
'include directive
print #22, "#include " + CHR$(34) + "inpchain" + str2$(x) + ".txt" + CHR$(34)
close #22
'create/clear include file
open tmpdir$ + "inpchain" + str2$(x) + ".txt" for output as #22:close #22

goto dimcommonarray



'old chain code
''add #include to chain.txt & inpchain.txt:
'
'OPEN tmpdir$ + "chain.txt" FOR APPEND AS #22
'
''add array place-holder
'print #22,"int32val=2;" 'array place-holder
'print #22,"sub_put(FF,NULL,byte_element((uint64)&int32val,4),0);"
'
'PRINT #22, "#include " + CHR$(34) + "chain" + str2$(commonarraylistn) + ".txt" + CHR$(34)
'
'CLOSE #22
'open tmpdir$ + "chain" + str2$(commonarraylistn) + ".txt" for output as #22:close #22
'
'OPEN tmpdir$ + "inpchain.txt" FOR APPEND AS #23
'PRINT #23, "#include " + CHR$(34) + "inpchain" + str2$(commonarraylistn) + ".txt" + CHR$(34)
'CLOSE #23
'open tmpdir$ + "inpchain" + str2$(commonarraylistn) + ".txt" for output as #23:close #23



'create an array with one element
'redirect output of creator to dump file





'goto commonarraylisted
end if
end if

'is varname on common list?
'******
if len(elements$) then 'it's an array
if subfuncn=0 then 'not in a sub/function

if debug then print #9, "common checking:"+varname$

xi=1
for x=1 to commonarraylistn
varname2$=getelement$(commonarraylist,xi):xi=xi+1
typ2$=getelement$(commonarraylist,xi):xi=xi+1
dimmethod2=val(getelement$(commonarraylist,xi)):xi=xi+1
dimshared2=val(getelement$(commonarraylist,xi)):xi=xi+1
if debug then print #9, "common checking against:"+varname2$+sp+typ2$+sp+str2(dimmethod2)+sp+str2(dimshared2)
'check if they are similar
if varname$=varname2$ then
if symbol2fulltypename$(typ$)=typ2$ then
if dimmethod=dimmethod2 then

'match found!
'enforce shared status (if necessary)
if dimshared2 then dimshared = dimshared+2 'temp force SHARED

'old chain code
'chaincommonarray=x

end if 'method
end if 'typ
end if 'varname
next
end if
end if

dimcommonarray:

retval = dim2(varname$, typ$, dimmethod, elements$)
if dimshared>=2 then dimshared=dimshared-2

'non-array COMMON variable
if commonoption<>0 and len(elements$)=0 then

'CHAIN.TXT (save)

'switch output from main.txt to chain.txt
close #12
OPEN tmpdir$ + "chain.txt" FOR APPEND AS #12
l2$=tlayout$

print #12,"int32val=1;" 'simple variable
print #12,"sub_put(FF,NULL,byte_element((uint64)&int32val,4),0);"

t=id.t
bits=t and 511
if t and ISUDT then bits=udtxsize(t and 511)
if t and ISSTRING then
if t and ISFIXEDLENGTH then
bits=id.tsize*8
else
print #12,"int64val=__STRING_"+rtrim$(id.n)+"->len*8;"
bits=0
end if
end if

if bits then
print #12,"int64val="+str2$(bits)+";" 'size in bits
end if
print #12,"sub_put(FF,NULL,byte_element((uint64)&int64val,8),0);"

'put the variable
e$=rtrim$(id.n)

if (t and ISUDT)=0 then
if t and ISFIXEDLENGTH then
e$=e$+"$"+str2$(id.tsize)
else
e$=e$+typevalue2symbol$(t)
end if
end if
e$=evaluatetotyp(fixoperationorder$(e$),-4)

print #12,"sub_put(FF,NULL,"+e$+",0);"

tlayout$=l2$
'revert output to main.txt
close #12
OPEN tmpdir$ + "main.txt" FOR APPEND AS #12


'INPCHAIN.TXT (load)

'switch output from main.txt to chain.txt
close #12
OPEN tmpdir$ + "inpchain.txt" FOR APPEND AS #12
l2$=tlayout$


print #12,"if (int32val==1){"
'get the size in bits
print #12,"sub_get(FF,NULL,byte_element((uint64)&int64val,8),0);"
'***assume correct size***

e$=rtrim$(id.n)
t=id.t
if (t and ISUDT)=0 then
if t and ISFIXEDLENGTH then
e$=e$+"$"+str2$(id.tsize)
else
e$=e$+typevalue2symbol$(t)
end if
end if

if t and ISSTRING then
if (t and ISFIXEDLENGTH)=0 then
print #12,"tqbs=qbs_new(int64val>>3,1);"
print #12,"qbs_set(__STRING_"+rtrim$(id.n)+",tqbs);"
'now that the string is the correct size, the following GET command will work correctly...
end if
end if

e$=evaluatetotyp(fixoperationorder$(e$),-4)
print #12,"sub_get(FF,NULL,"+e$+",0);"

print #12,"sub_get(FF,NULL,byte_element((uint64)&int32val,4),0);" 'get next command
print #12,"}"

tlayout$=l2$
'revert output to main.txt
close #12
OPEN tmpdir$ + "main.txt" FOR APPEND AS #12






end if

commonarraylisted:

n2=numelements(tlayout$)
l$=l$+sp+getelement$(tlayout$,1)+appendname$
if n2>1 then
l$=l$+sp2+getelements$(tlayout$,2,n2)
end if

if len(appendtype$) then
if len(dim2typepassback$) then appendtype$=sp+"AS"+sp+dim2typepassback$
l$=l$+appendtype$
end if

'modify first element name to include symbol

dimstatic=olddimstatic

end if 'listarray=0


IF d$ = "," then l$=l$+sp2+",":GOTO dimnext

dimshared = 0
redimoption=0
if dimstatic=1 then dimstatic=0

layoutdone=1
if len(layout$)=0 then layout$=l$ else layout$=layout$+sp+l$

GOTO finishedline
END IF
END IF











'THEN [GOTO] linenumber?
IF THENGOTO = 1 THEN
IF n = 1 THEN
l$=""
a = ASC(LEFT$(firstelement$, 1))
IF a = 46 OR (a >= 48 AND a <= 57) THEN a2$ = ca$: GOTO THENGOTO
END IF
END IF

'goto
IF n = 2 THEN
IF getelement$(a$, 1) = "GOTO" THEN
l$="GOTO"
a2$ = getelement$(ca$, 2)
THENGOTO:
IF validlabel(a2$) = 0 THEN x=36:goto errnum
if len(l$) then l$=l$+sp+tlayout$ else l$=tlayout$
layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$
PRINT #12, "goto LABEL_" + a2$ + ";"
GOTO finishedline
END IF
END IF



if firstelement$ = "RUN" then 'RUN
l$="RUN"
if n=1 then
'no parameters
print #12,"sub_run_init();" 'note: called first to free up screen-locked image handles
print #12,"sub_clear(NULL,NULL);" 'use functionality of CLEAR
if len(subfunc$) then
	print #12,"QBMAIN(NULL);"
else
	print #12,"goto S_0;"
end if
else
'parameter passed
e$=getelements$(ca$, 2, n)
e$=fixoperationorder$(e$)
l2$=tlayout$
ignore$=evaluate(e$,typ)
if n=2 and ((typ and ISSTRING)=0) then
 'assume it's a label or line number
 lbl$ = getelement$(ca$, 2)
 IF validlabel(lbl$) = 0 THEN x=36:goto errnum  'invalid label
 l$=l$+sp+tlayout$
 print #12,"sub_run_init();" 'note: called first to free up screen-locked image handles
 print #12,"sub_clear(NULL,NULL);" 'use functionality of CLEAR
 if len(subfunc$) then
	print #21,"if (run_from_line=="+str2(nextrunlineindex)+"){run_from_line=0;goto LABEL_" + lbl$ + ";}"
	print #12,"run_from_line="+str2(nextrunlineindex)+";"
	nextrunlineindex=nextrunlineindex+1
	print #12,"QBMAIN(NULL);"
 else
	print #12,"goto LABEL_" + lbl$ + ";"
 end if
else
 'assume it's a string containing a filename to execute
 e$ = evaluatetotyp(e$,ISSTRING)
 print #12,"sub_run("+e$+");"
 l$=l$+sp+l2$
end if 'isstring
end if 'n=1
layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$
GOTO finishedline
end if 'run

'KEY OFF (stub)
if n=2 then
if firstelement$ = "KEY" then
if getelement$(a$, 2)="OFF" then
l$="KEY"+sp+"OFF"
layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$
goto finishedline
end if
end if
end if '2

'note: ABSOLUTE cannot be used without CALL
cispecial=0
IF n > 1 THEN
if firstelement$="INTERRUPT" or firstelement$="INTERRUPTX" then
a$="CALL"+sp+firstelement$+sp+"("+sp+getelements$(a$, 2, n)+sp+")"
ca$="CALL"+sp+firstelement$+sp+"("+sp+getelements$(ca$, 2, n)+sp+")"
n=n+3
firstelement$="CALL"
cispecial=1
'fall through
end if
end if

usecall=0
IF firstelement$ = "CALL" THEN
usecall=1
IF n = 1 THEN a$="Expected CALL sub-name [(...)]":goto errmes
cn$ = getelement$(ca$, 2): n$=ucase$(cn$)

IF n > 2 THEN

IF n <= 4 THEN a$="Expected CALL sub-name (...)":goto errmes
IF getelement$(a$, 3) <> "(" OR getelement$(a$, n) <> ")" THEN a$="Expected CALL sub-name (...)":goto errmes
a$ = n$ + sp + getelements$(a$, 4, n - 1)
ca$ = cn$ + sp + getelements$(ca$, 4, n - 1)


if n$="INTERRUPT" or n$="INTERRUPTX" then 'assume CALL INTERRUPT[X] request
'print "CI: call interrupt command reached":sleep 1
if n$="INTERRUPT" then print #12,"call_interrupt("; else print #12,"call_interruptx(";
argn=0
n = numelements(a$)
b=0
e$=""
for i=2 to n
e2$=getelement$(ca$,i)
if e2$="(" then b=b+1
if e2$=")" then b=b-1
if (e2$="," and b=0) or i=n then
if i=n then
 if e$="" then e$=e2$ else e$=e$+sp+e2$
end if
argn=argn+1
if argn=1 then 'interrupt number
e$=fixoperationorder$(e$)
l$="CALL"+sp+n$+sp2+"("+sp2+tlayout$
if cispecial=1 then l$=n$+sp+tlayout$
e$=evaluatetotyp(e$,64&)
'print "CI: evaluated interrupt number as ["+e$+"]":sleep 1
print #12,e$;
end if
if argn=2 or argn=3 then 'inregs, outregs
e$ = fixoperationorder$(e$)
l$=l$+sp2+","+sp+tlayout$
e2$=e$
e$ = evaluatetotyp(e$,-2) 'offset+size
'print "CI: evaluated in/out regs ["+e2$+"] as ["+e$+"]":sleep 1
print #12,","+e$;
end if
e$=""
else
if e$="" then e$=e2$ else e$=e$+sp+e2$
end if
next
if argn<>3 then a$="Expected CALL INTERRUPT (interrupt-no, inregs, outregs)":goto errmes
print #12,");"
if cispecial=0 then l$=l$+sp2+")"
layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$
'print "CI: done":sleep 1
GOTO finishedline
end if 'call interrupt








'call to CALL ABSOLUTE beyond reasonable doubt
if n$="ABSOLUTE" then
l$="CALL"+sp+"ABSOLUTE"+sp2+"("+sp2
argn=0
n = numelements(a$)
b=0
e$=""
for i=2 to n
e2$=getelement$(ca$,i)
if e2$="(" then b=b+1
if e2$=")" then b=b-1
if (e2$="," and b=0) or i=n then
if i<n then
if e$="" then a$="Expected expression before , or )":goto errmes
'1. variable or value?
e$=fixoperationorder$(e$)
l$=l$+tlayout$+sp2+","+sp
ignore$=evaluate(e$,typ)

if (typ and ISPOINTER)<>0 and (typ and ISREFERENCE)<>0 then

 'assume standard variable
 'assume not string/array/udt/etc
 e$="VARPTR"+sp+"("+sp+e$+sp+")"
 e$=evaluatetotyp(e$,UINTEGERTYPE-ISPOINTER)

else

'assume not string
'single, double or integer64?
if typ and ISFLOAT then
 if (typ and 511)=32 then
  e$=evaluatetotyp(e$,SINGLETYPE-ISPOINTER)
        v$ = "pass" + str2$(uniquenumber)
	PRINT #defdatahandle, "float *" + v$ + "=NULL;"
	PRINT #13, "if(" + v$ + "==NULL){"
	PRINT #13, "cmem_sp-=4;"
	PRINT #13, v$ + "=(float*)(dblock+cmem_sp);"
	PRINT #13, "if (cmem_sp<qbs_cmem_sp) error(257);"
	PRINT #13, "}"
  e$ = "(uint16)(((unsigned char*)&(*" + v$ + "=" + e$+"))-((unsigned char*)dblock))"
 else
  e$=evaluatetotyp(e$,DOUBLETYPE-ISPOINTER)
        v$ = "pass" + str2$(uniquenumber)
	PRINT #defdatahandle, "double *" + v$ + "=NULL;"
	PRINT #13, "if(" + v$ + "==NULL){"
	PRINT #13, "cmem_sp-=8;"
	PRINT #13, v$ + "=(double*)(dblock+cmem_sp);"
	PRINT #13, "if (cmem_sp<qbs_cmem_sp) error(257);"
	PRINT #13, "}"
  e$ = "(uint16)(((unsigned char*)&(*" + v$ + "=" + e$+"))-((unsigned char*)dblock))"
 end if
else
 e$=evaluatetotyp(e$,INTEGER64TYPE-ISPOINTER)
        v$ = "pass" + str2$(uniquenumber)
	PRINT #defdatahandle, "int64 *" + v$ + "=NULL;"
	PRINT #13, "if(" + v$ + "==NULL){"
	PRINT #13, "cmem_sp-=8;"
	PRINT #13, v$ + "=(int64*)(dblock+cmem_sp);"
	PRINT #13, "if (cmem_sp<qbs_cmem_sp) error(257);"
	PRINT #13, "}"
 e$ = "(uint16)(((unsigned char*)&(*" + v$ + "=" + e$+"))-((unsigned char*)dblock))"
end if

end if

print #12,"call_absolute_offsets["+str2$(argn)+"]="+e$+";"
else
if e$="" then e$=e2$ else e$=e$+sp+e2$
e$=fixoperationorder(e$)
l$=l$+tlayout$+sp2+")"
e$=evaluatetotyp(e$,UINTEGERTYPE-ISPOINTER)
print #12,"call_absolute("+str2$(argn)+","+e$+");"
end if
argn=argn+1
e$=""
else
if e$="" then e$=e2$ else e$=e$+sp+e2$
end if
next
layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$
GOTO finishedline
end if

ELSE 'n>2

a$ = n$
ca$ = cn$
usecall=2

END IF 'n>2

n = numelements(a$)
firstelement$ = getelement$(a$, 1)

'valid SUB name
validsub = 0
findidsecondarg = "": IF n >= 2 THEN findidsecondarg = getelement$(a$, 2)
try = findid(firstelement$)
DO WHILE try
IF id.subfunc = 2 THEN validsub = 1: EXIT DO
IF try = 2 THEN
findidsecondarg = "": IF n >= 2 THEN findidsecondarg = getelement$(a$, 2)
findanotherid = 1
try = findid(firstelement$)
ELSE
try = 0
END IF
LOOP
IF validsub = 0 THEN a$="Expected CALL sub-name [(...)]":goto errmes
END IF

'sub?
IF n >= 1 THEN

if firstelement$="?" then firstelement$="PRINT"

findidsecondarg = "": IF n >= 2 THEN findidsecondarg = getelement$(a$, 2)

try = findid(firstelement$)
DO WHILE try
IF id.subfunc = 2 THEN

'IF findid(firstelement$) THEN
'IF id.subfunc = 2 THEN


IF firstelement$ = "CLOSE" OR firstelement$ = "RESET" THEN
IF firstelement$ = "RESET" THEN
IF n > 1 THEN a$="Syntax error":goto errmes
END IF
l$=firstelement$
IF n = 1 THEN
PRINT #12, "sub_close(NULL,0);"'closes all files
ELSE
l$=l$+sp
b = 0
s = 0
a3$ = ""
FOR x = 2 TO n
a2$ = getelement$(ca$, x)
IF a2$ = "(" THEN b = b + 1
IF a2$ = ")" THEN b = b - 1
IF a2$ = "#" AND b = 0 THEN
IF s = 0 THEN s = 1 ELSE x=37:goto errnum
l$=l$+"#"+sp2
GOTO closenexta
END IF

IF a2$ = "," AND b = 0 THEN
IF s = 2 THEN
e$=fixoperationorder$(a3$)
l$=l$+tlayout$+sp2+","+sp
e$ = evaluatetotyp(e$, 64&)
PRINT #12, "sub_close(" + e$ + ",1);"
a3$ = ""
s = 0
GOTO closenexta
ELSE
x=38:goto errnum
END IF
END IF

s = 2
IF a3$ = "" THEN a3$ = a2$ ELSE a3$ = a3$ + sp + a2$

closenexta:
NEXT

IF s = 2 THEN
e$=fixoperationorder$(a3$)
l$=l$+tlayout$
e$ = evaluatetotyp(e$, 64&)
PRINT #12, "sub_close(" + e$ + ",1);"
else
l$=left$(l$,len(l$)-1)
END IF

END IF
layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$
GOTO finishedline
END IF 'close
















'data, restore, read
IF firstelement$ = "READ" THEN 'file input
xread ca$, n
'note: layout done in xread sub
GOTO finishedline
END IF 'read





































lineinput=0
IF n >= 2 THEN
IF firstelement$ = "LINE" AND secondelement$ = "INPUT" THEN
lineinput = 1
a$=right$(a$,len(a$)-5):ca$=right$(ca$,len(ca$)-5): n = n - 1 'remove "LINE"
firstelement$="INPUT"
END IF
END IF

IF firstelement$ = "INPUT" THEN 'file input
IF n > 1 THEN
IF getelement$(a$, 2) = "#" THEN
l$="INPUT"+sp+"#": if lineinput then l$="LINE"+sp+l$

u$=str2$(uniquenumber)
'which file?
IF n = 2 THEN x=43:goto errnum
a3$ = ""
b = 0
FOR i = 3 TO n
a2$ = getelement$(ca$, i)
IF a2$ = "(" THEN b = b + 1
IF a2$ = ")" THEN b = b - 1
IF a2$ = "," AND b = 0 THEN
IF a3$ = "" THEN x=44:goto errnum
GOTO inputgotfn
END IF
IF a3$ = "" THEN a3$ = a2$ ELSE a3$ = a3$ + sp + a2$
NEXT
inputgotfn:
e$=fixoperationorder$(a3$)
l$=l$+sp2+tlayout$
e$ = evaluatetotyp(e$, 64&)
PRINT #12, "tmp_fileno=" + e$ + ";"
PRINT #12, "if (new_error) goto skip"+u$+";"
i = i + 1
IF i > n THEN x=45:goto errnum
a3$ = ""
b = 0
FOR i = i TO n
a2$ = getelement$(ca$, i)
IF a2$ = "(" THEN b = b + 1
IF a2$ = ")" THEN b = b - 1
IF i = n THEN
IF a3$ = "" THEN a3$ = a2$ ELSE a3$ = a3$ + sp + a2$
a2$ = ",": b = 0
END IF
IF a2$ = "," AND b = 0 THEN
IF a3$ = "" THEN x=46:goto errnum
e$ = fixoperationorder$(a3$)
l$=l$+sp2+","+sp+tlayout$
e$ = evaluate(e$, t)
IF (t AND ISREFERENCE) = 0 THEN x=47:goto errnum
IF (t AND ISSTRING) THEN
 e$ = refer(e$, t, 0)
 IF lineinput THEN
 PRINT #12, "sub_file_line_input_string(tmp_fileno," + e$ + ");"
 PRINT #12, "if (new_error) goto skip"+u$+";"
 ELSE
 PRINT #12, "sub_file_input_string(tmp_fileno," + e$ + ");"
 PRINT #12, "if (new_error) goto skip"+u$+";"
 END IF
 stringprocessinghappened = 1
ELSE
 IF lineinput THEN a$="Expected string-variable":goto errmes
 'not a string!
 'e$ = refer(e$, t, 1)
 '***INPORTANT NOTE: Modify t for non-0 bit offsets found in UDTs & arrays too
 t2 = t
 IF (t2 AND ISPOINTER) THEN t2 = t2 - ISPOINTER
 IF (t2 AND ISINCONVENTIONALMEMORY) THEN t2 = t2 - ISINCONVENTIONALMEMORY
 IF (t2 AND ISREFERENCE) THEN t2 = t2 - ISREFERENCE
 'PRINT #12, "sub_file_input_value(tmp_long," + str2(t) + "," + e$ + ");"
IF (t AND 511) = 64 THEN
 IF (t AND ISUNSIGNED) THEN
 setrefer e$, t, "func_file_input_uint64(tmp_fileno)", 1
 ELSE
 setrefer e$, t, "func_file_input_int64(tmp_fileno)", 1
 END IF
ELSE
setrefer e$, t, "func_file_input_float(tmp_fileno," + str2(t) + ")", 1
END IF
PRINT #12, "if (new_error) goto skip"+u$+";"
END IF
IF i = n THEN EXIT FOR
IF lineinput THEN a$="Too many variables":goto errmes
a3$ = "": a2$ = ""
END IF
IF a3$ = "" THEN a3$ = a2$ ELSE a3$ = a3$ + sp + a2$
NEXT
PRINT #12, "skip"+u$+":"
PRINT #12, "revert_input_check();"
IF stringprocessinghappened THEN PRINT #12, cleanupstringprocessingcall$ + "0);"
layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$
GOTO finishedline
END IF
END IF
END IF 'input#


IF firstelement$ = "INPUT" THEN
l$="INPUT": if lineinput then l$="LINE"+sp+l$
commaneeded = 0
i = 2

newline = 1: IF getelement$(a$, i) = ";" THEN newline = 0: i = i + 1:l$=l$+sp+";"

a2$ = getelement$(ca$, i)
IF LEFT$(a2$, 1) = CHR$(34) THEN
e$ = fixoperationorder$(a2$): l$=l$+sp+tlayout$
PRINT #12, "qbs_print(qbs_new_txt_len(" + a2$ + "),0);"
i = i + 1
'MUST be followed by a ; or ,
a2$ = getelement$(ca$, i)
i = i + 1
l$=l$+sp2+a2$
IF a2$ = ";" THEN
IF lineinput THEN GOTO finishedpromptstring
PRINT #12, "qbs_print(qbs_new_txt(" + CHR$(34) + "? " + CHR$(34) + "),0);"
GOTO finishedpromptstring
END IF
IF a2$ = "," THEN
GOTO finishedpromptstring
END IF
x=48:goto errnum
END IF
'there was no promptstring, so print a ?
PRINT #12, "qbs_print(qbs_new_txt(" + CHR$(34) + "? " + CHR$(34) + "),0);"
finishedpromptstring:
numvar = 0
FOR i = i TO n
IF commaneeded = 1 THEN
a2$ = getelement$(ca$, i)
IF a2$ <> "," THEN x=49:goto errnum
ELSE

b = 0
e$ = ""
FOR i2 = i TO n
e2$ = getelement$(ca$, i2)
IF e2$ = "(" THEN b = b + 1
IF e2$ = ")" THEN b = b - 1
IF e2$ = "," AND b = 0 THEN i2 = i2 - 1: EXIT FOR
e$ = e$ + sp + e2$
NEXT
i = i2: IF i > n THEN i = n
IF e$ = "" THEN a$="Expected variable":goto errmes
e$ = RIGHT$(e$, LEN(e$) - 1)
e$ = fixoperationorder$(e$)
l$=l$+sp+tlayout$: if i<>n then l$=l$+sp2+","
e$ = evaluate(e$, t)
IF (t AND ISREFERENCE) = 0 THEN a$="Expected variable":goto errmes

IF (t AND ISSTRING) THEN
e$ = refer(e$, t, 0)
numvar = numvar + 1
IF lineinput THEN
PRINT #12, "qbs_input_variabletypes[" + str2(numvar) + "]=ISSTRING+512;"
ELSE
PRINT #12, "qbs_input_variabletypes[" + str2(numvar) + "]=ISSTRING;"
END IF
PRINT #12, "qbs_input_variableoffsets[" + str2(numvar) + "]=" + e$ + ";"
GOTO gotinputvar
END IF

IF lineinput THEN a$="Expected string variable":goto errmes
IF (t AND ISARRAY) THEN
IF (t AND ISOFFSETINBITS) THEN
a$="INPUT cannot handle BIT array elements yet":goto errmes
END IF
END IF
e$ = "&(" + refer(e$, t, 0) + ")"

'remove assumed/unnecessary flags
IF (t AND ISPOINTER) THEN t = t - ISPOINTER
IF (t AND ISINCONVENTIONALMEMORY) THEN t = t - ISINCONVENTIONALMEMORY
IF (t AND ISREFERENCE) THEN t = t - ISREFERENCE

'IF (t AND ISOFFSETINBITS) THEN
'numvar = numvar + 1
'consider storing the bit offset in unused bits of t
'PRINT #12, "qbs_input_variabletypes[" + str2(numvar) + "]=" + str2(t) + ";"
'PRINT #12, "qbs_input_variableoffsets[" + str2(numvar) + "]=" + refer(ref$, typ, 1) + ";"
'GOTO gotinputvar
'END IF

'assume it is a regular variable
numvar = numvar + 1
PRINT #12, "qbs_input_variabletypes[" + str2(numvar) + "]=" + str2$(t) + ";"
PRINT #12, "qbs_input_variableoffsets[" + str2(numvar) + "]=" + e$ + ";"
GOTO gotinputvar

END IF
gotinputvar:
commaneeded = commaneeded + 1: IF commaneeded = 2 THEN commaneeded = 0
NEXT
IF numvar = 0 THEN x=51:goto errnum
IF lineinput = 1 AND numvar > 1 THEN a$="Too many variables":goto errmes
PRINT #12, "qbs_input(" + str2(numvar) + "," + str2$(newline) + ");"
PRINT #12, "if (stop_program) end();"
PRINT #12, cleanupstringprocessingcall$ + "0);"
layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$
GOTO finishedline
END IF



IF firstelement$ = "WRITE" THEN 'file write
IF n > 1 THEN
IF getelement$(a$, 2) = "#" THEN
xfilewrite ca$, n
GOTO finishedline
END IF '#
END IF 'n>1
END IF '"write"

IF firstelement$ = "WRITE" THEN 'write
xwrite ca$, n
GOTO finishedline
END IF '"write"

IF firstelement$ = "PRINT" THEN 'file print
IF n > 1 THEN
IF getelement$(a$, 2) = "#" THEN
xfileprint a$, ca$, n
l$=tlayout$
layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$
GOTO finishedline
END IF '#
END IF 'n>1
END IF '"print"

IF firstelement$ = "PRINT" THEN
xprint a$, ca$, n
l$=tlayout$
layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$
GOTO finishedline
END IF

if firstelement$="CLEAR" then
if subfunc$<>"" then a$="CLEAR cannot be used inside a SUB/FUNCTION":goto errmes
end if

'any other "unique" subs can be processed above

id2 = id

targetid = currentid

passedneeded = seperateargs(getelements(a$, 2, n),getelements(ca$, 2, n), passed&)
'backup args to local string array space before calling evaluate
FOR i = 1 TO 60: separgs2(i) = "": NEXT 'save space!
FOR i = 1 TO 61: separgslayout2(i) = "": NEXT
FOR i = 1 TO id2.args: separgs2(i) = separgs(i): NEXT
FOR i = 1 TO id2.args+1: separgslayout2(i) = separgslayout(i): NEXT

'note: seperateargs finds the arguments to pass and sets passed& as necessary
'      FIXOPERTIONORDER is not called on these args yet
'      what we need it to do is build a second array of layout info at the same time
'	ref:DIM SHARED separgslayout(100) AS STRING
'	the above array stores what layout info (if any) goes BEFORE the arg in question
'       it has one extra index which is the arg after

if usecall then
if usecall=1 then l$="CALL"+sp+RTRIM$(id.cn)+rtrim$(id.musthave)+sp2+"("+sp2
if usecall=2 then l$="CALL"+sp+RTRIM$(id.cn)+rtrim$(id.musthave)+sp 'sp at end for easy parsing
else
l$=RTRIM$(id.cn)+rtrim$(id.musthave)+sp
end if

subcall$ = RTRIM$(id.callname) + "("
addedlayout=0

FOR i = 1 TO id2.args
targettyp = CVL(MID$(id2.arg, -3 + i * 4, 4))
nele = ASC(MID$(id2.nele, i, 1))
nelereq = ASC(MID$(id2.nelereq, i, 1))

addlayout=1 'omits option values in layout (eg. BINARY="2")
convertspacing=0 'if an 'equation' is next, it will be preceeded by a space
x$=separgslayout2$(i)
do while len(x$)
x=asc(x$)
if x then
convertspacing=0
x2$=mid$(x$,2,x)
x$=right$(x$,len(x$)-x-1)

s=0
an=0
x3$=right$(l$,1)
if x3$=sp then s=1
if x3$=sp2 then
 s=2
 if alphanumeric(asc(right$(l$,2))) then an=1
else
 if alphanumeric(asc(x3$)) then an=1
end if
s1=s

if alphanumeric(asc(x2$)) then convertspacing=1

if (an=1 or addedlayout=1) and alphanumeric(asc(x2$))<>0 then
s=1 'force space
x2$=x2$+sp2
goto customlaychar
end if

if x2$="=" then
s=1
x2$=x2$+sp
goto customlaychar
end if

if x2$="#" then
s=1
x2$=x2$+sp2
goto customlaychar
end if

if x2$="," then x2$=x2$+sp:goto customlaychar

'default solution sp2+?+sp2
x2$=x2$+sp2
customlaychar:
if s=0 then s=2
if s<>s1 then
if s1 then l$=left$(l$,len(l$)-1)
if s=1 then l$=l$+sp
if s=2 then l$=l$+sp2
end if
l$=l$+x2$
else
addlayout=0
x$=right$(x$,len(x$)-1)
end if
addedlayout=0
loop


addedlayout=0

IF targettyp = -3 THEN
IF separgs2(i) = "NULL" THEN x=56:goto errnum
'names of numeric arrays have ( ) automatically appended (nothing else)
e$=separgs2(i)
if instr(e$,sp)=0 then 'one element only
 try = findid(e$)
 DO WHILE try
 IF id.arraytype THEN
 IF (id.arraytype and isstring)=0 then
 e$=e$+sp+"("+sp+")"
 exit do
 end if
 END IF
 IF try = 2 THEN findanotherid = 1: try = findid(e$) ELSE try = 0
 LOOP
end if
e$=fixoperationorder$(e$)
if convertspacing=1 and addlayout=1 then l$=left$(l$,len(l$)-1)+sp
if addlayout then l$=l$+tlayout$:addedlayout=1
e$ = evaluatetotyp(e$,-2)
GOTO sete
END IF '-3

IF targettyp = -2 THEN
e$=fixoperationorder$(e$)
if convertspacing=1 and addlayout=1 then l$=left$(l$,len(l$)-1)+sp
if addlayout then l$=l$+tlayout$:addedlayout=1
e$ = evaluatetotyp(e$,-2)
GOTO sete
end if '-2

IF targettyp = -4 THEN
IF separgs2(i) = "NULL" THEN x=61:goto errnum
e$ = fixoperationorder$(separgs2(i))
if convertspacing=1 and addlayout=1 then l$=left$(l$,len(l$)-1)+sp
if addlayout then l$=l$+tlayout$:addedlayout=1

'GET/PUT RANDOM-ACCESS override
IF firstelement$ = "GET" or firstelement$ = "PUT" THEN
e2$=e$ 'backup
e$ = evaluate(e$,sourcetyp)
IF (sourcetyp AND ISSTRING) THEN
IF (sourcetyp AND ISFIXEDLENGTH) = 0 THEN
'replace name of sub to call
subcall$ = RIGHT$(subcall$, LEN(subcall$) - 7) 'delete original name
'note: GET2 & PUT2 take differing input, following code is correct
IF firstelement$ = "GET" then
 subcall$ = "sub_get2" + subcall$
 e$ = refer(e$, sourcetyp, 0) 'pass a qbs pointer instead
 GOTO sete
else
 subcall$ = "sub_put2" + subcall$
 'no goto sete required, fall through
end if
end if
end if
e$=e2$ 'restore
end if 'override

e$=evaluatetotyp(e$,-4)
GOTO sete
END IF '-4

IF separgs2(i) = "NULL" THEN
e$ = "NULL"
ELSE

e2$ = fixoperationorder$(separgs2(i))
if convertspacing=1 and addlayout=1 then l$=left$(l$,len(l$)-1)+sp
if addlayout then l$=l$+tlayout$:addedlayout=1
e$ = evaluate(e2$, sourcetyp)

IF RTRIM$(id2.callname) = "sub_paint" THEN
IF i = 4 THEN
IF (sourcetyp AND ISSTRING) THEN
targettyp = ISSTRING
END IF
END IF
END IF

'pass by reference
IF (targettyp AND ISPOINTER) THEN
if left$(separgs2(i),2)<>"("+sp then 'check for '(' dereference


IF (targettyp AND ISARRAY) THEN
IF (sourcetyp AND ISREFERENCE) = 0 THEN a$="Expected arrayname()":goto errmes

idnum = VAL(LEFT$(e$, INSTR(e$, "") - 1))
getid idnum

if mid$(sfcmemargs(targetid),i,1)=chr$(1) then 'cmem required?
if cmemlist(idnum)=0 then
cmemlist(idnum) = 1
recompile = 1
end if
end if

'following check failed...
IF (sourcetyp AND ISARRAY) = 0 THEN a$="Expected arrayname()":goto errmes

if sourcetyp and ISUDT then
'check u or e
else
IF RIGHT$(e$, 2) <> "0" THEN a$="Expected arrayname()":goto errmes
end if

'check array is of same TYPE!

targettypsize = CVL(MID$(id2.argsize, i * 4 - 4 + 1, 4))
'targettypsize is ignored! but would be used for type checking fixed length string arrays


IF id.linkid = 0 THEN
'if id.linkid is 0, it means the number of array elements is definietly
'known of the array being passed, this is not some "fake"/unknown array.
'using the numer of array elements of a fake array would be dangerous!


IF nelereq = 0 THEN
'only continue if the number of array elements required is unknown
'and it needs to be set

if id.arrayelements>0 then '2009

nelereq = id.arrayelements
MID$(id2.nelereq, i, 1) = CHR$(nelereq)

end if

'print rtrim$(id2.n)+">nelereq=";nelereq

ids(targetid)=id2

ELSE

'the number of array elements required is known AND
'the number of elements in the array to be passed is known

IF id.arrayelements <> nelereq THEN a$="Passing arrays with a differing number of elements to a SUB/FUNCTION is not supported (yet)":goto errmes


END IF
END IF

e$ = refer(e$, sourcetyp, 1)
GOTO sete

END IF 'target is an array
'target is not an array

IF (targettyp AND ISSTRING) = 0 THEN 'not a string
IF (sourcetyp AND ISREFERENCE) THEN
idnum = VAL(LEFT$(e$, INSTR(e$, "") - 1)) 'id# of sourcetyp

'check to see if given reference is of the correct type
	'compare the source and dest. types
	'print targettyp , sourcetyp
	'print targettyp and 511, sourcetyp and 511
	'print targettyp and ISPOINTER, sourcetyp and ISPOINTER
	'print targettyp and ISUDT, sourcetyp and ISUDT
	'print targettyp and ISARRAY, sourcetyp and ISARRAY
	'print targettyp and ISREFERENCE, sourcetyp and ISREFERENCE
targettyp2 = targettyp: sourcetyp2 = sourcetyp - ISREFERENCE
IF (sourcetyp2 AND ISARRAY) THEN
arr = 1: sourcetyp2 = sourcetyp2 - ISARRAY
ELSE
arr=0
END IF
IF (sourcetyp2 AND ISPOINTER) = 0 THEN sourcetyp2 = sourcetyp2 + ISPOINTER
IF (sourcetyp2 AND ISINCONVENTIONALMEMORY) THEN sourcetyp2 = sourcetyp2 - ISINCONVENTIONALMEMORY

IF sourcetyp2 = targettyp2 THEN
'print "Similar!"
if sourcetyp and ISUDT then
'udt/udt array
getid val(e$)
udtrefi=instr(e$,"")'skip id
udtrefi=instr(udtrefi+1,e$,"")'skip u
udtrefi=instr(udtrefi+1,e$,"")'skip e
o$=right$(e$,len(e$)-udtrefi)'set o$ to the offset
if arr then
n$=scope$+"ARRAY_UDT_"+rtrim$(id.n)+"[0]"
else
n$=scope$+"UDT_"+rtrim$(id.n)
end if
e$="(void*)( ((char*)("+n$+")) + ("+right$(e$,len(e$)-udtrefi)+") )"
'print "passing:"+e$

else
'not a udt
IF arr THEN
IF (sourcetyp2 AND ISOFFSETINBITS) THEN a$="Cannot pass BIT array offsets yet":goto errmes
e$ = "(&(" + refer(e$, sourcetyp, 0) + "))"
else
e$ = refer(e$, sourcetyp, 1)
end if

end if

if mid$(sfcmemargs(targetid),i,1)=chr$(1) then 'cmem required?
if cmemlist(idnum)=0 then
cmemlist(idnum) = 1
recompile = 1
end if
end if

GOTO sete
END IF 'similar

END IF 'reference
END IF 'not a string

end if 'dereference check
END IF 'target is a pointer

IF (sourcetyp AND ISREFERENCE) THEN
e$ = refer(e$, sourcetyp, 0)
END IF

'round to integer if required
IF (sourcetyp AND ISFLOAT) THEN
IF (targettyp AND ISFLOAT) = 0 THEN
'**32 rounding fix
bits = targettyp AND 511
IF bits <= 16 THEN e$ = "qbr_float_to_long(" + e$ + ")"
IF bits > 16 AND bits < 32 THEN e$ = "qbr_double_to_long(" + e$ + ")"
IF bits >= 32 THEN e$ = "qbr(" + e$ + ")"
END IF
END IF

IF (targettyp AND ISPOINTER) THEN 'pointer required
IF (targettyp AND ISSTRING) THEN GOTO sete 'no changes required
t$ = typ2ctyp$(targettyp, "")
v$ = "pass" + str2$(uniquenumber)
'assume numeric type
if mid$(sfcmemargs(targetid),i,1)=chr$(1) then 'cmem required?
	bytesreq=((targettyp and 511)+7)\8
	PRINT #defdatahandle, t$ + " *" + v$ + "=NULL;"
	PRINT #13, "if(" + v$ + "==NULL){"
	PRINT #13, "cmem_sp-="+str2(bytesreq)+";"
	PRINT #13, v$ + "=(" + t$ + "*)(dblock+cmem_sp);"
	PRINT #13, "if (cmem_sp<qbs_cmem_sp) error(257);"
	PRINT #13, "}"
	e$ = "&(*" + v$ + "=" + e$+")"
else
	PRINT #13, t$ + " " + v$ + ";"
	e$ = "&(" + v$ + "=" + e$ + ")"
end if
GOTO sete
END IF

END IF 'not "NULL"

sete:

IF RTRIM$(id2.callname) = "sub_paint" THEN
IF i = 4 THEN
IF (sourcetyp AND ISSTRING) THEN
e$ = "(qbs*)" + e$
ELSE
e$ = "(unsigned long)" + e$
END IF
END IF
END IF

IF i <> 1 THEN subcall$ = subcall$ + ","
subcall$ = subcall$ + e$
NEXT

'note: i=id.args+1
x$=separgslayout2$(i)
do while len(x$)
x=asc(x$)
if x then
x2$=mid$(x$,2,x)
x$=right$(x$,len(x$)-x-1)

s=0
an=0
x3$=right$(l$,1)
if x3$=sp then s=1
if x3$=sp2 then
 s=2
 if alphanumeric(asc(right$(l$,2))) then an=1
 'if asc(right$(l$,2))=34 then an=1
else
 if alphanumeric(asc(x3$)) then an=1
 'if asc(x3$)=34 then an=1
end if
s1=s

if (an=1 or addedlayout=1) and alphanumeric(asc(x2$))<>0 then
s=1 'force space
x2$=x2$+sp2
goto customlaychar2
end if

if x2$="=" then
s=1
x2$=x2$+sp
goto customlaychar2
end if

if x2$="#" then
s=1
x2$=x2$+sp2
goto customlaychar2
end if

if x2$="," then x2$=x2$+sp:goto customlaychar2

'default solution sp2+?+sp2
x2$=x2$+sp2
customlaychar2:
if s=0 then s=2
if s<>s1 then
if s1 then l$=left$(l$,len(l$)-1)
if s=1 then l$=l$+sp
if s=2 then l$=l$+sp2
end if
l$=l$+x2$

else
addlayout=0
x$=right$(x$,len(x$)-1)
end if
addedlayout=0
loop






IF passedneeded THEN
subcall$ = subcall$ + "," + str2$(passed&)
END IF
subcall$ = subcall$ + ");"
PRINT #12, subcall$
subcall$ = ""
IF stringprocessinghappened THEN PRINT #12, cleanupstringprocessingcall$ + "0);"

layoutdone=1
x$=right$(l$,1): if x$=sp or x$=sp2 then l$=left$(l$,len(l$)-1)
if usecall=1 then l$=l$+sp2+")"
if debug then print #9, "SUB layout:["+l$+"]"
if len(layout$)=0 then layout$=l$ else layout$=layout$+sp+l$
GOTO finishedline

END IF

IF try = 2 THEN
findidsecondarg = "": IF n >= 2 THEN findidsecondarg = getelement$(a$, 2)
findanotherid = 1
try = findid(firstelement$)
ELSE
try = 0
END IF
LOOP

END IF




IF n = 1 THEN
IF firstelement$ = "END" THEN
xend
l$="END"
layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$
GOTO finishedline
END IF
END IF

IF n = 1 THEN
IF firstelement$ = "SYSTEM" THEN
PRINT #12, "close_program=1;"
PRINT #12, "end();"
l$="SYSTEM"
layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$
GOTO finishedline
END IF
END IF

IF n>=1 THEN
IF firstelement$ = "STOP" THEN
l$="STOP"
if n>1 then
e$=getelements$(ca$,2,n)
e$=fixoperationorder$(e$)
l$="STOP"+sp+tlayout$
e$=evaluatetotyp(e$,64)
'note: this value is currently ignored but evaluated for checking reasons
end if
layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$
PRINT #12, "close_program=1;"
PRINT #12, "end();"
GOTO finishedline
END IF
END IF

IF n = 2 THEN
IF firstelement$ = "GOSUB" THEN
xgosub ca$, n
'note: layout implemented in xgosub
GOTO finishedline
END IF
END IF

IF n >= 1 THEN
IF firstelement$ = "RETURN" THEN
if n=1 then
 PRINT #12, "#include " + CHR$(34) + "ret" + str2$(subfuncn) + ".txt" + CHR$(34)
 l$="RETURN"
 layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$
 GOTO finishedline
else
 'label/linenumber follows
 if subfuncn<>0 then a$="RETURN linelabel/linenumber invalid within a SUB/FUNCTION":goto errmes
 if n>2 then a$="Expected linelabel/linenumber after RETURN":goto errmes
 print #12,"if (!next_return_point) error(3);" 'check return point available
 print #12,"next_return_point--;" 'destroy return point
 a2$ = getelement$(ca$, 2)
 IF validlabel(a2$) = 0 THEN x=36:goto errnum
 PRINT #12, "goto LABEL_" + a2$ + ";"
 l$="RETURN"+sp+tlayout$
 layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$
 GOTO finishedline
end if
END IF
END IF

IF n >= 1 THEN
IF firstelement$ = "RESUME" THEN
l$="RESUME"
IF n = 1 THEN
resumeprev:
PRINT #12, "if (!error_handling){error(20);}else{error_retry=1; qbevent=1; error_handling=0; error_err=0; error_erl=0; return NULL;}"
layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$
GOTO finishedline
END IF
IF n > 2 THEN x=66:goto errnum
s$ = getelement$(ca$, 2)
IF ucase$(s$) = "NEXT" THEN
PRINT #12, "if (!error_handling){error(20);}else{error_handling=0; error_err=0; error_erl=0; return NULL;}"
l$=l$+sp+"NEXT"
layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$
GOTO finishedline
END IF
IF s$ = "0" THEN l$=l$+sp+"0": GOTO resumeprev
IF validlabel(s$) = 0 THEN x=67:goto errnum
l$=l$+sp+tlayout$
layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$
PRINT #12, "if (!error_handling){error(20);}else{error_handling=0; error_err=0; error_erl=0; goto LABEL_" + s$ + ";}"
GOTO finishedline
END IF
END IF

IF n = 4 THEN
IF getelements(a$, 1, 3) = "ON" + sp + "ERROR" + sp + "GOTO" THEN
l$="ON"+sp+"ERROR"+sp+"GOTO"
lbl$ = getelement$(ca$, 4)
IF lbl$ = "0" THEN
PRINT #12, "error_goto_line=0;"
l$=l$+sp+"0"
layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$
GOTO finishedline
END IF
IF validlabel(lbl$) = 0 THEN x=68:goto errnum
l$=l$+sp+tlayout$
layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$
errorlabels = errorlabels + 1
PRINT #12, "error_goto_line=" + str2(errorlabels) + ";"
PRINT #14, "if (error_goto_line==" + str2(errorlabels) + "){error_handling=1; goto LABEL_" + lbl$ + ";}"
GOTO finishedline
END IF
END IF

IF n >= 1 THEN
IF firstelement$ = "RESTORE" THEN
l$="RESTORE"
IF n = 1 THEN
PRINT #12, "data_offset=0;"
ELSE
IF n > 2 THEN x=69:goto errnum
lbl$ = getelement$(ca$, 2)
IF validlabel(lbl$) = 0 THEN x=70:goto errnum
l$=l$+sp+tlayout$
PRINT #12, "data_offset=data_at_LABEL_" + lbl$ + ";"
END IF
layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$
GOTO finishedline
END IF
END IF

IF n = 1 THEN
IF firstelement$ = "DATA" THEN
'note: data already processed by "lineformat", DATA is a placeholder only
GOTO finishedline
END IF
END IF

IF n >= 1 THEN
IF firstelement$ = "OPTION" THEN
IF n <> 3 THEN x=71:goto errnum
IF getelement$(a$, 2) <> "BASE" THEN x=72:goto errnum
l$ = getelement$(a$, 3)
IF l$ <> "0" AND l$ <> "1" THEN x=73:goto errnum
IF l$ = "1" THEN optionbase = 1 ELSE optionbase = 0
l$="OPTION"+sp+"BASE"+sp+l$
layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$
GOTO finishedline
END IF
END IF

'ON ... GOTO/GOSUB
IF n >= 1 THEN
IF firstelement$ = "ON" THEN
xongotogosub a$,ca$, n
GOTO finishedline
END IF
END IF

IF n >= 1 THEN
IF firstelement$ = "LET" THEN
IF n = 1 THEN x=74:goto errnum
ca$ = RIGHT$(ca$, LEN(ca$) - 4)
n=n-1
l$="LET"
if len(layout$) then layout$=layout$+sp+l$ else layout$=l$
'note: layoutdone=1 will be set later
GOTO letused
END IF
END IF

'LET ???=???
IF n >= 3 THEN
IF INSTR(a$, sp + "=" + sp) THEN
letused:
assign ca$,n
layoutdone=1
if len(layout$)=0 then layout$=tlayout$ else layout$=layout$+sp+tlayout$
GOTO finishedline
END IF
END IF '>=3
if right$(a$,2)=sp+"=" then a$="Expected ... = expression":goto errmes

'Syntax error
x=75:goto errnum

finishedline:
THENGOTO = 0
finishedline2:

IF arrayprocessinghappened = 1 THEN arrayprocessinghappened = 0

if nochecks=0 then
if dynscope then
dynscope=0
PRINT #12, "if(qbevent){evnt("+str2$(linenumber)+");if(r)goto S_" + str2$(statementn) + ";}"
else
PRINT #12, "if(!qbevent)break;evnt("+str2$(linenumber)+");}while(r);
end if
end if

finishednonexec:

if layoutdone=0 then layoutok=0 'invalidate layout if not handled

if continuelinefrom=0 then 'note: manager #2 requires this condition

'Include Manager #2 '***
if len(addmetainclude$) then
a$=addmetainclude$: addmetainclude$="" 'read/clear message
if inclevel=100 then qb64error "Too many indwelling INCLUDE files"
'1. Verify file exists (location is either (a)relative to source file or (b)absolute)
fh=99+inclevel+1
for try=1 to 2
if try=1 then
if inclevel=0 then
if idemode then p$=idepath$ + pathsep$ else p$=getfilepath$(sourcefile$)
else
p$=getfilepath$(incname(inclevel))
end if
f$=p$+a$
end if
if try=2 then f$=a$
qberrorhappened = -2 '***
open f$ for input as #fh
qberrorhappened2: '***
IF qberrorhappened=-2 THEN exit for'***
qberrorhappened=0
next
if qberrorhappened<>-2 then qberrorhappened=0: qb64error "File "+a$+" not found" '***
inclevel=inclevel+1: incname$(inclevel)=f$: inclinenumber(inclevel)=0
end if 'fall through to next section...
'--------------------
if inclevel then
fh=99+inclevel
'2. Feed next line
if eof(fh)=0 then
line input #fh,x$
a3$=x$
continuelinefrom = 0
inclinenumber(inclevel)=inclinenumber(inclevel)+1
	'create extended error string 'incerror$'
	e$=" in line "+str2(inclinenumber(inclevel))+" of "+incname$(inclevel)+" included"
        if inclevel>1 then
	e$=e$+" (through "
	for x=1 to inclevel-1 step 1
	e$=e$+incname$(x)
	if x<inclevel-1 then 'a sep is req
	if x=inclevel-2 then
	e$=e$+" then "
	else
	e$=e$+", "
	end if
	end if
	next
	e$=e$+")"
	end if
	incerror$=e$
linenumber = linenumber - 1 'lower official linenumber to counter later increment
if idemode then sendc$ = CHR$(10)+ a3$: goto sendcommand 'passback
goto includeline
end if
'3. Close & return control
close #fh
inclevel=inclevel-1
if idemode then goto ideret4 '***
end if 'fall through to next section...
'(end manager)

end if 'continuelinefrom=0


if debug then
print #9,"[layout check]"
print #9,"["+layoutoriginal$+"]"
print #9,"["+layout$+"]"
print #9,layoutok
print #9,"[end layout check]"
end if




if idemode then
if continuelinefrom<>0 then goto ide4 'continue processing other commands on line

if len(layoutcomment$) then
if len(layout$) then layout$=layout$+sp+layoutcomment$ else layout$=layoutcomment$
end if

if layoutok=0 then
layout$=layoutoriginal$
else

'reverse '046' changes present in autolayout
'replace fix046$ with .
i=instr(layout$,fix046$)
do while i
layout$=left$(layout$,i-1)+"."+right$(layout$,len(layout$)-(i+len(fix046$)-1))
i=instr(layout$,fix046$)
loop

end if
x=lhscontrollevel: if controllevel<lhscontrollevel then x=controllevel
layout$=space$(x)+layout$
if linecontinuation then layout$=""

goto ideret4 'return control to IDE
end if

'layout is not currently used by the compiler (as appose to the IDE), if it was it would be used here

LOOP

ide5:
linenumber = 0

IF closedmain = 0 THEN closemain

'close the error handler (cannot be put in 'closemain' because subs/functions can also add error jumps to this file)
PRINT #14, "exit(99);" 'in theory this line should never be run!
PRINT #14, "}" 'close error jump handler

'create stub entry in userdata if necessary (or c comp. fails)
IF dataoffset = 0 THEN PRINT #16, "0";
PRINT #18, "unsigned long data_size=" + str2(dataoffset) + ";"

'create CLEAR method "CLEAR"
close #12 'close code handle
open tmpdir$ + "clear.txt" for output as #12 'direct code to clear.txt

for i = 1 TO idn

if ids(i).staticscope then 'static scope?
subfunc = rtrim$(ids(i).insubfunc) 'set static scope
goto clearstaticscope
end if

a=asc(ids(i).insubfunc)
if a=0 or a=32 then 'global scope?
subfunc = "" 'set global scope
clearstaticscope:

if ids(i).arraytype then 'an array
getid i
if id.arrayelements=-1 then goto clearerasereturned 'cannot erase non-existant array
clearerasereturn=1: goto clearerase
end if 'array

if ids(i).t then 'non-array variable
getid i
bytes$=variablesize$(-1)
'create a reference
typ=id.t+isreference
if typ and isudt then
e$=str2(i)+""+str2(typ and 511)+""+"0"+""+"0"
else
e$=str2(i)
end if
e$=refer$(e$,typ,1)
if typ and ISSTRING then
if typ and ISFIXEDLENGTH then
print #12,"memset((void*)("+e$+"->chr),0,"+bytes$+");"
goto cleared
else
print #12,e$+"->len=0;"
goto cleared
end if
end if
if typ and isudt then
print #12,"memset((void*)"+e$+",0,"+bytes$+");"
else
print #12,"*"+e$+"=0;"
end if
goto cleared
end if 'non-array variable

end if 'scope

cleared:
clearerasereturned:
next
close #12

if debug then
print #9,"finished making program!"
print #9,"recompile=";recompile
end if

'Set cmem flags for subs/functions requiring data passed in cmem
FOR i = 1 TO idn
if cmemlist(i) then 'must be in cmem

getid i

if debug then print #9,"recompiling cmem sf! checking:";rtrim$(id.n)

if id.sfid then 'it is an argument of a sub/function

if debug then print #9,"recompiling cmem sf! It's a sub/func arg!"

i2=id.sfid
x=id.sfarg

if debug then print #9,"recompiling cmem sf! values:";i2;x

'check if cmem flag is set, if not then set it & force recompile
if mid$(sfcmemargs(i2),x,1)<>chr$(1) then
mid$(sfcmemargs(i2),x,1)=chr$(1)


if debug then print #9,"recompiling cmem sf! setting:";i2;x


recompile=1
end if
end if
end if
next i

unresolved=0
FOR i = 1 TO idn
getid i

if debug then print #9,"checking id named:";id.n

IF id.subfunc THEN
FOR i2 = 1 TO id.args
t = CVL(MID$(id.arg, i2 * 4 - 3, 4))
IF t > 0 THEN
IF (t AND ISPOINTER) THEN
IF (t AND ISARRAY) THEN

if debug then print #9,"checking argument ";i2;" of ";id.args

 nele = ASC(MID$(id.nele, i2, 1))
 nelereq = ASC(MID$(id.nelereq, i2, 1))

if debug then print #9,"nele=";nele
if debug then print #9,"nelereq=";nelereq

 IF nele <> nelereq THEN

if debug then print #9,"mismatch detected!"

 unresolved=unresolved+1
 sflistn = sflistn + 1
 sfidlist(sflistn) = i
 sfarglist(sflistn) = i2
 sfelelist(sflistn) = nelereq '0 means still unknown
 END IF
END IF
END IF
END IF
NEXT
END IF
NEXT

'is recompilation required to resolve this?
if unresolved>0 then
if lastunresolved=-1 then
'first pass
recompile=1
 if debug then
 print #9,"recompiling to resolve array elements (first time)"
 print #9,"sflistn=";sflistn
 print #9,"oldsflistn=";oldsflistn
 end if
else
'not first pass
if unresolved<lastunresolved then
recompile=1
 if debug then
 print #9,"recompiling to resolve array elements (not first time)"
 print #9,"sflistn=";sflistn
 print #9,"oldsflistn=";oldsflistn
 end if
end if
end if
end if 'unresolved
lastunresolved=unresolved

'IDEA!
'have a flag to record if anything gets resolved in a pass
'if not then it's time to stop
'the problem is the same amount of new problems may be created by a
'resolve as those that get fixed
'also/or.. could it be that previous fixes are overridden in a recompile
'          by a new fix? if so, it would give these effects



'could recompilation resolve this?
'IF sflistn <> -1 THEN
'IF sflistn <> oldsflistn THEN
'recompile = 1
'
'if debug then
'print #9,"recompile set to 1 to resolve array elements"
'print #9,"sflistn=";sflistn
'print #9,"oldsflistn=";oldsflistn
'end if
'
'END IF
'END IF

xi=1
for x=1 to commonarraylistn
varname$=getelement$(commonarraylist,xi):xi=xi+1
typ$=getelement$(commonarraylist,xi):xi=xi+1
dimmethod=val(getelement$(commonarraylist,xi)):xi=xi+1
dimshared=val(getelement$(commonarraylist,xi)):xi=xi+1
'find the array ID (try method)
t=typname2typ(typ$)
if (t and ISUDT)=0 then varname$=varname$+type2symbol$(typ$)
try = findid(varname$)
DO WHILE try
if id.arraytype then goto foundcommonarray2
IF try = 2 THEN findanotherid = 1: try = findid(varname$) ELSE try = 0
LOOP
foundcommonarray2:
if id.arrayelements=-1 then
if arrayelementslist(currentid)<>0 then recompile=1
if debug then print #9,"Recompiling to resolve elements of:"+ varname$
end if
next

IF recompile THEN
recompile = 0
if idemode then iderecompile=1
close
open tmpdir$+"temp.bin" for output lock read write as #26 'relock
GOTO recompile
end if





'if targettyp=-4 or targettyp=-5 then '? -> byte_element(offset,element size in bytes)
' IF (sourcetyp AND ISREFERENCE) = 0 THEN nerror (62)


'create include files for COMMON arrays

CLOSE #12

'return to 'main'
subfunc$ = ""
defdatahandle=18
close #13:open tmpdir$+"maindata.txt" for append as #13
close #19:open tmpdir$+"mainfree.txt" for append as #19

ncommontmp=0
xi=1
for x=1 to commonarraylistn
varname$=getelement$(commonarraylist,xi):xi=xi+1
typ$=getelement$(commonarraylist,xi):xi=xi+1
dimmethod=val(getelement$(commonarraylist,xi)):xi=xi+1
dimshared=val(getelement$(commonarraylist,xi)):xi=xi+1

'find the array ID (try method)
purevarname$=varname$
t=typname2typ(typ$)
if (t and ISUDT)=0 then varname$=varname$+type2symbol$(typ$)
try = findid(varname$)
DO WHILE try
if id.arraytype then goto foundcommonarray
IF try = 2 THEN findanotherid = 1: try = findid(varname$) ELSE try = 0
LOOP
a$="COMMON array unlocatable":goto errmes 'should never happen
foundcommonarray:


i=currentid
arraytype=id.arraytype
arrayelements=id.arrayelements
e$=rtrim$(id.n)
if (t and ISUDT)=0 then e$=e$+typevalue2symbol$(t)
n$=e$
n2$ = RTRIM$(id.callname)
tsize=id.tsize

'select command
com=3 'fixed length elements
if t and ISSTRING then
if (t and ISFIXEDLENGTH)=0 then
com=4 'var-len elements
end if
end if


'if...
'i) array elements are still undefined (ie. arrayelements=-1) pass the input content along
'   if any existed or an array-placeholder
'ii) if the array's elements were defined, any input content would have been loaded so the
'    array (in whatever state it currently is) should be passed. If it is currently erased
'    then it should be passed as a placeholder


if arrayelements=-1 then

'load array (copies the array, if any, into a buffer for later)

open tmpdir$ + "inpchain" + str2$(i) + ".txt" for output as #12
print #12, "if (int32val==2){" 'array place-holder
'create buffer to store array as-is in global.txt
x$ = str2$(uniquenumber)
x1$="chainarraybuf"+x$
x2$="chainarraybufsiz"+x$
print #18, "static uint8 *"+x1$+"=(uint8*)malloc(1);"
print #18, "static int64 "+x2$+"=0;"
'read next command
print #12, "sub_get(FF,NULL,byte_element((uint64)&int32val,4),0);"

if com=3 then print #12, "if (int32val==3){" 'fixed-length-element array
if com=4 then print #12, "if (int32val==4){" 'var-length-element array
print #12, x2$+"+=4; "+x1$+"=(uint8*)realloc("+x1$+","+x2$+"); *(int32*)("+x1$+"+"+x2$+"-4)=int32val;"

if com=3 then
'read size in bits of one element, convert it to bytes
print #12, "sub_get(FF,NULL,byte_element((uint64)&int64val,8),0);"
print #12, x2$+"+=8; "+x1$+"=(uint8*)realloc("+x1$+","+x2$+"); *(int64*)("+x1$+"+"+x2$+"-8)=int64val;"
print #12, "bytes=int64val>>3;"
end if 'com=3

if com=4 then print #12, "bytes=1;" 'bytes used to calculate number of elements

'read number of dimensions
print #12, "sub_get(FF,NULL,byte_element((uint64)&int32val,4),0);"
print #12, x2$+"+=4; "+x1$+"=(uint8*)realloc("+x1$+","+x2$+"); *(int32*)("+x1$+"+"+x2$+"-4)=int32val;"

'read size of dimensions & calculate the size of the array in bytes
print #12, "while(int32val--){"
print #12, "sub_get(FF,NULL,byte_element((uint64)&int64val,8),0);" 'lbound
print #12, x2$+"+=8; "+x1$+"=(uint8*)realloc("+x1$+","+x2$+"); *(int64*)("+x1$+"+"+x2$+"-8)=int64val;"
print #12, "sub_get(FF,NULL,byte_element((uint64)&int64val2,8),0);" 'ubound
print #12, x2$+"+=8; "+x1$+"=(uint8*)realloc("+x1$+","+x2$+"); *(int64*)("+x1$+"+"+x2$+"-8)=int64val2;"
print #12, "bytes*=(int64val2-int64val+1);"
print #12, "}"

if com=3 then
'read the array data
print #12, x2$+"+=bytes; "+x1$+"=(uint8*)realloc("+x1$+","+x2$+");"
print #12, "sub_get(FF,NULL,byte_element((uint64)("+x1$+"+"+x2$+"-bytes),bytes),0);"
end if 'com=3

if com=4 then
print #12,"bytei=0;"
print #12,"while(bytei<bytes){"
print #12,"sub_get(FF,NULL,byte_element((uint64)&int64val,8),0);" 'get size
print #12, x2$+"+=8; "+x1$+"=(uint8*)realloc("+x1$+","+x2$+"); *(int64*)("+x1$+"+"+x2$+"-8)=int64val;"
print #12, x2$+"+=(int64val>>3); "+x1$+"=(uint8*)realloc("+x1$+","+x2$+");"
print #12, "sub_get(FF,NULL,byte_element((uint64)("+x1$+"+"+x2$+"-(int64val>>3)),(int64val>>3)),0);"
print #12,"bytei++;"
print #12,"}"
end if

'get next command
print #12,"sub_get(FF,NULL,byte_element((uint64)&int32val,4),0);"
print #12,"}" 'command=3 or 4

print #12,"}" 'array place-holder
close #12


'save array (saves the buffered data, if any, for later)

open tmpdir$ + "chain" + str2$(i) + ".txt" for output as #12
print #12,"int32val=2;" 'placeholder
print #12,"sub_put(FF,NULL,byte_element((uint64)&int32val,4),0);"

print #12,"sub_put(FF,NULL,byte_element((uint64)"+x1$+","+x2$+"),0);"
close #12




else
'note: arrayelements<>-1

'load array

open tmpdir$ + "inpchain" + str2$(i) + ".txt" for output as #12

print #12,"if (int32val==2){" 'array place-holder
print #12,"sub_get(FF,NULL,byte_element((uint64)&int32val,4),0);"

if com=3 then print #12,"if (int32val==3){" 'fixed-length-element array
if com=4 then print #12,"if (int32val==4){" 'var-length-element array

if com=3 then
'get size in bits
print #12,"sub_get(FF,NULL,byte_element((uint64)&int64val,8),0);"
'***assume correct***
end if

'get number of elements
print #12,"sub_get(FF,NULL,byte_element((uint64)&int32val,4),0);"
'***assume correct***

e$=""
if com=4 then print #12,"bytes=1;" 'bytes counts the number of total elements
for x2=1 to arrayelements

'create 'secret' variables to assist in passing common arrays
if x2>ncommontmp then
ncommontmp=ncommontmp+1
retval=dim2("_RESERVED_COMMON_LBOUND"+str2$(ncommontmp),"_INTEGER64",0,"")
retval=dim2("_RESERVED_COMMON_UBOUND"+str2$(ncommontmp),"_INTEGER64",0,"")
end if

print #12,"sub_get(FF,NULL,byte_element((uint64)&int64val,8),0);"
print #12,"*__INTEGER64__RESERVED_COMMON_LBOUND"+str2$(x2)+"=int64val;"
print #12,"sub_get(FF,NULL,byte_element((uint64)&int64val2,8),0);"
print #12,"*__INTEGER64__RESERVED_COMMON_UBOUND"+str2$(x2)+"=int64val2;"
if com=4 then print #12,"bytes*=(int64val2-int64val+1);"
if x2>1 then e$=e$+sp+","+sp
e$=e$+"_RESERVED_COMMON_LBOUND"+str2$(x2)+sp+"TO"+sp+"_RESERVED_COMMON_UBOUND"+str2$(x2)
next
redimoption=1
retval=dim2(purevarname$,typ$,0,e$)
redimoption=0

if com=3 then
'use get to load in the array data
varname$=varname$+sp+"("+sp+")"
e$=evaluatetotyp(fixoperationorder$(varname$),-4)
print #12,"sub_get(FF,NULL,"+e$+",0);"
end if

if com=4 then
print #12,"bytei=0;"
print #12,"while(bytei<bytes){"
print #12,"sub_get(FF,NULL,byte_element((uint64)&int64val,8),0);" 'get size
print #12,"tqbs=((qbs*)(((uint64*)("+n2$+"[0]))[bytei]));" 'get element
print #12,"qbs_set(tqbs,qbs_new(int64val>>3,1));" 'change string size
print #12,"sub_get(FF,NULL,byte_element((uint64)tqbs->chr,int64val>>3),0);" 'get size
print #12,"bytei++;"
print #12,"}"
end if

'get next command
print #12,"sub_get(FF,NULL,byte_element((uint64)&int32val,4),0);"
print #12,"}"
print #12,"}"
close #12

'save array

open tmpdir$ + "chain" + str2$(i) + ".txt" for output as #12

print #12,"int32val=2;" 'placeholder
print #12,"sub_put(FF,NULL,byte_element((uint64)&int32val,4),0);"

print #12,"if ("+n2$+"[2]&1){" 'don't add unless defined

if com=3 then print #12,"int32val=3;"
if com=4 then print #12,"int32val=4;"
print #12,"sub_put(FF,NULL,byte_element((uint64)&int32val,4),0);"

if com=3 then
'size of each element in bits
bits=t and 511
if t and ISUDT then bits=udtxsize(t and 511)
if t and ISSTRING then bits=tsize*8
print #12,"int64val="+str2$(bits)+";" 'size in bits
print #12,"sub_put(FF,NULL,byte_element((uint64)&int64val,8),0);"
end if 'com=3

print #12,"int32val="+str2$(arrayelements)+";" 'number of dimensions
print #12,"sub_put(FF,NULL,byte_element((uint64)&int32val,4),0);"

if com=3 then

for x2=1 to arrayelements
'simulate calls to lbound/ubound
e$="LBOUND"+sp+"("+sp+n$+sp+","+sp+str2$(x2)+sp+")"
e$=evaluatetotyp(fixoperationorder$(e$),64)
print #12,"int64val="+e$+";"
print #12,"sub_put(FF,NULL,byte_element((uint64)&int64val,8),0);"
e$="UBOUND"+sp+"("+sp+n$+sp+","+sp+str2$(x2)+sp+")"
e$=evaluatetotyp(fixoperationorder$(e$),64)
print #12,"int64val="+e$+";"
print #12,"sub_put(FF,NULL,byte_element((uint64)&int64val,8),0);"
next

'array data
e$=evaluatetotyp(fixoperationorder$(n$+sp+"("+sp+")"),-4)
print #12,"sub_put(FF,NULL,"+e$+",0);"

end if 'com=3

if com=4 then

'store LBOUND/UBOUND values and calculate number of total elements/strings
print #12, "bytes=1;" 'note: bytes is actually the total number of elements
for x2=1 to arrayelements
e$="LBOUND"+sp+"("+sp+n$+sp+","+sp+str2$(x2)+sp+")"
e$=evaluatetotyp(fixoperationorder$(e$),64)
print #12,"int64val="+e$+";"
print #12,"sub_put(FF,NULL,byte_element((uint64)&int64val,8),0);"
e$="UBOUND"+sp+"("+sp+n$+sp+","+sp+str2$(x2)+sp+")"
e$=evaluatetotyp(fixoperationorder$(e$),64)
print #12,"int64val2="+e$+";"
print #12,"sub_put(FF,NULL,byte_element((uint64)&int64val2,8),0);"
print #12,"bytes*=(int64val2-int64val+1);"
next

print #12,"bytei=0;"
print #12,"while(bytei<bytes){"
print #12,"tqbs=((qbs*)(((uint64*)("+n2$+"[0]))[bytei]));" 'get element
print #12,"int64val=tqbs->len; int64val<<=3;"
print #12,"sub_put(FF,NULL,byte_element((uint64)&int64val,8),0);" 'size of element
print #12,"sub_put(FF,NULL,byte_element((uint64)tqbs->chr,tqbs->len),0);" 'element data
print #12,"bytei++;"
print #12,"}"

end if 'com=4

print #12,"}" 'don't add unless defined

close #12




'if chaincommonarray then
'l2$=tlayout$
'x=chaincommonarray
'
''chain???.txt
'open tmpdir$ + "chain" + str2$(x) + ".txt" for append as #22
'if lof(22) then close #22: goto chaindone 'only add this once
''***assume non-var-len-string array***
'print #22,"int32val=3;" 'non-var-len-element array
'print #22,"sub_put(FF,NULL,byte_element((uint64)&int32val,4),0);"
't=id.arraytype
''***check for UDT size if necessary***
''***check for string length if necessary***
'bits=t and 511
'print #22,"int64val="+str2$(bits)+";" 'size in bits
'print #22,"sub_put(FF,NULL,byte_element((uint64)&int64val,8),0);"
'print #22,"int32val="+str2$(id.arrayelements)+";" 'number of elements
'print #22,"sub_put(FF,NULL,byte_element((uint64)&int32val,4),0);"
'e$=rtrim$(id.n)
'if (t and ISUDT)=0 then e$=e$+typevalue2symbol$(t)
'n$=e$
'for x2=1 to id.arrayelements
''simulate calls to lbound/ubound
'e$="LBOUND"+sp+"("+sp+n$+sp+","+sp+str2$(x2)+sp+")"
'e$=evaluatetotyp(fixoperationorder$(e$),64)
'print #22,"int64val="+e$+";"'LBOUND
'print #22,"sub_put(FF,NULL,byte_element((uint64)&int64val,8),0);"
'e$="UBOUND"+sp+"("+sp+n$+sp+","+sp+str2$(x2)+sp+")"
'e$=evaluatetotyp(fixoperationorder$(e$),64)
'print #22,"int64val="+e$+";"'LBOUND
'print #22,"sub_put(FF,NULL,byte_element((uint64)&int64val,8),0);"
'next
''add array data
'e$=evaluatetotyp(fixoperationorder$(n$+sp+"("+sp+")"),-4)
'print #22,"sub_put(FF,NULL,"+e$+",0);"
'close #22
'
''inpchain???.txt
'open tmpdir$ + "chain" + str2$(x) + ".txt" for append as #22
'print #22,"if (int32val==1){" 'common declaration of an array
'print #22,"sub_get(FF,NULL,byte_element((uint64)&int32val,4),0);"
'print #22,"if (int32val==3){" 'fixed-length-element array
'
'print #22,"sub_get(FF,NULL,byte_element((uint64)&int64val,8),0);"
''***assume size correct and continue***
'
''get number of elements
'print #22,"sub_get(FF,NULL,byte_element((uint64)&int32val,4),0);"
'
''call dim2 and tell it to redim an array 
'
''*********this should happen BEFORE the array (above) is actually dimensioned, 
''*********where the common() declaration is
'
''****although, if you never reference the array.............
''****ARGH! you can access an undimmed array just like in a sub/function
''****OUCH, OUCH, OUCH, OUCH, OUCH
''****MUMMY!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
'
'
'
'
'print #22,"}"
'print #22,"}"
'close #22
'
'chaindone:
'tlayout$=l2$
'end if 'chaincommonarray




'OPEN tmpdir$ + "chain.txt" FOR APPEND AS #22
''include directive
'print #22, "#include " + CHR$(34) + "chain" + str2$(x) + ".txt" + CHR$(34)
'close #22
''create/clear include file
'open tmpdir$ + "chain" + str2$(x) + ".txt" for output as #22:close #22
'
'OPEN tmpdir$ + "inpchain.txt" FOR APPEND AS #22
''include directive
'print #22, "#include " + CHR$(34) + "inpchain" + str2$(x) + ".txt" + CHR$(34)
'close #22
''create/clear include file
'open tmpdir$ + "inpchain" + str2$(x) + ".txt" for output as #22:close #22






end if 'id.arrayelements=-1






next




close
open tmpdir$+"temp.bin" for output lock read write as #26 'relock








if idemode then goto ideret5
ide6:

if idemode=0 then
PRINT
PRINT "COMPILING C++ CODE INTO EXE..."

ON ERROR GOTO qberror_test
e=0
OPEN file$ + ".exe" FOR OUTPUT AS #1
ON ERROR GOTO qberror
if e=1 then
print "CANNOT CREATE "+chr$(34)+file$+".exe"+chr$(34)+" BECAUSE THE FILE IS ALREADY IN USE!"
end
else
close #1
end if

end if 'idemode=0

if os$="WIN" then
open ".\internal\c\makeline.txt" for input as #150
line input #150, a$
x=instr(a$,"qbx.cpp"): if x<>0 and tempfolderindex<>1 then a$=left$(a$,x-1)+"qbx"+str2$(tempfolderindex)+".cpp"+right$(a$,len(a$)-(x+6))
'makeline.txt patch (following line will become unrequired in later versions)
if right$(a$,7)=" ..\..\" then a$=left$(a$,len(a$)-6)
close #150
CHDIR ".\internal\c"
SHELL _hide a$+idezfilename$("..\..\"+file$+".exe")
CHDIR "..\.."
end if

if os$="LNX" then
open "./internal/c/makeline.txt" for input as #150
line input #150, a$
x=instr(a$,"qbx.cpp"): if x<>0 and tempfolderindex<>1 then a$=left$(a$,x-1)+"qbx"+str2$(tempfolderindex)+".cpp"+right$(a$,len(a$)-(x+6))
'makeline.txt patch (following line will become unrequired in later versions)
if right$(a$,7)=" ../../" then a$=left$(a$,len(a$)-6)
close #150
CHDIR "./internal/c"
SHELL _hide a$+idezfilename$("../../"+file$+".exe")
CHDIR "../.."
end if

'detect compilation failure
OPEN file$ + ".exe" FOR BINARY AS #1
IF LOF(1) THEN compfailed = 0 else compfailed = 1
CLOSE #1

IF compfailed THEN
KILL file$ + ".exe"
 if idemode then
 idemessage$="C++ Compilation failed"
 goto ideerror
 end if
PRINT "C++ COMPILATION FAILED!"
END
END IF

if idemode then goto ideret6
SYSTEM


qberror_test:
e=1
resume next

qberror:

if ideerror then 'error happened inside the IDE
sendc$ = CHR$(255) 'a runtime error has occurred
resume sendcommand 'allow IDE to handle error recovery
end if

if err=2 then resume ideerror 'qb64error purposefully generated error 2 (syntax error), only happens in idemode

qberrorhappenedvalue = qberrorhappened
qberrorhappened = 1

if debug then print #9, "QB ERROR!"
if debug then print #9, "ERR="; ERR
if debug then print #9, "ERL="; ERL

if idemode and qberrorhappenedvalue>=0 then
'real qb error occurred
ideerrorline=linenumber
idemessage$="Compiler error (check for syntax errors) (Reference:"+str2$(ERR)+"-"+str2$(_ERRORLINE)+")"
if inclevel>0 then idemessage$=idemessage$+incerror$
resume ideerror
end if

IF qberrorhappenedvalue >= 0 THEN
x=76:goto errnum  'internal comiler error
END IF


qberrorcode = ERR
qberrorline = ERL
IF qberrorhappenedvalue = -1 THEN RESUME qberrorhappened1
IF qberrorhappenedvalue = -2 THEN RESUME qberrorhappened2
IF qberrorhappenedvalue = -3 THEN RESUME qberrorhappened3
end

'directly GOTO'd to from supporting routines
errnum:
'set x to error's value
if os$="WIN" then OPEN ".\internal\qb64\errormes.txt" FOR INPUT AS #50
if os$="LNX" then OPEN "./internal/qb64/errormes.txt" FOR INPUT AS #50
FOR i = 1 TO x
LINE INPUT #50, a$
NEXT
close #50
a$ = RIGHT$(a$, LEN(a$) - INSTR(a$, ","))
errmes: 'set a$ to message
layout$="": layoutok=0 'invalidate layout
if inclevel>0 then a$=a$+incerror$
if idemode then
ideerrorline=linenumber
idemessage$=a$
goto ideerror 'infinitely preferable to RESUME
end if
'non-ide mode output
PRINT
PRINT a$
FOR i = 1 TO LEN(linefragment)
IF MID$(linefragment, i, 1) = sp$ THEN MID$(linefragment, i, 1) = " "
NEXT
FOR i = 1 TO LEN(wholeline)
IF MID$(wholeline, i, 1) = sp$ THEN MID$(wholeline, i, 1) = " "
NEXT
PRINT "Caused by (or after):" + linefragment
PRINT "LINE " + str2(linenumber) + ":" + wholeline
END



FUNCTION allocarray (n2$, elements$, elementsize)
dimsharedlast=dimshared: dimshared=0

if autoarray=1 then autoarray=0: autoary=1 'clear global value & set local value

f12$=""

'changelog:
'added 4 to [2] to indicate cmem array where appropriate

e$ = elements$: n$ = n2$
IF elementsize = -2147483647 THEN stringarray = 1: elementsize = 8

if asc(e$)=63 then '?
l$="("+sp2+")"
undefined=-1
nume=1
if len(e$)=1 then goto undefinedarray
undefined=1
nume=val(right$(e$,len(e$)-1))
goto undefinedarray
end if


'work out how many elements there are (critical to later calculations)
nume = 1
n = numelements(e$)
FOR i = 1 TO n
e2$ = getelement(e$, i)
IF e2$ = "(" THEN b = b + 1
IF b = 0 AND e2$ = "," THEN nume = nume + 1
IF e2$ = ")" THEN b = b - 1
NEXT
if debug then print #9,"numelements count:";nume

descstatic = 0
IF arraydesc THEN
IF id.arrayelements <> nume THEN

if id.arrayelements=-1 then 'unknown
if arrayelementslist(currentid)<>0 and nume<>arrayelementslist(currentid) then nerror(85)
if nume=1 then id.arrayelements=1: ids(currentid).arrayelements=1 'lucky guess!
arrayelementslist(currentid)=nume
else
  nerror (85)
end if

END IF
IF id.staticarray THEN descstatic = 1
END IF

l$="("+sp2

cr$ = CHR$(13) + CHR$(10)
sd$ = ""
constdimensions = 1
ei = 4 + nume * 4 - 4
cure = 1
e3$ = "": e3base$ = ""
FOR i = 1 TO n
e2$ = getelement(e$, i)
IF e2$ = "(" THEN b = b + 1
IF (e2$ = "," and b=0) OR i = n THEN
IF i = n THEN e3$ = e3$ + sp + e2$
e3$ = RIGHT$(e3$, LEN(e3$) - 1)
IF e3base$ <> "" THEN e3base$ = RIGHT$(e3base$, LEN(e3base$) - 1)
'PRINT e3base$ + "[TO]" + e3$
'set the base

basegiven=1
IF e3base$ = "" THEN e3base$ = str2$(optionbase + 0):basegiven=0
constequation = 1

e3base$=fixoperationorder$(e3base$)
if basegiven then l$=l$+tlayout$+sp+"TO"+sp
e3base$=evaluatetotyp$(e3base$,64&)

IF constequation = 0 THEN constdimensions = 0
sd$ = sd$ + n$ + "[" + str2(ei) + "]=" + e3base$ + ";" + cr$
'set the number of indexes
constequation = 1

e3$=fixoperationorder$(e3$)
l$=l$+tlayout$+sp2
if i=n then l$=l$+")" else l$=l$+","+sp
e3$=evaluatetotyp$(e3$,64&)

IF constequation = 0 THEN constdimensions = 0
ei = ei + 1
sd$ = sd$ + n$ + "[" + str2(ei) + "]=(" + e3$ + ")-" + n$ + "[" + str2(ei - 1) + "]+1;" + cr$
ei = ei + 1
'calc muliplier
IF cure = 1 THEN
'set only for the purpose of the calculating correct multipliers
sd$ = sd$ + n$ + "[" + str2(ei) + "]=1;" + cr$
ELSE
sd$ = sd$ + n$ + "[" + str2(ei) + "]=" + n$ + "[" + str2(ei + 4) + "]*" + n$ + "[" + str2(ei + 3) + "];" + cr$
END IF
ei = ei + 1
ei = ei + 1 'skip reserved
ei = ei - 8
cure = cure + 1
e3$ = "": e3base$ = ""
GOTO aanexte
END IF
IF e2$ = ")" THEN b = b - 1
IF ucase$(e2$) = "TO" AND b = 0 THEN
e3base$ = e3$
e3$ = ""
ELSE
e3$ = e3$ + sp + e2$
END IF
aanexte:
NEXT
sd$ = LEFT$(sd$, LEN(sd$) - 2)

undefinedarray:

'calc cmem
cmem = 0
IF arraydesc = 0 THEN
IF cmemlist(idn + 1) THEN cmem = 1
ELSE
IF cmemlist(arraydesc) THEN cmem = 1
END IF

staticarray = constdimensions
IF subfuncn<>0 and dimstatic=0 THEN staticarray = 0 'arrays in SUBS/FUNCTIONS are DYNAMIC
if dimstatic=3 then staticarray=0 'STATIC arrayname() listed arrays keep thier values but are dynamic in memory
IF dynamic THEN staticarray = 0
IF redimoption THEN staticarray = 0
IF arraydesc THEN
IF staticarray = 1 THEN
IF descstatic THEN nerror (86)
staticarray = 0
END IF
END IF






bytesperelement$ = str2(elementsize)
IF elementsize < 0 THEN
elementsize = -elementsize
bytesperelement$ = str2(elementsize) + "/8+1"
END IF


'Begin creation of array descriptor (if array has not been defined yet)
IF arraydesc = 0 THEN
PRINT #defdatahandle, "long *" + n$ + "=NULL;"
PRINT #13, "if (!" + n$ + "){"
PRINT #13, n$ + "=(long*)mem_static_malloc(" + str2(16 * nume + 16) + ");"
END IF

'generate sizestr$ & elesizestr$ (both are used in various places in following code)
sizestr$=""
FOR i = 1 TO nume
IF i <> 1 THEN  sizestr$=sizestr$+"*"
sizestr$=sizestr$+n$ + "[" + str2(i * 4 - 4 + 5) + "]"
NEXT
elesizestr$=sizestr$ 'elements in entire array
sizestr$=sizestr$+"*"+bytesperelement$ 'bytes in entire array



'------------------STATIC ARRAY CREATION--------------------------------
IF staticarray THEN
'STATIC memory
PRINT #13, sd$ 'setup new array dimension ranges
	'Example of sd$ for DIM a(10):
	'__ARRAY_SINGLE_A[4]= 0 ;
	'__ARRAY_SINGLE_A[5]=( 10 )-__ARRAY_SINGLE_A[4]+1;
	'__ARRAY_SINGLE_A[6]=1;
IF cmem AND stringarray = 0 THEN
	'Note: A string array's pointers are always stored in 64bit memory
 '(static)CONVENTINAL memory
 PRINT #13, n$ + "[0]=(unsigned long)cmem_static_pointer;"
 'alloc mem & check if static memory boundry has oversteped dynamic memory boundry
 PRINT #13, "if ((cmem_static_pointer+=(("+sizestr$+")+15)&-16)>cmem_dynamic_base) error(257);"
 '64K check
 PRINT #13, "if (("+sizestr$+")>65536) error(257);"
 'clear array
 PRINT #13, "memset((void*)(" + n$ + "[0]),0,"+sizestr$+");"
 'set flags
 PRINT #13, n$ + "[2]=1+2+4;" 'init+static+cmem
ELSE
 '64BIT MEMORY
 PRINT #13, n$ + "[0]=(unsigned long)mem_static_malloc("+sizestr$+");"
 IF stringarray THEN 
  'Init string pointers in the array
  PRINT #13, "tmp_long="+elesizestr$+";"
  PRINT #13, "while(tmp_long--){"
  IF cmem THEN
   PRINT #13, "((uint64*)(" + n$ + "[0]))[tmp_long]=(uint64)qbs_new_cmem(0,0);"
  ELSE
   PRINT #13, "((uint64*)(" + n$ + "[0]))[tmp_long]=(uint64)qbs_new(0,0);"
  END IF
  PRINT #13, "}"
 ELSE
  'clear array
  PRINT #13, "memset((void*)(" + n$ + "[0]),0,"+sizestr$+");"
 END IF
 PRINT #13, n$ + "[2]=1+2;" 'init+static
END IF
'Close static array desc
PRINT #13, "}"
allocarray = nume+65536
END IF
'------------------END OF STATIC ARRAY CREATION-------------------------

'------------------DYNAMIC ARRAY CREATION-------------------------------
IF staticarray=0 THEN

if undefined=0 then



'Generate error if array is static
f12$=f12$+crlf+ "if (" + n$ + "[2]&2){" 'static array
f12$=f12$+crlf+ "error(10);"'cannot redefine a static array!
f12$=f12$+crlf+ "}else{"
'Note: Array is either undefined or dynamically defined at this point


'REDIM (not DIM) must be used to redefine an array
IF redimoption = 0 THEN
f12$=f12$+crlf+ "if (" + n$ + "[2]&1){" 'array is defined
f12$=f12$+crlf+ "error(10);"'cannot redefine an array without using REDIM!
f12$=f12$+crlf+ "}else{"
ELSE
'--------ERASE EXISTING ARRAY IF NECESSARY--------

'IMPORTANT: If array is not going to be preserved, it should be cleared before
'           creating the new array for memory considerations

if redimoption = 2 then
f12$=f12$+crlf+"static int32 preserved_elements;" 'must be put here for scope considerations
end if

'If array is defined, it must be destroyed first
f12$=f12$+crlf+ "if (" + n$ + "[2]&1){" 'array is defined

if redimoption=2 then
f12$=f12$+crlf+ "preserved_elements="+elesizestr$+";"
goto skiperase
end if

 'Note: pointers to strings must be freed before array can be freed
 IF stringarray THEN
 f12$=f12$+crlf+ "tmp_long="+elesizestr$+";"
 f12$=f12$+crlf+ "while(tmp_long--) qbs_free((qbs*)((uint64*)(" + n$ + "[0]))[tmp_long]);"
 END IF
'Free array's memory
if stringarray then
 'Note: String arrays are never in cmem
 f12$=f12$+crlf+ "free((void*)(" + n$ + "[0]));"
else
 'Note: Array may be in cmem!
 f12$=f12$+crlf+ "if (" + n$ + "[2]&4){" 'array is in cmem
 f12$=f12$+crlf+ "cmem_dynamic_free((unsigned char*)(" + n$ + "[0]));" 
 f12$=f12$+crlf+ "}else{" 'not in cmem
 f12$=f12$+crlf+ "free((void*)(" + n$ + "[0]));"
 f12$=f12$+crlf+ "}"
end if

skiperase:

f12$=f12$+crlf+ "}" 'array was defined
if redimoption = 2 then
f12$=f12$+crlf+ "else preserved_elements=0;" 'if array wasn't defined, no elements are preserved
end if


'--------ERASED ARRAY AS NECESSARY--------
END IF 'redim specified


'--------CREATE ARRAY & CLEAN-UP CODE--------
'Overwrite existing array dimension sizes/ranges
f12$=f12$+crlf+ sd$
IF stringarray THEN

 'Note: String arrays are always created in 64bit memory

if redimoption = 2 then
f12$=f12$+crlf+ "if (preserved_elements){"

f12$=f12$+crlf+ "static int32 tmp_long2;"

'free any qbs strings which will be lost in the realloc
f12$=f12$+crlf+ "tmp_long="+elesizestr$+";"
f12$=f12$+crlf+ "if (tmp_long<preserved_elements){"
f12$=f12$+crlf+ "for(tmp_long2=tmp_long;tmp_long2<preserved_elements;tmp_long2++) qbs_free((qbs*)((uint64*)(" + n$ + "[0]))[tmp_long2]);"
f12$=f12$+crlf+ "}"
'reallocate the array
f12$=f12$+crlf+ n$ + "[0]=(unsigned long)realloc((void*)("+n$+"[0]),tmp_long*"+bytesperelement$+");"
f12$=f12$+crlf+ "if (!" + n$ + "[0]) error(257);" 'not enough memory
f12$=f12$+crlf+ "if (preserved_elements<tmp_long){"
f12$=f12$+crlf+ "for(tmp_long2=preserved_elements;tmp_long2<tmp_long;tmp_long2++){"
 f12$=f12$+crlf+ "if (" + n$ + "[2]&4){" 'array is in cmem
 f12$=f12$+crlf+ "((uint64*)(" + n$ + "[0]))[tmp_long2]=(uint64)qbs_new_cmem(0,0);"
 f12$=f12$+crlf+ "}else{" 'not in cmem
 f12$=f12$+crlf+ "((uint64*)(" + n$ + "[0]))[tmp_long2]=(uint64)qbs_new(0,0);"
 f12$=f12$+crlf+ "}" 'not in cmem
f12$=f12$+crlf+ "}"
f12$=f12$+crlf+ "}"

f12$=f12$+crlf+ "}else{"
end if

 '1. Create string array
 f12$=f12$+crlf+ n$ + "[0]=(unsigned long)malloc("+sizestr$+");"
 f12$=f12$+crlf+ "if (!" + n$ + "[0]) error(257);" 'not enough memory
 f12$=f12$+crlf+ n$ + "[2]|=1;" 'ADD initialized flag
 f12$=f12$+crlf+ "tmp_long="+elesizestr$+";"


 'init individual strings
 f12$=f12$+crlf+ "if (" + n$ + "[2]&4){" 'array is in cmem
 f12$=f12$+crlf+ "while(tmp_long--) ((uint64*)(" + n$ + "[0]))[tmp_long]=(uint64)qbs_new_cmem(0,0);"
 f12$=f12$+crlf+ "}else{" 'not in cmem
 f12$=f12$+crlf+ "while(tmp_long--) ((uint64*)(" + n$ + "[0]))[tmp_long]=(uint64)qbs_new(0,0);"
 f12$=f12$+crlf+ "}" 'not in cmem

if redimoption = 2 then
f12$=f12$+crlf+ "}"
end if


 '2. Generate "clean up" code (called when EXITING A SUB/FUNCTION)
 if arraydesc=0 then 'only add for first declaration of the array
 PRINT #19, "if (" + n$ + "[2]&1){"'initialized?
 PRINT #19, "tmp_long="+elesizestr$+";"
 PRINT #19, "while(tmp_long--) qbs_free((qbs*)((uint64*)(" + n$ + "[0]))[tmp_long]);"
 PRINT #19, "free((void*)(" + n$ + "[0]));"
 PRINT #19, "}"
 end if


else 'not string array

 '1. Create array
 f12$=f12$+crlf+ "if (" + n$ + "[2]&4){" 'array will be in cmem

if redimoption = 2 then
f12$=f12$+crlf+ "if (preserved_elements){"

  'reallocation method
  'backup data
  f12$=f12$+crlf+"memcpy(redim_preserve_cmem_buffer,(void*)("+n$+"[0]),preserved_elements*"+bytesperelement$+");"
  'free old array
  f12$=f12$+crlf+ "cmem_dynamic_free((unsigned char*)(" + n$ + "[0]));"
  f12$=f12$+crlf+ "tmp_long="+elesizestr$+";"
  f12$=f12$+crlf+ n$ + "[0]=(unsigned long)cmem_dynamic_malloc(tmp_long*"+bytesperelement$+");"
  f12$=f12$+crlf+"memcpy((void*)("+n$+"[0]),redim_preserve_cmem_buffer,preserved_elements*"+bytesperelement$+");"
  f12$=f12$+crlf+ "if (preserved_elements<tmp_long) ZeroMemory(((uint8*)("+n$+"[0]))+preserved_elements*"+bytesperelement$+",(tmp_long-preserved_elements)*"+bytesperelement$+");"

f12$=f12$+crlf+ "}else{"
end if

  'standard cmem method
  f12$=f12$+crlf+ n$ + "[0]=(unsigned long)cmem_dynamic_malloc("+sizestr$+");"
  'clear array
  f12$=f12$+crlf+ "memset((void*)(" + n$ + "[0]),0,"+sizestr$+");"

if redimoption = 2 then
f12$=f12$+crlf+ "}"
end if


 f12$=f12$+crlf+ "}else{" 'not in cmem

if redimoption = 2 then
f12$=f12$+crlf+ "if (preserved_elements){"
  'reallocation method
  f12$=f12$+crlf+ "tmp_long="+elesizestr$+";"
  f12$=f12$+crlf+ n$ + "[0]=(unsigned long)realloc((void*)("+n$+"[0]),tmp_long*"+bytesperelement$+");"
  f12$=f12$+crlf+ "if (!" + n$ + "[0]) error(257);" 'not enough memory
  f12$=f12$+crlf+ "if (preserved_elements<tmp_long) ZeroMemory(((uint8*)("+n$+"[0]))+preserved_elements*"+bytesperelement$+",(tmp_long-preserved_elements)*"+bytesperelement$+");"
f12$=f12$+crlf+ "}else{"
end if
  'standard allocation method
  f12$=f12$+crlf+ n$ + "[0]=(unsigned long)calloc("+sizestr$+",1);"
  f12$=f12$+crlf+ "if (!" + n$ + "[0]) error(257);" 'not enough memory
if redimoption = 2 then
f12$=f12$+crlf+ "}"
end if

 f12$=f12$+crlf+ "}" 'not in cmem
 f12$=f12$+crlf+ n$ + "[2]|=1;" 'ADD initialized flag

 '2. Generate "clean up" code (called when EXITING A SUB/FUNCTION)
 if arraydesc=0 then 'only add for first declaration of the array
 PRINT #19, "if (" + n$ + "[2]&1){"'initialized?
 print #19, "if (" + n$ + "[2]&4){" 'array is in cmem
  PRINT #19, "cmem_dynamic_free((unsigned char*)(" + n$ + "[0]));"
 print #19, "}else{"
  PRINT #19, "free((void*)(" + n$ + "[0]));"
 PRINT #19, "}" 'cmem
 PRINT #19, "}" 'init
 end if
end if 'not string array

end if 'undefined=0

'----FINISH ARRAY DESCRIPTOR IF DEFINING FOR THE FIRST TIME----
IF arraydesc = 0 THEN
'Note: Array is init as undefined (& possibly a cmem flag)
if cmem then PRINT #13, n$ + "[2]=4;" else PRINT #13, n$ + "[2]=0;"
'set dimensions as undefined
FOR i = 1 TO nume
b = i * 4
PRINT #13, n$ + "[" + str2(b) + "]=2147483647;"'base
PRINT #13, n$ + "[" + str2(b + 1) + "]=0;"'num. index
PRINT #13, n$ + "[" + str2(b + 2) + "]=0;"'multiplier
NEXT
IF stringarray THEN
 'set array's data offset to the offset of the offset to nothingstring
 PRINT #13, n$ + "[0]=(long)&nothingstring;"
ELSE
 'set array's data offset to "nothing"
 PRINT #13, n$ + "[0]=(unsigned long)nothingvalue;"
END IF
PRINT #13, "}" 'close array descriptor
END IF 'arraydesc = 0

if undefined =0 then

IF redimoption = 0 THEN f12$=f12$+crlf+ "}" 'if REDIM not specified the above is conditional
f12$=f12$+crlf+ "}" 'not static

end if 'undefined=0

allocarray = nume
if undefined=-1 then allocarray=-1

END IF

if autoary=0 then print #12, f12$

'[8] offset of data
'[8] reserved (could be used to store a bit offset)
'(the following repeats depending on the number of elements)
'[4] base-offset
'[4] number of indexes
'[4] multiplier (the last multiplier doesn't actually exist)
'[4] reserved

dimshared=dimsharedlast

tlayout$=l$
END FUNCTION

FUNCTION arrayreference$ (indexes$, typ)
arrayprocessinghappened = 1
'*returns an array reference: idnumberindex$
'*does not take into consideration the type of the array
'*expects array id to be passed in the global id structure





idnumber$ = str2(currentid)

DIM id2 AS idstruct

id2 = id

a$ = indexes$
typ = id2.arraytype + ISARRAY + ISREFERENCE
n$ = RTRIM$(id2.callname)

IF a$ = "" THEN 'no indexes passed eg. a()
r$ = "0"
GOTO gotarrayindex
END IF

n = numelements(a$)

'find number of elements supplied
elements=1
b=0
FOR i = 1 TO n
a = asc(getelement(a$, i))
if a=40 then b=b+1
if a=41 then b=b-1
if a=44 and b=0 then elements=elements+1
next

if id2.arrayelements=-1 then
if arrayelementslist(currentid)<>0 and elements<>arrayelementslist(currentid) then nerror(85)
if elements=1 then id2.arrayelements=1: ids(currentid).arrayelements=1 'lucky guess
arrayelementslist(currentid)=elements
else
if elements<>id2.arrayelements then nerror(85)
end if

curarg = 1
firsti = 1
FOR i = 1 TO n
l$ = getelement(a$, i)
IF l$ = "(" THEN b = b + 1
IF l$ = ")" THEN b = b - 1
IF (l$ = "," AND b = 0) OR (i = n) THEN
IF i = n THEN
e$ = evaluatetotyp(getelements$(a$, firsti, i), 64&)
ELSE
e$ = evaluatetotyp(getelements$(a$, firsti, i - 1), 64&)
END IF
argi = (elements - curarg) * 4 + 4
IF curarg = 1 THEN
r$ = r$ + "array_check((" + e$ + ")-" + n$ + "[" + str2(argi) + "]," + n$ + "[" + str2(argi + 1) + "])+"
ELSE
r$ = r$ + "array_check((" + e$ + ")-" + n$ + "[" + str2(argi) + "]," + n$ + "[" + str2(argi + 1) + "])*" + n$ + "[" + str2(argi + 2) + "]+"
END IF
firsti = i + 1
curarg = curarg + 1
END IF
NEXT
r$ = LEFT$(r$, LEN(r$) - 1) 'remove trailing +
gotarrayindex:

r$ = idnumber$ + "" + r$
arrayreference$ = r$
'PRINT "arrayreference returning:" + r$

END FUNCTION

SUB assign (a$,n)
for i=1 to n
c=asc(getelement$(a$,i))
if c=40 then b=b+1 '(
if c=41 then b=b-1 ')
if c=61 and b=0 then '=
if i=1 then qb64error "Expected ... ="
if i=n then qb64error "Expected = ..."

a2$=fixoperationorder(getelements$(a$,1,i-1))
l$=tlayout$+sp+"="+sp

'note: evaluating a2$ will fail if it is setting a function's return value without this check (as the function, not the return-variable) will be found by evaluate)
if i=2 then 'lhs has only 1 element
 try = findid(a2$)
 DO WHILE try
 IF id.t THEN
 IF (id.t and ISUDT)=0 then
 makeidrefer a2$, typ
 goto assignsimplevariable
 end if
 END IF
 IF try = 2 THEN findanotherid = 1: try = findid(a2$) ELSE try = 0
 LOOP
end if

a2$=evaluate$(a2$,typ)
assignsimplevariable:
if (typ AND ISREFERENCE)=0 then qb64error "Expected variable ="
setrefer a2$,typ,getelements$(a$,i+1,n),0
tlayout$=l$+tlayout$

exit sub

end if '=,b=0
next
qb64error "Expected ="
END SUB

SUB clearid
id=cleariddata
END SUB

SUB closemain
xend
PRINT #12, "return NULL;"
PRINT #12, "}"
PRINT #15, "}"'end case
PRINT #15, "}"
print #15, "if(event_return)return NULL;"
PRINT #15, "error(3);"'no valid return possible

closedmain = 1

END SUB

FUNCTION countelements (a$)
n = numelements(a$)
c = 1
FOR i = 1 TO n
e$ = getelement$(a$, i)
IF e$ = "(" THEN b = b + 1
IF e$ = ")" THEN b = b - 1
IF b < 0 THEN qb64error "Unexpected ) encountered"
IF e$ = "," AND b = 0 THEN c = c + 1
NEXT
countelements = c
END FUNCTION



FUNCTION dim2 (varname$, typ2$, method, elements$)

'notes: (DO NOT REMOVE THESE IMPORTANT USAGE NOTES)
'
'(shared)dimsfarray: Creates an ID only (no C++ code)
'                    Adds an index/'link' to the sub/function's argument
'                        ID.sfid=glinkid
'                        ID.sfarg=glinkarg
'                    Sets arrayelements=-1 'unknown' (if elements$="?") otherwise val(elements$)
'                    ***Does not refer to arrayelementslist()***
'
'(argument)method: 0 being created by a DIM name AS type
'                  1 being created by a DIM name+symbol
'                  or automatically without the use of DIM
'
'elements$="?": (see also dimsfarray for that special case)
'               Checks arrayelementslist() and;
'               if unknown(=0), creates an ID only
'               if known, creates a DYNAMIC array's C++ initialization code so it can be used later






typ$ = typ2$
dim2 = 1'success

if debug then print #9, "dim2 called"

cvarname$=varname$
l$=cvarname$
varname$=ucase$(varname$)

IF dimsfarray = 1 THEN f = 0 ELSE f = 1

if dimstatic<>0 and dimshared=0 then
'name will have include the sub/func name in its scope
'variable/array will be created in main on startup
defdatahandle=18 'change from 13 to 18(global.txt)
close #13:open tmpdir$+"maindata.txt" for append as #13
close #19:open tmpdir$+"mainfree.txt" for append as #19
end if


scope2$ = module$ + "_" + subfunc$ + "_"
'Note: when REDIMing a SHARED array in dynamic memory scope2$ must be modified

IF LEN(typ$) = 0 THEN nerror (102)

'UDT
'is it a udt?
for i=1 to lasttype
if typ$=rtrim$(udtxname(i)) then
dim2typepassback$=rtrim$(udtxcname(i))

n$ = "UDT_" + varname$

'array of UDTs
IF elements$ <> "" THEN
arraydesc = 0
if f=1 then
try = findid(varname$)
DO WHILE try
IF (id.arraytype) THEN
l$=rtrim$(id.cn)
arraydesc = currentid: scope2$=scope$
exit do
END IF
IF try = 2 THEN findanotherid = 1: try = findid(varname$) ELSE try = 0
LOOP
end if
n$ = scope2$ + "ARRAY_" + n$
bits=udtxsize(i)
if udtxbytealign(i) then
if bits mod 8 then bits=bits+8-(bits mod 8)
end if

IF f = 1 THEN

if len(elements$)=1 and asc(elements$)=63 then '"?"
e=arrayelementslist(idn+1): if e then elements$=elements$+str2$(e) 'eg. "?3" for a 3 dimensional array
end if
nume = allocarray(n$, elements$, -bits)
l$=l$+sp+tlayout$
IF arraydesc THEN goto dim2exitfunc
clearid

ELSE
 clearid
 IF elements$ = "?" THEN
 nume = -1
 id.linkid = glinkid
 id.linkarg = glinkarg
 ELSE
 nume = VAL(elements$)
 END IF
END IF

id.arraytype = ISUDT+i
IF cmemlist(idn + 1) THEN id.arraytype = id.arraytype + ISINCONVENTIONALMEMORY
id.n = cvarname$

if nume>65536 then nume=nume-65536: id.staticarray = 1

id.arrayelements = nume
id.callname = n$
regid
goto dim2exitfunc
END IF

'not an array of UDTs
bits=udtxsize(i): bytes=bits\8
if bits MOD 8 then
bytes=bytes+1
end if
n$ = scope2$ + n$
IF f THEN PRINT #defdatahandle, "void *" + n$ + "=NULL;"
clearid
id.n = cvarname$
id.t = ISUDT+i
IF cmemlist(idn + 1) THEN
id.t = id.t + ISINCONVENTIONALMEMORY
IF f THEN PRINT #13, "if(" + n$ + "==NULL){"
IF f THEN PRINT #13, "cmem_sp-=" + str2(bytes) + ";"
IF f THEN PRINT #13, "if (cmem_sp<qbs_cmem_sp) error(257);"
IF f THEN PRINT #13, n$ + "=(void*)(dblock+cmem_sp);"
IF f THEN PRINT #13, "memset(" + n$ + ",0," + str2(bytes) + ");"
IF f THEN PRINT #13, "}"
ELSE
IF f THEN PRINT #13, "if(" + n$ + "==NULL){"
IF f THEN PRINT #13, n$ + "=(void*)mem_static_malloc(" + str2$(bytes) + ");"
IF f THEN PRINT #13, "memset(" + n$ + ",0," + str2(bytes) + ");"
IF f THEN PRINT #13, "}"
END IF
regid
goto dim2exitfunc
end if
next i
'it isn't a udt

typ$=symbol2fulltypename$(typ$)

'check if _UNSIGNED was specified
unsgn = 0
IF LEFT$(typ$, 10) = "_UNSIGNED " THEN
unsgn = 1
typ$ = RIGHT$(typ$, LEN(typ$) - 10)
IF LEN(typ$) = 0 THEN nerror (108)
END IF

n$ = "" 'n$ is assumed to be "" after branching into the code for each type

IF LEFT$(typ$, 6) = "STRING" THEN

IF LEN(typ$) > 6 THEN
IF LEFT$(typ$, 9) <> "STRING * " THEN nerror (109)

c$ = RIGHT$(typ$, LEN(typ$) - 9)
IF isuinteger(c$) = 0 THEN nerror (110)
IF LEN(c$) > 10 THEN nerror (111)
bytes = VAL(c$)
IF bytes = 0 THEN nerror (112)
n$ = "STRING" + str2(bytes) + "_" + varname$

'array of fixed length strings
IF elements$ <> "" THEN
arraydesc = 0
if f=1 then
try = findid(varname$ + "$")
DO WHILE try
IF (id.arraytype) THEN
l$=rtrim$(id.cn)
arraydesc = currentid: scope2$=scope$
exit do
END IF
IF try = 2 THEN findanotherid = 1: try = findid(varname$ + "$") ELSE try = 0
LOOP
end if
n$ = scope2$ + "ARRAY_" + n$

'nume = allocarray(n$, elements$, bytes)
'IF arraydesc THEN goto dim2exitfunc 'id already exists!
'clearid

IF f = 1 THEN

if len(elements$)=1 and asc(elements$)=63 then '"?"
e=arrayelementslist(idn+1): if e then elements$=elements$+str2$(e) 'eg. "?3" for a 3 dimensional array
end if
nume = allocarray(n$, elements$, bytes)
l$=l$+sp+tlayout$
IF arraydesc THEN goto dim2exitfunc
clearid

ELSE
 clearid
 IF elements$ = "?" THEN
 nume = -1
 id.linkid = glinkid
 id.linkarg = glinkarg
 ELSE
 nume = VAL(elements$)
 END IF
END IF

id.arraytype = STRINGTYPE + ISFIXEDLENGTH
IF cmemlist(idn + 1) THEN id.arraytype = id.arraytype + ISINCONVENTIONALMEMORY
id.n = cvarname$
if nume>65536 then nume=nume-65536: id.staticarray = 1

id.arrayelements = nume
id.callname = n$
id.tsize = bytes
IF method = 0 THEN
id.mayhave = "$" + str2(bytes)
END IF
IF method = 1 THEN
id.musthave = "$" + str2(bytes)
END IF
regid
goto dim2exitfunc
END IF

'standard fixed length string
n$ = scope2$ + n$
IF f THEN PRINT #defdatahandle, "qbs *" + n$ + "=NULL;"
IF f THEN PRINT #19, "qbs_free(" + n$ + ");"'so descriptor can be freed
clearid
id.n = cvarname$
id.t = STRINGTYPE + ISFIXEDLENGTH
IF cmemlist(idn + 1) THEN
id.t = id.t + ISINCONVENTIONALMEMORY
IF f THEN PRINT #13, "if(" + n$ + "==NULL){"
IF f THEN PRINT #13, "cmem_sp-=" + str2(bytes) + ";"
IF f THEN PRINT #13, "if (cmem_sp<qbs_cmem_sp) error(257);"
IF f THEN PRINT #13, n$ + "=qbs_new_fixed((unsigned char*)(dblock+cmem_sp)," + str2(bytes) + ",0);"
IF f THEN PRINT #13, "memset(" + n$ + "->chr,0," + str2(bytes) + ");"
IF f THEN PRINT #13, "}"
ELSE
IF f THEN PRINT #13, "if(" + n$ + "==NULL){"
o$ = "(unsigned char*)mem_static_malloc(" + str2$(bytes) + ")"
IF f THEN PRINT #13, n$ + "=qbs_new_fixed(" + o$ + "," + str2$(bytes) + ",0);"
IF f THEN PRINT #13, "memset(" + n$ + "->chr,0," + str2$(bytes) + ");"
IF f THEN PRINT #13, "}"
END IF
id.tsize = bytes
IF method = 0 THEN
id.mayhave = "$" + str2(bytes)
END IF
IF method = 1 THEN
id.musthave = "$" + str2(bytes)
END IF
regid
goto dim2exitfunc
END IF

'variable length string processing
n$ = "STRING_" + varname$

'array of variable length strings
IF elements$ <> "" THEN
arraydesc = 0
if f=1 then
try = findid(varname$ + "$")
DO WHILE try
IF (id.arraytype) THEN
l$=rtrim$(id.cn)
arraydesc = currentid: scope2$=scope$
exit do
END IF
IF try = 2 THEN findanotherid = 1: try = findid(varname$ + "$") ELSE try = 0
LOOP
end if
n$ = scope2$ + "ARRAY_" + n$

'nume = allocarray(n$, elements$, -2147483647) '-2147483647=STRING
'IF arraydesc THEN goto dim2exitfunc 'id already exists!
'clearid

IF f = 1 THEN

if len(elements$)=1 and asc(elements$)=63 then '"?"
e=arrayelementslist(idn+1): if e then elements$=elements$+str2$(e) 'eg. "?3" for a 3 dimensional array
end if
nume = allocarray(n$, elements$, -2147483647)
l$=l$+sp+tlayout$
IF arraydesc THEN goto dim2exitfunc
clearid

ELSE
 clearid
 IF elements$ = "?" THEN
 nume = -1
 id.linkid = glinkid
 id.linkarg = glinkarg
 ELSE
 nume = VAL(elements$)
 END IF
END IF

id.n = cvarname$
id.arraytype = STRINGTYPE
IF cmemlist(idn + 1) THEN id.arraytype = id.arraytype + ISINCONVENTIONALMEMORY
if nume>65536 then nume=nume-65536: id.staticarray = 1

id.arrayelements = nume
id.callname = n$
IF method = 0 THEN
id.mayhave = "$"
END IF
IF method = 1 THEN
id.musthave = "$"
END IF
regid
goto dim2exitfunc
END IF

'standard variable length string
n$ = scope2$ + n$
clearid
id.n = cvarname$
id.t = STRINGTYPE
IF cmemlist(idn + 1) THEN
IF f THEN PRINT #defdatahandle, "qbs *" + n$ + "=NULL;"
IF f THEN PRINT #13, "if (!" + n$ + ")" + n$ + "=qbs_new_cmem(0,0);"
id.t = id.t + ISINCONVENTIONALMEMORY
ELSE
IF f THEN PRINT #defdatahandle, "qbs *" + n$ + "=NULL;"
IF f THEN PRINT #13, "if (!" + n$ + ")" + n$ + "=qbs_new(0,0);"
END IF
IF f THEN PRINT #19, "qbs_free(" + n$ + ");"
IF method = 0 THEN
id.mayhave = "$"
END IF
IF method = 1 THEN
id.musthave = "$"
END IF
regid
goto dim2exitfunc
END IF

IF LEFT$(typ$, 4) = "_BIT" THEN
IF LEN(typ$) > 4 THEN
IF LEFT$(typ$, 7) <> "_BIT * " THEN nerror (113)
c$ = RIGHT$(typ$, LEN(typ$) - 7)
IF isuinteger(c$) = 0 THEN nerror (114)
IF LEN(c$) > 2 THEN nerror (115)
bits = VAL(c$)
IF bits = 0 THEN nerror (116)
IF bits > 57 THEN nerror (117)
ELSE
bits = 1
END IF
if bits<=32 then ct$="int32" else ct$="int64"
IF unsgn THEN n$ = "U": ct$ = "u" + ct$
n$ = n$ + "BIT" + str2(bits) + "_" + varname$

'array of bit-length variables
IF elements$ <> "" THEN
arraydesc = 0
cmps$ = varname$: IF unsgn THEN cmps$ = cmps$ + "~"
cmps$ = cmps$ + "`" + str2(bits)
if f=1 then
try = findid(cmps$)
DO WHILE try
IF (id.arraytype) THEN
l$=rtrim$(id.cn)
arraydesc = currentid: scope2$=scope$
exit do
END IF
IF try = 2 THEN findanotherid = 1: try = findid(cmps$) ELSE try = 0
LOOP
end if
n$ = scope2$ + "ARRAY_" + n$

'nume = allocarray(n$, elements$, -bits) 'passing a negative element size signifies bits not bytes
'IF arraydesc THEN goto dim2exitfunc 'id already exists!
'clearid

IF f = 1 THEN

if len(elements$)=1 and asc(elements$)=63 then '"?"
e=arrayelementslist(idn+1): if e then elements$=elements$+str2$(e) 'eg. "?3" for a 3 dimensional array
end if
nume = allocarray(n$, elements$, -bits)
l$=l$+sp+tlayout$
IF arraydesc THEN goto dim2exitfunc
clearid

ELSE
 clearid
 IF elements$ = "?" THEN
 nume = -1
 id.linkid = glinkid
 id.linkarg = glinkarg
 ELSE
 nume = VAL(elements$)
 END IF
END IF

id.n = cvarname$
id.arraytype = BITTYPE - 1 + bits
IF unsgn THEN id.arraytype = id.arraytype + ISUNSIGNED
IF cmemlist(idn + 1) THEN id.arraytype = id.arraytype + ISINCONVENTIONALMEMORY
if nume>65536 then nume=nume-65536: id.staticarray = 1

id.arrayelements = nume
id.callname = n$
IF method = 0 THEN
IF unsgn THEN id.mayhave = "~`" + str2(bits) ELSE id.mayhave = "`" + str2(bits)
END IF
IF method = 1 THEN
IF unsgn THEN id.musthave = "~`" + str2(bits) ELSE id.musthave = "`" + str2(bits)
END IF
regid
goto dim2exitfunc
END IF
'standard bit-length variable
n$ = scope2$ + n$
PRINT #defdatahandle, ct$ + " *" + n$ + "=NULL;"
PRINT #13, "if(" + n$ + "==NULL){"
PRINT #13, "cmem_sp-=4;"
PRINT #13, "if (cmem_sp<qbs_cmem_sp) error(257);"
PRINT #13, n$ + "=(" + ct$ + "*)(dblock+cmem_sp);"
PRINT #13, "*" + n$ + "=0;"
PRINT #13, "}"
clearid
id.n = cvarname$
id.t = BITTYPE - 1 + bits + ISINCONVENTIONALMEMORY: IF unsgn THEN id.t = id.t + ISUNSIGNED
IF method = 0 THEN
IF unsgn THEN id.mayhave = "~`" + str2(bits) ELSE id.mayhave = "`" + str2(bits)
END IF
IF method = 1 THEN
IF unsgn THEN id.musthave = "~`" + str2(bits) ELSE id.musthave = "`" + str2(bits)
END IF
regid
goto dim2exitfunc
END IF

IF typ$ = "_BYTE" THEN
ct$ = "int8"
IF unsgn THEN n$ = "U": ct$ = "u" + ct$
n$ = n$ + "BYTE_" + varname$
IF elements$ <> "" THEN
arraydesc = 0
cmps$ = varname$: IF unsgn THEN cmps$ = cmps$ + "~"
cmps$ = cmps$ + "%%"
if f=1 then
try = findid(cmps$)
DO WHILE try
IF (id.arraytype) THEN
l$=rtrim$(id.cn)
arraydesc = currentid: scope2$=scope$
EXIT DO
END IF
IF try = 2 THEN findanotherid = 1: try = findid(cmps$) ELSE try = 0
LOOP
end if
n$ = scope2$ + "ARRAY_" + n$

'nume = allocarray(n$, elements$, 1)
'IF arraydesc THEN goto dim2exitfunc
'clearid

IF f = 1 THEN

if len(elements$)=1 and asc(elements$)=63 then '"?"
e=arrayelementslist(idn+1): if e then elements$=elements$+str2$(e) 'eg. "?3" for a 3 dimensional array
end if
nume = allocarray(n$, elements$, 1)
l$=l$+sp+tlayout$
IF arraydesc THEN goto dim2exitfunc
clearid

ELSE
 clearid
 IF elements$ = "?" THEN
 nume = -1
 id.linkid = glinkid
 id.linkarg = glinkarg
 ELSE
 nume = VAL(elements$)
 END IF
END IF

id.arraytype = BYTETYPE: IF unsgn THEN id.arraytype = id.arraytype + ISUNSIGNED
IF cmemlist(idn + 1) THEN id.arraytype = id.arraytype + ISINCONVENTIONALMEMORY
if nume>65536 then nume=nume-65536: id.staticarray = 1

id.arrayelements = nume
id.callname = n$
ELSE
n$ = scope2$ + n$
clearid
id.t = BYTETYPE: IF unsgn THEN id.t = id.t + ISUNSIGNED
IF f = 1 THEN PRINT #defdatahandle, ct$ + " *" + n$ + "=NULL;"
IF f = 1 THEN PRINT #13, "if(" + n$ + "==NULL){"
IF cmemlist(idn + 1) THEN
id.t = id.t + ISINCONVENTIONALMEMORY
IF f = 1 THEN PRINT #13, "cmem_sp-=1;"
IF f = 1 THEN PRINT #13, n$ + "=(" + ct$ + "*)(dblock+cmem_sp);"
IF f = 1 THEN PRINT #13, "if (cmem_sp<qbs_cmem_sp) error(257);"
ELSE
IF f = 1 THEN PRINT #13, n$ + "=(" + ct$ + "*)mem_static_malloc(1);"
END IF
IF f = 1 THEN PRINT #13, "*" + n$ + "=0;"
IF f = 1 THEN PRINT #13, "}"
END IF
id.n = cvarname$
IF method = 0 THEN
IF unsgn THEN id.mayhave = "~%%" ELSE id.mayhave = "%%"
END IF
IF method = 1 THEN
IF unsgn THEN id.musthave = "~%%" ELSE id.musthave = "%%"
END IF
regid
goto dim2exitfunc
END IF

IF typ$ = "INTEGER" THEN
ct$ = "int16"
IF unsgn THEN n$ = "U": ct$ = "u" + ct$
n$ = n$ + "INTEGER_" + varname$

IF elements$ <> "" THEN
arraydesc = 0
cmps$ = varname$: IF unsgn THEN cmps$ = cmps$ + "~"
cmps$ = cmps$ + "%"
if f=1 then
try = findid(cmps$)
DO WHILE try
IF (id.arraytype) THEN
l$=rtrim$(id.cn)
arraydesc = currentid: scope2$=scope$
EXIT DO
END IF
IF try = 2 THEN findanotherid = 1: try = findid(cmps$) ELSE try = 0
LOOP
end if
n$ = scope2$ + "ARRAY_" + n$

IF f = 1 THEN

if len(elements$)=1 and asc(elements$)=63 then '"?"
e=arrayelementslist(idn+1): if e then elements$=elements$+str2$(e) 'eg. "?3" for a 3 dimensional array
end if
nume = allocarray(n$, elements$, 2)
l$=l$+sp+tlayout$
IF arraydesc THEN goto dim2exitfunc
clearid

ELSE
 clearid
 IF elements$ = "?" THEN
 nume = -1
 id.linkid = glinkid
 id.linkarg = glinkarg
 ELSE
 nume = VAL(elements$)
 END IF
END IF


id.arraytype = INTEGERTYPE: IF unsgn THEN id.arraytype = id.arraytype + ISUNSIGNED
IF cmemlist(idn + 1) THEN id.arraytype = id.arraytype + ISINCONVENTIONALMEMORY
if nume>65536 then nume=nume-65536: id.staticarray = 1

id.arrayelements = nume
id.callname = n$
ELSE
n$ = scope2$ + n$
clearid
id.t = INTEGERTYPE: IF unsgn THEN id.t = id.t + ISUNSIGNED
IF f = 1 THEN PRINT #defdatahandle, ct$ + " *" + n$ + "=NULL;"
IF f = 1 THEN PRINT #13, "if(" + n$ + "==NULL){"
IF cmemlist(idn + 1) THEN
id.t = id.t + ISINCONVENTIONALMEMORY
IF f = 1 THEN PRINT #13, "cmem_sp-=2;"
IF f = 1 THEN PRINT #13, n$ + "=(" + ct$ + "*)(dblock+cmem_sp);"
IF f = 1 THEN PRINT #13, "if (cmem_sp<qbs_cmem_sp) error(257);"
ELSE
IF f = 1 THEN PRINT #13, n$ + "=(" + ct$ + "*)mem_static_malloc(2);"
END IF
IF f = 1 THEN PRINT #13, "*" + n$ + "=0;"
IF f = 1 THEN PRINT #13, "}"
END IF
id.n = cvarname$
IF method = 0 THEN
IF unsgn THEN id.mayhave = "~%" ELSE id.mayhave = "%"
END IF
IF method = 1 THEN
IF unsgn THEN id.musthave = "~%" ELSE id.musthave = "%"
END IF
regid
goto dim2exitfunc
END IF

IF typ$ = "LONG" THEN
ct$ = "int32"
IF unsgn THEN n$ = "U": ct$ = "u" + ct$
n$ = n$ + "LONG_" + varname$
IF elements$ <> "" THEN
arraydesc = 0
cmps$ = varname$: IF unsgn THEN cmps$ = cmps$ + "~"
cmps$ = cmps$ + "&"
if f=1 then
try = findid(cmps$)
DO WHILE try
IF (id.arraytype) THEN
l$=rtrim$(id.cn)
arraydesc = currentid: scope2$=scope$
EXIT DO
END IF
IF try = 2 THEN findanotherid = 1: try = findid(cmps$) ELSE try = 0
LOOP
end if
n$ = scope2$ + "ARRAY_" + n$

'nume = allocarray(n$, elements$, 4)
'IF arraydesc THEN goto dim2exitfunc
'clearid

IF f = 1 THEN

if len(elements$)=1 and asc(elements$)=63 then '"?"
e=arrayelementslist(idn+1): if e then elements$=elements$+str2$(e) 'eg. "?3" for a 3 dimensional array
end if
nume = allocarray(n$, elements$, 4)
l$=l$+sp+tlayout$
IF arraydesc THEN goto dim2exitfunc
clearid

ELSE
 clearid
 IF elements$ = "?" THEN
 nume = -1
 id.linkid = glinkid
 id.linkarg = glinkarg
 ELSE
 nume = VAL(elements$)
 END IF
END IF

id.arraytype = LONGTYPE: IF unsgn THEN id.arraytype = id.arraytype + ISUNSIGNED
IF cmemlist(idn + 1) THEN id.arraytype = id.arraytype + ISINCONVENTIONALMEMORY
if nume>65536 then nume=nume-65536: id.staticarray = 1

id.arrayelements = nume
id.callname = n$
ELSE
n$ = scope2$ + n$
clearid
id.t = LONGTYPE: IF unsgn THEN id.t = id.t + ISUNSIGNED
IF f = 1 THEN PRINT #defdatahandle, ct$ + " *" + n$ + "=NULL;"
IF f = 1 THEN PRINT #13, "if(" + n$ + "==NULL){"
IF cmemlist(idn + 1) THEN
id.t = id.t + ISINCONVENTIONALMEMORY
IF f = 1 THEN PRINT #13, "cmem_sp-=4;"
IF f = 1 THEN PRINT #13, n$ + "=(" + ct$ + "*)(dblock+cmem_sp);"
IF f = 1 THEN PRINT #13, "if (cmem_sp<qbs_cmem_sp) error(257);"
ELSE
IF f = 1 THEN PRINT #13, n$ + "=(" + ct$ + "*)mem_static_malloc(4);"
END IF
IF f = 1 THEN PRINT #13, "*" + n$ + "=0;"
IF f = 1 THEN PRINT #13, "}"
END IF
id.n = cvarname$
IF method = 0 THEN
IF unsgn THEN id.mayhave = "~&" ELSE id.mayhave = "&"
END IF
IF method = 1 THEN
IF unsgn THEN id.musthave = "~&" ELSE id.musthave = "&"
END IF
regid
goto dim2exitfunc
END IF

IF typ$ = "_INTEGER64" THEN
ct$ = "int64"
IF unsgn THEN n$ = "U": ct$ = "u" + ct$
n$ = n$ + "INTEGER64_" + varname$
IF elements$ <> "" THEN
arraydesc = 0
cmps$ = varname$: IF unsgn THEN cmps$ = cmps$ + "~"
cmps$ = cmps$ + "&&"
if f=1 then
try = findid(cmps$)
DO WHILE try
IF (id.arraytype) THEN
l$=rtrim$(id.cn)
arraydesc = currentid: scope2$=scope$
EXIT DO
END IF
IF try = 2 THEN findanotherid = 1: try = findid(cmps$) ELSE try = 0
LOOP
end if
n$ = scope2$ + "ARRAY_" + n$

'nume = allocarray(n$, elements$, 8)
'IF arraydesc THEN goto dim2exitfunc
'clearid

IF f = 1 THEN

if len(elements$)=1 and asc(elements$)=63 then '"?"
e=arrayelementslist(idn+1): if e then elements$=elements$+str2$(e) 'eg. "?3" for a 3 dimensional array
end if
nume = allocarray(n$, elements$, 8)
l$=l$+sp+tlayout$
IF arraydesc THEN goto dim2exitfunc
clearid

ELSE
 clearid
 IF elements$ = "?" THEN
 nume = -1
 id.linkid = glinkid
 id.linkarg = glinkarg
 ELSE
 nume = VAL(elements$)
 END IF
END IF

id.arraytype = INTEGER64TYPE: IF unsgn THEN id.arraytype = id.arraytype + ISUNSIGNED
IF cmemlist(idn + 1) THEN id.arraytype = id.arraytype + ISINCONVENTIONALMEMORY
if nume>65536 then nume=nume-65536: id.staticarray = 1

id.arrayelements = nume
id.callname = n$
ELSE
n$ = scope2$ + n$
clearid
id.t = INTEGER64TYPE: IF unsgn THEN id.t = id.t + ISUNSIGNED
IF f = 1 THEN PRINT #defdatahandle, ct$ + " *" + n$ + "=NULL;"
IF f = 1 THEN PRINT #13, "if(" + n$ + "==NULL){"
IF cmemlist(idn + 1) THEN
id.t = id.t + ISINCONVENTIONALMEMORY
IF f = 1 THEN PRINT #13, "cmem_sp-=8;"
IF f = 1 THEN PRINT #13, n$ + "=(" + ct$ + "*)(dblock+cmem_sp);"
IF f = 1 THEN PRINT #13, "if (cmem_sp<qbs_cmem_sp) error(257);"
ELSE
IF f = 1 THEN PRINT #13, n$ + "=(" + ct$ + "*)mem_static_malloc(8);"
END IF
IF f = 1 THEN PRINT #13, "*" + n$ + "=0;"
IF f = 1 THEN PRINT #13, "}"
END IF
id.n = cvarname$
IF method = 0 THEN
IF unsgn THEN id.mayhave = "~&&" ELSE id.mayhave = "&&"
END IF
IF method = 1 THEN
IF unsgn THEN id.musthave = "~&&" ELSE id.musthave = "&&"
END IF
regid
goto dim2exitfunc
END IF

IF unsgn = 1 THEN nerror (118)

IF typ$ = "SINGLE" THEN
ct$ = "float"
n$ = n$ + "SINGLE_" + varname$
IF elements$ <> "" THEN
arraydesc = 0
cmps$ = varname$ + "!"
if f=1 then
try = findid(cmps$)
DO WHILE try
IF (id.arraytype) THEN
l$=rtrim$(id.cn)
arraydesc = currentid: scope2$=scope$
EXIT DO
END IF
IF try = 2 THEN findanotherid = 1: try = findid(cmps$) ELSE try = 0
LOOP
end if
n$ = scope2$ + "ARRAY_" + n$

'nume = allocarray(n$, elements$, 4)
'IF arraydesc THEN goto dim2exitfunc
'clearid

IF f = 1 THEN

if len(elements$)=1 and asc(elements$)=63 then '"?"
e=arrayelementslist(idn+1): if e then elements$=elements$+str2$(e) 'eg. "?3" for a 3 dimensional array
end if
nume = allocarray(n$, elements$, 4)
l$=l$+sp+tlayout$
IF arraydesc THEN goto dim2exitfunc
clearid

ELSE
 clearid
 IF elements$ = "?" THEN
 nume = -1
 id.linkid = glinkid
 id.linkarg = glinkarg
 ELSE
 nume = VAL(elements$)
 END IF
END IF

id.arraytype = SINGLETYPE
IF cmemlist(idn + 1) THEN id.arraytype = id.arraytype + ISINCONVENTIONALMEMORY
if nume>65536 then nume=nume-65536: id.staticarray = 1

id.arrayelements = nume
id.callname = n$
ELSE
n$ = scope2$ + n$
clearid
id.t = SINGLETYPE
IF f = 1 THEN PRINT #defdatahandle, ct$ + " *" + n$ + "=NULL;"
IF f = 1 THEN PRINT #13, "if(" + n$ + "==NULL){"
IF cmemlist(idn + 1) THEN
id.t = id.t + ISINCONVENTIONALMEMORY
IF f = 1 THEN PRINT #13, "cmem_sp-=4;"
IF f = 1 THEN PRINT #13, n$ + "=(" + ct$ + "*)(dblock+cmem_sp);"
IF f = 1 THEN PRINT #13, "if (cmem_sp<qbs_cmem_sp) error(257);"
ELSE
IF f = 1 THEN PRINT #13, n$ + "=(" + ct$ + "*)mem_static_malloc(4);"
END IF
IF f = 1 THEN PRINT #13, "*" + n$ + "=0;"
IF f = 1 THEN PRINT #13, "}"
END IF
id.n = cvarname$
IF method = 0 THEN
id.mayhave = "!"
END IF
IF method = 1 THEN
id.musthave = "!"
END IF
regid
goto dim2exitfunc
END IF

IF typ$ = "DOUBLE" THEN
ct$ = "double"
n$ = n$ + "DOUBLE_" + varname$
IF elements$ <> "" THEN
arraydesc = 0
cmps$ = varname$ + "#"
if f=1 then
try = findid(cmps$)
DO WHILE try
IF (id.arraytype) THEN
l$=rtrim$(id.cn)
arraydesc = currentid: scope2$=scope$
EXIT DO
END IF
IF try = 2 THEN findanotherid = 1: try = findid(cmps$) ELSE try = 0
LOOP
end if
n$ = scope2$ + "ARRAY_" + n$

'nume = allocarray(n$, elements$, 8)
'IF arraydesc THEN goto dim2exitfunc
'clearid

IF f = 1 THEN

if len(elements$)=1 and asc(elements$)=63 then '"?"
e=arrayelementslist(idn+1): if e then elements$=elements$+str2$(e) 'eg. "?3" for a 3 dimensional array
end if
nume = allocarray(n$, elements$, 8)
l$=l$+sp+tlayout$
IF arraydesc THEN goto dim2exitfunc
clearid

ELSE
 clearid
 IF elements$ = "?" THEN
 nume = -1
 id.linkid = glinkid
 id.linkarg = glinkarg
 ELSE
 nume = VAL(elements$)
 END IF
END IF

id.arraytype = DOUBLETYPE
IF cmemlist(idn + 1) THEN id.arraytype = id.arraytype + ISINCONVENTIONALMEMORY
if nume>65536 then nume=nume-65536: id.staticarray = 1

id.arrayelements = nume
id.callname = n$
ELSE
n$ = scope2$ + n$
clearid
id.t = DOUBLETYPE
IF f = 1 THEN PRINT #defdatahandle, ct$ + " *" + n$ + "=NULL;"
IF f = 1 THEN PRINT #13, "if(" + n$ + "==NULL){"
IF cmemlist(idn + 1) THEN
id.t = id.t + ISINCONVENTIONALMEMORY
IF f = 1 THEN PRINT #13, "cmem_sp-=8;"
IF f = 1 THEN PRINT #13, n$ + "=(" + ct$ + "*)(dblock+cmem_sp);"
IF f = 1 THEN PRINT #13, "if (cmem_sp<qbs_cmem_sp) error(257);"
ELSE
IF f = 1 THEN PRINT #13, n$ + "=(" + ct$ + "*)mem_static_malloc(8);"
END IF
IF f = 1 THEN PRINT #13, "*" + n$ + "=0;"
IF f = 1 THEN PRINT #13, "}"
END IF
id.n = cvarname$
IF method = 0 THEN
id.mayhave = "#"
END IF
IF method = 1 THEN
id.musthave = "#"
END IF
regid
goto dim2exitfunc
END IF

IF typ$ = "_FLOAT" THEN
ct$ = "long double"
n$ = n$ + "FLOAT_" + varname$
IF elements$ <> "" THEN
arraydesc = 0
cmps$ = varname$ + "##"
if f=1 then
try = findid(cmps$)
DO WHILE try
IF (id.arraytype) THEN
l$=rtrim$(id.cn)
arraydesc = currentid: scope2$=scope$
EXIT DO
END IF
IF try = 2 THEN findanotherid = 1: try = findid(cmps$) ELSE try = 0
LOOP
end if
n$ = scope2$ + "ARRAY_" + n$

'nume = allocarray(n$, elements$, 32)
'IF arraydesc THEN goto dim2exitfunc
'clearid

IF f = 1 THEN

if len(elements$)=1 and asc(elements$)=63 then '"?"
e=arrayelementslist(idn+1): if e then elements$=elements$+str2$(e) 'eg. "?3" for a 3 dimensional array
end if
nume = allocarray(n$, elements$, 32)
l$=l$+sp+tlayout$
IF arraydesc THEN goto dim2exitfunc
clearid

ELSE
 clearid
 IF elements$ = "?" THEN
 nume = -1
 id.linkid = glinkid
 id.linkarg = glinkarg
 ELSE
 nume = VAL(elements$)
 END IF
END IF

id.arraytype = FLOATTYPE
IF cmemlist(idn + 1) THEN id.arraytype = id.arraytype + ISINCONVENTIONALMEMORY
if nume>65536 then nume=nume-65536: id.staticarray = 1

id.arrayelements = nume
id.callname = n$
ELSE
n$ = scope2$ + n$
clearid
id.t = FLOATTYPE
IF f THEN PRINT #defdatahandle, ct$ + " *" + n$ + "=NULL;"
IF f THEN PRINT #13, "if(" + n$ + "==NULL){"
IF cmemlist(idn + 1) THEN
id.t = id.t + ISINCONVENTIONALMEMORY
IF f THEN PRINT #13, "cmem_sp-=32;"
IF f THEN PRINT #13, n$ + "=(" + ct$ + "*)(dblock+cmem_sp);"
IF f THEN PRINT #13, "if (cmem_sp<qbs_cmem_sp) error(257);"
ELSE
IF f THEN PRINT #13, n$ + "=(" + ct$ + "*)mem_static_malloc(32);"
END IF
IF f THEN PRINT #13, "*" + n$ + "=0;"
IF f THEN PRINT #13, "}"
END IF
id.n = cvarname$
IF method = 0 THEN
id.mayhave = "##"
END IF
IF method = 1 THEN
id.musthave = "##"
END IF
regid
goto dim2exitfunc
END IF

nerror (119)
dim2exitfunc:

if dimsfarray then
ids(idn).sfid=glinkid
ids(idn).sfarg=glinkarg
end if

'restore STATIC state
if dimstatic<>0 and dimshared=0 then
defdatahandle=13
close #13:open tmpdir$+"data"+str2$(subfuncn)+".txt" for append as #13
close #19:open tmpdir$+"free"+str2$(subfuncn)+".txt" for append as #19
end if

tlayout$=l$

END FUNCTION


FUNCTION udtreference$ (o$,a$,typ as long)
'UDT REFERENCE FORMAT
'idno|udtno|udtelementno|byteoffset
'     ^udt of the element, not of the id

obak$=o$

'PRINT "called udtreference!"


r$=str2$(currentid)+""


o=0 'the fixed/known part of the offset

incmem=0
if id.t then
u=id.t and 511
if id.t and ISINCONVENTIONALMEMORY then incmem=1
else
u=id.arraytype and 511
if id.arraytype and ISINCONVENTIONALMEMORY then incmem=1
end if
e=0

n=numelements(a$)
if n=0 then goto fulludt

i=1
udtfindelenext:
if getelement$(a$,i)<>"." then qb64error "Expected ."
i=i+1
n$=getelement$(a$,i)
nsym$=removesymbol(n$): if len(nsym$) then ntyp=typname2typ(nsym$): ntypsize=typname2typsize

if n$="" then qb64error "Expected .elementname"
udtfindele:
if e=0 then e=udtxnext(u) else e=udtenext(e)
if e=0 then qb64error "Element not defined"
n2$=rtrim$(udtename(e))
if udtebytealign(e) then
if o mod 8 then o=o+(8-(o mod 8))
end if

if n$<>n2$ then
'increment fixed offset
o=o+udtesize(e)
goto udtfindele
end if

'check symbol after element's name (if given) is correct
if len(nsym$) then

if udtetype(e) and ISUDT then qb64error "Invalid symbol after user defined type"
if ntyp<>udtetype(e) or ntypsize<>udtetypesize(e) then
if nsym$="$" and ((udtetype(e) and ISFIXEDLENGTH)<>0) then goto correctsymbol
qb64error "Incorrect symbol after element name"
end if
end if
correctsymbol:

'Move into another UDT structure?
if i<>n then
if (udtetype(e) and ISUDT)=0 then qb64error "Expected user defined type"
u=udtetype(e) and 511
e=0
i=i+1
goto udtfindelenext
end if

'Change e reference to u0 reference?
if udtetype(e) and ISUDT then
u=udtetype(e) and 511
e=0
end if

fulludt:

r$=r$+str2$(u)+""+str2$(e)+""

if o mod 8 then qb64error "QB64 cannot handle bit offsets within user defined types yet"
o=o\8

if o$<>"" then
 if o<>0 then 'dont add an unnecessary 0
  o$=o$+"+"+str2$(o)
 end if
else
 o$=str2$(o)
end if

r$=r$+o$

udtreference$=r$
typ = udtetype(e) + ISUDT + ISREFERENCE

'full udt override:
if e=0 then
typ = u + ISUDT + ISREFERENCE
end if

if obak$<>"" then typ=typ+ISARRAY
if incmem then typ=typ+ISINCONVENTIONALMEMORY

'print "UDTREF:"+r$+","+str2$(typ)

END FUNCTION

FUNCTION evaluate$ (a2$, typ AS LONG)
DIM block(1000) AS STRING
DIM evaledblock(1000) AS INTEGER
DIM blocktype(1000) AS LONG
'typ IS A RETURN VALUE
'''DIM cli(15) AS INTEGER
a$ = a2$
typ = -1

if debug then print #9, "evaluating:[" + a2$ + "]"






'''cl$ = classify(a$)

blockn = 0
n = numelements(a$)
b = 0'bracketting level
FOR i = 1 TO n
reevaluate:
l$ = getelement(a$, i)
IF i <> n THEN nextl$ = getelement(a$, i + 1) ELSE nextl$ = ""


'''getclass cl$, i, cli()

IF b = 0 THEN 'don't evaluate anything within brackets

if debug then print #9, l$

reattempt:

try = findid(l$)
DO WHILE try

if debug then print #9, try



'UDT
'names
'dim shared lasttype as long
'dim shared udtxname(1000) as string*256
'dim shared udtxsize(1000) as long
'dim shared udtxbytealign(1000) as integer 'first element MUST be on a byte alignment & size is a multiple of 8
'dim shared udtxnext(1000) as long
'elements
'dim shared lasttypeelement as long
'dim shared udtename(1000) as string*256
'dim shared udtebytealign(1000) as integer
'dim shared udtesize(1000) as long
'dim shared udtetype(1000) as long
'dim shared udtetypesize(1000) as long
'dim shared udtearrayelements(1000) as long
'dim shared udtearraybaseelement(1000) as string*1024
'dim shared udtearraytopelement(1000) as string*1024
'dim shared udtenext(1000) as long


'DIM SHARED id.t AS LONG
'DIM SHARED id.tsize AS LONG

if id.t and ISUDT then
o$=""
evaludt:
b2=0
i3=i+1
for i2=i3 to n
e2$ = getelement(a$, i2)
if e2$="(" then b2=b2+1
if b2=0 then
if e2$=")" or isoperator(e2$) then
i4=i2-1
goto gotudt
end if
end if
if e2$=")" then b2=b2-1
next
i4=n
gotudt:
if i4<i3 then e$="" else e$=getelements$(a$,i3,i4)
'PRINT "UDTREFERENCE:";l$; e$
e$=udtreference(o$,e$,typ2)
i=i4
blockn = blockn + 1
block(blockn) = e$
evaledblock(blockn) = 2
blocktype(blockn) = typ2
'is the following next necessary?
'IF (typ2 AND ISSTRING) THEN stringprocessinghappened = 1
GOTO evaled
end if

'is l$ an array?
IF nextl$ = "(" THEN
IF id.arraytype THEN
arrayid=currentid
constequation = 0
i2 = i + 2
b2 = 0
evalnextele3:
l2$ = getelement(a$, i2)
IF l2$ = "(" THEN b2 = b2 + 1
IF l2$ = ")" THEN
b2 = b2 - 1
IF b2 = -1 THEN
c$ = arrayreference(getelements$(a$, i + 2, i2 - 1), typ2)
i = i2

'UDT
if typ2 and ISUDT then
'print "arrayref returned:"+c$
getid arrayid
o$=right$(c$,len(c$)-instr(c$,""))
'change o$ to a byte offset if necessary
u=typ2 and 511
s=udtxsize(u)
if udtxbytealign(u) then
if s mod 8 then s=s+(8-(s mod 8)) 'round up to nearest byte
s=s\8
end if
o$="("+o$+")*"+str2$(s)
'print "calling evaludt with o$:"+o$
goto evaludt
end if

GOTO evalednextele3
END IF
END IF
i2 = i2 + 1
GOTO evalnextele3
evalednextele3:
blockn = blockn + 1
block(blockn) = c$
evaledblock(blockn) = 2
blocktype(blockn) = typ2
IF (typ2 AND ISSTRING) THEN stringprocessinghappened = 1
GOTO evaled
END IF
END IF
'no, it's not an array

'is l$ a function?
IF id.subfunc = 1 THEN
constequation = 0
IF getelement(a$, i + 1) = "(" THEN
i2 = i + 2
b2 = 0
args = 1
evalnextele:
l2$ = getelement(a$, i2)
IF l2$ = "(" THEN b2 = b2 + 1
IF l2$ = ")" THEN
b2 = b2 - 1
IF b2 = -1 THEN
IF i2 = i + 2 THEN nerror (87)
c$ = evaluatefunc(getelements$(a$, i + 2, i2 - 1), args, typ2)
i = i2
GOTO evalednextele
END IF
END IF
IF l2$ = "," AND b2 = 0 THEN args = args + 1
i2 = i2 + 1
GOTO evalnextele
ELSE
'no brackets
c$ = evaluatefunc("", 0, typ2)
END IF
evalednextele:
blockn = blockn + 1
block(blockn) = c$
evaledblock(blockn) = 2
blocktype(blockn) = typ2
IF (typ2 AND ISSTRING) THEN stringprocessinghappened = 1
GOTO evaled
END IF
'no, it's not a function

IF try = 2 THEN findanotherid = 1: try = findid(l$) ELSE try = 0
LOOP

'is l$ an undefined array?
IF i <> n THEN
IF getelement$(a$, i + 1) = "(" THEN
IF isoperator(l$) = 0 THEN
IF isvalidvariable(l$) THEN
dtyp$ = removesymbol(l$)

'if no extension was given, add a DEFault one and retry
IF dtyp$ = "" THEN
IF LEFT$(l$, 1) = "_" THEN v = 27 ELSE v = ASC(ucase$(l$)) - 64
're-attempt array access with extension
l$ = l$ + defineextaz(v)
GOTO reattempt
END IF

'count the number of elements 
nume = 1
b2 = 0
FOR i2 = i + 2 TO n
e$ = getelement(a$, i2)
IF e$ = "(" THEN b2 = b2 + 1
IF b2 = 0 AND e$ = "," THEN nume = nume + 1
IF e$ = ")" THEN b2 = b2 - 1
IF b2 = -1 THEN EXIT FOR
NEXT


fakee$ = "10": FOR i2 = 2 TO nume: fakee$ = fakee$ + sp+","+sp+"10": NEXT
if debug then print #9, "evaluate:creating undefined array using dim2("+l$+","+dtyp$+",0,"+fakee$+")"

olddimstatic=dimstatic

IF subfuncn then
autoarray=1 'move dimensioning of auto array to data???.txt from inline

'static array declared by STATIC name()?
'check if varname is on the static list
xi=1
for x=1 to staticarraylistn
varname2$=getelement$(staticarraylist,xi):xi=xi+1
typ2$=getelement$(staticarraylist,xi):xi=xi+1
dimmethod2=val(getelement$(staticarraylist,xi)):xi=xi+1
'check if they are similar
if ucase$(l$)=ucase$(varname2$) then
if symbol2fulltypename$(dtyp$)=typ2$ then
if dimmethod2=1 then 'has to have been informally defined, because DEF symbol was applied above
'match found!
l$=varname2$
dimstatic=3
end if
end if 'typ
end if 'varname
next

end if 'subfuncn

ignore = dim2(l$, dtyp$, 0, fakee$)

dimstatic=olddimstatic

GOTO reevaluate
END IF
END IF
END IF
END IF

END IF 'b=0

IF l$ = "(" THEN
IF b = 0 THEN i1 = i + 1
b = b + 1
END IF

IF b = 0 THEN
blockn = blockn + 1
block(blockn) = l$
evaledblock(blockn) = 0
END IF

IF l$ = ")" THEN
b = b - 1
IF b = 0 THEN
c$ = evaluate(getelements$(a$, i1, i - 1), typ2)
IF (typ2 AND ISSTRING) THEN stringprocessinghappened = 1
blockn = blockn + 1
IF (typ2 AND ISPOINTER) THEN
block(blockn) = c$
ELSE
block(blockn) = "(" + c$ + ")"
END IF
evaledblock(blockn) = 1
blocktype(blockn) = typ2
END IF
END IF

evaled:
NEXT

r$ = "" 'return value

if debug then print #9, "evaluated blocks:";
FOR i = 1 TO blockn
IF i <> blockn THEN
if debug then print #9, block(i) + CHR$(219);
ELSE
if debug then print #9, block(i)
END IF
NEXT



'identify any referencable values
FOR i = 1 TO blockn
IF isoperator(block(i)) = 0 THEN
IF evaledblock(i) = 0 THEN

'a number?
c=ASC(LEFT$(block(i), 1))
if c=45 or (c>=48 and c<=57) then
num$=block(i)
'a float?
f=0
x=instr(num$,"E")
if x then
f=1: blocktype(i) = SINGLETYPE - ISPOINTER
else
 x=instr(num$,"D")
 if x then
 f=2: blocktype(i) = DOUBLETYPE - ISPOINTER
 else
  x=instr(num$,"F")
  if x then
  f=3: blocktype(i) = FLOATTYPE - ISPOINTER
  end if
 end if
end if
if f then
'float
if f=2 or f=3 then mid$(num$,x,1)="E" 'D,F invalid in C++
else
'integer
blocktype(i)=typname2typ(removesymbol$(num$))
 if blocktype(i) and ISPOINTER then blocktype(i)=blocktype(i)-ISPOINTER
 if (blocktype(i) and 511)>32 then
 if blocktype(i) and ISUNSIGNED then num$=num$+"ull" else num$=num$+"ll" 
 end if
end if
block(i)=" "+num$+" " 'pad with spaces to avoid C++ computation errors
evaledblock(i) = 1
GOTO evaledblock
END IF

'number?
'fc = ASC(LEFT$(block(i), 1))
'IF fc = 45 OR (fc >= 48 AND fc <= 57) THEN '- or 0-9
''it's a number
''check for an extension, if none, assume integer
'blocktype(i) = INTEGER64TYPE - ISPOINTER
'tblock$ = " " + block(i)
'IF RIGHT$(tblock$, 2) = "##" THEN blocktype(i) = FLOATTYPE - ISPOINTER: block(i) = LEFT$(block(i), LEN(block$(i)) - 2): GOTO evfltnum
'IF RIGHT$(tblock$, 1) = "#" THEN blocktype(i) = DOUBLETYPE - ISPOINTER: block(i) = LEFT$(block(i), LEN(block$(i)) - 1): GOTO evfltnum
'IF RIGHT$(tblock$, 1) = "!" THEN blocktype(i) = SINGLETYPE - ISPOINTER: block(i) = LEFT$(block(i), LEN(block$(i)) - 1): GOTO evfltnum
'
''C++ 32bit unsigned to signed 64bit
'IF INSTR(block(i),".")=0 THEN
'
'negated=0
'if left$(block(i),1)="-" then block(i)=right$(block(i),len(block(i))-1):negated=1
'
'if left$(block(i),2)="0x" then 'hex
'if len(block(i))=10 then
'if block(i)>="0x80000000" and block(i)<="0xFFFFFFFF" then block(i)="(int64)"+block(i): goto evnum
'end if
'if len(block(i))>10 then block(i)=block(i)+"ll": goto evnum
'goto evnum
'end if
'
'if left$(block(i),1)="0" then 'octal
'if len(block(i))=12 then
'if block(i)>="020000000000" and block(i)<="037777777777" then block(i)="(int64)"+block(i): goto evnum
'if block(i)>"037777777777" then block(i)=block(i)+"ll": goto evnum
'end if
'if len(block(i))>12 then block(i)=block(i)+"ll": goto evnum
'goto evnum
'end if
'
''decimal
'if len(block(i))=10 then
'if block(i)>="2147483648" and block(i)<="4294967295" then block(i)="(int64)"+block(i): goto evnum
'if block(i)>"4294967295" then block(i)=block(i)+"ll": goto evnum
'end if
'if len(block(i))>10 then block(i)=block(i)+"ll"
'
'evnum:
'
'if negated=1 then block(i)="-"+block(i)
'
'END IF
'
'evfltnum:
'
'block(i) = " " + block(i)+" "
'evaledblock(i) = 1
'GOTO evaledblock
'END IF

'a typed string in ""
IF LEFT$(block(i), 1) = CHR$(34) THEN
IF RIGHT$(block(i), 1) <> CHR$(34) THEN
block(i) = "qbs_new_txt_len(" + block(i) + ")"
ELSE
block(i) = "qbs_new_txt(" + block(i) + ")"
END IF
blocktype(i) = ISSTRING
evaledblock(i) = 1
GOTO evaledblock
END IF

'variable?
ignore = findvariable(block(i))
constequation = 0
'create a reference to that variable
makeidrefer block(i), blocktype(i)
IF blockn = 1 THEN
IF (blocktype(i) AND ISREFERENCE) THEN GOTO returnpointer
END IF
'reference value
block(i) = refer(block(i), blocktype(i), 0)
evaledblock(i) = 1
GOTO evaledblock

ELSE
IF (blocktype(i) AND ISREFERENCE) THEN
IF blockn = 1 THEN GOTO returnpointer

'if blocktype(i) and ISUDT then PRINT "UDT passed to refer by evaluate"

block(i) = refer(block(i), blocktype(i), 0)

END IF

END IF
END IF
evaledblock:
NEXT


'return a POINTER if possible
IF blockn = 1 THEN
IF evaledblock(1) THEN
IF (blocktype(1) AND ISREFERENCE) THEN
returnpointer:
IF (blocktype(1) AND ISSTRING) THEN stringprocessinghappened = 1
if debug then print #9, "evaluated reference:" + block(1)
typ = blocktype(1)
evaluate$ = block(1)
EXIT FUNCTION
END IF
END IF
END IF
'it cannot be returned as a pointer








if debug then print #9, "applying operators:";


IF typ = -1 THEN
typ = blocktype(1) 'init typ with first blocktype


IF isoperator(block(1)) THEN 'but what if it starts with a UNARY operator?
typ = blocktype(2) 'init typ with second blocktype
END IF
END IF


FOR i = 1 TO blockn

IF evaledblock(i) = 0 THEN
IF isoperator(block(i)) THEN
constequation = 0

'operator found
o$ = block(i)
u = operatorusage(o$, typ, i$, lhstyp, rhstyp, result)
'lhstyp & rhstyp bit-field values
'1=integeral
'2=floating point
'4=string
'8=bool *only used for result

oldtyp = typ
newtyp = blocktype(i + 1)

'IF block(i - 1) = "6" THEN
'PRINT o$
'PRINT oldtyp AND ISFLOAT
'PRINT blocktype(i - 1) AND ISFLOAT
'END
'END IF



'numeric->string is illegal!
IF (typ AND ISSTRING) = 0 AND (newtyp AND ISSTRING) <> 0 THEN
nerror (88)
END IF

'STEP 1: convert oldtyp and/or newtyp if required for the operator
'convert lhs
IF (oldtyp AND ISSTRING) THEN
 IF (lhstyp AND 4) = 0 THEN nerror (89)
ELSE
 'oldtyp is numeric
 IF lhstyp = 4 THEN nerror (90)
 IF (oldtyp AND ISFLOAT) THEN
  IF (lhstyp AND 2) = 0 THEN
  'convert float to int
  block(i - 1) = "qbr(" + block(i - 1) + ")"
  oldtyp = 64&
  END IF
 ELSE
  'oldtyp is an int
  IF (lhstyp AND 1) = 0 THEN
  'convert int to float
  block(i - 1) = "((long double)(" + block(i - 1) + "))"
  oldtyp = 256& + ISFLOAT
  END IF
 END IF
END IF
'convert rhs
IF (newtyp AND ISSTRING) THEN
 IF (rhstyp AND 4) = 0 THEN nerror (91)
ELSE
 'newtyp is numeric
 IF rhstyp = 4 THEN nerror (92)
 IF (newtyp AND ISFLOAT) THEN
  IF (rhstyp AND 2) = 0 THEN
  'convert float to int
  block(i + 1) = "qbr(" + block(i + 1) + ")"
  newtyp = 64&
  END IF
 ELSE
  'newtyp is an int
  IF (rhstyp AND 1) = 0 THEN
  'convert int to float
  block(i + 1) = "((long double)(" + block(i + 1) + "))"
  newtyp = 256& + ISFLOAT
  END IF
 END IF
END IF

typ = newtyp

'STEP 2: markup typ
'        if either side is a float, markup typ to largest float
'        if either side is integer, markup typ
'Note: A markup is a GUESS of what the return type will be,
'      'result' can override this markup
IF (oldtyp AND ISSTRING) = 0 AND (newtyp AND ISSTRING) = 0 THEN
IF (oldtyp AND ISFLOAT) <> 0 OR (newtyp AND ISFLOAT) <> 0 THEN
 'float
 b = 0: IF (oldtyp AND ISFLOAT) THEN b = oldtyp AND 511
 IF (newtyp AND ISFLOAT) THEN
 b2 = newtyp AND 511: IF b2 > b THEN b = b2
 END IF
 typ = ISFLOAT + b
ELSE
 'integer
 '***THIS IS THE IDEAL MARKUP FOR A 64-BIT SYSTEM***
 'In reality 32-bit C++ only marks-up to 32-bit integers
 b = oldtyp AND 511: b2 = newtyp AND 511: IF b2 > b THEN b = b2
 typ = 64&
 IF b = 64 THEN
 IF (oldtyp AND ISUNSIGNED) <> 0 AND (newtyp AND ISUNSIGNED) <> 0 THEN typ = 64& + ISUNSIGNED
 END IF
END IF
END IF

if result=1 then
if (typ and ISFLOAT)<>0 or (typ and ISSTRING)<>0 then typ=64 'otherwise keep markuped integer type
end if
if result=2 then
if (typ and ISFLOAT)=0 then typ=ISFLOAT + 256
end if
if result=4 then
typ = ISSTRING
end if
if result=8 then 'bool
typ = 32
end if

'override typ=ISFLOAT+256 to typ=ISFLOAT+64 for ^ operator's result
IF u=2 then
if i$ = "pow2" THEN

'QB-like conversion of math functions returning floating point values
'reassess oldtype & newtype
b=oldtyp and 511
IF oldtyp AND ISFLOAT then
'no change to b
else
if b>16 then b=64 'larger than INTEGER? return DOUBLE
if b>32 then b=256 'larger than LONG? return FLOAT
if b<=16 then b=32
end if
b2=newtyp and 511
IF newtyp AND ISFLOAT then
if b2>b then b=b2
else
b3=32
if b2>16 then b3=64 'larger than INTEGER? return DOUBLE
if b2>32 then b3=256 'larger than LONG? return FLOAT
if b3>b then b=b3
end if
typ = ISFLOAT + b

END IF 'pow2
end if 'u=2

'STEP 3: apply operator appropriately
IF u = 1 THEN
block(i + 1) = block(i - 1) + i$ + block(i + 1)
block(i - 1) = "": block(i) = "": i = i + 1: GOTO operatorapplied
END IF

IF u = 2 THEN
block(i + 1) = i$ + "(" + block(i - 1) + "," + block(i + 1) + ")"
block(i - 1) = "": block(i) = "": i = i + 1: GOTO operatorapplied
END IF

IF u = 3 THEN
block(i + 1) = "-(" + block(i - 1) + i$ + block(i + 1) + ")"
block(i - 1) = "": block(i) = "": i = i + 1: GOTO operatorapplied
END IF

IF u = 4 THEN
block(i + 1) = "~" + block(i - 1) + i$ + block(i + 1)
block(i - 1) = "": block(i) = "": i = i + 1: GOTO operatorapplied
END IF

IF u = 5 THEN
block(i + 1) = i$ + "(" + block(i + 1) + ")"
block(i) = "": i = i + 1: GOTO operatorapplied
END IF

'...more?...

nerror (93)
operatorapplied:

END IF
END IF
NEXT
if debug then print #9, ""

'join blocks
FOR i = 1 TO blockn
r$ = r$ + block(i)
NEXT

if debug then
print #9, "evaluated:" + r$ + " AS TYPE:";
IF (typ AND ISSTRING) THEN print #9, "[ISSTRING]";
IF (typ AND ISFLOAT) THEN print #9, "[ISFLOAT]";
IF (typ AND ISUNSIGNED) THEN print #9, "[ISUNSIGNED]";
IF (typ AND ISPOINTER) THEN print #9, "[ISPOINTER]";
IF (typ AND ISFIXEDLENGTH) THEN PRINT #9, "[ISFIXEDLENGTH]";
IF (typ AND ISINCONVENTIONALMEMORY) THEN PRINT #9, "[ISINCONVENTIONALMEMORY]";
PRINT #9, "(size in bits=" + str2$(typ AND 511) + ")"
end if


evaluate$ = r$



END FUNCTION




FUNCTION evaluatefunc$ (a2$, args AS LONG, typ AS LONG)
a$ = a2$

if debug then print #9, "evaluatingfunction:" + RTRIM$(id.n) + ":" + a$

DIM id2 AS idstruct

id2 = id
n$ = RTRIM$(id2.n)
typ = id2.ret
targetid = currentid

passomit = 0
skiparg = 0

f$ = RTRIM$(id2.specialformat)
IF LEN(f$) THEN 'special format given

passomit = 1
IF args < id2.args - 1 OR args > id2.args THEN nerror (120)
f$ = f$ + " "
a = 0
FOR i = 1 TO LEN(f$) - 1
IF MID$(f$, i, 1) = "?" THEN
a = a + 1
IF MID$(f$, i + 1, 1) = "]" THEN skiparg = a: EXIT FOR
END IF
NEXT
IF id2.args = args THEN skiparg = 0 'all arguments were passed!
IF args<id2.args-1 or args>id2.args THEN nerror (121)

ELSE 'no special format given

if n$="ASC" and args=2 then goto skipargnumchk
IF id2.args <> args THEN nerror (121)

END IF 

skipargnumchk:



r$ = RTRIM$(id2.callname) + "("
IF id2.args <> 0 THEN

curarg = 1
firsti = 1

n = numelements(a$)
IF n = 0 THEN i = 0: GOTO noargs

FOR i = 1 TO n

IF curarg = skiparg THEN
noargs:
targettyp = CVL(MID$(id2.arg, curarg * 4 - 4 + 1, 4))


'IF (targettyp AND ISSTRING) THEN nerror (122)

r$ = r$ + "NULL"
curarg = curarg + 1
IF i = n THEN EXIT FOR
r$ = r$ + ","
END IF

l$ = getelement(a$, i)
IF l$ = "(" THEN b = b + 1
IF l$ = ")" THEN b = b - 1
IF (l$ = "," AND b = 0) OR (i = n) THEN
targettyp = CVL(MID$(id2.arg, curarg * 4 - 4 + 1, 4))

IF i = n THEN
e$ = getelements$(a$, firsti, i)
ELSE
e$ = getelements$(a$, firsti, i - 1)
END IF

if left$(e$,2)="("+sp then dereference=1 else dereference=0



'*special case CVI,CVL,CVS,CVD,_CV (part #1)
IF n$ = "_CV" THEN
IF curarg = 1 THEN
cvtype$ = type2symbol$(e$)
e$ = ""
GOTO dontevaluate
END IF
END IF

'*special case MKI,MKL,MKS,MKD,_MK (part #1)

IF n$ = "_MK" THEN
IF RTRIM$(id2.musthave) = "$" THEN
IF curarg = 1 THEN
mktype$ = type2symbol$(e$)
if debug then print #9,"_MK:["+e$+"]:["+mktype$+"]"
e$ = ""
GOTO dontevaluate
END IF
END IF
END IF

IF n$ = "UBOUND" OR n$ = "LBOUND" THEN
IF curarg = 1 THEN
'perform a "fake" evaluation of the array
e$ = e$ + sp + "(" + sp + ")"
e$ = evaluate(e$, sourcetyp)
IF (sourcetyp AND ISREFERENCE) = 0 THEN nerror (123)
IF (sourcetyp AND ISARRAY) = 0 THEN nerror (124)
'make a note of the array's index for later
ulboundarray$ = e$
ulboundarraytyp = sourcetyp
e$ = ""
r$ = ""
GOTO dontevaluate
END IF
END IF


'*special case: INPUT$ function
IF n$ = "INPUT" THEN
IF RTRIM$(id2.musthave) = "$" THEN
IF curarg = 2 THEN
IF LEFT$(e$, 2) = "#" + sp THEN e$ = RIGHT$(e$, LEN(e$) - 2)
END IF
END IF
END IF


'*special case*
if n$="ASC" then
if curarg=2 then
e$=evaluatetotyp$(e$,32&)
typ& = LONGTYPE - ISPOINTER
r$=r$+e$+")"
GOTO evalfuncspecial
end if
end if

'------------------------------------------------------------------------------------------------------------
e2$=e$
e$ = evaluate(e$, sourcetyp)
'------------------------------------------------------------------------------------------------------------

'*special case*
if n$="ENVIRON" then
if sourcetyp and ISSTRING then
if sourcetyp and ISREFERENCE then e$=refer(e$,sourcetyp,0)
GOTO dontevaluate
end if
end if

'*special case*
if n$="LEN" then
typ& = LONGTYPE - ISPOINTER
if (sourcetyp and ISREFERENCE)=0 then
	'could be a string expression
	if sourcetyp and ISSTRING then
	r$="("+e$+")->len"
	GOTO evalfuncspecial
	end if
qb64error "String expression or variable name required in LEN statement"
end if
r$=evaluatetotyp$(e2$,-5) 'use evaluatetotyp to get 'element' size
GOTO evalfuncspecial
end if

'*special case*
IF n$ = "OCT" THEN
IF RTRIM$(id2.musthave) = "$" THEN
bits = sourcetyp AND 511
IF (sourcetyp AND ISSTRING) THEN nerror (125)
wasref = 0
IF (sourcetyp AND ISREFERENCE) THEN e$ = refer(e$, sourcetyp, 0): wasref = 1
bits = sourcetyp AND 511
IF (sourcetyp AND ISOFFSETINBITS) THEN
e$ = "func_oct(" + e$ + "," + str2$(bits) + ")"
ELSE
IF (sourcetyp AND ISFLOAT) THEN
e$ = "func_oct_float(" + e$ + ")"
ELSE
IF bits = 64 THEN
IF wasref = 0 THEN bits = 0
END IF
e$ = "func_oct(" + e$ + "," + str2$(bits) + ")"
END IF
END IF
typ& = STRINGTYPE - ISPOINTER
r$ = e$
GOTO evalfuncspecial
END IF
END IF



'*special case*
IF n$ = "HEX" THEN
IF RTRIM$(id2.musthave) = "$" THEN
bits = sourcetyp AND 511
IF (sourcetyp AND ISSTRING) THEN nerror (126)
wasref = 0
IF (sourcetyp AND ISREFERENCE) THEN e$ = refer(e$, sourcetyp, 0): wasref = 1
bits = sourcetyp AND 511
IF (sourcetyp AND ISOFFSETINBITS) THEN
chars = (bits + 3) \ 4
e$ = "func_hex(" + e$ + "," + str2$(chars) + ")"
ELSE
IF (sourcetyp AND ISFLOAT) THEN
e$ = "func_hex_float(" + e$ + ")"
ELSE
IF bits = 8 THEN chars = 2
IF bits = 16 THEN chars = 4
IF bits = 32 THEN chars = 8
IF bits = 64 THEN
IF wasref = 1 THEN chars = 16 ELSE chars = 0
END IF
e$ = "func_hex(" + e$ + "," + str2$(chars) + ")"
END IF
END IF
typ& = STRINGTYPE - ISPOINTER
r$ = e$
GOTO evalfuncspecial
END IF
END IF









'*special case*
IF n$ = "EXP" THEN
bits = sourcetyp AND 511
IF (sourcetyp AND ISSTRING) THEN nerror (127)
IF (sourcetyp AND ISREFERENCE) THEN e$ = refer(e$, sourcetyp, 0)
'establish which function (if any!) should be used
bits = sourcetyp AND 511
typ& = SINGLETYPE - ISPOINTER
IF (sourcetyp AND ISFLOAT) THEN
IF bits = 32 THEN e$ = "func_exp_single(" + e$ + ")" ELSE e$ = "func_exp_float(" + e$ + ")": typ& = FLOATTYPE - ISPOINTER
ELSE
IF (sourcetyp AND ISOFFSETINBITS) THEN
e$ = "func_exp_float(" + e$ + ")": typ& = FLOATTYPE - ISPOINTER
ELSE
IF bits <= 16 THEN e$ = "func_exp_single(" + e$ + ")" ELSE e$ = "func_exp_float(" + e$ + ")": typ& = FLOATTYPE - ISPOINTER
END IF
END IF
r$ = e$
GOTO evalfuncspecial
END IF

'*special case*
IF n$ = "INT" THEN
IF (sourcetyp AND ISSTRING) THEN nerror (128)
IF (sourcetyp AND ISREFERENCE) THEN e$ = refer(e$, sourcetyp, 0)
'establish which function (if any!) should be used
IF (sourcetyp AND ISFLOAT) THEN e$ = "floor(" + e$ + ")"
r$ = e$
typ& = sourcetyp
GOTO evalfuncspecial
END IF

'*special case*
IF n$ = "FIX" THEN
IF (sourcetyp AND ISSTRING) THEN nerror (129)
IF (sourcetyp AND ISREFERENCE) THEN e$ = refer(e$, sourcetyp, 0)
'establish which function (if any!) should be used
bits = sourcetyp AND 511
IF (sourcetyp AND ISFLOAT) THEN
IF bits > 64 THEN e$ = "func_fix_float(" + e$ + ")" ELSE e$ = "func_fix_double(" + e$ + ")"
END IF
r$ = e$
typ& = sourcetyp
GOTO evalfuncspecial
END IF

'*special case*
IF n$ = "_ROUND" THEN
IF (sourcetyp AND ISSTRING) THEN nerror (130)
IF (sourcetyp AND ISREFERENCE) THEN e$ = refer(e$, sourcetyp, 0)
'establish which function (if any!) should be used
IF (sourcetyp AND ISFLOAT) THEN
bits = sourcetyp AND 511
IF bits > 64 THEN e$ = "func_round_float(" + e$ + ")" ELSE e$ = "func_round_double(" + e$ + ")"
END IF
r$ = e$
typ& = 64&
GOTO evalfuncspecial
END IF


'*special case*
IF n$ = "CDBL" THEN
IF (sourcetyp AND ISSTRING) THEN nerror (131)
IF (sourcetyp AND ISREFERENCE) THEN e$ = refer(e$, sourcetyp, 0)
'establish which function (if any!) should be used
bits = sourcetyp AND 511
IF (sourcetyp AND ISFLOAT) THEN
IF bits > 64 THEN e$ = "func_cdbl_float(" + e$ + ")"
ELSE
e$ = "((double)(" + e$ + "))"
END IF
r$ = e$
typ& = DOUBLETYPE - ISPOINTER
GOTO evalfuncspecial
END IF

'*special case*
IF n$ = "CSNG" THEN
IF (sourcetyp AND ISSTRING) THEN nerror (132)
IF (sourcetyp AND ISREFERENCE) THEN e$ = refer(e$, sourcetyp, 0)
'establish which function (if any!) should be used
bits = sourcetyp AND 511
IF (sourcetyp AND ISFLOAT) THEN
IF bits = 64 THEN e$ = "func_csng_double(" + e$ + ")"
IF bits > 64 THEN e$ = "func_csng_float(" + e$ + ")"
ELSE
e$ = "((double)(" + e$ + "))"
END IF
r$ = e$
typ& = SINGLETYPE - ISPOINTER
GOTO evalfuncspecial
END IF


'*special case*
IF n$ = "CLNG" THEN
IF (sourcetyp AND ISSTRING) THEN nerror (133)
IF (sourcetyp AND ISREFERENCE) THEN e$ = refer(e$, sourcetyp, 0)
'establish which function (if any!) should be used
bits = sourcetyp AND 511
IF (sourcetyp AND ISFLOAT) THEN
IF bits > 64 THEN e$ = "func_clng_float(" + e$ + ")" ELSE e$ = "func_clng_double(" + e$ + ")"
ELSE 'integer
IF (sourcetyp AND ISUNSIGNED) THEN
IF bits = 32 THEN e$ = "func_clng_ulong(" + e$ + ")"
IF bits > 32 THEN e$ = "func_clng_uint64(" + e$ + ")"
ELSE 'signed
IF bits > 32 THEN e$ = "func_clng_int64(" + e$ + ")"
END IF
END IF
r$ = e$
typ& = 32&
GOTO evalfuncspecial
END IF

'*special case*
IF n$ = "CINT" THEN
IF (sourcetyp AND ISSTRING) THEN nerror (134)
IF (sourcetyp AND ISREFERENCE) THEN e$ = refer(e$, sourcetyp, 0)
'establish which function (if any!) should be used
bits = sourcetyp AND 511
IF (sourcetyp AND ISFLOAT) THEN
IF bits > 64 THEN e$ = "func_cint_float(" + e$ + ")" ELSE e$ = "func_cint_double(" + e$ + ")"
ELSE 'integer
IF (sourcetyp AND ISUNSIGNED) THEN
IF bits > 15 AND bits <= 32 THEN e$ = "func_cint_ulong(" + e$ + ")"
IF bits > 32 THEN e$ = "func_cint_uint64(" + e$ + ")"
ELSE 'signed
IF bits > 16 AND bits <= 32 THEN e$ = "func_cint_long(" + e$ + ")"
IF bits > 32 THEN e$ = "func_cint_int64(" + e$ + ")"
END IF
END IF
r$ = e$
typ& = 16&
GOTO evalfuncspecial
END IF

'*special case MKI,MKL,MKS,MKD,_MK (part #2)
mktype = 0
size = 0
IF n$ = "MKI" THEN mktype = 1: mktype$ = "%"
IF n$ = "MKL" THEN mktype = 2: mktype$ = "&"
IF n$ = "MKS" THEN mktype = 3: mktype$ = "!"
IF n$ = "MKD" THEN mktype = 4: mktype$ = "#"
IF n$ = "_MK" THEN mktype = -1
IF mktype THEN
IF mktype <> -1 OR curarg = 2 THEN
'both _MK and trad. process the following
qtyp& = 0
IF mktype$ = "%%" THEN ctype$ = "b": qtyp& = BYTETYPE - ISPOINTER
IF mktype$ = "~%%" THEN ctype$ = "ub": qtyp& = UBYTETYPE - ISPOINTER
IF mktype$ = "%" THEN ctype$ = "i": qtyp& = INTEGERTYPE - ISPOINTER
IF mktype$ = "~%" THEN ctype$ = "ui": qtyp& = UINTEGERTYPE - ISPOINTER
IF mktype$ = "&" THEN ctype$ = "l": qtyp& = LONGTYPE - ISPOINTER
IF mktype$ = "~&" THEN ctype$ = "ul": qtyp& = ULONGTYPE - ISPOINTER
IF mktype$ = "&&" THEN ctype$ = "i64": qtyp& = INTEGER64TYPE - ISPOINTER
IF mktype$ = "~&&" THEN ctype$ = "ui64": qtyp& = UINTEGER64TYPE - ISPOINTER
IF mktype$ = "!" THEN ctype$ = "s": qtyp& = SINGLETYPE - ISPOINTER
IF mktype$ = "#" THEN ctype$ = "d": qtyp& = DOUBLETYPE - ISPOINTER
IF mktype$ = "##" THEN ctype$ = "f": qtyp& = FLOATTYPE - ISPOINTER
IF LEFT$(mktype$, 2) = "~`" THEN ctype$ = "ubit": qtyp& = UINTEGER64TYPE - ISPOINTER: size = VAL(RIGHT$(mktype$, LEN(mktype$) - 2))
IF LEFT$(mktype$, 1) = "`" THEN ctype$ = "bit": qtyp& = INTEGER64TYPE - ISPOINTER: size = VAL(RIGHT$(mktype$, LEN(mktype$) - 1))
IF qtyp& = 0 THEN nerror (135)
IF size THEN
r$ = ctype$ + "2string(" + str2(size) + ","
ELSE
r$ = ctype$ + "2string("
END IF
nocomma = 1
targettyp = qtyp&
END IF
END IF

'*special case CVI,CVL,CVS,CVD,_CV (part #2)
cvtype = 0
IF n$ = "CVI" THEN cvtype = 1: cvtype$ = "%"
IF n$ = "CVL" THEN cvtype = 2: cvtype$ = "&"
IF n$ = "CVS" THEN cvtype = 3: cvtype$ = "!"
IF n$ = "CVD" THEN cvtype = 4: cvtype$ = "#"
IF n$ = "_CV" THEN cvtype = -1
IF cvtype THEN
IF cvtype <> -1 OR curarg = 2 THEN
IF (sourcetyp AND ISSTRING) = 0 THEN qb64error n$ + " requires a STRING argument"
IF (sourcetyp AND ISREFERENCE) THEN e$ = refer(e$, sourcetyp, 0)
typ& = 0
IF cvtype$ = "%%" THEN ctype$ = "b": typ& = BYTETYPE - ISPOINTER
IF cvtype$ = "~%%" THEN ctype$ = "ub": typ& = UBYTETYPE - ISPOINTER
IF cvtype$ = "%" THEN ctype$ = "i": typ& = INTEGERTYPE - ISPOINTER
IF cvtype$ = "~%" THEN ctype$ = "ui": typ& = UINTEGERTYPE - ISPOINTER
IF cvtype$ = "&" THEN ctype$ = "l": typ& = LONGTYPE - ISPOINTER
IF cvtype$ = "~&" THEN ctype$ = "ul": typ& = ULONGTYPE - ISPOINTER
IF cvtype$ = "&&" THEN ctype$ = "i64": typ& = INTEGER64TYPE - ISPOINTER
IF cvtype$ = "~&&" THEN ctype$ = "ui64": typ& = UINTEGER64TYPE - ISPOINTER
IF cvtype$ = "!" THEN ctype$ = "s": typ& = SINGLETYPE - ISPOINTER
IF cvtype$ = "#" THEN ctype$ = "d": typ& = DOUBLETYPE - ISPOINTER
IF cvtype$ = "##" THEN ctype$ = "f": typ& = FLOATTYPE - ISPOINTER
IF LEFT$(cvtype$, 2) = "~`" THEN ctype$ = "ubit": typ& = UINTEGER64TYPE - ISPOINTER: size = VAL(RIGHT$(cvtype$, LEN(cvtype$) - 2))
IF LEFT$(cvtype$, 1) = "`" THEN ctype$ = "bit": typ& = INTEGER64TYPE - ISPOINTER: size = VAL(RIGHT$(cvtype$, LEN(cvtype$) - 1))
IF typ& = 0 THEN nerror (136)
IF ctype$ = "bit" OR ctype$ = "ubit" THEN
r$ = "string2" + ctype$ + "(" + e$ + "," + str2(size) + ")"
ELSE
r$ = "string2" + ctype$ + "(" + e$ + ")"
END IF
GOTO evalfuncspecial
END IF
END IF

'*special case
IF RTRIM$(id2.n) = "STRING" THEN
IF curarg = 2 THEN
IF (sourcetyp AND ISSTRING) THEN
IF (sourcetyp AND ISREFERENCE) THEN e$ = refer(e$, sourcetyp, 0)
sourcetyp = 64&
e$ = "(" + e$ + "->chr[0])"
END IF
END IF
END IF

'*special case
IF RTRIM$(id2.n) = "SADD" THEN
IF (sourcetyp AND ISREFERENCE) = 0 THEN
nerror (137)
END IF
IF (sourcetyp AND ISFIXEDLENGTH) THEN
nerror (138)
END IF
IF (sourcetyp AND ISINCONVENTIONALMEMORY) = 0 THEN
recompile = 1
cmemlist(VAL(e$)) = 1
r$ = "[CONVENTIONAL_MEMORY_REQUIRED]"
typ& = 64&
GOTO evalfuncspecial
END IF
r$ = refer(e$, sourcetyp, 0)
r$ = "((unsigned short)(" + r$ + "->chr-&cmem[1280]))"
typ& = 64&
GOTO evalfuncspecial
END IF

'*special case
IF RTRIM$(id2.n) = "VARPTR" THEN
IF (sourcetyp AND ISREFERENCE) = 0 THEN
nerror (139)
END IF

IF RTRIM$(id2.musthave) = "$" THEN
IF (sourcetyp AND ISINCONVENTIONALMEMORY) = 0 THEN
recompile = 1
cmemlist(VAL(e$)) = 1
r$ = "[CONVENTIONAL_MEMORY_REQUIRED]"
typ& = ISSTRING
GOTO evalfuncspecial
END IF

IF (sourcetyp AND ISARRAY) THEN
IF (sourcetyp AND ISSTRING) = 0 THEN nerror (140)
IF (sourcetyp AND ISFIXEDLENGTH) THEN nerror (141)
END IF

'must be a simple variable
'!assuming it is in cmem in DBLOCK
r$ = refer(e$, sourcetyp, 1)
IF (sourcetyp AND ISSTRING) THEN
IF (sourcetyp AND ISARRAY) THEN r$ = refer(e$, sourcetyp, 0)
r$ = r$ + "->cmem_descriptor_offset"
t = 3
ELSE
r$ = "((unsigned short)(((unsigned char*)" + r$ + ")-&cmem[1280]))"
'*top bit on=unsigned
'*second top bit on=bit-value (lower bits indicate the size)
'BYTE=1
'INTEGER=2
'STRING=3
'SINGLE=4
'INT64=5
'FLOAT=6
'DOUBLE=8
'LONG=20
'BIT=64+n
t = 0
IF (sourcetyp AND ISUNSIGNED) THEN t = t + 128
IF (sourcetyp AND ISOFFSETINBITS) THEN
t = t + 64
t = t + (sourcetyp AND 63)
ELSE
bits = sourcetyp AND 511
IF (sourcetyp AND ISFLOAT) THEN
IF bits = 32 THEN t = t + 4
IF bits = 64 THEN t = t + 8
IF bits = 256 THEN t = t + 6
ELSE
IF bits = 8 THEN t = t + 1
IF bits = 16 THEN t = t + 2
IF bits = 32 THEN t = t + 20
IF bits = 64 THEN t = t + 5
END IF
END IF
END IF
r$ = "func_varptr_helper(" + str2(t) + "," + r$ + ")"
typ& = ISSTRING
GOTO evalfuncspecial
END IF 'end of varptr$











'VARPTR
IF (sourcetyp AND ISINCONVENTIONALMEMORY) = 0 THEN
recompile = 1
cmemlist(VAL(e$)) = 1
r$ = "[CONVENTIONAL_MEMORY_REQUIRED]"
typ& = 64&
GOTO evalfuncspecial
END IF

IF (sourcetyp AND ISARRAY) THEN
IF (sourcetyp AND ISOFFSETINBITS) THEN nerror (142)

'string array?
IF (sourcetyp AND ISSTRING) THEN
IF (sourcetyp AND ISFIXEDLENGTH) THEN
getid VAL(e$)
m = id.tsize
index$ = RIGHT$(e$, LEN(e$) - INSTR(e$, ""))
typ = 64&
r$ = "((" + index$ + ")*" + str2(m) + ")"
GOTO evalfuncspecial
ELSE
'return the offset of the string's descriptor
r$ = refer(e$, sourcetyp, 0)
r$ = r$ + "->cmem_descriptor_offset"
typ = 64&
GOTO evalfuncspecial
END IF
END IF

if sourcetyp and ISUDT then
e$ = RIGHT$(e$, LEN(e$) - INSTR(e$, "")) 'skip idnumber
e$ = RIGHT$(e$, LEN(e$) - INSTR(e$, "")) 'skip u
o$ = RIGHT$(e$, LEN(e$) - INSTR(e$, "")) 'skip e
typ = 64&
r$ = "("+o$+")"
GOTO evalfuncspecial
end if

'non-UDT array
m = (sourcetyp AND 511) \ 8 'calculate size multiplier
index$ = RIGHT$(e$, LEN(e$) - INSTR(e$, ""))
typ = 64&
r$ = "((" + index$ + ")*" + str2(m) + ")"
GOTO evalfuncspecial

END IF

'not an array

if sourcetyp and ISUDT then
r$ = refer(e$, sourcetyp, 1)
e$ = RIGHT$(e$, LEN(e$) - INSTR(e$, "")) 'skip idnumber
e$ = RIGHT$(e$, LEN(e$) - INSTR(e$, "")) 'skip u
o$ = RIGHT$(e$, LEN(e$) - INSTR(e$, "")) 'skip e
typ = 64&

'if sub/func arg, may not be in DBLOCK
getid val(e$)
if id.sfarg then 'could be in DBLOCK
	'note: segment could be the closest segment to UDT element or the base of DBLOCK
	r$="varptr_dblock_check(((unsigned char*)"+r$+")+("+o$+"))"
else 'definitely in DBLOCK
	'give offset relative to DBLOCK
	r$ = "((unsigned short)(((unsigned char*)" + r$ + ") - &cmem[1280] + ("+o$+") ))"
end if

GOTO evalfuncspecial
end if

typ = 64&
r$ = refer(e$, sourcetyp, 1)
IF (sourcetyp AND ISSTRING) THEN
IF (sourcetyp AND ISFIXEDLENGTH) THEN

'if sub/func arg, may not be in DBLOCK
getid val(e$) 
if id.sfarg then 'could be in DBLOCK
	r$="varptr_dblock_check("+r$+"->chr)"
else 'definitely in DBLOCK
	r$ = "((unsigned short)(" + r$ + "->chr-&cmem[1280]))"
end if

ELSE
r$ = r$ + "->cmem_descriptor_offset"
END IF
GOTO evalfuncspecial
END IF

'single, simple variable
'if sub/func arg, may not be in DBLOCK
getid val(e$) 
if id.sfarg then 'could be in DBLOCK
	r$="varptr_dblock_check((unsigned char*)"+r$+")"
else 'definitely in DBLOCK
	r$ = "((unsigned short)(((unsigned char*)" + r$ + ")-&cmem[1280]))"	
end if

GOTO evalfuncspecial
END IF

'*special case*
IF RTRIM$(id2.n) = "VARSEG" THEN
IF (sourcetyp AND ISREFERENCE) = 0 THEN
nerror (143)
END IF
IF (sourcetyp AND ISINCONVENTIONALMEMORY) = 0 THEN
recompile = 1
cmemlist(VAL(e$)) = 1
r$ = "[CONVENTIONAL_MEMORY_REQUIRED]"
typ& = 64&
GOTO evalfuncspecial
END IF
'array?
IF (sourcetyp AND ISARRAY) THEN
	IF (sourcetyp AND ISFIXEDLENGTH) = 0 THEN
	IF (sourcetyp AND ISSTRING) THEN
	r$ = "80"
	typ = 64&
	GOTO evalfuncspecial
	END IF
	END IF
typ = 64&
r$ = "( ( ((unsigned long)(" + refer(e$, sourcetyp, 1) + "[0])) - ((unsigned long)(&cmem[0])) ) /16)"
GOTO evalfuncspecial
END IF

'single variable/(var-len)string/udt? (usually stored in DBLOCK)
typ = 64&
'if sub/func arg, may not be in DBLOCK
getid val(e$)
if id.sfarg<>0 and (sourcetyp AND ISSTRING)=0 then
	if sourcetyp AND ISUDT then
		r$ = refer(e$, sourcetyp, 1)
		e$ = RIGHT$(e$, LEN(e$) - INSTR(e$, "")) 'skip idnumber
		e$ = RIGHT$(e$, LEN(e$) - INSTR(e$, "")) 'skip u
		o$ = RIGHT$(e$, LEN(e$) - INSTR(e$, "")) 'skip e
		r$="varseg_dblock_check(((unsigned char*)"+r$+")+("+o$+"))"
	else
		r$="varseg_dblock_check((unsigned char*)"+refer(e$, sourcetyp, 1)+")"
	end if
else
	'can be assumed to be in DBLOCK
	r$ = "80"
end if
GOTO evalfuncspecial
END IF 'varseg


'any numeric variable, but it must be type-speficied

explicitreference = 0
IF targettyp = -1 THEN
explicitreference = 1
IF (sourcetyp AND ISSTRING) THEN nerror (144)
targettyp = sourcetyp
IF (targettyp AND ISPOINTER) THEN targettyp = targettyp - ISPOINTER
END IF

'pointer?
IF (targettyp AND ISPOINTER) THEN
if dereference=0 then 'check deferencing wasn't used

'PRINT "Target is a pointer!"

IF (targettyp AND ISARRAY) THEN

IF (sourcetyp AND ISREFERENCE) = 0 THEN qb64error "Expected arrayname()"

'following check failed...
IF (sourcetyp AND ISARRAY) = 0 THEN qb64error "Expected arrayname()"

if sourcetyp and ISUDT then
'check u or e
else
IF RIGHT$(e$, 2) <> "0" THEN qb64error "Expected arrayname()"
end if

'check array is of same TYPE!

targettypsize = CVL(MID$(id2.argsize, i * 4 - 4 + 1, 4))
'targettypsize is ignored! but would be used for type checking fixed length string arrays

idnum = VAL(LEFT$(e$, INSTR(e$, "") - 1))
getid idnum

'20090703
if mid$(sfcmemargs(targetid),curarg,1)=chr$(1) then 'cmem required?
if cmemlist(idnum)=0 then
cmemlist(idnum) = 1
recompile = 1
end if
end if

IF id.linkid = 0 THEN
'if id.linkid is 0, it means the number of array elements is definietly
'known of the array being passed, this is not some "fake"/unknown array.
'using the numer of array elements of a fake array would be dangerous!


IF nelereq = 0 THEN
'only continue if the number of array elements required is unknown
'and it needs to be set

if id.arrayelements<>-1 then '2009
nelereq = id.arrayelements
MID$(id2.nelereq, i, 1) = CHR$(nelereq)
end if

'print rtrim$(id2.n)+">nelereq=";nelereq

ids(targetid)=id2

ELSE

'the number of array elements required is known AND
'the number of elements in the array to be passed is known



'REMOVED FOR TESTING PURPOSES ONLY!!! SHOULD BE UNREM'd!
'print id.arrayelements,nelereq
'             1       ,  2

IF id.arrayelements <> nelereq THEN qb64error "Passing arrays with a differing number of elements to a SUB/FUNCTION is not supported (yet)"


END IF
END IF


e$ = refer(e$, sourcetyp, 1)
GOTO dontevaluate
END IF

'target is not an array

IF (targettyp AND ISSTRING) = 0 THEN
IF (sourcetyp AND ISREFERENCE) THEN
'20090703
idnum = VAL(LEFT$(e$, INSTR(e$, "") - 1)) 'id# of sourcetyp 

'
'compare the source and dest. types
'print targettyp , sourcetyp
'print targettyp and 511, sourcetyp and 511
'print targettyp and ISPOINTER, sourcetyp and ISPOINTER
'print targettyp and ISUDT, sourcetyp and ISUDT
'print targettyp and ISARRAY, sourcetyp and ISARRAY
'print targettyp and ISREFERENCE, sourcetyp and ISREFERENCE
targettyp2 = targettyp: sourcetyp2 = sourcetyp - ISREFERENCE
IF (sourcetyp2 AND ISARRAY) THEN
arr = 1: sourcetyp2 = sourcetyp2 - ISARRAY
ELSE
arr=0
END IF
IF (sourcetyp2 AND ISPOINTER) = 0 THEN sourcetyp2 = sourcetyp2 + ISPOINTER
IF (sourcetyp2 AND ISINCONVENTIONALMEMORY) THEN sourcetyp2 = sourcetyp2 - ISINCONVENTIONALMEMORY

IF sourcetyp2 = targettyp2 THEN
'print "Similar!"
if sourcetyp and ISUDT then
'udt/udt array
getid val(e$)
udtrefi=instr(e$,"")'skip id
udtrefi=instr(udtrefi+1,e$,"")'skip u
udtrefi=instr(udtrefi+1,e$,"")'skip e
o$=right$(e$,len(e$)-udtrefi)'set o$ to the offset
if arr then
n$=scope$+"ARRAY_UDT_"+rtrim$(id.n)+"[0]"
else
n$=scope$+"UDT_"+rtrim$(id.n)
end if
e$="(void*)( ((char*)("+n$+")) + ("+right$(e$,len(e$)-udtrefi)+") )"
'print "passing:"+e$

else
'not a udt
IF arr THEN
IF (sourcetyp2 AND ISOFFSETINBITS) THEN qb64error "Cannot pass BIT array offsets yet"
e$ = "(&(" + refer(e$, sourcetyp, 0) + "))"
else
e$ = refer(e$, sourcetyp, 1)
end if

end if

'20090703
if mid$(sfcmemargs(targetid),curarg,1)=chr$(1) then 'cmem required?
if cmemlist(idnum)=0 then
cmemlist(idnum) = 1
recompile = 1
end if
end if

GOTO dontevaluate
END IF 'similar

'IF sourcetyp2 = targettyp2 THEN
'IF arr THEN
'IF (sourcetyp2 AND ISOFFSETINBITS) THEN qb64error "Cannot pass BIT array offsets yet"
'e$ = "(&(" + refer(e$, sourcetyp, 0) + "))"
'ELSE
'e$ = refer(e$, sourcetyp, 1)
'END IF
'GOTO dontevaluate
'END IF

END IF
END IF

end if 'dereference
END IF 'pointer




'IF (targettyp AND ISSTRING) = 0 THEN
'IF (sourcetyp AND ISREFERENCE) THEN
'targettyp2 = targettyp: sourcetyp2 = sourcetyp - ISREFERENCE
'IF (sourcetyp2 AND ISINCONVENTIONALMEMORY) THEN sourcetyp2 = sourcetyp2 - ISINCONVENTIONALMEMORY
'IF sourcetyp2 = targettyp2 THEN e$ = refer(e$, sourcetyp, 1): GOTO dontevaluate
'END IF
'END IF
'END IF

'change to "non-pointer" value
IF (sourcetyp AND ISREFERENCE) THEN
e$ = refer(e$, sourcetyp, 0)
END IF

'round to integer if required
IF (sourcetyp AND ISFLOAT) THEN
IF (targettyp AND ISFLOAT) = 0 THEN
'**32 rounding fix
bits = targettyp AND 511
IF bits <= 16 THEN e$ = "qbr_float_to_long(" + e$ + ")"
IF bits > 16 AND bits < 32 THEN e$ = "qbr_double_to_long(" + e$ + ")"
IF bits >= 32 THEN e$ = "qbr(" + e$ + ")"
END IF
END IF

IF explicitreference THEN
IF (targettyp AND ISOFFSETINBITS) THEN
 'integer value can fit inside int64
 e$ = "(int64)(" + e$ + ")" 
ELSE
 IF (targettyp AND ISFLOAT) THEN
  IF (targettyp AND 511) = 32 THEN e$ = "(float)(" + e$ + ")"
  IF (targettyp AND 511) = 64 THEN e$ = "(double)(" + e$ + ")"
  IF (targettyp AND 511) = 256 THEN e$ = "(long double)(" + e$ + ")"
 ELSE
  IF (targettyp AND ISUNSIGNED) THEN
   IF (targettyp AND 511) = 8 THEN e$ = "(uint8)(" + e$ + ")"
   IF (targettyp AND 511) = 16 THEN e$ = "(uint16)(" + e$ + ")"
   IF (targettyp AND 511) = 32 THEN e$ = "(uint32)(" + e$ + ")"
   IF (targettyp AND 511) = 64 THEN e$ = "(uint64)(" + e$ + ")"
  ELSE
   IF (targettyp AND 511) = 8 THEN e$ = "(int8)(" + e$ + ")"
   IF (targettyp AND 511) = 16 THEN e$ = "(int16)(" + e$ + ")"
   IF (targettyp AND 511) = 32 THEN e$ = "(int32)(" + e$ + ")"
   IF (targettyp AND 511) = 64 THEN e$ = "(int64)(" + e$ + ")"
  END IF
 END IF 'float?
END IF 'offset in bits?
END IF 'explicit?

IF (targettyp AND ISPOINTER) THEN 'pointer required
IF (targettyp AND ISSTRING) THEN GOTO dontevaluate 'no changes required
'20090703
t$ = typ2ctyp$(targettyp, "")
v$ = "pass" + str2$(uniquenumber)
'assume numeric type
if mid$(sfcmemargs(targetid),curarg,1)=chr$(1) then 'cmem required?
	bytesreq=((targettyp and 511)+7)\8
	PRINT #defdatahandle, t$ + " *" + v$ + "=NULL;"
	PRINT #13, "if(" + v$ + "==NULL){"
	PRINT #13, "cmem_sp-="+str2(bytesreq)+";"
	PRINT #13, v$ + "=(" + t$ + "*)(dblock+cmem_sp);"
	PRINT #13, "if (cmem_sp<qbs_cmem_sp) error(257);"
	PRINT #13, "}"
	e$ = "&(*" + v$ + "=" + e$+")"
else
	PRINT #13, t$ + " " + v$ + ";"
	e$ = "&(" + v$ + "=" + e$ + ")"
end if
GOTO dontevaluate
END IF

dontevaluate:

r$ = r$ + e$
IF i <> n AND nocomma = 0 THEN r$ = r$ + ","
nocomma = 0
firsti = i + 1
curarg = curarg + 1
END IF

IF curarg = skiparg AND i = n THEN
targettyp = CVL(MID$(id2.arg, curarg * 4 - 4 + 1, 4))
'IF (targettyp AND ISSTRING) THEN nerror (149)
r$ = r$ + ",NULL"
curarg = curarg + 1
END IF

NEXT
END IF

IF n$ = "UBOUND" OR n$ = "LBOUND" THEN
IF r$ = ",NULL" THEN r$ = ",1"
IF n$ = "UBOUND" THEN r2$ = "func_ubound(" ELSE r2$ = "func_lbound("
e$ = refer$(ulboundarray$, sourcetyp, 1)
'note: ID contins refer'ed array info

arrayelements=id.arrayelements '2009
if arrayelements=-1 then arrayelements=1 '2009

r$ = r2$ + e$ + r$ + "," + str2$(arrayelements) + ")"
typ& = LONGTYPE - ISPOINTER
GOTO evalfuncspecial
END IF

IF passomit THEN
IF skiparg THEN r$ = r$ + ",0" ELSE r$ = r$ + ",1"
END IF
r$ = r$ + ")"

evalfuncspecial:

if n$="ABS" then typ&=sourcetyp 'ABS Note: ABS() returns argument #1's type

'QB-like conversion of math functions returning floating point values
if n$="SIN" or n$="COS" or n$="TAN" or n$="ATN" or n$="SQR" or n$="LOG" then
b=sourcetyp and 511
if sourcetyp and ISFLOAT then
'Default is FLOATTYPE
if b=64 then typ&=DOUBLETYPE-ISPOINTER
if b=32 then typ&=SINGLETYPE-ISPOINTER
else
'Default is FLOATTYPE
if b<=32 then typ&=DOUBLETYPE-ISPOINTER
if b<=16 then typ&=SINGLETYPE-ISPOINTER
end if
end if

if debug then print #9, "evaluatefunc:out:"; r$
evaluatefunc$ = r$
END FUNCTION

FUNCTION variablesize$ (i AS LONG) 'ID or -1 (if ID already 'loaded')
'Note: assumes whole bytes, no bit offsets/sizes
if i<>-1 then getid i
'find base size from type
t=id.t: if t=0 then t=id.arraytype
bytes=(t and 511)\8

if t and isudt then 'correct size for UDTs
u=t and 511
bytes=udtxsize(u)\8
end if

if t and isstring then 'correct size for strings
if t and isfixedlength then
bytes=id.tsize
else
if id.arraytype then qb64error "Cannot determine size of variable-length string array"
variablesize$=scope$+"STRING_"+rtrim$(id.n)+"->len"
exit function
end if
end if

if id.arraytype then 'multiply size for arrays
n$ = RTRIM$(id.callname)
s$=str2(bytes)+"*("+n$+"[2]&1)" 'note: multiplying by 0 if array not currently defined (affects dynamic arrays)
arrayelements=id.arrayelements: if arrayelements=-1 then arrayelements=1 '2009
 FOR i2 = 1 TO arrayelements
 s$=s$+"*"+n$+"["+str2(i2 * 4 - 4 + 5)+"]"
 NEXT
variablesize$="("+s$+")"
exit function
end if

variablesize$=str2(bytes)
END FUNCTION



FUNCTION evaluatetotyp$ (a2$, targettyp AS LONG)
'note: 'evaluatetotyp' no longer performs 'fixoperationorder' on a2$ (in many cases, this has already been done)
a$ = a2$
e$ = evaluate(a$, sourcetyp)

if targettyp=-4 or targettyp=-5 then '? -> byte_element(offset,element size in bytes)
 IF (sourcetyp AND ISREFERENCE) = 0 THEN nerror (62)
 IF (sourcetyp AND ISOFFSETINBITS) THEN nerror (63)

' print "-4: evaluated as ["+e$+"]":sleep 1

 if (sourcetyp and ISUDT) then 'User Defined Type -> byte_element(offset,bytes)
  idnumber=VAL(e$)
  i=INSTR(e$,""): e$=RIGHT$(e$,LEN(e$)-i)
  u=VAL(e$) 'closest parent
  i=INSTR(e$,""): e$=RIGHT$(e$,LEN(e$)-i)
  e=VAL(e$)
  i=INSTR(e$,""): e$=RIGHT$(e$,LEN(e$)-i)
  o$=e$
  getid idnumber
  n$="UDT_"+rtrim$(id.n)
  if id.arraytype then
  n$="ARRAY_"+n$+"[0]"
   'whole array reference examplename()?  
   if left$(o$,3)="(0)" then
   'use -2 type method
   goto method2usealludt
   end if
  end if
  'determine size of element
  if e=0 then 'no specific element, use size of entire type
  bytes$=str2(udtxsize(u)\8)
  else 'a specific element
  bytes$=str2(udtesize(e)\8)
  end if
  dst$="(((char*)"+scope$+n$+")+("+o$+"))"
  evaluatetotyp$ = "byte_element((uint64)" + dst$ + "," + bytes$+ ")"
  if targettyp=-5 then evaluatetotyp$ = bytes$
  exit function
 end if

 if (sourcetyp and ISARRAY) then 'Array reference -> byte_element(offset,bytes)
  'whole array reference examplename()?
  if right$(e$,2)="0" then
  'use -2 type method
  IF sourcetyp AND ISSTRING THEN
  IF (sourcetyp AND ISFIXEDLENGTH)=0 THEN
  qb64error "Cannot pass array of variable-length strings"  
  end if
  end if
  goto method2useall
  end if
  'assume a specific element
  IF sourcetyp AND ISSTRING THEN
   IF sourcetyp AND ISFIXEDLENGTH THEN 
    idnumber=VAL(e$)
    getid idnumber
    bytes$=str2(id.tsize)
    e$ = refer(e$, sourcetyp, 0)
    evaluatetotyp$ = "byte_element((uint64)" + e$ + "->chr," +bytes$+ ")"
    if targettyp=-5 then evaluatetotyp$ = bytes$
   else
    e$ = refer(e$, sourcetyp, 0)
    evaluatetotyp$ = "byte_element((uint64)" + e$ + "->chr," + e$ + "->len)"
    if targettyp=-5 then evaluatetotyp$ = e$ + "->len"
   end if
   exit function
  end if
  e$ = refer(e$, sourcetyp, 0)
  e$ = "(&(" + e$ + "))"
  bytes$=str2((sourcetyp and 511)\8)
  evaluatetotyp$ = "byte_element((uint64)" + e$ + "," + bytes$+ ")"
  if targettyp=-5 then evaluatetotyp$ = bytes$
  exit function
 end if

 IF sourcetyp AND ISSTRING THEN 'String -> byte_element(offset,bytes)
  IF sourcetyp AND ISFIXEDLENGTH THEN 
   idnumber=VAL(e$)
   getid idnumber
   bytes$=str2(id.tsize)
   e$ = refer(e$, sourcetyp, 0)
  else
   e$ = refer(e$, sourcetyp, 0)
   bytes$=e$ + "->len"
  end if
  evaluatetotyp$ = "byte_element((uint64)" + e$ + "->chr," + bytes$+")"
  if targettyp=-5 then evaluatetotyp$ = bytes$
  exit function
 end if

 'Standard variable -> byte_element(offset,bytes)
 e$ = refer(e$, sourcetyp, 1)'get the variable's formal name
 size = (sourcetyp AND 511) \ 8 'calculate its size in bytes
 evaluatetotyp$ = "byte_element((uint64)" + e$ + "," + str2(size) + ")"
 if targettyp=-5 then evaluatetotyp$ = str2(size)
 exit function

end if '-4



if targettyp=-2 then '? -> byte_element(offset,max possible bytes)
method2useall:
' print "CI: eval2typ detected target type of -2 for ["+a2$+"] evaluated as ["+e$+"]":sleep 1 

 IF (sourcetyp AND ISREFERENCE) = 0 THEN nerror (62)
 IF (sourcetyp AND ISOFFSETINBITS) THEN nerror (63)

  'User Defined Type -> byte_element(offset,bytes)
  if (sourcetyp and ISUDT) then
' 			print "CI: -2 type from a UDT":sleep 1 
   idnumber=VAL(e$)
   i=INSTR(e$,""): e$=RIGHT$(e$,LEN(e$)-i)
   u=VAL(e$) 'closest parent
   i=INSTR(e$,""): e$=RIGHT$(e$,LEN(e$)-i)
   e=VAL(e$)
   i=INSTR(e$,""): e$=RIGHT$(e$,LEN(e$)-i)
   o$=e$
   getid idnumber
   n$="UDT_"+rtrim$(id.n): if id.arraytype then n$="ARRAY_"+n$+"[0]"
   method2usealludt:
   bytes$=variablesize$(-1)+"-("+o$+")"
   dst$="(((char*)"+scope$+n$+")+("+o$+"))"
   evaluatetotyp$ = "byte_element((uint64)" + dst$ + "," + bytes$+ ")"
   if targettyp=-5 then evaluatetotyp$ = bytes$
   exit function
  end if

  'Array reference -> byte_element(offset,bytes)
  if (sourcetyp and ISARRAY) then
   'array of variable length strings (special case, can only refer to single element)
   IF sourcetyp AND ISSTRING THEN
   IF (sourcetyp AND ISFIXEDLENGTH)=0 THEN 
   e$ = refer(e$, sourcetyp, 0)
   evaluatetotyp$ = "byte_element((uint64)" + e$ + "->chr," + e$ + "->len)"
   if targettyp=-5 then evaluatetotyp$ = e$ + "->len"
   exit function
   end if
   end if
  idnumber=VAL(e$)
  getid idnumber
  tsize=id.tsize 'used later to determine element size of fixed length strings
  'note: array references consist of idnumber|unmultiplied-element-index
  index$=right$(e$,len(e$)-instr(e$,"")) 'get element index
  bytes$=variablesize$(-1)
  e$ = refer(e$, sourcetyp, 0)
  e$ = "(&(" + e$ + "))"
'			print "CI: array: e$["+e$+"], bytes$["+bytes$+"]":sleep 1 
  'calculate size of elements
  IF sourcetyp AND ISSTRING THEN
  bytes=tsize
  else
  bytes=(sourcetyp and 511)\8
  end if  
  bytes$=bytes$+"-("+str2(bytes)+"*("+index$+"))"
  evaluatetotyp$ = "byte_element((uint64)" + e$ + "," + bytes$+ ")"
  if targettyp=-5 then evaluatetotyp$ = bytes$
'			print "CI: array ->["+"byte_element((uint64)" + e$ + "," + bytes$+ ")"+"]":sleep 1
  exit function
  end if

  'String -> byte_element(offset,bytes)
  IF sourcetyp AND ISSTRING THEN
  IF sourcetyp AND ISFIXEDLENGTH THEN 
   idnumber=VAL(e$)
   getid idnumber
   bytes$=str2(id.tsize)
   e$ = refer(e$, sourcetyp, 0)
  else
   e$ = refer(e$, sourcetyp, 0)
   bytes$=e$ + "->len"
  end if
  evaluatetotyp$ = "byte_element((uint64)" + e$ + "->chr," + bytes$+")"
  if targettyp=-5 then evaluatetotyp$ = bytes$
  exit function
  end if

  'Standard variable -> byte_element(offset,bytes)
  e$ = refer(e$, sourcetyp, 1)'get the variable's formal name
  size = (sourcetyp AND 511) \ 8 'calculate its size in bytes
  evaluatetotyp$ = "byte_element((uint64)" + e$ + "," + str2(size) + ")"
  if targettyp=-5 then evaluatetotyp$ = str2(size)
  exit function

end if '-2 byte_element(offset,bytes)



'string?
IF (sourcetyp AND ISSTRING) <> (targettyp AND ISSTRING) THEN
nerror (77)
END IF

IF (sourcetyp AND ISSTRING) THEN
evaluatetotyp$ = e$
IF (sourcetyp AND ISREFERENCE) THEN
evaluatetotyp$ = refer(e$, sourcetyp, 0)
END IF
EXIT FUNCTION
END IF

'pointer required?
IF (targettyp AND ISPOINTER) THEN
nerror (78)
'...
nerror (79)
END IF

'change to "non-pointer" value
IF (sourcetyp AND ISREFERENCE) THEN
e$ = refer(e$, sourcetyp, 0)
END IF
'check if successful
IF (sourcetyp AND ISPOINTER) THEN
nerror (80)
END IF

'round to integer if required
IF (sourcetyp AND ISFLOAT) THEN
IF (targettyp AND ISFLOAT) = 0 THEN
bits = targettyp AND 511
'**32 rounding fix
IF bits <= 16 THEN e$ = "qbr_float_to_long(" + e$ + ")"
IF bits > 16 AND bits < 32 THEN e$ = "qbr_double_to_long(" + e$ + ")"
IF bits >= 32 THEN e$ = "qbr(" + e$ + ")"
END IF
END IF

evaluatetotyp$ = e$
END FUNCTION

FUNCTION findid& (n2$)
n$ = ucase$(n2$) 'case insensitive

'return all strings as 'not found'
if asc(n$)=34 then goto noid

'if findidsecondarg was set, it will be used for finding the name of a sub (not a func or variable)
secondarg$ = findidsecondarg: findidsecondarg = ""

'if findanotherid was set, findid will continue scan from last index, otherwise, it will begin a new search
findanother = findanotherid: findanotherid = 0
IF findanother <> 0 AND findidinternal = 0 THEN nerror (81) 'cannot continue search, no more indexes left!
                                                            '(the above should never happen)
findid& = 2 '2=not finished searching all indexes

'seperate symbol from name (if a symbol has been added), this is the only way symbols can be passed to findid
i = 0
i = INSTR(n$, "~"): IF i THEN GOTO gotsc
i = INSTR(n$, "`"): IF i THEN GOTO gotsc
i = INSTR(n$, "%"): IF i THEN GOTO gotsc
i = INSTR(n$, "&"): IF i THEN GOTO gotsc
i = INSTR(n$, "!"): IF i THEN GOTO gotsc
i = INSTR(n$, "#"): IF i THEN GOTO gotsc
i = INSTR(n$, "$"): IF i THEN GOTO gotsc
gotsc:
if i then
sc$ = RIGHT$(n$, LEN(n$) - i + 1): n$ = LEFT$(n$, i - 1)
IF sc$ = "`" or sc$="~`" THEN sc$ = sc$ + "1" 'clarify abbreviated 1 bit reference
else
'no symbol passed, so check what symbol could be assumed under the current DEF...
v=asc(n$): if v=95 then v=27 else v=v-64
if v>=1 and v<=27 then 'safeguard against n$ not being a standard name
couldhavesc$=defineextaz(v)
IF couldhavesc$ = "`" or couldhavesc$="~`" THEN couldhavesc$ = couldhavesc$ + "1" 'clarify abbreviated 1 bit reference
end if 'safeguard
end if

'optomizations for later comparisons
insf$=subfunc+space$(256-len(subfunc))
secondarg$=secondarg$+space$(256-len(secondarg$))
if len(sc$) then scpassed=1: sc$ = sc$ + SPACE$(8 - LEN(sc$)) else scpassed=0
if len(couldhavesc$) then couldhavesc$ = couldhavesc$ + SPACE$(8 - LEN(couldhavesc$)):couldhavescpassed=1 else couldhavescpassed=0
IF LEN(n$) < 256 THEN n$ = n$ + SPACE$(256 - LEN(n$))

'continue from previous position?
IF findanother THEN start = findidinternal ELSE start = idn

for i = start TO 1 step -1

findidinternal = i - 1
IF findidinternal = 0 THEN findid& = 1 '1=found id, but no more to search

if ids(i).n=n$ then 'same name?

'in scope?
IF ids(i).subfunc=0 and ids(i).share=0 THEN 'scope check required (not a shared variable or the name of a sub/function)
IF ids(i).insubfunc <> insf$ THEN goto findidnomatch
end if

'some subs require a second argument (eg. PUT #, DEF SEG, etc.)
if ids(i).subfunc=2 then
if asc(ids(i).secondargmustbe)<>32 then 'exists?
IF secondarg$ <> ids(i).secondargmustbe THEN GOTO findidnomatch
end if
if asc(ids(i).secondargcantbe)<>32 then 'exists?
IF secondarg$ = ids(i).secondargcantbe THEN GOTO findidnomatch
end if
end if 'second sub argument possible

'must have symbol?
'typically for variables defined automatically or by a symbol and not the full type name
imusthave=cvi(ids(i).musthave) 'speed up checks of first 2 characters
amusthave=imusthave and 255   'speed up checks of first character
if amusthave<>32 then
if scpassed then
if sc$ = ids(i).musthave THEN GOTO findidok
end if
if couldhavescpassed then
if couldhavesc$ = ids(i).musthave THEN GOTO findidok
end if
'note: symbol defined fixed length strings cannot be referred to by $ without an extension
'note: sc$ and couldhavesc$ are already changed from ` to `1 to match stored musthave
GOTO findidnomatch
END IF

'may have symbol?
'typically for variables formally dim'd
'note: couldhavesc$ needn't be considered for mayhave checks
IF scpassed THEN 'symbol was passed, so it must match the mayhave symbol
imayhave=cvi(ids(i).mayhave) 'speed up checks of first 2 characters
amayhave=imayhave and 255   'speed up checks of first character
if amayhave=32 then goto findidnomatch 'it cannot have the symbol passed (nb. musthave symbols have already been ok'd)
 'note: variable length strings are not a problem here, as they can only have one possible extension
 if amayhave=36 then '"$"
 if imayhave<>8228 then '"$ "
 'it is a fixed length string
 if cvi(sc$)=8228 then goto findidok 'allow myvariable$ to become myvariable$10
 'allow later comparison to verify if extension is correct
 end if
 end if
IF sc$ <> ids(i).mayhave THEN GOTO findidnomatch
END IF 'scpassed

'return id
findidok:

id=ids(i)

currentid = i
EXIT FUNCTION

END IF 'same name
findidnomatch:
NEXT

'totally unclassifiable
noid:
findid& = 0
currentid = -1
END FUNCTION

FUNCTION findvariable (secure$)
'only used in const equation and for statement. consider making redundant.

n$ = secure$
if debug then print #9, "func findvariable:in:"+n$

'assumes the variable is not an array!

'sets idz to hold info about the variable wanted
'also creates variables if they don't exist

'establish whether v$ includes an extension
i = INSTR(n$, "~"): IF i THEN sc$ = RIGHT$(n$, LEN(n$) - i + 1): n$ = LEFT$(n$, i - 1): GOTO gotsc2
i = INSTR(n$, "`"): IF i THEN sc$ = RIGHT$(n$, LEN(n$) - i + 1): n$ = LEFT$(n$, i - 1): GOTO gotsc2
i = INSTR(n$, "%"): IF i THEN sc$ = RIGHT$(n$, LEN(n$) - i + 1): n$ = LEFT$(n$, i - 1): GOTO gotsc2
i = INSTR(n$, "&"): IF i THEN sc$ = RIGHT$(n$, LEN(n$) - i + 1): n$ = LEFT$(n$, i - 1): GOTO gotsc2
i = INSTR(n$, "!"): IF i THEN sc$ = RIGHT$(n$, LEN(n$) - i + 1): n$ = LEFT$(n$, i - 1): GOTO gotsc2
i = INSTR(n$, "#"): IF i THEN sc$ = RIGHT$(n$, LEN(n$) - i + 1): n$ = LEFT$(n$, i - 1): GOTO gotsc2
i = INSTR(n$, "$"): IF i THEN sc$ = RIGHT$(n$, LEN(n$) - i + 1): n$ = LEFT$(n$, i - 1): GOTO gotsc2
gotsc2:
n2$ = n$ + sc$

IF sc$ <> "" THEN
'has an extension
'note! findid must unambiguify ` to `5 or $ to $10 where applicable
'pass variable with extension
try = findid(n2$)
DO WHILE try
IF id.t THEN 'check it is a variable and not something else
'id is already set correctly, so simply return found variable
EXIT FUNCTION
END IF
IF try = 2 THEN findanotherid = 1: try = findid(n2$) ELSE try = 0
LOOP
GOTO createunknownvariable
EXIT FUNCTION
ELSE
'no extension
'1. pass as is, without any extension



try = findid(n2$)
DO WHILE try
IF id.t THEN 'check it is a variable and not something else
'id is already set correctly, so simply return found variable
EXIT FUNCTION
END IF
IF try = 2 THEN findanotherid = 1: try = findid(n2$) ELSE try = 0
LOOP

'2. that failed, so apply the _define'd extension and pass
'note! valid variable names start with

if debug then print #9, "func findvariable:try add ext:"+n$


a = ASC(ucase$(n$)): IF a = 95 THEN a = 91
a = a - 64 'so A=1, Z=27 and _=28
n2$ = n$ + defineextaz(a)
try = findid(n2$)
DO WHILE try
IF id.t THEN 'check it is a variable and not something else
'id is already set correctly, so simply return found variable
EXIT FUNCTION
END IF
IF try = 2 THEN findanotherid = 1: try = findid(n2$) ELSE try = 0
LOOP
GOTO createunknownvariable
END IF
createunknownvariable:

typ$ = removesymbol$(n2$)
retval = dim2(n2$, typ$, 1, "")

'create variable n2$
if debug then print #9, "CREATING VARIABLE:" + n2$
'ignore = createquickvariable(n2$)

END FUNCTION

FUNCTION fixoperationorder$ (savea$)
a$=savea$
if debug then print #9, "fixoperationorder:in:" + a$

fooindwel=fooindwel+1

n = numelements(a$) 'n is maintained throughout function

if fooindwel=1 then 'actions to take on initial call only

'----------------A. 'Quick' mismatched brackets check----------------
b=0
a2$=sp+a$+sp
b1$=sp+"("+sp
b2$=sp+")"+sp
i=1
findmmb:
i1=instr(i,a2$,b1$)
i2=instr(i,a2$,b2$)
i3=i1
if i2 then
 if i1=0 then
  i3=i2
 else
  if i2<i1 then i3=i2
 end if
end if
if i3 then
if i3=i1 then b=b+1
if i3=i2 then b=b-1
i=i3+2
if b<0 then qb64error "Missing ("
goto findmmb
end if
if b>0 then qb64error "Missing )"

'----------------B. 'Quick' correction of over-use of +,- ----------------
'note: the results of this change are beneficial to foolayout
a2$=sp+a$+sp

'rule 1: change ++ to +
rule1:
i=instr(a2$,sp+"+"+sp+"+"+sp)
if i then
a2$=left$(a2$,i+2)+right$(a2$,len(a2$)-i-4)
a$=mid$(a2$,2,len(a2$)-2)
n=n-1
if debug then print #9, "fixoperationorder:+/-:" + a$
goto rule1
end if

'rule 2: change -+ to -
rule2:
i=instr(a2$,sp+"-"+sp+"+"+sp)
if i then
a2$=left$(a2$,i+2)+right$(a2$,len(a2$)-i-4)
a$=mid$(a2$,2,len(a2$)-2)
n=n-1
if debug then print #9, "fixoperationorder:+/-:" + a$
goto rule2
end if

'rule 3: change anyoperator-- to anyoperator
rule3:
if instr(a2$,sp+"-"+sp+"-"+sp) then
FOR i = 1 TO n-2
if isoperator(getelement(a$, i)) then
if getelement(a$, i+1)="-" then
if getelement(a$, i+2)="-" then
removeelements a$, i + 1, i + 2, 0
a2$=sp+a$+sp
n=n-2
if debug then print #9, "fixoperationorder:+/-:" + a$
goto rule3
end if
end if
end if
next
end if 'rule 3



'----------------C. 'Quick' location of negation----------------
'note: the results of this change are beneficial to foolayout

'for numbers...
'before: anyoperator,-,number
'after:  anyoperator,-number

'for variables...
'before: anyoperator,-,variable
'after:  anyoperator,,variable

'exception for numbers followed by ^... (they will be bracketed up along with the ^ later)
'before: anyoperator,-,number,^
'after:  anyoperator,,number,^

for i=1 to n-1
if i>n-1 then exit for 'n changes, so manually exit if required

if asc(getelement(a$, i))=45 then '-

neg=0
if i=1 then
neg=1
else
a2$=getelement(a$, i-1)
c=asc(a2$)
if c=40 or c=44 then '(,
neg=1
else
if isoperator(a2$) then neg=1
end if '()
end if 'i=1
if neg=1 then

a2$=getelement(a$, i+1)
c=asc(a2$)
IF c>=48 AND c<=57 then
c2=0: if i<n-1 then c2=asc(getelement(a$, i+2))
if c2<>94 then 'not ^
'number...
i2=instr(a2$,",")
if i2 and asc(a2$,i2+1)<>38 then '&H/&O/&B values don't need the assumed negation
a2$="-"+left$(a2$,i2)+"-"+right$(a2$,len(a2$)-i2)
else
a2$="-"+a2$
end if
removeelements a$, i, i + 1, 0
insertelements a$, i - 1, a2$
n=n-1
if debug then print #9, "fixoperationorder:negation:" + a$

goto negdone
end if
end if


'not a number (or for exceptions)...
removeelements a$, i, i, 0
insertelements a$, i - 1, ""
if debug then print #9, "fixoperationorder:negation:" + a$

end if 'isoperator
end if '-
negdone:
next



end if 'fooindwel=1



'----------------D. 'Quick' Add 'power of' with negation {}bracketing to bottom bracket level----------------
pownegused=0
powneg:
if instr(a$,"^"+sp+"") then 'quick check
b=0
b1 = 0
FOR i = 1 TO n
a2$ = getelement(a$, i)
c=asc(a2$)
IF c=40 THEN b = b + 1
IF c=41 THEN b = b - 1
IF b = 0 THEN
IF b1 THEN
IF isoperator(a2$) THEN
IF a2$<>"^" and a2$<>"" then
insertelements a$, i-1, "}"
insertelements a$, b1, "{"
n = n+2
if debug then print #9, "fixoperationorder:^-:" + a$
GOTO powneg
pownegused=1
end if
END IF
END IF
IF c=94 then '^
if getelement$(a$, i + 1) = "" THEN b1 = i: i = i + 1
end if
END IF 'b=0
NEXT i
IF b1 THEN
insertelements a$, b1, "{"
a$ = a$ + sp + "}"
n = n+2
if debug then print #9, "fixoperationorder:^-:" + a$
pownegused=1
GOTO powneg
END IF

end if 'quick check



'----------------E. Find lowest & highest operator level in bottom bracket level----------------
lco = 255
hco = 0
b=0
FOR i = 1 TO n
a2$ = getelement(a$, i)
c=asc(a2$)
IF c=40 or c=123 THEN b = b + 1
IF c=41 or c=125 THEN b = b - 1
IF b = 0 THEN
op = isoperator(a2$)
if op then
IF op < lco THEN lco = op
IF op > hco THEN hco = op
end if
end if
next

'----------------F. Add operator {}bracketting----------------
'apply bracketting only if required
IF hco <> 0 THEN 'operators were used
IF lco <> hco THEN
'brackets needed
n2=n
b = 0
a3$ = "{"
n=1
FOR i = 1 TO n2
a2$ = getelement(a$, i)
c=asc(a2$)
IF c=40 or c=123 then b = b + 1
IF c=41 or c=125 then b = b - 1
IF b = 0 THEN
op = isoperator(a2$)
IF op = lco THEN
 IF i = 1 THEN
 a3$ = a2$ + sp + "{"
 n=2
 ELSE
 a3$ = a3$ + sp + "}" + sp + a2$ + sp + "{"
 n=n+3
 END IF
GOTO fixop0
END IF

END IF 'b=0
a3$ = a3$ + sp + a2$
n=n+1
fixop0:
NEXT
a3$ = a3$ + sp + "}"
n=n+1
a$ = a3$
if debug then print #9, "fixoperationorder:lco bracketing[";lco;",";hco;"]:" + a$



'--------(F)G. Remove indwelling {}bracketting from power-negation--------
if pownegused then
b=0
i=0
do while i<=n
i=i+1
c=asc(getelement(a$, i))
IF c=41 or c=125 then b = b - 1
if (c=123 or c=125) and b<>0 then 
removeelements a$, i, i, 0
n=n-1
i=i-1
if debug then print #9, "fixoperationorder:^- {} removed:" + a$
end if
IF c=40 or c=123 then b = b + 1
loop
end if 'pownegused

END IF 'lco <> hco
END IF 'hco <> 0

'----------------H. Identification/conversion of elements within bottom bracket level----------------
'actions performed:
'	->builds f$(tlayout)
'	->adds symbols to all numbers
'	->evaluates constants to numbers

f$=""
b=0
c=0
for i=1 to n
f2$ = getelement(a$, i)
lastc=c
c=asc(f2$)

IF c=40 or c=123 then
if c<>40 or b<>0 then f2$="" 'skip temporary & indwelling  brackets
b = b + 1
goto classdone
end if
IF c=41 or c=125 then
b = b - 1
if c<>41 or b<>0 then f2$="" 'skip temporary & indwelling  brackets
goto classdone
end if

IF b = 0 THEN

'classifications/conversions:
'1. quoted string ("....)
'2. number
'3. operator
'4. constant
'5. variable/array/udt/function (note: nothing can share the same name as a function except a label)


'quoted string?
if c=34 then '"
'convert \\ to \
'convert \??? to CHR$(&O???)
x2=1
x=instr(x2,f2$,"\")
do while x
c2=asc(f2$,x+1)
if c2=92 then '\\
f2$=left$(f2$,x)+right$(f2$,len(f2$)-x-1) 'remove second \
x2=x+1
else
'octal triplet value
c3=(asc(f2$,x+3)-48)+(asc(f2$,x+2)-48)*8+(asc(f2$,x+1)-48)*64
f2$=left$(f2$,x-1)+chr$(c3)+right$(f2$,len(f2$)-x-3)
x2=x+1
end if
x=instr(x2,f2$,"\")
loop
'remove ',len' (if it exists)
x=instr(2,f2$,chr$(34)+","): if x then f2$=left$(f2$,x)
goto classdone
end if

'number?
if (c>=48 and c<=57) or c=45 then

x=instr(f2$,",")
if x then
removeelements a$, i, i, 0: insertelements a$, i-1, left$(f2$,x-1)
f2$=right$(f2$,len(f2$)-x)
end if

if x=0 then
c2=asc(f2$,len(f2$))
if c2<48 or c2>57 then
x=1 'extension given
else
x=instr(f2$,"`")
end if
end if

'add appropriate integer symbol if none present
if x=0 then
f3$=f2$
s$=""
if c=45 then
s$="&&"
if f3$<="-2147483648" or len(f3$)<11 then s$="&"
if f3$<="-32768" or len(f3$)<6 then s$="%"
else
s$="~&&"
if f3$<="9223372036854775807" or len(f3$)<19 then s$="&&"
if f3$<="2147483647" or len(f3$)<10 then s$="&"
if f3$<="32767" or len(f3$)<5 then s$="%"
end if
f3$=f3$+s$
removeelements a$, i, i, 0: insertelements a$, i-1, f3$
end if 'x=0

goto classdone
end if

'operator?
if isoperator(f2$) then
if len(f2$)>1 then
if f2$<>ucase$(f2$) then
f2$=ucase$(f2$)
removeelements a$, i, i, 0
insertelements a$, i-1, f2$
end if
end if
'append negation
if f2$="" then f$=f$+sp+"-": goto classdone_special
goto classdone
end if


if alphanumeric(c) then
if i<n then nextc=asc(getelement(a$, i+1)) else nextc=0

if nextc<>40 then '<>"(" (not an array)
if lastc<>46 then '<>"." (not an element of a UDT)

e$=ucase$(f2$)
es$=removesymbol$(e$)
for i2=constlast to 0 step -1
if e$=constname(i2) then

'is a STATIC variable overriding this constant?
staticvariable=0
try = findid(e$+es$)
DO WHILE try
IF id.arraytype=0 THEN staticvariable=1:exit do 'if it's not an array, it's probably a static variable
IF try = 2 THEN findanotherid = 1: try = findid(e$+es$) ELSE try = 0
LOOP
if staticvariable=0 then

t=consttype(i2)
if t and ISSTRING then
	if len(es$)>0 and es$<>"$" then qb64error "Type mismatch"
	e$=conststring(i2)
else 'not a string
	if len(es$) then et=typname2typ(es$) else et=0
	if et and ISSTRING then qb64error "Type mismatch"
'convert value to general formats
if t and ISFLOAT then
 v##=constfloat(i2)
 v&&=v##
 v~&&=v&&
else
 if t and ISUNSIGNED then
  v~&&=constuinteger(i2)
  v&&=v~&&
  v##=v&&
 else
  v&&=constinteger(i2)
  v##=v&&
  v~&&=v&&
 end if
end if
'apply type conversion if necessary
if et then t=et
'(todo: range checking)
'convert value into string for returning
if t and ISFLOAT then
 e$=ltrim$(rtrim$(str$(v##)))
else
 if t and ISUNSIGNED then
  e$=ltrim$(rtrim$(str$(v~&&)))
 else
  e$=ltrim$(rtrim$(str$(v&&)))
 end if
end if

'floats returned by str$ must be converted to qb64 standard format
if t and ISFLOAT then
 t2=t and 511
 'find E,D or F
 s$=""
 if instr(e$,"E") then s$="E"
 if instr(e$,"D") then s$="D"
 if instr(e$,"F") then s$="F"
 if len(s$) then
  'E,D,F found
  x=instr(e$,s$)
  'as incorrect type letter may have been returned by STR$, override it
  if t2=32 then s$="E"
  if t2=64 then s$="D"
  if t2=256 then s$="F"
  mid$(e$,x,1)=s$
  if instr(e$,".")=0 then e$=left$(e$,x-1)+".0"+right$(e$,len(e$)-x+1):x=x+2
  if left$(e$,1)="." then e$="0"+e$
  if left$(e$,2)="-." then e$="-0"+right$(e$,len(e$)-1)
  if instr(e$,"+")=0 and instr(e$,"-")=0 then
  e$=left$(e$,x)+"+"+right$(e$,len(e$)-x)
  end if
 else
  'E,D,F not found
  if instr(e$,".")=0 then e$=e$+".0"
  if left$(e$,1)="." then e$="0"+e$
  if left$(e$,2)="-." then e$="-0"+right$(e$,len(e$)-1)
  if t2=32 then e$=e$+"E+0"
  if t2=64 then e$=e$+"D+0"
  if t2=256 then e$=e$+"F+0"
 end if
else
 s$=typevalue2symbol$(t)
 e$=e$+s$ 'simply append symbol to integer
end if

end if 'not a string

removeelements a$, i, i , 0
insertelements a$, i - 1, e$
'alter f2$ here to original casing
f2$=ucase$(left$(f2$,1))+lcase$(right$(f2$,len(f2$)-1))
goto classdone

end if 'not static
end if 'same name
next
end if 'not udt element
end if 'not array
'REFERENCE:
'dim shared constmax as long
'constmax=10000
'dim shared constlast as long
'constlast=-1
'dim shared constname(constmax) as STRING
'dim shared constnamesymbol (constmax) as STRING 'optional name symbol
'' `1 and `no-number must be handled correctly
'dim shared constlastshared as LONG 'so any defined inside a sub/function after this index can be "forgotten" when sub/function exits
'constlastshared=-1
'dim shared consttype(constmax) as LONG 'variable type number
''consttype determines storage
'dim shared constinteger(constmax) as _INTEGER64
'dim shared constuinteger(constmax) as _UNSIGNED _INTEGER64
'dim shared constfloat(constmax) as _FLOAT
'dim shared conststring(constmax) as STRING


'variable/array/udt?
u$=f2$
try = findid(f2$)
DO WHILE try
if debug then print #9, "found id matching "+f2$

if nextc=40 then '(

'function or array?
if id.arraytype<>0 or id.subfunc=1 then
'note: even if it's an array of UDTs, the bracketted index will follow immediately

'correct name
f3$=f2$
s$=removesymbol$(f3$)
f2$=rtrim$(id.cn)+s$
removeelements a$, i, i, 0
insertelements a$, i-1, ucase$(f2$)
f$=f$+f2$+sp+"("+sp

'skip (but record with nothing inside them) brackets
b2=1 'already in first bracket
for i2=i+2 to n
c2=asc(getelement(a$, i2))
IF c2=40 then b2=b2+1
IF c2=41 then b2=b2-1
if b2=0 then exit for 'note: mismatched brackets check ensures this always succeeds
f$=f$+sp
next

'adjust i accordingly
i=i2

f$=f$+")"

'jump to UDT section if array is of UDT type (and elements are referenced)
if id.arraytype and ISUDT then
if i<n then nextc=asc(getelement(a$, i+1)) else nextc=0
if nextc=46 then t=id.arraytype: goto fooudt
end if

f$=f$+sp
goto classdone_special
end if 'id.arraytype
end if 'nextc "("

if nextc<>40 then 'not "(" (this avoids confusing simple variables with arrays)
if id.t<>0 or id.subfunc=1 then 'simple variable or function (without parameters)

if id.t and ISUDT then
'note: it may or may not be followed by a period (eg. if whole udt is being referred to)
'check if next item is a period

'correct name
f2$=rtrim$(id.cn)+removesymbol$(f2$)
removeelements a$, i, i, 0
insertelements a$, i-1, ucase$(f2$)
f$=f$+f2$



if nextc<>46 then f$=f$+sp: goto classdone_special 'no sub-elements referenced
t=id.t

fooudt:

f$=f$+sp+"."+sp
e=udtxnext(t and 511) 'next element to check
i=i+2

'loop

'"." encountered, i must be an element
if i>n then qb64error "Expected .element"
f2$=getelement(a$, i)
s$=removesymbol$(f2$)
u$=ucase$(f2$)+space$(256-len(f2$))'fast scanning

'is f$ the same as element e?
fooudtnexte:
if udtename(e)=u$ then
'match found
'todo: check symbol(s$) matches element's type

'correct name
f2$=rtrim$(udtecname(e))+s$
removeelements a$, i, i, 0
insertelements a$, i-1, ucase$(f2$)
f$=f$+f2$

if i=n then f$=f$+sp: goto classdone_special
nextc=asc(getelement(a$, i+1))
if nextc<>46 then f$=f$+sp: goto classdone_special 'no sub-elements referenced
'sub-element exists
t=udtetype(e)
if (t and ISUDT)=0 then qb64error "Invalid . after element"
goto fooudt

end if 'match found

'no, so check next element
e=udtenext(e)
if e=0 then qb64error "Element not defined"
goto fooudtnexte

end if 'udt

'non array/udt based variable
f3$=f2$
s$=removesymbol$(f3$)
f2$=rtrim$(id.cn)+s$
'change was is returned to uppercase
removeelements a$, i, i, 0
insertelements a$, i-1, ucase$(f2$)
exit do
end if 'id.t

end if 'nextc not "("

IF try = 2 THEN findanotherid = 1: try = findid(f2$) ELSE try = 0
LOOP

'alphanumeric, but item name is unknown... is it an internal type? if so, use capitals
f3$=ucase$(f2$)
internaltype=0
if f3$="_UNSIGNED" then internaltype=1
if f3$="_BIT" then internaltype=1
if f3$="_BYTE" then internaltype=1
if f3$="INTEGER" then internaltype=1
if f3$="LONG" then internaltype=1
if f3$="_INTEGER64" then internaltype=1
if f3$="SINGLE" then internaltype=1
if f3$="DOUBLE" then internaltype=1
if f3$="_FLOAT" then internaltype=1
if internaltype=1 then
f2$=f3$
removeelements a$, i, i, 0
insertelements a$, i-1, f3$
goto classdone
end if

goto classdone
end if 'alphanumeric

classdone:
f$=f$+f2$
end if 'b=0
f$=f$+sp
classdone_special:
next
if len(f$) then f$=left$(f$,len(f$)-1) 'remove trailing 'sp'

if debug then print #9, "fixoperationorder:identification:" + a$,n
if debug then print #9, "fixoperationorder:identification(layout):" + f$,n


'----------------I. Pass (){}bracketed items (if any) to fixoperationorder & build return----------------
'note: items seperated by commas are done seperately

ff$=""
b = 0
b2=0
p1=0 'where level 1 began
aa$ = ""
n = numelements(a$)
FOR i = 1 TO n

openbracket=0

a2$ = getelement(a$, i)

c=asc(a2$)



IF c=40 or c=123 then '({
b = b + 1

if b=1 then




p1=i+1
aa$=aa$+"("+sp

end if

openbracket=1

goto foopass

end if '({

IF c=44 then ',
if b=1 then
goto foopassit
end if
end if

IF c=41 or c=125 then ')}
b = b - 1

if b=0 then
foopassit:
if p1<>i then
foo$ = fixoperationorder(getelements(a$,p1,i-1))
if len(foo$) then
aa$=aa$+foo$+sp
if c=125 then ff$=ff$+tlayout$+sp else ff$=ff$+tlayout$+sp2 'spacing between ) } , varies
end if
end if
if c=44 then aa$=aa$+","+sp: ff$=ff$+","+sp else aa$=aa$+")"+sp
p1=i+1
end if

goto foopass
end if ')}




if b=0 then aa$=aa$+a2$+sp


foopass:

f2$ = getelementspecial(f$, i)
if len(f2$) then

'use sp2 to join items connected by a period
if c=46 then '"."
if i>1 and i<n then 'stupidity check
if len(ff$) then mid$(ff$,len(ff$),1)=sp2 'convert last spacer to a sp2
ff$=ff$+"."+sp2
goto fooloopnxt
end if
end if

'spacing just before (
if openbracket then

	'convert last spacer?
	if i<>1 then
	if isoperator(getelement$(a$,i-1))=0 then
	mid$(ff$,len(ff$),1)=sp2
	end if
	end if
ff$=ff$+f2$+sp2
else 'not openbracket
ff$=ff$+f2$+sp 
end if

end if 'len(f2$)

fooloopnxt:

next

if len(aa$) then aa$=left$(aa$,len(aa$)-1)
if len(ff$) then ff$=left$(ff$,len(ff$)-1)

if debug then print #9, "fixoperationorder:return:" + aa$
if debug then print #9, "fixoperationorder:layout:" + ff$
tlayout$=ff$
fixoperationorder$ = aa$

fooindwel=fooindwel-1
END FUNCTION




FUNCTION getelementspecial$ (savea$, elenum)
a$=savea$
IF a$ = "" THEN EXIT FUNCTION 'no elements!

n = 1
p = 1
getelementspecialnext:
i = INSTR(p, a$, sp)

'avoid sp inside "..."
i2 = INSTR(p, a$, chr$(34))
if i2<i and i2<>0 then
i3 = INSTR(i2+1, a$, chr$(34)): if i3=0 then qb64error "Expected "+chr$(34)
i=INSTR(i3, a$, sp)
end if

IF elenum = n THEN
IF i THEN
getelementspecial$ = MID$(a$, p, i - p)
ELSE
getelementspecial$ = RIGHT$(a$, LEN(a$) - p + 1)
END IF
EXIT FUNCTION
END IF

IF i = 0 THEN EXIT FUNCTION 'no more elements!
n = n + 1
p = i + 1
GOTO getelementspecialnext
END FUNCTION



FUNCTION getelement$ (a$, elenum)
IF a$ = "" THEN EXIT FUNCTION 'no elements!

n = 1
p = 1
getelementnext:
i = INSTR(p, a$, sp)

IF elenum = n THEN
IF i THEN
getelement$ = MID$(a$, p, i - p)
ELSE
getelement$ = RIGHT$(a$, LEN(a$) - p + 1)
END IF
EXIT FUNCTION
END IF

IF i = 0 THEN EXIT FUNCTION 'no more elements!
n = n + 1
p = i + 1
GOTO getelementnext
END FUNCTION

FUNCTION getelements$ (a$, i1, i2)
IF i2 < i1 THEN getelements$ = "": EXIT FUNCTION
n = 1
p = 1
getelementsnext:
i = INSTR(p, a$, sp)
IF n = i1 THEN
i1pos = p
END IF
IF n = i2 THEN
IF i THEN
getelements$ = MID$(a$, i1pos, i - i1pos)
ELSE
getelements$ = RIGHT$(a$, LEN(a$) - i1pos + 1)
END IF
EXIT FUNCTION
END IF
n = n + 1
p = i + 1
GOTO getelementsnext
END FUNCTION

SUB getid (i AS LONG)
IF i = -1 THEN nerror (82)

id=ids(i)

currentid=i
END SUB

SUB insertelements (a$, i, elements$)
IF i = 0 THEN
 IF a$ = "" THEN
  a$ = elements$
  EXIT SUB
 END IF
 a$ = elements$ + sp + a$
 EXIT SUB
END IF

a2$ = ""
n = numelements(a$)




FOR i2 = 1 TO n
 IF i2 > 1 THEN a2$ = a2$ + sp
 a2$ = a2$ + getelement$(a$, i2)
 IF i = i2 THEN a2$ = a2$ + sp + elements$
NEXT

a$ = a2$

END SUB

FUNCTION isnumber (a$)
IF LEN(a$) = 0 THEN EXIT FUNCTION
FOR i = 1 TO LEN(a$)
a = ASC(MID$(a$, i, 1))
IF a = 45 THEN
IF i <> 1 THEN EXIT FUNCTION
GOTO isnumok
END IF
IF a = 46 THEN
IF dp = 1 THEN EXIT FUNCTION
dp = 1
GOTO isnumok
END IF
IF a >= 48 AND a <= 57 THEN v = 1: GOTO isnumok
EXIT FUNCTION
isnumok:
NEXT
isnumber = 1
END FUNCTION

FUNCTION isoperator (a2$)
a$=ucase$(a2$)
l = 0
l = l + 1: IF a$ = "IMP" THEN GOTO opfound
l = l + 1: IF a$ = "EQV" THEN GOTO opfound
l = l + 1: IF a$ = "XOR" THEN GOTO opfound
l = l + 1: IF a$ = "OR"  THEN GOTO opfound
l = l + 1: IF a$ = "AND" THEN GOTO opfound
l = l + 1: IF a$ = "NOT" THEN GOTO opfound
l = l + 1
IF a$ = "=" THEN GOTO opfound
IF a$ = ">" THEN GOTO opfound
IF a$ = "<" THEN GOTO opfound
IF a$ = "<>" THEN GOTO opfound
IF a$ = "<=" THEN GOTO opfound
IF a$ = ">=" THEN GOTO opfound
l = l + 1
IF a$ = "+" THEN GOTO opfound
IF a$ = "-" THEN GOTO opfound '!CAREFUL! could be negation
l = l + 1: IF a$ = "MOD" THEN GOTO opfound
l = l + 1: IF a$ = "\" THEN GOTO opfound
l = l + 1
IF a$ = "*" THEN GOTO opfound
IF a$ = "/" THEN GOTO opfound
'NEGATION LEVEL (MUST BE SET AFTER CALLING ISOPERATOR BY CONTEXT)
l = l + 1: IF a$ = "" THEN GOTO opfound
l = l + 1: IF a$ = "^" THEN GOTO opfound
EXIT FUNCTION
opfound:
isoperator = l
END FUNCTION

FUNCTION isuinteger (i$)
if len(i$)=0 then exit function
FOR c = 1 TO LEN(i$)
v = ASC(MID$(i$, c, 1))
IF v < 48 THEN EXIT FUNCTION
IF v > 57 THEN EXIT FUNCTION
NEXT
isuinteger = 1
END FUNCTION

FUNCTION isvalidvariable (a$)
FOR i = 1 TO LEN(a$)
c = ASC(a$,i)
t = 0
IF c >= 48 AND c <= 57 THEN t = 1 'numeric
IF c >= 65 AND c <= 90 THEN t = 2 'uppercase
IF c >= 97 AND c <= 122 THEN t = 2 'lowercase
IF c = 95 THEN t = 2 '_ underscore
IF t = 2 OR (t = 1 AND i > 1) THEN
'valid (continue)
ELSE
IF i = 1 THEN isvalidvariable = 0: EXIT FUNCTION
EXIT FOR
END IF
NEXT

isvalidvariable = 1
IF i > n THEN EXIT FUNCTION
e$ = RIGHT$(a$, LEN(a$) - i - 1)
IF e$ = "%%" OR e$ = "~%%" THEN EXIT FUNCTION
IF e$ = "%" OR e$ = "~%" THEN EXIT FUNCTION
IF e$ = "&" OR e$ = "~&" THEN EXIT FUNCTION
IF e$ = "&&" OR e$ = "~&&" THEN EXIT FUNCTION
IF e$ = "!" OR e$ = "#" OR e$ = "##" THEN EXIT FUNCTION
IF e$ = "$" THEN EXIT FUNCTION
IF e$ = "`" THEN EXIT FUNCTION
IF LEFT$(e$, 1) <> "$" AND LEFT$(e$, 1) <> "`" THEN isvalidvariable = 0: EXIT FUNCTION
e$ = RIGHT$(e$, LEN(e$) - 1)
IF isuinteger(e$) THEN isvalidvariable = 1: EXIT FUNCTION
isvalidvariable = 0
END FUNCTION




FUNCTION lineformat$ (a$)
a2$ = ""
linecontinuation=0

continueline:

a$ = a$ + "  " 'add 2 extra spaces to make reading next char easier

ca$ = a$
a$ = UCASE$(a$)

n = LEN(a$)
i = 1
lineformatnext:
IF i >= n THEN GOTO lineformatdone

c = ASC(a$,i)
c$=chr$(c)'***remove later***

'----------------quoted string----------------
IF c = 34 THEN '"
a2$ = a2$ + sp + CHR$(34)
p1=i+1
for i2=i+1 to n-2
c2=asc(a$,i2)

if c2=34 then
a2$=a2$+mid$(ca$,p1,i2-p1+1)+","+str2$(i2-(i+1))
i=i2+1
exit for
end if

if c2=92 then '\
a2$=a2$+mid$(ca$,p1,i2-p1)+"\\"
p1=i2+1
end if

if c2<32 or c2>126 then
o$ = OCT$(c2)
IF LEN(o$) < 3 THEN
o$ = "0" + o$
	IF LEN(o$) < 3 THEN o$ = "0" + o$
end if
a2$=a2$+mid$(ca$,p1,i2-p1)+"\"+o$
p1=i2+1
end if

next

if i2=n-1 then 'no closing "
a2$=a2$+mid$(ca$,p1,(n-2)-p1+1)+chr$(34)+","+str2$((n-2)-(i+1)+1)
i=n-1
end if

GOTO lineformatnext

END IF

'----------------number----------------
firsti=i
IF c = 46 THEN
c2$ = MID$(a$, i + 1, 1): c2 = ASC(c2$)
IF (c2 >= 48 AND c2 <= 57) THEN GOTO lfnumber
END IF
IF (c >= 48 AND c <= 57) THEN '0-9
lfnumber:

'handle 'IF a=1 THEN a=2 ELSE 100' by assuming numeric after ELSE to be a 
if right$(a2$,5)=sp+"ELSE" then
a2$=a2$+sp+"GOTO"
end if

'Number will be converted to the following format:
' 999999  .        99999  E        +         999
'[whole$][dp(0/1)][frac$][ed(1/2)][pm(1/-1)][ex$]
' 0                1               2         3    <-mode

mode = 0
whole$ = ""
dp = 0
frac$ = ""
ed = 0 'E=1, D=2, F=3
pm = 1
ex$ = ""




lfreadnumber:
valid = 0

IF c = 46 THEN
IF mode = 0 THEN valid = 1: dp = 1: mode = 1
END IF

IF c >= 48 AND c <= 57 THEN '0-9
valid = 1
IF mode = 0 THEN whole$ = whole$ + c$
IF mode = 1 THEN frac$ = frac$ + c$
IF mode = 2 THEN mode = 3
IF mode = 3 THEN ex$ = ex$ + c$
END IF

IF c = 69 OR c = 68 or c=70 THEN 'E,D,F
IF mode < 2 THEN
valid = 1
IF c = 69 THEN ed = 1
IF c = 68 THEN ed = 2
IF c = 70 THEN ed = 3
mode = 2
END IF
END IF

IF c = 43 OR c = 45 THEN '+,-
IF mode = 2 THEN
valid = 1
IF c = 45 THEN pm = -1
mode = 3
END IF
END IF

IF valid THEN
IF i <= n THEN i = i + 1: c$ = MID$(a$, i, 1): c = ASC(c$): GOTO lfreadnumber
END IF



'cull leading 0s off whole$
DO WHILE LEFT$(whole$, 1) = "0": whole$ = RIGHT$(whole$, LEN(whole$) - 1): LOOP
'cull trailing 0s off frac$
DO WHILE RIGHT$(frac$, 1) = "0": frac$ = LEFT$(frac$, LEN(frac$) - 1): LOOP
'cull leading 0s off ex$
DO WHILE LEFT$(ex$, 1) = "0": ex$ = RIGHT$(ex$, LEN(ex$) - 1): LOOP

IF dp <> 0 or ed<>0 THEN float = 1 ELSE float = 0

extused=1

IF ed THEN e$ = "": GOTO lffoundext 'no extensions valid after E/D/F specified

'3-character extensions
IF i <= n - 2 THEN
e$ = MID$(a$, i, 3)
IF e$ = "~%%" AND float = 0 THEN i = i + 3: GOTO lffoundext
IF e$ = "~&&" AND float = 0 THEN i = i + 3: GOTO lffoundext
END IF
'2-character extensions
IF i <= n - 1 THEN
e$ = MID$(a$, i, 2)
IF e$ = "%%" AND float = 0 THEN i = i + 2: GOTO lffoundext
IF e$ = "~%" AND float = 0 THEN i = i + 2: GOTO lffoundext
IF e$ = "&&" AND float = 0 THEN i = i + 2: GOTO lffoundext
IF e$ = "~&" AND float = 0 THEN i = i + 2: GOTO lffoundext
IF e$ = "##" THEN
i = i + 2
ed=3
e$=""
GOTO lffoundext
end if
IF e$ = "~`" THEN
i = i + 2
GOTO lffoundbitext
END IF
END IF
'1-character extensions
IF i <= n THEN
e$ = MID$(a$, i, 1)
IF e$ = "%" AND float = 0 THEN i = i + 1: GOTO lffoundext
IF e$ = "&" AND float = 0 THEN i = i + 1: GOTO lffoundext
IF e$ = "!" THEN
i = i + 1
ed=1
e$=""
GOTO lffoundext
end if
IF e$ = "#" THEN
i = i + 1
ed=2
e$=""
GOTO lffoundext
end if
IF e$ = "`" THEN
i = i + 1
lffoundbitext:
bitn$ = ""
DO WHILE i <= n
c2 = ASC(MID$(a$, i, 1))
IF c2 >= 48 AND c2 <= 57 THEN
bitn$ = bitn$ + CHR$(c2)
i = i + 1
ELSE
EXIT DO
END IF
LOOP
IF bitn$ = "" THEN bitn$ = "1"
'cull leading 0s off bitn$
DO WHILE LEFT$(bitn$, 1) = "0": bitn$ = RIGHT$(bitn$, LEN(bitn$) - 1): LOOP
e$ = e$ + bitn$
GOTO lffoundext
END IF
END IF

IF float THEN 'floating point types CAN be assumed
'calculate first significant digit offset & number of significant digits
IF whole$ <> "" THEN
 offset = LEN(whole$) - 1
 sigdigits = LEN(whole$) + LEN(frac$)
ELSE
 IF frac$ <> "" THEN
  offset = -1
  sigdigits = LEN(frac$)
  FOR i2 = 1 TO LEN(frac$)
  IF MID$(frac$, i2, 1) <> "0" THEN EXIT FOR
  offset = offset - 1
  sigdigits = sigdigits - 1
  NEXT
 ELSE
  'number is 0
  offset = 0
  sigdigits = 0
 END IF
END IF
sigdig$ = RIGHT$(whole$ + frac$, sigdigits)
'SINGLE?
IF sigdigits <= 7 THEN 'QBASIC interprets anything with more than 7 sig. digits as a DOUBLE
IF offset <= 38 AND offset >= -38 THEN 'anything outside this range cannot be represented as a SINGLE
IF offset = 38 THEN
IF sigdig$ > "3402823" THEN GOTO lfxsingle
END IF
IF offset = -38 THEN
IF sigdig$ < "1175494" THEN GOTO lfxsingle
END IF
ed=1
e$ = ""
GOTO lffoundext
END IF
END IF
lfxsingle:
'DOUBLE?
IF sigdigits <= 16 THEN 'QB64 handles DOUBLES with 16-digit precision
IF offset <= 308 AND offset >= -308 THEN 'anything outside this range cannot be represented as a DOUBLE
IF offset = 308 THEN
IF sigdig$ > "1797693134862315" THEN GOTO lfxdouble
END IF
IF offset = -308 THEN
IF sigdig$ < "2225073858507201" THEN GOTO lfxdouble
END IF
ed=2
e$ = ""
GOTO lffoundext
END IF
END IF
lfxdouble:
'assume _FLOAT
ed=3
e$ = "": GOTO lffoundext
END IF

extused=0
e$ = ""
lffoundext:

'make sure a leading numberic character exists
IF whole$ = "" THEN whole$ = "0"
'if a float, ensure frac$<>"" and dp=1
if float then
dp=1
IF frac$ = "" then frac$="0"
end if
'if ed is specified, make sure ex$ exists
IF ed <> 0 AND ex$ = "" THEN ex$ = "0"

a2$ = a2$ + sp
a2$ = a2$ + whole$
IF dp THEN a2$ = a2$ + "." + frac$
IF ed THEN
 IF ed = 1 THEN a2$ = a2$ + "E"
 if ed=2 then a2$ = a2$ + "D"
 if ed=3 then a2$ = a2$ + "F"
 IF pm = -1 AND ex$ <> "0" THEN a2$ = a2$ + "-" else a2$ = a2$ + "+"
 a2$ = a2$ + ex$
END IF
a2$ = a2$ + e$

if extused then a2$=a2$+","+mid$(a$,firsti,i-firsti)

GOTO lineformatnext
END IF

'----------------(number)&H...----------------
'note: the final value, not the number of hex characters, sets the default type
IF c = 38 THEN '&
IF MID$(a$, i + 1, 1) = "H" THEN
i = i + 2
hx$ = ""
lfreadhex:
IF i <= n THEN
c$ = MID$(a$, i, 1): c = ASC(c$)
IF (c >= 48 AND c <= 57) OR (c >= 65 AND c <= 70) THEN hx$ = hx$ + c$: i = i + 1: GOTO lfreadhex
END IF
fullhx$="&H"+hx$

'cull leading 0s off hx$
DO WHILE LEFT$(hx$, 1) = "0": hx$ = RIGHT$(hx$, LEN(hx$) - 1): LOOP
IF hx$ = "" THEN hx$ = "0"

bitn$ = ""
'3-character extensions
IF i <= n - 2 THEN
e$ = MID$(a$, i, 3)
IF e$ = "~%%" THEN i = i + 3: GOTO lfhxext
IF e$ = "~&&" THEN i = i + 3: GOTO lfhxext
END IF
'2-character extensions
IF i <= n - 1 THEN
e$ = MID$(a$, i, 2)
IF e$ = "%%" THEN i = i + 2: GOTO lfhxext
IF e$ = "~%" THEN i = i + 2: GOTO lfhxext
IF e$ = "&&" THEN i = i + 2: GOTO lfhxext
IF e$ = "~&" THEN i = i + 2: GOTO lfhxext
IF e$ = "~`" THEN
i = i + 2
GOTO lfhxbitext
END IF
END IF
'1-character extensions
IF i <= n THEN
e$ = MID$(a$, i, 1)
IF e$ = "%" THEN i = i + 1: GOTO lfhxext
IF e$ = "&" THEN i = i + 1: GOTO lfhxext
IF e$ = "`" THEN
i = i + 1
lfhxbitext:
DO WHILE i <= n
c2 = ASC(MID$(a$, i, 1))
IF c2 >= 48 AND c2 <= 57 THEN
bitn$ = bitn$ + CHR$(c2)
i = i + 1
ELSE
EXIT DO
END IF
LOOP
IF bitn$ = "" THEN bitn$ = "1"
'cull leading 0s off bitn$
DO WHILE LEFT$(bitn$, 1) = "0": bitn$ = RIGHT$(bitn$, LEN(bitn$) - 1): LOOP
GOTO lfhxext
END IF
END IF
'if no valid extension context was given, assume one
'note: leading 0s have been culled, so LEN(hx$) reflects its values size
e$ = "&&"
IF LEN(hx$) <= 8 THEN e$ = "&" 'as in QBASIC, signed values must be used
IF LEN(hx$) <= 4 THEN e$ = "%" 'as in QBASIC, signed values must be used
goto lfhxext2
lfhxext:
fullhx$=fullhx$+e$+bitn$
lfhxext2:

'build 8-byte unsigned integer rep. of hx$
IF LEN(hx$) > 16 THEN qb64error "Overflow"
v~&& = 0
FOR i2 = 1 TO LEN(hx$)
v2 = ASC(MID$(hx$, i2, 1))
IF v2 <= 57 THEN v2 = v2 - 48 ELSE v2 = v2 - 65 + 10
v~&& = v~&& * 16 + v2
NEXT

finishhexoctbin:
num$ = str2u64$(v~&&) 'correct for unsigned values (overflow of unsigned can be checked later)
IF LEFT$(e$, 1) <> "~" THEN 'note: range checking will be performed later in fixop.order
'signed

IF e$ = "%%" THEN
IF v~&& > 127 THEN
IF v~&& > 255 THEN qb64error "Overflow"
v~&& = ((NOT v~&&) AND 255) + 1
num$ = "-" + sp + str2$(v~&&)
END IF
END IF

IF e$ = "%" THEN
IF v~&& > 32767 THEN
IF v~&& > 65535 THEN qb64error "Overflow"
v~&& = ((NOT v~&&) AND 65535) + 1
num$ = "-" + sp + str2$(v~&&)
END IF
END IF

IF e$ = "&" THEN
IF v~&& > 2147483647 THEN
IF v~&& > 4294967295 THEN qb64error "Overflow"
v~&& = ((NOT v~&&) AND 4294967295) + 1
num$ = "-" + sp + str2$(v~&&)
END IF
END IF

IF e$ = "&&" THEN
IF v~&& > 9223372036854775807 THEN
'note: no error checking necessary
v~&&= (NOT v~&&) + 1
num$ = "-" + sp + str2$(v~&&)
END IF
END IF

IF e$ = "`" THEN
vbitn = VAL(bitn$)
h~&& = 1: FOR i2 = 1 TO vbitn - 1: h~&& = h~&& * 2: NEXT: h~&& = h~&& - 1 'build h~&&
IF v~&& > h~&& THEN
h~&& = 1: FOR i2 = 1 TO vbitn: h~&& = h~&& * 2: NEXT: h~&& = h~&& - 1 'build h~&&
IF v~&& > h~&& THEN qb64error "Overflow"
v~&& = ((NOT v~&&) AND h~&&) + 1
num$ = "-" + sp + str2$(v~&&)
END IF
END IF

END IF '<>"~"

a2$ = a2$ + sp + num$ + e$ + bitn$+","+fullhx$

GOTO lineformatnext
END IF
END IF

'----------------(number)&O...----------------
'note: the final value, not the number of oct characters, sets the default type
IF c = 38 THEN '&
IF MID$(a$, i + 1, 1) = "O" THEN
i = i + 2
'note: to avoid mistakes, hx$ is used instead of 'ot$'
hx$ = ""
lfreadoct:
IF i <= n THEN
c$ = MID$(a$, i, 1): c = ASC(c$)
IF c >= 48 AND c <= 55 THEN hx$ = hx$ + c$: i = i + 1: GOTO lfreadoct
END IF
fullhx$="&O"+hx$

'cull leading 0s off hx$
DO WHILE LEFT$(hx$, 1) = "0": hx$ = RIGHT$(hx$, LEN(hx$) - 1): LOOP
IF hx$ = "" THEN hx$ = "0"

bitn$ = ""
'3-character extensions
IF i <= n - 2 THEN
e$ = MID$(a$, i, 3)
IF e$ = "~%%" THEN i = i + 3: GOTO lfotext
IF e$ = "~&&" THEN i = i + 3: GOTO lfotext
END IF
'2-character extensions
IF i <= n - 1 THEN
e$ = MID$(a$, i, 2)
IF e$ = "%%" THEN i = i + 2: GOTO lfotext
IF e$ = "~%" THEN i = i + 2: GOTO lfotext
IF e$ = "&&" THEN i = i + 2: GOTO lfotext
IF e$ = "~&" THEN i = i + 2: GOTO lfotext
IF e$ = "~`" THEN
i = i + 2
GOTO lfotbitext
END IF
END IF
'1-character extensions
IF i <= n THEN
e$ = MID$(a$, i, 1)
IF e$ = "%" THEN i = i + 1: GOTO lfotext
IF e$ = "&" THEN i = i + 1: GOTO lfotext
IF e$ = "`" THEN
i = i + 1
lfotbitext:
bitn$ = ""
DO WHILE i <= n
c2 = ASC(MID$(a$, i, 1))
IF c2 >= 48 AND c2 <= 57 THEN
bitn$ = bitn$ + CHR$(c2)
i = i + 1
ELSE
EXIT DO
END IF
LOOP
IF bitn$ = "" THEN bitn$ = "1"
'cull leading 0s off bitn$
DO WHILE LEFT$(bitn$, 1) = "0": bitn$ = RIGHT$(bitn$, LEN(bitn$) - 1): LOOP
GOTO lfotext
END IF
END IF
'if no valid extension context was given, assume one
'note: leading 0s have been culled, so LEN(hx$) reflects its values size
e$ = "&&"
'37777777777
IF LEN(hx$) <= 11 THEN
IF LEN(hx$) < 11 OR ASC(LEFT$(hx$, 1)) <= 51 THEN e$ = "&"
END IF
'177777
IF LEN(hx$) <= 6 THEN
IF LEN(hx$) < 6 OR LEFT$(hx$, 1) = "1" THEN e$ = "%"
END IF

goto lfotext2
lfotext:
fullhx$=fullhx$+e$+bitn$
lfotext2:

'build 8-byte unsigned integer rep. of hx$
'1777777777777777777777 (22 digits)
IF LEN(hx$) > 22 THEN qb64error "Overflow"
IF LEN(hx$) = 22 THEN
IF LEFT$(hx$, 1) <> "1" THEN qb64error "Overflow"
END IF
'********change v& to v~&&********
v~&& = 0
FOR i2 = 1 TO LEN(hx$)
v2 = ASC(MID$(hx$, i2, 1))
v2 = v2 - 48
v~&& = v~&& * 8 + v2
NEXT

goto finishhexoctbin
END IF
END IF

'----------------(number)&B...----------------
'note: the final value, not the number of bin characters, sets the default type
IF c = 38 THEN '&
IF MID$(a$, i + 1, 1) = "B" THEN
i = i + 2
'note: to avoid mistakes, hx$ is used instead of 'bi$'
hx$ = ""
lfreadbin:
IF i <= n THEN
c$ = MID$(a$, i, 1): c = ASC(c$)
IF c >= 48 AND c <= 49 THEN hx$ = hx$ + c$: i = i + 1: GOTO lfreadbin
END IF
fullhx$="&B"+hx$

'cull leading 0s off hx$
DO WHILE LEFT$(hx$, 1) = "0": hx$ = RIGHT$(hx$, LEN(hx$) - 1): LOOP
IF hx$ = "" THEN hx$ = "0"

bitn$ = ""
'3-character extensions
IF i <= n - 2 THEN
e$ = MID$(a$, i, 3)
IF e$ = "~%%" THEN i = i + 3: GOTO lfbiext
IF e$ = "~&&" THEN i = i + 3: GOTO lfbiext
END IF
'2-character extensions
IF i <= n - 1 THEN
e$ = MID$(a$, i, 2)
IF e$ = "%%" THEN i = i + 2: GOTO lfbiext
IF e$ = "~%" THEN i = i + 2: GOTO lfbiext
IF e$ = "&&" THEN i = i + 2: GOTO lfbiext
IF e$ = "~&" THEN i = i + 2: GOTO lfbiext
IF e$ = "~`" THEN
i = i + 2
GOTO lfbibitext
END IF
END IF
'1-character extensions
IF i <= n THEN
e$ = MID$(a$, i, 1)
IF e$ = "%" THEN i = i + 1: GOTO lfbiext
IF e$ = "&" THEN i = i + 1: GOTO lfbiext
IF e$ = "`" THEN
i = i + 1
lfbibitext:
bitn$ = ""
DO WHILE i <= n
c2 = ASC(MID$(a$, i, 1))
IF c2 >= 48 AND c2 <= 57 THEN
bitn$ = bitn$ + CHR$(c2)
i = i + 1
ELSE
EXIT DO
END IF
LOOP
IF bitn$ = "" THEN bitn$ = "1"
'cull leading 0s off bitn$
DO WHILE LEFT$(bitn$, 1) = "0": bitn$ = RIGHT$(bitn$, LEN(bitn$) - 1): LOOP
GOTO lfbiext
END IF
END IF
'if no valid extension context was given, assume one
'note: leading 0s have been culled, so LEN(hx$) reflects its values size
e$ = "&&"
IF LEN(hx$) <= 32 THEN e$ = "&"
IF LEN(hx$) <= 16 THEN e$ = "%"

goto lfbiext2
lfbiext:
fullhx$=fullhx$+e$+bitn$
lfbiext2:

'build 8-byte unsigned integer rep. of hx$
IF LEN(hx$) > 64 THEN qb64error "Overflow"

v~&& = 0
FOR i2 = 1 TO LEN(hx$)
v2 = ASC(MID$(hx$, i2, 1))
v2 = v2 - 48
v~&& = v~&& * 2 + v2
NEXT

goto finishhexoctbin
END IF
END IF


'----------------(number)&H??? error----------------
IF c = 38 THEN qb64error "Expected &H... or &O..."

'----------------variable/name----------------
'*trailing _ is treated as a seperate line extension*
if (c >= 65 AND c <= 90) or c=95 then 'A-Z(a-z) or _
if c=95 then p2=0 else p2=i
for i2=i+1 to n
c2=asc(a$,i2)
if not alphanumeric(c2) then exit for
if c2<>95 then p2=i2
next
if p2 then 'not just underscores!
'char is from i to p2
n2=p2-i+1
a3$=mid$(a$,i,n2)

'----(variable/name)rem----
IF n2 = 3 THEN
IF a3$ = "REM" THEN
i=i+n2
'note: In QBASIC 'IF cond THEN REM comment' counts as a single line IF statement, however use of ' instead of REM does not
if ucase$(right$(a2$,5))=sp+"THEN" then a2$=a2$+sp+"DATA" 'add stub DATA statement
layoutcomment="REM"
GOTO comment
END IF
END IF

'----(variable/name)data----
IF n2 = 4 THEN
IF a3$ = "DATA" THEN
i=i+n2
scan = 0
speechmarks = 0
commanext = 0
finaldata = 0
e$ = ""
p1=0
p2=0
nextdatachr:
IF i < n THEN
c=asc(a$,i)

IF c = 9 OR c = 32 THEN
IF scan = 0 THEN GOTO skipwhitespace
END IF

IF c = 58 THEN '":"
IF speechmarks = 0 THEN finaldata = 1: GOTO adddata
END IF

IF c = 44 THEN '","
IF speechmarks = 0 THEN
adddata:
a3$=""
if p1 then
for i2=p1 to p2
IF dataoffset THEN a3$=a3$+","+str2$(asc(ca$,i2)) else a3$=str2$(asc(ca$,i2))
dataoffset = dataoffset + 1
next
end if
'assume closing "
if speechmarks then
IF dataoffset THEN a3$=a3$+","+str2$(34) else a3$=str2$(34)
dataoffset = dataoffset + 1
end if
'append comma
IF dataoffset THEN a3$=a3$+",44" ELSE a3$="44"
dataoffset = dataoffset + 1
print #16,a3$;
IF finaldata = 1 THEN GOTO finisheddata
e$ = ""
p1=0
p2=0
speechmarks = 0
scan = 0
commanext = 0
i = i + 1
GOTO nextdatachr
END IF
END IF '","

IF commanext = 1 THEN
IF c <> 32 AND c <> 9 THEN nerror (99)
END IF

IF c = 34 THEN
IF speechmarks = 1 THEN
commanext = 1
speechmarks = 0
END IF
IF scan = 0 THEN speechmarks = 1
END IF

scan = 1

if p1=0 then p1=i:p2=i
IF c<>9 and c<>32 THEN p2=i

skipwhitespace:
i = i + 1: GOTO nextdatachr
END IF 'i<n
finaldata = 1: GOTO adddata
finisheddata:
a2$=a2$+sp+"DATA"
GOTO lineformatnext
END IF
END IF

a2$=a2$+sp+mid$(ca$,i,n2)
i=i+n2

'----(variable/name)extensions----
extcheck:
if n2>40 then qb64error "Identifier longer than 40 character limit"
c3=asc(a$,i)
m=0
if c3=126 then '"~"
e2$ = mid$(a$, i + 1,2)
if e2$ = "&&" THEN e2$="~&&": GOTO lfgetve
if e2$ = "%%" THEN e2$="~%%": GOTO lfgetve
e2$ = chr$(asc(e2$))
if e2$ = "&" THEN e2$="~&": GOTO lfgetve
if e2$ = "%" THEN e2$="~%": GOTO lfgetve
if e2$ = "`" THEN m=1: e2$="~`": GOTO lfgetve
end if
if c3=37 then
c4=asc(a$,i+1)
if c4=37 then e2$="%%": GOTO lfgetve
e2$="%": GOTO lfgetve
end if
if c3=38 then
c4=asc(a$,i+1)
if c4=38 then e2$="&&": GOTO lfgetve
e2$="&": GOTO lfgetve
end if
if c3=33 then e2$="!": GOTO lfgetve
if c3=35 then
c4=asc(a$,i+1)
if c4=35 then e2$="##": GOTO lfgetve
e2$="#": GOTO lfgetve
end if
if c3=36 then m=1: e2$="$": GOTO lfgetve
if c3=96 then m=1: e2$="`": GOTO lfgetve
'(no symbol)

'cater for unusual names/labels (eg a.0b%)
if asc(a$, i)=46 then '"."
c2=asc(a$,i+1)
if c2>=48 and c2<=57 then
'scan until no further alphanumerics
p2=i+1
for i2=i+2 to n
c=asc(a$,i2)
if not alphanumeric(c) then exit for
if c<>95 then p2=i2 'don't including trailing _
next
a2$=a2$+sp+"."+sp+mid$(ca$,i+1,p2-(i+1)+1) 'case sensitive
n2=n2+1+(p2-(i+1)+1)
i=p2+1
goto extcheck 'it may have an extension or be continued with another "."
end if
end if

GOTO lineformatnext

lfgetve:
i = i + LEN(e2$)
a2$ = a2$ + e2$
IF m THEN 'allow digits after symbol
lfgetvd:
IF i < n THEN
c = asc(a$, i)
IF c >= 48 AND c <= 57 THEN a2$ = a2$ + CHR$(c): i = i + 1: GOTO lfgetvd
END IF
END IF'm

GOTO lineformatnext

end if 'p2
end if 'variable/name
'----------------variable/name end----------------

'----------------spacing----------------
IF c = 32 or c=9 THEN i = i + 1: GOTO lineformatnext

'----------------symbols----------------
'--------single characters--------
if lfsinglechar(c) then

if c=60 then '<
c2=asc(a$,i+1)
if c2=61 then a2$ = a2$ + sp + "<=":i = i + 2:GOTO lineformatnext
if c2=62 then a2$ = a2$ + sp + "<>":i = i + 2:GOTO lineformatnext
end if
if c=62 then '>
c2=asc(a$,i+1)
if c2=61 then a2$ = a2$ + sp + ">=":i = i + 2:GOTO lineformatnext
if c2=60 then a2$ = a2$ + sp + "<>":i = i + 2:GOTO lineformatnext '>< to <>
end if
if c=61 then '=
c2=asc(a$,i+1)
if c2=62 then a2$ = a2$ + sp + ">=":i = i + 2:GOTO lineformatnext '=> to >=
if c2=60 then a2$ = a2$ + sp + "<=":i = i + 2:GOTO lineformatnext '=< to <=
end if

if c=36 and len(a2$) then goto badusage '$

a2$ = a2$ + sp + chr$(c)
i = i + 1
GOTO lineformatnext
end if
badusage:

if c<>39 then nerror (100) 'invalid symbol encountered

'----------------comment(')----------------
layoutcomment="'"
i = i + 1
comment:
IF i >= n THEN GOTO lineformatdone2
c$ = RIGHT$(a$, LEN(a$) - i + 1)
cc$ = RIGHT$(ca$, LEN(ca$) - i + 1)
IF LEN(c$) = 0 then GOTO lineformatdone2
layoutcomment$=layoutcomment$+cc$

c$ = LTRIM$(c$)
IF LEN(c$) = 0 then GOTO lineformatdone2
ac=ASC(c$)
if ac<>36 then GOTO lineformatdone2
nocasec$=ltrim$(RIGHT$(ca$, LEN(ca$) - i + 1))
memmode=0
for x=1 to len(c$)
mcnext:
if mid$(c$,x,1)="$" then



'note: $STATICksdcdweh$DYNAMIC is valid!

if mid$(c$,x,7)="$STATIC" then
memmode=1
xx=instr(x+1,c$,"$")
if xx=0 then exit for else
x=xx:goto mcnext
end if

if mid$(c$,x,8)="$DYNAMIC" then
memmode=2
xx=instr(x+1,c$,"$")
if xx=0 then exit for
x=xx:goto mcnext
end if

if mid$(c$,x,8)="$INCLUDE" then
'note: INCLUDE adds the file AFTER the line it is on has been processed
'note: No other metacommands can follow the INCLUDE metacommand!
'skip spaces until :
for xx=x+8 to len(c$)
ac=asc(mid$(c$,xx,1))
if ac=58 then exit for ':
if ac<>32 and ac<>9 then qb64error "Expected $INCLUDE:'filename'"
next
x=xx
'skip spaces until '
for xx=x+1 to len(c$)
ac=asc(mid$(c$,xx,1))
if ac=39 then exit for 'character:'
if ac<>32 and ac<>9 then qb64error "Expected $INCLUDE:'filename'"
next
x=xx
xx=instr(x+1,c$,"'")
if xx=0 then qb64error "Expected $INCLUDE:'filename'"
addmetainclude$=mid$(nocasec$,x+1,xx-x-1)
if addmetainclude$="" then qb64error "Expected $INCLUDE:'filename'"
goto mcfinal
end if

'add more metacommands here

end if '$
next
mcfinal:

if memmode=1 then addmetastatic=1
if memmode=2 then addmetadynamic=1

GOTO lineformatdone2



lineformatdone:

'line continuation?
'note: line continuation in idemode is illegal
IF LEN(a2$) THEN
IF RIGHT$(a2$, 1) = "_" THEN

linecontinuation=1 'avoids auto-format glitches
layout$=""

'remove _ from the end of the building string
IF LEN(a2$) >= 2 THEN
IF RIGHT$(a2$, 2) = sp + "_" THEN a2$ = LEFT$(a2$, LEN(a2$) - 1)
END IF
a2$ = LEFT$(a2$, LEN(a2$) - 1)

if inclevel then
fh=99+inclevel
if eof(fh) then GOTO lineformatdone2
line input #fh,a$
inclinenumber(inclevel)=inclinenumber(inclevel)+1
goto includecont 'note: should not increase linenumber
end if

if idemode then
 idecommand$=chr$(100)
 ignore=ide(0)
 ideerror = 0
 a$=idereturn$
 if a$="" then GOTO lineformatdone2
else
 a$=lineinput3$
 if a$=chr$(13) then GOTO lineformatdone2
end if

linenumber = linenumber + 1

includecont:

contline = 1
GOTO continueline
END IF
END IF

lineformatdone2:
IF LEFT$(a2$, 1) = sp THEN a2$ = RIGHT$(a2$, LEN(a2$) - 1)

'fix for trailing : error
IF RIGHT$(a2$, 1) = ":" THEN a2$ = a2$ + sp + "DATA"

if debug then print #9, "lineformat():return:" + a2$
lineformat$ = a2$

END FUNCTION


SUB makeidrefer (ref$, typ AS LONG)
ref$ = str2$(currentid)
typ = id.t + ISREFERENCE
END SUB

SUB nerror (n AS LONG)
layout$="": layoutok=0 'invalidate layout

if os$="WIN" then OPEN ".\internal\qb64\errormes.txt" FOR INPUT AS #50
if os$="LNX" then OPEN "./internal/qb64/errormes.txt" FOR INPUT AS #50

FOR i = 1 TO n
LINE INPUT #50, a$
NEXT
a$ = RIGHT$(a$, LEN(a$) - INSTR(a$, ","))
qb64error a$
END SUB

FUNCTION numelements (a$)
IF a$ = "" THEN EXIT FUNCTION
n = 1
p = 1
numelementsnext:
i = INSTR(p, a$, sp)
IF i = 0 THEN numelements = n: EXIT FUNCTION
n = n + 1
p = i + 1
GOTO numelementsnext
END FUNCTION

FUNCTION operatorusage (operator$, typ AS LONG, info$, lhs AS LONG, rhs AS LONG, result as long)
lhs = 7: rhs = 7: result=0
'return values
'1 = use info$ as the operator without any other changes
'2 = use the function returned in info$ to apply this operator
'    upon left and right side of equation
'3=  bracket left and right side with negation and change operator to info$
'4=  BINARY NOT l.h.s, then apply operator in info$
'5=  UNARY, bracket up rhs, apply operator info$ to left, rebracket again

'lhs & rhs bit-field values
'1=integeral
'2=floating point
'4=string
'8=bool

'string operator
IF (typ AND ISSTRING) THEN
lhs = 4: rhs = 4
result=4
IF operator$ = "+" THEN info$ = "qbs_add": operatorusage = 2: EXIT FUNCTION
result=8
IF operator$ = "=" THEN info$ = "qbs_equal": operatorusage = 2: EXIT FUNCTION
IF operator$ = "<>" THEN info$ = "qbs_notequal": operatorusage = 2: EXIT FUNCTION
IF operator$ = ">" THEN info$ = "qbs_greaterthan": operatorusage = 2: EXIT FUNCTION
IF operator$ = "<" THEN info$ = "qbs_lessthan": operatorusage = 2: EXIT FUNCTION
IF operator$ = ">=" THEN info$ = "qbs_greaterorequal": operatorusage = 2: EXIT FUNCTION
IF operator$ = "<=" THEN info$ = "qbs_lessorequal": operatorusage = 2: EXIT FUNCTION
if debug then print #9, "INVALID STRING OPERATOR!": END
END IF

'assume numeric operator
lhs = 1 + 2: rhs = 1 + 2
IF operator$ = "^" THEN result=2: info$ = "pow2": operatorusage = 2: EXIT FUNCTION
IF operator$ = "" THEN info$ = "-": operatorusage = 5: EXIT FUNCTION
IF operator$ = "/" THEN
info$ = "/ ": operatorusage = 1
'for / division, either the lhs or the rhs must be a float to make
'c++ return a result in floating point form
IF (typ AND ISFLOAT) THEN
'lhs is a float
lhs = 2
rhs = 1 + 2
ELSE
'lhs isn't a float!
lhs = 1 + 2
rhs = 2
END IF
result=2
EXIT FUNCTION
END IF
IF operator$ = "*" THEN info$ = "*": operatorusage = 1: EXIT FUNCTION
IF operator$ = "+" THEN info$ = "+": operatorusage = 1: EXIT FUNCTION
IF operator$ = "-" THEN info$ = "-": operatorusage = 1: EXIT FUNCTION

result=8
IF operator$ = "=" THEN info$ = "==": operatorusage = 3: EXIT FUNCTION
IF operator$ = ">" THEN info$ = ">": operatorusage = 3: EXIT FUNCTION
IF operator$ = "<" THEN info$ = "<": operatorusage = 3: EXIT FUNCTION
IF operator$ = "<>" THEN info$ = "!=": operatorusage = 3: EXIT FUNCTION
IF operator$ = "<=" THEN info$ = "<=": operatorusage = 3: EXIT FUNCTION
IF operator$ = ">=" THEN info$ = ">=": operatorusage = 3: EXIT FUNCTION

lhs = 1: rhs = 1: result=1
IF operator$ = "MOD" THEN info$ = "%": operatorusage = 1: EXIT FUNCTION
IF operator$ = "\" THEN info$ = "/ ": operatorusage = 1: EXIT FUNCTION
IF operator$ = "IMP" THEN info$ = "|": operatorusage = 4: EXIT FUNCTION
IF operator$ = "EQV" THEN info$ = "^": operatorusage = 4: EXIT FUNCTION
IF operator$ = "XOR" THEN info$ = "^": operatorusage = 1: EXIT FUNCTION
IF operator$ = "OR" THEN info$ = "|": operatorusage = 1: EXIT FUNCTION
IF operator$ = "AND" THEN info$ = "&": operatorusage = 1: EXIT FUNCTION

lhs = 7
IF operator$ = "NOT" THEN info$ = "~": operatorusage = 5: EXIT FUNCTION

if debug then print #9, "INVALID NUMBERIC OPERATOR!": END

END FUNCTION

SUB qb64error (info$)
layout$="": layoutok=0 'invalidate layout

if inclevel>0 then info$=info$+incerror$

if idemode then
ideerrorline=linenumber
idemessage$=info$
error 2 'simulate an error to take advantage of qb64's error jumping
end if

PRINT
PRINT info$
FOR i = 1 TO LEN(linefragment)
IF MID$(linefragment, i, 1) = sp$ THEN MID$(linefragment, i, 1) = " "
NEXT
FOR i = 1 TO LEN(wholeline)
IF MID$(wholeline, i, 1) = sp$ THEN MID$(wholeline, i, 1) = " "
NEXT
PRINT "Caused by (or after):" + linefragment
PRINT "LINE " + str2(linenumber) + ":" + wholeline
END
END SUB

FUNCTION refer$ (a2$, typ AS LONG, method AS LONG)
typbak = typ
'method: 0 return an equation which calculates the value of the "variable"
'        1 return the C name of the variable, typ will be left unchanged

a$ = a2$

'retrieve ID
i = INSTR(a$, "")
IF i THEN
idnumber = VAL(LEFT$(a$, i - 1)): a$ = RIGHT$(a$, LEN(a$) - i)
ELSE
idnumber = VAL(a$)
END IF
getid idnumber

'UDT?
IF typ and ISUDT then
if method=1 then
 n$="UDT_"+rtrim$(id.n)
 if id.t=0 then n$="ARRAY_"+n$
 n$=scope$+n$
 refer$=n$
 EXIT FUNCTION
end if

'print "UDTSUBSTRING[idX|u|e|o]:"+a$

u=VAL(a$)
i = INSTR(a$, ""): a$=right$(a$,len(a$)-i): e=VAL(a$)
i = INSTR(a$, ""): o$=right$(a$,len(a$)-i)
n$="UDT_"+rtrim$(id.n):if id.t=0 then n$="ARRAY_"+n$+"[0]"
if e=0 then qb64error "User defined types in expressions are invalid"
if typ and ISOFFSETINBITS then qb64error "Cannot resolve bit-length variables inside user defined types yet"

if typ and ISSTRING then
 o2$="(((unsigned char*)"+scope$+n$+")+("+o$+"))"
 r$ = "qbs_new_fixed(" + o2$ + "," + str2(udtetypesize(e)) + ",1)"
 typ = STRINGTYPE + ISFIXEDLENGTH 'ISPOINTER retained, it is still a pointer!
else
 typ = typ - ISUDT - ISREFERENCE - ISPOINTER
 IF typ and ISARRAY then typ = typ - ISARRAY
 t$=typ2ctyp$(typ,"")
 o2$="(((char*)"+scope$+n$+")+("+o$+"))"
 r$="*"+"("+t$+"*)"+o2$
end if

'print "REFER:"+r$+","+str2$(typ)
refer$=r$
EXIT FUNCTION
end if


'array?
IF id.arraytype THEN

n$ = RTRIM$(id.callname)
IF method = 1 THEN
refer$ = n$
typ = typbak
EXIT FUNCTION
END IF
typ = typ - ISPOINTER - ISREFERENCE'typ now looks like a regular value

IF (typ AND ISSTRING) THEN
IF (typ AND ISFIXEDLENGTH) THEN
offset$ = "&((unsigned char*)(" + n$ + "[0]))[(" + a$ + ")*" + str2(id.tsize) + "]"
r$ = "qbs_new_fixed(" + offset$ + "," + str2(id.tsize) + ",1)"
ELSE
r$ = "((qbs*)(((uint64*)(" + n$ + "[0]))[" + a$ + "]))"
END IF
stringprocessinghappened = 1
refer$ = r$
EXIT FUNCTION
END IF

IF (typ AND ISOFFSETINBITS) THEN
'IF (typ AND ISUNSIGNED) THEN r$ = "getubits_" ELSE r$ = "getbits_"
'r$ = r$ + str2(typ AND 511) + "("
IF (typ AND ISUNSIGNED) THEN r$ = "getubits" ELSE r$ = "getbits"
r$ = r$ + "(" + str2(typ AND 511) + ","
r$ = r$ + "(unsigned char*)(" + n$ + "[0])" + ","
r$ = r$ + a$ + ")"
refer$ = r$
EXIT FUNCTION
ELSE
t$ = ""
IF (typ AND ISFLOAT) THEN
 IF (typ AND 511) = 32 THEN t$ = "float"
 IF (typ AND 511) = 64 THEN t$ = "double"
 IF (typ AND 511) = 256 THEN t$ = "long double"
ELSE
 IF (typ AND ISUNSIGNED) THEN
 IF (typ AND 511) = 8 THEN t$ = "uint8"
 IF (typ AND 511) = 16 THEN t$ = "uint16"
 IF (typ AND 511) = 32 THEN t$ = "uint32"
 IF (typ AND 511) = 64 THEN t$ = "uint64"
 ELSE
 IF (typ AND 511) = 8 THEN t$ = "int8"
 IF (typ AND 511) = 16 THEN t$ = "int16"
 IF (typ AND 511) = 32 THEN t$ = "int32"
 IF (typ AND 511) = 64 THEN t$ = "int64"
 END IF
END IF
END IF
IF t$ = "" THEN nerror (83)
r$ = "((" + t$ + "*)(" + n$ + "[0]))[" + a$ + "]"
refer$ = r$
EXIT FUNCTION
END IF 'array

'variable?
IF id.t THEN
r$ = RTRIM$(id.n)
t = id.t
'remove irrelavant flags
IF (t AND ISINCONVENTIONALMEMORY) THEN t = t - ISINCONVENTIONALMEMORY
'string?
IF (t AND ISSTRING) THEN
IF (t AND ISFIXEDLENGTH) THEN
r$ = scope$ + "STRING" + str2(id.tsize) + "_" + r$: GOTO ref
END IF
r$ = scope$ + "STRING_" + r$: GOTO ref
END IF
'bit-length single variable?
IF (t AND ISOFFSETINBITS) THEN
IF (t AND ISUNSIGNED) THEN
r$ = "*" + scope$ + "UBIT" + str2(t AND 511) + "_" + r$
ELSE
r$ = "*" + scope$ + "BIT" + str2(t AND 511) + "_" + r$
END IF
GOTO ref
END IF
IF t = BYTETYPE THEN r$ = "*" + scope$ + "BYTE_" + r$: GOTO ref
IF t = UBYTETYPE THEN r$ = "*" + scope$ + "UBYTE_" + r$: GOTO ref
IF t = INTEGERTYPE THEN r$ = "*" + scope$ + "INTEGER_" + r$: GOTO ref
IF t = UINTEGERTYPE THEN r$ = "*" + scope$ + "UINTEGER_" + r$: GOTO ref
IF t = LONGTYPE THEN r$ = "*" + scope$ + "LONG_" + r$: GOTO ref
IF t = ULONGTYPE THEN r$ = "*" + scope$ + "ULONG_" + r$: GOTO ref
IF t = INTEGER64TYPE THEN r$ = "*" + scope$ + "INTEGER64_" + r$: GOTO ref
IF t = UINTEGER64TYPE THEN r$ = "*" + scope$ + "UINTEGER64_" + r$: GOTO ref
IF t = SINGLETYPE THEN r$ = "*" + scope$ + "SINGLE_" + r$: GOTO ref
IF t = DOUBLETYPE THEN r$ = "*" + scope$ + "DOUBLE_" + r$: GOTO ref
IF t = FLOATTYPE THEN r$ = "*" + scope$ + "FLOAT_" + r$: GOTO ref
ref:
IF (t AND ISSTRING) THEN stringprocessinghappened = 1
IF (t AND ISPOINTER) THEN t = t - ISPOINTER
typ = t
IF method = 1 THEN
IF LEFT$(r$, 1) = "*" THEN r$ = RIGHT$(r$, LEN(r$) - 1)
typ = typbak
END IF
refer$ = r$
EXIT FUNCTION
END IF 'variable



END FUNCTION

SUB regid
idn = idn + 1

if idn>ids_max then
ids_max=ids_max*2
redim _preserve ids(1 to ids_max) as idstruct
reDIM _preserve cmemlist(1 to ids_max+1) AS INTEGER
redim _preserve sfcmemargs(1 to ids_max+1) as string * 100
reDIM _preserve arrayelementslist(1 to ids_max+1) AS INTEGER
end if


'register case sensitive name if none given
if asc(id.cn)=32 then
a$=rtrim$(id.n)
id.n=ucase$(a$)
id.cn=a$
end if


id.insubfunc = subfunc

'note: cannot be STATIC and SHARED at the same time
if dimshared then
id.share = dimshared
else
if dimstatic then id.staticscope=1
end if

ids(idn)=id

currentid = idn
END SUB

SUB reginternal

'special codes:

'-1 Any numeric variable (will be made explicit by a C cast)
'   Typically, these are used when multiple C functions exist 

'-2 Offset+Size(in bytes)
'   Size is the largest safe memory block available from the offset
'   used for: CALL INTERRUPT[X]

'-3 Offset+Size(in bytes)
'   Size is the largest safe memory block available from the offset
'   *Like -2, but restrictions apply
'   used for: GET/PUT(graphics)

'-4 Offset+Size(in bytes)
'   Size is the size of the element referenced
'   used for: GET/PUT(file)

'special return codes:
'none


'remote desktop

clearid
id.n = "_SCREENCLICK"
id.subfunc = 2
id.callname = "sub__screenclick"
id.args = 2
id.arg = MKL$(LONGTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER)
regid

clearid
id.n = "_SCREENPRINT"
id.subfunc = 2
id.callname = "sub__screenprint"
id.args = 1
id.arg = MKL$(STRINGTYPE - ISPOINTER)
regid

clearid
id.n = "_SCREENIMAGE"
id.subfunc = 1
id.callname = "func__screenimage"
id.ret = LONGTYPE - ISPOINTER
regid





clearid
id.n = "LOCK"
id.subfunc = 2
id.callname = "sub_lock"
id.args = 3
id.arg = MKL$(LONGTYPE - ISPOINTER) + MKL$(INTEGER64TYPE - ISPOINTER)+ MKL$(INTEGER64TYPE - ISPOINTER)
id.specialformat = "[#]?[,[?][{TO}?]]"
regid

clearid
id.n = "UNLOCK"
id.subfunc = 2
id.callname = "sub_unlock"
id.args = 3
id.arg = MKL$(LONGTYPE - ISPOINTER) + MKL$(INTEGER64TYPE - ISPOINTER)+ MKL$(INTEGER64TYPE - ISPOINTER)
id.specialformat = "[#]?[,[?][{TO}?]]"
regid

clearid
id.n = "_FREETIMER"
id.subfunc = 1
id.callname = "func__freetimer"
id.ret = LONGTYPE - ISPOINTER
regid

clearid
id.n = "TIMER"
id.subfunc = 2
id.callname = "sub_timer"
id.args = 2
id.arg = MKL$(LONGTYPE - ISPOINTER)+MKL$(LONGTYPE - ISPOINTER)
id.specialformat = "[(?)]{ON|OFF|STOP|FREE}"
regid

clearid
id.n = "_FULLSCREEN"
id.subfunc = 2
id.callname = "sub__fullscreen"
id.args = 1
id.arg = MKL$(LONGTYPE - ISPOINTER)
id.specialformat = "[{_OFF|_STRETCH|_SQUAREPIXELS}]"
regid

clearid
id.n = "_FULLSCREEN"
id.subfunc = 1
id.callname = "func__fullscreen"
id.ret = LONGTYPE - ISPOINTER
regid

clearid
id.n = "_CLIPBOARD"
id.musthave = "$"
id.subfunc = 2
id.callname = "sub__clipboard"
id.args = 1
id.arg = MKL$(STRINGTYPE - ISPOINTER)
id.specialformat = "=?"
regid

clearid
id.n = "_CLIPBOARD"
id.musthave = "$"
id.subfunc = 1
id.callname = "func__clipboard"
id.ret = STRINGTYPE - ISPOINTER
regid

clearid
id.n = "_EXIT"
id.subfunc = 1
id.callname = "func__exit"
id.ret = LONGTYPE - ISPOINTER
regid

clearid
id.n = "_OPENHOST"
id.subfunc = 1
id.callname = "func__openhost"
id.args = 1
id.arg = MKL$(STRINGTYPE - ISPOINTER)
id.ret = LONGTYPE - ISPOINTER
regid

clearid
id.n = "_CONNECTED"
id.subfunc = 1
id.callname = "func__connected"
id.args = 1
id.arg = MKL$(LONGTYPE - ISPOINTER)
id.ret = LONGTYPE - ISPOINTER
regid

clearid
id.n = "_CONNECTIONADDRESS"
id.subfunc = 1
id.callname = "func__connectionaddress"
id.args = 1
id.arg = MKL$(LONGTYPE - ISPOINTER)
id.ret = STRINGTYPE - ISPOINTER
regid

clearid
id.n = "_OPENCONNECTION"
id.subfunc = 1
id.callname = "func__openconnection"
id.args = 1
id.arg = MKL$(LONGTYPE - ISPOINTER)
id.ret = LONGTYPE - ISPOINTER
regid

clearid
id.n = "_OPENCLIENT"
id.subfunc = 1
id.callname = "func__openclient"
id.args = 1
id.arg = MKL$(STRINGTYPE - ISPOINTER)
id.ret = LONGTYPE - ISPOINTER
regid


clearid
id.n = "ENVIRON"
id.musthave = "$"
id.subfunc = 1
id.callname = "func_environ"
id.args = 1
id.arg = MKL$(LONGTYPE - ISPOINTER)
id.ret = STRINGTYPE - ISPOINTER
regid

clearid
id.n = "ENVIRON"
id.subfunc = 2
id.callname = "sub_environ"
id.args = 1
id.arg = MKL$(STRINGTYPE - ISPOINTER)
regid

clearid
id.n = "_ERRORLINE"
id.subfunc = 1
id.callname = "func__errorline"
id.ret = LONGTYPE - ISPOINTER
regid

clearid
id.n = "_DISPLAY"
id.subfunc = 2
id.callname = "sub__display"
regid

clearid
id.n = "_AUTODISPLAY"
id.subfunc = 2
id.callname = "sub__autodisplay"
regid


clearid
id.n = "_LIMIT"
id.subfunc = 2
id.callname = "sub__limit"
id.args = 1
id.arg = MKL$(DOUBLETYPE - ISPOINTER)
regid

clearid
id.n = "_DELAY"
id.subfunc = 2
id.callname = "sub__delay"
id.args = 1
id.arg = MKL$(DOUBLETYPE - ISPOINTER)
regid

clearid
id.n = "_ICON"
id.subfunc = 2
id.callname = "sub__icon"
id.args = 1
id.arg = MKL$(LONGTYPE - ISPOINTER)
regid

clearid
id.n = "_TITLE"
id.subfunc = 2
id.callname = "sub__title"
id.args = 1
id.arg = MKL$(STRINGTYPE - ISPOINTER)
regid

clearid
id.n = "CLEAR"
id.subfunc = 2
id.callname = "sub_clear"
id.args = 1
id.arg = MKL$(LONGTYPE - ISPOINTER)
id.specialformat = "[,,?]"
regid

'2D PROTOTYPE 1.0

'IMAGE CREATION/FREEING

clearid
id.n = "_NEWIMAGE"
id.subfunc = 1
id.callname = "func__newimage"
id.args = 3
id.arg = MKL$(LONGTYPE - ISPOINTER)+MKL$(LONGTYPE - ISPOINTER)+MKL$(LONGTYPE - ISPOINTER)
id.specialformat = "?,?[,?]"
id.ret = LONGTYPE - ISPOINTER
regid

clearid
id.n = "_LOADIMAGE"
id.subfunc = 1
id.callname = "func__loadimage"
id.args = 2
id.arg = MKL$(STRINGTYPE - ISPOINTER)+MKL$(LONGTYPE - ISPOINTER)
id.specialformat = "?[,?]"
id.ret = LONGTYPE - ISPOINTER
regid

clearid
id.n = "_FREEIMAGE"
id.subfunc = 2
id.callname = "sub__freeimage"
id.args = 1
id.arg = MKL$(LONGTYPE - ISPOINTER)
id.specialformat = "[?]"
regid

clearid
id.n = "_COPYIMAGE"
id.subfunc = 1
id.callname = "func__copyimage"
id.args = 1
id.arg = MKL$(LONGTYPE - ISPOINTER)
id.specialformat = "[?]"
id.ret = LONGTYPE - ISPOINTER
regid

'IMAGE SELECTION

clearid
id.n = "_SOURCE"
id.subfunc = 2
id.callname = "sub__source"
id.args = 1
id.arg = MKL$(LONGTYPE - ISPOINTER)
id.specialformat = "?"
regid

clearid
id.n = "_DEST"
id.subfunc = 2
id.callname = "sub__dest"
id.args = 1
id.arg = MKL$(LONGTYPE - ISPOINTER)
id.specialformat = "?"
regid

clearid
id.n = "_SOURCE"
id.subfunc = 1
id.callname = "func__source"
id.ret = LONGTYPE - ISPOINTER
regid

clearid
id.n = "_DEST"
id.subfunc = 1
id.callname = "func__dest"
id.ret = LONGTYPE - ISPOINTER
regid

clearid
id.n = "_DISPLAY"
id.subfunc = 1
id.callname = "func__display"
id.ret = LONGTYPE - ISPOINTER
regid

'IMAGE SETTINGS

clearid
id.n = "_BLEND"
id.subfunc = 2
id.callname = "sub__blend"
id.args = 1
id.arg = MKL$(LONGTYPE - ISPOINTER)
id.specialformat = "[?]"
regid

clearid
id.n = "_DONTBLEND"
id.subfunc = 2
id.callname = "sub__dontblend"
id.args = 1
id.arg = MKL$(LONGTYPE - ISPOINTER)
id.specialformat = "[?]"
regid

clearid
id.n = "_CLEARCOLOR"
id.subfunc = 2
id.callname = "sub__clearcolor"
id.args = 3
id.arg = MKL$(LONGTYPE - ISPOINTER)+MKL$(ULONGTYPE - ISPOINTER)+MKL$(LONGTYPE - ISPOINTER)
id.specialformat = "[{_NONE}][?][,?]"
regid

'USING/CHANGING A SURFACE

clearid
id.n = "_PUTIMAGE"
id.subfunc = 2
id.callname = "sub__putimage"
id.args = 14
id.arg = MKL$(LONGTYPE - ISPOINTER)+MKL$(DOUBLETYPE - ISPOINTER)+MKL$(DOUBLETYPE - ISPOINTER)+MKL$(LONGTYPE - ISPOINTER)+MKL$(DOUBLETYPE - ISPOINTER)+MKL$(DOUBLETYPE - ISPOINTER)+MKL$(LONGTYPE - ISPOINTER)+MKL$(LONGTYPE - ISPOINTER)+MKL$(LONGTYPE - ISPOINTER)+MKL$(DOUBLETYPE - ISPOINTER)+MKL$(DOUBLETYPE - ISPOINTER)+MKL$(LONGTYPE - ISPOINTER)+MKL$(DOUBLETYPE - ISPOINTER)+MKL$(DOUBLETYPE - ISPOINTER)
id.specialformat = "[[{STEP}](?,?)[-[{STEP}](?,?)]][,[?][,[?][,[[{STEP}](?,?)[-[{STEP}](?,?)]]]]]"
regid

clearid
id.n = "_SETALPHA"
id.subfunc = 2
id.callname = "sub__setalpha"
id.args = 4
id.arg = MKL$(ULONGTYPE - ISPOINTER)+MKL$(ULONGTYPE - ISPOINTER)+MKL$(ULONGTYPE - ISPOINTER)+MKL$(LONGTYPE - ISPOINTER)
id.specialformat = "?[,[?[{TO}?]][,?]]"
regid

'IMAGE INFO

clearid
id.n = "_WIDTH"
id.subfunc = 1
id.callname = "func__width"
id.args = 1
id.arg = MKL$(LONGTYPE - ISPOINTER)
id.specialformat = "[?]"
id.ret = LONGTYPE - ISPOINTER
regid

clearid
id.n = "_HEIGHT"
id.subfunc = 1
id.callname = "func__height"
id.args = 1
id.arg = MKL$(LONGTYPE - ISPOINTER)
id.specialformat = "[?]"
id.ret = LONGTYPE - ISPOINTER
regid

clearid
id.n = "_PIXELSIZE"
id.subfunc = 1
id.callname = "func__pixelsize"
id.args = 1
id.arg = MKL$(LONGTYPE - ISPOINTER)
id.specialformat = "[?]"
id.ret = LONGTYPE - ISPOINTER
regid

clearid
id.n = "_CLEARCOLOR"
id.subfunc = 1
id.callname = "func__clearcolor"
id.args = 1
id.arg = MKL$(LONGTYPE - ISPOINTER)
id.specialformat = "[?]"
id.ret = LONGTYPE - ISPOINTER
regid

clearid
id.n = "_BLEND"
id.subfunc = 1
id.callname = "func__blend"
id.args = 1
id.arg = MKL$(LONGTYPE - ISPOINTER)
id.specialformat = "[?]"
id.ret = LONGTYPE - ISPOINTER
regid

clearid
id.n = "_DEFAULTCOLOR"
id.subfunc = 1
id.callname = "func__defaultcolor"
id.args = 1
id.arg = MKL$(LONGTYPE - ISPOINTER)
id.specialformat = "[?]"
id.ret = ULONGTYPE - ISPOINTER
regid

clearid
id.n = "_BACKGROUNDCOLOR"
id.subfunc = 1
id.callname = "func__backgroundcolor"
id.args = 1
id.arg = MKL$(LONGTYPE - ISPOINTER)
id.specialformat = "[?]"
id.ret = ULONGTYPE - ISPOINTER
regid

'256 COLOR PALETTES

clearid
id.n = "_PALETTECOLOR"
id.subfunc = 1
id.callname = "func__palettecolor"
id.args = 2
id.arg = MKL$(LONGTYPE - ISPOINTER)+MKL$(LONGTYPE - ISPOINTER)
id.specialformat = "?[,?]"
id.ret = LONGTYPE - ISPOINTER
regid

clearid
id.n = "_PALETTECOLOR"
id.subfunc = 2
id.callname = "sub__palettecolor"
id.args = 3
id.arg = MKL$(LONGTYPE - ISPOINTER)+MKL$(ULONGTYPE - ISPOINTER)+MKL$(LONGTYPE - ISPOINTER)
id.specialformat = "?,?[,?]"
regid

clearid
id.n = "_COPYPALETTE"
id.subfunc = 2
id.callname = "sub__copypalette"
id.args = 2
id.arg = MKL$(LONGTYPE - ISPOINTER)+MKL$(LONGTYPE - ISPOINTER)
id.specialformat = "[?][,?]"
regid

'FONT SUPPORT

clearid
id.n = "_LOADFONT"
id.subfunc = 1
id.callname = "func__loadfont"
id.args = 3
id.arg = MKL$(STRINGTYPE - ISPOINTER)+MKL$(DOUBLETYPE - ISPOINTER)+MKL$(STRINGTYPE - ISPOINTER)
id.specialformat = "?,?[,?]"
id.ret = LONGTYPE - ISPOINTER
regid

clearid
id.n = "_FONT"
id.subfunc = 2
id.callname = "sub__font"
id.args = 2
id.arg = MKL$(LONGTYPE - ISPOINTER)+MKL$(LONGTYPE - ISPOINTER)
id.specialformat = "?[,?]"
regid

clearid
id.n = "_FONTWIDTH"
id.subfunc = 1
id.callname = "func__fontwidth"
id.args = 1
id.arg = MKL$(LONGTYPE - ISPOINTER)
id.specialformat = "[?]"
id.ret = LONGTYPE - ISPOINTER
regid

clearid
id.n = "_FONTHEIGHT"
id.subfunc = 1
id.callname = "func__fontheight"
id.args = 1
id.arg = MKL$(LONGTYPE - ISPOINTER)
id.specialformat = "[?]"
id.ret = LONGTYPE - ISPOINTER
regid

clearid
id.n = "_FONT"
id.subfunc = 1
id.callname = "func__font"
id.args = 1
id.arg = MKL$(LONGTYPE - ISPOINTER)
id.specialformat = "[?]"
id.ret = LONGTYPE - ISPOINTER
regid

clearid
id.n = "_PRINTSTRING"
id.subfunc = 2
id.callname = "sub__printstring"
id.args = 5
id.arg = MKL$(LONGTYPE - ISPOINTER)+MKL$(DOUBLETYPE - ISPOINTER)+MKL$(DOUBLETYPE - ISPOINTER)+MKL$(STRINGTYPE - ISPOINTER)+MKL$(LONGTYPE - ISPOINTER)
id.specialformat = "[{STEP}](?,?),?[,?]"
regid

clearid
id.n = "_PRINTWIDTH"
id.subfunc = 1
id.callname = "func__printwidth"
id.args = 2
id.arg = MKL$(STRINGTYPE - ISPOINTER)+MKL$(LONGTYPE - ISPOINTER)
id.specialformat = "?[,?]"
id.ret = LONGTYPE - ISPOINTER
regid

clearid
id.n = "_FREEFONT"
id.subfunc = 2
id.callname = "sub__freefont"
id.args = 1
id.arg = MKL$(LONGTYPE - ISPOINTER)
id.specialformat = "?"
regid

clearid
id.n = "_PRINTMODE"
id.subfunc = 2
id.callname = "sub__printmode"
id.args = 2
id.arg = MKL$(LONGTYPE - ISPOINTER)+MKL$(LONGTYPE - ISPOINTER)
id.specialformat = "{_FILLBACKGROUND|_KEEPBACKGROUND|_ONLYBACKGROUND}[,?]"
regid

clearid
id.n = "_PRINTMODE"
id.subfunc = 1
id.callname = "func__printmode"
id.args = 1
id.arg = MKL$(LONGTYPE - ISPOINTER)
id.specialformat = "[?]"
id.ret = LONGTYPE - ISPOINTER
regid

'WORKING WITH COLORS

clearid
id.n = "_RGBA"
id.subfunc = 1
id.callname = "func__rgba"
id.args = 5
id.arg = MKL$(LONGTYPE - ISPOINTER)+MKL$(LONGTYPE - ISPOINTER)+MKL$(LONGTYPE - ISPOINTER)+MKL$(LONGTYPE - ISPOINTER)+MKL$(LONGTYPE - ISPOINTER)
id.specialformat = "?,?,?,?[,?]"
id.ret = ULONGTYPE - ISPOINTER
regid

clearid
id.n = "_RGB"
id.subfunc = 1
id.callname = "func__rgb"
id.args = 4
id.arg = MKL$(LONGTYPE - ISPOINTER)+MKL$(LONGTYPE - ISPOINTER)+MKL$(LONGTYPE - ISPOINTER)+MKL$(LONGTYPE - ISPOINTER)
id.specialformat = "?,?,?[,?]"
id.ret = ULONGTYPE - ISPOINTER
regid

clearid
id.n = "_RED"
id.subfunc = 1
id.callname = "func__red"
id.args = 2
id.arg = MKL$(ULONGTYPE - ISPOINTER)+MKL$(ULONGTYPE - ISPOINTER)
id.specialformat = "?[,?]"
id.ret = LONGTYPE - ISPOINTER
regid

clearid
id.n = "_GREEN"
id.subfunc = 1
id.callname = "func__green"
id.args = 2
id.arg = MKL$(ULONGTYPE - ISPOINTER)+MKL$(ULONGTYPE - ISPOINTER)
id.specialformat = "?[,?]"
id.ret = LONGTYPE - ISPOINTER
regid

clearid
id.n = "_BLUE"
id.subfunc = 1
id.callname = "func__blue"
id.args = 2
id.arg = MKL$(ULONGTYPE - ISPOINTER)+MKL$(ULONGTYPE - ISPOINTER)
id.specialformat = "?[,?]"
id.ret = LONGTYPE - ISPOINTER
regid

clearid
id.n = "_ALPHA"
id.subfunc = 1
id.callname = "func__alpha"
id.args = 2
id.arg = MKL$(ULONGTYPE - ISPOINTER)+MKL$(ULONGTYPE - ISPOINTER)
id.specialformat = "?[,?]"
id.ret = LONGTYPE - ISPOINTER
regid

clearid
id.n = "_RGBA32"
id.subfunc = 1
id.callname = "func__rgba32"
id.args = 4
id.arg = MKL$(LONGTYPE - ISPOINTER)+MKL$(LONGTYPE - ISPOINTER)+MKL$(LONGTYPE - ISPOINTER)+MKL$(LONGTYPE - ISPOINTER)
id.ret = ULONGTYPE - ISPOINTER
regid

clearid
id.n = "_RGB32"
id.subfunc = 1
id.callname = "func__rgb32"
id.args = 3
id.arg = MKL$(LONGTYPE - ISPOINTER)+MKL$(LONGTYPE - ISPOINTER)+MKL$(LONGTYPE - ISPOINTER)
id.ret = ULONGTYPE - ISPOINTER
regid

clearid
id.n = "_RED32"
id.subfunc = 1
id.callname = "func__red32"
id.args = 1
id.arg = MKL$(ULONGTYPE - ISPOINTER)
id.ret = LONGTYPE - ISPOINTER
regid

clearid
id.n = "_GREEN32"
id.subfunc = 1
id.callname = "func__green32"
id.args = 1
id.arg = MKL$(ULONGTYPE - ISPOINTER)
id.ret = LONGTYPE - ISPOINTER
regid

clearid
id.n = "_BLUE32"
id.subfunc = 1
id.callname = "func__blue32"
id.args = 1
id.arg = MKL$(ULONGTYPE - ISPOINTER)
id.ret = LONGTYPE - ISPOINTER
regid

clearid
id.n = "_ALPHA32"
id.subfunc = 1
id.callname = "func__alpha32"
id.args = 1
id.arg = MKL$(ULONGTYPE - ISPOINTER)
id.ret = LONGTYPE - ISPOINTER
regid


clearid
id.n = "DRAW"
id.subfunc = 2
id.callname = "sub_draw"
id.args = 1
id.arg = MKL$(STRINGTYPE - ISPOINTER)
regid

clearid
id.n = "PLAY"
id.subfunc = 2
id.callname = "sub_play"
id.args = 1
id.arg = MKL$(STRINGTYPE - ISPOINTER)
regid

'QB64 MOUSE
clearid
id.n = "_MOUSESHOW"
id.subfunc = 2
id.callname = "sub__mouseshow"
regid

clearid
id.n = "_MOUSEHIDE"
id.subfunc = 2
id.callname = "sub__mousehide"
regid

clearid
id.n = "_MOUSEINPUT"
id.subfunc = 1
id.callname = "func__mouseinput"
id.ret = LONGTYPE - ISPOINTER
regid

clearid
id.n = "_MOUSEX"
id.subfunc = 1
id.callname = "func__mousex"
id.ret = SINGLETYPE - ISPOINTER
regid

clearid
id.n = "_MOUSEY"
id.subfunc = 1
id.callname = "func__mousey"
id.ret = SINGLETYPE - ISPOINTER
regid

clearid
id.n = "_MOUSEBUTTON"
id.subfunc = 1
id.callname = "func__mousebutton"
id.args = 1
id.arg = MKL$(LONGTYPE - ISPOINTER)
id.ret = LONGTYPE - ISPOINTER
regid

clearid
id.n = "_MOUSEWHEEL"
id.subfunc = 1
id.callname = "func__mousewheel"
id.ret = LONGTYPE - ISPOINTER
regid

clearid
id.n = "FREEFILE"
id.subfunc = 1
id.callname = "func_freefile"
id.ret = LONGTYPE - ISPOINTER
regid

clearid
id.n = "NAME"
id.subfunc = 2
id.callname = "sub_name"
id.args = 2
id.arg = MKL$(STRINGTYPE - ISPOINTER) + MKL$(STRINGTYPE - ISPOINTER)
id.specialformat = "?{AS}?"
regid

clearid
id.n = "KILL"
id.subfunc = 2
id.callname = "sub_kill"
id.args = 1
id.arg = MKL$(STRINGTYPE - ISPOINTER)
regid

clearid
id.n = "CHDIR"
id.subfunc = 2
id.callname = "sub_chdir"
id.args = 1
id.arg = MKL$(STRINGTYPE - ISPOINTER)
regid

clearid
id.n = "MKDIR"
id.subfunc = 2
id.callname = "sub_mkdir"
id.args = 1
id.arg = MKL$(STRINGTYPE - ISPOINTER)
regid

clearid
id.n = "RMDIR"
id.subfunc = 2
id.callname = "sub_rmdir"
id.args = 1
id.arg = MKL$(STRINGTYPE - ISPOINTER)
regid

clearid
id.n = "CHAIN"
id.subfunc = 2
id.callname = "sub_chain"
id.args = 1
id.arg = MKL$(STRINGTYPE - ISPOINTER)
regid

clearid
id.n = "SHELL"
id.subfunc = 2
id.callname = "sub_shell"
id.args = 1
id.arg = MKL$(STRINGTYPE - ISPOINTER)
id.specialformat = "[?]"
'id.secondargcantbe = "_HIDE"
regid

clearid
id.n = "SHELL"
id.subfunc = 2
id.callname = "sub_shell2"
id.args = 1
id.arg = MKL$(STRINGTYPE - ISPOINTER)
id.specialformat = "{_HIDE}?"
id.secondargmustbe = "_HIDE"
regid

clearid
id.n = "SHELL"
id.subfunc = 2
id.callname = "sub_shell3"
id.args = 1
id.arg = MKL$(STRINGTYPE - ISPOINTER)
id.specialformat = "{_DONTWAIT}?"
id.secondargmustbe = "_DONTWAIT"
regid

clearid
id.n = "COMMAND"
id.musthave = "$"
id.subfunc = 1
id.callname = "func_command"
id.args = 0
id.ret = STRINGTYPE - ISPOINTER
regid

'QB64 AUDIO
clearid
id.n = "_SNDLEN"
id.subfunc = 1
id.callname = "func__sndlen"
id.args = 1
id.arg = MKL$(ULONGTYPE - ISPOINTER)
id.ret = SINGLETYPE - ISPOINTER
regid

clearid
id.n = "_SNDPAUSED"
id.subfunc = 1
id.callname = "func__sndpaused"
id.args = 1
id.arg = MKL$(ULONGTYPE - ISPOINTER)
id.ret = LONGTYPE - ISPOINTER
regid

clearid
id.n = "_SNDPLAYFILE"
id.subfunc = 2
id.callname = "sub__sndplayfile"
id.args = 3
id.arg = MKL$(STRINGTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER) + MKL$(FLOATTYPE - ISPOINTER)
id.specialformat = "?[,[?][,?]]"
regid

clearid
id.n = "_SNDPLAYCOPY"
id.subfunc = 2
id.callname = "sub__sndplaycopy"
id.args = 2
id.arg = MKL$(ULONGTYPE - ISPOINTER) + MKL$(FLOATTYPE - ISPOINTER)
id.specialformat = "?[,?]"
regid

clearid
id.n = "_SNDSTOP"
id.subfunc = 2
id.callname = "sub__sndstop"
id.args = 1
id.arg = MKL$(ULONGTYPE - ISPOINTER)
regid

clearid
id.n = "_SNDLOOP"
id.subfunc = 2
id.callname = "sub__sndloop"
id.args = 1
id.arg = MKL$(ULONGTYPE - ISPOINTER)
regid

clearid
id.n = "_SNDLIMIT"
id.subfunc = 2
id.callname = "sub__sndlimit"
id.args = 2
id.arg = MKL$(ULONGTYPE - ISPOINTER) + MKL$(FLOATTYPE - ISPOINTER)
regid

clearid
id.n = "_SNDOPEN"
id.subfunc = 1
id.callname = "func__sndopen"
id.args = 2
id.arg = MKL$(STRINGTYPE - ISPOINTER) + MKL$(STRINGTYPE - ISPOINTER)
id.specialformat = "?[,?]"
id.ret = ULONGTYPE - ISPOINTER
regid

clearid
id.n = "_SNDSETPOS"
id.subfunc = 2
id.callname = "sub__sndsetpos"
id.args = 2
id.arg = MKL$(ULONGTYPE - ISPOINTER) + MKL$(DOUBLETYPE - ISPOINTER)
regid

clearid
id.n = "_SNDGETPOS"
id.subfunc = 1
id.callname = "func__sndgetpos"
id.args = 1
id.arg = MKL$(ULONGTYPE - ISPOINTER)
id.ret = SINGLETYPE - ISPOINTER
regid

clearid
id.n = "_SNDPLAYING"
id.subfunc = 1
id.callname = "func__sndplaying"
id.args = 1
id.arg = MKL$(ULONGTYPE - ISPOINTER)
id.ret = LONGTYPE - ISPOINTER
regid

clearid
id.n = "_SNDPAUSE"
id.subfunc = 2
id.callname = "sub__sndpause"
id.args = 1
id.arg = MKL$(ULONGTYPE - ISPOINTER)
regid

clearid
id.n = "_SNDBAL"
id.subfunc = 2
id.callname = "sub__sndbal"
id.args = 4
id.arg = MKL$(ULONGTYPE - ISPOINTER) + MKL$(FLOATTYPE - ISPOINTER) + MKL$(FLOATTYPE - ISPOINTER) + MKL$(FLOATTYPE - ISPOINTER)
id.specialformat = "?,[?][,[?][,[?]]]"
regid


clearid
id.n = "_SNDVOL"
id.subfunc = 2
id.callname = "sub__sndvol"
id.args = 2
id.arg = MKL$(ULONGTYPE - ISPOINTER) + MKL$(FLOATTYPE - ISPOINTER)
regid

clearid
id.n = "_SNDPLAY"
id.subfunc = 2
id.callname = "sub__sndplay"
id.args = 1
id.arg = MKL$(ULONGTYPE - ISPOINTER)
regid

clearid
id.n = "_SNDCOPY"
id.subfunc = 1
id.callname = "func__sndcopy"
id.args = 1
id.arg = MKL$(ULONGTYPE - ISPOINTER)
id.ret = ULONGTYPE - ISPOINTER
regid

clearid
id.n = "_SNDCLOSE"
id.subfunc = 2
id.callname = "sub__sndclose"
id.args = 1
id.arg = MKL$(ULONGTYPE - ISPOINTER)
regid



clearid
id.n = "WRITE" 'stub
id.subfunc = 2
regid

clearid
id.n = "INPUT"
id.musthave = "$"
id.subfunc = 1
id.callname = "func_input"
id.args = 2
id.arg = MKL$(LONGTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER)
id.specialformat = "?[,?]"
id.ret = STRINGTYPE - ISPOINTER
regid

clearid
id.n = "SEEK"
id.subfunc = 2
id.callname = "sub_seek"
id.args = 2
id.arg = MKL$(LONGTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER)
id.specialformat = "[#]?,?"
regid

clearid
id.n = "SEEK"
id.subfunc = 1
id.callname = "func_seek"
id.args = 1
id.arg = MKL$(LONGTYPE - ISPOINTER)
id.ret = LONGTYPE - ISPOINTER
regid

clearid
id.n = "LOC"
id.subfunc = 1
id.callname = "func_loc"
id.args = 1
id.arg = MKL$(LONGTYPE - ISPOINTER)
id.ret = LONGTYPE - ISPOINTER
regid

clearid
id.n = "EOF"
id.subfunc = 1
id.callname = "func_eof"
id.args = 1
id.arg = MKL$(LONGTYPE - ISPOINTER)
id.ret = LONGTYPE - ISPOINTER
regid

clearid
id.n = "LOF"
id.subfunc = 1
id.callname = "func_lof"
id.args = 1
id.arg = MKL$(LONGTYPE - ISPOINTER)
id.ret = LONGTYPE - ISPOINTER
regid


clearid
id.n = "SCREEN"
id.subfunc = 1
id.callname = "func_screen"
id.args = 3
id.arg = MKL$(LONGTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER)
id.specialformat = "?,?[,?]"
id.ret = ULONGTYPE - ISPOINTER
regid

clearid
id.n = "PMAP"
id.subfunc = 1
id.callname = "func_pmap"
id.args = 2
id.arg = MKL$(SINGLETYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER)
id.ret = SINGLETYPE - ISPOINTER
regid


clearid
id.n = "POINT"
id.subfunc = 1
id.callname = "func_point"
id.args = 2
id.arg = MKL$(SINGLETYPE - ISPOINTER) + MKL$(SINGLETYPE - ISPOINTER)
id.specialformat = "?[,?]"
id.ret = DOUBLETYPE - ISPOINTER
regid


clearid
id.n = "TAB"
id.subfunc = 1
id.callname = "func_tab"
id.args = 1
id.arg = MKL$(LONGTYPE - ISPOINTER)
id.ret = STRINGTYPE - ISPOINTER
regid

clearid
id.n = "SPC"
id.subfunc = 1
id.callname = "func_spc"
id.args = 1
id.arg = MKL$(LONGTYPE - ISPOINTER)
id.ret = STRINGTYPE - ISPOINTER
regid


clearid
id.n = "WAIT"
id.subfunc = 2
id.callname = "sub_wait"
id.args = 3
id.arg = MKL$(LONGTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER)
id.specialformat = "?,?[,?]"
regid

clearid
id.n = "INP"
id.subfunc = 1
id.callname = "func_inp"
id.args = 1
id.arg = MKL$(LONGTYPE - ISPOINTER)
id.ret = LONGTYPE - ISPOINTER
regid

clearid
id.n = "POS"
id.subfunc = 1
id.callname = "func_pos"
id.args = 1
id.arg = MKL$(LONGTYPE - ISPOINTER)
id.ret = LONGTYPE - ISPOINTER
regid

clearid
id.n = "SGN"
id.subfunc = 1
id.callname = "func_sgn"
id.args = 1
id.arg = MKL$(-1)
id.ret = LONGTYPE - ISPOINTER
regid

clearid
id.n = "LBOUND"
id.subfunc = 1
id.args = 2
id.arg = MKL$(-1) + MKL$(LONGTYPE - ISPOINTER)
id.specialformat = "?,[?]"
id.ret = LONGTYPE - ISPOINTER
regid

clearid
id.n = "UBOUND"
id.subfunc = 1
id.args = 2
id.arg = MKL$(-1) + MKL$(LONGTYPE - ISPOINTER)
id.specialformat = "?,[?]"
id.ret = LONGTYPE - ISPOINTER
regid

clearid
id.n = "OCT"
id.musthave = "$"
id.subfunc = 1
id.args = 1
id.arg = MKL$(-1)
id.ret = STRINGTYPE - ISPOINTER
regid

clearid
id.n = "HEX"
id.musthave = "$"
id.subfunc = 1
id.args = 1
id.arg = MKL$(-1)
id.ret = STRINGTYPE - ISPOINTER
regid

clearid
id.n = "SLEEP"
id.subfunc = 2
id.callname = "sub_sleep"
id.args = 1
id.arg = MKL$(LONGTYPE - ISPOINTER)
id.specialformat = "[?]"
regid

clearid
id.n = "EXP"
id.subfunc = 1
id.args = 1
id.arg = MKL$(-1)
id.ret = -1
regid

clearid
id.n = "FIX"
id.subfunc = 1
id.args = 1
id.arg = MKL$(-1)
id.ret = -1
regid

clearid
id.n = "INT"
id.subfunc = 1
id.args = 1
id.arg = MKL$(-1)
id.ret = -1
regid

clearid
id.n = "CDBL"
id.subfunc = 1
id.args = 1
id.arg = MKL$(-1)
id.ret = DOUBLETYPE - ISPOINTER
regid

clearid
id.n = "CSNG"
id.subfunc = 1
id.args = 1
id.arg = MKL$(-1)
id.ret = SINGLETYPE - ISPOINTER
regid

clearid
id.n = "_ROUND"
id.subfunc = 1
id.args = 1
id.arg = MKL$(-1)
id.ret = INTEGER64TYPE - ISPOINTER
regid

clearid
id.n = "CINT"
id.subfunc = 1
id.args = 1
id.arg = MKL$(-1)
id.ret = INTEGERTYPE - ISPOINTER
regid

clearid
id.n = "CLNG"
id.subfunc = 1
id.args = 1
id.arg = MKL$(-1)
id.ret = INTEGERTYPE - ISPOINTER
regid



clearid
id.n = "TIME"
id.musthave = "$"
id.subfunc = 2
id.callname = "sub_time"
id.args = 1
id.arg = MKL$(STRINGTYPE - ISPOINTER)
id.specialformat = "=?"
regid

clearid
id.n = "TIME"
id.musthave = "$"
id.subfunc = 1
id.callname = "func_time"
id.ret = STRINGTYPE - ISPOINTER
regid



clearid
id.n = "DATE"
id.musthave = "$"
id.subfunc = 2
id.callname = "sub_date"
id.args = 1
id.arg = MKL$(STRINGTYPE - ISPOINTER)
id.specialformat = "=?"
regid

clearid
id.n = "DATE"
id.musthave = "$"
id.subfunc = 1
id.callname = "func_date"
id.ret = STRINGTYPE - ISPOINTER
regid

clearid
id.n = "CSRLIN"
id.subfunc = 1
id.callname = "func_csrlin"
id.ret = LONGTYPE - ISPOINTER
regid


clearid
id.n = "PAINT"
id.subfunc = 2
id.callname = "sub_paint"
id.args = 6
id.arg = MKL$(LONGTYPE - ISPOINTER) + MKL$(FLOATTYPE - ISPOINTER) + MKL$(FLOATTYPE - ISPOINTER) + MKL$(ULONGTYPE - ISPOINTER) + MKL$(ULONGTYPE - ISPOINTER) + MKL$(STRINGTYPE - ISPOINTER)
id.specialformat = "[{STEP}](?,?)[,[?][,[?][,?]]]"
'PAINT [STEP] (x!,y!)[,[paint] [,[bordercolor&] [,background$]]]
regid

clearid
id.n = "CIRCLE"
id.subfunc = 2
id.callname = "sub_circle"
id.args = 8
id.arg = MKL$(LONGTYPE - ISPOINTER) + MKL$(FLOATTYPE - ISPOINTER) + MKL$(FLOATTYPE - ISPOINTER) + MKL$(FLOATTYPE - ISPOINTER) + MKL$(ULONGTYPE - ISPOINTER) + MKL$(FLOATTYPE - ISPOINTER) + MKL$(FLOATTYPE - ISPOINTER) + MKL$(FLOATTYPE - ISPOINTER)
id.specialformat = "[{STEP}](?,?),?[,[?][,[?][,[?][,?]]]]"
'CIRCLE [STEP] (x!,y!),radius![,[color&] [,[start!] [,[end!] [,aspect!]]]]
regid

clearid
id.n = "READ" 'stub
id.subfunc = 2
regid


clearid
id.n = "BLOAD"
id.subfunc = 2
id.callname = "sub_bload"
id.args = 2
id.arg = MKL$(STRINGTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER)
id.specialformat = "?[,?]"
regid

clearid
id.n = "BSAVE"
id.subfunc = 2
id.callname = "sub_bsave"
id.args = 3
id.arg = MKL$(STRINGTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER)
regid


clearid
id.n = "CLOSE" 'stub
id.subfunc = 2
regid

clearid
id.n = "RESET" 'stub
id.subfunc = 2
regid

clearid
id.n = "GET"
id.subfunc = 2
id.callname = "sub_get"
id.args = 3
id.arg = MKL$(LONGTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER) + MKL$(-4)
id.specialformat = "[#]?,[?],?"
regid

clearid
id.n = "PUT"
id.subfunc = 2
id.callname = "sub_put"
id.args = 3
id.arg = MKL$(LONGTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER) + MKL$(-4)
id.specialformat = "[#]?,[?],?"
regid

'double definition
clearid
id.n = "GET"
id.subfunc = 2
id.callname = "sub_graphics_get"
id.args = 8
id.arg = MKL$(LONGTYPE - ISPOINTER) + MKL$(FLOATTYPE - ISPOINTER) + MKL$(FLOATTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER) + MKL$(FLOATTYPE - ISPOINTER) + MKL$(FLOATTYPE - ISPOINTER) + MKL$(-3) + MKL$(ULONGTYPE - ISPOINTER)
id.specialformat = "[{STEP}](?,?)-[{STEP}](?,?),?[,?]"
'GET [STEP](x1!,y1!)-[STEP](x2!,y2!),arrayname[(indexes%)]
id.secondargmustbe = "STEP"
regid
clearid
id.n = "GET"
id.subfunc = 2
id.callname = "sub_graphics_get"
id.args = 8
id.arg = MKL$(LONGTYPE - ISPOINTER) + MKL$(FLOATTYPE - ISPOINTER) + MKL$(FLOATTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER) + MKL$(FLOATTYPE - ISPOINTER) + MKL$(FLOATTYPE - ISPOINTER) + MKL$(-3) + MKL$(ULONGTYPE - ISPOINTER)
id.specialformat = "[{STEP}](?,?)-[{STEP}](?,?),?[,?]"
'GET [STEP](x1!,y1!)-[STEP](x2!,y2!),arrayname[(indexes%)]
id.secondargmustbe = "("
regid

'double definition
clearid
id.n = "PUT"
id.subfunc = 2
id.callname = "sub_graphics_put"
id.args = 7
id.arg = MKL$(LONGTYPE - ISPOINTER) + MKL$(FLOATTYPE - ISPOINTER) + MKL$(FLOATTYPE - ISPOINTER) + MKL$(-3) + MKL$(LONGTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER) + MKL$(ULONGTYPE - ISPOINTER)
id.specialformat = "[{STEP}](?,?),?[,[{_CLIP}][{PSET|PRESET|AND|OR|XOR}][,?]]"
'PUT [STEP] (x!,y!),arrayname# [(indexes%)] [,actionverb]
'PUT (10, 10), myimage, _CLIP, 0
id.secondargmustbe = "STEP"
regid
clearid
id.n = "PUT"
id.subfunc = 2
id.callname = "sub_graphics_put"
id.args = 7
id.arg = MKL$(LONGTYPE - ISPOINTER) + MKL$(FLOATTYPE - ISPOINTER) + MKL$(FLOATTYPE - ISPOINTER) + MKL$(-3) + MKL$(LONGTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER) + MKL$(ULONGTYPE - ISPOINTER)
id.specialformat = "[{STEP}](?,?),?[,[{_CLIP}][{PSET|PRESET|AND|OR|XOR}][,?]]"
'PUT [STEP] (x!,y!),arrayname# [(indexes%)] [,actionverb]
'PUT (10, 10), myimage, _CLIP, 0
id.secondargmustbe = "("
regid




clearid
id.n = "OPEN"
id.subfunc = 2
id.callname = "sub_open"
id.args = 6
id.arg = MKL$(STRINGTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER)
id.specialformat = "?[{FOR RANDOM|FOR BINARY|FOR INPUT|FOR OUTPUT|FOR APPEND}][{ACCESS READ WRITE|ACCESS READ|ACCESS WRITE}][{SHARED|LOCK READ WRITE|LOCK READ|LOCK WRITE}]{AS}[#]?[{LEN =}?]"
regid

clearid
id.n = "VAL"
id.subfunc = 1
id.callname = "func_val"
id.args = 1
id.arg = MKL$(STRINGTYPE - ISPOINTER)
id.ret = FLOATTYPE - ISPOINTER
regid

clearid
id.n = "MKSMBF"
id.musthave = "$"
id.subfunc = 1
id.callname = "func_mksmbf"
id.args = 1
id.arg = MKL$(SINGLETYPE - ISPOINTER)
id.ret = STRINGTYPE - ISPOINTER
regid
clearid
id.n = "MKDMBF"
id.musthave = "$"
id.subfunc = 1
id.callname = "func_mkdmbf"
id.args = 1
id.arg = MKL$(DOUBLETYPE - ISPOINTER)
id.ret = STRINGTYPE - ISPOINTER
regid

clearid
id.n = "MKI"
id.musthave = "$"
id.subfunc = 1
id.callname = ""
id.args = 1
id.arg = MKL$(INTEGERTYPE - ISPOINTER)
id.ret = STRINGTYPE - ISPOINTER
regid
clearid
id.n = "MKL"
id.musthave = "$"
id.subfunc = 1
id.callname = ""
id.args = 1
id.arg = MKL$(LONGTYPE - ISPOINTER)
id.ret = STRINGTYPE - ISPOINTER
regid
clearid
id.n = "MKS"
id.musthave = "$"
id.subfunc = 1
id.callname = ""
id.args = 1
id.arg = MKL$(SINGLETYPE - ISPOINTER)
id.ret = STRINGTYPE - ISPOINTER
regid
clearid
id.n = "MKD"
id.musthave = "$"
id.subfunc = 1
id.callname = ""
id.args = 1
id.arg = MKL$(DOUBLETYPE - ISPOINTER)
id.ret = STRINGTYPE - ISPOINTER
regid
clearid
id.n = "_MK"
id.musthave = "$"
id.subfunc = 1
id.callname = ""
id.args = 2
id.arg = MKL$(-1) + MKL$(-1)
id.ret = STRINGTYPE - ISPOINTER
regid

clearid
id.n = "CVSMBF"
id.subfunc = 1
id.callname = "func_cvsmbf"
id.args = 1
id.arg = MKL$(STRINGTYPE - ISPOINTER)
id.ret = SINGLETYPE - ISPOINTER
regid
clearid
id.n = "CVDMBF"
id.subfunc = 1
id.callname = "func_cvdmbf"
id.args = 1
id.arg = MKL$(STRINGTYPE - ISPOINTER)
id.ret = DOUBLETYPE - ISPOINTER
regid

clearid
id.n = "CVI"
id.subfunc = 1
id.callname = ""
id.args = 1
id.arg = MKL$(STRINGTYPE - ISPOINTER)
id.ret = INTEGERTYPE - ISPOINTER
regid
clearid
id.n = "CVL"
id.subfunc = 1
id.callname = ""
id.args = 1
id.arg = MKL$(STRINGTYPE - ISPOINTER)
id.ret = LONGTYPE - ISPOINTER
regid
clearid
id.n = "CVS"
id.subfunc = 1
id.callname = ""
id.args = 1
id.arg = MKL$(STRINGTYPE - ISPOINTER)
id.ret = SINGLETYPE - ISPOINTER
regid
clearid
id.n = "CVD"
id.subfunc = 1
id.callname = ""
id.args = 1
id.arg = MKL$(STRINGTYPE - ISPOINTER)
id.ret = DOUBLETYPE - ISPOINTER
regid
clearid
id.n = "_CV"
id.subfunc = 1
id.callname = ""
id.args = 2
id.arg = MKL$(-1) + MKL$(STRINGTYPE - ISPOINTER)
id.ret = -1
regid

clearid
id.n = "STRING"
id.musthave = "$"
id.subfunc = 1
id.callname = "func_string"
id.args = 2
id.arg = MKL$(LONGTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER)
id.ret = STRINGTYPE - ISPOINTER
regid

clearid
id.n = "SPACE"
id.musthave = "$"
id.subfunc = 1
id.callname = "func_space"
id.args = 1
id.arg = MKL$(LONGTYPE - ISPOINTER)
id.ret = STRINGTYPE - ISPOINTER
regid

clearid
id.n = "INSTR"
id.subfunc = 1
id.callname = "func_instr"
id.args = 3
id.arg = MKL$(LONGTYPE - ISPOINTER) + MKL$(STRINGTYPE - ISPOINTER) + MKL$(STRINGTYPE - ISPOINTER)
id.ret = LONGTYPE - ISPOINTER
id.specialformat = "[?],?,?" 'checked!
regid

clearid
id.n = "MID"
id.musthave = "$"
id.subfunc = 1
id.callname = "func_mid"
id.args = 3
id.arg = MKL$(STRINGTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER)
id.ret = STRINGTYPE - ISPOINTER
id.specialformat = "?,?,[?]" 'checked!
regid

clearid
id.n = "SADD"
id.subfunc = 1
id.callname = ""
id.args = 1
id.arg = MKL$(-1)'!this value is ignored, the qb64 compiler handles this function
id.ret = LONGTYPE - ISPOINTER
regid

clearid
id.n = "CLS"
id.subfunc = 2
id.callname = "sub_cls"
id.args = 2
id.arg = MKL$(LONGTYPE - ISPOINTER)+MKL$(ULONGTYPE - ISPOINTER)
id.specialformat = "[?][,?]"
regid

clearid
id.n = "SQR"
id.subfunc = 1
id.callname = "func_sqr"
id.args = 1
id.arg = MKL$(FLOATTYPE - ISPOINTER)
id.ret = FLOATTYPE - ISPOINTER
regid

clearid
id.n = "CHR"
id.musthave = "$"
id.subfunc = 1
id.callname = "func_chr"
id.args = 1
id.arg = MKL$(LONGTYPE - ISPOINTER)
id.ret = STRINGTYPE - ISPOINTER
regid

clearid
id.n = "VARPTR"
id.subfunc = 1
id.callname = ""
id.args = 1
id.arg = MKL$(-1)'!this value is ignored, the qb64 compiler handles this function
id.ret = STRINGTYPE - ISPOINTER
id.musthave = "$"
regid


clearid
id.n = "VARPTR"
id.subfunc = 1
id.callname = ""
id.args = 1
id.arg = MKL$(-1)'!this value is ignored, the qb64 compiler handles this function
id.ret = LONGTYPE - ISPOINTER
regid

clearid
id.n = "VARSEG"
id.subfunc = 1
id.callname = ""
id.args = 1
id.arg = MKL$(-1)'!this value is ignored, the qb64 compiler handles this function
id.ret = LONGTYPE - ISPOINTER
regid

clearid
id.n = "POKE"
id.subfunc = 2
id.callname = "sub_poke"
id.args = 2
id.arg = MKL$(LONGTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER)
regid

clearid
id.n = "PEEK"
id.subfunc = 1
id.callname = "func_peek"
id.args = 1
id.arg = MKL$(LONGTYPE - ISPOINTER)
id.ret = LONGTYPE - ISPOINTER
regid

clearid
id.n = "DEF"
id.subfunc = 2
id.callname = "sub_defseg"
id.args = 1
id.arg = MKL$(LONGTYPE - ISPOINTER)
id.specialformat = "{SEG}[=?]" 'checked!
id.secondargmustbe = "SEG"
regid

clearid
id.n = "SIN"
id.subfunc = 1
id.callname = "sin"
id.args = 1
id.arg = MKL$(FLOATTYPE - ISPOINTER)
id.ret = FLOATTYPE - ISPOINTER
regid

clearid
id.n = "COS"
id.subfunc = 1
id.callname = "cos"
id.args = 1
id.arg = MKL$(FLOATTYPE - ISPOINTER)
id.ret = FLOATTYPE - ISPOINTER
regid

clearid
id.n = "TAN"
id.subfunc = 1
id.callname = "tan"
id.args = 1
id.arg = MKL$(FLOATTYPE - ISPOINTER)
id.ret = FLOATTYPE - ISPOINTER
regid

clearid
id.n = "ATN"
id.subfunc = 1
id.callname = "atan"
id.args = 1
id.arg = MKL$(FLOATTYPE - ISPOINTER)
id.ret = FLOATTYPE - ISPOINTER
regid

clearid
id.n = "LOG"
id.subfunc = 1
id.callname = "func_log"
id.args = 1
id.arg = MKL$(FLOATTYPE - ISPOINTER)
id.ret = FLOATTYPE - ISPOINTER
regid

clearid
id.n = "ABS"
id.subfunc = 1
id.callname = "func_abs"
id.args = 1
id.arg = MKL$(-1) 'takes anything numerical
id.ret = FLOATTYPE - ISPOINTER '***overridden by function evaluatefunc***
regid

clearid
id.n = "ERL"
id.subfunc = 1
id.callname = "get_error_erl"
id.args = 0
id.ret = DOUBLETYPE - ISPOINTER
regid

clearid
id.n = "ERR"
id.subfunc = 1
id.callname = "get_error_err"
id.args = 0
id.ret = ULONGTYPE - ISPOINTER
regid

clearid
id.n = "ERROR"
id.subfunc = 2
id.callname = "error"
id.args = 1
id.arg = MKL$(ULONGTYPE - ISPOINTER)
regid

clearid
id.n = "LINE"
id.subfunc = 2
id.callname = "sub_line"
id.args = 9
id.arg = MKL$(LONGTYPE - ISPOINTER) + MKL$(FLOATTYPE - ISPOINTER) + MKL$(FLOATTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER) + MKL$(FLOATTYPE - ISPOINTER) + MKL$(FLOATTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER) + MKL$ _
(LONGTYPE - ISPOINTER)
id.specialformat = "[[{STEP}](?,?)]-[{STEP}](?,?)[,[?][,[{B|BF}][,?]]]"
regid

clearid
id.n = "SOUND"
id.subfunc = 2
id.callname = "sub_sound"
id.args = 2
id.arg = MKL$(DOUBLETYPE - ISPOINTER) + MKL$(DOUBLETYPE - ISPOINTER)
regid

clearid
id.n = "BEEP"
id.subfunc = 2
id.callname = "sub_beep"
id.args = 0
regid

clearid
id.n = "TIMER"
id.subfunc = 1
id.callname = "func_timer"
id.args = 1
id.arg = MKL$(DOUBLETYPE - ISPOINTER)
id.ret = SINGLETYPE - ISPOINTER
id.specialformat = "[?]"
regid

clearid
id.n = "RND"
id.subfunc = 1
id.callname = "func_rnd"
id.args = 1
id.arg = MKL$(FLOATTYPE - ISPOINTER)
id.ret = SINGLETYPE - ISPOINTER
id.specialformat = "[?]" 'checked!
regid

clearid
id.n = "RANDOMIZE"
id.subfunc = 2
id.callname = "sub_randomize"
id.args = 1
id.arg = MKL$(DOUBLETYPE - ISPOINTER)
id.specialformat = "[?]" 'checked!
regid

clearid
id.n = "OUT"
id.subfunc = 2
id.callname = "sub_out"
id.args = 2
id.arg = MKL$(LONGTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER)
regid

clearid
id.n = "PCOPY"
id.subfunc = 2
id.callname = "sub_pcopy"
id.args = 2
id.arg = MKL$(LONGTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER)
regid

clearid
id.n = "VIEW"
id.subfunc = 2
id.callname = "qbg_sub_view"
id.args = 7
id.arg = MKL$(LONGTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER)
id.specialformat = "[[{SCREEN}](?,?)-(?,?)[,[?][,?]]]" 'new!
id.secondargcantbe = "PRINT"
regid

clearid
id.n = "VIEW"
id.subfunc = 2
id.callname = "qbg_sub_view_print"
id.args = 2
id.arg = MKL$(LONGTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER)
id.specialformat = "{PRINT}[?{TO}?]" 'new!
id.secondargmustbe = "PRINT"
regid

clearid
id.n = "INPUT"
id.subfunc = 2
'stub
regid

clearid
id.n = "WINDOW"
id.subfunc = 2
id.callname = "qbg_sub_window"
id.args = 5
id.arg = MKL$(LONGTYPE - ISPOINTER) + MKL$(FLOATTYPE - ISPOINTER) + MKL$(FLOATTYPE - ISPOINTER) + MKL$(FLOATTYPE - ISPOINTER) + MKL$(FLOATTYPE - ISPOINTER)
id.specialformat = "[[{SCREEN}](?,?)-(?,?)]"
regid

clearid
id.n = "LOCATE"
id.subfunc = 2
id.callname = "qbg_sub_locate"
id.args = 5
id.arg = MKL$(LONGTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER)
id.specialformat = "[?][,[?][,[?][,?,?]]]"
regid

clearid
id.n = "COLOR"
id.subfunc = 2
id.callname = "qbg_sub_color"
id.args = 3
id.arg = MKL$(LONGTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER)
id.specialformat = "[?][,[?][,?]]"
regid

clearid
id.n = "PALETTE"
id.subfunc = 2
id.callname = "qbg_palette"
id.args = 2
id.arg = MKL$(LONGTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER)
id.specialformat = "[?,?]"
regid

clearid
id.n = "WIDTH"
id.subfunc = 2
id.callname = "qbsub_width"
id.args = 3
id.arg = MKL$(LONGTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER)
id.specialformat = "[{#|LPRINT}][?][,?]" 'new!
regid

clearid
id.n = "SCREEN"
id.subfunc = 2
id.callname = "qbg_screen"
id.args = 5
id.arg = MKL$(LONGTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER)+ MKL$(LONGTYPE - ISPOINTER)
'id.specialformat = "[?][,[?][,[?][,?]]]" 'new!
'id.specialformat = "[?][,[?][,[?][,[?][,{_MANUALDISPLAY}]]]]" 'breaks compilation!
id.specialformat = "[?][,[?][,[?][,[?][,[{_MANUALDISPLAY}]]]]]"
regid

clearid
id.n = "PSET"
id.subfunc = 2
id.callname = "qbg_pset"
id.args = 4
id.arg = MKL$(LONGTYPE - ISPOINTER) + MKL$(FLOATTYPE - ISPOINTER) + MKL$(FLOATTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER)
id.specialformat = "[{STEP}](?,?)[,?]" 'new!
regid

clearid
id.n = "PRESET"
id.subfunc = 2
id.callname = "sub_preset"
id.args = 4
id.arg = MKL$(LONGTYPE - ISPOINTER) + MKL$(FLOATTYPE - ISPOINTER) + MKL$(FLOATTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER)
id.specialformat = "[{STEP}](?,?)[,?]"
regid

clearid
id.n = "ASC"
id.subfunc = 1
id.callname = "qbs_asc"
id.args = 1
id.arg = MKL$(STRINGTYPE - ISPOINTER)
id.ret = LONGTYPE - ISPOINTER
regid

clearid
id.n = "LEN"
id.subfunc = 1
id.callname = "" 'callname is not used
id.args = 1
id.arg = MKL$(STRINGTYPE - ISPOINTER) 'note: LEN is a special case, any input is actually accepted
id.ret = LONGTYPE - ISPOINTER
regid

clearid
id.n = "INKEY"
id.musthave = "$"
id.subfunc = 1
id.callname = "qbs_inkey"
id.ret = STRINGTYPE - ISPOINTER
regid

clearid
id.n = "STR"
id.musthave = "$"
id.subfunc = 1
id.callname = "qbs_str"
id.args = 1
id.arg = MKL$(-1)
id.ret = STRINGTYPE - ISPOINTER
regid

clearid
id.n = "UCASE"
id.musthave = "$"
id.subfunc = 1
id.callname = "qbs_ucase"
id.args = 1
id.arg = MKL$(STRINGTYPE - ISPOINTER)
id.ret = STRINGTYPE - ISPOINTER
regid

clearid
id.n = "LCASE"
id.musthave = "$"
id.subfunc = 1
id.callname = "qbs_lcase"
id.args = 1
id.arg = MKL$(STRINGTYPE - ISPOINTER)
id.ret = STRINGTYPE - ISPOINTER
regid

clearid
id.n = "LEFT"
id.musthave = "$"
id.subfunc = 1
id.callname = "qbs_left"
id.args = 2
id.arg = MKL$(STRINGTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER)
id.ret = STRINGTYPE - ISPOINTER
regid

clearid
id.n = "RIGHT"
id.musthave = "$"
id.subfunc = 1
id.callname = "qbs_right"
id.args = 2
id.arg = MKL$(STRINGTYPE - ISPOINTER) + MKL$(LONGTYPE - ISPOINTER)
id.ret = STRINGTYPE - ISPOINTER
regid

clearid
id.n = "LTRIM"
id.musthave = "$"
id.subfunc = 1
id.callname = "qbs_ltrim"
id.args = 1
id.arg = MKL$(STRINGTYPE - ISPOINTER)
id.ret = STRINGTYPE - ISPOINTER
regid

clearid
id.n = "RTRIM"
id.musthave = "$"
id.subfunc = 1
id.callname = "qbs_rtrim"
id.args = 1
id.arg = MKL$(STRINGTYPE - ISPOINTER)
id.ret = STRINGTYPE - ISPOINTER
regid

clearid
id.n = "PRINT"
id.subfunc = 2
id.callname = "qbs_print"
id.args = 1
id.arg = MKL$(STRINGTYPE - ISPOINTER)
regid

END SUB

'this sub is faulty atm!
'sub replacelement (a$, i, newe$)
''note: performs no action for out of range values of i
'e=1
's=1
'do
'x=instr(s,a$,sp)
'if x then
'if e=i then
'a1$=left$(a$,s-1): a2$=right$(a$,len(a$)-x+1)
'a$=a1$+sp+newe$+a2$ 'note: a2 includes spacer
'exit sub
'end if
's=x+1
'e=e+1
'end if
'loop until x=0
'if e=i then
'a$=left$(a$,s-1)+sp+newe$
'end if
'end sub


SUB removeelements (a$, first, last, keepindexing)
a2$ = ""
'note: first and last MUST be valid
'      keepindexing means the number of elements will stay the same
'       but some elements will be equal to ""

n = numelements(a$)
FOR i = 1 TO n
IF i < first OR i > last THEN
a2$ = a2$ + sp + getelement(a$, i)
ELSE
IF keepindexing THEN a2$ = a2$ + sp
END IF
NEXT
IF LEFT$(a2$, 1) = sp THEN a2$ = RIGHT$(a2$, LEN(a2$) - 1)

a$ = a2$

END SUB

FUNCTION removesymbol$ (varname$)
i = INSTR(varname$, "~"): IF i THEN GOTO foundsymbol
i = INSTR(varname$, "`"): IF i THEN GOTO foundsymbol
i = INSTR(varname$, "%"): IF i THEN GOTO foundsymbol
i = INSTR(varname$, "&"): IF i THEN GOTO foundsymbol
i = INSTR(varname$, "!"): IF i THEN GOTO foundsymbol
i = INSTR(varname$, "#"): IF i THEN GOTO foundsymbol
i = INSTR(varname$, "$"): IF i THEN GOTO foundsymbol
EXIT FUNCTION
foundsymbol:
IF i = 1 THEN nerror (84)
removesymbol$ = RIGHT$(varname$, LEN(varname$) - i + 1)
varname$ = LEFT$(varname$, i - 1)
END FUNCTION

FUNCTION scope$
IF id.share THEN scope$ = module$ + "__": EXIT FUNCTION
scope$ = module$ + "_" + subfunc$ + "_"
END FUNCTION

FUNCTION seperateargs (a$, ca$, pass&)
pass& = 0

FOR i = 1 TO 60: separgs(i) = "": NEXT
FOR i = 1 TO 61: separgslayout(i) = "": NEXT

DIM id2 AS idstruct

id2 = id

IF id2.args = 0 THEN EXIT FUNCTION 'no arguments!

s$ = id2.specialformat
s$ = RTRIM$(s$)
IF s$ = "" THEN
FOR i = 1 TO id2.args
IF i <> 1 THEN s$ = s$ + ",?" ELSE s$ = "?"
NEXT
END IF

'these options are independent of separgs, because they refer to the
'format of the sub/function HOWEVER, the first value should be larger
'than the value used in separgs
'the second value is the number of options in a block such as
'{A|BAT|CAT}
DIM opt(1 TO 100, 1 TO 100) AS STRING
DIM optwords(1 TO 100, 1 TO 100) AS INTEGER
DIM lev(1 TO 100) AS INTEGER
DIM entrylev(1 TO 100) AS INTEGER
DIM t(1 TO 100) AS INTEGER
DIM dontpass(1 TO 100) AS INTEGER
DIM passflag(1 TO 100) AS INTEGER 'used to avoid passing duplicate "passed" flags
DIM levelentered(100) 'up to 64 levels supported

nextentrylevel = 0
nextentrylevelset = 1
level = 0
lastt = 0

FOR i = 1 TO LEN(s$)
s2$ = MID$(s$, i, 1)

IF s2$ = "[" THEN
level = level + 1
levelentered(level) = 0
GOTO nextsymbol
END IF

IF s2$ = "]" THEN
level = level - 1
GOTO nextsymbol
END IF

IF s2$ = "{" THEN
lastt = lastt + 1: lev(lastt) = level

i = i + 1
i2 = INSTR(i, s$, "}")
numopts = 0
nextopt:
numopts = numopts + 1
i3 = INSTR(i + 1, s$, "|")
IF i3 <> 0 AND i3 < i2 THEN
opt(lastt, numopts) = MID$(s$, i, i3 - i)
i = i3 + 1: GOTO nextopt
END IF
opt(lastt, numopts) = MID$(s$, i, i2 - i)
t(lastt) = numopts
'calculate words in each option
FOR x = 1 TO t(lastt)
w = 1
x2 = 1
newword:
IF INSTR(x2, opt(lastt, x), " ") THEN w = w + 1: x2 = INSTR(x2, opt(lastt, x), " ") + 1: GOTO newword
optwords(lastt, x) = w
NEXT
i = i2

'set entry level routine
entrylev(lastt) = level 'default level when continuing a previously entered level
IF levelentered(level) = 0 THEN
entrylev(lastt) = 0
FOR i2 = 1 TO level - 1
IF levelentered(i2) = 1 THEN entrylev(lastt) = i2
NEXT
END IF
levelentered(level) = 1

GOTO nextsymbol
END IF

IF s2$ = "?" THEN
lastt = lastt + 1: lev(lastt) = level
t(lastt) = 0

'set entry level routine
entrylev(lastt) = level 'default level when continuing a previously entered level
IF levelentered(level) = 0 THEN
entrylev(lastt) = 0
FOR i2 = 1 TO level - 1
IF levelentered(i2) = 1 THEN entrylev(lastt) = i2
NEXT
END IF
levelentered(level) = 1

GOTO nextsymbol
END IF

'assume "special" character (like ( ) , . - etc.)
lastt = lastt + 1: lev(lastt) = level
t(lastt) = 1: opt(lastt, 1) = s2$: optwords(lastt, 1) = 1: dontpass(lastt) = 1

'set entry level routine
entrylev(lastt) = level 'default level when continuing a previously entered level
IF levelentered(level) = 0 THEN
entrylev(lastt) = 0
FOR i2 = 1 TO level - 1
IF levelentered(i2) = 1 THEN entrylev(lastt) = i2
NEXT
END IF
levelentered(level) = 1

GOTO nextsymbol

nextsymbol:
NEXT

DIM nopasslist(1 TO 100) AS INTEGER
FOR x = 1 TO lastt
IF lev(x) = 0 THEN
IF t(x) = 1 THEN dontpass(x) = 1
END IF
NEXT

x1 = 0
optional = 0
nopasslistn = 0
FOR l = 1 TO 32767
scannextlevel = 0

FOR x = 1 TO lastt
IF lev(x) > l THEN scannextlevel = 1

 IF x1 THEN
 IF entrylev(x) < l THEN
 IF optional THEN
 FOR x2 = 1 TO nopasslistn: dontpass(nopasslist(x2)) = 1: NEXT
 ELSE
 FOR x2 = 2 TO nopasslistn: dontpass(nopasslist(x2)) = 1: NEXT
 END IF
 x1 = 0
 END IF
 END IF

IF lev(x) = l THEN
IF entrylev(x) < l THEN x1 = x: optional = 0: nopasslistn = 0
END IF

IF x1 THEN
IF lev(x) > l THEN optional = 1
IF lev(x) = l THEN
IF t(x) <> 1 THEN optional = 1
IF t(x) = 1 THEN nopasslistn = nopasslistn + 1: nopasslist(nopasslistn) = x
END IF
END IF

NEXT
'scan last run
IF x1 THEN
IF optional THEN
FOR x2 = 1 TO nopasslistn: dontpass(nopasslist(x2)) = 1: NEXT
ELSE
FOR x2 = 2 TO nopasslistn: dontpass(nopasslist(x2)) = 1: NEXT
END IF
END IF
IF scannextlevel = 0 THEN EXIT FOR
NEXT

'should consider changes from previous pass
x1 = 0
optional = 0
nopasslistn = 0
FOR l = 1 TO 32767
scannextlevel = 0

FOR x = 1 TO lastt
IF lev(x) > l THEN scannextlevel = 1

 IF x1 THEN
 IF entrylev(x) < l THEN
 IF nopasslistn THEN passflag(nopasslist(1)) = 1
 x1 = 0
 END IF
 END IF

IF lev(x) = l THEN
IF entrylev(x) < l THEN x1 = x: nopasslistn = 0
 IF x1 = 0 THEN
 IF lev(x - 1) > l THEN x1 = x: nopasslistn = 0
 END IF
END IF

IF x1 THEN
IF lev(x) > l THEN optional = 1
IF lev(x) = l THEN
IF dontpass(x) = 0 AND t(x) = 0 THEN nopasslistn = nopasslistn + 1: nopasslist(nopasslistn) = x
END IF
END IF

NEXT
 'scan last run
 IF x1 THEN
 IF entrylev(x) < l THEN
 IF nopasslistn THEN passflag(nopasslist(1)) = 1
 x1 = 0
 END IF
 END IF
IF scannextlevel = 0 THEN EXIT FOR
NEXT

FOR i = 1 TO lastt: separgs(i) = "null": NEXT

'visualize opts
GOTO skipvisopts

COLOR 15
LOCATE 1, 1
PRINT "FORMAT:"
PRINT s$
x = 1
FOR i = 1 TO lastt
COLOR 7
LOCATE 20 - lev(i), x: PRINT str2(lev(i) + 0)'"*" 'str2(t(i) + 0)
COLOR 8
extra = 0
IF t(i) = 0 THEN
LOCATE 20 - lev(i) - 1, x: PRINT "?"
extra = 1
ELSE
FOR i2 = 1 TO t(i)
LOCATE 20 - lev(i) - 1 - t(i) + i2, x: PRINT opt(i, i2)
IF extra < LEN(opt(i, i2)) THEN extra = LEN(opt(i, i2))
NEXT
END IF
COLOR 1
LOCATE 21, x: IF entrylev(i) <> -1 THEN PRINT str2(entrylev(i) + 0) ELSE PRINT "-"
LOCATE 22, x: IF dontpass(i) THEN COLOR 4: PRINT "X" ELSE COLOR 2: PRINT "P"
LOCATE 23, x: IF passflag(i) THEN COLOR 10: PRINT ""
x = x + 1 + extra
NEXT
COLOR 7
SLEEP
LOCATE 24, 1
skipvisopts:

DIM readahead(1 TO 8) AS STRING

n = numelements(a$)
s = 1 'next item to check (assume at least 1 item exists!)
i = 1
level = 0
currentexpression = -1
l$=""
sepnextarg:

e$ = ""
b = 0
nextexpele:
 'reload read-ahead buffers
 IF (i <= n) THEN e2$ = getelement$(ca$, i) ELSE e2$ = ""
 readahead(1)=ucase$(e2$)
 FOR x = 1 TO 7
 IF ((i + x) <= n) THEN readahead(x + 1) = readahead(x) + " " + getelement$(a$, i + x) ELSE readahead(x + 1) = ""
 NEXT

IF b = 0 THEN
currentexpression = -1
l = level 'temp. level
FOR x = s TO lastt
IF entrylev(x) < l THEN l = entrylev(x) 'lower l

IF entrylev(x) <= l THEN 'it is possible to enter this level

'register an expression?
IF t(x) = 0 THEN

IF currentexpression = -1 THEN
currentexpression = x: level = lev(x)
x = x + 1
END IF

END IF

IF t(x) THEN

x3 = x
FOR x2 = 1 TO t(x3)
'PRINT readahead(optwords(x3, x2)), opt(x3, x2)
IF readahead(optwords(x3, x2)) = opt(x3, x2) THEN
IF e$ <> "" THEN
'IF currentexpression = -1 THEN PRINT "ILLEGAL EXPRESSION!"
'separgslayout(currentexpression) = "@"+l$
separgs(currentexpression) = e$
currentexpression = -1
END IF

'aha x3 is x, and x is the point in the syntax we are up to
'x begins at s(the start) to lastt(the last point in the syntax)

'unfortunately it may be near impossible to deduce which opts are choices
'aha, it seems unneeded args are culled after(see below)
'this could destroy some of these args but... that's ok they can be added to others

e$ = ""
separgslayout(x3)=chr$(len(opt(x3, x2)))+opt(x3, x2)
separgs(x3) = chr$(0)+str2(x2)
i = i + optwords(x3, x2)
s = x3 + 1
level = lev(x3)
GOTO sepnextarg
END IF
NEXT x2

'PRINT l, lev(x)

IF l = lev(x) THEN 'is level we are in now the same as this options level?
'if so, a mandatory item has been encountered!
'missing mandatory option encountered! abort this scan
'PRINT "Aborted!"
GOTO abortoptscan
END IF

END IF 't(x)<>0

END IF
NEXT
abortoptscan:

END IF

IF e2$ = "(" THEN b = b + 1
IF e2$ = ")" THEN b = b - 1
IF e$ <> "" THEN e$ = e$ + sp + e2$ ELSE e$ = e2$

IF i < n THEN
i = i + 1
GOTO nextexpele
END IF

IF e$ <> "" THEN
'should this create an error?
IF currentexpression = -1 THEN qb64error "Syntax error in expression"

'separgslayout(currentexpression) = "#"+l$
separgs(currentexpression) = e$
currentexpression = -1
END IF

'PRINT "--------SEPERATE ARGUMENTS REPORT--------"
'PRINT "----FORMAT----"
'PRINT s$
'PRINT "----SEPARGS(...)----"
'FOR i = 1 TO lastt
'PRINT separgs(i)
'NEXT
'PRINT lastt

pass& = 0
x = 1
omitn = 0
omitnpassed = 0
FOR i = 1 TO lastt
IF dontpass(i) = 0 THEN

IF passflag(i) THEN omit = 1: omitn = omitn + 1
IF separgs(i) <> "null" AND passflag(i) = 1 THEN pass& = pass& + (2& ^ (omitn - 1)): omitnpassed = omitnpassed + 1
separgs(x) = separgs(i)
separgslayout(x) = separgslayout(i)

if len(separgs(x)) then
if asc(separgs(x))=0 then
'switch omit layout tag from item to layout info
separgs(x)=right$(separgs(x),len(separgs(x))-1)
separgslayout(x)=separgslayout(x)+chr$(0)
end if
end if

IF separgs(x) = "null" THEN separgs(x) = "NULL"
x = x + 1

else
'its gonna be skipped!
'add it to the next one to be safe
separgslayout(i+1) = separgslayout(i)+separgslayout(i+1)

END IF
NEXT
separgslayout(x)=separgslayout(i)'set final layout



x = x - 1

'PRINT "total arguments:"; x
'PRINT "omittable arguments passed:"; omitnpassed; "/"; omitn
'PRINT "pass omit (0/1):"; omit
'PRINT "pass&="; pass&

seperateargs = omit
END FUNCTION

SUB setrefer (a2$, typ2 AS LONG, e2$, method AS LONG)
a$ = a2$: typ = typ2: e$ = e2$
if method<>1 then e$=fixoperationorder$(e$)
tl$=tlayout$

'method: 0 evaulatetotyp e$
'        1 skip evaluation of e$ and use as is
'*due to the complexity of setting a reference with a value/string
' this function handles the problem

'retrieve ID
i = INSTR(a$, "")
IF i THEN
idnumber = VAL(LEFT$(a$, i - 1)): a$ = RIGHT$(a$, LEN(a$) - i)
ELSE
idnumber = VAL(a$)
END IF
getid idnumber


'UDT?
IF typ and ISUDT then

'print "setrefer-ing a UDT!"
u=VAL(a$)
i = INSTR(a$, ""): a$=right$(a$,len(a$)-i): e=VAL(a$)
i = INSTR(a$, ""): o$=right$(a$,len(a$)-i)
n$="UDT_"+rtrim$(id.n):if id.t=0 then n$="ARRAY_"+n$+"[0]"


if e=0 then
'use u and u's size

IF method <> 0 THEN qb64error "Unexpected internal code reference to UDT"
lhsscope$=scope$
e$ = evaluate(e$, t2)
if (t2 and ISUDT)=0 then qb64error "Expected = similar user defined type"
idnumber2=VAL(e$)
getid idnumber2
n2$="UDT_"+rtrim$(id.n):if id.t=0 then n2$="ARRAY_"+n2$+"[0]"
i = INSTR(e$, ""): e$=right$(e$,len(e$)-i): u2=VAL(e$)
i = INSTR(e$, ""): e$=right$(e$,len(e$)-i): e2=VAL(e$)
i = INSTR(e$, ""): o2$=right$(e$,len(e$)-i)
'WARNING: u2 may need minor modifications based on e to see if they are the same
if u<>u2 or e2<>0 then qb64error "Expected = similar user defined type"

'we have now established we have 2 pointers to similar data types!
'ASSUME BYTE TYPE!!!

dst$="(((char*)"+lhsscope$+n$+")+("+o$+"))"
src$="(((char*)"+scope$+n2$+")+("+o2$+"))"
siz$=str2$(udtxsize(u)\8)

print #12, "memcpy("+dst$+","+src$+","+siz$+");"

'print "setFULLUDTrefer!"

tlayout$=tl$
EXIT SUB

end if 'e=0

if typ and ISOFFSETINBITS then qb64error "Cannot resolve bit-length variables inside user defined types yet"
if typ and ISSTRING then
 o2$="(((unsigned char*)"+scope$+n$+")+("+o$+"))"
 r$ ="qbs_new_fixed(" + o2$ + "," + str2(udtetypesize(e)) + ",1)"
 if method=0 then e$=evaluatetotyp(e$,STRINGTYPE-ISPOINTER)
 print #12, "qbs_set("+r$+","+e$+");"
else
 typ = typ - ISUDT - ISREFERENCE - ISPOINTER
 IF typ and ISARRAY then typ = typ - ISARRAY
 t$=typ2ctyp$(typ,"")
 o2$="(((char*)"+scope$+n$+")+("+o$+"))"
 r$="*"+"("+t$+"*)"+o2$
 if method=0 then e$=evaluatetotyp(e$,typ)
 print #12, r$+"="+e$+";"
end if

'print "setUDTrefer:"+r$,e$
tlayout$=tl$
EXIT SUB
end if


'array?
IF id.arraytype THEN
n$ = RTRIM$(id.callname)
typ = typ - ISPOINTER - ISREFERENCE'typ now looks like a regular value

IF (typ AND ISSTRING) THEN
IF (typ AND ISFIXEDLENGTH) THEN
 offset$ = "&((unsigned char*)(" + n$ + "[0]))[tmp_long*" + str2(id.tsize) + "]"
 r$ = "qbs_new_fixed(" + offset$ + "," + str2(id.tsize) + ",1)"
 PRINT #12, "tmp_long=" + a$ + ";"
 IF method = 0 THEN
 l$ = "if (!new_error) qbs_set(" + r$ + "," + evaluatetotyp(e$, typ) + ");"
 ELSE
 l$ = "if (!new_error) qbs_set(" + r$ + "," + e$ + ");"
 END IF
 PRINT #12, l$
ELSE
 PRINT #12, "tmp_long=" + a$ + ";"
 IF method = 0 THEN
 l$ = "if (!new_error) qbs_set( ((qbs*)(((uint64*)(" + n$ + "[0]))[tmp_long]))," + evaluatetotyp(e$, typ) + ");"
 ELSE
 l$ = "if (!new_error) qbs_set( ((qbs*)(((uint64*)(" + n$ + "[0]))[tmp_long]))," + e$ + ");"
 END IF
 PRINT #12, l$
END IF
stringprocessinghappened = 1
tlayout$=tl$
EXIT SUB
END IF

IF (typ AND ISOFFSETINBITS) THEN
'r$ = "setbits_" + str2(typ AND 511) + "("
r$ = "setbits(" + str2(typ AND 511) + ","
r$ = r$ + "(unsigned char*)(" + n$ + "[0])" + ",tmp_long,"
PRINT #12, "tmp_long=" + a$ + ";"
IF method = 0 THEN
l$ = "if (!new_error) " + r$ + evaluatetotyp(e$, typ) + ");"
ELSE
l$ = "if (!new_error) " + r$ + e$ + ");"
END IF
PRINT #12, l$
tlayout$=tl$
EXIT SUB
ELSE
t$ = ""
IF (typ AND ISFLOAT) THEN
 IF (typ AND 511) = 32 THEN t$ = "float"
 IF (typ AND 511) = 64 THEN t$ = "double"
 IF (typ AND 511) = 256 THEN t$ = "long double"
ELSE
 IF (typ AND ISUNSIGNED) THEN
 IF (typ AND 511) = 8 THEN t$ = "uint8"
 IF (typ AND 511) = 16 THEN t$ = "uint16"
 IF (typ AND 511) = 32 THEN t$ = "uint32"
 IF (typ AND 511) = 64 THEN t$ = "uint64"
 ELSE
 IF (typ AND 511) = 8 THEN t$ = "int8"
 IF (typ AND 511) = 16 THEN t$ = "int16"
 IF (typ AND 511) = 32 THEN t$ = "int32"
 IF (typ AND 511) = 64 THEN t$ = "int64"
 END IF
END IF
END IF
IF t$ = "" THEN nerror (101)
PRINT #12, "tmp_long=" + a$ + ";"
IF method = 0 THEN
l$ = "if (!new_error) ((" + t$ + "*)(" + n$ + "[0]))[tmp_long]=" + evaluatetotyp(e$, typ) + ";"
ELSE
l$ = "if (!new_error) ((" + t$ + "*)(" + n$ + "[0]))[tmp_long]=" + e$ + ";"
END IF

PRINT #12, l$
tlayout$=tl$
EXIT SUB
END IF 'array

'variable?
IF id.t THEN
r$ = RTRIM$(id.n)
t = id.t
'remove irrelavant flags
IF (t AND ISINCONVENTIONALMEMORY) THEN t = t - ISINCONVENTIONALMEMORY
typ = t

'string variable?
IF (t AND ISSTRING) THEN
IF (t AND ISFIXEDLENGTH) THEN
r$ = scope$ + "STRING" + str2(id.tsize) + "_" + r$
ELSE
r$ = scope$ + "STRING_" + r$
END IF
IF method = 0 THEN e$ = evaluatetotyp(e$, ISSTRING)
PRINT #12, "qbs_set(" + r$ + "," + e$ + ");"
PRINT #12, cleanupstringprocessingcall$ + "0);"
IF arrayprocessinghappened THEN arrayprocessinghappened = 0
tlayout$=tl$
EXIT SUB
END IF

'bit-length variable?
IF (t AND ISOFFSETINBITS) THEN
b = t AND 511
IF (t AND ISUNSIGNED) THEN
r$ = "*" + scope$ + "UBIT" + str2(t AND 511) + "_" + r$
IF method = 0 THEN e$ = evaluatetotyp(e$, 64& + ISUNSIGNED)
l$ = r$ + "=(" + e$ + ")&" + str2(bitmask(b)) + ";"
PRINT #12, l$
ELSE
r$ = "*" + scope$ + "BIT" + str2(t AND 511) + "_" + r$
IF method = 0 THEN e$ = evaluatetotyp(e$, 64&)
l$ = "if ((" + r$ + "=" + e$ + ")&" + str2(2 ^ (b - 1)) + "){"
PRINT #12, l$
'signed bit is set
l$ = r$ + "|=" + str2(bitmaskinv(b)) + ";"
PRINT #12, l$
PRINT #12, "}else{"
'signed bit is not set
l$ = r$ + "&=" + str2(bitmask(b)) + ";"
PRINT #12, l$
PRINT #12, "}"
END IF
IF stringprocessinghappened THEN PRINT #12, cleanupstringprocessingcall$ + "0);": stringprocessinghappened = 0
IF arrayprocessinghappened THEN arrayprocessinghappened = 0
tlayout$=tl$
EXIT SUB
END IF

'standard variable?
IF t = BYTETYPE THEN r$ = "*" + scope$ + "BYTE_" + r$: GOTO sref
IF t = UBYTETYPE THEN r$ = "*" + scope$ + "UBYTE_" + r$: GOTO sref
IF t = INTEGERTYPE THEN r$ = "*" + scope$ + "INTEGER_" + r$: GOTO sref
IF t = UINTEGERTYPE THEN r$ = "*" + scope$ + "UINTEGER_" + r$: GOTO sref
IF t = LONGTYPE THEN r$ = "*" + scope$ + "LONG_" + r$: GOTO sref
IF t = ULONGTYPE THEN r$ = "*" + scope$ + "ULONG_" + r$: GOTO sref
IF t = INTEGER64TYPE THEN r$ = "*" + scope$ + "INTEGER64_" + r$: GOTO sref
IF t = UINTEGER64TYPE THEN r$ = "*" + scope$ + "UINTEGER64_" + r$: GOTO sref
IF t = SINGLETYPE THEN r$ = "*" + scope$ + "SINGLE_" + r$: GOTO sref
IF t = DOUBLETYPE THEN r$ = "*" + scope$ + "DOUBLE_" + r$: GOTO sref
IF t = FLOATTYPE THEN r$ = "*" + scope$ + "FLOAT_" + r$: GOTO sref
sref:
t2 = t - ISPOINTER
IF method = 0 THEN e$ = evaluatetotyp(e$, t2)
l$ = r$ + "=" + e$ + ";"
PRINT #12, l$
IF stringprocessinghappened THEN PRINT #12, cleanupstringprocessingcall$ + "0);": stringprocessinghappened = 0
IF arrayprocessinghappened THEN arrayprocessinghappened = 0
tlayout$=tl$
EXIT SUB
END IF 'variable

tlayout$=tl$
END SUB

FUNCTION str2$ (v AS LONG)
str2$ = LTRIM$(RTRIM$(STR$(v)))
END FUNCTION

FUNCTION str2u64$ (v~&&)
str2u64$ = LTRIM$(RTRIM$(STR$(v~&&)))
END FUNCTION

FUNCTION str2i64$ (v&&)
str2i64$ = LTRIM$(RTRIM$(STR$(v&&)))
END FUNCTION

FUNCTION typ2ctyp$ (t AS LONG, tstr AS STRING)
ctyp$ = ""
'typ can be passed as either: (the unused value is ignored)
'i. as a typ value in t
'ii. as a typ symbol (eg. "~%") in tstr
'iii. as a typ name (eg. _UNSIGNED INTEGER) in tstr
IF tstr$ = "" THEN
IF (t AND ISARRAY) THEN EXIT FUNCTION 'cannot return array types
IF (t AND ISSTRING) THEN typ2ctyp$ = "qbs": EXIT FUNCTION
b = t AND 511
IF (t AND ISUDT) THEN typ2ctyp$="void": EXIT FUNCTION
IF (t AND ISOFFSETINBITS) THEN
IF b <= 32 THEN ctyp$ = "int32" ELSE ctyp$ = "int64"
IF (t AND ISUNSIGNED) THEN ctyp$ = "u" + ctyp$
typ2ctyp$ = ctyp$: EXIT FUNCTION
END IF
IF (t AND ISFLOAT) THEN
 IF b = 32 THEN ctyp$ = "float"
 IF b = 64 THEN ctyp$ = "double"
 IF b = 256 THEN ctyp$ = "long double"
ELSE
 IF b = 8 THEN ctyp$ = "int8"
 IF b = 16 THEN ctyp$ = "int16"
 IF b = 32 THEN ctyp$ = "int32"
 IF b = 64 THEN ctyp$ = "int64"
 IF (t AND ISUNSIGNED) THEN ctyp$ = "u" + ctyp$
END IF
typ2ctyp$ = ctyp$: EXIT FUNCTION
END IF

ts$ = tstr$
'is ts$ a symbol?
IF ts$ = "!" THEN ctyp$ = "float"
IF ts$ = "#" THEN ctyp$ = "double"
IF ts$ = "##" THEN ctyp$ = "long double"
IF LEFT$(ts$, 1) = "~" THEN unsgn = 1: ts$ = RIGHT$(ts$, 1)
IF LEFT$(ts$, 1) = "`" THEN
n$ = RIGHT$(ts$, LEN(ts$) - 1)
b = 1
IF n$ <> "" THEN
IF isuinteger(n$) = 0 THEN qb64error "Invalid index after _BIT type"
b = VAL(n$)
IF b > 57 THEN qb64error "Invalid index after _BIT type"
END IF
IF b <= 32 THEN ctyp$ = "int32" ELSE ctyp$ = "int64"
IF unsgn THEN ctyp$ = "u" + ctyp$
typ2ctyp$ = ctyp$: EXIT FUNCTION
END IF
IF ts$ = "%%" THEN ctyp$ = "int8"
IF ts$ = "%" THEN ctyp$ = "int16"
IF ts$ = "&" THEN ctyp$ = "int32"
IF ts$ = "&&" THEN ctyp$ = "int64"
IF ctyp$ <> "" THEN
IF unsgn THEN ctyp$ = "u" + ctyp$
typ2ctyp$ = ctyp$: EXIT FUNCTION
END IF

qb64error "Invalid type"

END FUNCTION

FUNCTION type2symbol$ (typ$)
t$ = typ$
FOR i = 1 TO LEN(t$)
IF MID$(t$, i, 1) = sp THEN MID$(t$, i, 1) = " "
NEXT
e$ = "Cannot convert type (" + typ$ + ") to symbol"
t2$ = "_UNSIGNED _BIT": s$ = "~`1": IF LEFT$(t$, LEN(t2$)) = t2$ THEN GOTO t2sfound
t2$ = "_UNSIGNED _BYTE": s$ = "~%%": IF LEFT$(t$, LEN(t2$)) = t2$ THEN GOTO t2sfound
t2$ = "_UNSIGNED INTEGER": s$ = "~%": IF LEFT$(t$, LEN(t2$)) = t2$ THEN GOTO t2sfound
t2$ = "_UNSIGNED LONG": s$ = "~&": IF LEFT$(t$, LEN(t2$)) = t2$ THEN GOTO t2sfound
t2$ = "_UNSIGNED _INTEGER64": s$ = "~&&": IF LEFT$(t$, LEN(t2$)) = t2$ THEN GOTO t2sfound
t2$ = "_BIT": s$ = "`1": IF LEFT$(t$, LEN(t2$)) = t2$ THEN GOTO t2sfound
t2$ = "_BYTE": s$ = "%%": IF LEFT$(t$, LEN(t2$)) = t2$ THEN GOTO t2sfound
t2$ = "INTEGER": s$ = "%": IF LEFT$(t$, LEN(t2$)) = t2$ THEN GOTO t2sfound
t2$ = "LONG": s$ = "&": IF LEFT$(t$, LEN(t2$)) = t2$ THEN GOTO t2sfound
t2$ = "_INTEGER64": s$ = "&&": IF LEFT$(t$, LEN(t2$)) = t2$ THEN GOTO t2sfound
t2$ = "SINGLE": s$ = "!": IF LEFT$(t$, LEN(t2$)) = t2$ THEN GOTO t2sfound
t2$ = "DOUBLE": s$ = "#": IF LEFT$(t$, LEN(t2$)) = t2$ THEN GOTO t2sfound
t2$ = "_FLOAT": s$ = "##": IF LEFT$(t$, LEN(t2$)) = t2$ THEN GOTO t2sfound
t2$ = "STRING": s$ = "$": IF LEFT$(t$, LEN(t2$)) = t2$ THEN GOTO t2sfound
qb64error e$
t2sfound:
type2symbol$ = s$
IF LEN(t2$) <> LEN(t$) THEN
IF s$ <> "*" AND s$ <> "~`1" AND s$ <> "`1" THEN qb64error e$
t$ = RIGHT$(t$, LEN(t$) - LEN(t2$))
IF LEFT$(t$, 3) <> " * " THEN qb64error e$
t$ = RIGHT$(t$, LEN(t$) - 3)
IF isuinteger(t$) = 0 THEN qb64error e$
v = VAL(t$)
IF v = 0 THEN qb64error e$
IF s$ <> "$" AND v > 56 THEN qb64error e$
IF s$ = "$" THEN
s$ = s$ + str2$(v)
ELSE
s$ = LEFT$(s$, LEN(s$) - 1) + str2$(v)
END IF
type2symbol$ = s$
END IF
END FUNCTION

'Strips away bits/indentifiers which make locating a variables source difficult
FUNCTION typecomp (typ)
typ2 = typ
IF (typ2 AND ISINCONVENTIONALMEMORY) THEN typ2 = typ2 - ISINCONVENTIONALMEMORY
typecomp = typ2
END FUNCTION

FUNCTION typname2typ& (t2$)
typname2typsize=0 'the default

t$ = t2$

'symbol?
ts$ = t$
IF ts$ = "$" THEN typname2typ& = STRINGTYPE: EXIT FUNCTION
IF ts$ = "!" THEN typname2typ& = SINGLETYPE: EXIT FUNCTION
IF ts$ = "#" THEN typname2typ& = DOUBLETYPE: EXIT FUNCTION
IF ts$ = "##" THEN typname2typ& = FLOATTYPE: EXIT FUNCTION

'fixed length string?
IF LEFT$(ts$, 1) = "$" THEN
n$ = RIGHT$(ts$, LEN(ts$) - 1)
IF isuinteger(n$) = 0 THEN qb64error "Invalid index after STRING * type"
b = VAL(n$)
IF b = 0 THEN qb64error "Invalid index after STRING * type"
typname2typsize = b
typname2typ& = STRINGTYPE + ISFIXEDLENGTH
EXIT FUNCTION
END IF

'unsigned?
IF LEFT$(ts$, 1) = "~" THEN unsgn = 1: ts$ = RIGHT$(ts$, len(ts$)-1)

'bit-type?
IF LEFT$(ts$, 1) = "`" THEN
n$ = RIGHT$(ts$, LEN(ts$) - 1)
b = 1
IF n$ <> "" THEN
IF isuinteger(n$) = 0 THEN qb64error "Invalid index after _BIT type"
b = VAL(n$)
IF b > 56 THEN qb64error "Invalid index after _BIT type"
END IF
IF unsgn THEN typname2typ& = UBITTYPE + (b - 1) ELSE typname2typ& = BITTYPE + (b - 1)
EXIT FUNCTION
END IF

t=0
IF ts$ = "%%" THEN t = BYTETYPE
IF ts$ = "%" THEN t = INTEGERTYPE
IF ts$ = "&" THEN t = LONGTYPE
IF ts$ = "&&" THEN t = INTEGER64TYPE
IF t THEN
IF unsgn THEN t = t + ISUNSIGNED
typname2typ& = t: EXIT FUNCTION
END IF
'not a valid symbol

'type name?
FOR i = 1 TO LEN(t$)
IF MID$(t$, i, 1) = sp THEN MID$(t$, i, 1) = " "
NEXT
IF t$ = "STRING" THEN typname2typ& = STRINGTYPE: EXIT FUNCTION

IF LEFT$(t$, 9) = "STRING * " THEN
n$ = RIGHT$(t$, LEN(t$) - 9)
IF isuinteger(n$) = 0 THEN qb64error "Invalid index after STRING * type"
b = VAL(n$)
IF b = 0 THEN qb64error "Invalid index after STRING * type"
typname2typsize = b
typname2typ& = STRINGTYPE + ISFIXEDLENGTH
EXIT FUNCTION
END IF

IF t$ = "SINGLE" THEN typname2typ& = SINGLETYPE: EXIT FUNCTION
IF t$ = "DOUBLE" THEN typname2typ& = DOUBLETYPE: EXIT FUNCTION
IF t$ = "_FLOAT" THEN typname2typ& = FLOATTYPE: EXIT FUNCTION
IF LEFT$(t$, 10) = "_UNSIGNED " THEN u = 1: t$ = RIGHT$(t$, LEN(t$) - 10)
IF LEFT$(t$, 4) = "_BIT" THEN
 IF t$="_BIT" then
  if u then typname2typ& = UBITTYPE else typname2typ& = BITTYPE
  EXIT FUNCTION
 end if
 IF LEFT$(t$, 7) <> "_BIT * " THEN qb64error "Expected _BIT * number"
 n$ = RIGHT$(t$, LEN(t$) - 7)
 IF isuinteger(n$) = 0 THEN qb64error "Invalid size after _BIT *"
 b = VAL(n$)
 IF b = 0 or b>56 THEN qb64error "Invalid size after _BIT *"
 t=BITTYPE-1+b: if u then t=t+ISUNSIGNED
 typname2typ& = t
 EXIT FUNCTION
END IF

t = 0
IF t$ = "_BYTE" THEN t = BYTETYPE
IF t$ = "INTEGER" THEN t = INTEGERTYPE
IF t$ = "LONG" THEN t = LONGTYPE
IF t$ = "_INTEGER64" THEN t = INTEGER64TYPE
IF t THEN
IF u THEN t = t + ISUNSIGNED
typname2typ& = t
EXIT FUNCTION
END IF
IF u THEN EXIT FUNCTION '_UNSIGNED (nothing)

'UDT?
for i=1 to lasttype
if t$=rtrim$(udtxname(i)) then
typname2typ&=ISUDT+ISPOINTER+i
exit function
end if
next

'return 0 (failed)
END FUNCTION

FUNCTION uniquenumber&
uniquenumbern = uniquenumbern + 1
uniquenumber& = uniquenumbern
END FUNCTION

FUNCTION validlabel (LABEL2$)
validlabel = 0
IF LEN(LABEL2$) = 0 THEN EXIT FUNCTION
clabel$=label2$
label$=ucase$(label2$)

n=numelements(label$)

if n=1 then

'any internal SUB which can be called with no parameters cannot be a label
IF LABEL$ = "BEEP" THEN EXIT FUNCTION
IF LABEL$ = "COLOR" THEN EXIT FUNCTION
IF LABEL$ = "CLS" THEN EXIT FUNCTION
IF LABEL$ = "CLEAR" THEN EXIT FUNCTION
IF LABEL$ = "CLOSE" THEN EXIT FUNCTION
IF LABEL$ = "DO" THEN EXIT FUNCTION
IF LABEL$ = "ELSE" THEN EXIT FUNCTION
IF LABEL$ = "ELSEIF" THEN EXIT FUNCTION
IF LABEL$ = "END" THEN EXIT FUNCTION
IF LABEL$ = "FILES" THEN EXIT FUNCTION
IF LABEL$ = "LOCATE" THEN EXIT FUNCTION
IF LABEL$ = "LOCAL" THEN EXIT FUNCTION
IF LABEL$ = "LOOP" THEN EXIT FUNCTION
IF LABEL$ = "NEXT" THEN EXIT FUNCTION
IF LABEL$ = "PRINT" THEN EXIT FUNCTION
IF LABEL$ = "PALETTE" THEN EXIT FUNCTION
IF LABEL$ = "RANDOMIZE" THEN EXIT FUNCTION
IF LABEL$ = "RESTORE" THEN EXIT FUNCTION
IF LABEL$ = "RESUME" THEN EXIT FUNCTION
IF LABEL$ = "RETURN" THEN EXIT FUNCTION
IF LABEL$ = "RUN" THEN EXIT FUNCTION
IF LABEL$ = "SCREEN" THEN EXIT FUNCTION
IF LABEL$ = "SHELL" THEN EXIT FUNCTION
IF LABEL$ = "SIGNAL" THEN EXIT FUNCTION
IF LABEL$ = "SLEEP" THEN EXIT FUNCTION
IF LABEL$ = "SYSTEM" THEN EXIT FUNCTION
IF LABEL$ = "TRON" THEN EXIT FUNCTION
IF LABEL$ = "TROFF" THEN EXIT FUNCTION
IF LABEL$ = "RESET" THEN EXIT FUNCTION
IF LABEL$ = "WEND" THEN EXIT FUNCTION
IF LABEL$ = "WIDTH" THEN EXIT FUNCTION
IF LABEL$ = "WINDOW" THEN EXIT FUNCTION

'Numeric label?
	'quasi numbers are possible, but:
	'a) They may only have one decimal place
	'b) They must be typed with the exact same characters to match
t$ = LABEL$
'numeric?
a=asc(t$)
if (a>=48 and a<=57) or a=46 then
if a=46 then dp=1
'remove possible E/D/F+0 added by autoformatting
for x=2 to len(t$)
a=asc(mid$(t$,x,1))
if a=46 then dp=dp+1
if a=68 or a=69 or a=70 then 'D/E/F
if mid$(t$,x+1,2)="+0" then exit for
exit function
end if
if a=44 then exit for 'skip auto-layout info
if (a<48 or a>57) and a<>46 then exit function 'not numeric
next x
if dp>1 then EXIT FUNCTION 'too many decimal places
t$=left$(t$,x-1)
tlayout$=t$
'change dp to "p"
i = INSTR(t$, "."): IF i THEN MID$(t$, i, 1) = "p"
label2$=t$
validlabel = 1
exit function
end if 'numeric

end if 'n=1

'Alpha-numeric label?
'Build label

'structure check (???.???.???.???)
if (n and 1)=0 then exit function 'must be an odd number of elements
for nx=2 to n-1 step 2
a$=getelement$(label2$,nx)
if a$<>"." then exit function 'every 2nd element must be a period
next

'cannot begin with numeric
c=asc(clabel$): IF c >= 48 AND c <= 57 THEN exit function

'elements check
label3$=""
for nx=1 to n step 2
label$=getelement$(clabel$,nx)

'alpha-numeric?
FOR x = 1 TO LEN(LABEL$)
if alphanumeric(asc(label$,x))=0 then exit function
next

'build label
if label3$="" then label3$=ucase$(label$):tlayout$=label$ else label3$=label3$+fix046$+ucase$(label$):tlayout$=tlayout$+"."+label$
next nx

validlabel = 1
label2$=label3$

END FUNCTION

SUB xend

'1. locate bottomline,1
'PRINT #12, "display_page->cursor_y=print_holding_cursor=0; qbg_cursor_x=1; qbg_cursor_y=qbg_height_in_characters;"

'2. print a message in the screen's width
'PRINT #12, "if (qbg_width_in_characters==80){"
'PRINT #12, "qbs_print(qbs_new_txt(" + CHR$(34) + "Press any key to continue" + SPACE$(80 - 25) + CHR$(34) + "),0);"
'PRINT #12, "}else{"
'PRINT #12, "qbs_print(qbs_new_txt(" + CHR$(34) + "Press any key to continue" + SPACE$(40 - 25) + CHR$(34) + "),0);"
'PRINT #12, "}"

'3. wait for a key to be pressed
'PRINT #12, "do{"
'PRINT #12, "SDL_Delay(0);"
'PRINT #12, "if (stop_program) end();"
'PRINT #12, "}while(qbs_cleanup(qbs_tmp_base,qbs_equal(qbs_inkey(),
'            qbs_new_txt(" + CHR$(34) + CHR$(34) + "))));"
'4. quit
'PRINT #12, "close_program=1;"
'PRINT #12, "end();"
PRINT #12, "sub_end();"
END SUB

SUB xfileprint (a$, ca$, n)
u$=str2$(uniquenumber)
PRINT #12, "tab_spc_cr_size=2;"
IF n = 2 THEN nerror (52)
a3$ = ""
b = 0
FOR i = 3 TO n
a2$ = getelement$(ca$, i)
IF a2$ = "(" THEN b = b + 1
IF a2$ = ")" THEN b = b - 1
IF a2$ = "," AND b = 0 THEN
IF a3$ = "" THEN nerror (53)
GOTO printgotfn
END IF
IF a3$ = "" THEN a3$ = a2$ ELSE a3$ = a3$ + sp + a2$
NEXT
nerror (54)
printgotfn:
e$=fixoperationorder$(a3$)
l$="PRINT"+sp+"#"+sp2+tlayout$+sp2+","
e$ = evaluatetotyp(e$, 64&)
PRINT #12, "tmp_fileno=" + e$ + ";"
PRINT #12, "if (new_error) goto skip"+u$+";"
i = i + 1

'PRINT USING? (file)
if n>=i then
if getelement(a$, i)="USING" then
'get format string
fpujump:
l$=l$+sp+"USING"
e$="": b=0: puformat$=""
FOR i = i+1 TO n
a2$ = getelement(ca$, i)
IF a2$ = "(" THEN b = b + 1
IF a2$ = ")" THEN b = b - 1
IF b = 0 THEN
if a2$= "," then qb64error "Expected PRINT USING #filenumber, formatstring ; ..."
IF a2$ = ";" THEN
e$ = fixoperationorder$(e$)
l$=l$+sp+tlayout$+sp2+";"
e$ = evaluate(e$, typ)
IF (typ AND ISREFERENCE) THEN e$ = refer(e$, typ, 0)
IF (typ AND ISSTRING) = 0 THEN qb64error "Expected PRINT USING #filenumber, formatstring ; ..."
puformat$=e$
exit for
end if ';
end if 'b
IF len(e$) THEN e$ = e$ + sp + a2$ ELSE e$ = a2$
next
if puformat$="" then qb64error "Expected PRINT USING #filenumber, formatstring ; ..."
if i=n then qb64error "Expected PRINT USING #filenumber, formatstring ; ..."
'create build string
PRINT #12, "tqbs=qbs_new(0,0);"
'set format start/index variable
PRINT #12, "tmp_long=0;"'scan format from beginning
'create string to hold format in for multiple references
puf$="print_using_format"+u$
IF subfunc = "" THEN
PRINT #13, "static qbs *"+puf$+";"
ELSE
PRINT #13, "qbs *"+puf$+";"
END IF
PRINT #12, puf$+"=qbs_new(0,0); qbs_set("+puf$+","+puformat$+");"
PRINT #12, "if (new_error) goto skip"+u$+";"
'print expressions
b = 0
e$ = ""
last = 0
FOR i = i+1 TO n
a2$ = getelement(ca$, i)
IF a2$ = "(" THEN b = b + 1
IF a2$ = ")" THEN b = b - 1
IF b = 0 THEN
IF a2$ = ";" OR a2$ = "," THEN
fprintulast:
e$ = fixoperationorder$(e$)
if last then l$=l$+sp+tlayout$ else l$=l$+sp+tlayout$+sp2+a2$
e$ = evaluate(e$, typ)
IF (typ AND ISREFERENCE) THEN e$ = refer(e$, typ, 0)
IF typ AND ISSTRING THEN
PRINT #12, "tmp_long=print_using("+puf$+",tmp_long,tqbs,"+e$+");"
else 'not a string
IF typ AND ISFLOAT THEN
 if (typ and 511)=32 then PRINT #12, "tmp_long=print_using_single("+puf$+","+e$+",tmp_long,tqbs);"
 if (typ and 511)=64 then PRINT #12, "tmp_long=print_using_double("+puf$+","+e$+",tmp_long,tqbs);"
 if (typ and 511)>64 then PRINT #12, "tmp_long=print_using_float("+puf$+","+e$+",tmp_long,tqbs);"
else
 if ((typ and 511)=64) and (typ and ISUNSIGNED)<>0 then
  PRINT #12, "tmp_long=print_using_uinteger64("+puf$+","+e$+",tmp_long,tqbs);"
 else
  PRINT #12, "tmp_long=print_using_integer64("+puf$+","+e$+",tmp_long,tqbs);"
 end if
end if
end if 'string/not string
PRINT #12, "if (new_error) goto skip_pu"+u$+";"
e$ = ""
IF last THEN EXIT FOR
GOTO fprintunext
END IF
END IF
IF len(e$) THEN e$ = e$ + sp + a2$ ELSE e$ = a2$
fprintunext:
NEXT
IF e$ <> "" THEN a2$ = "": last = 1: GOTO fprintulast
PRINT #12, "skip_pu"+u$+":"
'check for errors
print #12, "if (new_error){"
print #12, "g_tmp_long=new_error; new_error=0; sub_file_print(tmp_fileno,tqbs,0,0,0); new_error=g_tmp_long;"
print #12, "}else{"
if a2$="," or a2$=";" then nl=0 else nl=1 'note: a2$ is set to the last element of a$
PRINT #12, "sub_file_print(tmp_fileno,tqbs,0,0,"+str2$(nl)+");"
print #12, "}"
print #12, "qbs_free(tqbs);"
print #12, "qbs_free("+puf$+");"
PRINT #12, "skip"+u$+":"
PRINT #12, cleanupstringprocessingcall$ + "0);"
PRINT #12, "tab_spc_cr_size=1;"
tlayout$=l$
exit sub
end if
end if
'end of print using code

IF i > n THEN
PRINT #12, "sub_file_print(tmp_fileno,nothingstring,0,0,1);"
GOTO printblankline
END IF
b = 0
e$ = ""
last = 0
FOR i = i TO n
a2$ = getelement(ca$, i)
IF a2$ = "(" THEN b = b + 1
IF a2$ = ")" THEN b = b - 1
IF b = 0 THEN
IF a2$ = ";" OR a2$ = "," or ucase$(a2$)="USING" THEN
printfilelast:

if ucase$(a2$)="USING" then
if e$<>"" then gotofpu=1 else goto fpujump
end if

IF a2$ = "," THEN usetab = 1 ELSE usetab = 0
IF last = 1 THEN newline = 1 ELSE newline = 0
extraspace = 0

if len(e$) then
ebak$ = e$
pnrtnum=0
printfilenumber:
e$ = fixoperationorder$(e$)
if pnrtnum=0 then
if last then l$=l$+sp+tlayout$ else l$=l$+sp+tlayout$+sp2+a2$
end if
e$ = evaluate(e$, typ)
IF (typ AND ISSTRING) = 0 THEN
e$ = "STR$" + sp + "(" + sp + ebak$ + sp + ")"
extraspace = 1
pnrtnum=1
GOTO printfilenumber 'force re-evaluation
END IF
IF (typ AND ISREFERENCE) THEN e$ = refer(e$, typ, 0)
'format: string, (1/0) extraspace, (1/0) tab, (1/0)begin a new line
PRINT #12, "sub_file_print(tmp_fileno," + e$ + ","; extraspace; ","; usetab; ","; newline; ");"
else 'len(e$)=0
if usetab then PRINT #12, "sub_file_print(tmp_fileno,nothingstring,0,1,0);"
end if 'len(e$)
PRINT #12, "if (new_error) goto skip"+u$+";"

e$ = ""
if gotofpu then goto fpujump
IF last THEN EXIT FOR
GOTO printfilenext
END IF ', or ;
END IF 'b=0
IF e$ <> "" THEN e$ = e$ + sp + a2$ ELSE e$ = a2$
printfilenext:
NEXT
IF e$ <> "" THEN a2$ = "": last = 1: GOTO printfilelast
printblankline:
PRINT #12, "skip"+u$+":"
PRINT #12, cleanupstringprocessingcall$ + "0);"
PRINT #12, "tab_spc_cr_size=1;"
tlayout$=l$
END SUB

SUB xfilewrite (ca$, n)
l$="WRITE"+sp+"#"
u$=str2$(uniquenumber)
PRINT #12, "tab_spc_cr_size=2;"
IF n = 2 THEN qb64error "Expected # ..."
a3$ = ""
b = 0
FOR i = 3 TO n
a2$ = getelement$(ca$, i)
IF a2$ = "(" THEN b = b + 1
IF a2$ = ")" THEN b = b - 1
IF a2$ = "," AND b = 0 THEN
IF a3$ = "" THEN nerror (53)
GOTO writegotfn
END IF
IF a3$ = "" THEN a3$ = a2$ ELSE a3$ = a3$ + sp + a2$
NEXT
nerror (54)
writegotfn:
e$=fixoperationorder$(a3$)
l$=l$+sp2+tlayout$+sp2+","
e$ = evaluatetotyp(e$, 64&)
PRINT #12, "tmp_fileno=" + e$ + ";"
print #12, "if (new_error) goto skip"+u$+";"
i = i + 1
IF i > n THEN
PRINT #12, "sub_file_print(tmp_fileno,nothingstring,0,0,1);"
GOTO writeblankline
END IF
b = 0
e$ = ""
last = 0
FOR i = i TO n
a2$ = getelement(ca$, i)
IF a2$ = "(" THEN b = b + 1
IF a2$ = ")" THEN b = b - 1
IF b = 0 THEN
IF a2$ = "," THEN
writefilelast:
IF last = 1 THEN newline = 1 ELSE newline = 0
ebak$ = e$
reevaled = 0
writefilenumber:
e$ = fixoperationorder$(e$)
if reevaled = 0 then
l$=l$+sp+tlayout$
if last=0 then l$=l$+sp2+","
end if
e$ = evaluate(e$, typ)
IF reevaled = 0 THEN
IF (typ AND ISSTRING) = 0 THEN
e$ = "LTRIM$" + sp + "(" + sp + "STR$" + sp + "(" + sp + ebak$ + sp + ")" + sp + ")"
IF last = 0 THEN e$ = e$ + sp + "+" + sp + CHR$(34) + "," + CHR$(34) + ",1"
reevaled = 1
GOTO writefilenumber 'force re-evaluation
ELSE
e$ = CHR$(34) + "\042" + CHR$(34) + ",1" + sp + "+" + sp + ebak$ + sp + "+" + sp + CHR$(34) + "\042" + CHR$(34) + ",1"
IF last = 0 THEN e$ = e$ + sp + "+" + sp + CHR$(34) + "," + CHR$(34) + ",1"
reevaled = 1
GOTO writefilenumber 'force re-evaluation
END IF
END IF
IF (typ AND ISREFERENCE) THEN e$ = refer(e$, typ, 0)
'format: string, (1/0) extraspace, (1/0) tab, (1/0)begin a new line
PRINT #12, "sub_file_print(tmp_fileno," + e$ + ",0,0,"; newline; ");"
print #12, "if (new_error) goto skip"+u$+";"
e$ = ""
IF last THEN EXIT FOR
GOTO writefilenext
END IF ',
END IF 'b=0
IF e$ <> "" THEN e$ = e$ + sp + a2$ ELSE e$ = a2$
writefilenext:
NEXT
IF e$ <> "" THEN a2$ = ",": last = 1: GOTO writefilelast
writeblankline:
'print #12, "}"'new_error
print #12, "skip"+u$+":"
PRINT #12, cleanupstringprocessingcall$ + "0);"
PRINT #12, "tab_spc_cr_size=1;"
layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$
END SUB

SUB xgosub (ca$, n&)
a2$ = getelement(ca$, 2)
IF validlabel(a2$) = 0 THEN nerror (65)
l$="GOSUB"+sp+tlayout$
layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$
        'note: This code fragment also used by ON ... GOTO/GOSUB
        'assume label is reachable (revise)
        PRINT #12, "return_point[next_return_point++]=" + str2(gosubid) + ";"
        PRINT #12, "if (next_return_point>=return_points) more_return_points();"
        PRINT #12, "goto LABEL_" + a2$ + ";"
        'add return point jump
        PRINT #15, "case " + str2(gosubid) + ":"
        PRINT #15, "goto RETURN_" + str2(gosubid) + ";"
        PRINT #15, "break;"
        PRINT #12, "RETURN_" + str2(gosubid) + ":;"
        gosubid = gosubid + 1
END SUB

SUB xongotogosub (a$, ca$, n)
IF n < 4 THEN qb64error "Expected ON expression GOTO/GOSUB label,label,..."
l$="ON"
b = 0
FOR i = 2 TO n
e2$ = getelement$(a$, i)
IF e2$ = "(" THEN b = b + 1
IF e2$ = ")" THEN b = b - 1
IF e2$ = "GOTO" OR e2$ = "GOSUB" THEN EXIT FOR
NEXT
IF i >= n or i=2 THEN qb64error "Expected ON expression GOTO/GOSUB label,label,..."
e$=getelements$(ca$,2,i-1)

g = 0: IF e2$ = "GOSUB" THEN g = 1
e$ = fixoperationorder(e$)
l$=l$+sp+tlayout$
e$ = evaluate(e$, typ)
IF (typ AND ISREFERENCE) THEN e$ = refer(e$, typ, 0)
IF (typ AND ISSTRING) THEN qb64error "Expected numeric expression"
IF (typ AND ISFLOAT) THEN
e$ = "qbr_float_to_long(" + e$ + ")"
END IF
l$=l$+sp+e2$
u$ = str2$(uniquenumber)
PRINT #13, "static long ongo_" + u$ + "=0;"
PRINT #12, "ongo_" + u$ + "=" + e$ + ";"
ln = 1
labelwaslast = 0
FOR i = i + 1 TO n
e$ = getelement$(ca$, i)
IF e$ = "," THEN
l$=l$+sp2+","
IF i = n THEN qb64error "Trailing , invalid"
ln = ln + 1
labelwaslast = 0
ELSE
IF labelwaslast THEN qb64error "Expected ,"
IF validlabel(e$) = 0 THEN nerror (36)
l$=l$+sp+tlayout$
IF g THEN 'gosub
lb$=e$
PRINT #12, "if (ongo_" + u$ + "==" + str2$(ln) + "){"
        'note: This code fragment also used by ON ... GOTO/GOSUB
        'assume label is reachable (revise)
        PRINT #12, "return_point[next_return_point++]=" + str2(gosubid) + ";"
        PRINT #12, "if (next_return_point>=return_points) more_return_points();"
        PRINT #12, "goto LABEL_" + lb$ + ";"
        'add return point jump
        PRINT #15, "case " + str2(gosubid) + ":"
        PRINT #15, "goto RETURN_" + str2(gosubid) + ";"
        PRINT #15, "break;"
        PRINT #12, "RETURN_" + str2(gosubid) + ":;"
        gosubid = gosubid + 1
PRINT #12, "goto ongo_" + u$ + "_skip;"
PRINT #12, "}"
ELSE 'goto
PRINT #12, "if (ongo_" + u$ + "==" + str2$(ln) + ") goto LABEL_" + e$ + ";"
END IF
labelwaslast = 1
END IF
NEXT
PRINT #12, "if (ongo_" + u$ + "<0) error(5);"
IF g = 1 THEN PRINT #12, "ongo_" + u$ + "_skip:;"
layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$
END SUB

SUB xprint (a$, ca$, n)
u$=str2$(uniquenumber)

l$="PRINT"

'PRINT USING?
if n>=2 then
if getelement(a$, 2)="USING" then
'get format string
i=3
pujump:
l$=l$+sp+"USING"
e$="": b=0: puformat$=""
FOR i = i TO n
a2$ = getelement(ca$, i)
IF a2$ = "(" THEN b = b + 1
IF a2$ = ")" THEN b = b - 1
IF b = 0 THEN
if a2$= "," then qb64error "Expected PRINT USING formatstring ; ..."
IF a2$ = ";" THEN
e$ = fixoperationorder$(e$)
l$=l$+sp+tlayout$+sp2+";"
e$ = evaluate(e$, typ)
IF (typ AND ISREFERENCE) THEN e$ = refer(e$, typ, 0)
IF (typ AND ISSTRING) = 0 THEN qb64error "Expected PRINT USING formatstring ; ..."
puformat$=e$
exit for
end if ';
end if 'b
IF len(e$) THEN e$ = e$ + sp + a2$ ELSE e$ = a2$
next
if puformat$="" then qb64error "Expected PRINT USING formatstring ; ..."
if i=n then qb64error "Expected PRINT USING formatstring ; ..."
'create build string
PRINT #12, "tqbs=qbs_new(0,0);"
'set format start/index variable
PRINT #12, "tmp_long=0;"'scan format from beginning
'create string to hold format in for multiple references
puf$="print_using_format"+u$
IF subfunc = "" THEN
PRINT #13, "static qbs *"+puf$+";"
ELSE
PRINT #13, "qbs *"+puf$+";"
END IF
PRINT #12, puf$+"=qbs_new(0,0); qbs_set("+puf$+","+puformat$+");"
PRINT #12, "if (new_error) goto skip_pu"+u$+";"
'print expressions
b = 0
e$ = ""
last = 0
FOR i = i+1 TO n
a2$ = getelement(ca$, i)
IF a2$ = "(" THEN b = b + 1
IF a2$ = ")" THEN b = b - 1
IF b = 0 THEN
IF a2$ = ";" OR a2$ = "," THEN
printulast:
e$ = fixoperationorder$(e$)
if last then l$=l$+sp+tlayout$ else l$=l$+sp+tlayout$+sp2+a2$
e$ = evaluate(e$, typ)
IF (typ AND ISREFERENCE) THEN e$ = refer(e$, typ, 0)
IF typ AND ISSTRING THEN
PRINT #12, "tmp_long=print_using("+puf$+",tmp_long,tqbs,"+e$+");"
else 'not a string
IF typ AND ISFLOAT THEN
 if (typ and 511)=32 then PRINT #12, "tmp_long=print_using_single("+puf$+","+e$+",tmp_long,tqbs);"
 if (typ and 511)=64 then PRINT #12, "tmp_long=print_using_double("+puf$+","+e$+",tmp_long,tqbs);"
 if (typ and 511)>64 then PRINT #12, "tmp_long=print_using_float("+puf$+","+e$+",tmp_long,tqbs);"
else
 if ((typ and 511)=64) and (typ and ISUNSIGNED)<>0 then
  PRINT #12, "tmp_long=print_using_uinteger64("+puf$+","+e$+",tmp_long,tqbs);"
 else
  PRINT #12, "tmp_long=print_using_integer64("+puf$+","+e$+",tmp_long,tqbs);"
 end if
end if
end if 'string/not string
PRINT #12, "if (new_error) goto skip_pu"+u$+";"
e$ = ""
IF last THEN EXIT FOR
GOTO printunext
END IF
END IF
IF len(e$) THEN e$ = e$ + sp + a2$ ELSE e$ = a2$
printunext:
NEXT
IF e$ <> "" THEN a2$ = "": last = 1: GOTO printulast
PRINT #12, "skip_pu"+u$+":"
'check for errors
print #12, "if (new_error){"
print #12, "g_tmp_long=new_error; new_error=0; qbs_print(tqbs,0); new_error=g_tmp_long;"
print #12, "}else{"
if a2$="," or a2$=";" then nl=0 else nl=1 'note: a2$ is set to the last element of a$
PRINT #12, "qbs_print(tqbs,"+str2$(nl)+");"
print #12, "}"
print #12, "qbs_free(tqbs);"
print #12, "qbs_free("+puf$+");"
PRINT #12, "skip"+u$+":"
PRINT #12, cleanupstringprocessingcall$ + "0);"
tlayout$=l$
exit sub
end if
end if
'end of print using code

b = 0
e$ = ""
last = 0
FOR i = 2 TO n
a2$ = getelement(ca$, i)
IF a2$ = "(" THEN b = b + 1
IF a2$ = ")" THEN b = b - 1
IF b = 0 THEN
IF a2$ = ";" OR a2$ = "," OR ucase$(a2$)="USING" THEN
printlast:

if ucase$(a2$)="USING" then
if e$<>"" then gotopu=1 else i=i+1: goto pujump
end if

if len(e$) then
ebak$ = e$
pnrtnum=0
printnumber:
e$ = fixoperationorder$(e$)
if pnrtnum=0 then
if last then l$=l$+sp+tlayout$ else l$=l$+sp+tlayout$+sp2+a2$
end if
e$ = evaluate(e$, typ)
IF (typ AND ISSTRING) = 0 THEN
'not a string expresion!
e$ = "STR$" + sp + "(" + sp + ebak$ + sp + ")" + sp + "+" + sp + CHR$(34) + " " + CHR$(34)
pnrtnum=1
GOTO printnumber
END IF
IF (typ AND ISREFERENCE) THEN e$ = refer(e$, typ, 0)
PRINT #12, "tqbs=qbs_new(0,0);"
PRINT #12, "qbs_set(tqbs," + e$ + ");"
PRINT #12, "if (new_error) goto skip"+u$+";"
PRINT #12, "makefit(tqbs);"
PRINT #12, "qbs_print(tqbs,0);"
PRINT #12, "qbs_free(tqbs);"
end if 'len(e$)
IF a2$ = "," THEN PRINT #12, "tab();"
e$ = ""

if gotopu then i=i+1: goto pujump

IF last THEN
PRINT #12, "qbs_print(nothingstring,1);" 'go to new line
EXIT FOR
END IF

GOTO printnext
END IF 'a2$
END IF 'b=0

IF len(e$) THEN e$ = e$ + sp + a2$ ELSE e$ = a2$
printnext:
NEXT
IF len(e$) THEN a2$ = "": last = 1: GOTO printlast
IF n = 1 THEN PRINT #12, "qbs_print(nothingstring,1);"
PRINT #12, "skip"+u$+":"
PRINT #12, cleanupstringprocessingcall$ + "0);"
tlayout$=l$
END SUB




SUB xread (ca$, n)
l$="READ"
IF n = 1 THEN nerror (39)
i = 2
IF i > n THEN nerror (40)
a3$ = ""
b = 0
FOR i = i TO n
a2$ = getelement$(ca$, i)
IF a2$ = "(" THEN b = b + 1
IF a2$ = ")" THEN b = b - 1
IF (a2$ = "," AND b = 0) or i=n THEN
if i=n then 
IF a3$ = "" THEN a3$ = a2$ ELSE a3$ = a3$ + sp + a2$
end if
IF a3$ = "" THEN nerror (41)
e$ = fixoperationorder$(a3$)
l$=l$+sp+tlayout$: if i<>n then l$=l$+sp2+","
e$ = evaluate(e$, t)
IF (t AND ISREFERENCE) = 0 THEN nerror (42)

IF (t AND ISSTRING) THEN
 e$ = refer(e$, t, 0)
 PRINT #12, "sub_read_string(data,&data_offset,data_size," + e$ + ");"
 stringprocessinghappened = 1
ELSE
 'not a string!
 'e$ = refer(e$, t, 1)
 '***INPORTANT NOTE: Modify t for non-0 bit offsets found in UDTs & arrays too
 t2 = t
 IF (t2 AND ISPOINTER) THEN t2 = t2 - ISPOINTER
 IF (t2 AND ISINCONVENTIONALMEMORY) THEN t2 = t2 - ISINCONVENTIONALMEMORY
 IF (t2 AND ISREFERENCE) THEN t2 = t2 - ISREFERENCE
 'PRINT #12, "sub_file_input_value(tmp_long," + str2(t) + "," + e$ + ");"
IF (t AND 511) = 64 THEN
 IF (t AND ISUNSIGNED) THEN
 setrefer e$, t, "func_read_uint64(data,&data_offset,data_size)", 1
 ELSE
 setrefer e$, t, "func_read_int64(data,&data_offset,data_size)", 1
 END IF
ELSE
setrefer e$, t, "func_read_float(data,&data_offset,data_size," + str2(t) + ")", 1
END IF

END IF
IF i = n THEN EXIT FOR
a3$ = "": a2$ = ""
END IF
IF a3$ = "" THEN a3$ = a2$ ELSE a3$ = a3$ + sp + a2$
NEXT
IF stringprocessinghappened THEN PRINT #12, cleanupstringprocessingcall$ + "0);"
layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$
END SUB

SUB xwrite (ca$, n)
l$="WRITE"
u$=str2$(uniquenumber)
IF n = 1 THEN
PRINT #12, "qbs_print(nothingstring,1);"
GOTO writeblankline2
END IF
b = 0
e$ = ""
last = 0
FOR i = 2 TO n
a2$ = getelement(ca$, i)
IF a2$ = "(" THEN b = b + 1
IF a2$ = ")" THEN b = b - 1
IF b = 0 THEN
IF a2$ = "," THEN
writelast:
IF last = 1 THEN newline = 1 ELSE newline = 0
ebak$ = e$
reevaled = 0
writechecked:
e$ = fixoperationorder$(e$)
if reevaled = 0 then
l$=l$+sp+tlayout$
if last=0 then l$=l$+sp2+","
end if
e$ = evaluate(e$, typ)
IF reevaled = 0 THEN
IF (typ AND ISSTRING) = 0 THEN
e$ = "LTRIM$" + sp + "(" + sp + "STR$" + sp + "(" + sp + ebak$ + sp + ")" + sp + ")"
IF last = 0 THEN e$ = e$ + sp + "+" + sp + CHR$(34) + "," + CHR$(34) + ",1"
reevaled = 1
GOTO writechecked 'force re-evaluation
ELSE
e$ = CHR$(34) + "\042" + CHR$(34) + ",1" + sp + "+" + sp + ebak$ + sp + "+" + sp + CHR$(34) + "\042" + CHR$(34) + ",1"
IF last = 0 THEN e$ = e$ + sp + "+" + sp + CHR$(34) + "," + CHR$(34) + ",1"
reevaled = 1
GOTO writechecked 'force re-evaluation
END IF
END IF
IF (typ AND ISREFERENCE) THEN e$ = refer(e$, typ, 0)
'format: string, (1/0) extraspace, (1/0) tab, (1/0)begin a new line
PRINT #12, "qbs_print(" + e$ + ","; newline; ");"
print #12, "if (new_error) goto skip"+u$+";"
e$ = ""
IF last THEN EXIT FOR
GOTO writenext
END IF ',
END IF 'b=0
IF e$ <> "" THEN e$ = e$ + sp + a2$ ELSE e$ = a2$
writenext:
NEXT
IF e$ <> "" THEN a2$ = ",": last = 1: GOTO writelast
writeblankline2:
print #12, "skip"+u$+":"
PRINT #12, cleanupstringprocessingcall$ + "0);"
layoutdone=1: if len(layout$) then layout$=layout$+sp+l$ else layout$=l$
END SUB

function evaluateconst$ (a2$,t as long)
a$=a2$
if debug then print #9, "evaluateconst:in:"+a$


DIM block(1000) AS string
DIM status(1000) AS integer
'0=unprocessed (can be "")
'1=processed
DIM btype(1000) AS long 'for status=1 blocks

'put a$ into blocks
n=numelements(a$)
for i=1 to n
block(i)=getelement$(a$,i)
next

evalconstevalbrack:

'find highest bracket level
l=0
b=0
for i=1 to n
if block(i)="(" then b=b+1
if block(i)=")" then b=b-1
if b>l then l=b
next

'if brackets exist, evaluate that item first
if l then

b=0
e$=""
for i=1 to n

if block(i)=")" then
if b=l then block(i)="": exit for
b=b-1
end if

if b>=l then
if len(e$)=0 then e$=block(i) else e$=e$+sp+block(i)
block(i)=""
end if

if block(i)="(" then
b=b+1
if b=l then i2=i: block(i)=""
end if

next i

status(i)=1
block(i)=evaluateconst$(e$,btype(i))
goto evalconstevalbrack

end if 'l

'linear equation remains with some pre-calculated & non-pre-calc blocks

'problem: type QBASIC assumes and type required to store calc. value may
'         differ dramatically. in qbasic, this would have caused an overflow,
'         but in qb64 it MUST work. eg. 32767% * 32767%
'solution: all interger calc. will be performed using a signed _INTEGER64
'          all float calc. will be performed using a _FLOAT

'convert non-calc block numbers into binary form with QBASIC-like type
for i=1 to n
if status(i)=0 then
if len(block(i)) then

a=asc(block(i))
if (a=45 and len(block(i))>1) or (a>=48 and a<=57) then 'number?

'integers
e$=right$(block(i),3)
if e$="~&&" then btype(i)=UINTEGER64TYPE-ISPOINTER: goto gotconstblkityp
if e$="~%%" then btype(i)=UBYTETYPE-ISPOINTER: goto gotconstblkityp
e$=right$(block(i),2)
if e$="&&" then btype(i)=INTEGER64TYPE-ISPOINTER: goto gotconstblkityp
if e$="%%" then btype(i)=BYTETYPE-ISPOINTER: goto gotconstblkityp
if e$="~%" then btype(i)=UINTEGERTYPE-ISPOINTER: goto gotconstblkityp
if e$="~&" then btype(i)=ULONGTYPE-ISPOINTER: goto gotconstblkityp
e$=right$(block(i),1)
if e$="%" then btype(i)=INTEGERTYPE-ISPOINTER: goto gotconstblkityp
if e$="&" then btype(i)=LONGTYPE-ISPOINTER: goto gotconstblkityp

'ubit-type?
if instr(block(i),"~`") then
x=instr(block(i),"~`")
if x=len(block(i))-1 then block(i)=block(i)+"1"
btype(i)=UBITTYPE-ISPOINTER-1+val(right$(block(i),len(block(i))-x-1))
block(i)=_mk$(_integer64,val(left$(block(i),x-1)))
status(i)=1
goto gotconstblktyp
end if

'bit-type?
if instr(block(i),"`") then
x=instr(block(i),"`")
if x=len(block(i)) then block(i)=block(i)+"1"
btype(i)=BITTYPE-ISPOINTER-1+val(right$(block(i),len(block(i))-x))
block(i)=_mk$(_integer64,val(left$(block(i),x-1)))
status(i)=1
goto gotconstblktyp
end if

'floats
if instr(block(i),"E") then
block(i)=_mk$(_float,val(block(i)))
btype(i)=SINGLETYPE-ISPOINTER
status(i)=1
goto gotconstblktyp
end if
if instr(block(i),"D") then
block(i)=_mk$(_float,val(block(i)))
btype(i)=DOUBLETYPE-ISPOINTER
status(i)=1
goto gotconstblktyp
end if
if instr(block(i),"F") then
block(i)=_mk$(_float,val(block(i)))
btype(i)=FLOATTYPE-ISPOINTER
status(i)=1
goto gotconstblktyp
end if

qb64error "Invalid CONST expression.1"

gotconstblkityp:
block(i)=left$(block(i),len(block(i))-len(e$))
block(i)=_mk$(_integer64,val(block(i)))
status(i)=1
gotconstblktyp:

end if 'a

if a=34 then 'string?
'no changes need to be made to block(i) which is of format "CHARACTERS",size
btype(i)=STRINGTYPE-ISPOINTER
status(i)=1
end if

end if 'len<>0
end if 'status
next

'remove NULL blocks
n2=0
for i=1 to n
if block(i)<>"" then
n2=n2+1
block(n2)=block(i)
status(n2)=status(i)
btype(n2)=btype(i)
end if
next
n=n2

'only one block?
if n=1 then
if status(1)=0 then qb64error "Invalid CONST expression.2"
t=btype(1)
evaluateconst$=block(1)
exit function
end if 'n=1

'evaluate equation (equation cannot contain any STRINGs)

'[negation/not][variable]
e$=block(1)
if status(1)=0 then
if n<>2 then qb64error "Invalid CONST expression.4"
if status(2)=0 then qb64error "Invalid CONST expression.5"
if btype(2) and ISSTRING then qb64error "Invalid CONST expression.6"
o$=block(1)

if o$="" then
 if btype(2) and ISFLOAT then
 r##=-_CV(_FLOAT,block(2))
 evaluateconst$=_MK$(_FLOAT,r##)
 else
 r&&=-_CV(_INTEGER64,block(2))
 evaluateconst$=_MK$(_INTEGER64,r&&) 
 end if
t=btype(2)
exit function
end if

if o$="NOT" then
 if btype(2) and ISFLOAT then
 r&&=_CV(_FLOAT,block(2))
 else
 r&&=_CV(_INTEGER64,block(2))
 end if
r&&=NOT r&&
t=btype(2)
if t and ISFLOAT then t=LONGTYPE-ISPOINTER 'markdown to LONG
evaluateconst$=_MK$(_INTEGER64,r&&)
exit function
end if

qb64error "Invalid CONST expression.7"
end if

'[variable][bool-operator][variable]...

'get first variable
et=btype(1)
ev$=block(1)

i=2

evalconstequ:

'get operator
if i>=n then qb64error "Invalid CONST expression.8"
o$=block(i)
i=i+1
if isoperator(o$)=0 then qb64error "Invalid CONST expression.9"
if i>n then qb64error "Invalid CONST expression.10"

'string/numeric mismatch?
if (btype(i) and ISSTRING)<>(et and ISSTRING) then qb64error "Invalid CONST expression.11"

if et and ISSTRING then
if o$<>"+" then qb64error "Invalid CONST expression.12"
'concat strings
s1$=right$(ev$,len(ev$)-1)
s1$=left$(s1$,instr(s1$,chr$(34))-1)
s1size=val(right$(ev$,len(ev$)-len(s1$)-3))
s2$=right$(block(i),len(block(i))-1)
s2$=left$(s2$,instr(s2$,chr$(34))-1)
s2size=val(right$(block(i),len(block(i))-len(s2$)-3))
ev$=chr$(34)+s1$+s2$+chr$(34)+","+str2$(s1size+s2size)
goto econstmarkedup
end if

'prepare left and right values
if et and ISFLOAT then
linteger=0
l##=_CV(_FLOAT,ev$)
l&&=l##
else
linteger=1
l&&=_CV(_INTEGER64,ev$)
l##=l&&
end if
if btype(i) and ISFLOAT then
rinteger=0
r##=_CV(_FLOAT,block(i))
r&&=r##
else
rinteger=1
r&&=_CV(_INTEGER64,block(i))
r##=r&&
end if

if linteger=1 and rinteger=1 then
if o$="+" then r&&=l&&+r&&: goto econstmarkupi
if o$="-" then r&&=l&&-r&&: goto econstmarkupi
if o$="*" then r&&=l&&*r&&: goto econstmarkupi
if o$="^" then r##=l&&^r&&: goto econstmarkupf
if o$="/" then r##=l&&/r&&: goto econstmarkupf
if o$="\" then r&&=l&&\r&&: goto econstmarkupi
if o$="MOD" then r&&=l&& MOD r&&: goto econstmarkupi
if o$="=" then r&&=l&&=r&&: goto econstmarkupi16
if o$=">" then r&&=l&&>r&&: goto econstmarkupi16
if o$="<" then r&&=l&&<r&&: goto econstmarkupi16
if o$=">=" then r&&=l&&>=r&&: goto econstmarkupi16
if o$="<=" then r&&=l&&<=r&&: goto econstmarkupi16
if o$="<>" then r&&=l&&<>r&&: goto econstmarkupi16
if o$="IMP" then r&&=l&& IMP r&&: goto econstmarkupi
if o$="EQV" then r&&=l&& EQV r&&: goto econstmarkupi
if o$="XOR" then r&&=l&& XOR r&&: goto econstmarkupi
if o$="OR" then r&&=l&& OR r&&: goto econstmarkupi
if o$="AND" then r&&=l&& AND r&&: goto econstmarkupi
end if

if o$="+" then r##=l##+r##: goto econstmarkupf
if o$="-" then r##=l##-r##: goto econstmarkupf
if o$="*" then r##=l##*r##: goto econstmarkupf
if o$="^" then r##=l##^r##: goto econstmarkupf
if o$="/" then r##=l##/r##: goto econstmarkupf
if o$="\" then r&&=l##\r##: goto econstmarkupi32
if o$="MOD" then r&&=l## MOD r##: goto econstmarkupi32
if o$="=" then r&&=l##=r##: goto econstmarkupi16
if o$=">" then r&&=l##>r##: goto econstmarkupi16
if o$="<" then r&&=l##<r##: goto econstmarkupi16
if o$=">=" then r&&=l##>=r##: goto econstmarkupi16
if o$="<=" then r&&=l##<=r##: goto econstmarkupi16
if o$="<>" then r&&=l##<>r##: goto econstmarkupi16
if o$="IMP" then r&&=l## IMP r##: goto econstmarkupi32
if o$="EQV" then r&&=l## EQV r##: goto econstmarkupi32
if o$="XOR" then r&&=l## XOR r##: goto econstmarkupi32
if o$="OR" then r&&=l## OR r##: goto econstmarkupi32
if o$="AND" then r&&=l## AND r##: goto econstmarkupi32

qb64error "Invalid CONST expression.13"

econstmarkupi16:
et=INTEGERTYPE-ISPOINTER
ev$=_MK$(_INTEGER64,r&&)
goto econstmarkedup

econstmarkupi32:
et=LONGTYPE-ISPOINTER
ev$=_MK$(_INTEGER64,r&&)
goto econstmarkedup

econstmarkupi:
if et<>btype(i) then
'keep unsigned?
u=0: if (et and ISUNSIGNED)<>0 and (btype(i) and ISUNSIGNED)<>0 then u=1
lb=et and 511: rb=btype(i) and 511
ob=0
if lb=rb then
if (et and ISOFFSETINBITS)<>0 and (btype(i) and ISOFFSETINBITS)<>0 then ob=1
b=lb
end if
if lb>rb then
if (et and ISOFFSETINBITS)<>0 then ob=1
b=lb
end if
if lb<rb then
if (btype(i) and ISOFFSETINBITS)<>0 then ob=1
b=rb
end if
et=b
if ob then et=et+ISOFFSETINBITS
if u then et=et+ISUNSIGNED
end if
ev$=_MK$(_INTEGER64,r&&)
goto econstmarkedup

econstmarkupf:
lfb=0: rfb=0
lib=0: rib=0
if et and ISFLOAT then lfb=et AND 511 else lib=et AND 511
if btype(i) and ISFLOAT then rfb=btype(i) AND 511 else rib=btype(i) AND 511
f=32
if lib>16 or rib>16 then f=64
if lfb>32 or rfb>32 then f=64
if lib>32 or rib>32 then f=256
if lfb>64 or rfb>64 then f=256
et=ISFLOAT+f
ev$=_MK$(_FLOAT,r##)

econstmarkedup:

i=i+1

if i<=n then goto evalconstequ

t=et
evaluateconst$=ev$

end function

function typevalue2symbol$ (t)

if t and ISSTRING then
if t and ISFIXEDLENGTH then qb64error "Cannot convert expression type to symbol"
typevalue2symbol$="$"
exit function
end if

s$=""

if t and ISUNSIGNED then s$="~"

b=t and 511

if t and ISOFFSETINBITS then
if b>1 then s$=s$+"`"+str2$(b) else s$=s$+"`"
typevalue2symbol$=s$
exit function
end if

if t and ISFLOAT then
if b=32 then s$="!"
if b=64 then s$="#"
if b=256 then s$="##"
typevalue2symbol$=s$
exit function
end if

if b=8 then s$=s$+"%%"
if b=16 then s$=s$+"%"
if b=32 then s$=s$+"&"
if b=64 then s$=s$+"&&"
typevalue2symbol$=s$

end function

function symbol2fulltypename$ (s2$)
'note: accepts both symbols and type names
s$=s2$

IF LEFT$(s$, 1) = "~" THEN
u = 1
IF LEN(typ$) = 1 THEN qb64error "Expected ~..."
s$ = RIGHT$(s$, LEN(s$) - 1)
u$ = "_UNSIGNED "
END IF

IF s$ = "%%" THEN t$ = u$ + "_BYTE": GOTO gotsym2typ
IF s$ = "%" THEN t$ = u$ + "INTEGER": GOTO gotsym2typ
IF s$ = "&" THEN t$ = u$ + "LONG": GOTO gotsym2typ
IF s$ = "&&" THEN t$ = u$ + "_INTEGER64": GOTO gotsym2typ

IF LEFT$(s$, 1) = "`" THEN
 IF len(s$) = 1 THEN
 t$ = u$ + "_BIT * 1"
 GOTO gotsym2typ
 END IF
n$ = RIGHT$(s$, LEN(s$) - 1)
IF isuinteger(n$) = 0 THEN qb64error "Expected number after symbol `"
t$ = u$ + "_BIT * " + n$
GOTO gotsym2typ
END IF

IF u = 1 THEN qb64error "Expected type symbol after ~"

IF s$ = "!" THEN t$ = "SINGLE": GOTO gotsym2typ
IF s$ = "#" THEN t$ = "DOUBLE": GOTO gotsym2typ
IF s$ = "##" THEN t$ = "_FLOAT": GOTO gotsym2typ
IF s$ = "$" THEN t$ = "STRING": GOTO gotsym2typ

IF LEFT$(s$, 1) = "$" THEN
n$ = RIGHT$(s$, LEN(s$) - 1)
IF isuinteger(n$) = 0 THEN qb64error "Expected number after symbol $"
t$ = "STRING * " + n$
GOTO gotsym2typ
END IF

t$=s$

gotsym2typ:

if right$(" "+t$,5)=" _BIT" then t$=t$+" * 1" 'clarify (_UNSIGNED) _BIT as (_UNSIGNED) _BIT * 1

symbol2fulltypename$=t$

end function

sub lineinput3load (f$)
open f$ for binary as #1
l=lof(1)
lineinput3buffer$=space$(l)
get #1,,lineinput3buffer$
if len(lineinput3buffer$) then if right$(lineinput3buffer$,1)=chr$(26) then lineinput3buffer$=left$(lineinput3buffer$,len(lineinput3buffer$)-1)
close #1
lineinput3index=1
end sub

function lineinput3$
'returns CHR$(13) if no more lines are available
l=len(lineinput3buffer$)
if lineinput3index>l then lineinput3$=chr$(13): exit function
c13=instr(lineinput3index,lineinput3buffer$,chr$(13))
c10=instr(lineinput3index,lineinput3buffer$,chr$(10))
if c10=0 and c13=0 then
 lineinput3$=mid$(lineinput3buffer$,lineinput3index,l-lineinput3index+1)
 lineinput3index=l+1
 exit function
end if
if c10=0 then c10=2147483647
if c13=0 then c13=2147483647
if c10<c13 then
 '10 before 13
 lineinput3$=mid$(lineinput3buffer$,lineinput3index,c10-lineinput3index)
 lineinput3index=c10+1
 if lineinput3index<=l then
  if asc(mid$(lineinput3buffer$,lineinput3index,1))=13 then lineinput3index=lineinput3index+1:  end
 end if
else
 '13 before 10
 lineinput3$=mid$(lineinput3buffer$,lineinput3index,c13-lineinput3index)
 lineinput3index=c13+1
 if lineinput3index<=l then
  if asc(mid$(lineinput3buffer$,lineinput3index,1))=10 then lineinput3index=lineinput3index+1
 end if
end if
end function

function getfilepath$ (f$)
for i=len(f$) to 1 step -1
a$=mid$(f$,i,1)
if a$=pathsep$ then
getfilepath$=left$(f$,i)
exit function
end if
next
getfilepath$=""
end function

function eleucase$(a$)
'this function upper-cases all elements except for quoted strings
'check first element
if len(a$)=0 then exit function
i=1
if asc(a$)=34 then
i2=instr(a$,sp)
if i2=0 then eleucase$=a$:exit function
a2$=left$(a$,i2-1)
i=i2
end if
'check other elements
sp34$=sp+chr$(34)
if i<len(a$) then
do while instr(i,a$,sp34$)
i2=instr(i,a$,sp34$)
a2$=a2$+ucase$(mid$(a$,i,i2-i+1)) 'everything prior including spacer
i3=instr(i2+1,a$,sp): if i3=0 then i3=len(a$) else i3=i3-1
a2$=a2$+mid$(a$,i2+1,i3-(i2+1)+1) 'everything from " to before next spacer or end
i=i3+1
if i>len(a$) then exit do
loop
end if
a2$=a2$+ucase$(mid$(a$,i,len(a$)-i+1))
eleucase$=a2$
end function



'NEW IDE SPECIFIC
'------------------------------ IDE MODULE ------------------------------

DEFSNG A-Z
SUB getxymouse
static oldmousex,oldmousey,oldmousebutton1
mousewheel=0

do while _mouseinput

mousex=_mousex
mousey=_mousey
if _mousebutton(1) then mousebutton1=1 else mousebutton1=0
mousewheel=mousewheel+_mousewheel

if mousex<>oldmousex or mousey<>oldmousey then
if mousebutton1 then change=1
end if
if oldmousebutton1<>mousebutton1 then change=1
if mousewheel then change=1

oldmousex=mousex
oldmousey=mousey
oldmousebutton1=mousebutton1

if change=1 then exit sub

loop
END SUB

DEFLNG A-Z
FUNCTION ide(ignore)
c$=idecommand$

'report any IDE errors which have occurred
IF ideerror THEN
mustdisplay=1
IF ideerror = 1 THEN ideerrormessage "IDE module error"
IF ideerror = 2 THEN ideerrormessage "File not found"
IF ideerror = 3 THEN ideerrormessage "File access error": CLOSE #150
IF ideerror = 4 THEN ideerrormessage "Path not found"
END IF
ideerror = 1 'unknown IDE error

if left$(c$,1)=chr$(12) then
f$=right$(c$,len(c$)-1)
LOCATE , , 0
COLOR 7, 1: LOCATE idewy-3, 2: PRINT SPACE$(idewx-2);: LOCATE idewy-2, 2: PRINT SPACE$(idewx-2);: LOCATE idewy-1, 2: PRINT SPACE$(idewx-2); 'clear status window
LOCATE idewy-3, 2:PRINT "Creating .EXE file named "+chr$(34)+f$+".exe"+chr$(34)+"..."
PCOPY 3, 0
ide=9: idereturn$=f$
exit function
end if

IF c$ = CHR$(100) THEN 'special call for next line (usually for the purpose of line continuation)
idecompiledline = idecompiledline + 1 'must increment (to trigger no more lines avail. message later)
IF idecompiledline < iden THEN
idecompiledline$=idegetline(idecompiledline)
idereturn$ = idecompiledline$
else
idecompiledline$=""
idereturn$ = idecompiledline$ 'no more lines
end if
exit function
END IF

IF idelaunched = 0 THEN
idelaunched = 1



'ref: options.bin
'SEEK 1
'[2]   ideautolayout(=1)
'[2]   ideautoindent(=1)
'[2]   ideautoindentsize(=4)
'SEEK 7
'[2]   idewx(=80)
'[2]   idewy(=25)
'[2]   idecustomfont(=0)
'[1024]idecustomfontfile(=c:\windows\fonts\lucon.ttf)
'[2]   idecustomfontheight(=21)
'total bytes: 1024+2*7=1038


open ".\internal\temp\options.bin" for binary as #150

if lof(150)<>1038 then
'remake options with defaults
close #150
open ".\internal\temp\options.bin" for output as #150:close #150
open ".\internal\temp\options.bin" for binary as #150
v%=1: put #150,,v%
v%=1: put #150,,v%
v%=4: put #150,,v%
v%=80: put #150,,v%
v%=25: put #150,,v%
v%=0: put #150,,v%
v$=space$(1024): mid$(v$,1)="c:\windows\fonts\lucon.ttf": put #150,,v$
v%=21: put #150,,v%
close #150
open ".\internal\temp\options.bin" for binary as #150
end if

'load options
'layout:
get #150,,v%: if v%<>0 then v%=1
ideautolayout=v%
get #150,,v%: if v%<>0 then v%=1
ideautoindent=v%
get #150,,v%: if v%<0 or v%>64 then v%=4
ideautoindentsize=v%
'display:
get #150,,v%: if v%<80 or v%>1000 then v%=80
idewx=v%
get #150,,v%: if v%<25 or v%>1000 then v%=25
idewy=v%
get #150,,v%: if v%<>0 then v%=1
idecustomfont=v%
v$=space$(1024): get #150,,v$: idecustomfontfile$=rtrim$(v$)
get #150,,v%: if v%<8 or v%>100 then v%=21
idecustomfontheight=v%
close #150

WIDTH idewx,idewy
_FONT 16

if idecustomfont then
idecustomfonthandle=_LOADFONT(idecustomfontfile$,idecustomfontheight,"MONOSPACE")
if idecustomfonthandle=-1 then
'failed! - revert to default settings
idecustomfont=0: idecustomfontfile$="c:\windows\fonts\lucon.ttf": idecustomfontheight=21
else
_FONT idecustomfonthandle
end if
end if

m = 1: i = 0
menu$(m, i) = "File": i = i + 1
menu$(m, i) = "#New": i = i + 1
menu$(m, i) = "#Open...": i = i + 1
menu$(m, i) = "#Save": i = i + 1
menu$(m, i) = "Save #As...": i = i + 1
menu$(m, i) = "-": i = i + 1
menu$(m, i) = "E#xit": i = i + 1
menusize(m) = i - 1

m = m + 1: i = 0
menu$(m, i) = "Edit": i = i + 1
menu$(m, i) = "Cu#t  Shift+Del or CTRL+X": i = i + 1
menu$(m, i) = "#Copy  Ctrl+Ins or CTRL+C": i = i + 1
menu$(m, i) = "#Paste  Shift+Ins or CTRL+V": i = i + 1
menu$(m, i) = "Cl#ear  Del": i = i + 1
menu$(m, i) = "Select #All  CTRL+A": i = i + 1
menu$(m, i) = "-": i = i + 1
menu$(m, i) = "New #SUB...": i = i + 1
menu$(m, i) = "New #FUNCTION...": i = i + 1

menusize(m) = i - 1

m = m + 1: i = 0
menu$(m, i) = "View": i = i + 1
menu$(m, i) = "#SUBs...  F2": i = i + 1
menusize(m) = i - 1

m = m + 1: i = 0
menu$(m, i) = "Search": i = i + 1
menu$(m, i) = "#Find...": i = i + 1
menu$(m, i) = "#Repeat Last Find  F3": i = i + 1
menu$(m, i) = "#Change...": i = i + 1
menusize(m) = i - 1

m = m + 1: i = 0
menu$(m, i) = "Run": i = i + 1
menu$(m, i) = "#Start  F5": i = i + 1
menu$(m, i) = "-": i = i + 1
menu$(m, i) = "Start (#Detached)  Ctrl+F5": i = i + 1
menu$(m, i) = "Make E#XE Only  F11": i = i + 1
menusize(m) = i - 1
m = m + 1: i = 0
menu$(m, i) = "Options": i = i + 1
menu$(m, i) = "#Display...": i = i + 1
menu$(m, i) = "#Code layout...": i = i + 1
menusize(m) = i - 1

menus = m

IF os$ = "WIN" THEN
idepathsep$ = "\"
END IF
IF os$ = "LNX" THEN
idepathsep$ = "/"
END IF

initmouse
a$ = "QWERTYUIOP????ASDFGHJKL?????ZXCVBNM": x = 16: FOR i = 1 TO LEN(a$): idealtcode(ASC(MID$(a$, i, 1))) = x: x = x + 1: NEXT

ideroot$ = idezgetroot$
idepath$ = ideroot$

'new blank text field
idet$ = MKL$(0) + MKL$(0): idel = 1: ideli = 1: iden = 1

ideunsaved = -1
idechangemade = 1

redraweverything:

menubar$ = "   "
FOR i = 1 TO menus
menubar$ = menubar$ + menu$(i, 0) + "  "
NEXT
menubar$ = menubar$ + SPACE$(idewx - LEN(menubar$))

SCREEN , , 3, 0
VIEW PRINT 1 TO idewy
LOCATE , , , 8, 8

'static background
COLOR 0, 7: LOCATE 1, 1: PRINT menubar$;
COLOR 7, 1: idebox 1, 2, idewx, idewy-5
COLOR 7, 1: idebox 1, idewy-4, idewx, 5
'edit corners
COLOR 7, 1: LOCATE idewy-4, 1: PRINT ""; : LOCATE idewy-4, idewx: PRINT "";
'add status title
COLOR 7, 1: LOCATE idewy-4,(idewx-8)/2: PRINT " Status "
'status bar
COLOR 0, 3: LOCATE idewy, 1: PRINT SPACE$(idewx);
q = idevbar(idewx, idewy-3, 3, 1, 1)
q = idevbar(idewx, 3, idewy-8, 1, 1)
q = idehbar(2, idewy-5, idewx-2, 1, 1)
idesx = 1
idesy = 1
idecx = 1
idecy = 1
DEF SEG = 0
ideshowtext
if retval=1 then goto skipload



'restore autosave?
OPEN tmpdir$+"autosave.bin" FOR BINARY AS #150
IF LOF(150) THEN
GET #150, , n&
IF n& THEN
r$ = iderestore$
PCOPY 3, 0: SCREEN , , 3, 0: idewait4mous: idewait4alt
IF r$ = "Y" THEN
ideunsaved = 1
GET #150, , bytes&
idet$ = SPACE$(bytes&)
GET #150, , idet$
iden = n&
END IF
END IF
END IF
CLOSE #150



if ideunsaved<>1 then 'no file restored (takes priority over loading file from command line)
if left$(c$,1)=chr$(1) then 'load file
f$=right$(c$,len(c$)-1)
if lcase$(right$(f$,4))<>".bas" then f$=f$+".bas" 'add .bas if necessary
path$=idezgetfilepath$(ideroot$,f$)

'(copied from ideopen)
ideerror = 2
OPEN path$+idepathsep$+f$ FOR INPUT AS #150: CLOSE #150
ideerror = 3
idepath$=path$
lineinput3load path$+idepathsep$+f$
idet$=space$(len(lineinput3buffer)*8)
i2=1
n=0
chrtab$=chr$(9)
space1$=" ": space2$="  ": space3$="   ": space4$="    "
chr7$=chr$(7): chr11$=chr$(11): chr12$=chr$(12): chr28$=chr$(28): chr29$=chr$(29): chr30$=chr$(30): chr31$=chr$(31): chr254$=chr$(254)
do
a$=lineinput3$
l=len(a$)
if l then asca=asc(a$) else asca=-1
if asca<>13 then
if asca<>-1 then
'fix tabs
ideopenfixtabsx:
x=instr(a$,chrtab$)
if x then
x2 = (x-1) MOD 4
IF x2 = 0 THEN a$=left$(a$,x-1)+space4$+right$(a$,l-x): l=l+3: goto ideopenfixtabsx
IF x2 = 1 THEN a$=left$(a$,x-1)+space3$+right$(a$,l-x): l=l+2: goto ideopenfixtabsx
IF x2 = 2 THEN a$=left$(a$,x-1)+space2$+right$(a$,l-x): l=l+1: goto ideopenfixtabsx
IF x2 = 3 THEN a$=left$(a$,x-1)+space1$+right$(a$,l-x): goto ideopenfixtabsx
end if
'remove unprintable characters that may remain
ideopenfixunprintablex:
if instr(a$,chr7$) then x=instr(a$,chr7$): a$=left$(a$,x-1)+chr$(254)+right$(a$,l-x): goto ideopenfixunprintablex
if instr(a$,chr11$) then x=instr(a$,chr11$): a$=left$(a$,x-1)+chr$(254)+right$(a$,l-x): goto ideopenfixunprintablex
if instr(a$,chr12$) then x=instr(a$,chr12$): a$=left$(a$,x-1)+chr$(254)+right$(a$,l-x): goto ideopenfixunprintablex
if instr(a$,chr28$) then x=instr(a$,chr28$): a$=left$(a$,x-1)+chr$(254)+right$(a$,l-x): goto ideopenfixunprintablex
if instr(a$,chr29$) then x=instr(a$,chr29$): a$=left$(a$,x-1)+chr$(254)+right$(a$,l-x): goto ideopenfixunprintablex
if instr(a$,chr30$) then x=instr(a$,chr30$): a$=left$(a$,x-1)+chr$(254)+right$(a$,l-x): goto ideopenfixunprintablex
if instr(a$,chr31$) then x=instr(a$,chr31$): a$=left$(a$,x-1)+chr$(254)+right$(a$,l-x): goto ideopenfixunprintablex
end if 'asca<>-1
mid$(idet$,i2,l+8)=MKL$(l) + a$ + MKL$(l): i2=i2+l+8: n=n+1
end if
loop until asca=13
lineinput3buffer=""
iden=n: if n=0 then idet$ = MKL$(0) + MKL$(0): iden = 1 else idet$=left$(idet$,i2-1)
ideerror = 1
ideprogname = f$: _TITLE ideprogname+" - QB64"
end if 'message 1

end if 'no restore

skipload:
END IF 'idelaunched

IF c$ = CHR$(3) THEN
skipdisplay=1 'assume .../starting already displayed
sendnextline = 1

'previous line was OK, so use layout if available

if ideautolayout=0 and ideautoindent=0 then

layout$=""
idelayoutallow=0

else

if len(layout$) then

'calculate recommended indent level
for i=1 to len(layout$)
if asc(layout$,i)<>32 or i=len(layout$) then
indent=i-1
layout$=right$(layout$,len(layout$)-i+1)
exit for
end if
next

if ideautolayout then
spacelayout:
ignoresp=0
for i=1 to len(layout$)
if asc(layout$,i)=34 then
ignoresp=ignoresp+1: if ignoresp=2 then ignoresp=0
end if
if ignoresp=0 then
if mid$(layout$,i,1)=sp then mid$(layout$,i,1)=" "
if mid$(layout$,i,1)=sp2 then layout$=left$(layout$,i-1)+right$(layout$,len(layout$)-i): goto spacelayout
end if
next
end if

if ideautoindent=0 then
	'note: can assume auto-format
	'calculate old indent (if any)
	a$=idecompiledline$
	indent=0
	for i=1 to len(a$)
	if asc(a$,i)<>32 or i=len(a$) then
	indent=i-1
	exit for
	end if
	next
	indent$=space$(indent)
else
	indent$=space$(indent*ideautoindentsize)
end if

if ideautolayout=0 then
	'note: can assume auto-indent
	a$=idecompiledline$
	layout$=""
	for i=1 to len(a$)
	if asc(a$,i)<>32 or i=len(a$) then
	layout$=right$(a$,len(a$)-i+1)
 	exit for
	end if
	next
end if

layout$=indent$+layout$

if idecy<>idecompiledline or idelayoutallow<>0 then
idelayoutallow=0

if idecompiledline$<>layout$ then 
idesetline idecompiledline, layout$
if idecompiledline>=idesy and idecompiledline<=(idesy+16) then skipdisplay=0
end if

else

if idecompiledline$<>layout$ then
idecurrentlinelayout=layout$
idecurrentlinelayouti=idecy
end if

end if

end if 'len(layout$)

end if 'using layout/indent

END IF '3

IF c$ = CHR$(6) THEN
idecompiling = 0
ready = 1
if ideautorun then ideautorun=0: goto idemrunspecial
END IF

IF c$ = CHR$(11) THEN
idecompiling = 0
ready = 1
ideautorun=0
showexecreated=1
end if

IF c$ = CHR$(7) THEN
skipdisplay=1 'assume .../starting already displayed
idecompiledline = 0
sendnextline = 1
END IF

IF LEFT$(c$, 1) = CHR$(8) THEN
idecompiling = 0
failed = 1
ideautorun=0
END IF

passback=0
if left$(c$,1)=chr$(10) then 'passback
skipdisplay=1 'assume .../starting already displayed
sendnextline = 1
idecompiledline = idecompiledline - 1
passback=1
passback$=right$(c$,len(c$)-1)
end if

if mustdisplay then skipdisplay=0

if skipdisplay=0 then

LOCATE , , 0

'note: menu bar shouldn't need repairing!
'COLOR 0, 7: LOCATE 1, 1: PRINT menubar$; 'repair menu bar

if c$<>chr$(3) then
COLOR 7, 1: LOCATE idewy-3, 2: PRINT SPACE$(idewx-2);: LOCATE idewy-2, 2: PRINT SPACE$(idewx-2);: LOCATE idewy-1, 2: PRINT SPACE$(idewx-2); 'clear status window
IF ready THEN LOCATE idewy-3, 2: PRINT "OK"; 'report OK status
 if showexecreated then
 showexecreated=0
 LOCATE idewy-3, 2:PRINT ".EXE file created";
 end if
end if

end if 'skipdisplay

idefocusline=0

'main loop
DO
ideloop:

idedeltxt 'removes temporary strings by setting an index to 0

if skipdisplay=0 then

LOCATE , , 0

'update title of main window
COLOR 7, 1: LOCATE 2, 2: PRINT STRING$(idewx-2, "");
IF LEN(ideprogname) THEN a$ = ideprogname ELSE a$ = "Untitled"+tempfolderindexstr$
a$ = " " + a$ + " "
COLOR 1, 7: LOCATE 2, ((idewx/2)-1) - (LEN(a$) - 1) \ 2: PRINT a$;

'alter cursor style to match insert mode
IF ideinsert THEN LOCATE , , , 0, 31 ELSE LOCATE , , , 8, 8

'display error message (if necessary)
IF failed THEN
COLOR 7, 1: LOCATE idewy-3, 2: PRINT SPACE$(idewx-2);: LOCATE idewy-2, 2: PRINT SPACE$(idewx-2);: LOCATE idewy-1, 2: PRINT SPACE$(idewx-2); 'clear status window

'scrolling unavailable, but may span multiple lines
a$=MID$(c$, 2, LEN(c$) - 5)
l=cvl(right$(c$,4))
if l<>0 then
idefocusline=l
if idecy=l then a$=a$+" on current line" else a$=a$+" on line"+str$(l)
end if
LOCATE idewy-3,2: if len(a$) then print left$(a$,idewx-2);
if len(a$)>(idewx-2) then a$=right$(a$,len(a$)-(idewx-2)) else a$=""
locate idewy-2,2: if len(a$) then print left$(a$,(idewx-2));
if len(a$)>(idewx-2) then a$=right$(a$,len(a$)-(idewx-2)) else a$=""
locate idewy-1,2: if len(a$) then print left$(a$,(idewx-2));

end if

if idechangemade then
COLOR 7, 1: LOCATE idewy-3, 2: PRINT SPACE$(idewx-2);: LOCATE idewy-2, 2: PRINT SPACE$(idewx-2);: LOCATE idewy-1, 2: PRINT SPACE$(idewx-2); 'clear status window


LOCATE idewy-3, 2: PRINT "..."; 'assume new compilation will begin
end if

ideshowtext
LOCATE , , 1
PCOPY 3, 0

end if 'skipdisplay

IF idechangemade THEN

if idelayoutallow then idelayoutallow=idelayoutallow-1

idecurrentlinelayouti=0 'invalidate

idechangemade = 0
IF ideunsaved = -1 THEN ideunsaved = 0 ELSE ideunsaved = 1

'autosave
ideautosave = ideautosave + 1
IF ideautosave = 10 THEN
ideautosave = 0

OPEN tmpdir$+"autosave.bin" FOR OUTPUT AS #150: CLOSE #150: OPEN tmpdir$+"autosave.bin" FOR BINARY AS #150

PUT #150, , iden
l& = LEN(idet$)
PUT #150, , l&
PUT #150, , idet$
CLOSE #150
END IF

'begin new compilation
ideautorun=0
idecompiling = 1
ide=2
idecompiledline$=idegetline(1)
idereturn$ = idecompiledline$
idecompiledline = 1
EXIT FUNCTION
END IF'idechangemade


change = 0
waitforinput:

if idecurrentlinelayouti then
if idecy<>idecurrentlinelayouti then
idesetline idecurrentlinelayouti, idecurrentlinelayout$
idecurrentlinelayouti=0
change=1 'simulate a change to force a screen update
end if
end if

exitvalue=_EXIT
if exitvalue and 1 then goto quickexit

omb = mb
getxymouse
mx = mousex
my = mousey
mb = mousebutton1
IF mb = 0 THEN idemouseselect = 0
IF mb THEN change = 1
if mousewheel then change=1

k$ = INKEY$: IF LEN(k$) THEN change = 1

DEF SEG = 0
p417 = PEEK(&H417)
p418 = PEEK(&H418)


IF p417 AND 8 THEN 'alt held

IF idealthighlight = 0 THEN
 'highlist first letter of each menu item
 idealthighlight = 1
 LOCATE , , 0: COLOR 15, 7: x = 4
 FOR i = 1 TO menus
 LOCATE 1, x: PRINT LEFT$(menu$(i, 0), 1);
 x = x + LEN(menu$(i, 0)) + 2
 NEXT
ideentermenu = 1 'alt has just been pressed, so any next keystroke could enter a menu)
if change=0 then skipdisplay=0: GOTO ideloop 'force update so cursor will be restored to correct position
change=1
END IF

ELSE 'alt not held

IF idealthighlight = 1 THEN
 'remove highlight
 idealthighlight=0
 LOCATE , , 0: COLOR 0, 7: LOCATE 1, 1: PRINT menubar$;
IF ideentermenu = 1 and change=0 THEN 'alt was pressed then released
 LOCATE , , , 8, 8: skipdisplay=0: ideentermenu=0: GOTO startmenu
end if
change=1
END IF

END IF 'alt not held

IF change = 0 THEN

'continue compilation?
IF idecompiling THEN
IF sendnextline THEN
IF idecompiledline < iden THEN
idecompiledline = idecompiledline + 1
ide=4
if passback then
idecompiledline$=passback$
idereturn$=idecompiledline$
else
idecompiledline$=idegetline(idecompiledline)
idereturn$=idecompiledline$
end if
EXIT FUNCTION
ELSE
'finished compilation
ide=5 'end of program reached, what next?
'could return:
'i) 6 code ready for export/run
'ii) 7 repass required (if so send data from the beginning again)
EXIT FUNCTION
END IF
END IF
END IF

_LIMIT 16

GOTO waitforinput
END IF 'change=0

skipdisplay=0

if k$=CHR$(0) + chr$(98) then 'run detached
idemdetached:
iderunmode=1
goto idemrunspecial
end if

if k$=CHR$(0) + chr$(133) then 'make exe only
idemexe:
iderunmode=2
goto idemrunspecial
end if

'run: F5/shift+F5
IF k$ = CHR$(0) + "?" or k$ = CHR$(0) + "X" THEN
idemrun:
iderunmode=0 'standard run
idemrunspecial:

'run program
if ready then

LOCATE , , 0
COLOR 7, 1: LOCATE idewy-3, 2: PRINT SPACE$(idewx-2);: LOCATE idewy-2, 2: PRINT SPACE$(idewx-2);: LOCATE idewy-1, 2: PRINT SPACE$(idewx-2); 'clear status window

if idecompiled then

if iderunmode=2 then
LOCATE idewy-3, 2:PRINT "Already created .EXE file!";
GOTO specialchar
end if

LOCATE idewy-3, 2:PRINT "Starting program...";
else
LOCATE idewy-3, 2:PRINT "Creating .EXE file...";
end if
PCOPY 3, 0

'send run request
 'prepare name
 if ideprogname$="" then
  f$="untitled"+tempfolderindexstr$
 else
  f$=ideprogname$
  f$=left$(f$,len(f$)-4) 'remove .bas
 end if
ide=9: idereturn$=f$
exit function
end if
'not ready!
if failed=1 then GOTO specialchar
'assume still compiling ...
ideautorun=1

'correct status message
LOCATE , , 0
COLOR 7, 1: LOCATE idewy-3, 2: PRINT SPACE$(idewx-2);: LOCATE idewy-2, 2: PRINT SPACE$(idewx-2);: LOCATE idewy-1, 2: PRINT SPACE$(idewx-2); 'clear status window


LOCATE idewy-3, 2:PRINT "Checking program... (editing program will cancel request)";

'must move the cursor back to its correct location
ideshowtext
LOCATE , , 1
PCOPY 3, 0

GOTO specialchar
END IF

ideentermenu = 0

LOCATE , , 0
LOCATE , , , 8, 8


DEF SEG = 0
p417 = PEEK(&H417)
IF p417 AND 3 THEN shiftheld = 1 ELSE shiftheld = 0


IF mb <> 0 AND omb = 0 AND idemouseselect = 0 THEN
IF my = 1 THEN
x = 3
FOR i = 1 TO menus
x2 = LEN(menu$(i, 0)) + 2
IF mx >= x AND mx < x + x2 THEN
m = i
GOTO showmenu
END IF
x = x + x2
NEXT
END IF
END IF

IF LEN(k$) = 2 THEN
FOR i = 1 TO menus
a$ = UCASE$(LEFT$(menu$(i, 0), 1))
IF ASC(RIGHT$(k$, 1)) = idealtcode(ASC(a$)) THEN
m = i
LOCATE 1, 1: COLOR 0, 7: PRINT menubar$;
PCOPY 3, 0
GOTO showmenu
END IF
NEXT
END IF

IF mb <> 0 AND omb = 0 THEN
IF mx > 1 AND mx < idewx AND my > 2 AND my < (idewy-5) THEN 'inside text box
ideselect = 1
idecx = mx - 1 + idesx - 1
idecy = my - 2 + idesy - 1
IF idecy > iden THEN idecy = iden
ideselect = 1: ideselectx1 = idecx: ideselecty1 = idecy
idemouseselect = 1
END IF
END IF

IF mb <> 0 AND omb = 0 THEN
IF mx = idewx THEN
IF iden > 1 THEN 'take no action if not slider available
y = idevbar(idewx, 3, idewy-8, idecy, iden)
IF y = my THEN
idemouseselect = 2
ideselect = 0
END IF
END IF
END IF
END IF

IF mb <> 0 AND omb = 0 THEN
IF my = idewy-5 THEN
x = idehbar(2, idewy-5, idewx-2, idesx, 608)
IF x = mx THEN
idemouseselect = 3
ideselect = 0
END IF
END IF
END IF

IF mb <> 0 AND idemouseselect = 0 THEN
IF mx = idewx AND my > 2 AND my < idewy-5 THEN 'inside vbar
ideselect = 0
IF my = 3 THEN k$ = CHR$(0) + CHR$(72): idewait
IF my = idewy-6 THEN k$ = CHR$(0) + CHR$(80): idewait
IF my > 3 AND my < (idewy-6) THEN
 'assume not on slider
 IF iden > 1 THEN 'take no action if not slider available
 y = idevbar(idewx, 3, idewy-8, idecy, iden)
 IF y <> my THEN
 IF my < y THEN
 k$ = CHR$(0) + CHR$(73): idewait
 ELSE
 k$ = CHR$(0) + CHR$(81): idewait
 END IF
 END IF
 END IF
 END IF
END IF
END IF

IF mb <> 0 AND idemouseselect = 0 THEN
IF my = idewy-5 AND mx > 1 AND mx < idewx THEN 'inside hbar
ideselect = 0
IF mx = 2 THEN k$ = CHR$(0) + "K": idewait
IF mx = idewx-1 THEN k$ = CHR$(0) + "M": idewait
IF mx > 2 AND mx < idewx-1 THEN
 'assume not on slider
 x = idehbar(2, idewy-5, idewx-2, idesx, 608)
 IF x <> mx THEN
 IF mx < x THEN
 idecx = idecx - 8
 IF idecx < 1 THEN idecx = 1
 idewait
 ELSE
 idecx = idecx + 8
 idewait
 END IF
 END IF

 END IF
END IF
END IF

IF mb <> 0 AND idemouseselect = 2 THEN
'move vbar scroller (idecy) to appropriate position
IF iden > 1 THEN
IF my <= 4 THEN idecy = 1
IF my >= idewy-7 THEN idecy = iden
IF my > 4 AND my < idewy-7 THEN
y = my
p! = y - 3 - 2 + .5
p! = p! / ((idewy-8) - 4)
i = p! * (iden - 1) + 1
idecy = i
END IF
END IF
END IF

IF mb <> 0 AND idemouseselect = 3 THEN
'move hbar scroller (idecx) to appropriate position
IF mx <= 3 THEN idesx = 1: idecx = idesx
IF mx >= idewx-2 THEN idesx = 608: idecx = idesx
IF mx > 3 AND mx < idewx-2 THEN
x = mx
p! = x - 2 - 2 + .5
p! = p! / ((idewx-2) - 4)
i = p! * (608 - 1) + 1
idesx = i
idecx = idesx
END IF
END IF

IF mb AND idemouseselect <= 1 THEN
IF mx > 1 AND mx < idewx AND my > 2 AND my < idewy-5 THEN 'inside text box
IF idemouseselect = 1 THEN
idecx = mx - 1 + idesx - 1
idecy = my - 2 + idesy - 1
IF idecy > iden THEN idecy = iden
END IF
END IF
END IF

IF mb THEN
IF mx = 1 OR mx = idewx OR my <= 2 OR my >= idewy-5 THEN 'off text window area
IF idemouseselect = 1 THEN
'scroll window
IF my >= idewy-5 THEN idecy = idecy + 1: IF idecy > iden THEN idecy = iden
IF my <= 2 THEN idecy = idecy - 1: IF idecy < 1 THEN idecy = 1
IF mx = 1 THEN idecx = idecx - 1: IF idecx < 1 THEN idecx = 1
IF mx = idewx THEN idecx = idecx + 1
idewait
END IF
END IF
END IF

DEF SEG = 0
IF PEEK(&H417) AND 4 THEN ctrlheld = 1 ELSE ctrlheld = 0

if k$=chr$(1) and ctrlheld = 1 then 'select all
idemselectall:
ideselect = 1: ideselectx1 = 1: ideselecty1 = 1
idecy = iden
a$ = idegetline(idecy)
idecx = LEN(a$) + 1
GOTO specialchar
end if

IF k$ = CHR$(0) + CHR$(61) THEN 'F3
idemf3:
IF idefindtext$ <> "" THEN
idefindagain
else
goto idefindjmp
END IF
GOTO specialchar
END IF

IF k$ = CHR$(0) + CHR$(60) THEN 'F2
GOTO idesubsjmp
END IF

IF ((k$ = CHR$(0) + "S" and shiftheld <> 0) or (k$=chr$(24) and ctrlheld = 1)) AND ideselect = 1  THEN 'cut to clipboard
idemcut:
idechangemade = 1
GOTO copy2clip
END IF

IF k$ = CHR$(0) + "S" AND ideselect=1 THEN  'delete selection
idechangemade = 1
GOSUB delselect
GOTO specialchar
END IF

IF (k$ = CHR$(0) + "R" and shiftheld <> 0) or (k$=chr$(22) and ctrlheld = 1) THEN 'paste from clipboard
idempaste:

clip$=_CLIPBOARD$ 'read clipboard

IF LEN(clip$) THEN
if ideselect then GOSUB delselect
IF INSTR(clip$, CHR$(13)) or INSTR(clip$, CHR$(10)) THEN

'full lines paste

idelayoutallow=2
a$ = clip$
x3=1 'scan from position
i = 0 'lines counter

fullpastenextline:

x=INSTR(x3,a$,CHR$(13))
x2=INSTR(x3,a$,CHR$(10))
if x=0 then x=x2
if x2=0 then x2=x
if x2<x then swap x,x2
if x2>x+1 then x2=x 'if seperated by more than one character, they are seperate line terminators
'x to x2 is the range of the next line terminator (1 or 2 characters)

if x then
ideinsline idecy + i, mid$(a$,x3,x-x3)
i = i + 1
x3=x2+1
else
ideinsline idecy + i, mid$(a$,x3,len(a$)-x3+1)
i = i + 1
x3=len(a$)+1
end if

if x3<=len(a$) goto fullpastenextline

ELSE

'insert single line paste
a$ = idegetline(idecy)
IF LEN(a$) < idecx - 1 THEN a$ = a$ + SPACE$(idecx - 1 - LEN(a$))
a$ = LEFT$(a$, idecx - 1) + clip$ + RIGHT$(a$, LEN(a$) - idecx + 1)
idesetline idecy, a$

END IF

idechangemade = 1
END IF
GOTO specialchar
END IF

IF (k$ = CHR$(0) + CHR$(146) or (k$=chr$(3) and ctrlheld = 1)) AND ideselect = 1 THEN 'copy to clipboard
copy2clip:
clip$ = ""
sy1 = ideselecty1
sy2 = idecy
IF sy1 > sy2 THEN SWAP sy1, sy2
sx1 = ideselectx1
sx2 = idecx
IF sx1 > sx2 THEN SWAP sx1, sx2
FOR y = sy1 TO sy2
IF y <= iden THEN
a$ = idegetline(y)
IF sy1 = sy2 THEN 'single line select
FOR x = sx1 TO sx2 - 1
IF x <= LEN(a$) THEN clip$ = clip$ + MID$(a$, x, 1) ELSE clip$ = clip$ + " "
NEXT
ELSE 'multiline select
IF idecx = 1 AND y = sy2 AND idecy > sy1 THEN clip$ = clip$ + CHR$(13)+chr$(10): GOTO nofinalcopy
IF clip$ = "" THEN clip$ = a$ ELSE clip$ = clip$ + CHR$(13) +chr$(10) + a$
nofinalcopy:
END IF
END IF
NEXT
if clip$<>"" then _CLIPBOARD$=clip$
IF k$ = CHR$(0) + "S" or (k$=chr$(24) and ctrlheld = 1) THEN GOSUB delselect
GOTO specialchar
END IF

IF k$ = CHR$(0) + "R" AND shiftheld = 0 THEN 'toggle INSERT mode
ideinsert = ideinsert + 1
IF ideinsert = 2 THEN ideinsert = 0
END IF

IF k$ = CHR$(0) + "H" THEN
GOSUB selectcheck
idecy = idecy - 1
IF idecy < 1 THEN idecy = 1
GOTO specialchar
END IF

IF k$ = CHR$(0) + "P" THEN
GOSUB selectcheck
idecy = idecy + 1
IF idecy > iden THEN idecy = iden
GOTO specialchar
END IF

if mousewheel then
GOSUB selectcheck
'move relative to top/bottom
if mousewheel<0 then idecy=idesy
if mousewheel>0 then idecy=idesy+(idewy-9)
idecy = idecy + mousewheel*3
IF idecy < 1 THEN idecy = 1
IF idecy > iden THEN idecy = iden
GOTO specialchar
END IF

IF k$ = CHR$(0) + "K" THEN
GOSUB selectcheck
idecx = idecx - 1
IF idecx < 1 THEN idecx = 1
GOTO specialchar
END IF

IF k$ = CHR$(0) + "M" THEN
GOSUB selectcheck
idecx = idecx + 1
GOTO specialchar
END IF

IF k$ = CHR$(0) + "G" THEN
GOSUB selectcheck
idecx = 1
GOTO specialchar
END IF

IF k$ = CHR$(0) + "O" THEN
GOSUB selectcheck
a$ = idegetline(idecy)
idecx = LEN(a$) + 1
GOTO specialchar
END IF

IF k$ = CHR$(0) + "w" THEN
GOSUB selectcheck
idecx = 1
idecy = 1
GOTO specialchar
END IF

IF k$ = CHR$(0) + "u" THEN
GOSUB selectcheck
idecy = iden
a$ = idegetline(idecy)
idecx = LEN(a$) + 1
GOTO specialchar
END IF

IF k$ = CHR$(0) + "I" THEN
GOSUB selectcheck
idecy = idecy - (idewy-9)
IF idecy < 1 THEN idecy = 1
GOTO specialchar
END IF

IF k$ = CHR$(0) + "Q" THEN
GOSUB selectcheck
idecy = idecy + (idewy-9)
IF idecy > iden THEN idecy = iden
GOTO specialchar
END IF



GOTO skipgosubs

selectcheck:
IF shiftheld = 1 AND ideselect = 0 THEN ideselect = 1: ideselectx1 = idecx: ideselecty1 = idecy
IF shiftheld = 0 THEN ideselect = 0
RETURN

delselect:
sy1 = ideselecty1
sy2 = idecy
IF sy1 > sy2 THEN SWAP sy1, sy2
sx1 = ideselectx1
sx2 = idecx
IF sx1 > sx2 THEN SWAP sx1, sx2
nolastlinedel=0
if sy1<>sy2 and idecx=1 and idecy>sy1 then sy2=sy2-1:nolastlinedel=1 'ignore last line of multi-line select?
FOR y = sy2 TO sy1 step -1
 IF sy1 = sy2 and nolastlinedel=0 THEN 'single line select
  a$ = idegetline(y)
  a2$ = ""
  IF sx1 <= LEN(a$) THEN a2$ = LEFT$(a$, sx1 - 1) ELSE a2$ = a$
  IF sx2 <= LEN(a$) THEN a2$ = a2$ + RIGHT$(a$, LEN(a$) - sx2 + 1)
  idesetline y, a2$
 ELSE 'multiline select
  if iden=1 and y=1 then idesetline y, "" else idedelline y
 END IF
NEXT
idecx = sx1: IF sy1 <> sy2 or nolastlinedel=1 THEN idecx = 1
idecy = sy1
ideselect = 0
RETURN

skipgosubs:

IF k$ = CHR$(13) THEN
ideselect = 0
idechangemade = 1
a$ = idegetline(idecy)
IF idecx > LEN(a$) THEN
ideinsline idecy + 1, ""
ELSE
idesetline idecy, LEFT$(a$, idecx - 1)
ideinsline idecy + 1, RIGHT$(a$, LEN(a$) - idecx + 1)
END IF
idecy = idecy + 1
idecx = 1
GOTO specialchar
END IF

IF k$ = CHR$(0) + "S" THEN
idechangemade = 1
a$ = idegetline(idecy)
IF idecx <= LEN(a$) THEN
a$ = LEFT$(a$, idecx - 1) + RIGHT$(a$, LEN(a$) - idecx)
idesetline idecy, a$
ELSE
a$ = a$ + SPACE$(idecx - LEN(a$) - 1)
a$ = a$ + idegetline(idecy + 1)
idesetline idecy, a$
idedelline idecy + 1
END IF
GOTO specialchar
END IF

IF k$ = CHR$(8) THEN
ideselect = 0
idechangemade = 1
a$ = idegetline(idecy)
IF idecx = 1 THEN
IF idecy > 1 THEN
a2$ = idegetline(idecy - 1)
idesetline idecy - 1, a2$ + a$
idedelline idecy
idecx = LEN(a2$) + 1
idecy = idecy - 1
END IF
GOTO specialchar
END IF
IF idecx > LEN(a$) + 1 THEN
idecx = LEN(a$) + 1
ELSE
a$ = LEFT$(a$, idecx - 2) + RIGHT$(a$, LEN(a$) - idecx + 1)
idesetline idecy, a$
idecx = idecx - 1
END IF
GOTO specialchar
END IF









'patch#1
IF LEN(k$) <> 1 THEN GOTO specialchar
IF k$ = CHR$(9) THEN GOTO ideforceinput
IF ASC(k$) < 32 THEN GOTO specialchar
ideforceinput:

IF k$ = CHR$(9) THEN
x=4
if ideautoindent<>0 and ideautoindentsize<>0 then x=ideautoindentsize
k$ = SPACE$(x - ((idecx - 1) MOD x))
END IF

'standard character
IF ideselect THEN GOSUB delselect
idechangemade = 1
a$ = idegetline(idecy)
IF LEN(a$) < idecx - 1 THEN a$ = a$ + SPACE$(idecx - 1 - LEN(a$))

IF ideinsert THEN
a2$ = RIGHT$(a$, LEN(a$) - idecx + 1)
IF LEN(a2$) THEN a2$ = RIGHT$(a$, LEN(a$) - idecx)
a$ = LEFT$(a$, idecx - 1) + k$ + a2$
ELSE
a$ = LEFT$(a$, idecx - 1) + k$ + RIGHT$(a$, LEN(a$) - idecx + 1)
END IF

idesetline idecy, a$
idecx = idecx + LEN(k$)
specialchar:

LOOP


startmenu:
m = 1
startmenu2:
altheld=1

DO

LOCATE 1, 3
FOR i = 1 TO menus
IF m = i THEN COLOR 15, 0 ELSE COLOR 15, 7
PRINT " " + LEFT$(menu$(i, 0), 1);
IF m = i THEN COLOR 7, 0 ELSE COLOR 0, 7
PRINT RIGHT$(menu$(i, 0), LEN(menu$(i, 0)) - 1) + " ";
NEXT

PCOPY 3, 0
DO
k$ = INKEY$

lastaltheld=altheld
DEF SEG = 0
p417 = PEEK(&H417)
IF p417 AND 8 THEN altheld=1 else altheld=0
if altheld<>0 and lastaltheld=0 then
do while PEEK(&H417) and 8: loop 'wait till alt is released
k$=chr$(27)
end if

getxymouse
mx = mousex
my = mousey
if mousebutton1 then
IF my = 1 THEN
x = 3
FOR i = 1 TO menus
x2 = LEN(menu$(i, 0)) + 2
IF mx >= x AND mx < x + x2 THEN
m = i
LOCATE 1, 1: COLOR 0, 7: PRINT menubar$;
PCOPY 3, 0
do until mousebutton1=0:getxymouse:loop
GOTO showmenu
END IF
x = x + x2
NEXT
END IF 'my=1
do until mousebutton1=0:getxymouse:loop
k$=chr$(27) 'exit menu selection
end if 'mousebutton1

_LIMIT 16
LOOP UNTIL k$ <> ""

k$ = UCASE$(k$)
FOR i = 1 TO menus
a$ = UCASE$(LEFT$(menu$(i, 0), 1))
x = 0
IF LEN(k$) = 2 THEN
IF ASC(RIGHT$(k$, 1)) = idealtcode(ASC(a$)) THEN x = i
ELSE
IF k$ = a$ THEN x = i
END IF
IF x THEN
m = x
LOCATE 1, 1: COLOR 0, 7: PRINT menubar$;
PCOPY 3, 0
GOTO showmenu
END IF
NEXT

IF k$ = CHR$(0) + "K" THEN m = m - 1
IF k$ = CHR$(0) + "M" THEN m = m + 1
IF k$ = CHR$(27) THEN
LOCATE 1, 1: COLOR 0, 7: PRINT menubar$;
GOTO ideloop
END IF
IF m < 1 THEN m = menus
IF m > menus THEN m = 1
IF k$ = CHR$(0) + "P" OR k$ = CHR$(0) + "H" or k$=chr$(13) THEN 'up/down/enter
LOCATE 1, 1: COLOR 0, 7: PRINT menubar$;
PCOPY 3, 0

GOTO showmenu
END IF
LOOP

showmenu:
altheld=1
PCOPY 0, 2
SCREEN , , 1, 0
r = 1
DO
PCOPY 2, 1

'find pos of menu m
x = 4: FOR i = 1 TO m - 1: x = x + LEN(menu$(i, 0)) + 2: NEXT: xx = x
LOCATE 1, xx - 1: COLOR 7, 0: PRINT " " + menu$(m, 0) + " "
COLOR 0, 7
'calculate menu width
w = 0
FOR i = 1 TO menusize(m)
m$ = menu$(m, i)
l = LEN(m$)
IF INSTR(m$, "#") THEN l = l - 1
IF INSTR(m$, "  ") THEN l = l + 2 'min 4 spacing
IF l > w THEN w = l
NEXT
ideboxshadow xx - 2, 2, w + 4, menusize(m) + 2

'draw menu items
FOR i = 1 TO menusize(m)
m$ = menu$(m, i)
IF m$ = "-" THEN
COLOR 0, 7: LOCATE i + 2, xx - 2: PRINT "" + STRING$(w + 2, "") + "";
ELSE
IF r = i THEN LOCATE i + 2, xx - 1: COLOR 7, 0: PRINT SPACE$(w + 2);
LOCATE i + 2, xx
h = -1: x = INSTR(m$, "#"): IF x THEN h = x: m$ = LEFT$(m$, x - 1) + RIGHT$(m$, LEN(m$) - x)
x = INSTR(m$, "  "): IF x THEN m1$ = LEFT$(m$, x - 1): m2$ = RIGHT$(m$, LEN(m$) - x - 1): m$ = m1$ + SPACE$(w - LEN(m1$) - LEN(m2$)) + m2$
FOR x = 1 TO LEN(m$)
IF x = h THEN
IF r = i THEN COLOR 15, 0 ELSE COLOR 15, 7
ELSE
IF r = i THEN COLOR 7, 0 ELSE COLOR 0, 7
END IF
PRINT MID$(m$, x, 1);

NEXT



END IF

NEXT

PCOPY 1, 0

change = 0
omb = mb

DO

k$ = INKEY$: IF k$ <> "" THEN change = 1

'revert to previous menu
lastaltheld=altheld
DEF SEG = 0
p417 = PEEK(&H417)
IF p417 AND 8 THEN altheld=1 else altheld=0
if altheld<>0 and lastaltheld=0 then
do while PEEK(&H417) and 8: loop 'wait till alt is released
PCOPY 3, 0: SCREEN , , 3, 0
GOTO startmenu2
end if

mousedown=0:mouseup=0
getxymouse
mx = mousex
my = mousey
mb = mousebutton1
IF mb THEN change = 1
IF omb = 0 AND mb = 1 THEN mousedown = 1
IF omb = 1 AND mb = 0 THEN change = 1: mouseup = 1


omb = mb


if change=0 then _LIMIT 16
LOOP UNTIL change

s = 0

'mouse selection
IF mouseup THEN
'uses pre-calc xx & w
IF mx >= xx - 2 AND mx < xx - 2 + w + 4 THEN
IF my > 2 AND my <= menusize(m) + 2 THEN
y = my - 2
IF menu$(m, y) <> "-" THEN
s = r
END IF
END IF
END IF

IF mx < xx - 2 OR mx >= xx - 2 + w + 4 OR my > menusize(m) + 3 THEN
PCOPY 3, 0: SCREEN , , 3, 0
GOTO ideloop
END IF

END IF



IF mb THEN

'top row
IF my = 1 THEN
lastm=m
x = 3
FOR i = 1 TO menus
x2 = LEN(menu$(i, 0)) + 2
IF mx >= x AND mx < x + x2 THEN
m = i
r = 1
if lastm=m and mousedown=1 then PCOPY 3, 0: SCREEN , , 3, 0:idewait4mous: GOTO ideloop
EXIT FOR
END IF
x = x + x2
NEXT
END IF

'uses pre-calc xx & w
IF mx >= xx - 2 AND mx < xx - 2 + w + 4 THEN
IF my > 2 AND my <= menusize(m) + 2 THEN
y = my - 2
IF menu$(m, y) <> "-" THEN r = y
END IF
END IF

END IF 'mb



k$ = UCASE$(k$)

IF k$ = CHR$(0) + "K" THEN m = m - 1: r = 1
IF k$ = CHR$(0) + "M" THEN m = m + 1: r = 1
IF m < 1 THEN m = menus
IF m > menus THEN m = 1
IF k$ = CHR$(27) THEN
PCOPY 3, 0: SCREEN , , 3, 0
GOTO ideloop
END IF
IF k$ = CHR$(0) + "P" THEN
r = r + 1
IF menu$(m, r) = "-" THEN r = r + 1
IF r > menusize(m) THEN r = 1
END IF

IF k$ = CHR$(0) + "H" THEN
r = r - 1
IF menu$(m, r) = "-" THEN r = r - 1
IF r < 1 THEN r = menusize(m)
END IF

'select?

'with enter
IF k$ = CHR$(13) THEN
s = r
END IF
'with hotkey
FOR r2 = 1 TO menusize(m)
x = INSTR(menu$(m, r2), "#")
IF x THEN
a$ = UCASE$(MID$(menu$(m, r2), x + 1, 1))
IF LEN(k$) = 2 THEN
IF ASC(RIGHT$(k$, 1)) = idealtcode(ASC(a$)) THEN s = r2: EXIT FOR
ELSE
IF k$ = a$ THEN s = r2: EXIT FOR
END IF
END IF
NEXT

IF s THEN

'set idehl, a shared variable used by various dialogue boxes
'note: it shouldn't need to be shared!
DEF SEG = 0: alt = PEEK(&H417) AND 8: IF alt THEN idehl = 1 ELSE idehl = 0

IF menu$(m, s) = "#Display..." THEN
PCOPY 2, 0
retval=idedisplaybox
if retval=1 then
'screen dimensions have changed and everything must be redrawn/reapplied
WIDTH idewx,idewy
if idecustomfont then
_FONT idecustomfonthandle
else
_FONT 16
end if
skipdisplay=0
goto redraweverything
end if
PCOPY 3, 0: SCREEN , , 3, 0: idewait4mous: idewait4alt
GOTO ideloop
end if

IF menu$(m, s) = "#Code layout..." THEN
PCOPY 2, 0
retval=idelayoutbox
if retval then idechangemade = 1:idelayoutallow=2 'recompile if options changed
PCOPY 3, 0: SCREEN , , 3, 0: idewait4mous: idewait4alt
GOTO ideloop
end if

IF menu$(m, s) = "New #SUB..." THEN
PCOPY 2, 0
idenewsf "SUB"
ideselect = 0
PCOPY 3, 0: SCREEN , , 3, 0: idewait4mous: idewait4alt
GOTO ideloop
END IF
IF menu$(m, s) = "New #FUNCTION..." THEN
PCOPY 2, 0
idenewsf "FUNCTION"
ideselect = 0
PCOPY 3, 0: SCREEN , , 3, 0: idewait4mous: idewait4alt
GOTO ideloop
END IF

IF menu$(m, s) = "#SUBs...  F2" THEN
PCOPY 2, 0
idesubsjmp:
r$ = idesubs
PCOPY 3, 0: SCREEN , , 3, 0: idewait4mous: idewait4alt
GOTO ideloop
END IF



IF menu$(m, s) = "#Find..." THEN
PCOPY 2, 0
idefindjmp:
r$ = idefind
PCOPY 3, 0: SCREEN , , 3, 0: idewait4mous: idewait4alt
'...
GOTO ideloop
END IF

IF menu$(m, s) = "#Change..." THEN
PCOPY 2, 0
r$ = idechange
PCOPY 3, 0: SCREEN , , 3, 0: idewait4mous: idewait4alt
IF r$ = "C" OR r$ = "" THEN GOTO ideloop
'assume "V", verify changes
oldcx = idecx: oldcy = idecy
found = 0: looped = 0
'set temp variables
s$ = idefindtext$
IF idefindcasesens = 0 THEN s$ = UCASE$(s$)

'attempt to locate next item to change
l$ = idegetline(idecy)
IF LEN(l$) <= idecx THEN 'advance cursor to next line?
idechangenextline:
idecy = idecy + 1
IF idecy > iden THEN idecy = 1: looped = looped + 1
l$ = idegetline(idecy)
idecx = 0 '0 is invalid, but set for temporary purposes!
END IF
'check for possible finish...
x1 = idecx + 1
idechangeonce:
IF (((x1 > oldcx AND idecy = oldcy) OR idecy > oldcy) AND looped = 1) OR looped > 1 THEN
idecx = oldcx: idecy = oldcy
IF found THEN
ideshowtext
SCREEN , , 0, 0: LOCATE , , 1: SCREEN , , 3, 0
PCOPY 3, 0
idechanged
ELSE
idenomatch
END IF
PCOPY 3, 0: SCREEN , , 3, 0: idewait4mous: idewait4alt
GOTO ideloop
END IF

IF idefindcasesens = 0 THEN l3$ = UCASE$(l$) ELSE l3$ = l$
x = INSTR(x1, l3$, s$)

IF x THEN
IF idefindwholeword THEN
whole = 1
IF x > 1 THEN
c = ASC(UCASE$(MID$(l$, x - 1, 1)))
IF c >= 65 AND c <= 90 THEN whole = 0
IF c >= 48 AND c <= 57 THEN whole = 0
END IF
IF x + LEN(s$) <= LEN(l$) THEN
c = ASC(UCASE$(MID$(l$, x + LEN(s$), 1)))
IF c >= 65 AND c <= 90 THEN whole = 0
IF c >= 48 AND c <= 57 THEN whole = 0
END IF
IF whole = 0 THEN
x1 = x + 1
x = 0
IF x1 <= LEN(l$) THEN GOTO idechangeonce
END IF
END IF
END IF

IF x THEN
found = 1
'verify change
idecx = x
ideselect = 1
ideselecty1 = idecy
ideselectx1 = idecx + LEN(s$)
ideshowtext
SCREEN , , 0, 0: LOCATE , , 1: SCREEN , , 3, 0
PCOPY 3, 0
r$ = idechangeit
idedeltxt
PCOPY 3, 0: SCREEN , , 3, 0: idewait4mous: idewait4alt
ideselect = 0
IF r$ = "C" THEN idecx = oldcx: idecy = oldcy: GOTO ideloop
IF r$ = "Y" THEN
idechangemade = 1
IF LEN(l$) >= ideselectx1 THEN
l$ = LEFT$(l$, idecx - 1) + idechangeto$ + RIGHT$(l$, LEN(l$) - ideselectx1 + 1)
ELSE
l$ = LEFT$(l$, idecx - 1) + idechangeto$
END IF
idesetline idecy, l$
idecx = idecx + LEN(idechangeto$)
ELSE
'"N"
idecx = idecx + 1
END IF
x1 = idecx
IF x1 <= LEN(l$) THEN GOTO idechangeonce
END IF

GOTO idechangenextline

GOTO ideloop
END IF '#Change...

IF menu$(m, s) = "#Repeat Last Find  F3" THEN
PCOPY 3, 0: SCREEN , , 3, 0: idewait4mous: idewait4alt
GOTO idemf3
END IF

IF menu$(m, s) = "Cl#ear  Del" THEN
PCOPY 3, 0: SCREEN , , 3, 0: idewait4mous: idewait4alt
IF ideselect = 1 THEN
idechangemade = 1
GOSUB delselect
END IF
GOTO ideloop
END IF

IF menu$(m, s) = "#Paste  Shift+Ins or CTRL+V" THEN
PCOPY 3, 0: SCREEN , , 3, 0: idewait4mous: idewait4alt
GOTO idempaste
END IF

IF menu$(m, s) = "#Copy  Ctrl+Ins or CTRL+C" THEN
PCOPY 3, 0: SCREEN , , 3, 0: idewait4mous: idewait4alt
IF ideselect = 1 THEN GOTO copy2clip
GOTO ideloop
END IF

IF menu$(m, s) = "Cu#t  Shift+Del or CTRL+X" THEN
PCOPY 3, 0: SCREEN , , 3, 0: idewait4mous: idewait4alt
IF ideselect = 1 THEN
k$ = CHR$(0) + "S" 'tricks handler into del after copy
GOTO idemcut
END IF
GOTO ideloop
END IF

IF menu$(m, s) = "Select #All  CTRL+A" THEN
PCOPY 3, 0: SCREEN , , 3, 0: idewait4mous: idewait4alt
GOTO idemselectall
END IF

menu$(m, i) = "Select #All  CTRL+A": i = i + 1

IF menu$(m, s) = "#Start  F5" THEN
PCOPY 3, 0: SCREEN , , 3, 0: idewait4mous: idewait4alt
GOTO idemrun
END IF

IF menu$(m, s) = "Start (#Detached)  Ctrl+F5" THEN
PCOPY 3, 0: SCREEN , , 3, 0: idewait4mous: idewait4alt
GOTO idemdetached
END IF

IF menu$(m, s) = "Make E#XE Only  F11" THEN
PCOPY 3, 0: SCREEN , , 3, 0: idewait4mous: idewait4alt
GOTO idemexe
END IF

IF menu$(m, s) = "E#xit" THEN
PCOPY 2, 0
quickexit:
IF ideunsaved = 1 THEN
r$ = idesavenow
PCOPY 3, 0: SCREEN , , 3, 0: idewait4mous: idewait4alt
IF r$ = "C" THEN GOTO ideloop
IF r$ = "Y" THEN
IF ideprogname = "" THEN
r$ = idesaveas$("untitled"+tempfolderindexstr$+".bas")
IF r$ = "C" THEN
PCOPY 3, 0: SCREEN , , 3, 0: idewait4mous: idewait4alt: GOTO ideloop
END IF
ELSE
idesave idepath$ + idepathsep$ + ideprogname$
END IF
END IF
END IF
OPEN tmpdir$+"autosave.bin" FOR OUTPUT AS #150: CLOSE #150
SYSTEM
END IF

IF menu$(m, s) = "#New" THEN
PCOPY 2, 0
IF ideunsaved = 1 THEN
r$ = idesavenow
PCOPY 3, 0: SCREEN , , 3, 0: idewait4mous: idewait4alt
IF r$ = "C" THEN GOTO ideloop
IF r$ = "Y" THEN
IF ideprogname = "" THEN
a$ = idesaveas$("untitled"+tempfolderindexstr$+".bas")
PCOPY 3, 0: SCREEN , , 3, 0: idewait4mous: idewait4alt
IF r$ = "C" THEN GOTO ideloop
ELSE
idesave idepath$ + idepathsep$ + ideprogname$
END IF
END IF
END IF
ideunsaved = -1
'new blank text field
idet$ = MKL$(0) + MKL$(0): idel = 1: ideli = 1: iden = 1
idesx = 1
idesy = 1
idecx = 1
idecy = 1
ideselect = 0
ideprogname$ = ""
_TITLE "QB64"
idechangemade = 1
GOTO ideloop
END IF

IF menu$(m, s) = "#Open..." THEN
PCOPY 2, 0
IF ideunsaved THEN
r$ = idesavenow
PCOPY 3, 0: SCREEN , , 3, 0: idewait4mous: idewait4alt
IF r$ = "C" THEN GOTO ideloop
IF r$ = "Y" THEN
IF ideprogname = "" THEN
r$ = idesaveas$("untitled"+tempfolderindexstr$+".bas")
IF r$ = "C" THEN GOTO ideloop
ELSE
idesave idepath$ + idepathsep$ + ideprogname$
END IF
PCOPY 3, 0: SCREEN , , 3, 0: idewait4mous: idewait4alt
END IF '"Y"
END IF 'unsaved
r$ = ideopen
IF r$ <> "C" THEN ideunsaved = -1: idechangemade = 1: idelayoutallow=2
PCOPY 3, 0: SCREEN , , 3, 0: idewait4mous: idewait4alt: GOTO ideloop
END IF

IF menu$(m, s) = "#Save" THEN
PCOPY 2, 0
IF ideprogname = "" THEN
a$ = idesaveas$("untitled"+tempfolderindexstr$+".bas")
ELSE
idesave idepath$ + idepathsep$ + ideprogname$
END IF
PCOPY 3, 0: SCREEN , , 3, 0: idewait4mous: idewait4alt: GOTO ideloop
END IF


IF menu$(m, s) = "Save #As..." THEN
PCOPY 2, 0
IF ideprogname = "" THEN
a$ = idesaveas$("untitled"+tempfolderindexstr$+".bas")
ELSE
a$ = idesaveas$(ideprogname$)
END IF
PCOPY 3, 0: SCREEN , , 3, 0: idewait4mous: idewait4alt: GOTO ideloop
END IF




SCREEN , , 0, 0
CLS : PRINT "MENU ITEM [" + menu$(m, s) + "] NOT IMPLEMENTED!": END
END IF




LOOP

END FUNCTION

SUB idebox (x, y, w, h)
LOCATE y, x: PRINT "" + STRING$(w - 2, "") + "";
FOR y2 = y + 1 TO y + h - 2
LOCATE y2, x: PRINT "" + SPACE$(w - 2) + "";
NEXT
LOCATE y + h - 1, x: PRINT "" + STRING$(w - 2, "") + "";
END SUB

SUB ideboxshadow (x, y, w, h)

LOCATE y, x: PRINT "" + STRING$(w - 2, "") + "";
FOR y2 = y + 1 TO y + h - 2
LOCATE y2, x: PRINT "" + SPACE$(w - 2) + "";
NEXT
LOCATE y + h - 1, x: PRINT "" + STRING$(w - 2, "") + "";
'shadow
COLOR 8, 0
FOR y2 = y + 1 TO y + h - 1
FOR x2 = x + w TO x + w + 1
IF x2 <= idewx AND y2 <= idewy THEN
LOCATE y2, x2: PRINT CHR$(SCREEN(y2, x2));
END IF
NEXT
NEXT

y2 = y + h
IF y2 <= idewy THEN
FOR x2 = x + 2 TO x + w + 1
IF x2 <= idewx THEN
LOCATE y2, x2: PRINT CHR$(SCREEN(y2, x2));
END IF
NEXT
END IF


END SUB

FUNCTION idechange$


'-------- generic dialog box header --------
PCOPY 0, 2
PCOPY 0, 1
SCREEN , , 1, 0
focus = 1
DIM p AS idedbptype
DIM o(1 TO 100) AS idedbotype
DIM oo AS idedbotype
DIM sep AS STRING * 1
sep = CHR$(0)
'-------- end of generic dialog box header --------

'-------- init --------

'built initial search strings
IF ideselect THEN
IF ideselecty1 = idecy THEN 'single line selected
a$ = idegetline(idecy)
a2$ = ""
sx1 = ideselectx1: sx2 = idecx
IF sx2 < sx1 THEN SWAP sx1, sx2
FOR x = sx1 TO sx2 - 1
IF x <= LEN(a$) THEN a2$ = a2$ + MID$(a$, x, 1) ELSE a2$ = a2$ + " "
NEXT
END IF
END IF
IF a2$ = "" THEN
a2$ = idefindtext
END IF

i = 0
idepar p, 60, 11, "Change"
i = i + 1
o(i).typ = 1
o(i).y = 2
o(i).nam = idenewtxt("#Find What")
o(i).txt = idenewtxt(a2$)
o(i).v1 = LEN(a2$)

i = i + 1
o(i).typ = 1
o(i).y = 5
o(i).nam = idenewtxt("Change #To")
o(i).txt = idenewtxt(idechangeto)
o(i).v1 = LEN(idechangeto)

i = i + 1
o(i).typ = 4 'check box
o(i).y = 8
o(i).nam = idenewtxt("#Match Upper/Lowercase")
o(i).sel = idefindcasesens
i = i + 1
o(i).typ = 4 'check box
o(i).y = 9
o(i).nam = idenewtxt("#Whole Word")
o(i).sel = idefindwholeword

i = i + 1
o(i).typ = 3
o(i).y = 11
o(i).txt = idenewtxt("Find and #Verify" + sep + "#Change All" + sep + "Cancel")
o(i).def = 1
'-------- end of init --------

'-------- generic init --------
FOR i = 1 TO 100: o(i).par = p: NEXT 'set parent info of objects
'-------- end of generic init --------

DO 'main loop

'-------- generic display dialog box & objects --------

idedrawpar p
f = 1: cx = 0: cy = 0
FOR i = 1 TO 100

IF o(i).typ THEN

'prepare object
o(i).foc = focus - f 'focus offset

o(i).cx = 0: o(i).cy = 0

idedrawobj o(i), f 'display object

IF o(i).cx THEN cx = o(i).cx: cy = o(i).cy

END IF
NEXT i
lastfocus = f - 1
'-------- end of generic display dialog box & objects --------

'-------- custom display changes --------
'-------- end of custom display changes --------

'update visual page and cursor position
PCOPY 1, 0
IF cx THEN SCREEN , , 0, 0: LOCATE cy, cx, 1: SCREEN , , 1, 0

'-------- read input --------
change = 0
DO
getxymouse
mx = mousex: my = mousey: mb = mousebutton1
IF mb <> 0 AND omb = 0 THEN mousedown = 1: change = 1
IF mb = 0 AND omb <> 0 THEN mouseup = 1: change = 1
IF mb THEN change = 1
omb = mb
k$ = INKEY$: IF LEN(k$) THEN change = 1
DEF SEG = 0: alt = PEEK(&H417) AND 8: IF alt <> oldalt THEN change = 1
oldalt = alt

if change=0 then _LIMIT 16
LOOP UNTIL change
SCREEN , , 0, 0: LOCATE , , 0: SCREEN , , 1, 0
IF alt THEN idehl = 1 ELSE idehl = 0
'convert "alt+letter" scancode to letter's ASCII character
altletter$ = ""
IF alt THEN
IF LEN(k$) = 2 THEN
k = ASC(RIGHT$(k$, 1))
FOR c = 65 TO 90
IF k = idealtcode(c) THEN
altletter$ = CHR$(c)
EXIT FOR
END IF
NEXT
END IF
END IF
'-------- end of read input --------

'-------- generic input response --------
info = 0
IF k$ = "" THEN k$ = CHR$(255)
IF k$ = CHR$(9) THEN focus = focus + 1
IF k$ = CHR$(0) + CHR$(15) THEN focus = focus - 1
IF focus < 1 THEN focus = lastfocus
IF focus > lastfocus THEN focus = 1
f = 1
FOR i = 1 TO 100
t = o(i).typ
IF t THEN
focusoffset = focus - f
ideupdateobj o(i), focus, f, focusoffset, k$, altletter$, mb, mousedown, mouseup, mx, my, info
END IF
NEXT
'-------- end of generic input response --------

'specific post controls

IF k$ = CHR$(27) OR (focus = 7 AND info <> 0) THEN
idechange$ = "C"
EXIT FUNCTION
END IF




IF focus = 6 AND info <> 0 THEN
idefindcasesens = o(3).sel
idefindwholeword = o(4).sel
s$ = idetxt(o(1).txt)
idefindtext$ = s$
idechangeto$ = idetxt(o(2).txt)

changed = 0
s$ = idefindtext$
IF idefindcasesens = 0 THEN s$ = UCASE$(s$)

FOR y = 1 TO iden
l$ = idegetline(y)
l2$ = ""

x1 = 1
idechangeall:
IF idefindcasesens = 0 THEN l3$ = UCASE$(l$) ELSE l3$ = l$
x = INSTR(x1, l3$, s$)

IF x THEN
IF idefindwholeword THEN
whole = 1
IF x > 1 THEN
c = ASC(UCASE$(MID$(l$, x - 1, 1)))
IF c >= 65 AND c <= 90 THEN whole = 0
IF c >= 48 AND c <= 57 THEN whole = 0
END IF
IF x + LEN(s$) <= LEN(l$) THEN
c = ASC(UCASE$(MID$(l$, x + LEN(s$), 1)))
IF c >= 65 AND c <= 90 THEN whole = 0
IF c >= 48 AND c <= 57 THEN whole = 0
END IF
IF whole = 0 THEN
x1 = x + 1
x = 0
IF x1 <= LEN(l$) THEN GOTO idechangeall
END IF
END IF
END IF

IF x THEN
l2$ = l2$ + MID$(l$, x1, x - x1) + idechangeto$
x1 = x + LEN(s$)
IF x1 <= LEN(l$) THEN GOTO idechangeall
END IF

l2$ = l2$ + MID$(l$, x1, LEN(l$) - x1 + 1)
IF l2$ <> l$ THEN idesetline y, l2$: changed = 1

NEXT

IF changed = 0 THEN idenomatch ELSE idechanged: idechangemade = 1
EXIT FUNCTION

END IF 'change all


IF (focus = 5 AND info <> 0) OR k$ = CHR$(13) THEN
idefindcasesens = o(3).sel
idefindwholeword = o(4).sel
idefindtext$ = idetxt(o(1).txt)
idechangeto$ = idetxt(o(2).txt)
idechange$ = "V"
EXIT FUNCTION
END IF


'end of custom controls



mousedown = 0
mouseup = 0
LOOP


END FUNCTION

SUB idechanged

'-------- generic dialog box header --------
PCOPY 3, 0
PCOPY 0, 2
PCOPY 0, 1
SCREEN , , 1, 0
focus = 1
DIM p AS idedbptype
DIM o(1 TO 100) AS idedbotype
DIM oo AS idedbotype
DIM sep AS STRING * 1
sep = CHR$(0)
'-------- end of generic dialog box header --------

'-------- init --------
i = 0
idepar p, 19, 4, ""
i = i + 1
o(i).typ = 3
o(i).y = 4
o(i).txt = idenewtxt("OK")
o(i).def = 1
'-------- end of init --------

'-------- generic init --------
FOR i = 1 TO 100: o(i).par = p: NEXT 'set parent info of objects
'-------- end of generic init --------

DO 'main loop

'-------- generic display dialog box & objects --------
idedrawpar p
f = 1: cx = 0: cy = 0
FOR i = 1 TO 100
IF o(i).typ THEN
'prepare object
o(i).foc = focus - f 'focus offset
o(i).cx = 0: o(i).cy = 0
idedrawobj o(i), f 'display object
IF o(i).cx THEN cx = o(i).cx: cy = o(i).cy
END IF
NEXT i
lastfocus = f - 1
'-------- end of generic display dialog box & objects --------

'-------- custom display changes --------
COLOR 0, 7: LOCATE p.y + 2, p.x + 3: PRINT "Change Complete";
'-------- end of custom display changes --------

'update visual page and cursor position
PCOPY 1, 0
IF cx THEN SCREEN , , 0, 0: LOCATE cy, cx, 1: SCREEN , , 1, 0

'-------- read input --------
change = 0
DO
getxymouse
mx = mousex: my = mousey: mb = mousebutton1
IF mb <> 0 AND omb = 0 THEN mousedown = 1: change = 1
IF mb = 0 AND omb <> 0 THEN mouseup = 1: change = 1
IF mb THEN change = 1
omb = mb
k$ = INKEY$: IF LEN(k$) THEN change = 1
'DEF SEG = 0: alt = PEEK(&H417) AND 8
alt = 8
IF alt <> oldalt THEN change = 1
oldalt = alt

if change=0 then _LIMIT 16
LOOP UNTIL change
SCREEN , , 0, 0: LOCATE , , 0: SCREEN , , 1, 0
IF alt THEN idehl = 1 ELSE idehl = 0
'convert "alt+letter" scancode to letter's ASCII character
altletter$ = ""
IF alt THEN
IF LEN(k$) = 2 THEN
k = ASC(RIGHT$(k$, 1))
FOR c = 65 TO 90
IF k = idealtcode(c) THEN
altletter$ = CHR$(c)
EXIT FOR
END IF
NEXT
END IF
END IF
IF UCASE$(k$) = "Y" THEN altletter$ = "Y"
IF UCASE$(k$) = "N" THEN altletter$ = "N"

'-------- end of read input --------

'-------- generic input response --------
info = 0
IF k$ = "" THEN k$ = CHR$(255)
IF k$ = CHR$(9) THEN focus = focus + 1
IF k$ = CHR$(0) + CHR$(15) THEN focus = focus - 1
IF focus < 1 THEN focus = lastfocus
IF focus > lastfocus THEN focus = 1
f = 1
FOR i = 1 TO 100
t = o(i).typ
IF t THEN
focusoffset = focus - f
ideupdateobj o(i), focus, f, focusoffset, k$, altletter$, mb, mousedown, mouseup, mx, my, info
END IF
NEXT
'-------- end of generic input response --------

IF k$ = CHR$(27) THEN
EXIT SUB
END IF

IF info THEN
EXIT SUB
END IF

'end of custom controls

mousedown = 0
mouseup = 0
LOOP

END SUB

FUNCTION idechangeit$

'-------- generic dialog box header --------
PCOPY 3, 0
PCOPY 0, 2
PCOPY 0, 1
SCREEN , , 1, 0
focus = 1
DIM p AS idedbptype
DIM o(1 TO 100) AS idedbotype
DIM oo AS idedbotype
DIM sep AS STRING * 1
sep = CHR$(0)
'-------- end of generic dialog box header --------

'-------- init --------
i = 0
w = 45
p.x = 40 - w \ 2
p.y = 21
p.w = w
p.h = 2
p.nam = idenewtxt("Change")

i = i + 1
o(i).typ = 3
o(i).y = 2
o(i).txt = idenewtxt("#Change" + sep + "#Skip" + sep + "Cancel")
o(i).def = 1
'-------- end of init --------

'-------- generic init --------
FOR i = 1 TO 100: o(i).par = p: NEXT 'set parent info of objects
'-------- end of generic init --------

DO 'main loop

'-------- generic display dialog box & objects --------
idedrawpar p
f = 1: cx = 0: cy = 0
FOR i = 1 TO 100
IF o(i).typ THEN
'prepare object
o(i).foc = focus - f 'focus offset
o(i).cx = 0: o(i).cy = 0
idedrawobj o(i), f 'display object
IF o(i).cx THEN cx = o(i).cx: cy = o(i).cy
END IF
NEXT i
lastfocus = f - 1
'-------- end of generic display dialog box & objects --------

'-------- custom display changes --------
'-------- end of custom display changes --------

'update visual page and cursor position
PCOPY 1, 0
IF cx THEN SCREEN , , 0, 0: LOCATE cy, cx, 1: SCREEN , , 1, 0

'-------- read input --------
change = 0
DO
getxymouse
mx = mousex: my = mousey: mb = mousebutton1
IF mb <> 0 AND omb = 0 THEN mousedown = 1: change = 1
IF mb = 0 AND omb <> 0 THEN mouseup = 1: change = 1
IF mb THEN change = 1
omb = mb
k$ = INKEY$: IF LEN(k$) THEN change = 1
'DEF SEG = 0: alt = PEEK(&H417) AND 8
alt = 8
IF alt <> oldalt THEN change = 1
oldalt = alt

if change=0 then _LIMIT 16
LOOP UNTIL change
SCREEN , , 0, 0: LOCATE , , 0: SCREEN , , 1, 0
IF alt THEN idehl = 1 ELSE idehl = 0
'convert "alt+letter" scancode to letter's ASCII character
altletter$ = ""
IF alt THEN
IF LEN(k$) = 2 THEN
k = ASC(RIGHT$(k$, 1))
FOR c = 65 TO 90
IF k = idealtcode(c) THEN
altletter$ = CHR$(c)
EXIT FOR
END IF
NEXT
END IF
END IF
IF UCASE$(k$) = "C" THEN altletter$ = "C"
IF UCASE$(k$) = "S" THEN altletter$ = "S"


'-------- end of read input --------

'-------- generic input response --------
info = 0
IF k$ = "" THEN k$ = CHR$(255)
IF k$ = CHR$(9) THEN focus = focus + 1
IF k$ = CHR$(0) + CHR$(15) THEN focus = focus - 1
IF focus < 1 THEN focus = lastfocus
IF focus > lastfocus THEN focus = 1
f = 1
FOR i = 1 TO 100
t = o(i).typ
IF t THEN
focusoffset = focus - f
ideupdateobj o(i), focus, f, focusoffset, k$, altletter$, mb, mousedown, mouseup, mx, my, info
END IF
NEXT
'-------- end of generic input response --------

IF k$ = CHR$(27) THEN
idechangeit$ = "C"
EXIT FUNCTION
END IF

IF info THEN
IF info = 1 THEN idechangeit$ = "Y"
IF info = 2 THEN idechangeit$ = "N"
IF info = 3 THEN idechangeit$ = "C"
EXIT FUNCTION
END IF

'end of custom controls
mousedown = 0
mouseup = 0
LOOP


END FUNCTION

SUB idedelline (i)
idegotoline i
textlen = CVL(MID$(idet$, ideli, 4))
idet$ = LEFT$(idet$, ideli - 1) + RIGHT$(idet$, LEN(idet$) - ideli + 1 - 8 - textlen)
iden = iden - 1


END SUB

SUB idedeltxt
idetxtlast = 0
END SUB

SUB idedrawobj (o AS idedbotype, f)
DIM sep AS STRING * 1
sep = CHR$(0)

'#1: SINGLE LINE TEXT INPUT BOX
IF o.typ = 1 THEN
IF o.x = 0 THEN o.x = 2
x = o.par.x + o.x: y = o.par.y + o.y
COLOR 0, 7
IF o.nam THEN
a$ = idetxt(o.nam)
LOCATE y, x:  idehPRINT a$ + ":"
x = x + idehlen(a$) + 2
END IF
IF o.w = 0 THEN x2 = o.par.x + o.par.w - 1: o.w = x2 - x - 3
idebox x, y - 1, o.w + 4, 3
IF o.txt = 0 THEN o.txt = idenewtxt("")
a$ = idetxt(o.txt)
if o.v1>len(a$) then o.v1=len(a$) 'new
cx = o.v1

IF LEN(a$) > o.w THEN
IF o.foc = 0 THEN
tx = o.v1 - o.w + 1
IF tx < 1 THEN tx = 1
a$ = MID$(a$, tx, o.w)
cx = cx - tx + 1
ELSE
a$ = LEFT$(a$, o.w)
END IF
END IF

x = x + 2
LOCATE y, x: PRINT a$;
IF o.foc = 0 THEN o.cx = x + cx: o.cy = y
f = f + 1
END IF '#1

'#2: VERTICAL SCROLLING SELECTION BOX
IF o.typ = 2 THEN
IF o.x = 0 THEN o.x = 2
IF o.w = 0 THEN o.w = o.par.w - 2 - o.x
IF o.h = 0 THEN o.h = o.par.h - 1 - o.y
x = o.par.x + o.x: y = o.par.y + o.y
COLOR 0, 7
idebox x, y, o.w + 2, o.h + 2
IF o.nam THEN
a$ = idetxt(o.nam)
w = o.w + 2
m = w \ 2: IF w AND 1 THEN m = m + 1
LOCATE y, x + m - 1 - ((idehlen(a$) + 2) - 1) \ 2: idehPRINT " " + a$ + " "
END IF 'nam
'display list items
IF o.sel = 0 THEN o.sel = -1
IF o.txt = 0 THEN o.txt = idenewtxt("")
IF o.stx = 0 THEN o.stx = idenewtxt("")
IF o.v1 = 0 THEN o.v1 = 1
s = ABS(o.sel)
IF s >= o.v1 + o.h THEN o.v1 = s - o.h + 1
IF s < o.v1 THEN o.v1 = s
IF o.foc <> 0 AND o.sel > 0 THEN o.sel = -o.sel
a$ = idetxt(o.txt)
n = 1
y = 1
v1 = o.v1
a3$ = ""
FOR i2 = 1 TO LEN(a$)
a2$ = MID$(a$, i2, 1)
IF a2$ <> sep THEN a3$ = a3$ + a2$
IF a2$ = sep OR i2 = LEN(a$) THEN
 IF n < v1 THEN
 'skip
 ELSE
 IF y <= o.h THEN
 IF o.sel = n THEN COLOR 7, 0 ELSE COLOR 0, 7
 IF (o.sel = n OR -o.sel = n) AND o.foc = 0 THEN o.cx = o.par.x + o.x + 2: o.cy = o.par.y + o.y + y
 LOCATE o.par.y + o.y + y, o.par.x + o.x + 1
 a3$ = " " + a3$ + SPACE$(o.w)
 a3$ = LEFT$(a3$, o.w)
 PRINT a3$;
 y = y + 1
 END IF
 END IF
n = n + 1
a3$ = ""
END IF
NEXT
o.num = n - 1

tnum = o.num
tsel = ABS(o.sel)

q = idevbar(o.par.x + o.x + o.w + 1, o.par.y + o.y + 1, o.h, tsel, tnum)

f = f + 1
END IF '#2

'#3: ACTION BUTTONS
IF o.typ = 3 THEN
IF o.x = 0 THEN o.x = 2
IF o.w = 0 THEN o.w = o.par.w - o.x 'spanable width
IF o.txt = 0 THEN o.txt = idenewtxt("OK")
a$ = idetxt(o.txt)
n = 1
c = 0
FOR i2 = 1 TO LEN(a$)
a2$ = MID$(a$, i2, 1)
IF a2$ = CHR$(0) THEN
n = n + 1
ELSE
IF a$ <> "#" THEN c = c + 1
END IF
NEXT
w = o.w
c = c + n * 4 'add characters for bracing < > buttons
whitespace = w - c
spacing = whitespace \ (n + 1)
f2 = o.foc + 1
IF f2 < 1 OR f2 > n THEN
IF o.def THEN f2 = o.def
END IF
n2 = 1
a3$ = ""
LOCATE o.par.y + o.y, o.par.x + o.x
x = o.par.x + o.x
COLOR 0, 7
FOR i2 = 1 TO LEN(a$)
a2$ = MID$(a$, i2, 1)
IF a2$ <> CHR$(0) THEN a3$ = a3$ + a2$
IF a2$ = CHR$(0) OR i2 = LEN(a$) THEN
PRINT SPACE$(spacing);
x = x + spacing
IF f2 = n2 THEN COLOR 15, 7 ELSE COLOR 0, 7
PRINT "< ";
COLOR 0, 7: idehPRINT a3$
IF f2 = n2 THEN COLOR 15, 7 ELSE COLOR 0, 7
IF n2 = o.foc + 1 THEN
o.cx = x + 2: o.cy = o.par.y + o.y
END IF
PRINT " >";
COLOR 0, 7
x = x + idehlen(a3$) + 4
a3$ = ""
n2 = n2 + 1
END IF
NEXT
f = f + n
END IF '#3

'#4: CHECK BOX
IF o.typ = 4 THEN
IF o.x = 0 THEN o.x = 2
x = o.par.x + o.x: y = o.par.y + o.y
LOCATE y, x
COLOR 0, 7
IF o.sel THEN
PRINT "[X] ";
ELSE
PRINT "[ ] ";
END IF
IF o.nam THEN
a$ = idetxt(o.nam)
idehPRINT a$
END IF
IF o.foc = 0 THEN o.cx = x + 1: o.cy = y
f = f + 1
END IF '#4

END SUB

SUB idedrawpar (p AS idedbptype)
COLOR 0, 7: ideboxshadow p.x, p.y, p.w + 2, p.h + 2
IF p.nam THEN
x = LEN(idetxt(p.nam)) + 2
COLOR 0, 7: LOCATE p.y, (idewx\2) - (x - 1) \ 2: PRINT " " + idetxt(p.nam) + " ";
END IF
END SUB

SUB ideerrormessage (mess$)


'-------- generic dialog box header --------
PCOPY 3, 0
PCOPY 0, 2
PCOPY 0, 1
SCREEN , , 1, 0
focus = 1
DIM p AS idedbptype
DIM o(1 TO 100) AS idedbotype
DIM oo AS idedbotype
DIM sep AS STRING * 1
sep = CHR$(0)
'-------- end of generic dialog box header --------

'-------- init --------
i = 0
idepar p, LEN(mess$) + 4, 4, ""
i = i + 1
o(i).typ = 3
o(i).y = 4
o(i).txt = idenewtxt("OK")
o(i).def = 1
'-------- end of init --------

'-------- generic init --------
FOR i = 1 TO 100: o(i).par = p: NEXT 'set parent info of objects
'-------- end of generic init --------

DO 'main loop

'-------- generic display dialog box & objects --------
idedrawpar p
f = 1: cx = 0: cy = 0
FOR i = 1 TO 100
IF o(i).typ THEN
'prepare object
o(i).foc = focus - f 'focus offset
o(i).cx = 0: o(i).cy = 0
idedrawobj o(i), f 'display object
IF o(i).cx THEN cx = o(i).cx: cy = o(i).cy
END IF
NEXT i
lastfocus = f - 1
'-------- end of generic display dialog box & objects --------

'-------- custom display changes --------
COLOR 0, 7: LOCATE p.y + 2, p.x + 3: PRINT mess$;
'-------- end of custom display changes --------

'update visual page and cursor position
PCOPY 1, 0
IF cx THEN SCREEN , , 0, 0: LOCATE cy, cx, 1: SCREEN , , 1, 0

'-------- read input --------
change = 0
DO
getxymouse
mx = mousex: my = mousey: mb = mousebutton1
IF mb <> 0 AND omb = 0 THEN mousedown = 1: change = 1
IF mb = 0 AND omb <> 0 THEN mouseup = 1: change = 1
IF mb THEN change = 1
omb = mb
k$ = INKEY$: IF LEN(k$) THEN change = 1
'DEF SEG = 0: alt = PEEK(&H417) AND 8
alt = 8
IF alt <> oldalt THEN change = 1
oldalt = alt

if change=0 then _LIMIT 16
LOOP UNTIL change
SCREEN , , 0, 0: LOCATE , , 0: SCREEN , , 1, 0
IF alt THEN idehl = 1 ELSE idehl = 0
'convert "alt+letter" scancode to letter's ASCII character
altletter$ = ""
IF alt THEN
IF LEN(k$) = 2 THEN
k = ASC(RIGHT$(k$, 1))
FOR c = 65 TO 90
IF k = idealtcode(c) THEN
altletter$ = CHR$(c)
EXIT FOR
END IF
NEXT
END IF
END IF
IF UCASE$(k$) = "Y" THEN altletter$ = "Y"
IF UCASE$(k$) = "N" THEN altletter$ = "N"

'-------- end of read input --------

'-------- generic input response --------
info = 0
IF k$ = "" THEN k$ = CHR$(255)
IF k$ = CHR$(9) THEN focus = focus + 1
IF k$ = CHR$(0) + CHR$(15) THEN focus = focus - 1
IF focus < 1 THEN focus = lastfocus
IF focus > lastfocus THEN focus = 1
f = 1
FOR i = 1 TO 100
t = o(i).typ
IF t THEN
focusoffset = focus - f
ideupdateobj o(i), focus, f, focusoffset, k$, altletter$, mb, mousedown, mouseup, mx, my, info
END IF
NEXT
'-------- end of generic input response --------

IF k$ = CHR$(27) THEN
EXIT SUB
END IF

IF info THEN
EXIT SUB
END IF

'end of custom controls

mousedown = 0
mouseup = 0
LOOP


END SUB

FUNCTION idefileexists$
'-------- generic dialog box header --------
PCOPY 3, 0
PCOPY 0, 2
PCOPY 0, 1
SCREEN , , 1, 0
focus = 1
DIM p AS idedbptype
DIM o(1 TO 100) AS idedbotype
DIM oo AS idedbotype
DIM sep AS STRING * 1
sep = CHR$(0)
'-------- end of generic dialog box header --------

'-------- init --------
i = 0
'idepar p, 30, 6, "File already exists. Overwrite?"
idepar p, 35, 4, ""
i = i + 1
o(i).typ = 3
o(i).y = 4
o(i).txt = idenewtxt("#Yes" + sep + "#No")
o(i).def = 1
'-------- end of init --------

'-------- generic init --------
FOR i = 1 TO 100: o(i).par = p: NEXT 'set parent info of objects
'-------- end of generic init --------

DO 'main loop

'-------- generic display dialog box & objects --------
idedrawpar p
f = 1: cx = 0: cy = 0
FOR i = 1 TO 100
IF o(i).typ THEN
'prepare object
o(i).foc = focus - f 'focus offset
o(i).cx = 0: o(i).cy = 0
idedrawobj o(i), f 'display object
IF o(i).cx THEN cx = o(i).cx: cy = o(i).cy
END IF
NEXT i
lastfocus = f - 1
'-------- end of generic display dialog box & objects --------

'-------- custom display changes --------
COLOR 0, 7: LOCATE p.y + 2, p.x + 3: PRINT "File already exists. Overwrite?";
'-------- end of custom display changes --------

'update visual page and cursor position
PCOPY 1, 0
IF cx THEN SCREEN , , 0, 0: LOCATE cy, cx, 1: SCREEN , , 1, 0

'-------- read input --------
change = 0
DO
getxymouse
mx = mousex: my = mousey: mb = mousebutton1
IF mb <> 0 AND omb = 0 THEN mousedown = 1: change = 1
IF mb = 0 AND omb <> 0 THEN mouseup = 1: change = 1
IF mb THEN change = 1
omb = mb
k$ = INKEY$: IF LEN(k$) THEN change = 1
'DEF SEG = 0: alt = PEEK(&H417) AND 8
alt = 8
IF alt <> oldalt THEN change = 1
oldalt = alt

if change=0 then _LIMIT 16
LOOP UNTIL change
SCREEN , , 0, 0: LOCATE , , 0: SCREEN , , 1, 0
IF alt THEN idehl = 1 ELSE idehl = 0
'convert "alt+letter" scancode to letter's ASCII character
altletter$ = ""
IF alt THEN
IF LEN(k$) = 2 THEN
k = ASC(RIGHT$(k$, 1))
FOR c = 65 TO 90
IF k = idealtcode(c) THEN
altletter$ = CHR$(c)
EXIT FOR
END IF
NEXT
END IF
END IF
IF UCASE$(k$) = "Y" THEN altletter$ = "Y"
IF UCASE$(k$) = "N" THEN altletter$ = "N"

'-------- end of read input --------

'-------- generic input response --------
info = 0
IF k$ = "" THEN k$ = CHR$(255)
IF k$ = CHR$(9) THEN focus = focus + 1
IF k$ = CHR$(0) + CHR$(15) THEN focus = focus - 1
IF focus < 1 THEN focus = lastfocus
IF focus > lastfocus THEN focus = 1
f = 1
FOR i = 1 TO 100
t = o(i).typ
IF t THEN
focusoffset = focus - f
ideupdateobj o(i), focus, f, focusoffset, k$, altletter$, mb, mousedown, mouseup, mx, my, info
END IF
NEXT
'-------- end of generic input response --------

IF k$ = CHR$(27) THEN
idefileexists$ = "N"
EXIT FUNCTION
END IF

IF info THEN
IF info = 1 THEN idefileexists$ = "Y" ELSE idefileexists$ = "N"
EXIT FUNCTION
END IF

'end of custom controls
mousedown = 0
mouseup = 0
LOOP


END FUNCTION

FUNCTION idefind$


'-------- generic dialog box header --------
PCOPY 0, 2
PCOPY 0, 1
SCREEN , , 1, 0
focus = 1
DIM p AS idedbptype
DIM o(1 TO 100) AS idedbotype
DIM oo AS idedbotype
DIM sep AS STRING * 1
sep = CHR$(0)
'-------- end of generic dialog box header --------

'-------- init --------

'built initial search string
IF ideselect THEN
IF ideselecty1 = idecy THEN 'single line selected
a$ = idegetline(idecy)
a2$ = ""
sx1 = ideselectx1: sx2 = idecx
IF sx2 < sx1 THEN SWAP sx1, sx2
FOR x = sx1 TO sx2 - 1
IF x <= LEN(a$) THEN a2$ = a2$ + MID$(a$, x, 1) ELSE a2$ = a2$ + " "
NEXT
END IF
END IF
IF a2$ = "" THEN
a2$ = idefindtext
END IF


i = 0
idepar p, 60, 8, "Find"
i = i + 1
o(i).typ = 1
o(i).y = 2
o(i).nam = idenewtxt("#Find What")
o(i).txt = idenewtxt(a2$)
o(i).v1 = LEN(a2$)



i = i + 1
o(i).typ = 4 'check box
o(i).y = 5
o(i).nam = idenewtxt("#Match Upper/Lowercase")
o(i).sel = idefindcasesens
i = i + 1
o(i).typ = 4 'check box
o(i).y = 6
o(i).nam = idenewtxt("#Whole Word")
o(i).sel = idefindwholeword
i = i + 1
o(i).typ = 3
o(i).y = 8
o(i).txt = idenewtxt("OK" + sep + "#Cancel")
o(i).def = 1
'-------- end of init --------

'-------- generic init --------
FOR i = 1 TO 100: o(i).par = p: NEXT 'set parent info of objects
'-------- end of generic init --------

DO 'main loop


'-------- generic display dialog box & objects --------
idedrawpar p
f = 1: cx = 0: cy = 0
FOR i = 1 TO 100
IF o(i).typ THEN

'prepare object
o(i).foc = focus - f 'focus offset
o(i).cx = 0: o(i).cy = 0
idedrawobj o(i), f 'display object
IF o(i).cx THEN cx = o(i).cx: cy = o(i).cy
END IF
NEXT i
lastfocus = f - 1
'-------- end of generic display dialog box & objects --------

'-------- custom display changes --------
'-------- end of custom display changes --------

'update visual page and cursor position
PCOPY 1, 0
IF cx THEN SCREEN , , 0, 0: LOCATE cy, cx, 1: SCREEN , , 1, 0

'-------- read input --------
change = 0
DO
getxymouse
mx = mousex: my = mousey: mb = mousebutton1
IF mb <> 0 AND omb = 0 THEN mousedown = 1: change = 1
IF mb = 0 AND omb <> 0 THEN mouseup = 1: change = 1
IF mb THEN change = 1
omb = mb
k$ = INKEY$: IF LEN(k$) THEN change = 1
DEF SEG = 0: alt = PEEK(&H417) AND 8: IF alt <> oldalt THEN change = 1
oldalt = alt

if change=0 then _LIMIT 16
LOOP UNTIL change
SCREEN , , 0, 0: LOCATE , , 0: SCREEN , , 1, 0
IF alt THEN idehl = 1 ELSE idehl = 0
'convert "alt+letter" scancode to letter's ASCII character
altletter$ = ""
IF alt THEN
IF LEN(k$) = 2 THEN
k = ASC(RIGHT$(k$, 1))
FOR c = 65 TO 90
IF k = idealtcode(c) THEN
altletter$ = CHR$(c)
EXIT FOR
END IF
NEXT
END IF
END IF
'-------- end of read input --------

'-------- generic input response --------
info = 0
IF k$ = "" THEN k$ = CHR$(255)
IF k$ = CHR$(9) THEN focus = focus + 1
IF k$ = CHR$(0) + CHR$(15) THEN focus = focus - 1
IF focus < 1 THEN focus = lastfocus
IF focus > lastfocus THEN focus = 1
f = 1
FOR i = 1 TO 100
t = o(i).typ
IF t THEN
focusoffset = focus - f
ideupdateobj o(i), focus, f, focusoffset, k$, altletter$, mb, mousedown, mouseup, mx, my, info
END IF
NEXT
'-------- end of generic input response --------

'specific post controls

IF k$ = CHR$(27) OR (focus = 5 AND info <> 0) THEN
idefind$ = "C"
EXIT FUNCTION
END IF

IF k$ = CHR$(13) OR (focus = 4 AND info <> 0) THEN
idefindcasesens = o(2).sel
idefindwholeword = o(3).sel
s$ = idetxt(o(1).txt)
idefindtext$ = s$

s$ = idefindtext$
IF idefindcasesens = 0 THEN s$ = UCASE$(s$)
start = idecy
y = start

idefindnext:
l$ = idegetline(y)
IF idefindcasesens = 0 THEN l$ = UCASE$(l$)

IF y = start THEN
 IF looped = 1 THEN
  IF LEN(l$) > idecx THEN l$ = LEFT$(l$, idecx)
 ELSE
  IF LEN(l$) > idecx THEN l$ = STRING$(idecx, 255) + RIGHT$(l$, LEN(l$) - idecx) ELSE l$ = ""
 END IF
END IF

x1 = 1
idefindagain:
x = INSTR(x1, l$, s$)

IF x THEN
IF idefindwholeword THEN
whole = 1
IF x > 1 THEN
c = ASC(UCASE$(MID$(l$, x - 1, 1)))
IF c >= 65 AND c <= 90 THEN whole = 0
IF c >= 48 AND c <= 57 THEN whole = 0
END IF
IF x + LEN(s$) <= LEN(l$) THEN
c = ASC(UCASE$(MID$(l$, x + LEN(s$), 1)))
IF c >= 65 AND c <= 90 THEN whole = 0
IF c >= 48 AND c <= 57 THEN whole = 0
END IF
IF whole = 0 THEN
x1 = x + 1
x = 0
IF x1 <= LEN(l$) THEN GOTO idefindagain
END IF
END IF
END IF

IF x THEN
ideselect = 1
idecx = x: idecy = y
ideselectx1 = x + LEN(s$): ideselecty1 = y
EXIT FUNCTION
END IF

y = y + 1
IF y = start + 1 AND looped = 1 THEN
idenomatch

EXIT FUNCTION
END IF
IF y > iden THEN y = 1: looped = 1

GOTO idefindnext
END IF

'end of custom controls



mousedown = 0
mouseup = 0
LOOP
END FUNCTION

SUB idefindagain

s$ = idefindtext$
IF idefindcasesens = 0 THEN s$ = UCASE$(s$)
start = idecy
y = start

idefindnext2:
l$ = idegetline(y)
IF idefindcasesens = 0 THEN l$ = UCASE$(l$)

IF y = start THEN
 IF looped = 1 THEN
  IF LEN(l$) > idecx THEN l$ = LEFT$(l$, idecx)
 ELSE
  IF LEN(l$) > idecx THEN l$ = STRING$(idecx, 255) + RIGHT$(l$, LEN(l$) - idecx) ELSE l$ = ""
 END IF
END IF

x1 = 1
idefindagain2:
x = INSTR(x1, l$, s$)

IF x THEN
IF idefindwholeword THEN
whole = 1
IF x > 1 THEN
c = ASC(UCASE$(MID$(l$, x - 1, 1)))
IF c >= 65 AND c <= 90 THEN whole = 0
IF c >= 48 AND c <= 57 THEN whole = 0
END IF
IF x + LEN(s$) <= LEN(l$) THEN
c = ASC(UCASE$(MID$(l$, x + LEN(s$), 1)))
IF c >= 65 AND c <= 90 THEN whole = 0
IF c >= 48 AND c <= 57 THEN whole = 0
END IF
IF whole = 0 THEN
x1 = x + 1
x = 0
IF x1 <= LEN(l$) THEN GOTO idefindagain2
END IF
END IF
END IF

IF x THEN
ideselect = 1
idecx = x: idecy = y
ideselectx1 = x + LEN(s$): ideselecty1 = y
EXIT SUB
END IF

y = y + 1
IF y = start + 1 AND looped = 1 THEN
idenomatch

EXIT SUB
END IF
IF y > iden THEN y = 1: looped = 1

GOTO idefindnext2

END SUB

FUNCTION idegetline$ (i)
IF i <> -1 THEN idegotoline i
idegetline$ = MID$(idet$, ideli + 4, CVL(MID$(idet$, ideli, 4)))
END FUNCTION

SUB idegotoline (i)
IF idel = i THEN EXIT SUB
IF i < 1 THEN ERROR 5
'scan backwards
IF i < idel THEN
DO
idel = idel - 1
ideli = ideli - CVL(MID$(idet$, ideli - 4, 4)) - 8
LOOP UNTIL idel = i
EXIT SUB
END IF
'assume scan forwards
DO
IF idel = iden THEN idet$ = idet$ + MKL$(0) + MKL$(0): iden = iden + 1 'insert blank line at end?
idel = idel + 1
ideli = ideli + CVL(MID$(idet$, ideli, 4)) + 8
LOOP UNTIL idel = i
END SUB

FUNCTION idehbar (x, y, h, i2, n2)
i = i2: n = n2

'COLOR 0, 7
'LOCATE y, x: PRINT CHR$(27);
'LOCATE y, x + w - 1: PRINT CHR$(26);
'FOR x2 = x + 1 TO x + w - 2
'LOCATE y, x2: PRINT "";
'NEXT
'IF w > 3 THEN
'p2! = w - 2 - .00001
'x2 = x + 1 + INT(p2! * p!)
'LOCATE y, x2: PRINT "";
'END IF


'h is size in characters (inc. arrows)

'draw background & arrows
COLOR 0, 7
LOCATE y, x: PRINT CHR$(27);
LOCATE y, x + h - 1: PRINT CHR$(26);
FOR x2 = x + 1 TO x + h - 2
LOCATE y, x2: PRINT "";
NEXT

'draw slider

IF n < 1 THEN n = 1
IF i < 1 THEN i = 1
IF i > n THEN i = n

IF h = 2 THEN
idehbar = x 'not position for slider exists
EXIT FUNCTION
END IF

IF h = 3 THEN
idehbar = x + 1 'dummy value
'no slider
EXIT FUNCTION
END IF

IF h = 4 THEN
IF n = 1 THEN
idehbar = x + 1 'dummy value
'no slider required for 1 item
EXIT FUNCTION
ELSE
'show whichever is closer of the two positions
p! = (i - 1) / (n - 1)
IF p! < .5 THEN x2 = x + 1 ELSE x2 = x + 2
LOCATE y, x2: PRINT "";
idehbar = x2
EXIT FUNCTION
END IF
END IF

IF h > 4 THEN
IF n = 1 THEN
idehbar = x + h \ 4'dummy value
'no slider required for 1 item
EXIT FUNCTION
END IF
IF i = 1 THEN
x2 = x + 1
LOCATE y, x2: PRINT "";
idehbar = x2
EXIT FUNCTION
END IF
IF i = n THEN
x2 = x + h - 2
LOCATE y, x2: PRINT "";
idehbar = x2
EXIT FUNCTION
END IF
'between i=1 and i=n
p! = (i - 1) / (n - 1)
p! = p! * (h - 4)
x2 = x + 2 + INT(p!)
LOCATE y, x2: PRINT "";
idehbar = x2
EXIT FUNCTION
END IF


END FUNCTION

FUNCTION idehlen (a$)
IF INSTR(a$, "#") THEN idehlen = LEN(a$) - 1 ELSE idehlen = LEN(a$)
END FUNCTION

SUB idehPRINT (a$)
COLOR 0, 7
FOR i = 1 TO LEN(a$)
c$ = MID$(a$, i, 1)
IF c$ = "#" THEN
IF idehl THEN COLOR 15, 7
ELSE
PRINT c$; : COLOR 0, 7
END IF
NEXT
END SUB

SUB ideinsline (i, text$)
'note: cursor remains on line i

text$ = RTRIM$(text$)

IF i = -1 THEN i = idel
'if at end, use idesetline
IF i > iden THEN
idesetline i, text$
EXIT SUB
END IF
idegotoline i
'insert line
textlen = LEN(text$)
idet$ = LEFT$(idet$, ideli - 1) + MKL$(textlen) + text$ + MKL$(textlen) + RIGHT$(idet$, LEN(idet$) - ideli + 1)
iden = iden + 1
END SUB

SUB idenewsf (sf AS STRING)


'-------- generic dialog box header --------
PCOPY 0, 2
PCOPY 0, 1
SCREEN , , 1, 0
focus = 1
DIM p AS idedbptype
DIM o(1 TO 100) AS idedbotype
DIM oo AS idedbotype
DIM sep AS STRING * 1
sep = CHR$(0)
'-------- end of generic dialog box header --------

'-------- init --------

'built initial name if word selected
IF ideselect THEN
IF ideselecty1 = idecy THEN 'single line selected
a$ = idegetline(idecy)
a2$ = ""
sx1 = ideselectx1: sx2 = idecx
IF sx2 < sx1 THEN SWAP sx1, sx2
FOR x = sx1 TO sx2 - 1
IF x <= LEN(a$) THEN a2$ = a2$ + MID$(a$, x, 1) ELSE a2$ = a2$ + " "
NEXT
END IF
END IF

i = 0

idepar p, 60, 5, "New " + sf$

i = i + 1
o(i).typ = 1
o(i).y = 2
o(i).nam = idenewtxt("#Name")
o(i).txt = idenewtxt(a2$)
o(i).v1 = LEN(a2$)

i = i + 1
o(i).typ = 3
o(i).y = 5
o(i).txt = idenewtxt("OK" + sep + "#Cancel")
o(i).def = 1
'-------- end of init --------

'-------- generic init --------
FOR i = 1 TO 100: o(i).par = p: NEXT 'set parent info of objects
'-------- end of generic init --------

DO 'main loop


'-------- generic display dialog box & objects --------
idedrawpar p
f = 1: cx = 0: cy = 0
FOR i = 1 TO 100
IF o(i).typ THEN

'prepare object
o(i).foc = focus - f 'focus offset
o(i).cx = 0: o(i).cy = 0
idedrawobj o(i), f 'display object
IF o(i).cx THEN cx = o(i).cx: cy = o(i).cy
END IF
NEXT i
lastfocus = f - 1
'-------- end of generic display dialog box & objects --------

'-------- custom display changes --------
'-------- end of custom display changes --------

'update visual page and cursor position
PCOPY 1, 0
IF cx THEN SCREEN , , 0, 0: LOCATE cy, cx, 1: SCREEN , , 1, 0

'-------- read input --------
change = 0
DO
getxymouse
mx = mousex: my = mousey: mb = mousebutton1
IF mb <> 0 AND omb = 0 THEN mousedown = 1: change = 1
IF mb = 0 AND omb <> 0 THEN mouseup = 1: change = 1
IF mb THEN change = 1
omb = mb
k$ = INKEY$: IF LEN(k$) THEN change = 1
DEF SEG = 0: alt = PEEK(&H417) AND 8: IF alt <> oldalt THEN change = 1
oldalt = alt

if change=0 then _LIMIT 16
LOOP UNTIL change
SCREEN , , 0, 0: LOCATE , , 0: SCREEN , , 1, 0
IF alt THEN idehl = 1 ELSE idehl = 0
'convert "alt+letter" scancode to letter's ASCII character
altletter$ = ""
IF alt THEN
IF LEN(k$) = 2 THEN
k = ASC(RIGHT$(k$, 1))
FOR c = 65 TO 90
IF k = idealtcode(c) THEN
altletter$ = CHR$(c)
EXIT FOR
END IF
NEXT
END IF
END IF
'-------- end of read input --------

'-------- generic input response --------
info = 0
IF k$ = "" THEN k$ = CHR$(255)
IF k$ = CHR$(9) THEN focus = focus + 1
IF k$ = CHR$(0) + CHR$(15) THEN focus = focus - 1
IF focus < 1 THEN focus = lastfocus
IF focus > lastfocus THEN focus = 1
f = 1
FOR i = 1 TO 100
t = o(i).typ
IF t THEN
focusoffset = focus - f
ideupdateobj o(i), focus, f, focusoffset, k$, altletter$, mb, mousedown, mouseup, mx, my, info
END IF
NEXT
'-------- end of generic input response --------

'specific post controls

IF k$ = CHR$(27) OR (focus = 3 AND info <> 0) THEN
EXIT SUB
END IF

IF k$ = CHR$(13) OR (focus = 2 AND info <> 0) THEN
y = iden
y = y + 1: idesetline y, ""
y = y + 1: idesetline y, sf$ + " " + idetxt(o(1).txt)
idesy = y
y = y + 1: idesetline y, ""
idecy = y
y = y + 1: idesetline y, "END " + sf$
idecx = 1: idesx = 1
idechangemade = 1
EXIT SUB
END IF

'end of custom controls

mousedown = 0
mouseup = 0
LOOP



END SUB

FUNCTION idenewtxt (a$)
idetxtlast = idetxtlast + 1
idetxt$(idetxtlast) = a$
idenewtxt = idetxtlast
END FUNCTION

SUB idenomatch

'-------- generic dialog box header --------
PCOPY 3, 0
PCOPY 0, 2
PCOPY 0, 1
SCREEN , , 1, 0
focus = 1
DIM p AS idedbptype
DIM o(1 TO 100) AS idedbotype
DIM oo AS idedbotype
DIM sep AS STRING * 1
sep = CHR$(0)
'-------- end of generic dialog box header --------

'-------- init --------
i = 0
idepar p, 19, 4, ""
i = i + 1
o(i).typ = 3
o(i).y = 4
o(i).txt = idenewtxt("OK")
o(i).def = 1
'-------- end of init --------

'-------- generic init --------
FOR i = 1 TO 100: o(i).par = p: NEXT 'set parent info of objects
'-------- end of generic init --------

DO 'main loop

'-------- generic display dialog box & objects --------
idedrawpar p
f = 1: cx = 0: cy = 0
FOR i = 1 TO 100
IF o(i).typ THEN
'prepare object
o(i).foc = focus - f 'focus offset
o(i).cx = 0: o(i).cy = 0
idedrawobj o(i), f 'display object
IF o(i).cx THEN cx = o(i).cx: cy = o(i).cy
END IF
NEXT i
lastfocus = f - 1
'-------- end of generic display dialog box & objects --------

'-------- custom display changes --------
COLOR 0, 7: LOCATE p.y + 2, p.x + 3: PRINT "Match not found";
'-------- end of custom display changes --------

'update visual page and cursor position
PCOPY 1, 0
IF cx THEN SCREEN , , 0, 0: LOCATE cy, cx, 1: SCREEN , , 1, 0

'-------- read input --------
change = 0
DO
getxymouse
mx = mousex: my = mousey: mb = mousebutton1
IF mb <> 0 AND omb = 0 THEN mousedown = 1: change = 1
IF mb = 0 AND omb <> 0 THEN mouseup = 1: change = 1
IF mb THEN change = 1
omb = mb
k$ = INKEY$: IF LEN(k$) THEN change = 1
'DEF SEG = 0: alt = PEEK(&H417) AND 8
alt = 8
IF alt <> oldalt THEN change = 1
oldalt = alt

if change=0 then _LIMIT 16
LOOP UNTIL change
SCREEN , , 0, 0: LOCATE , , 0: SCREEN , , 1, 0
IF alt THEN idehl = 1 ELSE idehl = 0
'convert "alt+letter" scancode to letter's ASCII character
altletter$ = ""
IF alt THEN
IF LEN(k$) = 2 THEN
k = ASC(RIGHT$(k$, 1))
FOR c = 65 TO 90
IF k = idealtcode(c) THEN
altletter$ = CHR$(c)
EXIT FOR
END IF
NEXT
END IF
END IF
IF UCASE$(k$) = "Y" THEN altletter$ = "Y"
IF UCASE$(k$) = "N" THEN altletter$ = "N"

'-------- end of read input --------

'-------- generic input response --------
info = 0
IF k$ = "" THEN k$ = CHR$(255)
IF k$ = CHR$(9) THEN focus = focus + 1
IF k$ = CHR$(0) + CHR$(15) THEN focus = focus - 1
IF focus < 1 THEN focus = lastfocus
IF focus > lastfocus THEN focus = 1
f = 1
FOR i = 1 TO 100
t = o(i).typ
IF t THEN
focusoffset = focus - f
ideupdateobj o(i), focus, f, focusoffset, k$, altletter$, mb, mousedown, mouseup, mx, my, info
END IF
NEXT
'-------- end of generic input response --------

IF k$ = CHR$(27) THEN
EXIT SUB
END IF

IF info THEN
EXIT SUB
END IF

'end of custom controls

mousedown = 0
mouseup = 0
LOOP

END SUB

FUNCTION ideopen$

'-------- generic dialog box header --------
PCOPY 0, 2
PCOPY 0, 1
SCREEN , , 1, 0
focus = 1
DIM p AS idedbptype
DIM o(1 TO 100) AS idedbotype
DIM oo AS idedbotype
DIM sep AS STRING * 1
sep = CHR$(0)
'-------- end of generic dialog box header --------

'-------- init --------
path$ = idepath$
filelist$ = idezfilelist$(path$)
pathlist$ = idezpathlist$(path$)

i = 0
idepar p, 70, idewy-7, "Open"
i = i + 1
o(i).typ = 1
o(i).y = 2
o(i).nam = idenewtxt("File #Name")
i = i + 1
o(i).typ = 2
o(i).y = 5
o(i).w = 32: o(i).h = idewy-14
o(i).nam = idenewtxt("#Files")
o(i).txt = idenewtxt(filelist$): filelist$ = ""
i = i + 1
o(i).typ = 2
o(i).x = 37: o(i).y = 5
o(i).w = 31: o(i).h = idewy-14
o(i).nam = idenewtxt("#Paths")
o(i).txt = idenewtxt(pathlist$): pathlist$ = ""
i = i + 1
o(i).typ = 3
o(i).y = idewy-7
o(i).txt = idenewtxt("OK" + sep + "#Cancel")
o(i).def = 1
'-------- end of init --------

'-------- generic init --------
FOR i = 1 TO 100: o(i).par = p: NEXT 'set parent info of objects
'-------- end of generic init --------

DO 'main loop

'-------- generic display dialog box & objects --------
idedrawpar p
f = 1: cx = 0: cy = 0
FOR i = 1 TO 100
IF o(i).typ THEN
'prepare object
o(i).foc = focus - f 'focus offset
o(i).cx = 0: o(i).cy = 0
idedrawobj o(i), f 'display object
IF o(i).cx THEN cx = o(i).cx: cy = o(i).cy
END IF
NEXT i
lastfocus = f - 1
'-------- end of generic display dialog box & objects --------

'-------- custom display changes --------
COLOR 0, 7: LOCATE p.y + 4, p.x + 2: PRINT "Path: ";
a$ = path$
w = p.w - 8
IF LEN(a$) > w - 3 THEN a$ = "" + RIGHT$(a$, w - 3)
PRINT a$;
'-------- end of custom display changes --------

'update visual page and cursor position
PCOPY 1, 0
IF cx THEN SCREEN , , 0, 0: LOCATE cy, cx, 1: SCREEN , , 1, 0

'-------- read input --------
change = 0
DO
getxymouse
mx = mousex: my = mousey: mb = mousebutton1
IF mb <> 0 AND omb = 0 THEN mousedown = 1: change = 1
IF mb = 0 AND omb <> 0 THEN mouseup = 1: change = 1
IF mb THEN change = 1
omb = mb
k$ = INKEY$: IF LEN(k$) THEN change = 1
DEF SEG = 0: alt = PEEK(&H417) AND 8: IF alt <> oldalt THEN change = 1
oldalt = alt

if change=0 then _LIMIT 16
LOOP UNTIL change
SCREEN , , 0, 0: LOCATE , , 0: SCREEN , , 1, 0
IF alt THEN idehl = 1 ELSE idehl = 0
'convert "alt+letter" scancode to letter's ASCII character
altletter$ = ""
IF alt THEN
IF LEN(k$) = 2 THEN
k = ASC(RIGHT$(k$, 1))
FOR c = 65 TO 90
IF k = idealtcode(c) THEN
altletter$ = CHR$(c)
EXIT FOR
END IF
NEXT
END IF
END IF
'-------- end of read input --------

'-------- generic input response --------
info = 0
IF k$ = "" THEN k$ = CHR$(255)
IF k$ = CHR$(9) THEN focus = focus + 1
IF k$ = CHR$(0) + CHR$(15) THEN focus = focus - 1
IF focus < 1 THEN focus = lastfocus
IF focus > lastfocus THEN focus = 1
f = 1
FOR i = 1 TO 100
t = o(i).typ
IF t THEN
focusoffset = focus - f
ideupdateobj o(i), focus, f, focusoffset, k$, altletter$, mb, mousedown, mouseup, mx, my, info
END IF
NEXT
'-------- end of generic input response --------










'specific post controls


IF k$ = CHR$(27) OR (focus = 5 AND info <> 0) THEN
ideopen$ = "C"
EXIT FUNCTION
END IF

IF idetxt(o(2).stx) <> "" THEN
idetxt(o(1).txt) = idetxt(o(2).stx)
o(1).v1 = LEN(idetxt(o(1).txt))
END IF

IF focus = 3 THEN
IF k$ = CHR$(13) OR info = 1 THEN

path$ = idezchangepath(path$, idetxt(o(3).stx))
idetxt(o(2).txt) = idezfilelist$(path$)
idetxt(o(3).txt) = idezpathlist$(path$)

o(2).sel = -1
o(3).sel = 1
IF info = 1 THEN o(3).sel = -1
GOTO ideopenloop
END IF
END IF

'load file
IF k$ = CHR$(13) OR (info = 1 AND focus = 2) OR (focus = 4 AND info <> 0) THEN
f$ = idetxt(o(1).txt)

'change path?
if f$=".." or f$="." then f$=f$+idepathsep$
if right$(f$,1)=idepathsep$ then
path$=idezgetfilepath$(path$,f$) 'note: path ending with pathsep needn't contain a file
idetxt(o(1).txt) = ""
idetxt(o(2).txt) = idezfilelist$(path$)
o(2).sel = -1
idetxt(o(3).txt) = idezpathlist$(path$)
o(3).sel = -1
GOTO ideopenloop
end if

'add .bas if not given
IF LCASE$(RIGHT$(f$, 4)) <> ".bas" THEN f$ = f$ + ".bas"
'check/acquire file path
path$=idezgetfilepath$(path$,f$)
'check file exists
ideerror=2
OPEN path$ + idepathsep$ + f$ FOR INPUT AS #150: CLOSE #150
'load file
ideerror = 3
idet$ = MKL$(0) + MKL$(0): idel = 1: ideli = 1: iden = 1
idesx = 1
idesy = 1
idecx = 1
idecy = 1
ideselect = 0
lineinput3load path$ + idepathsep$ + f$
idet$=space$(len(lineinput3buffer)*8)
i2=1
n=0
chrtab$=chr$(9)
space1$=" ": space2$="  ": space3$="   ": space4$="    "
chr7$=chr$(7): chr11$=chr$(11): chr12$=chr$(12): chr28$=chr$(28): chr29$=chr$(29): chr30$=chr$(30): chr31$=chr$(31): chr254$=chr$(254)
do
a$=lineinput3$
l=len(a$)
if l then asca=asc(a$) else asca=-1
if asca<>13 then
if asca<>-1 then
'fix tabs
ideopenfixtabs:
x=instr(a$,chrtab$)
if x then
x2 = (x-1) MOD 4
IF x2 = 0 THEN a$=left$(a$,x-1)+space4$+right$(a$,l-x): l=l+3: goto ideopenfixtabs
IF x2 = 1 THEN a$=left$(a$,x-1)+space3$+right$(a$,l-x): l=l+2: goto ideopenfixtabs
IF x2 = 2 THEN a$=left$(a$,x-1)+space2$+right$(a$,l-x): l=l+1: goto ideopenfixtabs
IF x2 = 3 THEN a$=left$(a$,x-1)+space1$+right$(a$,l-x): goto ideopenfixtabs
end if
'remove unprintable characters that may remain
ideopenfixunprintable:
if instr(a$,chr7$) then x=instr(a$,chr7$): a$=left$(a$,x-1)+chr$(254)+right$(a$,l-x): goto ideopenfixunprintable
if instr(a$,chr11$) then x=instr(a$,chr11$): a$=left$(a$,x-1)+chr$(254)+right$(a$,l-x): goto ideopenfixunprintable
if instr(a$,chr12$) then x=instr(a$,chr12$): a$=left$(a$,x-1)+chr$(254)+right$(a$,l-x): goto ideopenfixunprintable
if instr(a$,chr28$) then x=instr(a$,chr28$): a$=left$(a$,x-1)+chr$(254)+right$(a$,l-x): goto ideopenfixunprintable
if instr(a$,chr29$) then x=instr(a$,chr29$): a$=left$(a$,x-1)+chr$(254)+right$(a$,l-x): goto ideopenfixunprintable
if instr(a$,chr30$) then x=instr(a$,chr30$): a$=left$(a$,x-1)+chr$(254)+right$(a$,l-x): goto ideopenfixunprintable
if instr(a$,chr31$) then x=instr(a$,chr31$): a$=left$(a$,x-1)+chr$(254)+right$(a$,l-x): goto ideopenfixunprintable
end if 'asca<>-1
mid$(idet$,i2,l+8)=MKL$(l) + a$ + MKL$(l): i2=i2+l+8: n=n+1
end if
loop until asca=13
lineinput3buffer=""
iden=n: if n=0 then idet$ = MKL$(0) + MKL$(0): iden = 1 else idet$=left$(idet$,i2-1)
ideerror = 1
ideprogname = f$: _TITLE ideprogname+" - QB64"
idepath$ = path$
EXIT FUNCTION
END IF

ideopenloop:

'end of custom controls
mousedown = 0
mouseup = 0
LOOP
END FUNCTION

SUB idepar (par AS idedbptype, w, h, title$)
par.x = (idewx\2) - w \ 2
par.y = (idewy\2) - h \ 2
par.w = w
par.h = h
IF LEN(title$) THEN par.nam = idenewtxt(title$)
END SUB

FUNCTION iderestore$

'-------- generic dialog box header --------
PCOPY 3, 0
PCOPY 0, 2
PCOPY 0, 1
SCREEN , , 1, 0
focus = 1
DIM p AS idedbptype
DIM o(1 TO 100) AS idedbotype
DIM oo AS idedbotype
DIM sep AS STRING * 1
sep = CHR$(0)
'-------- end of generic dialog box header --------

'-------- init --------
i = 0
'idepar p, 30, 6, "File already exists. Overwrite?"
idepar p, 43, 4, ""
i = i + 1
o(i).typ = 3
o(i).y = 4
o(i).txt = idenewtxt("#Yes" + sep + "#No")
o(i).def = 1
'-------- end of init --------

'-------- generic init --------
FOR i = 1 TO 100: o(i).par = p: NEXT 'set parent info of objects
'-------- end of generic init --------

DO 'main loop

'-------- generic display dialog box & objects --------
idedrawpar p
f = 1: cx = 0: cy = 0
FOR i = 1 TO 100
IF o(i).typ THEN
'prepare object
o(i).foc = focus - f 'focus offset
o(i).cx = 0: o(i).cy = 0
idedrawobj o(i), f 'display object
IF o(i).cx THEN cx = o(i).cx: cy = o(i).cy
END IF
NEXT i
lastfocus = f - 1
'-------- end of generic display dialog box & objects --------

'-------- custom display changes --------
COLOR 0, 7: LOCATE p.y + 2, p.x + 3: PRINT "Recover program from auto-saved backup?";
'-------- end of custom display changes --------

'update visual page and cursor position
PCOPY 1, 0
IF cx THEN SCREEN , , 0, 0: LOCATE cy, cx, 1: SCREEN , , 1, 0

'-------- read input --------
change = 0
DO
getxymouse
mx = mousex: my = mousey: mb = mousebutton1
IF mb <> 0 AND omb = 0 THEN mousedown = 1: change = 1
IF mb = 0 AND omb <> 0 THEN mouseup = 1: change = 1
IF mb THEN change = 1
omb = mb
k$ = INKEY$: IF LEN(k$) THEN change = 1
'DEF SEG = 0: alt = PEEK(&H417) AND 8
alt = 8
IF alt <> oldalt THEN change = 1
oldalt = alt

if change=0 then _LIMIT 16
LOOP UNTIL change
SCREEN , , 0, 0: LOCATE , , 0: SCREEN , , 1, 0
IF alt THEN idehl = 1 ELSE idehl = 0
'convert "alt+letter" scancode to letter's ASCII character
altletter$ = ""
IF alt THEN
IF LEN(k$) = 2 THEN
k = ASC(RIGHT$(k$, 1))
FOR c = 65 TO 90
IF k = idealtcode(c) THEN
altletter$ = CHR$(c)
EXIT FOR
END IF
NEXT
END IF
END IF
IF UCASE$(k$) = "Y" THEN altletter$ = "Y"
IF UCASE$(k$) = "N" THEN altletter$ = "N"

'-------- end of read input --------

'-------- generic input response --------
info = 0
IF k$ = "" THEN k$ = CHR$(255)
IF k$ = CHR$(9) THEN focus = focus + 1
IF k$ = CHR$(0) + CHR$(15) THEN focus = focus - 1
IF focus < 1 THEN focus = lastfocus
IF focus > lastfocus THEN focus = 1
f = 1
FOR i = 1 TO 100
t = o(i).typ
IF t THEN
focusoffset = focus - f
ideupdateobj o(i), focus, f, focusoffset, k$, altletter$, mb, mousedown, mouseup, mx, my, info
END IF
NEXT
'-------- end of generic input response --------

IF info THEN
IF info = 1 THEN iderestore$ = "Y" ELSE iderestore$ = "N"
EXIT FUNCTION
END IF

'end of custom controls
mousedown = 0
mouseup = 0
LOOP

END FUNCTION

SUB idesave (f$)
OPEN f$ FOR OUTPUT AS #150
FOR i = 1 TO iden
a$ = idegetline(i)
PRINT #150, a$
NEXT
CLOSE #150
ideunsaved = 0
END SUB

FUNCTION idesaveas$ (programname$)
'-------- generic dialog box header --------
PCOPY 0, 2
PCOPY 0, 1
SCREEN , , 1, 0
focus = 1
DIM p AS idedbptype
DIM o(1 TO 100) AS idedbotype
DIM oo AS idedbotype
DIM sep AS STRING * 1
sep = CHR$(0)
'-------- end of generic dialog box header --------

'-------- init --------
path$ = idepath$
pathlist$ = idezpathlist$(path$)

i = 0
idepar p, 48, idewy-7, "Save As"

i = i + 1
o(i).typ = 1
o(i).y = 2
o(i).nam = idenewtxt("File #Name")
o(i).txt = idenewtxt(programname$)
o(i).v1 = LEN(programname$)

'i = i + 1
'o(i).typ = 2
'o(i).y = 5
'o(i).w = 32: o(i).h = 11
'o(i).nam = idenewtxt("#Files")
'o(i).txt = idenewtxt(filelist$): filelist$ = ""

i = i + 1
o(i).typ = 2
'o(i).x = 10:
o(i).y = 5
o(i).w = 44: o(i).h = idewy-14
o(i).nam = idenewtxt("#Paths")
o(i).txt = idenewtxt(pathlist$): pathlist$ = ""

i = i + 1
o(i).typ = 3
o(i).y = idewy-7
o(i).txt = idenewtxt("OK" + sep + "#Cancel")
o(i).def = 1
'-------- end of init --------

'-------- generic init --------
FOR i = 1 TO 100: o(i).par = p: NEXT 'set parent info of objects
'-------- end of generic init --------

DO 'main loop

'-------- generic display dialog box & objects --------
idedrawpar p
f = 1: cx = 0: cy = 0
FOR i = 1 TO 100
IF o(i).typ THEN
'prepare object
o(i).foc = focus - f 'focus offset
o(i).cx = 0: o(i).cy = 0
idedrawobj o(i), f 'display object
IF o(i).cx THEN cx = o(i).cx: cy = o(i).cy
END IF
NEXT i
lastfocus = f - 1
'-------- end of generic display dialog box & objects --------

'-------- custom display changes --------
COLOR 0, 7: LOCATE p.y + 4, p.x + 2: PRINT "Path: ";
a$ = path$
w = p.w - 8
IF LEN(a$) > w - 3 THEN a$ = "" + RIGHT$(a$, w - 3)
PRINT a$;
'-------- end of custom display changes --------

'update visual page and cursor position
PCOPY 1, 0
IF cx THEN SCREEN , , 0, 0: LOCATE cy, cx, 1: SCREEN , , 1, 0

'-------- read input --------
change = 0
DO
getxymouse
mx = mousex: my = mousey: mb = mousebutton1
IF mb <> 0 AND omb = 0 THEN mousedown = 1: change = 1
IF mb = 0 AND omb <> 0 THEN mouseup = 1: change = 1
IF mb THEN change = 1
omb = mb
k$ = INKEY$: IF LEN(k$) THEN change = 1
DEF SEG = 0: alt = PEEK(&H417) AND 8: IF alt <> oldalt THEN change = 1
oldalt = alt

if change=0 then _LIMIT 16
LOOP UNTIL change
SCREEN , , 0, 0: LOCATE , , 0: SCREEN , , 1, 0
IF alt THEN idehl = 1 ELSE idehl = 0
'convert "alt+letter" scancode to letter's ASCII character
altletter$ = ""
IF alt THEN
IF LEN(k$) = 2 THEN
k = ASC(RIGHT$(k$, 1))
FOR c = 65 TO 90
IF k = idealtcode(c) THEN
altletter$ = CHR$(c)
EXIT FOR
END IF
NEXT
END IF
END IF
'-------- end of read input --------

'-------- generic input response --------
info = 0
IF k$ = "" THEN k$ = CHR$(255)
IF k$ = CHR$(9) THEN focus = focus + 1
IF k$ = CHR$(0) + CHR$(15) THEN focus = focus - 1
IF focus < 1 THEN focus = lastfocus
IF focus > lastfocus THEN focus = 1
f = 1
FOR i = 1 TO 100
t = o(i).typ
IF t THEN
focusoffset = focus - f
ideupdateobj o(i), focus, f, focusoffset, k$, altletter$, mb, mousedown, mouseup, mx, my, info
END IF
NEXT
'-------- end of generic input response --------

IF k$ = CHR$(27) OR (focus = 4 AND info <> 0) THEN
idesaveas$ = "C"
EXIT FUNCTION
END IF

IF focus = 2 THEN
IF k$ = CHR$(13) OR info = 1 THEN
path$ = idezchangepath(path$, idetxt(o(2).stx))
idetxt(o(2).txt) = idezpathlist$(path$)
o(2).sel = 1
IF info = 1 THEN o(2).sel = -1
END IF
END IF

IF (k$ = CHR$(13) AND focus <> 2) OR (focus = 3 AND info <> 0) THEN
f$ = idetxt(o(1).txt)

'change path?
if f$=".." or f$="." then f$=f$+idepathsep$
if right$(f$,1)=idepathsep$ then
path$=idezgetfilepath$(path$,f$) 'note: path ending with pathsep needn't contain a file
idetxt(o(1).txt) = ""
idetxt(o(2).txt) = idezpathlist$(path$)
o(2).sel = -1
GOTO idesaveasloop
end if

IF lcase$(RIGHT$(f$, 4)) <> ".bas" THEN f$ = f$ + ".bas"
path$=idezgetfilepath$(path$,f$)
ideerror=3
OPEN path$ + idepathsep$ + f$ FOR BINARY AS #150
ideerror=1
IF LOF(150) THEN
CLOSE #150
a$ = idefileexists
IF a$ = "N" THEN
idesaveas$ = "C"
EXIT FUNCTION 'user didn't agree to overwrite
END IF
ELSE
CLOSE #150
END IF
ideprogname$ = f$: _TITLE ideprogname+" - QB64"
idesave path$ + idepathsep$ + f$
idepath$ = path$
EXIT FUNCTION
END IF

idesaveasloop:

'end of custom controls
mousedown = 0
mouseup = 0
LOOP

END FUNCTION

FUNCTION idesavenow$

'-------- generic dialog box header --------
PCOPY 3, 0
PCOPY 0, 2
PCOPY 0, 1
SCREEN , , 1, 0
focus = 1
DIM p AS idedbptype
DIM o(1 TO 100) AS idedbotype
DIM oo AS idedbotype
DIM sep AS STRING * 1
sep = CHR$(0)
'-------- end of generic dialog box header --------

'-------- init --------
i = 0
idepar p, 40, 4, ""
i = i + 1
o(i).typ = 3
o(i).y = 4
o(i).txt = idenewtxt("#Yes" + sep + "#No" + sep + "#Cancel")
o(i).def = 1
'-------- end of init --------

'-------- generic init --------
FOR i = 1 TO 100: o(i).par = p: NEXT 'set parent info of objects
'-------- end of generic init --------

DO 'main loop

'-------- generic display dialog box & objects --------
idedrawpar p
f = 1: cx = 0: cy = 0
FOR i = 1 TO 100
IF o(i).typ THEN
'prepare object
o(i).foc = focus - f 'focus offset
o(i).cx = 0: o(i).cy = 0
idedrawobj o(i), f 'display object
IF o(i).cx THEN cx = o(i).cx: cy = o(i).cy
END IF
NEXT i
lastfocus = f - 1
'-------- end of generic display dialog box & objects --------

'-------- custom display changes --------
COLOR 0, 7: LOCATE p.y + 2, p.x + 4: PRINT "Program is not saved. Save it now?";
'-------- end of custom display changes --------

'update visual page and cursor position
PCOPY 1, 0
IF cx THEN SCREEN , , 0, 0: LOCATE cy, cx, 1: SCREEN , , 1, 0

'-------- read input --------
change = 0
DO
getxymouse
mx = mousex: my = mousey: mb = mousebutton1
IF mb <> 0 AND omb = 0 THEN mousedown = 1: change = 1
IF mb = 0 AND omb <> 0 THEN mouseup = 1: change = 1
IF mb THEN change = 1
omb = mb
k$ = INKEY$: IF LEN(k$) THEN change = 1
'DEF SEG = 0: alt = PEEK(&H417) AND 8
alt = 8
IF alt <> oldalt THEN change = 1
oldalt = alt


if change=0 then _LIMIT 16
LOOP UNTIL change
SCREEN , , 0, 0: LOCATE , , 0: SCREEN , , 1, 0
IF alt THEN idehl = 1 ELSE idehl = 0
'convert "alt+letter" scancode to letter's ASCII character
altletter$ = ""
IF alt THEN
IF LEN(k$) = 2 THEN
k = ASC(RIGHT$(k$, 1))
FOR c = 65 TO 90
IF k = idealtcode(c) THEN
altletter$ = CHR$(c)
EXIT FOR
END IF
NEXT
END IF
END IF
IF UCASE$(k$) = "Y" THEN altletter$ = "Y"
IF UCASE$(k$) = "N" THEN altletter$ = "N"
IF UCASE$(k$) = "C" THEN altletter$ = "C"

'-------- end of read input --------

'-------- generic input response --------
info = 0
IF k$ = "" THEN k$ = CHR$(255)
IF k$ = CHR$(9) THEN focus = focus + 1
IF k$ = CHR$(0) + CHR$(15) THEN focus = focus - 1
IF focus < 1 THEN focus = lastfocus
IF focus > lastfocus THEN focus = 1
f = 1
FOR i = 1 TO 100
t = o(i).typ
IF t THEN
focusoffset = focus - f
ideupdateobj o(i), focus, f, focusoffset, k$, altletter$, mb, mousedown, mouseup, mx, my, info
END IF
NEXT
'-------- end of generic input response --------

IF k$ = CHR$(27) THEN
idesavenow$ = "C"
EXIT FUNCTION
END IF

IF info THEN
IF info = 1 THEN idesavenow$ = "Y"
IF info = 2 THEN idesavenow$ = "N"
IF info = 3 THEN idesavenow$ = "C"
EXIT FUNCTION
END IF

'end of custom controls
mousedown = 0
mouseup = 0
LOOP

END FUNCTION

SUB idesetline (i, text$)

text$ = RTRIM$(text$)

IF i <> -1 THEN idegotoline i
textlen = LEN(text$)
idet$ = LEFT$(idet$, ideli - 1) + MKL$(textlen) + text$ + MKL$(textlen) + RIGHT$(idet$, LEN(idet$) - ideli + 1 - CVL(MID$(idet$, ideli, 4)) - 8)

END SUB

SUB ideshowtext

IF idecx < idesx THEN idesx = idecx
IF idecy < idesy THEN idesy = idecy
IF idecx - idesx >= (idewx-2) THEN idesx = idecx - (idewx-3)
IF idecy - idesy >= (idewy-8) THEN idesy = idecy - (idewy-9)

sy1 = ideselecty1
sy2 = idecy
IF sy1 > sy2 THEN SWAP sy1, sy2
sx1 = ideselectx1
sx2 = idecx
IF sx1 > sx2 THEN SWAP sx1, sx2

COLOR 7, 1
l = idesy
FOR y = 0 TO (idewy-9)
if l=idefocusline and idecy<>l then color 7,4 else color 7,1
LOCATE y + 3, 2
IF l <= iden THEN
a$ = idegetline(l)
a2$ = SPACE$(idesx + (idewx-3))
MID$(a2$, 1) = a$
a2$ = RIGHT$(a2$, (idewx-2))
ELSE
a2$ = SPACE$((idewx-2))
END IF
PRINT a2$;

'apply selection color change if necessary
IF ideselect THEN
IF l >= sy1 AND l <= sy2 THEN
IF sy1 = sy2 THEN 'single line select
COLOR 1, 7
x2 = idesx
FOR x = 2 TO (idewx-2)
IF x2 >= sx1 AND x2 < sx2 THEN
a = SCREEN(y + 3, x): LOCATE y + 3, x: PRINT CHR$(a);
END IF
x2 = x2 + 1
NEXT
COLOR 7, 1
ELSE 'multiline select
IF idecx = 1 AND l = sy2 AND idecy > sy1 THEN GOTO nofinalselect
LOCATE y + 3, 2
COLOR 1, 7: PRINT a2$;
COLOR 7, 1
nofinalselect:
END IF
END IF
END IF

l = l + 1
NEXT

q = idevbar(idewx, 3, (idewy-8), idecy, iden)
q = idehbar(2, (idewy-5), (idewx-2), idesx, 608)

'update cursor pos in status bar
COLOR 0, 3
LOCATE idewy, idewx-15: PRINT "          :     ";
IF idecx < 100000 THEN
LOCATE idewy,idewx-4
a$ = LTRIM$(STR$(idecx))
PRINT a$;
END IF
a$ = LTRIM$(STR$(idecy))
LOCATE idewy, (idewx-5) - LEN(a$)
PRINT a$;

SCREEN , , 0, 0: LOCATE idecy - idesy + 3, idecx - idesx + 2: SCREEN , , 3, 0

END SUB

FUNCTION idesubs$

'-------- generic dialog box header --------
PCOPY 0, 2
PCOPY 0, 1
SCREEN , , 1, 0
focus = 1
DIM p AS idedbptype
DIM o(1 TO 100) AS idedbotype
DIM oo AS idedbotype
DIM sep AS STRING * 1
sep = CHR$(0)
'-------- end of generic dialog box header --------

'-------- init --------

ly$ = MKL$(1)
l$ = ideprogname$
IF l$ = "" THEN l$ = "Untitled"+tempfolderindexstr$
FOR y = 1 TO iden
a$ = idegetline(y)
a$ = LTRIM$(RTRIM$(a$))
sf = 0
nca$ = UCASE$(a$)
IF LEFT$(nca$, 4) = "SUB " THEN sf = 1: sf$ = "SUB  "
IF LEFT$(nca$, 9) = "FUNCTION " THEN sf = 2: sf$ = "FUNC "
IF sf THEN
IF RIGHT$(nca$, 7) = " STATIC" THEN
a$ = RTRIM$(LEFT$(a$, LEN(a$) - 7))
END IF
ly$ = ly$ + MKL$(y)
IF sf = 1 THEN
a$ = RIGHT$(a$, LEN(a$) - 4)
ELSE
a$ = RIGHT$(a$, LEN(a$) - 9)
END IF
a$ = LTRIM$(RTRIM$(a$))
x = INSTR(a$, "(")
IF x THEN
n$ = RTRIM$(LEFT$(a$, x - 1))
args$ = RIGHT$(a$, LEN(a$) - x + 1)
ELSE
n$ = a$
args$ = ""
END IF
IF LEN(n$) <= 20 THEN
n$ = n$ + SPACE$(20 - LEN(n$))
ELSE
n$ = LEFT$(n$, 17) + ""
END IF
IF LEN(args$) <= (idewx-41) THEN
args$ = args$ + SPACE$((idewx-41) - LEN(args$))
ELSE
args$ = LEFT$(args$, (idewx-44)) + ""
END IF
l$ = l$ + sep + "" + n$ + " " + sf$ + args$

END IF
NEXT

FOR x = LEN(l$) TO 1 STEP -1
a$ = MID$(l$, x, 1)
IF a$ = "" THEN MID$(l$, x, 1) = "": EXIT FOR
NEXT



'72,19
i = 0
idepar p, idewx-8, idewy-6, "SUBs"

i = i + 1
o(i).typ = 2
o(i).y = 1
'68
o(i).w = idewx-12: o(i).h = idewy-9
o(i).txt = idenewtxt(l$)
o(i).sel = 1
o(i).nam = idenewtxt("Program Items")


i = i + 1
o(i).typ = 3
o(i).y = idewy-6
o(i).txt = idenewtxt("#Edit" + sep + "#Cancel")
o(i).def = 1

'-------- end of init --------

'-------- generic init --------
FOR i = 1 TO 100: o(i).par = p: NEXT 'set parent info of objects
'-------- end of generic init --------

DO 'main loop

'-------- generic display dialog box & objects --------
idedrawpar p
f = 1: cx = 0: cy = 0
FOR i = 1 TO 100
IF o(i).typ THEN
'prepare object
o(i).foc = focus - f 'focus offset
o(i).cx = 0: o(i).cy = 0
idedrawobj o(i), f 'display object
IF o(i).cx THEN cx = o(i).cx: cy = o(i).cy
END IF
NEXT i
lastfocus = f - 1
'-------- end of generic display dialog box & objects --------

'-------- custom display changes --------
'-------- end of custom display changes --------

'update visual page and cursor position
PCOPY 1, 0
IF cx THEN SCREEN , , 0, 0: LOCATE cy, cx, 1: SCREEN , , 1, 0

'-------- read input --------
change = 0
DO
getxymouse
mx = mousex: my = mousey: mb = mousebutton1
IF mb <> 0 AND omb = 0 THEN mousedown = 1: change = 1
IF mb = 0 AND omb <> 0 THEN mouseup = 1: change = 1
IF mb THEN change = 1
omb = mb
k$ = INKEY$: IF LEN(k$) THEN change = 1
DEF SEG = 0: alt = PEEK(&H417) AND 8: IF alt <> oldalt THEN change = 1
oldalt = alt

if change=0 then _LIMIT 16
LOOP UNTIL change
SCREEN , , 0, 0: LOCATE , , 0: SCREEN , , 1, 0
IF alt THEN idehl = 1 ELSE idehl = 0
'convert "alt+letter" scancode to letter's ASCII character
altletter$ = ""
IF alt THEN
IF LEN(k$) = 2 THEN
k = ASC(RIGHT$(k$, 1))
FOR c = 65 TO 90
IF k = idealtcode(c) THEN
altletter$ = CHR$(c)
EXIT FOR
END IF
NEXT
END IF
END IF
'-------- end of read input --------

'-------- generic input response --------
info = 0
IF k$ = "" THEN k$ = CHR$(255)
IF k$ = CHR$(9) THEN focus = focus + 1
IF k$ = CHR$(0) + CHR$(15) THEN focus = focus - 1
IF focus < 1 THEN focus = lastfocus
IF focus > lastfocus THEN focus = 1
f = 1
FOR i = 1 TO 100
t = o(i).typ
IF t THEN
focusoffset = focus - f
ideupdateobj o(i), focus, f, focusoffset, k$, altletter$, mb, mousedown, mouseup, mx, my, info
END IF
NEXT
'-------- end of generic input response --------

IF k$ = CHR$(27) OR (focus = 3 AND info <> 0) THEN
idesubs$ = "C"
EXIT FUNCTION
END IF

IF k$ = CHR$(13) OR (focus = 2 AND info <> 0) OR (info = 1 AND focus = 1) THEN
y = o(1).sel
IF y < 1 THEN y = -y
idecy = CVL(MID$(ly$, y * 4 - 3, 4))
idesy = idecy
idecx = 1
idesx = 1
EXIT FUNCTION
END IF


'end of custom controls
mousedown = 0
mouseup = 0
LOOP



END FUNCTION

SUB ideupdateobj (o AS idedbotype, focus, f, focusoffset, k$, altletter$, mb, mousedown, mouseup, mx, my, info)
DIM sep AS STRING * 1
sep = CHR$(0)

t = o.typ

IF t = 1 THEN
IF mousedown THEN
x1 = o.par.x + o.x: y = o.par.y + o.y
x2 = x1
IF o.nam THEN
x2 = x2 + idehlen(idetxt(o.nam)) + 2
END IF
IF my >= y - 1 AND my <= y + 1 THEN
IF mx >= x1 AND mx <= x2 + o.w + 3 THEN
focus = f
 'change cursor location?
 IF my = y THEN
 IF mx > x2 + 1 AND mx < x2 + o.w + 2 THEN
 a$ = idetxt(o.txt)
 x = mx - x2 - 2 '0-?
 IF x <= LEN(a$) THEN o.v1 = x ELSE o.v1 = LEN(a$)
 END IF
 END IF
END IF
END IF
END IF 'mousedown
IF focusoffset = 0 THEN
a$ = idetxt(o.txt)
IF LEN(k$) = 1 THEN
k = ASC(k$)
IF k = 8 AND o.v1 > 0 THEN
a1$ = LEFT$(a$, o.v1 - 1)
IF o.v1 <= LEN(a$) THEN a2$ = RIGHT$(a$, LEN(a$) - o.v1) ELSE a2$ = ""
a$ = a1$ + a2$: o.v1 = o.v1 - 1
END IF
IF k >= 32 AND k <= 126 THEN
IF o.v1 > 0 THEN a1$ = LEFT$(a$, o.v1) ELSE a1$ = ""
IF o.v1 <= LEN(a$) THEN a2$ = RIGHT$(a$, LEN(a$) - o.v1) ELSE a2$ = ""
a$ = a1$ + k$ + a2$: o.v1 = o.v1 + 1
END IF
idetxt(o.txt) = a$
END IF
IF k$ = CHR$(0) + "S" THEN 'DEL
IF o.v1 > 0 THEN a1$ = LEFT$(a$, o.v1) ELSE a1$ = ""
IF o.v1 < LEN(a$) THEN a2$ = RIGHT$(a$, LEN(a$) - o.v1 - 1) ELSE a2$ = ""
a$ = a1$ + a2$
idetxt(o.txt) = a$
END IF
'cursor control
IF k$ = CHR$(0) + "K" THEN o.v1 = o.v1 - 1
IF k$ = CHR$(0) + "M" THEN o.v1 = o.v1 + 1
IF k$ = CHR$(0) + "G" THEN o.v1 = 0
IF k$ = CHR$(0) + "O" THEN o.v1 = LEN(a$)
IF o.v1 < 0 THEN o.v1 = 0
IF o.v1 > LEN(a$) THEN o.v1 = LEN(a$)
END IF
'hot-key focus
IF LEN(altletter$) THEN
IF o.nam THEN
x = INSTR(idetxt(o.nam), "#")
IF x THEN
IF UCASE$(MID$(idetxt(o.nam), x + 1, 1)) = altletter$ THEN focus = f
END IF
END IF
END IF
f = f + 1
END IF '1

IF t = 2 THEN
idetxt(o.stx) = ""

IF mousedown THEN
x1 = o.par.x + o.x: y1 = o.par.y + o.y
x2 = x1 + o.w + 1: y2 = y1 + o.h + 1
IF mx >= x1 AND mx <= x2 AND my >= y1 AND my <= y2 THEN
focus = f
 IF mx > x1 AND mx < x2 AND my > y1 AND my < y2 THEN
 y = my - y1 - 1
 y = y + o.v1
 IF o.sel = y THEN info = 1
 o.sel = y
 IF o.sel > o.num THEN o.sel = o.num
 END IF
 END IF

END IF 'mousedown

IF mb THEN
IF focusoffset = 0 THEN

x1 = o.par.x + o.x: y1 = o.par.y + o.y
x2 = x1 + o.w + 1: y2 = y1 + o.h + 1
IF mx >= x1 AND mx <= x2 AND my >= y1 AND my <= y2 THEN

 IF mx = x2 AND my > y1 + 1 AND my < y2 - 1 THEN

 tsel = ABS(o.sel)
 tnum = o.num
 q = idevbar(x2, y1 + 1, o.h, tsel, tnum)

 IF my < q THEN
 k$ = CHR$(0) + CHR$(73)
 idewait
 END IF
 IF my > q THEN
 k$ = CHR$(0) + CHR$(81)
 idewait
 END IF
 END IF

 IF mx = x2 AND my = y1 + 1 THEN
 k$ = CHR$(0) + CHR$(72)
 idewait
 END IF
 IF mx = x2 AND my = y2 - 1 THEN
 k$ = CHR$(0) + CHR$(80)
 idewait
 END IF

END IF
END IF
END IF 'mb


IF focusoffset = 0 THEN


IF k$ = CHR$(0) + CHR$(72) THEN
IF o.sel < 0 THEN
o.sel = -o.sel
ELSE
o.sel = o.sel - 1
IF o.sel < 1 THEN o.sel = 1
END IF
END IF

IF k$ = CHR$(0) + CHR$(80) THEN
IF o.sel < 0 THEN
o.sel = -o.sel
ELSE
o.sel = o.sel + 1
IF o.sel > o.num THEN o.sel = o.num
END IF
END IF

IF k$ = CHR$(0) + CHR$(73) THEN
IF o.sel < 0 THEN
o.sel = -o.sel
END IF
o.sel = o.sel - o.h + 1
IF o.sel < 1 THEN o.sel = 1
END IF

IF k$ = CHR$(0) + CHR$(81) THEN
IF o.sel < 0 THEN
o.sel = -o.sel
END IF
o.sel = o.sel + o.h - 1
IF o.sel > o.num THEN o.sel = o.num
END IF

IF k$ = CHR$(0) + "w" THEN
o.sel = 1
END IF

IF k$ = CHR$(0) + "u" THEN
o.sel = o.num
END IF

k = ASC(UCASE$(k$)): IF k >= 32 AND k <= 126 THEN k2$ = CHR$(k) ELSE k2$ = CHR$(255)
a$ = idetxt(o.txt)
n = 1
a3$ = ""
m = 0
FOR i2 = 1 TO LEN(a$)
a2$ = MID$(a$, i2, 1)
IF a2$ <> sep THEN a3$ = a3$ + a2$
IF a2$ = sep OR i2 = LEN(a$) THEN
IF UCASE$(a3$) >= k2$ AND m = 0 THEN
m = 1
o.sel = n
END IF
IF n = o.sel THEN idetxt(o.stx) = a3$
n = n + 1
a3$ = ""
END IF
NEXT



END IF

'hot-key focus
IF LEN(altletter$) THEN
IF o.nam THEN
x = INSTR(idetxt(o.nam), "#")
IF x THEN
IF UCASE$(MID$(idetxt(o.nam), x + 1, 1)) = altletter$ THEN focus = f
END IF
END IF
END IF
f = f + 1
END IF '2

IF t = 3 THEN

'count buttons & check for hotkey(s)
a$ = idetxt(o.txt)
n = 1
x = 0
FOR i2 = 1 TO LEN(a$)
a2$ = MID$(a$, i2, 1)
IF a2$ = CHR$(0) THEN n = n + 1
IF x = 1 THEN
IF UCASE$(a2$) = altletter$ THEN
focus = f + n - 1
info = n
END IF
END IF
IF a2$ = "#" THEN x = 1 ELSE x = 0
NEXT

'check for mouse click on button(s)
IF mousedown THEN
IF my = o.par.y + o.y THEN
a$ = idetxt(o.txt)
n = 1
c = 0
FOR i2 = 1 TO LEN(a$)
a2$ = MID$(a$, i2, 1)
IF a2$ = CHR$(0) THEN
n = n + 1
ELSE
IF a$ <> "#" THEN c = c + 1
END IF
NEXT
w = o.w
c = c + n * 4 'add characters for bracing < > buttons
whitespace = w - c
spacing = whitespace \ (n + 1)
'f2 = o.foc + 1
'IF f2 < 1 OR f2 > n THEN
'IF o.def THEN f2 = o.def
'END IF
n2 = 1
a3$ = ""
'LOCATE o.par.y + o.y, o.par.x + o.x
x = o.par.x + o.x
'COLOR 0, 7
FOR i2 = 1 TO LEN(a$)
a2$ = MID$(a$, i2, 1)
IF a2$ <> CHR$(0) THEN a3$ = a3$ + a2$
IF a2$ = CHR$(0) OR i2 = LEN(a$) THEN
'PRINT SPACE$(spacing);
x = x + spacing
'IF f2 = n2 THEN COLOR 15, 7 ELSE COLOR 0, 7
'PRINT "< ";
'COLOR 0, 7: idehPRINT a3$
'IF f2 = n2 THEN COLOR 15, 7 ELSE COLOR 0, 7
'IF n2 = o.foc + 1 THEN
'o.cx = x + 2: o.cy = o.par.y + o.y
'END IF
'PRINT " >";
'COLOR 0, 7
x2 = idehlen(a3$) + 4
IF mx >= x AND mx < x + x2 THEN info = n2: focus = f + n2 - 1


x = x + x2
a3$ = ""
n2 = n2 + 1
END IF
NEXT
END IF 'my
END IF 'mousedown

IF focusoffset >= 0 AND focusoffset < n THEN
f2 = f + focusoffset
IF k$ = CHR$(13) THEN
info = focusoffset + 1
END IF
END IF

f = f + n
END IF '3

IF t = 4 THEN 'checkbox

IF mousedown THEN
y = o.par.y + o.y
x1 = o.par.x + o.x: x2 = x1 + 2
IF o.nam THEN
x2 = x2 + 1 + idehlen(idetxt(o.nam))
END IF
IF my = y THEN
IF mx >= x1 AND mx <= x2 THEN
focus = f
o.sel = o.sel + 1: IF o.sel > 1 THEN o.sel = 0'toggle
END IF
END IF
END IF 'mousedown
IF focusoffset = 0 THEN

'a$ = idetxt(o.txt)
'IF LEN(k$) = 1 THEN
'k = ASC(k$)
'IF k = 8 AND o.v1 > 0 THEN
'a1$ = LEFT$(a$, o.v1 - 1)
'IF o.v1 <= LEN(a$) THEN a2$ = RIGHT$(a$, LEN(a$) - o.v1) ELSE a2$ = ""
'a$ = a1$ + a2$: o.v1 = o.v1 - 1
'END IF
'IF k >= 32 AND k <= 126 THEN
'IF o.v1 > 0 THEN a1$ = LEFT$(a$, o.v1) ELSE a1$ = ""
'IF o.v1 <= LEN(a$) THEN a2$ = RIGHT$(a$, LEN(a$) - o.v1) ELSE a2$ = ""
'a$ = a1$ + k$ + a2$: o.v1 = o.v1 + 1
'END IF
'idetxt(o.txt) = a$
'END IF
'IF k$ = CHR$(0) + "S" THEN 'DEL
'IF o.v1 > 0 THEN a1$ = LEFT$(a$, o.v1) ELSE a1$ = ""
'IF o.v1 < LEN(a$) THEN a2$ = RIGHT$(a$, LEN(a$) - o.v1 - 1) ELSE a2$ = ""
'a$ = a1$ + a2$
'idetxt(o.txt) = a$
'END IF
''cursor control
'IF k$ = CHR$(0) + "K" THEN o.v1 = o.v1 - 1
'IF k$ = CHR$(0) + "M" THEN o.v1 = o.v1 + 1
'IF k$ = CHR$(0) + "G" THEN o.v1 = 0
'IF k$ = CHR$(0) + "O" THEN o.v1 = LEN(a$)
'IF o.v1 < 0 THEN o.v1 = 0
'IF o.v1 > LEN(a$) THEN o.v1 = LEN(a$)

IF k$ = CHR$(0) + "H" THEN o.sel = 1
IF k$ = CHR$(0) + "P" THEN o.sel = 0
IF k$ = " " THEN
o.sel = o.sel + 1: IF o.sel > 1 THEN o.sel = 0'toggle
END IF

END IF 'in focus
'hot-key focus
IF LEN(altletter$) THEN
IF o.nam THEN
x = INSTR(idetxt(o.nam), "#")
IF x THEN
IF UCASE$(MID$(idetxt(o.nam), x + 1, 1)) = altletter$ THEN focus = f
END IF
END IF
END IF
f = f + 1
END IF '4


END SUB

FUNCTION idevbar (x, y, h, i2, n2)
i = i2: n = n2

'h is height in charatcers (inc. arrows)

'draw background & arrows
COLOR 0, 7
LOCATE y, x: PRINT CHR$(24);
LOCATE y + h - 1, x: PRINT CHR$(25);
FOR y2 = y + 1 TO y + h - 2
LOCATE y2, x: PRINT "";
NEXT

'draw slider

IF n < 1 THEN n = 1
IF i < 1 THEN i = 1
IF i > n THEN i = n

IF h = 2 THEN
idevbar = y 'not position for slider exists
EXIT FUNCTION
END IF

IF h = 3 THEN
idevbar = y + 1 'dummy value
'no slider
EXIT FUNCTION
END IF

IF h = 4 THEN
IF n = 1 THEN
idevbar = y + 1 'dummy value
'no slider required for 1 item
EXIT FUNCTION
ELSE
'show whichever is closer of the two positions
p! = (i - 1) / (n - 1)
IF p! < .5 THEN y2 = y + 1 ELSE y2 = y + 2
LOCATE y2, x: PRINT "";
idevbar = y2
EXIT FUNCTION
END IF
END IF

IF h > 4 THEN
IF n = 1 THEN
idevbar = y + h \ 4'dummy value
'no slider required for 1 item
EXIT FUNCTION
END IF
IF i = 1 THEN
y2 = y + 1
LOCATE y2, x: PRINT "";
idevbar = y2
EXIT FUNCTION
END IF
IF i = n THEN
y2 = y + h - 2
LOCATE y2, x: PRINT "";
idevbar = y2
EXIT FUNCTION
END IF
'between i=1 and i=n
p! = (i - 1) / (n - 1)
p! = p! * (h - 4)
y2 = y + 2 + INT(p!)
LOCATE y2, x: PRINT "";
idevbar = y2
EXIT FUNCTION
END IF
END FUNCTION

SUB idewait
FOR i = 1 TO 2
t! = TIMER
DO: LOOP WHILE TIMER = t!
NEXT
END SUB

SUB idewait4alt
DEF SEG = 0
DO
LOOP WHILE PEEK(&H417) AND 8
END SUB

SUB idewait4mous
DO
getxymouse
mx = mousex
my = mousey
mb = mousebutton1
LOOP WHILE mb
END SUB

function idezfilename$(f$)

IF os$ = "WIN" THEN
idezfilename$=chr$(34)+f$+chr$(34)
exit function
end if

IF os$ = "LNX" THEN
idezfilename$="'"+f$+"'"
exit function
end if

end function

FUNCTION idezchangepath$ (path$, newpath$)

idezchangepath$ = path$ 'default (for unsuccessful cases)

IF os$ = "WIN" THEN
'go back a path
IF newpath$ = ".." THEN
FOR x = LEN(path$) TO 1 STEP -1
a$ = MID$(path$, x, 1)
IF a$ = "\" THEN
idezchangepath$ = LEFT$(path$, x - 1)
EXIT FOR
END IF
NEXT
EXIT FUNCTION
END IF
'change drive
IF LEN(newpath$) = 2 AND RIGHT$(newpath$, 1) = ":" THEN
idezchangepath$ = newpath$
EXIT FUNCTION
END IF
idezchangepath$ = path$ + "\" + newpath$
EXIT FUNCTION
END IF

IF os$ = "LNX" THEN

'go back a path
IF newpath$ = ".." THEN
FOR x = LEN(path$) TO 1 STEP -1
a$ = MID$(path$, x, 1)
IF a$ = "/" THEN
idezchangepath$ = LEFT$(path$, x - 1)
if x=1 then idezchangepath$ = "/" 'root path cannot be ""
EXIT FOR
END IF
NEXT
EXIT FUNCTION
END IF
if path$="/" then idezchangepath$ = "/" + newpath$ else idezchangepath$ = path$ +"/" + newpath$
EXIT FUNCTION
END IF

END FUNCTION

FUNCTION idezfilelist$ (path$)
DIM sep AS STRING * 1
sep = CHR$(0)

IF os$ = "WIN" THEN
OPEN ".\internal\temp\files.txt" FOR OUTPUT AS #150: CLOSE #150
SHELL _hide "dir /b /ON /A-D " + idezfilename$(path$) + "\*.bas >.\internal\temp\files.txt"
filelist$ = ""
OPEN ".\internal\temp\files.txt" FOR INPUT AS #150
DO UNTIL EOF(150)
LINE INPUT #150, a$
IF LEN(a$) THEN 'skip blank entries
IF filelist$ = "" THEN filelist$ = a$ ELSE filelist$ = filelist$ + sep + a$
END IF
LOOP
CLOSE #150
idezfilelist$ = filelist$
EXIT FUNCTION
END IF

IF os$ = "LNX" THEN
filelist$ = ""
for i=1 to 2
OPEN "./internal/temp/files.txt" FOR OUTPUT AS #150: CLOSE #150
if i=1 then SHELL _hide "find "+idezfilename$(path$)+" -maxdepth 1 -type f -name "+chr$(34)+"*.bas"+chr$(34)+" >./internal/temp/files.txt"
if i=2 then SHELL _hide "find "+idezfilename$(path$)+" -maxdepth 1 -type f -name "+chr$(34)+"*.BAS"+chr$(34)+" >./internal/temp/files.txt"
OPEN "./internal/temp/files.txt" FOR INPUT AS #150
DO UNTIL EOF(150)
LINE INPUT #150, a$
IF LEN(a$)=0 THEN exit do
for x=len(a$) to 1 step -1
a2$=mid$(a$,x,1)
if a2$="/" then
a$=right$(a$,len(a$)-x)
exit for
end if
next
IF filelist$ = "" THEN filelist$ = a$ ELSE filelist$ = filelist$ + sep + a$
LOOP
CLOSE #150
next
idezfilelist$ = filelist$
EXIT FUNCTION
END IF

END FUNCTION

FUNCTION idezgetroot$
'note: does NOT including a trailing / or \ on the right

IF os$ = "WIN" THEN
SHELL _hide "cd >.\internal\temp\root.txt"
OPEN ".\internal\temp\root.txt" FOR INPUT AS #150
LINE INPUT #150, a$
idezgetroot$ = a$
CLOSE #150
EXIT FUNCTION
END IF

IF os$ = "LNX" THEN
SHELL _hide "pwd >./internal/temp/root.txt"
OPEN "./internal/temp/root.txt" FOR INPUT AS #150
LINE INPUT #150, a$
idezgetroot$ = a$
CLOSE #150
EXIT FUNCTION
END IF

END FUNCTION

FUNCTION idezpathlist$ (path$)
DIM sep AS STRING * 1
sep = CHR$(0)

IF os$ = "WIN" THEN
OPEN ".\internal\temp\paths.txt" FOR OUTPUT AS #150: CLOSE #150
a$ = "": IF RIGHT$(path$, 1) = ":" THEN a$ = "\" 'use a \ after a drive letter
SHELL _hide "dir /b /ON /AD " + idezfilename$(path$ + a$) + " >.\internal\temp\paths.txt"
pathlist$ = ""
OPEN ".\internal\temp\paths.txt" FOR INPUT AS #150
DO UNTIL EOF(150)
LINE INPUT #150, a$
IF pathlist$ = "" THEN pathlist$ = a$ ELSE pathlist$ = pathlist$ + sep + a$
LOOP
CLOSE #150
'count instances of / or \
c = 0
FOR x = 1 TO LEN(path$)
b$ = MID$(path$, x, 1)
IF b$ = idepathsep$ THEN c = c + 1
NEXT
IF c >= 1 THEN
IF LEN(pathlist$) THEN pathlist$ = ".." + sep + pathlist$ ELSE pathlist$ = ".."
END IF
'add drive paths
FOR i = 0 TO 25
IF LEN(pathlist$) THEN pathlist$ = pathlist$ + sep
pathlist$ = pathlist$ + CHR$(65 + i) + ":"
NEXT
idezpathlist$ = pathlist$
EXIT FUNCTION
END IF

IF os$ = "LNX" THEN
pathlist$ = ""
OPEN "./internal/temp/paths.txt" FOR OUTPUT AS #150: CLOSE #150
SHELL _hide "find "+idezfilename$(path$)+" -maxdepth 1 -mindepth 1 -type d >./internal/temp/paths.txt"
OPEN "./internal/temp/paths.txt" FOR INPUT AS #150
DO UNTIL EOF(150)
LINE INPUT #150, a$
IF LEN(a$)=0 THEN exit do
for x=len(a$) to 1 step -1
a2$=mid$(a$,x,1)
if a2$="/" then
a$=right$(a$,len(a$)-x)
exit for
end if
next
IF pathlist$ = "" THEN pathlist$ = a$ ELSE pathlist$ = pathlist$ + sep + a$
LOOP
CLOSE #150

if path$<>"/" then
 a$=".."

IF pathlist$ = "" THEN pathlist$ = a$ ELSE pathlist$ = a$+sep+pathlist$
end if

idezpathlist$ = pathlist$
EXIT FUNCTION
END IF

END FUNCTION

function ideztakepath$ (f$) 'assume f$ contains a filename with an optional path
p$=""

IF os$ = "WIN" THEN
for i=len(f$) to 1 step -1
a$=mid$(f$,i,1)
if a$="\" then
p$=left$(f$,i-1)
f$=right$(f$,len(f$)-i)
exit for
end if
next
ideztakepath$=p$
exit function
end if

IF os$ = "LNX" THEN
for i=len(f$) to 1 step -1
a$=mid$(f$,i,1)
if a$="/" then
p$=left$(f$,i-1)
f$=right$(f$,len(f$)-i)
exit for
end if
next
ideztakepath$=p$
exit function
end if

end function

'file f$ exists, and may contain a path
'return the FULL path (even if it was passed as a relative path)
'f$ is altered to only contain the name of the actual file
'root$ is the path to apply relative paths to
function idezgetfilepath$(root$,f$)
'step #1: seperate file's name from its path (if any)
p$=ideztakepath$(f$) 'note: this is a simple seperation of the string
'step #2: if path was undefined, set it to root
if len(p$)=0 then p$=root$
'step #3: if path is relative, make it relative to root$
if left$(p$,1)="." then p$=root$+idepathsep$+p$
'step #4: attempt a CHDIR to the path to (i)  validate its existance
'                                      & (ii) allow listing the paths full name
ideerror=4 'path not found
p2$=p$
IF os$ = "WIN" THEN
 if right$(p2$,1)=":" then p2$=p2$+"\" 'force change to root of drive
end if 
CHDIR p2$
ideerror=1
'step #5: get the path's full name (assume success)
	IF os$ = "WIN" THEN
	 SHELL _hide "cd >"+idezfilename$(ideroot$)+"\internal\temp\root.txt"
	 OPEN ideroot$+"\internal\temp\root.txt" FOR INPUT AS #150
	 LINE INPUT #150, p$
	 if right$(p$,1)="\" then p$=left$(p$,len(p$)-1) 'strip trailing \ after root drive path
         CLOSE #150
	END IF
	IF os$ = "LNX" THEN
	 SHELL _hide "pwd >"+idezfilename$(ideroot$)+"/internal/temp/root.txt"
	 OPEN ideroot$+"/internal/temp/root.txt" FOR INPUT AS #150
	 LINE INPUT #150, p$
	 CLOSE #150
	END IF
'step #6: restore root path (assume success)
CHDIR ideroot$
'important: no validation of f$ necessary
idezgetfilepath$=p$
end function

SUB initmouse
_mouseshow
END SUB






FUNCTION idelayoutbox

'-------- generic dialog box header --------
PCOPY 0, 2
PCOPY 0, 1
SCREEN , , 1, 0
focus = 1
DIM p AS idedbptype
DIM o(1 TO 100) AS idedbotype
DIM oo AS idedbotype
DIM sep AS STRING * 1
sep = CHR$(0)
'-------- end of generic dialog box header --------

'-------- init --------
i = 0
idepar p, 60, 7, "Code Layout"

i = i + 1
o(i).typ = 4 'check box
o(i).y = 2
o(i).nam = idenewtxt("#Auto Spacing & Upper/Lowercase Formatting")
o(i).sel = ideautolayout

i = i + 1
o(i).typ = 4 'check box
o(i).y = 4
o(i).nam = idenewtxt("Auto #Indent -")
o(i).sel = ideautoindent

a2$=str2$(ideautoindentsize)
i = i + 1
o(i).typ = 1
o(i).x = 20
o(i).y = 4
o(i).nam = idenewtxt("#Spacing")
o(i).txt = idenewtxt(a2$)
o(i).v1 = LEN(a2$)

i = i + 1
o(i).typ = 3
o(i).y = 7
o(i).txt = idenewtxt("OK" + sep + "#Cancel")
o(i).def = 1
'-------- end of init --------

'-------- generic init --------
FOR i = 1 TO 100: o(i).par = p: NEXT 'set parent info of objects
'-------- end of generic init --------

DO 'main loop


'-------- generic display dialog box & objects --------
idedrawpar p
f = 1: cx = 0: cy = 0
FOR i = 1 TO 100
IF o(i).typ THEN

'prepare object
o(i).foc = focus - f 'focus offset
o(i).cx = 0: o(i).cy = 0
idedrawobj o(i), f 'display object
IF o(i).cx THEN cx = o(i).cx: cy = o(i).cy
END IF
NEXT i
lastfocus = f - 1
'-------- end of generic display dialog box & objects --------

'-------- custom display changes --------
'-------- end of custom display changes --------

'update visual page and cursor position
PCOPY 1, 0
IF cx THEN SCREEN , , 0, 0: LOCATE cy, cx, 1: SCREEN , , 1, 0

'-------- read input --------
change = 0
DO
getxymouse
mx = mousex: my = mousey: mb = mousebutton1
IF mb <> 0 AND omb = 0 THEN mousedown = 1: change = 1
IF mb = 0 AND omb <> 0 THEN mouseup = 1: change = 1
IF mb THEN change = 1
omb = mb
k$ = INKEY$: IF LEN(k$) THEN change = 1
DEF SEG = 0: alt = PEEK(&H417) AND 8: IF alt <> oldalt THEN change = 1
oldalt = alt

if change=0 then _LIMIT 16
LOOP UNTIL change
SCREEN , , 0, 0: LOCATE , , 0: SCREEN , , 1, 0
IF alt THEN idehl = 1 ELSE idehl = 0
'convert "alt+letter" scancode to letter's ASCII character
altletter$ = ""
IF alt THEN
IF LEN(k$) = 2 THEN
k = ASC(RIGHT$(k$, 1))
FOR c = 65 TO 90
IF k = idealtcode(c) THEN
altletter$ = CHR$(c)
EXIT FOR
END IF
NEXT
END IF
END IF
'-------- end of read input --------

'-------- generic input response --------
info = 0
IF k$ = "" THEN k$ = CHR$(255)
IF k$ = CHR$(9) THEN focus = focus + 1
IF k$ = CHR$(0) + CHR$(15) THEN focus = focus - 1
IF focus < 1 THEN focus = lastfocus
IF focus > lastfocus THEN focus = 1
f = 1
FOR i = 1 TO 100
t = o(i).typ
IF t THEN
focusoffset = focus - f
ideupdateobj o(i), focus, f, focusoffset, k$, altletter$, mb, mousedown, mouseup, mx, my, info
END IF
NEXT
'-------- end of generic input response --------

'specific post controls

a$=idetxt(o(3).txt)
if len(a$)>2 then a$=left$(a$,2) '2 character limit
for i=1 to len(a$)
a=asc(a$,i)
if i=2 and asc(a$,1)=48 then a$="0":exit for
if a<48 or a>57 then a$="":exit for
next
if len(a$) then
a=val(a$)
if a>64 then a$="64"
end if
idetxt(o(3).txt)=a$

IF k$ = CHR$(27) OR (focus = 5 AND info <> 0) THEN EXIT FUNCTION
IF k$ = CHR$(13) OR (focus = 4 AND info <> 0) THEN
'save changes
open ".\internal\temp\options.bin" for binary as #150
v%=o(1).sel: if v%<>0 then v%=1 'ideautolayout
put #150,,v%
if ideautolayout<>v% then ideautolayout=v%: idelayoutbox=1
v%=o(2).sel: if v%<>0 then v%=1 'ideautoindent
put #150,,v%
if ideautoindent<>v% then ideautoindent=v%: idelayoutbox=1
v$=idetxt(o(3).txt) 'ideautoindentsize
if v$="" then v$="4"
v%=val(v$)
if v%<0 or v%>64 then v%=4
put #150,,v%
if ideautoindentsize<>v% then
ideautoindentsize=v%
if ideautoindent<>0 then idelayoutbox=1
end if
close #150
EXIT FUNCTION
END IF

'end of custom controls

mousedown = 0
mouseup = 0
LOOP
END FUNCTION






'ref: options.bin
'SEEK 1
'[2]   ideautolayout(=1)
'[2]   ideautoindent(=1)
'[2]   ideautoindentsize(=4)
'SEEK 7
'[2]   idewx(=80)
'[2]   idewy(=25)
'[2]   idecustomfont(=0)
'[1024]idecustomfontfile(=c:\windows\fonts\lucon.ttf)
'[2]   idecustomfontheight(=21)
'total bytes: 256+2*7=270
'open ".\internal\temp\options.bin" for binary as #150


FUNCTION idedisplaybox

'-------- generic dialog box header --------
PCOPY 0, 2
PCOPY 0, 1
SCREEN , , 1, 0
focus = 1
DIM p AS idedbptype
DIM o(1 TO 100) AS idedbotype
DIM oo AS idedbotype
DIM sep AS STRING * 1
sep = CHR$(0)
'-------- end of generic dialog box header --------

'-------- init --------
i = 0
idepar p, 60, 16, "Display"

a2$=str2$(idewx)
i = i + 1
o(i).typ = 1
o(i).x = 16
o(i).y = 2
o(i).nam = idenewtxt("#Width")
o(i).txt = idenewtxt(a2$)
o(i).v1 = LEN(a2$)

a2$=str2$(idewy)
i = i + 1
o(i).typ = 1
o(i).x = 15
o(i).y = 5
o(i).nam = idenewtxt("#Height")
o(i).txt = idenewtxt(a2$)
o(i).v1 = LEN(a2$)

i = i + 1
o(i).typ = 4 'check box
o(i).y = 8
o(i).nam = idenewtxt("Custom #Font:")
o(i).sel = idecustomfont

a2$=idecustomfontfile$
i = i + 1
o(i).typ = 1
o(i).x = 10
o(i).y = 10
o(i).nam = idenewtxt("File #Name")
o(i).txt = idenewtxt(a2$)
o(i).v1 = LEN(a2$)

a2$=str2$(idecustomfontheight)
i = i + 1
o(i).typ = 1
o(i).x = 10
o(i).y = 13
o(i).nam = idenewtxt("#Row Height (Pixels)")
o(i).txt = idenewtxt(a2$)
o(i).v1 = LEN(a2$)

i = i + 1
o(i).typ = 3
o(i).y = 16
o(i).txt = idenewtxt("OK" + sep + "#Cancel")
o(i).def = 1
'-------- end of init --------

'-------- generic init --------
FOR i = 1 TO 100: o(i).par = p: NEXT 'set parent info of objects
'-------- end of generic init --------

DO 'main loop


'-------- generic display dialog box & objects --------
idedrawpar p
f = 1: cx = 0: cy = 0
FOR i = 1 TO 100
IF o(i).typ THEN

'prepare object
o(i).foc = focus - f 'focus offset
o(i).cx = 0: o(i).cy = 0
idedrawobj o(i), f 'display object
IF o(i).cx THEN cx = o(i).cx: cy = o(i).cy
END IF
NEXT i
lastfocus = f - 1
'-------- end of generic display dialog box & objects --------

'-------- custom display changes --------
COLOR 0, 7: LOCATE p.y + 2, p.x + 2: PRINT "Window Size -";
COLOR 0, 7: LOCATE p.y + 9, p.x + 29: PRINT " Monospace TTF Font ";
'-------- end of custom display changes --------

'update visual page and cursor position
PCOPY 1, 0
IF cx THEN SCREEN , , 0, 0: LOCATE cy, cx, 1: SCREEN , , 1, 0

'-------- read input --------
change = 0
DO
getxymouse
mx = mousex: my = mousey: mb = mousebutton1
IF mb <> 0 AND omb = 0 THEN mousedown = 1: change = 1
IF mb = 0 AND omb <> 0 THEN mouseup = 1: change = 1
IF mb THEN change = 1
omb = mb
k$ = INKEY$: IF LEN(k$) THEN change = 1
DEF SEG = 0: alt = PEEK(&H417) AND 8: IF alt <> oldalt THEN change = 1
oldalt = alt

if change=0 then _LIMIT 16
LOOP UNTIL change
SCREEN , , 0, 0: LOCATE , , 0: SCREEN , , 1, 0
IF alt THEN idehl = 1 ELSE idehl = 0
'convert "alt+letter" scancode to letter's ASCII character
altletter$ = ""
IF alt THEN
IF LEN(k$) = 2 THEN
k = ASC(RIGHT$(k$, 1))
FOR c = 65 TO 90
IF k = idealtcode(c) THEN
altletter$ = CHR$(c)
EXIT FOR
END IF
NEXT
END IF
END IF
'-------- end of read input --------

'-------- generic input response --------
info = 0
IF k$ = "" THEN k$ = CHR$(255)
IF k$ = CHR$(9) THEN focus = focus + 1
IF k$ = CHR$(0) + CHR$(15) THEN focus = focus - 1
IF focus < 1 THEN focus = lastfocus
IF focus > lastfocus THEN focus = 1
f = 1
FOR i = 1 TO 100
t = o(i).typ
IF t THEN
focusoffset = focus - f
ideupdateobj o(i), focus, f, focusoffset, k$, altletter$, mb, mousedown, mouseup, mx, my, info
END IF
NEXT
'-------- end of generic input response --------

'specific post controls

a$=idetxt(o(1).txt)
if len(a$)>3 then a$=left$(a$,3) '3 character limit
for i=1 to len(a$)
a=asc(a$,i)
if a<48 or a>57 then a$="":exit for
if i=2 and asc(a$,1)=48 then a$="0":exit for
next
if focus<>1 then
if len(a$) then a=val(a$) else a=0
if a<80 then a$="80"
end if
idetxt(o(1).txt)=a$

a$=idetxt(o(2).txt)
if len(a$)>3 then a$=left$(a$,3) '3 character limit
for i=1 to len(a$)
a=asc(a$,i)
if a<48 or a>57 then a$="":exit for
if i=2 and asc(a$,1)=48 then a$="0":exit for
next
if focus<>2 then
if len(a$) then a=val(a$) else a=0
if a<25 then a$="25"
end if
idetxt(o(2).txt)=a$

a$=idetxt(o(4).txt)
if len(a$)>1024 then a$=left$(a$,1024)
idetxt(o(4).txt)=a$

a$=idetxt(o(5).txt)
if len(a$)>2 then a$=left$(a$,2) '2 character limit
for i=1 to len(a$)
a=asc(a$,i)
if a<48 or a>57 then a$="":exit for
if i=2 and asc(a$,1)=48 then a$="0":exit for
next
if focus<>5 then
if len(a$) then a=val(a$) else a=0
if a<16 then a$="16"
end if
idetxt(o(5).txt)=a$



IF k$ = CHR$(27) OR (focus = 7 AND info <> 0) THEN EXIT FUNCTION
IF k$ = CHR$(13) OR (focus = 6 AND info <> 0) THEN

x=0 'change to custom font

'get size in v%
v$=idetxt(o(5).txt): if v$="" then v$="0"
v%=val(v$)
if v%<16 then v%=16
if v%>99 then v%=99
if v%<>idecustomfontheight then x=1

if o(3).sel<>idecustomfont then
if o(3).sel=0 then
_FONT 16
_FREEFONT idecustomfonthandle
else
x=1
end if
end if

v$=idetxt(o(4).txt): if v$<>idecustomfontfile$ then x=1

if o(3).sel=1 and x=1 then
oldhandle=idecustomfonthandle
idecustomfonthandle=_LOADFONT(v$,v%,"MONOSPACE")
if idecustomfonthandle=-1 then
'failed! - revert to default settings
o(3).sel=0: idetxt(o(4).txt)="c:\windows\fonts\lucon.ttf": idetxt(o(5).txt)="21":_FONT 16
else
_FONT idecustomfonthandle
end if
if idecustomfont=1 then _FREEFONT oldhandle
end if

'save changes
open ".\internal\temp\options.bin" for binary as #150

seek #150,7

v$=idetxt(o(1).txt): if v$="" then v$="0"
v%=val(v$)
if v%<80 then v%=80
if v%>999 then v%=999
put #150,,v%
if v%<>idewx then idedisplaybox=1
idewx=v%

v$=idetxt(o(2).txt): if v$="" then v$="0"
v%=val(v$)
if v%<25 then v%=25
if v%>999 then v%=999
put #150,,v%
if v%<>idewy then idedisplaybox=1
idewy=v%

v%=o(3).sel
if v%<>0 then v%=1
put #150,,v%
idecustomfont=v%

v$=idetxt(o(4).txt)
if len(v$)>1024 then v$=left$(v$,1024)
idecustomfontfile$=v$
v$=v$+space$(1024-len(v$))
put #150,,v$

v$=idetxt(o(5).txt): if v$="" then v$="0"
v%=val(v$)
if v%<16 then v%=16
if v%>99 then v%=99
put #150,,v%
idecustomfontheight=v%

close #150
EXIT FUNCTION
END IF

'end of custom controls

mousedown = 0
mouseup = 0
LOOP
END FUNCTION
