CLS

' Vetores e Matrizes associados `as faixas de trafego:
NFaixasMax = 4: NRodovMax = 150: NEixosMax = 6
DIM H(NFaixasMax), Tipo$(NFaixasMax), PSR(NFaixasMax), PSRACOST(NFaixasMax)
DIM DEGRAUCM(NFaixasMax), OBS$(NFaixasMax), IGG(NFaixasMax), VDMUni(NFaixasMax)
DIM CARGADEF(NFaixasMax), D0(NFaixasMax), NPTS(NFaixasMax), HC(NFaixasMax)
DIM REVEST$(NFaixasMax), FX(NFaixasMax), Nacum(NFaixasMax), ALPHA(NFaixasMax)
DIM FV(NEixosMax), PERCT(NEixosMax), VidaRes(NFaixasMax), ALFAIGG(NFaixasMax)
DIM IRest(NFaixasMax), Trecho$(NRodovMax + 1), FCnovorede(NRodovMax)
DIM FCrecaprede(NRodovMax), FCmicrorede(NRodovMax), VI(NFaixasMax), UltRest$(NFaixasMax)
DIM QI(NFaixasMax), Heff(NFaixasMax), ALFA(NFaixasMax), Icalib(NFaixasMax)
DIM ALFAnew(NFaixasMax), Tsup(NFaixasMax), MRfound(NFaixasMax), PERCTRAF(NFaixasMax)
DIM PSIacost(NFaixasMax), DegrauAcost(NFaixasMax), AreaAcost(NFaixasMax)
DIM VDMeixos(NEixosMax), CamBase$(NFaixasMax), PSInovo(NFaixasMax), FVusace(NEixosMax)
DIM FC0novorede(NRodovMax), FC0recaprede(NRodovMax), FC0microrede(NRodovMax)
DIM FC2novorede(NRodovMax), FC2recaprede(NRodovMax), FC2microrede(NRodovMax)
DIM ALPHA0(NFaixasMax), ALPHA2(NFaixasMax), VDMc(NFaixasMax)
  
OPEN "SISTEMA.DAT" FOR INPUT AS #1
INPUT #1, SGP$
CLOSE #1
SGP$ = UCASE$(SGP$)

' Fatores de Calibracao do Modelo AASHTO-HDM
OPEN "FcAASHTOHDM.csv" FOR INPUT AS #1
LINE INPUT #1, LINHA$
INPUT #1, Tipo$, FcPavNovoPSISL, FcPavNovoPSISB, FcPavNovoPSIBS, CfRecapPSI
INPUT #1, Tipo$, FcPavNovoSCISL, FcPavNovoSCISB, FcPavNovoSCIBS, CfRecapSCI
CLOSE #1

' Definicao de PSI dada pelo usuario
OPEN "DEFPSI.DAT" FOR INPUT AS #1
INPUT #1, DEFPSI
CLOSE #1

' Subdiretorios onde se encontram o programa SGP e a base de dados:
OPEN "DIRETOR.DAT" FOR INPUT AS #1
INPUT #1, ANOBASE
INPUT #1, NPeriodos
INPUT #1, PROGRAMA$
INPUT #1, DADOS$
INPUT #1, CALC$
INPUT #1, DadosAnoBase$
CLOSE #1

' Codigos de indentificacao das Pracas de Pedagio nos arquivos a serem gerados
ARQUIVO$ = DadosAnoBase$ + "PEDAGIOS.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NPDG
INPUT #1, NCatTraf
ARQUIVO$ = DadosAnoBase$ + "PEDG.DAT"
OPEN ARQUIVO$ FOR INPUT AS #2
LINE INPUT #2, LINHA$
DIM Cat(NCatTraf), VolAnual(NCatTraf), Pdg$(NPDG), ISent(NPDG), PdgNome$(NPDG)
FOR I = 1 TO NPDG
    INPUT #1, PdgNome$(I)
    INPUT #1, ISent(I)
    INPUT #2, Pdg$(I)
NEXT I
CLOSE #1, #2

' - - - - - - - - - - - - - - - -
' -  PARAMETROS DE CONFIGURACAO -
' - - - - - - - - - - - - - - - -

' Codigos de identificacao das rodovias que compoem a rede:
ARQUIVO$ = DadosAnoBase$ + "RODOVIAS.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NRODOV
DIM Rodov$(NRODOV), NSTHRODOV(NRODOV)
FOR I = 1 TO NRODOV
    INPUT #1, Rodov$(I)
NEXT I
CLOSE #1

' Criterios complementares para as arvores de decisao
ARQUIVO$ = CALC$ + "CRITERIO.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, TRcrit
INPUT #1, QIcrit
INPUT #1, ATRcrit
INPUT #1, ATRITOcrit
INPUT #1, IGGcrit
CLOSE #1

OPEN "MES.DAT" FOR INPUT AS #1
INPUT #1, MESBASE$
CLOSE #1
MESBASE$ = UCASE$(MESBASE$)
Mes$ = MESBASE$
GOSUB 50
ANOatual = ANOBASE + MONTH

' Tipos de dados de que a base de dados e' composta:
ARQUIVO$ = DADOS$ + "TIPODADO.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NDADOS
DIM DADO$(15)
FOR I = 1 TO NDADOS
    INPUT #1, DADO$(I)
NEXT I
CLOSE #1
NDADOS = NDADOS - 1
NTIPOSDADOS = NDADOS
FOR IFX = 1 TO NFaixasMax
    NTIPOSDADOS = NTIPOSDADOS + 1
    DADO$(NTIPOSDADOS) = "SUP"
NEXT IFX

' Numero total de Subtrechos Homogeneos da rede
NSTH = 0
FOR I = 1 TO NRODOV
    ARQUIVO$ = CALC$ + "CADAS" + Rodov$(I) + ".CSV"
    OPEN ARQUIVO$ FOR INPUT AS #1
    ISTH = 0
    WHILE EOF(1) = FALSE
        LINE INPUT #1, LINHA$
        ISTH = ISTH + 1
    WEND
    NSTHRODOV(I) = ISTH - 1
    CLOSE #1
    NSTH = NSTH + NSTHRODOV(I)
NEXT I
                    
ARQUIVO$ = CALC$ + "CALIBRA.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, Icalibra
CLOSE #1
IF Icalibra > 0 THEN
    ARQUIVO$ = CALC$ + "RELCALIB.DAT"
    OPEN ARQUIVO$ FOR OUTPUT AS #15
    CLOSE #15
END IF

' Parametros de configuracao do trafego atuante na rede:
ARQUIVO$ = CALC$ + "TRAFEGO.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
' Taxas anuais de crescimento do trafego
INPUT #1, TaxaAutos
INPUT #1, TaxaCam
INPUT #1, TaxaOnibus
CLOSE #1

' Funcao densidade de probabilidade para Fc
DIM NC(4), NQI(4), NS(4), NTR(4)
NC(1) = 50: NS(1) = 0: NQI(1) = 0: NTR(1) = 0
NC(2) = 85: NS(2) = 1.04: NQI(2) = 1.08: NTR(2) = 1.013
NC(3) = 90: NS(3) = 1.29: NQI(3) = 1.6038: NTR(3) = 1.14
NC(4) = 95: NS(4) = 1.65: NQI(4) = 2.35: NTR(4) = 1.348

' Parametros para medir o desempenho das estrategias (Ocorrencias em %) e
' criterio para Priorizacao das Restauracoes sob Restricoes Orcamentarias
ARQUIVO$ = CALC$ + "PARAM.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, PSIref
INPUT #1, PTRAF
INPUT #1, PPSI
INPUT #1, Nconf
INPUT #1, QIref
INPUT #1, IGGref
INPUT #1, ATRref
INPUT #1, TRref
CLOSE #1
IF Nconf <= NC(2) THEN
    I1 = 1: I2 = 2
ELSE
    IF Nconf <= NC(3) THEN
        I1 = 2: I2 = 3
    ELSE
        I1 = 3: I2 = 4
    END IF
END IF
Ngauss = ((NC(I2) * NS(I1) - NC(I1) * NS(I2)) + Nconf * (NS(I2) - NS(I1))) / (NC(I2) - NC(I1))
Nt = ((NC(I2) * NTR(I1) - NC(I1) * NTR(I2)) + Nconf * (NTR(I2) - NTR(I1))) / (NC(I2) - NC(I1))
Niri = ((NC(I2) * NQI(I1) - NC(I1) * NQI(I2)) + Nconf * (NQI(I2) - NQI(I1))) / (NC(I2) - NC(I1))
ARQUIVO$ = CALC$ + "NC.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, ZRmpd, S0mpd
CLOSE #1

' Calibracao do modelo de previsao de desempenho na rede
    
ARQUIVO$ = CALC$ + "FAIXACAL.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, FCminCA
INPUT #1, FCmaxCA
INPUT #1, FCdefCA
INPUT #1, FCminMicro
INPUT #1, FCmaxMicro
INPUT #1, FCdefMicro
INPUT #1, FCminRecap
INPUT #1, FCmaxRecap
INPUT #1, FCdefRecap
CLOSE #1
ARQUIVO$ = CALC$ + "CALIB.CSV"
OPEN ARQUIVO$ FOR INPUT AS #1
LINE INPUT #1, LINHA$
FOR I = 1 TO NRODOV
    INPUT #1, Trecho$(I), FCnovorede(I), FCrecaprede(I), FCmicrorede(I)
NEXT I
INPUT #1, Trecho$(NRODOV + 1), FCnew, FCovl, FCmicroCA
CLOSE #1
FOR I = 1 TO NRODOV
    FCnovorede(I) = 0
    FCrecaprede(I) = 0
    FCmicrorede(I) = 0
NEXT I
ICONTnovo = 0
ICONTrecap = 0
ICONTmicro = 0
FCmicro = 0
FCrecap = 0
FCnovo = 0
ICONTcalibra = 0
Ncasos = 0

ARQUIVO$ = CALC$ + "FAIXACA0.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, FC0minCA
INPUT #1, FC0maxCA
INPUT #1, FC0defCA
INPUT #1, FC0minMicro
INPUT #1, FC0maxMicro
INPUT #1, FC0defMicro
INPUT #1, FC0minRecap
INPUT #1, FC0maxRecap
INPUT #1, FC0defRecap
CLOSE #1
ARQUIVO$ = CALC$ + "CALIB0.CSV"
OPEN ARQUIVO$ FOR INPUT AS #1
LINE INPUT #1, LINHA$
FOR I = 1 TO NRODOV
    INPUT #1, Trecho$(I), FC0novorede(I), FC0recaprede(I), FC0microrede(I)
NEXT I
INPUT #1, Trecho$(NRODOV + 1), FC0new, FC0ovl, F0microCA
CLOSE #1
FOR I = 1 TO NRODOV
    FC0novorede(I) = 0
    FC0recaprede(I) = 0
    FC0microrede(I) = 0
NEXT I
ICONT0novo = 0
ICONT0recap = 0
ICONT0micro = 0
FC0micro = 0
FC0recap = 0
FC0novo = 0
ICONT0calibra = 0
Ncasos0 = 0
    
ARQUIVO$ = CALC$ + "FAIXACA2.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, FC2minCA
INPUT #1, FC2maxCA
INPUT #1, FC2defCA
INPUT #1, FC2minMicro
INPUT #1, FC2maxMicro
INPUT #1, FC2defMicro
INPUT #1, FC2minRecap
INPUT #1, FC2maxRecap
INPUT #1, FC2defRecap
CLOSE #1
ARQUIVO$ = CALC$ + "CALIB2.CSV"
OPEN ARQUIVO$ FOR INPUT AS #1
LINE INPUT #1, LINHA$
FOR I = 1 TO NRODOV
    INPUT #1, Trecho$(I), FC2novorede(I), FC2recaprede(I), FC2microrede(I)
NEXT I
INPUT #1, Trecho$(NRODOV + 1), FC2new, FC2ovl, F2microCA
CLOSE #1
FOR I = 1 TO NRODOV
    FC2novorede(I) = 0
    FC2recaprede(I) = 0
    FC2microrede(I) = 0
NEXT I
ICONT2novo = 0
ICONT2recap = 0
ICONT2micro = 0
FC2micro = 0
FC2recap = 0
FC2novo = 0
ICONT2calibra = 0
Ncasos2 = 0

' Constantes
PI# = 3.141592654#

' - - - - - - - - - - - -
' - Vetores e Matrizes  -
' - - - - - - - - - - - -
DIM QImed(NFaixasMax), H1REV(NFaixasMax), HrecExist(NFaixasMax), Idade(NFaixasMax)
DIM PSIat(NSTH, NFaixasMax), NANO(NFaixasMax), NANOusace(NFaixasMax)
DIM Aream2(NSTH, NFaixasMax), IRI0(NFaixasMax), SN(NFaixasMax)

CLS
PRINT
PRINT "                        * * * * * * * * * * * * * * * "
PRINT "                        *  INICIALIZA AS VARIAVEIS  * "
PRINT "                        * * * * * * * * * * * * * * * "

ARQUIVO$ = CALC$ + "ESTSTHS.DAT"
OPEN ARQUIVO$ FOR OUTPUT AS #1
CLOSE #1
   
' Arquivo de Depuracao dos Dados
ARQUIVO$ = CALC$ + "DEPURA.DAT"
OPEN ARQUIVO$ FOR OUTPUT AS #15
CLOSE #15

' Resultados para a Memoria de Calculo
ARQUIVO$ = CALC$ + "MEM1.DAT"
OPEN ARQUIVO$ FOR OUTPUT AS #15
CLOSE #15

FOR IRodov = 1 TO NRODOV
    ARQUIVO$ = CALC$ + "EST" + Rodov$(IRodov) + ".CSV"
    ARQCALB$ = CALC$ + "CALB" + Rodov$(IRodov) + ".CSV"
    OPEN ARQUIVO$ FOR OUTPUT AS #1
    OPEN ARQCALB$ FOR OUTPUT AS #2
    WRITE #1, "STH", "KMI", "KMF", "NanoAASHTO1", "NanoAASHTO2", "NanoAASHTO3", "NanoAASHTO4", "PSI1", "VidaRes1", "VDMUni1", "PSI2", "VidaRes2", "VDMUni2", "PSI3", "VidaRes3", "VDMUni3", "PSI4", "VidaRes4", "VDMUni4", "NanoUSACE1", "NanoUSACE2", "NanoUSACE3", "NanoUSACE4", "Fv_AASHTO", "Fv_USACE"
    WRITE #2, "STH", "KMI", "KMF", "Fc1", "Fc2", "Fc3", "Fc4"
    CLOSE #1, #2
    ARQCALB$ = CALC$ + "CAL0" + Rodov$(IRodov) + ".CSV"
    OPEN ARQCALB$ FOR OUTPUT AS #2
    WRITE #2, "STH", "KMI", "KMF", "Fc1", "Fc2", "Fc3", "Fc4"
    CLOSE #2
    ARQCALB$ = CALC$ + "CAL2" + Rodov$(IRodov) + ".CSV"
    OPEN ARQCALB$ FOR OUTPUT AS #2
    WRITE #2, "STH", "KMI", "KMF", "Fc1", "Fc2", "Fc3", "Fc4"
    CLOSE #2
    ARQUIVO$ = CALC$ + "Nec" + Rodov$(IRodov) + ".CSV"
    OPEN ARQUIVO$ FOR OUTPUT AS #1
    WRITE #1, "STH", "KMI", "KMF", "PSI1", "VidaRes1", "IDS1", "Idade1", "D01", "QI1", "PSI2", "VidaRes2", "IDS2", "Idade2", "D02", "QI2", "PSI3", "VidaRes3", "IDS3", "Idade3", "D03", "QI3", "PSI4", "VidaRes4", "IDS4", "Idade4", "D04", "QI4"
    CLOSE #1
    FOR IFX = 1 TO NFaixasMax
        GOSUB 30
        ARQUIVO$ = CALC$ + "Par" + Rodov$(IRodov) + Faixa$ + ".CSV"
        OPEN ARQUIVO$ FOR OUTPUT AS #1
        WRITE #1, "STH", "KMI", "KMF", "UltCam", "HR", "VS", "VidaRes", "Idade", "PSI", "IDS", "D0", "QI", "Fc", "Nano", "VDMuni", "MR"
        CLOSE #1
    NEXT IFX
    ARQUIVO$ = CALC$ + "INT" + Rodov$(IRodov) + ".CSV"
    OPEN ARQUIVO$ FOR OUTPUT AS #15
    WRITE #15, "STH", "UltRest1", "UltRest2", "UltRest3", "UltRest4"
    CLOSE #15
NEXT IRodov

' - - - - - - - - - - - - - - - - - - - - -
' - Condicoes Iniciais de cada Subtrecho  -
' - - - - - - - - - - - - - - - - - - - - -
ARQUIVO$ = CALC$ + "IDS.OUT"
OPEN ARQUIVO$ FOR INPUT AS #14

AreaTotal = 0!
PSImed = 0!
NPSI = 0
NUnidAnalise = 0
VDMmin = 1E+20: VDMmax = 0
PSImin = 5!: PSImax = 0

ISTH = 0
FOR IRodov = 1 TO NRODOV

    PRINT "Trecho: "; Rodov$(IRodov)

    ' Parametros que definem as Arvores de Decisao:
    ARQUIVO$ = CALC$ + "ARV" + Rodov$(IRodov) + ".dat"
    OPEN ARQUIVO$ FOR INPUT AS #1
    INPUT #1, IDScrit
    INPUT #1, PSRcrit
    INPUT #1, HRmin
    INPUT #1, HRmax
    INPUT #1, PSIf
    INPUT #1, DEGRAUadm
    INPUT #1, HCmin
    INPUT #1, HCMAXgeral
    INPUT #1, VUMin
    INPUT #1, QI0adm
    INPUT #1, HbaseAcost
    INPUT #1, RepFres
    INPUT #1, TipoRevAcost$
    INPUT #1, SART$
    CLOSE #1

    ' Fatores de Veiculo Adotados
    ARQUIVO$ = CALC$ + "Fv_" + Rodov$(IRodov) + ".DAT"
    OPEN ARQUIVO$ FOR INPUT AS #1
    FOR NEIXOS = 2 TO 6
        INPUT #1, FV(NEIXOS)
    NEXT NEIXOS
    CLOSE #1
    ARQUIVO$ = CALC$ + "USACE_" + Rodov$(IRodov) + ".DAT"
    OPEN ARQUIVO$ FOR INPUT AS #1
    FOR NEIXOS = 2 TO 6
        INPUT #1, FVusace(NEIXOS)
    NEXT NEIXOS
    CLOSE #1

    ICONTnew = 0
    ICONTovl = 0
    ICONTmca = 0
    ICONT0new = 0
    ICONT0ovl = 0
    ICONT0mca = 0
    ICONT2new = 0
    ICONT2ovl = 0
    ICONT2mca = 0
    IARQ = NDADOS
    FOR I = 1 TO (NDADOS + 1)
        IF I <= NDADOS THEN
            IF DADO$(I) = "TRAF" THEN EXT$ = ".CSV" ELSE EXT$ = ".DAT"
            ARQUIVO$ = CALC$ + DADO$(I) + Rodov$(IRodov) + EXT$
            OPEN ARQUIVO$ FOR INPUT AS #I
            LINE INPUT #I, LINHA$
        ELSE
            FOR IFX = 1 TO NFaixasMax
                IARQ = IARQ + 1
                GOSUB 30
                IF DADO$(IARQ) = "SUP" THEN EXT$ = ".DAT" ELSE EXT$ = ".CSV"
                ARQUIVO$ = CALC$ + DADO$(IARQ) + Rodov$(IRodov) + Faixa$ + EXT$
                OPEN ARQUIVO$ FOR INPUT AS #IARQ
            NEXT IFX
        END IF
        ' Sequencia dos arquivos de dados em DADO$(I):
        ' 1 ==> ACOST e DRG
        ' 2 ==> CADAS
        ' 3 ==> ESTR
        ' 4 ==> FUNC
        ' 5 ==> TRAF
        ' 6 ==> DFX
        ' 7, 8, 9 e 10 ==> SUP
    NEXT I

    FOR ISUB = 1 TO NSTHRODOV(IRodov)

        ISTH = ISTH + 1
        FOR IFaixa = 1 TO NFaixasMax
            H1REV(IFaixa) = 0
            SN(IFaixa) = 0
            HrecExist(IFaixa) = 0
            Idade(IFaixa) = 0
            REVEST$(IFaixa) = ""
            QImed(IFaixa) = 0
            Nacum(IFaixa) = 0
            NANO(IFaixa) = 0
            D0(IFaixa) = -1
            IRI0(IFaixa) = 0
            PSIat(ISTH, IFaixa) = 0
            Aream2(ISTH, IFaixa) = 0
            VidaRes(IFaixa) = 0
            VDMUni(IFaixa) = 0
            IRest(IFaixa) = 0
            ALFAIGG(IFaixa) = 1
            QI(IFaixa) = -1
            VI(IFaixa) = -1
        NEXT IFaixa

        INPUT #1, Subtrecho$, USOACOST$, ACOSTANOREVEST, ACOSTREVEST$, ACOSTH1CM
        INPUT #1, ACOSTBASE$, ACOSTH2CM, ACOSTSUBBASE$, ACOSTH3CM
        INPUT #1, ACOSTDECTRANSV, SUPPISTA$, SUPACOST$, HLFREATM, INUNDTEMP$

        INPUT #2, Subtrecho$, Rodov$, INI$, FIM$, KMI, KMF, PISTA$
        INPUT #2, NFaixas, PLUV, ALTM, PLATAF, LARGPISTA, ACOSTLE, ACOSTLD
        INPUT #2, GEOVERT$, GEOHORIZ$, SECTIPO$, FX(1), FX(2), FX(3), FX(4), DECTRA, RESTR, ExtPontes, OBS$
        MMP = (PLUV / 1000) / 12
        STH = VAL(Subtrecho$)

        ' Geometria em Planta
        Extensaom = 1000 * ABS(KMI - KMF)
        FOR IFaixa = 1 TO NFaixas
            Aream2(ISTH, IFaixa) = Extensaom * FX(IFaixa)
            IF Aream2(ISTH, IFaixa) <= 0 THEN
                Mesg$ = "ERRO na area do Subtrecho No.: " + STR$(STH) + " na faixa de trafego " + STR$(IFaixa)
                GOSUB 500
            END IF
            AreaTotal = AreaTotal + Aream2(ISTH, IFaixa)
            IF IFaixa = 1 THEN
                AreaAcost(IFaixa) = ACOSTLE * Extensaom
            ELSE
                IF IFaixa = NFaixas THEN
                    AreaAcost(IFaixa) = ACOSTLD * Extensaom
                ELSE
                    AreaAcost(IFaixa) = 0
                END IF
            END IF
        NEXT IFaixa

        INPUT #4, Subtrecho$, QImed(1), QImed(2), QImed(3), QImed(4), ATResq(1), ATRdir(1), ATResq(2), ATRdir(2), ATResq(3), ATRdir(3), ATResq(4), ATRdir(4), DSVesq(1), DSVdir(1), DSVesq(2), DSVdir(2), DSVesq(3), DSVdir(3), DSVesq(4), DSVdir(4)

        FOR IFaixa = 1 TO NFaixasMax

            INPUT #3, Subtrecho$, ANORIG, REVORIG$, MARSHALL, RTDIAMET, VAZIOSAR, TEORASF
            INPUT #3, H1CM(IFaixa), CamBase$(IFaixa), H2CM(IFaixa), CBRBS, RCS28DBASE, SUBBASE$
            INPUT #3, H3CM(IFaixa), CBRSUB, RCS28DSUBB, REFSL$, H4CM(IFaixa), CBRREF
            INPUT #3, SL$, CBRSL(IFaixa), LLSL, IPSL, P200SL, PROFROCHAm

            IF IFaixa <= NFaixas THEN
                Idade(IFaixa) = ANOatual - ANORIG
                IF (REVORIG$ = "" OR REVORIG$ = "Nada") THEN
                    Mesg$ = "Erro: revestimento original nao foi indicado em " + Rodov$(IRodov) + " no Subtrecho " + STR$(STH) + " e faixa de trafego " + STR$(IFaixa)
                    GOSUB 500
                END IF
                IF ANORIG < 1900 THEN
                    Mesg$ = "Erro: idade incorreta para o revestimento original em " + Rodov$(IRodov) + " no Subtrecho " + STR$(STH) + " e faixa de trafego " + STR$(IFaixa)
                    GOSUB 500
                END IF
                UltRest$(IFaixa) = "NONE"
                H1REV(IFaixa) = H1CM(IFaixa)
                REVEST$(IFaixa) = UCASE$(REVORIG$)
                CamBase$(IFaixa) = UCASE$(CamBase$(IFaixa))
                NUnidAnalise = NUnidAnalise + 1
            END IF
            ALPHA(IFaixa) = -1
            ALPHA0(IFaixa) = -1
            ALPHA2(IFaixa) = -1

        NEXT IFaixa

        ' Leitura do Historico de Manutencao:
        ARQUIVO$ = CALC$ + "STHS.DAT"
        OPEN ARQUIVO$ FOR INPUT AS #15
        FOR I = 1 TO NSTH
            INPUT #15, PATHHM$
            IF I = ISTH THEN ARQHM$ = PATHHM$
        NEXT I
        CLOSE #15
        OPEN ARQHM$ FOR INPUT AS #15
        LINE INPUT #15, LINHA$
        WHILE EOF(15) = FALSE
            INPUT #15, Intv$, Mes$, AnoX$, Tipo$(1), H(1), HC(1), FPArea(1), Tipo$(2), H(2), HC(2), FPArea(2)
            INPUT #15, Tipo$(3), H(3), HC(3), FPArea(3), Tipo$(4), H(4), HC(4), FPArea(4)
            Interv = VAL(Intv$)
            ANO = VAL(AnoX$)
            IF Interv > 0 THEN
                Mes$ = UCASE$(Mes$)
                GOSUB 50
                ANO = ANO + MONTH
                Age = ANOatual - ANO
                IF Age > 0 THEN
                    FOR IFaixa = 1 TO NFaixas
                        Tipo$(IFaixa) = UCASE$(Tipo$(IFaixa))
                        IF FPArea(IFaixa) > 0 THEN
                            IF FPArea(IFaixa) < 50 THEN
                                Tipo$(IFaixa) = "CL"
                            ELSE
                                IF Tipo$(IFaixa) = "CL" THEN Tipo$(IFaixa) = "FR+RC"
                            END IF
                        END IF
                        SELECT CASE Tipo$(IFaixa)
                            CASE "", "CR", "CL", "NENHUMA", "NADA", "ST"
                            CASE "CP", "MICRO", "MICROCA", "MICRO CA", "LA", "LAMA ASF.", "LAMA ASFALTICA", "TSD", "TST", "PMF", "TSS", "CAPE SEAL", "MF+CP", "FR+MF+CP", "MF+TSD", "FR+MF+TSD", "TSDPOL"
                                IF Age <= Idade(IFaixa) THEN
                                    UltRest$(IFaixa) = Tipo$(IFaixa)
                                    HrecExist(IFaixa) = H(IFaixa)
                                    Idade(IFaixa) = Age
                                END IF
                                H1REV(IFaixa) = H1REV(IFaixa) + H(IFaixa)
                                REVEST$(IFaixa) = "MICRO"
                            CASE "RS", "FR+RC", "CBUQ", "MF+RC", "PMQ", "AAQ", "CBUQ+PMQ", "BINDER", "CAPA", "REPERF.", "REPERFILAGEM", "PMQA", "CBUQ+PMF", "CPA", "BBTM", "SMA", "FR+MF+RC", "FR+CP", "CBUQAB", "CBUQPOL", "MF+CBUQPOL", "FR+CBUQAB", "FR+CBUQPOL"
                                IF Age <= Idade(IFaixa) THEN
                                    UltRest$(IFaixa) = Tipo$(IFaixa)
                                    HrecExist(IFaixa) = H(IFaixa)
                                    Idade(IFaixa) = Age
                                END IF
                                H1REV(IFaixa) = H1REV(IFaixa) + H(IFaixa) - HC(IFaixa)
                                IF (Tipo$(IFaixa) = "CBUQAB" OR Tipo$(IFaixa) = "FR+CBUQAB") THEN
                                    REVEST$(IFaixa) = "CBUQAB"
                                ELSE
                                    IF (Tipo$(IFaixa) = "CBUQPOL" OR Tipo$(IFaixa) = "FR+CBUQPOL" OR Tipo$(IFaixa) = "MF+CBUQPOL") THEN
                                        REVEST$(IFaixa) = "CBUQPOL"
                                    ELSE
                                        REVEST$(IFaixa) = "CBUQ"
                                    END IF
                                END IF
                                IRest(IFaixa) = 1
                            CASE "RRV", "RRP", "RRT"
                                IF Age <= Idade(IFaixa) THEN
                                    UltRest$(IFaixa) = Tipo$(IFaixa)
                                    Idade(IFaixa) = Age
                                END IF
                                H1REV(IFaixa) = H(IFaixa)
                                REVEST$(IFaixa) = "CBUQ"
                                IRest(IFaixa) = 0
                            CASE ELSE
                                Mesg$ = "ERRO: Medida nao identificada: " + Tipo$(IFaixa) + " em " + Rodov$(IRodov) + " no Subtrecho No.: " + STR$(STH) + "  e faixa de trafego " + STR$(IFaixa)
                                GOSUB 500
                        END SELECT
                    NEXT IFaixa
                END IF
            END IF
        WEND
        CLOSE #15

        ' Demais dados:
     
        QREF = 4100
        FOR IFX = 1 TO NFaixasMax
            INPUT #6, Subtrecho$, CARGADEF(IFX)
            FOR IGEO = 1 TO 7
                INPUT #6, DF(IGEO)
            NEXT IGEO
            INPUT #6, NPTSDF, Tar, Tsup(IFX)
            FOR IGEO = 1 TO 7
                INPUT #6, RCM(IGEO)
            NEXT IGEO
            INPUT #6, FIPLACA, DATADEFLX$, EQUIPDEFLX$
            NPTS(IFX) = NPTSDF
            IF IFX <= NFaixas THEN
                IF DF(1) > 0 THEN
                    EQUIPDEFLX$ = UCASE$(EQUIPDEFLX$)
                    IF EQUIPDEFLX$ = "VEL" THEN Fdyn = .72 ELSE Fdyn = 1
                    Fator = QREF / CARGADEF(IFX)
                    DF(1) = Fator * DF(1) * Fdyn
                    IF Tsup(IFX) > 0 THEN
                        GOSUB 20
                        DF(1) = DF(1) * Fd
                    END IF
                    D0(IFX) = DF(1)
                    FOR IGEO = 2 TO 7
                        DF(IGEO) = Fator * DF(IGEO)
                    NEXT IGEO
                ELSE
                    D0(IFX) = 60
                END IF
                IF DF(7) > 0 THEN
                    IF (RCM(5) > 0 AND RCM(7) > 0 AND RCM(5) <> RCM(7)) THEN
                        IF DF(5) > DF(7) THEN
                            HP = H1REV(IFX) + H2CM(IFX)
                            IF H3CM(IFX) > 0 THEN HP = HP + H3CM(IFX)
                            IF H4CM(IFX) > 0 THEN HP = HP + H4CM(IFX)
                            X = 1.5 * HP
                            X1 = RCM(6): X2 = RCM(7)
                            Y1 = DF(6): Y2 = DF(7)
                            FOR IGEO = 2 TO 6
                                IF X <= RCM(IGEO) THEN
                                    X1 = RCM(IGEO - 1): X2 = RCM(IGEO)
                                    Y1 = DF(IGEO - 1): Y2 = DF(IGEO)
                                END IF
                            NEXT IGEO
                            Y = ((X2 * Y1 - X1 * Y2) / (X2 - X1)) + ((Y2 - Y1) / (X2 - X1)) * X
                            IF D0(IFX) > Y THEN D15HP = Y ELSE D15HP = .7 * D0(IFX)
                            SIP = 10 * (D0(IFX) - D15HP)
                            HP = 10 * HP
                            IF REVEST$(IFX) <> "CBUQ" THEN
                                K1 = .1165
                                K2 = -.3248
                                K3 = .8241
                            ELSE
                                K1 = .4728
                                K2 = -.481
                                K3 = .7581
                            END IF
                            IF SIP >= 0 THEN
                                SN(IFX) = K1 * (SIP ^ K2) * (HP ^ K3)
                                IF SN(IFX) < 1 THEN SN(IFX) = 1
                                IF SN(IFX) > 10 THEN SN(IFX) = 10
                            ELSE
                                SN(IFX) = -1
                            END IF
                        ELSE
                            Mesg$ = "ERRO nas deflexoes em " + Rodov$(IRodov) + " na faixa de trafego " + STR$(IFX) + " no Subtrecho No.: " + STR$(STH)
                            GOSUB 500
                        END IF
                    ELSE
                        Mesg$ = "ERRO nas deflexoes em " + Rodov$(IRodov) + " na faixa de trafego " + STR$(IFX) + " no Subtrecho No.: " + STR$(STH)
                        GOSUB 500
                    END IF
                END IF
            END IF
        NEXT IFX

        FOR IFX = 1 TO NFaixasMax
            ISUP = NDADOS + IFX
            INPUT #ISUP, Subtrecho$, KMIni, KMFim, PSR(IFX), CR$, BL$, TT$, TL$, TE$, TB$, P$, D$, DS$
            INPUT #ISUP, ER$, BF$, DC$, R$, ATR$, COR$, EM$, DP$, EL$, PSRACOST(IFX), DEGRAUCM(IFX), OBS$(IFX), ATRmed(IFX)
        NEXT IFX

        FOR IFX = 1 TO NFaixas
            IF PSR(IFX) <= 0 THEN
                Mesg$ = "ERRO: PSR <= 0 em " + Rodov$(IRodov) + " no Subtrecho No.: " + STR$(STH) + "  e faixa de trafego " + STR$(IFX)
                GOSUB 500
            END IF
        NEXT IFX

        INPUT #5, Subtrecho$, Praca$, PERCTVDM, PERCTRAF(1), PERCTRAF(2), PERCTRAF(3), PERCTRAF(4), VDMunid, VDMeixos(2), VDMeixos(3), VDMeixos(4), VDMeixos(5), VDMeixos(6)
        Praca$ = UCASE$(Praca$)

        SELECT CASE Praca$
            CASE "CONTAGEM"
                IPDG = 0
            CASE "P1"
                IPDG = 1
            CASE "P2"
                IPDG = 2
            CASE "P3"
                IPDG = 3
            CASE "P4"
                IPDG = 4
            CASE "P5"
                IPDG = 5
            CASE "P6"
                IPDG = 6
            CASE "P7"
                IPDG = 7
            CASE "P8"
                IPDG = 8
            CASE "P9"
                IPDG = 9
            CASE "P10"
                IPDG = 10
            CASE "P11"
                IPDG = 11
            CASE "P12"
                IPDG = 12
            CASE "P13"
                IPDG = 13
            CASE "P14"
                IPDG = 14
            CASE "P15"
                IPDG = 15
            CASE "P16"
                IPDG = 16
            CASE "P17"
                IPDG = 17
            CASE "P18"
                IPDG = 18
            CASE "P19"
                IPDG = 19
            CASE "P20"
                IPDG = 20
            CASE "P21"
                IPDG = 21
            CASE "P22"
                IPDG = 22
            CASE "P23"
                IPDG = 23
            CASE "P24"
                IPDG = 24
            CASE "P25"
                IPDG = 25
            CASE "P26"
                IPDG = 26
            CASE "P27"
                IPDG = 27
            CASE "P28"
                IPDG = 28
            CASE "P29"
                IPDG = 29
            CASE "P30"
                IPDG = 30
            CASE "P31"
                IPDG = 31
            CASE "P32"
                IPDG = 32
            CASE "P33"
                IPDG = 33
            CASE "P34"
                IPDG = 34
            CASE "P35"
                IPDG = 35
            CASE "P36"
                IPDG = 36
            CASE "P37"
                IPDG = 37
            CASE "P38"
                IPDG = 38
            CASE "P39"
                IPDG = 39
            CASE "P40"
                IPDG = 40
            CASE "P41"
                IPDG = 41
            CASE "P42"
                IPDG = 42
            CASE "P43"
                IPDG = 43
            CASE "P44"
                IPDG = 44
            CASE ELSE
                Mesg$ = "ERRO: pedagio desconhecido ==> " + Praca$ + " em " + Rodov$(IRodov) + " no Subtrecho No.: " + STR$(STH)
                GOSUB 500
        END SELECT

        FOR IEIXOS = 1 TO NEixosMax
            PERCT(IEIXOS) = 0
        NEXT IEIXOS

        IF IPDG > 0 THEN

            Pedagio$ = Pdg$(IPDG)
            ARQUIVO$ = CALC$ + Pedagio$ + ".CSV"
            OPEN ARQUIVO$ FOR INPUT AS #15
            LINE INPUT #15, LINHA$
            VDM = 0

            FOR I = 1 TO NCatTraf

                INPUT #15, J, VolAnual(J)
                VolAnual(J) = VolAnual(J) * PERCTVDM / 100
                VDM = VDM + VolAnual(J)

                SELECT CASE SGP$

                    CASE "SGP43"

                        SELECT CASE J

                            CASE 1, 7, 8, 9
                                ' Automoveis e motos
                                PERCT(1) = PERCT(1) + VolAnual(J)
                            CASE 2
                                ' Veiculos comerciais de dois eixos
                                PERCT(2) = PERCT(2) + VolAnual(J)
                            CASE 3
                                ' Veiculos comerciais de tres eixos
                                PERCT(3) = PERCT(3) + VolAnual(J)
                            CASE 4
                                ' Veiculos comerciais de 4 eixos
                                PERCT(4) = PERCT(4) + VolAnual(J)
                            CASE 5
                                ' Veiculos comerciais de 5 eixos
                                PERCT(5) = PERCT(5) + VolAnual(J)
                            CASE 6, 10, 11, 12
                                ' Veiculos comerciais de 6 ou mais eixos
                                PERCT(6) = PERCT(6) + VolAnual(J)
                            CASE ELSE
                                GOSUB 10
                        END SELECT

                    CASE "SGP42"

                        SELECT CASE J

                            CASE 1, 3, 5, 9
                                ' Automoveis e motos
                                PERCT(1) = PERCT(1) + VolAnual(J)
                            CASE 2
                                ' Veiculos comerciais de dois eixos
                                PERCT(2) = PERCT(2) + VolAnual(J)
                            CASE 4
                                ' Veiculos comerciais de tres eixos
                                PERCT(3) = PERCT(3) + VolAnual(J)
                            CASE 6
                                ' Veiculos comerciais de 4 eixos
                                PERCT(4) = PERCT(4) + VolAnual(J)
                            CASE 7
                                ' Veiculos comerciais de 5 eixos
                                PERCT(5) = PERCT(5) + VolAnual(J)
                            CASE 8, 10, 11, 12, 13, 14
                                ' Veiculos comerciais de 6 ou mais eixos
                                PERCT(6) = PERCT(6) + VolAnual(J)
                            CASE ELSE
                                GOSUB 10
                        END SELECT

                    CASE "SGP17"

                        SELECT CASE J

                            CASE 1, 5, 9, 11, 12, 13
                                ' Automoveis e motos
                                PERCT(1) = PERCT(1) + VolAnual(J)
                            CASE 2, 3
                                ' Veiculos comerciais de dois eixos
                                PERCT(2) = PERCT(2) + VolAnual(J)
                            CASE 4
                                ' Veiculos comerciais de tres eixos
                                PERCT(3) = PERCT(3) + VolAnual(J)
                            CASE 6
                                ' Veiculos comerciais de 4 eixos
                                PERCT(4) = PERCT(4) + VolAnual(J)
                            CASE 7
                                ' Veiculos comerciais de 5 eixos
                                PERCT(5) = PERCT(5) + VolAnual(J)
                            CASE 8, 10
                                ' Veiculos comerciais de 6 ou mais eixos
                                PERCT(6) = PERCT(6) + VolAnual(J)
                            CASE ELSE
                                GOSUB 10
                        END SELECT

                    CASE "SGP3\"

                        SELECT CASE J

                            CASE 1, 3, 5, 9, 10, 11, 12, 13, 14, 15
                                ' Automoveis e motos
                                PERCT(1) = PERCT(1) + VolAnual(J)
                            CASE 2
                                ' Veiculos comerciais de dois eixos
                                PERCT(2) = PERCT(2) + VolAnual(J)
                            CASE 4
                                ' Veiculos comerciais de tres eixos
                                PERCT(3) = PERCT(3) + VolAnual(J)
                            CASE 6
                                ' Veiculos comerciais de 4 eixos
                                PERCT(4) = PERCT(4) + VolAnual(J)
                            CASE 7
                                ' Veiculos comerciais de 5 eixos
                                PERCT(5) = PERCT(5) + VolAnual(J)
                            CASE 8
                                ' Veiculos comerciais de 6 ou mais eixos
                                PERCT(6) = PERCT(6) + VolAnual(J)
                            CASE ELSE
                                GOSUB 10
                        END SELECT

                    CASE "SGPC\", "SGPL\", "SGPM\", "SGP8\", "SGP10", "SGP11"

                        SELECT CASE J

                            CASE 1, 7, 8, 15
                                ' Automoveis e motos
                                PERCT(1) = PERCT(1) + VolAnual(J)
                            CASE 2, 12
                                ' Veiculos comerciais de dois eixos
                                PERCT(2) = PERCT(2) + VolAnual(J)
                            CASE 3, 13
                                ' Veiculos comerciais de tres eixos
                                PERCT(3) = PERCT(3) + VolAnual(J)
                            CASE 4, 14
                                ' Veiculos comerciais de 4 eixos
                                PERCT(4) = PERCT(4) + VolAnual(J)
                            CASE 5
                                ' Veiculos comerciais de 5 eixos
                                PERCT(5) = PERCT(5) + VolAnual(J)
                            CASE 6, 9, 10, 11
                                ' Veiculos comerciais de 6 ou mais eixos
                                PERCT(6) = PERCT(6) + VolAnual(J)
                            CASE ELSE
                                GOSUB 10
                        END SELECT

                    CASE "SGP5\", "SGP16"

                        SELECT CASE J

                            CASE 1, 2, 3
                                ' Automoveis e motos
                                PERCT(1) = PERCT(1) + VolAnual(J)
                            CASE 4, 9, 10
                                ' Veiculos comerciais de dois eixos
                                PERCT(2) = PERCT(2) + VolAnual(J)
                            CASE 5
                                ' Veiculos comerciais de tres eixos
                                PERCT(3) = PERCT(3) + VolAnual(J)
                            CASE 6
                                ' Veiculos comerciais de 4 eixos
                                PERCT(4) = PERCT(4) + VolAnual(J)
                            CASE 7
                                ' Veiculos comerciais de 5 eixos
                                PERCT(5) = PERCT(5) + VolAnual(J)
                            CASE 8
                                ' Veiculos comerciais de 6 ou mais eixos
                                PERCT(6) = PERCT(6) + VolAnual(J)
                            CASE ELSE
                                GOSUB 10
                        END SELECT

                    CASE "SGP18"

                        SELECT CASE J

                            CASE 1, 7, 8
                                ' Automoveis e motos
                                PERCT(1) = PERCT(1) + VolAnual(J)
                            CASE 2
                                ' Veiculos comerciais de dois eixos
                                PERCT(2) = PERCT(2) + VolAnual(J)
                            CASE 3
                                ' Veiculos comerciais de tres eixos
                                PERCT(3) = PERCT(3) + VolAnual(J)
                            CASE 4
                                ' Veiculos comerciais de 4 eixos
                                PERCT(4) = PERCT(4) + VolAnual(J)
                            CASE 5
                                ' Veiculos comerciais de 5 eixos
                                PERCT(5) = PERCT(5) + VolAnual(J)
                            CASE 6
                                ' Veiculos comerciais de 6 ou mais eixos
                                PERCT(6) = PERCT(6) + VolAnual(J)
                            CASE ELSE
                                GOSUB 10
                        END SELECT

                    CASE "SGP14"

                        SELECT CASE J

                            CASE 1, 2, 3
                                ' Automoveis e motos
                                PERCT(1) = PERCT(1) + VolAnual(J)
                            CASE 4
                                ' Veiculos comerciais de dois eixos
                                PERCT(2) = PERCT(2) + VolAnual(J)
                            CASE 5
                                ' Veiculos comerciais de tres eixos
                                PERCT(3) = PERCT(3) + VolAnual(J)
                            CASE 6
                                ' Veiculos comerciais de 4 eixos
                                PERCT(4) = PERCT(4) + VolAnual(J)
                            CASE 7
                                ' Veiculos comerciais de 5 eixos
                                PERCT(5) = PERCT(5) + VolAnual(J)
                            CASE 8
                                ' Veiculos comerciais de 6 ou mais eixos
                                PERCT(6) = PERCT(6) + VolAnual(J)
                            CASE ELSE
                                GOSUB 10
                        END SELECT

                    CASE "SGP13"

                        SELECT CASE J

                            CASE 1, 7, 8, 10
                                ' Automoveis e motos
                                PERCT(1) = PERCT(1) + VolAnual(J)
                            CASE 2, 3
                                ' Veiculos comerciais de dois eixos
                                PERCT(2) = PERCT(2) + VolAnual(J)
                            CASE 4
                                ' Veiculos comerciais de tres eixos
                                PERCT(3) = PERCT(3) + VolAnual(J)
                            CASE 5
                                ' Veiculos comerciais de 4 eixos
                                PERCT(4) = PERCT(4) + VolAnual(J)
                            CASE 6
                                ' Veiculos comerciais de 5 eixos
                                PERCT(5) = PERCT(5) + VolAnual(J)
                            CASE 9
                                ' Veiculos comerciais de 6 ou mais eixos
                                PERCT(6) = PERCT(6) + VolAnual(J)
                            CASE ELSE
                                GOSUB 10
                        END SELECT

                    CASE "SGP23"

                        SELECT CASE J
                            CASE 1, 3, 5, 9
                                ' Automoveis e motos
                                PERCT(1) = PERCT(1) + VolAnual(J)
                            CASE 2
                                ' Veiculos comerciais de dois eixos
                                PERCT(2) = PERCT(2) + VolAnual(J)
                            CASE 4
                                ' Veiculos comerciais de tres eixos
                                PERCT(3) = PERCT(3) + VolAnual(J)
                            CASE 6
                                ' Veiculos comerciais de 4 eixos
                                PERCT(4) = PERCT(4) + VolAnual(J)
                            CASE 7
                                ' Veiculos comerciais de 5 eixos
                                PERCT(5) = PERCT(5) + VolAnual(J)
                            CASE 8, 10, 11, 12, 13, 14
                                ' Veiculos comerciais de 6 ou mais eixos
                                PERCT(6) = PERCT(6) + VolAnual(J)
                            CASE ELSE
                                GOSUB 10
                        END SELECT

                    CASE "SGP4\", "SGP9\", "SGP19", "SGP20", "SGP21", "SGP25", "SGP26", "SGP27", "SGP28", "SGP29", "SGP30", "SGMBD", "SGP31", "SGP32", "SGP33", "SGP51"

                        SELECT CASE J
                            CASE 1, 7, 8, 15
                                ' Automoveis e motos
                                PERCT(1) = PERCT(1) + VolAnual(J)
                            CASE 2, 12
                                ' Veiculos comerciais de dois eixos
                                PERCT(2) = PERCT(2) + VolAnual(J)
                            CASE 3, 13
                                ' Veiculos comerciais de tres eixos
                                PERCT(3) = PERCT(3) + VolAnual(J)
                            CASE 4, 14
                                ' Veiculos comerciais de 4 eixos
                                PERCT(4) = PERCT(4) + VolAnual(J)
                            CASE 5
                                ' Veiculos comerciais de 5 eixos
                                PERCT(5) = PERCT(5) + VolAnual(J)
                            CASE 6, 9, 10, 11
                                ' Veiculos comerciais de 6 ou mais eixos
                                PERCT(6) = PERCT(6) + VolAnual(J)
                            CASE ELSE
                                GOSUB 10
                        END SELECT

                    CASE "SGP6\"

                        SELECT CASE J

                            CASE 1, 11
                                ' Automoveis e motos
                                PERCT(1) = PERCT(1) + VolAnual(J)
                            CASE 2, 3
                                ' Veiculos comerciais de dois eixos
                                PERCT(2) = PERCT(2) + VolAnual(J)
                            CASE 4
                                ' Veiculos comerciais de tres eixos
                                PERCT(3) = PERCT(3) + VolAnual(J)
                            CASE 5, 6
                                ' Veiculos comerciais de 4 eixos
                                PERCT(4) = PERCT(4) + VolAnual(J)
                            CASE 7
                                ' Veiculos comerciais de 5 eixos
                                PERCT(5) = PERCT(5) + VolAnual(J)
                            CASE 8, 9, 10
                                ' Veiculos comerciais de 6 ou mais eixos
                                PERCT(6) = PERCT(6) + VolAnual(J)
                            CASE ELSE
                                GOSUB 10
                        END SELECT

                    CASE "SGP46", "SGP47", "SGP48"

                        SELECT CASE J

                            CASE 1, 3, 5, 12, 13
                                ' Automoveis e motos
                                PERCT(1) = PERCT(1) + VolAnual(J)
                            CASE 2
                                ' Veiculos comerciais de dois eixos
                                PERCT(2) = PERCT(2) + VolAnual(J)
                            CASE 4
                                ' Veiculos comerciais de tres eixos
                                PERCT(3) = PERCT(3) + VolAnual(J)
                            CASE 6
                                ' Veiculos comerciais de 4 eixos
                                PERCT(4) = PERCT(4) + VolAnual(J)
                            CASE 7
                                ' Veiculos comerciais de 5 eixos
                                PERCT(5) = PERCT(5) + VolAnual(J)
                            CASE 8, 9, 10, 11
                                ' Veiculos comerciais de 6 ou mais eixos
                                PERCT(6) = PERCT(6) + VolAnual(J)
                            CASE ELSE
                                GOSUB 10
                        END SELECT

                    CASE ELSE

                        SELECT CASE J

                            CASE 1, 7, 8, 9
                                ' Automoveis e motos
                                PERCT(1) = PERCT(1) + VolAnual(J)
                            CASE 2
                                ' Veiculos comerciais de dois eixos
                                PERCT(2) = PERCT(2) + VolAnual(J)
                            CASE 3
                                ' Veiculos comerciais de tres eixos
                                PERCT(3) = PERCT(3) + VolAnual(J)
                            CASE 4
                                ' Veiculos comerciais de 4 eixos
                                PERCT(4) = PERCT(4) + VolAnual(J)
                            CASE 5
                                ' Veiculos comerciais de 5 eixos
                                PERCT(5) = PERCT(5) + VolAnual(J)
                            CASE 6, 10, 11, 12
                                ' Veiculos comerciais de 6 ou mais eixos
                                PERCT(6) = PERCT(6) + VolAnual(J)
                            CASE ELSE
                                GOSUB 10
                        END SELECT

                END SELECT

            NEXT I
            CLOSE #15

            VDMcom = 0
            FOR I = 2 TO 6
                VDMcom = VDMcom + PERCT(I) / 365
            NEXT I
            FVeic = 0
            FvDNER = 0
            FOR I = 2 TO 6
                PERCT(I) = (PERCT(I) / 365) / VDMcom
                FVeic = FVeic + FV(I) * PERCT(I)
                FvDNER = FvDNER + FVusace(I) * PERCT(I)
            NEXT I
            VDMunid = VDM / 365

        ELSE

            VDMcom = 0
            FOR I = 2 TO 6
                VDMcom = VDMcom + VDMeixos(I)
            NEXT I
            FVeic = 0
            FvDNER = 0
            FOR I = 2 TO 6
                PERCT(I) = VDMeixos(I) / VDMcom
                FVeic = FVeic + FV(I) * PERCT(I)
                FvDNER = FvDNER + FVusace(I) * PERCT(I)
            NEXT I

        END IF

        ' Indice de Defeitos de Superficie
        INPUT #14, ISTHH, IGG(1), IGG(2), IGG(3), IGG(4), TR23(1), TR23(2), TR23(3), TR23(4), TR3(1), TR3(2), TR3(3), TR3(4)

        TAXACOMERC = (TaxaCam + TaxaOnibus) / 2
        TaxaVDM = (TaxaAutos * (VDMunid - VDMcom) + TAXACOMERC * VDMcom) / VDMunid
        FatorVDM = 1 + (TaxaVDM / 100)
        FatorTraf = 1 + (TAXACOMERC / 100)

        FOR IFaixa = 1 TO NFaixas

            ' Parametros relativos ao trafego:
            PISTA$ = UCASE$(PISTA$)
            VDMUni(IFaixa) = (VDMunid - VDMcom) / NFaixas
            IF PERCTRAF(IFaixa) > 0 THEN VDMc(IFaixa) = VDMcom * (PERCTRAF(IFaixa) / 100) ELSE VDMc(IFaixa) = 0
            VDMUni(IFaixa) = VDMUni(IFaixa) + VDMc(IFaixa)
            NANO(IFaixa) = VDMc(IFaixa) * FVeic * 365
            NANOusace(IFaixa) = VDMc(IFaixa) * FvDNER * 365

            ' - - - - - - - - - - - - - - - -
            ' -  Estado de Superficie atual -
            ' - - - - - - - - - - - - - - - -

            QInovo = 15
            PSIQInovo = 5! * EXP(-QInovo / 71.5)
            PSRnovo = 5
            PSI0max = (PSRnovo + PSIQInovo) / 2
            PSIQI = 5! * EXP(-QImed(IFaixa) / 71.5)
            PSIIDS = (309.22 - .616 * IGG(IFaixa)) / (61.844 + IGG(IFaixa))
            PSRmed = (PSR(IFaixa) + PSIIDS) / 2
            SELECT CASE DEFPSI
                CASE 0
                    PSIat(ISTH, IFaixa) = (PSRmed + PSIQI) / 2
                    ' Estimativa do PSInovo apos a ultima restauracao
                    IF IRest(IFaixa) = 1 THEN
                        IF PSIat(ISTH, IFaixa) > 4 THEN
                            Fator = .602
                        ELSE
                            IF PSI > 2 THEN Fator = .602 * ((PSI - 2) / 2) ELSE Fator = 0
                        END IF
                        QIantes = 19 + (QImed(IFaixa) - 19) * (1 + Fator * HrecExist(IFaixa))
                        QI0 = 19 + (QIantes - 19) / (1 + .602 * HrecExist(IFaixa))
                        PSIcr0 = 5 * EXP(-QI0 / 71.5)
                        PSInovo(IFaixa) = (5 + PSIcr0) / 2
                        IF PSInovo(IFaixa) > PSI0max THEN PSInovo(IFaixa) = PSI0max
                    ELSE
                        PSInovo(IFaixa) = PSI0max
                    END IF
                CASE 1
                    PSIat(ISTH, IFaixa) = PSRmed
                    PSInovo(IFaixa) = PSI0max
                CASE ELSE
                    PRINT "ERRO EM DEFPSI"
            END SELECT
            IF PSIat(ISTH, IFaixa) > PSInovo(IFaixa) THEN PSIat(ISTH, IFaixa) = PSInovo(IFaixa)
            IF PSIat(ISTH, IFaixa) < .5 THEN PSIat(ISTH, IFaixa) = .5

            PSI = PSIat(ISTH, IFaixa)
            TR = TR23(IFaixa)
            ATR = ATRmed(IFaixa)
            IF (PSI < PSIref OR QImed(IFaixa) > QIref OR IGG(IFaixa) > IGGref OR ATR > ATRref OR TR > TRref) THEN
                NPSI = NPSI + 1
            END IF

            PSImed = PSImed + PSIat(ISTH, IFaixa) * Aream2(ISTH, IFaixa)

            ' Parametros para o Indice de Prioridade
            IF VDMUni(IFaixa) > VDMmax THEN VDMmax = VDMUni(IFaixa)
            IF VDMUni(IFaixa) < VDMmin THEN VDMmin = VDMUni(IFaixa)
            IF PSIat(ISTH, IFaixa) > PSImax THEN PSImax = PSIat(ISTH, IFaixa)
            IF PSIat(ISTH, IFaixa) < PSImin THEN PSImin = PSIat(ISTH, IFaixa)

        NEXT IFaixa

        ' - - - - - - - - - - - - - - - - - - - - - - - - - - -
        ' -   Calibracao do Modelo de Previsao de Desempenho  -
        ' - - - - - - - - - - - - - - - - - - - - - - - - - - -
        IF Icalibra > 0 THEN
            IF Icalibra = 1 THEN
                FOR IFaixa = 1 TO NFaixas
                    IF IRest(IFaixa) = 1 THEN
                        SELECT CASE REVEST$(IFaixa)
                            CASE "CBUQ"
                                HR = HrecExist(IFaixa)
                                IF HR < 5 THEN
                                    FcMed = .31566 * (HR ^ 1.15146)
                                    Sigma = (.7242 / 2) * FcMed
                                ELSE
                                    FcMed = 2
                                    Sigma = .7242
                                END IF
                                FC0defRecap = FcMed - Nt * Sigma
                            CASE "CBUQAB"
                                HR = HrecExist(IFaixa) / 0.7
                                IF HR < 5 THEN
                                    FcMed = .31566 * (HR ^ 1.15146)
                                    Sigma = (.7242 / 2) * FcMed
                                ELSE
                                    FcMed = 2
                                    Sigma = .7242
                                END IF
                                FC0defRecap = FcMed - Nt * Sigma
                            CASE "CBUQPOL"
                                HR = HrecExist(IFaixa) / 0.6
                                IF HR < 5 THEN
                                    FcMed = .31566 * (HR ^ 1.15146)
                                    Sigma = (.7242 / 2) * FcMed
                                ELSE
                                    FcMed = 2
                                    Sigma = .7242
                                END IF
                                FC0defRecap = FcMed - Nt * Sigma
                            CASE "MICRO"
                                FcMed = .9167
                                Sigma = .3033
                                FC0defMicro = FcMed - Nt * Sigma
                            CASE ELSE
                                PRINT "ERRO EM REVEST$"
                        END SELECT
                    ELSE
                        FcMed = .91
                        Sigma = .239
                        FC0defCA = FcMed - Ngauss * Sigma
                    END IF
                    FC0oldCA(IFaixa) = FC0defCA
                    FC1oldCA(IFaixa) = FCdefCA
                    FC2oldCA(IFaixa) = FC2defCA
                    FC0oldRecap(IFaixa) = FC0defRecap
                    FC1oldRecap(IFaixa) = FCdefRecap
                    FC2oldRecap(IFaixa) = FC2defRecap
                    FC0oldMicro(IFaixa) = FC0defMicro
                    FC1oldMicro(IFaixa) = FCdefMicro
                    FC2oldMicro(IFaixa) = FC2defMicro
                NEXT IFaixa
            ELSE
                ARQUIVO$ = CALC$ + "Ano" + STR$(ANOBASE) + "\FC" + STR$(STH) + ".CSV"
                OPEN ARQUIVO$ FOR INPUT AS #15
                ' Pavimento asfaltico nunca restaurado
                INPUT #15, FC0oldCA(1), FC0oldCA(2), FC0oldCA(3), FC0oldCA(4)
                INPUT #15, FC1oldCA(1), FC1oldCA(2), FC1oldCA(3), FC1oldCA(4)
                INPUT #15, FC2oldCA(1), FC2oldCA(2), FC2oldCA(3), FC2oldCA(4)
                ' Recapeamento em CBUQ
                INPUT #15, FC0oldRecap(1), FC0oldRecap(2), FC0oldRecap(3), FC0oldRecap(4)
                INPUT #15, FC1oldRecap(1), FC1oldRecap(2), FC1oldRecap(3), FC1oldRecap(4)
                INPUT #15, FC2oldRecap(1), FC2oldRecap(2), FC2oldRecap(3), FC2oldRecap(4)
                ' Micro-concreto Asfaltico
                INPUT #15, FC0oldMicro(1), FC0oldMicro(2), FC0oldMicro(3), FC0oldMicro(4)
                INPUT #15, FC1oldMicro(1), FC1oldMicro(2), FC1oldMicro(3), FC1oldMicro(4)
                INPUT #15, FC2oldMicro(1), FC2oldMicro(2), FC2oldMicro(3), FC2oldMicro(4)
                CLOSE #15
            END IF
        END IF
        FOR IFaixa = 1 TO NFaixas
         
            Exec = 1
            Age = Idade(IFaixa)
            IF Age <= 0 THEN Exec = 0
            IF IRest(IFaixa) = 1 THEN
                SELECT CASE REVEST$(IFaixa)
                    CASE "CBUQ", "CBUQAB", "CBUQPOL"
                        Fc0 = FC0oldRecap(IFaixa)
                        Fc1 = FC1oldRecap(IFaixa)
                        Fc2 = FC2oldRecap(IFaixa)
                    CASE "MICRO"
                        Fc0 = FC0oldMicro(IFaixa)
                        Fc1 = FC1oldMicro(IFaixa)
                        Fc2 = FC2oldMicro(IFaixa)
                    CASE ELSE
                        PRINT "ERRO EM REVEST$"
                END SELECT
            ELSE
                IF REVEST$(IFaixa) = "CCP" THEN
                    Fc0 = 1
                    Fc1 = 1
                    Fc2 = 1
                ELSE
                    Fc0 = FC0oldCA(IFaixa)
                    Fc1 = FC1oldCA(IFaixa)
                    Fc2 = FC2oldCA(IFaixa)
                END IF
            END IF
            ALPHA(IFaixa) = Fc1
            ALPHA0(IFaixa) = Fc0
            ALPHA2(IFaixa) = Fc2

            PSI = PSIat(ISTH, IFaixa)
            Nacum(IFaixa) = Age * NANO(IFaixa)
            NE4 = Nacum(IFaixa) / 1000000!
            Nyear = NANO(IFaixa) / 1000000!
            H1 = H1REV(IFaixa)
            FatorHR = 1
            IF REVEST$(IFaixa) = "CBUQAB" THEN FatorHR = 0.7
            IF REVEST$(IFaixa) = "CBUQPOL" THEN FatorHR = 0.6
            IF SN(IFaixa) <= 0 THEN
                SELECT CASE CamBase$(IFaixa)
                    CASE "BG", "MS", "MH"
                        A2 = .14
                    CASE "Solo-Cimento", "Solo-Cal"
                        A2 = .2
                    CASE "BGTC"
                        A2 = .25
                    CASE "PMF"
                        A2 = .27
                    CASE "MB", "PMQ", "Solo-Betume"
                        A2 = .29
                    CASE "CCR", "CCP"
                        A2 = .35
                    CASE "CBUQ", "Binder", "BINDER"
                        A2 = .32
                    CASE ELSE
                        A2 = .12
                END SELECT
                SN(IFaixa) = .44 * ((H1 / FatorHR) / 2.54) + A2 * (H2CM(IFaixa) / 2.54) + .11 * (H3CM(IFaixa) / 2.54) + .07 * (H4CM(IFaixa) / 2.54)
            END IF
            IF CBRSL(IFaixa) < 3 THEN CBRSL(IFaixa) = 3
            LCBR = LOG(CBRSL(IFaixa)) / LOG(10)
            SNC = SN(IFaixa) + 3.51 * LCBR - .85 * (LCBR ^ 2) - 1.43
            IF NANO(IFaixa) <= 0 THEN
                Mesg$ = "ERRO no trafego do Subtrecho No.: " + STR$(STH) + " na faixa de trafego " + STR$(IFaixa)
                GOSUB 500
                Exec = 0
            END IF
            IF (PSI <= 0 OR PSI >= 5) THEN
                Mesg$ = "ERRO no PSI do Subtrecho No.: " + STR$(STH) + " na faixa de trafego " + STR$(IFaixa)
                GOSUB 500
                Exec = 0
            END IF
            IF IRest(IFaixa) = 1 THEN
                IF HrecExist(IFaixa) <= 0 THEN
                    Mesg$ = "ERRO na espessura do ultimo recapeamento do Subtrecho No.: " + STR$(STH) + " na faixa de trafego " + STR$(IFaixa)
                    GOSUB 500
                    Exec = 0
                END IF
            END IF
            IF PSI >= PSInovo(IFaixa) THEN Exec = 0
            Icalib(IFaixa) = 0
            GOSUB 6800
            MR = E / .0703
            MRfound(IFaixa) = .0703 * MR

            IF Exec = 1 THEN

                FatorHR = 1
                IF REVEST$(IFaixa) = "CBUQAB" THEN FatorHR = 0.7
                IF REVEST$(IFaixa) = "CBUQPOL" THEN FatorHR = 0.6
                BASE$ = UCASE$(CamBase$(IFaixa))
                IF IRest(IFaixa) = 0 THEN
                    V1 = 8.7: V2 = 12.5
                    SELECT CASE BASE$
                        CASE "BGTC", "SOLO-CIMENTO", "SOLO-CAL", "CCP"
                            CMOD = 120000 / 10000!
                            TYcr2 = 1.11 * EXP(.035 * (H1 / FatorHR) * 10 + .371 * LOG(CMOD) - .418 * LOG(D0(IFaixa) / 100) - 2.87 * Nyear * (D0(IFaixa) / 100))
                        CASE ELSE
                            SNCL = SNC - (0.44 * H1 / 2.54)
                            SNCL = SNCL + (0.44 * H1 / (FatorHR * 2.54))
                            TYcr2 = 4.21 * EXP(.139 * SNCL - 17.1 * (Nyear / (SNC ^ 2)))
                            V1 = 6.3: V2 = 8.7
                    END SELECT
                ELSE
                    PCR4 = TR3(IFaixa)
                    TYcr2A = 2.54 * EXP(.0157 * (HrecExist(IFaixa) / FatorHR) * 10 - .0141 * PCR4)
                    TYcr2B = 10.8 * EXP(-1.21 * (D0(IFaixa) / 100) - 1.02 * Nyear * (D0(IFaixa) / 100))
                    TYcr2 = (1 * TYcr2A + 1.5 * TYcr2B) / (1 + 1.5)
                    IF REVEST$(IFaixa) = "CBUQ" THEN
                        V1 = 5: V2 = 7.6
                    ELSE
                        IF PCR4 > 0 THEN V1 = PCR4 / TYcr2 ELSE V1 = 5
                        V2 = (31 / 10.2) * V1
                    END IF
                END IF
                T0(IFaixa) = TYcr2

                Nf = Fc0 * TYcr2 * NANO(IFaixa)
                PT = 2.5
                DPSI = PSInovo(IFaixa) - PT
                SNcalib = SN(IFaixa)
                MR = 100 * CBRSL(IFaixa) / .0703
                IF REVEST$(IFaixa) = "CCP" THEN
                    ' Dados
                    K = MR / 19.4
                    D = H1 / 2.54
                    J = 3.2
                    CD = 1
                    ' Correlacoes
                    RTF = 640
                    RTFMPA = RTF * .0703 / 10
                    RCS = 10 * ((RTFMPA / .56) ^ 1.67)
                    EC = (15110 * (RCS ^ .5)) / .0703
                    ' Modelo do Guia da AASHTO
                    W18# = 215.63 * J * ((D ^ .75) - (18.42 / ((EC / K) ^ .25)))
                    W18# = (4.22 - .32 * PT) * LOG(RTF * CD * ((D ^ .75) - 1.132) / W18#) / LOG(10)
                    A# = (LOG(DPSI / (4.5 - 1.5)) / LOG(10)) / (1 + (1.624E+07 / ((D + 1) ^ 8.46)))
                    W18# = W18# + A# - .06 + 7.35 * (LOG(D + 1) / LOG(10))
                    W18# = (10 ^ W18#) / 1000000!
                ELSE
                    BETA = .4 + (1094 / ((SNcalib + 1) ^ 5.19))
                    W18# = (((SNcalib + 1) / 1.05) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
                    W18# = W18# * ((MR / 3000) ^ 2.32) / 1000000!
                END IF
                FCmin = FCminCA
                FCmax = FCmaxCA
                FC0min = FC0minCA
                FC0max = FC0maxCA
                FC2min = FC2minCA
                FC2max = FC2maxCA
                ' Valor de Alfa pelo Guia da AASHTO
                ALFAA = (1 / W18#) * LOG(LOG(PT / 5) / LOG(PSInovo(IFaixa) / 5))
                ' Calibracao pelo HDM-III
                ALFAnew(IFaixa) = 1! * ALFAA
                IF IRest(IFaixa) = 1 THEN
                    SELECT CASE REVEST$(IFaixa)
                        CASE "CBUQ"
                            A1 = .44
                            FCmin = FCminRecap
                            FCmax = FCmaxRecap
                            FC0min = FC0minRecap
                            FC0max = FC0maxRecap
                            FC2min = FC2minRecap
                            FC2max = FC2maxRecap
                        CASE "CBUQAB"
                            A1 = .44 / 0.7
                            FCmin = FCminRecap
                            FCmax = FCmaxRecap
                            FC0min = FC0minRecap
                            FC0max = FC0maxRecap
                            FC2min = FC2minRecap
                            FC2max = FC2maxRecap
                        CASE "CBUQPOL"
                            A1 = .44 / 0.6
                            FCmin = FCminRecap
                            FCmax = FCmaxRecap
                            FC0min = FC0minRecap
                            FC0max = FC0maxRecap
                            FC2min = FC2minRecap
                            FC2max = FC2maxRecap
                        CASE "MICRO"
                            A1 = .44
                            FCmin = FCminMicro
                            FCmax = FCmaxMicro
                            FC0min = FC0minMicro
                            FC0max = FC0maxMicro
                            FC2min = FC2minMicro
                            FC2max = FC2maxMicro
                        CASE ELSE
                            PRINT "ERRO EM REVEST$"
                    END SELECT
                    SNcalib = A1 * (HrecExist(IFaixa) / FatorHR) / 2.54
                    BETA = .4 + (1094 / ((SNcalib + 1) ^ 5.19))
                    GOSUB 6800
                    MR = E / .0703
                    MRfound(IFaixa) = .0703 * MR
                    W18# = (((SNcalib + 1) / 1.05) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
                    W18# = W18# * ((MR / 3000) ^ 2.32) / 1000000!
                    ' Valor de Alfa pelo Guia da AASHTO
                    ALFAA = (1 / W18#) * LOG(LOG(PT / 5) / LOG(PSInovo(IFaixa) / 5))
                    ' Calibracao pelo HDM-III
                    ALFA(IFaixa) = 1! * ALFAA
                ELSE
                    ALFA(IFaixa) = ALFAnew(IFaixa)
                END IF

                IF TR23(IFaixa) > 0 THEN
                    IF TR23(IFaixa) < 30 THEN
                        dTRdt = V1
                    ELSE
                        dTRdt = V2
                    END IF
                    DeltaT = TR23(IFaixa) / dTRdt
                    DeltaN = DeltaT * NANO(IFaixa)
                    Nfrec = Nacum(IFaixa) - DeltaN
                    IF Nfrec > 0 THEN
                        Fc0 = Nfrec / (TYcr2 * NANO(IFaixa))
                        GOSUB 200
                        Ncasos0 = Ncasos0 + 1
                    END IF
                    Nf = ALPHA0(IFaixa) * TYcr2 * NANO(IFaixa)
                ELSE
                    IF Nacum(IFaixa) < Nf THEN
                        ' Nf e' confiavel (aceita Fc0)
                        Ncasos0 = Ncasos0 + 1
                        GOSUB 200
                    END IF
                END IF
                ' Estimativa inicial de PSIcritico
                Nfad = Nf / 1000000!
                P# = ALPHA(IFaixa) * ALFAA * Nfad
                IF P# < 85 THEN
                    PSIcrt = 5 * ((PSInovo(IFaixa) / 5) ^ EXP(P#))
                ELSE
                    PSIcrt = .9 * PSInovo(IFaixa)
                END IF

                TRmin = 10
                IF Nacum(IFaixa) < Nf THEN
                    IF PSI >= PSIcrt THEN
                        ' Calcula Fc1
                        ALFAL = (1 / NE4) * LOG(LOG(PSI / 5) / LOG(PSInovo(IFaixa) / 5))
                        Ncasos = Ncasos + 1
                        Fc = ALFAL / ALFA(IFaixa)
                        GOSUB 100
                    ELSE
                        IF TR23(IFaixa) < TRmin THEN
                            ' Calcula Fc1 (PSIcrt inicial esta' errado)
                            ALFAL = (1 / NE4) * LOG(LOG(PSI / 5) / LOG(PSInovo(IFaixa) / 5))
                            Ncasos = Ncasos + 1
                            Fc = ALFAL / ALFA(IFaixa)
                            GOSUB 100
                        END IF
                    END IF
                ELSE
                    IF PSI < PSIcrt THEN
                        ' Calcula Fc2
                        GOSUB 70
                    ELSE
                        IF TR23(IFaixa) > TRmin THEN
                            ' Erro em PSIcrt (sera' feita nova tentativa)
                            PSIcrt = 1.1 * PSI
                            IF PSIcrt >= PSInovo(IFaixa) THEN PSIcrt = .95 * PSInovo(IFaixa)
                            IF PSI < PSIcrt THEN
                                ' Calcula Fc2
                                GOSUB 70
                                ' Recalcula Fc1
                                Nfad = Nf / 1000000!
                                ALFAL = (1 / Nfad) * LOG(LOG(PSIcrt / 5) / LOG(PSInovo(IFaixa) / 5))
                                Ncasos = Ncasos + 1
                                Fc = ALFAL / ALFA(IFaixa)
                                GOSUB 100
                            END IF
                        END IF
                    END IF
                END IF

                IF Icalibra > 0 THEN
                    IF IRest(IFaixa) = 1 THEN
                        SELECT CASE REVEST$(IFaixa)
                            CASE "CBUQ", "CBUQAB", "CBUQPOL"
                                FC0oldRecap(IFaixa) = ALPHA0(IFaixa)
                                FC1oldRecap(IFaixa) = ALPHA(IFaixa)
                                FC2oldRecap(IFaixa) = ALPHA2(IFaixa)
                            CASE "MICRO"
                                FC0oldMicro(IFaixa) = ALPHA0(IFaixa)
                                FC1oldMicro(IFaixa) = ALPHA(IFaixa)
                                FC2oldMicro(IFaixa) = ALPHA2(IFaixa)
                            CASE ELSE
                                PRINT "ERRO"
                        END SELECT
                    ELSE
                        FC0oldCA(IFaixa) = ALPHA0(IFaixa)
                        FC1oldCA(IFaixa) = ALPHA(IFaixa)
                        FC2oldCA(IFaixa) = ALPHA2(IFaixa)
                    END IF
                END IF

            ELSE

                T0(IFaixa) = 5

            END IF

            ARQUIVO$ = CALC$ + "MEM1.DAT"
            OPEN ARQUIVO$ FOR APPEND AS #15
            WRITE #15, IRest(IFaixa), SNcalib, MR, Icalib(IFaixa)
            CLOSE #15

            ' Modelo: Irregularidade = f(t)
            IRIcor = QImed(IFaixa) / 13
            IRI0(IFaixa) = IRIcor * EXP(-.0153 * Age)
            IRI0(IFaixa) = IRI0(IFaixa) - 725 * ((1 + SNC) ^ -4.99) * NE4
            QI0 = 13 * IRI0(IFaixa)
            QI0min = 5
            QI0max = 40
            IF QI0 < QI0min THEN QI0 = QI0min
            IF QI0 > QI0max THEN QI0 = QI0max
            IRI0(IFaixa) = QI0 / 13
         
            ' Calibracao da correlacao PSI x IDS
            IF PSIat(ISTH, IFaixa) < PSI0max THEN
                'IGG = ALFAIGG * ((((PSIMAX / PSI) - 1) / .007635) ^ (1 / 1.065))
                ALFAI = IGG(IFaixa) / ((((PSI0max / PSIat(ISTH, IFaixa)) - 1) / .007635) ^ (1 / 1.065))
                IF (ALFAI > .3 AND ALFAI < 3) THEN ALFAIGG(IFaixa) = ALFAI
            END IF

            PSIacost(IFaixa) = PSRACOST(IFaixa)
            DegrauAcost(IFaixa) = DEGRAUCM(IFaixa)

        NEXT IFaixa

        IF Icalibra > 0 THEN
            ARQUIVO$ = CALC$ + "Ano" + STR$(ANOBASE) + "\FC" + STR$(STH) + ".CSV"
            OPEN ARQUIVO$ FOR OUTPUT AS #15
            ' Pavimento asfaltico nunca restaurado
            WRITE #15, FC0oldCA(1), FC0oldCA(2), FC0oldCA(3), FC0oldCA(4)
            WRITE #15, FC1oldCA(1), FC1oldCA(2), FC1oldCA(3), FC1oldCA(4)
            WRITE #15, FC2oldCA(1), FC2oldCA(2), FC2oldCA(3), FC2oldCA(4)
            ' Recapeamento em CBUQ
            WRITE #15, FC0oldRecap(1), FC0oldRecap(2), FC0oldRecap(3), FC0oldRecap(4)
            WRITE #15, FC1oldRecap(1), FC1oldRecap(2), FC1oldRecap(3), FC1oldRecap(4)
            WRITE #15, FC2oldRecap(1), FC2oldRecap(2), FC2oldRecap(3), FC2oldRecap(4)
            ' Micro-concreto Asfaltico
            WRITE #15, FC0oldMicro(1), FC0oldMicro(2), FC0oldMicro(3), FC0oldMicro(4)
            WRITE #15, FC1oldMicro(1), FC1oldMicro(2), FC1oldMicro(3), FC1oldMicro(4)
            WRITE #15, FC2oldMicro(1), FC2oldMicro(2), FC2oldMicro(3), FC2oldMicro(4)
            CLOSE #15
        END IF

        IF DegrauAcost(1) >= 0 THEN
            IF DegrauAcost(NFaixas) >= 0 THEN
                DegrauMedio = (DegrauAcost(1) + DegrauAcost(NFaixas)) / 2
            ELSE
                DegrauMedio = DegrauAcost(1)
            END IF
        ELSE
            IF DegrauAcost(NFaixas) >= 0 THEN
                DegrauMedio = DegrauAcost(NFaixas)
            ELSE
                DegrauMedio = 0
            END IF
        END IF
        DegrauAcost(1) = DegrauMedio
        DegrauAcost(NFaixas) = DegrauMedio

        ' Arquivos onde sera' armazenada a condicao dos Subtrechos Homogeneos
        ARQUIVO$ = CALC$ + "ESTSTHS.DAT"
        OPEN ARQUIVO$ FOR APPEND AS #15
        WRITE #15, STH, NFaixas, KMI, KMF, FatorVDM, FatorTraf
        FOR IFX = 1 TO NFaixas
            IF (Idade(IFX) <= 0 AND REVEST$(IFX) = "CBUQ") THEN
                ' Valor de Alfa pelo Guia da AASHTO
                PT = 2.5
                DPSI = PSInovo(IFX) - PT
                MR = 100 * CBRSL(IFX) / 0.0703
                BETA = .4 + (1094 / ((SN(IFX) + 1) ^ 5.19))
                W18# = (((SN(IFX) + 1) / 1.05) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
                W18# = W18# * ((MR / 3000) ^ 2.32) / 1000000!
                ALFAA = (1 / W18#) * LOG(LOG(PT / 5) / LOG(PSInovo(IFX) / 5))
                ' Calibracao pelo HDM-III
                ALFA(IFX) = 1! * ALFAA
                Nyear = NANO(IFX) / 1000000!
                LCBR = LOG(CBRSL(IFX)) / LOG(10)
                SNC = SN(IFX) + 3.51 * LCBR - .85 * (LCBR ^ 2) - 1.43
                BASE$ = UCASE$(CamBase$(IFX))
                V1 = 8.7: V2 = 12.5
                SELECT CASE BASE$
                    CASE "BGTC", "SOLO-CIMENTO", "SOLO-CAL", "CCP"
                        CMOD = 120000 / 10000!
                        T0(IFX) = 1.11 * EXP(.035 * H1REV(IFX) * 10 + .371 * LOG(CMOD) - .418 * LOG(D0(IFX) / 100) - 2.87 * Nyear * (D0(IFX) / 100))
                    CASE ELSE
                        T0(IFX) = 4.21 * EXP(.139 * SNC - 17.1 * (Nyear / (SNC ^ 2)))
                END SELECT
            END IF
            WRITE #15, H1REV(IFX), HrecExist(IFX), Idade(IFX), SN(IFX), CBRSL(IFX), QImed(IFX), NANO(IFX), IRI0(IFX), ALFA(IFX), ALFAnew(IFX)
            WRITE #15, Nacum(IFX), REVEST$(IFX), CamBase$(IFX), ALFAIGG(IFX), VDMc(IFX), VDMUni(IFX)
            WRITE #15, PSIat(ISTH, IFX), Aream2(ISTH, IFX), VidaRes(IFX), PSInovo(IFX), Icalib(IFX), IRest(IFX), D0(IFX), MRfound(IFX)
            WRITE #15, ALPHA0(IFX), ALPHA(IFX), ALPHA2(IFX), AreaAcost(IFX), PSIacost(IFX), DegrauAcost(IFX), T0(IFX), TR23(IFX), ATRmed(IFX)
        NEXT IFX
        CLOSE #15

        ARQUIVO$ = CALC$ + "EST" + Rodov$(IRodov) + ".CSV"
        OPEN ARQUIVO$ FOR APPEND AS #15
        WRITE #15, STH, KMI, KMF, NANO(1), NANO(2), NANO(3), NANO(4), PSIat(ISTH, 1), VidaRes(1), VDMUni(1), PSIat(ISTH, 2), VidaRes(2), VDMUni(2), PSIat(ISTH, 3), VidaRes(3), VDMUni(3), PSIat(ISTH, 4), VidaRes(4), VDMUni(4), NANOusace(1), NANOusace(2), NANOusace(3), NANOusace(4), FVeic, FvDNER
        CLOSE #15
        tempTR$ = "&, ###.###, ###.###, ###.########, ###.########, ###.########, ###.########"
        ARQUIVO$ = CALC$ + "CALB" + Rodov$(IRodov) + ".CSV"
        OPEN ARQUIVO$ FOR APPEND AS #15
        PRINT #15, USING tempTR$; STR$(STH); KMI; KMF; ALPHA(1); ALPHA(2); ALPHA(3); ALPHA(4)
        CLOSE #15
        ARQUIVO$ = CALC$ + "CAL0" + Rodov$(IRodov) + ".CSV"
        OPEN ARQUIVO$ FOR APPEND AS #15
        PRINT #15, USING tempTR$; STR$(STH); KMI; KMF; ALPHA0(1); ALPHA0(2); ALPHA0(3); ALPHA0(4)
        CLOSE #15
        ARQUIVO$ = CALC$ + "CAL2" + Rodov$(IRodov) + ".CSV"
        OPEN ARQUIVO$ FOR APPEND AS #15
        PRINT #15, USING tempTR$; STR$(STH); KMI; KMF; ALPHA2(1); ALPHA2(2); ALPHA2(3); ALPHA2(4)
        CLOSE #15
        ARQUIVO$ = CALC$ + "INT" + Rodov$(IRodov) + ".CSV"
        OPEN ARQUIVO$ FOR APPEND AS #15
        WRITE #15, STH, UltRest$(1), UltRest$(2), UltRest$(3), UltRest$(4)
        CLOSE #15

    NEXT ISUB

    FOR ILL = 1 TO 10
        CLOSE #ILL
    NEXT ILL

    IF ICONTovl > 0 THEN
        FCrecaprede(IRodov) = FCrecaprede(IRodov) / ICONTovl
    ELSE
        FCrecaprede(IRodov) = FCdefRecap
    END IF
    IF ICONTnew > 0 THEN
        FCnovorede(IRodov) = FCnovorede(IRodov) / ICONTnew
    ELSE
        FCnovorede(IRodov) = FCdefCA
    END IF
    IF ICONTmca > 0 THEN
        FCmicrorede(IRodov) = FCmicrorede(IRodov) / ICONTmca
    ELSE
        FCmicrorede(IRodov) = FCdefMicro
    END IF

    IF ICONT0ovl > 0 THEN
        FC0recaprede(IRodov) = FC0recaprede(IRodov) / ICONT0ovl
    ELSE
        FC0recaprede(IRodov) = FC0defRecap
    END IF
    IF ICONT0new > 0 THEN
        FC0novorede(IRodov) = FC0novorede(IRodov) / ICONT0new
    ELSE
        FC0novorede(IRodov) = FC0defCA
    END IF
    IF ICONT0mca > 0 THEN
        FC0microrede(IRodov) = FC0microrede(IRodov) / ICONT0mca
    ELSE
        FC0microrede(IRodov) = FC0defMicro
    END IF

    IF ICONT2ovl > 0 THEN
        FC2recaprede(IRodov) = FC2recaprede(IRodov) / ICONT2ovl
    ELSE
        FC2recaprede(IRodov) = FC2defRecap
    END IF
    IF ICONT2new > 0 THEN
        FC2novorede(IRodov) = FC2novorede(IRodov) / ICONT2new
    ELSE
        FC2novorede(IRodov) = FC2defCA
    END IF
    IF ICONT2mca > 0 THEN
        FC2microrede(IRodov) = FC2microrede(IRodov) / ICONT2mca
    ELSE
        FC2microrede(IRodov) = FC2defMicro
    END IF

NEXT IRodov
CLOSE #14
 
PSImed = PSImed / AreaTotal
NPSI = 100 * NPSI / NUnidAnalise
 
ARQUIVO$ = CALC$ + "ESTSTHS.DAT"
OPEN ARQUIVO$ FOR APPEND AS #15
WRITE #15, PSImed, NPSI
WRITE #15, AreaTotal, NUnidAnalise
CLOSE #15

ARQUIVO$ = CALC$ + "IP.DAT"
OPEN ARQUIVO$ FOR OUTPUT AS #1
WRITE #1, VDMmin, VDMmax
WRITE #1, PSImin, PSImax
CLOSE #1

IF ICONTrecap > 0 THEN
    FCrecap = FCrecap / ICONTrecap
ELSE
    FCrecap = FCdefRecap
END IF
IF ICONTnovo > 0 THEN
    FCnovo = FCnovo / ICONTnovo
ELSE
    FCnovo = FCdefCA
END IF
IF ICONTmicro > 0 THEN
    FCmicro = FCmicro / ICONTmicro
ELSE
    FCmicro = FCdefMicro
END IF
temp$ = "&, ###.########, ###.########, ###.########"
ARQUIVO$ = CALC$ + "CALIB.CSV"
OPEN ARQUIVO$ FOR OUTPUT AS #1
WRITE #1, "Trecho", "FC_NOVO", "FC_RECAP", "FC_MICRO"
FOR I = 1 TO NRODOV
    PRINT #1, USING temp$; Trecho$(I); FCnovorede(I); FCrecaprede(I); FCmicrorede(I)
NEXT I
PRINT #1, USING temp$; "Rede"; FCnovo; FCrecap; FCmicro
CLOSE #1
ARQUIVO$ = CALC$ + "CALIB.DAT"
OPEN ARQUIVO$ FOR OUTPUT AS #1
WRITE #1, FCnovo
WRITE #1, FCrecap
WRITE #1, FCmicro
CLOSE #1

IF ICONT0recap > 0 THEN
    FC0recap = FC0recap / ICONT0recap
ELSE
    FC0recap = FC0defRecap
END IF
IF ICONT0novo > 0 THEN
    FC0novo = FC0novo / ICONT0novo
ELSE
    FC0novo = FC0defCA
END IF
IF ICONT0micro > 0 THEN
    FC0micro = FC0micro / ICONT0micro
ELSE
    FC0micro = FC0defMicro
END IF
ARQUIVO$ = CALC$ + "CALIB0.CSV"
OPEN ARQUIVO$ FOR OUTPUT AS #1
WRITE #1, "Trecho", "FC_NOVO", "FC_RECAP", "FC_MICRO"
FOR I = 1 TO NRODOV
    PRINT #1, USING temp$; Trecho$(I); FC0novorede(I); FC0recaprede(I); FC0microrede(I)
NEXT I
PRINT #1, USING temp$; "Rede"; FC0novo; FC0recap; FC0micro
CLOSE #1
ARQUIVO$ = CALC$ + "CALIB0.DAT"
OPEN ARQUIVO$ FOR OUTPUT AS #1
WRITE #1, FC0novo
WRITE #1, FC0recap
WRITE #1, FC0micro
CLOSE #1

IF ICONT2recap > 0 THEN
    FC2recap = FC2recap / ICONT2recap
ELSE
    FC2recap = FC2defRecap
END IF
IF ICONT2novo > 0 THEN
    FC2novo = FC2novo / ICONT2novo
ELSE
    FC2novo = FC2defCA
END IF
IF ICONT2micro > 0 THEN
    FC2micro = FC2micro / ICONT2micro
ELSE
    FC2micro = FC2defMicro
END IF
ARQUIVO$ = CALC$ + "CALIB2.CSV"
OPEN ARQUIVO$ FOR OUTPUT AS #1
WRITE #1, "Trecho", "FC_NOVO", "FC_RECAP", "FC_MICRO"
FOR I = 1 TO NRODOV
    PRINT #1, USING temp$; Trecho$(I); FC2novorede(I); FC2recaprede(I); FC2microrede(I)
NEXT I
PRINT #1, USING temp$; "Rede"; FC2novo; FC2recap; FC2micro
CLOSE #1
ARQUIVO$ = CALC$ + "CALIB2.DAT"
OPEN ARQUIVO$ FOR OUTPUT AS #1
WRITE #1, FC2novo
WRITE #1, FC2recap
WRITE #1, FC2micro
CLOSE #1
 
ARQUIVO$ = CALC$ + "IDS.OUT"
OPEN ARQUIVO$ FOR INPUT AS #14

VRmed = 0!
ARQUIVO$ = CALC$ + "ESTSTHS.DAT"
OPEN ARQUIVO$ FOR INPUT AS #12
ARQUIVO$ = CALC$ + "ESTSTHS0.DAT"
OPEN ARQUIVO$ FOR OUTPUT AS #13

IF Icalibra = 0 THEN
    ARQUIVO$ = CALC$ + "ESTSTHS.OUT"
    OPEN ARQUIVO$ FOR INPUT AS #10
END IF

ISTH = 0
FOR IRodov = 1 TO NRODOV

    ARQUIVO$ = CALC$ + "INT" + Rodov$(IRodov) + ".CSV"
    OPEN ARQUIVO$ FOR INPUT AS #11
    LINE INPUT #11, LINHA$

    FOR ISUB = 1 TO NSTHRODOV(IRodov)

        ISTH = ISTH + 1

        INPUT #11, STH, UltRest$(1), UltRest$(2), UltRest$(3), UltRest$(4)

        INPUT #12, STH, NFaixas, KMI, KMF, FatorVDM, FatorTraf
        FOR IFX = 1 TO NFaixas
            INPUT #12, H1REV(IFX), HrecExist(IFX), Idade(IFX), SN(IFX), CBRSL(IFX), QImed(IFX), NANO(IFX), IRI0(IFX), ALFA(IFX), ALFAnew(IFX)
            INPUT #12, Nacum(IFX), REVEST$(IFX), CamBase$(IFX), ALFAIGG(IFX), VDMc(IFX), VDMUni(IFX)
            INPUT #12, PSIat(ISTH, IFX), Aream2(ISTH, IFX), VidaRes(IFX), PSInovo(IFX), Icalib(IFX), IRest(IFX), D0(IFX), MRfound(IFX)
            INPUT #12, ALPHA0(IFX), ALPHA(IFX), ALPHA2(IFX), AreaAcost(IFX), PSIacost(IFX), DegrauAcost(IFX), T0(IFX), TR23(IFX), ATRmed(IFX)
        NEXT IFX

        IF Icalibra = 0 THEN
            INPUT #10, STH, NFaixas, KMI, KMF, A, A
            FOR IFX = 1 TO NFaixas
                INPUT #10, A, A, A, A, A, A, A, A, ALFA(IFX), ALFAnew(IFX)
                LINE INPUT #10, LINHA$
                INPUT #10, A, A, A, PSInovo(IFX), Icalib(IFX), IRest(IFX), A, A
                LINE INPUT #10, LINHA$
            NEXT IFX
        END IF

        FOR IFaixa = 1 TO NFaixas

            IF Icalib(IFaixa) = 0 THEN
                IF Icalibra = 2 THEN
                    FC0hr = FC0defRecap
                    FC1hr = FCdefRecap
                    FC2hr = FC2defRecap
                    IF IRest(IFaixa) = 1 THEN
                        IF REVEST$(IFaixa) = "CBUQ" THEN
                            ALPHA(IFaixa) = FCdefRecap
                            ALPHA0(IFaixa) = FC0defRecap
                            ALPHA2(IFaixa) = FC2defRecap
                        ELSE
                            ALPHA(IFaixa) = FCdefMicro
                            ALPHA0(IFaixa) = FC0defMicro
                            ALPHA2(IFaixa) = FC2defMicro
                        END IF
                    ELSE
                        ALPHA(IFaixa) = FCdefCA
                        ALPHA0(IFaixa) = FC0defCA
                        ALPHA2(IFaixa) = FC2defCA
                    END IF
                ELSE
                    FC0hr = FC0recaprede(IRodov)
                    FC1hr = FCrecaprede(IRodov)
                    FC2hr = FC2recaprede(IRodov)
                    IF IRest(IFaixa) = 0 THEN
                        ALPHA(IFaixa) = FCnovorede(IRodov)
                        ALPHA0(IFaixa) = FC0novorede(IRodov)
                        ALPHA2(IFaixa) = FC2novorede(IRodov)
                    ELSE
                        IF REVEST$(IFaixa) = "CBUQ" THEN
                            ALPHA(IFaixa) = FCrecaprede(IRodov)
                            ALPHA0(IFaixa) = FC0recaprede(IRodov)
                            ALPHA2(IFaixa) = FC2recaprede(IRodov)
                        ELSE
                            ALPHA(IFaixa) = FCmicrorede(IRodov)
                            ALPHA0(IFaixa) = FC0microrede(IRodov)
                            ALPHA2(IFaixa) = FC2microrede(IRodov)
                        END IF
                    END IF
                END IF
            ELSE
                IF IRest(IFaixa) = 0 THEN
                    FC0hr = FC0recaprede(IRodov)
                    FC1hr = FCrecaprede(IRodov)
                    FC2hr = FC2recaprede(IRodov)
                ELSE
                    FC0hr = ALPHA0(IFaixa)
                    FC1hr = ALPHA(IFaixa)
                    FC2hr = ALPHA2(IFaixa)
                END IF
            END IF
            TYcr2 = T0(IFaixa)

            ' Estimativa da Vida Restante
            Nyear = NANO(IFaixa) / 1000000!
            Age = Idade(IFaixa)
            QI = QImed(IFaixa)
            TR = TR23(IFaixa)
            GOSUB 6000
            VidaRes(IFaixa) = VR
            VRmed = VRmed + VR * Aream2(ISTH, IFaixa)
            ' Espessura efetiva de reforco existente
            PSI = PSIat(ISTH, IFaixa)
            Nyear = NANO(IFaixa)
            GOSUB 1700

        NEXT IFaixa

        WRITE #13, STH, NFaixas, KMI, KMF, FatorVDM, FatorTraf
        FOR IFX = 1 TO NFaixas
            WRITE #13, IFX, H1REV(IFX), HrecExist(IFX), Idade(IFX), SN(IFX), QImed(IFX), NANO(IFX), IRI0(IFX), Nacum(IFX), REVEST$(IFX), ALFAIGG(IFX)
            WRITE #13, PSIat(ISTH, IFX), Aream2(ISTH, IFX), VidaRes(IFX), VDMUni(IFX), PSInovo(IFX), Heff(IFX), IRest(IFX), Icalib(IFX), D0(IFX), MRfound(IFX)
            WRITE #13, ALPHA0(IFX), ALPHA(IFX), ALPHA2(IFX), AreaAcost(IFX), PSIacost(IFX), DegrauAcost(IFX), T0(IFX), TR23(IFX), CBRSL(IFX), CamBase$(IFX), VDMc(IFX), ATRmed(IFX)
        NEXT IFX

        ' Indice de Defeitos de Superficie
        INPUT #14, ISTHH, IGG(1), IGG(2), IGG(3), IGG(4), TR23(1), TR23(2), TR23(3), TR23(4), TR3(1), TR3(2), TR3(3), TR3(4)

        ARQUIVO$ = CALC$ + "Nec" + Rodov$(IRodov) + ".CSV"
        OPEN ARQUIVO$ FOR APPEND AS #15
        I = ISTH
        FOR J = 1 TO NFaixas
            QI(J) = QImed(J)
            VI(J) = VidaRes(J)
        NEXT J
        FOR J = (NFaixas + 1) TO NFaixasMax
            D0(J) = -1
            PSIat(I, J) = -1
            VI(J) = -1
            IGG(J) = -1
            Idade(J) = -1
            QI(J) = -1
        NEXT J
        temp$ = "&, ###.###, ###.###, ##.##, ###.#, ###.#, ###.#, ####.#, ####.#, ##.##, ###.#, ###.#, ###.#, ####.#, ####.#, ##.##, ###.#, ###.#, ###.#, ####.#, ####.#, ##.##, ###.#, ###.#, ###.#, ####.#, ####.#"
        PRINT #15, USING temp$; STR$(STH); KMI; KMF; PSIat(I, 1); VI(1); IGG(1); Idade(1); D0(1); QI(1); PSIat(I, 2); VI(2); IGG(2); Idade(2); D0(2); QI(2); PSIat(I, 3); VI(3); IGG(3); Idade(3); D0(3); QI(3); PSIat(I, 4); VI(4); IGG(4); Idade(4); D0(4); QI(4)
        CLOSE #15

    NEXT ISUB
    CLOSE #11

NEXT IRodov
INPUT #12, PSImed, NPSI
INPUT #12, AreaTotal, NUnidAnalise
VRmed = VRmed / AreaTotal
WRITE #13, PSImed, NPSI, VRmed
WRITE #13, AreaTotal, NUnidAnalise

IF Icalibra = 0 THEN
    INPUT #10, PSImed, NPSI
    INPUT #10, AreaTotal, NUnidAnalise
    CLOSE #10
END IF
CLOSE #12, #13, #14
  
IF IDepura = 0 THEN
    ARQUIVO$ = CALC$ + "DEPURA.DAT"
    OPEN ARQUIVO$ FOR APPEND AS #15
    WRITE #15, "Nenhuma mensagem de erro foi gerada."
    CLOSE #15
END IF

IF Ncasos > 0 THEN ICONTcalibra = 100 * ICONTcalibra / Ncasos
ARQUIVO$ = CALC$ + "PerctCal.OUT"
OPEN ARQUIVO$ FOR OUTPUT AS #1
WRITE #1, ICONTcalibra
CLOSE #1

IF Ncasos0 > 0 THEN ICONT0calibra = 100 * ICONT0calibra / Ncasos0
ARQUIVO$ = CALC$ + "PerctCa0.OUT"
OPEN ARQUIVO$ FOR OUTPUT AS #1
WRITE #1, ICONT0calibra
CLOSE #1

IF Ncasos2 > 0 THEN ICONT2calibra = 100 * ICONT2calibra / Ncasos2
ARQUIVO$ = CALC$ + "PerctCa2.OUT"
OPEN ARQUIVO$ FOR OUTPUT AS #1
WRITE #1, ICONT2calibra
CLOSE #1

SYSTEM

10 '
PRINT "ERRO: categoria de veiculo nao identificada no pedagio ", Pedagio$
BEEP
RETURN

'
20 ' Corrige a deflexao maxima para 21,1oC
'
IF H1REV(IFX) < 3.5 THEN
    X1 = 110
    X2 = -32
    Y1 = 65
    Y2 = -17
ELSE
    IF H1REV(IFX) <= 7.5 THEN
        X1 = 110
        X2 = -35
        Y1 = 60
        Y2 = -17
    ELSE
        X1 = 110
        X2 = -38
        Y1 = 55
        Y2 = -17
    END IF
END IF
IF Tsup(IFX) > 75 THEN Tsup(IFX) = 75
IF Tar > 45 THEN Tar = 45
X = Tsup(IFX) + Tar
Tpav = ((X2 * Y1 - X1 * Y2) - X * (Y1 - Y2)) / (X2 - X1)
Fd = -.00002 * (Tpav ^ 3) + .0019 * (Tpav ^ 2) - .0597 * Tpav + 1.6028
RETURN

30 '
SELECT CASE IFX
    CASE 1: Faixa$ = "1"
    CASE 2: Faixa$ = "2"
    CASE 3: Faixa$ = "3"
    CASE 4: Faixa$ = "4"
    CASE ELSE
        Mesg$ = "ERRO: faixa de trafego nao identificada em " + Rodov$(IRodov)
        GOSUB 500
END SELECT
RETURN

50 '
SELECT CASE Mes$
    CASE "JAN": MONTH = .5
    CASE "FEV": MONTH = 1.5
    CASE "MAR": MONTH = 2.5
    CASE "ABR": MONTH = 3.5
    CASE "MAI": MONTH = 4.5
    CASE "JUN": MONTH = 5.5
    CASE "JUL": MONTH = 6.5
    CASE "AGO": MONTH = 7.5
    CASE "SET": MONTH = 8.5
    CASE "OUT": MONTH = 9.5
    CASE "NOV": MONTH = 10.5
    CASE "DEZ": MONTH = 11.5
    CASE ELSE: MONTH = 6
END SELECT
MONTH = MONTH / 12
RETURN

70 '
' - - - - - - - - - - - - -
' -  Pavimento na Fase 2  -
' -      (Subrotina)      -
' - - - - - - - - - - - - -
DeltaN = .1 * NANO(IFaixa) / 1000000!
NPASSOS = 100
Fcc2 = FC2min
PASSO = (FC2max - FC2min) / (NPASSOS - 1)
ERROMIN = 1E+30
FOR IPASSO = 1 TO NPASSOS
    ALFAG = Fcc2 * ALFAA
    Nac = Nf / 1000000!
    PSIatual = PSIcrt
    WHILE (Nac < NE4 AND PSIatual > 0)
        DeltaPSI = ALFAG * DeltaN * PSIatual * LOG(PSIatual / 5)
        PSIatual = PSIatual + DeltaPSI
        Nac = Nac + DeltaN
    WEND
    ERRO = 100 * ABS(PSIatual - PSI) / PSI
    IF ERRO < ERROMIN THEN
        Fc2 = Fcc2
        ERROMIN = ERRO
    END IF
    Fcc2 = Fcc2 + PASSO
NEXT IPASSO
GOSUB 300
Ncasos2 = Ncasos2 + 1
RETURN

100 '
IF (REVEST$(IFaixa) <> "CCP" AND Fc > FCmin AND Fc < FCmax) THEN
    ICONTcalibra = ICONTcalibra + 1
    Icalib(IFaixa) = 1
    IF IRest(IFaixa) = 1 THEN
        IF REVEST$(IFaixa) = "CBUQ" THEN
            FCrecap = FCrecap + Fc
            ICONTrecap = ICONTrecap + 1
            FCrecaprede(IRodov) = FCrecaprede(IRodov) + Fc
            ICONTovl = ICONTovl + 1
        ELSE
            FCmicro = FCmicro + Fc
            ICONTmicro = ICONTmicro + 1
            FCmicrorede(IRodov) = FCmicrorede(IRodov) + Fc
            ICONTmca = ICONTmca + 1
        END IF
    ELSE
        FCnovo = FCnovo + Fc
        ICONTnovo = ICONTnovo + 1
        FCnovorede(IRodov) = FCnovorede(IRodov) + Fc
        ICONTnew = ICONTnew + 1
    END IF
    ALPHA(IFaixa) = Fc
    ARQUIVO$ = CALC$ + "RELCALIB.DAT"
    OPEN ARQUIVO$ FOR APPEND AS #15
    WRITE #15, ISTH, IFaixa, IRest(IFaixa), REVEST$(IFaixa), 1, Fc
    CLOSE #15
END IF
RETURN

200 '
IF (Fc0 > FC0min AND Fc0 < FC0max) THEN
    ICONT0calibra = ICONT0calibra + 1
    IF IRest(IFaixa) = 1 THEN
        IF REVEST$(IFaixa) = "CBUQ" THEN
            FC0recap = FC0recap + Fc0
            ICONT0recap = ICONT0recap + 1
            FC0recaprede(IRodov) = FC0recaprede(IRodov) + Fc0
            ICONT0ovl = ICONT0ovl + 1
        ELSE
            FC0micro = FC0micro + Fc0
            ICONT0micro = ICONT0micro + 1
            FC0microrede(IRodov) = FC0microrede(IRodov) + Fc0
            ICONT0mca = ICONT0mca + 1
        END IF
    ELSE
        FC0novo = FC0novo + Fc0
        ICONT0novo = ICONT0novo + 1
        FC0novorede(IRodov) = FC0novorede(IRodov) + Fc0
        ICONT0new = ICONT0new + 1
    END IF
    ALPHA0(IFaixa) = Fc0
    ARQUIVO$ = CALC$ + "RELCALIB.DAT"
    OPEN ARQUIVO$ FOR APPEND AS #15
    WRITE #15, ISTH, IFaixa, IRest(IFaixa), REVEST$(IFaixa), 0, Fc0
    CLOSE #15
END IF
RETURN

300 '
IF (Fc2 > FC2min AND Fc2 < FC2max) THEN
    ICONT2calibra = ICONT2calibra + 1
    IF IRest(IFaixa) = 1 THEN
        IF REVEST$(IFaixa) = "CBUQ" THEN
            FC2recap = FC2recap + Fc2
            ICONT2recap = ICONT2recap + 1
            FC2recaprede(IRodov) = FC2recaprede(IRodov) + Fc2
            ICONT2ovl = ICONT2ovl + 1
        ELSE
            FC2micro = FC2micro + Fc2
            ICONT2micro = ICONT2micro + 1
            FC2microrede(IRodov) = FC2microrede(IRodov) + Fc2
            ICONT2mca = ICONT2mca + 1
        END IF
    ELSE
        FC2novo = FC2novo + Fc2
        ICONT2novo = ICONT2novo + 1
        FC2novorede(IRodov) = FC2novorede(IRodov) + Fc2
        ICONT2new = ICONT2new + 1
    END IF
    ALPHA2(IFaixa) = Fc2
    ARQUIVO$ = CALC$ + "RELCALIB.DAT"
    OPEN ARQUIVO$ FOR APPEND AS #15
    WRITE #15, ISTH, IFaixa, IRest(IFaixa), REVEST$(IFaixa), 2, Fc2
    CLOSE #15
END IF
RETURN


500 '
' - - - - - - - - - - - - - -
' -   Depuracao dos Dados   -
' -       (Subrotina)       -
' - - - - - - - - - - - - - -
ARQUIVO$ = CALC$ + "DEPURA.DAT"
OPEN ARQUIVO$ FOR APPEND AS #17
IDepura = IDepura + 1
WRITE #17, Mesg$
CLOSE #17
RETURN


1700 '
' - - - - - - - - - - - - - - - - - - - - - - - - -
' -     Espessura de reforco efetiva existente    -
' -                  (Subrotina)                  -
' - - - - - - - - - - - - - - - - - - - - - - - - -
A1 = .44
IF VR > 0 THEN
    IPER = INT(VR)
    NANO = Nyear / 1000000!
    IF VR > 1 THEN
        NPA = NANO
        FOR IVR = 2 TO IPER
            NANO = NANO * (1 + (FatorTraf / 100))
            NPA = NPA + NANO
        NEXT IVR
        NPA = NPA + NANO * (VR - IPER)
    ELSE
        NPA = NANO * VR
    END IF
    SNP = A1 * .5 / 2.54
    NP = 0
    WHILE NP < NPA
        SNP = SNP + .01
        HRmodel = 2.54 * SNP / A1
        IF QI > 19 THEN
            QId = 19 + ((QI - 19) / (.602 * HRmodel + 1))
        ELSE
            QId = QI
        END IF
        PSIQI = 5 * EXP(-QId / 71.5)
        PSR = 5
        PSI0 = (PSIQI + PSR) / 2
        IF PSI0 > 4.95 THEN PSI0 = 4.95
        DPSI = PSI0 - 2.5
        IF DPSI > 0 THEN
            B = 30
            P = QREF / (PI# * B * B / 4)
            E = 2 * (1 - .33 * .33) * P * (B / 2) / (D0(IFaixa) / 1000)
            MR = E / .0703
            BETA = .4 + (1094 / ((SNP + 1) ^ 5.19))
            W18 = (((SNP + 1) / 1.05) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
            W18 = W18 * ((MR / 3000) ^ 2.32) / 1000000!
            ALFAA = (1 / W18) * LOG(LOG(2.5 / 5) / LOG(PSI0 / 5))
            PSIx = PSI0
            DeltaT = .1
            DeltaN = DeltaT * NANO
            PCR4 = 5
            TYcr2A = 2.54 * EXP(.0157 * HRmodel * 10 - .0141 * PCR4)
            TYcr2B = 10.8 * EXP(-1.21 * (D0(IFaixa) / 100) - 1.02 * NANO * (D0(IFaixa) / 100))
            TYcr2 = (1 * TYcr2A + 1.5 * TYcr2B) / (1 + 1.5)
            Nf = TYcr2 * FC0hr * NANO
            NP = 0
            VRmax = 64.43 * (5 ^ -.76) * ((HRmodel / 2.54) ^ .37)
            VRmin = 64.43 * (25 ^ -.76) * ((HRmodel / 2.54) ^ .37)
            dPSIdtmin = 2! / VRmax
            dPSIdtmax = 2! / VRmin
            DPSImin = dPSIdtmin * DeltaT
            DPSImax = dPSIdtmax * DeltaT
            WHILE PSIx > PSIf
                NP = NP + DeltaN
                IF NP < Nf THEN
                    Fc = FC1hr
                ELSE
                    Fc = FC2hr
                END IF
                ALFA = ALFAA * Fc
                DeltaPSI = ALFA * DeltaN * PSIx * LOG(PSIx / 5)
                IF ABS(DeltaPSI) > DPSImax THEN DeltaPSI = -DPSImax
                IF ABS(DeltaPSI) < DPSImin THEN DeltaPSI = -DPSImin
                PSIx = PSIx + DeltaPSI
            WEND
        END IF
    WEND
    Heff(IFaixa) = HRmodel
ELSE
    Heff(IFaixa) = 0
END IF
RETURN


6000 '
' - - - - - - - - - - - - - - - - - - - - - - - - - -
' -      Calculo da Vida Residual do Pavimento      -
' -                   (Subrotina)                   -
' -  Dados: PSI, PSIf, ALPHA, NYEAR, Age, QI, TYcr2 -
' -  Saida: VR                                      -
' - - - - - - - - - - - - - - - - - - - - - - - - - -
VR = 0
IF Age < 0 THEN
    Nac = 0
    TTIME = 0
ELSE
    Nac = Age * NANO(IFaixa)
    TTIME = Idade(IFaixa)
END IF
Nf = TYcr2 * ALPHA0(IFaixa) * NANO(IFaixa)
DeltaT = .1
NE4 = Nac / 1000000!
IF (REVEST$(IFaixa) = "CBUQ" OR REVEST$(IFaixa) = "CBUQAB" OR REVEST$(IFaixa) = "CBUQPOL") THEN
    FatorHR = 1
    IF REVEST$(IFaixa) = "CBUQAB" THEN FatorHR = 0.7
    IF REVEST$(IFaixa) = "CBUQPOL" THEN FatorHR = 0.6
    IF IRest(IFaixa) = 0 THEN
        FcIRImed = 1: SigmaIRI = .48
        RH = 0
        VRmax = 30
        VRmin = 5
        FcATRmed = 1.3492: SigmaATR = .5612
        SELECT CASE CamBase$(IFaixa)
            CASE "BGTC", "SOLO-CIMENTO", "SOLO-CAL", "CCP"
                V1 = 8.7: V2 = 12.5
            CASE ELSE
                V1 = 6.3: V2 = 8.7
        END SELECT
    ELSE
        FcIRImed = 1.883: SigmaIRI = 1.905
        RH = 1
        VRmax = 64.43 * (5 ^ -.76) * (((HrecExist(IFaixa) / FatorHR) / 2.54) ^ .37) * (300000! / NANO(IFaixa))
        VRmin = 64.43 * (25 ^ -.76) * (((HrecExist(IFaixa) / FatorHR) / 2.54) ^ .37) * (300000! / NANO(IFaixa))
        IF REVEST$(IFaixa) = "CBUQ" THEN
            V1 = 5: V2 = 7.6
            FcATRmed = 1.2464: SigmaATR = .8204
        ELSE
            IF TR > 0 THEN V1 = TR / TYcr2 ELSE V1 = 5
            V2 = (31 / 10.2) * V1
            FcATRmed = 1.8168: SigmaATR = .8717
        END IF
    END IF
ELSE
    RH = 0
    IF REVEST$(IFaixa) = "CCP" THEN
        VRmax = 50
        VRmin = 10
    ELSE
        VRmax = 10
        VRmin = 2
        FcATRmed = 1.3492: SigmaATR = .5612
        SELECT CASE CamBase$(IFaixa)
            CASE "BGTC", "SOLO-CIMENTO", "SOLO-CAL", "CCP"
                V1 = 8.7: V2 = 12.5
            CASE ELSE
                V1 = 6.3: V2 = 8.7
        END SELECT
    END IF
END IF
dPSIdtmin = 2! / VRmax
dPSIdtmax = 2! / VRmin
DPSImin = dPSIdtmin * DeltaT
DPSImax = dPSIdtmax * DeltaT
PSIatual = PSIat(ISTH, IFaixa)
IF PSIatual <= 4.5 THEN
    IGG = ALFAIGG(IFaixa) * ((((4.5 / PSIatual) - 1) / .007635) ^ (1 / 1.065))
ELSE
    IGG = 0
END IF
ATR = ATRmed(IFaixa)
IF (Idade(IFaixa) > 20 AND ATR > 12) THEN COMP = .7 ELSE COMP = 1
LCBR = LOG(CBRSL(IFaixa)) / LOG(10)
SNC = SN(IFaixa) + 3.51 * LCBR - .85 * (LCBR ^ 2) - 1.43
PSIQI = 5! * EXP(-QI / 71.5)
PSR = 2 * PSIatual - PSIQI
DeltaTR = 0
WHILE (QI < QIcrit AND ATR < ATRcrit AND IGG < IGGcrit)
    ' Evolucao do PSI
    VR = VR + DeltaT
    DeltaN = DeltaT * Nyear * (FatorTraf ^ VR)
    Nac = Nac + DeltaT * NANO(IFaixa)
    IF TR < TRmin THEN
        ALFAG = ALFA(IFaixa) * ALPHA(IFaixa)
    ELSE
        ALFAG = ALFA(IFaixa) * ALPHA2(IFaixa)
    END IF
    'DeltaPSI = (ALFAG / 10 ^ (-ZRmpd * S0mpd)) * DeltaN * PSIatual * LOG(PSIatual / 5)
    'IF ABS(DeltaPSI) > DPSImax THEN DeltaPSI = -DPSImax
    'IF ABS(DeltaPSI) < DPSImin THEN DeltaPSI = -DPSImin
    IF REVEST$(IFaixa) = "CCP" THEN
        ' Dados
        Epsi = 100 * CBRSL(IFaixa) / 0.0703
        K = Epsi / 19.4
        RTF = 640
        Dcm = H1REV(IFaixa)
        D = Dcm / 2.54
        PT = 2.5
        J = 3.2
        CD = 1
        PSI0 = 4.5
        ' Correlacoes
        RTFMPA = RTF * .0703 / 10
        RCS = 10 * ((RTFMPA / .56) ^ 1.67)
        EC = 15110 * (RCS ^ .5)
        EC = EC / .0703
        ' Parametros complementares
        DPSI = PSI0 - PT
        ZR = ZRmpd
        S0 = S0mpd
        ' Modelo
        W18 = 215.63 * J * ((D ^ .75) - (18.42 / ((EC / K) ^ .25)))
        W18 = (4.22 - .32 * PT) * LOG(RTF * CD * ((D ^ .75) - 1.132) / W18) / LOG(10)
        A# = (LOG(DPSI / (4.5 - 1.5)) / LOG(10)) / (1 + (1.624E+07 / ((D + 1) ^ 8.46)))
        W18 = W18 + A# - .06 + 7.35 * (LOG(D + 1) / LOG(10)) + ZR * S0
        W18 = (10 ^ W18) / 1.E6
        ALFAA = (1 / W18) * LOG(LOG(PT / 5) / LOG(PSI0 / 5))
        FcCCP = 0.3
        ALFA = FcCCP * ALFAA
        DeltaPSI = ALFA * DeltaN * PSIatual * LOG(PSIatual / 5)
        PSIold = PSIatual
        PSIatual = PSIatual + DeltaPSI
        DeltaQI = -71.5 * DeltaPSI / ((PSIatual + PSIold) / 2)
        QI = QI + DeltaQI
    ELSE
        ' - - - - - - - - - - - - - - - - - - - - -
        ' - Modelo AASHTO-HDM para irregularidade -
        ' - - - - - - - - - - - - - - - - - - - - -
        IF DEFPSI = 0 THEN
            PSI0ah = 2 * PSInovo(IFaixa) - 5
            IF PSI0ah < 2.55 THEN PSI0ah = 2.55
        ELSE
            PSI0ah = PSInovo(IFaixa)
        END IF
        DPSI = PSI0ah - 2.5
        IF DPSI <= 0.5 THEN DPSI = 0.5
        PSIah = 5 * EXP(-QI / 71.5)
        IF PSIah < 0.5 THEN PSIah = 0.5
        IF IRec(IFaixa) = 0 THEN
            DPSI = PSI0ah - 2.5
            ' Analise do subleito
            MR = 100 * CBRSL(IFaixa) / .0703
            SNP = SN(IFaixa)
            BETA = .4 + (1094 / ((SNP + 1) ^ 5.19))
            W18 = (((SNP + 1) / 1.0512) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
            W18 = 10 ^ (-ZRmpd * S0mpd) * W18 * ((MR / 3000) ^ 2.32) / 1000000!
            ALFAah = FcPavNovoPSISL * (1 / W18) * LOG(LOG(2.5 / 5) / LOG(PSI0ah / 5))
            ' Analise da camada de base
            SELECT CASE CamBase$(IFaixa)
                CASE "BGTC"
                    CBRbase = 580
                CASE "SOLO-CIMENTO", "SOLO-CAL", "SC"
                    CBRbase = 300
                CASE "CCP", "CCR"
                    CBRbase = 1250
                CASE "MB", "PMF", "PMQ", "CBUQ", "CBUQ+PMQ", "CBUQ+PMF"
                    CBRbase = 250
                CASE ELSE
                    CBRbase = 80
            END SELECT
            MR = 20 * CBRbase / .0703
            SNP = 0.44 * (H1REV(IFaixa) / FatorHR) / 2.54
            BETA = .4 + (1094 / ((SNP + 1) ^ 5.19))
            W18 = (((SNP + 1) / 1.0512) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
            W18 = 10 ^ (-ZRmpd * S0mpd) * W18 * ((MR / 3000) ^ 2.32) / 1000000!
            ALFAahbs = FcPavNovoPSIBS * (1 / W18) * LOG(LOG(2.5 / 5) / LOG(PSI0ah / 5))
            IF ALFAahbs > ALFAah THEN ALFAah = ALFAahbs
        ELSE
            MR = MRfound(IFaixa) / .0703
            SNP = CfRecapPSI * 0.44 * (HrecExist(IFaixa) / FatorHR) / 2.54
            BETA = .4 + (1094 / ((SNP + 1) ^ 5.19))
            DPSI = PSI0ah - 2.5
            W18 = (((SNP + 1) / 1.0512) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
            W18 = 10 ^ (-ZRmpd * S0mpd) * W18 * ((MR / 3000) ^ 2.32) / 1000000!
            ALFAah = FcPavNovoPSIBS * (1 / W18) * LOG(LOG(2.5 / 5) / LOG(PSI0ah / 5))
        END IF
        DeltaPSI = ALFAah * DeltaT * Nyear * PSIah * LOG(PSIah / 5)
        DeltaQI = (-71.5 / PSIah) * DeltaPSI
        QI = QI + DeltaQI
        ' - - - - - - - - - - -
        ' -  Evolucao do IGG  -
        ' - - - - - - - - - - -
        SCI = (309.22 - .616 * IGG) / (61.844 + IGG)
        SCI0 = 4.97
        DPSI = SCI0 - 2.5
        IF IRec(IFaixa) = 0 THEN
            ' Analise do subleito
            MR = 100 * CBRSL(IFaixa) / .0703
            SNP = SN(IFaixa)
            BETA = .4 + (1094 / ((SNP + 1) ^ 5.19))
            W18 = (((SNP + 1) / 1.0512) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
            W18 = 10 ^ (-ZRmpd * S0mpd) * W18 * ((MR / 3000) ^ 2.32) / 1000000!
            ALFAah = FcPavNovoSCISL * (1 / W18) * LOG(LOG(2.5 / 5) / LOG(SCI0 / 5))
            ' Analise da camada de base
            SELECT CASE CamBase$(IFaixa)
                CASE "BGTC", "SOLO-CIMENTO", "SOLO-CAL", "CCP", "SC", "CCR"
                CASE "MB", "PMF", "PMQ", "CBUQ", "CBUQ+PMQ", "CBUQ+PMF"
                CASE ELSE
                    CBRbase = 80
                    MR = 20 * CBRbase / .0703
                    SNP = 0.44 * (H1REV(IFaixa) / FatorHR) / 2.54
                    BETA = .4 + (1094 / ((SNP + 1) ^ 5.19))
                    W18 = (((SNP + 1) / 1.0512) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
                    W18 = 10 ^ (-ZRmpd * S0mpd) * W18 * ((MR / 3000) ^ 2.32) / 1000000!
                    ALFAahbs = FcPavNovoSCIBS * (1 / W18) * LOG(LOG(2.5 / 5) / LOG(SCI0 / 5))
                    IF ALFAahbs > ALFAah THEN ALFAah = ALFAahbs
            END SELECT
        ELSE
            ALFAah = (10 ^ (ZRmpd * S0mpd)) * LOG(10.676 / T0(IFaixa)) / (1.222E-6 * NANO(IFaixa))
        END IF
        DeltaSCI = ALFAah * DeltaT * Nyear * SCI * LOG(SCI / 5)
        DeltaIGG = DeltaSCI * (-61.844 - IGGest) / (.616 + SCI)
        ' Evolucao do trincamento severo
        IF TTIME <= TYcr2 THEN
            DeltaTR = 0
        ELSE
            IF TR > 0 THEN
                IF TR > 30 THEN dTRdt = V2 ELSE dTRdt = V1
                DeltaTR = dTRdt * DeltaT
            ELSE
                DeltaTR = V1 * DeltaT
            END IF
        END IF
        TR = TR + DeltaTR
        IF TR > 100 THEN TR = 100
        IGItr = DeltaTR * .65
        ' Evolucao dos afundamentos em trilha de roda
        MMP = .123
        FcATR = FcATRmed + Ngauss * SigmaATR
        NE4 = NE4 + DeltaT * Nyear
        ERM = .0902 + .0384 * (D0(IFaixa) / 100) - .009 * RH + .00158 * MMP * TR
        dATR = (.166 * FcATR * (COMP ^ -2.3) * (TTIME ^ (.166 - 1)) * (SNC ^ -.502) * (Nac ^ ERM) + ERM * ATR * (Nyear / NE4)) * DeltaT
        ATR = ATR + dATR
        IGIatr = (4 / 3) * dATR
    END IF
    ' Evolucao do IGG e do PSR
    PSIQI = 5! * EXP(-QI / 71.5)
    PSRat = 2 * PSIatual - PSIQI
    DeltaPSR = PSRat - PSR
    DeltaIGG = (DeltaIGG + (IGIatr + IGItr)) / 2
    IGG = IGG + DeltaIGG
    PSR = PSRat
    PSIatual = (PSR + PSIQI) / 2
WEND
IF VR = DeltaT THEN VR = 0
IF (Age > 0 AND Age < VRmax) THEN VRmax = VRmax - Age
IF VR > VRmax THEN VR = VRmax

RETURN


6800 '
' - - - - - - - - - - - - - - - - - - - - - - - - -
' -  Modulo de Elasticidade da Camada Subjacente  -
' -                  (Subrotina)                  -
' - - - - - - - - - - - - - - - - - - - - - - - - -
B = 15
P = QREF / (PI# * B * B)
'DCantigo = D0(IFaixa) * 10 ^ (HrecExist(IFaixa) / 40)
'E = 2 * (1 - .35 * .35) * P * B / (DCantigo / 1000)
EP = 30000
ERROABS = 100
MR = 1000
WHILE ERROABS > 1!
    Delta = 1 + ((HrecExist(IFaixa) / B) * ((EP / MR) ^ (1 / 3))) ^ 2
    Delta = 1 / (MR * (Delta ^ (1 / 2)))
    BLOC = (1 - (1 / ((1 + ((HrecExist(IFaixa) / B) ^ 2)) ^ .5))) / EP
    Delta = 1.5 * P * B * (Delta + BLOC)
    Delta = 1000 * Delta
    ERRO = (Delta - D0(IFaixa)) / D0(IFaixa)
    Fator = 1 + .3 * ERRO
    MR = MR * Fator
    ERROABS = 100 * ABS(ERRO)
WEND
E = MR
RETURN

