CLS

PRINT
PRINT "    VIDA RESTANTE DOS PAVIMENTOS   "
PRINT

PI# = 3.141592654#
NFaixasMax = 4
DIM DF(9), D(9), FX(NFaixasMax), ESLest(9), Dx(9)
' Funcao densidade de probabilidade para Fc
DIM Nc(4), NQI(4), NS(4)
Nc(1) = 50: NS(1) = 0: NQI(1) = 0
Nc(2) = 85: NS(2) = 1.04: NQI(2) = 1.08
Nc(3) = 90: NS(3) = 1.29: NQI(3) = 1.6038
Nc(4) = 95: NS(4) = 1.65: NQI(4) = 2.35

' Carga de referencia para a conversao das deflexoes do FWD
LOAD = 4100
Dplaca = 30
Raio = Dplaca / 2
Pressao = LOAD / (PI# * (Raio ^ 2))
NPONTOS = 7

' Subdiretorios onde se encontram o programa SGP e a base de dados:
OPEN "DIRETOR.DAT" FOR INPUT AS #1
INPUT #1, ANOBASE
INPUT #1, NPeriodos
INPUT #1, PROGRAMA$
INPUT #1, DADOS$
INPUT #1, CALC$
INPUT #1, DADOSANOBASE$
CLOSE #1

OPEN "SISTEMA.DAT" FOR INPUT AS #1
INPUT #1, SGP$
CLOSE #1

OPEN "DISCO.DAT" FOR INPUT AS #1
INPUT #1, DISCO$
CLOSE #1

' Codigos de identificacao das rodovias que compoem a rede:
ARQUIVO$ = DADOSANOBASE$ + "RODOVIAS.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NRODOV
DIM Rodovia$(NRODOV), NSTHRODOV(NRODOV)
FOR I = 1 TO NRODOV
    INPUT #1, Rodovia$(I)
NEXT I
CLOSE #1

' Numero de Subtrechos Homogeneos por rodovia:
ARQUIVO$ = CALC$ + "NSTHROD.OUT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NSTHMAX
FOR I = 1 TO NRODOV
    INPUT #1, NSTHRODOV(I)
NEXT I
CLOSE #1

' Criterios complementares para as arvores de decisao
ARQUIVO$ = CALC$ + "CRITERIO.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, TRcrit
INPUT #1, QIcrit
INPUT #1, ATRcrit
INPUT #1, ATRITOcrit
INPUT #1, IGGcrit
CLOSE #1

ARQUIVO$ = CALC$ + "TipoLev.dat"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, TipoLev$
CLOSE #1

ARQ$ = CALC$ + "REF.DAT"
OPEN ARQ$ FOR INPUT AS #1
INPUT #1, TRECHO$
INPUT #1, Faixa
INPUT #1, PP
INPUT #1, Nconf
INPUT #1, TAXA
INPUT #1, PSIt
INPUT #1, GrTraf$
INPUT #1, RestrGreide$
CLOSE #1

SELECT CASE Faixa
    CASE 1: Faixa$ = "1"
    CASE 2: Faixa$ = "2"
    CASE 3: Faixa$ = "3"
    CASE 4: Faixa$ = "4"
    CASE ELSE
        PRINT "ERRO"
END SELECT

' Dados do pavimento dentro dos subtrechos homogeneos

ARQUIVO$ = CALC$ + "VR" + TRECHO$ + Faixa$ + ".CSV"
OPEN ARQUIVO$ FOR OUTPUT AS #1
WRITE #1, "STH", "km", "VR_anos", "D0fwd", "Ep", "Esl", "SN", "SNC", "QI", "VRqi", "ATR", "VRatr", "TR", "VRtr", "IGG", "VRigg", "QI_2024", "IGG_2024", "ATR_2024", "RDS_2024", "TR_2024"

' Analisa cada bacia do FWD

ARQUIVO$ = DADOSANOBASE$ + "DEFLEX\" + TRECHO$ + "_" + Faixa$ + ".CSV"
OPEN ARQUIVO$ FOR INPUT AS #2
LINE INPUT #2, LINHA$
WHILE NOT EOF(2)

    INPUT #2, km, CARGA, DF(1), DF(2), DF(3), DF(4), DF(5), DF(6), DF(7), TAR, TSUP, D(1), D(2), D(3), D(4), D(5), D(6), D(7), Dplaca, DAT$, Equipamento$

    PRINT "km "; km

    Exec$ = "S"
    FOR I = 1 TO 7
        IF DF(I) <= 0 THEN Exec$ = "N"
    NEXT I

    IF Exec$ = "S" THEN

        Qkgf = CARGA
        p0 = Qkgf / (PI# * (Raio ^ 2))

        ARQUIVO$ = CALC$ + "ESTR" + TRECHO$ + Faixa$ + ".CSV"
        OPEN ARQUIVO$ FOR INPUT AS #3
        LINE INPUT #3, LINHA$

        ARQUIVO$ = CALC$ + "CADAS" + TRECHO$ + ".CSV"
        OPEN ARQUIVO$ FOR INPUT AS #4
        LINE INPUT #4, LINHA$

        ARQUIVO$ = DISCO$ + SGP$ + "\Docs\Params\LVC" + TRECHO$ + Faixa$ + ".CSV"
        OPEN ARQUIVO$ FOR INPUT AS #6
        LINE INPUT #6, LINHA$
        LINE INPUT #6, LINHA$

        Hrev = -1
        Hbase = -1
        Hsub = -1
        Href = -1
        Hp = -1
        TipoPista$ = ""
        Rev$ = ""
        NLayers = 0

        Executa$ = "N"
        WHILE NOT EOF(3)

            INPUT #4, STH$, Rodov$, INI$, FIM$, KMI, KMF, PISTA$
            INPUT #4, NFaixas, PLUV, ALTM, PLATAF, LARGPISTA, ACOSTLE, ACOSTLD
            INPUT #4, GEOVERT$, GEOHORIZ$, SECTIPO$, FX(1), FX(2), FX(3), FX(4), DECTRA, RESTR, ExtPontes, OBS$

            INPUT #3, STH$, ANORIG, REVORIG$, MARSHALL, RTDIAMET, VAZIOSAR, TEORASF
            INPUT #3, H1CM, CamBase$, H2CM, CBRBS, RCS28DBASE, SUBBASE$
            INPUT #3, H3CM, CBRSUB, RCS28DSUBB, REFSL$, H4CM, CBRREF
            INPUT #3, SL$, CBRsl, LLSL, IPSL, P200SL, PROFROCHAm

            INPUT #6, KMini, KMfim, IGG, ICPF, IES, TR23, TR2, TR3, TRI, TRE, QI, Dc, PISTA$

            IF KMF > KMI THEN
                IF (km >= KMI AND km <= KMF) THEN
                    Executa$ = "S"
                    Subtrecho$ = STH$
                    TipoPista$ = PISTA$
                    GOSUB 300
                    Idade = ANOBASE - ANORIG
                    IGGatual = IGG
                    IF H1REV > 0 THEN
                        Hrev = H1REV
                        Hbase = H2CM
                        NLayers = 3
                        Hp = H1REV + H2CM
                        IF H3CM > 0 THEN
                            Hp = Hp + H3CM
                            Hsub = H3CM
                            NLayers = 4
                        ELSE
                            Hsub = 0
                        END IF
                        IF H4CM > 0 THEN
                            Hp = Hp + H4CM
                            Href = H4CM
                            NLayers = 5
                        ELSE
                            Href = 0
                        END IF
                        NP = 0
                        FOR I = 1 TO PP
                            Nano = NanoAASHTO * ((1 + (TAXA / 100)) ^ I)
                            NP = NP + Nano
                        NEXT I
                        NanoMed = NP / PP
                    END IF
                    Raio = Dplaca / 2
                END IF
            ELSE
                IF (km <= KMI AND km >= KMF) THEN
                    Executa$ = "S"
                    Subtrecho$ = STH$
                    TipoPista$ = PISTA$
                    GOSUB 300
                    Idade = ANOBASE - ANORIG
                    IGGatual = IGG
                    IF H1REV > 0 THEN
                        Hrev = H1REV
                        Hbase = H2CM
                        NLayers = 3
                        Hp = H1REV + H2CM
                        IF H3CM > 0 THEN
                            Hp = Hp + H3CM
                            Hsub = H3CM
                            NLayers = 4
                        ELSE
                            Hsub = 0
                        END IF
                        IF H4CM > 0 THEN
                            Hp = Hp + H4CM
                            Href = H4CM
                            NLayers = 5
                        ELSE
                            Href = 0
                        END IF
                        NP = 0
                        FOR I = 1 TO PP
                            Nano = NanoAASHTO * ((1 + (TAXA / 100)) ^ I)
                            NP = NP + Nano
                        NEXT I
                        NanoMed = NP / PP
                    END IF
                    Raio = Dplaca / 2
                END IF
            END IF

        WEND
        CLOSE #3, #4, #6
        HT = Hp

        IF Executa$ = "S" THEN

            ' Converte D0 a 70oF e 4100 kgf
            GOSUB 10
            DeflexRef = Fd * DF(1) * (LOAD / CARGA)

            ' Estimativa inicial de Esl
            FOR IP = 3 TO NPONTOS
                II = 0
                IF D(IP) >= 1.5 * HT + Raio THEN
                    II = II + 1
                    ESLest(II) = Qkgf * (1 - 0.4 * 0.4) / (PI# * D(IP) * DF(IP) / 1000)
                END IF
            NEXT IP
            IF II > 0 THEN
                IF II = 1 THEN
                    ESLmax = ESLest(1) * 1.3
                    ESLmin = ESLest(1) / 1.3
                ELSE
                    ESLmax = ESLest(1)
                    ESLmin = ESLest(1)
                    FOR J = 2 TO II
                        IF ESLest(J) > ESLmax THEN ESLmax = ESLest(J)
                        IF ESLest(J) < ESLmin THEN ESLmin = ESLest(J)
                    NEXT J
                END IF
                ESLmax = ESLmax * 1.3
                ESLmin = ESLmin / 1.3
            ELSE
                ESLmax = 500
                ESLmin = 7000
            END IF
            E1min = 10000
            E1max = 100000
            CamBase$ = UCASE$(CamBase$)
            SELECT CASE CamBase$
                CASE "BG", "MH", "SOLO-BRITA"
                    E2min = 1000
                    E2max = 10000
                CASE "GW", "SE", "CASCALHO"
                    E2min = 500
                    E2max = 5000
                CASE "SC", "SOLO-CIMENTO", "BGTC", "CCR"
                    E2min = 5000
                    E2max = 100000
                CASE "BGTC", "CCR"
                    E2min = 10000
                    E2max = 150000
                CASE "CBUQ", "MB", "PMQ", "PMF"
                    E2min = 7000
                    E2max = 100000
                CASE ELSE
                    E2min = 500
                    E2max = 7000
            END SELECT
            IF NLayers = 3 THEN
                EpMin = (Hrev * E1min + Hbase * E2min) / HT
                EpMax = (Hrev * E1max + Hbase * E2max) / HT
            ELSE
                SUBBASE$ = UCASE$(SUBBASE$)
                SELECT CASE SUBBASE$
                    CASE "BG", "MH", "SOLO-BRITA"
                        E3min = 1000
                        E3max = 10000
                    CASE "GW", "SE", "CASCALHO"
                        E3min = 500
                        E3max = 5000
                    CASE "SC", "SOLO-CIMENTO", "BGTC", "CCR"
                        E3min = 5000
                        E3max = 100000
                    CASE "BGTC", "CCR"
                        E3min = 10000
                        E3max = 150000
                    CASE "CBUQ", "MB", "PMQ", "PMF"
                        E3min = 7000
                        E3max = 100000
                    CASE ELSE
                        E3min = 500
                        E3max = 7000
                END SELECT
                EpMin = (Hrev * E1min + Hbase * E2min + Hsub * E3min) / HT
                EpMax = (Hrev * E1max + Hbase * E2max + Hsub * E3max) / HT
            END IF

            ' Retroanalise com o sistema de duas camadas elasticas (Swift)
            AREAref = 0
            FOR IP = 1 TO NPONTOS - 1
                IF IP = 1 THEN Deflex = Fd * DF(1) ELSE Deflex = DF(IP)
                AREAref = AREAref + ((Deflex + DF(IP + 1)) / 2) * (D(IP + 1) - D(IP))
            NEXT IP
            NPassos = 100
            PassoEp = (EpMax - EpMin) / NPassos
            PassoSL = (ESLmax - ESLmin) / NPassos
            ErroMin = 1.0E10
            Ep = EpMin
            FOR IEP = 1 TO NPassos
                Esl = ESLmin
                FOR ISL = 1 TO NPassos
                    FOR IP = 2 TO NPONTOS
                        XX = 2 * HT * (((Ep + 2 * Esl) / (3 * Esl)) ^ (1 / 3))
                        LL = ((D(IP) ^ 2) + (XX ^ 2)) ^ 0.5
                        BLOC = (3 * D(IP) * (XX ^ 4) / (2 * (LL ^ 5))) + (D(IP) * (XX ^ 2) / (2 * (LL ^ 3))) + (D(IP) / LL)
                        BLOC = BLOC * ((1 / Esl) - (1 / Ep)) + (1 / Esl)
                        Dx(IP) = 1000 * BLOC * 3 * Qkgf / (4 * PI# * D(IP))
                    NEXT IP
                    ' Valor de D0 pela formula do Guia da AASHTO (1993)
                    Bloc1 = 1 / (Esl * (1 + ((((Ep / Esl) ^ (1 / 3)) * HT / Raio) ^ 2)) ^ (1 / 2))
                    Bloc2 = (1 - (1 / ((1 + ((HT / Raio) ^ 2)) ^ (1 / 2)))) / Ep
                    Dx(1) = 1000 * 1.5 * p0 * Raio * (Bloc1 + Bloc2)
                    AREA = 0
                    FOR IP = 1 TO NPONTOS - 1
                        AREA = AREA + ((Dx(IP) + Dx(IP + 1)) / 2) * (D(IP + 1) - D(IP))
                    NEXT IP
                    Erro = 100 * ABS(AREA - AREAref) / AREAref
                    IF Erro < ErroMin THEN
                        ErroMin = Erro
                        EpOt = Ep
                        Eslot = Esl
                    END IF
                    Esl = Esl + PassoSL
                NEXT ISL
                Ep = Ep + PassoEp
            NEXT IEP
            IF Eslot > 7000 THEN Eslot = 7000

            Deflex = DF(1) * (LOAD / CARGA)
            DF(1) = Deflex * Fd
            FOR I = 2 TO 7
                DF(I) = (LOAD / CARGA) * DF(I)
            NEXT I

            ' Numero Estrutural Efetivo do pavimento
            X = Raio + 1.5 * HT
            GOSUB 100
            SNrhode = SN
            SNaashto = 0.0045 * (HT / 2.54) * ((EpOt / 0.0703) ^ (1 / 3))
            IF SNrhode > 0 THEN SNef = (SNaashto + SNrhode) / 2 ELSE SNef = SNaashto

            ' Correlacao entre deflexao do FWD e da viga
            Dvbk = DF(1) / 0.74

            CBRsl = Eslot / 130
            LCBR = LOG(CBRsl) / LOG(10)
            SNC = SN + 3.51 * LCBR - .85 * (LCBR ^ 2) - 1.43

            ' Aplica os Modelos para Previsao de Desempenho para o calculo da vida restante
 
            ' Modelo do HDM-III para irregularidade
            ' IRI = (IRI0 + 725 * ((1 + SNC) ^ -4.99) * NE4) * EXP(.0153 * TTIME)
            FcIRImed = 1: SigmaIRI = .48
            IF Nconf <= Nc(2) THEN
                I1 = 1: I2 = 2
            ELSE
                IF Nconf <= Nc(3) THEN
                    I1 = 2: I2 = 3
                ELSE
                    I1 = 3: I2 = 4
                END IF
            END IF
            Ngauss = ((Nc(I2) * NS(I1) - Nc(I1) * NS(I2)) + Nconf * (NS(I2) - NS(I1))) / (Nc(I2) - Nc(I1))
            Niri = ((Nc(I2) * NQI(I1) - Nc(I1) * NQI(I2)) + Nconf * (NQI(I2) - NQI(I1))) / (Nc(I2) - Nc(I1))
            FcIRI = FcIRImed + Niri * SigmaIRI
            DeltaT = 0.1
            Nyear = NanoMed / 1.0E6
            TTIME = Idade
            QI = QIa
            VRqi = 0
            WHILE (QI < QIcrit AND VRqi < 10)
                DeltaIRI = (.0153 * (QI / 13) + 725 * FcIRI * ((1 + SNC) ^ -4.99) * Nyear * EXP(.0153 * TTIME)) * DeltaT
                QI = QI + 13 * DeltaIRI
                TTIME = TTIME + DeltaT
                VRqi = TTIME - Idade
            WEND

            ' Modelo para trincamento
            IF TR23 <= 0 THEN
                Nadm = 10 ^ ((3.01 - (LOG(Dvbk) / LOG(10))) / 0.176)
                t0 = Nadm / (3 * NanoMed)
                TYcr2 = 4.21 * EXP(0.139 * SNC - 17.1 * Nyear / (SNC ^ 2))
                t0 = (t0 + TYcr2) / 2
                IF t0 > 15 THEN t0 = 15
                TR = 0.1
                VRtr = t0
                WHILE (TR < TRcrit AND VRtr < 20)
                    dTRdt = 2 * (TR ^ 0.35)
                    TR = TR + dTRdt * DeltaT
                    VRtr = VRtr + DeltaT
                WEND
            ELSE
                t0 = 0
                TR = TR23
                VRtr = 0
                WHILE (TR < TRcrit AND VRtr < 15)
                    dTRdt = 2 * (TR ^ 0.35)
                    TR = TR + dTRdt * DeltaT
                    VRtr = VRtr + DeltaT
                WEND
            END IF

            ' Evolucao dos afundamentos em trilha de roda
            MMP = .123
            RH = 1
            COMP = 1
            FcATRmed = 1.2464: SigmaATR = .8204
            FcATR = FcATRmed + Ngauss * SigmaATR
            VRatr = 0
            ATR = RDatual
            TTIME = 0
            NE4 = 0
            IF TR23 <= 0 THEN TR = 0.1 ELSE TR = TR23
            WHILE (ATR < ATRcrit AND VRatr < 10)
                TTIME = TTIME + DeltaT
                NE4 = NE4 + Nyear * DeltaT
                Nac = NE4 * 1.0E6
                IF (TR23 <= 0 AND t0 > TTIME) THEN
                    TR = 0.1
                ELSE
                    dTRdt = 2 * (TR ^ 0.35)
                    TR = TR + dTRdt * DeltaT
                    IF TR > 100 THEN TR = 100
                END IF
                ERM = .0902 + .0384 * (Dvbk / 100) - .009 * RH + .00158 * MMP * TR
                dATR = (.166 * FcATR * (COMP ^ -2.3) * (TTIME ^ (.166 - 1)) * (SNC ^ -.502) * (Nac ^ ERM) + ERM * ATR * (Nyear / NE4)) * DeltaT
                ATR = ATR + dATR
                VRatr = VRatr + DeltaT
            WEND

            ' Evolucao do IGG
            VRigg = 0
            IGG = IGGatual
            ATR = RDatual
            IF TR23 <= 0 THEN TR = 0.1 ELSE TR = TR23
            TTIME = 0
            NE4 = 0
            WHILE (IGG < IGGcrit AND VRigg < 10)
                TTIME = TTIME + DeltaT
                NE4 = NE4 + Nyear * DeltaT
                Nac = NE4 * 1.0E6
                IF (TR23 <= 0 AND t0 > TTIME) THEN
                    TR = 0.1
                ELSE
                    dTRdt = 2 * (TR ^ 0.35)
                    TR = TR + dTRdt * DeltaT
                    IF TR > 100 THEN TR = 100
                END IF
                ERM = .0902 + .0384 * (Dvbk / 100) - .009 * RH + .00158 * MMP * TR
                dATR = (.166 * FcATR * (COMP ^ -2.3) * (TTIME ^ (.166 - 1)) * (SNC ^ -.502) * (Nac ^ ERM) + ERM * ATR * (Nyear / NE4)) * DeltaT
                ATR = ATR + dATR
                ERS = -0.009 * RH + 0.00116 * MMP * TR
                RDS = 2.063 * (ATR ^ 0.532) * (SNC ^ -0.422) * (COMP ^ -1.664) * (Nac ^ ERS)
                IGG = IGGatual + (4 / 3) * (ATR - RDatual) + (RDS ^ 2) + 0.5 * (TR - TR23)
                VRigg = TTIME
            WEND

            VR = VRqi
            IF VRatr < VR THEN VR = VRatr
            IF VRtr < VR THEN VR = VRtr
            IF VRigg < VR THEN VR = VRigg

            ' Condicao prevista para 2024
            DeltaT = 0.1
            TTIME = Idade
            QI = QIa
            IGG = IGGatual
            ATR = RDatual
            IF TR23 <= 0 THEN TR = 0.1 ELSE TR = TR23
            NE4 = 0
            Tempo = 0
            WHILE Tempo < 6
                DeltaIRI = (.0153 * (QI / 13) + 725 * FcIRI * ((1 + SNC) ^ -4.99) * Nyear * EXP(.0153 * TTIME)) * DeltaT
                QI = QI + 13 * DeltaIRI
                TTIME = TTIME + DeltaT
                Tempo = Tempo + DeltaT
                NE4 = NE4 + Nyear * DeltaT
                Nac = NE4 * 1.0E6
                IF (TR23 <= 0 AND t0 > Tempo) THEN
                    TR = 0.1
                ELSE
                    dTRdt = 2 * (TR ^ 0.35)
                    TR = TR + dTRdt * DeltaT
                    IF TR > 100 THEN TR = 100
                END IF
                ERM = .0902 + .0384 * (Dvbk / 100) - .009 * RH + .00158 * MMP * TR
                dATR = (.166 * FcATR * (COMP ^ -2.3) * (Tempo ^ (.166 - 1)) * (SNC ^ -.502) * (Nac ^ ERM) + ERM * ATR * (Nyear / NE4)) * DeltaT
                ATR = ATR + dATR
                ERS = -0.009 * RH + 0.00116 * MMP * TR
                RDS = 2.063 * (ATR ^ 0.532) * (SNC ^ -0.422) * (COMP ^ -1.664) * (Nac ^ ERS)
                IGG = IGGatual + (4 / 3) * (ATR - RDatual) + (RDS ^ 2) + 0.5 * (TR - TR23)
            WEND
            IF TR = 0.1 THEN TR = 0

            WRITE #1, VAL(Subtrecho$), km, INT(10 * VR) / 10, INT(10 * DF(1)) / 10, INT(EpOt), INT(Eslot), INT(100 * SN) / 100, INT(100 * SNC) / 100, INT(10 * QIa) / 10, INT(10 * VRqi) / 10, RDatual, INT(10 * VRatr) / 10, TR23, INT(10 * VRtr) / 10, IGGatual, INT(10 * VRigg) / 10, INT(10 * QI) / 10, INT(10 * IGG) / 10, INT(10 * ATR) / 10, INT(10 * RDS) / 10, INT(10 * TR) / 10

        END IF

    END IF

WEND
CLOSE #2, #1

SYSTEM


10 '
'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
'- Corrige a deflexao maxima para 21,1oC (Guia da AASHTO de 1993)  -
'-                         (Subrotina)                             -
'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
IF Hrev < 3.5 THEN
    X1 = 110
    X2 = -32
    Y1 = 65
    Y2 = -17
ELSE
    IF Hrev <= 7.5 THEN
        X1 = 110
        X2 = -35
        Y1 = 60
        Y2 = -17
    ELSE
        X1 = 110
        X2 = -38
        Y1 = 55
        Y2 = -17
    END IF
END IF
IF TSUP > 75 THEN TSUP = 75
IF TAR > 45 THEN TAR = 45
X = TSUP + TAR
Tpav = ((X2 * Y1 - X1 * Y2) - X * (Y1 - Y2)) / (X2 - X1)
Fd = -.00002 * (Tpav ^ 3) + .0019 * (Tpav ^ 2) - .0597 * Tpav + 1.6028
RETURN


100 '
'- - - - - - - - - - - - - - - - - - - -
'- CALCULA SN A PARTIR DA BACIA DO FWD -
'-            (Subrotina)              -
'- - - - - - - - - - - - - - - - - - - -
IF X > D(7) THEN
    IF DF(7) > 0 THEN
        K = D(7) * DF(7)
    ELSE
        IF DF(6) > 0 THEN
            K = D(6) * DF(6)
        ELSE
            K = D(5) * DF(5)
        END IF
    END IF
    D15HP = K / X
ELSE
    IF X >= D(6) THEN
        I1 = 6
        X1 = D(6)
        X2 = D(7)
        Y1 = DF(6)
        Y2 = DF(7)
    ELSE
        IF X >= D(5) THEN
            I1 = 5
            X1 = D(5)
            X2 = D(6)
            Y1 = DF(5)
            Y2 = DF(6)
        ELSE
            IF X >= D(4) THEN
                I1 = 4
                X1 = D(4)
                X2 = D(5)
                Y1 = DF(4)
                Y2 = DF(5)
            ELSE
                IF X >= D(3) THEN
                    I1 = 3
                    X1 = D(3)
                    X2 = D(4)
                    Y1 = DF(3)
                    Y2 = DF(4)
                ELSE
                    I1 = 2
                    IF X >= D(2) THEN
                        X1 = D(2)
                        X2 = D(3)
                        Y1 = DF(2)
                        Y2 = DF(3)
                    ELSE
                        X1 = D(1)
                        X2 = D(2)
                        Y1 = DF(1)
                        Y2 = DF(2)
                    END IF
                END IF
            END IF
        END IF
    END IF
    D15HP = ((X2 * Y1 - X1 * Y2) - X * (Y1 - Y2)) / (X2 - X1)
    IF D15HP <= 0 THEN
        K = D(I1) * DF(I1)
        D15HP = K / X
    END IF
END IF
SIP = 10 * (DF(1) - D15HP)
IF SIP <= 0 THEN SIP = 10 * (Deflex - D15HP)
IF REVORIG$ = "CBUQ" THEN
    K1 = .4728
    K2 = -.481
    K3 = .7581
ELSE
    IF Hrev >= 3.5 THEN
        K1 = .4728
        K2 = -.481
        K3 = .7581
    ELSE
        K1 = .1165
        K2 = -.3248
        K3 = .8241
    END IF
END IF
IF SIP > 0 THEN
    IF HT <= 0 THEN HT = 30
    SN = K1 * (SIP ^ K2) * ((10 * HT) ^ K3)
ELSE
    SN = -1
END IF
MRsurf = (1 - .4 * .4) * LOAD / (PI# * X * (D15HP / 1000))
RETURN


300 '
' - - - - - - - - - - - - - - - - - - -
' -  Leitura da Base de Dados do SGP  -
' - - - - - - - - - - - - - - - - - - -
Trincado$ = "N"
ARQUIVO$ = CALC$ + "ESTSTHS0.DAT"
OPEN ARQUIVO$ FOR INPUT AS #5
ISTH = 0
QIa = -1
AgePav = -1
FOR IRodov = 1 TO NRODOV
    FOR ISUB = 1 TO NSTHRODOV(IRodov)
        ISTH = ISTH + 1
        INPUT #5, Subtr, NFX, KM1, KM2, FatorVDM, FatorTraf
        FOR IFaixa = 1 TO NFX
            INPUT #5, IFX, h1, HrecExist, Idade, SN, QImed, Nano, IRI0, Nacum, REVEST$, ALFAIGG
            INPUT #5, PSIat, Aream2, VidaRes, VDMUni, PSInovo, Heff, IRec, ICalib, D0, MRfound
            INPUT #5, ALPHA0, ALPHA, ALPHA2, AreaAcost, PSIacost, DegrauAcost, t0, TR23, CBRsl, CamBase$, VDMc, ATRmed
            IF (Subtr = VAL(STH$) AND IFX = Faixa) THEN
                H1REV = h1
                Rev$ = REVEST$
                QIa = QImed
                RDatual = ATRmed
                AgePav = Idade
                IF TR23 > 20 THEN Trincado$ = "S"
                NanoAASHTO = Nano
                IGG$ = "Excelente"
                IF PSIat >= 0 THEN
                    IF PSIat < 2 THEN
                        IGG$ = "Pessimo"
                    ELSE
                        IF PSIat < 3 THEN
                            IGG$ = "Regular"
                        ELSE
                            IF PSIat < 4 THEN
                                IGG$ = "Bom"
                            ELSE
                                IGG$ = "Excelente"
                            END IF
                        END IF
                    END IF
                END IF
            END IF
        NEXT IFaixa
    NEXT ISUB
NEXT IRodov
INPUT #5, PSImed(0), Npsi(0), VRmed(0)
INPUT #5, AreaTotal, NUnidAnalise
CLOSE #5
ARQUIVO$ = DADOSANOBASE$ + "QI\" + TRECHO$ + ".CSV"
OPEN ARQUIVO$ FOR INPUT AS #5
LINE INPUT #5, LINHA$
WHILE NOT EOF(5)
    INPUT #5, KMini, KMfim, QI(1), QI(2), QI(3), QI(4), DAT$, Equip$
    IF KMini < KMfim THEN
        IF (KMini <= km AND km <= KMfim) THEN
            IF QI(Faixa) >= 0 THEN QIa = QI(Faixa)
        END IF
    ELSE
        IF (KMini >= km AND km >= KMfim) THEN
            IF QI(Faixa) >= 0 THEN QIa = QI(Faixa)
        END IF
    END IF
WEND
CLOSE #5
RETURN

6900 '
' - - - - - - - - - - - - - - - - - - - -
' -   Irregularidade apos Recapeamento  -
' -        (Subrotina do HDM-III)       -
' -   Dados: HR, HC, QIest              -
' -   Saida: QIest                      -
' - - - - - - - - - - - - - - - - - - - -
IF QIest > 19 THEN
    QIB = 19! + ((QIest - 19!) / (.602 * hc + 1))
ELSE
    QIB = QIest
END IF
H0 = 10 * HR
IF QIB > 13 THEN QIBL = QIB ELSE QIBL = 13
IF H0 < 80 THEN H0L = H0 ELSE H0L = 80
IF H0 < 40 THEN X = H0 ELSE X = 40
HOV = 3 - ((H0L + X) / 40)
X1 = 19.42 - .78 * QIBL - .068 * H0
IF H0 > 20 THEN Y = H0 - 20 ELSE Y = 0
X2 = -19.5 - .008 * QIBL * Y
IF X1 > X2 THEN DQI = X1 ELSE DQI = X2
IF DQI > 0 THEN DQI = 0
QIest = QIB + DQI
RETURN
