unit Unit94;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls;

procedure Converte(Path: string);
procedure InvConv(Path: string);
procedure VirgDot(Varstring: string);
procedure DotVirg(Varstring: string);
procedure Converte2(Arq: string);

var
  NovoPath, VarDot: string;
  Format1: string[5];
  Format2: string[6];
  Format3: string[7];
  Format4: string[8];

implementation

procedure Converte(Path: string);
var
  Ano, NPeriodos, i: integer;
  Programa, Dados, Calc, Arquivo, DadosAnoBase, Linha, NovaLinha, ConfReg: string;
  ArqDados, ArqOut: TextFile;
begin
  AssignFile(ArqDados, 'Config.dat');
  Reset(ArqDados);
  Readln(ArqDados, ConfReg);
  CloseFile(ArqDados);
  if ConfReg = 'Portuguese' then
    begin
      AssignFile(ArqDados, 'Diretor.dat');
      Reset(ArqDados);
      Readln(ArqDados, Ano);
      Readln(ArqDados, NPeriodos);
      Readln(ArqDados, Programa);
      Readln(ArqDados, Dados);
      Readln(ArqDados, Calc);
      Readln(ArqDados, DadosAnoBase);
      CloseFile(ArqDados);
      { Gera Temp.csv para gerar o arquivo DBF }
        AssignFile(ArqDados, Path);
        Reset(ArqDados);
        AssignFile(ArqOut, 'ArqTemp.csv');
        Rewrite(ArqOut);
        while not Eof(ArqDados) do
          begin
            Readln(ArqDados, Linha);
            NovaLinha := '';
            for i := 1 to Length(Linha) do
              if Linha[i] = ',' then
                 NovaLinha := NovaLinha + ';'
              else
                 if Linha[i] = '.' then
                    NovaLinha := NovaLinha + ','
                 else
                    NovaLinha := NovaLinha + Linha[i];
            Writeln(ArqOut, NovaLinha);
          end;
          CloseFile(ArqDados);
          CloseFile(ArqOut);
          NovoPath := Programa + 'ArqTemp.csv';
    end
  else
    NovoPath := Path;
end;

procedure InvConv(Path: string);
var
  Ano, NPeriodos, i: integer;
  Programa, Dados, Calc, Arquivo, DadosAnoBase, Linha, NovaLinha, ConfReg: string;
  ArqDados, ArqOut: TextFile;
  NumSec, Flag: SmallInt;
  StartTime: TDateTime;
begin
  AssignFile(ArqDados, 'Config.dat');
  Reset(ArqDados);
  Readln(ArqDados, ConfReg);
  CloseFile(ArqDados);
  if ConfReg = 'Portuguese' then
    begin
      AssignFile(ArqDados, 'Diretor.dat');
      Reset(ArqDados);
      Readln(ArqDados, Ano);
      Readln(ArqDados, NPeriodos);
      Readln(ArqDados, Programa);
      Readln(ArqDados, Dados);
      Readln(ArqDados, Calc);
      Readln(ArqDados, DadosAnoBase);
      CloseFile(ArqDados);
      { Gera Temp.csv para gerar o arquivo DBF }
        AssignFile(ArqDados, Path);
        Reset(ArqDados);
        AssignFile(ArqOut, 'ArqTemp.csv');
        Rewrite(ArqOut);
        while not Eof(ArqDados) do
          begin
            Readln(ArqDados, Linha);
            NovaLinha := '';
            for i := 1 to Length(Linha) do
              if Linha[i] = ',' then
                 NovaLinha := NovaLinha + '.'
              else
                 if Linha[i] = ';' then
                    NovaLinha := NovaLinha + ','
                 else
                    NovaLinha := NovaLinha + Linha[i];
            Writeln(ArqOut, NovaLinha);
          end;
          CloseFile(ArqDados);
          CloseFile(ArqOut);
          NovoPath := Programa + 'ArqTemp.csv';
          AssignFile(ArqDados, 'RenFile.bat');
          Rewrite(ArqDados);
          Writeln(ArqDados, 'Copy ' + NovoPath + ' ' + Path);
          CloseFile(ArqDados);
          Arquivo := 'DOS.DAT';
          if FileExists(Arquivo) then
            begin
              AssignFile(ArqDados, Arquivo);
              Erase(ArqDados)
            end;
          WinExec('RenFile.bat /c', SW_HIDE);
          Flag := 0;
          StartTime := now;
          NumSec := 3;
          repeat
            Application.ProcessMessages;
            if FileExists(Arquivo) then Flag := 1;
          until (Now > StartTime + NumSec * (1/24/60/60)) and (Flag = 1);
    end
  else
    NovoPath := Path;
end;

procedure VirgDot(Varstring: string);
var
  i: integer;
  ArqDados: TextFile;
  ConfReg: string;
begin
  AssignFile(ArqDados, 'Config.dat');
  Reset(ArqDados);
  Readln(ArqDados, ConfReg);
  CloseFile(ArqDados);
  if ConfReg = 'Portuguese' then
    begin
      VarDot := '';
      for i := 1 to Length(Varstring) do
        if Varstring[i] = ',' then
          VarDot := VarDot + '.'
        else
          VarDot := VarDot + Varstring[i];
    end
  else
    VarDot := Varstring;
end;

procedure DotVirg(Varstring: string);
var
  i: integer;
  ArqDados: TextFile;
  ConfReg: string;
begin
  AssignFile(ArqDados, 'Config.dat');
  Reset(ArqDados);
  Readln(ArqDados, ConfReg);
  CloseFile(ArqDados);
  if ConfReg = 'Portuguese' then
    begin
      VarDot := '';
      for i := 1 to Length(Varstring) do
        if Varstring[i] = '.' then
          VarDot := VarDot + ','
        else
          VarDot := VarDot + Varstring[i];
    end
  else
    VarDot := Varstring;
end;

procedure Converte2(Arq: string);
var
  Ano, NPeriodos, i: integer;
  Programa, Dados, Calc, Arquivo, DadosAnoBase, Linha, NovaLinha, ConfReg: string;
  ArqDados, ArqOut: TextFile;
begin
  AssignFile(ArqDados, 'Config.dat');
  Reset(ArqDados);
  Readln(ArqDados, ConfReg);
  CloseFile(ArqDados);
  Arquivo := Arq + '.csv';
  if ConfReg = 'Portuguese' then
    begin
      AssignFile(ArqDados, 'Diretor.dat');
      Reset(ArqDados);
      Readln(ArqDados, Ano);
      Readln(ArqDados, NPeriodos);
      Readln(ArqDados, Programa);
      Readln(ArqDados, Dados);
      Readln(ArqDados, Calc);
      Readln(ArqDados, DadosAnoBase);
      CloseFile(ArqDados);
         { Gera Temp.csv para gerar o arquivo DBF }
         AssignFile(ArqDados, Arquivo);
         Reset(ArqDados);
         NovoPath := Arq + 'X.csv';
         AssignFile(ArqOut, NovoPath);
         Rewrite(ArqOut);
         while not Eof(ArqDados) do
           begin
             Readln(ArqDados, Linha);
             NovaLinha := '';
             for i := 1 to Length(Linha) do
               begin
                 if Linha[i] = ',' then
                    NovaLinha := NovaLinha + ';'
                 else
                    if Linha[i] = '.' then
                       NovaLinha := NovaLinha + ','
                    else
                       NovaLinha := NovaLinha + Linha[i];
               end;
               Writeln(ArqOut, NovaLinha);
           end;
           CloseFile(ArqDados);
           CloseFile(ArqOut);
           Format1 := '######,#';
           Format2 := '######,##';
           Format3 := '######,###';
           Format4 := '######,####';
    end
  else
    begin
      NovoPath := Arquivo;
      Format1 := '######.#';
      Format2 := '######.##';
      Format3 := '######.###';
      Format4 := '######.####';
    end;
end;

end.

