unit Unit92;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls;

type
  TForm92 = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    Label1: TLabel;
    ComboBox1: TComboBox;
    procedure CurvasdeDesempenho1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form92: TForm92;

implementation

uses Childwin, ComObj, ActiveX;

{$R *.dfm}

procedure TForm92.CurvasdeDesempenho1Click(Sender: TObject);
begin
  MDIChild.CurvasdeDesempenho1Click(Sender);
end;

procedure TForm92.BitBtn2Click(Sender: TObject);
begin
  Close;
end;

procedure TForm92.BitBtn1Click(Sender: TObject);
var
  ArqDados, Arq: TextFile;
  Programa, Dados, Calc, Arquivo, DadosAnoBase: string;
  Excel: OleVariant;
  ArqCsv, ArqXLS, ArqXLSnovo, Linha: string;
  PA, AnoBase, i, j, k, NFields, NRodov, ISTH, FileCodeExcel, Code, Ano,
    NPeriodos, NSTHmax, icont, STH, NanosHist, Iano1, Jano: integer;
  TaxaTraf: Single;
  Disco: string[3];
  Estrategia: string[3];
  NumSec, Flag: SmallInt;
  StartTime: TDateTime;
  NSTHS, NFaixas, AnoHist: array [1..50] of integer;
  Rodovia: array [1..350] of string[4];
  Campo: array [1..50] of string;
begin
 if ComboBox1.Text <> '' then
 begin
  Screen.Cursor := crHourglass;
  AssignFile(ArqDados, 'Disco.dat');
  Reset(ArqDados);
  Readln(ArqDados, Disco);
  CloseFile(ArqDados);
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Arquivo := Dados + 'AnosHist.dat';
  AssignFile(ArqDados, Arquivo);
  Reset(ArqDados);
  while not Eof(ArqDados) do
    begin
      NanosHist := NanosHist + 1;
      Readln(ArqDados, AnoHist[NanosHist]);
    end;
  CloseFile(ArqDados);
  { Cdigos de identificao das rodovias que compem a rede }
  Arquivo := DadosAnoBase + 'Rodovias.dat';
  AssignFile(ArqDados, Arquivo);
  Reset(ArqDados);
  Readln(ArqDados, NRodov);
  for i := 1 to NRodov do
    Readln(ArqDados, Rodovia[i]);
  CloseFile(ArqDados);
  Arquivo := Calc + 'NSTHROD.OUT';
  AssignFile(ArqDados, Arquivo);
  Reset(ArqDados);
  Readln(ArqDados, NSTHmax);
  for i := 1 to NRodov do
    Readln(ArqDados, NSTHS[i]);
  CloseFile(ArqDados);
  if ComboBox1.Text = 'Evoluo sem Investimentos' then Estrategia := 'EVO'
  else
   if ComboBox1.Text = 'Estratgia-Base' then Estrategia := 'EB' else Estrategia := 'RO';
  Arquivo := Calc + 'Estrateg.dat';
  AssignFile(ArqDados, Arquivo);
  Rewrite(ArqDados);
  Writeln(ArqDados, Estrategia);
  CloseFile(ArqDados);
  Arquivo := 'DOS.DAT';
  if FileExists(Arquivo) then
    begin
      AssignFile(ArqDados, Arquivo);
      Erase(ArqDados)
    end;
  WinExec('cmd.exe /c Prev.bat', SW_SHOW);
  Flag := 0;
  StartTime := now;
  NumSec := 7;
  repeat
    Application.ProcessMessages;
    if FileExists(Arquivo) then Flag := 1;
  until (Now > StartTime + NumSec * (1/24/60/60)) and (Flag = 1);
  { Insere os arquivos *.csv gerados nas planilhas Excel }
  Excel := CreateOleObject('Excel.Application');
  Excel.Visible := False;
  for i := 1 to NRodov do
   begin
    Arquivo := Calc + 'Cadas' + Rodovia[i] + '.csv';
    AssignFile(ArqDados, Arquivo);
    Reset(ArqDados);
    Readln(ArqDados, Linha);
    for ISTH := 1 to NSTHS[i] do
     begin
      { L o nmero de faixas de trfego }
        Readln(ArqDados, Linha);
        NFields := 25;
        k := 1;
        for icont := 1 to NFields do
          Campo[icont] := '';
        for icont := 1 to Length(Linha) do
          if Linha[icont] = ',' then
            k := k + 1
          else
            Campo[k] := Campo[k] + Linha[icont];
        STH := StrToInt(Campo[1]);
        NFaixas[i] := StrToInt(Campo[8]);
      for j := 1 to NFaixas[i] do
       begin
        { Gera os arquivos de resultados }
        Arquivo := Calc + 'Prev.dat';
        AssignFile(Arq, Arquivo);
        Rewrite(Arq);
        Writeln(Arq, Rodovia[i]);
        Writeln(Arq, ISTH);
        Writeln(Arq, j);
        CloseFile(Arq);
        Iano1 := NanosHist;
        for Jano := 1 to NanosHist do
          begin
            Arquivo := Calc + 'Ano ' + IntToStr(AnoHist[Jano]) + '\SUP' + Rodovia[i] + IntToStr(j) + '.dat';
            if FileExists(Arquivo) then
              if Jano < Iano1 then Iano1 := Jano;
          end;
        Arquivo := Calc + 'Previsao.dat';
        AssignFile(Arq, Arquivo);
        Rewrite(Arq);
        Writeln(Arq, Rodovia[i]);
        Writeln(Arq, STH);
        Writeln(Arq, j);
        Writeln(Arq, Iano1);
        CloseFile(Arq);
        Arquivo := 'DOS.DAT';
        if FileExists(Arquivo) then
          begin
            AssignFile(Arq, Arquivo);
            Erase(Arq)
          end;
        WinExec('cmd.exe /c Curv.bat', SW_SHOW);
        Flag := 0;
        StartTime := now;
        NumSec := 5;
        repeat
          Application.ProcessMessages;
          if FileExists(Arquivo) then Flag := 1;
        until (Now > StartTime + NumSec * (1/24/60/60)) and (Flag = 1);
        { Insere em Modelo.xls }
        ArqXLSnovo := Calc + 'XLS\' + Rodovia[i] + '_Fx' + IntToStr(j) + '_STH' + IntToStr(ISTH) + '.xls';
        ArqCsv := Calc + 'S' + Rodovia[i] + IntToStr(j) + IntToStr(ISTH) + '.csv';
        if FileExists(ArqCsv) then
         begin
           FileCodeExcel := 6;
           Excel.Workbooks.Open(ArqCsv, True, FileCodeExcel);
           ArqXls := Disco + 'SGP\Modelo.xls';
           FileCodeExcel := 1;
           Excel.Workbooks.Open(ArqXls, True, FileCodeExcel);
           Excel.Workbooks[1].Sheets[1].UsedRange.Copy;
           Excel.Workbooks[2].Sheets[1].PasteSpecial;
           ArqCsv := Calc + 'D' + Rodovia[i] + IntToStr(j) + IntToStr(ISTH) + '.csv';
           FileCodeExcel := 6;
           Excel.Workbooks.Open(ArqCsv, True, FileCodeExcel);
           Excel.Workbooks[3].Sheets[1].UsedRange.Copy;
           Excel.Workbooks[2].Sheets[2].PasteSpecial;
           FileCodeExcel := 1;
           Excel.Workbooks[2].Sheets[1].SaveAs(ArqXLSnovo, FileCodeExcel);
           Excel.Workbooks[2].Saved := True;
           Excel.Workbooks.Close;
         end;
       end;
     end;
    CloseFile(ArqDados);
   end;
  Excel.Quit;
  Screen.Cursor := crDefault;
 end;
end;

initialization
  CoInitialize (nil);

end.
