unit Unit89;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls, TeeProcs, TeEngine, Chart, DbChart,
  Series;

type
  TForm89 = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    Label1: TLabel;
    ComboBox1: TComboBox;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    Panel3: TPanel;
    Panel4: TPanel;
    Panel5: TPanel;
    Panel6: TPanel;
    Panel7: TPanel;
    Panel8: TPanel;
    DBChart1: TDBChart;
    DBChart2: TDBChart;
    DBChart3: TDBChart;
    DBChart4: TDBChart;
    Series1: TPointSeries;
    Series2: TPointSeries;
    Series3: TPointSeries;
    Series4: TPointSeries;
    Label2: TLabel;
    BitBtn3: TBitBtn;
    procedure PesquisadeModelos1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form89: TForm89;

implementation

uses Childwin, ComObj, ActiveX, Unit24, Unit94;

{$R *.dfm}

procedure TForm89.PesquisadeModelos1Click(Sender: TObject);
begin
  MDIChild.PesquisadeModelos1Click(Sender);
end;

procedure TForm89.BitBtn2Click(Sender: TObject);
begin
  Close;
end;

procedure TForm89.ComboBox1Change(Sender: TObject);
var
  Ano, NPeriodos, i, NRodov, FileCodeExcel, j, icont, NFields, jk: integer;
  ArqDados: TextFile;
  Programa, Dados, Calc, Arquivo, DadosAnoBase, ArqCsv, ArqDbf, ArqOut, Caso,
    Linha, ConfReg: string;
  Excel: OleVariant;
  NumSec, Flag: SmallInt;
  StartTime: TDateTime;
  Campo: array [1..100] of string;
begin
  if ComboBox1.Text <> '' then
    begin
      Screen.Cursor := crHourglass;
      DataModule24.Table41.Active := False;
      DBChart1.Hide;
      DBChart2.Hide;
      DBChart3.Hide;
      DBChart4.Hide;
      AssignFile(ArqDados, 'Diretor.dat');
      Reset(ArqDados);
      Readln(ArqDados, Ano);
      Readln(ArqDados, NPeriodos);
      Readln(ArqDados, Programa);
      Readln(ArqDados, Dados);
      Readln(ArqDados, Calc);
      Readln(ArqDados, DadosAnoBase);
      CloseFile(ArqDados);
      AssignFile(ArqDados, 'Config.dat');
      Reset(ArqDados);
      Readln(ArqDados, ConfReg);
      CloseFile(ArqDados);
      if ComboBox1.Text = 'Pavimentos asflticos' then
        begin
          ArqCsv := Calc + 'MPDFlex.csv';
          Caso := 'Pav. Novo';
          ArqOut := Calc + 'PavNovo.csv';
        end
      else
        if ComboBox1.Text = 'Recapeamentos asflticos' then
          begin
            ArqCsv := Calc + 'MPDRec.csv';
            Caso := 'Recap.';
            ArqOut := Calc + 'Recap.csv';
          end
        else
          begin
            Caso := 'Micro-CA';
            ArqCsv := Calc + 'MPDMic.csv';
            ArqOut := Calc + 'MicroCA.csv';
          end;
      AssignFile(ArqDados, 'Caso.dat');
      Rewrite(ArqDados);
      Writeln(ArqDados, Caso);
      Writeln(ArqDados, ArqCsv);
      CloseFile(ArqDados);
      Arquivo := 'DOS.DAT';
      if FileExists(Arquivo) then
        begin
          AssignFile(ArqDados, Arquivo);
          Erase(ArqDados)
        end;
      WinExec('Regress.bat /c', SW_HIDE);
      Flag := 0;
      StartTime := now;
      NumSec := 5;
      repeat
        Application.ProcessMessages;
        if FileExists(Arquivo) then Flag := 1;
      until (Now > StartTime + NumSec * (1/24/60/60)) and (Flag = 1);
      ArqDbf := Calc + 'MPD.dbf';
      NFields := 18;
      AssignFile(ArqDados, ArqCsv);
      Reset(ArqDados);
      Readln(ArqDados, Linha);
      with DataModule24.Table41 do
        begin
          Active := False;
          TableName := ArqDbf;
          CreateTable;
          Active := True;
          Edit;
          First;
        end;
      while not eof(ArqDados) do
        begin
          Readln(ArqDados, Linha);
          j := 1;
          for icont := 1 to NFields do
            Campo[icont] := '';
          for icont := 1 to Length(Linha) do
            begin
              if Linha[icont] = ',' then
                j := j + 1
              else
                if Linha[icont] <> '' then Campo[j] := Campo[j] + Linha[icont];
            end;
          if ConfReg = 'Portuguese' then
            begin
              for j := 1 to 18 do
                begin
                  for jk := 1 to Length(Campo[j]) do
                    if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                end;
            end;
          DataModule24.Table41.InsertRecord([StrToFloat(Campo[1]),StrToFloat(Campo[2]),
            StrToFloat(Campo[3]),StrToFloat(Campo[4]),StrToFloat(Campo[5]),
            StrToFloat(Campo[6]),StrToFloat(Campo[7]),StrToFloat(Campo[8]),
            StrToFloat(Campo[9]),StrToFloat(Campo[10]),StrToFloat(Campo[11]),
            StrToFloat(Campo[12]),StrToFloat(Campo[13]),StrToFloat(Campo[14]),
            StrToFloat(Campo[15]),StrToFloat(Campo[16]),StrToFloat(Campo[17]),StrToFloat(Campo[18])]);
      end;
    DataModule24.Table41.Close;
    DataModule24.Table41.Active := False;
    CloseFile(ArqDados);
      DataModule24.Table41.Active := True;
      DBChart1.Visible := True;
      DBChart2.Visible := True;
      DBChart3.Visible := True;
      DBChart4.Visible := True;
      DBChart1.Show;
      DBChart2.Show;
      DBChart3.Show;
      DBChart4.Show;
      Excel := CreateOleObject('Excel.Application');
      Excel.Visible := True;
      FileCodeExcel := 6;
      Excel.Workbooks.Open(ArqCsv, True, FileCodeExcel);
      Excel.Workbooks.Open(ArqOut, True, FileCodeExcel);
      Excel.Workbooks[2].Sheets[1].Columns[1].ColumnWidth := 40;
      Excel.Workbooks[2].Sheets[1].Columns[2].ColumnWidth := 11;
      Screen.Cursor := crDefault;
    end;
end;

procedure TForm89.BitBtn1Click(Sender: TObject);
var
  Ano, NPeriodos, NRodov: integer;
  ArqDados: TextFile;
  Programa, Dados, Calc, Arquivo, DadosAnoBase: string;
  NumSec, Flag: SmallInt;
  StartTime: TDateTime;
begin
  Screen.Cursor := crHourglass;
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Arquivo := 'DOS.DAT';
  if FileExists(Arquivo) then
    begin
      AssignFile(ArqDados, Arquivo);
      Erase(ArqDados)
    end;
  WinExec('cmd.exe /c Models.bat', SW_HIDE);
  Flag := 0;
  StartTime := now;
  NumSec := 5;
  repeat
    Application.ProcessMessages;
    if FileExists(Arquivo) then Flag := 1;
  until (Now > StartTime + NumSec * (1/24/60/60)) and (Flag = 1);
  Label1.Visible := True;
  Label2.Visible := True;
  ComboBox1.Visible := True;
  Screen.Cursor := crDefault;
end;

procedure TForm89.FormShow(Sender: TObject);
begin
  Label1.Visible := False;
  Label2.Visible := False;
  ComboBox1.Visible := False;
  DataModule24.Table41.Active := False;
  DBChart1.Hide;
  DBChart2.Hide;
  DBChart3.Hide;
  DBChart4.Hide;
end;

procedure TForm89.BitBtn3Click(Sender: TObject);
begin
  Label1.Visible := True;
  Label2.Visible := True;
  ComboBox1.Visible := True;
end;

initialization
  CoInitialize (nil);

end.
