unit Unit84;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, Buttons, TeeProcs, TeEngine, Chart, DbChart,
  DB, DBCtrls, Series;

type
  TForm84 = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;
    Panel4: TPanel;
    Panel5: TPanel;
    Panel6: TPanel;
    Panel7: TPanel;
    Panel8: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    ComboBox1: TComboBox;
    ComboBox2: TComboBox;
    BitBtn1: TBitBtn;
    DBChart1: TDBChart;
    DBChart2: TDBChart;
    DBChart3: TDBChart;
    DBChart4: TDBChart;
    DBNavigator1: TDBNavigator;
    Label3: TLabel;
    DBText1: TDBText;
    DataSource1: TDataSource;
    Series1: TLineSeries;
    Series2: TLineSeries;
    Series3: TLineSeries;
    Series4: TLineSeries;
    Label4: TLabel;
    Label5: TLabel;
    DBText2: TDBText;
    DBText3: TDBText;
    GroupBox1: TGroupBox;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    DBChart5: TDBChart;
    Series5: TLineSeries;
    DBChart6: TDBChart;
    Series6: TLineSeries;
    DBChart7: TDBChart;
    Series7: TLineSeries;
    DBChart8: TDBChart;
    Series8: TLineSeries;
    procedure DesempenhoporSubtrecho1Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure ComboBox2Change(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure DBNavigator1Click(Sender: TObject; Button: TNavigateBtn);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form84: TForm84;

implementation

uses Childwin, Unit10, Unit24, ComObj, ActiveX, Unit94;

{$R *.dfm}

procedure TForm84.DesempenhoporSubtrecho1Click(Sender: TObject);
begin
  MDIChild.DesempenhoporSubtrecho1Click(Sender);
end;

procedure TForm84.BitBtn1Click(Sender: TObject);
begin
  Close;
end;

procedure TForm84.FormShow(Sender: TObject);
var
  Ano, NPeriodos: integer;
  ArqDados: TextFile;
  Programa, Dados, Calc, Arquivo, DadosAnoBase: string;
begin
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Arquivo := DadosAnoBase + 'Trechos.dat';
  ComboBox1.Items.LoadFromFile(Arquivo);
  DataModule24.Table39.Active := False;
  DataModule24.Table40.Active := False;
  DataModule10.Table2.Active := False;
  DBChart1.Visible := False;
  DBChart2.Visible := False;
  DBChart3.Visible := False;
  DBChart4.Visible := False;
  DBChart5.Visible := False;
  DBChart6.Visible := False;
  DBChart7.Visible := False;
  DBChart8.Visible := False;
end;

procedure TForm84.ComboBox2Change(Sender: TObject);
var
  Ano, NPeriodos, i, NRodov, Subtrecho, j, icont, NFields, jk: integer;
  ArqDados, Arq: TextFile;
  Programa, Dados, Calc, Arquivo, DadosAnoBase, ArqCsv, ArqDbf, Executa, Local,
    NomeArq, Linha, ConfReg: string;
  Trecho, Nome, Estrategia: string[4];
  NumSec, Flag: SmallInt;
  StartTime: TDateTime;
  Campo: array [1..100] of string;
begin
  if ComboBox1.Text <> '' then
   if ComboBox2.Text <> '' then
    begin
      Screen.Cursor := crHourglass;
      DBChart1.Visible := False;
      DBChart2.Visible := False;
      DBChart3.Visible := False;
      DBChart4.Visible := False;
      DBChart1.Hide;
      DBChart2.Hide;
      DBChart3.Hide;
      DBChart4.Hide;
      DBChart5.Visible := False;
      DBChart6.Visible := False;
      DBChart7.Visible := False;
      DBChart8.Visible := False;
      DBChart5.Hide;
      DBChart6.Hide;
      DBChart7.Hide;
      DBChart8.Hide;
      DataModule24.Table39.Active := False;
      DataModule24.Table40.Active := False;
      AssignFile(ArqDados, 'Diretor.dat');
      Reset(ArqDados);
      Readln(ArqDados, Ano);
      Readln(ArqDados, NPeriodos);
      Readln(ArqDados, Programa);
      Readln(ArqDados, Dados);
      Readln(ArqDados, Calc);
      Readln(ArqDados, DadosAnoBase);
      CloseFile(ArqDados);
      AssignFile(ArqDados, 'Config.dat');
      Reset(ArqDados);
      Readln(ArqDados, ConfReg);
      CloseFile(ArqDados);
      Estrategia := 'EVO';
      Arquivo := Calc + 'Estrateg.dat';
      AssignFile(ArqDados, Arquivo);
      Rewrite(ArqDados);
      Writeln(ArqDados, Estrategia);
      CloseFile(ArqDados);
      Subtrecho := StrToInt(DBText1.Field.Text);
      Arquivo := DadosAnoBase + 'Trechos.dat';
      AssignFile(ArqDados, Arquivo);
      Reset(ArqDados);
      Arquivo := DadosAnoBase + 'Trechos.dsc';
      AssignFile(Arq, Arquivo);
      Reset(Arq);
      while Eof(ArqDados) = False do
        begin
          Readln(ArqDados, Local);
          Readln(Arq, Nome);
          if ComboBox1.Text = Local then Trecho := Nome;
        end;
      CloseFile(ArqDados);
      CloseFile(Arq);
      Arquivo := Calc + 'Previsao.dat';
      AssignFile(ArqDados, Arquivo);
      Rewrite(ArqDados);
      Writeln(ArqDados, Trecho);
      Writeln(ArqDados, Subtrecho);
      Writeln(ArqDados, ComboBox2.Text);
      CloseFile(ArqDados);
      ArqCsv := 'DOS.DAT';
      if FileExists(ArqCsv) then
        begin
          AssignFile(ArqDados, ArqCsv);
          Erase(ArqDados)
        end;
      if CheckBox2.Checked then
        begin
          NomeArq := 'Previsao';
          WinExec('PrevSTH.bat /c', SW_HIDE);
        end
      else
        begin
          NomeArq := 'Hist';
          WinExec('History.bat /c', SW_HIDE);
        end;
      Flag := 0;
      StartTime := now;
      NumSec := 5;
      repeat
        Application.ProcessMessages;
        if FileExists(ArqCsv) then Flag := 1;
      until (Now > StartTime + NumSec * (1/24/60/60)) and (Flag = 1);
      AssignFile(ArqDados, 'Prev.dat');
      Reset(ArqDados);
      Readln(ArqDados, Executa);
      CloseFile(ArqDados);
      if Executa = '"Sim"' then
        begin
          ArqDbf := Calc + NomeArq + '.dbf';
          ArqCsv := Calc + NomeArq + '.csv';
          if CheckBox2.Checked then
            begin
              DataModule24.Table39.Active := False;
              NFields := 7;
              AssignFile(ArqDados, ArqCsv);
              Reset(ArqDados);
              Readln(ArqDados, Linha);
              with DataModule24.Table39 do
                begin
                  Active := False;
                  TableName := ArqDbf;
                  CreateTable;
                  Active := True;
                  Edit;
                  First;
                end;
              while not eof(ArqDados) do
                begin
                  Readln(ArqDados, Linha);
                  j := 1;
                  for icont := 1 to NFields do
                    Campo[icont] := '';
                  for icont := 1 to Length(Linha) do
                    begin
                      if Linha[icont] = ',' then
                        j := j + 1
                      else
                        if Linha[icont] <> '' then Campo[j] := Campo[j] + Linha[icont];
                    end;
                  if ConfReg = 'Portuguese' then
                    begin
                      for j := 1 to 7 do
                        begin
                          for jk := 1 to Length(Campo[j]) do
                            if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                        end;
                    end;
                  DataModule24.Table39.InsertRecord([StrToFloat(Campo[1]),StrToFloat(Campo[2]),
                    StrToFloat(Campo[3]),StrToFloat(Campo[4]),StrToFloat(Campo[5]),
                    StrToFloat(Campo[6]),StrToFloat(Campo[7])]);
                end;
              DataModule24.Table39.Close;
              DataModule24.Table39.Active := False;
              CloseFile(ArqDados);
            end
          else
            begin
              DataModule24.Table40.Active := False;
              NFields := 10;
              AssignFile(ArqDados, ArqCsv);
              Reset(ArqDados);
              Readln(ArqDados, Linha);
              with DataModule24.Table40 do
                begin
                  Active := False;
                  TableName := ArqDbf;
                  CreateTable;
                  Active := True;
                  Edit;
                  First;
                end;
              while not eof(ArqDados) do
                begin
                  Readln(ArqDados, Linha);
                  j := 1;
                  for icont := 1 to NFields do
                    Campo[icont] := '';
                  for icont := 1 to Length(Linha) do
                    begin
                      if Linha[icont] = ',' then
                        j := j + 1
                      else
                        if Linha[icont] <> '' then Campo[j] := Campo[j] + Linha[icont];
                    end;
                  if ConfReg = 'Portuguese' then
                    begin
                      for j := 1 to 10 do
                        begin
                          for jk := 1 to Length(Campo[j]) do
                            if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                        end;
                    end;
                  DataModule24.Table40.InsertRecord([StrToFloat(Campo[1]),StrToFloat(Campo[2]),
                    StrToFloat(Campo[3]),StrToFloat(Campo[4]),StrToFloat(Campo[5]),
                    StrToFloat(Campo[6]),StrToFloat(Campo[7]),StrToFloat(Campo[8]),
                    StrToFloat(Campo[9]),StrToFloat(Campo[10])]);
                end;
              DataModule24.Table40.Close;
              DataModule24.Table40.Active := False;
              CloseFile(ArqDados);
            end;
          if CheckBox2.Checked then
            begin
              DataModule24.Table39.Active := True;
              DBChart1.Visible := True;
              DBChart2.Visible := True;
              DBChart3.Visible := True;
              DBChart4.Visible := True;
              DBChart1.Align := alClient;
              DBChart2.Align := alClient;
              DBChart3.Align := alClient;
              DBChart4.Align := alClient;
              DBChart1.Show;
              DBChart2.Show;
              DBChart3.Show;
              DBChart4.Show;
            end
          else
            begin
              DataModule24.Table40.Active := True;
              DBChart5.Visible := True;
              DBChart6.Visible := True;
              DBChart7.Visible := True;
              DBChart8.Visible := True;
              DBChart5.Align := alClient;
              DBChart6.Align := alClient;
              DBChart7.Align := alClient;
              DBChart8.Align := alClient;
              DBChart5.Show;
              DBChart6.Show;
              DBChart7.Show;
              DBChart8.Show;
            end;
        end
      else
        ShowMessage('Faixa de trfego inexistente!');
      Screen.Cursor := crDefault;
    end;
end;

procedure TForm84.ComboBox1Change(Sender: TObject);
var
  Ano, NPeriodos, i, NRodov, Subtrecho: integer;
  ArqDados, Arq: TextFile;
  Trecho, Nome: string[4];
  Year: string[4];
  Rodovia: array [1..350] of string[4];
  Programa, Dados, Calc, Arquivo, DadosAnoBase, Local: string;
begin
  if ComboBox1.Text <> '' then
    begin
      ComboBox2.Text := '';
      DataModule10.Table2.Active := False;
      DataModule24.Table39.Active := False;
      DataModule24.Table40.Active := False;
      DBChart1.Visible := False;
      DBChart2.Visible := False;
      DBChart3.Visible := False;
      DBChart4.Visible := False;
      DBChart5.Visible := False;
      DBChart6.Visible := False;
      DBChart7.Visible := False;
      DBChart8.Visible := False;
      AssignFile(ArqDados, 'Diretor.dat');
      Reset(ArqDados);
      Readln(ArqDados, Ano);
      Readln(ArqDados, NPeriodos);
      Readln(ArqDados, Programa);
      Readln(ArqDados, Dados);
      Readln(ArqDados, Calc);
      Readln(ArqDados, DadosAnoBase);
      CloseFile(ArqDados);
      Year := IntToStr(Ano);
      { Cdigos de identificao das rodovias que compem a rede }
        Arquivo := DadosAnoBase + 'Rodovias.dat';
        AssignFile(ArqDados, Arquivo);
        Reset(ArqDados);
        Readln(ArqDados, NRodov);
        for i := 1 to NRodov do
          Readln(ArqDados, Rodovia[i]);
        CloseFile(ArqDados);
        Arquivo := DadosAnoBase + 'Trechos.dat';
        AssignFile(ArqDados, Arquivo);
        Reset(ArqDados);
        Arquivo := DadosAnoBase + 'Trechos.dsc';
        AssignFile(Arq, Arquivo);
        Reset(Arq);
        i := 0;
        while Eof(ArqDados) = False do
          begin
            Readln(ArqDados, Local);
            Readln(Arq, Nome);
            i := i + 1;
            if ComboBox1.Text = Local then Trecho := Nome;
          end;
        CloseFile(ArqDados);
        CloseFile(Arq);
      DataModule10.Table2.TableName := Dados + 'Cadas_' + Trecho + '_' + Year + '.dbf';
      DataModule10.Table2.Active := True;
    end;
end;

procedure TForm84.CheckBox2Click(Sender: TObject);
begin
  ComboBox2.Text := '';
  if CheckBox2.Checked then CheckBox1.Checked := False;
  if not CheckBox2.Checked then CheckBox1.Checked := True;
end;

procedure TForm84.CheckBox1Click(Sender: TObject);
begin
  ComboBox2.Text := '';
  if CheckBox1.Checked then CheckBox2.Checked := False;
  if not CheckBox1.Checked then CheckBox2.Checked := True;
end;

procedure TForm84.DBNavigator1Click(Sender: TObject; Button: TNavigateBtn);
begin
  ComboBox2.Text := '';
end;

initialization
  CoInitialize (nil);

end.
