unit Unit82;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB, DBCtrls, Grids, DBGrids, StdCtrls, Buttons, ExtCtrls;

type
  TForm82 = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    DBGrid1: TDBGrid;
    DBNavigator1: TDBNavigator;
    DataSource1: TDataSource;
    Panel3: TPanel;
    Panel4: TPanel;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    ComboBox1: TComboBox;
    Edit1: TEdit;
    Label3: TLabel;
    Label4: TLabel;
    Panel5: TPanel;
    BitBtn2: TBitBtn;
    BitBtn1: TBitBtn;
    Panel6: TPanel;
    DBGrid2: TDBGrid;
    DataSource2: TDataSource;
    DBNavigator2: TDBNavigator;
    procedure AnliseFinanceira1Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form82: TForm82;

implementation

uses Childwin, Unit24, ComObj, ActiveX, Unit10, Unit94;

{$R *.dfm}

procedure TForm82.AnliseFinanceira1Click(Sender: TObject);
begin
  MDIChild.AnliseFinanceira1Click(Sender);
end;

procedure TForm82.BitBtn1Click(Sender: TObject);
begin
  BitBtn2.Visible := False;
  Close;
end;

procedure TForm82.FormShow(Sender: TObject);
begin
  BitBtn2.Visible := False;
  DataModule24.Table34.Active := False;
  DataModule10.Table13.Active := True;
  Label3.Visible := False;
  Label4.Visible := False;
end;

procedure TForm82.ComboBox1Change(Sender: TObject);
var
  Ano, NPeriodos, Modo, i, j, icont, NFields, jk: integer;
  ArqDados: TextFile;
  Programa, Dados, Calc, Arquivo, ArqCsv, ArqDbf, Linha, LinhaX, LinhaY, ConfReg: string;
  NumSec, Flag: SmallInt;
  StartTime: TDateTime;
  Campo: array [1..100] of string;
begin
 if ComboBox1.Text <> '' then
   begin
     DataModule24.Table34.Active := False;
     DataModule10.Table13.Active := False;
     Screen.Cursor := crHourglass;
     Label3.Visible := False;
     Label4.Visible := False;
     AssignFile(ArqDados, 'Diretor.dat');
     Reset(ArqDados);
     Readln(ArqDados, Ano);
     Readln(ArqDados, NPeriodos);
     Readln(ArqDados, Programa);
     Readln(ArqDados, Dados);
     Readln(ArqDados, Calc);
     CloseFile(ArqDados);
     AssignFile(ArqDados, 'Config.dat');
     Reset(ArqDados);
     Readln(ArqDados, ConfReg);
     CloseFile(ArqDados);
     Modo := -1;
     if ComboBox1.Text = 'Estratgia-Base' then Modo := 1;
     if ComboBox1.Text = 'Estratgia sob Restries' then Modo := 2;
     if Modo > 0 then
       begin
         { Converte de DBF para CSV }
           ArqCsv := Calc + 'Tarifas.csv';
           ArqDbf := Dados + 'Tarifas.dbf';
           AssignFile(ArqDados, ArqCsv);
           Rewrite(ArqDados);
           Linha := 'CATEGORIA,VEICULO,TARIFA_R$';
           NFields := 1;
           for icont := 1 to Length(Linha) do
             if Linha[icont] = ',' then NFields := NFields + 1;
           Writeln(ArqDados, Linha);
           with DataModule10.Table13 do
             begin
               Active := False;
               TableName := ArqDbf;
               Active := True;
               First;
               while not Eof do
                 begin
                   LinhaX := Fields.Fields[0].AsString;
                   Linha := '';
                   for jk := 1 to Length(LinhaX) do
                     begin
                       if LinhaX[jk] = ',' then LinhaX[jk] := '.';
                       Linha := Linha + LinhaX[jk];
                     end;
                   for icont := 1 to NFields-1 do
                     begin
                       LinhaX := Fields.Fields[icont].AsString;
                       LinhaY := '';
                       for jk := 1 to Length(LinhaX) do
                         begin
                           if LinhaX[jk] = ',' then LinhaX[jk] := '.';
                           LinhaY := LinhaY + LinhaX[jk];
                         end;
                       Linha := Linha + ',' + LinhaY;
                     end;
                   Writeln(ArqDados, Linha);
                   Next;
                 end;
               Active := False;
             end;
           CloseFile(ArqDados);
         Arquivo := Calc + 'Cash.dat';
         AssignFile(ArqDados, Arquivo);
         Rewrite(ArqDados);
         Writeln(ArqDados, Modo);
         CloseFile(ArqDados);
         { Gera o arquivo CashFlow.csv }
           ArqDbf := Calc + 'CashFlow.dbf';
           if FileExists(ArqDbf) then
           begin
             AssignFile(ArqDados, ArqDbf);
             Erase(ArqDados)
           end;
           Arquivo := 'DOS.DAT';
           if FileExists(Arquivo) then
           begin
             AssignFile(ArqDados, Arquivo);
             Erase(ArqDados)
           end;
           WinExec('Cash.bat /c', SW_HIDE);
           Flag := 0;
           StartTime := now;
           NumSec := 5;
           repeat
             Application.ProcessMessages;
             if FileExists(Arquivo) then Flag := 1;
           until (Now > StartTime + NumSec * (1/24/60/60)) and (Flag = 1);
         { Converte de CSV para DBF }
           ArqCsv := Calc + 'CashFlow.csv';
  NFields := 9;
  AssignFile(ArqDados, ArqCsv);
  Reset(ArqDados);
  Readln(ArqDados, Linha);
  with DataModule24.Table34 do
    begin
      Active := False;
      TableName := ArqDbf;
      CreateTable;
      Active := True;
      Edit;
      First;
    end;
    while not eof(ArqDados) do
      begin
        Readln(ArqDados, Linha);
        j := 1;
        for icont := 1 to NFields do
          Campo[icont] := '';
        for icont := 1 to Length(Linha) do
          begin
            if Linha[icont] = ',' then
              j := j + 1
            else
              if Linha[icont] <> '' then Campo[j] := Campo[j] + Linha[icont];
          end;
        if ConfReg = 'Portuguese' then
          begin
            for j := 1 to 9 do
              begin
                for jk := 1 to Length(Campo[j]) do
                  if Campo[j,jk] = '.' then Campo[j,jk] := ',';
              end;
          end;
        DataModule24.Table34.InsertRecord([StrToFloat(Campo[1]),StrToFloat(Campo[2]),
          StrToFloat(Campo[3]),StrToFloat(Campo[4]),StrToFloat(Campo[5]),
          StrToFloat(Campo[6]),StrToFloat(Campo[7]),StrToFloat(Campo[8]),
          StrToFloat(Campo[9])]);
      end;
    DataModule24.Table34.Close;
    DataModule24.Table34.Active := False;
    CloseFile(ArqDados);
         BitBtn2.Visible := True;
         Screen.Cursor := crDefault;
         DataModule10.Table13.Active := True;
         DataModule24.Table34.Active := True;
       end;
   end;
end;

procedure TForm82.BitBtn2Click(Sender: TObject);
var
  Ano, NPeriodos, Modo, i, icont, NFields, jk: integer;
  ArqDados: TextFile;
  Programa, Dados, Calc, Arquivo, ArqCsv, ArqDbf, Taxa, Linha, LinhaX,
    LinhaY: string;
  NumSec, Flag: SmallInt;
  StartTime: TDateTime;
  VP, r: Single;
begin
VirgDot(Edit1.Text);
r := StrToFloat(VarDot);
if r >= 0.0 then
 begin
  DataModule24.Table34.Active := False;
  Screen.Cursor := crHourglass;
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  CloseFile(ArqDados);
  { Converte de DBF para CSV }
  ArqCsv := Calc + 'CashFlow.csv';
  ArqDbf := Calc + 'CashFlow.dbf';
  AssignFile(ArqDados, ArqCsv);
  Rewrite(ArqDados);
  Linha := 'ANO,PAVIMENTO,OAES,SINALIZ.,DRENAGEM,TALUDES,OPERACAO,MAN.GERAL,PEDAGIOS';
  NFields := 1;
  for icont := 1 to Length(Linha) do
    if Linha[icont] = ',' then NFields := NFields + 1;
  Writeln(ArqDados, Linha);
  with DataModule24.Table34 do
    begin
      Active := False;
      TableName := ArqDbf;
      Active := True;
      First;
      while not Eof do
        begin
          LinhaX := Fields.Fields[0].AsString;
          Linha := '';
          for jk := 1 to Length(LinhaX) do
            begin
              if LinhaX[jk] = ',' then LinhaX[jk] := '.';
              Linha := Linha + LinhaX[jk];
            end;
          for icont := 1 to NFields-1 do
            begin
              LinhaX := Fields.Fields[icont].AsString;
              LinhaY := '';
              for jk := 1 to Length(LinhaX) do
                begin
                  if LinhaX[jk] = ',' then LinhaX[jk] := '.';
                  LinhaY := LinhaY + LinhaX[jk];
                end;
              Linha := Linha + ',' + LinhaY;
            end;
          Writeln(ArqDados, Linha);
          Next;
        end;
      Active := False;
    end;
  CloseFile(ArqDados);
  { Faz os clculos }
    Arquivo := Calc + 'Taxa.dat';
    AssignFile(ArqDados, Arquivo);
    Rewrite(Arqdados);
    Writeln(ArqDados, r);
    CloseFile(ArqDados);
    Arquivo := 'DOS.DAT';
    if FileExists(Arquivo) then
      begin
        AssignFile(ArqDados, Arquivo);
        Erase(ArqDados)
      end;
      WinExec('Financ.bat /c', SW_HIDE);
      Flag := 0;
      StartTime := now;
      NumSec := 5;
      repeat
        Application.ProcessMessages;
        if FileExists(Arquivo) then Flag := 1;
      until (Now > StartTime + NumSec * (1/24/60/60)) and (Flag = 1);
  Arquivo := Calc + 'Financ.out';
  AssignFile(ArqDados, Arquivo);
  Reset(ArqDados);
  Readln(ArqDados, VP);
  Readln(ArqDados, Taxa);
  CloseFile(ArqDados);
  Label3.Caption := '- Valor presente do fluxo de caixa (R$) =  ' + FloatToStr(VP);
  Label4.Caption := '- Taxa interna de retorno (% a.a.) =  ' + Taxa;
  Label3.Visible := True;
  Label4.Visible := True;
  DataModule24.Table34.Active := True;
  Screen.Cursor := crDefault;
 end;
end;

initialization
  CoInitialize (nil);

end.
