unit Unit81;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls, DB, Grids, DBGrids, Menus, DBCtrls;

type
  TForm81 = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    Label1: TLabel;
    ComboBox1: TComboBox;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    DBGrid1: TDBGrid;
    DataSource1: TDataSource;
    MainMenu1: TMainMenu;
    Edit1: TMenuItem;
    Cut1: TMenuItem;
    Copy1: TMenuItem;
    Paste1: TMenuItem;
    Clula1: TMenuItem;
    Coluna1: TMenuItem;
    Memo1: TMemo;
    Label2: TLabel;
    DBNavigator1: TDBNavigator;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    procedure AmpliaesdePistas1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure Cut1Click(Sender: TObject);
    procedure Copy1Click(Sender: TObject);
    procedure Clula1Click(Sender: TObject);
    procedure Coluna1Click(Sender: TObject);
    procedure DBGrid1CellClick(Column: TColumn);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form81: TForm81;

implementation

uses Childwin, Unit24, ComObj, ActiveX, Unit94;

{$R *.dfm}

procedure TForm81.AmpliaesdePistas1Click(Sender: TObject);
begin
  MDIChild.AmpliaesdePistas1Click(Sender);
end;

procedure TForm81.BitBtn2Click(Sender: TObject);
begin
  Close;
end;

procedure TForm81.FormShow(Sender: TObject);
var
  Ano, NPeriodos: integer;
  ArqDados: TextFile;
  Programa, Dados, Calc, Arquivo, DadosAnoBase: string;
begin
  Label3.Visible := False;
  Label4.Visible := False;
  Label5.Visible := False;
  Memo1.Text := '';
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Arquivo := DadosAnoBase + 'Trechos.dat';
  ComboBox1.Items.LoadFromFile(Arquivo);
  DataModule24.Table33.Active := False;
end;

procedure TForm81.ComboBox1Change(Sender: TObject);
var
  Ano, NPeriodos: integer;
  Arquivo, Programa, Dados, Calc, Polo, Local, DadosAnoBase: string;
  Year: string[4];
  Trecho, Nome: string[4];
  ArqDados, Arq: TextFile;
begin
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Year := IntToStr(Ano);
  Arquivo := DadosAnoBase + 'Trechos.dat';
  AssignFile(ArqDados, Arquivo);
  Reset(ArqDados);
  Arquivo := DadosAnoBase + 'Trechos.dsc';
  AssignFile(Arq, Arquivo);
  Reset(Arq);
  while Eof(ArqDados) = False do
    begin
      Readln(ArqDados, Local);
      Readln(Arq, Nome);
      if ComboBox1.Text = Local then Trecho := Nome;
    end;
  CloseFile(ArqDados);
  CloseFile(Arq);
  if ComboBox1.Text <> '' then
    begin
      DataModule24.Table33.Active := False;
      DataModule24.Table33.TableName := Calc + 'Amplia_' + Trecho + '.dbf';
      DataModule24.Table33.Active := True;
      Label3.Caption := Trecho;
      Label3.Visible := True;
    end;
end;

procedure TForm81.BitBtn1Click(Sender: TObject);
var
  Ano, NPeriodos, NRodov, i, icont, NFields, jk: integer;
  ArqDados: TextFile;
  Programa, Dados, Calc, Arquivo, ArqDbf, ArqCsv, DadosAnoBase, Linha,
    LinhaX, LinhaY: string;
  Rodovia: array [1..350] of string[4];
  Year: string[4];
begin
  Screen.Cursor := crHourglass;
  DataModule24.Table33.Active := False;
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Year := IntToStr(Ano);
  { Cdigos de identificao das rodovias que compem a rede }
  Arquivo := DadosAnoBase + 'Rodovias.dat';
  AssignFile(ArqDados, Arquivo);
  Reset(ArqDados);
  Readln(ArqDados, NRodov);
  for i := 1 to NRodov do
    Readln(ArqDados, Rodovia[i]);
  CloseFile(ArqDados);
  { Converte de *.dbf para *.csv }
    for i := 1 to NRodov do
      begin
        ArqCsv := Calc + 'Ampl' + Rodovia[i] + '.csv';
        ArqDbf := Calc + 'Amplia_' + Rodovia[i] + '.dbf';
        AssignFile(ArqDados, ArqCsv);
        Rewrite(ArqDados);
        Linha := 'STH, ANO_ALTERA, FATOR_1, FATOR_2, FATOR_3, FATOR_4';
        NFields := 1;
        for icont := 1 to Length(Linha) do
          if Linha[icont] = ',' then NFields := NFields + 1;
        Writeln(ArqDados, Linha);
        with DataModule24.Table33 do
          begin
            Active := False;
            TableName := ArqDbf;
            Active := True;
            First;
            while not Eof do
              begin
                LinhaX := Fields.Fields[0].AsString;
                Linha := '';
                for jk := 1 to Length(LinhaX) do
                  begin
                    if LinhaX[jk] = ',' then LinhaX[jk] := '.';
                    Linha := Linha + LinhaX[jk];
                  end;
                for icont := 1 to NFields-1 do
                  begin
                    LinhaX := Fields.Fields[icont].AsString;
                    LinhaY := '';
                    for jk := 1 to Length(LinhaX) do
                      begin
                        if LinhaX[jk] = ',' then LinhaX[jk] := '.';
                        LinhaY := LinhaY + LinhaX[jk];
                      end;
                    Linha := Linha + ',' + LinhaY;
                  end;
                Writeln(ArqDados, Linha);
                Next;
              end;
              Active := False;
          end;
        CloseFile(ArqDados);
      end;
  Screen.Cursor := crDefault;
end;

procedure TForm81.Cut1Click(Sender: TObject);
begin
  Memo1.Text := DBGrid1.SelectedField.AsString;
  DataSource1.Edit;
  DBGrid1.SelectedField.Clear;
  DataModule24.Table33.Post;
end;

procedure TForm81.Copy1Click(Sender: TObject);
begin
  Memo1.Text := DBGrid1.SelectedField.AsString;
end;

procedure TForm81.Clula1Click(Sender: TObject);
begin
  DataSource1.Edit;
  DBGrid1.SelectedField.AsString := Memo1.Text;
  DataModule24.Table33.Post;
end;

procedure TForm81.Coluna1Click(Sender: TObject);
var
  i: SmallInt;
begin
  i := DBGrid1.SelectedField.Index;
  with DataModule24.Table33 do
    begin
      First;
      while not EOF do
        begin
          DataSource1.Edit;
          DBGrid1.Fields[i].AsString := Memo1.Text;
          Next;
        end;
      DataSource1.Edit;
      Post;
    end;
end;

procedure TForm81.DBGrid1CellClick(Column: TColumn);
var
  Ano, NPeriodos, icont, NFields, i, j: integer;
  ArqDados, Arq: TextFile;
  Programa, Dados, Calc, Arquivo, DadosAnoBase, Local, Linha, Subtrecho, STH,
    kmi, kmf, SubSTH: string;
  Trecho, Nome: string[4];
  Coluna: SmallInt;
  Campo: array [1..50] of string[30];
begin
  Coluna := DBGrid1.SelectedField.Index;
  if Coluna = 0 then
    begin
      Label4.Visible := False;
      Label5.Visible := False;
      Subtrecho := DBGrid1.SelectedField.AsString;
      AssignFile(ArqDados, 'Diretor.dat');
      Reset(ArqDados);
      Readln(ArqDados, Ano);
      Readln(ArqDados, NPeriodos);
      Readln(ArqDados, Programa);
      Readln(ArqDados, Dados);
      Readln(ArqDados, Calc);
      Readln(ArqDados, DadosAnoBase);
      CloseFile(ArqDados);
      Arquivo := DadosAnoBase + 'Trechos.dat';
      AssignFile(ArqDados, Arquivo);
      Reset(ArqDados);
      Arquivo := DadosAnoBase + 'Trechos.dsc';
      AssignFile(Arq, Arquivo);
      Reset(Arq);
      while Eof(ArqDados) = False do
        begin
          Readln(ArqDados, Local);
          Readln(Arq, Nome);
          if ComboBox1.Text = Local then Trecho := Nome;
        end;
      CloseFile(ArqDados);
      CloseFile(Arq);
      Arquivo := Calc + 'Cadas' + Trecho + '.csv';
      AssignFile(ArqDados, Arquivo);
      Reset(ArqDados);
      Readln(ArqDados, Linha);
      icont := 0;
      NFields := 25;
      while not Eof(ArqDados) do
        begin
          Readln(ArqDados, Linha);
          icont := icont + 1;
          j := 1;
          for i := 1 to NFields do
            Campo[i] := '';
          for i := 1 to Length(Linha) do
            begin
              if Linha[i] = ',' then
                j := j + 1
              else
               Campo[j] := Campo[j] + Linha[i];
            end;
          SubSTH := '';
          for i := 1 to Length(Campo[1]) do
            if Campo[1,i] <> '"' then SubSTH := SubSTH + Campo[1,i];
          if Subtrecho = SubSTH then
            begin
              STH := Campo[1];
              kmi := Campo[5];
              kmf := Campo[6];
            end;
        end;
      CloseFile(ArqDados);
      Label4.Caption := 'Subtrecho ==> Incio: km ' + kmi;
      Label4.Visible := True;
      Label5.Caption := 'Final: km ' + kmf;
      Label5.Visible := True;
    end;
end;

initialization
  CoInitialize (nil);

end.
