unit Unit77;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Db, DBTables, Qrctrls, QuickRpt, ExtCtrls;

type
  TQRListForm21 = class(TForm)
    QuickRep1: TQuickRep;
    DetailBand1: TQRBand;
    PageFooterBand1: TQRBand;
    QRSysData2: TQRSysData;
    TitleBand1: TQRBand;
    QRSysData1: TQRSysData;
    MasterTable: TTable;
    QRLabel3: TQRLabel;
    QRSysData3: TQRSysData;
    QRLabel1: TQRLabel;
    QRLabel2: TQRLabel;
    QRLabel4: TQRLabel;
    QRLabel5: TQRLabel;
    QRLabel6: TQRLabel;
    QRLabel7: TQRLabel;
    QRLabel8: TQRLabel;
    QRLabel9: TQRLabel;
    QRLabel10: TQRLabel;
    QRLabel11: TQRLabel;
    QRLabel12: TQRLabel;
    QRLabel13: TQRLabel;
    QRLabel14: TQRLabel;
    QRLabel15: TQRLabel;
    QRImage1: TQRImage;
    procedure QuickRep1BeforePrint(Sender: TCustomQuickRep;
      var PrintReport: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  QRListForm21: TQRListForm21;

implementation

uses Unit47;

{$R *.DFM}

procedure TQRListForm21.QuickRep1BeforePrint(Sender: TCustomQuickRep;
  var PrintReport: Boolean);
const
  NPolos = 19;
var
  ArqDados: TextFile;
  Ano, NPeriodos, Modo, NPP, i, j: integer;
  Programa, Dados, Calc, Arquivo, MatCP, Pole, Local,
    Mode, RevAcost, SART: string;
  Year: string[4];
  PSRcrit, HRmin, HRmax, PSIf, IDScrit, DEGRAUadm, HCmin, VUMin, QI0adm,
    PP, inf, HRCP, PSIref, FCnovo, FCrecap, FCccp, PTRAF, PPSI, HCmax,
    HbaseAcost, PerctReparos: Single;
  Param7: string[7];
  Restr: array [1..NPolos, 1..30] of Single;
  RestrAnual: array [1..30] of Single;
  Polo: array [1..NPolos] of string;
  Trecho, Estrategia: string[4];
  SGP, Sistema: string[5];
  Num: string[2];
begin
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  CloseFile(ArqDados);
  Year := IntToStr(Ano);
  Arquivo := Calc + 'Local.dat';
  AssignFile(ArqDados, Arquivo);
  Reset(ArqDados);
  Readln(ArqDados, Pole);
  Readln(ArqDados, Local);
  Readln(ArqDados, Trecho);
  Readln(ArqDados, Estrategia);
  CloseFile(ArqDados);
  Arquivo := Calc + 'Arv' + Trecho + '.dat';
  AssignFile(ArqDados, Arquivo);
  Reset(ArqDados);
  Readln(ArqDados, IDScrit);
  Readln(ArqDados, PSRcrit);
  Readln(ArqDados, HRmin);
  Readln(ArqDados, HRmax);
  Readln(ArqDados, PSIf);
  Readln(ArqDados, DEGRAUadm);
  Readln(ArqDados, HCmin);
  Readln(ArqDados, HCmax);
  Readln(ArqDados, VUMin);
  Readln(ArqDados, QI0adm);
  Readln(ArqDados, HbaseAcost);
  Readln(ArqDados, PerctReparos);
  Readln(ArqDados, RevAcost);
  Readln(ArqDados, SART);
  CloseFile(ArqDados);
  AssignFile(ArqDados, 'Sistema.dat');
  Reset(ArqDados);
  Readln(ArqDados, SGP);
  CloseFile(ArqDados);
  if SGP[5] = '\' then Sistema := SGP[1] + SGP[2] + SGP[3] + SGP[4] else Sistema := SGP;
  if Sistema = 'SGP4' then
   Num := '2'
  else
   if Sistema = 'SGP5' then
    Num := '3'
   else
    if Sistema = 'SGP3' then
      Num := '1'
    else
      if Sistema = 'SGPC' then
        Num := '11'
      else
        if Sistema = 'SGPL' then
          Num := '12'
        else
          if Sistema = 'SGPM' then
            Num := '13'
          else
            Num := '2';
  if Sistema = 'SGP6' then Num := '4';
  if Sistema = 'SGP8' then Num := '6';
  if Sistema = 'SGP9' then Num := '7';
  if Sistema = 'SGP10' then Num := '8';
  if Sistema = 'SGP11' then Num := '9';
  if Sistema = 'SGP13' then Num := '14';
  if Sistema = 'SGP14' then Num := '16';
  if Sistema = 'SGP16' then Num := '17';
  if Sistema = 'SGP17' then Num := '18';
  if Sistema = 'SGP18' then Num := '19';
  if Sistema = 'SGP19' then Num := '20';
  if Sistema = 'SGP20' then Num := '21';
  if Sistema = 'SGP21' then Num := '22';
  if Sistema = 'SGP22' then Num := '23';
  if Sistema = 'SGP23' then Num := '24';
  if Sistema = 'SGP24' then Num := '25';
  if Sistema = 'SGP25' then Num := '26';
  if Sistema = 'SGP26' then Num := '27';
  if Sistema = 'SGP27' then Num := '28';
  if Sistema = 'SGP28' then Num := '29';
  if Sistema = 'SGP29' then Num := '15';
  if Sistema = 'SGMBD' then Num := '35';
  if Sistema = 'SGP30' then Num := '40';
  if Sistema = 'SGP31' then Num := '41';
  if Sistema = 'SGP32' then Num := '42';
  if Sistema = 'SGP33' then Num := '43';
  if Sistema = 'SGP34' then Num := '44';
  if Sistema = 'SGP35' then Num := '45';
  if Sistema = 'SGP36' then Num := '46';
  if Sistema = 'SGP37' then Num := '47';
  if Sistema = 'SGP38' then Num := '48';
  if Sistema = 'SGP39' then Num := '49';
  MasterTable.Active := False;
  MasterTable.DatabaseName := 'STANDARD' + Num + '3';
  QRLabel1.Caption := 'PSI terminal para restaurao';
  QRLabel2.Caption := FloatToStr(PSIf);
  QRLabel4.Caption := 'Desnvel pista-acostamento admissvel';
  QRLabel5.Caption := FloatToStr(DEGRAUadm) + ' cm';
  QRLabel6.Caption := 'Vida til mnima para Conserva Pesada';
  QRLabel7.Caption := FloatToStr(VUMin) + ' anos';
  QRLabel8.Caption := 'Irregularidade mxima admissvel aps restaurao';
  if QI0adm > 0.0 then
    QRLabel9.Caption := FloatToStr(QI0adm) + ' cont/km'
  else
    QRLabel9.Caption := 'No foi imposta';
  QRLabel10.Caption := 'Espessura mnima de fresagem';
  QRLabel11.Caption := FloatToStr(HCmin) + ' cm';
  QRLabel12.Caption := 'Espessura mnima de recapeamento';
  QRLabel13.Caption := FloatToStr(HRmin) + ' cm';
  QRLabel14.Caption := 'Espessura mxima de recapeamento';
  QRLabel15.Caption := FloatToStr(HRmax) + ' cm';
  QRImage1.Picture.LoadFromFile(Dados + 'Logotipo.jpg');
end;

end.
