unit Unit70;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, TeEngine, Series, TeeProcs, Chart,
  DBChart;

type
  TForm70 = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    DBChart1: TDBChart;
    Series1: TLineSeries;
    Series2: TLineSeries;
    Series3: TLineSeries;
    DBChart2: TDBChart;
    Series4: TLineSeries;
    Series5: TLineSeries;
    Series6: TLineSeries;
    GroupBox1: TGroupBox;
    CheckBox1: TCheckBox;
    RadioGroup1: TRadioGroup;
    Panel3: TPanel;
    DBChart3: TDBChart;
    Series7: TLineSeries;
    Series8: TLineSeries;
    Series9: TLineSeries;
    DBChart4: TDBChart;
    Series10: TLineSeries;
    Series11: TLineSeries;
    Series12: TLineSeries;
    BitBtn3: TBitBtn;
    procedure ComparaodeEstratgias1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form70: TForm70;

implementation

uses Childwin, Unit24, ComObj, ActiveX, Printers, Unit94;

{$R *.DFM}

procedure TForm70.ComparaodeEstratgias1Click(Sender: TObject);
begin
  MDIChild.ComparaodeEstratgias1Click(Sender);
end;

procedure TForm70.BitBtn2Click(Sender: TObject);
begin
  Close;
end;

procedure TForm70.FormShow(Sender: TObject);
begin
  DBChart1.Visible := False;
  DBChart2.Visible := False;
  DBChart3.Visible := False;
  DBChart4.Visible := False;
  GroupBox1.Visible := False;
end;

procedure TForm70.BitBtn1Click(Sender: TObject);
const
  NEstrateg = 3;
var
  Ano, NPeriodos, i, j, icont, NFields, jk: integer;
  ArqDados: TextFile;
  Programa, Dados, Calc, Arquivo, ArqDbf1, ArqDbf2, ArqCsv, Linha, LinhaX,
    LinhaY, DadosAnoBase, ConfReg: string;
  NumSec, Flag: SmallInt;
  StartTime: TDateTime;
  ARQ: array[1..NEstrateg] of string[2];
  Campo: array [1..100] of string;
begin
  Screen.Cursor := crHourglass;
  GroupBox1.Visible := False;
  ARQ[1] := 'SI';
  ARQ[2] := 'EB';
  ARQ[3] := 'RO';
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  AssignFile(ArqDados, 'Config.dat');
  Reset(ArqDados);
  Readln(ArqDados, ConfReg);
  CloseFile(ArqDados);
  { Cria o arquivo global }
    DataModule24.Table10.Active := False;
    DataModule24.Table11.Active := False;
    DataModule24.Table15.Active := False;
    DataModule24.Table25.Active := False;
    ArqDbf2 := Calc + 'Res.dbf';
    if FileExists(ArqDbf2) then
      begin
        AssignFile(ArqDados, ArqDbf2);
        Erase(ArqDados)
      end;
    for i := 1 to NEstrateg do
      begin
        ArqCsv := Calc + 'Res' + ARQ[i] + '.csv';
        ArqDbf1 := Calc + 'Res' + ARQ[i] + '.dbf';
        AssignFile(ArqDados, ArqCsv);
        Rewrite(ArqDados);
        Linha := 'ANO,CUSTO,PSIMEDIO,OCORR,VRANOS';
        NFields := 1;
        for icont := 1 to Length(Linha) do
          if Linha[icont] = ',' then NFields := NFields + 1;
        Writeln(ArqDados, Linha);
        with DataModule24.Table10 do
          begin
            Active := False;
            TableName := ArqDbf1;
            Active := True;
            First;
            while not Eof do
              begin
                LinhaX := Fields.Fields[0].AsString;
                Linha := '';
                for jk := 1 to Length(LinhaX) do
                  begin
                    if LinhaX[jk] = ',' then LinhaX[jk] := '.';
                    Linha := Linha + LinhaX[jk];
                  end;
                for icont := 1 to NFields-1 do
                  begin
                    LinhaX := Fields.Fields[icont].AsString;
                    LinhaY := '';
                    for jk := 1 to Length(LinhaX) do
                      begin
                        if LinhaX[jk] = ',' then LinhaX[jk] := '.';
                        LinhaY := LinhaY + LinhaX[jk];
                      end;
                    Linha := Linha + ',' + LinhaY;
                  end;
                Writeln(ArqDados, Linha);
                Next;
              end;
            Active := False;
          end;
        CloseFile(ArqDados);
      end;
    ArqCsv := 'DOS.DAT';
    if FileExists(ArqCsv) then
      begin
        AssignFile(ArqDados, ArqCsv);
        Erase(ArqDados)
      end;
    WinExec('Res.exe /c', SW_HIDE);
    Flag := 0;
    StartTime := now;
    NumSec := 3;
    repeat
      Application.ProcessMessages;
      if FileExists(ArqCsv) then Flag := 1;
    until (Now > StartTime + NumSec * (1/24/60/60)) and (Flag = 1);
    ArqCsv := Calc + 'Res.csv';
    NFields := 13;
    AssignFile(ArqDados, ArqCsv);
    Reset(ArqDados);
    Readln(ArqDados, Linha);
    with DataModule24.Table25 do
      begin
        Active := False;
        TableName := ArqDbf2;
        CreateTable;
        Active := True;
        Edit;
        First;
      end;
      while not eof(ArqDados) do
        begin
          Readln(ArqDados, Linha);
          j := 1;
          for icont := 1 to NFields do
            Campo[icont] := '';
          for icont := 1 to Length(Linha) do
            begin
              if Linha[icont] = ',' then
                j := j + 1
              else
                if Linha[icont] <> '' then Campo[j] := Campo[j] + Linha[icont];
            end;
          if ConfReg = 'Portuguese' then
            begin
              for j := 1 to 13 do
                begin
                  for jk := 1 to Length(Campo[j]) do
                    if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                end;
            end;
          DataModule24.Table25.InsertRecord([StrToFloat(Campo[1]),StrToFloat(Campo[2]),
            StrToFloat(Campo[3]),StrToFloat(Campo[4]),StrToFloat(Campo[5]),StrToFloat(Campo[6]),
            StrToFloat(Campo[7]),StrToFloat(Campo[8]),StrToFloat(Campo[9]),StrToFloat(Campo[10]),
            StrToFloat(Campo[11]),StrToFloat(Campo[12]),StrToFloat(Campo[13])]);
        end;
      DataModule24.Table25.Close;
      DataModule24.Table25.Active := False;
      CloseFile(ArqDados);
  GroupBox1.Visible := True;
  Screen.Cursor := crDefault;
  DataModule24.Table25.Active := True;
  DBChart1.Visible := True;
  DBChart2.Visible := True;
  DBChart3.Visible := True;
  DBChart4.Visible := True;
end;

procedure TForm70.CheckBox1Click(Sender: TObject);
begin
  DBChart1.View3D := CheckBox1.Checked;
  DBChart2.View3D := CheckBox1.Checked;
  DBChart3.View3D := CheckBox1.Checked;
  DBChart4.View3D := CheckBox1.Checked;
end;

procedure TForm70.BitBtn3Click(Sender: TObject);
var
  tmpH, tmpW, tmpWMargin, tmpHMargin: Longint; { margins }
  OldOrientation: TPrinterOrientation;
begin
  Screen.Cursor := crHourGlass;
  OldOrientation:=Printer.Orientation;  { <-- save paper orientation }
  Printer.Orientation:=poLandscape; { <-- Force Horizontal paper }
  try
    Printer.BeginDoc;       { <-- start printer job }
    try
      Printer.Title := 'Comparao de Estratgias ao Longo do Tempo';

      Case RadioGroup1.ItemIndex of
        0: begin { screen proportional }
             DBChart1.PrintResolution:= 0;
             DBChart2.PrintResolution:= 0;
             DBChart3.PrintResolution:= 0;
             DBChart4.PrintResolution:= 0;
           end;
        1: begin { thin lines and small fonts }
             DBChart1.PrintResolution:= -100;
             DBChart2.PrintResolution:= -100;
             DBChart3.PrintResolution:= -100;
             DBChart4.PrintResolution:= -100;
           end;
      end;

      { Print the four charts, each one at a different paper position }

      { CALCULATE HORIZONTAL MARGIN }
      tmpW:=Printer.PageWidth;
      tmpWMargin:=Round(5.0*tmpW/100.0); { <-- 5% margins }
      tmpW:=tmpW-2*tmpWMargin;  { <-- left and right margins }
      tmpW:=tmpW div 2; { half width for left and right charts }
      { CALCULATE VERTICAL MARGIN }
      tmpH:=Printer.PageHeight;
      tmpHMargin:=Round(5.0*tmpH/100.0);  { <-- 5% margins }
      tmpH:=tmpH-2*tmpHMargin;  { <-- bottom and top margins }
      tmpH:=tmpH div 2; { half height for top and bottom charts }

      { left / top chart }
      DBChart1.PrintPartial( Rect( tmpWMargin,tmpHMargin,
                            tmpWMargin+tmpW,tmpHMargin+tmpH ) );

      { right / top chart }
      DBChart3.PrintPartial( Rect( tmpWMargin+tmpW,tmpHMargin,
                            tmpWMargin+2*tmpW,tmpHMargin+tmpH ) );

      { left / bottom chart }
      DBChart2.PrintPartial( Rect( tmpWMargin,tmpHMargin+tmpH,
                            tmpWMargin+tmpW,tmpHMargin+2*tmpH ) );

      { right / bottom chart }
      DBChart4.PrintPartial( Rect( tmpWMargin+tmpW,tmpHMargin+tmpH,
                            tmpWMargin+2*tmpW,tmpHMargin+2*tmpH ) );

      Printer.EndDoc; { <-- end job and print !! }
      except
        on Exception do  { just in case an error happens... }
          begin
            Printer.Abort;
            Printer.EndDoc;
            Raise;
          end;
    end;
  finally
     Printer.Orientation:=OldOrientation;  { <-- restore paper orientation }
     Screen.Cursor:=crDefault; { <-- restore cursor }
  end;
end;

initialization
  CoInitialize (nil);

end.
