unit Unit7;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, Db, Grids, DBGrids, DBTables, DBCtrls, Menus;

type
  TForm7 = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    BitBtn1: TBitBtn;
    Label1: TLabel;
    ComboBox1: TComboBox;
    DataSource1: TDataSource;
    DBGrid1: TDBGrid;
    DBNavigator1: TDBNavigator;
    Memo1: TMemo;
    Label2: TLabel;
    MainMenu1: TMainMenu;
    Edit1: TMenuItem;
    Cut1: TMenuItem;
    Copy1: TMenuItem;
    Paste1: TMenuItem;
    Coluna1: TMenuItem;
    Clula1: TMenuItem;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    procedure BitBtn1Click(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure Cut1Click(Sender: TObject);
    procedure Copy1Click(Sender: TObject);
    procedure Coluna1Click(Sender: TObject);
    procedure Clula1Click(Sender: TObject);
    procedure DBGrid1CellClick(Column: TColumn);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form7: TForm7;

implementation

{$R *.DFM}

uses Childwin, Unit10;

procedure TForm7.BitBtn1Click(Sender: TObject);
begin
  DataSource1.Edit;
  DataModule10.Table7.Post;
  DataModule10.Table7.Active := False;
  Close;
end;

procedure TForm7.ComboBox1Change(Sender: TObject);
var
  Ano, NPeriodos: integer;
  Programa, Dados, Calc, Polo, Local, Arquivo, DadosAnoBase: string;
  Year: string[4];
  Trecho, Nome: string[4];
  ArqDados, Arq: TextFile;
begin
if ComboBox1.Text <> '' then
 begin
  Label4.Visible := False;
  Label5.Visible := False;
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Year := IntToStr(Ano);
  Arquivo := DadosAnoBase + 'Trechos.dat';
  AssignFile(ArqDados, Arquivo);
  Reset(ArqDados);
  Arquivo := DadosAnoBase + 'Trechos.dsc';
  AssignFile(Arq, Arquivo);
  Reset(Arq);
  while Eof(ArqDados) = False do
    begin
      Readln(ArqDados, Local);
      Readln(Arq, Nome);
      if ComboBox1.Text = Local then
        begin
          Trecho := Nome;
          Label3.Caption := Trecho;
          Label3.Visible := True;
        end;
    end;
  CloseFile(ArqDados);
  CloseFile(Arq);
  if ComboBox1.Text <> '' then
    begin
      DataModule10.Table7.Active := False;
      DataModule10.Table7.TableName := Dados + 'TRAF_' + Trecho + '_' + Year + '.dbf';
      Arquivo := DadosAnoBase + 'Pedg.dat';
      DBGrid1.Columns[1].PickList.LoadFromFile(Arquivo);
      DataModule10.Table7.Active := True;
    end;
 end
else
 Label3.Visible := False;
end;

procedure TForm7.FormShow(Sender: TObject);
var
  Ano, NPeriodos: integer;
  ArqDados: TextFile;
  Programa, Dados, Calc, Arquivo, DadosAnoBase: string;
  Atualiza: string[3];
begin
  Label3.Visible := False;
  Label4.Visible := False;
  Label5.Visible := False;
  Memo1.Text := '';
  DataModule10.Table7.Active := False;
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Arquivo := DadosAnoBase + 'Trechos.dat';
  ComboBox1.Items.LoadFromFile(Arquivo);
  AssignFile(ArqDados, 'Acesso.dat');
  Reset(ArqDados);
  Readln(ArqDados, Atualiza);
  CloseFile(ArqDados);
  if Atualiza = 'Sim' then
    DBGrid1.ReadOnly := False
  else
    DBGrid1.ReadOnly := True;
end;

procedure TForm7.Cut1Click(Sender: TObject);
begin
  Memo1.Text := DBGrid1.SelectedField.AsString;
  DataSource1.Edit;
  DBGrid1.SelectedField.Clear;
  DataModule10.Table7.Post;
end;

procedure TForm7.Copy1Click(Sender: TObject);
begin
  Memo1.Text := DBGrid1.SelectedField.AsString;
end;

procedure TForm7.Coluna1Click(Sender: TObject);
var
  i: SmallInt;
begin
  i := DBGrid1.SelectedField.Index;
  with DataModule10.Table7 do
    begin
      First;
      while not EOF do
        begin
          DataSource1.Edit;
          DBGrid1.Fields[i].AsString := Memo1.Text;
          Next;
        end;
      DataSource1.Edit;
      Post;
    end;
end;

procedure TForm7.Clula1Click(Sender: TObject);
begin
  DataSource1.Edit;
  DBGrid1.SelectedField.AsString := Memo1.Text;
  DataModule10.Table7.Post;
end;

procedure TForm7.DBGrid1CellClick(Column: TColumn);
var
  Ano, NPeriodos, icont, NFields, i, j: integer;
  ArqDados, Arq: TextFile;
  Programa, Dados, Calc, Arquivo, DadosAnoBase, Local, Linha, Subtrecho,
    STH, kmi, kmf, SubSTH: string;
  Trecho, Nome: string[4];
  Coluna: SmallInt;
  Campo: array [1..50] of string[30];
begin
  Coluna := DBGrid1.SelectedField.Index;
  if Coluna = 0 then
    begin
      Label4.Visible := False;
      Label5.Visible := False;
      Subtrecho := DBGrid1.SelectedField.AsString;
      AssignFile(ArqDados, 'Diretor.dat');
      Reset(ArqDados);
      Readln(ArqDados, Ano);
      Readln(ArqDados, NPeriodos);
      Readln(ArqDados, Programa);
      Readln(ArqDados, Dados);
      Readln(ArqDados, Calc);
      Readln(ArqDados, DadosAnoBase);
      CloseFile(ArqDados);
      Arquivo := DadosAnoBase + 'Trechos.dat';
      AssignFile(ArqDados, Arquivo);
      Reset(ArqDados);
      Arquivo := DadosAnoBase + 'Trechos.dsc';
      AssignFile(Arq, Arquivo);
      Reset(Arq);
      while Eof(ArqDados) = False do
        begin
          Readln(ArqDados, Local);
          Readln(Arq, Nome);
          if ComboBox1.Text = Local then Trecho := Nome;
        end;
      CloseFile(ArqDados);
      CloseFile(Arq);
      Arquivo := Calc + 'Cadas' + Trecho + '.csv';
      AssignFile(ArqDados, Arquivo);
      Reset(ArqDados);
      Readln(ArqDados, Linha);
      icont := 0;
      NFields := 25;
      while not Eof(ArqDados) do
        begin
          Readln(ArqDados, Linha);
          icont := icont + 1;
          j := 1;
          for i := 1 to NFields do
            Campo[i] := '';
          for i := 1 to Length(Linha) do
            begin
              if Linha[i] = ',' then
                j := j + 1
              else
               Campo[j] := Campo[j] + Linha[i];
            end;
          SubSTH := '';
          for i := 1 to Length(Campo[1]) do
            if Campo[1,i] <> '"' then SubSTH := SubSTH + Campo[1,i];
          if Subtrecho = SubSTH then
            begin
              STH := Campo[1];
              kmi := Campo[5];
              kmf := Campo[6];
            end;
        end;
      CloseFile(ArqDados);
      Label4.Caption := 'Subtrecho ==> Incio: km ' + kmi;
      Label4.Visible := True;
      Label5.Caption := 'Final: km ' + kmf;
      Label5.Visible := True;
    end;
end;

end.
