unit Unit69;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, Grids, DBGrids, Db, DBCtrls, TeeProcs,
  TeEngine, Chart, DBChart, Series;

type
  TForm69 = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    DataSource1: TDataSource;
    DBGrid1: TDBGrid;
    BitBtn3: TBitBtn;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    ComboBox1: TComboBox;
    ComboBox2: TComboBox;
    DBNavigator1: TDBNavigator;
    DBText1: TDBText;
    Label4: TLabel;
    Label5: TLabel;
    DBText2: TDBText;
    DBText3: TDBText;
    DataSource2: TDataSource;
    Label6: TLabel;
    ComboBox3: TComboBox;
    Panel4: TPanel;
    DBChart1: TDBChart;
    Series1: TLineSeries;
    Label7: TLabel;
    ComboBox4: TComboBox;
    DBChart2: TDBChart;
    Series2: TLineSeries;
    procedure MemriadeClculo1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure ComboBox4Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form69: TForm69;

implementation

uses Childwin, ComObj, ActiveX, Unit10, Unit24, Unit71, Unit94;

{$R *.DFM}

procedure TForm69.MemriadeClculo1Click(Sender: TObject);
begin
  MDIChild.MemriadeClculo1Click(Sender);
end;

procedure TForm69.BitBtn2Click(Sender: TObject);
begin
  DataModule24.Table26.Active := False;
  DataModule10.Table2.Active := False;
  Close;
end;

procedure TForm69.BitBtn1Click(Sender: TObject);
var
  Ano, NPeriodos, Modo, NPP, j, icont, NFields, jk: integer;
  ArqDados: TextFile;
  Programa, Dados, Calc, Arquivo, ArqCsv, ArqDbf, DadosAnoBase, Linha, ConfReg: string;
  PP, inf: Single;
  Trecho, Nome: string[4];
  NumSec, Flag: SmallInt;
  StartTime: TDateTime;
  Campo: array [1..100] of string;
begin
 if ComboBox1.Text <> '' then
 if ComboBox2.Text <> '' then
 if ComboBox3.Text <> '' then
 begin
  Screen.Cursor := crHourglass;
  Label7.Caption := '';
  ComboBox4.Visible := False;
  ComboBox4.Text := '';
  DBChart1.Visible := False;
  DBChart2.Visible := False;
  DataModule24.Table26.Active := False;
  DataModule24.Table27.Active := False;
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  AssignFile(ArqDados, 'Config.dat');
  Reset(ArqDados);
  Readln(ArqDados, ConfReg);
  CloseFile(ArqDados);
  if ComboBox3.Text = 'Evoluo sem Investimentos' then Modo := 0;
  if ComboBox3.Text = 'Estratgia-Base' then Modo := 1;
  if ComboBox3.Text = 'Estratgia sob Restries' then Modo := 2;
  Arquivo := Calc + 'Modo.dat';
  AssignFile(ArqDados, Arquivo);
  Rewrite(ArqDados);
  Writeln(ArqDados, Modo);
  CloseFile(ArqDados);
  Arquivo := Calc + 'MemSth.dat';
  AssignFile(ArqDados, Arquivo);
  Rewrite(ArqDados);
  Writeln(ArqDados, DBText1.Field.AsInteger);
  Writeln(ArqDados, ComboBox2.Text);
  CloseFile(ArqDados);
  ArqCsv := 'DOS.DAT';
  if FileExists(ArqCsv) then
    begin
      AssignFile(ArqDados, ArqCsv);
      Erase(ArqDados)
    end;
  WinExec('MemSth.bat /c', SW_HIDE);
  Flag := 0;
  StartTime := now;
  NumSec := 3;
  repeat
    Application.ProcessMessages;
    if FileExists(ArqCsv) then Flag := 1;
  until (Now > StartTime + NumSec * (1/24/60/60)) and (Flag = 1);
  { Converte de CSV para DBF }
    ArqDbf := Calc + 'Memoria.dbf';
    ArqCsv := Calc + 'MemSth.csv';
    NFields := 2;
    AssignFile(ArqDados, ArqCsv);
    Reset(ArqDados);
    Readln(ArqDados, Linha);
    with DataModule24.Table26 do
      begin
        Active := False;
        TableName := ArqDbf;
        CreateTable;
        Active := True;
        Edit;
        First;
      end;
      while not eof(ArqDados) do
        begin
          Readln(ArqDados, Linha);
          j := 1;
          for icont := 1 to NFields do
            Campo[icont] := '';
          for icont := 1 to Length(Linha) do
            begin
              if Linha[icont] = ',' then
                j := j + 1
              else
                if Linha[icont] <> '' then Campo[j] := Campo[j] + Linha[icont];
            end;
          DataModule24.Table26.InsertRecord([Campo[1],Campo[2]]);
        end;
      DataModule24.Table26.Close;
      DataModule24.Table26.Active := False;
      CloseFile(ArqDados);
    ArqDbf := Calc + 'STH.dbf';
    ArqCsv := Calc + 'Sth.csv';
    NFields := 3;
    AssignFile(ArqDados, ArqCsv);
    Reset(ArqDados);
    Readln(ArqDados, Linha);
    with DataModule24.Table27 do
      begin
        Active := False;
        TableName := ArqDbf;
        CreateTable;
        Active := True;
        Edit;
        First;
      end;
      while not eof(ArqDados) do
        begin
          Readln(ArqDados, Linha);
          j := 1;
          for icont := 1 to NFields do
            Campo[icont] := '';
          for icont := 1 to Length(Linha) do
            begin
              if Linha[icont] = ',' then
                j := j + 1
              else
                if Linha[icont] <> '' then Campo[j] := Campo[j] + Linha[icont];
            end;
          if ConfReg = 'Portuguese' then
            begin
              for j := 1 to 3 do
                begin
                  for jk := 1 to Length(Campo[j]) do
                    if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                end;
            end;
          DataModule24.Table27.InsertRecord([StrToFloat(Campo[1]),StrToFloat(Campo[2]),
            StrToFloat(Campo[3])]);
        end;
      DataModule24.Table27.Close;
      DataModule24.Table27.Active := False;
      CloseFile(ArqDados);
  DataModule24.Table26.Active := True;
  BitBtn3.Visible := True;
  Label7.Caption := 'Grfico:';
  ComboBox4.Visible := True;
  Screen.Cursor := crDefault;
 end;
end;

procedure TForm69.FormShow(Sender: TObject);
var
  Ano, NPeriodos: integer;
  ArqDados: TextFile;
  Programa, Dados, Calc, Arquivo, DadosAnoBase: string;
begin
  Label7.Caption := '';
  ComboBox4.Visible := False;
  DBChart1.Visible := False;
  DBChart2.Visible := False;
  BitBtn3.Visible := False;
  DataModule10.Table2.Active := False;
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Arquivo := DadosAnoBase + 'Trechos.dat';
  ComboBox1.Items.LoadFromFile(Arquivo);
end;

procedure TForm69.ComboBox1Change(Sender: TObject);
var
  Ano, NPeriodos: integer;
  Programa, Dados, Calc, Polo, Local, Arquivo, DadosAnoBase: string;
  ArqDados, Arq: TextFile;
  Year: string[4];
  Trecho, Nome: string[4];
begin
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Year := IntToStr(Ano);
  Arquivo := DadosAnoBase + 'Trechos.dat';
  AssignFile(ArqDados, Arquivo);
  Reset(ArqDados);
  Arquivo := DadosAnoBase + 'Trechos.dsc';
  AssignFile(Arq, Arquivo);
  Reset(Arq);
  while Eof(ArqDados) = False do
    begin
      Readln(ArqDados, Local);
      Readln(Arq, Nome);
      if ComboBox1.Text = Local then Trecho := Nome;
    end;
  CloseFile(ArqDados);
  CloseFile(Arq);
  if ComboBox1.Text <> '' then
    begin
      DataModule10.Table2.Active := False;
      DataModule10.Table2.TableName := Dados + 'CADAS_' + Trecho + '_' + Year + '.dbf';
      DataModule10.Table2.Active := True;
    end;
end;

procedure TForm69.BitBtn3Click(Sender: TObject);
var
  Ano, NPeriodos: integer;
  Programa, Dados, Calc, Arquivo, DadosAnoBase: string;
  ArqDados: TextFile;
begin
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Arquivo := Calc + 'Mem.out';
  AssignFile(ArqDados, Arquivo);
  Rewrite(ArqDados);
  Writeln(ArqDados, 'Trecho: ' + ComboBox1.Text);
  Writeln(ArqDados, 'Subtrecho No.: ' + DBText1.Field.AsString);
  Writeln(ArqDados, 'km_i: ' + DBText2.Field.AsString);
  Writeln(ArqDados, 'km_f: ' + DBText3.Field.AsString);
  Writeln(ArqDados, 'Faixa de trfego: ' + ComboBox2.Text);
  Writeln(ArqDados, 'Anlise: ' + ComboBox3.Text);
  CloseFile(ArqDados);
  QRListForm16.QuickRep1.Preview;
end;

procedure TForm69.ComboBox4Change(Sender: TObject);
begin
  DataModule24.Table27.Active := True;
  DBChart1.Visible := False;
  DBChart1.Align := alLeft;
  DBChart2.Visible := False;
  DBChart2.Align := alLeft;
  if ComboBox4.Text = 'PSI' then
    begin
      DBChart1.Align := alClient;
      DBChart1.Visible := True;
    end;
  if ComboBox4.Text = 'Vida Restante' then
    begin
      DBChart2.Align := alClient;
      DBChart2.Visible := True;
    end;
end;

initialization
  CoInitialize (nil);

end.
