unit Unit65;

interface

procedure Inicializa;
procedure Estrategias;

const
  NPolos = 30;
  NRodovMax = NPolos;
  NSTHMAXIMO = 500;
  NSthRedeMax = 1500;
  NFaixasMax = 4;
  NPeriodosMax = 30;
  NPSITMAX = 20;
  NPPMAX = 20;
  PI = 3.141592654;
  QREF = 4100.0;

var
  CustoP, ConserP, NewRestP, CustoCLP, IPMAXPolo, CostPr: array [1..NPolos] of Single;
  STHPRIPolo: array [1..NPolos] of integer;
  UltCamada, REVEST, Restaurado, MedidaF: array [1..NFaixasMax] of string;
  VDMUni, Nacum, VidaRes, CotaFaixa, ALFAIGG, PSInovo, SN, HREFORCO, HRef,
    Heff, Hfres, Hrec, IRI0, ALPHA: array [1..NFaixasMax] of Single;
  NFaixas: array [1..NSthRedeMax] of integer;
  Rodov: array [1..NRodovMax] of string;
  NSTHI: array [1..NRodovMax] of integer;
  NSTHRODOV: array [1..NRodovMax] of integer;
  Code: array [1..NRodovMax, 1..NSTHMAXIMO] of integer;
  QImed, H1REV, HrecExist, Idade, Nano, CustoFaixa: array [1..NFaixasMax] of Single;
  PSIat, Aream2: array [1..NSthRedeMax, 1..NFaixasMax] of Single;
  EXECF, IPRIOR : array [1..NSthRedeMax, 1..NFaixasMax] of integer;
  RestrAnual, PSImed, VRmed, PPrest: array [1..NPeriodosMax] of Single;
  RestrPolo, CustoPolo: array [1..NPolos, 1..NPeriodosMax] of Single;
  AreaAcost, PSImedSTH: array [1..NSthRedeMax] of Single;
  VSMIN: array [1..NPPMAX] of Single;
  CUSTOT, Deficit, NPSI: array [1..NPeriodosMax] of Single;
  PSIt: array [1..NPSITMAX] of Single;
  ANOBASE, NPeriodos, NRODOV, NMODELOS, NSTH, NSTHMAX: integer;
  PROGRAMA, DADOS, CALC, MatCP, CRest, CamadaRest: string;
  PTRAF, PPSI, HRCP, Arest, PSRrest, A0rest, PSR0rest, FCnovo, FCrecap,
    FCccp, IDScrit, PSRcrit, Idadec, Idaderec, HRmin, HRMAX, PSIf, DEGRAUadm,
    PSIref, VUMin, QI0adm: Single;

implementation

procedure Inicializa;
var
  ArqDados: TextFile;
  Arquivo, DadosAnoBase: string;
  PTRAF, PPSI, Nconf, PSIref, QIref, IGGref, ATRref, TRref: Single;
  i, j: integer;
begin
  { Subdiretorios onde se encontram o programa SGP e a base de dados }
    AssignFile(ArqDados, 'Diretor.dat');
    Reset(ArqDados);
    Readln(ArqDados, ANOBASE);
    Readln(ArqDados, NPeriodos);
    Readln(ArqDados, PROGRAMA);
    Readln(ArqDados, DADOS);
    Readln(ArqDados, CALC);
    Readln(ArqDados, DadosAnoBase);
    CloseFile(ArqDados);
  { Codigos de identificacao das rodovias que compoem a rede }
    Arquivo := DadosAnoBase + 'RODOVIAS.DAT';
    AssignFile(ArqDados, Arquivo);
    Reset(ArqDados);
    Readln(ArqDados, NRODOV);
    for i := 1 to NRODOV do
      Readln(ArqDados, Rodov[i]);
    CloseFile(ArqDados);
  { Numero de Subtrechos Homogeneos por rodovia }
    Arquivo := CALC + 'NSTHROD.OUT';
    AssignFile(ArqDados, Arquivo);
    Reset(ArqDados);
    Readln(ArqDados, NSTHMAX);
    for i := 1 to NRODOV do
      Readln(ArqDados, NSTHRODOV[i]);
    CloseFile(ArqDados);
  { Leitura dos codigos numericos que identificam os Subtrechos Homogeneos }
    for i := 1 to NRODOV do
      begin
        Arquivo := CALC + 'CODE' + Rodov[i] + '.STH';
        AssignFile(ArqDados, Arquivo);
        Readln(ArqDados, NSTHI[i]);
        for j := 1 to NSTHI[i] do
          Readln(ArqDados, Code[i,j]);
        CloseFile(ArqDados);
      end;
  { Criterio para Priorizacao das Restauracoes sob Restricoes Orcamentarias }
    Arquivo := CALC + 'PRIOR.DAT';
    AssignFile(ArqDados, Arquivo);
    Reset(ArqDados);
    Readln(ArqDados, PTRAF);
    Readln(ArqDados, PPSI);
    CloseFile(ArqDados);
  { Modelos de previsao de desempenho para conserva pesada }
    Arquivo := CALC + 'CP.DAT';
    AssignFile(ArqDados, Arquivo);
    Reset(ArqDados);
    Readln(ArqDados, MatCP);
    Readln(ArqDados, HRCP);
    CloseFile(ArqDados);
    Arquivo := PROGRAMA + 'MODELOS.DAT';
    AssignFile(ArqDados, Arquivo);
    Reset(ArqDados);
    Readln(ArqDados, NMODELOS);
    for i := 1 to NMODELOS do
      begin
        Readln(ArqDados, CRest);
        Readln(ArqDados, Arest);
        Readln(ArqDados, PSRrest);
        if CRest = MatCP then
          begin
            CamadaRest := CRest;
            A0rest := Arest;
            PSR0rest := PSRrest;
          end;
      end;
    CloseFile(ArqDados);
  { Fatores de calibracao medios da rede }
    Arquivo := CALC + 'CALIB.DAT';
    AssignFile(ArqDados, Arquivo);
    Reset(ArqDados);
    Readln(ArqDados, FCnovo);
    Readln(ArqDados, FCrecap);
    Readln(ArqDados, FCccp);
    CloseFile(ArqDados);
  { Parametros que definem as Arvores de Decisao }
    Arquivo := CALC + 'ARVORES.DAT';
    AssignFile(ArqDados, Arquivo);
    Reset(ArqDados);
    Readln(ArqDados, IDScrit);
    Readln(ArqDados, PSRcrit);
    Readln(ArqDados, Idadec);
    Readln(ArqDados, Idaderec);
    Readln(ArqDados, HRmin);
    Readln(ArqDados, HRMAX);
    Readln(ArqDados, PSIf);
    Readln(ArqDados, DEGRAUadm);
    Readln(ArqDados, VUMin);
    Readln(ArqDados, QI0adm);
    CloseFile(ArqDados);
  { Parametros para medir o desempenho das estrategias (Ocorrencias em %) }
  Arquivo := Calc + 'Param.dat';
  AssignFile(ArqDados, Arquivo);
  Reset(ArqDados);
  Readln(ArqDados, PSIref);
  Readln(ArqDados, PTRAF);
  Readln(ArqDados, PPSI);
  Readln(ArqDados, Nconf);
  Readln(ArqDados, QIref);
  Readln(ArqDados, IGGref);
  Readln(ArqDados, ATRref);
  Readln(ArqDados, TRref);
  CloseFile(ArqDados);
  { Numero total de Subtrechos Homogeneos da rede }
    NSTH := 0;
    for i := 1 to NRODOV do
      NSTH := NSTH + NSTHRODOV[i];
end;

procedure Estrategias;
var
  ArqDados: TextFile;
  Arquivo: string;
  i, j: integer;
begin

{
  Arquivos a serem gerados pela chamada a esta procedure:
   
   ' Arquivo de configuracao do problema a ser analisado:
     ARQUIVO$ = CALC$ + "DADOS.DAT"
     OPEN ARQUIVO$ FOR INPUT AS #1
          INPUT #1, MODO
          INPUT #1, PPmin
          INPUT #1, PPmax
          INPUT #1, NPP
          INPUT #1, inflacao
     CLOSE #1
     PASSO = (PPmax - PPmin) / (NPP - 1)
     VSMIN(1) = PPmin
     FOR IPP = 2 TO NPP
         VSMIN(IPP) = VSMIN(IPP - 1) + PASSO
     NEXT IPP

     ARQUIVO$ = CALC$ + "PSIT.DAT"
     OPEN ARQUIVO$ FOR INPUT AS #12
     INPUT #12, PSITMIN
     INPUT #12, PSITMAX
     INPUT #12, NPSIT
     CLOSE #12
     PASSO = (PSITMAX - PSITMIN) / (NPSIT - 1)
     PSIt(1) = PSITMIN
     FOR I = 2 TO NPSIT
         PSIt(I) = PSIt(I - 1) + PASSO
     NEXT I
     
}



end;


   
{
    SELECT CASE MODO
           CASE 0
                      MODOANALISE$ = "EVOLUI"
                      VSMIN(1) = PP
                      ARQ$ = "EVO"
           CASE 5
                      MODOANALISE$ = "NECESSIDADES"
                      VSMIN(1) = PP
                      NPeriodos = 1
                      ARQ$ = "NAT"
           CASE 1
                      MODOANALISE$ = "EstratBase"
                      RedeRestric$ = "Para toda a rede"
                      FOR I = 1 TO NPeriodos
                          RestrAnual(I) = 1E+30
                      NEXT I
                      VSMIN(1) = PP
                      ARQ$ = "EB"
           CASE 2
                      MODOANALISE$ = "EstratRO"
                      ARQUIVO$ = CALC$ + "RESTRIC.DAT"
                      OPEN ARQUIVO$ FOR INPUT AS #8
                           INPUT #8, RedeRestric$
                           FOR I = 1 TO NPeriodos
                               INPUT #8, RestrAnual(I)
                           NEXT I
                           FOR IPolo = 1 TO NPolos
                               INPUT #8, PoloRestr$
                               FOR I = 1 TO NPeriodos
                                   INPUT #8, RestrPolo(IPolo, I)
                               NEXT I
                           NEXT IPolo
                      CLOSE #8
                      ARQUIVO$ = CALC$ + "PP.DAT"
                      OPEN ARQUIVO$ FOR INPUT AS #8
                           FOR I = 1 TO NPeriodos
                               INPUT #8, PPrest(I)
                           NEXT I
                      CLOSE #8
                      ARQ$ = "RO"
           CASE 4
                      MODOANALISE$ = "OTIMIZA"
                      RedeRestric$ = "Para toda a rede"
                      FOR I = 1 TO NPeriodos
                          RestrAnual(I) = 1E+30
                      NEXT I
            CASE 6
                      MODOANALISE$ = "MOMRESTIDEAL"
                      RedeRestric$ = "Para toda a rede"
                      FOR I = 1 TO NPeriodos
                          RestrAnual(I) = 1E+30
                      NEXT I
                      VSMIN(1) = PP     
            CASE 3          
                      ARQUIVO$ = CALC$ + "RESTRIC.DAT"
                      OPEN ARQUIVO$ FOR INPUT AS #8
                           INPUT #8, RedeRestric$
                           FOR I = 1 TO NPeriodos
                               INPUT #8, RestrAnual(I)
                           NEXT I
                           FOR IPolo = 1 TO NPolos
                               INPUT #8, PoloRestr$
                               FOR I = 1 TO NPeriodos
                                   INPUT #8, RestrPolo(IPolo, I)
                               NEXT I
                           NEXT IPolo
                      CLOSE #8
                      VSMIN(1) = PP
                      ARQUIVO$ = CALC$ + "Conseq.dat"
                      OPEN ARQUIVO$ FOR INPUT AS #8
                           INPUT #8, ICONSEQ
                      CLOSE #8
                      ARQ$ = ""
           CASE ELSE
                      PRINT "ERRO": STOP
    END SELECT

}

end.
 
