unit Unit63;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls, Dialogs;

type
  TOKBottomDlg = class(TForm)
    Bevel1: TBevel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    Label1: TLabel;
    Edit1: TEdit;
    Label2: TLabel;
    procedure GeraBasedeDadosdoPrximoAno1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  OKBottomDlg: TOKBottomDlg;

implementation

uses Childwin;

{$R *.DFM}

procedure TOKBottomDlg.GeraBasedeDadosdoPrximoAno1Click(Sender: TObject);
begin
  MDIChild.GeraBasedeDadosdoPrximoAno1Click(Sender);
end;

procedure TOKBottomDlg.BitBtn2Click(Sender: TObject);
begin
  Close;
end;

procedure TOKBottomDlg.BitBtn1Click(Sender: TObject);
var
  Ano, NPeriodos, i, j, k, NRodov, NTipos, Ano2, Code, isth, NSTH, NDados: integer;
  ArqDados, Arq, Arq2: TextFile;
  Programa, Dados, Calc, Arquivo, Path, Dest, ArqCsv, DadosAnoBase, Linha,
    DefLVC: string;
  Rodovia: array [1..350] of string[4];
  Codigo: array [1..8] of string[5];
  Year1, Year2: string[4];
  source, destination: file;
  buffer: array [1..1024] of byte;
  readcnt, writecnt: integer;
  scrname, destname: string;
  Faixa: string[1];
  TipoDado: array [1..20] of string[4];
  NumSec, Flag: SmallInt;
  StartTime: TDateTime;
  AnosHist: array [1..100] of integer;
begin
  Screen.Cursor := crHourglass;
  Year2 := Edit1.Text;
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Year1 := IntToStr(Ano);
  Val(Edit1.Text, Ano2, Code);
  Path := Calc + 'Ano ' + Year1 + '\';
  AssignFile(ArqDados, Path + 'DefLVC.dat');
  Reset(ArqDados);
  Readln(ArqDados, DefLVC);
  CloseFile(ArqDados);
  if Ano2 <= Ano then
      Label2.Caption := 'Erro: novo ano-base no  maior que o atual!'
  else
    begin
      Arquivo := Dados + 'AnosHist.dat';
      AssignFile(ArqDados, Arquivo);
      Reset(ArqDados);
      i := 0;
      while not Eof(ArqDados) do
        begin
          i := i + 1;
          Readln(ArqDados, AnosHist[i]);
        end;
      CloseFile(ArqDados);
      if AnosHist[i] < Ano2 then
        begin
          i := i + 1;
          AnosHist[i] := Ano2;;
          Arquivo := Dados + 'AnosHist.dat';
          AssignFile(ArqDados, Arquivo);
          Rewrite(ArqDados);
          for j := 1 to i do
            Writeln(ArqDados, AnosHist[j]);
          CloseFile(ArqDados);
        end;
      { Cdigos de identificao das rodovias que compem a rede }
        Arquivo := DadosAnoBase + 'Rodovias.dat';
        AssignFile(ArqDados, Arquivo);
        Reset(ArqDados);
        Readln(ArqDados, NRodov);
        for i := 1 to NRodov do
          Readln(ArqDados, Rodovia[i]);
        CloseFile(ArqDados);
      { Cdigos dos tipos de defeitos da base de dados }
        Arquivo := Dados + 'TipoDado.dat';
        AssignFile(ArqDados, Arquivo);
        Reset(ArqDados);
        Readln(ArqDados, NTipos);
        NTipos := NTipos - 1;
        for i := 1 to NTipos-1 do
          Readln(ArqDados, Codigo[i]);
        Readln(ArqDados, Linha);
        Readln(ArqDados, Codigo[NTipos]);
        CloseFile(ArqDados);
        NTipos := NTipos + 1;
        Codigo[NTipos] := 'COST';
  { Cria as pastas onde os dados dos pedgios e as fontes de avaliaes
    sero armazenadas }
    Path := Calc + 'Ano ' + Year2;
    AssignFile(ArqDados, 'PathCalc.dat');
    Rewrite(ArqDados);
    Writeln(ArqDados, Path);
    CloseFile(ArqDados);
    AssignFile(ArqDados, 'PathTraf.bat');
    Rewrite(ArqDados);
    Writeln(ArqDados, 'PathCalc.exe');
    Dest := Dados + Year2;
    Arquivo := Dest + '\Pedagios.csv';
    if not FileExists(Arquivo) then Writeln(ArqDados, 'MD ' + Dest);
    Dest := Dest + '\';
    Path := Dados + Year1 + '\';
    Writeln(ArqDados, 'Copy ' + Path + 'Pedagios.csv ' + Dest + 'Pedagios.csv');
    Writeln(ArqDados, 'Copy ' + Path + 'Rodovias.dat ' + Dest + 'Rodovias.dat');
    Writeln(ArqDados, 'Copy ' + DadosAnoBase + 'Trechos.dat ' + Dest + 'Trechos.dat');
    Writeln(ArqDados, 'Copy ' + DadosAnoBase + 'Trechos.dsc ' + Dest + 'Trechos.dsc');
    Writeln(ArqDados, 'Copy ' + DadosAnoBase + 'Pedagios.dat ' + Dest + 'Pedagios.dat');
    Writeln(ArqDados, 'Copy ' + DadosAnoBase + 'Pedg.dat ' + Dest + 'Pedg.dat');
    Writeln(ArqDados, 'Copy ' + DadosAnoBase + 'TRE.dat ' + Dest + 'TRE.dat');
    if not FileExists(Arquivo) then
      begin
        Writeln(ArqDados, 'MD ' + Dest + 'ATR');
        Writeln(ArqDados, 'MD ' + Dest + 'Deflex');
        Writeln(ArqDados, 'MD ' + Dest + 'QI');
        Writeln(ArqDados, 'MD ' + Dest + 'Modulos');
        Writeln(ArqDados, 'MD ' + Dest + 'Unifilar');
      end;
    Writeln(ArqDados, 'MD ' + Dest + 'Xls');
    Writeln(ArqDados, 'MD ' + Dest + 'Xls\ATR');
    Writeln(ArqDados, 'MD ' + Dest + 'Xls\QI');
    Writeln(ArqDados, 'MD ' + Dest + 'Csv');
    Writeln(ArqDados, 'MD ' + Dest + 'Csv\ATR');
    Writeln(ArqDados, 'MD ' + Dest + 'Csv\QI');
    Writeln(ArqDados, 'MD ' + Dest + 'Csv\Temp');
    Writeln(ArqDados, 'Fim.exe');
    CloseFile(ArqDados);
    ArqCsv := 'DOS.DAT';
    if FileExists(ArqCsv) then
      begin
        AssignFile(ArqDados, ArqCsv);
        Erase(ArqDados)
      end;
    WinExec('PathTraf.bat /c', SW_HIDE);
    Flag := 0;
    StartTime := now;
    NumSec := 7;
    repeat
      Application.ProcessMessages;
      if FileExists(ArqCsv) then Flag := 1;
    until (Now > StartTime + NumSec * (1/24/60/60)) and (Flag = 1);
    for i := 1 to NRodov do
      begin
        Dest := Dados + Year2 + '\Unifilar\';
        Path := Dados + Year1 + '\Unifilar\';
        scrname := Path + 'Unifilar_' + Rodovia[i] + '.xls';
        destname := Dest + 'Unifilar_' + Rodovia[i] + '.xls';
        AssignFile(source, scrname);
        if FileExists(scrname) then
          begin
            Try
                Reset(source, 1);
            Except
                Exit;
            end;
            AssignFile(destination, destname);
            Try
                Rewrite(destination, 1);
            Except
                Exit;
            end;
            Repeat
                BlockRead(source, buffer, sizeof(buffer), readcnt);
            Try
                BlockWrite(destination, buffer, readcnt, writecnt);
            Except
                Exit;
            end;
            until (readcnt=0) or (writecnt<>readcnt);
              CloseFile(destination);
              CloseFile(source);
          end;
      end;
      { Efetua as cpias dos arquivos de dados }
        for i := 1 to NRodov do
          for j := 1 to NTipos do
            begin
             if j <> 3 then
              begin
                if j < NTipos then Path := Dados else Path := Dados + 'Custos\';
                scrname := Path + Codigo[j] + '_' + Rodovia[i] + '_' + Year1 + '.dbf';
                destname := Path + Codigo[j] + '_' + Rodovia[i] + '_' + Year2 + '.dbf';
                AssignFile(source, scrname);
                if not FileExists(scrname) then ShowMessage('Arquivo no existe: ' + scrname);
                Try
                   Reset(source, 1);
                Except
                   Exit;
                end;
                AssignFile(destination, destname);
                Try
                   Rewrite(destination, 1);
                Except
                   Exit;
                end;
                Repeat
                  BlockRead(source, buffer, sizeof(buffer), readcnt);
                  Try
                     BlockWrite(destination, buffer, readcnt, writecnt);
                  Except
                     Exit;
                  end;
                until (readcnt=0) or (writecnt<>readcnt);
                CloseFile(destination);
                CloseFile(source);
              end;
            end;
        Path := Dados + 'Custos\';
        scrname := Path + 'COST_' + Year1 + '.dbf';
        destname := Path + 'COST_' + Year2 + '.dbf';
        AssignFile(source, scrname);
        Try
             Reset(source, 1);
        Except
             Exit;
        end;
        AssignFile(destination, destname);
        Try
             Rewrite(destination, 1);
        Except
             Exit;
        end;
        Repeat
          BlockRead(source, buffer, sizeof(buffer), readcnt);
        Try
          BlockWrite(destination, buffer, readcnt, writecnt);
        Except
          Exit;
        end;
        until (readcnt=0) or (writecnt<>readcnt);
        CloseFile(destination);
        CloseFile(source);
      for i := 1 to NRodov do
       begin
        Path := Dados + 'Custos\';
        scrname := Path + 'COST_' + Rodovia[i] + '_' + Year1 + '.dbf';
        destname := Path + 'COST_' + Rodovia[i] + '_' + Year2 + '.dbf';
        AssignFile(source, scrname);
        Try
             Reset(source, 1);
        Except
             Exit;
        end;
        AssignFile(destination, destname);
        Try
             Rewrite(destination, 1);
        Except
             Exit;
        end;
        Repeat
          BlockRead(source, buffer, sizeof(buffer), readcnt);
        Try
          BlockWrite(destination, buffer, readcnt, writecnt);
        Except
          Exit;
        end;
        until (readcnt=0) or (writecnt<>readcnt);
        CloseFile(destination);
        CloseFile(source);
       end;
      NDados := 4;
      TipoDado[1] := 'DFX';
      TipoDado[2] := 'MOD';
      TipoDado[3] := 'ESTR';
      if DefLVC = 'Completo' then TipoDado[4] := 'LVC' else TipoDado[4] := 'SUP';
      for k := 1 to NDados do
       begin
        for i := 1 to NRodov do
          for j := 1 to 4 do
            begin
              Faixa := IntToStr(j);
              Path := Dados;
              scrname := Path + TipoDado[k] + '_' + Rodovia[i] + Faixa + '_' + Year1 + '.dbf';
              destname := Path + TipoDado[k] + '_' + Rodovia[i] + Faixa + '_' + Year2 + '.dbf';
              AssignFile(source, scrname);
              if not FileExists(scrname) then ShowMessage('Arquivo no existe: ' + scrname);
              Try
                   Reset(source, 1);
              Except
                   Exit;
              end;
              AssignFile(destination, destname);
              Try
                   Rewrite(destination, 1);
              Except
                   Exit;
              end;
              Repeat
                BlockRead(source, buffer, sizeof(buffer), readcnt);
                Try
                   BlockWrite(destination, buffer, readcnt, writecnt);
                Except
                   Exit;
                end;
              until (readcnt=0) or (writecnt<>readcnt);
              CloseFile(destination);
              CloseFile(source);
            end;
       end;
    end;
    Path := Calc + 'Ano ' + Year2 + '\';
    AssignFile(ArqDados, Path + 'DefLVC.dat');
    Rewrite(ArqDados);
    Writeln(ArqDados, DefLVC);
    CloseFile(ArqDados);
    Screen.Cursor := crDefault;
    Close;
end;

procedure TOKBottomDlg.FormShow(Sender: TObject);
var
  Ano, NPeriodos: integer;
  ArqDados: TextFile;
  Programa, Dados, Calc, Arquivo, DadosAnoBase: string;
begin
  Label2.Caption := '';
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Ano := Ano + 1;
  Edit1.Text := IntToStr(Ano);
end;

procedure TOKBottomDlg.Edit1Change(Sender: TObject);
begin
  Label2.Caption := '';
end;

end.
